/*
Rem
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/mediator/mediator_danglingdelete.sql /st_pcbpel_12.2.1.4.0soabp/5 2020/11/20 09:06:07 shabdull Exp $
Rem
Rem mediator_danglingdelete.sql
Rem
Rem Copyright (c) 2020, Oracle and/or its affiliates. 
Rem
Rem    NAME
Rem      mediator_danglingdelete.sql - <one-line expansion of the name>
Rem
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      MEDIATOR_RESEQUENCER_MESSAGE
*      MEDIATOR_DEFERRED_MESSAGE
*      MEDIATOR_PAYLOAD
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

  -- purge mediator_resequencer_message
  if (purge_partitioned_component = TRUE) or (is_table_partitioned('MEDIATOR_RESEQUENCER_MESSAGE','PARTITION_DATE') = FALSE) then
    v_stmt := 'DELETE from mediator_resequencer_message s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
  end if;
  
  -- purge mediator_correlation
  if (purge_partitioned_component = TRUE) or (is_table_partitioned('MEDIATOR_CORRELATION','PARTITION_DATE') = FALSE) then
    v_stmt := 'DELETE from mediator_correlation s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
  end if;

  -- purge mediator_callback
  if (purge_partitioned_component = TRUE) or (is_table_partitioned('MEDIATOR_CALLBACK','PARTITION_DATE') = FALSE) then
    v_stmt := 'DELETE from mediator_callback s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
  end if;

  -- purge mediator_deferred_message
  if (purge_partitioned_component = TRUE) or (is_table_partitioned('MEDIATOR_DEFERRED_MESSAGE','CREATION_DATE') = FALSE) then
    v_stmt := 'DELETE from mediator_deferred_message s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.CREATION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
  end if;

  if (purge_partitioned_component = TRUE) or (is_table_partitioned('MEDIATOR_PAYLOAD','CREATION_TIME') = FALSE) then
    v_stmt := 'DELETE FROM mediator_payload s ' || 
              'WHERE s.owner_id NOT IN (SELECT mdf.dummy1 from mediator_deferred_message mdf) ' || 
              'AND s.owner_id NOT IN (SELECT mdr.id from mediator_resequencer_message mdr) ';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
  end if;
END dangling_delete;
