/*
Rem
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/mediator/mediator_deleteComponentInstances.sql /st_pcbpel_12.2.1.4.0soabp/7 2023/01/28 03:34:48 apfwkr Exp $
Rem
Rem mediator_deleteComponentInstances.sql
Rem
Rem Copyright (c) 2010, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      mediator_deleteComponentInstances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Mediator purge
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      01/19/23 - CI# 34996638 of
Rem    apfwkr      01/19/23 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr      01/19/23 - from st_pcbpel_12.2.1.4.0soabp.
Rem    apfwkr      01/19/23 - CI# 34996638
Rem    apfwkr      01/19/23 - apfwkr_ci_backport_33323056_12.2.1.4.0soabp
Rem    apfwkr      01/19/23 - CI# 34996636 of
Rem    apfwkr      01/19/23 - apfwkr_blr_backport_34756955_12.2.1.4.220827soabp
Rem    apfwkr      01/19/23 - CI# 34996636
Rem    apfwkr      01/19/23 - apfwkr_ci_backport_34756955_12.2.1.4.0soabp
Rem    apfwkr      12/14/22 - BLR# 34893200 of
Rem    apfwkr      12/14/22 - jbahadur_blr_backport_34756955_12.2.1.4.0 .
Rem    apfwkr      12/14/22 - BLR# 34893200
Rem    apfwkr      12/14/22 - apfwkr_blr_backport_34756955_12.2.1.4.220827soabp
Rem    apfwkr      12/14/22 - from main
Rem    apfwkr      12/08/22 - BLR# 34874653 of jbahadur_bug-33323056_1221 .
Rem    apfwkr      12/08/22 - BLR# 34874653
Rem    apfwkr      12/08/22 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr      12/08/22 - from main
Rem    apfwkr      05/06/21 - Backport linlxu_bug-32701803_1221_main from main
Rem    apfwkr      11/19/20 - Backport
Rem                           apfwkr_blr_backport_30387707_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      11/06/20 - Backport linlxu_bug-32003379_1221-main from main
Rem    apfwkr      11/06/20 - Backport apfwkr_blr_backport_30387707_12.2.1.4.0
Rem                           from main
Rem    apfwkr      05/12/20 - Backport samathai_bug-29809205_1221 from main
Rem    apfwkr      11/17/19 - Backport linlxu_bug-30507140_12212-main from main
Rem    apfwkr      10/26/20 - Backport linlxu_bug-30387707_12212-main from main
Rem    jbahadur    12/13/22 - Backport jbahadur_bug-34756955_1221 from main
Rem    apjain      07/13/11 - XbranchMerge apjain_bug-12749521_main from main
Rem    sanjain     04/27/10 - Created
Rem
*/

PROCEDURE truncate_temp_tables
AS
BEGIN

  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_mediator_deferred';
  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_mediator_resequencer';
  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_mediator_group';
  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_flowid_purge_glb';


END truncate_temp_tables;


PROCEDURE purge_mediator_tables
          (purge_partitioned_component in boolean default false,
           write_file in utl_file.file_type default null)
AS
BEGIN

  -- purge MEDIATOR_CORRELATION 
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_CORRELATION','PARTITION_DATE') = FALSE then
    DELETE from MEDIATOR_CORRELATION a where a.flow_id IN (select b.flow_id from temp_flowid_purge_glb b);
    COMMIT;
    debug_purge_both('MEDIATOR_CORRELATION','Deleted =',write_file);
  end if;

  -- purge MEDIATOR_CALLBACK 
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_CALLBACK','PARTITION_DATE') = FALSE then
    DELETE from MEDIATOR_CALLBACK a where a.flow_id IN (select b.flow_id from temp_flowid_purge_glb b);
    COMMIT;
    debug_purge_both('MEDIATOR_CALLBACK','Deleted =',write_file);
  end if;

  -- purge mediator_payload
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_PAYLOAD','CREATION_TIME') = FALSE then
    DELETE FROM mediator_payload a WHERE a.owner_id in (SELECT b.dummy1 FROM temp_mediator_deferred b);
    COMMIT;
    debug_purge_both('mediator_payload for def','Deleted =',write_file);
    DELETE FROM mediator_payload a WHERE a.owner_id in (SELECT b.id FROM temp_mediator_resequencer b);
    COMMIT;
    debug_purge_both('mediator_payload for reseq','Deleted =',write_file);
    DELETE FROM mediator_payload mp WHERE NOT EXISTS (SELECT 1 FROM mediator_deferred_message mdm WHERE mdm.dummy1 = mp.owner_id) AND NOT EXISTS (SELECT 1 FROM mediator_resequencer_message mrm WHERE mrm.ID = mp.owner_id);
    COMMIT;
    debug_purge_both('dangling mediator_payload for reseq and def','Deleted =',write_file);
  end if;

  -- purge mediator_resequencer_message
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_RESEQUENCER_MESSAGE','PARTITION_DATE') = FALSE then
  DELETE from mediator_resequencer_message a where a.id in (select b.id from temp_mediator_resequencer b);
    COMMIT;
    debug_purge_both('mediator_resequencer_message','Deleted =',write_file);
  end if;
  
  -- purge mediator_deferred_message
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_DEFERRED_MESSAGE','CREATION_DATE') = FALSE then
  DELETE from mediator_deferred_message a where a.msg_id in (select b.msg_id from temp_mediator_deferred b);
    COMMIT;
    debug_purge_both('mediator_deferred_message','Deleted =',write_file);
  end if;

  -- purge mediator_group_status
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_GROUP_STATUS','PARTITION_DATE') = FALSE then
  DELETE from mediator_group_status a where a.id in (select b.id from temp_mediator_group b);
    COMMIT;
    debug_purge_both('mediator_group_status','Deleted =',write_file);
  end if;


END purge_mediator_tables;


PROCEDURE deleteComponentInstances(p_id_table   IN VARCHAR2, 
                     purge_partitioned_component in boolean default false,
                     max_count in integer,
                     min_creation_date in timestamp,
                     max_creation_date in timestamp,
                     retention_period in timestamp,
                     write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
  v_bound_predicates VARCHAR2(500);
BEGIN

  truncate_temp_tables();

v_stmt := 'INSERT into temp_flowid_purge_glb(flow_id) ' || 'SELECT flow_id from '|| p_id_table;
  EXECUTE immediate v_stmt;
  debug_purge_both('temp_flowid_purge_glb', 'Inserted =',write_file);

v_stmt := 'INSERT into temp_mediator_deferred(msg_id,flow_id,dummy1) ' || 
          'SELECT mdf.msg_id,mdf.flow_id,mdf.dummy1 ' ||
          'from mediator_deferred_message mdf, '
          || p_id_table || ' comp WHERE comp.flow_id = mdf.flow_id';
  EXECUTE immediate v_stmt;
  debug_purge_both('temp_mediator_deferred', 'Inserted = ',write_file);

v_stmt := 'INSERT into temp_mediator_resequencer(id,flow_id) ' ||
          'SELECT mdr.id,mdr.flow_id ' ||
          'from mediator_resequencer_message mdr, '
          || p_id_table || ' comp WHERE comp.flow_id = mdr.flow_id';
  EXECUTE immediate v_stmt;
  debug_purge_both('temp_mediator_resequencer', 'Inserted =',write_file);
  commit;


/*

The GROUP table is not purged in relation to closed SOA flows. Within
mediator it pretty much stands alone with a not exists relationship
to mediator_resequencer_message table.

To reduce the complexity of the purge and improve performance, the
temp table will be populate in two steps:

1. The initial list of candidate groups will be selected on their relation
to the service table and BOUND by date predicates (min/max/retention).
If not specified then max_count will act as upper bound.

2. ROWNUM is added to result set to aid parallel deletion.

2. The removal of groups that are still in the resequencer table.

*/

v_stmt := 'INSERT into temp_mediator_group(id,row_num) ' ||
          'SELECT mdg.id,rownum ' ||
          'from mediator_group_status mdg, mediator_service_detail mds ' ||
          'where mdg.component_dn = mds.component_dn '||
          'and mdg.level_detail2 = mds.level_detail2 ' ||
          'and mdg.operation = mds.operation ' ||
          'and mdg.status=0 ' ||
          'and (mdg.resequencer_type != ''Standard'' ' ||
               ' or mds.component_status = 1) ';

-- Add date predicated to BOUND the selection of groups.
v_bound_predicates := null;
if min_creation_date is not null then
   v_bound_predicates := ' and partition_date > ' 
                        || '''' || min_creation_date || '''';
end if;
if max_creation_date is not null then
   v_bound_predicates := v_bound_predicates
                        || ' and partition_date < ' 
                        || '''' || max_creation_date || '''';
end if;
if retention_period is not null then
   v_bound_predicates := v_bound_predicates 
                        || ' and (last_received_time < ' 
                        || '''' || retention_period || ''''
                        || ' or (mdg.PARTITION_DATE < ''' || retention_period || ''' AND mdg.RESEQUENCER_TYPE = ''BestEffort'' AND mdg.LOCK_TIME_1 IS NOT NULL))';
end if;
v_bound_predicates := v_bound_predicates
                     || ' and rownum <= ' || max_count;

v_stmt := v_stmt || v_bound_predicates;
   EXECUTE immediate v_stmt;
   debug_purge_both('temp_mediator_group', 'Inserted =',write_file);
   commit;

/*
 Remove any groups that are still referenced in the resequencer table.
 This does not include the resequencer rows removed in this purge run
 as there is always a chance they might not be removed.
*/
v_stmt := 'DELETE from temp_mediator_group mdg ' ||
          'WHERE exists ' ||
          '(SELECT 1 from mediator_resequencer_message mdr ' ||
          'where mdg.id = mdr.owner_id)';
   EXECUTE immediate v_stmt;
   debug_purge_both('temp_mediator_group', 'Deleted =',write_file);
   commit;


  purge_mediator_tables(purge_partitioned_component,write_file);

EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END deleteComponentInstances;

FUNCTION abortComponentInstances (lookupcompquery IN VARCHAR2 , batch_size IN INTEGER, cmpst_name IN VARCHAR2,max_runtime IN INTEGER) RETURN INTEGER AS
	v_stmt          VARCHAR2(2000);
    v_totalcount    INTEGER := 0;	
	filter_instances_query VARCHAR2(10000) := 'SELECT mi.ID FROM mediator_instance mi, sca_flow_instance cmpt WHERE mi.flow_id=cmpt.flow_id AND  mi.component_state BETWEEN 4 AND 15 AND ';
BEGIN
 --Mediator flow started
	filter_instances_query := filter_instances_query || lookupcompquery;
	dbms_output.put_line('lookupcompquery' || lookupcompquery); 

       dbms_output.put_line('filter_instances_query' || filter_instances_query); 
	v_stmt := 'update MEDIATOR_CASE_DETAIL set state =1 WHERE  state != 1 AND INSTANCE_ID in('|| filter_instances_query || ')';
    	dbms_output.put_line('filter_instances_query v_stmt' || v_stmt); 

	v_totalcount := batch_update_func(v_stmt, batch_size,max_runtime);
	COMMIT;
	dbms_output.put_line('Number of MEDIATOR_CASE_DETAIL entries marked aborted = ' || v_totalcount);   
	v_stmt := 'update MEDIATOR_INSTANCE set component_state = 1 WHERE component_state BETWEEN 4 AND 15 AND flow_id IN( SELECT cmpt.flow_id FROM sca_flow_instance cmpt WHERE ' || lookupcompquery || ')';
        dbms_output.put_line('MEDIATOR_INSTANCE  v_stmt' || v_stmt); 

	v_totalcount := batch_update_func(v_stmt, batch_size,max_runtime);
	COMMIT;
	dbms_output.put_line('Number of MEDIATOR_INSTANCE entries marked aborted = ' || v_totalcount);

    RETURN v_totalcount;
EXCEPTION
    WHEN OTHERS THEN
        RETURN -1;
END abortComponentInstances;


