/*
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/mediator/mediator_deleteComponentInstancesDOP.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/11/20 17:50:02 apfwkr Exp $
Rem
Rem mediator_deleteComponentInstancesDOP.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      mediator_deleteComponentInstancesDOP.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      11/19/20 - Backport
Rem                           apfwkr_blr_backport_30387707_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      11/06/20 - Backport apfwkr_blr_backport_30387707_12.2.1.4.0
Rem                           from main
Rem    apfwkr      10/26/20 - Backport linlxu_bug-30387707_12212-main from main
Rem    apjain      07/13/11 - XbranchMerge apjain_bug-12749521_main from main
Rem    sanjain     04/27/10 - Created
Rem
*/

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER, 
                       p_batch_size NUMBER default 20000,
                       p_stop_time DATE default NULL,
                       write_file utl_file.file_type default NULL, 
                       purge_partitioned_component in boolean default false)
RETURN BOOLEAN
AS
  v_stmt  VARCHAR2(2000);
  v_deleted boolean:=true;
  v_counter NUMBER := 1;
  f0_flag boolean:=true;
  f00_flag boolean:=true;
  f1_flag boolean:=true;
  f2_flag boolean:=true;
  f3_flag boolean:=true;
  f4_flag boolean:=true;
  f5_flag boolean:=true;
  v_stoptime date :=p_stop_time; 
BEGIN

v_deleted := true;
WHILE  v_deleted  LOOP 

  v_deleted := false;
  log_info('Begin  Mediator purge loop ' || v_counter || ' for thread = ' || p_thread,write_file);

  v_stmt := 'Purge MEDIATOR_CORRELATION' ;
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_CORRELATION','PARTITION_DATE') = FALSE then
    IF f0_flag then
       f0_flag:=false;
         DELETE from MEDIATOR_CORRELATION a where a.flow_id IN 
          (select b.flow_id from temp_flowid_purge_glb b) 
         AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f0_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_CORRELATION',null,write_file);
  COMMIT;
  END IF;

  v_stmt := 'Purge MEDIATOR_CALLBACK' ;
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_CALLBACK','PARTITION_DATE') = FALSE then
    IF f00_flag then
       f00_flag:=false;
         DELETE from MEDIATOR_CALLBACK a where a.flow_id IN 
          (select b.flow_id from temp_flowid_purge_glb b) 
         AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f00_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_CALLBACK',null,write_file);
  COMMIT;
  END IF;

  v_stmt := 'Purge MEDIATOR_PAYLOAD for DEFERRED' ;
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_PAYLOAD','CREATION_TIME') = FALSE then
    IF f1_flag then
       f1_flag:=false;
         DELETE from mediator_payload where owner_id in
          (select dummy1 from temp_mediator_deferred tmd
           where (mod(tmd.flow_id, p_dop)=p_thread))
         AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f1_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_PAYLOAD for DEFERRED',null,write_file);
  COMMIT;
  END IF;

  v_stmt := 'Purge MEDIATOR_PAYLOAD for RESEQUENCER' ;
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_PAYLOAD','CREATION_TIME') = FALSE then
    IF f2_flag then
       f2_flag:=false;
         DELETE from mediator_payload where owner_id in
          (select id from temp_mediator_resequencer tmr
           where (mod(tmr.flow_id, p_dop)=p_thread))
         AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f2_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_PAYLOAD for RESEQUENCER',null,write_file);
  COMMIT;
  END IF;

  v_stmt := 'Purge MEDIATOR_RESEQUENCER_MESSAGE';
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_RESEQUENCER_MESSAGE','PARTITION_DATE') = FALSE then
    IF f3_flag then
       f3_flag:=false;
       DELETE from mediator_resequencer_message a WHERE a.id in
        (select tmr.id from temp_mediator_resequencer tmr
         where (mod(tmr.flow_id, p_dop)=p_thread))
       AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f3_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_RESEQUENCER_MESSAGE',null,write_file);
  COMMIT;
  END IF;

  v_stmt := 'Purge MEDIATOR_DEFERRED_MESSAGE';
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_DEFERRED_MESSAGE','CREATION_DATE') = FALSE then
    IF f4_flag then
       f4_flag:=false;
       DELETE from mediator_deferred_message a WHERE a.msg_id in
        (select tmd.msg_id from temp_mediator_deferred tmd
         where (mod(tmd.flow_id, p_dop)=p_thread))
       AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f4_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_DEFERRED_MESSAGE',null,write_file);
  COMMIT;
  END IF;

  v_stmt := 'Purge MEDIATOR_GROUP_STATUS';
  IF purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_GROUP_STATUS','PARTITION_DATE') = FALSE then
    IF f5_flag then
       f5_flag:=false;
       DELETE from mediator_group_status a WHERE a.id in
        (select tmg.id from temp_mediator_group tmg
         where (mod(tmg.row_num, p_dop)=p_thread))
       AND rownum < p_batch_size;

      IF SQL%FOUND THEN
         v_deleted := true;
         f5_flag:=true;
      END IF;

    END IF;
  debug_purge('MEDIATOR_GROUP_STATUS',null,write_file);
  COMMIT;
  END IF;

  v_counter := v_counter + 1;

  -- exit loop if out of time
  IF (sysdate >= v_stoptime) THEN
     v_deleted := FALSE;
     return FALSE ;
  END IF;

END LOOP;
return TRUE;

EXCEPTION
  when others then
    log_error(v_stmt,write_file);
    raise;
END deleteComponentInstances;
