/*
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/mediator/mediator_pruneOpenFlowIDs.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/11/06 12:05:41 apfwkr Exp $
Rem
Rem mediator_pruneOpenFlowIDs.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      mediator_pruneOpenFlowIDs.sql - Mediator prune open FlowID sql
Rem
Rem    DESCRIPTION
Rem      This scripts prunes the list of FlowIDs which are not purgable w.r.t 
Rem      mediator using the following criteria:
Rem      mediator_instance.component_state between 4 and 15(when the instance is in recovery required state or running)
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sanjain     04/27/10 - Created
Rem
*/

PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

IF p_prune_table is not null then

    -- Open but not migrated if there is no flow_id.
    v_stmt := 'INSERT INTO ' || p_prune_table || ' SELECT DISTINCT comp.FLOW_ID from ' || p_id_table || ' comp ' || 
                        ' WHERE NOT EXISTS (select 1 from ' || p_prune_table || ' tpri where tpri.FLOW_ID = comp.FLOW_ID) ' ||
    					' AND EXISTS (SELECT 1 FROM MEDIATOR_RESEQUENCER_MESSAGE mrm WHERE mrm.FLOW_ID = comp.FLOW_ID AND mrm.STATUS IN (1, 3, 4))';
    EXECUTE immediate v_stmt;
    debug_purge_both(p_prune_table, 'Inserted ',write_file);
    COMMIT;

    v_stmt := 'INSERT INTO ' || p_prune_table || ' SELECT DISTINCT comp.FLOW_ID from ' || p_id_table || ' comp ' || 
                        ' WHERE NOT EXISTS (select 1 from ' || p_prune_table || ' tpri where tpri.FLOW_ID = comp.FLOW_ID) ' || 
                        ' AND EXISTS (SELECT 1 FROM MEDIATOR_DEFERRED_MESSAGE mdm WHERE mdm.FLOW_ID = comp.FLOW_ID AND mdm.STATUS IN (1, 3))';
    EXECUTE immediate v_stmt;
    debug_purge_both(p_prune_table, 'Inserted ',write_file);
    COMMIT;

END IF;


EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END pruneOpenFlowIDs;

