Rem
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/mediator/purge_mediator_oracle.sql /st_pcbpel_12.2.1.4.0soabp/6 2023/01/28 03:34:48 apfwkr Exp $
Rem
Rem purge_mediator_oracle.sql
Rem
Rem Copyright (c) 2010, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_mediator_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Mediator tables
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      01/19/23 - CI# 34996638 of
Rem    apfwkr      01/19/23 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr      01/19/23 - from st_pcbpel_12.2.1.4.0soabp.
Rem    apfwkr      01/19/23 - CI# 34996638
Rem    apfwkr      01/19/23 - apfwkr_ci_backport_33323056_12.2.1.4.0soabp
Rem    apfwkr      12/08/22 - BLR# 34874653 of jbahadur_bug-33323056_1221 .
Rem    apfwkr      12/08/22 - BLR# 34874653
Rem    apfwkr      12/08/22 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr      12/08/22 - from main
Rem    apfwkr      11/04/20 - Backport
Rem                           apfwkr_blr_backport_31572611_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      10/19/20 - Backport apfwkr_blr_backport_31572611_12.2.1.4.0
Rem                           from main
Rem    apfwkr      07/23/20 - Backport
Rem                           apfwkr_blr_backport_31589423_12.2.1.4.200524soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      07/20/20 - Backport apfwkr_blr_backport_31589423_12.2.1.4.0
Rem                           from main
Rem    apfwkr      07/16/20 - Backport linlxu_bug-31589423_apps_1221 from
Rem                           st_pcbpel_12.2.1.0.0
Rem    shabdull    12/17/19 - Backport apfwkr_blr_backport_30374610_12.2.1.1.0
Rem                           from st_pcbpel_12.2.1.1.0
Rem    apfwkr      11/20/19 - Backport linlxu_bug-30374610_12212-main from main
Rem    apfwkr      10/28/19 - Backport linlxu_bug-30374610_12212-main from main
Rem    apfwkr      10/16/20 - Backport apfwkr_blr_backport_31572611_12.2.1.3.0
Rem                           from main
Rem    apfwkr      10/15/20 - Backport
Rem                           shabdull_blr_backport_31572611_12.2.1.2.0 from
Rem                           st_pcbpel_12.2.1.2.0
Rem    shabdull    07/16/20 - Backport linlxu_bug-31572611_12212 from
Rem                           st_pcbpel_12.2.1.2.0
Rem    sanjain     04/25/10 - Created
Rem

--Drop temp table for mediator instances
BEGIN
  IF table_exist('TEMP_MEDIATOR_DEFERRED') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_mediator_deferred';
  END IF;
  IF table_exist('TEMP_MEDIATOR_DEFERRED_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_mediator_deferred_glb';
  END IF;
  IF table_exist('TEMP_MEDIATOR_RESEQUENCER') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_mediator_resequencer';
  END IF;
  IF table_exist('TEMP_MEDIATOR_RESEQUENCER_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_mediator_resequencer_glb';
  END IF;
  IF table_exist('TEMP_MEDIATOR_GROUP') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_mediator_group';
  END IF;

-- Create temporary table
  EXECUTE IMMEDIATE 'CREATE TABLE temp_mediator_deferred
  (
    msg_id VARCHAR2(1000),
    flow_id INTEGER default ''0'',
    dummy1 VARCHAR2(200)
  )';
  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE temp_mediator_deferred_glb
  (
    msg_id VARCHAR2(1000),
    flow_id INTEGER default ''0'',
    dummy1 VARCHAR2(200)
  ) on commit preserve rows';
  EXECUTE IMMEDIATE 'CREATE TABLE temp_mediator_resequencer
  (
    id VARCHAR2(100),
    flow_id INTEGER default ''0''
  )';
  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE temp_mediator_resequencer_glb
  (
    id VARCHAR2(100),
    flow_id INTEGER default ''0''
  ) on commit preserve rows';
  EXECUTE IMMEDIATE 'CREATE TABLE temp_mediator_group
  (
    id VARCHAR2(100),
    row_num integer default ''0''
  )';

END;

/

CREATE OR REPLACE PACKAGE soa_mediator
AS

PROCEDURE deleteComponentInstances ( p_id_table   IN VARCHAR2, 
                     purge_partitioned_component in boolean default false,
                     max_count in integer,
                     min_creation_date in timestamp,
                     max_creation_date in timestamp,
                     retention_period in timestamp,
                     write_file in utl_file.file_type default null);

PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null);
                      
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false);
                      
PROCEDURE createTempTables(p_id_table   IN VARCHAR2,
                           max_count in integer,
                           min_creation_date in timestamp,
                           max_creation_date in timestamp,
                           retention_period in timestamp,
                           write_file in utl_file.file_type default null);

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER, 
                     p_batch_size NUMBER default 20000,
                     p_stop_time DATE default NULL,
                     write_file in utl_file.file_type default null, 
                     purge_partitioned_component in boolean default false) 
RETURN BOOLEAN;

PROCEDURE deleteComponentInstAdhoc;

FUNCTION isComponentPartitioned RETURN boolean;

function getComponentPartitionInfo return char;
FUNCTION abortComponentInstances(lookupcompquery IN VARCHAR2 , batch_size IN INTEGER, cmpst_name IN VARCHAR2,max_runtime IN INTEGER) RETURN INTEGER;

END soa_mediator;
/
--show errors;
CREATE OR REPLACE PACKAGE body soa_mediator
AS
@@mediator_pruneOpenFlowIDs.sql
@@mediator_danglingdelete.sql
@@mediator_deleteComponentInstances.sql
@@mediator_deleteComponentInstancesDOP.sql
@@mediator_deleteComponentInstAdhoc.sql
@@mediator_isComponentPartitioned.sql
@@mediator_createTempTables.sql
END soa_mediator;
/
show errors;

