/*
*
* deleteComponentInstances.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
*
*    NAME
*      deleteComponentInstAdhoc.sql - BPEL purge script 
*
*
*    DESCRIPTION
*      Delete a set of CIKEY based on a set of FLOWIDs.
*
*/

PROCEDURE delete_orabpel_tables_adhoc
AS

BEGIN

    INSERT INTO temp_document_ci_ref_glb (document_id) 
        SELECT document_id
        FROM document_ci_ref d, temp_cube_instance_glb t WHERE d.cikey = t.cikey;
    COMMIT;

    INSERT INTO temp_document_dlv_msg_ref_glb (message_guid,document_id)
        SELECT DISTINCT m.message_guid,ddmr.document_id
               FROM document_dlv_msg_ref ddmr, dlv_message m
               WHERE ddmr.message_guid = m.message_guid
               AND m.flow_id in (SELECT DISTINCT comp.flow_id from temp_flowid_purge_glb comp); 
    COMMIT;

    DELETE FROM HEADERS_PROPERTIES WHERE message_guid IN (SELECT message_guid FROM temp_document_dlv_msg_ref_glb) ;
    COMMIT;

    DELETE FROM AG_INSTANCE WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT;

    DELETE FROM TEST_DETAILS WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT;
    
    DELETE FROM CUBE_SCOPE WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT;

    DELETE FROM CI_INDEXES WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT;

    DELETE FROM WORK_ITEM WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM WI_FAULT WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM  XML_DOCUMENT d WHERE document_id in
              ( SELECT t1.document_id FROM  temp_document_dlv_msg_ref_glb t1
                union  
                SELECT t2.document_id FROM temp_document_ci_ref_glb t2
              );
    COMMIT ;
    
    DELETE FROM DOCUMENT_DLV_MSG_REF  WHERE document_id in (SELECT document_id FROM temp_document_dlv_msg_ref_glb t);
    COMMIT ;

    DELETE FROM DOCUMENT_CI_REF WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM DLV_MESSAGE  where message_guid in ( SELECT message_guid from temp_document_dlv_msg_ref_glb);
    COMMIT ;

    DELETE FROM DLV_SUBSCRIPTION s WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM DLV_AGGREGATION WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM VARIABLE_SENSOR_VALUES WHERE PROCESS_INSTANCE_ID in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM FAULT_SENSOR_VALUES WHERE PROCESS_INSTANCE_ID in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM ACTIVITY_SENSOR_VALUES WHERE PROCESS_INSTANCE_ID in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

    DELETE FROM cube_instance ci WHERE cikey in (SELECT tpic.cikey FROM temp_cube_instance_glb tpic);
    COMMIT ;

END delete_orabpel_tables_adhoc;


PROCEDURE deleteComponentInstAdhoc
AS
    v_count NUMBER default 0;

BEGIN
    
-- Should not be necessary as removed for each database session.
    EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_cube_instance_glb';
    EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_document_ci_ref_glb';
    EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_document_dlv_msg_ref_glb';
    
    INSERT INTO temp_cube_instance_glb
        SELECT DISTINCT cikey, ci.flow_id FROM cube_instance ci,
              temp_flowid_purge_glb comp WHERE ci.flow_id = comp.flow_id;
    
    v_count := SQL%ROWCOUNT;
    COMMIT;

    IF v_count > 0 then
       delete_orabpel_tables_adhoc;
    END  IF;


    exception
      when others then
        rollback;
        raise;

END deleteComponentInstAdhoc;

