/*
*
*
* orabpel_pruneOpenFlowIDs.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
*
*    NAME
*      orabpel_pruneOpenFlowIDs.sql - BPEL purge prune script 
*
*
*    DESCRIPTION
*     This script is used to prune a list of composite instance ids passed in 
*     an idTable. BPEL uses following criteria to identify a non-purgeable instance :
*     - ci state is <5 (instance is still open)
*
*     Parameters:
*     p_id_table : this is the temp table with purge able composite instance ids
*     p_prune_table : Add to this table the open instances
*
*/
PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

IF p_prune_table is not null then

    v_stmt := 'INSERT INTO ' || p_prune_table 
            || ' SELECT DISTINCT comp.FLOW_ID from CUBE_INSTANCE ci, ' 
            || p_id_table 
            || ' comp WHERE NOT EXISTS (select 1 from ' || p_prune_table || ' tpri where tpri.FLOW_ID = comp.FLOW_ID) '
			|| ' AND comp.FLOW_ID = ci.FLOW_ID AND ci.STATE < 5 ';

    EXECUTE immediate v_stmt;
    debug_purge_both(p_prune_table, 'Inserted (bpel) for open ci ',write_file);


    --Recoverable invoke messages cannot be purged.These are in state 0 or 1
    v_stmt := 'INSERT INTO ' || p_prune_table 
           || ' SELECT DISTINCT dlv.FLOW_ID from DLV_MESSAGE dlv, ' 
           || p_id_table 
           || ' comp WHERE NOT EXISTS (select 1 from ' || p_prune_table || ' tpri where tpri.FLOW_ID = comp.FLOW_ID) '
		   || ' AND comp.FLOW_ID = dlv.FLOW_ID AND dlv.DLV_TYPE=1 AND dlv.STATE in (0,1,4)' ;
    EXECUTE immediate v_stmt;
    debug_purge_both(p_prune_table, 'Inserted (bpel) for dlv_message '
            ,write_file);


    COMMIT;
END IF;

EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END pruneOpenFlowIDs;

