Rem
Rem
Rem purge_bpel_oracle.sql
Rem
Rem Copyright (c) 2009, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_bpel_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Purges BPEL related tables.
Rem
Rem
BEGIN
  IF table_exist('TEMP_CUBE_INSTANCE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_cube_instance';
  END IF;
  IF table_exist('TEMP_DOCUMENT_CI_REF') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_document_ci_ref';
  END IF;
  IF table_exist('TEMP_DOCUMENT_DLV_MSG_REF') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_document_dlv_msg_ref';
  END IF;
  IF table_exist('TEMP_XML_DOCUMENT') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_xml_document';
  END IF;
  IF table_exist('TEMP_CUBE_INSTANCE_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_cube_instance_glb';
  END IF;
  IF table_exist('TEMP_DOCUMENT_CI_REF_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_document_ci_ref_glb';
  END IF;
  IF table_exist('TEMP_DOCUMENT_DLV_MSG_REF_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_document_dlv_msg_ref_glb';
  END IF;
  -- Create temporary tables.
  EXECUTE IMMEDIATE 'CREATE TABLE temp_cube_instance  
(    
cikey INTEGER primary key,    
flow_id INTEGER default ''0''
)';
  EXECUTE IMMEDIATE 'CREATE TABLE temp_document_ci_ref  
(    
document_id VARCHAR2(200),    
cikey INTEGER default ''0'',
flow_id INTEGER default ''0''
)';
  EXECUTE IMMEDIATE 'CREATE TABLE temp_document_dlv_msg_ref  
(    
message_guid VARCHAR2( 50 ),
document_id VARCHAR2(200),    
flow_id INTEGER default ''0''
)';
 EXECUTE IMMEDIATE 
  'CREATE INDEX temp_msg_guid on temp_document_dlv_msg_ref(message_guid)';
 EXECUTE IMMEDIATE
  'CREATE INDEX temp_msg_id on temp_document_dlv_msg_ref(document_id)';

 EXECUTE IMMEDIATE 'CREATE TABLE temp_xml_document
(
document_id VARCHAR2(200),
flow_id INTEGER default ''0''
)';

 EXECUTE IMMEDIATE 
   'CREATE INDEX temp_xml_document_id on temp_xml_document(document_id)';

  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE temp_cube_instance_glb 
(    
cikey INTEGER primary key,    
flow_id INTEGER default ''0''
) on commit preserve rows';
  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE temp_document_ci_ref_glb  
(    
document_id VARCHAR2(200),    
cikey INTEGER default ''0'',
flow_id INTEGER default ''0''
) on commit preserve rows';
  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE temp_document_dlv_msg_ref_glb 
(    
message_guid VARCHAR2( 50 ),
document_id VARCHAR2(200),    
flow_id INTEGER default ''0''
) on commit preserve rows';

END;

/
CREATE OR REPLACE PACKAGE soa_orabpel
AS

PROCEDURE deleteComponentInstances ( p_id_table   IN VARCHAR2, 
                      purge_partitioned_component in boolean default false,
                      write_file in utl_file.file_type default null);

PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null);
                      
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false);
                      
PROCEDURE createTempTables(p_id_table   IN VARCHAR2,
                      write_file in utl_file.file_type default null);

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER,
                       p_batch_size NUMBER default 20000,
                       p_stop_time DATE default NULL,
                       write_file in utl_file.file_type default null, 
                       purge_partitioned_component in boolean default false)
RETURN BOOLEAN;

PROCEDURE deleteComponentInstAdhoc;

FUNCTION isComponentPartitioned RETURN boolean;

function getComponentPartitionInfo return char;
FUNCTION abortComponentInstances(min_creation_date IN TIMESTAMP, max_creation_date IN TIMESTAMP, lookupcompquery IN VARCHAR2 , batch_size IN INTEGER, cmpst_name IN VARCHAR2,max_runtime IN INTEGER, update_retention IN BOOLEAN) RETURN INTEGER;



END soa_orabpel;
/
--show errors;
CREATE OR REPLACE
PACKAGE body soa_orabpel
AS
@@orabpel_pruneOpenFlowIDs.sql
@@orabpel_danglingdelete.sql
@@orabpel_deleteComponentInstances.sql
@@orabpel_deleteComponentInstancesDOP.sql
@@orabpel_deleteComponentInstAdhoc.sql
@@orabpel_isComponentPartitioned.sql
END soa_orabpel;
/
show errors;

