/*
Rem
Rem
Rem delete_instances_in_parallel.sql
Rem
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem    delete_instances_in_parallel.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   11/04/20 - Backport
Rem                           apfwkr_blr_backport_31572611_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem       apfwkr   10/19/20 - Backport apfwkr_blr_backport_31572611_12.2.1.4.0
Rem                           from main
Rem       apfwkr   10/16/20 - Backport apfwkr_blr_backport_31572611_12.2.1.3.0
Rem                           from main
Rem       apfwkr   10/15/20 - Backport
Rem                           shabdull_blr_backport_31572611_12.2.1.2.0 from
Rem                           st_pcbpel_12.2.1.2.0
Rem       shabdull 07/16/20 - Backport linlxu_bug-31572611_12212 from
Rem                           st_pcbpel_12.2.1.2.0
Rem       mbousamr 11/15/12 - Modified for SOA 12c purge.
Rem       sanjain  04/29/10 - Enabling Mediator purge
Rem
*/

procedure createTempTables(
                   purge_id_table in varchar2,
                   purge_partitioned_component in boolean,
                   componentPartInfo in  component_partition_info,
                   max_count in integer,
                   min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   retention_period in timestamp,
                   write_file in utl_file.file_type default null
                   ) is
begin

     if purge_partitioned_component = true 
      OR componentPartInfo.bpelPartitioned= 'N' 
      OR componentPartInfo.bpelPartitioned = 'P' then
         soa_orabpel.createTempTables(purge_id_table,write_file);
      end if;

     if purge_partitioned_component = true 
      OR componentPartInfo.mediatorPartitioned='N' 
      OR componentPartInfo.mediatorPartitioned ='P' then
         soa_mediator.createTempTables(purge_id_table,
                          max_count,
                          min_creation_date,
                          max_creation_date,
                          retention_period,
                          write_file);
     end if;

     if purge_partitioned_component = true 
      OR componentPartInfo.workflowPartitioned='N' then
         soa_workflow.createTempTables(purge_id_table,write_file);
     end if;

end createTempTables;

procedure deleteNonParallelComponents(
                   purge_id_table in varchar2,
                   purge_partitioned_component in boolean,
                   componentPartInfo in component_partition_info,
                   write_file in utl_file.file_type default null
                 ) is
begin
-- The partitioning flags are left for possible future need.
-- However this is doubtful as the decision data is not high.
     if purge_partitioned_component = true 
      OR componentPartInfo.decisionPartitioned='N' then
        soa_decision.deleteComponentInstances(purge_id_table,write_file);
    end if;    

end deleteNonParallelComponents;


procedure delete_soa_inst_in_parallel (
                   min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer default 20000,
                   -- max_runtime in integer default 60,
                   stoptime in varchar2 default null,
                   retention_period in timestamp default null,
                   DOP in integer default 4,
                   max_count in integer default 1000000,
                   purge_partitioned_component in boolean default false,
                   composite_name in  varchar2 default null,
                   composite_revision in varchar2 default null,
                   soa_partition_name in varchar2 default null,
                   ignore_state in boolean default false,
                   PQS in integer default 1,
                   sql_trace IN boolean default false,
                   inmemory in boolean default false,
		   compbased in boolean default false
                ) is
                   
    flow_id_sql varchar2(4000);
    v_stmt varchar2(500);
    purge_id_table varchar2(100) := 'temp_flowid_purge';
    -- stoptime varchar2(100) := to_char(sysdate + NVL(max_runtime,24*60)/(24*60),'DD/MON/YYYY:HH24/MI'); 
    v_stoptime date := NULL;
    total_rows integer;
    v_thread number := 0;
    v_jobname VARCHAR2(20);
    v_jobsrunning number;
    v_jobflowsql varchar2(100);
    total_rows_after_pruning integer;
    purge_partitioned_comp_char char;
    prune_running_insts_table varchar2(100) :='temp_prune_running_insts';
    componentPartInfo component_partition_info;
    v_retention_period timestamp;
    composite_dn varchar2(500);
    soa_purge_job_no number;
    sql_trace_char varchar2(1);
    v_batch_size number := batch_size;
    v_max_count number := max_count;
    v_DOP number := DOP;
    -- v_max_runtime number := max_runtime;
    v_PQS number := PQS;
    write_file  utl_file.file_type;

    begin


      write_file := get_file_main;

      -- Check and exit if another purge is currently running.
      check_purge_session(write_file);
      -- Check and exit if the 11g to 12c upgrade is running.
      check_upgrade_session(write_file);
      -- Set ACTION_NAME on SESSION.
      DBMS_APPLICATION_INFO.SET_MODULE(
            MODULE_NAME => 'PARALLELPURGE',
            ACTION_NAME => 'SOAPURGEEXECUTING');

      --check whether any job is running or whether they shut down properly
      log_info_both('checking for jobs running',write_file);
      SELECT count(*) INTO v_jobsrunning FROM job_flow_control;
      log_info_both('jobs running = ' || v_jobsrunning,write_file);
      -- if not, raise an error and let the exception handling take care of it
      IF v_jobsrunning != 0 THEN
        raise_application_error (-20001,'Jobs still running or not shut down properly');
      END IF;

      log_info_both('***************************************',write_file);
      log_info_both('***************************************',write_file);
      log_info_both(' STARTING 12c PARALLEL loop PURGE    **',write_file);
      log_info_both('***************************************',write_file);
      log_info_both('***************************************',write_file);
      log_info_both('min_creation_date => '
         ||TO_CHAR(min_creation_date,'DD/MON/YYYY:HH24/MI'),write_file);
      log_info_both('max_creation_date => '
        ||TO_CHAR(max_creation_date,'DD/MON/YYYY:HH24/MI'),write_file);
      if batch_size < 1 then v_batch_size := 20000; end if;
      log_info_both('batch_size => '||v_batch_size,write_file);
      -- if max_runtime < 1 then 
      --   v_max_runtime := 60; 
      --   stoptime := to_char(sysdate + NVL(v_max_runtime,24*60)/(24*60),'DD/MON/YYYY:HH24/MI');
      -- end if;
      -- log_info('max_runtime => '||v_max_runtime);
      log_info_both('retention_period => '
         ||TO_CHAR(retention_period,'DD/MON/YYYY:HH24/MI'),write_file); 
      log_info_both('composite_name => '||composite_name,write_file);
      log_info_both('composite_revision => '||composite_revision,write_file);
      log_info_both('soa_partition_name => '||soa_partition_name,write_file);
      if DOP < 1 then v_DOP := 4; end if;
      log_info_both('DOP => '||v_DOP,write_file);
      if max_count < 1 then v_max_count := 1000000; end if;
      log_info_both('max_count => '||v_max_count,write_file);
      v_stoptime := to_date(stoptime,'DD/MON/YYYY:HH24/MI');
      log_info_both
        ('stoptime = ' ||TO_CHAR(v_stoptime,'DD/MON/YYYY:HH24/MI'),write_file);
      if inmemory then
         log_info_both('inmemory => TRUE ',write_file);
      else 
         log_info_both('inmemory => FALSE ',write_file);
      end if;
      if compbased then
         log_info_both('compbased is true, flows will be purged based on component states ');
      end if;

      if purge_partitioned_component = true then
        purge_partitioned_comp_char := 'Y';
      else
        purge_partitioned_comp_char := 'N';
      end if;

      if sql_trace then
        v_stmt := 'alter session set max_dump_file_size = unlimited';
        log_info_both(v_stmt,write_file);
        execute immediate v_stmt;
        v_stmt := 'alter session set events '
        || '''10046 trace name context forever, level 12''';
        log_info_both(v_stmt,write_file);
        execute immediate v_stmt;
        sql_trace_char := 'Y';
      end if;

      select soa_purge_seq.nextval into soa_purge_job_no from dual;
      insert into soa_purge_history
        (job_no,start_time,end_time,type,thread,status)
      values
        (soa_purge_job_no,systimestamp,null,'P',0,'R');
      commit;

      execute immediate 'truncate table ' || purge_id_table;
      execute immediate 'truncate table ' || prune_running_insts_table;       
      execute immediate 'truncate table edn_log_messages'; 
      execute immediate 'delete from SOA_PURGE_LOG where LOG_DATE < sysdate - 30';
      composite_dn := make_composite_dn
                   (soa_partition_name, composite_name, composite_revision);

      flow_id_sql := ' select s.flow_id from sca_flow_instance s where ' ;

      if ignore_state = false AND compbased = false then
         flow_id_sql := flow_id_sql
         || ' s.active_component_instances = 0 and ';
      end if;

      if inmemory then
         flow_id_sql :=  flow_id_sql
         || ' s.purgeable = ''Y'' and '
         || ' s.updated_time <= '
         || '''' || retention_period || '''' || ' and ';
      else
         if min_creation_date is not null then 
            flow_id_sql := flow_id_sql 
            || ' s.created_time >= ' 
            || '''' || min_creation_date || '''' || ' and ';
         end if;
         if max_creation_date is not null then
            flow_id_sql := flow_id_sql 
            || ' s.created_time <= ' 
            || '''' || max_creation_date || '''' || ' and ';
         end if;
         if retention_period is not null then
            v_retention_period := retention_period;
            if max_creation_date is not null then
            -- placed for backward compatibility.
               if retention_period < max_creation_date then
                  v_retention_period := max_creation_date;
               end if;
            end if;
            flow_id_sql := flow_id_sql 
            || ' s.updated_time <= ' 
            || '''' || v_retention_period || '''' || ' and ';
         end if;
      end if;

      if composite_dn is not  null then
         flow_id_sql := flow_id_sql
         || ' s.flow_id in (select c.flow_id from sca_flow_to_cpst c, sca_entity e, sca_partition p where c.composite_sca_entity_id = e.id ' || composite_dn || ') and ';
      end if;

      -- rownum is mandatory.
      flow_id_sql := flow_id_sql || ' rownum <= ' || v_max_count;
      flow_id_sql := 'insert into '||purge_id_table || flow_id_sql;
      execute immediate flow_id_sql;
      total_rows := SQL%ROWCOUNT;
      debug_purge_both(purge_id_table,'Inserted = ',write_file);
      commit;
	
      -- if not compbased job and not ignoring state, same as SINGLE purge
      if ignore_state = false AND compbased = false then
      flow_id_sql := 'insert into temp_prune_running_insts '
                  || ' select flow_id from temp_flowid_purge p '
                  || 'where exists '
                  ||  '(select ''1'' '
                  ||  'from sca_flow_assoc a '
                  ||  'where a.correlated_flow_id = p.flow_id '
                  ||  'and exists '
                  ||   '(select ''1'' '
                  ||   'from sca_flow_assoc a1, sca_flow_instance f '
                  ||   'where a1.owner_flow_id = a.owner_flow_id '
                  ||   'and a1.correlated_flow_id = f.flow_id '
                  ||   'and f.active_component_instances > 0))';                  
      execute immediate flow_id_sql;

      delete from temp_flowid_purge
      where flow_id in ( select flow_id from temp_prune_running_insts);

      total_rows := SQL%ROWCOUNT;
      debug_purge_both(purge_id_table,'Correlated flows pruned  = ',write_file);
      commit;

      end if;

      -- do pruning based on component states if compbased job
      if compbased then
         SELECT count(*) INTO total_rows_after_pruning FROM temp_flowid_purge;
         log_info_both('compbased is true, pruneOpenFlowIDs  , total flows before pruning = ' || total_rows_after_pruning);

         pruneOpenFlowIDs (purge_id_table,prune_running_insts_table);

         delete from temp_flowid_purge
               where flow_id in ( select flow_id from temp_prune_running_insts);
	 debug_purge_both(purge_id_table,'Flows pruned  = ',write_file);
	 commit;

      end if;

      SELECT count(*) INTO total_rows_after_pruning FROM temp_flowid_purge;
      log_info_both('total purgeable flows after pruning = ' || total_rows_after_pruning);
 
      log_info_both('creating temp  tables',write_file);
      componentPartInfo := getComponentPartitionInfo();

      createTempTables(purge_id_table,
                       purge_partitioned_component,
                       componentPartInfo,
                       v_max_count,
                       min_creation_date,
                       max_creation_date,
                       retention_period,
                       write_file);
      log_info_both('completed creating temp tables',write_file);

-- purge small volume data components which would not warrant 
-- multi-threaded purge

      log_info_both('purging small volume components',write_file);
      deleteNonParallelComponents(purge_id_table,purge_partitioned_component,componentPartInfo,write_file);
      log_info_both('completed purging small volume components',write_file);

      LOOP
          -- exit loop when DOP jobs have been started
             EXIT WHEN v_DOP=v_thread;
             v_jobname := 'SOA_PURGE_'||v_thread;
             v_jobflowsql := 'insert into job_flow_control  values (' || v_thread||')';
             execute immediate v_jobflowsql;
             commit;
             log_info_both
               ('inserting v_thread into job_flow_control ',write_file);
             log_info_both('spawning thread ' ||v_thread ,write_file);
             execute immediate 'BEGIN ' 
                   || 'dbms_scheduler.create_job (''' 
                   ||v_jobname
                   ||''',''STORED_PROCEDURE'',''soa.delete_insts_in_parallel_job'', 7); '
                   ||'dbms_scheduler.set_job_argument_value (''' 
                   ||v_jobname 
                   ||''',1,to_char('||v_DOP||')); ' 
                   ||'dbms_scheduler.set_job_argument_value (''' 
                   || v_jobname 
                   ||''',2,to_char('||v_thread||')); '
                   ||'dbms_scheduler.set_job_argument_value ('''
                   || v_jobname 
                   ||''',3,to_char('||v_batch_size||')); ' 
                   ||'dbms_scheduler.set_job_argument_value ('''
                   ||v_jobname 
                   ||''',4,'''||stoptime||'''); ' 
                   ||'dbms_scheduler.set_job_argument_value (''' 
                   ||v_jobname 
                   ||''',5,'''||purge_partitioned_comp_char||'''); ' 
                   ||'dbms_scheduler.set_job_argument_value (''' 
                   ||v_jobname 
                   ||''',6,'''||sql_trace_char||'''); ' 
                   ||'dbms_scheduler.set_job_argument_value (''' 
                   ||v_jobname 
                   ||''',7,to_char('||soa_purge_job_no||')); ' 
                   ||'DBMS_SCHEDULER.SET_ATTRIBUTE ('''
                   ||v_jobname
                   ||''', ''logging_level'', DBMS_SCHEDULER.LOGGING_FULL); '
                   ||'dbms_scheduler.enable ('''
                   ||v_jobname||'''); ' 
                   ||' END; ';   
              v_thread := v_thread +1;
      END LOOP;

      /* The deletion of report and statistical tables can be performed 
         in parallel to the main SOA purge threads.
       */
      delete_stat_alert_tables
           (v_stoptime,
            v_max_count,
            v_batch_size,
            retention_period,
            write_file);

      update soa_purge_history set
       end_time = systimestamp,
       status = 'C'
      where job_no = soa_purge_job_no
        and type = 'P';

      log_info_both('thread spawning done',write_file);

    close_file(write_file);
    -- Set ACTION_NAME on SESSION to NULL.
    DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);

  EXCEPTION
   when others then
    close_file(write_file);
    DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);
    log_error_both('ERROR(delete_soa_inst_in_parallel',write_file);
    raise;

 end delete_soa_inst_in_parallel;
