Rem
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/soa/loadcompbasedpurgeprogram.sql /st_pcbpel_12.2.1.4.0soabp/2 2022/05/10 13:50:21 apfwkr Exp $
Rem
Rem loadcompbasedpurgeprogram.sql
Rem
Rem Copyright (c) 2020, 2022, Oracle and/or its affiliates. 
Rem
Rem    NAME
Rem      This will create DB scheduled jobs for component based purge.. 
Rem	 This will have to be executed as SOAINFRA user after reloading the soa_purge_scripts with latest changes.
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: pcbpel/admin/sqlutils12/soa_purge/oracle/soa/loadcompbasedpurgeprogram.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      05/10/22 - Backport
Rem                           linlxu_blr_backport_33944765_12.2.1.4.211221soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    linlxu      03/23/22 - Backport linlxu_bug-33944765_1221_12.2.1.4 from
Rem                           st_pcbpel_12.2.1.4.0soabp
Rem    linlxu      07/07/20 - script to create schedule for UI
Rem    linlxu      07/07/20 - Created
Rem


BEGIN
   dbms_scheduler.drop_schedule(
      schedule_name       => 'delete_instances_auto_sch3'
      ,force              => TRUE);
  EXCEPTION
     WHEN OTHERS THEN
      NULL;  
  END; 

/

BEGIN
   dbms_scheduler.drop_job(
      job_name            => 'DELETE_COMP_BASED_JOB1'
      ,force              => TRUE);
  EXCEPTION
     WHEN OTHERS THEN
      NULL;  
  END; 
/

BEGIN
   dbms_scheduler.drop_job(
      job_name            => 'delete_instances_auto_job1'
      ,force              => TRUE);
  EXCEPTION
     WHEN OTHERS THEN
      NULL;  
  END; 
/

BEGIN
   dbms_scheduler.drop_job(
      job_name            => 'delete_instances_auto_job2'
      ,force              => TRUE);
  EXCEPTION
     WHEN OTHERS THEN
      NULL;  
  END; 
/

BEGIN
   dbms_scheduler.drop_job(
      job_name            => 'delete_inmemory_job1'
      ,force              => TRUE);
  EXCEPTION
     WHEN OTHERS THEN
      NULL;  
  END; 
/

BEGIN
   dbms_scheduler.drop_program(
      program_name       => 'delete_instances_auto_prg'
      ,force              => TRUE);
  EXCEPTION
     WHEN OTHERS THEN
      NULL;  
  END; 
/


-- Create DELETE_INSTANCES_AUTO_PRG and Args

BEGIN
    DBMS_SCHEDULER.create_program(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        program_action => 'SOA.DELETE_INSTANCES_AUTO',
        program_type => 'STORED_PROCEDURE',
        number_of_arguments => 15,
        comments => NULL,
        enabled => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'SOA_PURGE_TYPE',
        argument_position => 1,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'MIN_CREATION_PERIOD_DAYS',
        argument_position => 2,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'MAX_CREATION_PERIOD_DAYS',
        argument_position => 3,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'BATCH_SIZE',
        argument_position => 4,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'MAX_RUNTIME',
        argument_position => 5,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'RETENTION_PERIOD',
        argument_position => 6,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'PURGE_PARTITIONED_COMPONENT',
        argument_position => 7,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'IGNORE_STATE',
        argument_position => 8,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'PQS',
        argument_position => 9,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'DOP',
        argument_position => 10,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'MAX_COUNT',
        argument_position => 11,
        argument_type => 'NUMBER',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'SQL_TRACE',
        argument_position => 12,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'INMEMORY',
        argument_position => 13,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'RETENTION_PERIOD_UNIT',
        argument_position => 14,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.define_program_argument(
        program_name => 'DELETE_INSTANCES_AUTO_PRG',
        argument_name => 'COMPBASED',
        argument_position => 15,
        argument_type => 'VARCHAR2',
        out_argument => FALSE);

    DBMS_SCHEDULER.ENABLE(name=>'DELETE_INSTANCES_AUTO_PRG');    

  END; 
/


-- Create delete_instances_auto_sch3 and Args

BEGIN
   dbms_scheduler.create_schedule (
      schedule_name      => 'delete_instances_auto_sch3'
     ,start_date         => SYSTIMESTAMP
     ,repeat_interval    => 'freq=daily; byhour=0; byminute=0; bysecond=0'
     ,comments           => 'Schedule for Component based SOA purge job');
  END; 
/


-- Create Component based Job and Args

BEGIN
   dbms_scheduler.create_job(
       job_name         => 'delete_comp_based_job1'
      ,program_name     => 'delete_instances_auto_prg'
      ,schedule_name    => 'delete_instances_auto_sch3'
      ,enabled          => FALSE
      ,comments         => 'Component based SOA purge job');

   dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'soa_purge_type',
         argument_value => 'SINGLE');

   dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'min_creation_period_days',
         argument_value => -1);

   dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'max_creation_period_days',
         argument_value => -1);

   dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'batch_size',
         argument_value => 20000);

   dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'max_runtime',
         argument_value => 60);

   dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'retention_period',
         argument_value => 7);

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'purge_partitioned_component',
         argument_value => 'FALSE');

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'ignore_state',
         argument_value => 'FALSE');

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'PQS',
         argument_value => 1);

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'DOP',
         argument_value => 4);

    dbms_scheduler.set_job_argument_value(
       job_name => 'delete_comp_based_job1',
       argument_name => 'max_count',
       argument_value => 1000000);

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'sql_trace',
         argument_value => 'FALSE');

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'inmemory',
         argument_value => 'FALSE');

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'retention_period_unit',
         argument_value => 'D');

    dbms_scheduler.set_job_argument_value(
         job_name => 'delete_comp_based_job1',
         argument_name => 'compbased',
         argument_value => 'TRUE');

  END; 
/

-- Create Component based Job and Args
BEGIN
    DBMS_SCHEDULER.CREATE_JOB (
            job_name => 'DELETE_INSTANCES_AUTO_JOB1',
            program_name => 'DELETE_INSTANCES_AUTO_PRG',
            schedule_name => 'DELETE_INSTANCES_AUTO_SCH1',
            enabled => FALSE,
            auto_drop => TRUE,
            comments => 'First SOA purge job',
            job_style => 'REGULAR');

    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 1, 
             argument_value => 'SINGLE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 2, 
             argument_value => '-1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 3, 
             argument_value => '-1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 4, 
             argument_value => '20000');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 5, 
             argument_value => '60');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 6, 
             argument_value => '7');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 7, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 8, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 9, 
             argument_value => '1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 10, 
             argument_value => '4');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 11, 
             argument_value => '1000000');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 12, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 13, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 14, 
             argument_value => 'D');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB1', 
             argument_position => 15, 
             argument_value => 'FALSE');
         
    DBMS_SCHEDULER.SET_ATTRIBUTE( 
             name => 'DELETE_INSTANCES_AUTO_JOB1', 
             attribute => 'logging_level', value => DBMS_SCHEDULER.LOGGING_OFF);
      
    DBMS_SCHEDULER.enable(
             name => 'DELETE_INSTANCES_AUTO_JOB1');
END;
/

BEGIN
    DBMS_SCHEDULER.CREATE_JOB (
            job_name => 'DELETE_INSTANCES_AUTO_JOB2',
            program_name => 'DELETE_INSTANCES_AUTO_PRG',
            schedule_name => 'DELETE_INSTANCES_AUTO_SCH2',
            enabled => FALSE,
            auto_drop => TRUE,
            comments => 'Second (optional) SOA purge job',
            job_style => 'REGULAR');

    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 1, 
             argument_value => 'SINGLE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 2, 
             argument_value => '-1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 3, 
             argument_value => '-1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 4, 
             argument_value => '20000');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 5, 
             argument_value => '60');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 6, 
             argument_value => '7');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 7, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 8, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 9, 
             argument_value => '1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 10, 
             argument_value => '4');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 11, 
             argument_value => '1000000');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 12, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 13, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 14, 
             argument_value => 'D');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INSTANCES_AUTO_JOB2', 
             argument_position => 15, 
             argument_value => 'FALSE');
             
END;
/

BEGIN
    DBMS_SCHEDULER.CREATE_JOB (
            job_name => 'DELETE_INMEMORY_JOB1',
            program_name => 'DELETE_INSTANCES_AUTO_PRG',
            schedule_name => 'DELETE_INMEMORY_SCH1',
            enabled => FALSE,
            auto_drop => TRUE,
            comments => 'In-Memory SOA purge job',
            job_style => 'REGULAR');

    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 1, 
             argument_value => 'SINGLE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 2, 
             argument_value => '-1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 3, 
             argument_value => '-1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 4, 
             argument_value => '20000');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 5, 
             argument_value => '50');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 6, 
             argument_value => '15');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 7, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 8, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 9, 
             argument_value => '1');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 10, 
             argument_value => '4');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 11, 
             argument_value => '1000000');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 12, 
             argument_value => 'FALSE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 13, 
             argument_value => 'TRUE');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 14, 
             argument_value => 'M');
    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE( 
             job_name => 'DELETE_INMEMORY_JOB1', 
             argument_position => 15, 
             argument_value => 'FALSE');
         
    DBMS_SCHEDULER.SET_ATTRIBUTE( 
             name => 'DELETE_INMEMORY_JOB1', 
             attribute => 'logging_level', value => DBMS_SCHEDULER.LOGGING_OFF);
      
END;
/
