Rem
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem    "trs_comm_oracle.sql" 
Rem
Rem
Rem    DESCRIPTION
Rem    
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       shabdull 08/31/20 - XbranchMerge
Rem                           shabdull_bug-29325672_1221_pt_moveupgscriptstoade
Rem                           from st_pcbpel_pt-fa12-generic
Rem       shabdull 09/20/19 - removing 11g trs dependency
Rem       mbousamr
Rem

BEGIN

  IF table_exist('TRS_PARAMETER') THEN
    EXECUTE IMMEDIATE 'DROP TABLE TRS_PARAMETER';
  END IF;

  EXECUTE IMMEDIATE 
  'CREATE TABLE TRS_PARAMETER (table_name varchar2(40))';

commit;

END;
/

create or replace package trs_comm as

    procedure trs_CreatePartitionScripts(trs_handle in utl_file.file_type,
                       trs_handle_log in utl_file.file_type,
                           Part_table in varchar2,
                             Part_key in varchar2,
                       range_interval in varchar2,
                      interval_clause in varchar2,
                            drop_flag in boolean default false,
                            redo_flag in boolean default false,
                                  DOP in number default 0,
                           schemaname in varchar2);

    procedure trs_HandleMaxvalue(trs_handle in utl_file.file_type,
                       trs_handle_log in utl_file.file_type,
                           schemaname in varchar2,
                            tablename in varchar2,
                            part_name in varchar2,
                      interval_clause in varchar2,
                            drop_flag in boolean,
                            redo_flag in boolean,
                                  DOP in number);

    procedure trs_DropMaxvalue(trs_handle in  utl_file.file_type,
                   trs_handle_log in  utl_file.file_type,
                      schema_name in varchar2,
                       table_name in varchar2,
                       table_part in varchar2);

    procedure trs_AlterInterval(trs_handle in  utl_file.file_type,
                   trs_handle_log in  utl_file.file_type,
                      schema_name in varchar2,
                       table_name in varchar2,
                  interval_clause in varchar2);

    procedure trs_DisableEnableConst(trs_handle in  utl_file.file_type,
                   trs_handle_log in  utl_file.file_type,
                      schema_name in varchar2,
                       table_name in varchar2,
                           enable in boolean);

    procedure trs_WriteDirectPathFile (trs_handle in  utl_file.file_type,
                   trs_handle_log in  utl_file.file_type,
                      schema_name in varchar2,
                       table_name in varchar2,
                   table_name_trs in varchar2,
                        drop_flag in boolean,
                        redo_flag in boolean,
	  	         trs_sttt in varchar2);

    procedure trs_WriteAddFKConstFile(trs_handle in  utl_file.file_type,
                  trs_handle_log in  utl_file.file_type,
                     schema_name in varchar2,
                      table_name in varchar2);

    procedure trs_WriteTableFile (trs_handle in  utl_file.file_type,
                   trs_handle_log in  utl_file.file_type,
                      schema_name in varchar2,
                       table_name in varchar2,
                   table_name_trs in varchar2,
                        partition in boolean);

    procedure trs_WriteIndexFile(trs_handle in utl_file.file_type,
	               trs_handle_log in utl_file.file_type,
	                  schema_name in varchar2,
        	           table_name in varchar2,
                            redo_flag in boolean,
         	                  DOP in number);

    procedure trs_WriteConstFile(trs_handle in  utl_file.file_type,
                  trs_handle_log in  utl_file.file_type,
                     schema_name in varchar2,
                      table_name in varchar2);

    procedure trs_CreateTableScripts(trs_handle in utl_file.file_type,
                       trs_handle_log in utl_file.file_type,
                           schemaname in varchar2,
                            tablename in varchar2,
                        tablename_trs in varchar2,
                                  DOP in number,
                            drop_flag in boolean,
                            redo_flag in boolean,
	                     trs_sttt in varchar2);
 
    function chk_trs_table (trs_table_name in varchar2)
                       return boolean;

    function chk_trs_fabric
                       return boolean;

    function chk_trs_bpel 
                      return boolean;

    function chk_trs_med
                      return boolean;

    function chk_trs_hwf 
                      return boolean;

    function chk_trs_dec 
                      return boolean;

end trs_comm;
/
show error;

create or replace package body trs_comm as
@@trs_common.sql
@@trs_create_table_scripts.sql
end trs_comm; 
/
show errors;

