
CREATE OR REPLACE PACKAGE BODY WFTaskpkg_121200 AS
            v_lockException EXCEPTION;
            v_lockErrorNumber NUMBER := -20001;
            PRAGMA EXCEPTION_INIT(v_lockException,-20001);

            v_updateErrorNumber NUMBER := -20002;
            v_insertErrorNumber NUMBER := -20003;

            v_deletedException EXCEPTION ;
            v_deletedErrorNumber NUMBER := -20004;
            PRAGMA EXCEPTION_INIT(v_deletedException,-20004);

            v_modifiedException EXCEPTION ;
            v_modifiedErrorNumber NUMBER := -20005;
            PRAGMA EXCEPTION_INIT(v_modifiedException,-20005);


            v_createHistoryException EXCEPTION;
            v_createHistoryErrorNumber  NUMBER  := -20007;
            PRAGMA EXCEPTION_INIT(v_createHistoryException,-20007);

            FUNCTION insertRoutingSlip(
            p_taskId  VARCHAR2,
            p_taskNumber NUMBER,
            p_compositeCreatedTime TIMESTAMP
            ) RETURN BLOB IS
            v_blob  BLOB;
            v_taskNumber NUMBER;

            BEGIN

            IF p_taskNumber <= 0 THEN
            SELECT /*+ INDEX(WFTask WFTask(taskId)) */ taskNumber
            INTO v_taskNumber
            FROM WFTask
            WHERE taskId = p_taskId;
            ELSE
            v_taskNumber := p_taskNumber ;
            END IF;

            INSERT INTO WFRoutingSlip
            (taskId , taskNumber, routingSlip, noOfTimesModified, compositeCreatedTime )
            VALUES( p_taskId, v_taskNumber , empty_blob(), 1, p_compositeCreatedTime);

            SELECT /*+ INDEX(WFRoutingSlip WFRoutingSlip(taskId)) */ routingSlip INTO v_blob
            FROM WFRoutingSlip WHERE taskId = p_taskId;
            return v_blob;
            EXCEPTION
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,'Error while inserting routing slip',true);

            END  insertRoutingSlip;


            FUNCTION updateRoutingSlip(
            p_taskId  VARCHAR2,
            p_notm NUMBER
            ) RETURN BLOB IS
            v_notm NUMBER;
            v_blob  BLOB;
            BEGIN

            BEGIN
            SELECT /*+ INDEX(WFRoutingSlip WFRoutingSlip(taskId)) */ noOfTimesModified INTO v_notm
            FROM WFRoutingSlip WHERE taskId = p_taskId FOR UPDATE NOWAIT;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            RAISE v_deletedException;
            WHEN OTHERS THEN
            RAISE v_lockException;
            END;

            BEGIN
            IF v_notm != p_notm THEN
            RAISE v_modifiedException;
            END IF;
            END;

            UPDATE /*+ INDEX(WFRoutingSlip WFRoutingSlip(taskId)) */
            WFRoutingSlip
            SET noOfTimesModified = p_notm +1,
            routingSlip = empty_blob()
            WHERE taskId = p_taskId;

            SELECT /*+ INDEX(WFRoutingSlip WFRoutingSlip(taskId)) */ routingSlip INTO v_blob
            FROM WFRoutingSlip WHERE taskId = p_taskId;
            return v_blob;

            EXCEPTION
            WHEN  v_lockException THEN
            RAISE_APPLICATION_ERROR(v_lockErrorNumber,'Task is locked for update',true);
            WHEN v_deletedException THEN
            RAISE_APPLICATION_ERROR(v_deletedErrorNumber,'Task is deleted',true);
            WHEN v_modifiedException THEN
            RAISE_APPLICATION_ERROR(v_modifiedErrorNumber,'Task is modified',true);
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_updateErrorNumber,'Error while updating routing slip',true);
            END updateRoutingSlip;

            /**
            To lock the WFTask table
            */

            PROCEDURE lockWFTask(
            p_taskId VARCHAR,
            p_notm   NUMBER
            ) IS
            v_notm NUMBER;
            BEGIN
            BEGIN
            SELECT /*+ INDEX(WFTask WFTask(taskId)) */ numberOfTimesModified INTO v_notm
            FROM WFTask WHERE taskId = p_taskId FOR UPDATE NOWAIT;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            RAISE v_deletedException;
            WHEN OTHERS THEN
            RAISE v_lockException;
            END;
            IF v_notm != p_notm THEN
            RAISE v_modifiedException;
            END IF;
            END lockWFTask;


            PROCEDURE createHistory(p_taskID VARCHAR2) IS
            BEGIN
            INSERT INTO WFTaskHistory
            ( acquiredBy,
            assignees,
            assigneesDisplayName,
            reviewers,
            reviewersDisplayName,
            callbackContext,
            callbackId,
            callbackType,
            creator,
            digitalSignatureRequired,
            expirationDate,
            expirationDuration,
            identityContext,
            ownerUser,
            ownerGroup,
            ownerRole,
            passwordRequiredOnUpdate,
            priority,
            domainId,
            instanceId,
            processId,
            processName,
            processType,
            processVersion,
            secureNotifications,
            accessKey,
            approvalDuration,
            approvers,
            assignedDate,
            createdDate,
            elapsedTime,
            endDate,
            fromUser,
            fromUserDisplayName,
            hasSubtask,
            inShortHistory,
            isGroup,
            language,
            mailStatus,
            numberOfTimesModified,
            originalAssigneeUser,
            outcome,
            parallelOutcomeCount,
            pushbackSequence,
            State,
            SubState,
            systemString1,
            systemString2,
            SystemString3,
            taskGroupId,
            taskId,
            taskNumber,
            updatedBy,
            updatedByDisplayName,
            updatedDate,
            updatedNotificationId,
            version,
            versionReason,
            workflowPattern,
            textAttribute1,
            textAttribute2,
            textAttribute3,
            textAttribute4,
            textAttribute5,
            textAttribute6,
            textAttribute7,
            textAttribute8,
            textAttribute9,
            textAttribute10,
            textAttribute11,
            textAttribute12,
            textAttribute13,
            textAttribute14,
            textAttribute15,
            textAttribute16,
            textAttribute17,
            textAttribute18,
            textAttribute19,
            textAttribute20,
            formAttribute1,
            formAttribute2,
            formAttribute3,
            formAttribute4,
            formAttribute5,
            formAttribute6,
            formAttribute7,
            formAttribute8,
            formAttribute9,
            formAttribute10,
            urlAttribute1,
            urlAttribute2,
            urlAttribute3,
            urlAttribute4,
            urlAttribute5,
            urlAttribute6,
            urlAttribute7,
            urlAttribute8,
            urlAttribute9,
            urlAttribute10,
            dateAttribute1,
            dateAttribute2,
            dateAttribute3,
            dateAttribute4,
            dateAttribute5,
            dateAttribute6,
            dateAttribute7,
            dateAttribute8,
            dateAttribute9,
            dateAttribute10,
            numberAttribute1,
            numberAttribute2,
            numberAttribute3,
            numberAttribute4,
            numberAttribute5,
            numberAttribute6,
            numberAttribute7,
            numberAttribute8,
            numberAttribute9,
            numberAttribute10,
            protectedTextAttribute1,
            protectedTextAttribute2,
            protectedTextAttribute3,
            protectedTextAttribute4,
            protectedTextAttribute5,
            protectedTextAttribute6,
            protectedTextAttribute7,
            protectedTextAttribute8,
            protectedTextAttribute9,
            protectedTextAttribute10,
            protectedTextAttribute11,
            protectedTextAttribute12,
            protectedTextAttribute13,
            protectedTextAttribute14,
            protectedTextAttribute15,
            protectedTextAttribute16,
            protectedTextAttribute17,
            protectedTextAttribute18,
            protectedTextAttribute19,
            protectedTextAttribute20,
            protectedFormAttribute1,
            protectedFormAttribute2,
            protectedFormAttribute3,
            protectedFormAttribute4,
            protectedFormAttribute5,
            protectedFormAttribute6,
            protectedFormAttribute7,
            protectedFormAttribute8,
            protectedFormAttribute9,
            protectedFormAttribute10,
            protectedUrlAttribute1,
            protectedUrlAttribute2,
            protectedUrlAttribute3,
            protectedUrlAttribute4,
            protectedUrlAttribute5,
            protectedUrlAttribute6,
            protectedUrlAttribute7,
            protectedUrlAttribute8,
            protectedUrlAttribute9,
            protectedUrlAttribute10,
            protectedDateAttribute1,
            protectedDateAttribute2,
            protectedDateAttribute3,
            protectedDateAttribute4,
            protectedDateAttribute5,
            protectedDateAttribute6,
            protectedDateAttribute7,
            protectedDateAttribute8,
            protectedDateAttribute9,
            protectedDateAttribute10,
            protectedNumberAttribute1,
            protectedNumberAttribute2,
            protectedNumberAttribute3,
            protectedNumberAttribute4,
            protectedNumberAttribute5,
            protectedNumberAttribute6,
            protectedNumberAttribute7,
            protectedNumberAttribute8,
            protectedNumberAttribute9,
            protectedNumberAttribute10,
            title,
            titleResourceKey,
            identificationKey,
            userComment,
            workflowDescriptorURI,
            taskDefinitionId,
            taskDefinitionName,
            applicationContext,
            applicationName,
            category,
            componentName,
            compositeDN,
            compositeInstanceId,
            compositeName,
            compositeVersion,
            conversationId,
            dueDate,
            ecId,
            isPublic,
            isTestTask,
            parentComponentInstanceId,
            parentComponentInstRefId,
            invokedComponent,
            participantName,
            percentageComplete,
            readByUsers,
            startDate,
            parentTaskVersion,
            taskGroupInstanceId,
            subTaskGroupInstanceId,
            agRootId,
            agMileStonePath,
            rootTaskId,
            parentTaskId,
            systemStringActions,
            taskDisplayUrl,
            documentPackageId,
            subCategory,
            correlationId,
            stage,
            assignmentContext,
            preActionUserSteps,
            aggregationTaskId,
            mdsLabel,
            isTemplateTask,
            componentType,
            activityName,
            activityId,
            processDueDate,
            thread,
            parentThread,
            step,
            taskNamespace,
            timers,
            vrcValues,
            organizationalUnitId,
            compositeCreatedTime,
            tenantId,
            listBuilderId,
            caseId,
            swimlaneRole,
            excludedParticipants,
            customAttributeString1,
            customAttributeString2,
            customAttributeNumber1,
            customAttributeNumber2,
            customAttributeDate1,
            customAttributeDate2,
            timersSuspended,
            tenant_id,
            isDecomposedTask,
            formName,
            decomposedTaskGrpInstanceId,
            startTime,
            stopTime,
            workingduration,
            shortSummary,
            longSummary,
            COMPONENT_INSTANCE_ID,
            FLOW_ID,
            SCA_PARTITION_ID
            )
            SELECT /*+ INDEX(WFTask WFTask(taskId)) */
            acquiredBy,
            assignees,
            assigneesDisplayName,
            reviewers,
            reviewersDisplayName,
            callbackContext,
            callbackId,
            callbackType,
            creator,
            digitalSignatureRequired,
            expirationDate,
            expirationDuration,
            identityContext,
            ownerUser,
            ownerGroup,
            ownerRole,
            passwordRequiredOnUpdate,
            priority,
            domainId,
            instanceId,
            processId,
            processName,
            processType,
            processVersion,
            secureNotifications,
            accessKey,
            approvalDuration,
            approvers,
            assignedDate,
            createdDate,
            elapsedTime,
            endDate,
            fromUser,
            fromUserDisplayName,
            hasSubtask,
            inShortHistory,
            isGroup,
            language,
            mailStatus,
            numberOfTimesModified,
            originalAssigneeUser,
            outcome,
            parallelOutcomeCount,
            pushbackSequence,
            State,
            SubState,
            systemString1,
            systemString2,
            SystemString3,
            taskGroupId,
            taskId,
            taskNumber,
            updatedBy,
            updatedByDisplayName,
            updatedDate,
            updatedNotificationId,
            version,
            versionReason,
            workflowPattern,
            textAttribute1,
            textAttribute2,
            textAttribute3,
            textAttribute4,
            textAttribute5,
            textAttribute6,
            textAttribute7,
            textAttribute8,
            textAttribute9,
            textAttribute10,
            textAttribute11,
            textAttribute12,
            textAttribute13,
            textAttribute14,
            textAttribute15,
            textAttribute16,
            textAttribute17,
            textAttribute18,
            textAttribute19,
            textAttribute20,
            formAttribute1,
            formAttribute2,
            formAttribute3,
            formAttribute4,
            formAttribute5,
            formAttribute6,
            formAttribute7,
            formAttribute8,
            formAttribute9,
            formAttribute10,
            urlAttribute1,
            urlAttribute2,
            urlAttribute3,
            urlAttribute4,
            urlAttribute5,
            urlAttribute6,
            urlAttribute7,
            urlAttribute8,
            urlAttribute9,
            urlAttribute10,
            dateAttribute1,
            dateAttribute2,
            dateAttribute3,
            dateAttribute4,
            dateAttribute5,
            dateAttribute6,
            dateAttribute7,
            dateAttribute8,
            dateAttribute9,
            dateAttribute10,
            numberAttribute1,
            numberAttribute2,
            numberAttribute3,
            numberAttribute4,
            numberAttribute5,
            numberAttribute6,
            numberAttribute7,
            numberAttribute8,
            numberAttribute9,
            numberAttribute10,
            protectedTextAttribute1,
            protectedTextAttribute2,
            protectedTextAttribute3,
            protectedTextAttribute4,
            protectedTextAttribute5,
            protectedTextAttribute6,
            protectedTextAttribute7,
            protectedTextAttribute8,
            protectedTextAttribute9,
            protectedTextAttribute10,
            protectedTextAttribute11,
            protectedTextAttribute12,
            protectedTextAttribute13,
            protectedTextAttribute14,
            protectedTextAttribute15,
            protectedTextAttribute16,
            protectedTextAttribute17,
            protectedTextAttribute18,
            protectedTextAttribute19,
            protectedTextAttribute20,
            protectedFormAttribute1,
            protectedFormAttribute2,
            protectedFormAttribute3,
            protectedFormAttribute4,
            protectedFormAttribute5,
            protectedFormAttribute6,
            protectedFormAttribute7,
            protectedFormAttribute8,
            protectedFormAttribute9,
            protectedFormAttribute10,
            protectedUrlAttribute1,
            protectedUrlAttribute2,
            protectedUrlAttribute3,
            protectedUrlAttribute4,
            protectedUrlAttribute5,
            protectedUrlAttribute6,
            protectedUrlAttribute7,
            protectedUrlAttribute8,
            protectedUrlAttribute9,
            protectedUrlAttribute10,
            protectedDateAttribute1,
            protectedDateAttribute2,
            protectedDateAttribute3,
            protectedDateAttribute4,
            protectedDateAttribute5,
            protectedDateAttribute6,
            protectedDateAttribute7,
            protectedDateAttribute8,
            protectedDateAttribute9,
            protectedDateAttribute10,
            protectedNumberAttribute1,
            protectedNumberAttribute2,
            protectedNumberAttribute3,
            protectedNumberAttribute4,
            protectedNumberAttribute5,
            protectedNumberAttribute6,
            protectedNumberAttribute7,
            protectedNumberAttribute8,
            protectedNumberAttribute9,
            protectedNumberAttribute10,
            title,
            titleResourceKey,
            identificationKey,
            userComment,
            workflowDescriptorURI,
            taskDefinitionId,
            taskDefinitionName,
            applicationContext,
            applicationName,
            category,
            componentName,
            compositeDN,
            compositeInstanceId,
            compositeName,
            compositeVersion,
            conversationId,
            dueDate,
            ecId,
            isPublic,
            isTestTask,
            parentComponentInstanceId,
            parentComponentInstRefId,
            invokedComponent,
            participantName,
            percentageComplete,
            readByUsers,
            startDate,
            parentTaskVersion,
            taskGroupInstanceId,
            subTaskGroupInstanceId,
            agRootId,
            agMileStonePath,
            rootTaskId,
            parentTaskId,
            systemStringActions,
            taskDisplayUrl,
            documentPackageId,
            subCategory,
            correlationId,
            stage,
            assignmentContext,
            preActionUserSteps,
            aggregationTaskId,
            mdsLabel,
            isTemplateTask,
            componentType,
            activityName,
            activityId,
            processDueDate,
            thread,
            parentThread,
            step,
            taskNamespace,
            timers,
            vrcValues,
            organizationalUnitId,
            compositeCreatedTime,
            tenantId,
            listBuilderId,
            caseId,
            swimlaneRole,
            excludedParticipants,
            customAttributeString1,
            customAttributeString2,
            customAttributeNumber1,
            customAttributeNumber2,
            customAttributeDate1,
            customAttributeDate2,
            timersSuspended,
            tenant_id,
            isDecomposedTask,
            formName,
            decomposedTaskGrpInstanceId,
            startTime,
            stopTime,
            workingduration,
            shortSummary,
            longSummary,
            COMPONENT_INSTANCE_ID,
            FLOW_ID,
            SCA_PARTITION_ID

            FROM WFTask WHERE taskId = p_taskID;
            END;


            PROCEDURE insertTask(
            p_acquiredBy                  VARCHAR2,
            p_assignees                   VARCHAR2,
            p_assigneesDisplayName        VARCHAR2,
            p_reviewers                   VARCHAR2,
            p_reviewersDisplayName        VARCHAR2,
            p_callbackContext             VARCHAR2,
            p_callbackId                  VARCHAR2,
            p_callbackType                VARCHAR2,
            p_creator                     VARCHAR2,
            p_digitalSignatureRequired    VARCHAR2,
            p_expirationDate              DATE,
            p_expirationDuration          VARCHAR2,
            p_identityContext             VARCHAR2,
            p_ownerUser                   VARCHAR2,
            p_ownerGroup                  VARCHAR2,
            p_ownerRole                   VARCHAR2,
            p_passwordRequiredOnUpdate    VARCHAR2,
            p_priority                    NUMBER,
            p_domainId                    VARCHAR2,
            p_instanceId                  VARCHAR2,
            p_processId                   VARCHAR2,
            p_processName                 VARCHAR2,
            p_processType                 VARCHAR2,
            p_processVersion              VARCHAR2,
            p_secureNotifications         VARCHAR2,
            p_accessKey                   VARCHAR2,
            p_approvalDuration            NUMBER,
            p_approvers                   VARCHAR2,
            p_assignedDate                DATE,
            p_createdDate                 DATE,
            p_elapsedTime                 NUMBER,
            p_endDate                     DATE,
            p_fromUser                    VARCHAR2,
            p_fromUserDisplayName         VARCHAR2,
            p_hasSubtask                  VARCHAR2,
            p_inShortHistory              VARCHAR2,
            p_isGroup                     VARCHAR2,
            p_language                    VARCHAR2,
            p_mailStatus                  VARCHAR2,
            p_numberOfTimesModified       NUMBER,
            p_originalAssigneeUser        VARCHAR2,
            p_outcome                     VARCHAR2,
            p_parallelOutcomeCount        VARCHAR2,
            p_pushbackSequence            VARCHAR2,
            p_State                       VARCHAR2,
            p_SubState                    VARCHAR2,
            p_systemString1               VARCHAR2,
            p_systemString2               VARCHAR2,
            p_SystemString3               VARCHAR2,
            p_taskGroupId                 VARCHAR2,
            p_taskId                      VARCHAR2,
            p_taskNumber      IN OUT      NUMBER,
            p_updatedBy                   VARCHAR2,
            p_updatedByDisplayName        VARCHAR2,
            p_updatedDate                 DATE,
            p_updatedNotificationId       VARCHAR2,
            p_version                     NUMBER,
            p_versionReason               VARCHAR2,
            p_workflowPattern             VARCHAR2,
            p_textAttribute1              VARCHAR2,
            p_textAttribute2              VARCHAR2,
            p_textAttribute3              VARCHAR2,
            p_textAttribute4              VARCHAR2,
            p_textAttribute5              VARCHAR2,
            p_textAttribute6              VARCHAR2,
            p_textAttribute7              VARCHAR2,
            p_textAttribute8              VARCHAR2,
            p_textAttribute9              VARCHAR2,
            p_textAttribute10             VARCHAR2,
            p_textAttribute11             VARCHAR2,
            p_textAttribute12             VARCHAR2,
            p_textAttribute13             VARCHAR2,
            p_textAttribute14             VARCHAR2,
            p_textAttribute15             VARCHAR2,
            p_textAttribute16             VARCHAR2,
            p_textAttribute17             VARCHAR2,
            p_textAttribute18             VARCHAR2,
            p_textAttribute19             VARCHAR2,
            p_textAttribute20             VARCHAR2,
            p_formAttribute1              VARCHAR2,
            p_formAttribute2              VARCHAR2,
            p_formAttribute3              VARCHAR2,
            p_formAttribute4              VARCHAR2,
            p_formAttribute5              VARCHAR2,
            p_formAttribute6              VARCHAR2,
            p_formAttribute7              VARCHAR2,
            p_formAttribute8              VARCHAR2,
            p_formAttribute9              VARCHAR2,
            p_formAttribute10             VARCHAR2,
            p_urlAttribute1               VARCHAR2,
            p_urlAttribute2               VARCHAR2,
            p_urlAttribute3               VARCHAR2,
            p_urlAttribute4               VARCHAR2,
            p_urlAttribute5               VARCHAR2,
            p_urlAttribute6               VARCHAR2,
            p_urlAttribute7               VARCHAR2,
            p_urlAttribute8               VARCHAR2,
            p_urlAttribute9               VARCHAR2,
            p_urlAttribute10              VARCHAR2,
            p_dateAttribute1              DATE,
            p_dateAttribute2              DATE,
            p_dateAttribute3              DATE,
            p_dateAttribute4              DATE,
            p_dateAttribute5              DATE,
            p_dateAttribute6              DATE,
            p_dateAttribute7              DATE,
            p_dateAttribute8              DATE,
            p_dateAttribute9              DATE,
            p_dateAttribute10             DATE,
            p_numberAttribute1            NUMBER,
            p_numberAttribute2            NUMBER,
            p_numberAttribute3            NUMBER,
            p_numberAttribute4            NUMBER,
            p_numberAttribute5            NUMBER,
            p_numberAttribute6            NUMBER,
            p_numberAttribute7            NUMBER,
            p_numberAttribute8            NUMBER,
            p_numberAttribute9            NUMBER,
            p_numberAttribute10           NUMBER,
            p_protectedTextAttribute1     VARCHAR2,
            p_protectedTextAttribute2     VARCHAR2,
            p_protectedTextAttribute3     VARCHAR2,
            p_protectedTextAttribute4     VARCHAR2,
            p_protectedTextAttribute5     VARCHAR2,
            p_protectedTextAttribute6     VARCHAR2,
            p_protectedTextAttribute7     VARCHAR2,
            p_protectedTextAttribute8     VARCHAR2,
            p_protectedTextAttribute9     VARCHAR2,
            p_protectedTextAttribute10    VARCHAR2,
            p_protectedTextAttribute11    VARCHAR2,
            p_protectedTextAttribute12    VARCHAR2,
            p_protectedTextAttribute13    VARCHAR2,
            p_protectedTextAttribute14    VARCHAR2,
            p_protectedTextAttribute15    VARCHAR2,
            p_protectedTextAttribute16    VARCHAR2,
            p_protectedTextAttribute17    VARCHAR2,
            p_protectedTextAttribute18    VARCHAR2,
            p_protectedTextAttribute19    VARCHAR2,
            p_protectedTextAttribute20    VARCHAR2,
            p_protectedFormAttribute1     VARCHAR2,
            p_protectedFormAttribute2     VARCHAR2,
            p_protectedFormAttribute3     VARCHAR2,
            p_protectedFormAttribute4     VARCHAR2,
            p_protectedFormAttribute5     VARCHAR2,
            p_protectedFormAttribute6     VARCHAR2,
            p_protectedFormAttribute7     VARCHAR2,
            p_protectedFormAttribute8     VARCHAR2,
            p_protectedFormAttribute9     VARCHAR2,
            p_protectedFormAttribute10    VARCHAR2,
            p_protectedUrlAttribute1      VARCHAR2,
            p_protectedUrlAttribute2      VARCHAR2,
            p_protectedUrlAttribute3      VARCHAR2,
            p_protectedUrlAttribute4      VARCHAR2,
            p_protectedUrlAttribute5      VARCHAR2,
            p_protectedUrlAttribute6      VARCHAR2,
            p_protectedUrlAttribute7      VARCHAR2,
            p_protectedUrlAttribute8      VARCHAR2,
            p_protectedUrlAttribute9      VARCHAR2,
            p_protectedUrlAttribute10     VARCHAR2,
            p_protectedDateAttribute1     DATE,
            p_protectedDateAttribute2     DATE,
            p_protectedDateAttribute3     DATE,
            p_protectedDateAttribute4     DATE,
            p_protectedDateAttribute5     DATE,
            p_protectedDateAttribute6     DATE,
            p_protectedDateAttribute7     DATE,
            p_protectedDateAttribute8     DATE,
            p_protectedDateAttribute9     DATE,
            p_protectedDateAttribute10    DATE,
            p_protectedNumberAttribute1   NUMBER,
            p_protectedNumberAttribute2   NUMBER,
            p_protectedNumberAttribute3   NUMBER,
            p_protectedNumberAttribute4   NUMBER,
            p_protectedNumberAttribute5   NUMBER,
            p_protectedNumberAttribute6   NUMBER,
            p_protectedNumberAttribute7   NUMBER,
            p_protectedNumberAttribute8   NUMBER,
            p_protectedNumberAttribute9   NUMBER,
            p_protectedNumberAttribute10  NUMBER,
            p_title                       VARCHAR2,
            p_titleResourceKey            VARCHAR2,
            p_identificationKey           VARCHAR2,
            p_workflowDescriptorURI       VARCHAR2,
            p_taskDefinitionId            VARCHAR2,
            p_taskDefinitionName          VARCHAR2,
            p_applicationContext          VARCHAR2,
            p_applicationName             VARCHAR2,
            p_category                    VARCHAR2,
            p_componentName               VARCHAR2,
            p_compositeDN                 VARCHAR2,
            p_compositeInstanceId         VARCHAR2,
            p_compositeName               VARCHAR2,
            p_compositeVersion            VARCHAR2,
            p_conversationId              VARCHAR2,
            p_dueDate                     DATE,
            p_ecId                        VARCHAR2,
            p_isPublic                    VARCHAR2,
            p_isTestTask                  VARCHAR2,
            p_parentComponentInstanceId   VARCHAR2,
            p_parentComponentInstRefId    VARCHAR2,
            p_invokedComponent            VARCHAR2,
            p_participantName             VARCHAR2,
            p_percentageComplete          NUMBER,
            p_readByUsers                 VARCHAR2,
            p_startDate                   DATE,
            p_parentTaskVersion           NUMBER,
            p_taskGroupInstanceId         VARCHAR2,
            p_subTaskGroupInstanceId      VARCHAR2,
            p_agRootId                    NUMBER,
            p_agMileStonePath             VARCHAR2,
            p_rootTaskId                  VARCHAR2,
            p_parentTaskId                VARCHAR2,
            p_systemStringActions         VARCHAR2,
            p_taskDisplayUrl              VARCHAR2,
            p_documentPackageId           VARCHAR2,
            p_subCategory                 VARCHAR2,
            p_correlationId               VARCHAR2,
            p_stage                       VARCHAR2,
            p_assignmentContext           VARCHAR2,
            p_preActionUserSteps          VARCHAR2,
            p_aggregationTaskId           VARCHAR2,
            p_mdsLabel                    VARCHAR2,
            p_isTemplateTask              VARCHAR2,
            p_componentType               VARCHAR2,
            p_activityName                VARCHAR2,
            p_activityId                  VARCHAR2,
            p_processDueDate              DATE,
            p_thread                      INTEGER,
            p_parentThread                INTEGER,
            p_step                        INTEGER,
            p_taskNamespace               VARCHAR2,
            p_timers                      VARCHAR2,
            p_vrcValues                   VARCHAR2,
            p_organizationalUnitId        VARCHAR2,
            p_compositeCreatedTime        TIMESTAMP,
            p_tenantId                    VARCHAR2,
            p_listBuilderId               VARCHAR2,
            p_caseId                      VARCHAR2,
            p_swimlaneRole                VARCHAR2,
            p_excludedParticipants        VARCHAR2,
            p_customAttributeString1    VARCHAR2,
            p_customAttributeString2    VARCHAR2,
            p_customAttributeNumber1    NUMBER,
            p_customAttributeNumber2    NUMBER,
            p_customAttributeDate1      DATE,
            p_customAttributeDate2      DATE,
            p_timersSuspended           VARCHAR2,
            p_tenant_id                 NUMBER,
            p_isDecomposedTask          VARCHAR2,
            p_formName                  VARCHAR2,
            p_decomposedTaskGrpInstanceId VARCHAR2,
            p_startTime                 TIMESTAMP,
            p_stopTime                  TIMESTAMP,
            p_workingduration           INTEGER,
            p_shortSummary              VARCHAR2,
            p_longSummary               VARCHAR2,
            p_COMPONENT_INSTANCE_ID       INTEGER,
            p_FLOW_ID                   INTEGER,
            p_SCA_PARTITION_ID          INTEGER
            ) IS
            BEGIN
            IF ( p_taskNumber IS NULL OR  p_taskNumber <= 0 ) THEN
            SELECT WFTaskSeq.NEXTVAL INTO p_taskNumber
            FROM DUAL;
            END IF;
            INSERT INTO WFTask
            (acquiredBy,
            assignees,
            assigneesDisplayName,
            reviewers,
            reviewersDisplayName,
            callbackContext,
            callbackId,
            callbackType,
            creator,
            digitalSignatureRequired,
            expirationDate,
            expirationDuration,
            identityContext,
            ownerUser,
            ownerGroup,
            ownerRole,
            passwordRequiredOnUpdate,
            priority,
            domainId,
            instanceId,
            processId,
            processName,
            processType,
            processVersion,
            secureNotifications,
            accessKey,
            approvalDuration,
            approvers,
            assignedDate,
            createdDate,
            elapsedTime,
            endDate,
            fromUser,
            fromUserDisplayName,
            hasSubtask,
            inShortHistory,
            isGroup,
            language,
            mailStatus,
            numberOfTimesModified,
            originalAssigneeUser,
            outcome,
            parallelOutcomeCount,
            pushbackSequence,
            State,
            SubState,
            systemString1,
            systemString2,
            SystemString3,
            taskGroupId,
            taskId,
            taskNumber,
            updatedBy,
            updatedByDisplayName,
            updatedDate,
            updatedNotificationId,
            version,
            versionReason,
            workflowPattern,
            textAttribute1,
            textAttribute2,
            textAttribute3,
            textAttribute4,
            textAttribute5,
            textAttribute6,
            textAttribute7,
            textAttribute8,
            textAttribute9,
            textAttribute10,
            textAttribute11,
            textAttribute12,
            textAttribute13,
            textAttribute14,
            textAttribute15,
            textAttribute16,
            textAttribute17,
            textAttribute18,
            textAttribute19,
            textAttribute20,
            formAttribute1,
            formAttribute2,
            formAttribute3,
            formAttribute4,
            formAttribute5,
            formAttribute6,
            formAttribute7,
            formAttribute8,
            formAttribute9,
            formAttribute10,
            urlAttribute1,
            urlAttribute2,
            urlAttribute3,
            urlAttribute4,
            urlAttribute5,
            urlAttribute6,
            urlAttribute7,
            urlAttribute8,
            urlAttribute9,
            urlAttribute10,
            dateAttribute1,
            dateAttribute2,
            dateAttribute3,
            dateAttribute4,
            dateAttribute5,
            dateAttribute6,
            dateAttribute7,
            dateAttribute8,
            dateAttribute9,
            dateAttribute10,
            numberAttribute1,
            numberAttribute2,
            numberAttribute3,
            numberAttribute4,
            numberAttribute5,
            numberAttribute6,
            numberAttribute7,
            numberAttribute8,
            numberAttribute9,
            numberAttribute10,
            protectedTextAttribute1,
            protectedTextAttribute2,
            protectedTextAttribute3,
            protectedTextAttribute4,
            protectedTextAttribute5,
            protectedTextAttribute6,
            protectedTextAttribute7,
            protectedTextAttribute8,
            protectedTextAttribute9,
            protectedTextAttribute10,
            protectedTextAttribute11,
            protectedTextAttribute12,
            protectedTextAttribute13,
            protectedTextAttribute14,
            protectedTextAttribute15,
            protectedTextAttribute16,
            protectedTextAttribute17,
            protectedTextAttribute18,
            protectedTextAttribute19,
            protectedTextAttribute20,
            protectedFormAttribute1,
            protectedFormAttribute2,
            protectedFormAttribute3,
            protectedFormAttribute4,
            protectedFormAttribute5,
            protectedFormAttribute6,
            protectedFormAttribute7,
            protectedFormAttribute8,
            protectedFormAttribute9,
            protectedFormAttribute10,
            protectedUrlAttribute1,
            protectedUrlAttribute2,
            protectedUrlAttribute3,
            protectedUrlAttribute4,
            protectedUrlAttribute5,
            protectedUrlAttribute6,
            protectedUrlAttribute7,
            protectedUrlAttribute8,
            protectedUrlAttribute9,
            protectedUrlAttribute10,
            protectedDateAttribute1,
            protectedDateAttribute2,
            protectedDateAttribute3,
            protectedDateAttribute4,
            protectedDateAttribute5,
            protectedDateAttribute6,
            protectedDateAttribute7,
            protectedDateAttribute8,
            protectedDateAttribute9,
            protectedDateAttribute10,
            protectedNumberAttribute1,
            protectedNumberAttribute2,
            protectedNumberAttribute3,
            protectedNumberAttribute4,
            protectedNumberAttribute5,
            protectedNumberAttribute6,
            protectedNumberAttribute7,
            protectedNumberAttribute8,
            protectedNumberAttribute9,
            protectedNumberAttribute10,
            title,
            titleResourceKey,
            identificationKey,
            workflowDescriptorURI,
            taskDefinitionId,
            taskDefinitionName,
            applicationContext,
            applicationName,
            category,
            componentName,
            compositeDN,
            compositeInstanceId,
            compositeName,
            compositeVersion,
            conversationId,
            dueDate,
            ecId,
            isPublic,
            isTestTask,
            parentComponentInstanceId,
            parentComponentInstRefId,
            invokedComponent,
            participantName,
            percentageComplete,
            readByUsers,
            startDate,
            parentTaskVersion,
            taskGroupInstanceId,
            subTaskGroupInstanceId,
            agRootId,
            agMileStonePath,
            rootTaskId,
            parentTaskId,
            systemStringActions,
            taskDisplayUrl,
            documentPackageId,
            subCategory,
            correlationId,
            stage,
            assignmentContext,
            preActionUserSteps,
            aggregationTaskId,
            mdsLabel,
            isTemplateTask,
            componentType,
            activityName,
            activityId,
            processDueDate,
            thread,
            parentThread,
            step,
            taskNamespace,
            timers,
            vrcValues,
            organizationalUnitId,
            compositeCreatedTime,
            tenantId,
            listBuilderId,
            caseId,
            swimlaneRole,
            excludedParticipants,
            customAttributeString1,
            customAttributeString2,
            customAttributeNumber1,
            customAttributeNumber2,
            customAttributeDate1,
            customAttributeDate2,
            timersSuspended,
            tenant_id,
            isDecomposedTask,
            formName,
            decomposedTaskGrpInstanceId,
            startTime,
            stopTime,
            workingduration,
            shortSummary,
            longSummary,
            COMPONENT_INSTANCE_ID,
            FLOW_ID,
            SCA_PARTITION_ID
            )VALUES(
            p_acquiredBy,
            p_assignees,
            p_assigneesDisplayName,
            p_reviewers,
            p_reviewersDisplayName,
            p_callbackContext,
            p_callbackId,
            p_callbackType,
            p_creator,
            p_digitalSignatureRequired,
            p_expirationDate,
            p_expirationDuration,
            p_identityContext,
            p_ownerUser,
            p_ownerGroup,
            p_ownerRole,
            p_passwordRequiredOnUpdate,
            p_priority,
            p_domainId,
            p_instanceId,
            p_processId,
            p_processName,
            p_processType,
            p_processVersion,
            p_secureNotifications,
            p_accessKey,
            p_approvalDuration,
            p_approvers,
            p_assignedDate,
            p_createdDate,
            p_elapsedTime,
            p_endDate,
            p_fromUser,
            p_fromUserDisplayName,
            p_hasSubtask,
            p_inShortHistory,
            p_isGroup,
            p_language,
            p_mailStatus,
            1,
            p_originalAssigneeUser,
            p_outcome,
            p_parallelOutcomeCount,
            p_pushbackSequence,
            p_State,
            p_SubState,
            p_systemString1,
            p_systemString2,
            p_SystemString3,
            p_taskGroupId,
            p_taskId,
            p_taskNumber,
            p_updatedBy,
            p_updatedByDisplayName,
            p_updatedDate,
            p_updatedNotificationId,
            1,
            p_versionReason,
            p_workflowPattern,
            p_textAttribute1,
            p_textAttribute2,
            p_textAttribute3,
            p_textAttribute4,
            p_textAttribute5,
            p_textAttribute6,
            p_textAttribute7,
            p_textAttribute8,
            p_textAttribute9,
            p_textAttribute10,
            p_textAttribute11,
            p_textAttribute12,
            p_textAttribute13,
            p_textAttribute14,
            p_textAttribute15,
            p_textAttribute16,
            p_textAttribute17,
            p_textAttribute18,
            p_textAttribute19,
            p_textAttribute20,
            p_formAttribute1,
            p_formAttribute2,
            p_formAttribute3,
            p_formAttribute4,
            p_formAttribute5,
            p_formAttribute6,
            p_formAttribute7,
            p_formAttribute8,
            p_formAttribute9,
            p_formAttribute10,
            p_urlAttribute1,
            p_urlAttribute2,
            p_urlAttribute3,
            p_urlAttribute4,
            p_urlAttribute5,
            p_urlAttribute6,
            p_urlAttribute7,
            p_urlAttribute8,
            p_urlAttribute9,
            p_urlAttribute10,
            p_dateAttribute1,
            p_dateAttribute2,
            p_dateAttribute3,
            p_dateAttribute4,
            p_dateAttribute5,
            p_dateAttribute6,
            p_dateAttribute7,
            p_dateAttribute8,
            p_dateAttribute9,
            p_dateAttribute10,
            p_numberAttribute1,
            p_numberAttribute2,
            p_numberAttribute3,
            p_numberAttribute4,
            p_numberAttribute5,
            p_numberAttribute6,
            p_numberAttribute7,
            p_numberAttribute8,
            p_numberAttribute9,
            p_numberAttribute10,
            p_protectedTextAttribute1,
            p_protectedTextAttribute2,
            p_protectedTextAttribute3,
            p_protectedTextAttribute4,
            p_protectedTextAttribute5,
            p_protectedTextAttribute6,
            p_protectedTextAttribute7,
            p_protectedTextAttribute8,
            p_protectedTextAttribute9,
            p_protectedTextAttribute10,
            p_protectedTextAttribute11,
            p_protectedTextAttribute12,
            p_protectedTextAttribute13,
            p_protectedTextAttribute14,
            p_protectedTextAttribute15,
            p_protectedTextAttribute16,
            p_protectedTextAttribute17,
            p_protectedTextAttribute18,
            p_protectedTextAttribute19,
            p_protectedTextAttribute20,
            p_protectedFormAttribute1,
            p_protectedFormAttribute2,
            p_protectedFormAttribute3,
            p_protectedFormAttribute4,
            p_protectedFormAttribute5,
            p_protectedFormAttribute6,
            p_protectedFormAttribute7,
            p_protectedFormAttribute8,
            p_protectedFormAttribute9,
            p_protectedFormAttribute10,
            p_protectedUrlAttribute1,
            p_protectedUrlAttribute2,
            p_protectedUrlAttribute3,
            p_protectedUrlAttribute4,
            p_protectedUrlAttribute5,
            p_protectedUrlAttribute6,
            p_protectedUrlAttribute7,
            p_protectedUrlAttribute8,
            p_protectedUrlAttribute9,
            p_protectedUrlAttribute10,
            p_protectedDateAttribute1,
            p_protectedDateAttribute2,
            p_protectedDateAttribute3,
            p_protectedDateAttribute4,
            p_protectedDateAttribute5,
            p_protectedDateAttribute6,
            p_protectedDateAttribute7,
            p_protectedDateAttribute8,
            p_protectedDateAttribute9,
            p_protectedDateAttribute10,
            p_protectedNumberAttribute1,
            p_protectedNumberAttribute2,
            p_protectedNumberAttribute3,
            p_protectedNumberAttribute4,
            p_protectedNumberAttribute5,
            p_protectedNumberAttribute6,
            p_protectedNumberAttribute7,
            p_protectedNumberAttribute8,
            p_protectedNumberAttribute9,
            p_protectedNumberAttribute10,
            p_title,
            p_titleResourceKey,
            p_identificationKey,
            p_workflowDescriptorURI,
            p_taskDefinitionId,
            p_taskDefinitionName,
            p_applicationContext,
            p_applicationName,
            p_category,
            p_componentName,
            p_compositeDN,
            p_compositeInstanceId,
            p_compositeName,
            p_compositeVersion,
            p_conversationId,
            p_dueDate,
            p_ecId,
            p_isPublic,
            p_isTestTask,
            p_parentComponentInstanceId,
            p_parentComponentInstRefId,
            p_invokedComponent,
            p_participantName,
            p_percentageComplete,
            p_readByUsers,
            p_startDate,
            p_parentTaskVersion,
            p_taskGroupInstanceId,
            p_subTaskGroupInstanceId,
            p_agRootId,
            p_agMileStonePath,
            p_rootTaskId,
            p_parentTaskId,
            p_systemStringActions,
            p_taskDisplayUrl,
            p_documentPackageId,
            p_subCategory,
            p_correlationId,
            p_stage,
            p_assignmentContext,
            p_preActionUserSteps,
            p_aggregationTaskId,
            p_mdsLabel,
            p_isTemplateTask,
            p_componentType,
            p_activityName,
            p_activityId,
            p_processDueDate,
            p_thread,
            p_parentThread,
            p_step,
            p_taskNamespace,
            p_timers,
            p_vrcValues,
            p_organizationalUnitId,
            p_compositeCreatedTime,
            p_tenantId,
            p_listBuilderId,
            p_caseId,
            p_swimlaneRole,
            p_excludedParticipants,
            p_customAttributeString1,
            p_customAttributeString2,
            p_customAttributeNumber1,
            p_customAttributeNumber2,
            p_customAttributeDate1,
            p_customAttributeDate2,
            p_timersSuspended,
            p_tenant_id,
            p_isDecomposedTask,
            p_formName,
            p_decomposedTaskGrpInstanceId,
            p_startTime,
            p_stopTime,
            p_workingduration,
            p_shortSummary,
            p_longSummary,
            p_COMPONENT_INSTANCE_ID,
            p_FLOW_ID,
            p_SCA_PARTITION_ID
            );

            createHistory(p_taskID);
            EXCEPTION
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,'Error while inserting task',true);
            END insertTask;


            /**
            *  Insert update of process instance. This package takes same argument as others so that we can reuse the bind
            *  code from java. This takes extra argument as locale which is last argument. Actualy we might not be using all
            *  the values.
            */
            PROCEDURE insertUpdateProcessInstance(
            p_acquiredBy                  VARCHAR2,
            p_assignees              VARCHAR2,
            p_assigneesDisplayName   VARCHAR2,
            p_reviewers              VARCHAR2,
            p_reviewersDisplayName   VARCHAR2,
            p_callbackContext             VARCHAR2,
            p_callbackId                  VARCHAR2,
            p_callbackType                VARCHAR2,
            p_creator                     VARCHAR2,
            p_digitalSignatureRequired    VARCHAR2,
            p_expirationDate              DATE,
            p_expirationDuration          VARCHAR2,
            p_identityContext             VARCHAR2,
            p_ownerUser                   VARCHAR2,
            p_ownerGroup                   VARCHAR2,
            p_ownerRole                   VARCHAR2,
            p_passwordRequiredOnUpdate    VARCHAR2,
            p_priority                    NUMBER,
            p_domainId                    VARCHAR2,
            p_instanceId                  VARCHAR2,
            p_processId                   VARCHAR2,
            p_processName                 VARCHAR2,
            p_processType                 VARCHAR2,
            p_processVersion              VARCHAR2,
            p_secureNotifications         VARCHAR2,
            p_accessKey                   VARCHAR2,
            p_approvalDuration            NUMBER,
            p_approvers                   VARCHAR2,
            p_assignedDate                DATE,
            p_createdDate          IN OUT       DATE,
            p_elapsedTime                 NUMBER,
            p_endDate                     DATE,
            p_fromUser                    VARCHAR2,
            p_fromUserDisplayName         VARCHAR2,
            p_hasSubtask                  VARCHAR2,
            p_inShortHistory              VARCHAR2,
            p_isGroup                     VARCHAR2,
            p_language                    VARCHAR2,
            p_mailStatus                  VARCHAR2,
            p_numberOfTimesModified  IN OUT     NUMBER,
            p_originalAssigneeUser        VARCHAR2,
            p_outcome                     VARCHAR2,
            p_parallelOutcomeCount        VARCHAR2,
            p_pushbackSequence            VARCHAR2,
            p_State                       VARCHAR2,
            p_SubState                    VARCHAR2,
            p_systemString1               VARCHAR2,
            p_systemString2               VARCHAR2,
            p_SystemString3               VARCHAR2,
            p_taskGroupId                 VARCHAR2,
            p_taskId                      VARCHAR2,
            p_taskNumber      IN OUT      NUMBER,
            p_updatedBy                   VARCHAR2,
            p_updatedByDisplayName        VARCHAR2,
            p_updatedDate      IN OUT           DATE,
            p_updatedNotificationId       VARCHAR2,
            p_version        IN OUT             NUMBER,
            p_versionReason               VARCHAR2,
            p_workflowPattern             VARCHAR2,
            p_textAttribute1              VARCHAR2,
            p_textAttribute2              VARCHAR2,
            p_textAttribute3              VARCHAR2,
            p_textAttribute4              VARCHAR2,
            p_textAttribute5              VARCHAR2,
            p_textAttribute6              VARCHAR2,
            p_textAttribute7              VARCHAR2,
            p_textAttribute8              VARCHAR2,
            p_textAttribute9              VARCHAR2,
            p_textAttribute10             VARCHAR2,
            p_textAttribute11             VARCHAR2,
            p_textAttribute12             VARCHAR2,
            p_textAttribute13             VARCHAR2,
            p_textAttribute14             VARCHAR2,
            p_textAttribute15             VARCHAR2,
            p_textAttribute16             VARCHAR2,
            p_textAttribute17             VARCHAR2,
            p_textAttribute18             VARCHAR2,
            p_textAttribute19             VARCHAR2,
            p_textAttribute20             VARCHAR2,
            p_formAttribute1              VARCHAR2,
            p_formAttribute2              VARCHAR2,
            p_formAttribute3              VARCHAR2,
            p_formAttribute4              VARCHAR2,
            p_formAttribute5              VARCHAR2,
            p_formAttribute6              VARCHAR2,
            p_formAttribute7              VARCHAR2,
            p_formAttribute8              VARCHAR2,
            p_formAttribute9              VARCHAR2,
            p_formAttribute10             VARCHAR2,
            p_urlAttribute1               VARCHAR2,
            p_urlAttribute2               VARCHAR2,
            p_urlAttribute3               VARCHAR2,
            p_urlAttribute4               VARCHAR2,
            p_urlAttribute5               VARCHAR2,
            p_urlAttribute6               VARCHAR2,
            p_urlAttribute7               VARCHAR2,
            p_urlAttribute8               VARCHAR2,
            p_urlAttribute9               VARCHAR2,
            p_urlAttribute10              VARCHAR2,
            p_dateAttribute1              DATE,
            p_dateAttribute2              DATE,
            p_dateAttribute3              DATE,
            p_dateAttribute4              DATE,
            p_dateAttribute5              DATE,
            p_dateAttribute6              DATE,
            p_dateAttribute7              DATE,
            p_dateAttribute8              DATE,
            p_dateAttribute9              DATE,
            p_dateAttribute10             DATE,
            p_numberAttribute1            NUMBER,
            p_numberAttribute2            NUMBER,
            p_numberAttribute3            NUMBER,
            p_numberAttribute4            NUMBER,
            p_numberAttribute5            NUMBER,
            p_numberAttribute6            NUMBER,
            p_numberAttribute7            NUMBER,
            p_numberAttribute8            NUMBER,
            p_numberAttribute9            NUMBER,
            p_numberAttribute10           NUMBER,
            p_protectedTextAttribute1     VARCHAR2,
            p_protectedTextAttribute2     VARCHAR2,
            p_protectedTextAttribute3     VARCHAR2,
            p_protectedTextAttribute4     VARCHAR2,
            p_protectedTextAttribute5     VARCHAR2,
            p_protectedTextAttribute6     VARCHAR2,
            p_protectedTextAttribute7     VARCHAR2,
            p_protectedTextAttribute8     VARCHAR2,
            p_protectedTextAttribute9     VARCHAR2,
            p_protectedTextAttribute10    VARCHAR2,
            p_protectedTextAttribute11    VARCHAR2,
            p_protectedTextAttribute12    VARCHAR2,
            p_protectedTextAttribute13    VARCHAR2,
            p_protectedTextAttribute14    VARCHAR2,
            p_protectedTextAttribute15    VARCHAR2,
            p_protectedTextAttribute16    VARCHAR2,
            p_protectedTextAttribute17    VARCHAR2,
            p_protectedTextAttribute18    VARCHAR2,
            p_protectedTextAttribute19    VARCHAR2,
            p_protectedTextAttribute20    VARCHAR2,
            p_protectedFormAttribute1     VARCHAR2,
            p_protectedFormAttribute2     VARCHAR2,
            p_protectedFormAttribute3     VARCHAR2,
            p_protectedFormAttribute4     VARCHAR2,
            p_protectedFormAttribute5     VARCHAR2,
            p_protectedFormAttribute6     VARCHAR2,
            p_protectedFormAttribute7     VARCHAR2,
            p_protectedFormAttribute8     VARCHAR2,
            p_protectedFormAttribute9     VARCHAR2,
            p_protectedFormAttribute10    VARCHAR2,
            p_protectedUrlAttribute1      VARCHAR2,
            p_protectedUrlAttribute2      VARCHAR2,
            p_protectedUrlAttribute3      VARCHAR2,
            p_protectedUrlAttribute4      VARCHAR2,
            p_protectedUrlAttribute5      VARCHAR2,
            p_protectedUrlAttribute6      VARCHAR2,
            p_protectedUrlAttribute7      VARCHAR2,
            p_protectedUrlAttribute8      VARCHAR2,
            p_protectedUrlAttribute9      VARCHAR2,
            p_protectedUrlAttribute10     VARCHAR2,
            p_protectedDateAttribute1     DATE,
            p_protectedDateAttribute2     DATE,
            p_protectedDateAttribute3     DATE,
            p_protectedDateAttribute4     DATE,
            p_protectedDateAttribute5     DATE,
            p_protectedDateAttribute6     DATE,
            p_protectedDateAttribute7     DATE,
            p_protectedDateAttribute8     DATE,
            p_protectedDateAttribute9     DATE,
            p_protectedDateAttribute10    DATE,
            p_protectedNumberAttribute1   NUMBER,
            p_protectedNumberAttribute2   NUMBER,
            p_protectedNumberAttribute3   NUMBER,
            p_protectedNumberAttribute4   NUMBER,
            p_protectedNumberAttribute5   NUMBER,
            p_protectedNumberAttribute6   NUMBER,
            p_protectedNumberAttribute7   NUMBER,
            p_protectedNumberAttribute8   NUMBER,
            p_protectedNumberAttribute9   NUMBER,
            p_protectedNumberAttribute10  NUMBER,
            p_title                       VARCHAR2,
            p_titleResourceKey            VARCHAR2,
            p_identificationKey           VARCHAR2,
            p_workflowDescriptorURI       VARCHAR2,
            p_taskDefinitionId            VARCHAR2,
            p_taskDefinitionName          VARCHAR2,
            p_applicationContext          VARCHAR2,
            p_applicationName             VARCHAR2,
            p_category                    VARCHAR2,
            p_componentName               VARCHAR2,
            p_compositeDN                 VARCHAR2,
            p_compositeInstanceId         VARCHAR2,
            p_compositeName               VARCHAR2,
            p_compositeVersion            VARCHAR2,
            p_conversationId              VARCHAR2,
            p_dueDate                     DATE,
            p_ecId                        VARCHAR2,
            p_isPublic                    VARCHAR2,
            p_isTestTask                  VARCHAR2,
            p_parentComponentInstanceId   VARCHAR2,
            p_parentComponentInstRefId    VARCHAR2,
            p_invokedComponent            VARCHAR2,
            p_participantName             VARCHAR2,
            p_percentageComplete          NUMBER,
            p_readByUsers                 VARCHAR2,
            p_startDate                   DATE,
            p_parentTaskVersion           NUMBER,
            p_taskGroupInstanceId         VARCHAR2,
            p_subTaskGroupInstanceId      VARCHAR2,
            p_agRootId                    NUMBER,
            p_agMileStonePath             VARCHAR2,
            p_rootTaskId                  VARCHAR2,
            p_parentTaskId                VARCHAR2,
            p_systemStringActions         VARCHAR2,
            p_taskDisplayUrl              VARCHAR2,
            p_documentPackageId           VARCHAR2,
            p_subCategory                 VARCHAR2,
            p_correlationId               VARCHAR2,
            p_stage                       VARCHAR2,
            p_assignmentContext           VARCHAR2,
            p_preActionUserSteps          VARCHAR2,
            p_aggregationTaskId           VARCHAR2,
            p_mdsLabel                    VARCHAR2,
            p_isTemplateTask              VARCHAR2,
            p_componentType               VARCHAR2,
            p_activityName                VARCHAR2,
            p_activityId                  VARCHAR2,
            p_processDueDate              DATE,
            p_thread                      INTEGER,
            p_parentThread                INTEGER,
            p_step                        INTEGER,
            p_taskNamespace               VARCHAR2,
            p_timers                      VARCHAR2,
            p_vrcValues                   VARCHAR2,
            p_organizationalUnitId        VARCHAR2,
            p_compositeCreatedTime        TIMESTAMP,
            p_tenantId                    VARCHAR2,
            p_listBuilderId               VARCHAR2,
            p_caseId                      VARCHAR2,
            p_swimlaneRole                VARCHAR2,
            p_excludedParticipants        VARCHAR2,
            p_customAttributeString1    VARCHAR2,
            p_customAttributeString2    VARCHAR2,
            p_customAttributeNumber1    NUMBER,
            p_customAttributeNumber2    NUMBER,
            p_customAttributeDate1      DATE,
            p_customAttributeDate2      DATE,
            p_timersSuspended           VARCHAR2,
            p_tenant_id                 NUMBER,
            p_isDecomposedTask          VARCHAR2,
            p_formName                  VARCHAR2,
            p_decomposedTaskGrpInstanceId VARCHAR2,
            p_startTime                 TIMESTAMP,
            p_stopTime                  TIMESTAMP,
            p_workingduration           INTEGER,
            p_shortSummary              VARCHAR2,
            p_longSummary               VARCHAR2,
            p_COMPONENT_INSTANCE_ID       INTEGER,
            p_FLOW_ID                   INTEGER,
            p_SCA_PARTITION_ID          INTEGER,
            /** p_locale should be the last parameter **/
            p_locale                      VARCHAR2
            ) IS
            l_instancecount NUMBER;
            l_parentinstancecount NUMBER;
            BEGIN
            /**
            * Check for instance before creating it exist or not
            */
            SELECT count(taskId) into l_instancecount FROM WFTask
            WHERE taskId = p_taskId;
            IF l_instancecount = 0 THEN
            select  WFTaskSeq.NEXTVAL into p_taskNumber from DUAL;
            p_version := 1;
            p_numberOfTimesModified := 1;
            insert into WFTask
            (taskId,
            assignees,
            reviewers,
            title,
            ownerUser,
            ownerGroup,
            ownerRole,
            isGroup,
            creator,
            instanceId,
            accessKey,
            componentName,
            compositeDN,
            compositeInstanceId,
            compositeName,
            compositeVersion,
            ecid,
            createdDate,
            endDate,
            expirationDate,
            expirationDuration,
            identityContext,
            applicationContext,
            priority,
            state,
            subState,
            callbackContext,
            taskNumber,
            version,
            versionReason,
            numberOfTimesModified,
            updatedBy,
            updatedDate,
            componentType,
            activityName,
            activityId,
            processDueDate,
            thread,
            parentThread,
            step,
            taskDefinitionId,
            vrcValues,
            organizationalUnitId,
            textAttribute1,
            textAttribute2,
            textAttribute3,
            textAttribute4,
            textAttribute5,
            textAttribute6,
            textAttribute7,
            textAttribute8,
            textAttribute9,
            textAttribute10,
            textAttribute11,
            textAttribute12,
            textAttribute13,
            textAttribute14,
            textAttribute15,
            textAttribute16,
            textAttribute17,
            textAttribute18,
            textAttribute19,
            textAttribute20,
            dateAttribute1,
            dateAttribute2,
            dateAttribute3,
            dateAttribute4,
            dateAttribute5,
            dateAttribute6,
            dateAttribute7,
            dateAttribute8,
            dateAttribute9,
            dateAttribute10,
            numberAttribute1,
            numberAttribute2,
            numberAttribute3,
            numberAttribute4,
            numberAttribute5,
            numberAttribute6,
            numberAttribute7,
            numberAttribute8,
            numberAttribute9,
            numberAttribute10,
            protectedTextAttribute1,
            protectedTextAttribute2,
            protectedTextAttribute3,
            protectedTextAttribute4,
            protectedTextAttribute5,
            protectedTextAttribute6,
            protectedTextAttribute7,
            protectedTextAttribute8,
            protectedTextAttribute9,
            protectedTextAttribute10,
            protectedTextAttribute11,
            protectedTextAttribute12,
            protectedTextAttribute13,
            protectedTextAttribute14,
            protectedTextAttribute15,
            protectedTextAttribute16,
            protectedTextAttribute17,
            protectedTextAttribute18,
            protectedTextAttribute19,
            protectedTextAttribute20,
            protectedDateAttribute1,
            protectedDateAttribute2,
            protectedDateAttribute3,
            protectedDateAttribute4,
            protectedDateAttribute5,
            protectedDateAttribute6,
            protectedDateAttribute7,
            protectedDateAttribute8,
            protectedDateAttribute9,
            protectedDateAttribute10,
            protectedNumberAttribute1,
            protectedNumberAttribute2,
            protectedNumberAttribute3,
            protectedNumberAttribute4,
            protectedNumberAttribute5,
            protectedNumberAttribute6,
            protectedNumberAttribute7,
            protectedNumberAttribute8,
            protectedNumberAttribute9,
            protectedNumberAttribute10,
            assignmentContext,
            compositeCreatedTime,
            tenantId,
            listBuilderId,
            caseId,
            swimlaneRole,
            excludedParticipants,
            customAttributeString1,
            customAttributeString2,
            customAttributeNumber1,
            customAttributeNumber2,
            customAttributeDate1,
            customAttributeDate2,
            timersSuspended,
            tenant_id,
            isDecomposedTask,
            formName,
            decomposedTaskGrpInstanceId,
            COMPONENT_INSTANCE_ID,
            FLOW_ID,
            SCA_PARTITION_ID,
            agRootId,
            startTime,
            stopTime,
            workingduration,
            shortSummary,
            longSummary)
            values
            (p_taskId,
            p_assignees,
            p_reviewers,
            p_title,
            p_ownerUser,
            p_ownerGroup,
            p_ownerRole,
            p_isGroup,
            p_creator,
            p_instanceId,
            p_accessKey,
            p_componentName,
            p_compositeDN,
            p_compositeInstanceId,
            p_compositeName,
            p_compositeVersion,
            p_ecid,
            p_createdDate,
            p_endDate,
            p_expirationDate,
            p_expirationDuration,
            p_identityContext,
            p_applicationContext,
            p_priority,
            p_state,
            p_SubState,
            p_callbackContext,
            p_taskNumber,
            p_version,
            p_versionReason,
            p_numberOfTimesModified,
            p_updatedBy,
            p_updatedDate,
            p_componentType,
            p_activityName,
            p_activityId,
            p_processDueDate,
            p_thread,p_parentThread,
            p_step,
            p_taskDefinitionId,
            p_vrcValues,
            p_organizationalUnitId,
            p_textAttribute1,
            p_textAttribute2,
            p_textAttribute3,
            p_textAttribute4,
            p_textAttribute5,
            p_textAttribute6,
            p_textAttribute7,
            p_textAttribute8,
            p_textAttribute9,
            p_textAttribute10,
            p_textAttribute11,
            p_textAttribute12,
            p_textAttribute13,
            p_textAttribute14,
            p_textAttribute15,
            p_textAttribute16,
            p_textAttribute17,
            p_textAttribute18,
            p_textAttribute19,
            p_textAttribute20,
            p_dateAttribute1,
            p_dateAttribute2,
            p_dateAttribute3,
            p_dateAttribute4,
            p_dateAttribute5,
            p_dateAttribute6,
            p_dateAttribute7,
            p_dateAttribute8,
            p_dateAttribute9,
            p_dateAttribute10,
            p_numberAttribute1,
            p_numberAttribute2,
            p_numberAttribute3,
            p_numberAttribute4,
            p_numberAttribute5,
            p_numberAttribute6,
            p_numberAttribute7,
            p_numberAttribute8,
            p_numberAttribute9,
            p_numberAttribute10,
            p_protectedTextAttribute1,
            p_protectedTextAttribute2,
            p_protectedTextAttribute3,
            p_protectedTextAttribute4,
            p_protectedTextAttribute5,
            p_protectedTextAttribute6,
            p_protectedTextAttribute7,
            p_protectedTextAttribute8,
            p_protectedTextAttribute9,
            p_protectedTextAttribute10,
            p_protectedTextAttribute11,
            p_protectedTextAttribute12,
            p_protectedTextAttribute13,
            p_protectedTextAttribute14,
            p_protectedTextAttribute15,
            p_protectedTextAttribute16,
            p_protectedTextAttribute17,
            p_protectedTextAttribute18,
            p_protectedTextAttribute19,
            p_protectedTextAttribute20,
            p_protectedDateAttribute1,
            p_protectedDateAttribute2,
            p_protectedDateAttribute3,
            p_protectedDateAttribute4,
            p_protectedDateAttribute5,
            p_protectedDateAttribute6,
            p_protectedDateAttribute7,
            p_protectedDateAttribute8,
            p_protectedDateAttribute9,
            p_protectedDateAttribute10,
            p_protectedNumberAttribute1,
            p_protectedNumberAttribute2,
            p_protectedNumberAttribute3,
            p_protectedNumberAttribute4,
            p_protectedNumberAttribute5,
            p_protectedNumberAttribute6,
            p_protectedNumberAttribute7,
            p_protectedNumberAttribute8,
            p_protectedNumberAttribute9,
            p_protectedNumberAttribute10,
            p_assignmentContext,
            p_compositeCreatedTime,
            p_tenantId,
            p_listBuilderId,
            p_caseId,
            p_swimlaneRole,
            p_excludedParticipants,
            p_customAttributeString1,
            p_customAttributeString2,
            p_customAttributeNumber1,
            p_customAttributeNumber2,
            p_customAttributeDate1,
            p_customAttributeDate2,
            p_timersSuspended,
            p_tenant_id,
            p_isDecomposedTask,
            p_formName,
            p_decomposedTaskGrpInstanceId,
            p_COMPONENT_INSTANCE_ID,
            p_FLOW_ID,
            p_SCA_PARTITION_ID,
            p_agRootId,
            p_startTime,
            p_stopTime,
            p_workingduration,
            p_shortSummary,
            p_longSummary);

            INSERT INTO WFTASK_TL (taskId, version, locale ,title,compositeCreatedTime)
            VALUES (p_taskId,p_version,p_locale,p_title,p_compositeCreatedTime);
            /*
            * This is just to add dummy entry in history table for main instance only
            */
            IF p_state IS NOT NULL AND p_taskId = p_instanceId THEN
            INSERT INTO WFTASKHISTORY(
            taskId,
            assignees,
            reviewers,
            title,
            ownerUser,
            ownerGroup,
            ownerRole,
            isGroup,
            creator,
            instanceId,
            accessKey,
            componentName,
            compositeDN,
            compositeInstanceId,
            compositeName,
            compositeVersion,
            ecid,
            createdDate,
            endDate,
            expirationDate,
            expirationDuration,
            identityContext,
            applicationContext,
            priority,
            state,
            subState,
            callbackContext,
            taskNumber,
            version,
            versionReason,
            numberOfTimesModified,
            updatedBy,
            updatedDate,
            componentType,
            activityName,
            activityId,
            processDueDate,
            thread,
            parentThread,
            step,
            taskDefinitionId,
            assignmentContext,
            compositeCreatedTime,
            tenantId,
            listBuilderId,
            caseId,
            swimlaneRole,
            excludedParticipants,
            customAttributeString1,
            customAttributeString2,
            customAttributeNumber1,
            customAttributeNumber2,
            customAttributeDate1,
            customAttributeDate2,
            timersSuspended,
            tenant_id,
            isDecomposedTask,
            formName,
            decomposedTaskGrpInstanceId,
            startTime,
            stopTime,
            workingduration,
            shortSummary,
            longSummary)
            VALUES
            (p_taskId,
            p_assignees,
            p_reviewers,
            p_title,
            p_ownerUser,
            p_ownerGroup,
            p_ownerRole,
            p_isGroup,
            p_creator,p_instanceId,
            p_accessKey,
            p_componentName,
            p_compositeDN,
            p_compositeInstanceId,
            p_compositeName,
            p_compositeVersion,
            p_ecid,
            p_createdDate,
            p_endDate,
            p_expirationDate,
            p_expirationDuration,
            p_identityContext,
            p_applicationContext,
            p_priority,
            p_state,
            p_SubState,
            p_callbackContext,
            p_taskNumber,
            p_version,
            p_versionReason,
            p_numberOfTimesModified,
            p_updatedBy,
            p_updatedDate,
            p_componentType,
            p_activityName,
            p_activityId,
            p_processDueDate,
            p_thread,
            p_parentThread,
            p_step,
            p_taskDefinitionId,
            p_assignmentContext,
            p_compositeCreatedTime,
            p_tenantId,
            p_listBuilderId,
            p_caseId,
            p_swimlaneRole,
            p_excludedParticipants,
            p_customAttributeString1,
            p_customAttributeString2,
            p_customAttributeNumber1,
            p_customAttributeNumber2,
            p_customAttributeDate1,
            p_customAttributeDate2,
            p_timersSuspended,
            p_tenant_id,
            p_isDecomposedTask,
            p_formName,
            p_decomposedTaskGrpInstanceId,
            p_startTime,
            p_stopTime,
            p_workingduration,
            p_shortSummary,
            p_longSummary
            );
            END IF;

            ELSE
            /**
            *  In case if it exist and not top instance and state is null means it needs to be
            *  deleted as we can not keep too many asyn instances.
            */
            update  WFTask set
            compositeDN = p_compositeDN,
            title = p_title,assignees=p_assignees,reviewers=p_reviewers,ownerUser=p_ownerUser,ownerGroup=p_ownerGroup,isGroup=p_isGroup,
            ownerRole=p_ownerRole,creator=p_creator,accessKey=p_accessKey,endDate=p_endDate,
            expirationDate = p_expirationDate,expirationDuration=p_expirationDuration,
            priority=p_priority,state=p_state,subState=p_SubState,callbackContext=p_callbackContext,numberOfTimesModified=numberOfTimesModified+1,
            updatedBy=p_updatedBy,updatedDate=p_createdDate,activityName=p_activityName,
            activityId=p_activityId,processDueDate=p_processDueDate,
            step=p_step,taskDefinitionId=p_taskDefinitionId,assignmentContext=p_assignmentContext,vrcValues=p_vrcValues,
            organizationalUnitId=p_organizationalUnitId,
            tenantId=p_tenantId,
            listBuilderId=p_listBuilderId,
            caseId=p_caseId,
            swimlaneRole=p_swimlaneRole,
            excludedParticipants=p_excludedParticipants,
            customAttributeString1=p_customAttributeString1,
            customAttributeString2=p_customAttributeString2,
            customAttributeNumber1=p_customAttributeNumber1,
            customAttributeNumber2=p_customAttributeNumber2,
            customAttributeDate1=p_customAttributeDate1,
            customAttributeDate2=p_customAttributeDate2,
            timersSuspended=p_timersSuspended,
            tenant_id=p_tenant_id,
            isDecomposedTask=p_isDecomposedTask,
            formName=p_formName,
            decomposedTaskGrpInstanceId=p_decomposedTaskGrpInstanceId,
            COMPONENT_INSTANCE_ID=p_COMPONENT_INSTANCE_ID,
            FLOW_ID=p_FLOW_ID,
            SCA_PARTITION_ID=p_SCA_PARTITION_ID,
            textAttribute1=p_textAttribute1,textAttribute2=p_textAttribute2,
            textAttribute3=p_textAttribute3,textAttribute4=p_textAttribute4,
            textAttribute5=p_textAttribute5,textAttribute6=p_textAttribute6,
            textAttribute7=p_textAttribute7,textAttribute8=p_textAttribute8,
            textAttribute9=p_textAttribute9,textAttribute10=p_textAttribute10,
            textAttribute11=p_textAttribute11,textAttribute12=p_textAttribute12,
            textAttribute13=p_textAttribute13,textAttribute14=p_textAttribute14,
            textAttribute15=p_textAttribute15,textAttribute16=p_textAttribute16,
            textAttribute17=p_textAttribute17,textAttribute18=p_textAttribute18,
            textAttribute19=p_textAttribute19,textAttribute20=p_textAttribute20,
            dateAttribute1=p_dateAttribute1,dateAttribute2=p_dateAttribute2,
            dateAttribute3=p_dateAttribute3,dateAttribute4=p_dateAttribute4,
            dateAttribute5=p_dateAttribute5,dateAttribute6=p_dateAttribute6,
            dateAttribute7=p_dateAttribute7,dateAttribute8=p_dateAttribute8,
            dateAttribute9=p_dateAttribute9,dateAttribute10=p_dateAttribute10,
            numberAttribute1=p_numberAttribute1,numberAttribute2=p_numberAttribute2,
            numberAttribute3=p_numberAttribute3,numberAttribute4=p_numberAttribute4,
            numberAttribute5=p_numberAttribute5,numberAttribute6=p_numberAttribute6,
            numberAttribute7=p_numberAttribute7,numberAttribute8=p_numberAttribute8,
            numberAttribute9=p_numberAttribute9,numberAttribute10=p_numberAttribute10,
            protectedTextAttribute1=p_protectedTextAttribute1,protectedTextAttribute2=p_protectedTextAttribute2,
            protectedTextAttribute3=p_protectedTextAttribute3,protectedTextAttribute4=p_protectedTextAttribute4,
            protectedTextAttribute5=p_protectedTextAttribute5,protectedTextAttribute6=p_protectedTextAttribute6,
            protectedTextAttribute7=p_protectedTextAttribute7,protectedTextAttribute8=p_protectedTextAttribute8,
            protectedTextAttribute9=p_protectedTextAttribute9,protectedTextAttribute10=p_protectedTextAttribute10,
            protectedTextAttribute11=p_protectedTextAttribute11,protectedTextAttribute12=p_protectedTextAttribute12,
            protectedTextAttribute13=p_protectedTextAttribute13,protectedTextAttribute14=p_protectedTextAttribute14,
            protectedTextAttribute15=p_protectedTextAttribute15,protectedTextAttribute16=p_protectedTextAttribute16,
            protectedTextAttribute17=p_protectedTextAttribute17,protectedTextAttribute18=p_protectedTextAttribute18,
            protectedTextAttribute19=p_protectedTextAttribute19,protectedTextAttribute20=p_protectedTextAttribute20,
            protectedDateAttribute1=p_protectedDateAttribute1,protectedDateAttribute2=p_protectedDateAttribute2,
            protectedDateAttribute3=p_protectedDateAttribute3,protectedDateAttribute4=p_protectedDateAttribute4,
            protectedDateAttribute5=p_protectedDateAttribute5,protectedDateAttribute6=p_protectedDateAttribute6,
            protectedDateAttribute7=p_protectedDateAttribute7,protectedDateAttribute8=p_protectedDateAttribute8,
            protectedDateAttribute9=p_protectedDateAttribute9,protectedDateAttribute10=p_protectedDateAttribute10,
            protectedNumberAttribute1=p_protectedNumberAttribute1,protectedNumberAttribute2=p_protectedNumberAttribute2,
            protectedNumberAttribute3=p_protectedNumberAttribute3,protectedNumberAttribute4=p_protectedNumberAttribute4,
            protectedNumberAttribute5=p_protectedNumberAttribute5,protectedNumberAttribute6=p_protectedNumberAttribute6,
            protectedNumberAttribute7=p_protectedNumberAttribute7,protectedNumberAttribute8=p_protectedNumberAttribute8,
            protectedNumberAttribute9=p_protectedNumberAttribute9,protectedNumberAttribute10=p_protectedNumberAttribute10,agRootId=p_agRootId,
            startTime=p_startTime,
            stopTime=p_stopTime,
            workingduration=p_workingduration,
            shortSummary=p_shortSummary,
            longSummary=p_longSummary

            WHERE taskId =p_taskId;
            UPDATE WFTASK_TL SET
            locale = p_locale, title = p_title ,
            version = p_version
            WHERE taskId = p_taskId;


            SELECT taskNumber,updatedDate,createdDate,version,numberOfTimesModified
            INTO p_taskNumber,p_updatedDate,p_createdDate,p_version,p_numberOfTimesModified
            FROM WFTask where taskId = p_taskId;
            END IF;

            --Bug 9462350: for parallel threads, ensure the flexfield valies on the main instance
            --are kept in sync with those on parallel threads
            IF (p_taskId != p_instanceId) THEN
            update  WFTask set
            -- compositeDN = p_compositeDN,
            -- title = p_title,assignees=p_assignees,reviewers=p_reviewers,ownerUser=p_ownerUser,ownerGroup=p_ownerGroup,isGroup=p_isGroup,
            -- ownerRole=p_ownerRole,creator=p_creator,endDate=p_endDate,
            -- expirationDate = p_expirationDate,expirationDuration=p_expirationDuration,
            -- priority=p_priority,numberOfTimesModified=numberOfTimesModified+1,
            -- updatedBy=p_updatedBy,updatedDate=p_createdDate,processDueDate=p_processDueDate,
            -- step=p_step,taskDefinitionId=p_taskDefinitionId,assignmentContext=p_assignmentContext,vrcValues=p_vrcValues,
            -- organizationalUnitId=p_organizationalUnitId,
            -- tenantId=p_tenantId,
            -- listBuilderId=p_listBuilderId,
            -- caseId=p_caseId,
            -- swimlaneRole=p_swimlaneRole,
            -- excludedParticipants=p_excludedParticipants,
            -- customAttributeString1=p_customAttributeString1,
            -- customAttributeString2=p_customAttributeString2,
            -- customAttributeNumber1=p_customAttributeNumber1,
            -- customAttributeNumber2=p_customAttributeNumber2,
            -- customAttributeDate1=p_customAttributeDate1,
            -- customAttributeDate2=p_customAttributeDate2,
            -- timersSuspended=p_timersSuspended,
            -- tenant_id=p_tenant_id,
            -- isDecomposedTask=p_isDecomposedTask,
            -- formName=p_formName,
            -- decomposedTaskGrpInstanceId=p_decomposedTaskGrpInstanceId,
            -- COMPONENT_INSTANCE_ID=p_COMPONENT_INSTANCE_ID,
            -- FLOW_ID=p_FLOW_ID,
            -- SCA_PARTITION_ID=p_SCA_PARTITION_ID,
            textAttribute1=p_textAttribute1,textAttribute2=p_textAttribute2,
            textAttribute3=p_textAttribute3,textAttribute4=p_textAttribute4,
            textAttribute5=p_textAttribute5,textAttribute6=p_textAttribute6,
            textAttribute7=p_textAttribute7,textAttribute8=p_textAttribute8,
            textAttribute9=p_textAttribute9,textAttribute10=p_textAttribute10,
            textAttribute11=p_textAttribute11,textAttribute12=p_textAttribute12,
            textAttribute13=p_textAttribute13,textAttribute14=p_textAttribute14,
            textAttribute15=p_textAttribute15,textAttribute16=p_textAttribute16,
            textAttribute17=p_textAttribute17,textAttribute18=p_textAttribute18,
            textAttribute19=p_textAttribute19,textAttribute20=p_textAttribute20,
            dateAttribute1=p_dateAttribute1,dateAttribute2=p_dateAttribute2,
            dateAttribute3=p_dateAttribute3,dateAttribute4=p_dateAttribute4,
            dateAttribute5=p_dateAttribute5,dateAttribute6=p_dateAttribute6,
            dateAttribute7=p_dateAttribute7,dateAttribute8=p_dateAttribute8,
            dateAttribute9=p_dateAttribute9,dateAttribute10=p_dateAttribute10,
            numberAttribute1=p_numberAttribute1,numberAttribute2=p_numberAttribute2,
            numberAttribute3=p_numberAttribute3,numberAttribute4=p_numberAttribute4,
            numberAttribute5=p_numberAttribute5,numberAttribute6=p_numberAttribute6,
            numberAttribute7=p_numberAttribute7,numberAttribute8=p_numberAttribute8,
            numberAttribute9=p_numberAttribute9,numberAttribute10=p_numberAttribute10,
            protectedTextAttribute1=p_protectedTextAttribute1,protectedTextAttribute2=p_protectedTextAttribute2,
            protectedTextAttribute3=p_protectedTextAttribute3,protectedTextAttribute4=p_protectedTextAttribute4,
            protectedTextAttribute5=p_protectedTextAttribute5,protectedTextAttribute6=p_protectedTextAttribute6,
            protectedTextAttribute7=p_protectedTextAttribute7,protectedTextAttribute8=p_protectedTextAttribute8,
            protectedTextAttribute9=p_protectedTextAttribute9,protectedTextAttribute10=p_protectedTextAttribute10,
            protectedTextAttribute11=p_protectedTextAttribute11,protectedTextAttribute12=p_protectedTextAttribute12,
            protectedTextAttribute13=p_protectedTextAttribute13,protectedTextAttribute14=p_protectedTextAttribute14,
            protectedTextAttribute15=p_protectedTextAttribute15,protectedTextAttribute16=p_protectedTextAttribute16,
            protectedTextAttribute17=p_protectedTextAttribute17,protectedTextAttribute18=p_protectedTextAttribute18,
            protectedTextAttribute19=p_protectedTextAttribute19,protectedTextAttribute20=p_protectedTextAttribute20,
            protectedDateAttribute1=p_protectedDateAttribute1,protectedDateAttribute2=p_protectedDateAttribute2,
            protectedDateAttribute3=p_protectedDateAttribute3,protectedDateAttribute4=p_protectedDateAttribute4,
            protectedDateAttribute5=p_protectedDateAttribute5,protectedDateAttribute6=p_protectedDateAttribute6,
            protectedDateAttribute7=p_protectedDateAttribute7,protectedDateAttribute8=p_protectedDateAttribute8,
            protectedDateAttribute9=p_protectedDateAttribute9,protectedDateAttribute10=p_protectedDateAttribute10,
            protectedNumberAttribute1=p_protectedNumberAttribute1,protectedNumberAttribute2=p_protectedNumberAttribute2,
            protectedNumberAttribute3=p_protectedNumberAttribute3,protectedNumberAttribute4=p_protectedNumberAttribute4,
            protectedNumberAttribute5=p_protectedNumberAttribute5,protectedNumberAttribute6=p_protectedNumberAttribute6,
            protectedNumberAttribute7=p_protectedNumberAttribute7,protectedNumberAttribute8=p_protectedNumberAttribute8,
            protectedNumberAttribute9=p_protectedNumberAttribute9,protectedNumberAttribute10=p_protectedNumberAttribute10
            -- ,startTime=p_startTime,
            -- stopTime=p_stopTime,
            -- workingduration=p_workingduration,
            -- shortSummary=p_shortSummary,
            -- longSummary=p_longSummary
            WHERE taskId =p_instanceid;
            UPDATE WFTASK_TL SET
            locale = p_locale, title = p_title ,
            version = p_version
            WHERE taskId = p_instanceid;

            END IF;


            END;

            /*
            * Copies the WFTask_TL rows to the WFTaskHistory_TL
            * table for the given taskId.
            */
            PROCEDURE createHistoryTranslations(p_taskId varchar2,
            p_version number)
            IS
            l_title VARCHAR2(1500);
            l_category VARCHAR2(600);
            l_subcategory VARCHAR2(600);
            l_compositeCreatedTime TIMESTAMP;

            cursor tasks(p_taskId VARCHAR2, p_version NUMBER)
            is
            SELECT taskId, locale, version, title, category, subcategory, compositeCreatedTime,
            FLOW_ID, SCA_PARTITION_ID
            FROM WFTask_TL
            where taskId = p_taskId
            and version = p_version;

            BEGIN
            for task in tasks(p_taskId, p_version) loop
            BEGIN
            select title, category, subcategory
            into l_title, l_category, l_subcategory
            from WFTaskHistory_TL
            where taskId = task.taskId
            and locale = task.locale
            and version = task.version
            FOR UPDATE NOWAIT;

            update WFTaskHistory_TL
            set title = l_title,
            category = l_category,
            subcategory = l_subcategory
            where taskId = task.taskId
            and locale = task.locale
            and version = task.version;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            INSERT INTO WFTaskHistory_TL
            (taskId, version, locale, title, category, subcategory, compositeCreatedTime,
            FLOW_ID, SCA_PARTITION_ID)
            VALUES (task.taskId, task.version, task.locale,
            task.title, task.category, task.subcategory, task.compositeCreatedTime,
            task.FLOW_ID, task.SCA_PARTITION_ID);
            END;
            end loop;
            EXCEPTION
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,
            'Error while inserting task history translation for task ' ||
            p_taskId, true);
            END createHistoryTranslations;

            /*
            * Creates a version of the translation history for update purposes but no
            * new translation is required.
            */
            PROCEDURE createTranslationVersion(p_taskId IN VARCHAR2, p_version IN NUMBER)
            IS
            CURSOR c_translations(p_taskId IN VARCHAR2) IS
            SELECT taskId, version, locale
            FROM WFTask_TL
            WHERE taskId = p_taskId;

            l_taskId VARCHAR2(64);

            BEGIN
            FOR trans in c_translations(p_taskId) loop
            BEGIN
            SELECT taskId
            INTO l_taskId
            FROM WFTask_TL
            WHERE taskId = trans.taskId
            AND locale = trans.locale
            FOR UPDATE NOWAIT;

            UPDATE WFTask_TL
            SET version = p_version
            WHERE taskId = trans.taskId
            AND locale = trans.locale;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            RAISE v_deletedException;
            WHEN OTHERS THEN
            RAISE v_lockException;
            END;
            END LOOP;
            EXCEPTION
            WHEN  v_lockException THEN
            RAISE_APPLICATION_ERROR(V_lockErrorNumber,'Task translation is locked for update '||p_taskId,true);
            WHEN  v_deletedException THEN
            RAISE_APPLICATION_ERROR(v_deletedErrorNumber,'Task translation does not exist '||p_taskId,true);
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,
            'Error while translation version for task ' ||
            p_taskId, true);
            END;

            /*
            * See specification description
            */
            PROCEDURE createTaskTranslations(p_taskId VARCHAR2,
            p_version NUMBER,
            p_task_data TASK_TRANSLATION_T,
            p_rec_size NUMBER,
            p_isVersionable VARCHAR2,
            p_compositeCreatedTime TIMESTAMP,
            p_FLOW_ID NUMBER,
            p_SCA_PARTITION_ID NUMBER)
            IS
            tId VARCHAR2(64);
            i pls_integer;
            BEGIN
            if p_rec_size = 0 then
            if p_isVersionable = BOOLEAN_TRUE_STRING then
            -- A rec_size of zero flags that there are no translations to post.
            -- However, if the task is versionalbe, we still need a set of
            -- task history rows.
            createTranslationVersion(p_taskId, p_version);
            createHistoryTranslations(p_taskId, p_version);
            return;
            else
            -- No work to be done.
            return;
            end if;
            end if;

            -- Quick parity check. The size of the incoming array must be a
            -- multiple of the record size.
            if p_rec_size <> 0 AND p_task_data.count mod p_rec_size <> 0 then
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,
            'Record size does not match the total data passed ' ||
            to_char(p_rec_size) || ':' ||
            to_char(p_task_data.count) || ' ' ||
            p_taskId, true);
            end if;

            -- Ensure that the task actually exists - but we don't have to
            -- lock this one.
            BEGIN
            SELECT taskId INTO tId
            FROM WFTask WHERE taskId = p_taskId;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            RAISE v_deletedException;
            WHEN OTHERS THEN
            RAISE;
            END;

            i := 1;
            LOOP
            EXIT when i > p_task_data.count;
            -- Insert/Update of translation rows
            BEGIN
            select taskId into tId
            from WFTask_TL
            where taskId = p_taskId
            and locale = p_task_data(i)
            FOR UPDATE NOWAIT;

            update WFTask_TL
            set version = p_version,
            title = p_task_data(i+1),
            category = p_task_data(i+2),
            subcategory = p_task_data(i+3)
            where taskId = p_taskId
            and locale = p_task_data(i);

            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            insert into WFTask_TL(taskId,
            compositeCreatedTime,
            FLOW_ID,
            SCA_PARTITION_ID,
            version,
            locale,
            title,
            category,
            subcategory)
            values(p_taskId,
            p_compositeCreatedTime,
            p_FLOW_ID,
            p_SCA_PARTITION_ID,
            p_version,
            p_task_data(i),
            p_task_data(i+1),
            p_task_data(i+2),
            p_task_data(i+3));
            END;
            i := i + p_rec_size;
            end loop;

            if p_isVersionable = BOOLEAN_TRUE_STRING then
            createHistoryTranslations(p_taskId, p_version);
            end if;

            EXCEPTION
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,
            'Error while inserting task translation for task ' ||
            p_taskId, true);
            END createTaskTranslations;

            PROCEDURE updateTask(
            p_acquiredBy                  VARCHAR2,
            p_assignees                   VARCHAR2,
            p_assigneesDisplayName        VARCHAR2,
            p_reviewers                   VARCHAR2,
            p_reviewersDisplayName        VARCHAR2,
            p_callbackContext             VARCHAR2,
            p_callbackId                  VARCHAR2,
            p_callbackType                VARCHAR2,
            p_creator                     VARCHAR2,
            p_digitalSignatureRequired    VARCHAR2,
            p_expirationDate              DATE,
            p_expirationDuration          VARCHAR2,
            p_identityContext             VARCHAR2,
            p_ownerUser                   VARCHAR2,
            p_ownerGroup                  VARCHAR2,
            p_ownerRole                   VARCHAR2,
            p_passwordRequiredOnUpdate    VARCHAR2,
            p_priority                    NUMBER,
            p_domainId                    VARCHAR2,
            p_instanceId                  VARCHAR2,
            p_processId                   VARCHAR2,
            p_processName                 VARCHAR2,
            p_processType                 VARCHAR2,
            p_processVersion              VARCHAR2,
            p_secureNotifications         VARCHAR2,
            p_accessKey                   VARCHAR2,
            p_approvalDuration            NUMBER,
            p_approvers                   VARCHAR2,
            p_assignedDate                DATE,
            p_createdDate                 DATE,
            p_elapsedTime                 NUMBER,
            p_endDate                     DATE,
            p_fromUser                    VARCHAR2,
            p_fromUserDisplayName         VARCHAR2,
            p_hasSubtask                  VARCHAR2,
            p_inShortHistory              VARCHAR2,
            p_isGroup                     VARCHAR2,
            p_language                    VARCHAR2,
            p_mailStatus                  VARCHAR2,
            p_numberOfTimesModified       NUMBER,
            p_originalAssigneeUser        VARCHAR2,
            p_outcome                     VARCHAR2,
            p_parallelOutcomeCount        VARCHAR2,
            p_pushbackSequence            VARCHAR2,
            p_State                       VARCHAR2,
            p_SubState                    VARCHAR2,
            p_systemString1               VARCHAR2,
            p_systemString2               VARCHAR2,
            p_SystemString3               VARCHAR2,
            p_taskGroupId                 VARCHAR2,
            p_taskId                      VARCHAR2,
            p_taskNumber                  NUMBER,
            p_updatedBy                   VARCHAR2,
            p_updatedByDisplayName        VARCHAR2,
            p_updatedDate                 DATE,
            p_updatedNotificationId       VARCHAR2,
            p_version                     NUMBER,
            p_versionReason               VARCHAR2,
            p_workflowPattern             VARCHAR2,
            p_textAttribute1              VARCHAR2,
            p_textAttribute2              VARCHAR2,
            p_textAttribute3              VARCHAR2,
            p_textAttribute4              VARCHAR2,
            p_textAttribute5              VARCHAR2,
            p_textAttribute6              VARCHAR2,
            p_textAttribute7              VARCHAR2,
            p_textAttribute8              VARCHAR2,
            p_textAttribute9              VARCHAR2,
            p_textAttribute10             VARCHAR2,
            p_textAttribute11             VARCHAR2,
            p_textAttribute12             VARCHAR2,
            p_textAttribute13             VARCHAR2,
            p_textAttribute14             VARCHAR2,
            p_textAttribute15             VARCHAR2,
            p_textAttribute16             VARCHAR2,
            p_textAttribute17             VARCHAR2,
            p_textAttribute18             VARCHAR2,
            p_textAttribute19             VARCHAR2,
            p_textAttribute20             VARCHAR2,
            p_formAttribute1              VARCHAR2,
            p_formAttribute2              VARCHAR2,
            p_formAttribute3              VARCHAR2,
            p_formAttribute4              VARCHAR2,
            p_formAttribute5              VARCHAR2,
            p_formAttribute6              VARCHAR2,
            p_formAttribute7              VARCHAR2,
            p_formAttribute8              VARCHAR2,
            p_formAttribute9              VARCHAR2,
            p_formAttribute10             VARCHAR2,
            p_urlAttribute1               VARCHAR2,
            p_urlAttribute2               VARCHAR2,
            p_urlAttribute3               VARCHAR2,
            p_urlAttribute4               VARCHAR2,
            p_urlAttribute5               VARCHAR2,
            p_urlAttribute6               VARCHAR2,
            p_urlAttribute7               VARCHAR2,
            p_urlAttribute8               VARCHAR2,
            p_urlAttribute9               VARCHAR2,
            p_urlAttribute10              VARCHAR2,
            p_dateAttribute1              DATE,
            p_dateAttribute2              DATE,
            p_dateAttribute3              DATE,
            p_dateAttribute4              DATE,
            p_dateAttribute5              DATE,
            p_dateAttribute6              DATE,
            p_dateAttribute7              DATE,
            p_dateAttribute8              DATE,
            p_dateAttribute9              DATE,
            p_dateAttribute10             DATE,
            p_numberAttribute1            NUMBER,
            p_numberAttribute2            NUMBER,
            p_numberAttribute3            NUMBER,
            p_numberAttribute4            NUMBER,
            p_numberAttribute5            NUMBER,
            p_numberAttribute6            NUMBER,
            p_numberAttribute7            NUMBER,
            p_numberAttribute8            NUMBER,
            p_numberAttribute9            NUMBER,
            p_numberAttribute10           NUMBER,
            p_protectedTextAttribute1     VARCHAR2,
            p_protectedTextAttribute2     VARCHAR2,
            p_protectedTextAttribute3     VARCHAR2,
            p_protectedTextAttribute4     VARCHAR2,
            p_protectedTextAttribute5     VARCHAR2,
            p_protectedTextAttribute6     VARCHAR2,
            p_protectedTextAttribute7     VARCHAR2,
            p_protectedTextAttribute8     VARCHAR2,
            p_protectedTextAttribute9     VARCHAR2,
            p_protectedTextAttribute10    VARCHAR2,
            p_protectedTextAttribute11    VARCHAR2,
            p_protectedTextAttribute12    VARCHAR2,
            p_protectedTextAttribute13    VARCHAR2,
            p_protectedTextAttribute14    VARCHAR2,
            p_protectedTextAttribute15    VARCHAR2,
            p_protectedTextAttribute16    VARCHAR2,
            p_protectedTextAttribute17    VARCHAR2,
            p_protectedTextAttribute18    VARCHAR2,
            p_protectedTextAttribute19    VARCHAR2,
            p_protectedTextAttribute20    VARCHAR2,
            p_protectedFormAttribute1     VARCHAR2,
            p_protectedFormAttribute2     VARCHAR2,
            p_protectedFormAttribute3     VARCHAR2,
            p_protectedFormAttribute4     VARCHAR2,
            p_protectedFormAttribute5     VARCHAR2,
            p_protectedFormAttribute6     VARCHAR2,
            p_protectedFormAttribute7     VARCHAR2,
            p_protectedFormAttribute8     VARCHAR2,
            p_protectedFormAttribute9     VARCHAR2,
            p_protectedFormAttribute10    VARCHAR2,
            p_protectedUrlAttribute1      VARCHAR2,
            p_protectedUrlAttribute2      VARCHAR2,
            p_protectedUrlAttribute3      VARCHAR2,
            p_protectedUrlAttribute4      VARCHAR2,
            p_protectedUrlAttribute5      VARCHAR2,
            p_protectedUrlAttribute6      VARCHAR2,
            p_protectedUrlAttribute7      VARCHAR2,
            p_protectedUrlAttribute8      VARCHAR2,
            p_protectedUrlAttribute9      VARCHAR2,
            p_protectedUrlAttribute10     VARCHAR2,
            p_protectedDateAttribute1     DATE,
            p_protectedDateAttribute2     DATE,
            p_protectedDateAttribute3     DATE,
            p_protectedDateAttribute4     DATE,
            p_protectedDateAttribute5     DATE,
            p_protectedDateAttribute6     DATE,
            p_protectedDateAttribute7     DATE,
            p_protectedDateAttribute8     DATE,
            p_protectedDateAttribute9     DATE,
            p_protectedDateAttribute10    DATE,
            p_protectedNumberAttribute1   NUMBER,
            p_protectedNumberAttribute2   NUMBER,
            p_protectedNumberAttribute3   NUMBER,
            p_protectedNumberAttribute4   NUMBER,
            p_protectedNumberAttribute5   NUMBER,
            p_protectedNumberAttribute6   NUMBER,
            p_protectedNumberAttribute7   NUMBER,
            p_protectedNumberAttribute8   NUMBER,
            p_protectedNumberAttribute9   NUMBER,
            p_protectedNumberAttribute10  NUMBER,
            p_title                       VARCHAR2,
            p_titleResourceKey            VARCHAR2,
            p_identificationKey           VARCHAR2,
            p_workflowDescriptorURI       VARCHAR2,
            p_taskDefinitionId            VARCHAR2,
            p_taskDefinitionName          VARCHAR2,
            p_applicationContext          VARCHAR2,
            p_applicationName             VARCHAR2,
            p_category                    VARCHAR2,
            p_componentName               VARCHAR2,
            p_compositeDN                 VARCHAR2,
            p_compositeInstanceId         VARCHAR2,
            p_compositeName               VARCHAR2,
            p_compositeVersion            VARCHAR2,
            p_conversationId              VARCHAR2,
            p_dueDate                     DATE,
            p_ecId                        VARCHAR2,
            p_isPublic                    VARCHAR2,
            p_isTestTask                  VARCHAR2,
            p_parentComponentInstanceId   VARCHAR2,
            p_parentComponentInstRefId    VARCHAR2,
            p_invokedComponent            VARCHAR2,
            p_participantName             VARCHAR2,
            p_percentageComplete          NUMBER,
            p_readByUsers                 VARCHAR2,
            p_startDate                   DATE,
            p_parentTaskVersion           NUMBER,
            p_taskGroupInstanceId         VARCHAR2,
            p_subTaskGroupInstanceId      VARCHAR2,
            p_agRootId                    NUMBER,
            p_agMileStonePath             VARCHAR2,
            p_rootTaskId                  VARCHAR2,
            p_parentTaskId                VARCHAR2,
            p_systemStringActions         VARCHAR2,
            p_taskDisplayUrl              VARCHAR2,
            p_documentPackageId           VARCHAR2,
            p_subCategory                 VARCHAR2,
            p_correlationId               VARCHAR2,
            p_stage                       VARCHAR2,
            p_assignmentContext           VARCHAR2,
            p_preActionUserSteps          VARCHAR2,
            p_aggregationTaskId           VARCHAR2,
            p_mdsLabel                    VARCHAR2,
            p_isTemplateTask              VARCHAR2,
            p_componentType               VARCHAR2,
            p_activityName                VARCHAR2,
            p_activityId                  VARCHAR2,
            p_processDueDate              DATE,
            p_thread                      INTEGER,
            p_parentThread                INTEGER,
            p_step                        INTEGER,
            p_taskNamespace               VARCHAR2,
            p_timers                      VARCHAR2,
            p_vrcValues                   VARCHAR2,
            p_organizationalUnitId        VARCHAR2,
            p_compositeCreatedTime        TIMESTAMP,
            p_tenantId                    VARCHAR2,
            p_listBuilderId               VARCHAR2,
            p_caseId                      VARCHAR2,
            p_swimlaneRole                VARCHAR2,
            p_excludedParticipants        VARCHAR2,
            p_customAttributeString1    VARCHAR2,
            p_customAttributeString2    VARCHAR2,
            p_customAttributeNumber1    NUMBER,
            p_customAttributeNumber2    NUMBER,
            p_customAttributeDate1      DATE,
            p_customAttributeDate2      DATE,
            p_timersSuspended           VARCHAR2,
            p_tenant_id                 NUMBER,
            p_isDecomposedTask          VARCHAR2,
            p_formName                  VARCHAR2,
            p_decomposedTaskGrpInstanceId VARCHAR2,
            p_startTime                 TIMESTAMP,
            p_stopTime                  TIMESTAMP,
            p_workingduration           INTEGER,
            p_shortSummary              VARCHAR2,
            p_longSummary               VARCHAR2,
            p_COMPONENT_INSTANCE_ID       INTEGER,
            p_FLOW_ID                   INTEGER,
            p_SCA_PARTITION_ID          INTEGER,
            /** p_IsVersionable should be the last parameter **/
            p_IsVersionable               VARCHAR2
            ) IS
            v_notm NUMBER;
            BEGIN
            /**
            As caller already increments notm value call lock method
            by decrementing notm value
            */
            lockWFTask(p_taskId, p_numberOfTimesModified-1);
            UPDATE  /*+ INDEX(WFTask WFTask(taskId)) */ WFTask SET
            acquiredBy = p_acquiredBy,
            assignees = p_assignees,
            assigneesDisplayName = p_assigneesDisplayName,
            reviewers = p_reviewers,
            reviewersDisplayName = p_reviewersDisplayName,
            callbackContext = p_callbackContext,
            callbackId = p_callbackId,
            callbackType = p_callbackType,
            creator = p_creator,
            digitalSignatureRequired = p_digitalSignatureRequired,
            expirationDate = p_expirationDate,
            expirationDuration = p_expirationDuration,
            identityContext = p_identityContext,
            ownerUser = p_ownerUser,
            ownerGroup = p_ownerGroup,
            ownerRole = p_ownerRole,
            passwordRequiredOnUpdate = p_passwordRequiredOnUpdate,
            priority = p_priority,
            domainId = p_domainId,
            instanceId = p_instanceId,
            processId = p_processId,
            processName = p_processName,
            processType = p_processType,
            processVersion = p_processVersion,
            secureNotifications = p_secureNotifications,
            accessKey = p_accessKey,
            approvalDuration = p_approvalDuration,
            approvers = p_approvers,
            assignedDate = p_assignedDate,
            createdDate = p_createdDate,
            elapsedTime = p_elapsedTime,
            endDate = p_endDate,
            fromUser = p_fromUser,
            fromUserDisplayName = p_fromUserDisplayName,
            hasSubtask = p_hasSubtask,
            inShortHistory = p_inShortHistory,
            isGroup = p_isGroup,
            language = p_language,
            mailStatus = p_mailStatus,
            numberOfTimesModified = p_numberOfTimesModified,
            originalAssigneeUser = p_originalAssigneeUser,
            outcome = p_outcome,
            parallelOutcomeCount = p_parallelOutcomeCount,
            pushbackSequence = p_pushbackSequence,
            State = p_State,
            SubState = p_SubState,
            systemString1 = p_systemString1,
            systemString2 = p_systemString2,
            SystemString3 = p_SystemString3,
            taskGroupId = p_taskGroupId,
            taskNumber = p_taskNumber,
            updatedBy = p_updatedBy,
            updatedByDisplayName = p_updatedByDisplayName,
            updatedDate = p_updatedDate,
            updatedNotificationId = p_updatedNotificationId,
            version = p_version,
            versionReason = p_versionReason,
            workflowPattern = p_workflowPattern,
            textAttribute1 = p_textAttribute1,
            textAttribute2 = p_textAttribute2,
            textAttribute3 = p_textAttribute3,
            textAttribute4 = p_textAttribute4,
            textAttribute5 = p_textAttribute5,
            textAttribute6 = p_textAttribute6,
            textAttribute7 = p_textAttribute7,
            textAttribute8 = p_textAttribute8,
            textAttribute9 = p_textAttribute9,
            textAttribute10 = p_textAttribute10,
            textAttribute11 = p_textAttribute11,
            textAttribute12 = p_textAttribute12,
            textAttribute13 = p_textAttribute13,
            textAttribute14 = p_textAttribute14,
            textAttribute15 = p_textAttribute15,
            textAttribute16 = p_textAttribute16,
            textAttribute17 = p_textAttribute17,
            textAttribute18 = p_textAttribute18,
            textAttribute19 = p_textAttribute19,
            textAttribute20 = p_textAttribute20,
            formAttribute1 = p_formAttribute1,
            formAttribute2 = p_formAttribute2,
            formAttribute3 = p_formAttribute3,
            formAttribute4 = p_formAttribute4,
            formAttribute5 = p_formAttribute5,
            formAttribute6 = p_formAttribute6,
            formAttribute7 = p_formAttribute7,
            formAttribute8 = p_formAttribute8,
            formAttribute9 = p_formAttribute9,
            formAttribute10 = p_formAttribute10,
            urlAttribute1 = p_urlAttribute1,
            urlAttribute2 = p_urlAttribute2,
            urlAttribute3 = p_urlAttribute3,
            urlAttribute4 = p_urlAttribute4,
            urlAttribute5 = p_urlAttribute5,
            urlAttribute6 = p_urlAttribute6,
            urlAttribute7 = p_urlAttribute7,
            urlAttribute8 = p_urlAttribute8,
            urlAttribute9 = p_urlAttribute9,
            urlAttribute10 = p_urlAttribute10,
            dateAttribute1 = p_dateAttribute1,
            dateAttribute2 = p_dateAttribute2,
            dateAttribute3 = p_dateAttribute3,
            dateAttribute4 = p_dateAttribute4,
            dateAttribute5 = p_dateAttribute5,
            dateAttribute6 = p_dateAttribute6,
            dateAttribute7 = p_dateAttribute7,
            dateAttribute8 = p_dateAttribute8,
            dateAttribute9 = p_dateAttribute9,
            dateAttribute10 = p_dateAttribute10,
            numberAttribute1 = p_numberAttribute1,
            numberAttribute2 = p_numberAttribute2,
            numberAttribute3 = p_numberAttribute3,
            numberAttribute4 = p_numberAttribute4,
            numberAttribute5 = p_numberAttribute5,
            numberAttribute6 = p_numberAttribute6,
            numberAttribute7 = p_numberAttribute7,
            numberAttribute8 = p_numberAttribute8,
            numberAttribute9 = p_numberAttribute9,
            numberAttribute10 = p_numberAttribute10,
            protectedTextAttribute1 = p_protectedTextAttribute1,
            protectedTextAttribute2 = p_protectedTextAttribute2,
            protectedTextAttribute3 = p_protectedTextAttribute3,
            protectedTextAttribute4 = p_protectedTextAttribute4,
            protectedTextAttribute5 = p_protectedTextAttribute5,
            protectedTextAttribute6 = p_protectedTextAttribute6,
            protectedTextAttribute7 = p_protectedTextAttribute7,
            protectedTextAttribute8 = p_protectedTextAttribute8,
            protectedTextAttribute9 = p_protectedTextAttribute9,
            protectedTextAttribute10 = p_protectedTextAttribute10,
            protectedTextAttribute11 = p_protectedTextAttribute11,
            protectedTextAttribute12 = p_protectedTextAttribute12,
            protectedTextAttribute13 = p_protectedTextAttribute13,
            protectedTextAttribute14 = p_protectedTextAttribute14,
            protectedTextAttribute15 = p_protectedTextAttribute15,
            protectedTextAttribute16 = p_protectedTextAttribute16,
            protectedTextAttribute17 = p_protectedTextAttribute17,
            protectedTextAttribute18 = p_protectedTextAttribute18,
            protectedTextAttribute19 = p_protectedTextAttribute19,
            protectedTextAttribute20 = p_protectedTextAttribute20,
            protectedFormAttribute1 = p_protectedFormAttribute1,
            protectedFormAttribute2 = p_protectedFormAttribute2,
            protectedFormAttribute3 = p_protectedFormAttribute3,
            protectedFormAttribute4 = p_protectedFormAttribute4,
            protectedFormAttribute5 = p_protectedFormAttribute5,
            protectedFormAttribute6 = p_protectedFormAttribute6,
            protectedFormAttribute7 = p_protectedFormAttribute7,
            protectedFormAttribute8 = p_protectedFormAttribute8,
            protectedFormAttribute9 = p_protectedFormAttribute9,
            protectedFormAttribute10 = p_protectedFormAttribute10,
            protectedUrlAttribute1 = p_protectedUrlAttribute1,
            protectedUrlAttribute2 = p_protectedUrlAttribute2,
            protectedUrlAttribute3 = p_protectedUrlAttribute3,
            protectedUrlAttribute4 = p_protectedUrlAttribute4,
            protectedUrlAttribute5 = p_protectedUrlAttribute5,
            protectedUrlAttribute6 = p_protectedUrlAttribute6,
            protectedUrlAttribute7 = p_protectedUrlAttribute7,
            protectedUrlAttribute8 = p_protectedUrlAttribute8,
            protectedUrlAttribute9 = p_protectedUrlAttribute9,
            protectedUrlAttribute10 = p_protectedUrlAttribute10,
            protectedDateAttribute1 = p_protectedDateAttribute1,
            protectedDateAttribute2 = p_protectedDateAttribute2,
            protectedDateAttribute3 = p_protectedDateAttribute3,
            protectedDateAttribute4 = p_protectedDateAttribute4,
            protectedDateAttribute5 = p_protectedDateAttribute5,
            protectedDateAttribute6 = p_protectedDateAttribute6,
            protectedDateAttribute7 = p_protectedDateAttribute7,
            protectedDateAttribute8 = p_protectedDateAttribute8,
            protectedDateAttribute9 = p_protectedDateAttribute9,
            protectedDateAttribute10 = p_protectedDateAttribute10,
            protectedNumberAttribute1 = p_protectedNumberAttribute1,
            protectedNumberAttribute2 = p_protectedNumberAttribute2,
            protectedNumberAttribute3 = p_protectedNumberAttribute3,
            protectedNumberAttribute4 = p_protectedNumberAttribute4,
            protectedNumberAttribute5 = p_protectedNumberAttribute5,
            protectedNumberAttribute6 = p_protectedNumberAttribute6,
            protectedNumberAttribute7 = p_protectedNumberAttribute7,
            protectedNumberAttribute8 = p_protectedNumberAttribute8,
            protectedNumberAttribute9 = p_protectedNumberAttribute9,
            protectedNumberAttribute10 = p_protectedNumberAttribute10,
            title = p_title,
            titleResourceKey = p_titleResourceKey,
            identificationKey = p_identificationKey,
            workflowDescriptorURI = p_workflowDescriptorURI,
            taskDefinitionId = p_taskDefinitionId,
            taskDefinitionName = p_taskDefinitionName,
            applicationContext = p_applicationContext,
            applicationName = p_applicationName,
            category = p_category,
            componentName = p_componentName,
            compositeDN = p_compositeDN,
            compositeInstanceId = p_compositeInstanceId,
            compositeName = p_compositeName,
            compositeVersion = p_compositeVersion,
            conversationId = p_conversationId,
            dueDate = p_dueDate,
            ecId = p_ecId,
            isPublic = p_isPublic,
            isTestTask = p_isTestTask,
            parentComponentInstanceId = p_parentComponentInstanceId,
            parentComponentInstRefId = p_parentComponentInstRefId,
            invokedComponent = p_invokedComponent,
            participantName = p_participantName,
            percentageComplete = p_percentageComplete,
            readByUsers = p_readByUsers,
            startDate = p_startDate,
            parentTaskVersion = p_parentTaskVersion,
            taskGroupInstanceId = p_taskGroupInstanceId,
            subTaskGroupInstanceId = p_subTaskGroupInstanceId,
            agRootId = p_agRootId,
            agMileStonePath = p_agMileStonePath,
            rootTaskId = p_rootTaskId,
            parentTaskId = p_parentTaskId,
            systemStringActions = p_systemStringActions,
            taskDisplayUrl = p_taskDisplayUrl,
            documentPackageId = p_documentPackageId,
            subCategory = p_subCategory,
            correlationId = p_correlationId,
            stage = p_stage,
            assignmentContext = p_assignmentContext,
            preActionUserSteps = p_preActionUserSteps,
            aggregationTaskId = p_aggregationTaskId,
            mdsLabel = p_mdsLabel,
            isTemplateTask = p_isTemplateTask,
            componentType =  p_componentType,
            activityName  =  p_activityName,
            activityId    =  p_activityId,
            processDueDate = p_processDueDate,
            thread =  p_thread,
            parentThread =  p_parentThread,
            step = p_step,
            taskNamespace = p_taskNamespace,
            timers = p_timers,
            vrcValues = p_vrcValues,
            organizationalUnitId = p_organizationalUnitId,
            tenantId = p_tenantId,
            listBuilderId = p_listBuilderId,
            caseId = p_caseId,
            swimlaneRole = p_swimlaneRole,
            excludedParticipants = p_excludedParticipants,
            customAttributeString1 = p_customAttributeString1,
            customAttributeString2 = p_customAttributeString2,
            customAttributeNumber1 = p_customAttributeNumber1,
            customAttributeNumber2 = p_customAttributeNumber2,
            customAttributeDate1 = p_customAttributeDate1,
            customAttributeDate2 = p_customAttributeDate2,
            timersSuspended = p_timersSuspended,
            tenant_id = p_tenant_id,
            isDecomposedTask=p_isDecomposedTask,
            formName=p_formName,
            decomposedTaskGrpInstanceId=p_decomposedTaskGrpInstanceId,
            startTime=p_startTime,
            stopTime=p_stopTime,
            workingduration=p_workingduration,
            shortSummary=p_shortSummary,
            longSummary=p_longSummary,
            COMPONENT_INSTANCE_ID=p_COMPONENT_INSTANCE_ID,
            FLOW_ID=p_FLOW_ID,
            SCA_PARTITION_ID=p_SCA_PARTITION_ID
            WHERE taskID = p_taskId;

            IF p_IsVersionable =  BOOLEAN_TRUE_STRING THEN
            createHistory(p_taskID);
            END IF;

            EXCEPTION
            WHEN  v_lockException THEN
            RAISE_APPLICATION_ERROR(v_lockErrorNumber,'Task is locked for update',true);
            WHEN  v_deletedException THEN
            RAISE_APPLICATION_ERROR(v_deletedErrorNumber,'Task is deleted',true);
            WHEN v_modifiedException THEN
            RAISE_APPLICATION_ERROR(v_modifiedErrorNumber,'Task is modified',true);
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_updateErrorNumber,'Error while updating the task',true);
            END updateTask;


            PROCEDURE insertTaskAggregation (
            p_rootTaskId               VARCHAR,
            p_id                       VARCHAR,
            p_assignee                 VARCHAR,
            p_stage                    VARCHAR,
            p_aggregationType          VARCHAR,
            p_collectionName           VARCHAR,
            p_xpath                    VARCHAR,
            p_targetIndex              NUMBER,
            p_keyList                  VARCHAR,
            p_action                   VARCHAR,
            p_actionParams             VARCHAR,
            p_updatedBy                VARCHAR,
            p_updatedDate              DATE,
            p_compositeCreatedTime      TIMESTAMP
            ) IS
            BEGIN
            INSERT INTO WFTaskAggregation(
            rootTaskId,
            id,
            assignee,
            stage,
            aggregationType,
            collectionName,
            xpath,
            targetIndex,
            keyList,
            action,
            actionParams,
            updatedBy,
            updatedDate,
            compositeCreatedTime,
            numberOfTimesModified
            ) VALUES (
            p_rootTaskId,
            p_id,
            p_assignee,
            p_stage,
            p_aggregationType,
            p_collectionName,
            p_xpath,
            p_targetIndex,
            p_keyList,
            p_action,
            p_actionParams,
            p_updatedBy,
            p_updatedDate,
            p_compositeCreatedTime,
            1);
            EXCEPTION
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_insertErrorNumber,'Error while inserting task aggregation',true);
            END;

            /**
            To lock the WFTaskAggregation table
            */

            PROCEDURE lockWFTaskAggregation(
            p_id VARCHAR,
            p_notm   NUMBER
            ) IS
            v_notm NUMBER;
            BEGIN
            BEGIN
            SELECT numberOfTimesModified INTO v_notm
            FROM WFTaskAggregation WHERE id = p_id FOR UPDATE NOWAIT;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
            RAISE v_deletedException;
            WHEN OTHERS THEN
            RAISE v_lockException;
            END;
            IF v_notm != p_notm THEN
            RAISE v_modifiedException;
            END IF;
            END lockWFTaskAggregation;


            PROCEDURE updateTaskAggregation (
            p_id                       VARCHAR,
            p_aggregationTaskId        VARCHAR,
            p_action                   VARCHAR,
            p_actionParams             VARCHAR,
            p_updatedBy                VARCHAR,
            p_updatedDate              DATE,
            p_numberOfTimesModified    NUMBER
            ) IS
            v_notm NUMBER;
            BEGIN

            /**
            As caller already increments notm value call lock method
            by decrementing notm value
            */
            lockWFTaskAggregation(p_id, p_numberOfTimesModified-1);

            UPDATE WFTaskAggregation SET
            aggregationTaskId = p_aggregationTaskId,
            action = p_action,
            actionParams = p_actionParams,
            updatedBy = p_updatedBy,
            updatedDate = p_updatedDate,
            numberOfTimesModified = p_numberOfTimesModified

            WHERE id = p_id;

            EXCEPTION
            WHEN  v_lockException THEN
            RAISE_APPLICATION_ERROR(v_lockErrorNumber,'Task aggregation is locked for update',true);
            WHEN  v_deletedException THEN
            RAISE_APPLICATION_ERROR(v_deletedErrorNumber,'Task aggregation is deleted',true);
            WHEN v_modifiedException THEN
            RAISE_APPLICATION_ERROR(v_modifiedErrorNumber,'Task aggregation is modified',true);
            WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(v_updateErrorNumber,'Error while updating task aggregation',true);
            END;


            END WFTaskpkg_121200;
/
