	Rem
	Rem $Header: pcbpel/admin/sqlutils12/upgrade/oracle/soa_migrate.sql /st_pcbpel_12.2.1.4.0soabp/2 2024/08/08 15:38:24 apfwkr Exp $
	Rem
	Rem soa_mig.sql
	Rem
Rem Copyright (c) 2013, 2024, Oracle and/or its affiliates. 
Rem All rights reserved.
	Rem
	Rem    NAME
	Rem      soa_mig.sql - <one-line expansion of the name>
	Rem
	Rem    DESCRIPTION
	Rem      <short description of component this file declares/defines>
	Rem
	Rem    NOTES
	Rem      <other useful comments, qualifications, etc.>
	Rem
	Rem    MODIFIED   (MM/DD/YY)
    Rem    apfwkr      08/08/24 - CI# 36927594 of
    Rem    apfwkr      08/08/24 - apfwkr_blr_backport_36434213_12.2.1.4.240404soabp
    Rem                           from st_pcbpel_12.2.1.4.0soabp
    Rem    apfwkr      06/01/24 - BLR# 36684850 of
    Rem    apfwkr      06/01/24 - linlxu_bug-36434213_1221_main .
    Rem    apfwkr      06/01/24 - BLR# 36684850
    Rem    apfwkr      06/01/24 - apfwkr_blr_backport_36434213_12.2.1.4.240404soabp
    Rem                           from main
    Rem    apfwkr      02/22/24 - CI# 36329889 of
    Rem    apfwkr      02/22/24 - linlxu_blr_backport_33808201_12.2.1.4.230827soabp
    Rem                           from st_pcbpel_12.2.1.4.0soabp
    Rem    linlxu      12/04/23 - BLR# 36073346 of
    Rem    linlxu      12/04/23 - linlxu_bug-36044643_1221_12.2.1.4.230827 from
    Rem    linlxu      12/04/23 - st_pcbpel_12.2.1.4.0soabp.
    Rem    linlxu      12/04/23 - BLR# 36073346
    Rem                           linlxu_blr_backport_33808201_12.2.1.4.230827soabp
    Rem    ykotecha    03/14/17 - Backport ambbaner_bug-23041569_1221_dlv_fix
    Rem                           from main
    Rem    ykotecha    12/13/16 - Bug fix 24964490
    Rem    ykotecha    10/25/16 - Bug fix 24913000
	Rem    ambbaner    02/21/14 - Bug fix 18266511
	Rem    ambbaner    01/09/14 - Bug fix 17694077
	Rem    ambbaner    01/02/14 - Bug fix 17979056
	Rem    ambbaner    12/20/13 - Bug fix 17732966
	Rem    ambbaner    12/06/13 - Changes for ondemand upgrade,
	Rem                           component_fault_key generation for bpel callback
	Rem                           recovery.
	Rem    ambbaner    11/22/13 - Bug fix 17789287,17693974,disable AUDIT_TRAIL
	Rem                           update, composite label changes
	Rem    ssudarsa    07/09/13 - Created
	Rem
	Rem    BEGIN SQL_FILE_METADATA
	Rem    SQL_SOURCE_FILE: pcbpel/admin/sqlutils/upgrade/soa_migrate.sql
	Rem    SQL_SHIPPED_FILE:
	Rem    SQL_PHASE:
	Rem    SQL_STARTUP_MODE: NORMAL
	Rem    SQL_IGNORABLE_ERRORS: NONE
	Rem    SQL_CALLING_FILE:
	Rem    END SQL_FILE_METADATA

       
	-------------------------BPEL TYPES -------------------------------------
	create or replace type bpel_fault_type as object 
	(

	    bpel_fault_name varchar2(255),
	    bpel_fault_typ varchar2(255),
	    bpel_fault_message CLOB,
	    bpel_node_id varchar2(200),
	    bpel_scope_id varchar2(1024),
	    bpel_count_id number,
	    bpel_creation_date timestamp,
	    bpel_modify_date timestamp,
	    bpel_cikey number,
	    bpel_component_name varchar2(300),
	  constructor function bpel_fault_type return self as result

	)
	/
	show errors;
	create or replace type body bpel_fault_type as 

	  constructor function bpel_fault_type return self as result is
	  begin
	    return;
	  end bpel_fault_type;
	end;
	/
	show errors;
	create or replace type dlv_msg_type as object
	(
	   dlv_type number, 
	   message_guid varchar2(50),
	   component_name varchar2(300),
	   cikey number, 
	   receive_date timestamp,
	   conv_id varchar2(256),
	   domain_name varchar2(50),
	   composite_name varchar2(500),
	   composite_revision varchar2(50),
	   composite_label varchar2(50), 
	   state number,
	   component_type varchar2(10),
	   constructor function dlv_msg_type return self as result,
	   constructor function dlv_msg_type(dlv_type number, message_guid varchar2, component_name varchar2, cikey number,
	   receive_date timestamp,conv_id varchar2,domain_name varchar2,composite_name varchar2,composite_revision varchar2,composite_label varchar2,
	   state number,component_type varchar2) return self as result
	)
	/
	show errors;

	create or replace type dlv_msg_type as object
	(
	   dlv_type number, 
	   message_guid varchar2(50),
	   component_name varchar2(300),
	   cikey number, 
	   receive_date timestamp,
	   conv_id varchar2(256),
	   domain_name varchar2(50),
	   composite_name varchar2(500),
	   composite_revision varchar2(50),
	   composite_label varchar2(50), 
	   state number,
	   component_type varchar2(10),
	   constructor function dlv_msg_type return self as result,
	   constructor function dlv_msg_type(dlv_type number, message_guid varchar2, component_name varchar2, cikey number,
	   receive_date timestamp,conv_id varchar2,domain_name varchar2,composite_name varchar2,composite_revision varchar2,composite_label varchar2,
	   state number,component_type varchar2) return self as result
	)
	/
	show errors;

	create or replace type body dlv_msg_type as 

	  constructor function dlv_msg_type return self as result is
	  begin
	    return;
	  end dlv_msg_type;
	   constructor function dlv_msg_type(dlv_type number, message_guid varchar2, component_name varchar2, cikey number,
	   receive_date timestamp,conv_id varchar2,domain_name varchar2,composite_name varchar2,composite_revision varchar2, composite_label varchar2,
	   state number,component_type varchar2) return self as result is
	   begin
	      SELF.dlv_type := dlv_type;
	      SELF.message_guid := message_guid;
	      SELF.component_name := component_name;
	      SELF.cikey := cikey; 
	      SELF.receive_date := receive_date;
	      SELF.conv_id := conv_id;
	      SELF.domain_name := domain_name;
	      SELF.composite_name := composite_name;
	      SELF.composite_revision := composite_revision;
		  SELF.composite_label := composite_label;
              SELF.state := state;
		  SELF.component_type := component_type;
	     return;
	  end dlv_msg_type;
	end;
	/
	show errors;

	create or replace type work_item_type as object
	(
	   cikey number, 
	   component_name varchar2(300),
	   state number,
	   partition_date timestamp, 
	   node_id varchar2(200),
	   scope_id varchar2(1024),
	   count_id number,
       exp_flag number,
       exp_date timestamp,
	   component_type varchar2(10),
	   constructor function work_item_type return self as result,
	   constructor function work_item_type(cikey number, component_name varchar2,state  number, node_id varchar2,     
	      scope_id varchar2,count_id number,exp_flag number ,exp_date timestamp,component_type varchar2,partition_date timestamp) return self as result
	)
	/
	show errors;

	create or replace type body work_item_type as 

	  constructor function work_item_type return self as result is
	  begin
	    return;
	  end work_item_type;
	   constructor function work_item_type(cikey number, component_name varchar2,state  number, node_id varchar2,     
	      scope_id varchar2,count_id number,exp_flag number ,exp_date timestamp,component_type varchar2,partition_date timestamp) return self as result is
	   begin
	      SELF.cikey := cikey;
	      SELF.component_name := component_name;
          SELF.state := state;
	     
	      SELF.node_id := node_id;
	      SELF.scope_id := scope_id;
	      SELF.count_id := count_id;
          SELF.exp_flag := exp_flag; 
	      SELF.exp_date := exp_date;	
		  SELF.component_type := component_type;
		  SELF.partition_date := partition_date;
	     return;
	  end work_item_type;
	end;
	/
	show errors;
	create or replace type wif_type as object
	(
	   fault_name varchar2(255), 
	   fault_type varchar2(300),
	   message clob,
	   node_id varchar2(200),
	   scope_id varchar2(1024),
	   count_id number,
	   creation_date timestamp, 
	   modify_date timestamp,
	   cikey number,	   
	   component_name varchar2(300),
	   component_state number,
	   component_type varchar2(10),
	   constructor function wif_type return self as result,
	   constructor function wif_type(fault_name varchar2, fault_type varchar2,message clob,node_id varchar2,scope_id varchar2,count_id number ,
	   	creation_date timestamp, modify_date timestamp ,cikey number ,component_name varchar ,component_state number,component_type varchar2 ) return self as result
	)
	/
	show errors;

	create or replace type body wif_type as 

	  constructor function wif_type return self as result is
	  begin
	    return;
	  end wif_type;
	  
	   constructor function wif_type(fault_name varchar2, fault_type varchar2,message clob,node_id varchar2,scope_id varchar2,count_id number ,
	   	creation_date timestamp, modify_date timestamp ,cikey number ,component_name varchar ,component_state number,component_type varchar2 ) return self as result is
	   begin
	      SELF.cikey := cikey;
	      SELF.component_name := component_name;
	      SELF.node_id := node_id;
	      SELF.scope_id := scope_id;
	      SELF.count_id := count_id;
      	      SELF.creation_date := creation_date; 
       	      SELF.modify_date := modify_date; 
       	      SELF.fault_name := fault_name;
     	      SELF.fault_type := fault_type;
       	      SELF.message := message;
			  SELF.component_state := component_state;
			  SELF.component_type := component_type;
	     return;
	  end wif_type;
	end;
	/
	show errors;
				

	create or replace package soa_migrate as

	  type sca_partition_table_id is table of number index by varchar2(50);

	  type sca_entity_table_type is table of sca_entity_type;
    
	  type ecid_list_type is table of varchar2(100);
	  
	  type processed_dlv_message IS TABLE OF VARCHAR2(50) INDEX BY VARCHAR2(50);

	  type processed_cikey_type IS TABLE OF number INDEX BY varchar2(50);

          TYPE upgrade_progress_log_rec_type is record (
           RUN number,
           CREATION_DATE timestamp,
           MODULE varchar2(40),
           MSG_TYPE varchar2(5),
           REMAINING number,
           UPG_COMMENT varchar2(80));
	  
	  cursor dlv_msg_query is select dlv_type, message_guid, component_name, cikey, receive_date,conv_id,domain_name,
	      composite_name,composite_revision from dlv_message where ecid in (select ecid from TEMP_UPGRADE_ECID ) and state in
	                  (0,1,4);
	  type sca_flow_to_cpst_table_type is table of sca_flow_to_cpst_type;
          type dlv_msg_table_type is table of dlv_msg_type index by varchar2(200);
          type work_item_table_type is table of work_item_type index by varchar2(100);          
          FUNCTION dlv_msg_table_type_const RETURN dlv_msg_table_type ;
          FUNCTION work_item_table_type_const RETURN work_item_table_type ;          
	  function migrate_ecid( ecid in varchar2,
                                 log_file IN utl_file.file_type default null,
			     flow_id in integer default 0,
				 flow_correlation_id  in varchar2 default null,
				 component_id_val in varchar2 default null,
				 component_dn in varchar2 default null,
				 component_fault_key_val in varchar2 default null,
				 engine_type in varchar2 default null,
				-- commit_after_execution in boolean default true,
				-- dlv_msg_table in dlv_msg_table_type default dlv_msg_table_type_const(),
				-- work_item_table in work_item_table_type default work_item_table_type_const(),
				-- use_ci_temp_table in boolean default false ,                 
		                is_midtier_upgrade in boolean default true,
				mid_process_flow in integer default 0,
                                sca_partition_count in integer default 0,fa_env in boolean default false ) return varchar2;
				 
	procedure migrate_soa_metadata(batch_size in number default 10000,
				stoptime_v  in varchar2 default null,thread in integer default 0, sql_trace in varchar2 default 'FALSE' );
	function migrate_ecids(batch_size in number default 10000,is_migrate_metadata_reqd boolean default true,
	             stoptime  in date default null, max_count number default 0, thread in integer default -1, dop in integer default 1,log_file IN utl_file.file_type, sca_partition_count in integer, fa_env in boolean default false) return boolean ;


	 function populate_sca_entry(log_file IN utl_file.file_type, stoptime in date) return boolean;

	  function populate_sca_entry_for_comp(component_dn in varchar2,
						   component_type in varchar2,
						   component_sub_type in varchar2,
              log_file IN utl_file.file_type) return boolean;
                                                   
		procedure migrate_soa(batch_size in number default 10000,is_migrate_metadata_reqd in varchar default 'TRUE',
	                     is_data_migrate_reqd in varchar2 default 'TRUE',open_ecids_complete in 
		             varchar2 default 'FALSE',
		             stoptime_v  in varchar2 default null, max_count in number default 0, 
		             thread in integer default -1, dop in integer default 1,  sql_trace in varchar2 default 'FALSE' );
	end soa_migrate;
	/

	show errors;
	create or replace package body soa_migrate as

	-- Generate sca entry for the given component_dn if an entry doesnt exist
	function populate_sca_entry_for_comp(component_dn in varchar2,
						 component_type in varchar2,
						 component_sub_type in varchar2,
                                                 log_file IN utl_file.file_type)
						 return boolean as
	  participating_component_dn component_dn_type;
	  participating_composite_name varchar2(500);
	  participating_composite_rev varchar2(50);
	  participating_composite_label varchar2(500);
	  participating_composite_part varchar2(200);
	  participating_component_name varchar2(500);
	  participating_sca_partition_id integer := 0;
	  existing_composite_name varchar2(500);

	  sca_entity_id number;
	  sca_entity_count number := 0;
	  sca_entity_ids varchar(100) := 'SCA_ENTITY_IDS';

	  BEGIN
	    if component_dn is not null and LENGTH(component_dn) > 0 then
	      participating_component_dn := component_dn_type(component_dn);
	      participating_composite_name := participating_component_dn.composite_name;
	      participating_composite_rev := participating_component_dn.revision;
	      participating_composite_label := participating_component_dn.label;
	      participating_composite_part := participating_component_dn.partition_name;
	      participating_component_name := participating_component_dn.component_name;      

	      -- Retrieve partition id for the given partition name from sca_partition
	      select sp.id into participating_sca_partition_id from sca_partition sp 
			where sp.name=participating_composite_part;
	      BEGIN
	      select composite into existing_composite_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id 
		      and se.composite=participating_composite_name and se.name=participating_component_name and 
		      se.revision=participating_composite_rev; --and se.label=participating_composite_label;
	      EXCEPTION
		WHEN NO_DATA_FOUND THEN
		log_debug('sca entry doesnt exist for the component : ' || 
				      participating_component_name, log_file);                                     
	      END;
	      if existing_composite_name is not null then 
		log_debug('sca entry already exist for the component : ' ||
				      participating_component_name, log_file);
		return false; -- sca_entry already exists                      
	      -- if the entry is not found in the sca_entry, add those entries into sca_entry table                             
	      else
		-- Get the id to be added to sca_entry
		sca_entity_id := get_next_id(sca_entity_ids);

select count(*) into sca_entity_count from SCA_ENTITY
where SCA_PARTITION_ID = participating_sca_partition_id
and COMPOSITE = participating_composite_name
and REVISION = participating_composite_rev
and LABEL = participating_composite_label
and NAME = participating_component_name
and TYPE = component_type
and SUB_TYPE = component_sub_type
and STATE = 'active';
if sca_entity_count > 0 then
		log_debug('Inserted into sca_entity - SKIPPED: ' ||
				      ' id : ' || sca_entity_id ||
				      ' composite : ' || participating_composite_name ||
				      ' revision : ' || participating_composite_rev ||
				      ' label : ' || participating_composite_label ||
				      ' name : ' || participating_component_name ||
				      ' type : ' || component_type ||
				      ' subtype : ' || component_sub_type, log_file);
else
		INSERT INTO SCA_ENTITY
		(
		  ID,
		  SCA_PARTITION_ID,
		  COMPOSITE,
		  REVISION,
		  LABEL,
		  NAME,
		  TYPE,
		  SUB_TYPE,
		  STATE,
		  PROPERTIES
		)
		VALUES
		(
		  sca_entity_id,
		  participating_sca_partition_id,
		  participating_composite_name,
		  participating_composite_rev,
		  participating_composite_label,
		  participating_component_name,
		  component_type,
		  component_sub_type,
		  'active',
		  NULL                              
		);
		log_debug('Inserted into sca_entity : ' ||
				      ' composite : ' || participating_composite_name ||
				      ' revision : ' || participating_composite_rev ||
				      ' label : ' || participating_composite_label ||
				      ' name : ' || participating_component_name ||
				      ' type : ' || component_type ||
				      ' subtype : ' || component_sub_type , log_file);
		commit;
end if;

		return true; -- indicates sca entry added for the given component dn
	      end if;
	    end if;
	    return false;
	end populate_sca_entry_for_comp;

	function is_sca_entry_exists(composite_dn_val in varchar2, 
				      sca_partition_table_obj in sca_partition_table_id,
				      sca_entity_table in out sca_entity_table_type, 
                                      log_file IN utl_file.file_type) 
				      return boolean as
	  participating_composite_dn composite_dn_type;
	  participating_composite_name varchar2(500);
	  participating_composite_rev varchar2(50);
	  participating_composite_label varchar2(500);
	  participating_composite_part varchar2(200);
	  existing_composite_name varchar2(500);  
	  participating_sca_partition_id integer;
	  participating_composite_id integer := 0;

	  workflow_composite_dn composite_dn_type;
	  spring_component_dn component_dn_type;
	  mediator_component_dn component_dn_type;
	  reference_composite_dn  composite_dn_type;
	  cm_composite_dn composite_dn_type;

	  --workflow variables
	  workflow_composite_name varchar2(500);
	  workflow_composite_revision varchar2(50);
	  workflow_composite_label varchar2(500);
	  workflow_component_name varchar2(500);
	  
	  -- spring variables
	  spring_composite_name varchar2(500);
	  spring_composite_revision  varchar2(50);
	  spring_composite_label varchar2(500);
	  spring_component_name varchar2(500);
	  --mediator variables
	  mediator_composite_name varchar2(500);
	  mediator_composite_revision  varchar2(50);
	  mediator_composite_label varchar2(500);
	  mediator_component_name varchar2(500);
	  -- reference variables
	  reference_composite_name varchar2(500);
	  reference_composite_revision  varchar2(50);
	  reference_composite_label varchar2(500);
	  reference_component_name varchar2(500);

	  -- service variables
	  rejected_service_name varchar2(500);
	  rejected_binding_type varchar2(50);

	  --case management variables
	  cm_composite_name varchar2(500);
	  cm_composite_revision varchar2(50);
	  cm_composite_label varchar2(500);
	  cm_component_name varchar2(500);

	  bpel_component_name varchar2(500);
      dlv_component_name varchar2(500);
	  ref_component_name varchar2(500);
	  ref_service_name varchar2(500);
	  med_component_name varchar2(500);
	  wf_component_name varchar2(500);
	  br_component_name varchar2(500);
	  sp_component_name varchar2(500);
	  case_component_name varchar2(500);

	  cmp_ecid varchar2(500);

	  sca_entity_count integer := 0;  
	  sca_entity_id number;
	  sca_entity_ids varchar(100) := 'SCA_ENTITY_IDS';

	  sca_component_type varchar2(20) := 'component';
	  sca_composite_name varchar2(20) := 'composite';
	  sca_reference_name varchar2(10) := 'reference';
	  sca_service_name varchar2(10) := 'service';
	  sca_bpel_subtype varchar2(25) := 'implementation.bpel';
	  sca_bpmn_subtype varchar2(25) := 'implementation.bpmn';
	  sca_worflow_subtype varchar2(25) := 'implementation.workflow';
	  sca_decision_subtype varchar2(25) := 'implementation.decision';
	  sca_spring_subtype varchar2(25) := 'implementation.spring';
	  sca_mediator_subtype varchar2(25) := 'implementation.mediator';
	  sca_cm_subtype varchar2(50) := 'implementation.casemanagement';
	  var_impl_type varchar2(50) := sca_bpel_subtype;
	  composite_dn_val_like varchar2(510); --:= composite_dn_val || '%';
	  --composite_dn_val_med_like varchar2(510);
      is_sca_entry_exists boolean :=true;
          ecode number;
          emesg varchar2(300);       
	  label_not_found varchar2(50) := 'LABEL_NOT_FOUND';
	  begin 
	  
	 --new code
	 	participating_composite_dn := composite_dn_type(composite_dn_val); 
	 	participating_composite_name := participating_composite_dn.composite_name;
	 	participating_composite_part := participating_composite_dn.partition_name;
	 	participating_composite_rev := participating_composite_dn.revision;
	 	participating_composite_label := participating_composite_dn.label;
	 	participating_sca_partition_id := sca_partition_table_obj(participating_composite_part);
		composite_dn_val_like := participating_composite_dn.partition_name || '/' || participating_composite_name || '!'
                                             || participating_composite_rev || '%';
               
                --Services should be the first one to be upgraded - binding.jca, binding.ws and binding.b2b all of which use the rejected_message table
                BEGIN
		    FOR rej_mesg IN
        	       ( select distinct(service_name),binding_type from TEMP_UPGRADE_REJ_MSG_DN rejected_mesg where composite_dn like composite_dn_val_like 
    			 )
        	       LOOP
        		rejected_service_name := rej_mesg.service_name;
        		rejected_binding_type := rej_mesg.binding_type;
        		  BEGIN
				  ref_service_name := null;
        		  select se.name into ref_service_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
        		    and se.composite=participating_composite_name and se.name=rejected_service_name  
        		    and se.revision=participating_composite_rev --and se.label=participating_composite_label 
                    and type = 'service' and state = 'active' and rownum = 1;
        		  EXCEPTION
        		  WHEN NO_DATA_FOUND THEN
        		    log_debug('sca entry for service instance doesnt exist :  ' || rejected_service_name  || ',' || rejected_binding_type , log_file);
        		  END;
        		  if ref_service_name is not null then
        		    log_debug('sca entry already exists for the service instance : ' || rejected_service_name  || ',' || rejected_binding_type , log_file);
        		  else
        		    sca_entity_id := get_next_id(sca_entity_ids);
        		    sca_entity_count := sca_entity_count+1;
        		    sca_entity_table.EXTEND;
        		    sca_entity_table(sca_entity_count) := sca_entity_type
        					  (
        					    sca_entity_id,
        					    participating_sca_partition_id,
        					    participating_composite_name,
        					    participating_composite_rev,
        					    participating_composite_label,
        					    rejected_service_name, 
            					    sca_service_name,
            					    NULL,
	        				    'active',
	        				    NULL
	        				  );
                     is_sca_entry_exists :=false;         
	        	  end if;        
	               END LOOP;
                EXCEPTION
                    --Ignore if errors are encountered during service upgrade
                    WHEN OTHERS THEN
                        ecode := SQLCODE;
                        emesg := SQLERRM;
			log_error('SQL Error Code : ' || ecode ||
					     ' SQL Error Message : '  || emesg, log_file);
			log_error('error occured for the service upgrade for : ' || 
			      composite_dn_val, log_file);			
			insert into UPGRADE_ERROR_LOG values(1, systimestamp, composite_dn_val,9, ecode || ':' || emesg);
                        commit;
                END; 


		BEGIN
		select composite into existing_composite_name from sca_entity where sca_partition_id=participating_sca_partition_id 
		      and composite=participating_composite_name and type='composite' and revision=participating_composite_rev AND ROWNUM < 2;
		      --and label=participating_composite_label;
		EXCEPTION
		  WHEN NO_DATA_FOUND THEN
		    log_debug('sca entry for composite doesnt exist :  ' || participating_composite_name, log_file);          
		END;	
		if existing_composite_name is not null then        
		  -- For the given ecid, there exists an entry in sca_entity 
		  log_debug('sca entry already exists for the composite : ' || existing_composite_name, log_file);              
		 -- return true;
		else
		    sca_entity_id := get_next_id(sca_entity_ids);
		    sca_entity_count := sca_entity_count+1;
		    sca_entity_table.EXTEND;
		    sca_entity_table(sca_entity_count) := sca_entity_type
					  (
					  sca_entity_id,
					  sca_partition_table_obj(participating_composite_dn.partition_name),
					  participating_composite_name,
					  participating_composite_rev,
					  participating_composite_label,
					  NULL, -- component name for composite is null
					  sca_composite_name,
					  NULL, -- subttype null for composite
					  'active',
					  NULL  -- extra properties
					);
                    is_sca_entry_exists :=false;
		end if;   
		FOR bpel_inst IN
			       (select distinct(component_name),componenttype from TEMP_UPGRADE_CI_DN cui where 
			                composite_name = participating_composite_name and composite_revision  = participating_composite_rev -- and composite_label = participating_composite_label 
							and domain_name = participating_composite_dn.partition_name )
				LOOP
				  BEGIN
				  bpel_component_name := null;
				  select se.name into bpel_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
				    and se.composite=participating_composite_name and se.name=bpel_inst.component_name
				    and se.revision=participating_composite_rev and type = sca_component_type and (sub_type = sca_bpmn_subtype or sub_type = sca_bpel_subtype) AND ROWNUM < 2;-- and se.label=participating_composite_label;
				  EXCEPTION
				  WHEN NO_DATA_FOUND THEN
				    log_debug('sca entry for cube_instance doesnt exist :  ' || bpel_inst.component_name , log_file);
				  END;
				  if bpel_component_name is not null then
				    log_debug('sca entry already exists for the cube_instance : ' || bpel_inst.component_name ,log_file);
				   -- return true;
				  else
					if bpel_inst.componenttype = 'bpmn' then 
						var_impl_type := sca_bpmn_subtype;
					else 
						var_impl_type := sca_bpel_subtype;
					end if;
				    sca_entity_id := get_next_id(sca_entity_ids);
				    sca_entity_count := sca_entity_count+1;
				    sca_entity_table.EXTEND;
				    sca_entity_table(sca_entity_count) := sca_entity_type
							  (
							    sca_entity_id,
							    participating_sca_partition_id,
							    participating_composite_name,
							    participating_composite_rev,
							    participating_composite_label,
							    bpel_inst.component_name,
							    sca_component_type,
							    var_impl_type,
							    'active',
							    NULL  -- extra properties
							  );    
                    is_sca_entry_exists :=false;
				  end if;          
	       END LOOP;
           FOR dlv_instance IN
			       (select distinct(component_name),COMPONENT_TYPE from TEMP_UPGRADE_DLV_MSG_DN  where 
			                composite_name = participating_composite_name and composite_revision  = participating_composite_rev and
			                --composite_label = participating_composite_label and 
                            domain_name = participating_composite_dn.partition_name and component_name NOT IN  (
                            select component_name from TEMP_UPGRADE_CI_DN  where 
			                composite_name = participating_composite_name and composite_revision  = participating_composite_rev and
			                --composite_label = participating_composite_label and 
                            domain_name = participating_composite_dn.partition_name))
				LOOP
				  BEGIN
				  dlv_component_name := null;
				  select se.name into dlv_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
				    and se.composite=participating_composite_name and se.name=dlv_instance.component_name
				    and se.revision=participating_composite_rev  and type = sca_component_type and (sub_type = sca_bpmn_subtype or sub_type = sca_bpel_subtype);-- and se.label=participating_composite_label;
				  EXCEPTION
				  WHEN NO_DATA_FOUND THEN
				    log_debug('sca entry for dlv_message doesnt exist :  ' || dlv_instance.component_name , log_file);
				  END;
				  if dlv_component_name is not null then
				    log_debug('sca entry already exists for the dlv_message : ' || dlv_instance.component_name ,log_file);
				   -- return true;
				  else
                    
                        if dlv_instance.COMPONENT_TYPE = 'bpmn' then 
                            var_impl_type := sca_bpmn_subtype;
                        else 
                            var_impl_type := sca_bpel_subtype;
                        end if;
                        log_debug('Adding sca entity for dlv loop ',log_file);
                        sca_entity_id := get_next_id(sca_entity_ids);
                        sca_entity_count := sca_entity_count+1;
                        sca_entity_table.EXTEND;
                        sca_entity_table(sca_entity_count) := sca_entity_type
							  (
							    sca_entity_id,
							    participating_sca_partition_id,
							    participating_composite_name,
							    participating_composite_rev,
							    participating_composite_label,
							    dlv_instance.component_name,
							    sca_component_type,
							    var_impl_type,
							    'active',
							    NULL  -- extra properties
							  ); 
                        is_sca_entry_exists :=false;
                       end if;     
	       END LOOP;   
		FOR ref_inst IN
	       ( select distinct(reference_name) from TEMP_UPGRADE_REF_INST_DN ri where composite_dn like composite_dn_val_like 
			 )
	       LOOP
		reference_component_name := ref_inst.reference_name;
		  BEGIN
		  ref_component_name := null;
		  select se.name into ref_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
		    and se.composite=participating_composite_name and se.name=reference_component_name
		    and se.revision=participating_composite_rev and type = sca_reference_name  ;-- and se.label=participating_composite_label;
		  EXCEPTION
		  WHEN NO_DATA_FOUND THEN
		    log_debug('sca entry for reference instance doesnt exist :  ' || ref_inst.reference_name , log_file);
		  END;
		  if ref_component_name is not null then
		    log_debug('sca entry already exists for the reference instance : ' || ref_inst.reference_name , log_file);
		    --return true;
		  else
		    sca_entity_id := get_next_id(sca_entity_ids);
		    sca_entity_count := sca_entity_count+1;
		    sca_entity_table.EXTEND;
		    sca_entity_table(sca_entity_count) := sca_entity_type
					  (
					    sca_entity_id,
					    participating_sca_partition_id,
					    participating_composite_name,
					    participating_composite_rev,
					    participating_composite_label,
					    reference_component_name,
					    sca_reference_name,
					    NULL, -- subtype will be null for reference instances
					    'active',
					    NULL
					  );
             is_sca_entry_exists :=false;
		  end if;        
	       END LOOP;
               --orphaned mediator instances do not contain label. This creates inconsistencies between orphaned and non-orphaned
               -- component_dn. At runtime sca entity queries do not consider label at all. So, we do the same here, only for 
               -- mediator though 
     	       --composite_dn_val_med_like := participating_composite_dn.partition_name || '/' || participating_composite_name || '!'
                 --                            || participating_composite_rev || '%';
	       FOR med_inst IN
	       ( select distinct REGEXP_REPLACE(component_name,'\*(.[^/]*)', '') as component_dn_without_label from TEMP_UPGRADE_MI_DN mi where component_name like composite_dn_val_like)
	       LOOP
		  mediator_component_dn := component_dn_type(med_inst.component_dn_without_label);
		  mediator_component_name := mediator_component_dn.component_name;
		  log_debug('mediator component dn label: ' || mediator_component_dn.label , log_file);
		  BEGIN
		  med_component_name := null;
		  select se.name into med_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
		    and se.composite=participating_composite_name and se.name=mediator_component_name
		    and se.revision=participating_composite_rev and se.state = 'active'  and type = sca_component_type and sub_type = sca_mediator_subtype; -- and se.label=mediator_component_dn.label ;
		  EXCEPTION
		  WHEN NO_DATA_FOUND THEN
		    log_debug('sca entry for mediator instance doesnt exist :  ' || mediator_component_name , log_file);
		  END;
		  if med_component_name is not null then
		    log_debug('sca entry already exists for mediator instance :  ' || mediator_component_name , log_file);
		   -- return true;
		  else
		    -- store mediator component instances into sca_entity
		    sca_entity_id := get_next_id(sca_entity_ids);
		    sca_entity_count := sca_entity_count+1;
		    sca_entity_table.EXTEND;
		    sca_entity_table(sca_entity_count) := sca_entity_type
					  (
					    sca_entity_id,
					    participating_sca_partition_id,
					    participating_composite_name,
					    participating_composite_rev,
					    participating_composite_label,
					    mediator_component_name,
					    sca_component_type,
					    sca_mediator_subtype,
					    'active',
					    NULL
					  );
             is_sca_entry_exists :=false;         
		  end if;
		END LOOP;
	      FOR wf_inst IN
	      ( select distinct componentname from TEMP_UPGRADE_WFTASK_DN wf where wf.compositedn like composite_dn_val_like and (componenttype = 'Workflow'  OR componenttype is null) )
	       LOOP  
	       workflow_component_name := wf_inst.componentname;
		  BEGIN
		  wf_component_name := null;
		  select se.name into wf_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
		    and se.composite=participating_composite_name and se.name=workflow_component_name
		    and se.revision=participating_composite_rev and type = sca_component_type and sub_type = sca_worflow_subtype;-- and se.label=participating_composite_label;
		  EXCEPTION
		  WHEN NO_DATA_FOUND THEN
		    log_debug('sca entry for workflow instance doesnt exist :  ' || workflow_component_name , log_file);
		  END;
		  if wf_component_name is not null then
		    log_debug('sca entry already exists for workflow instance :  ' || workflow_component_name , log_file);
		   -- return true;
		  else
		    sca_entity_id := get_next_id(sca_entity_ids);
		    sca_entity_count := sca_entity_count+1;
		    sca_entity_table.EXTEND;
		    sca_entity_table(sca_entity_count) := sca_entity_type
					  (
					    sca_entity_id,
					    participating_sca_partition_id,
					    participating_composite_name,
					    participating_composite_rev,
					    participating_composite_label,
					    workflow_component_name,
					    sca_component_type,
					    sca_worflow_subtype,
					    'active',
					    NULL  -- extra properties
					  );
             is_sca_entry_exists :=false;         
		  end if;
	      END LOOP;	
	      	      FOR brd_inst IN
	      	       ( select distinct component_name  from TEMP_UPGRADE_BRDECINST_DN brd where 
	      	       brd.composite_name=participating_composite_name and brd.revision= participating_composite_rev )--and   brd.label = participating_composite_label)
	      	      LOOP
	      		  BEGIN
				  br_component_name := null;
	      		  select se.name into br_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
	      		    and se.composite=participating_composite_name and se.name=brd_inst.component_name
	      		    and se.revision=participating_composite_rev  and type = sca_component_type and sub_type = sca_decision_subtype; --and se.label=participating_composite_label;
	      		  EXCEPTION
	      		  WHEN NO_DATA_FOUND THEN
	      		    log_debug('sca entry for decision instance doesnt exist :  ' || brd_inst.component_name , log_file);
	      		  END;
	      		  if br_component_name is not null then
	      		    log_debug('sca entry already exists for decision instance :  ' || brd_inst.component_name , log_file);
	      		   -- return true;
	      		  else
	      		    -- store business rules instances in sca_entity
	      		    sca_entity_id := get_next_id(sca_entity_ids);
	      		    sca_entity_count := sca_entity_count+1;
	      		    sca_entity_table.EXTEND;
	      		    sca_entity_table(sca_entity_count) := sca_entity_type
	      					  (
	      					    sca_entity_id,
	      					    participating_sca_partition_id,
	      					    participating_composite_name,
	                                            participating_composite_rev,
	                                            participating_composite_label,
	      					    brd_inst.component_name,
	      					    sca_component_type,
	      					    sca_decision_subtype,
	      					    'active',
	      					    NULL
	      					  );
                    is_sca_entry_exists :=false;          
	      		  end if;
		END LOOP;
	       FOR comp_inst IN
	       ( select distinct component_dn from TEMP_UPGRADE_CPNTINST_DN coi where coi.component_dn like composite_dn_val_like )
	       LOOP
	        spring_component_dn := component_dn_type(comp_inst.component_dn);
		spring_component_name := spring_component_dn.component_name;
		  BEGIN
		  sp_component_name := null;
		  select se.name into sp_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
		    and se.composite=participating_composite_name and se.name=spring_component_name
		    and se.revision=participating_composite_rev and type = sca_component_type and sub_type = sca_spring_subtype;-- and se.label=participating_composite_label;
		  EXCEPTION
		  WHEN NO_DATA_FOUND THEN
		    log_debug('sca entry for spring component intstance doesnt exist :  ' || spring_component_name , log_file);
		  END;
		  if sp_component_name is not null then
		    log_debug('sca entry already exists for spring component instance :  ' || spring_component_name , log_file);
		  --  return true;
		  else
		    -- store spring component instances into sca_entity
		    sca_entity_id := get_next_id(sca_entity_ids);
		    sca_entity_count := sca_entity_count+1;
		    sca_entity_table.EXTEND;
		    sca_entity_table(sca_entity_count) := sca_entity_type
					  (
					    sca_entity_id,
					    participating_sca_partition_id,
					    participating_composite_name,
					    participating_composite_rev,
					    participating_composite_label,
					    spring_component_name,
					    sca_component_type,
					    sca_spring_subtype,
					    'active',
					    NULL
					  );
             is_sca_entry_exists :=false;         
		  end if;
		END LOOP;
		FOR cm_inst IN
	      ( select distinct component_name from TEMP_UPGRADE_CM_CASE_HDR_DN case_header where composite_dn like composite_dn_val_like)
	       LOOP  
                 cm_component_name := cm_inst.component_name;
                 BEGIN
		  case_component_name := null;
		  select se.name into case_component_name from sca_entity se where se.sca_partition_id=participating_sca_partition_id
		    and se.composite=participating_composite_name and se.name=cm_component_name
		    and se.revision=participating_composite_rev and type = sca_component_type and sub_type = sca_cm_subtype ;-- and se.label=participating_composite_label;
		  EXCEPTION
		  WHEN NO_DATA_FOUND THEN
		    log_debug('sca entry for case management instance does not exist :  ' || cm_component_name, log_file );
		  END;
		  if case_component_name is not null then
		    log_debug('sca entry already exists for case management instance :  ' || cm_component_name, log_file );
		    return true;
		  else
		    sca_entity_id := get_next_id(sca_entity_ids);
		    sca_entity_count := sca_entity_count+1;
		    sca_entity_table.EXTEND;
		    sca_entity_table(sca_entity_count) := sca_entity_type
					  (
					    sca_entity_id,
					    participating_sca_partition_id,
					    participating_composite_name,
					    participating_composite_rev,
					    participating_composite_label,
					    cm_component_name,
					    sca_component_type,
					    sca_cm_subtype,
					    'active',
					    NULL  -- extra properties
					  );
             is_sca_entry_exists :=false;
		  end if;
	      END LOOP;	
              
	    return is_sca_entry_exists;
	  end is_sca_entry_exists;

PROCEDURE  insert_upgrade_progress_log(
    upgrade_progress_log_rec in upgrade_progress_log_rec_type
                   )
   is

  error_no number;
  run_currval number;
  RUN_v number;
  CREATION_DATE_v timestamp;
  MODULE_v varchar(40);
  MSG_TYPE_v varchar(5);
  REMAINING_v number;
  UPG_COMMENT_v varchar2(80);

 begin

     error_no := 0;
     MSG_TYPE_v := upgrade_progress_log_rec.msg_type;
     IF MSG_TYPE_V != 'SEQ' THEN
        select remaining into run_currval 
          from  upgrade_progress_log
         where  msg_type='SEQ';
     END IF;
     RUN_V := run_currval;
     CREATION_DATE_v := systimestamp;
     MODULE_v := upgrade_progress_log_rec.module;
     UPG_COMMENT_v := upgrade_progress_log_rec.upg_comment;
     REMAINING_v :=  upgrade_progress_log_rec.remaining;

     BEGIN
       insert into upgrade_progress_log
       (
        RUN, CREATION_DATE, MODULE, MSG_TYPE, REMAINING, UPG_COMMENT
       )
        VALUES
      (
       RUN_V, CREATION_DATE_v, MODULE_v, MSG_TYPE_v, REMAINING_v, UPG_COMMENT_v
      );
      commit;

      EXCEPTION
        when others then
            error_no := -1;

     END;

     IF error_no = -1 THEN
        log_debug('ERROR within insert_upgrade_progress_log ');
     ELSE
        log_debug('insert_upgrade_progress_log RUN: ' || RUN_V 
         || ', creation_date: ' || CREATION_DATE_v ||  ', module : ' 
         || MODULE_v || ', msg_type : ' || MSG_TYPE_v || ', remaining : ' 
         || REMAINING_v || ', comment : ' || UPG_COMMENT_v);
     END IF;

 end insert_upgrade_progress_log;

 PROCEDURE  insert_upgrade_progress_info(
             module varchar2,
             upg_comment varchar2)
  is

  upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

    log_debug(upg_comment);   
    upgrade_progress_log_rec.msg_type := 'INFO';
    upgrade_progress_log_rec.module := module;
    upgrade_progress_log_rec.remaining := 0;
    upgrade_progress_log_rec.upg_comment := upg_comment;
    insert_upgrade_progress_log(upgrade_progress_log_rec);

 end insert_upgrade_progress_info;


function populate_sca_entry(log_file IN utl_file.file_type, stoptime in date) return boolean is 
    participating_composite_dn composite_dn_type;
    sca_entity_ids varchar(100) := 'SCA_ENTITY_IDS';
    sca_partition_id number;
    sca_entity_count number := 0;
    partition_name varchar2(100);  
    sca_partition_table_obj sca_partition_table_id; 
    cmp_ecid varchar2(500);

    sca_entry_exists boolean := false;  
    sca_entity_table sca_entity_table_type := sca_entity_table_type();
    sca_entity_obj sca_entity_type;
    ecode number;
    emesg varchar2(300);   
    error_stack varchar2(300);
    error_info varchar2(100);
    num_sca_part number := 0;

    begin  
    -- Iterate over sca_partition and store the id and name in a table, used later while inserting into sca_entity table
    FOR sca_partition_inst IN
    ( select id,name from sca_partition )
    LOOP
        sca_partition_table_obj(sca_partition_inst.name) := sca_partition_inst.id;
        log_debug('sca_partition_name : ' || sca_partition_inst.name || ' sca_partition_id : ' || sca_partition_inst.id, log_file);
    END LOOP;
    IF (sysdate >= stoptime) then
        return false;
    end if;  
    IF is_stop_injected = true then
        log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
        return false;
    end if;    
    For ci_inst IN ( select composite_dn from TEMP_COMPOSITEDN_UPGRADE order by max_created_time desc)
    LOOP
        BEGIN   
            sca_entity_table.delete;
            log_debug('Distinct composite DN : ' || ci_inst.composite_dn, log_file);
            participating_composite_dn := composite_dn_type(ci_inst.composite_dn);
            partition_name := participating_composite_dn.partition_name;
            select count(*) into num_sca_part from sca_partition sc  where composite_dn_type(ci_inst.composite_dn).partition_name = sc.name;
            if (num_sca_part < 1) then       
                sca_partition_id := get_next_id(sca_entity_ids);
                sca_partition_table_obj(partition_name) := sca_partition_id;
                INSERT INTO SCA_PARTITION
                (
                    ID,
                    NAME
                )
                values
                (
                    sca_partition_id,
                    partition_name
                );
                log_debug('Insert into sca_partition :' ||  ' sca_partition_id ' || sca_partition_id
                    || ' partition_name ' || partition_name, log_file);                                   
            end if;
            sca_entry_exists := is_sca_entry_exists(ci_inst.composite_dn,sca_partition_table_obj,sca_entity_table, log_file);
            log_debug('out of polupate', log_file); --remove
            if sca_entry_exists = TRUE then
                log_debug('sca entry exists for the given composite_dn : ' || ci_inst.composite_dn, log_file);
            end if;

            -- If a sca_entity entry doesn't exist for the given ecid, then add those 
            --  entries to the sca_entity
            if sca_entry_exists != TRUE then      
                log_debug('insertingg',log_file); --remove
                -- LOOP through sca_entity table and do insertion
                if sca_entity_table.count > 0 then
                    FOR i IN sca_entity_table.FIRST..sca_entity_table.LAST 
                    LOOP
                        sca_entity_obj := sca_entity_table(i);
                        log_debug(sca_entity_obj.sca_partition_id,log_file); --remove
                        log_debug(sca_entity_obj.composite,log_file); --remove
                        log_debug(sca_entity_obj.revision,log_file); --remove
                        log_debug(sca_entity_obj.label,log_file); --remove    
                        log_debug(sca_entity_obj.name,log_file); --remove    
                        log_debug(sca_entity_obj.type,log_file); --remove           	        
                        
select count(*) into sca_entity_count from SCA_ENTITY
where SCA_PARTITION_ID = sca_entity_obj.sca_partition_id
and COMPOSITE = sca_entity_obj.composite
and REVISION = sca_entity_obj.revision
and LABEL = sca_entity_obj.label
and NAME = sca_entity_obj.name
and TYPE = sca_entity_obj.type
and SUB_TYPE = sca_entity_obj.subtype
and STATE = sca_entity_obj.state;
if sca_entity_count > 0 then
                        log_debug('Inserted into sca_entity - SKIPPED : ' ||                              
                            ' id : ' || sca_entity_obj.id ||
                            ' composite : ' || sca_entity_obj.composite ||
                            ' revision : ' || sca_entity_obj.revision ||
                            ' label : ' || sca_entity_obj.label ||
                            ' name : ' || sca_entity_obj.name ||
                            ' type : ' || sca_entity_obj.type || 
                            ' subtype : ' || sca_entity_obj.subtype || 
                            ' state : ' || sca_entity_obj.state, log_file);
else
                            INSERT INTO SCA_ENTITY
                            (
                                ID,
                                SCA_PARTITION_ID,
                                COMPOSITE,
                                REVISION,
                                LABEL,
                                NAME,
                                TYPE,
                                SUB_TYPE,
                                STATE,
                                PROPERTIES
                            )
                            VALUES
                            (
                                sca_entity_obj.id,
                                sca_entity_obj.sca_partition_id,
                                sca_entity_obj.composite,
                                sca_entity_obj.revision,
                                sca_entity_obj.label,
                                sca_entity_obj.name,
                                sca_entity_obj.type,
                                sca_entity_obj.subtype,
                                sca_entity_obj.state,
                                sca_entity_obj.properties
                            );
                        log_debug('Inserted into sca_entity : ' ||                              
                            ' composite : ' || sca_entity_obj.composite ||
                            ' revision : ' || sca_entity_obj.revision ||
                            ' label : ' || sca_entity_obj.label ||
                            ' name : ' || sca_entity_obj.name ||
                            ' type : ' || sca_entity_obj.type || 
                            ' subtype : ' || sca_entity_obj.subtype || 
                            ' state : ' || sca_entity_obj.state, log_file);
end if;

                    END LOOP; -- end of sca_entity insertion
                end if;
            end if;   
            commit;
            sca_entity_table := sca_entity_table_type();
            IF (sysdate >= stoptime) then
                return false;
            end if;   
            IF is_stop_injected = true then
                log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
                return false;
            end if; 
        EXCEPTION 
        WHEN OTHERS THEN 
            ecode := SQLCODE;
            emesg := SQLERRM; 
            ROLLBACK; -- on the occurence of exception, rollback the current transcation
            error_stack := crop_error_stack(DBMS_UTILITY.format_error_backtrace,300,log_file);
            error_info := crop_error_stack('Metadata:'||ci_inst.composite_dn,100,log_file);
            log_error('SQL Error Code : ' || ecode || ' SQL Error Message : '  || emesg, log_file);
            log_error('Error occured while migrate metadata for  ' || ci_inst.composite_dn, log_file);
            insert into UPGRADE_ERROR_LOG values(0, systimestamp, error_info,9, ecode || ':' || emesg || ';' || error_stack );
            commit;
        END;
    END LOOP; -- end of TEMP_COMPOSITEDN_UPGRADE loop
    return true; 
end populate_sca_entry;


	function is_fa_env return boolean as
	 schema_name varchar2(128);
         begin
          SELECT sys_context('USERENV', 'CURRENT_SCHEMA') into schema_name FROM DUAL;
	  if UPPER(TRIM(schema_name)) = 'FA_FUSION_SOAINFRA' then
	     return true;
	  end if;
	  return false;
	end is_fa_env;

	function is_num(p_str in varchar2) return boolean as
	begin
	  if regexp_instr(p_str, '^[[:space:]]*[[:digit:]]{1,5}[[:space:]]*$') > 0 then
	    return true;
	  end if;

	  return false;
	end is_num;
	
	function bool_to_text (p_bool in boolean) return varchar2
	      is
	      begin
		return case when p_bool then 'TRUE'
			    when not p_bool then 'FALSE'
			    else 'NULL'
		      end;
	     end bool_to_text;
	function get_next_composite_id(log_file IN utl_file.file_type) return number
	is
	  ret_id number := 0;
	  begin
	     log_debug('into get_next_composite_id', log_file); 
	    --TODO change the logic to sca_sequence and upgrade_seq. This will fail if the stored proc is 
	    --executed multiple times in parallel
	     log_debug('ret_d ' || ret_id, log_file);
	      BEGIN
		  select max(id)into ret_id from composite_instance;
		       log_debug('ret_d ' || ret_id, log_file);
	      EXCEPTION
		   WHEN NO_DATA_FOUND THEN
		      ret_id := 0;
			   log_debug('ret_d ' || ret_id, log_file);
	      END;
		   log_debug('ret_d ' || ret_id, log_file);
	      if ret_id is null then
		  ret_id :=1;
	      else
		 ret_id := ret_id +1;
	      end if;	 
	      log_debug('ret_d ' || ret_id, log_file);
	      return ret_id;
	 end  get_next_composite_id;
	 
	procedure truncate_temp_tables as
        BEGIN
          --workaround for DB bug-32938174, replaceing truncates with delete
	  --execute immediate 'truncate table TEMP_UPGRADE_ECID'; 
	  --execute immediate 'truncate table TEMP_UPGRADE_CI';	
	  --execute immediate 'truncate table TEMP_UPGRADE_WFTASK';	
	  --execute immediate 'truncate table TEMP_UPGRADE_BRDECISION';	
	  --execute immediate 'truncate table TEMP_UPGRADE_MI';	
	  --execute immediate 'truncate table TEMP_UPGRADE_MCI';
	  --execute immediate 'truncate table TEMP_UPGRADE_MCDV';
          --execute immediate 'truncate table TEMP_UPGRADE_CPST_INST';  
          --execute immediate 'truncate table TEMP_UPGRADE_DLV_MSG';  
          --execute immediate 'truncate table TEMP_UPGRADE_DLV_ECID_MAP';
          --execute immediate 'truncate table TEMP_UPGRADE_WKITM_CI'; 
            execute immediate 'delete from TEMP_UPGRADE_ECID';
            execute immediate 'delete from TEMP_UPGRADE_CI';
            execute immediate 'delete from TEMP_UPGRADE_WFTASK';
            execute immediate 'delete from TEMP_UPGRADE_BRDECISION';
            execute immediate 'delete from TEMP_UPGRADE_MI';
            execute immediate 'delete from TEMP_UPGRADE_MCI';
            execute immediate 'delete from TEMP_UPGRADE_MCDV';
            execute immediate 'delete from TEMP_UPGRADE_CPST_INST';
            execute immediate 'delete from TEMP_UPGRADE_DLV_MSG';
            execute immediate 'delete from TEMP_UPGRADE_DLV_ECID_MAP';
            execute immediate 'delete from TEMP_UPGRADE_WKITM_CI';
            execute immediate 'commit';
	END truncate_temp_tables;

	--------------------------BPEL Functions ------------------------------------------------------------------------------------	 
	function get_c_key_for_invoke(compositeDN in varchar2, component_name in varchar2, message_guid in varchar2, log_file IN utl_file.file_type) return varchar2 is 
		correlation_key varchar2(2000);
		corr_key_props correlation_key_props := correlation_key_props();
		delivery_message_val varchar2(80);
		component_name_val varchar2(320); 
		composite_dn_val varchar2(1260);
		begin
		   delivery_message_val  := length(corr_key_props.DLV_MSG_GUID) || ' ' || corr_key_props.get_dlv_message_guid() ||
				    length(message_guid) || ' ' || message_guid ;
		   delivery_message_val := length(delivery_message_val) || ' ' || delivery_message_val;
		   component_name_val  := length(corr_key_props.CMPNT_NAME) || ' ' || corr_key_props.CMPNT_NAME ||
				    length(component_name) ||' ' ||  component_name ;
		   component_name_val := length(component_name_val) || ' ' || component_name_val;
		   composite_dn_val  := length(corr_key_props.CMPST_DN) || ' ' || corr_key_props.CMPST_DN ||
				    length(compositeDN) ||' ' ||  compositeDN ;
		   composite_dn_val := length(composite_dn_val) || ' ' || composite_dn_val;
			   correlation_key := delivery_message_val || component_name_val || composite_dn_val;
			   log_debug('correlation key for bpel invoke = ' || correlation_key, log_file);
			   return correlation_key; 
		end get_c_key_for_invoke;

	function get_c_key_for_callback(compositeDN in varchar2, component_name in varchar2, message_guid in varchar2, state in number, subscriberId 
	  in varchar2, conversationID in varchar2, conversation_type in number,  log_file IN utl_file.file_type) return varchar2 is 
		correlation_key varchar2(2000);
		corr_key_props correlation_key_props := correlation_key_props();
		delivery_message_val varchar2(80);
		component_name_val varchar2(320); 
		composite_dn_val varchar2(1260);
			state_val varchar2(18);
			--subscriber_id_val varchar2(1055);
			conv_id_val  varchar2(285);
		    conv_type_val varchar2(30);

		begin
		   delivery_message_val  := length(corr_key_props.DLV_MSG_GUID) || ' ' || corr_key_props.get_dlv_message_guid() ||
				    length(message_guid) || ' ' || message_guid ;
		   delivery_message_val := length(delivery_message_val) || ' ' || delivery_message_val;
		   component_name_val  := length(corr_key_props.CMPNT_NAME) || ' ' || corr_key_props.CMPNT_NAME ||
				    length(component_name) ||' ' ||  component_name ;
		   component_name_val := length(component_name_val) || ' ' || component_name_val;
		   composite_dn_val  := length(corr_key_props.CMPST_DN) || ' ' || corr_key_props.CMPST_DN ||
				    length(compositeDN) ||' ' ||  compositeDN ;
		   composite_dn_val := length(composite_dn_val) || ' ' || composite_dn_val;
			   --state_val := length(corr_key_props.CORR_STATE) || ' ' || corr_key_props.CORR_STATE ||
					     -- length(state) || ' ' || state;
				--state_val := length(state_val) || ' ' || state_val;	
			   --subscriber_id_val := length(corr_key_props.SUBSCRIBER_ID) || ' ' || corr_key_props.SUBSCRIBER_ID ||
				--	     length(subscriberId) || ' ' || subscriberId;
				--subscriber_id_val := length(subscriber_id_val) || ' ' || subscriber_id_val;
			    conv_id_val := length(corr_key_props.CONV_ID) || ' ' || corr_key_props.CONV_ID ||
					     length(conversationId) || ' ' || conversationId;
				conv_id_val := length(conv_id_val) || ' ' || conv_id_val;
			    conv_type_val := length(corr_key_props.CONV_TYPE) || ' ' || corr_key_props.CONV_TYPE ||
					     length(conversation_type) || ' ' || conversation_type;
				conv_type_val := length(conv_type_val) || ' ' || conv_type_val;	
				--removed subscriber_id_val as from recent bpel logic it has been removed.
				--removed state_val. 
				--In 11g, state might be in 0(STATE_UNRESOLVED), During upgrade, we create fault key based on that.
				--Post upgrade, failure retries will change state to 4(STATE_MAX_RECOVERED).
				--In these use case we will not be able to fetch upgraded properties based on component fault key.
				--For any use case where state is required, those are to be recovered from bpel recovery console.
				correlation_key := conv_id_val || component_name_val || composite_dn_val || delivery_message_val || conv_type_val ;
				log_debug('correlation key for bpel callback = ' || correlation_key, log_file);
	   return correlation_key; 
	end get_c_key_for_callback;

	function get_c_key_for_activity(compositeDN in varchar2, component_name in varchar2, cikey in number, node_id in  varchar2, scope_id in varchar, count_id in number) return varchar2 is 
		correlation_key varchar2(2000);
	    activity_key_sep varchar2(1) := '-';

		begin
			correlation_key := compositeDN || '/' || component_name || '/' || cikey || '-' || node_id || '-' || scope_id || '-' || count_id ;
			return correlation_key;
	   return correlation_key; 
	end get_c_key_for_activity;

	procedure update_flow_ids_workflow(ecid_val in varchar, flow_id_val in number,cmpst_id_val in number default 0,log_file IN utl_file.file_type) is
	BEGIN
    log_debug('Updating wftask with flow_id: ' || to_char(flow_id_val) || ':ecid:' || ecid_val || ':cmpst_id_val:'||to_char(cmpst_id_val), log_file);
		  FOR wf_inst IN
			  ( 
			      select /*+ INDEX(TEMP_UPGRADE_WFTASK ECID_TEMP_UPG_WFTASK_IDX) */ taskid from TEMP_UPGRADE_WFTASK where ecid = ecid_val )
			  LOOP 
              log_debug('Updating wftask with taskid: ' ||wf_inst.taskid , log_file);
				  if cmpst_id_val != 0 then	
					  update wftask set flow_id = flow_id_val, compositeinstanceid = cmpst_id_val where taskid = wf_inst.taskid;
				  else
					  update wftask set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  end if;
				  update Wfheaderprops set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wfroutingslip set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wfassignee set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wfattachment set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wfmessageattribute set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wftaskhistory_Tl set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wftaskhistory set flow_id = flow_id_val where taskid = wf_inst.taskid;
				  update Wftask_Tl set flow_id = flow_id_val where taskid = wf_inst.taskid;
		      END LOOP; 
	end update_flow_ids_workflow;

procedure update_flow_ids_bpel(ecid_val in varchar, flow_id_val in number,log_file IN utl_file.file_type,  cmpst_id_val in number default 0,
	sca_flow_to_cpst_table in sca_flow_to_cpst_table_type default null,is_orphaned_case in boolean default true,m_sca_partition_id in number default 0, sca_partition_count in integer default 0 ) is
    
    dlv_msg_guid varchar2(50);
    cikey_for_update number;
    sca_partition_id_val number := 0;
    sca_flow_to_cpst_obj sca_flow_to_cpst_type;
    -- though the follwoing 2 queries in the cursor looks odd, its required for ensuring that if the current dlv_message(or cube_instance) row is locked, the other dlv_messages sharing
    -- the same ecid are updated
    cursor dlv_msg_update(param_msg_guid varchar2) is select message_guid from dlv_message  where message_guid = param_msg_guid for update NOWAIT;
    cursor cube_inst_update(param_cikey varchar2) is select cikey from cube_instance  where cikey = param_cikey for update NOWAIT;
    
    BEGIN
    
    update dlv_message set flow_id = flow_id_val where ecid = ecid_val;
    
    --for dlv_msg_loop in (select /*+ INDEX(TEMP_UPGRADE_DLV_MSG ECID_TEMP_UPGRADE_DLV_MSG) */ message_guid from TEMP_UPGRADE_DLV_MSG where ecid = ecid_val)
    --Loop
        --log_debug('Updating DLV MESSSAGE with message_guid: ' || dlv_msg_loop.message_guid , log_file);
       -- begin
            --open dlv_msg_update(dlv_msg_loop.message_guid);
            --fetch dlv_msg_update into dlv_msg_guid;
            --update dlv_message set flow_id = flow_id_val where current of dlv_msg_update;
            --close dlv_msg_update;
        --end;
    --end loop;

    if (is_orphaned_case = true) then 
        for cube_inst_loop in (select cikey ,cmpst_id from cube_instance where ecid = ecid_val)
        Loop
            begin
                open cube_inst_update(cube_inst_loop.cikey);
                fetch cube_inst_update into cikey_for_update ;
                update cube_instance set flow_id = flow_id_val, cmpst_id = cmpst_id_val,SCA_PARTITION_ID = m_sca_partition_id   where current of cube_inst_update;
                close cube_inst_update;
            end;    
        end loop;
    else

      
       if (sca_partition_count = 1) then
           -- sending name null because it will pickup first id as there is only one id
           cache_util.get_cache_query_type_4_output(name => NULL, sca_partition_id => sca_partition_id_val);
           update cube_instance set flow_id = flow_id_val, sca_partition_id = sca_partition_id_val where ecid = ecid_val;
       else

           update cube_instance set flow_id = flow_id_val where ecid = ecid_val;
      
           for sca_partition_loop in (select id,name from SCA_PARTITION)
           Loop
           begin
             update cube_instance set sca_partition_id = sca_partition_loop.id where ecid = ecid_val and domain_name = sca_partition_loop.name;
           end;
           end loop;
        end if;

        --for cube_inst_loop in (select /*+ INDEX(TEMP_UPGRADE_CI ECID_TEMP_UPG_CI_IDX) */ cikey ,composite_id from TEMP_UPGRADE_CI where ecid = ecid_val)
        --Loop
        --begin
            --if sca_flow_to_cpst_table is not null AND sca_flow_to_cpst_table.COUNT > 0 then
                --FOR i IN sca_flow_to_cpst_table.FIRST..sca_flow_to_cpst_table.LAST 
                --LOOP
                    --sca_flow_to_cpst_obj := sca_flow_to_cpst_table(i);
                    --if(sca_flow_to_cpst_obj.composite_id = cube_inst_loop.composite_id) then
                        --sca_partition_id_val := sca_flow_to_cpst_obj.sca_partition_id;
                        --EXIT;
                    --end if;
                --END LOOP;
            --END IF;
            --open cube_inst_update(cube_inst_loop.cikey);
            --fetch cube_inst_update into cikey_for_update ;
            --update cube_instance set flow_id = flow_id_val , sca_partition_id = sca_partition_id_val where current of cube_inst_update;
            --update cube_instance set flow_id = flow_id_val, sca_partition_id = sca_partition_id_val where ecid = ecid_val;
            --close cube_inst_update;
        --end;    
        --end loop;

    end if ;
end update_flow_ids_bpel;

procedure update_cmpst_ids_mediator(ecid_val in varchar, cmpst_id_val in number default 0) is
	BEGIN
	   if cmpst_id_val != 0 then	
		update mediator_instance set composite_instance_id = cmpst_id_val where ecid = ecid_val;
	   end if;
end update_cmpst_ids_mediator;

procedure populate_wf_common_fault
	(
		component_name IN varchar2,
		comp_fault_key_val IN VARCHAR2,
		cikey_val IN NUMBER, 
		composite_id_val NUMBER,
		fault_name_val IN VARCHAR2,
		fault_type_val IN VARCHAR2,
		error_message_val IN VARCHAR2,
		state_val IN NUMBER,
		creation_date_val IN TIMESTAMP,
		error_code_val IN VARCHAR2,
		sca_flow_to_cpst_obj IN SCA_FLOW_TO_CPST_TYPE,
		log_file IN utl_file.file_type,
        composite_dn in varchar2,
        is_orphan_instance in boolean
	) IS 
	
    fault_id_val NUMBER;
    orphan_composite_dn composite_dn_type;
    m_partition_id integer;
    composite_sca_entity_id integer;
    wf_component_sca_entity_id integer;
    
	BEGIN
		--generate fault_id
		fault_id_val := get_next_id('FAULT_IDS');
		log_debug('fault_id generated:::' || fault_id_val,log_file);
		log_debug('comp_fault_key_val:::' || comp_fault_key_val,log_file);
		log_debug('composite_id_val:::' || composite_id_val,log_file);
		log_debug('component_name:::' || component_name,log_file);
		log_debug('composite_sca_entity_id:::' || sca_flow_to_cpst_obj.composite_sca_entity_id,log_file);
		log_debug('fault_name_val:::' || fault_name_val,log_file);
		log_debug('fault_type_val:::' || upper(fault_type_val),log_file);
		log_debug('sca_partition_id:::' || sca_flow_to_cpst_obj.sca_partition_id,log_file);
		log_debug('creation_date_val:::' || creation_date_val,log_file);
		log_debug('error_code_val:::' || error_code_val,log_file);
		if (is_orphan_instance = true ) then
            orphan_composite_dn := composite_dn_type(composite_dn);
            select id into m_partition_id from sca_partition where name = orphan_composite_dn.partition_name;
            SELECT ID INTO wf_component_sca_entity_id 
                FROM SCA_ENTITY 
                WHERE SCA_PARTITION_ID = m_partition_id  AND 
                COMPOSITE = orphan_composite_dn.composite_name  AND 
                REVISION = orphan_composite_dn.revision AND 
                NAME = REGEXP_SUBSTR(component_name,'[^/]*$') AND
              --  LABEL = orphan_composite_dn.label AND 
              TYPE = 'component' AND
                SUB_TYPE = 'implementation.workflow';
            select id into composite_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = orphan_composite_dn.composite_name and revision = orphan_composite_dn.revision and type='composite';-- and label =  orphan_composite_dn.label; 
        else
            
            SELECT ID INTO wf_component_sca_entity_id 
                FROM SCA_ENTITY 
                WHERE SCA_PARTITION_ID = sca_flow_to_cpst_obj.SCA_PARTITION_ID  AND 
                COMPOSITE = sca_flow_to_cpst_obj.COMPOSITE_NAME  AND 
                REVISION = sca_flow_to_cpst_obj.REVISION AND 
                NAME = REGEXP_SUBSTR(component_name,'[^/]*$') AND
              --  LABEL = sca_flow_to_cpst_obj.LABEL AND 
              TYPE = 'component' AND
                SUB_TYPE = 'implementation.workflow';
                composite_sca_entity_id := sca_flow_to_cpst_obj.composite_sca_entity_id;
                m_partition_id := sca_flow_to_cpst_obj.sca_partition_id;
        end if;
		INSERT INTO SCA_COMMON_FAULT
				(
				   ID,
				   RETRY_COUNT,  -- 0
				   FLOW_ID, -- sca_flow_to_cpst_obj.flow_id
				   COMPONENT_TYPE, --workflow
				   COMPONENT_FAULT_KEY, --calculated
				   SCA_ENTITY_ID, --calculated
				   COMPOSITE_SCA_ENTITY_ID, -- sca_flow_to_cpst_obj.composite_sca_entity_id
				   CIKEY,
				   OWNER_CIKEY,
				   OWNER_SCA_ENTITY_ID,
				   OWNER_COMPONENT_TYPE,
				   COMPOSITE_ID,
				   OWNER_COMPOSITE_SCA_ENTITY_ID,
				   FAULT_NAME,
				   FAULT_TYPE,
				   ERROR_MESSAGE,
				   ERROR_CODE,
				   STATE,
				   SCA_PARTITION_ID,
				   OWNER_SCA_PARTITION_ID,
				   CREATION_DATE,
				   MODIFY_DATE
				)
			   VALUES
				(
				   fault_id_val,
				   0,
				   sca_flow_to_cpst_obj.flow_id,
				   'workflow',
				   comp_fault_key_val, --component_fault_key
				   wf_component_sca_entity_id, -- SCA_ENTITY_ID
				   composite_sca_entity_id,	 --COMPOSITE_SCA_ENTITY_ID
				   cikey_val, --CIKEY
				   cikey_val, --OWNER_CIKEY
				   wf_component_sca_entity_id, -- OWNER_SCA_ENTITY_ID
				   'workflow', -- OWNER_COMPONENT_TYPE
				   composite_id_val, -- COMPOSITE_ID
				   composite_sca_entity_id,	 --OWNER_COMPOSITE_SCA_ENTITY_ID
				   fault_name_val,  --FAULT_NAME
				   upper(fault_type_val),   --FAULT_TYPE
				   error_message_val,   -- ERROR_MESSAGE 
				   error_code_val, -- ERROR_CODE
				   state_val,   -- STATE
				   m_partition_id,   --SCA_PARTITION_ID
				   m_partition_id,   --OWNER_SCA_PARTITION_D
				   creation_date_val, -- CREATION_DATE
				   creation_date_val --MODIFY_DATE
				);			
				
		END ;
procedure process_workflow(
                            ecid_val in varchar2,
                            flow_id in number,
                            sca_flow_to_cpst_obj sca_flow_to_cpst_type,
                            SE_status  out SE_status_type,
                            is_orphaned_case in boolean default false,
                            log_file IN utl_file.file_type)  is 
    component_id  number;
    component_ids_seq  VARCHAR (100) := 'COMPONENT_INSTANCE_IDS';
    wf_fault_state number;
    wf_error_code_val VARCHAR2(100);
    str_composite_instance_id VARCHAR2(200);
    wf_composite_dn varchar2(500);
    
    begin
        SE_status  := SE_status_type();
        if (is_orphaned_case = false) then
            log_debug('TEMP_UPGRADE_WFTASK global temp table used for normal instances',log_file );
            str_composite_instance_id := TO_CHAR(sca_flow_to_cpst_obj.composite_id);
            FOR wf_instance in (SELECT /*+ INDEX(TEMP_UPGRADE_WFTASK CPST_ID_TEMP_UPG_WFTASK_IDX) */ TASKID, COMPONENTNAME, STATE,COMPOSITEDN from TEMP_UPGRADE_WFTASK WHERE compositeinstanceid = str_composite_instance_id
                and (componenttype = 'Workflow'  OR componenttype is null))
            LOOP
                if wf_instance.state is not null and wf_instance.state = 'STALE' then 
                    SE_status.is_stale := 1;
                end if;
                if wf_instance.state is not null and wf_instance.state not in ('DELETED','ERRORED','EXPIRED','STALE','WITHDRAWN') then
                    SE_status.active_component_count := SE_status.active_component_count + 1;
                end if; 
                component_id := get_next_id(component_ids_seq);
                update WFTASK set component_instance_id = component_id where taskid = wf_instance.taskid;
        
                FOR wf_faulted_instance in 
                (SELECT TASKERRORID, TASKID, TASKNUMBER, TASKVERSION, ERRORARGS, ERRORDATE, ERRORID, ERRORSTACK, ERRORTYPE, ISRECOVERABLE,COMPOSITEINSTANCEID,ERRORMESSAGE FROM wftaskerror WHERE TASKID = wf_instance.taskid)
                LOOP
                    wf_error_code_val := TO_CHAR(wf_faulted_instance.ERRORID, '99999');
                    if (wf_faulted_instance.ISRECOVERABLE = 'T') then
                        if wf_instance.state = 'ALERTED' then 
	                        SE_status.recoverable_fault_count := SE_status.recoverable_fault_count + 1;
        	                wf_fault_state := 2048; -- HWF Recovery
                        else
                            wf_fault_state := 256; --non recoverable in case the state is assigned, withdrawn
                        end if;
                    else 
                        SE_status.unhandled_count := SE_status.unhandled_count + 1; -- increase the unhandled fault count for each non-recoverable common fault inserted.
                        wf_fault_state := 256; --Non Recoverable
                    end if;
                    populate_wf_common_fault(wf_instance.COMPONENTNAME,wf_faulted_instance.TASKNUMBER||':'||wf_faulted_instance.TASKVERSION,component_id,sca_flow_to_cpst_obj.composite_id,'',wf_faulted_instance.ERRORTYPE,wf_faulted_instance.ERRORMESSAGE,wf_fault_state,wf_faulted_instance.ERRORDATE,wf_error_code_val,sca_flow_to_cpst_obj,log_file,wf_instance.COMPOSITEDN,is_orphaned_case);
            
                END LOOP;
            END LOOP;
        else 
            log_debug('WFTASK normal table used',log_file );
            FOR wf_instance in (SELECT /*+ INDEX(TEMP_UPGRADE_WFTASK ECID_TEMP_UPG_WFTASK_IDX) */ TASKID, COMPONENTNAME, STATE,COMPOSITEDN from TEMP_UPGRADE_WFTASK WHERE ecid = ecid_val
                and (componenttype = 'Workflow'  OR componenttype is null))
            LOOP
                if wf_instance.state is not null and wf_instance.state = 'STALE' then 
                    SE_status.is_stale := 1;
                end if;
                if wf_instance.state is not null and wf_instance.state not in ('DELETED','ERRORED','EXPIRED','STALE','WITHDRAWN') then
                    SE_status.active_component_count := SE_status.active_component_count + 1;
                end if; 
                
                component_id := get_next_id(component_ids_seq);
        
                update WFTASK set component_instance_id = component_id where taskid = wf_instance.taskid;
        
                FOR wf_faulted_instance in 
                (SELECT TASKERRORID, TASKID, TASKNUMBER, TASKVERSION, ERRORARGS, ERRORDATE, ERRORID, ERRORSTACK, ERRORTYPE, ISRECOVERABLE,COMPOSITEINSTANCEID,ERRORMESSAGE FROM wftaskerror WHERE TASKID = wf_instance.taskid)
                LOOP
                    wf_error_code_val := TO_CHAR(wf_faulted_instance.ERRORID, '99999');
                    if (wf_faulted_instance.ISRECOVERABLE = 'T') then
                        SE_status.recoverable_fault_count := SE_status.recoverable_fault_count + 1;
                        wf_fault_state := 2048; -- HWF Recovery
                    else 
                        SE_status.unhandled_count := SE_status.unhandled_count + 1; -- increase the unhandled fault count for each non-recoverable common fault inserted.
                        wf_fault_state := 256; --Non Recoverable
                    end if;
                    populate_wf_common_fault(wf_instance.COMPONENTNAME,wf_faulted_instance.TASKNUMBER||':'||wf_faulted_instance.TASKVERSION,component_id,sca_flow_to_cpst_obj.composite_id,'',wf_faulted_instance.ERRORTYPE,wf_faulted_instance.ERRORMESSAGE,wf_fault_state,wf_faulted_instance.ERRORDATE,wf_error_code_val,sca_flow_to_cpst_obj,log_file,wf_instance.COMPOSITEDN,is_orphaned_case);
            
                END LOOP;
            END LOOP;
        end if;
 end process_workflow;
	
	function process_work_item(
        				   ecid in varchar2,
					   flow_id in number ,
					   sca_flow_to_cpst_obj in sca_flow_to_cpst_type,
                                           log_file IN utl_file.file_type,
                                           wi_inst in work_item_type ,
                                           component_id_val in varchar2 default null,
					   component_dn in varchar2 default null,
                                           component_fault_key_val in varchar2,
                                           SE_status  in out SE_status_type,
										   processed_active_cikey_arr in out processed_cikey_type,
                                           is_orphan_instance in boolean                                           ) return boolean is
	bpel_sca_entity_id integer;
	bpel_state integer;    
	owner_cikey integer;
	is_fault_recovery boolean := false;
	is_callback_recovery boolean := false;
	subscriber_id_val varchar2(1024);
	subs_state number;
	conv_type_val number;	
	fault_id_val number;
	common_fault_type_val varchar2(10);
	bpel_component_key varchar2(1000);
	fault_ids_seq VARCHAR(100) := 'FAULT_IDS';
	default_fault_meessage varchar2(100) := 'Error Message not available-Generated during instance upgrade.';
	default_fault_name varchar2(20) := 'Upgraded Fault';
	common_fault_type enum_fault_type := new enum_fault_type;
    m_composite_name varchar2(500) := null;
    m_composite_domain varchar2(50) := null;
    m_composite_version varchar2(50) := null;
    m_composite_label varchar2(50) := null;
    m_partition_id integer;
    m_composite_id number;
    composite_sca_entity_id integer;
	
        begin
        
        if(is_orphan_instance = true) then 
            Select Composite_Name,Domain_Name,Composite_Revision,Composite_Label,Composite_ID into m_composite_name,m_composite_domain,m_composite_version,m_composite_label,m_composite_id from TEMP_UPGRADE_CI Where cikey  = wi_inst.cikey;
            select id into m_partition_id from sca_partition where name = m_composite_domain;
            select id into bpel_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = m_composite_name  and revision = m_composite_version and name = wi_inst.component_name --and label = m_composite_label 
            and type= 'component' and (sub_type = 'implementation.bpel' or sub_type = 'implementation.bpmn');
            bpel_component_key := get_c_key_for_activity(m_composite_domain || '/'  || m_composite_name || '!' || m_composite_version ||'*' || m_composite_label,wi_inst.component_name,
                wi_inst.cikey,wi_inst.node_id, wi_inst.scope_id, wi_inst.count_id);
            select id into composite_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = m_composite_name and revision = m_composite_version and type='composite';-- and label = m_composite_label; 
        else
            -- get sca entity ID for the component 
            select id into bpel_sca_entity_id from sca_entity where sca_partition_id = sca_flow_to_cpst_obj.sca_partition_id  and 
            composite = sca_flow_to_cpst_obj.composite_name  and revision = sca_flow_to_cpst_obj.revision and 
            name = wi_inst.component_name --and label = sca_flow_to_cpst_obj.label 
            and type= 'component' and (sub_type = 'implementation.bpel'
            or sub_type = 'implementation.bpmn');
            bpel_component_key := get_c_key_for_activity(sca_flow_to_cpst_obj.composite_dn,wi_inst.component_name,
  					wi_inst.cikey,wi_inst.node_id, wi_inst.scope_id, wi_inst.count_id);
            composite_sca_entity_id := sca_flow_to_cpst_obj.composite_sca_entity_id;
            m_partition_id := sca_flow_to_cpst_obj.sca_partition_id;
            m_composite_id := sca_flow_to_cpst_obj.composite_id;  
        end if;
		
		
	    if wi_inst.state = 13 then  --OPEN PENDING RECOVERY = ADMIN_RECOVERY
		 bpel_state := 512; --ADMIN_RECOVERY
		--TODO correlation  for bpel_admin_recovery 
		--is_fault_recovery := TRUE;
        elsif (wi_inst.state = 1) then  --activity recovery
          	 bpel_state := 1024; --BPEL_ACTIVITY_RECOVERY
        	 log_debug('total_active_count incremented bpel_2', log_file);
   		 							
                 log_debug('ACTIVITY RECOVERY', log_file);
		elsif (wi_inst.state = 3) then 
			if(processed_active_cikey_arr.exists(wi_inst.cikey) = false) then
				processed_active_cikey_arr(wi_inst.cikey) := wi_inst.cikey;
			end if;
			return false;	
		else
              -- not a recovery
                  return false;
    	end if;		
	 fault_id_val := get_next_id( fault_ids_seq  );
   	 log_debug('fault ID Val'|| ' ' || fault_id_val, log_file);    
		    
         common_fault_type_val := common_fault_type.SYSTEM;		--default fault_type to SYSTEM . NOT FEASIBLE TO COMPUTE
	 INSERT INTO SCA_COMMON_FAULT
	 (
		ID,
		RETRY_COUNT,  -- 0
		FLOW_ID, -- sca_flow_to_cpst_obj.flow_id
		COMPONENT_TYPE, --bpel/bpmn
		COMPONENT_FAULT_KEY, --calculated
		SCA_ENTITY_ID, --calculated
		COMPOSITE_SCA_ENTITY_ID, -- sca_flow_to_cpst_obj.composite_sca_entity_id
		CIKEY,
		OWNER_CIKEY,
		OWNER_SCA_ENTITY_ID,
		OWNER_COMPONENT_TYPE,
		OWNER_COMPOSITE_SCA_ENTITY_ID,
		 FAULT_NAME, 
		 FAULT_TYPE,
		 ERROR_MESSAGE,
		 STATE,
		 SCA_PARTITION_ID,
		 OWNER_SCA_PARTITION_ID,
     COMPOSITE_ID,
		 CREATION_DATE,
   	         MODIFY_DATE	
	   )
           VALUES
	  (
  	         fault_id_val,
		 0,
		 sca_flow_to_cpst_obj.flow_id,
		 wi_inst.component_type,
		 bpel_component_key, --component_fault_key
	         bpel_sca_entity_id, -- SCA_ENTITY_ID 
		 composite_sca_entity_id,	 --COMPOSITE_SCA_ENTITY_ID
		 wi_inst.cikey, --CIKEY
		 wi_inst.cikey, --OWNER_CIKEY
		 bpel_sca_entity_id, -- OWNER_SCA_ENTITY_ID
	     wi_inst.component_type, -- OWNER_COMPONENT_TYPE
		 composite_sca_entity_id,	 --OWNER_COMPOSITE_SCA_ENTITY_ID
		 default_fault_name,  --FAULT_NAME
		 common_fault_type_val,   --FAULT_TYPE
		 default_fault_meessage,   -- ERROR_MESSAGE  - NOT FEASABLE TO FIX . TODO - PUT A DEFAULT ERROR MESSAGE STATING THAT ITS AN UPGRADED INSTANCE.
	          bpel_state,   -- STATE
		  m_partition_id,   --SCA_PARTITION_ID
		  m_partition_id,   --OWNER_SCA_PARTITION_D
      m_composite_id, -- COMPOSITE_ID
		  wi_inst.partition_date, -- CREATION_DATE
		  wi_inst.partition_date --MODIFY_DATE 
	  );
          SE_status.fault_id := fault_id_val;
 	  SE_status.recoverable_fault_count := SE_status.recoverable_fault_count + 1;
	  SE_status.active_component_count :=  SE_status.active_component_count + 1;
	  return true;	
      end process_work_item;
	
        function process_dlv_msg(
        				   ecid in varchar2,
					   flow_id in number ,
					   sca_flow_to_cpst_obj in sca_flow_to_cpst_type,
                                           log_file IN utl_file.file_type,
                                           dlv_inst in dlv_msg_type ,
                                           component_id_val in varchar2 default null,
					   component_dn in varchar2 default null,
                                           component_fault_key_val in varchar2,
                                           SE_status  in out SE_status_type,
                                           is_orphan_instance in boolean) return boolean is
	bpel_sca_entity_id integer;
	bpel_state integer;    
	owner_cikey integer;
        ecid_val varchar2(100);
	--is_fault_recovery boolean := false;
	is_callback_recovery boolean := false;
	subscriber_id_val varchar2(1024);
	subs_state number;
	conv_type_val number;	
	fault_id_val number;
	common_fault_type_val varchar2(10);
	bpel_component_key varchar2(1000);
	fault_ids_seq VARCHAR(100) := 'FAULT_IDS';
	default_fault_meessage varchar2(100) := 'Error Message not available-Generated during instance upgrade.';
	default_fault_name varchar2(20) := 'Upgraded Fault';
	common_fault_type enum_fault_type := new enum_fault_type;
    m_partition_id integer;
    m_composite_id number;
    m_composite_dn varchar2(1253);
    composite_sca_entity_id integer;
        begin
		ecid_val := ecid;
        	log_debug('composite_namee ' || sca_flow_to_cpst_obj.composite_name, log_file);
        		-- get sca entity ID for the component
        	log_debug('compositeDn = ' || 	sca_flow_to_cpst_obj.sca_partition_id || ' ' ||sca_flow_to_cpst_obj.composite_name
        	||' '||sca_flow_to_cpst_obj.revision ||' ' || dlv_inst.component_name,log_file); --remove
        if(is_orphan_instance = true) then 
            
            select id into m_partition_id from sca_partition where name = dlv_inst.domain_name;
            select id into bpel_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = dlv_inst.composite_name  and revision = dlv_inst.composite_revision and name = dlv_inst.component_name --and label = dlv_inst.composite_label 
            and type= 'component' and (sub_type = 'implementation.bpel' or sub_type = 'implementation.bpmn');
            select id into composite_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = dlv_inst.composite_name and revision = dlv_inst.composite_revision and type='composite'; --and label = dlv_inst.composite_label; 
            m_composite_dn := dlv_inst.domain_name || '/'  || dlv_inst.composite_name || '!' || dlv_inst.composite_revision ||'*' || dlv_inst.composite_label ;
            m_composite_id := sca_flow_to_cpst_obj.composite_id;
        else
            select id into bpel_sca_entity_id from sca_entity where sca_partition_id = sca_flow_to_cpst_obj.sca_partition_id  
            and composite = sca_flow_to_cpst_obj.composite_name  and revision = sca_flow_to_cpst_obj.revision 
            and name = dlv_inst.component_name --and label = sca_flow_to_cpst_obj.label 
            and type= 'component' and (sub_type = 'implementation.bpel'
            or sub_type = 'implementation.bpmn');
            m_composite_dn := sca_flow_to_cpst_obj.composite_dn;
            composite_sca_entity_id := sca_flow_to_cpst_obj.composite_sca_entity_id;
            m_partition_id := sca_flow_to_cpst_obj.sca_partition_id;
            m_composite_id := sca_flow_to_cpst_obj.composite_id;
        end if;
	  	common_fault_type_val := common_fault_type.SYSTEM;		--default fault_type to SYSTEM . NOT FEASIBLE TO COMPUTE
	
	  	if dlv_inst.dlv_type = 1 then 
			if dlv_inst.cikey = 0 then
			  select max(cikey) into owner_cikey  from TEMP_UPGRADE_CI where conversation_id = dlv_inst.conv_id and ecid = ecid_val;
			else
	  		  owner_cikey := dlv_inst.cikey;
			end if;
	  		bpel_state  := 768; --invoke recovery
	  		bpel_component_key := get_c_key_for_invoke(m_composite_dn,dlv_inst.component_name,
	  			dlv_inst.message_guid, log_file); 
	  	else
	  		bpel_state := 3072; --callback recovery
	  	        --is_fault_recovery := TRUE ;
	  		is_callback_recovery := TRUE;
	  		
			BEGIN
			select state , subscriber_id, conv_type, cikey into subs_state, subscriber_id_val, conv_type_val, owner_cikey from dlv_subscription where conv_id = dlv_inst.conv_id and state in (0,1) and rownum = 1;
			
			EXCEPTION 
				WHEN NO_DATA_FOUND then
					return false;
			END;		
	  		 bpel_component_key := get_c_key_for_callback(m_composite_dn,dlv_inst.component_name,dlv_inst. message_guid, subs_state,subscriber_id_val, dlv_inst.conv_id, conv_type_val, log_file); 
	  	end if;
   	        fault_id_val := get_next_id( fault_ids_seq  );
		log_debug('fault ID Val'|| ' ' || fault_id_val, log_file);    
	  	INSERT INTO SCA_COMMON_FAULT
	  	(
	  		ID,
	  		RETRY_COUNT,  -- 0
	  		FLOW_ID, -- sca_flow_to_cpst_obj.flow_id
	  		COMPONENT_TYPE, --bpel/bpmn
	  		COMPONENT_FAULT_KEY, --calculated
	  		SCA_ENTITY_ID, --calculated
	  		COMPOSITE_SCA_ENTITY_ID, -- sca_flow_to_cpst_obj.composite_sca_entity_id
	  		CIKEY,
	  		OWNER_CIKEY,
	  		OWNER_SCA_ENTITY_ID,
	  		OWNER_COMPONENT_TYPE,
	  		OWNER_COMPOSITE_SCA_ENTITY_ID,
	  		FAULT_NAME,  
	  		FAULT_TYPE,
	  		ERROR_MESSAGE,
	  		STATE,
	  		SCA_PARTITION_ID,
	  		OWNER_SCA_PARTITION_ID,
        COMPOSITE_ID,
	  		CREATION_DATE,
	  		MODIFY_DATE	
	  	 )
	  	 VALUES
	  	(
	  	               fault_id_val,
	  	               0,
	  	               sca_flow_to_cpst_obj.flow_id,
	  		       dlv_inst.component_type,
	  		       bpel_component_key, --component_fault_key
	  	               bpel_sca_entity_id, -- SCA_ENTITY_ID 
	  		       composite_sca_entity_id,	 --COMPOSITE_SCA_ENTITY_ID
	  		       owner_cikey, --CIKEY
	  		       owner_cikey, --OWNER_CIKEY
	  		       bpel_sca_entity_id, -- OWNER_SCA_ENTITY_ID
	  				   dlv_inst.component_type, -- OWNER_COMPONENT_TYPE
	  		       composite_sca_entity_id,	 --OWNER_COMPOSITE_SCA_ENTITY_ID
	  		      default_fault_name,  --FAULT_NAME
	  		       common_fault_type_val,   --FAULT_TYPE
	  		       default_fault_meessage,   -- ERROR_MESSAGE  - NOT FEASABLE TO FIX . TODO - PUT A DEFAULT ERROR MESSAGE STATING THAT ITS AN UPGRADED INSTANCE.
	  			   bpel_state,   -- STATE
	  			   m_partition_id,   --SCA_PARTITION_ID
	  		       m_partition_id,   --OWNER_SCA_PARTITION_D
               m_composite_id, -- COMPOSITE_ID
	  		       dlv_inst.receive_date, -- CREATION_DATE
	  		       dlv_inst.receive_date --MODIFY_DATE 
			);	
        	  	 log_debug('inserted',log_file); --remove
			SE_status.fault_id := fault_id_val;
			SE_status.recoverable_fault_count := SE_status.recoverable_fault_count + 1;
			SE_status.active_component_count :=  SE_status.active_component_count + 1;
			log_debug('end of process_dlv_msg',log_file);
			return is_callback_recovery; 		
       end process_dlv_msg;
	   
        procedure process_wifault(
        	   ecid in varchar2,
		   flow_id in number ,
		   sca_flow_to_cpst_obj in sca_flow_to_cpst_type,
                   log_file IN utl_file.file_type,
                   wif_inst in wif_type,
                   is_orphan_instance in boolean
                  ) is
        	bpel_sca_entity_id integer;
		bpel_state integer;    
		owner_cikey integer;
		--is_fault_recovery boolean := false;
		is_callback_recovery boolean := false;
		subscriber_id_val varchar2(1024);
		subs_state number;
		conv_type_val number;	
		fault_id_val number;
		common_fault_type_val varchar2(10);
		bpel_component_key varchar2(1000);
		fault_ids_seq VARCHAR(100) := 'FAULT_IDS';
        	common_fault_type enum_fault_type := new enum_fault_type;
		bpel_system_fault varchar2(62) := '{http://schemas.oracle.com/bpel/extension}RuntimeFaultMessage';        	
		bpel_owsm_fault varchar2(65) := '{http://schemas.oracle.com/bpel/extension}OWSMPolicyFaultMessage';
        m_composite_name varchar2(500) := null;
        m_composite_domain varchar2(50) := null;
        m_composite_version varchar2(50) := null;
        m_composite_label varchar2(50) := null;
        m_composite_id number;
        m_partition_id integer;
        composite_sca_entity_id integer;
        begin
               fault_id_val := get_next_id( fault_ids_seq  );
	      log_debug('fault ID Val'|| ' ' || fault_id_val, log_file);  
        if(is_orphan_instance = true) then 
            Select Composite_Name,Domain_Name,Composite_Revision,Composite_Label,Composite_ID into m_composite_name,m_composite_domain,m_composite_version,m_composite_label,m_composite_id from TEMP_UPGRADE_CI Where cikey  = wif_inst.cikey;
            select id into m_partition_id from sca_partition where name = m_composite_domain;
            select id into bpel_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = m_composite_name  and revision = m_composite_version and name = wif_inst.component_name and --label = m_composite_label and 
            type= 'component' and (sub_type = 'implementation.bpel' or sub_type = 'implementation.bpmn');
            select id into composite_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = m_composite_name and revision = m_composite_version and type='composite' ;
            --and label = m_composite_label; 
        else
            select id into bpel_sca_entity_id from sca_entity where sca_partition_id = sca_flow_to_cpst_obj.sca_partition_id  and composite = sca_flow_to_cpst_obj.composite_name  and revision = sca_flow_to_cpst_obj.revision and name = wif_inst.component_name --and label = sca_flow_to_cpst_obj.label 
            and type= 'component' and (sub_type = 'implementation.bpel' or sub_type = 'implementation.bpmn');
            composite_sca_entity_id := sca_flow_to_cpst_obj.composite_sca_entity_id;
            m_partition_id := sca_flow_to_cpst_obj.sca_partition_id;
            m_composite_id := sca_flow_to_cpst_obj.composite_id;
        end if;
				--get the fault type 
		if wif_inst.fault_type = bpel_system_fault OR wif_inst.fault_type = null then 
			common_fault_type_val := common_fault_type.SYSTEM;
	        elsif wif_inst.fault_type= bpel_owsm_fault then 
			common_fault_type_val := common_fault_type.POLICY;
		else
			common_fault_type_val := common_fault_type.BUSINESS;
    		end if;
		INSERT INTO SCA_COMMON_FAULT
		(
		     ID,
		     RETRY_COUNT,  -- 0
		     FLOW_ID, -- sca_flow_to_cpst_obj.flow_id
		     COMPONENT_TYPE, --bpel/bpmn
		     COMPONENT_FAULT_KEY, --NOT REquired for a non-recoverable fault
		     SCA_ENTITY_ID, --calculated
		     COMPOSITE_SCA_ENTITY_ID, -- sca_flow_to_cpst_obj.composite_sca_entity_id
		     CIKEY,
		     OWNER_CIKEY,
		     OWNER_SCA_ENTITY_ID,
		     OWNER_COMPONENT_TYPE,
		     OWNER_COMPOSITE_SCA_ENTITY_ID,
		     FAULT_NAME,  
		     FAULT_TYPE,
		     ERROR_MESSAGE,
		     STATE,
		     SCA_PARTITION_ID,
		     OWNER_SCA_PARTITION_ID,
         COMPOSITE_ID,
		     CREATION_DATE,
		     MODIFY_DATE	
		)
		VALUES
		(
		    fault_id_val,
		    0,
		    sca_flow_to_cpst_obj.flow_id,
                    wif_inst.component_type,
        	    '', --component_fault_key  NOT REQUIRED FOR A NON_RECOVERABLE FAULT
		     bpel_sca_entity_id, -- SCA_ENTITY_ID 
		     composite_sca_entity_id,	 --COMPOSITE_SCA_ENTITY_ID
		     wif_inst.cikey, --CIKEY
		     wif_inst.cikey, --OWNER_CIKEY
		     bpel_sca_entity_id, -- OWNER_SCA_ENTITY_ID
		      wif_inst.component_type, -- OWNER_COMPONENT_TYPE
		     composite_sca_entity_id,	 --OWNER_COMPOSITE_SCA_ENTITY_ID
		     wif_inst.fault_name,  --FAULT_NAME
		     common_fault_type_val,   --FAULT_TYPE
		     wif_inst.message,   -- ERROR_MESSAGE  - NOT FEASABLE TO FIX . 
		                         --TODO - PUT A DEFAULT ERROR MESSAGE STATING THAT ITS AN UPGRADED INSTANCE.
		     256,   -- STATE - ALWAYS NON_RECOVERABLE
		     m_partition_id,   --SCA_PARTITION_ID
		     m_partition_id,   --OWNER_SCA_PARTITION_D
         m_composite_id, -- COMPOSITE_ID
	             wif_inst.creation_date, -- CREATION_DATE
		     wif_inst.modify_date --MODIFY_DATE 
	       );

        end process_wifault;
		
procedure  process_bpel(   
    ecid in varchar2,
    flow_id in number ,
    sca_flow_to_cpst_obj sca_flow_to_cpst_type,
    SE_status  out SE_status_type,
    log_file IN utl_file.file_type,
    component_id_val in varchar2 default null,
    component_dn in varchar2 default null,
    component_fault_key_val in varchar2 default null,
    is_orphan_instance boolean,
    processed_dlv_message_array in out processed_dlv_message)  is 

    bpel_sca_entity_id integer;
    bpel_state integer;
    fault_claimed boolean := false;
    IC_recovery_claimed boolean := false;
    bpel_component_key varchar2(1000);	
    bpel_system_fault varchar2(62) := '{http://schemas.oracle.com/bpel/extension}RuntimeFaultMessage';
    type bpel_faults_type is table of bpel_fault_type;
    bpel_faults  bpel_faults_type;
    subscriber_id_val varchar2(1024);
    subs_state number;
    conv_type_val number;	
    is_fault_recovery boolean := false;
    fault_recovered boolean := false;
    fault_id_val number;
    common_fault_type_val varchar2(10);
    fault_ids_seq VARCHAR(100) := 'FAULT_IDS';
    common_fault_type enum_fault_type := new enum_fault_type;
    cmp_ecid varchar2(500);
    active_component_count number := 0;
    is_callback_recovery boolean := false;
    owner_cikey number := 0;
    dlv_count number := 0;
    is_callback_recovery_temp boolean;
    dlv_msg_rec dlv_msg_type;
    wi_count number := 0;
    work_item_rec work_item_type;
    message_guid_val varchar2(50);
    processed_active_cikey_arr processed_cikey_type ;
    --delete_count number := 0; 
    
    BEGIN
    SE_status  := SE_status_type();
    processed_active_cikey_arr.DELETE;
    cmp_ecid := ecid;
    
    if is_orphan_instance  = true then 
        FOR ci_inst IN  (select /*+ INDEX(TEMP_UPGRADE_CI  ECID_TEMP_UPG_CI_IDX) */    cikey,state  from  TEMP_UPGRADE_CI where ecid = cmp_ecid )
        LOOP 
            if ci_inst.state = 9 then -- State of 9 is stale for cube instance
                SE_status.is_stale := 1;
            elsif ci_inst.state = 8 then  -- State of 8 is Aborted for cube instance
                 SE_status.is_aborted := 1;
            end if;
        FOR wi_inst 
            IN(select /*+ INDEX(TEMP_UPGRADE_WKITM_CI CIKEY_TEMP_UPGRADE_WKITM_CI) */ work_item_type(cikey ,component_name  ,state, node_id, scope_id, count_id, exp_flag, exp_date,componenttype,creation_date)wrk_itm  from TEMP_UPGRADE_WKITM_CI where CIKEY =ci_inst.cikey )
        LOOP 
            fault_recovered := TRUE;
            log_debug('orphan recoverable count incremented by 1 work item open: flow_id =   ' || flow_id , log_file);
            log_debug('total_active_count incremented bpel_1', log_file);
            is_fault_recovery := process_work_item(
                ecid,
                flow_id,
                sca_flow_to_cpst_obj,
                log_file,
                wi_inst.wrk_itm,
                component_id_val,
                component_dn,
                component_fault_key_val,
                SE_status,
                processed_active_cikey_arr,
                is_orphan_instance);
        END LOOP; -- end of wi_inst loop
        END LOOP;
    else 
        FOR ci_inst IN  (select /*+ INDEX(TEMP_UPGRADE_CI  CMP_ID_TEMP_UPG_CI_IDX) */    cikey,state  from  TEMP_UPGRADE_CI where composite_id = sca_flow_to_cpst_obj.composite_id )
        LOOP
            if ci_inst.state = 9 then -- State of 9 is stale for cube instance
                SE_status.is_stale := 1;
            elsif ci_inst.state = 8 then  -- State of 8 is Aborted for cube instance
                 SE_status.is_aborted := 1;
            end if;
            FOR wi_inst 
            IN(select /*+ INDEX(TEMP_UPGRADE_WKITM_CI CIKEY_TEMP_UPGRADE_WKITM_CI) */ work_item_type(cikey ,component_name  ,state,  node_id, scope_id, count_id, exp_flag, exp_date,componenttype,creation_date)wrk_itm  from TEMP_UPGRADE_WKITM_CI where CIKEY =ci_inst.cikey )
            LOOP
                fault_recovered := TRUE;
                log_debug(' normal instance recoverable count incremented by 1 work item open: flow_id =   ' || flow_id , log_file);
                log_debug('total_active_count incremented bpel_1', log_file);
                is_fault_recovery := process_work_item(
                    ecid,
                    flow_id,
                    sca_flow_to_cpst_obj,
                    log_file,
                    wi_inst.wrk_itm,
                    component_id_val,
                    component_dn,
                    component_fault_key_val,
                    SE_status,
                    processed_active_cikey_arr,
                    is_orphan_instance);
            END LOOP;
        END LOOP;
    end if;
    -- check for Invoke or callback recovery
    -- ideally we expect this query to return only 1 row always
    is_fault_recovery := FALSE;
    --if is_orphan_instance = true then
    for msg_ecid_map_inst IN 
    (select MESSAGE_GUID  /*+ INDEX(TEMP_UPGRADE_DLV_ECID_MAP ECID_TEMP_UPGRADE_DLV_ECID_MAP) */ from TEMP_UPGRADE_DLV_ECID_MAP where ecid = cmp_ecid )
    LOOP
        if is_orphan_instance = false then
            for dlv_inst IN 
            (select dlv_msg_type(dlv_type, message_guid, component_name, cikey, receive_date,conv_id ,domain_name,composite_name,composite_revision,composite_label,state,component_type) dlv_msg from TEMP_UPGRADE_DLV_MSG 
            where domain_name = sca_flow_to_cpst_obj.partition_name 
            and composite_name = sca_flow_to_cpst_obj.composite_name and composite_revision = sca_flow_to_cpst_obj.revision -- and composite_label = sca_flow_to_cpst_obj.label 
			and message_guid = msg_ecid_map_inst.MESSAGE_GUID) 
            LOOP
                message_guid_val := dlv_inst.dlv_msg.message_guid;
                fault_recovered := TRUE;
                log_debug('recoverable count incremented by 1 dlv_msg open: flow_id =   ' || flow_id , log_file);
                if(processed_dlv_message_array.exists(message_guid_val) = false) then
                    is_callback_recovery_temp := process_dlv_msg(
                        ecid,
                        flow_id  ,
                        sca_flow_to_cpst_obj,
                        log_file ,
                        dlv_inst.dlv_msg,
                        component_id_val,
                        component_dn,
                        component_fault_key_val,
                        SE_status,
                        is_orphan_instance);
                    log_debug('is_callback_recovery_temp  = ',log_file ); --remove	   
                    if is_callback_recovery_temp = true then
                        is_callback_recovery := true;
                    end if;
                    bpel_component_key := '';
                    log_debug ('next loop',log_file); --remove
                    processed_dlv_message_array(message_guid_val) := message_guid_val;
                    DELETE from TEMP_UPGRADE_DLV_ECID_MAP where MESSAGE_GUID = message_guid_val;
                    --delete_count := SQL%ROWCOUNT;
                    --log_debug('Deleted from  TEMP_UPGRADE_DLV_ECID_MAP MESSAGE_GUID =' || message_guid_val || ' and count ' ||to_char(delete_count), log_file);
                end if;	
            END LOOP; --end of dlv_inst loops
        else -- For orphan instance take all the dlv_msg for the ecid
            for dlv_inst IN 
            (select dlv_msg_type(dlv_type, message_guid, component_name, cikey, receive_date,conv_id ,domain_name,composite_name,composite_revision,composite_label,state,component_type) dlv_msg from TEMP_UPGRADE_DLV_MSG 
            where message_guid = msg_ecid_map_inst.MESSAGE_GUID) 
            LOOP
                message_guid_val := dlv_inst.dlv_msg.message_guid;
                fault_recovered := TRUE;
                log_debug('recoverable count incremented by 1 dlv_msg open: flow_id =   ' || flow_id , log_file);
                if(processed_dlv_message_array.exists(message_guid_val) = false) then
                    is_callback_recovery_temp := process_dlv_msg(
                        ecid,
                        flow_id  ,
                        sca_flow_to_cpst_obj,
                        log_file ,
                        dlv_inst.dlv_msg,
                        component_id_val,
                        component_dn,
                        component_fault_key_val,
                        SE_status,
                        is_orphan_instance);
                    log_debug('is_callback_recovery_temp  = ',log_file ); --remove	   
                    if is_callback_recovery_temp = true then
                        is_callback_recovery := true;
                    end if;
                    bpel_component_key := '';
                    log_debug ('next loop',log_file); --remove
                    processed_dlv_message_array(message_guid_val) := message_guid_val;
                    DELETE from TEMP_UPGRADE_DLV_ECID_MAP where MESSAGE_GUID = message_guid_val;
                    --delete_count := SQL%ROWCOUNT;
                    --log_debug('Deleted from  TEMP_UPGRADE_DLV_ECID_MAP MESSAGE_GUID =' || message_guid_val || ' and count ' ||to_char(delete_count), log_file);
                end if;	
            END LOOP; --end of dlv_inst loops
        end if;
        
    END LOOP; 
    log_debug('end of dlv_msg_table loop',log_file); --remove
    if(processed_dlv_message_array.COUNT > 0) then 
         fault_recovered := TRUE;
    end if;
    
    if is_orphan_instance = false then
        log_debug('using temp_upgrade_ci table',log_file);
        FOR wif_insts IN
        ( select /*+ INDEX(TEMP_UPGRADE_CI CMP_ID_TEMP_UPG_CI_IDX) */ wif_type(f.fault_name , f.fault_type ,f.message ,f.node_id,f.scope_id,f.count_id,f.creation_date ,f.modify_date , ci.cikey , ci.component_name, ci.state,ci.componenttype) wif_inst  from TEMP_UPGRADE_CI ci, WI_FAULT f  where f.cikey = ci.cikey  and ci.composite_id = sca_flow_to_cpst_obj.composite_id )
        LOOP
            log_error('inside loop for wi fault'); --remove
            process_wifault(ecid, flow_id ,sca_flow_to_cpst_obj,log_file,wif_insts.wif_inst,is_orphan_instance);
            if(fault_recovered = false and wif_insts.wif_inst.component_state != 5) then 
                SE_status.unhandled_count := SE_status.unhandled_count + 1;  -- increase unhandled count only when there is no recovery involved
            end if;
        END LOOP ;-- end of wif_inst loop                     
    else
        log_debug('starting wif_inst for orpahns',log_file);
        FOR wif_insts IN
        (select  /*+ INDEX(TEMP_UPGRADE_CI ECID_TEMP_UPG_CI_IDX) */ wif_type(f.fault_name , f.fault_type ,f.message ,f.node_id,f.scope_id,f.count_id,f.creation_date ,f.modify_date , ci.cikey , ci.component_name , ci.state,ci.componenttype) wif_inst  from TEMP_UPGRADE_CI ci, WI_FAULT f  where f.cikey = ci.cikey  and ecid = cmp_ecid)
        LOOP
            process_wifault(ecid, flow_id ,sca_flow_to_cpst_obj,log_file,wif_insts.wif_inst,is_orphan_instance);
            if(fault_recovered = false and wif_insts.wif_inst.component_state != 5) then 
                SE_status.unhandled_count := SE_status.unhandled_count + 1;  -- increase unhandled count only when there is no recovery involved
            end if;
        END LOOP ;-- end of wif_inst loop 
    end if;
    log_debug('end wif_inst',log_file);
    active_component_count := 0;
    --get active instance count for bpel instances instances which are in running state (no faults)
    --TODO there is a problem in differentiating between an instance waiting for callback recovery and an instance
    -- waiting at a dehyrdation point- no faults(which is deduced by the query below). So, until we can find out a way to differentiate we need this if condition
    if is_callback_recovery = false then
        -- get the number of instance waiting for recovery from the processed_active_cikey_arr associative array. We already have have queried the data and got the 
        -- result set back
        -- select count(distinct(ci.cikey)) into active_component_count from WORK_ITEM wi, cube_instance ci  where wi.cikey = ci.cikey and  ci.cmpst_id = sca_flow_to_cpst_obj.composite_id and wi.state =  3 ;--open pending complete
        active_component_count := processed_active_cikey_arr.count;
    end if;
    log_debug('active_component_count incremented bpel_4 = ' || active_component_count , log_file);
    SE_status.active_component_count := SE_status.active_component_count + active_component_count ;
    log_debug('end of process_bpel',log_file);
end process_bpel;
      
     procedure handle_midprocess_correlation( parent_flow_id in number , parent_ecid in varchar2 , child_flow_id in number , 
			child_ecid in varchar2, log_file IN utl_file.file_type ) is
		parent_active_inst_count number;
		parent_recoverable_fault_count number;
		child_active_inst_count number;
		child_recoverable_fault_count number;
		owner_cikey_val number ;
		common_fault_id number ;
		cube_inst_flow_id number ;

		BEGIN
		log_debug('handle_midprocess_correlation for parent_flow_id:'||parent_flow_id||' and child flow id :'||child_flow_id,log_file);
		BEGIN
			select ACTIVE_COMPONENT_INSTANCES,RECOVERABLE_FAULTS into parent_active_inst_count,parent_recoverable_fault_count 
				from sca_flow_instance where flow_id = parent_flow_id;
			EXCEPTION
			WHEN NO_DATA_FOUND THEN
			log_debug(' Returning as Flow instance found for parent flow id   : ' ||
				parent_flow_id, log_file);  
			return;
		END;
		BEGIN
			select ACTIVE_COMPONENT_INSTANCES,RECOVERABLE_FAULTS into child_active_inst_count,child_recoverable_fault_count 
				from sca_flow_instance where flow_id = child_flow_id;
			EXCEPTION
			WHEN NO_DATA_FOUND THEN
			log_debug(' Returning as Flow instance found for child flow id   : ' ||
				child_flow_id, log_file);  
			return;                 
		END;
	-- Query Common Fault
		For cf_inst IN ( select ID, OWNER_CIKEY  from sca_common_fault where flow_id = child_flow_id and state = 3072 )
		LOOP
			cube_inst_flow_id := 0;
			BEGIN
			--Check the flow id for the cikey in cube_instance table .
			select flow_id into cube_inst_flow_id from cube_instance where cikey = cf_inst.OWNER_CIKEY;
			EXCEPTION
				WHEN NO_DATA_FOUND THEN
				log_debug(' No Data retturned for owner_ci_key    : ' ||
					cf_inst.OWNER_CIKEY, log_file);  
				cube_inst_flow_id := 0;
			END;
			if (cube_inst_flow_id = parent_flow_id) then
				-- the flow_id in cube instance matches with that of the parent flow id then do the processing.
				parent_recoverable_fault_count := parent_recoverable_fault_count +1;
				child_active_inst_count := child_active_inst_count -1;
				child_recoverable_fault_count := child_recoverable_fault_count -1;
				update sca_common_fault set flow_id = parent_flow_id where id = cf_inst.id;
			end if ;                                                 
		END LOOP;

		update sca_flow_instance set ACTIVE_COMPONENT_INSTANCES = parent_active_inst_count ,RECOVERABLE_FAULTS = parent_recoverable_fault_count
			where flow_id = parent_flow_id;
		update sca_flow_instance set ACTIVE_COMPONENT_INSTANCES = child_active_inst_count ,RECOVERABLE_FAULTS = child_recoverable_fault_count
			where flow_id = child_flow_id;              
		END handle_midprocess_correlation;
	
------------------------------------------- END OF BPEL Functions ----------------------------------------------------------------------
function  handle_orphaned_case(in_ecid in varchar2, in_flow_id in  number, log_file IN utl_file.file_type, sca_partition_count in integer) 
    return composite_instance_type is
    m_created_time timestamp := systimestamp;
    m_upgrade_date timestamp;
    m_composite_name varchar2(500) := null;
    m_composite_domain varchar2(50) := null;
    m_composite_version varchar2(50) := null;
    m_composite_label varchar2(50) := null;
    m_tenant_id number;
    dlv_created_time timestamp := systimestamp;
    dlv_composite_name varchar2(500) := null;
    dlv_composite_domain varchar2(50) := null;
    dlv_composite_version varchar2(50) := null;
    dlv_composite_label varchar2(50) := null;
    dlv_tenant_id number;
    tmp_created_time timestamp;
    tmp_composite_name  varchar2(500):= null;
    tmp_composite_domain  varchar2(50):= null;
    tmp_composite_version varchar2(50):= null;
    tmp_composite_label varchar2(50) := null;   
    tmp_component_name varchar2(1500) := null;
    tmp_component_dn component_dn_type := null;
    tmp_tenant_id number;
    m_composite_id number;
    m_composite_dn varchar2(1253) ;
    m_sca_partition_id number;
    composite_instance_row composite_instance_type;
    BEGIN
        BEGIN
            log_debug('into handle_orphaned_case', log_file);
            composite_instance_row := composite_instance_type();
            Select Composite_Name,Domain_Name,Composite_Revision,Composite_Label,creation_date,tenant_id into m_composite_name,m_composite_domain,m_composite_version,m_composite_label,   m_created_time,m_tenant_id from Cube_Instance Where cikey  = (select min(cikey) from TEMP_UPGRADE_CI where ecid = in_ecid );
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
                log_debug('No cube_instance found for ecid  : ' || in_ecid, log_file);  
        END;
        BEGIN 
            Select  Composite_Name,Domain_Name,Composite_Revision,Composite_Label,RECEIVE_DATE,tenant_id into dlv_composite_name,dlv_composite_domain,dlv_composite_version,dlv_composite_label,   dlv_created_time,dlv_tenant_id from DLV_MESSAGE  where ecid = in_ecid 
            and rownum =1 order by RECEIVE_DATE ;
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
                log_debug('No dlv_message found for ecid  : ' || in_ecid, log_file);
        END ;        
        BEGIN 
            Select Component_Name,Created_Time,tenant_id into tmp_component_name,tmp_created_time,tmp_tenant_id From Mediator_Instance Where id = (Select Min(id) From TEMP_UPGRADE_MI where ecid = in_ecid);
            EXCEPTION
            WHEN NO_DATA_FOUND THEN
                log_debug('No mediator_instance found for ecid  : ' || in_ecid, log_file);                                     
        END;

        if tmp_component_name is not null  and tmp_created_time < m_created_time then  
            tmp_component_dn := component_dn_type(tmp_component_name);
            m_created_time := tmp_created_time;
            m_composite_domain := tmp_component_dn.partition_name;
            m_composite_name := tmp_component_dn.composite_name;
            m_composite_version := tmp_component_dn.revision;
            m_composite_label := tmp_component_dn.label;
            m_tenant_id := tmp_tenant_id;
        elsif dlv_created_time is not null  and dlv_created_time < m_created_time then 
            
            m_created_time := dlv_created_time;
            m_composite_domain := dlv_composite_domain;
            m_composite_name := dlv_composite_name;
            m_composite_version := dlv_composite_version;
            m_composite_label := dlv_composite_label;
            m_tenant_id := dlv_tenant_id;
        end if ;
        -- TODO other components 
        --Check if this is instance was created after the upgrade. Sometimes the mid-tier might call the script for a new instance.(Error Scenarios).
        BEGIN 
            select soa_upgrade_date into m_upgrade_date from version;
            EXCEPTION 
            WHEN NO_DATA_FOUND THEN
                return composite_instance_row;
        END;
        if m_upgrade_date is not null and m_upgrade_date < m_created_time then
            return composite_instance_row;
        end if;
        if m_composite_name is not null then 
            m_composite_id := get_next_id('COMPOSITE_INSTANCE_IDS'); 
            log_debug(' id generated for dummy composite instance '|| m_composite_id , log_file);
            m_composite_dn := m_composite_domain || '/' || m_composite_name || '!' || m_composite_version || '*' || m_composite_label;
            BEGIN 
                select id into m_sca_partition_id from sca_partition where name = m_composite_domain;
                EXCEPTION 
                WHEN NO_DATA_FOUND THEN
                     log_debug(' SCA partition id not found for  '|| m_composite_domain , log_file);
            END;
            INSERT into composite_instance(ecid,id,composite_dn,state,partition_date,created_time,updated_time,tenant_id,flow_id) 
                values( in_ecid, m_composite_id,m_composite_dn,  -1, m_created_time,m_created_time, m_created_time,m_tenant_id,in_flow_id);
            -- Insert into temp tables for later use
            INSERT into TEMP_UPGRADE_CPST_INST(ecid,id,composite_dn,state,partition_date,created_time,updated_time,tenant_id,flow_id) 
                values( in_ecid, m_composite_id,m_composite_dn,  -1, m_created_time,m_created_time, m_created_time,m_tenant_id,in_flow_id);
            
            update_flow_ids_bpel(in_ecid,in_flow_id,log_file,m_composite_id,null,true,m_sca_partition_id,sca_partition_count);
            update_flow_ids_workflow(in_ecid,in_flow_id,m_composite_id,log_file);
			update_cmpst_ids_mediator(in_ecid,m_composite_id);
            cm_migrate.upgrade_flow_ids_cm(in_ecid,in_flow_id,m_composite_id);
        
            composite_instance_row.composite_dn := m_composite_dn;
            composite_instance_row.created_time := m_created_time;
            composite_instance_row.updated_time := m_created_time;
            composite_instance_row.tenant_id := m_tenant_id;
            composite_instance_row.id := m_composite_id ;
        end if;
        log_debug('out of  handle_orphaned_case', log_file);
        return composite_instance_row;
end handle_orphaned_case; 
	
function  get_tracking_data_to_return(in_flow_id in  number,component_id_val in varchar2 ,engine_type in varchar2,component_fault_key_val in varchar2, log_file IN utl_file.file_type) return varchar2 IS
	   ret_fault_id_val number :=0;
	   ret_sca_entity_id_val number :=0;
	   ret_sca_partition_id_val number := 0;
	   ret_owner_cikey number :=0;
	   ret_retry_count number :=0;
	   ret_str_val varchar2(200);
	   ret_str_val_assoc varchar2(200);
	   fault_id_name varchar2(9) := 'FAULT_ID=';
	   sca_partition_id_name varchar2(17) := 'SCA_PARTITION_ID=';
	   sca_entity_id_name varchar2(14) := 'SCA_ENTITY_ID=';
	   flow_id_name varchar2(8) := 'FLOW_ID=';
	   component_id_name varchar2(13) := 'COMPONENT_ID=';
	   owner_cikey_name varchar2(13) := 'OWNER_CIKEY=';
	   retry_count_name varchar2(13) := 'RETRY_COUNT=';
	   composite_dn varchar2(500);
	   participating_composite_dn composite_dn_type;
	   existing_component_id number := 0;
	   existing_component_name varchar2(500);
	   BEGIN
			  --first check if component_fault_key is present . if present it means its a fault recovery. query sca_common_fault with component_fault_key
			  log_debug('component_fault_key_val ' || component_fault_key_val, log_file);
			  log_debug('engine type ' || engine_type, log_file);
			    --Logic for workflow approval
			  if (engine_type = 'workflow' and component_fault_key_val is not null ) then
			
			     log_debug('into if loop for workflow', log_file);
		     BEGIN 		  
					select COMPOSITEDN , componentname,component_instance_id  into composite_dn, existing_component_name,
					existing_component_id from wftask where taskid = component_fault_key_val;
				EXCEPTION 
		     WHEN NO_DATA_FOUND THEN
				log_debug('NO composite_dn for workflow task ID ' || component_fault_key_val, log_file);
			   END;
					participating_composite_DN := composite_dn_type(composite_dn);
					log_debug('componentname' || existing_component_name, log_file);
                    cache_util.get_cache_query_type_4_output(name => participating_composite_DN.partition_name, sca_partition_id => ret_sca_partition_id_val);
					select id into ret_sca_entity_id_val from sca_entity where sca_partition_id = ret_sca_partition_id_val and composite = participating_composite_DN.composite_name and revision = participating_composite_DN.revision and name = existing_component_name and --label = participating_composite_DN.label and
					type = 'component' and sub_type = 'implementation.workflow';

			  end if;
			  
			  --Logic for case management 
			 if (engine_type = 'casemanagement' and component_fault_key_val is not null ) then
			
			     log_debug('into if loop for workflow', log_file);
		     BEGIN 		  
					select COMPOSITE_DN , COMPONENT_NAME,COMPONENT_INSTANCE_ID  into composite_dn, existing_component_name,
					existing_component_id from cm_case_header where ID = component_fault_key_val;
				EXCEPTION 
		     WHEN NO_DATA_FOUND THEN
				log_debug('NO composite_dn for case management task ID ' || component_fault_key_val, log_file);
			   END;
					participating_composite_DN := composite_dn_type(composite_dn);
					log_debug('componentname' || existing_component_name, log_file);
                    cache_util.get_cache_query_type_4_output(name => participating_composite_DN.partition_name, sca_partition_id => ret_sca_partition_id_val);
					select id into ret_sca_entity_id_val from sca_entity where sca_partition_id = ret_sca_partition_id_val and composite = participating_composite_DN.composite_name and revision = participating_composite_DN.revision and name = existing_component_name and --label = participating_composite_DN.label and
					type = 'component' and sub_type = 'implementation.casemanagement';

			  end if;
			  -- End of Logic for case management
			  if component_fault_key_val is not null and (engine_type = 'null' OR engine_type = 'bpel') then
				BEGIN	
					select id, OWNER_SCA_PARTITION_ID, OWNER_SCA_ENTITY_ID,OWNER_CIKEY,RETRY_COUNT into ret_fault_id_val,ret_sca_partition_id_val,ret_sca_entity_id_val,ret_owner_cikey,ret_retry_count from sca_common_fault where component_fault_key = component_fault_key_val and state in (512,768,1024,1280,1536,2048,3072) ;
				EXCEPTION 
					WHEN NO_DATA_FOUND THEN
						log_debug('NO DATA FOUND for component_fault_key' || component_fault_key_val, log_file);
					END;	    
			  end if;
			  if ret_fault_id_val = 0 and component_id_val != 0 and component_id_val is not null then 
				BEGIN
					select id, OWNER_SCA_PARTITION_ID , OWNER_SCA_ENTITY_ID,OWNER_CIKEY,RETRY_COUNT into ret_fault_id_val,ret_sca_partition_id_val,ret_sca_entity_id_val,ret_owner_cikey,ret_retry_count from sca_common_fault where owner_cikey =  component_id_val  and state in (512,768,1024,1280,1536,2048,3072) and rownum =1  ;
				EXCEPTION 
					WHEN NO_DATA_FOUND THEN
						log_debug('NO DATA FOUND for component_id' || component_id_val, log_file);
				END;
			  end if;
			  --TODO remove the following if block once the call to CubeFabricUtil.callInitializeTrackingContextReHydrate() is removed by BPEL
			  if ret_fault_id_val = 0 and (component_id_val is not null or component_fault_key_val is not null ) then 
				BEGIN
					select id, OWNER_SCA_PARTITION_ID , OWNER_SCA_ENTITY_ID, OWNER_CIKEY ,RETRY_COUNT into ret_fault_id_val,ret_sca_partition_id_val,ret_sca_entity_id_val,ret_owner_cikey,ret_retry_count from sca_common_fault where owner_component_type = 'bpel'   and state in (512,768,1024,1280,1536,2048,3072) and flow_id = in_flow_id and rownum=1;		   
				EXCEPTION 
					WHEN NO_DATA_FOUND THEN
					log_debug('NO DATA FOUND for owner type BPEL' , log_file);
				END;			
			  end if;  
					--ret_str_val := flow_id_name || existing_flow_id ||';' ;
					--TODO logic for non-fault in-flight instances
			ret_str_val :=  flow_id_name || in_flow_id ||';' ||fault_id_name || ret_fault_id_val || ';' || sca_partition_id_name ||
			ret_sca_partition_id_val || ';' || sca_entity_id_name ||
			ret_sca_entity_id_val || ';' || component_id_name || existing_component_id ||';' || owner_cikey_name || ret_owner_cikey || ';'
			|| retry_count_name || ret_retry_count || ';';
			return ret_str_val;
	END get_tracking_data_to_return;
	
	function dlv_msg_table_type_const return dlv_msg_table_type IS
		dlv_msg_table dlv_msg_table_type ;
		dlv_msg dlv_msg_type := dlv_msg_type();
		begin
		      dlv_msg.dlv_type := -1; 
	              dlv_msg_table(0) := dlv_msg;
		return dlv_msg_table;
	end dlv_msg_table_type_const;
	function work_item_table_type_const return work_item_table_type IS
		work_item_table work_item_table_type ;
		work_item work_item_type := work_item_type();
		begin
		      work_item.cikey := -1; 
	              work_item_table(0) := work_item;
		return work_item_table;
	end work_item_table_type_const;
    
    
procedure populate_tmp_tables(ecid_list in ecid_list_type, log_file in utl_file.file_type) is 
    dlv_count number := 0;
    prev_ecid varchar2(100);
    prev_cmpst number;
    wi_count number;
    BEGIN
    log_debug('Inside populate_tmp_tables with count of ecid :'|| to_char(ecid_list.COUNT),log_file);
    forall ecids in ecid_list.first..ecid_list.last
        insert into  TEMP_UPGRADE_ECID values(ecid_list(ecids)); 
    -- Consider the associated ecids also for upgrade    
    insert into  TEMP_UPGRADE_ECID select assoc2_ecid from composite_instance_assoc where assoc1_ecid in (select  /*+ INDEX(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) */  ecid from temp_upgrade_ecid);
     INSERT INTO TEMP_UPGRADE_CPST_INST  SELECT ID ,ECID ,PARENT_ID ,CONVERSATION_ID ,COMPOSITE_DN ,TITLE ,LIVE_INSTANCES ,CREATED_TIME ,UPDATED_TIME ,PARTITION_DATE ,TENANT_ID ,STATE ,CREATED_BY ,UPDATED_BY ,FLOW_ID FROM COMPOSITE_INSTANCE where ecid in (select  /*+ INDEX_FFS(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) cardinality(TEMP_UPGRADE_ECID 100)*/ ecid from temp_upgrade_ecid);
    insert into TEMP_UPGRADE_CI select cikey,cmpst_id,component_name,state,componenttype,ecid,CONVERSATION_ID,DOMAIN_NAME,COMPOSITE_NAME ,COMPOSITE_REVISION,COMPOSITE_LABEL from cube_instance where ecid in (select  /*+ INDEX_FFS(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) cardinality(TEMP_UPGRADE_ECID 100)*/ ecid from temp_upgrade_ecid );
    insert into TEMP_UPGRADE_MI select flow_id,ecid,composite_instance_id, id, component_name, component_state, case_num, group_id, source_action_name, resequencer_type from mediator_instance where ecid in (select  /*+ INDEX_FFS(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) cardinality(TEMP_UPGRADE_ECID 100)*/ ecid from temp_upgrade_ecid );
    insert into TEMP_UPGRADE_MCI select instance_id,id,def_message_id,retry_count,fault_name,exception_type,exception_msg,created_time, recoverable from mediator_case_instance where instance_id in (select /*+ INDEX_FFS(TEMP_UPGRADE_MI TEMP_UPGRADE_MI_ID) cardinality(TEMP_UPGRADE_MI 100) */ id from temp_upgrade_mi );
	insert into TEMP_UPGRADE_MCDV select instance_id from mediator_case_detail_v where instance_id in (select /*+ INDEX(TEMP_UPGRADE_MI TEMP_UPGRADE_MI_ID) */ id from temp_upgrade_mi ) and (state = 4 OR state = 8);
    INSERT INTO TEMP_UPGRADE_WFTASK SELECT ECID ,TASKID ,COMPOSITEINSTANCEID ,COMPONENTNAME ,STATE ,COMPONENTTYPE,COMPOSITEDN FROM WFTASK where ecid in (select  /*+ INDEX_FFS(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) cardinality(TEMP_UPGRADE_ECID 100)*/ ecid from temp_upgrade_ecid) AND (WORKFLOWPATTERN IS NULL OR WORKFLOWPATTERN <> 'FYI');
    INSERT INTO TEMP_UPGRADE_BRDECISION SELECT ECID ,ID ,COMPOSITE_INSTANCE_ID ,COMPONENT_NAME,STATE FROM BRDECISIONINSTANCE where ecid in (select  /*+ INDEX_FFS(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) cardinality(TEMP_UPGRADE_ECID  100) */ ecid from temp_upgrade_ecid);
   
    INSERT INTO TEMP_UPGRADE_DLV_MSG  select DLV_TYPE ,MESSAGE_GUID,COMPONENT_NAME,CIKEY,RECEIVE_DATE,CONV_ID,DOMAIN_NAME,COMPOSITE_NAME,COMPOSITE_REVISION,COMPOSITE_LABEL,STATE,COMPONENT_TYPE,ECID,TENANT_ID from dlv_message where ecid in (select  /*+ INDEX_FFS(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) cardinality(TEMP_UPGRADE_ECID 100)*/ ecid from temp_upgrade_ecid ) ;
 	INSERT INTO TEMP_UPGRADE_DLV_ECID_MAP select MESSAGE_GUID,ECID from TEMP_UPGRADE_DLV_MSG where state in (0,1,4);
    
    INSERT INTO TEMP_UPGRADE_WKITM_CI  select wi.CIKEY ,wi.STATE,wi.NODE_ID, wi.SCOPE_ID,wi.CREATION_DATE,wi.COUNT_ID,wi.EXP_FLAG,wi.EXP_DATE,ci.COMPONENT_NAME,ci.COMPONENTTYPE,ci.composite_id,ci.ECID from WORK_ITEM wi, TEMP_UPGRADE_CI ci where wi.cikey = ci.cikey and  wi.state in ( 1,3,13 );-- and ci.ecid in (select  /*+ INDEX(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) */ ecid from temp_upgrade_ecid ) ;
	commit;
       
end populate_tmp_tables;

procedure append_tmp_tables(ecid_list in ecid_list_type, log_file in utl_file.file_type) is 
    dlv_count number := 0;
    prev_ecid varchar2(100);
    prev_cmpst number;
    wi_count number;
    ecid_val varchar2(100);
	
    BEGIN
    log_debug('Inside append_tmp_tables with count of ecid :'|| to_char(ecid_list.COUNT),log_file);
	
    for ecid_index in ecid_list.first..ecid_list.last loop
        ecid_val := ecid_list(ecid_index);
        log_debug('appending ecid :'|| ecid_val,log_file);
        insert into  TEMP_UPGRADE_ECID values(ecid_val); 
        INSERT INTO TEMP_UPGRADE_CPST_INST  SELECT ID ,ECID ,PARENT_ID ,CONVERSATION_ID ,COMPOSITE_DN ,TITLE ,LIVE_INSTANCES ,CREATED_TIME ,UPDATED_TIME ,PARTITION_DATE ,TENANT_ID ,STATE ,CREATED_BY ,UPDATED_BY ,FLOW_ID FROM COMPOSITE_INSTANCE where ecid = ecid_val;
        insert into TEMP_UPGRADE_CI select cikey,cmpst_id,component_name,state,componenttype,ecid,CONVERSATION_ID,DOMAIN_NAME,COMPOSITE_NAME ,COMPOSITE_REVISION,COMPOSITE_LABEL from cube_instance where ecid = ecid_val;
        insert into TEMP_UPGRADE_MI select flow_id,ecid,composite_instance_id, id, component_name, component_state, case_num, group_id, source_action_name, resequencer_type from mediator_instance where ecid = ecid_val;
        insert into TEMP_UPGRADE_MCI select instance_id,id,def_message_id,retry_count,fault_name,exception_type,exception_msg,created_time, recoverable from mediator_case_instance where instance_id in (select /*+ INDEX_FFS(TEMP_UPGRADE_MI TEMP_UPGRADE_MI_ID) cardinality(TEMP_UPGRADE_MI 100) */ id from temp_upgrade_mi where ecid = ecid_val );
        insert into TEMP_UPGRADE_MCDV select instance_id from mediator_case_detail_v where instance_id in (select /*+ INDEX(TEMP_UPGRADE_MI TEMP_UPGRADE_MI_ID) */ id from temp_upgrade_mi  where ecid = ecid_val) and (state = 4 OR state = 8);
        INSERT INTO TEMP_UPGRADE_WFTASK SELECT ECID ,TASKID ,COMPOSITEINSTANCEID ,COMPONENTNAME ,STATE ,COMPONENTTYPE,COMPOSITEDN FROM WFTASK where ecid = ecid_val;
        INSERT INTO TEMP_UPGRADE_BRDECISION SELECT ECID ,ID ,COMPOSITE_INSTANCE_ID ,COMPONENT_NAME,STATE FROM BRDECISIONINSTANCE where ecid = ecid_val;
        INSERT INTO TEMP_UPGRADE_DLV_MSG  select DLV_TYPE ,MESSAGE_GUID,COMPONENT_NAME,CIKEY,RECEIVE_DATE,CONV_ID,DOMAIN_NAME,COMPOSITE_NAME,COMPOSITE_REVISION,COMPOSITE_LABEL,STATE,COMPONENT_TYPE,ECID,TENANT_ID from dlv_message where ecid = ecid_val;
        INSERT INTO TEMP_UPGRADE_DLV_ECID_MAP select MESSAGE_GUID,ECID from TEMP_UPGRADE_DLV_MSG where state in (0,1,4) and ecid = ecid_val;
        INSERT INTO TEMP_UPGRADE_WKITM_CI  select wi.CIKEY ,wi.STATE,wi.NODE_ID, wi.SCOPE_ID,wi.CREATION_DATE,wi.COUNT_ID,wi.EXP_FLAG,wi.EXP_DATE,ci.COMPONENT_NAME,ci.COMPONENTTYPE,ci.composite_id,ci.ECID from WORK_ITEM wi, TEMP_UPGRADE_CI ci where wi.cikey = ci.cikey and  wi.state in ( 1,3,13 ) and ecid = ecid_val;-- and ci.ecid in (select  /*+ INDEX(TEMP_UPGRADE_ECID ECID_TEMP_UPGRADE_ECID) */ ecid from temp_upgrade_ecid ) ;
        log_debug('appending ecid completed:'|| ecid_val,log_file);
    end loop;
end append_tmp_tables;


procedure insert_default_sequence as 
    BEGIN
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'FAULT_IDS',-1,-1);
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'FLOW_INSTANCE_IDS',-1,-1);
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'COMPONENT_INSTANCE_IDS',-1,-1);
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_ENTITY_IDS',-1,-1);
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_REJECTED_MSG_IDS',-1,-1);
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_REJECTED_MSG_IDS',-1,-1);
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'COMPOSITE_INSTANCE_IDS',-1,-1);
end insert_default_sequence;

function migrate_ecid( ecid in varchar2,
                       log_file IN utl_file.file_type default null,
                       flow_id in integer default 0,
                       flow_correlation_id  in varchar2 default null,
                       component_id_val in varchar2 default null,
                       component_dn in varchar2 default null,
                       component_fault_key_val in varchar2 default null,
                       engine_type in varchar2 default null,
                      -- commit_after_execution in boolean default true,
                      -- dlv_msg_table in  dlv_msg_table_type default dlv_msg_table_type_const(),
                      -- work_item_table in work_item_table_type default work_item_table_type_const(),
                      -- use_ci_temp_table in boolean default false,
                       is_midtier_upgrade in boolean default true,
                       mid_process_flow in integer default 0 ,
                       sca_partition_count in integer default 0,
                       fa_env in boolean default false
                       ) 
    return varchar2 is

    sequence_val integer;
    flow_id_val integer;
    flow_correlation_id_val varchar2(100);
    total_live_instances integer := 0 ;
    --fault  fault_details;
    type faults_type is table of fault_details; --  index by binary_integer;
    -- type sca_flow_to_cpst_table_type is table of sca_flow_to_cpst_type;
    sca_flow_to_cpst_table sca_flow_to_cpst_table_type := sca_flow_to_cpst_table_type();
    sca_flow_to_cpst_obj sca_flow_to_cpst_type;
    sca_flow_to_cpst_count integer := 0;
    unhandled_faults faults_type;
    recoverable_faults faults_type;
    unhandled_count integer;
    recoverable_count integer;
    composite_dn varchar2(500);
    participating_composite_dn composite_dn_type;
    participating_sca_entity_id integer;
    participating_partition_id integer;
    initiating_composite_dn composite_dn_type;
    initiating_sca_entity_id integer;
    initiating_partition_id integer;
    initiating_tenant_id integer;
    initiating_created_by varchar2(100);
    initiating_updated_by varchar2(100);
    initiating_created_time timestamp;
    initiating_updated_time timestamp;
    cmp_ecid varchar2(500);
    fault_ids_seq VARCHAR(100) := 'FAULT_IDS';
    flow_ids_seq  VARCHAR (100) := 'FLOW_INSTANCE_IDS';
    fault_id_val number;
    fault_id_val_str varchar2(20);  
    common_fault_type enum_fault_type := new enum_fault_type;
    common_fault_type_val varchar2(10);
    ret_str_val varchar2(200);
    ret_str_val_assoc varchar2(200);
    is_fault_recoverable boolean := false;
    is_fault_recovery boolean := false; --indicates if its a recovery or processing a new message
    existing_flow_id number := 0;
    SE_status  SE_status_type;
    total_active_cmpt_count number := 0;
    active_cmpt_count number := 0;
    total_recoverable_count number := 0;
    total_unhandled_count number := 0;
    admin_state_val number := -1;
    is_orphaned_case boolean := false;
    is_aborted_instance boolean := false;
    is_staled_instance boolean := false; 
    ret_migration migration_return_type;
    --use_ci_temp_table_val boolean := use_ci_temp_table;
    temp_ecid_list  ecid_list_type;
    temp_ecid_count number := 0;
    temp_id number := 0;
    child_components cpst_child_comp_type;
    bpel_component_present boolean := false;
    mediator_component_present boolean := false;
    decision_component_present boolean := false;
    case_mgmt_component_present boolean := false;
    workflow_component_present boolean := false;
    properties varchar2(200):='';  
    ----------recoverable data ------------------------
    recoverable_fault_id_val number;
    recoverable_sca_entity_id number;
    
    ---------BPEL Variables-----------------------
    bpel_sca_entity_id integer;
    bpel_state integer;
    fault_claimed boolean := false;
    IC_recovery_claimed boolean := false;
    bpel_component_key varchar2(1000);
    bpel_system_fault varchar2(62) := '{http://schemas.oracle.com/bpel/extension}RuntimeFaultMessage';
    bpel_owsm_fault varchar2(65) := '{http://schemas.oracle.com/bpel/extension}OWSMPolicyFaultMessage';
    type bpel_faults_type is table of bpel_fault_type;
    bpel_faults  bpel_faults_type;
    subscriber_id_val varchar2(1024);
    subs_state number;
    conv_type_val number;
    dummy_composite_row composite_instance_type;
    ret_sca_partition_id number;
    count_ret_sca_partition_id number;
    processed_dlv_message_array  processed_dlv_message;
    unique_constraint EXCEPTION; 
    PRAGMA EXCEPTION_INIT(unique_constraint, -06512);
	assoc2_ecid_count number;
    
    ---------BPEL Variables------------------------ 

    begin
    
    cmp_ecid := ecid;
    if(fa_env = true) then
       properties := '{state=false}';
    end if;
    
    if(is_midtier_upgrade = true) then 
        log_debug('Starting is_midtier_upgrade', log_file);
        BEGIN
            select flow_id into existing_flow_id  from COMPOSITE_INSTANCE c  where ecid =cmp_ecid and rownum = 1 ;
            EXCEPTION 
            WHEN NO_DATA_FOUND THEN 
                is_orphaned_case := true;
               -- use_ci_temp_table_val := false;
        END;
        if existing_flow_id is not null AND existing_flow_id != 0 then
            -- ecid has already been migrated. return the details 
            return get_tracking_data_to_return(existing_flow_id,component_id_val,engine_type,component_fault_key_val, log_file) ;
        else 
            insert_default_sequence();
            temp_ecid_list := ecid_list_type(cmp_ecid);
            truncate_temp_tables();
            populate_tmp_tables(temp_ecid_list,log_file);      
            
        end if;
    end if;
    if flow_id > 0 then 
        flow_id_val := flow_id;
    else
        flow_id_val := get_next_id(flow_ids_seq);   
    end if;	
    if flow_correlation_id is null then
        flow_correlation_id_val := ecid;  
    else
        flow_correlation_id_val := flow_correlation_id;
    end if;
    log_debug('Flow Correlation Id  = ' || flow_correlation_id_val, log_file);
    log_debug('flow_id_val  = ' || flow_id_val, log_file);
    log_debug('ecid  = ' || ecid, log_file);
       --get initiating composite
    if(is_orphaned_case = false) then
       BEGIN
            select /*+ INDEX(COMPOSITE_INSTANCE COMPOSITE_INSTANCE_ID) */ composite_dn_type(composite_dn),created_time,updated_time,created_by,updated_by, tenant_id, flow_id into initiating_composite_dn, initiating_created_time,initiating_updated_time,initiating_created_by, initiating_updated_by, initiating_tenant_id, existing_flow_id  from COMPOSITE_INSTANCE where id = (select min(temp.id) from TEMP_UPGRADE_CPST_INST temp where temp.ecid = cmp_ecid) AND ROWNUM < 2;
            EXCEPTION 
            WHEN NO_DATA_FOUND THEN
                log_debug('NO Composites found for ecid ' || ecid, log_file);
                is_orphaned_case := true;
        END;
    end if;
    if existing_flow_id is not null AND existing_flow_id != 0 then
            -- ecid has already been migrated. return the details 
            return get_tracking_data_to_return(existing_flow_id,component_id_val,engine_type,component_fault_key_val, log_file) ;
    end if;
    if is_orphaned_case = true then 
        log_debug('orphaned instance', log_file);
        dummy_composite_row := handle_orphaned_case(ecid, flow_id_val, log_file, sca_partition_count);
        -- if no composite_instance was found and its not really a orphan case . Might be a fresh instance(error scenario where upgrade script gets called due to no flow_id)
        if dummy_composite_row.created_time is null then
            return 'FLOW_ID=' || '-1;';
        end if;

        initiating_composite_dn := composite_dn_type(dummy_composite_row.composite_dn);
        initiating_created_time := dummy_composite_row.created_time;
        initiating_updated_time := dummy_composite_row.updated_time;
        initiating_tenant_id := dummy_composite_row.tenant_id;
    end if;

    --get initiating partition id
    cache_util.get_cache_query_type_4_output(name => initiating_composite_dn.partition_name, sca_partition_id => initiating_partition_id);
    --get initiating sca_entity_id
    if initiating_partition_id > 0 then
        log_debug('initiating partition id = '||  initiating_partition_id, log_file);
        log_debug('initiating composite name  = '||  initiating_composite_dn.composite_name, log_file);
        log_debug('initiating revision  = '||  initiating_composite_dn.revision, log_file);
        log_debug('initiating label  = '||  initiating_composite_dn.label, log_file);
        BEGIN
            cache_util.get_cache_query_type_1_output(partition_id => initiating_partition_id,composite => initiating_composite_dn.composite_name, revision => initiating_composite_dn.revision, sca_entity_id => initiating_sca_entity_id);
        EXCEPTION
            WHEN NO_DATA_FOUND THEN
                if is_orphaned_case = true then
                    -- in order to handle mediator orphaned instances having dummy label, 
                    -- ignore label comparision and check for state of sca_entity is active
                    select id into initiating_sca_entity_id from sca_entity where sca_partition_id = initiating_partition_id and composite = initiating_composite_dn.composite_name and revision = initiating_composite_dn.revision and type='composite' and state = 'active';
                else
                    raise;
                end if;
        END;

        processed_dlv_message_array.DELETE;
        FOR ci_inst IN
        (SELECT /*+ INDEX(ci TEMP_CPST_INST_ECID) */ ID, composite_DN,parent_id, title, conversation_id, live_instances,created_time,updated_time, partition_date,tenant_id,state  FROM TEMP_UPGRADE_CPST_INST ci   WHERE ci.ECID =cmp_ecid)
        LOOP
            --create participating_composite_DN 
            participating_composite_DN := composite_dn_type(ci_inst.composite_DN);
            cache_util.get_cache_query_type_4_output(name => participating_composite_DN.partition_name, sca_partition_id => participating_partition_id);
            BEGIN
                --get initiating sca_entity_id
                cache_util.get_cache_query_type_1_output(partition_id => participating_partition_id,composite => participating_composite_DN.composite_name, revision => participating_composite_DN.revision, sca_entity_id => participating_sca_entity_id);
                EXCEPTION
                WHEN NO_DATA_FOUND THEN
                    if is_orphaned_case = true then
                        -- in order to handle mediator orphaned instances having dummy label, ignore label comparison and check for state of sca_entity is active
                        --get initiating sca_entity_id
                        select id into participating_sca_entity_id from sca_entity where sca_partition_id = participating_partition_id and composite = participating_composite_DN.composite_name and revision = participating_composite_DN.revision  and type='composite' and state = 'active';     
                else    
                    raise;
                end if;
            END;
            --update total_live_instances
            total_live_instances := total_live_instances + ci_inst.live_instances;
            --add element  into the sca_flow_to_cpst_table
            sca_flow_to_cpst_count := sca_flow_to_cpst_count +1;
            sca_flow_to_cpst_table.EXTEND;
           BEGIN
            sca_flow_to_cpst_table(sca_flow_to_cpst_count) := sca_flow_to_cpst_type
            (
                ci_inst.ID,
                flow_id_val,
                ci_inst.title,
                participating_sca_entity_id,
                ci_inst.created_time,
                ci_inst.updated_time,
                ci_inst.live_instances,
                ci_inst.partition_date,
                participating_partition_id,
                ci_inst.tenant_id,
                ci_inst.composite_dn,
                participating_composite_DN.partition_name,
                participating_composite_DN.composite_name,
                participating_composite_DN.revision,
                participating_composite_DN.label); 
           EXCEPTION
            WHEN OTHERS THEN
            sca_flow_to_cpst_table(sca_flow_to_cpst_count) := sca_flow_to_cpst_type
            (
                ci_inst.ID,
                flow_id_val,
                substr(ci_inst.title,1,50) || ' _TRIMMED_',
                participating_sca_entity_id,
                ci_inst.created_time,
                ci_inst.updated_time,
                ci_inst.live_instances,
                ci_inst.partition_date,
                participating_partition_id,
                ci_inst.tenant_id,
                ci_inst.composite_dn,
                participating_composite_DN.partition_name,
                participating_composite_DN.composite_name,
                participating_composite_DN.revision,
                participating_composite_DN.label); 
           END;

            log_debug(ci_inst.ID || ' ' || ci_inst.composite_DN, log_file);
            -- if any of the composite instance is in stale or aborted state  and not running then mark the flow as terminated
            if ci_inst.state >= 0 then --orphaned instances will have a state of -1
                if BITAND(ci_inst.state,16) = 16  THEN
                    is_aborted_instance := true;
                end if ;
                if BITAND(ci_inst.state,64) = 64 then
                    is_staled_instance := true;
                end if;	
            end if;

        END LOOP;

        -- insert into the sca_flow_instance table 
        INSERT INTO SCA_FLOW_INSTANCE
        (
            FLOW_ID,
            FLOW_CORRELATION_ID,
            ECID,
            CONVERSATION_ID,
            --TITLE  new functionality in 12c
            COMPOSITE_SCA_ENTITY_ID,
            SCA_PARTITION_ID,
            ACTIVE_COMPONENT_INSTANCES,
            UNHANDLED_FAULTS,
            RECOVERABLE_FAULTS,
            ADMIN_STATE,
            --PURGEABLE, Not supported for upgraded instances
            RESEQUENCER,
            PROPERTIES, --supported for fa upgrade to 12c not capturing flow instance state.
            CREATED_BY,
            CREATED_TIME,
            UPDATED_BY,
            UPDATED_TIME,
            TENANT_ID
            --TEST_RUN_NAME, TODO
            --TEST_RUN_ID, TODO
            --TEST_SUITE,TODO
            --TEST_CASE TODO
        )
        VALUES
        (
            flow_id_val,
            flow_correlation_id_val,
            cmp_ecid,
            NULL,    --TODO conversation_id
            initiating_sca_entity_id,   --composite_sca_entity_id
            initiating_partition_id,     --sca_partition_id
            total_live_instances,   --active_component_instances
            unhandled_count,    --unhandled_faults
            recoverable_count,  --recoverable_faults
            admin_state_val, --admin_state TODO admin_state(suspended,terminated, stale ) wouldnt occur for recoverable instance, however since in 
                                        -- 11g state was associated with composite, one of the composite in the same flow(ecid) might be in a terminated state
            0, --resequencer TODO defaulted to false for now. Need to look at it for resequencer cases			 
            properties,
            initiating_created_by,  --created_by
            initiating_created_time, --created_time,
            initiating_updated_by,   --updated by,
            initiating_created_time, --updated_time, 	
            initiating_tenant_id --tenant_id  
        );
    end if; -- if the intiating_partition_id is not null, then dont insert into sca_flow_instance table
    SE_status := SE_status_type();
    if sca_flow_to_cpst_table.COUNT > 0 then
        FOR i IN sca_flow_to_cpst_table.FIRST..sca_flow_to_cpst_table.LAST LOOP
            active_cmpt_count := 0;
            sca_flow_to_cpst_obj := sca_flow_to_cpst_table(i);
            child_components :=cpst_child_comp_type(sca_flow_to_cpst_obj.composite_name,sca_flow_to_cpst_obj.sca_partition_id, sca_flow_to_cpst_obj.revision,sca_flow_to_cpst_obj.label);
            
            --if child_components.has_bpel_component() = true or is_orphaned_case = true then
                process_bpel(cmp_ecid,flow_id_val, sca_flow_to_cpst_obj,SE_status,log_file, component_id_val,component_dn,
                    component_fault_key_val,is_orphaned_case,processed_dlv_message_array);
                active_cmpt_count :=  active_cmpt_count + SE_status.active_component_count;
                log_debug('total_active_count incremented for bpel = ' || active_cmpt_count, log_file); 
                total_recoverable_count := total_recoverable_count + SE_status.recoverable_fault_count;
                total_unhandled_count := total_unhandled_count + SE_status.unhandled_count;
                if SE_status.is_aborted = 1 then
                    is_aborted_instance := true;
                elsif SE_status.is_stale = 1 then
                    is_staled_instance := true;
                end if;
                bpel_component_present := true;
            --end if;
            
            --if child_components.has_mediator_component() = true or is_orphaned_case = true then
                SE_status.reset_values();
                mediator_migrate.perform_mediator_upgrade(cmp_ecid, flow_id_val, sca_flow_to_cpst_obj, component_id_val, component_dn, component_fault_key_val, se_status, log_file, is_orphaned_case);
                active_cmpt_count :=  active_cmpt_count + SE_status.active_component_count;
                total_recoverable_count := total_recoverable_count + SE_status.recoverable_fault_count;
                total_unhandled_count := total_unhandled_count + SE_status.unhandled_count;
                log_debug('total_active_count incremented for mediator = ' || SE_status.active_component_count, log_file);
                if SE_status.is_aborted = 1 then
                    is_aborted_instance := true;
                elsif SE_status.is_stale = 1 then
                    is_staled_instance := true;
                end if;
                mediator_component_present := true;
            --end if;

            --if child_components.has_workflow_component() = true or is_orphaned_case = true then
                SE_status.reset_values();
                process_workflow(cmp_ecid,flow_id_val, sca_flow_to_cpst_obj,SE_status,is_orphaned_case,log_file);
                active_cmpt_count :=  active_cmpt_count + SE_status.active_component_count;
                total_recoverable_count := total_recoverable_count + SE_status.recoverable_fault_count;
                total_unhandled_count := total_unhandled_count + SE_status.unhandled_count;
                log_debug('total_active_count incremented for workflow = ' || SE_status.active_component_count, log_file);
                if SE_status.is_aborted = 1 then
                    is_aborted_instance := true;
                elsif SE_status.is_stale = 1 then
                    is_staled_instance := true;
                end if;
                workflow_component_present := true;  
            --end if;
    
            --if child_components.has_case_management_component() = true or is_orphaned_case = true then
                SE_status.reset_values();
                cm_migrate.perform_cm_upgrade(cmp_ecid,flow_id_val, sca_flow_to_cpst_obj,SE_status);
                active_cmpt_count :=  active_cmpt_count + SE_status.active_component_count;
                total_recoverable_count := total_recoverable_count + SE_status.recoverable_fault_count;
                log_debug('total_active_count incremented for case management = ' || SE_status.active_component_count, log_file);
                if SE_status.is_aborted = 1 then
                    is_aborted_instance := true;
                elsif SE_status.is_stale = 1 then
                    is_staled_instance := true;
                end if;
                case_mgmt_component_present := true;
            --end if;

            --if child_components.has_decision_component() = true or is_orphaned_case = true then
                SE_status.reset_values();
                br_migrate.perform_br_upgrade( flow_id_val, cmp_ecid, sca_flow_to_cpst_obj, se_status, log_file, is_orphaned_case);
                active_cmpt_count :=  active_cmpt_count + SE_status.active_component_count;
                total_recoverable_count := total_recoverable_count + SE_status.recoverable_fault_count;
                total_unhandled_count := total_unhandled_count + SE_status.unhandled_count;
                log_debug('total_active_count incremented for business rules = ' || SE_status.active_component_count, log_file);
                if SE_status.is_aborted = 1 then
                    is_aborted_instance := true;
                elsif SE_status.is_stale = 1 then
                    is_staled_instance := true;
                end if;
                decision_component_present := true;
            --end if;    
            BEGIN 
            if is_orphaned_case = false then
                log_debug('inserting into sca_flow_to_cpst',log_file);
                INSERT INTO SCA_FLOW_TO_CPST
                (
                    COMPOSITE_ID,
                    FLOW_ID,
                    TITLE,
                    COMPOSITE_SCA_ENTITY_ID,
                    CREATED_TIME,
                    UPDATED_TIME,
                    ACTIVE_COMPONENT_INSTANCES,
                    PARTITION_DATE,
                    SCA_PARTITION_ID,
                    TENANT_ID
                )
                VALUES
                (
                    sca_flow_to_cpst_obj.composite_id,
                    sca_flow_to_cpst_obj.flow_id,
                    sca_flow_to_cpst_obj.title,
                    sca_flow_to_cpst_obj.composite_sca_entity_id,
                    sca_flow_to_cpst_obj.created_time,
                    sca_flow_to_cpst_obj.updated_time,
                    active_cmpt_count,
                    sca_flow_to_cpst_obj.partition_date,
                    sca_flow_to_cpst_obj.sca_partition_id,
                    sca_flow_to_cpst_obj.tenant_id
                ); 
            end if;
            EXCEPTION
            WHEN unique_constraint or DUP_VAL_ON_INDEX THEN
                --33746021 allowing process to use already migrated flow_id
                --if mid_process_flow > 0 then
                    select flow_id into  flow_id_val from sca_flow_to_cpst where composite_id = sca_flow_to_cpst_obj.composite_id;
                    log_debug('mid-process - composite id ' || sca_flow_to_cpst_obj.composite_id || ' already migrated',log_file);     
                    return get_tracking_data_to_return(flow_id_val,0,null,null, log_file);
                --else 
                --    raise; 
                --end if;
            END; 
            log_debug('inserted into sca_flow_to_cpst',log_file);
            total_active_cmpt_count := total_active_cmpt_count + active_cmpt_count;
        END LOOP;  --end of flow_to_cpst loop
    end if;
    if is_orphaned_case = false then 
        --if bpel_component_present = true then
            update_flow_ids_bpel(cmp_ecid,flow_id_val, log_file,0,sca_flow_to_cpst_table,false,0,sca_partition_count);
        --end if;
        --if workflow_component_present = true then
            update_flow_ids_workflow(cmp_ecid,flow_id_val,0,log_file);
        --end if;
        --if case_mgmt_component_present = true then
            cm_migrate.upgrade_flow_ids_cm(cmp_ecid,flow_id_val);
        --end if;
        --if decision_component_present = true then    
            br_migrate.update_br_tables(cmp_ecid,flow_id_val);
        --end if;
        update composite_instance ci set ci.flow_id = flow_id_val where ci.id IN (select /*+ INDEX(tci TEMP_CPST_INST_ECID) */ tci.id from TEMP_UPGRADE_CPST_INST tci where tci.ecid = cmp_ecid);
    end if;
    if is_aborted_instance = true and total_active_cmpt_count = 0 then
        total_recoverable_count := 0;
        total_unhandled_count := 0;
        admin_state_val := 2;
        update sca_common_fault set state = 256 where flow_id = flow_id_val;
    end if;	
    if is_staled_instance = true then
        total_active_cmpt_count := 0;
        total_recoverable_count := 0;
        total_unhandled_count := 0;
        admin_state_val := 2;
        update sca_common_fault set state = 256 where flow_id = flow_id_val;
    end if ;
    update sca_flow_instance set active_component_instances = total_active_cmpt_count,recoverable_faults = total_recoverable_count,unhandled_faults = total_unhandled_count,admin_state = admin_state_val where flow_id = flow_id_val;
    --commit;
    ret_str_val :=  get_tracking_data_to_return(flow_id_val,component_id_val,engine_type,component_fault_key_val, log_file) ; 

    -- check for associated flow ids for mid-process receive scenarios
    -- assoc2 is parent and assoc1 is child
    FOR cmp_assoc IN
    (select assoc2_ecid,created_time from composite_instance_assoc where assoc1_ecid = cmp_ecid)
    LOOP
        log_debug('migrating associated ecid :' || cmp_assoc.assoc2_ecid, log_file);
		
        -- fix for bug-25387031 - multi-level ecids in composite_instance_assoc fails to upgrade
        -- for example - ecid level1 is assoc1_ecid, level2 is assoc2_ecid, level3 is assoc2_ecid having assoc1_ecid = level2.
        -- in this use case, level3 ecid was not upgrading and its flow_id in composite_instance is null.
        select count(1) into assoc2_ecid_count from TEMP_UPGRADE_ECID where ecid = cmp_assoc.assoc2_ecid;
        if(assoc2_ecid_count = 0) then
           temp_ecid_list := ecid_list_type(cmp_assoc.assoc2_ecid);
           append_tmp_tables(temp_ecid_list,log_file);  
        end if;
        ret_str_val_assoc :=  migrate_ecid(ecid=>cmp_assoc.assoc2_ecid, log_file=>log_file,is_midtier_upgrade=>false,mid_process_flow=>flow_id_val,sca_partition_count=>sca_partition_count, fa_env=>fa_env);
        ret_migration  := migration_return_type(ret_str_val_assoc);

        select count(*) into count_ret_sca_partition_id from SCA_FLOW_INSTANCE where FLOW_ID = ret_migration.m_flow_id;
if count_ret_sca_partition_id > 0 then
        select SCA_PARTITION_ID into ret_sca_partition_id from SCA_FLOW_INSTANCE where FLOW_ID = ret_migration.m_flow_id;
        insert into sca_flow_assoc values (flow_id_val,ret_migration.m_flow_id,cmp_assoc.created_time,ret_sca_partition_id);
        if(cmp_assoc.assoc2_ecid != cmp_ecid) then
            handle_midprocess_correlation(ret_migration.m_flow_id, cmp_assoc.assoc2_ecid, flow_id_val, cmp_ecid, log_file);
        end if; 

else
        log_debug('Inserted into sca_flow_assoc - SKIPPED: ' ||
		        ' owner_flow_id : ' || flow_id_val ||
		        ' correlated_flow_id : ' || ret_migration.m_flow_id ||
		        ' partition_date : ' || cmp_assoc.created_time, log_file);
        exit;
end if; 

    END LOOP;

if count_ret_sca_partition_id > 0 then
    update composite_instance_assoc set flow_id = flow_id_val where assoc1_ecid = cmp_ecid; 
end if; 

    if (is_midtier_upgrade = true OR mid_process_flow > 0 )then
        commit;
    end if;
    log_debug('returning from migrate_ecid',log_file);
    return ret_str_val;
end migrate_ecid;
   
   procedure populate_tmp_tables_cmpst_dn(log_file in utl_file.file_type) is 
		BEGIN
		log_debug('Inside populate_tmp_tables_cmpst_dn',log_file);
		log_debug('truncate temp tables for cmpst_dn',log_file);
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_REJ_MSG_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_CI_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_DLV_MSG_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_REF_INST_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_MI_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_WFTASK_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_BRDECINST_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_CPNTINST_DN';
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_CM_CASE_HDR_DN';
		log_debug('truncate temp tables for cmpst_dn completed',log_file);
		log_debug('populate temp tables for cmpst_dn',log_file);
		INSERT INTO TEMP_UPGRADE_REJ_MSG_DN SELECT DISTINCT service_name, binding_type, composite_dn FROM REJECTED_MESSAGE;
		INSERT INTO TEMP_UPGRADE_CI_DN SELECT DISTINCT component_name, componenttype, composite_name, composite_revision, composite_label, domain_name FROM CUBE_INSTANCE;
		INSERT INTO TEMP_UPGRADE_DLV_MSG_DN SELECT DISTINCT component_name, component_type, composite_name, composite_revision, composite_label, domain_name FROM DLV_MESSAGE;
		INSERT INTO TEMP_UPGRADE_REF_INST_DN SELECT DISTINCT composite_dn, reference_name  FROM REFERENCE_INSTANCE;
		INSERT INTO TEMP_UPGRADE_MI_DN SELECT DISTINCT component_name FROM MEDIATOR_INSTANCE;
		INSERT INTO TEMP_UPGRADE_WFTASK_DN SELECT DISTINCT componentname, compositedn, componenttype FROM WFTASK;
		INSERT INTO TEMP_UPGRADE_BRDECINST_DN SELECT DISTINCT component_name, composite_name, revision FROM BRDECISIONINSTANCE;
		INSERT INTO TEMP_UPGRADE_CPNTINST_DN SELECT DISTINCT component_dn FROM COMPONENT_INSTANCE;
		INSERT INTO TEMP_UPGRADE_CM_CASE_HDR_DN SELECT DISTINCT component_name, composite_dn FROM CM_CASE_HEADER;
		COMMIT;
		log_debug('populate temp tables for cmpst_dn completed',log_file);
		log_debug('populate_tmp_tables_cmpst_dn ended',log_file);   
   end populate_tmp_tables_cmpst_dn;

procedure migrate_soa_metadata(batch_size in number default 10000,
    stoptime_v in varchar2 default null,thread in integer default 0, sql_trace in varchar2 default 'FALSE' ) is
    metadata_loop boolean := true;
    total_rows number ;
    log_file utl_file.file_type;
    ret_val boolean;
    v_stmt varchar2(100);
    stoptime date := NULL;
    is_metadata_migration_complete varchar2(5) := 'FALSE';
    batch_size_remaining number; 
    ecode number;
    emesg varchar2(300);   
    error_stack varchar2(300);
    error_info varchar2(100);
	BEGIN 
      BEGIN
        INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_ENTITY_IDS',-1,-1);
        if trim(sql_trace) = 'TRUE' then
            v_stmt := 'alter session set max_dump_file_size = unlimited';
            log_info(v_stmt);
            execute immediate v_stmt;
            v_stmt := 'alter session set events '
                || '''10046 trace name context forever, level 12''';
            log_info(v_stmt);
            execute immediate v_stmt;
        end if;
        DBMS_APPLICATION_INFO.SET_MODULE(
            MODULE_NAME => 'SOAUPGRADEMETADATA',
            ACTION_NAME => 'SOAUPGRADEEXECUTING');  
        log_file := get_logfile();  
        execute immediate 'truncate table TEMP_COMPOSITEDN_UPGRADE';
        execute immediate 'truncate table TEMP_COMPOSITEDN_UPGRADE_ALL';
        IF stoptime_v is null then
            stoptime := null;
        ELSE
            stoptime := to_date(stoptime_v,'DD/MON/YYYY:HH24/MI');
        END IF;
        --while metadata_loop = true LOOP
        --metadata_loop := false;
		--create_tmp_tables_cmpst_dn(log_file);
		populate_tmp_tables_cmpst_dn(log_file);
        insert into TEMP_COMPOSITEDN_UPGRADE select  composite_dn,max(created_time) from composite_instance where composite_dn not in (select composite_dn from TEMP_COMPOSITEDN_UPGRADE_ALL)  group by composite_dn; --where rownum <= batch_size;
        
        insert into TEMP_COMPOSITEDN_UPGRADE select composite_dn,max(CREATED_TIME) from rejected_message where composite_dn not in   (select composite_dn from TEMP_COMPOSITEDN_UPGRADE_ALL) group by composite_dn;--  where rownum <= batch_size;
        insert into  TEMP_COMPOSITEDN_UPGRADE_ALL select distinct composite_dn from  TEMP_COMPOSITEDN_UPGRADE;
        total_rows := SQL%ROWCOUNT;
        commit;
        --if total_rows >=  batch_size then
            --metadata_loop := true;
        --end if;
        if total_rows > 0 then 
            ret_val :=  populate_sca_entry(log_file, stoptime);
        end if;
        execute immediate 'truncate table  TEMP_COMPOSITEDN_UPGRADE';
        IF (sysdate >= stoptime) then
            log_debug('stop time reached. Metadata upgrade not yet complete');
            return;
        end if; 
        IF is_stop_injected = true then
            log_debug('STOP injected..exiting. Instances still left for upgrade');
            return;
        end if;
            
        --orphaned cubeinstance 
        insert into TEMP_COMPOSITEDN_UPGRADE  (select composite_dn,max(CREATION_DATE) from(select  (domain_name || '/'  || composite_name || '!' || composite_revision ||'*' || composite_label) as composite_dn ,CREATION_DATE from cube_instance where cmpst_id is null and  domain_name || '/'  || composite_name || '!' || composite_revision ||'*' || composite_label not in (select composite_dn from TEMP_COMPOSITEDN_UPGRADE_ALL)) group by composite_dn  );--where rownum <= batch_size );
        insert into  TEMP_COMPOSITEDN_UPGRADE_ALL select distinct composite_dn from  TEMP_COMPOSITEDN_UPGRADE;
        total_rows := SQL%ROWCOUNT;
        commit;
        --if total_rows >=  batch_size then
            --    metadata_loop := true;
        --end if;
        if total_rows > 0 then 
            ret_val :=  populate_sca_entry(log_file, stoptime);
        end if;
        execute immediate 'truncate table  TEMP_COMPOSITEDN_UPGRADE';
        IF (sysdate >= stoptime) then
            log_debug('stop time reached. Metadata upgrade not yet complete');
            return;
        end if; 
        IF is_stop_injected = true then
            log_debug('STOP injected..exiting. Instances still left for upgrade');
            return; 
        end if;
   
        --orphaned dlv_message        
        insert into TEMP_COMPOSITEDN_UPGRADE  (select composite_dn,max(RECEIVE_DATE) from(select  distinct (domain_name || '/'  || composite_name || '!' || composite_revision ||'*' || composite_label) as composite_dn,RECEIVE_DATE from dlv_message where (cikey is null or cikey = 0) and  domain_name || '/'  || composite_name || '!' || composite_revision ||'*' || composite_label not in (select composite_dn from TEMP_COMPOSITEDN_UPGRADE_ALL)) group by composite_dn);-- where rownum <= batch_size );    
        insert into  TEMP_COMPOSITEDN_UPGRADE_ALL select distinct composite_dn from  TEMP_COMPOSITEDN_UPGRADE;
        total_rows := SQL%ROWCOUNT;
        commit;
        --if total_rows >=  batch_size then
            --metadata_loop := true;
        --end if;
        if total_rows > 0 then 
            ret_val :=  populate_sca_entry(log_file, stoptime);
        end if;
        execute immediate 'truncate table  TEMP_COMPOSITEDN_UPGRADE';
        IF (sysdate >= stoptime) then
            log_debug('stop time reached. Metadata upgrade not yet complete');
            return;
        end if; 
        IF is_stop_injected = true then
            log_debug('STOP injected..exiting. Instances still left for upgrade');
            return; 
        end if;
        
        --orphaned mediatorinstance 
        insert into Temp_Compositedn_Upgrade (select composite_dn,max(CREATED_TIME) from (select get_composite_dn_med_orphan(component_name) as composite_dn,CREATED_TIME from mediator_instance where (composite_instance_id is null OR composite_instance_id = 0) and  substr(get_composite_dn_med_orphan(component_name),0,instr(get_composite_dn_med_orphan(component_name),'*',1)-1) not in  (select substr(composite_dn,0,instr(composite_dn,'*',1) -1) from TEMP_COMPOSITEDN_UPGRADE_ALL)) group by composite_dn );-- where rownum <= batch_size);
        insert into  TEMP_COMPOSITEDN_UPGRADE_ALL select distinct composite_dn from  TEMP_COMPOSITEDN_UPGRADE;
        total_rows := SQL%ROWCOUNT;
        commit;
        --if total_rows >=  batch_size then
            --metadata_loop := true;
        --end if;
        if total_rows > 0 then 
            ret_val :=  populate_sca_entry(log_file, stoptime);
        end if;
        execute immediate 'truncate table  TEMP_COMPOSITEDN_UPGRADE';
        IF (sysdate >= stoptime) then
            log_debug('stop time reached. Metadata upgrade not yet complete');
            return;
        end if; 
        IF is_stop_injected = true then
            log_debug('STOP injected..exiting. Instances still left for upgrade');
            return;
        end if;
        --END LOOP;
        is_metadata_migration_complete := 'TRUE';
        set_metadata_job_complete('TRUE');
        DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);
       EXCEPTION 
        WHEN OTHERS THEN 
            ecode := SQLCODE;
            emesg := SQLERRM; 
            ROLLBACK; -- on the occurence of exception, rollback the current transcation
            error_stack := crop_error_stack(DBMS_UTILITY.format_error_backtrace,300,log_file);
            error_info := crop_error_stack('Metadata Upgrade Error:',100,log_file);
            log_error('SQL Error Code : ' || ecode || ' SQL Error Message : '  || emesg, log_file);
            insert into UPGRADE_ERROR_LOG values(0, systimestamp, error_info,9, ecode || ':' || emesg || ';' || error_stack );
            commit;
        END;
end;
	
	procedure mark_ecid_as_errored (ecid_val in varchar2, thread in integer,ecode in number,emsg in varchar2 ,log_file in utl_file.file_type) is
		error_stack varchar2(300);
		BEGIN 
			error_stack := crop_error_stack(DBMS_UTILITY.format_error_backtrace,300,log_file);
			log_error('SQL Error Code : ' || ecode || ' SQL Error Message : '  || emsg, log_file);
			log_error('error occured for the ecid : ' || ecid_val, log_file);	
			insert into UPGRADE_ERROR_LOG values(thread, systimestamp, ecid_val,1, ecode || ':' || emsg || ';' || error_stack );
			update composite_instance set flow_id = -1 where ecid = ecid_val;
			update cube_instance set flow_id = -2 where ecid = ecid_val;
			update dlv_message set flow_id = -2 where ecid = ecid_val;
			update mediator_instance set flow_id = -2 where ecid = ecid_val;
			commit;
	end mark_ecid_as_errored; 

        
	
	function  populate_tmp_tbles_and_migrate(ecid_list in ecid_list_type, log_file in utl_file.file_type,stoptime  in date,
                  thread in integer, sca_partition_count in integer, fa_env in boolean default false) return boolean is                
      
       temp_count_1 number;
       temp_count_2 number;
       commit_size_count number;
       commit_size number :=  100;       
       ret varchar2(200);
       ecode number;
       emesg varchar2(300);       
       
  
       BEGIN
         log_debug('into populate_tmp_tbles_and_migrate',log_file);
                populate_tmp_tables(ecid_list,log_file);
				-- upgrade each ecid   
				commit_size_count := 1;
				for I in 1..ecid_list.COUNT
		        LOOP
					BEGIN
				    IF (sysdate >= stoptime) THEN
						log_debug('stop time reached. Instances still left for upgrade',log_file);
				        return false;
      		 		END IF;
					IF is_stop_injected = true then
						log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
						return false;
					end if;
                	log_debug('migrating ecid ' || ecid_list(i), log_file);
					ret := migrate_ecid(ecid => ecid_list(i), log_file=>log_file,
						is_midtier_upgrade=>false, sca_partition_count=>sca_partition_count, fa_env=>fa_env);
					EXCEPTION
						WHEN OTHERS THEN
						ecode := SQLCODE;
						emesg := SQLERRM;
						ROLLBACK; -- on the occurence of exception, rollback the current transcation
						mark_ecid_as_errored(ecid_list(i),thread,ecode,emesg,log_file);	
						commit_size_count := 0;
					END;
			   if commit_size_count = commit_size  then
			     commit;
			     commit_size_count := 1;
			   else
			      commit_size_count := commit_size_count + 1;
			   end if;  
			END LOOP; --end of for loop
            commit;
			log_debug('populate_tmp_tbles_and_migrate ended',log_file);
      return true;
   END populate_tmp_tbles_and_migrate;
  
	function migrate_open_ecids(batch_size in number default 10000,stoptime  in date default null, 
	              max_count number default 0,  thread in integer default -1, dop in integer default 1, log_file IN utl_file.file_type, sca_partition_count in integer, fa_env in boolean default false) return boolean is
                query_count number;
                ignore_midprocess_query_1 varchar2(110) := ' and ecid not in (select assoc2_ecid from composite_instance_assoc where assoc2_ecid <> assoc1_ecid ) ' ;
                ignore_midprocess_query_2 varchar2(110) := ' and ecid not in (select assoc1_ecid from composite_instance_assoc where assoc2_ecid <> assoc1_ecid ) ' ;
        
                cube_query varchar2(112) := 'select ecid from cube_instance where flow_id = -1 and state < 5 ' ;
                cube_count_query varchar2(138) := 'select count(*) from cube_instance where flow_id = -1 and state < 5 and ROWNUM = 1 ';
                dlv_query varchar2(133) := 'select ecid from dlv_message where flow_id = -1 and state in (0,1,4)  and dlv_type = 1 ';
                dlv_count_query varchar2(145) := 'select count(*) from dlv_message where flow_id = -1 and state in (0,1,4)  and dlv_type = 1 and ROWNUM = 1 ';
                mi_query  varchar2(145) := 'select ecid from mediator_instance where flow_id is null and component_state between 4 and 15 ';
                mi_count_query varchar2(150) := 'select count(*) from mediator_instance where flow_id is null and component_state between 4 and 15 and ROWNUM = 1 ';
                --order_by_time_query varchar2(30) := ' order by created_time DESC ';
                order_by_time_query varchar2(60) := ' group by ecid order by max(created_time) DESC ';
                --order_by_time_cube_query varchar2(30) := ' order by CREATION_DATE DESC ';
                order_by_time_cube_query varchar2(60) := ' group by ecid order by max(creation_date) DESC ';
                --order_by_time_dlv_query varchar2(30) := ' order by RECEIVE_DATE DESC ';
                order_by_time_dlv_query varchar2(60) := ' group by ecid order by max(RECEIVE_DATE) DESC ';
                rownum_query varchar2(14) := 'and rownum <= ';
                parallel_query varchar2(400) :=' and mod (dbms_utility.get_hash_value(ecid,0,' || dop || '),' || dop || ')=' ||thread || ignore_midprocess_query_1 || ignore_midprocess_query_2 ;       
		                
                cmpst_query varchar2(900);
                cmpst_count_query varchar2(900);
                upgrade_ci_ecids_done boolean := false;
                ret_val boolean;
             --   log_file utl_file.file_type;
                cmpst_cursor sys_refcursor ;
                ret varchar2(200);
                ecode number;
                emesg varchar2(300);   
                error_stack varchar2(300);
                ecid_list ecid_list_type;
                thread_val integer;
                upg_comment_v varchar2(80) := null;
                
       
			BEGIN
            thread_val := thread;
			log_debug('migrating open instances',log_file);
			--log_file := get_logfile(thread);
			-- looping for cube_instance

                        upg_comment_v := ('['|| thread ||'] open ci started, start time:[' || systimestamp || ']');
                        insert_upgrade_progress_info('DATA', upg_comment_v);

			LOOP
				IF (sysdate >= stoptime) THEN
		   	            log_debug('stop time reached. Instances still left for upgrade',log_file);
    		            return false;
				END IF;
				IF is_stop_injected = true then
				    log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
					return false;
				end if;      		  
				truncate_temp_tables();
				dbms_output.enable(NULL);
				if max_count = 0 then  
					cmpst_query := cube_query ;
				else  
					cmpst_query := cube_query ||rownum_query || max_count ;
				end if;
				cmpst_count_query := cube_count_query;
				if thread >=0 then
					cmpst_query := cmpst_query || parallel_query ;
					cmpst_count_query := cmpst_count_query || parallel_query;
				end if;
				cmpst_query := cmpst_query ||  order_by_time_cube_query;
				log_debug('query = ' ||cmpst_query,log_file);
				OPEN cmpst_cursor FOR cmpst_query;
					LOOP
						fetch cmpst_cursor bulk collect into ecid_list limit batch_size;
						--if cursor returns no rows then upgrade is already done 
						If ecid_list.COUNT > 0 then 
							log_debug('no of open cube instance := ' || ecid_list.COUNT ,log_file);
							ret_val := populate_tmp_tbles_and_migrate(ecid_list, log_file,stoptime, thread, sca_partition_count, fa_env);
						end if;    
						truncate_temp_tables(); 
						
						EXIT WHEN ecid_list.COUNT < batch_size;
						IF (sysdate >= stoptime) THEN
							log_debug('stop time reached. Instances still left for upgrade',log_file);
							commit;
							close cmpst_cursor;
							return false;
						END IF;
						IF is_stop_injected = true then
							log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
							commit;
							close cmpst_cursor;
							return false;
						end if;      		                
					END LOOP; --end of cmpst_cursor   
				close cmpst_cursor;
				log_debug('cmpst_count_query = ' ||cmpst_count_query,log_file);
				execute immediate cmpst_count_query into query_count;
				if query_count = 0 then
					upgrade_ci_ecids_done := TRUE;
				end if;
				EXIT WHEN upgrade_ci_ecids_done = TRUE;
			END LOOP;     -- end of loop for cube_instance
                       
                        upg_comment_v := ('['|| thread ||'] open ci completed, end time:[' || systimestamp || ']');
                        insert_upgrade_progress_info('DATA', upg_comment_v);
                                                
                        upg_comment_v := ('['|| thread ||'] open dlv started, start time:[' || systimestamp || ']');
                        insert_upgrade_progress_info('DATA', upg_comment_v);

			LOOP   -- looping for dlv_message
				IF (sysdate >= stoptime) THEN
		   	            log_debug('stop time reached. Instances still left for upgrade',log_file);
    		            return false;
				END IF;
				IF is_stop_injected = true then
					log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
					return false;
				end if;      		  
				truncate_temp_tables();
				dbms_output.enable(NULL);
				if max_count = 0 then  
					cmpst_query := dlv_query ;
				else  
					cmpst_query := dlv_query ||rownum_query || max_count ;
				end if;
				cmpst_count_query := dlv_count_query;
				if thread >=0 then
					cmpst_query := cmpst_query || parallel_query ;
					cmpst_count_query := cmpst_count_query || parallel_query;
				end if;
				cmpst_query := cmpst_query ||  order_by_time_dlv_query;
				log_debug('query = ' ||cmpst_query,log_file);
				OPEN cmpst_cursor FOR cmpst_query;
					LOOP
						fetch cmpst_cursor bulk collect into ecid_list limit batch_size;
						--if cursor returns no rows then upgrade is already done 
						If ecid_list.COUNT > 0 then 
							log_debug('no of open cube instance := ' || ecid_list.COUNT ,log_file);
							ret_val := populate_tmp_tbles_and_migrate(ecid_list, log_file,stoptime, thread, sca_partition_count, fa_env);
						end if;    
						truncate_temp_tables();
						EXIT WHEN ecid_list.COUNT < batch_size;
						IF (sysdate >= stoptime) THEN
							log_debug('stop time reached. Instances still left for upgrade',log_file);
							commit;
							close cmpst_cursor;
							return false;
						END IF;
						IF is_stop_injected = true then
							log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
							commit;
							close cmpst_cursor;
							return false;
						end if;      		                
					END LOOP; --end of cmpst_cursor   
				close cmpst_cursor;
				log_debug('cmpst_count_query = ' ||cmpst_count_query,log_file);
				execute immediate cmpst_count_query into query_count;
				if query_count = 0 then
					upgrade_ci_ecids_done := TRUE;
				end if;
				EXIT WHEN upgrade_ci_ecids_done = TRUE;
			END LOOP;    -- end of loop for dlv_message

                        upg_comment_v := ('['|| thread ||'] open dlv completed, end time:[' || systimestamp || ']');
                        insert_upgrade_progress_info('DATA', upg_comment_v);   

                        upg_comment_v := ('['|| thread ||'] open mi started, start time:[' || systimestamp || ']');
                        insert_upgrade_progress_info('DATA', upg_comment_v);

			LOOP   --looping for mediator_instance
				IF (sysdate >= stoptime) THEN
					log_debug('stop time reached. Instances still left for upgrade',log_file);
    		        return false;
				END IF;
				IF is_stop_injected = true then
					log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
					return false;
				end if;      		  
				truncate_temp_tables(); 
				dbms_output.enable(NULL);
				if max_count = 0 then  
					cmpst_query := mi_query ;
				else  
					cmpst_query := mi_query ||rownum_query || max_count ;
				end if;
				cmpst_count_query := mi_count_query;
				if thread >=0 then
					cmpst_query := cmpst_query || parallel_query ;
					cmpst_count_query := cmpst_count_query || parallel_query;
				end if;
				cmpst_query := cmpst_query ||  order_by_time_query;
				log_debug('query = ' ||cmpst_query,log_file);
				OPEN cmpst_cursor FOR cmpst_query;
				LOOP
					fetch cmpst_cursor bulk collect into ecid_list limit batch_size;
					--if cursor returns no rows then upgrade is already done 
					If ecid_list.COUNT > 0 then 
						log_debug('no of open cube instance := ' || ecid_list.COUNT ,log_file);
						ret_val := populate_tmp_tbles_and_migrate(ecid_list, log_file,stoptime, thread, sca_partition_count, fa_env);					
					end if;    
					truncate_temp_tables(); 	
					EXIT WHEN ecid_list.COUNT < batch_size;
					IF (sysdate >= stoptime) THEN
		   	            log_debug('stop time reached. Instances still left for upgrade',log_file);
						commit;
						close cmpst_cursor;
						return false;
					END IF;
					IF is_stop_injected = true then
						log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
						commit;
						close cmpst_cursor;
						return false;
					end if;      		                
				END LOOP; --end of cmpst_cursor   
				close cmpst_cursor;
				log_debug('cmpst_count_query = ' ||cmpst_count_query,log_file);
				execute immediate cmpst_count_query into query_count;
				if query_count = 0 then
					upgrade_ci_ecids_done := TRUE;
				end if;
				EXIT WHEN upgrade_ci_ecids_done = TRUE;
			END LOOP;     -- end of loop for mediator_instance

                        upg_comment_v := ('['|| thread ||'] open mi completed, end time:[' || systimestamp || ']');
                        insert_upgrade_progress_info('DATA', upg_comment_v); 
            
			update upgrade_open_ecids_status set complete = 'TRUE' where thread  = thread_val;
		log_debug('migrate_open_ecids ended',log_file);
		return true;
	end migrate_open_ecids;             
	function migrate_ecids(batch_size in number default 10000,is_migrate_metadata_reqd boolean default true,
	             stoptime  in date default null, max_count number default 0,  thread in integer default -1, dop in integer default 1,log_file IN utl_file.file_type,sca_partition_count in integer, fa_env in boolean default false  ) return boolean is
		ret varchar2(200);
		ecode number;
		emesg varchar2(300);
               -- log_file utl_file.file_type;
                ecid_list ecid_list_type;
                cmpst_cursor sys_refcursor ;
                ignore_midprocess_query_1 varchar2(110) := ' and ecid not in (select assoc2_ecid from composite_instance_assoc where assoc2_ecid <> assoc1_ecid ) ' ;
                ignore_midprocess_query_2 varchar2(110) := ' and ecid not in (select assoc1_ecid from composite_instance_assoc where assoc2_ecid <> assoc1_ecid ) ' ;

                main_query varchar2(60) := 'select ecid from composite_instance where flow_id is null ';
                cube_query varchar2(80) := 'select ecid from cube_instance where  cmpst_id is null and flow_id = -1 ';
				mediator_query varchar2(100) := 'select ecid from mediator_instance where  COMPOSITE_INSTANCE_ID = 0 and FLOW_ID is null ';
				main_count_query varchar2(100) := 'select count(1) from composite_instance where flow_id is null and ROWNUM = 1 ';
				cube_count_query varchar2(100) := 'select count(1) from cube_instance where cmpst_id is null and flow_id = -1 and ROWNUM = 1 ';
				mediator_count_query varchar2(150) := 'select count(1) from mediator_instance where COMPOSITE_INSTANCE_ID = 0 and FLOW_ID is null and ROWNUM = 1 ';
                --order_by_time_query varchar2(30) := ' order by created_time DESC ';
                order_by_time_query varchar2(60) := ' group by ecid order by max(created_time) DESC ';
                order_by_time_cube_query varchar2(60) := ' group by ecid order by max(creation_date) DESC ';
				--order_by_time_cube_query varchar2(30) := ' order by CREATION_DATE DESC ';
                rownum_query varchar2(14) := 'and rownum <= ';
                parallel_query varchar2(400) :=' and mod (dbms_utility.get_hash_value(ecid,0,' || dop || '),' || dop || ')=' ||thread || ignore_midprocess_query_1 ||     ignore_midprocess_query_2;
                cmpst_query varchar2(900);
		cmpst_count_query varchar2(900);
                commit_size_count number;
                commit_size number :=  100;
                dlv_msg dlv_msg_type;
                dlv_msg_table dlv_msg_table_type;
                work_item_table work_item_table_type;
                dlv_count number := 0;
                prev_ecid varchar2(100);
                prev_cmpst number;
                wi_count number;
                wrk_item work_item_type;
                temp_count_1 number;
                temp_count_2 number;
                sca_entry_ret boolean;
                cmp_inst_ecids_done boolean := true;
				cube_inst_ecids_done boolean := true;
				med_inst_ecids_done boolean := true;
                more_rows_to_upgrade_count integer;
		BEGIN
		--log_file := get_logfile(thread);
        BEGIN
		
			IF (sysdate >= stoptime) THEN
				log_debug('stop time reached. Instances still left for upgrade',log_file);
		        return false;
      		END IF;
	        IF is_stop_injected = true then
				log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
				return false;
			end if;      		  
			
			truncate_temp_tables();
		
			dbms_output.enable(NULL);
			if max_count = 0 then  
				cmpst_query := main_query ;
			else  
				cmpst_query := main_query ||rownum_query || max_count ;
			end if;
			cmpst_count_query := main_count_query;
			if thread >=0 then
				cmpst_query := cmpst_query || parallel_query ;
				cmpst_count_query := cmpst_count_query || parallel_query ;
			end if;
			cmpst_query := cmpst_query ||  order_by_time_query;
            log_debug('query = ' ||cmpst_query,log_file);
   	        OPEN cmpst_cursor FOR cmpst_query;
			LOOP
				fetch cmpst_cursor bulk collect into ecid_list limit batch_size;
				--if cursor returns no rows then upgrade is already done 
				If ecid_list.COUNT = 0 Then 
					log_debug('no ecids found',log_file);
					cmp_inst_ecids_done := true;
                  --  close_logfile(log_file);
					--close cmpst_cursor;
					EXIT;
				end if;   
				
				/*if is_migrate_metadata_reqd = true then
					execute immediate 'truncate table TEMP_COMPOSITEDN_UPGRADE';
					execute immediate 'truncate table TEMP_COMPOSITEDN_UPGRADE_ALL';	
					for i in 1..ecid_list.COUNT
     		        LOOP
						BEGIN
						log_debug('populating  composite_dn ' || ecid_list(i), log_file);
						insert into TEMP_COMPOSITEDN_UPGRADE select distinct composite_dn from composite_instance where 
						ecid = ecid_list(i) and composite_dn not in (select composite_dn from TEMP_COMPOSITEDN_UPGRADE_ALL);
						insert into  TEMP_COMPOSITEDN_UPGRADE_ALL select composite_dn from  TEMP_COMPOSITEDN_UPGRADE;
                        EXCEPTION
							WHEN OTHERS THEN
							ecode := SQLCODE;
							emesg := SQLERRM;
							log_error('SQL Error Code : ' || ecode ||
								' SQL Error Message : '  || emesg, log_file);
							log_error('error occured for the ecid : ' || 
								ecid_list(i), log_file);			
							ROLLBACK; -- on the occurence of exception, rollback the current transcation
                        END;
					END LOOP; --end of for loop
					-- create the metadata
					commit;
					sca_entry_ret := populate_sca_entry(log_file,stoptime);
					--create temp tables
				end if; -- is_migrate_metadata_reqd  */ 
				cmp_inst_ecids_done :=  populate_tmp_tbles_and_migrate(ecid_list, log_file,stoptime,thread, sca_partition_count, fa_env);
				truncate_temp_tables();							  
				EXIT WHEN ecid_list.COUNT < batch_size;		
				IF (sysdate >= stoptime) THEN
					log_debug('migrate_ecids:composite_instance loop stop time reached. Instances still left for upgrade',log_file);
					commit;
					close cmpst_cursor;
					return false;
				END IF;
				IF is_stop_injected = true then
					log_debug('migrate_ecids:composite_instance loop STOP injected..exiting. Instances still left for upgrade',log_file);
					commit;
					close cmpst_cursor;
					return false;
				end if; 
			END LOOP; --end of cmpst_no_min_max cursor	
			close cmpst_cursor;
			ecid_list.delete();
			log_debug('end of cmpst_no_min_max loop with cmp_inst_ecids_done as '|| bool_to_text(cmp_inst_ecids_done),log_file);
			if cmp_inst_ecids_done  = true then
				EXECUTE IMMEDIATE cmpst_count_query  into more_rows_to_upgrade_count ;
				if more_rows_to_upgrade_count > 0 then
					cmp_inst_ecids_done := false;
				end if;
			end if;
			-- Now query for cube instance for left over orphans
			log_debug('cursor on cube_instance',log_file);
			if max_count = 0 then  
				cmpst_query := cube_query ;
            else  
	            cmpst_query := cube_query ||rownum_query || max_count ;
			end if;
			cmpst_count_query := cube_count_query;
			if thread >=0 then
				cmpst_query := cmpst_query || parallel_query ;
				cmpst_count_query := cmpst_count_query || parallel_query ;
	        end if;
            cmpst_query := cmpst_query ||  order_by_time_cube_query;
		
            log_debug('[migrate_ecids]query = ' ||cmpst_query,log_file);
   	        OPEN cmpst_cursor FOR cmpst_query;
			LOOP
				fetch cmpst_cursor bulk collect into ecid_list limit batch_size;
				--if cursor returns no rows then upgrade is already done 
				If ecid_list.COUNT = 0 Then 
					log_debug('no ecids found',log_file);
					cube_inst_ecids_done := true;
					EXIT;
				end if;   
				cube_inst_ecids_done :=  populate_tmp_tbles_and_migrate(ecid_list, log_file,stoptime,thread,sca_partition_count, fa_env);
				truncate_temp_tables();	
				if(ecid_list.COUNT < batch_size) then
                    cube_inst_ecids_done :=true;
					EXIT;
				end if;
				IF (sysdate >= stoptime) THEN
					log_debug('migrate_ecids:composite_instance loop stop time reached. Instances still left for upgrade',log_file);
					commit;
					close cmpst_cursor;
					return false;
				END IF;
				IF is_stop_injected = true then
					log_debug('migrate_ecids:composite_instance loop STOP injected..exiting. Instances still left for upgrade',log_file);
					commit;
					close cmpst_cursor;
					return false;
				end if; 
			END LOOP; --end of cursor   
		
			log_debug('[migrate_ecids]cursor on cube_instance endeddd',log_file);
			log_debug('[migrate_ecids] with cube_inst_ecids_done as '|| bool_to_text(cube_inst_ecids_done),log_file);
			close cmpst_cursor;
			ecid_list.delete();
			if cube_inst_ecids_done  = true then
				EXECUTE IMMEDIATE cmpst_count_query into more_rows_to_upgrade_count ;
				if more_rows_to_upgrade_count > 0 then
		             cube_inst_ecids_done := false;
				end if;
			end if;
			log_debug('end of cube instance loop with cube_inst_ecids_done as '|| bool_to_text(cube_inst_ecids_done),log_file);
			-- Mediator orphans starts
			-- Now query for mediator instance for left over orphans
			log_debug('cursor on mediator_instance',log_file);
			if max_count = 0 then  
				cmpst_query := mediator_query ;
            else  
	            cmpst_query := mediator_query ||rownum_query || max_count ;
			end if;
			cmpst_count_query := mediator_count_query;
			if thread >=0 then
				cmpst_query := cmpst_query || parallel_query ;
				cmpst_count_query := cmpst_count_query || parallel_query ;
	        end if;
            cmpst_query := cmpst_query ||  order_by_time_query;
		
            log_debug('[migrate_ecids]query = ' ||cmpst_query,log_file);
   	        OPEN cmpst_cursor FOR cmpst_query;
			LOOP
				fetch cmpst_cursor bulk collect into ecid_list limit batch_size;
				--if cursor returns no rows then upgrade is already done 
				If ecid_list.COUNT = 0 Then 
					log_debug('no ecids found',log_file);
					med_inst_ecids_done := true;
					EXIT;
				end if;   
				med_inst_ecids_done :=  populate_tmp_tbles_and_migrate(ecid_list, log_file,stoptime,thread,sca_partition_count, fa_env);
				truncate_temp_tables();	
                if(ecid_list.COUNT < batch_size) then
                    med_inst_ecids_done :=true;
					EXIT;
				end if;
                IF (sysdate >= stoptime) THEN
					log_debug('migrate_ecids:composite_instance loop stop time reached. Instances still left for upgrade',log_file);
					commit;
					close cmpst_cursor;
					return false;
				END IF;
                IF is_stop_injected = true then
					log_debug('migrate_ecids:composite_instance loop STOP injected..exiting. Instances still left for upgrade',log_file);
					commit;
					close cmpst_cursor;
					return false;
				end if; 				
					
			END LOOP;
			log_debug('[migrate_ecids]cursor on mediator_instance ended',log_file);
			log_debug('[migrate_ecids] with med_inst_ecids_done as '|| bool_to_text(med_inst_ecids_done),log_file);
			close cmpst_cursor;
			ecid_list.delete();
			if med_inst_ecids_done  = true then
				EXECUTE IMMEDIATE cmpst_count_query into more_rows_to_upgrade_count ;
				if more_rows_to_upgrade_count > 0 then
		             med_inst_ecids_done := false;
				end if;
			end if;
			log_debug('[migrate_ecids] After fetch with med_inst_ecids_done as '|| bool_to_text(med_inst_ecids_done),log_file);
			--  Mediator Orphans ends          
			commit;                        
			end ; 
       log_debug('[migrate_ecids]returning from migrate_ecids :'|| bool_to_text(cmp_inst_ecids_done and cube_inst_ecids_done and med_inst_ecids_done),log_file);
       return cmp_inst_ecids_done and cube_inst_ecids_done and med_inst_ecids_done;
	end migrate_ecids;

   
procedure migrate_soa(batch_size in number default 10000,is_migrate_metadata_reqd in varchar default 'TRUE',is_data_migrate_reqd in varchar2 default 'TRUE',
                        open_ecids_complete in varchar2 default 'FALSE', stoptime_v  in varchar2 default null, max_count in number default 0, 
                        thread in integer default -1, dop in integer default 1,  sql_trace in varchar2 default 'FALSE' ) is

    ecids_done boolean := false;
    rej_msgs_done boolean := false;
    edn_done boolean := false;
    b2b_done boolean := false;
    ret_value boolean;
    stoptime date := null;
    v_stmt varchar2(100);
    log_file utl_file.file_type;
    ecode number;
    emesg varchar2(300);   
    error_stack varchar2(300);
    sca_partition_count integer := 0;
    fa_env boolean;
    
    BEGIN
        BEGIN 
            log_file := get_logfile(thread);
            --first migrate the metadata
            if trim(sql_trace) = 'TRUE' then 
                v_stmt := 'alter session set max_dump_file_size = unlimited';
                log_info(v_stmt);
                execute immediate v_stmt;
                v_stmt := 'alter session set events '|| '''10046 trace name context forever, level 12''';
                log_info(v_stmt);
                execute immediate v_stmt;
            end if;
            DBMS_APPLICATION_INFO.SET_MODULE(
                MODULE_NAME => 'SOAUPGRADEDATA' || '_' || thread,
                ACTION_NAME => 'SOAUPGRADEEXECUTING');  

            IF stoptime_v is null then
                stoptime := null;
            ELSE
                stoptime := to_date(stoptime_v,'DD/MON/YYYY:HH24/MI');
            END IF;
            if trim(is_migrate_metadata_reqd) = 'TRUE' then 
                migrate_soa_metadata(batch_size ,stoptime,0,sql_trace);
            end if;
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'FAULT_IDS',-1,-1);
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'FLOW_INSTANCE_IDS',-1,-1);
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'COMPONENT_INSTANCE_IDS',-1,-1);
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_ENTITY_IDS',-1,-1);
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_REJECTED_MSG_IDS',-1,-1);
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'SCA_REJECTED_MSG_IDS',-1,-1);
            INSERT INTO UPGRADE_CURRENT_SEQUENCE_TEMP VALUES( 'COMPOSITE_INSTANCE_IDS',-1,-1);
            -- now loop for data upgrade
            if trim(is_data_migrate_reqd) = 'TRUE' then 
                select count(1) into sca_partition_count from sca_partition;
                -- first migrate all open instances
                -- check whether fa env
                fa_env := is_fa_env; 
                -- first migrate all open instances 
                if open_ecids_complete = 'FALSE' then 
                    ret_value := migrate_open_ecids(batch_size,stoptime, max_count,thread , dop,log_file, sca_partition_count, fa_env);
                end if;   
                LOOP
                    log_debug('looping...',log_file); --remove
                    IF (sysdate >= stoptime) THEN
                        log_debug('stop time reached. Instances still left for upgrade',log_file);
                         EXIT ;
                    END IF;
                    IF is_stop_injected = true then
                        log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
                        EXIT;
                    end if;
                    if ecids_done = false then
                        log_debug('[migrate_soa]migrate_soa ecids_done is false calling migrate_ecids',log_file);
                        ecids_done :=  migrate_ecids(batch_size,false,stoptime,max_count,thread,dop,log_file,sca_partition_count, fa_env);
                    end if;
                    IF (sysdate >= stoptime) THEN
                        log_debug('stop time reached. Instances still left for upgrade',log_file);
                        EXIT;
                    END IF;	
                    IF is_stop_injected = true then
                        log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
                        EXIT;
                    end if;       
                    if rej_msgs_done = false then 
                        rej_msgs_done := adapter_migrate.upgrade_rejected_messages(batch_size, stoptime, max_count, thread, dop);
                    end if;
                    IF (sysdate >= stoptime) THEN
                        log_debug('stop time reached. Instances still left for upgrade',log_file);
                        EXIT ;
                    END IF;	
                    IF is_stop_injected = true then
                        log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
                        EXIT;
                    end if;       
                    if edn_done = false then 
                        edn_done := edn_migrate.upgrade_edn_messages(batch_size, stoptime, max_count, thread, dop);
                    end if; 
                    IF (sysdate >= stoptime) THEN
                        log_debug('stop time reached. Instances still left for upgrade',log_file);
                        EXIT ;
                    END IF;	   
                    IF is_stop_injected = true then
                        log_debug('STOP injected..exiting. Instances still left for upgrade',log_file);
                        EXIT;
                    end if;       
                    if b2b_done = false then
                        soa_migrate_b2b.b2b_upgrade_ecid();  
                        b2b_done := true; --TODO
                    end if;
                    EXIT WHEN  ecids_done = true and rej_msgs_done = true and edn_done = true and b2b_done = true;
                END LOOP;
            end if; 
            DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);
                --return ecids_done and rej_msgs_done and edn_done and b2b_done;
        
        EXCEPTION
                WHEN OTHERS THEN 
                ecode := SQLCODE;
                emesg := SQLERRM; 
                ROLLBACK; -- on the occurence of exception, rollback the current transcation
                error_stack := crop_error_stack(DBMS_UTILITY.format_error_backtrace,300,log_file);
                log_error('migrate_soa :SQL Error Code : ' || ecode || ' SQL Error Message : '  || emesg, log_file);
                insert into UPGRADE_ERROR_LOG values(thread, systimestamp, 'migrate_soa',12, ecode || ':' || emesg || ';' || error_stack );
                commit;
        END;  
        close_logfile(log_file);
        exception
        when others then 
            log_debug(' ' || SQLCODE ||' ' ||SQLERRM,log_file );
            dbms_output.put_line('Error in closing log file due to - ' || SQLERRM);      
end migrate_soa;

end soa_migrate;
/
show errors;
