BEGIN

/*
*  The upgrade parameter table can be precreated to the UA be executed.
*   If the table already exists then it will not be recreated so
*    that the parameter will override the JOB ARGS.
*/
  IF not table_exist('UPGRADE_PARAMETER_TABLE') THEN
    EXECUTE IMMEDIATE
          'CREATE TABLE UPGRADE_PARAMETER_TABLE
             (name varchar2(40), value varchar2(5))';
  END IF;

  IF table_exist('UPGRADE_PROGRESS_LOG') THEN
    EXECUTE IMMEDIATE 'DROP TABLE UPGRADE_PROGRESS_LOG';
  END IF;

  IF table_exist('UPGRADE_INJECTION') THEN
    EXECUTE IMMEDIATE 'DROP TABLE UPGRADE_INJECTION';
  END IF;

  IF table_exist('UPGRADE_OPEN_ECIDS_STATUS') THEN
     EXECUTE IMMEDIATE 'DROP TABLE UPGRADE_OPEN_ECIDS_STATUS';
  END IF;

  IF seq_exist('UPGRADE_RUN_SEQ') THEN
    EXECUTE IMMEDIATE 'DROP SEQUENCE UPGRADE_RUN_SEQ';
  END IF;

  EXECUTE IMMEDIATE
     'CREATE TABLE UPGRADE_INJECTION
      (PARM varchar2(5), VALUE varchar2(5))';

  EXECUTE IMMEDIATE
     'INSERT INTO UPGRADE_INJECTION VALUES (''STOP'', ''FALSE'')';
  COMMIT;

  EXECUTE IMMEDIATE
     'CREATE TABLE UPGRADE_PROGRESS_LOG
      (RUN number,
       CREATION_DATE timestamp,
       MODULE varchar2(40),
       MSG_TYPE varchar2(5),
       REMAINING number,
       UPG_COMMENT varchar2(80))';

  EXECUTE IMMEDIATE
     'INSERT INTO UPGRADE_PROGRESS_LOG VALUES
        (0,systimestamp,''CONTROL'',''SEQ'',0,''SEQUENCE'')';
  COMMIT;

  EXECUTE IMMEDIATE
     'INSERT INTO UPGRADE_PROGRESS_LOG VALUES
        (0,systimestamp,''CONTROL'',''EDN'',1,''12.1.3.0.0'')';
  COMMIT;


  EXECUTE IMMEDIATE
     'CREATE TABLE UPGRADE_OPEN_ECIDS_STATUS
      (thread integer, complete varchar2(5))';

  EXECUTE IMMEDIATE
  'CREATE SEQUENCE UPGRADE_RUN_SEQ START WITH 1 INCREMENT BY 1 NOCACHE NOCYCLE';

   if not table_exist('UPGRADE_CURRENT_SEQUENCE_TEMP') THEN
 	EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE UPGRADE_CURRENT_SEQUENCE_TEMP( ' ||
 	    'RANGE_NAME VARCHAR2(50) NOT NULL, ' ||
 	    'CURRENT_RANGE_LOWER NUMBER NOT NULL, ' ||
  	    'CURRENT_RANGE_UPPER NUMBER NOT NULL '||
  	    ') ON COMMIT PRESERVE ROWS ';
   END IF;
	
	IF table_exist('TEMP_COMPOSITEDN_UPGRADE') THEN
		EXECUTE IMMEDIATE 'DROP TABLE TEMP_COMPOSITEDN_UPGRADE';
	END IF;
	EXECUTE IMMEDIATE 'CREATE TABLE TEMP_COMPOSITEDN_UPGRADE (composite_dn varchar2(500),MAX_CREATED_TIME TIMESTAMP(6))';
	
	IF table_exist('TEMP_COMPOSITEDN_UPGRADE_ALL') THEN
		EXECUTE IMMEDIATE 'DROP TABLE TEMP_COMPOSITEDN_UPGRADE_ALL';
	END IF;
	EXECUTE IMMEDIATE 'CREATE TABLE TEMP_COMPOSITEDN_UPGRADE_ALL (composite_dn varchar2(500))';	  
	
	IF not  table_exist('TEMP_UPGRADE_ECID') THEN
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_ECID (ecid varchar2(500))ON COMMIT PRESERVE ROWS ';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPGRADE_ECID on  TEMP_UPGRADE_ECID(ecid)';  
	END IF;	  
	
	if not table_exist('TEMP_UPGRADE_CI') THEN
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_CI(cikey number,composite_id number,component_name varchar2(300),state number,componenttype varchar2(10),ecid VARCHAR2(100),CONVERSATION_ID VARCHAR2(256),DOMAIN_NAME VARCHAR2(50),COMPOSITE_NAME VARCHAR2(500),COMPOSITE_REVISION VARCHAR2(50),COMPOSITE_LABEL VARCHAR2(50),' ||
			'CONSTRAINT ci_temp_ci_pkey PRIMARY KEY (cikey)) '||
	        'ON COMMIT PRESERVE ROWS';
		EXECUTE IMMEDIATE 'CREATE INDEX CMP_ID_TEMP_UPG_CI_IDX on  TEMP_UPGRADE_CI(composite_id)';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPG_CI_IDX on  TEMP_UPGRADE_CI(ecid)';        
	END IF;  
	if not table_exist('TEMP_UPGRADE_DLV_MSG') THEN
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_DLV_MSG( DLV_TYPE NUMBER ,MESSAGE_GUID VARCHAR2(50),COMPONENT_NAME VARCHAR2(300),' ||
        'CIKEY NUMBER ,RECEIVE_DATE TIMESTAMP(6),CONV_ID VARCHAR2(256),DOMAIN_NAME VARCHAR2(50),'||
        'COMPOSITE_NAME VARCHAR2(500),COMPOSITE_REVISION VARCHAR2(50),COMPOSITE_LABEL VARCHAR2(50),STATE NUMBER,COMPONENT_TYPE VARCHAR2(10),ECID VARCHAR2(100),TENANT_ID NUMBER(18), ' ||
        ' CONSTRAINT TEMP_UPGRADE_DLV_MSG_PK PRIMARY KEY(MESSAGE_GUID)) ' ||
	    ' ON COMMIT PRESERVE ROWS';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPGRADE_DLV_MSG on  TEMP_UPGRADE_DLV_MSG(ecid)';        
    END IF;
    if not table_exist('TEMP_UPGRADE_DLV_ECID_MAP') THEN
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_DLV_ECID_MAP( MESSAGE_GUID VARCHAR2(50),ECID VARCHAR2(100), ' ||
        ' CONSTRAINT TEMP_UPGRADE_DLV_ECID_MAP_PK PRIMARY KEY(MESSAGE_GUID)) ' ||
	    ' ON COMMIT PRESERVE ROWS';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPGRADE_DLV_ECID_MAP on  TEMP_UPGRADE_DLV_ECID_MAP(ecid)';        
    END IF;
    if not table_exist('TEMP_UPGRADE_WKITM_CI') THEN
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_WKITM_CI( CIKEY NUMBER(38),STATE NUMBER(38),NODE_ID VARCHAR2(200), SCOPE_ID VARCHAR2(1024),CREATION_DATE TIMESTAMP(6), COUNT_ID NUMBER(38),'||
        'EXP_FLAG NUMBER(38),EXP_DATE TIMESTAMP(6),COMPONENT_NAME VARCHAR2(300), COMPONENTTYPE VARCHAR2(10), CMPST_ID VARCHAR2(100),ECID VARCHAR2(100) )' ||
	    ' ON COMMIT PRESERVE ROWS';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPGRADE_WKITM_CI on  TEMP_UPGRADE_WKITM_CI(ecid)';  
        EXECUTE IMMEDIATE 'CREATE INDEX CIKEY_TEMP_UPGRADE_WKITM_CI on  TEMP_UPGRADE_WKITM_CI(CIKEY)';  
	ELSE 
		EXECUTE IMMEDIATE 'DROP TABLE TEMP_UPGRADE_WKITM_CI';
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_WKITM_CI( CIKEY NUMBER(38),STATE NUMBER(38),NODE_ID VARCHAR2(200), SCOPE_ID VARCHAR2(1024),CREATION_DATE TIMESTAMP(6), COUNT_ID NUMBER(38),'||
        'EXP_FLAG NUMBER(38),EXP_DATE TIMESTAMP(6),COMPONENT_NAME VARCHAR2(300), COMPONENTTYPE VARCHAR2(10), CMPST_ID VARCHAR2(100),ECID VARCHAR2(100) )' ||
	    ' ON COMMIT PRESERVE ROWS';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPGRADE_WKITM_CI on  TEMP_UPGRADE_WKITM_CI(ecid)';  
        EXECUTE IMMEDIATE 'CREATE INDEX CIKEY_TEMP_UPGRADE_WKITM_CI on  TEMP_UPGRADE_WKITM_CI(CIKEY)';  
    END IF;  
	IF table_exist('UPGRADE_ERROR_LOG') THEN
		EXECUTE IMMEDIATE 'DROP TABLE UPGRADE_ERROR_LOG';
	END IF;
	EXECUTE IMMEDIATE 'CREATE TABLE UPGRADE_ERROR_LOG (thread integer, created_time timestamp, info varchar2(100),type integer, error_msg varchar2(500))'; 
    
	if not table_exist('TEMP_UPGRADE_WFTASK') THEN
		EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_WFTASK(ECID VARCHAR2(200),TASKID VARCHAR2(64),COMPOSITEINSTANCEID VARCHAR2(200),COMPONENTNAME VARCHAR2(500),STATE VARCHAR2(100),COMPONENTTYPE VARCHAR2(10),COMPOSITEDN VARCHAR2(500),' ||
        'CONSTRAINT wftask_temp_taskid_pkey PRIMARY KEY (TASKID)) '||
	    'ON COMMIT PRESERVE ROWS';
	  	EXECUTE IMMEDIATE 'CREATE INDEX CPST_ID_TEMP_UPG_WFTASK_IDX on  TEMP_UPGRADE_WFTASK(COMPOSITEINSTANCEID)';
        EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_UPG_WFTASK_IDX on  TEMP_UPGRADE_WFTASK(ECID)'; 	
	END IF;
	
	IF NOT table_exist('TEMP_UPGRADE_BRDECISION') THEN
		  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_BRDECISION(ECID VARCHAR2(100),ID  VARCHAR2(100),COMPOSITE_INSTANCE_ID VARCHAR2(100),COMPONENT_NAME VARCHAR2(200),STATE NUMBER(38),' ||
                            'CONSTRAINT brdecision_temp_id_pkey PRIMARY KEY (ID)) '||
	                      'ON COMMIT PRESERVE ROWS';
	  	  EXECUTE IMMEDIATE 'CREATE INDEX CPST_ID_TEMP_BRD_IDX on  TEMP_UPGRADE_BRDECISION(COMPOSITE_INSTANCE_ID)';
          EXECUTE IMMEDIATE 'CREATE INDEX ECID_TEMP_BRD_IDX on  TEMP_UPGRADE_BRDECISION(ECID)';
    ELSE 
        IF NOT COLUMN_EXISTS('TEMP_UPGRADE_BRDECISION','STATE') THEN
            EXECUTE IMMEDIATE  'ALTER TABLE TEMP_UPGRADE_BRDECISION ADD STATE NUMBER(38)';
        END IF;
	END IF;
    
	-- temperary table for mediator_instance
	IF NOT  table_exist('TEMP_UPGRADE_MI') THEN
		  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_MI (flow_id number,ecid varchar2(100),composite_instance_id number,id varchar2(100),component_name varchar2(1000),' ||
                            'component_state number, case_num number,group_id varchar2(1000), source_action_name varchar2(1000), resequencer_type varchar2(100)) ON COMMIT PRESERVE ROWS';
	          EXECUTE IMMEDIATE 'CREATE INDEX TEMP_UPGRADE_MI_CMPSTID ON TEMP_UPGRADE_MI(COMPOSITE_INSTANCE_ID)';
              EXECUTE IMMEDIATE 'CREATE INDEX TEMP_UPGRADE_MI_ECID ON TEMP_UPGRADE_MI(ECID)';
              EXECUTE IMMEDIATE 'CREATE INDEX TEMP_UPGRADE_MI_ID ON TEMP_UPGRADE_MI(ID)';
	END IF;
	
    -- temperary table for mediator_case_instance
	IF NOT  table_exist('TEMP_UPGRADE_MCI') THEN
		  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_MCI (instance_id varchar2(100),id varchar2(100),def_message_id varchar2(100),retry_count number,' ||
                            'fault_name varchar2(4000),exception_type varchar2(100),exception_msg varchar2(4000),created_time timestamp, recoverable number) ON COMMIT PRESERVE ROWS';
		  EXECUTE IMMEDIATE 'CREATE INDEX TEMP_UPGRADE_MCI_INSID ON TEMP_UPGRADE_MCI(INSTANCE_ID)';
	END IF;
	
	-- temperary table for mediator_case_detail_view
	IF NOT  table_exist('TEMP_UPGRADE_MCDV') THEN
		  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_MCDV (instance_id varchar2(100)) ON COMMIT PRESERVE ROWS';
		  EXECUTE IMMEDIATE 'CREATE INDEX TEMP_UPGRADE_MCDV_INSID ON TEMP_UPGRADE_MCDV(INSTANCE_ID)';
	END IF;
	
    IF NOT  table_exist('TEMP_UPGRADE_CPST_INST') THEN
		  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_UPGRADE_CPST_INST (ID NUMBER(38),ECID VARCHAR2(100),PARENT_ID VARCHAR2(100),CONVERSATION_ID VARCHAR2(100),COMPOSITE_DN VARCHAR2(500),TITLE NVARCHAR2(100),LIVE_INSTANCES NUMBER(38),CREATED_TIME TIMESTAMP(6),UPDATED_TIME TIMESTAMP(6),PARTITION_DATE TIMESTAMP(6),TENANT_ID NUMBER(18),STATE NUMBER(3),CREATED_BY VARCHAR2(100),UPDATED_BY VARCHAR2(100),FLOW_ID NUMBER ) ON COMMIT PRESERVE ROWS';
		  EXECUTE IMMEDIATE 'CREATE INDEX TEMP_CPST_INST_ECID ON TEMP_UPGRADE_CPST_INST(ECID)';
          EXECUTE IMMEDIATE 'CREATE INDEX TEMP_CPST_INST_CPSTID ON TEMP_UPGRADE_CPST_INST(ID)';
    END IF;

    IF table_exist('TEMP_UPGRADE_REJ_MSG_DN') THEN
		  EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_REJ_MSG_DN';	
    ELSE
		  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_REJ_MSG_DN (SERVICE_NAME VARCHAR2(200), BINDING_TYPE VARCHAR2(100), COMPOSITE_DN VARCHAR2(500))';
    END IF;
   
    IF table_exist('TEMP_UPGRADE_CI_DN') THEN
		  EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_CI_DN';
    ELSE
		  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_CI_DN (COMPONENT_NAME VARCHAR2(300), COMPONENTTYPE VARCHAR2(10), COMPOSITE_NAME VARCHAR2(500), COMPOSITE_REVISION VARCHAR2(50), COMPOSITE_LABEL VARCHAR2(50), DOMAIN_NAME VARCHAR2(50))';
    END IF;  
   
    IF table_exist('TEMP_UPGRADE_DLV_MSG_DN') THEN
		  EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_DLV_MSG_DN';
    ELSE
		  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_DLV_MSG_DN (COMPONENT_NAME VARCHAR2(300), COMPONENT_TYPE VARCHAR2(10), COMPOSITE_NAME VARCHAR2(500), COMPOSITE_REVISION VARCHAR2(50), COMPOSITE_LABEL VARCHAR2(50), DOMAIN_NAME VARCHAR2(50))';
    END IF;
   
    IF table_exist('TEMP_UPGRADE_REF_INST_DN') THEN
		  EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_REF_INST_DN';
    ELSE
		  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_REF_INST_DN (COMPOSITE_DN VARCHAR2(500), REFERENCE_NAME VARCHAR2(200))';
    END IF;	
   
    IF table_exist('TEMP_UPGRADE_MI_DN') THEN
		  EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_MI_DN';
    ELSE
		  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_MI_DN (COMPONENT_NAME VARCHAR2(1000))';
    END IF;

    IF table_exist('TEMP_UPGRADE_WFTASK_DN') THEN
		  EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_WFTASK_DN';
    ELSE
		  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_WFTASK_DN (COMPONENTNAME VARCHAR2(500), COMPOSITEDN VARCHAR2(500), COMPONENTTYPE VARCHAR2(10))';
   END IF;

   IF table_exist('TEMP_UPGRADE_BRDECINST_DN') THEN
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_BRDECINST_DN';
   ELSE
		EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_BRDECINST_DN (COMPONENT_NAME VARCHAR2(500), COMPOSITE_NAME VARCHAR2(500), REVISION VARCHAR2(200))';
   END IF;	 

   IF table_exist('TEMP_UPGRADE_CPNTINST_DN') THEN
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_CPNTINST_DN';
   ELSE
		EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_CPNTINST_DN (COMPONENT_DN VARCHAR2(500))';
   END IF;	   	   
   
   IF table_exist('TEMP_UPGRADE_CM_CASE_HDR_DN') THEN
		EXECUTE IMMEDIATE 'TRUNCATE TABLE TEMP_UPGRADE_CM_CASE_HDR_DN';
   ELSE
		EXECUTE IMMEDIATE 'CREATE TABLE TEMP_UPGRADE_CM_CASE_HDR_DN (COMPONENT_NAME VARCHAR2(500), COMPOSITE_DN VARCHAR2(500))';
   END IF;	 
END;
/

create or replace type composite_instance_type as object 
(
    id	number,
    composite_dn varchar2(1253),
    created_time timestamp,
    updated_time timestamp,
    created_by varchar2(100),
    updated_by varchar2(100),
    tenant_id number(18),
   constructor function composite_instance_type return self as result
    	
)
/
create or replace type body composite_instance_type as 
 
  constructor function composite_instance_type return self as result is
  begin
    return;
  end composite_instance_type;
end;
/
 create or replace type correlation_key_props as object
	(
                 CMPST_DN varchar2(11),
                 CMPNT_NAME varchar2(14),
                 DLV_MSG_GUID  varchar2(19),
				 CORR_STATE  varchar(5),
				 SUBSCRIBER_ID varchar(12),
				 CONV_ID varchar(14),
				 CONV_TYPE varchar(16),
	--	 member function make_composite_dn return varchar2
	constructor function correlation_key_props return self as result,
        member function get_dlv_message_guid return varchar2
	);
/
show errors;

create or replace type body correlation_key_props as 
 
  constructor function correlation_key_props return self as result is
  begin
                 SELF.CMPST_DN  := 'compositeDN';
                 SELF.CMPNT_NAME := 'componentName';
                 SELF.DLV_MSG_GUID := 'deliveryMessageGUID';
				 SELF.CORR_STATE := 'state';
				 SELF.SUBSCRIBER_ID := 'subscriberId';
				 SELF.CONV_ID := 'conversationId';
				 SELF.CONV_TYPE := 'conversationType';
  return;
  end correlation_key_props;
  member function get_dlv_message_guid return varchar2 is
   begin
      return DLV_MSG_GUID;
   end  get_dlv_message_guid ;
 
end;
/
show errors;

 create or replace type enum_fault_type as object
	(
                 SYSTEM varchar2(6),
                 BUSINESS varchar2(8),
                 POLICY  varchar2(6),
	constructor function enum_fault_type return self as result
	);
/
show errors;

create or replace type body enum_fault_type as 
 
  constructor function enum_fault_type return self as result is
  begin
                 SELF.SYSTEM  := 'system';
                 SELF.BUSINESS := 'business';
                 SELF.POLICY := 'policy';
  return;
  end enum_fault_type;
 end;
/
show errors;
create or replace type SE_status_type as object
(
                 fault_id number,
                 recoverable_fault_count number,
                 unhandled_count  number,
		 active_component_count number,
		 cikey number,
    is_stale number,
    is_aborted number,
		member procedure reset_values,	
		constructor function SE_status_type return self as result
);
/
show errors;

create or replace type body SE_status_type as 
 
member   procedure reset_values is 
begin 
                 fault_id  := 0;
                 recoverable_fault_count := 0;
                 unhandled_count := 0;
        	 active_component_count := 0;
    is_stale := 0;
    is_aborted := 0;
end  reset_values;
constructor function SE_status_type return self as result is
begin
                 fault_id  := 0;
                 recoverable_fault_count := 0;
                 unhandled_count := 0;
		 active_component_count := 0;
    is_stale := 0;
    is_aborted := 0; 
  return;
end SE_status_type;
 end;
/
show errors;


create or replace type fault_details as object 
(
      fault_name             varchar2(255),
	  fault_type             varchar2(255),
	--  owner_component_type   varchar2(100),
	  state                  integer ,
	  constructor function fault_details return self as result
)
/
show errors;
create or replace type body fault_details as 
 
  constructor function fault_details return self as result is
  begin
    return;
  end fault_details;
end;
/
show errors;
create or replace type composite_dn_type as object
(
    composite_dn varchar2(1253),
    partition_name varchar2(200),
	composite_name varchar2(500),
	revision varchar2(50),
	label varchar2(500),
    constructor function composite_dn_type(p_composite_dn varchar2) return self as result,
	member function get_partition_name return varchar2,
	member function get_composite_name return varchar2,
	member function get_version_name return varchar2,
	member function get_label_name return varchar2

    
)
/
show errors;

create or replace type body composite_dn_type  as

  constructor function composite_dn_type(p_composite_dn varchar2) return self as result is
  pos1 integer;
  pos2 integer;
  begin
     SELF.composite_dn := p_composite_dn;
	 pos1 := INSTR(composite_dn,'/');
	 SELF.partition_name := SUBSTR(composite_dn,1,pos1-1);
     pos2 := INSTR(composite_dn,'!',pos1+1);
     SELF.composite_name := SUBSTR(composite_dn,pos1+1,pos2-pos1 -1);
     pos1 := INSTR(composite_dn,'*' ,pos2+1);
     SELF.revision := SUBSTR(composite_dn,pos2+1,pos1-pos2-1);
     SELF.label := SUBSTR(composite_dn,pos1+1);  	 
	 return;
  end composite_dn_type;
  member function get_composite_name return varchar2 is
  begin
     return composite_name;
  end get_composite_name;
  member function get_partition_name return varchar2 is
  begin
     return partition_name;
  end get_partition_name;
  member function get_version_name return varchar2 is
  begin
     return revision;
  end get_version_name;
  member function get_label_name return varchar2 is
  begin
     return label;
  end get_label_name;  
 end; 
/
show errors;  
create or replace type cpst_child_comp_type as object
    (
        v_bpel_component integer,
		v_mediator_component integer,
		v_decision_component integer,
		v_case_management_component integer,
		v_workflow_component integer,  
		v_spring_component integer,
		constructor function cpst_child_comp_type(composite_name varchar2,partition_id number,revision_val varchar2 ,label_val varchar2) return self as result,
		member function has_bpel_component return boolean,
		member function has_mediator_component return boolean,
		member function has_decision_component return boolean,
		member function has_case_management_component return boolean,
		member function has_workflow_component return boolean,  
		member function has_spring_component return boolean   
	)
/	
create or replace type body cpst_child_comp_type  as
    constructor function cpst_child_comp_type(composite_name varchar2,partition_id number,revision_val varchar2 ,label_val varchar2) return self as result is
        
        se_subtype_list cache_util.sca_entity_subtype_type;
        BEGIN
        
        SELF.v_bpel_component := 0;
		SELF.v_mediator_component := 0;
		SELF.v_decision_component := 0;
		SELF.v_case_management_component := 0;
		SELF.v_workflow_component := 0;  
		SELF.v_spring_component := 0;
        BEGIN
           -- select ID into partition_id from SCA_PARTITION where NAME = partition_name_val;
           cache_util.get_cache_query_type_2_output(partition_id => partition_id,composite => composite_name, revision => revision_val, sca_entity_subtype_list => se_subtype_list);
           IF se_subtype_list IS NOT NULL AND se_subtype_list.COUNT > 0 THEN
               FOR i IN se_subtype_list.FIRST .. se_subtype_list.LAST LOOP  -- For first to last element
                    DBMS_OUTPUT.PUT_LINE('sub_type::' ||se_subtype_list(i));
                    if(se_subtype_list(i) = 'implementation.bpel' or se_subtype_list(i) = 'implementation.bpmn') then
                    SELF.v_bpel_component := 1;
                    elsif(se_subtype_list(i) = 'implementation.mediator') then
                    SELF.v_mediator_component := 1;
                    elsif(se_subtype_list(i) = 'implementation.decision') then
                    SELF.v_decision_component := 1;
                    elsif (se_subtype_list(i) = 'implementation.casemanagement') then
                    SELF.v_case_management_component := 1 ;
                    elsif (se_subtype_list(i) = 'implementation.workflow') then
                    SELF.v_workflow_component := 1 ;
                    elsif (se_subtype_list(i) = 'implementation.spring') then
                    SELF.v_spring_component := 1;
                    end if;
               END LOOP;
           END IF;
          END;
        return;
    end cpst_child_comp_type;
  
    member function has_bpel_component return boolean is
    begin
        if(v_bpel_component = 0) then
            return false;
        else 
            return true;
        end if;    
    end has_bpel_component;
  
    member function has_mediator_component return boolean is
    begin
        if(v_mediator_component = 0) then
            return false;
        else 
            return true;
        end if;    
    end has_mediator_component;
  
    member function has_decision_component return boolean is
    begin
        if(v_decision_component = 0) then
            return false;
        else 
            return true;
        end if;    
    end has_decision_component;
  
    member function has_case_management_component return boolean is
    begin
        if(v_case_management_component = 0) then
            return false;
        else 
            return true;
        end if;    
    end has_case_management_component;  
  
    member function has_workflow_component return boolean is
    begin
        if(v_workflow_component = 0) then
            return false;
        else 
            return true;
        end if;    
    end has_workflow_component; 

    member function has_spring_component return boolean is
    begin
        if(v_spring_component = 0) then
            return false;
        else 
            return true;
        end if;    
    end has_spring_component;   
end;
/
show errors;
create or replace type sca_flow_to_cpst_type as object 
(
	composite_id  integer,
	flow_id  integer,
	title  nvarchar2(100),
	composite_sca_entity_id integer,
	created_time 	timestamp,
	updated_time  timestamp,
	active_component_instances integer,
	partition_date timestamp,
	sca_partition_id integer,
	tenant_id  integer,
    composite_dn varchar2(1253),
    partition_name varchar2(200),
	composite_name varchar2(500),
	revision varchar2(50),
	label varchar2(500),		
	constructor function sca_flow_to_cpst_type return self as result
)
/
show errors;

create or replace type body sca_flow_to_cpst_type as 
 
  constructor function sca_flow_to_cpst_type return self as result is
  begin
    return;
  end sca_flow_to_cpst_type;
end;
/
show errors;
create or replace function get_next_sca_sequence(seq_type in varchar2, range_interval in number) return number is 
	pragma autonomous_transaction;
	next_range_val number;
	CURSOR sca_sequence_update
	IS
		select next_range from sca_sequence where RANGE_NAME  = seq_type for update of next_range;
	BEGIN 
		open sca_sequence_update;
		fetch sca_sequence_update into next_range_val;
			update sca_sequence set next_range = next_range_val + range_interval where RANGE_NAME = seq_type; 
        close sca_sequence_update;
		commit;
		return next_range_val;
	

end get_next_sca_sequence;
/
show errors;
create or replace function get_next_id(seq_type in varchar2  )  return number is 
   current_range_upper_val number;
   current_range_lower_val number; 
   range_interval number := 1000;
   next_range_val number;
   

   CURSOR update_current_sequence 
   IS 
       select current_range_lower,current_range_upper from upgrade_current_sequence_temp where RANGE_NAME = seq_type
       for update ;   

BEGIN

   open update_current_sequence ;
   fetch update_current_sequence into current_range_lower_val,current_range_upper_val ;

   if current_range_lower_val = -1 OR current_range_lower_val =  current_range_upper_val  then
		next_range_val := get_next_sca_sequence(seq_type,range_interval);
        update upgrade_current_sequence_temp set current_range_lower = next_range_val + 1 ,current_range_upper = next_range_val + range_interval -1  where  RANGE_NAME = seq_type;
        current_range_lower_val := next_range_val;
   else
	update upgrade_current_sequence_temp set current_range_lower = current_range_lower_val + 1 where RANGE_NAME = seq_type;
   end if;

   close update_current_sequence;

   RETURN current_range_lower_val;

END; 
/ 
show errors;

create or replace function get_composite_dn_med_orphan(component_dn_val in varchar2) return varchar2 IS
	 composite_dn_val varchar2(1253);
	 pos integer;
  BEGIN
     pos := INSTR(component_dn_val,'*');
     if pos = 0 then  
        composite_dn_val := substr(component_dn_val,0,instr(component_dn_val,'/',1,2)-1) || '*LABEL_NOT_FOUND';
	 else
	    composite_dn_val := substr(component_dn_val,0,instr(component_dn_val,'/',1,2)-1); 
	 end if;	
	 return composite_dn_val;
  END get_composite_dn_med_orphan;
/ 
show errors;


create or replace type component_dn_type as object
(
   component_dn varchar2(1500),
   partition_name varchar2(200),
   composite_name varchar2(500),
   revision varchar2(50),
   label varchar2(500),
   component_name varchar2(500),
   constructor function component_dn_type(p_component_dn varchar2) return self as result,
   member function get_partition_name return varchar2,
   member function get_composite_name return varchar2,
   member function get_version_name return varchar2,
   member function get_label_name return varchar2,
   member function get_component_name return varchar2
);
/
show errors;

create or replace type body component_dn_type  as

  constructor function component_dn_type(p_component_dn varchar2) return self as result is
  pos1 integer;
  pos2 integer;
  label_not_found varchar2(50) := 'LABEL_NOT_FOUND';
  no_label boolean := false;
  begin
     SELF.component_dn := p_component_dn;
         pos1 := INSTR(component_dn,'/');
         SELF.partition_name := SUBSTR(component_dn,1,pos1-1);
     pos2 := INSTR(component_dn,'!',pos1+1);
     SELF.composite_name := SUBSTR(component_dn,pos1+1,pos2-pos1 -1);
     pos1 := INSTR(component_dn,'*' ,pos2+1);
     if pos1 = 0 then 
       pos1 := INSTR(component_dn,'/',pos2+1);
       no_label := true;
     end if;
     SELF.revision := SUBSTR(component_dn,pos2+1,pos1-pos2-1);
     if no_label = false then
	     pos2 := INSTR(component_dn,'/',pos1+1);
	     SELF.label := SUBSTR(component_dn,pos1+1,pos2-pos1-1);
     else
	     SELF.label := label_not_found;
             pos2 := pos1;  
     end if;

     SELF.component_name := SUBSTR(component_dn,pos2+1);
         return;
  end component_dn_type;
  member function get_composite_name return varchar2 is
  begin
     return composite_name;
  end get_composite_name;
  member function get_partition_name return varchar2 is
  begin
     return partition_name;
  end get_partition_name;
  member function get_version_name return varchar2 is
  begin
     return revision;
  end get_version_name;
  member function get_label_name return varchar2 is
  begin
     return label;
  end get_label_name;
  member function get_component_name return varchar2 is
  begin
    return component_name;
  end get_component_name;
 end;
/
show errors;

create or replace type sca_entity_type as object
(
        id  integer,
        sca_partition_id  integer,
        composite  varchar2(500),
        revision varchar2(50),
        label varchar2(500),
        name varchar2(500),
        type varchar2(50),
        subtype varchar2(100),
        state varchar2(10),
        properties varchar2(4000),
        constructor function sca_entity_type return self as result
);
/
show errors;

create or replace type body sca_entity_type as

  constructor function sca_entity_type return self as result is
  begin
    return;
  end sca_entity_type;
end;
/
show errors;

create or replace type migration_return_type as object
(
    m_flow_id number ,
    m_fault_id number ,
    m_component_id number ,
    m_sca_entity_id number,
    m_sca_partition_id number,
    constructor function migration_return_type(p_ret_values varchar2) return self as result
   
)
/
show errors;

create or replace type body migration_return_type  as

  constructor function migration_return_type(p_ret_values varchar2) return self as result is
    flow_id_name varchar2(8) := 'FLOW_ID=';
    fault_id_name varchar2(9) := 'FAULT_ID=';
    component_id_name varchar2(13) := 'COMPONENT_ID=';
    sca_entity_id_name varchar2(14) := 'SCA_ENTITY_ID=';
    sca_partition_id_name varchar2(17) := 'SCA_PARTITION_ID=';
    pos number;
  begin
         --get flow_id 
	 pos :=  instr(p_ret_values,flow_id_name,1,1); 
	 if pos > 0 then 
	    SELF.m_flow_id := substr( p_ret_values, 
               instr(p_ret_values,flow_id_name,1,1) + length(flow_id_name), 
               instr(p_ret_values,';',instr(p_ret_values,flow_id_name,1,1) +  length(flow_id_name),1) - instr(p_ret_values,flow_id_name,1,1) - length(flow_id_name));
	 end if;  
         -- get sca_partition_id
	 pos :=  instr(p_ret_values,sca_partition_id_name,1,1);
	 if pos > 0 then 
	    SELF.m_sca_partition_id := substr( p_ret_values, 
               instr(p_ret_values,sca_partition_id_name,1,1) + length(sca_partition_id_name), 
               instr(p_ret_values,';',instr(p_ret_values,sca_partition_id_name,1,1) +  length(flow_id_name),1) - instr(p_ret_values,sca_partition_id_name,1,1) - length(sca_partition_id_name));
	 end if;   
     return;
  end migration_return_type;
 end; 
/
show errors;
create or replace  function  insert_sca_entity
(
    sca_entity_obj in sca_entity_type
) return number as
    sca_entity_ids varchar(100) := 'SCA_ENTITY_IDS';
    sca_id number := -1;
    begin
        begin
            sca_id := get_next_id(sca_entity_ids);
            insert into sca_entity
            (
                id,
                sca_partition_id,
                composite,
                revision,
                label,
                name,
                type,
                state
             )
             VALUES
            (
                sca_id,
                sca_entity_obj.sca_partition_id,
                sca_entity_obj.composite,
                sca_entity_obj.revision,
                sca_entity_obj.label,
                sca_entity_obj.name,
                sca_entity_obj.type,
                sca_entity_obj.state
             );
             dbms_output.put_line('Inserted sca_entity with id:' || sca_id || ', composite:' || sca_entity_obj.composite ||  ', service :' || sca_entity_obj.name || ', partition :' || sca_entity_obj.sca_partition_id || ', revision :' || sca_entity_obj.revision);
         exception
             when others then 
                sca_id := -1;
         end;
         return sca_id;
end insert_sca_entity;
/
show errors;
create or replace procedure write_log(line in varchar2, log_file in  utl_file.file_type default null) is
begin

 if utl_file.is_open(log_file)=false  then
      dbms_output.put_line(line);
  else
     begin
         utl_file.put_line (log_file,line);
     exception 
       when others then
         dbms_output.put_line('log:' || line);
     end;
  end if;
end write_log;
/
show errors;



create or replace procedure log_debug(message in varchar2, log_file utl_file.file_type default null) is

begin
  $IF $$debug_on $THEN
           write_log('DEBUG: '||message,log_file);
  $ELSE
     null;
  $END
end log_debug;
/
show errors;

/*
 * this procedure is already defined in 
 * $pcbpel/admin/sqlutils12/soa_purge/oracle/common/purge_common_oracle.sql
 * this duplicate will cause sql re-compile, and result in invalid procedures and packages in Oracle SQL Developer
 * 
create or replace procedure log_error(message in varchar2, log_file utl_file.file_type default null) is

begin
    write_log('ERROR: '||message,log_file);
end log_error;
/
show errors;
*/

create or replace function  get_logfile(thread in integer default -1) return utl_file.file_type is
    log_file  utl_file.file_type;
    LOG_DIR_NAME     varchar2(40) := 'UPGRADE_DIR';
    filename  varchar2(50) := '__upgrade_' || to_char(systimestamp, 'DD-MON-YYYY-HH24:MI:SS.FF') ;
    begin
        if thread <> -1 then 
           filename := 	'__upgrade_' || thread  || '_' || to_char(systimestamp, 'DD-MON-YYYY-HH24:MI:SS.FF') ;	
        end if;
        dbms_output.put_line('calling fopen');
        log_file := utl_file.fopen (LOG_DIR_NAME,filename, 'W');
    return log_file;
    EXCEPTION
       when others then
           dbms_output.put_line('Error while trying to open log file due to - ' || SQLERRM);
           return null;
end get_logfile;
/
show errors;

create or replace procedure close_logfile(log_file in out utl_file.file_type) is
    begin
        if (utl_file.is_open(log_file)) then
            utl_file.fclose(log_file);
        end if;
    end close_logfile;
/
show errors;

create or replace procedure set_LogLevel(log_level number) is

begin

    if(log_level = 0) then
       execute immediate 'ALTER PROCEDURE log_debug COMPILE PLSQL_CCFLAGS = ''debug_on:false'' REUSE SETTINGS';
    elsif (log_level = 1) then
       execute immediate 'ALTER PROCEDURE log_debug COMPILE PLSQL_CCFLAGS = ''debug_on:TRUE'' REUSE SETTINGS';
    else
       execute immediate 'ALTER PROCEDURE log_debug COMPILE PLSQL_CCFLAGS = ''debug_on:false'' REUSE SETTINGS';
    end if;
end set_LogLevel;
/
show errors;
create or replace procedure  dumpScaEntities
(
    log_file in  utl_file.file_type 
)
is
    begin
       log_debug('dumpScaEntities start', log_file);
       for sca_entity_record in
            ( select id,sca_partition_id, composite, revision, name, type from sca_entity )
            loop
                  log_debug('sca_id : ' || sca_entity_record.ID ||
                                    ' sca_partition_id : ' || sca_entity_record.sca_partition_id || 
                                    ' composite : ' || sca_entity_record.composite || 
                                    ' revision : ' || sca_entity_record.revision || 
                                    ' name : ' || sca_entity_record.name || 
                                    ' type : ' || sca_entity_record.type , log_file);
            end loop;
        log_debug('dumpScaEntities end', log_file);
end dumpScaEntities;
/
show errors;


create or replace procedure insert_error_log
    (
        thread     IN INTEGER,
        ecid       IN VARCHAR,
        log_level  IN NUMBER,
        ecode      IN NUMBER, 
        emesg      IN VARCHAR2
    )
    is 
    begin
        insert into UPGRADE_ERROR_LOG values(thread, systimestamp, ecid,log_level, ecode || ':' || emesg);
        commit;
    exception
        when others then 
            log_error('Unable to insert into UPGRADE_ERROR_LOG ' || SQLERRM);
end  insert_error_log;
/
show errors;

/*
* set_metadata_job_complete
*/
 CREATE OR REPLACE PROCEDURE set_metadata_job_complete(
                   metadata_job_complete_v in varchar2
                   )
        is

    job_name_v varchar2(40);

 begin

    job_name_v :=  'CONTROL_MIGRATION_MAIN_JOB';

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'METADATA_JOB_COMPLETE',
      argument_value => metadata_job_complete_v);

    exception
      when others then
        log_error('ERROR (set_metadata_job_complete)');
        rollback;
        raise;

 end set_metadata_job_complete;
/
show errors;
/*
* Count outstanding ECIDS.
*/
create or replace  function is_upgrade_complete return number is
          no_of_rows  number := 0;
          tot_no_of_rows number := 0;

     begin

        tot_no_of_rows := 0;
        no_of_rows := 0;
        select /*+ INDEX(COMPOSITE_INSTANCE COMPOSITE_INSTANCE_FLOWID) */ count(1) into no_of_rows from composite_instance
        where flow_id is null;
          if no_of_rows > 0 then
             tot_no_of_rows := tot_no_of_rows + no_of_rows;
          end if;

        no_of_rows := 0;
        select count(1) into no_of_rows from cube_instance
        where  cmpst_id is null and FLOW_ID = -1;
          if no_of_rows > 0 then
             tot_no_of_rows := tot_no_of_rows + no_of_rows;
          end if;

        no_of_rows := 0;
        select /*+ INDEX(MEDIATOR_INSTANCE MEDIATOR_INSTANCE_FLOWID) */ count(1) into no_of_rows  from mediator_instance
        where  (composite_instance_id is null OR composite_instance_id = 0)  and FLOW_ID is null;
          if no_of_rows > 0 then
             tot_no_of_rows := tot_no_of_rows + no_of_rows;
          end if;

        no_of_rows := 0;
        SELECT count(1) into no_of_rows from REJECTED_MESSAGE
        WHERE FLOW_ID IS NULL;
          if no_of_rows > 0 then
             tot_no_of_rows := tot_no_of_rows + no_of_rows;
          end if;

        no_of_rows := 0;
        SELECT count(1) into no_of_rows from EDN_EVENT_ERROR_STORE
        WHERE FLOW_ID IS NULL AND STATE=1;
          if no_of_rows > 0 then
             tot_no_of_rows := tot_no_of_rows + no_of_rows;
          end if;

                --TODO check b2b

       return tot_no_of_rows;

end is_upgrade_complete;
/
show errors;

/*
* Determine if there are any outstanding flows.
*/
create or replace  function any_flows_remaining return boolean is
          no_of_rows  number := 0;

     begin

        no_of_rows := 0;
        select count(1) into no_of_rows from composite_instance
        where flow_id is null and rownum < 2;
          if no_of_rows > 0 then
             return true;
          end if;

        no_of_rows := 0;
        select count(1) into no_of_rows from cube_instance
        where  cmpst_id is null and FLOW_ID = -1 and rownum < 2;
          if no_of_rows > 0 then
             return true;
          end if;

        no_of_rows := 0;
        select count(1) into no_of_rows  from mediator_instance
        where ( composite_instance_id is null OR composite_instance_id = 0 ) and FLOW_ID is null
          and  rownum < 2;
          if no_of_rows > 0 then
             return true;
          end if;

        no_of_rows := 0;
        SELECT count(1) into no_of_rows from REJECTED_MESSAGE
        WHERE FLOW_ID IS NULL and rownum < 2;
          if no_of_rows > 0 then
             return true;
          end if;

        no_of_rows := 0;
        SELECT count(1) into no_of_rows from EDN_EVENT_ERROR_STORE
        WHERE FLOW_ID IS NULL AND STATE=1 and rownum < 2;
          if no_of_rows > 0 then
             return true;
          end if;

       return false;

end any_flows_remaining;
/
show errors;

/*
* is_stop_injected
*/
CREATE OR REPLACE FUNCTION is_stop_injected
  return boolean
   is

 begin

   FOR v_rec in (select parm,value from upgrade_injection)
    LOOP
      IF upper(v_rec.parm) = 'STOP' THEN
         IF upper(v_rec.value) = 'TRUE' THEN
            RETURN TRUE;
         END IF;
      END IF;
   END LOOP;

   RETURN FALSE;

 end is_stop_injected;
/
show errors;
create or replace function crop_error_stack(error_stack varchar2,max_length number ,log_file IN utl_file.file_type) return varchar2 as 
	len number := LENGTH(error_stack);
	v_len PLS_INTEGER := LEAST (len, max_length);
	BEGIN 
		return SUBSTR (error_stack, 1, v_len);		
		EXCEPTION 
		WHEN OTHERS THEN 
			log_error('Error in crop error stack :'||SQLERRM,log_file);
	
end;
/
show errors;
