create or replace PACKAGE br_migrate AS
  PROCEDURE perform_br_upgrade 
	(
		flow_id IN NUMBER,
		cmp_ecid IN VARCHAR2,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		se_status_obj IN OUT SE_status_type,
		log_file IN utl_file.file_type,
		is_orphaned_case in boolean default false
	);
	 
	FUNCTION populate_common_fault
	(
		component_name IN varchar2,
		comp_fault_key_val IN VARCHAR2,
		fault_name_val IN VARCHAR2,
		fault_type IN INTEGER,
		error_message_val IN CLOB,
		creation_date_val IN TIMESTAMP,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		se_status_obj IN OUT SE_status_type,
        is_orphaned_case in boolean default false
	) RETURN NUMBER;

	PROCEDURE update_br_tables
	(
		ecid_val IN VARCHAR2, 
		flow_id_val IN NUMBER
	);

	PROCEDURE debug 
	(
		debug_text IN VARCHAR2
	);

	PROCEDURE error 
	(
		error_text IN VARCHAR2
	);

END br_migrate;
/
show errors

create or replace PACKAGE BODY br_migrate AS   
	PROCEDURE perform_br_upgrade 
	(
		flow_id IN NUMBER,
		cmp_ecid IN VARCHAR2,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		se_status_obj IN OUT SE_status_type,
		log_file IN utl_file.file_type,
		is_orphaned_case in boolean default false
	)
	IS
      component_id_val  number;
	  component_ids_seq  VARCHAR(100) := 'COMPONENT_INSTANCE_IDS';
	  str_composite_instance_id VARCHAR2(100);
     
	  
	BEGIN
	    debug('Business Rules component fault migration started...');
		
		se_status_obj.recoverable_fault_count := 0;
		se_status_obj.active_component_count := 0;
		se_status_obj.unhandled_count := 0;
		if(is_orphaned_case = TRUE) then
			log_debug('TEMP_UPGRADE_BRDECISION global temp table used for orphans',log_file );
			FOR br_instance in (SELECT /*+ INDEX(TEMP_UPGRADE_BRDECISION ECID_TEMP_BRD_IDX) */ id, component_name,state from TEMP_UPGRADE_BRDECISION WHERE ECID = cmp_ecid  )
            
			LOOP
            if br_instance.state = 6 then 
                se_status_obj.is_stale := 1;
            end if;    
            component_id_val := get_next_id(component_ids_seq);
            update BRDECISIONINSTANCE set COMPONENT_ID = component_id_val where id = br_instance.id;
			  FOR br_faulted_instance in (SELECT instance_id, qname, fault_type, message, creation_time FROM BRDECISIONFAULT WHERE instance_id = br_instance.id)
			  LOOP
					se_status_obj.fault_id := populate_common_fault(br_instance.component_name, br_faulted_instance.instance_id, br_faulted_instance.qname, br_faulted_instance.fault_type, br_faulted_instance.message, br_faulted_instance.creation_time, sca_flow_to_cpst_obj,se_status_obj,is_orphaned_case);
					debug('SCA_COMMON_FAULT populated sucessfully...');
			  END LOOP;
			END LOOP;
		else
			log_debug('BRDECISIONINSTANCE normal table used',log_file );
            str_composite_instance_id := TO_CHAR(sca_flow_to_cpst_obj.composite_id);
			FOR br_instance in (SELECT /*+ INDEX(TEMP_UPGRADE_BRDECISION CPST_ID_TEMP_BRD_IDX) */ id, component_name,state from TEMP_UPGRADE_BRDECISION WHERE ECID = cmp_ecid and COMPOSITE_INSTANCE_ID = str_composite_instance_id )
			LOOP      
            if br_instance.state = 6 then 
                se_status_obj.is_stale := 1;
            end if; 
			 component_id_val := get_next_id(component_ids_seq);
             update BRDECISIONINSTANCE set COMPONENT_ID = component_id_val where id = br_instance.id;
				
			  FOR br_faulted_instance in (SELECT instance_id, qname, fault_type, message, creation_time FROM BRDECISIONFAULT WHERE instance_id = br_instance.id)
			  LOOP
					se_status_obj.fault_id := populate_common_fault(br_instance.component_name, br_faulted_instance.instance_id, br_faulted_instance.qname, br_faulted_instance.fault_type, br_faulted_instance.message, br_faulted_instance.creation_time, sca_flow_to_cpst_obj,se_status_obj,is_orphaned_case);
					debug('SCA_COMMON_FAULT populated sucessfully...');
			  END LOOP;
			END LOOP;
		end if;
	    
		  debug('Business Rules component fault migration completed successfully!!!');
	END; 

	FUNCTION populate_common_fault
	(
		component_name IN varchar2,
		comp_fault_key_val IN VARCHAR2,
		fault_name_val IN VARCHAR2,
		fault_type IN INTEGER,
		error_message_val IN CLOB,
		creation_date_val IN TIMESTAMP,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		se_status_obj IN OUT SE_status_type,
        is_orphaned_case in boolean default false
		
	) RETURN NUMBER 
	
	IS
    br_sca_entity_id NUMBER;
	fault_id_val NUMBER;
	fault_state NUMBER;
	fault_type_val VARCHAR2(100);
	common_fault_type enum_fault_type := new enum_fault_type;
    m_composite_name varchar2(500) := null;
    m_composite_domain varchar2(50) := null;
    m_composite_version varchar2(50) := null;
    m_composite_label varchar2(50) := null;
    m_partition_id integer;
    m_composite_id number;
    composite_sca_entity_id integer;

	BEGIN
		--generate fault_id
		fault_id_val := get_next_id('FAULT_IDS');
		debug('fault_id generated:::' || fault_id_val);
		debug('comp_fault_key_val:::' || comp_fault_key_val);
		debug('component_name:::' || component_name);
		debug('composite_sca_entity_id:::' || sca_flow_to_cpst_obj.composite_sca_entity_id);
		debug('fault_name_val:::' || fault_name_val);
		debug('fault_type_val:::' || upper(fault_type_val));
		debug('sca_partition_id:::' || sca_flow_to_cpst_obj.sca_partition_id);
		debug('creation_date_val:::' || creation_date_val);
		
		fault_state := 256; -- non recoverable always
		
		fault_type_val := common_fault_type.SYSTEM; --can only be 0 (System) or 1 (Business)
		IF fault_type = 1 THEN
			fault_type_val := common_fault_type.BUSINESS;
		END IF;
        if is_orphaned_case = true then 
        select COMPOSITE_NAME,REVISION,LABEL into m_composite_name,m_composite_version,m_composite_label from brdecisioninstance where id = comp_fault_key_val and rownum = 1;
        m_composite_domain := SUBSTR(component_name,1,(INSTR(component_name,'/'))-1);
        cache_util.get_cache_query_type_4_output(name => m_composite_domain, sca_partition_id => m_partition_id);
        
            SELECT ID INTO br_sca_entity_id FROM SCA_ENTITY WHERE SCA_PARTITION_ID = m_partition_id AND COMPOSITE = m_composite_name  AND 
                                                              REVISION = m_composite_version AND 
                                                              NAME = REGEXP_SUBSTR(component_name,'[^/]*$') AND 
															  --LABEL = sca_flow_to_cpst_obj.LABEL AND 
                                                              TYPE ='component' AND
															  SUB_TYPE = 'implementation.decision' and rownum = 1;
         cache_util.get_cache_query_type_1_output(partition_id => m_partition_id,composite => m_composite_name, revision => m_composite_version, sca_entity_id => composite_sca_entity_id);

         m_composite_id := sca_flow_to_cpst_obj.composite_id; 
        else
       
         SELECT ID INTO br_sca_entity_id FROM SCA_ENTITY WHERE SCA_PARTITION_ID = sca_flow_to_cpst_obj.SCA_PARTITION_ID  AND 
                                                              COMPOSITE = sca_flow_to_cpst_obj.COMPOSITE_NAME  AND 
                                                              REVISION = sca_flow_to_cpst_obj.REVISION AND 
                                                              NAME = REGEXP_SUBSTR(component_name,'[^/]*$') AND 
															 -- LABEL = sca_flow_to_cpst_obj.LABEL AND 
                                                              TYPE ='component' AND
															  SUB_TYPE = 'implementation.decision';
           composite_sca_entity_id := sca_flow_to_cpst_obj.composite_sca_entity_id;
           m_partition_id := sca_flow_to_cpst_obj.sca_partition_id; 
           m_composite_id := sca_flow_to_cpst_obj.composite_id; 
		end if; 
		INSERT INTO SCA_COMMON_FAULT
				(
				   ID,
				   RETRY_COUNT,
				   FLOW_ID,
				   COMPONENT_TYPE,
				   COMPONENT_FAULT_KEY,
				   SCA_ENTITY_ID,
				   COMPOSITE_SCA_ENTITY_ID,
				   OWNER_SCA_ENTITY_ID,
				   OWNER_COMPONENT_TYPE,
				   OWNER_COMPOSITE_SCA_ENTITY_ID,
				   FAULT_NAME,
				   FAULT_TYPE,
				   ERROR_MESSAGE,
				   STATE,
				   SCA_PARTITION_ID,
				   OWNER_SCA_PARTITION_ID,
				   COMPOSITE_ID,
				   CREATION_DATE,
				   MODIFY_DATE	
				)
			   VALUES
				(
				   fault_id_val,
				   0,
				   sca_flow_to_cpst_obj.flow_id,
				   'decision',
				   comp_fault_key_val,
				   br_sca_entity_id,
				   composite_sca_entity_id,
				   br_sca_entity_id,
				   'decision',
				   composite_sca_entity_id,
				   fault_name_val,
				   fault_type_val,
				   error_message_val,
				   fault_state,
				   m_partition_id,
				   m_partition_id,
  			   m_composite_id,
 				   creation_date_val,
				   creation_date_val
				);
				 se_status_obj.unhandled_count := se_status_obj.unhandled_count + 1; -- increase the unhandled fault count for each common fault inserted.
				RETURN fault_id_val;
	END;

	PROCEDURE update_br_tables
	(
		ecid_val IN VARCHAR2,
		flow_id_val IN NUMBER
	)
	IS
	BEGIN
		UPDATE BRDECISIONINSTANCE SET FLOW_ID = flow_id_val WHERE ID IN (SELECT /*+ INDEX(TEMP_UPGRADE_BRDECISION ECID_TEMP_BRD_IDX) */ ID FROM TEMP_UPGRADE_BRDECISION WHERE ECID = ecid_val ) ;
	END;

	PROCEDURE debug 
	(
		debug_text IN VARCHAR2
	)
	IS
	BEGIN
		log_debug(debug_text);
	END;

	PROCEDURE error 
	(
		error_text IN VARCHAR2
	)
	IS
	BEGIN
		log_error(error_text);
	END;

END br_migrate;
/
show errors
