/*Rem
Rem $Header: 
Rem
Rem MG_VERIFY.sql
Rem
Rem Copyright (c) 2009, 2022, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     MG_VERIFY.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr    05/10/22 - Backport
Rem                         linlxu_blr_backport_33773901_12.2.1.4.211221soabp
Rem                         from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr    01/20/22 - Backport
Rem                         apfwkr_blr_backport_33581656_12.2.1.4.210928soabp
Rem                         from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr    12/14/21 - Backport apfwkr_blr_backport_33581656_12.2.1.4.0
Rem                         from main
Rem    linlxu    03/09/22 - Backport linlxu_bug-33773901_1221_main from main
Rem    apfwkr    01/17/20 - Backport linlxu_bug-30303875_12212-main from main
Rem    apfwkr    11/17/19 - Backport linlxu_bug-30507140_12212-main from main
Rem    apfwkr    12/13/21 - Backport jbahadur_bug-33581656 from
Rem                         st_pcbpel_12.2.1.4.0soabp
Rem    linlxu    03/31/16 - Created
Rem
Rem
Rem ==========================================================
Rem 
Rem Description
Rem -----------
Rem This Package will verify the given MEDIATOR_GROUP_STATUS partitions.
Rem 
Rem Procedure/functions
Rem -------------------
Rem MG_chk_part_ok: Check Driver Partition for MEDIATOR_GROUP_STATUS:
Rem  Checks if all rows in the partition are completed.
Rem
Rem


/*
***********************************************************
  Med_Ser_Seq_Ok :  Check MEDIATOR_SERVICE_DETAIL and MEDIATOR_RESEQUENCER_MESSAGE
***********************************************************
-- Check documents in MEDIATOR_SERVICE_DETAIL and MEDIATOR_RESEQUENCER_MESSAGE
   still related to MEDIATOR_GROUP_STATUS partition.
-- If not; print total document to allow the DBA to decide 
   on whether to purge or migrate rows.

  MG_Chk_Part_Ok :  Check Driver Partition for MEDIATOR_GROUP_STATUS
***********************************************************
-- Checks that the mediator_group_status partition has only  
   completed flows.
-- If not; print total rows and total rows completed to
   allow the DBA to decide on whether to purge or 
   migrate rows.
*********************************************************** 
*/
FUNCTION Med_Ser_Seq_Ok 
(mg_part_name in varchar2,log_handle in UTL_FILE.file_type) 
return NUMBER 
IS

MG_SUCCESS        BOOLEAN := TRUE; 
mg_total_count    NUMBER;
stmt              VARCHAR2(2000);
verify_id_table varchar2(100) :='verify_MG_group2';
BEGIN 

UTL_FILE.Put_Line (log_handle, 'CHECKING MEDIATOR_GROUP_STATUS TABLE');

stmt := 'SELECT mgs.id '
     || 'FROM MEDIATOR_GROUP_STATUS PARTITION(PARTNAME) mgs '
     || 'WHERE mgs.status != 0 '
     || 'OR (mgs.resequencer_type = ''Standard'' '
     || '    AND not exists (SELECT 1 FROM MEDIATOR_SERVICE_DETAIL msd '
     || '                 WHERE msd.component_dn = mgs.component_dn '
     || '                 AND msd.level_detail2 = mgs.level_detail2 '
     || '                 AND msd.operation = mgs.operation '
     || '                 AND msd.component_status = 1) '
     || '   ) ';
stmt := REPLACE(stmt,'PARTNAME',mg_part_name);
stmt := 'insert into ' || verify_id_table  ||' ' || stmt;
-- dbms_output.put_line('stmt : ' || stmt);
EXECUTE IMMEDIATE stmt ;
 mg_total_count := SQL%ROWCOUNT;
stmt := 'SELECT mgs.id '
     || 'FROM MEDIATOR_GROUP_STATUS PARTITION(PARTNAME) mgs '
     || 'WHERE exists (SELECT 1 FROM MEDIATOR_RESEQUENCER_MESSAGE mrm '
     || '              WHERE mgs.id = mrm.owner_id) '
     || 'AND mgs.id not in (SELECT mgs2.id FROM ' || verify_id_table || ' mgs2 ) ';
stmt := REPLACE(stmt,'PARTNAME',mg_part_name);
stmt := 'insert into ' || verify_id_table  ||' ' || stmt;
EXECUTE IMMEDIATE stmt ;
 mg_total_count := mg_total_count + SQL%ROWCOUNT;
commit;

IF mg_total_count > 0
THEN
  MG_SUCCESS := FALSE;
  UTL_FILE.Putf     (log_handle, 'TOTAL MEDIATOR MESSAGES STILL ACTIVE    : %s \n', mg_total_count);
ELSE
  UTL_FILE.Put_Line (log_handle, 'NO MEDIATOR MESSAGES ARE STILL ACTIVE ');
END IF;
UTL_FILE.Put_Line   (log_handle, '----------------------------------------------------');

RETURN mg_total_count;
END Med_Ser_Seq_Ok;

FUNCTION MG_Chk_Part_Ok 
(mg_part_name in varchar2, log_handle in UTL_FILE.file_type,result_handle in UTL_FILE.file_type) return boolean IS
mg_open_count    NUMBER ;
mg_count NUMBER;
percent_open NUMBER;
stmt  VARCHAR2(2000);
verify_id_table varchar2(100) :='verify_MG_group2';
BEGIN
UTL_FILE.Put_Line(log_handle, 'CHECKING PARTITION FOR TABLE MEDIATOR_GROUP_STATUS  ')
;
if not partition_exists('MEDIATOR_GROUP_STATUS',mg_part_name) then
  UTL_FILE.Put_Line(log_handle, 'WARNING: Skip MEDIATOR_GROUP_STATUS - PARTITION DOES NOT EXIST ');
  return false;
else
UTL_FILE.Put_Line(log_handle, ' PASS - PARTITION FOUND ');

end if;

mg_open_count := Med_Ser_Seq_Ok(mg_part_name,log_handle);
stmt := 'select count(unique id) from ' || verify_id_table ;
EXECUTE IMMEDIATE stmt into mg_open_count;
IF mg_open_count= 0 THEN 
  
   UTL_FILE.Put_Line
    (log_handle,'PASS: ALL MEDIATOR MESSAGES ARE UNREFERENCED THUS THE');
   UTL_FILE.Put_line
    (log_handle,'        MEDIATOR_GROUP_STATUS PARTITION CAN BE DROPPED');
   write_drop_partition_query('MEDIATOR_GROUP_STATUS',mg_part_name,FALSE,result_handle); 
    return true;
ELSE
   stmt := 'SELECT count(*) '
           || 'FROM MEDIATOR_GROUP_STATUS PARTITION(PARTNAME)';
   stmt := REPLACE(stmt,'PARTNAME',mg_part_name);
   EXECUTE IMMEDIATE stmt INTO mg_count;
   UTL_FILE.Putf
    (log_handle, '** FAIL - TOTAL INSTANCES IN PARTITION  : %s \n', mg_count);

   UTL_FILE.Putf(log_handle, '** FAIL - TOTAL INSTANCES IN PARTITION  : ', mg_part_name);
   if mg_count = 0 then
      percent_open := 0 ;
   else      
      percent_open := mg_open_count/mg_count * 100;
   end if;
   UTL_FILE.Put_line(log_handle, '** FAIL - TOTAL INSTANCES STILL OPEN    : ' 
        || mg_open_count 
        ||' ( ' || trunc(percent_open, 2) || '% )');
   return false;
END IF;

END MG_Chk_Part_Ok;


PROCEDURE mg_row_mvt_script( partition_name in varchar2, new_partition_date in timestamp, file_handle in UTL_FILE.file_type ) is
v_query varchar2(4000);
verify_id_table varchar2(100) :='verify_MG_group2';
mg_count number;
begin

if is_table_partitioned('MEDIATOR_GROUP_STATUS','PARTITION_DATE') then

   dbms_output.put_line('ROW MVMT MEDIATOR_GROUP_STATUS');
   v_query := 'update MEDIATOR_GROUP_STATUS a set PARTITION_DATE = ''' || new_partition_date || ''' where id  in (select id from ' || verify_id_table || ' )';
   v_query := REPLACE(v_query,'PARTNAME',partition_name);
   --   UTL_FILE.Put_Line(file_handle, v_query || '/n');
   execute immediate v_query;
   mg_count := SQL%ROWCOUNT;
   commit;
		
end if ;

commit;

end mg_row_mvt_script;

--SHOW ERRORS;



