/*Rem
Rem $Header: 
Rem
Rem MR_VERIFY.sql
Rem
Rem Copyright (c) 2009, 2022, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     MR_VERIFY.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr    05/10/22 - Backport
Rem                         linlxu_blr_backport_33773901_12.2.1.4.211221soabp
Rem                         from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr    01/20/22 - Backport
Rem                         apfwkr_blr_backport_33581656_12.2.1.4.210928soabp
Rem                         from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr    12/14/21 - Backport apfwkr_blr_backport_33581656_12.2.1.4.0
Rem                         from main
Rem    apfwkr    12/13/21 - Backport jbahadur_bug-33581656 from
Rem                         st_pcbpel_12.2.1.4.0soabp
Rem    linlxu    03/09/22 - Backport linlxu_bug-33773901_1221_main from main
Rem    linlxu    03/31/16 - Created
Rem
Rem
Rem ==========================================================
Rem 
Rem Description
Rem -----------
Rem This Package will verify the given MEDIATOR_RESEQUENCER_MESSAGE partitions.
Rem 
Rem Procedure/functions
Rem -------------------
Rem MR_chk_part_ok: Check Driver Partition for MEDIATOR_RESEQUENCER_MESSAGE:
Rem  Checks if all rows in the partition are completed.
Rem
Rem MR_chk_equi_part_ok: Checks dependents for EQUI Partitioning.
Rem   That is; The same NAME, UPPER and LOWER bound.
Rem
Rem
Rem


/*
***********************************************************
  MR_Chk_Part_Ok :  Check Driver Partition for MEDIATOR_RESEQUENCER_MESSAGE
***********************************************************
-- Checks that the MEDIATOR_RESEQUENCER_MESSAGE partition has only  
   completed flows.
-- If not; print total rows and total rows completed to
   allow the DBA to decide on whether to purge or 
   migrate rows.
*********************************************************** 
*/

FUNCTION MR_Chk_Part_Ok 
(mr_part_name in varchar2,fabric_chk_ok in boolean, log_handle in UTL_FILE.file_type,result_handle in UTL_FILE.file_type) 
return BOOLEAN 
IS

MR_SUCCESS         BOOLEAN := TRUE;
mr_open_count      NUMBER; 
mr_total_count     NUMBER;
percent_open       NUMBER(5,2);
stmt               VARCHAR2(2000);
verify_id_table varchar2(100) :='verify_MR_group1A';
BEGIN 

UTL_FILE.Putf     (log_handle, 'CHECKING MEDIATOR_RESEQUENCER_MESSAGE PARTITION %s \n', mr_part_name);
UTL_FILE.Put_Line (log_handle, '----------------------------------------------------');
if not partition_exists('MEDIATOR_RESEQUENCER_MESSAGE',mr_part_name) then
      UTL_FILE.Put_Line(log_handle, '** WARNING:  Skip MEDIATOR_RESEQUENCER_MESSAGE  - PARTITION DOES NOT EXIST  ');
      return false; 
else
      UTL_FILE.Put_Line(log_handle, '** PASS  MEDIATOR_RESEQUENCER_MESSAGE  - PARTITION FOUND ');
end if;

stmt := 'SELECT mrm.id '
     || 'FROM MEDIATOR_RESEQUENCER_MESSAGE PARTITION(PARTNAME) mrm '
     || 'WHERE not exists (SELECT 1 FROM SCA_FLOW_INSTANCE sli '
     || '                 WHERE sli.flow_id = mrm.flow_id AND sli.active_component_instances !=0) ';
  stmt := REPLACE(stmt,'PARTNAME',mr_part_name);
  stmt := 'insert into ' || verify_id_table  ||' ' || stmt;
  UTL_FILE.put_line(log_handle, 'stmt : ' || stmt);
  EXECUTE IMMEDIATE stmt ;
  mr_open_count := SQL%ROWCOUNT;

  stmt := 'SELECT count(*) '
       || 'FROM MEDIATOR_RESEQUENCER_MESSAGE PARTITION(PARTNAME)';
  stmt := REPLACE(stmt,'PARTNAME',mr_part_name);
  EXECUTE IMMEDIATE stmt INTO mr_total_count;

  UTL_FILE.Putf(log_handle, 'TOTAL INSTANCES IN PARTITION  : %s \n', mr_total_count);
  if mr_open_count >  0 then
     MR_SUCCESS := FALSE;
     percent_open := mr_open_count/mr_total_count * 100;
  else
     percent_open := 0;
  end if; 
  UTL_FILE.Put_line(log_handle, 'TOTAL INSTANCES STILL OPEN    : ' || mr_open_count ||' ( ' || percent_open || '% )');

IF MR_SUCCESS=true  then
  UTL_FILE.putf(log_handle,' PASS \n');
  write_drop_partition_query('MEDIATOR_RESEQUENCER_MESSAGE', mr_part_name, FALSE, result_handle);
END IF;
RETURN MR_SUCCESS;
END MR_Chk_Part_Ok;

/*
***********************************************************
   MR_CHK_EQUI_PART_OK: Checks dependents for EQUI Partitioning.
***********************************************************
-- Loop through the collection of dependent tables partitions
   and verify they are equi-partitioned:
   -- Same NAME as MEDIATOR_RESEQUENCER_MESSAGE partition.
   -- Same LOWER BOUND as MEDIATOR_RESEQUENCER_MESSAGE partition.
   -- Same UPPER BOUND as MEDIATOR_RESEQUENCER_MESSAGE partition.
***********************************************************
*/

FUNCTION MR_Chk_Equi_Part_Ok 
(mr_part_name in varchar2, 
log_handle in UTL_FILE.file_type) 
return BOOLEAN 
IS

ALL_EQUI_SUCCESS     BOOLEAN := TRUE;
DEP_PART_FOUND       BOOLEAN := FALSE;
DEP_PART_PASS        BOOLEAN := TRUE;

mr_upp_bound         part_record; 
mr_low_bound         part_record; 
dep_upp_bound        part_record; 
dep_prev_upp_bound   part_record; 
dep_prev_part_pos    PLS_INTEGER := 0; 
mr_prev_part_pos     PLS_INTEGER := 0; 
dep1                 PLS_INTEGER := 0; 
mr_dep_list          mediator_dep_table;
/*
------------------------------------
COMPLETE Hard Coded list of tables 
which are dependent on the 
MEDIATOR_RESEQUENCER_MESSAGE table. 
------------------------------------
*/
CURSOR mr_dependents is 
SELECT TABLE_NAME, HIGH_VALUE, PARTITION_NAME, PARTITION_POSITION
  FROM USER_TAB_PARTITIONS
 WHERE TABLE_NAME IN (
      'MEDIATOR_RESEQUENCER_MESSAGE'
      )
   AND PARTITION_NAME = mr_part_name;

BEGIN
UTL_FILE.Put_line(log_handle, 'CHECKING PARTITION FOR TABLE MEDIATOR_RESEQUENCER_MESSAGE ');
if not partition_exists('MEDIATOR_RESEQUENCER_MESSAGE',mr_part_name) then
  UTL_FILE.Put_Line(log_handle, 'WARNING:  Skip MEDIATOR_RESEQUENCER_MESSAGE  - PARTITION DOES NOT EXIST ' );
  return false;
else
 UTL_FILE.Put_Line(log_handle, ' PASS - PARTITION FOUND' );
end if;

SELECT PARTITION_NAME, HIGH_VALUE, PARTITION_POSITION
  INTO mr_upp_bound
  FROM USER_TAB_PARTITIONS
 WHERE TABLE_NAME = 'MEDIATOR_RESEQUENCER_MESSAGE'
   AND PARTITION_NAME = mr_part_name
   AND ROWNUM < 2;
IF SQL%NOTFOUND
  THEN
    RAISE_APPLICATION_ERROR(-20001, 'MR_VERIFY.Chk_Equi_Part_Ok Logic Error');
END IF;

mr_prev_part_pos := mr_upp_bound.position - 1;

IF mr_prev_part_pos > 0
THEN
SELECT PARTITION_NAME, HIGH_VALUE, PARTITION_POSITION
  INTO mr_low_bound
  FROM USER_TAB_PARTITIONS
 WHERE TABLE_NAME = 'MEDIATOR_RESEQUENCER_MESSAGE'
   AND PARTITION_POSITION = mr_prev_part_pos
   AND ROWNUM < 2;
 IF SQL%NOTFOUND
  THEN
    RAISE_APPLICATION_ERROR(-20002, 'mr_VERIFY.Chk_Equi_Part_Ok Logic Error');
 END IF;
ELSE
 mr_low_bound.position := 0;
END IF;
 mr_dep_list   :=  mediator_dep_table();
 mr_dep_list.extend(1);
 mr_dep_list(1)  := 'MEDIATOR_RESEQUENCER_MESSAGE';
/* 
------------------------------------
Loop through the Partitions for the
 Dependent Tables.
------------------------------------
*/

FOR i in mr_dep_list.FIRST..mr_dep_list.LAST LOOP

UTL_FILE.Putf(log_handle, 'CHECKING PARTITION FOR TABLE %s \n', mr_dep_list(i));

/* 
------------------------------------
Loop through the Dependent tables to 
determine if ALL Dependent Tables 
are partitioned.
------------------------------------
*/
DEP_PART_FOUND := FALSE;
DEP_PART_PASS  := TRUE;

FOR dep1 in mr_dependents LOOP 

IF dep1.partition_name = mr_part_name
AND dep1.table_name = mr_dep_list(i)
THEN
  dep_upp_bound.high_value := dep1.high_value;
  IF dep_upp_bound.high_value = mr_upp_bound.high_value
  THEN
  DEP_PART_FOUND := TRUE;
  UTL_FILE.Put_Line(log_handle, '** PASS - PARTITION NAME MATCH');
  UTL_FILE.Put_Line(log_handle, '** PASS - UPPER BOUND MATCH'); 

/*
------------------------------------
 IF previous partition position is 0 then
  there in no previous parition and LOWER BOUND
  is IMPLICIT.
------------------------------------
*/
  dep_prev_part_pos := dep1.partition_position - 1;  
  IF dep_prev_part_pos = 0
  OR mr_low_bound.position = 0
  THEN
    IF dep_prev_part_pos <> 0
    OR mr_low_bound.position <> 0
    THEN
	DEP_PART_PASS := FALSE;
	UTL_FILE.Put_Line(log_handle, '** FAIL - IMPLICT LOWER BOUND MISMATCH'); 
    ELSE
	UTL_FILE.Put_Line(log_handle, '** PASS - IMPLICT LOWER BOUND MATCH'); 
    END IF;
  ELSE
    SELECT PARTITION_NAME, HIGH_VALUE, PARTITION_POSITION
      INTO dep_prev_upp_bound 
      FROM USER_TAB_PARTITIONS
     WHERE PARTITION_NAME = mr_low_bound.name 
	 AND TABLE_NAME = dep1.table_name
	 AND PARTITION_POSITION = dep_prev_part_pos
       AND ROWNUM < 2;
    IF SQL%FOUND
    THEN
	IF dep_prev_upp_bound.high_value <> mr_low_bound.high_value
	THEN
	  DEP_PART_PASS := FALSE;
	  UTL_FILE.Put_Line(log_handle, '** FAIL - LOWER BOUND MISMATCH'); 
      ELSE
	  UTL_FILE.Put_Line(log_handle, '** PASS - LOWER BOUND MATCH');
      END IF;
     END IF;
    END IF;
   END IF;
  END IF;
END LOOP;

IF DEP_PART_FOUND
THEN 
  IF DEP_PART_PASS 
  THEN
    UTL_FILE.Put_Line(log_handle, '** PASS - EQUI-PARTITIONED TESTS - PASS');
  ELSE
    UTL_FILE.Put_Line(log_handle, '** FAIL - EQUI-PARTITIONED TESTS - FAIL');
    ALL_EQUI_SUCCESS := FALSE;
  END IF;
ELSE
    UTL_FILE.Put_Line(log_handle, 'PARTITION DOES NOT EXIST ');
  --  ALL_EQUI_SUCCESS := FALSE;
END IF;	 

END LOOP; 
 
RETURN ALL_EQUI_SUCCESS;

END MR_Chk_Equi_Part_Ok;

/*
***********************************************************
   MR_CHK_EQUI_PART_INT_OK: Checks dependents for EQUI Partitioning.
***********************************************************
-- Loop through the collection of dependent tables partitions
   and verify they are equi-partitioned:
   -- Same LOWER BOUND as MEDIATOR_RESEQUENCER_MESSAGE partition.
   -- Same UPPER BOUND as MEDIATOR_RESEQUENCER_MESSAGE partition.
***********************************************************
*/

FUNCTION MR_Chk_Equi_Part_Int_Ok
(mr_part_name in varchar2,
 mr_part_hv in timestamp,
 log_handle in UTL_FILE.file_type)
return BOOLEAN
IS

ALL_EQUI_SUCCESS     BOOLEAN := TRUE;
mr_interval          varchar2(1000);
mr_dep_list          mediator_dep_table;

BEGIN

  mr_dep_list   :=  mediator_dep_table();
  mr_dep_list.extend(1);
  mr_dep_list(1)  := 'MEDIATOR_RESEQUENCER_MESSAGE';

--Select the interval partition value for the the MASTER table.
  SELECT INTERVAL
    INTO mr_interval
    FROM USER_PART_TABLES
   WHERE table_name = 'MEDIATOR_RESEQUENCER_MESSAGE'
     AND ROWNUM < 2;
--Doesn't work need EXCEPTION
  IF SQL%NOTFOUND
   THEN
      RAISE_APPLICATION_ERROR(-20002, 'Chk_Equi_Part_Int_Ok Logic Error');
  END IF;

  UTL_FILE.Put_line
     (log_handle, 'CHECKING PARTITION FOR TABLE MEDIATOR_RESEQUENCER_MESSAGE ');

/*
Ensure all dependents have the same INTERVAL value and thus
are table partitioned and on the same interval (day, month, etc)
*/

  FOR i in mr_dep_list.FIRST..mr_dep_list.LAST
   LOOP

   UTL_FILE.Putf
      (log_handle, 'CHECKING PARTITION FOR TABLE %s \n', mr_dep_list(i));
   dbms_output.put_line('TABLE_NAME: ' || mr_dep_list(i));

   for v_rec in (select interval
                  from user_part_tables
                 where table_name = mr_dep_list(i))
   loop
    dbms_output.put_line('Dependent INTERVAL : ' || v_rec.interval);
    if v_rec.interval = mr_interval
     then
        UTL_FILE.Put_Line(log_handle, '** PASS -  INTERVAL VALUE MATCH');
    else
        ALL_EQUI_SUCCESS := FALSE;
        UTL_FILE.Put_Line(log_handle, '** FAIL -  INTERVAL VALUE MISMATCH');
    end if;
   end loop;

  END LOOP;

  IF ALL_EQUI_SUCCESS
  THEN
    UTL_FILE.Put_Line(log_handle, '** PASS -   EQUI-PARTITIONED TESTS - PASS');
  ELSE
    UTL_FILE.Put_Line(log_handle, '** FAIL -   EQUI-PARTITIONED TESTS - FAIL');
  END IF;

RETURN ALL_EQUI_SUCCESS;

END MR_Chk_Equi_Part_Int_Ok;


PROCEDURE mr_row_mvt_script( partition_name in varchar2,new_partition_date in varchar2, file_handle in UTL_FILE.file_type ) is
v_query varchar2(4000);
verify_id_table varchar2(100) :='verify_MR_group1A';
mr_count number;
begin

if is_table_partitioned('MEDIATOR_RESEQUENCER_MESSAGE','PARTITION_DATE') then
  v_query := 'update MEDIATOR_RESEQUENCER_MESSAGE set PARTITION_DATE = ''' || new_partition_date || ''' where id  in (select id from ' || verify_id_table || ' )';
     --   UTL_FILE.Put_Line(file_handle, v_query || '/n');
   execute immediate v_query;
   mr_count := SQL%ROWCOUNT;
   commit;
 
end if ;

end mr_row_mvt_script;



