Rem
Rem $Header: pcbpel/admin/sqlutils12/verify/oracle/soa_verify.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/01/28 22:03:35 apfwkr Exp $
Rem
Rem SOA_VERIFY.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      SOA_VERIFY.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      01/17/20 - Backport linlxu_bug-30303875_12212-main from main
Rem    linlxu      05/14/19 - XbranchMerge linlxu_bug-21805776_12.1.3 from
Rem                           st_pcbpel_12.1.3.0.0soabp
Rem    ssudarsa    05/10/10 - Created
Rem

BEGIN

  IF table_exist('VERIFY_MG_GROUP2') THEN
    EXECUTE IMMEDIATE 'DROP TABLE verify_MG_group2';
  END IF;
  IF table_exist('VERIFY_MR_GROUP1A') THEN
    EXECUTE IMMEDIATE 'DROP TABLE verify_MR_group1A';
  END IF;

  
  EXECUTE IMMEDIATE 'CREATE TABLE verify_MG_group2 (id varchar2(100))';
  EXECUTE IMMEDIATE 'CREATE TABLE verify_MR_group1A (id varchar2(50))';

END;
/
CREATE OR REPLACE PACKAGE VERIFY_SOA
IS
TYPE soa_drv_table is TABLE of VARCHAR2(100);

TYPE soa_interval_record is RECORD (
  part_name VARCHAR2(100),
  part_hv_timestamp timestamp);
TYPE soa_drv_Interval_table is TABLE of soa_interval_record;

PROCEDURE Verify_1
(soa_drv_list in soa_drv_table);
PROCEDURE Verify_2
(soa_drv_list in soa_drv_table);
PROCEDURE Verify_Interval_1
(soa_drv_list in soa_drv_interval_table);
PROCEDURE Verify_Interval_2
(soa_drv_list in soa_drv_interval_table);
PROCEDURE exec_row_movement_1( partition_name in varchar2,new_partition_date in timestamp );
PROCEDURE exec_row_movement_interval_1( partition_name in varchar2,new_partition_date in timestamp );
PROCEDURE exec_row_movement_2( partition_name in varchar2, new_partition_date in timestamp );
PROCEDURE exec_row_movement_interval_2( partition_name in varchar2, new_partition_date in timestamp );
PROCEDURE trunc_verify1_temp_tables;
PROCEDURE trunc_verify2_temp_tables;
PROCEDURE trunc_verify1_rst_temp_tables;
PROCEDURE exec_row_restore_1;
PROCEDURE Alter_Interval(interval_clause in varchar2);
procedure Alter_FK;
procedure Alter_Movement;

END VERIFY_SOA;
/
--SHOW ERRORS
CREATE OR REPLACE PACKAGE BODY VERIFY_SOA
IS
procedure trunc_verify1_temp_SE_tables is
begin
  execute immediate 'truncate table VERIFY_FABRIC_GROUP1';
  execute immediate 'truncate table VERIFY_CP_GROUP1';
  execute immediate 'truncate table VERIFY_BPEL_GROUP1';
  execute immediate 'truncate table VERIFY_MEDIATOR_GROUP1';
  execute immediate 'truncate table VERIFY_WORKFLOW_GROUP1';
end trunc_verify1_temp_SE_tables;

procedure trunc_verify1_temp_tables is
begin
  execute immediate 'truncate table VERIFY_GROUP1';
  execute immediate 'truncate table VERIFY_ECID_GROUP1';
  execute immediate 'truncate table VERIFY_DL_GROUP1A';
  execute immediate 'truncate table VERIFY_MD_GROUP1';
end trunc_verify1_temp_tables;

procedure trunc_verify2_temp_tables is
begin
  execute immediate 'truncate table VERIFY_MP_GROUP2';
  execute immediate 'truncate table VERIFY_DC_GROUP2';
  execute immediate 'truncate table VERIFY_SN_GROUP2';
end trunc_verify2_temp_tables ;

procedure trunc_verify1_rst_temp_tables is
begin
  execute immediate 'truncate table VERIFY_R_GROUP1';
end trunc_verify1_rst_temp_tables;

procedure Alter_Group_Tables(action in varchar2 default null,
                            interval_clause in varchar2 default null,
                            handle1 in UTL_FILE.file_type default null,
                            handle2 in UTL_FILE.file_type default null) is
begin

  verify_fabric.Alter_Group_Tables(action,interval_clause,handle1,handle2);
  verify_bpel.Alter_Group_Tables(action,interval_clause,handle1,handle2);
  verify_mediator.Alter_Group_Tables(action,interval_clause,handle1,handle2);
  verify_wf.Alter_Group_Tables(action,interval_clause,handle1,handle2);
  verify_b2b.Alter_Group_Tables(action,interval_clause,handle1,handle2);

end Alter_Group_Tables;

procedure exec_row_restore_1 is
begin

  verify_fabric.row_rst_script_1;
  verify_bpel.row_rst_script_1;
  -- Mediator is completed by fabric.
  verify_wf.row_rst_script_1;

end exec_row_restore_1;

procedure exec_row_movement_1( partition_name in varchar2,new_partition_date in timestamp ) is
table_name varchar(200);
id_sql varchar2(2000);
high_val varchar2(1000);
PART_DIR_NAME     varchar2(40) := 'PART_DIR';
PART_FILE_NAME    varchar2(40);
file_handle UTL_FILE.file_type;
partition_name_upper varchar2(100);
begin

  trunc_verify1_temp_SE_tables;
  partition_name_upper := UPPER(partition_name);
  file_handle := null;

  verify_fabric.row_mvt_script_1
   (partition_name_upper,new_partition_date,'R',NULL,file_handle);
  verify_bpel.row_mvt_script_1
   (partition_name_upper, new_partition_date,'R',NULL,file_handle);
  verify_mediator.row_mvt_script_1
   (partition_name_upper,new_partition_date,'R',NULL,file_handle);
  verify_wf.row_mvt_script_1
   (partition_name_upper, new_partition_date,'R',NULL,file_handle);   

end exec_row_movement_1;

procedure exec_row_movement_interval_1( partition_name in varchar2,new_partition_date in timestamp ) is
table_name varchar(200);
id_sql varchar2(2000);
high_val varchar2(1000);
PART_DIR_NAME     varchar2(40) := 'PART_DIR';
PART_FILE_NAME    varchar2(40);
file_handle UTL_FILE.file_type;
partition_name_upper varchar2(100);
soa_part_hv      timestamp;

begin

  trunc_verify1_temp_SE_tables;
  partition_name_upper := UPPER(partition_name);
  file_handle := null;

  if not partition_exists('SCA_FLOW_INSTANCE',partition_name_upper) then
     dbms_output.put_line
      ('FAIL: SCA_FLOW_INSTANCE PARTITION DOES NOT EXIST: '
       || partition_name_upper);
  else
    for v_rec in (select high_value
                from user_tab_partitions
               where table_name = 'SCA_FLOW_INSTANCE'
                 and partition_name = partition_name_upper)
   loop
     if v_rec.high_value != 'MAXVALUE'
      then
       execute immediate 'begin :1 := ' || v_rec.high_value || '; end;'
          using out soa_part_hv;
       dbms_output.put_line
        ('ROW MVMT HIGH VALUE: ' || soa_part_hv );
       verify_fabric.row_mvt_script_1
       (partition_name_upper,new_partition_date,'I',soa_part_hv,file_handle);
       verify_bpel.row_mvt_script_1
       (partition_name_upper,new_partition_date,'I',soa_part_hv,file_handle);
       verify_mediator.row_mvt_script_1
       (partition_name_upper,new_partition_date,'I',soa_part_hv,file_handle);
       verify_wf.row_mvt_script_1
       (partition_name_upper,new_partition_date,'I',soa_part_hv,file_handle);
     end if;
   end loop;
  end if;

end exec_row_movement_interval_1;


procedure exec_row_movement_2( partition_name in varchar2,new_partition_date in timestamp  ) is
PART_DIR_NAME     varchar2(40) := 'PART_DIR';
PART_FILE_NAME    varchar2(40);
file_handle UTL_FILE.file_type;
partition_name_upper varchar2(100);
begin

  partition_name_upper := UPPER( partition_name);
  PART_FILE_NAME:=UPPER('SOA_'||partition_name||'_ROW_MVMT_2')||'.sql';
  file_handle := null; 
  verify_bpel.row_mvt_script_2
   (partition_name_upper, new_partition_date,'R',NULL,file_handle);
  verify_mediator.row_mvt_script_2
   (partition_name_upper, new_partition_date,'R',NULL,file_handle);

end exec_row_movement_2;


procedure exec_row_movement_interval_2( partition_name in varchar2,new_partition_date in timestamp  ) is
PART_DIR_NAME     varchar2(40) := 'PART_DIR';
PART_FILE_NAME    varchar2(40);
file_handle UTL_FILE.file_type;
partition_name_upper varchar2(100);
soa_part_hv      timestamp;

begin

  partition_name_upper := UPPER( partition_name);
  PART_FILE_NAME:=UPPER('SOA_'||partition_name||'_ROW_MVMT_2')||'.sql';
  file_handle := null;

  for v_rec in (select high_value
                from user_tab_partitions
               where partition_name = partition_name_upper
                 and table_name in ('XML_DOCUMENT','MEDIATOR_PAYLOAD',
   'ACTIVITY_SENSOR_VALUES','FAULT_SENSOR_VALUES','VARIABLE_SENSOR_VALUES'))
  loop
     if v_rec.high_value != 'MAXVALUE'
      then
       execute immediate 'begin :1 := ' || v_rec.high_value || '; end;'
          using out soa_part_hv;
       dbms_output.put_line
        ('ROW MVMT HIGH VALUE: ' || soa_part_hv );
       verify_bpel.row_mvt_script_2
        (partition_name_upper, new_partition_date,'I',soa_part_hv,file_handle);
       verify_mediator.row_mvt_script_2
       (partition_name_upper, new_partition_date,'I',soa_part_hv,file_handle);
     end if;
  end loop;

end exec_row_movement_interval_2;
  
procedure write_sql_file_header(result_handle in UTL_FILE.file_type) is
begin
  write_line('REM Auto generated by the SOA verify script ', result_handle);
  write_line('REM Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.', result_handle);
  write_line('REM DESCRIPTION ', result_handle);
  write_line('REM This script is  generated by the SOA verify sctipts. It is used to drop partitions from the SOA Table.',result_handle);
  write_line('REM This script should only be run by DBA who is familiar with the SOA Schema.', result_handle);
  write_line('REM ',result_handle);
end write_sql_file_header;

FUNCTION Chk_Equi_Part_Ok_1
(part_name in varchar2,
bpel_part_name in varchar2,
med_part_name in varchar2,
wf_part_name in varchar2,
soa_range_interval in varchar2,
soa_part_hv in timestamp,
log_handle in UTL_FILE.file_type)
return BOOLEAN
IS
BEGIN

   if (soa_fabric.getComponentPartitionInfo = 'Y' OR soa_fabric.getComponentPartitionInfo='P') and not verify_fabric.Chk_Equi_Part_Ok_1(part_name, soa_range_interval, soa_part_hv, log_handle) then
     return false;
   end if;

   if (soa_orabpel.getComponentPartitionInfo = 'Y' OR soa_orabpel.getComponentPartitionInfo='P')  and not verify_bpel.Chk_Equi_Part_Ok_1(bpel_part_name, soa_range_interval, soa_part_hv, log_handle) then
     return false;
   end if;

   if (soa_mediator.getComponentPartitionInfo = 'Y' OR soa_mediator.getComponentPartitionInfo='P') and not verify_mediator.Chk_Equi_Part_Ok_1(med_part_name, soa_range_interval, soa_part_hv, log_handle) then
     return false;
   end if;

   if soa_workflow.isComponentPartitioned and not verify_wf.Chk_Equi_Part_Ok_1(wf_part_name, soa_range_interval, soa_part_hv, log_handle) then
     return false;
   end if;

 return true;  

end Chk_Equi_Part_Ok_1;

function chk_Part_Ok_2(part_name in varchar2,soa_range_interval in varchar2,soa_part_hv in timestamp,log_handle in UTL_FILE.file_type,result_handle in UTL_FILE.file_type ) return BOOLEAN
is
bool boolean;
begin
   write_sql_file_header(result_handle);

   write_query_comments('COMPONENT:  BPEL ',result_handle);
   if (soa_orabpel.getComponentPartitionInfo = 'Y' OR soa_orabpel.getComponentPartitionInfo='P')  and not verify_bpel.chk_Part_Ok_2(part_name,soa_range_interval,soa_part_hv,log_handle,result_handle) then
      bool := false;
   end if;

   write_query_comments('COMPONENT:  MEDIATOR ',result_handle);
   if (soa_mediator.getComponentPartitionInfo = 'Y' OR soa_mediator.getComponentPartitionInfo='P') and not verify_mediator.chk_Part_Ok_2(part_name,soa_range_interval,soa_part_hv,log_handle,result_handle) then
      bool := false;
   end if ;

  return bool;

end chk_Part_Ok_2;

function chk_Part_Ok_1(part_name in varchar2,soa_range_interval in varchar2,soa_part_hv in timestamp,log_handle in UTL_FILE.file_type,result_handle in UTL_FILE.file_type ) return BOOLEAN
is
bool_group1 boolean := true;
bool boolean;
transition boolean := false;
fabric_result boolean := false;
isEquiPart_1 boolean;
bpel_part_name varchar2(40);
med_part_name  varchar2(40);
med1A_part_name  varchar2(40);
b2b_part_name  varchar2(40);
wf_part_name  varchar2(40);
cp_part_name   varchar2(40);
mi_part_name   varchar2(40);
dlv_part_name   varchar2(40);
aud_part_name   varchar2(40);

begin

   if soa_range_interval = 'I'
    then
      -- part_name is NOTFOUND if no partitions or high_value not matched.
      bpel_part_name := get_partition_name
                         ('CUBE_INSTANCE',soa_part_hv);
      med_part_name  := get_partition_name
                         ('MEDIATOR_DEFERRED_MESSAGE',soa_part_hv);
      med1A_part_name  := get_partition_name
                         ('MEDIATOR_RESEQUENCER_MESSAGE',soa_part_hv);
      wf_part_name   := get_partition_name
                         ('WFTASK',soa_part_hv);
      b2b_part_name  := get_partition_name
                         ('B2B_BUSINESS_MESSAGE',soa_part_hv);
      mi_part_name   := get_partition_name
                         ('MEDIATOR_INSTANCE',soa_part_hv);
      cp_part_name   := get_partition_name
                         ('COMPOSITE_INSTANCE',soa_part_hv);
      aud_part_name  := get_partition_name
                         ('AUDIT_DETAILS',soa_part_hv);
      dlv_part_name   := get_partition_name
                         ('DLV_MESSAGE',soa_part_hv);
   else
      transition := FALSE;
      for v_rec in (select PARTITION_NAME
             from user_tab_partitions t, user_part_tables p
            where t.table_name = 'SCA_FLOW_INSTANCE'
              and t.table_name = p.table_name
              and p.interval is not null
              and  t.PARTITION_POSITION =
              (select max(PARTITION_POSITION) from user_tab_partitions
                where TABLE_NAME = 'SCA_FLOW_INSTANCE'
                  and INTERVAL = 'NO'))
      loop
        if v_rec.PARTITION_NAME = part_name
         then
            transition := TRUE;
        end if;
      end loop;
      bpel_part_name := 'NOTFOUND';
      med_part_name  := 'NOTFOUND';
      med1A_part_name  := 'NOTFOUND';
      b2b_part_name  := 'NOTFOUND';
      wf_part_name   := 'NOTFOUND';
      mi_part_name   := 'NOTFOUND';
      cp_part_name   := 'NOTFOUND';
      aud_part_name  := 'NOTFOUND';
      dlv_part_name  := 'NOTFOUND';
      IF partition_exists('CUBE_INSTANCE',part_name) THEN
         bpel_part_name := part_name;
      END IF;
      IF partition_exists('MEDIATOR_DEFERRED_MESSAGE',part_name) THEN
         med_part_name  := part_name;
      END IF;
      IF partition_exists('MEDIATOR_RESEQUENCER_MESSAGE',part_name) THEN
         med1A_part_name  := part_name;
      END IF;      
      IF partition_exists('B2B_BUSINESS_MESSAGE',part_name) THEN
         b2b_part_name  := part_name;
      END IF;
      IF partition_exists('WFTASK',part_name) THEN
         wf_part_name   := part_name;
      END IF;
      IF partition_exists('MEDIATOR_INSTANCE',part_name) THEN
         mi_part_name   := part_name;
      END IF;
      IF partition_exists('COMPOSITE_INSTANCE',part_name) THEN
         cp_part_name   := part_name;
      END IF;
      IF partition_exists('AUDIT_DETAILS',part_name) THEN
         aud_part_name  := part_name;
      END IF;
      IF partition_exists('DLV_MESSAGE',part_name) THEN
         dlv_part_name   := part_name;
      END IF;
   END IF;

   write_sql_file_header(result_handle);
   isEquiPart_1  := Chk_Equi_Part_Ok_1
      (part_name,bpel_part_name,med_part_name,wf_part_name,
       soa_range_interval,soa_part_hv,log_handle);

   write_query_comments('COMPONENT:  FABRIC ',result_handle);
   if soa_fabric.getComponentPartitionInfo='Y' 
   OR soa_fabric.getComponentPartitionInfo='P' then 
      if isEquiPart_1 then
         bool_group1 := false;
         bool_group1 :=verify_fabric.chk_Part_Ok_1
            (part_name,bpel_part_name,med_part_name,wf_part_name,cp_part_name,
             mi_part_name,b2b_part_name,aud_part_name,dlv_part_name,
             soa_range_interval,soa_part_hv,transition,
             log_handle,result_handle);
         fabric_result := bool_group1;
       end if;  
   end if ;

   write_query_comments('COMPONENT:  BPEL ',result_handle);
   if soa_orabpel.getComponentPartitionInfo='Y' 
   OR soa_orabpel.getComponentPartitionInfo='P' then 
      if isEquiPart_1 then
         if bpel_part_name != 'NOTFOUND' then
            if fabric_result then
               bool := verify_bpel.chk_Part_Ok_1
                  (bpel_part_name,soa_range_interval,soa_part_hv,
                   fabric_result,transition,log_handle,result_handle);
            end if;
            --  TODO think bool_group1 is redundant.
            if bool = false then bool_group1 := bool; end if;
         else
             UTL_FILE.Put_Line(log_handle,
              '** WARNING - CUBE_INSTANCE PARTITION NOFOUND');
         end if;
      end if;
      if dlv_part_name != 'NOTFOUND' then
         if fabric_result then
            bool := verify_bpel.chk_Part_Ok_1A
                 (dlv_part_name,soa_range_interval,soa_part_hv,
                 transition,log_handle,result_handle);
         end if;
         if bool = false then bool_group1 := bool; end if;
      else
         UTL_FILE.Put_Line(log_handle, 
           '** WARNING - DLV_MESSAGE PARTITION NOFOUND');
      end if;
   end if; 

   write_query_comments('COMPONENT:  MEDIATOR ',result_handle);
   if soa_mediator.getComponentPartitionInfo = 'Y' 
   OR soa_mediator.getComponentPartitionInfo='P' then
      if isEquiPart_1 then
         if med_part_name != 'NOTFOUND' then
            if fabric_result then
               bool := verify_mediator.chk_Part_Ok_1
                  (med_part_name,soa_range_interval,soa_part_hv,
                   fabric_result,transition,log_handle,result_handle);
            end if;
          else
             UTL_FILE.Put_Line(log_handle,
              '** WARNING - MEDIATOR_DEFERRED_MESSAGE PARTITION NOFOUND');
          end if;
      end if;
      --  TODO think bool_group1 is redundant
      if bool = false then 
  	   bool_group1 := bool;
      else
  	   --  MEDIATOR_RESEQUENCER_MESSAGE uses separate partition from MEDIATOR_DEFERRED_MESSAGE
  	   if med1A_part_name != 'NOTFOUND' then
               bool := verify_mediator.chk_Part_Ok_1A(med1A_part_name,soa_range_interval,soa_part_hv,fabric_result,log_handle,result_handle);
               if bool = false then bool_group1 := bool; end if;
  	   else
               UTL_FILE.Put_Line(log_handle,
               '** WARNING - MEDIATOR_RESEQUENCER_MESSAGE PARTITION NOFOUND');
  	   end if;
      end if;	

   end if;

  write_query_comments('COMPONENT:  B2B ',result_handle);
  if soa_b2b.isComponentPartitioned then
     if isEquiPart_1 then
        if b2b_part_name != 'NOTFOUND' then
           if fabric_result then
              bool := verify_b2b.chk_Part_Ok_1
                 (b2b_part_name,soa_range_interval,soa_part_hv,
                  fabric_result,transition,log_handle,result_handle);
            end if;
          else
             UTL_FILE.Put_Line(log_handle,
              '** WARNING - B2B_BUSINESS_MESSAGE PARTITION NOFOUND');
          end if;
     end if;
     --  TODO think bool_group1 is redundant
     if bool = false then bool_group1 := bool; end if;	
  end if;

  write_query_comments('COMPONENT:  workflow ',result_handle);
  if soa_workflow.isComponentPartitioned then
     if isEquiPart_1 then
        if wf_part_name != 'NOTFOUND' then
           if fabric_result then
              bool := verify_wf.chk_Part_Ok_1
                  (wf_part_name,soa_range_interval,soa_part_hv,
                  fabric_result,transition,log_handle,result_handle);
           end if;
          else
             UTL_FILE.Put_Line(log_handle,
              '** WARNING - WFTASK PARTITION NOFOUND');
          end if;
     end if;
     --  TODO think bool_group1 is redundant
     if bool = false then bool_group1 := bool; end if;	
  end if;

  return bool_group1;

end chk_Part_Ok_1;

function verify_1_tmp_table_chk return boolean
IS
id_sql varchar2(1000);
id_sql1 varchar2(1000);
row_count number;
table_name varchar2(100);
BEGIN

   id_sql := 'select count(1) from TABLENAME';
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_GROUP1');
   execute immediate id_sql1 into row_count;
   if row_count > 0 then
     return false;
   end if;

   row_count := 0;
   id_sql := 'select count(1) from TABLENAME';
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_ECID_GROUP1');
   execute immediate id_sql1 into row_count;
   if row_count > 0 then
     return false;
   end if;

   row_count := 0;
   id_sql := 'select count(1) from TABLENAME';
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_MD_GROUP1');
   execute immediate id_sql1 into row_count;
   if row_count > 0 then
     return false;
   end if;

   row_count := 0;
   id_sql := 'select count(1) from TABLENAME';
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_DL_GROUP1A');
   execute immediate id_sql1 into row_count;
   if row_count > 0 then
     return false;
   end if;

   return true;

end verify_1_tmp_table_chk;

function verify_2_tmp_table_chk return boolean
IS
id_sql varchar2 (1000);
id_sql1 varchar2 (1000);
row_count number;
table_name varchar2(100);
BEGIN
   id_sql := 'select count(1) from TABLENAME' ;
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_DC_GROUP2');
   execute immediate  id_sql1 into row_count;   
   if row_count > 0 then
     return false;
   end if;

   row_count := 0;
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_MP_GROUP2');
   table_name := 'VERIFY_MP_GROUP2';
   execute immediate  id_sql1 into row_count;   
   if row_count > 0 then
     return false;
   end if;   

   row_count := 0;
   id_sql1 := REPLACE(id_sql,'TABLENAME', 'VERIFY_SN_GROUP2');
   table_name := 'VERIFY_SN_GROUP2';
   execute immediate  id_sql1 into row_count;
   if row_count > 0 then
     return false;
   end if;

   return true;   
end verify_2_tmp_table_chk;


PROCEDURE Verify_1
(
soa_drv_list in soa_drv_table
)
IS
LOG_HANDLE         UTL_FILE.file_type;
RESULT_HANDLE      UTL_FILE.file_type;
PART_DIR_NAME      varchar2(40) := 'PART_DIR';
PART_FILE_NAME     varchar2(40);
PART_RES_FILE_NAME varchar2(40);
bool boolean;

BEGIN
if not verify_1_tmp_table_chk  then
raise_application_error(-20000, 'ERROR :TEMP TABLES NOT EMPTY. PLEASE TRUNCATE TEMP TABLES AFTER EXECUTING ROW MOVEMENT AND ROW RESTORE PROCEDURES(IF APPLICABLE) ');
ELSE

FOR i in soa_drv_list.FIRST..soa_drv_list.LAST LOOP


PART_FILE_NAME := UPPER('SOA_'||soa_drv_list(i)||'_LOG_1');
PART_RES_FILE_NAME:=UPPER('SOA_'||soa_drv_list(i)||'_RESULT_1')||'.sql';
LOG_HANDLE := UTL_FILE.fopen(PART_DIR_NAME, PART_FILE_NAME, 'W');
RESULT_HANDLE:= UTL_FILE.fopen(PART_DIR_NAME, PART_RES_FILE_NAME, 'W');
bool := chk_Part_Ok_1(UPPER(soa_drv_list(i)),'R',NULL,LOG_HANDLE, RESULT_HANDLE);
UTL_FILE.Put_Line (LOG_HANDLE,'------------END OF REPORT---------------------------');
UTL_FILE.fclose(LOG_HANDLE);
UTL_FILE.fclose(RESULT_HANDLE);
END LOOP;
END IF;
END Verify_1;

PROCEDURE Verify_2
(soa_drv_list in soa_drv_table)
IS
LOG_HANDLE         UTL_FILE.file_type;
RESULT_HANDLE      UTL_FILE.file_type;
PART_DIR_NAME      varchar2(40) := 'PART_DIR';
PART_FILE_NAME     varchar2(40);
PART_RES_FILE_NAME varchar2(40);
bool boolean;
BEGIN
if not verify_2_tmp_table_chk  then
  raise_application_error(-20000, 'ERROR :TEMP TABLES NOT EMPTY. PLEASE TRUNCATE TEMP TABLES AFTER EXECUTING ROW MOVEMENT PROCEDURES(IF APPLICABLE) ');
ELSE
FOR i in soa_drv_list.FIRST..soa_drv_list.LAST LOOP
  PART_FILE_NAME := UPPER('SOA_'||soa_drv_list(i)||'_LOG_2');
  PART_RES_FILE_NAME:=UPPER('SOA_'||soa_drv_list(i)||'_RESULT_2')||'.sql';
  LOG_HANDLE := UTL_FILE.fopen(PART_DIR_NAME, PART_FILE_NAME, 'W');
  RESULT_HANDLE:= UTL_FILE.fopen(PART_DIR_NAME, PART_RES_FILE_NAME, 'W');
  bool := chk_Part_Ok_2(UPPER(soa_drv_list(i)),'R',NULL,LOG_HANDLE, RESULT_HANDLE);
  UTL_FILE.Put_Line (LOG_HANDLE,'------------END OF REPORT---------------------------');
  UTL_FILE.fclose(LOG_HANDLE);
  UTL_FILE.fclose(RESULT_HANDLE);
END LOOP;
END IF;
END Verify_2;

PROCEDURE Verify_Interval_1
( soa_drv_list in soa_drv_Interval_table)
IS
LOG_HANDLE         UTL_FILE.file_type;
RESULT_HANDLE      UTL_FILE.file_type;
PART_DIR_NAME      varchar2(40) := 'PART_DIR';
PART_FILE_NAME     varchar2(40);
PART_RES_FILE_NAME varchar2(40);
bool boolean;

BEGIN
if not verify_1_tmp_table_chk  then
raise_application_error(-20000, 'ERROR :TEMP TABLES NOT EMPTY. PLEASE TRUNCATE TEMP TABLES AFTER EXECUTING ROW MOVEMENT AND ROW RESTORE PROCEDURES(IF APPLICABLE) ');
ELSE

FOR i in soa_drv_list.FIRST..soa_drv_list.LAST LOOP

PART_FILE_NAME := UPPER('SOA_'||soa_drv_list(i).part_name||'_LOG_1');
PART_RES_FILE_NAME:=UPPER('SOA_'||soa_drv_list(i).part_name||'_RESULT_1')||'.sql';
LOG_HANDLE := UTL_FILE.fopen(PART_DIR_NAME, PART_FILE_NAME, 'W');
RESULT_HANDLE:= UTL_FILE.fopen(PART_DIR_NAME, PART_RES_FILE_NAME, 'W');
dbms_output.put_line('verify_interval_1 timestamp :' || soa_drv_list(i).part_hv_timestamp);
bool := chk_Part_Ok_1(UPPER(soa_drv_list(i).part_name),'I',soa_drv_list(i).part_hv_timestamp,LOG_HANDLE, RESULT_HANDLE);
UTL_FILE.Put_Line (LOG_HANDLE,'------------END OF REPORT---------------------------');
UTL_FILE.fclose(LOG_HANDLE);
UTL_FILE.fclose(RESULT_HANDLE);
END LOOP;
END IF;
END Verify_Interval_1;

PROCEDURE Verify_Interval_2
(soa_drv_list in soa_drv_Interval_table)
IS
LOG_HANDLE          UTL_FILE.file_type;
RESULT_HANDLE       UTL_FILE.file_type;
PART_DIR_NAME       varchar2(40) := 'PART_DIR';
PART_FILE_NAME      varchar2(40);
PART_RES_FILE_NAME  varchar2(40);
bool boolean;
BEGIN
if not verify_2_tmp_table_chk  then
  raise_application_error(-20000, 'ERROR :TEMP TABLES NOT EMPTY. PLEASE TRUNCATE TEMP TABLES AFTER EXECUTING ROW MOVEMENT PROCEDURES(IF APPLICABLE) ');
ELSE
FOR i in soa_drv_list.FIRST..soa_drv_list.LAST LOOP
  PART_FILE_NAME := UPPER('SOA_'||soa_drv_list(i).part_name||'_LOG_2');
  PART_RES_FILE_NAME:=UPPER('SOA_'||soa_drv_list(i).part_name||'_RESULT_2')||'.sql';
  LOG_HANDLE := UTL_FILE.fopen(PART_DIR_NAME, PART_FILE_NAME, 'W');
  RESULT_HANDLE:= UTL_FILE.fopen(PART_DIR_NAME, PART_RES_FILE_NAME, 'W');
  bool := chk_Part_Ok_2(UPPER(soa_drv_list(i).part_name),'I',soa_drv_list(i).part_hv_timestamp,LOG_HANDLE, RESULT_HANDLE);
  UTL_FILE.Put_Line (LOG_HANDLE,'------------END OF REPORT---------------------------');
  UTL_FILE.fclose(LOG_HANDLE);
  UTL_FILE.fclose(RESULT_HANDLE);
END LOOP;
END IF;
END Verify_Interval_2;

PROCEDURE Alter_Interval
(interval_clause in varchar2)
IS
HANDLE1             UTL_FILE.file_type;
HANDLE2             UTL_FILE.file_type;
PART_DIR_NAME       varchar2(40) := 'PART_DIR';
PART_RES_FILE_NAME  varchar2(40);
bool boolean;
BEGIN

  PART_RES_FILE_NAME:=UPPER('SOA_ALTER_INTERVAL_GROUP.SQL');
  HANDLE1:= UTL_FILE.fopen(PART_DIR_NAME, PART_RES_FILE_NAME, 'W');
  Alter_Group_Tables('I',interval_clause,HANDLE1,HANDLE2);
  UTL_FILE.fclose(HANDLE1);

END Alter_Interval;

PROCEDURE Alter_FK
IS
HANDLE1                 UTL_FILE.file_type;
HANDLE2                 UTL_FILE.file_type;
PART_DIR_NAME           varchar2(40) := 'PART_DIR';
ENABLE_FILE_NAME        varchar2(40);
DISABLE_FILE_NAME       varchar2(40);
bool boolean;
BEGIN

  DISABLE_FILE_NAME:=UPPER('SOA_DISABLE_FK.SQL');
  ENABLE_FILE_NAME:=UPPER('SOA_ENABLE_FK.SQL');
  HANDLE1:= UTL_FILE.fopen(PART_DIR_NAME, DISABLE_FILE_NAME, 'W');
  HANDLE2:= UTL_FILE.fopen(PART_DIR_NAME, ENABLE_FILE_NAME, 'W');
  Alter_Group_Tables('F',NULL,HANDLE1,HANDLE2);
  UTL_FILE.fclose(HANDLE1);
  UTL_FILE.fclose(HANDLE2);

END Alter_FK;

PROCEDURE Alter_Movement
IS
HANDLE1                 UTL_FILE.file_type;
HANDLE2                 UTL_FILE.file_type;
PART_DIR_NAME           varchar2(40) := 'PART_DIR';
ENABLE_FILE_NAME        varchar2(40);
DISABLE_FILE_NAME       varchar2(40);
bool boolean;
BEGIN

  DISABLE_FILE_NAME:=UPPER('SOA_DISABLE_MVT.SQL');
  ENABLE_FILE_NAME:=UPPER('SOA_ENABLE_MVT.SQL');
  HANDLE1:= UTL_FILE.fopen(PART_DIR_NAME, DISABLE_FILE_NAME, 'W');
  HANDLE2:= UTL_FILE.fopen(PART_DIR_NAME, ENABLE_FILE_NAME, 'W');
  Alter_Group_Tables('M',NULL,HANDLE1,HANDLE2);
  UTL_FILE.fclose(HANDLE1);
  UTL_FILE.fclose(HANDLE2);

END Alter_Movement;

END VERIFY_SOA;
/
--SHOW ERRORS;


