Rem
Rem $Header: pcbpel/admin/sqlutils/soa_purge/oracle/common/purge_common_oracle.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/11/19 00:42:45 shabdull Exp $
Rem
Rem purge_common_oracle.sql
Rem
Rem Copyright (c) 2009, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_common_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   11/16/20 - Backport apfwkr_blr_backport_30701409_12.2.1.4.0
Rem                           from main
Rem       apfwkr   08/14/20 - Backport linlxu_bug-30701409_12212-main from main
Rem       ssudarsa 04/13/10 - Created
Rem


create or replace procedure write_line(line in varchar2, write_file in  utl_file.file_type default null) is
begin

 if utl_file.is_open(write_file)=false  then
      dbms_output.put_line(line);
  else
     utl_file.put_line (write_file,line); 
  end if; 
end write_line;
/
--show errors;

CREATE OR REPLACE PROCEDURE debug_purge (table_name IN VARCHAR2, str IN VARCHAR2 default null,write_file in utl_file.file_type default null) AS
BEGIN
$IF $$debug_on $THEN
      if str is NULL then
	         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || ' purged is : ' || SQL%ROWCOUNT,write_file);
     ELSE
	         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || str || SQL%ROWCOUNT,write_file);
     END IF;
$ELSE
    null;
$END

END debug_purge;
/
--show errors;
create or replace procedure log_info(message in varchar2, write_file utl_file.file_type default null) is

begin
  $IF $$debug_on $THEN
	   write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') ||' : '||message,write_file);
  $ELSE
     null;
  $END   
end log_info;	
/
--show errors;
create or replace procedure log_error(message in varchar2,write_file utl_file.file_type default null) is
begin
            write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') ||'
: '||message ||'. Error Code = '||SQLCODE||', Error Message = '||SQLERRM,write_file);
end log_error;
/
--show errors;
CREATE OR REPLACE PROCEDURE debug_purge2 (table_name IN VARCHAR2, SQL_ROWCOUNT IN integer default null, str IN VARCHAR2 default null, write_file in utl_file.file_type default null) AS
  MAX_LENGTH_PURGE_LOG integer := 2000;  -- max length of the PURGE_LOG column of the SOA_PURGE_LOG table
  v_stmt  VARCHAR2(2100);
  v_SQL_ROWCOUNT integer := SQL_ROWCOUNT; 
BEGIN
IF v_SQL_ROWCOUNT is NULL then
     v_SQL_ROWCOUNT  := SQL%ROWCOUNT; 
END IF;

$IF $$debug_on $THEN
      if str is NULL then
	         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || ' purged is : ' || v_SQL_ROWCOUNT,write_file);
     ELSE
	         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || str || v_SQL_ROWCOUNT,write_file);
     END IF;

$ELSE
    null;
$END

IF str is NULL then
     v_stmt := 'INSERT INTO SOA_PURGE_LOG VALUES (sysdate, ''' || get_Valid_PURGE_LOG('Number of rows in table ' || table_name || ' ' || ' purged is : ' || v_SQL_ROWCOUNT) || ''')';
ELSE
     v_stmt := 'INSERT INTO SOA_PURGE_LOG VALUES (sysdate, ''' || get_Valid_PURGE_LOG('Number of rows in table ' || table_name || ' ' || str || v_SQL_ROWCOUNT) || ''')';
END IF;
EXECUTE IMMEDIATE v_stmt;


EXCEPTION
  when others then
    log_error(v_stmt);
END debug_purge2;
/
--show errors;
CREATE OR REPLACE PROCEDURE debug_purge (table_name IN VARCHAR2, str IN VARCHAR2 default null,write_file in utl_file.file_type default null) AS
BEGIN
    debug_purge2(table_name, null, str, write_file);
END debug_purge;
/
CREATE OR REPLACE PROCEDURE dangling_delete_proc(p_sql IN VARCHAR2, p_transaction_size NUMBER default 0, v_stoptime in date, write_file in utl_file.file_type default null) AS 
       v_stmt  VARCHAR2(2000);
       v_stmt2  VARCHAR2(10) := ' AND ';
       has_more_rows BOOLEAN := TRUE;
BEGIN
       v_stmt := p_sql;
       IF (p_transaction_size > 0) THEN
          IF (INSTR( UPPER(p_sql), 'WHERE' ) = 0) THEN
              v_stmt2 := ' WHERE ';
          END IF;
          v_stmt := v_stmt || v_stmt2 || 'rownum <= ROWSIZE';
          v_stmt := REPLACE(v_stmt, 'ROWSIZE', p_transaction_size);
       END IF;
       WHILE (sysdate < v_stoptime and has_more_rows )
       LOOP
          EXECUTE IMMEDIATE  v_stmt;
          IF SQL%NOTFOUND THEN
              has_more_rows := FALSE;
          END IF;
          dbms_output.put_line('[' || v_stmt || '], deleted = ' || SQL%ROWCOUNT);
          log_info('[' || v_stmt || '], deleted = ' || SQL%ROWCOUNT, write_file);
          commit;
       END LOOP;
   EXCEPTION
            when others then
            log_error('ERROR(dangling_delete_proc ' || SQLCODE);

END dangling_delete_proc;
/
--show errors;

create or replace function batch_delete_func(p_sql IN VARCHAR2, p_transaction_size integer default 100000, p_stop_time INTEGER default -1, write_file in utl_file.file_type default null) return integer AS 
       v_stoptime DATE := sysdate + NVL(p_stop_time,24*60)/(24*60);
       v_stmt  VARCHAR2(2000);
       v_stmt2  VARCHAR2(10) := ' AND ';
       has_more_rows BOOLEAN := TRUE;
       v_totalcount integer := 0;
BEGIN
       v_stmt := p_sql;
       IF (p_transaction_size > 0) THEN
          IF (INSTR( UPPER(p_sql), 'WHERE' ) = 0) THEN
              v_stmt2 := ' WHERE ';
          END IF;
          v_stmt := v_stmt || v_stmt2 || 'rownum <= ROWSIZE';
          v_stmt := REPLACE(v_stmt, 'ROWSIZE', p_transaction_size);
       END IF;

       WHILE (has_more_rows )
       LOOP
          EXECUTE IMMEDIATE  v_stmt;
          IF SQL%NOTFOUND THEN
              has_more_rows := FALSE;
          END IF;
          v_totalcount := v_totalcount + SQL%ROWCOUNT;
          
          dbms_output.put_line('[' || v_stmt || '], rowcount = ' || SQL%ROWCOUNT);
          log_info('[' || v_stmt || '], rowcount = ' || SQL%ROWCOUNT, write_file);
          commit;

          IF p_stop_time > 0 AND sysdate > v_stoptime THEN
              has_more_rows := FALSE;
          END IF;
          
       END LOOP;
       
       return v_totalcount;
       
   EXCEPTION
            when others then
            log_error('ERROR(batch_delete_func ' || SQLCODE);
       return -1;

END batch_delete_func;
/
--show errors;

create or replace function is_table_partitioned(table_name in varchar2, 
                                                partition_column_name in varchar2) return boolean is
   
                                  
   row_found integer := 0;       
begin       
   select count(1) into row_found from user_part_key_columns where object_type ='TABLE' and name = table_name and column_name = partition_column_name;
       
   if row_found = 1 then
       return true;
   else
       return false;
   end if;
           
end is_table_partitioned;
/
--show errors;
create or replace function partition_exists(table_name in varchar2,
                                                partition_name in varchar2) return boolean is


   row_found integer := 0;
   tablename varchar2(100) := upper(table_name);
   partitionname varchar2(100) := upper(partition_name);
begin
   select count(1) into row_found from user_tab_partitions where table_name =tablename and partition_name = partitionname;

   if row_found = 1 then
       return true;
   else
       return false;
   end if;

end partition_exists;
/

--show errors;
CREATE OR REPLACE FUNCTION table_exist( tablename IN VARCHAR2)
   RETURN BOOLEAN
 IS
   val   VARCHAR2(2) :='F';
   val_T VARCHAR2(2) :='T';
 BEGIN
   SELECT DECODE(COUNT(*),0,'F','T')
   INTO val
   from USER_TABLES
   WHERE table_name = tablename;
   IF val = val_T THEN
     RETURN true;
   ELSE
     RETURN false;
   END IF;
 END table_exist;
/
--show errors;
  create or replace function  get_file(thread_num in integer) return utl_file.file_type is
   write_file  utl_file.file_type;
   SOA_PURGE_DIR_NAME     varchar2(40) := 'SOA_PURGE_DIR';
   filename  varchar2(40) := 'SOA_PURGE_LOG_THREAD' || thread_num;

    begin
        write_file := utl_file.fopen (SOA_PURGE_DIR_NAME,filename, 'W');
        return write_file;
   EXCEPTION
      when others then 
        return null;
   end get_file;
/
  --show errors;

   create or replace procedure close_file(write_file in out utl_file.file_type) is
   begin
        utl_file.fclose(write_file);
   end close_file;
/
--show errors;

create or replace function column_exists( p_table_name varchar2, p_column_name varchar2)
  RETURN BOOLEAN
 IS
   val   VARCHAR2(2) :='F';
   val_T VARCHAR2(2) :='T';
 BEGIN
   SELECT DECODE(COUNT(*),0,'F','T') INTO val
    FROM USER_TAB_COLUMNS WHERE table_name = p_table_name and column_name = p_column_name ;

   IF val = val_T THEN
     RETURN true;
   ELSE
     RETURN false;
   END IF;
END column_exists;
/
--show errors;
create or replace procedure write_drop_partition_query(p_table_name varchar2,p_partition_name varchar2,write_file  utl_file.file_type)
is
v_query varchar2(4000);
begin
   if partition_exists(p_table_name, p_partition_name)  = true then
      v_query := 'ALTER TABLE ' || p_table_name || ' drop partition ' || p_partition_name ||' UPDATE GLOBAL INDEXES;';
      write_line(v_query,write_file);
   end if;
end write_drop_partition_query;
/
--show errors
create or replace procedure write_query_comments(comments varchar2, write_file utl_file.file_type)
is
begin
     write_line('-- ' || comments,write_file ); 
end write_query_comments;
/
--show errors
 
create or replace type component_partition_info as object
(
  fabricPartitioned char,
  bpelPartitioned char,
  mediatorPartitioned char,
  b2bPartitioned char,
  workflowPartitioned char,
  decisionPartitioned char,
constructor function component_partition_info return self as result
);
/
--show errors;
create or replace type body component_partition_info as 
 
  constructor function component_partition_info return self as result is
  begin
    return;
  end component_partition_info;
end;
/
--show errors;                                             
