/*
Rem
Rem $Header: pcbpel/admin/sqlutils/soa_purge/oracle/mediator/mediator_deleteComponentInstances.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/11/19 00:42:45 shabdull Exp $
Rem
Rem mediator_deleteComponentInstances.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      mediator_deleteComponentInstances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Mediator purge
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      11/16/20 - Backport apfwkr_blr_backport_30701409_12.2.1.4.0
Rem                           from main
Rem    apfwkr      08/14/20 - Backport linlxu_bug-30701409_12212-main from main
Rem    apjain      07/13/11 - XbranchMerge apjain_bug-12749521_main from main
Rem    sanjain     04/27/10 - Created
Rem
*/

PROCEDURE truncate_temp_tables
AS
BEGIN
  --before starting clean up temp tables
  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_mediator_instance';
END truncate_temp_tables;

-- Function to distinguish between 11gR1PS1 and 11gR1PS2 schema
function is_ps1_schema return boolean is

col_found integer := 0;       
begin       
   select count(1) into col_found from user_tab_columns where table_name='MEDIATOR_AUDIT_DOCUMENT' and column_name='INSTANCE_ID';
       
   if col_found = 1 then
       return true;
   else
       return false;
   end if;
       
end is_ps1_schema;   

PROCEDURE delete_mediator_instances(purge_partitioned_component in boolean default false)
AS
  batch_total_count integer := 0;
BEGIN

  -- purge mediator_payload
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_PAYLOAD','CREATION_TIME') = FALSE then
    batch_total_count := batch_delete_func('DELETE from mediator_payload where owner_id in(
    select dummy1 from mediator_deferred_message a where exists(select id from temp_mediator_instance b
    where b.id=a.msg_id)
    union select id from mediator_case_instance c where exists(select id from temp_mediator_instance d
    where d.id=c.instance_id))');
  COMMIT;
  debug_purge2('mediator_payload',batch_total_count);
 end if;


batch_total_count := batch_delete_func('DELETE from mediator_payload
WHERE owner_id IN
  (SELECT a.id
  FROM temp_mediator_instance b,
    mediator_resequencer_message a
  WHERE b.id     =a.id 
  )') ;

COMMIT;

batch_total_count := batch_delete_func('DELETE from mediator_resequencer_message
WHERE id IN
  (SELECT a.id
  FROM temp_mediator_instance b,
    mediator_resequencer_message a
  WHERE b.id     =a.id
  )') ;

COMMIT;

batch_total_count := batch_delete_func('DELETE  from mediator_group_status a where resequencer_type != ''Standard'' and  not exists (select distinct owner_id from mediator_resequencer_message b where a.id=b.owner_id)');

COMMIT;

 -- purge mediator_deferred_message
  batch_total_count := batch_delete_func('DELETE from mediator_deferred_message a where exists(select id from temp_mediator_instance b where b.id=a.msg_id)');
  COMMIT;
  debug_purge2('mediator_deferred_message', batch_total_count);

  -- purge mediator_document
  if is_ps1_schema() = true then
    batch_total_count := batch_delete_func('DELETE from mediator_audit_document a where exists(select id from temp_mediator_instance b where b.id=a.instance_id)');
    COMMIT;
    debug_purge2('mediator_document',batch_total_count);
  end if;
  
  -- purge mediator_case_detail
  batch_total_count := batch_delete_func('DELETE from mediator_case_detail a where exists(select id from temp_mediator_instance b where b.id=a.instance_id)');
  COMMIT;
  debug_purge2('mediator_case_detail',batch_total_count);
  
  -- purge mediator_case_instance
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_CASE_INSTANCE','MI_PARTITION_DATE') = FALSE then
     batch_total_count := batch_delete_func('DELETE from mediator_case_instance a where exists(select id from temp_mediator_instance b where b.id=a.instance_id)');
     COMMIT;
	 debug_purge2('mediator_case_instance',batch_total_count);
  end if;
  
  
  -- purge mediator_instance
  if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_INSTANCE','COMPOSITE_CREATION_DATE') = FALSE then
    batch_total_count := batch_delete_func('DELETE from mediator_instance a where exists(select id from temp_mediator_instance b where b.id=a.id)');
    COMMIT;
    debug_purge2('mediator_instance',batch_total_count);
  end if;
END delete_mediator_instances;

-- To purge mediator instances for the ecids present in p_id_table
PROCEDURE deleteComponentInstances(p_id_table   IN VARCHAR2, purge_partitioned_component in boolean default false)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

  truncate_temp_tables();
  v_stmt := 'INSERT into temp_mediator_instance(id) SELECT id from mediator_instance a
          where exists(select id from ' || p_id_table || ' b where b.ecid=a.ecid)';
  EXECUTE immediate v_stmt;
  debug_purge('temp_mediator_instance', 'Inserted = ');

  delete_mediator_instances(purge_partitioned_component);

EXCEPTION
  when others then
    log_error(v_stmt);
    raise;

END deleteComponentInstances;


