/*
Rem
Rem wf_deleteCompositeInstances.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      wf_deleteCompositeInstances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Workflow purge
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr       11/16/20 - Backport apfwkr_blr_backport_30701409_12.2.1.4.0
Rem                            from main
Rem    apfwkr       08/14/20 - Backport linlxu_bug-30701409_12212-main from
Rem                            main
Rem    vsvetov      08/22/11 - XbranchMerge vsvetov_bug-12835682_ps5 from
Rem                            st_pcbpel_11.1.1.4.0
Rem    vsvetov      11/16/10 - XbranchMerge vsvetov_bug-10282512_ps3 from
Rem                            st_pcbpel_11.1.1.4.0
Rem    wstallar     07/16/10 - Addressing performance concerns
Rem    wstallar     08/03/10 - XbranchMerge wstallar_bug-9937600_ps3 from
Rem                            st_pcbpel_11.1.1.4.0
Rem    vumapath     06/25/10 - Purge task attachments
Rem    hdoddi       07/02/10 - Adding commit statments bug 9846252
Rem    vsvetov      05/04/10 - add support when ecid is null
Rem    vsvetov      04/28/10 - creation
Rem
*/

PROCEDURE truncate_temp_tables
AS
BEGIN
   log_info('workflow.truncate_temp_tables');
  --before starting clean up temp tables
  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_wftask_purge';
END truncate_temp_tables;



PROCEDURE delete_workflow_instances
AS
  v_stmt  VARCHAR2(2000);
  batch_total_count integer := 0;
BEGIN
--  purge of workflow data
--  first, purge each child-table in turn, as there are performance concerns
--  with relying on FK cascade deletes...

    log_info('workflow.delete_workflow_instances begins');

    log_info('Purging WFTask_TL');
    v_stmt := 'Purge WFTask_TL';
    batch_total_count := batch_delete_func('DELETE FROM WFTask_TL WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTask_TL',batch_total_count,v_stmt);
    COMMIT;

    log_info('Purging WFTaskHistory');
    v_stmt := 'Purge WFTaskHistory';
    batch_total_count := batch_delete_func('DELETE FROM WFTaskHistory WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTaskHistory',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFTaskHistory_TL');
    v_stmt := 'Purge WFTaskHistory_TL';
    batch_total_count := batch_delete_func('DELETE FROM WFTaskHistory_TL WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTaskHistory_TL',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFComments');
    v_stmt := 'Purge WFComments';
    batch_total_count := batch_delete_func('DELETE FROM WFComments WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFComments',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFMessageAttribute');
    v_stmt := 'Purge WFMessageAttribute';
    batch_total_count := batch_delete_func('DELETE FROM WFMessageAttribute WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFMessageAttribute',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFAttachment');
    v_stmt := 'Purge WFAttachment';
    batch_total_count := batch_delete_func('DELETE FROM WFAttachment WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFAttachment',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFAssignee');
    v_stmt := 'Purge WFAssignee';
    batch_total_count := batch_delete_func('DELETE FROM WFAssignee WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFAssignee',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFReviewer');
    v_stmt := 'Purge WFReviewer';
    batch_total_count := batch_delete_func('DELETE FROM WFReviewer WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFReviewer',batch_total_count,v_stmt);
    COMMIT;

    log_info('Purging WFCollectionTarget');
    v_stmt := 'Purge WFCollectionTarget';
    batch_total_count := batch_delete_func('DELETE FROM WFCollectionTarget WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFCollectionTarget',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFRoutingSlip');
    v_stmt := 'Purge WFRoutingSlip';
    batch_total_count := batch_delete_func('DELETE FROM WFRoutingSlip WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFRoutingSlip',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFNotification');
    v_stmt := 'Purge WFNotification' ;
    batch_total_count := batch_delete_func('DELETE FROM WFNotification WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFNotification',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFTaskTimer');
    v_stmt := 'Purge WFTaskTimer';
    batch_total_count := batch_delete_func('DELETE FROM WFTaskTimer WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTaskTimer',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFTaskError');
    v_stmt := 'Purge WFTaskError';
    batch_total_count := batch_delete_func('DELETE FROM WFTaskError WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTaskError',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFHeaderProps');
    v_stmt := 'Purge WFHeaderProps';
    batch_total_count := batch_delete_func('DELETE FROM WFHeaderProps WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFHeaderProps',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFEvidence');
    v_stmt := 'Purge  WFEvidence';
    batch_total_count := batch_delete_func('DELETE FROM WFEvidence WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFEvidence',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFTaskAssignmentStatistic');
    v_stmt := 'Purge WFTaskAssignmentStatistic';
    batch_total_count := batch_delete_func('DELETE FROM WFTaskAssignmentStatistic WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTaskAssignmentStatistic',batch_total_count,v_stmt);
    COMMIT;
    
    log_info('Purging WFTaskAggregation');
    v_stmt := 'Purge WFTaskAggregation';
    batch_total_count := batch_delete_func('DELETE FROM WFTaskAggregation WHERE rootTaskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)');
    debug_purge2('WFTaskAggregation',batch_total_count,v_stmt);
    COMMIT;

-- Now purge main task table
    log_info('Purging WFTask');
    v_stmt := 'Purge WFTask';
    batch_total_count := batch_delete_func('DELETE FROM  WFTask WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp)'); 
    debug_purge2('WFTask',batch_total_count,v_stmt);
    COMMIT;

    log_info('workflow.delete_workflow_instances ends');

EXCEPTION
  when others then
    log_error(v_stmt);
    raise;
END delete_workflow_instances;
 
PROCEDURE deleteComponentInstances(p_id_table   IN VARCHAR2)
AS
    v_stmt  VARCHAR2(2000);
    v_count NUMBER;
BEGIN
 
    log_info('workflow.deleteComponentInstance begins');
    truncate_temp_tables();
    v_stmt := 'INSERT INTO temp_wftask_purge (taskId, ecId) ' ||
              'SELECT task.taskId, task.ecId ' || 
              '  FROM WFTASK task, '||p_id_table || ' comp ' || 
              ' WHERE task.ecid = comp.ecId';

    EXECUTE IMMEDIATE v_stmt;
    COMMIT;
    debug_purge('temp_wftask_purge', 'workflow.deleteComponentInstance Inserted = ');

    delete_workflow_instances();
    log_info('workflow.deleteComponentInstance ends');


EXCEPTION
  when others then
    log_error(v_stmt);
    raise;
END deleteComponentInstances;

