/*
*
* deleteComponentInstances.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      deleteComponentInstances.sql - BPEL purge script 
*
*
*    DESCRIPTION
*     This script is used to purge BPEL tables provided with a list of composite instance ids
*     in an idTable. 
*
*    For a user with multi cpu machine, usage of parallel dml may help. Add this to master script.
*      execute immediate 'alter session enable parallel dml';
*
*/

PROCEDURE truncate_temp_tables
AS
BEGIN
  --before starting clean up temp tables
  EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_bm';
  EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_wm';
  EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_am';
END truncate_temp_tables;


/**
* procedure purge_b2b_tables
*
* delete b2b tables
*/
PROCEDURE purge_b2b_tables
AS
   CURSOR b2b_cur IS
     select bm_message_id, bm_payload_storage, bm_attachment_storage, bm_native_data_storage, bm_translated_data_storage, wm_packed_message, wm_payload_storage, am_payload, am_attachment_storage
     from b2b_purge_temp_bm ;
  TYPE bm_id_type IS TABLE OF b2b_purge_temp_bm.bm_message_id%TYPE;
  bm_id bm_id_type;
  TYPE bm_ps_type IS TABLE OF b2b_purge_temp_bm.bm_payload_storage%TYPE;
  bm_ps bm_ps_type;
  TYPE bm_as_type IS TABLE OF b2b_purge_temp_bm.bm_attachment_storage%TYPE;
  bm_as bm_as_type;
  TYPE bm_ns_type IS TABLE OF b2b_purge_temp_bm.bm_native_data_storage%TYPE;
  bm_ns bm_ns_type;
  TYPE bm_ts_type IS TABLE OF b2b_purge_temp_bm.bm_translated_data_storage%TYPE;
  bm_ts bm_ts_type;
  TYPE wm_pm_type IS TABLE OF b2b_purge_temp_bm.wm_packed_message%TYPE;
  wm_pm wm_pm_type;
  TYPE wm_ps_type IS TABLE OF b2b_purge_temp_bm.wm_payload_storage%TYPE;
  wm_ps wm_ps_type;
  TYPE am_p_type IS TABLE OF b2b_purge_temp_bm.am_payload%TYPE;
  am_p am_p_type;
  TYPE am_as_type IS TABLE OF b2b_purge_temp_bm.am_attachment_storage%TYPE;
  am_as am_as_type;

BEGIN
    
  OPEN b2b_cur;
     FETCH b2b_cur BULK COLLECT into bm_id, bm_ps, bm_as, bm_ns, bm_ts, wm_pm, wm_ps, am_p, am_as;
      dbms_output.put_line('TOTAL BM_ID = ' || bm_id.count());

     FORALL i IN bm_ps.first .. bm_ps.last
        DELETE FROM b2b_data_storage WHERE id = bm_ps(i);

     FORALL i IN bm_as.first .. bm_as.last
        DELETE FROM b2b_data_storage WHERE id = bm_as(i);

     FORALL i IN bm_ns.first .. bm_ns.last
        DELETE FROM b2b_data_storage WHERE id = bm_ns(i);

     FORALL i IN bm_ts.first .. bm_ts.last
        DELETE FROM b2b_data_storage WHERE id = bm_ts(i);

     FORALL i IN wm_pm.first .. wm_pm.last
        DELETE FROM b2b_data_storage WHERE id = wm_pm(i);

     FORALL i IN wm_ps.first .. wm_ps.last
        DELETE FROM b2b_data_storage WHERE id = wm_ps(i);

     FORALL i IN am_p.first .. am_p.last
        DELETE FROM b2b_data_storage WHERE id = am_p(i);

     FORALL i IN am_as.first .. am_as.last
        DELETE FROM b2b_data_storage WHERE id = am_as(i);

  CLOSE b2b_cur;
  EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_bm';

  COMMIT;

END purge_b2b_tables;


/*
* Procedure : deleteComponentInstances
*
* Description: 
*  This procedure is provided a table with composite instance ids that are purge able.
*
*  Parameters:
*  idTable : Name of the id table that contains list of purge able composite instance IDs
*  
*/

PROCEDURE deleteComponentInstances(p_id_table   IN VARCHAR2,
                        write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

  truncate_temp_tables();
  v_stmt := 'insert into b2b_purge_temp_bm(bm_id, bm_message_id, bm_payload_storage, bm_attachment_storage, bm_native_data_storage, bm_translated_data_storage, wm_packed_message, wm_payload_storage, am_payload, am_attachment_storage, ext_bm_id, am_id, wm_id)        SELECT bm.id, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage, 
       	      bm.translated_data_storage,
       	      wm.packed_message, wm.payload_storage,  
	      am.payload, am.attachment_storage, ext.id, am.id, wm.id
       FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext, ' || p_id_table || ' temp_table
       WHERE am.fabric_ecid = temp_table.ECID
       AND bm.wire_message = wm.id (+)
       AND bm.ext_business_message = ext.id (+)
       AND bm.app_message = am.id';
  EXECUTE immediate v_stmt;

  debug_purge_both('b2b_purge_temp_bm', 'Inserted = ',write_file);
  purge_b2b_tables();

EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END deleteComponentInstances;
