/*
*
*
* deleteNoCompositeIdInstances.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      deleteNoCompositeIdInstances.sql - Decision purge script used to purge Decision tables
*      that do not have a composite instance Id/ECID
*
*
*    DESCRIPTION
*     This script is used to purge BPEL tables rows that are created with instanace tracking off
*
*     Parameters:
*     p_older_than       Purge all data older than this retention period
*     p_rownum           Batch size, purge in batch size 
*     
*
*/

/*
* Procedure: deleteNoCompositeIdInstances
*
* Description
* This procedure purges following Decision tables where ecid is null
*
*    BRDecisionFault
*    BRDecisionUnitOfWork
*    BRDecisonInstance

*    
*/
FUNCTION deleteNoCompositeIdInstances( p_min_creation_date in timestamp,
                            p_max_creation_date in timestamp,
                            p_older_than TIMESTAMP, p_rownum NUMBER,
                            composite_dn in varchar2,
                            ignore_state in boolean,
                            write_file in utl_file.file_type default null)
RETURN BOOLEAN
AS
  v_stmt  VARCHAR2(2000);
  v_count NUMBER;
  v_cmpst_stmt varchar2(2000) := '';
  v_state_predicate varchar2(100):= '';
  v_rownum INTEGER;
BEGIN

  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_brdecision_instance';
  if ignore_state = false then 
       v_state_predicate := ' AND STATE !=0 ';
  end if;

  v_stmt := 'Create temp_brdecision_instance using CPST_INST_CREATED_TIME' ;
  if composite_dn is not null then
    v_cmpst_stmt := ' and component_dn like ''' || composite_dn || '%'''; 
   end if;	
  EXECUTE IMMEDIATE 'INSERT INTO temp_brdecision_instance(ID) ' 
     || 'SELECT ID FROM BRDecisionInstance WHERE  CREATION_TIME < '
     ||''''|| p_older_than ||''''|| ' AND   CPST_INST_CREATED_TIME BETWEEN '
     ||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''
     || p_max_creation_date  ||''''|| v_state_predicate || v_cmpst_stmt 
     ||' AND ROWNUM <= ' || p_rownum ||'  and ECID is null' ; 
  v_rownum := SQL%ROWCOUNT;
  debug_purge_both('temp_brdecision_instance', 'Inserted = ',write_file);
  if v_rownum = 0 then
     log_info_both
     ('No Decision instances found with null composite instance ids'
       ,write_file);
     RETURN FALSE;
  end if;
  commit;
  purge_decision_tables(write_file);

    return TRUE;
EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END deleteNoCompositeIdInstances ;
