/*
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem    delete_composite_inst_in_parallel.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   05/14/20 - Backport linlxu_bug-29750407_12212-main from main
Rem
*/    
  procedure delete_inst_pylds_parallel(id_table in varchar2,instance_type in varchar2, p_dop in number,p_thread in number,p_batch_size in number,write_file in utl_file.file_type, purge_partitioned_component in boolean ) as
      delete_sql varchar2(4000);
      v_deleted boolean :=true;
     begin
        while v_deleted LOOP
              v_deleted :=false;
           IF purge_partitioned_component = true OR is_table_partitioned('XML_DOCUMENT','DOC_PARTITION_DATE') = false then			  
	       delete_sql := 'delete from xml_document doc' ||
                      ' where doc.document_id NOT IN (select distinct b2b.document_id from B2B_DATA_STORAGE b2b)' ||
                      ' and doc.document_id in (' || 
                      ' select ip.payload_key from instance_payload ip' ||
                      ' where ip.instance_id in (' ||  
                      ' select it.id from ' || id_table || ' it' ||
                      ' WHERE (it.ecid IS NULL AND mod(it.id, ' || p_dop || ')=' || p_thread || ')' || 
                      ' OR (it.ecid IS NOT NULL and mod(dbms_utility.get_hash_value(it.ecid,0,' || p_dop || '), ' || p_dop || ')=' || p_thread || '))' ||
                      ' and ip.instance_type = ''' || instance_type || '''' || 
                      ' and rownum <= ' || p_batch_size || ')';
       execute immediate delete_sql;
       if SQL%FOUND then
           v_deleted :=true;
       end if;
       debug_purge('xml_document',null,write_file); 
	     end if;
       if instance_type = 'service'  then
           delete_sql := 'delete from rejected_msg_native_payload where id in (
                                   select payload_key from instance_payload where instance_id in (  select id from '||id_table||' ip WHERE
             (ip.ecid IS NULL AND mod (ip.id,'|| p_dop||')=' || p_thread ||')
          OR (ip.ecid IS NOT NULL and mod (dbms_utility.get_hash_value(ip.ecid,0,'||p_dop||'),'|| p_dop||')='||p_thread||')) and  instance_type = '''|| instance_type ||''' and  rownum<='||p_batch_size||')';  
           execute immediate delete_sql;
           if SQL%FOUND then
             v_deleted :=true;
            end if;
           debug_purge('rejected_msg_native_payload',null,write_file);
       end if;
       
           delete_sql :=  'delete from instance_payload where instance_id in (
                                  select id from '||id_table||' ip WHERE
             (ip.ecid  IS NULL AND mod (ip.id, '||p_dop||')=' || p_thread ||')
          OR (ip.ecid IS NOT NULL and mod (dbms_utility.get_hash_value(ip.ecid,0,'||p_dop||'),'|| p_dop||')='||p_thread||')) and  instance_type = '''|| instance_type ||''''||' and rownum<='||p_batch_size ;
           execute immediate delete_sql;
           if SQL%FOUND then
             v_deleted :=true;
            end if;
           debug_purge('instance_payload',null,write_file);
           commit; 

      END LOOP;
   EXCEPTION
    when others then
      log_error('ERROR(delete_inst_pylds_parallel)',write_file);
     raise; 
	 end delete_inst_pylds_parallel;

    procedure delete_ref_inst_parallel(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file in utl_file.file_type, purge_partitioned_component in boolean )  is
       
    purge_id_table varchar2(100) :='reference_instance_purge';
    delete_sql varchar2(4000);
    v_deleted boolean := true;
    begin

      delete_inst_pylds_parallel(purge_id_table, 'reference',p_dop,p_thread,p_batch_size,write_file, purge_partitioned_component);
	if purge_partitioned_component = true OR is_table_partitioned('REFERENCE_INSTANCE','CPST_PARTITION_DATE') = false then  
    while  v_deleted  LOOP 
        v_deleted :=false;          
      delete_sql:='delete from reference_instance  where id in ( select id from reference_instance_purge rip WHERE
             (rip.ecid IS NULL AND mod (rip.id,'|| p_dop||')='||p_thread||')
          OR (rip.ecid IS NOT NULL and mod (dbms_utility.get_hash_value(rip.ecid,0,'||p_dop||'),'|| p_dop||')='||p_thread||'))AND rownum <= '|| p_batch_size;         
        execute immediate delete_sql; 
       IF SQL%FOUND THEN
            v_deleted := true;
        END IF;
        debug_purge('reference_instance',null,write_file); 
        commit;
        log_info('time check',write_file);
        log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
        log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
        IF (sysdate >= p_stop_time) THEN
              v_deleted := FALSE ;
        END IF;

   END LOOP;   
    end if;  
    exception
      when others then
      log_error('ERROR(delete_ref_inst_parallel)',write_file);
	    raise;
	end delete_ref_inst_parallel;

   procedure delete_cmp_fault_parallel(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file in utl_file.file_type, purge_partitioned_component in boolean )  is

    purge_id_table varchar2(100) :='composite_fault_purge';
    delete_sql varchar2(4000);
    v_deleted boolean := true;
    begin

      delete_inst_pylds_parallel(purge_id_table, 'service',p_dop,p_thread,p_batch_size,write_file, purge_partitioned_component);
    while  v_deleted  LOOP
        v_deleted :=false;
      delete_sql:='delete from composite_instance_fault  where id in ( select id from composite_fault_purge rip WHERE
             (rip.ecid IS NULL AND mod (rip.id,'|| p_dop||')='||p_thread||')
          OR (rip.ecid IS NOT NULL and mod (dbms_utility.get_hash_value(rip.ecid,0,'||p_dop||'),'|| p_dop||')='||p_thread||'))AND rownum <= '|| p_batch_size;
        execute immediate delete_sql;
       IF SQL%FOUND THEN
            v_deleted := true;
        END IF;
        debug_purge('composite_instance_fault',null,write_file);
        commit;
        log_info('time check',write_file);
        log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
        log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
        IF (sysdate >= p_stop_time) THEN
             v_deleted := FALSE ;
        END IF;

   END LOOP;

    exception
      when others then
      log_error('ERROR(delete_cmp_fault_parallel)',write_file);
            raise;
         end delete_cmp_fault_parallel;
  procedure delete_component_instances(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file in utl_file.file_type, purge_partitioned_component in boolean) is 
  v_deleted boolean :=true;
  delete_sql varchar2(4000);
  purge_id_table varchar2(100) :='component_instance_purge';
  begin
    while v_deleted LOOP
      delete_inst_pylds_parallel(purge_id_table, 'component',p_dop,p_thread,p_batch_size,write_file, purge_partitioned_component);
      v_deleted := false;  
      delete_sql:='delete from component_instance  where id in ( select id from component_instance_purge cip WHERE
             (cip.ecid IS NULL AND mod (cip.id,'|| p_dop||')='||p_thread||')
          OR (cip.ecid IS NOT NULL and mod (dbms_utility.get_hash_value(cip.ecid,0,'||p_dop||'),'|| p_dop||')='||p_thread||'))AND rownum <= '|| p_batch_size;
        execute immediate delete_sql;
       IF SQL%FOUND THEN
            v_deleted := true;
        END IF;
        debug_purge('component_instance',null,write_file);
        commit;
        log_info('time check',write_file);
        log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
        log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
        IF (sysdate >= p_stop_time) THEN
             v_deleted := FALSE ;
        END IF;
     END LOOP;
    exception
      when others then
      log_error('ERROR(delete_component_instances)',write_file);
            raise;
  end delete_component_instances ;
   procedure delete_misc(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file in utl_file.file_type,purge_partitioned_component in boolean )  is

    purge_id_table varchar2(100) :='composite_instance_purge';
    v_deleted boolean := true;
    begin

      delete_inst_pylds_parallel(purge_id_table, 'composite',p_dop,p_thread,p_batch_size,write_file, purge_partitioned_component);
    while  v_deleted  LOOP
        v_deleted :=false;
       delete from composite_sensor_value where composite_instance_id in ( select id from composite_instance_purge cip where mod (dbms_utility.get_hash_value(cip.ecid,0,p_dop), p_dop)=p_thread)  AND rownum <= p_batch_size ;
       IF SQL%FOUND THEN
            v_deleted := true;
        END IF;
       debug_purge('composite_sensor_value',null,write_file);
        commit;
          delete from composite_instance_assoc where assoc1_composite_instance_id in ( select id from composite_instance_purge cip where mod (dbms_utility.get_hash_value(cip.ecid,0,p_dop), p_dop)=p_thread)  AND rownum <= p_batch_size ;
       IF SQL%FOUND THEN
            v_deleted := true;
       END IF;
       debug_purge('composite_instance_assoc',null,write_file);
        commit;

       delete from test_instance where composite_id in ( select id from composite_instance_purge cip where mod (dbms_utility.get_hash_value(cip.ecid,0,p_dop), p_dop)=p_thread)  AND rownum <= p_batch_size ;
       IF SQL%FOUND THEN
            v_deleted := true;
        END IF;
       debug_purge('test_instance',null,write_file);
        commit;

          log_info('time check',write_file);
          log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
          log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
          IF (sysdate >= p_stop_time) THEN
              v_deleted := FALSE ;
          END IF;

   END LOOP;

    exception
      when others then
      log_error('ERROR(delete_misc)',write_file);
            raise;
        end delete_misc;

   procedure delete_attachments(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file in utl_file.file_type )  is
     v_deleted boolean := true;
     begin
     while v_deleted LOOP
          v_deleted :=false;
          delete from attachment where key in (select key from attachment_ref where ecid in (
                      select ecid from composite_instance_purge cip where mod (dbms_utility.get_hash_value(cip.ecid,0,p_dop), p_dop)=p_thread) AND rownum <= p_batch_size);
          debug_purge('attachment',null,write_file);
          commit;

          delete from attachment_ref where ecid in (select ecid from composite_instance_purge cip where mod (dbms_utility.get_hash_value(cip.ecid,0,p_dop), p_dop)=p_thread) AND
               rownum <= p_batch_size;
          if SQL%FOUND then
            v_deleted :=true;
          end if;
          debug_purge('attachment_ref',null,write_file);
          commit;
          log_info('time check',write_file);
          log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
          log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
          IF (sysdate >= p_stop_time) THEN
             v_deleted := FALSE ;
          END IF;
    END LOOP;
    exception
      when others then
      log_error('ERROR(delete_attachment)',write_file);
            raise;
        end delete_attachments;

    procedure delete_rejected_messages(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file in utl_file.file_type, purge_partitioned_component in boolean )  is
       
    purge_id_table varchar2(100) :='rejected_message_purge';
    delete_sql varchar2(4000);
    v_deleted boolean := true;
    begin

      delete_inst_pylds_parallel(purge_id_table, 'service',p_dop,p_thread,p_batch_size,write_file,purge_partitioned_component);
    while  v_deleted  LOOP 
        v_deleted :=false;          
      delete_sql:='delete from rejected_message  where id in ( select id from rejected_message_purge rip WHERE
             (rip.ecid IS NULL AND mod (rip.id,'|| p_dop||')='||p_thread||')
          OR (rip.ecid IS NOT NULL and mod (dbms_utility.get_hash_value(rip.ecid,0,'||p_dop||'),'|| p_dop||')='||p_thread||'))AND rownum <= '|| p_batch_size;         
        execute immediate delete_sql; 
       IF SQL%FOUND THEN
            v_deleted := true;
        END IF;
        debug_purge('rejected_message',null,write_file); 
        commit;
        log_info('time check',write_file);
        log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
        log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
        IF (sysdate >= p_stop_time) THEN
              v_deleted := FALSE ;
        END IF;
    END LOOP;   
      
    exception
      when others then
      log_error('ERROR(delete_rejected_messages)',write_file);
	    raise;
    end delete_rejected_messages;
    
    procedure delete_composite_inst_parallel(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time date default NULL,write_file in utl_file.file_type default NULL, purge_partitioned_component  in boolean  default false ) is
    v_deleted boolean :=true;
    total_rows integer;
    begin
         log_info('starting fabric.delete_composite_insst_parallel',write_file);
         IF (sysdate < p_stop_time) THEN
          delete_ref_inst_parallel(p_dop,p_thread,p_batch_size,p_stop_time,write_file,purge_partitioned_component);
         END IF;
         IF (sysdate <  p_stop_time) THEN
           delete_cmp_fault_parallel(p_dop,p_thread,p_batch_size,p_stop_time,write_file, purge_partitioned_component); 
         END IF;
         IF (sysdate <  p_stop_time) THEN    
          delete_misc(p_dop,p_thread,p_batch_size,p_stop_time,write_file, purge_partitioned_component); 
         END IF; 
         IF(sysdate < p_stop_time) THEN
          delete_component_instances(p_dop,p_thread,p_batch_size,p_stop_time,write_file, purge_partitioned_component);
         END IF;
         IF(sysdate < p_stop_time) THEN
          delete_rejected_messages(p_dop,p_thread,p_batch_size,p_stop_time,write_file, purge_partitioned_component);
         end if; 
        IF(sysdate < p_stop_time) THEN
          delete_attachments(p_dop,p_thread,p_batch_size,p_stop_time,write_file);
         end if;
		if purge_partitioned_component = true OR is_table_partitioned('COMPOSITE_INSTANCE','PARTITION_DATE') = false then   
        while v_deleted LOOP
            delete from composite_instance where id in ( select id from composite_instance_purge cip where mod (dbms_utility.get_hash_value(cip.ecid,0,p_dop), p_dop)=p_thread)  AND rownum <= p_batch_size ;
            total_rows := SQL%ROWCOUNT;
          debug_purge('composite_instance',null,write_file);
          commit;
          IF total_rows < p_batch_size THEN
               v_deleted := FALSE ;
          END IF ;
          log_info('time check',write_file);
          log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
          log_info('p_stop_time = ' ||TO_CHAR( p_stop_time,'DD/MON/YYYY:HH24/MI'),write_file);
          IF (sysdate >= p_stop_time) THEN
              v_deleted := FALSE ;
          END IF;
       end loop;  
	   END IF;
        log_info('complete fabric.delete_composite_inst_parallel',write_file );
        exception
          when others then
          log_error('ERROR(delete_composite_inst_parallel)',write_file);
          rollback;
            raise;
    end delete_composite_inst_parallel;  
