Rem
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     purge_fabric_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Fabric tables
Rem
Rem

BEGIN
  IF table_exist('COMPOSITE_INSTANCE_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE COMPOSITE_INSTANCE_PURGE';
  END IF;
  IF table_exist('REFERENCE_INSTANCE_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE REFERENCE_INSTANCE_PURGE';
  END IF;
  IF table_exist('COMPOSITE_FAULT_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE COMPOSITE_FAULT_PURGE';
  END IF;
  IF table_exist('REJECTED_MESSAGE_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE REJECTED_MESSAGE_PURGE';
  END IF;
  IF table_exist('COMPONENT_INSTANCE_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE COMPONENT_INSTANCE_PURGE';
  END IF;
 EXECUTE IMMEDIATE 'CREATE TABLE composite_instance_purge (id integer,ecid varchar2(100))';
  EXECUTE IMMEDIATE 'CREATE TABLE reference_instance_purge (id integer,ecid varchar2(100))';
  EXECUTE IMMEDIATE 'CREATE INDEX temp11g_ref_inst_id on reference_instance_purge(id)';
  EXECUTE IMMEDIATE 'CREATE TABLE composite_fault_purge (id integer, ecid varchar2(100))';
  EXECUTE IMMEDIATE 'CREATE TABLE rejected_message_purge (id integer,ecid varchar2(100))';
  EXECUTE IMMEDIATE 'CREATE TABLE component_instance_purge (id varchar2(100),ecid varchar2(100))';
END;
/
CREATE OR REPLACE PACKAGE soa11g_fabric as

PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null);
                      
PROCEDURE deleteCompositeInstances(instance_id_table in varchar2,purge_partitioned_component in boolean default false,write_file in utl_file.file_type default null );

FUNCTION deleteNoCompositeIdInstances(min_created_date in timestamp,
                   max_created_date in timestamp,
                   retention_period in timestamp,
                   batch_size in integer,
                   purge_partitioned_component  in boolean  default false,
                   composite_dn in varchar2,
                   write_file in utl_file.file_type default null
                                      )  return boolean;                                        
PROCEDURE createTempTables(p_id_table   IN VARCHAR2,
                           p_max_count IN INTEGER,
                           p_min_creation_date in timestamp,
                           p_max_creation_date in timestamp,
                           p_older_than TIMESTAMP,
	                   composite_dn in varchar2,
                           write_file in utl_file.file_type default null);

PROCEDURE delete_composite_inst_parallel(p_dop NUMBER, p_thread NUMBER,
                     p_batch_size NUMBER default 20000,
                     p_stop_time date default NULL,
                     write_file in utl_file.file_type default NULL,
                     purge_partitioned_component  in boolean default false) ;

function isComponentPartitioned return boolean;
function getComponentPartitionInfo return char;
procedure deleteRejectedMessages(min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer,
                   stop_time  in Date,
                   purge_partitioned_component in boolean,
                   write_file in utl_file.file_type default null);

--  procedure delete_insts_by_partition(instance_id_table in varchar2, 
--                                                   partition_name in varchar2, 
--						   purge_partitioned_component in boolean);
end soa11g_fabric;
/

CREATE OR REPLACE PACKAGE BODY soa11g_fabric AS
@@fabric_danglingdelete.sql
@@fabric_delete_composite_instances.sql
@@fabric_delete_composite_inst_parallel.sql
@@fabric_deleteNoCompositeIdInstances.sql
@@fabric_createTempTable.sql
@@fabric_isComponentPartitioned.sql
@@fabric_deleteRejectedMessages.sql
--@@fabric_deleteCompositeInstancesByPartition.sql
END soa11g_fabric;    
/
--show errors ;
