/*
Rem
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem   delete_insts_in_parallel_job.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   04/28/20 - Backport linlxu_bug-30490102_12212-main from main
Rem       sanjain  04/29/10 - Enabling Mediator purge
Rem
*/

   procedure deleteComponentInstances(DOP in number,
                                      thread_num in number, 
                                      batch_size in number,
                                      v_stoptime in date,
                                      write_file in utl_file.file_type,
                                      purge_partitioned_component in char,
                                      componentPartInfo in component_partition_info ) is
   v_bool boolean;
   purge_partitioned_comp_bool boolean;
   begin
      log_info('soa11g.deleteComponentInstances begins, ' || 
               ' thread: ' || thread_num ||  
               ' batch_size=' || batch_size || 
               ' v_stoptime=' || v_stoptime || 
               ' sysdate='|| sysdate);
      if purge_partitioned_component ='Y' then 
               purge_partitioned_comp_bool := true;
      else
               purge_partitioned_comp_bool := false;
      end if; 
      IF (sysdate < v_stoptime) THEN
         log_info('thread: ' || thread_num || ' calling orabpel.deleteComponentInstances',write_file);
         if purge_partitioned_component = 'Y'  OR componentPartInfo.bpelPartitioned='N' OR componentPartInfo.bpelPartitioned='P' then             
            v_bool := soa11g_orabpel.deleteComponentInstances(DOP,thread_num, batch_size,v_stoptime,write_file,purge_partitioned_comp_bool);
            log_info('thread: ' || thread_num || ' finished processing bpel',write_file);
         end if;
      END IF;
      IF (sysdate < v_stoptime) THEN
         log_info('thread: ' || thread_num || ' calling workflow.deleteComponentInstances',write_file);
         if purge_partitioned_component = 'Y'  OR componentPartInfo.workflowPartitioned='N' then
               v_bool:= soa11g_workflow.deleteComponentInstances(DOP,thread_num, batch_size,v_stoptime,write_file);
            log_info('thread: ' || thread_num || ' finished processing workflow',write_file);
         end if;
      END IF;
      IF (sysdate < v_stoptime) THEN
         log_info('thread: ' || thread_num || ' calling mediator.deleteComponentInstances',write_file);
         if purge_partitioned_component = 'Y'  OR componentPartInfo.mediatorPartitioned='N'or componentPartInfo.mediatorPartitioned='P'  then
             v_bool:= soa11g_mediator.deleteComponentInstances(DOP,thread_num, batch_size,v_stoptime,write_file,purge_partitioned_comp_bool);
            log_info('thread: ' || thread_num || ' finished processing mediator',write_file);
         end if;
      END IF;

      if(sysdate < v_stoptime) then
        log_info('deleting composite instances',write_file);
         if purge_partitioned_component = 'Y'  OR componentPartInfo.fabricPartitioned='N' or componentPartInfo.fabricPartitioned ='P' then 
          soa11g_fabric.delete_composite_inst_parallel(DOP,thread_num,batch_size,v_stoptime,write_file,purge_partitioned_comp_bool);
        end if;
      end if;

      log_info('soa11g.deleteComponentInstances ends.'); 
   end deleteComponentInstances;

   procedure delete_insts_in_parallel_job(DOP in number,
                                          thread_num in number,
                                          batch_size in number,
                                          p_stoptime in varchar2,
                                          purge_partitioned_component in char,
                                          keep_workflow_inst_char in char,
                                          sql_trace IN varchar2 
                                          ) is
  v_code NUMBER;
  v_errm VARCHAR2(90); 
  v_stmt VARCHAR2(100);
  v_sleeptime number;
  v_jobflowsql varchar2(100);
  v_stoptime date := to_date(p_stoptime,'DD/MON/YYYY:HH24/MI');
  write_file  utl_file.file_type;
  componentPartInfo component_partition_info;
   BEGIN

      -- Set ACTION_NAME on SESSION.
      DBMS_APPLICATION_INFO.SET_MODULE(
            MODULE_NAME => 'PARALLELJOBPURGE11G',
            ACTION_NAME => 'SOAPURGEEXECUTING');

      if sql_trace = 'Y' then
        v_stmt := 'alter session set max_dump_file_size = unlimited';
        log_info(v_stmt);
        execute immediate v_stmt;
        v_stmt := 'alter session set events '
        || '''10046 trace name context forever, level 12''';
        log_info(v_stmt);
        execute immediate v_stmt;
      end if;

      log_info('soa11g.delete_insts_in_parallel_job begins. thread=' || thread_num);
      write_file := get_file11g(thread_num);      
      log_info( 'thread: ' || thread_num || ' sleep at start time',write_file);
      -- to avoid starting all jobs at the same time causing concurrency issues we put a sleep here into 
      v_stmt := 'sleep at start of job';
      v_sleeptime := 10*thread_num;
      execute immediate 'begin dbms_lock.sleep(' || v_sleeptime || '); end;';
      log_info('thread: ' || 'thread_num' || ' sleep over',write_file);
      log_info('thread: ' || thread_num || ' time check',write_file);
      log_info('time check');
      log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'),write_file);
      log_info('v_stoptime = ' ||TO_CHAR( v_stoptime,'DD/MON/YYYY:HH24/MI'),write_file);
      componentPartInfo := getComponentPartitionInfo();
      deleteComponentInstances(DOP,thread_num, batch_size,v_stoptime,write_file,purge_partitioned_component,componentPartInfo);
      log_info('time check');
      log_info('sysdate  = ' ||TO_CHAR(sysdate,'DD/MON/YYYY:HH24/MI'));
      log_info('thread: ' || thread_num || ' deleting from job_flow_control table',write_file);
      v_jobflowsql := 'DELETE FROM job_flow_control WHERE job_thread =' || thread_num;
      execute immediate v_jobflowsql;
      commit;
      close_file(write_file);
      log_info('soa11g.delete_insts_in_parallel_job ends. thread=' || thread_num);  

    -- Set ACTION_NAME on SESSION to NULL.
    DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);

 EXCEPTION
   when others then 
   log_error('ERROR(delete_inst_in_parallel_job',write_file);
   rollback;
   v_jobflowsql := 'DELETE FROM job_flow_control WHERE job_thread ='|| thread_num;
   execute immediate v_jobflowsql;
   commit;
   close_file(write_file);
   DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);
   raise;

 END delete_insts_in_parallel_job;
