Rem
Rem $Header: pcbpel/admin/sqlutils12/soa11g_purge/oracle/workflow/purge_hwf_oracle.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/08/19 12:08:47 apfwkr Exp $
Rem
Rem purge_workflow_oracle.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_workflow_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Purges workflow related tables
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      04/28/20 - Backport linlxu_bug-30490102_12212-main from main
Rem    vsvetov     05/04/10 - creation
Rem

--First drop temp table before procceding with creation
BEGIN
  IF table_exist('TEMP11G_WFTASK_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp11g_wftask_purge';
  END IF;
  -- Create temporary tables
  EXECUTE IMMEDIATE 'CREATE TABLE TEMP11g_WFTASK_PURGE(taskId VARCHAR2(64), ecId VARCHAR2(200))';
END;
/
--show errors;
CREATE OR REPLACE PACKAGE soa11g_workflow 
AS
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null);
                      
PROCEDURE deleteComponentInstances ( p_id_table   IN VARCHAR2,
                           write_file in utl_file.file_type default null);

PROCEDURE pruneOpenECIDs ( p_id_table      IN VARCHAR2,
                           p_prune_table IN VARCHAR2,
                           p_older_than TIMESTAMP,
                           write_file in utl_file.file_type default null);

FUNCTION  deleteNoCompositeIdInstances(p_min_creation_date in timestamp,
                             p_max_creation_date in timestamp,
                             p_older_than TIMESTAMP, p_rownum NUMBER,
                             composite_dn in varchar2,
                             ignore_state in boolean,
                             write_file in utl_file.file_type default null) 
RETURN BOOLEAN;

PROCEDURE createTempTables(p_id_table   IN VARCHAR2,
                           p_max_count IN INTEGER,
                           p_min_creation_date in timestamp,
                           p_max_creation_date in timestamp,
                           p_older_than TIMESTAMP,
			   composite_dn in varchar2,
                           write_file in utl_file.file_type default null);

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER,
                           p_batch_size NUMBER default 20000,
                           p_stop_time DATE default NULL,
                           write_file in utl_file.file_type default null) 
RETURN BOOLEAN;

FUNCTION isComponentPartitioned RETURN BOOLEAN;

END soa11g_workflow;
/

CREATE OR REPLACE PACKAGE BODY soa11g_workflow 
AS
@@hwf_danglingdelete.sql
@@hwf_pruneOpenECIDs.sql
@@hwf_deleteComponentInstances.sql
@@hwf_deleteNoCompositeIdInstances.sql
@@hwf_deleteComponentInstancesDOP.sql
@@hwf_isComponentPartitioned.sql
@@hwf_createTempTables.sql

END soa11g_workflow;
/
--show errors;
