Rem
Rem
Rem purge_common_oracle.sql
Rem
Rem Copyright (c) 2009, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_common_oracle.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   01/19/23 - CI# 34996638 of
Rem       apfwkr   01/19/23 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem       apfwkr   01/19/23 - from st_pcbpel_12.2.1.4.0soabp.
Rem       apfwkr   01/19/23 - CI# 34996638
Rem       apfwkr   01/19/23 - apfwkr_ci_backport_33323056_12.2.1.4.0soabp
Rem       apfwkr   12/08/22 - BLR# 34874653 of jbahadur_bug-33323056_1221 .
Rem       apfwkr   12/08/22 - BLR# 34874653
Rem       apfwkr   12/08/22 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem       apfwkr   12/08/22 - from main
Rem       apfwkr   11/04/20 - Backport
Rem                           apfwkr_blr_backport_31572611_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem       apfwkr   10/19/20 - Backport apfwkr_blr_backport_31572611_12.2.1.4.0
Rem                           from main
Rem       apfwkr   07/23/20 - Backport
Rem                           apfwkr_blr_backport_31589423_12.2.1.4.200524soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem       apfwkr   07/20/20 - Backport apfwkr_blr_backport_31589423_12.2.1.4.0
Rem                           from main
Rem       apfwkr   07/16/20 - Backport linlxu_bug-31589423_apps_1221 from
Rem                           st_pcbpel_12.2.1.0.0
Rem       shabdull 12/17/19 - Backport apfwkr_blr_backport_30374610_12.2.1.1.0
Rem                           from st_pcbpel_12.2.1.1.0
Rem       apfwkr   11/20/19 - Backport linlxu_bug-30374610_12212-main from main
Rem       apfwkr   10/16/20 - Backport apfwkr_blr_backport_31572611_12.2.1.3.0
Rem                           from main
Rem       apfwkr   10/15/20 - Backport
Rem                           shabdull_blr_backport_31572611_12.2.1.2.0 from
Rem                           st_pcbpel_12.2.1.2.0
Rem       shabdull 07/16/20 - Backport linlxu_bug-31572611_12212 from
Rem                           st_pcbpel_12.2.1.2.0
Rem       mbousamr 07/08/13 - Reversed most of the changes by rxvenkat
Rem                            on 03/02/13 due to purge 11g-12c upgrade.
Rem                           Other changes should be reversed once 
Rem                            partitioning is instrumented for upgrade.
Rem       rxvenkat 03/02/13 - Remove PS6 Purge Tables to have upgrade match
Rem                           full schema
Rem       ssudarsa 04/13/10 - Created
Rem
Rem
Rem Clean up old PS6 tables if present in the DB. Needed for upgrade
Rem
--show errors;
CREATE OR REPLACE FUNCTION table_exist( tablename IN VARCHAR2)
   RETURN BOOLEAN
 IS
   val   VARCHAR2(2) :='F';
   val_T VARCHAR2(2) :='T';
 BEGIN
   SELECT DECODE(COUNT(*),0,'F','T')
   INTO val
   from USER_TABLES
   WHERE table_name = tablename;
   IF val = val_T THEN
     RETURN true;
   ELSE
     RETURN false;
   END IF;
 END table_exist;
/
-- show error

BEGIN

  IF table_exist('VERIFY_MD_GROUP2') THEN
    EXECUTE IMMEDIATE 'DROP TABLE VERIFY_MD_GROUP2';
  END IF;

END;
/

create or replace procedure write_line(line in varchar2, write_file in  utl_file.file_type default null) is
begin

 if utl_file.is_open(write_file)=false  then
      dbms_output.put_line(line);
  else
     utl_file.put_line (write_file,line); 
  end if; 
end write_line;
/
--show errors;

CREATE OR REPLACE PROCEDURE debug_purge (table_name IN VARCHAR2, str IN VARCHAR2 default null,write_file in utl_file.file_type default null) AS
BEGIN
 $IF $$debug_on $THEN
      if str is NULL then
	         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || ' purged is : ' || SQL%ROWCOUNT,write_file);
     ELSE
	         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || str || SQL%ROWCOUNT,write_file);
     END IF;
 $ELSE
    null;
 $END

END debug_purge;
/
--show errors;

CREATE OR REPLACE FUNCTION get_Valid_PURGE_LOG (message IN VARCHAR2) RETURN VARCHAR2 AS 
  MAX_LENGTH_PURGE_LOG integer := 2000;  -- max length of the PURGE_LOG column of the SOA_PURGE_LOG table
BEGIN
  IF message IS NULL THEN
      RETURN '';
  ELSIF LENGTH(message) > MAX_LENGTH_PURGE_LOG THEN
      RETURN replace(SUBSTR(message, 0, MAX_LENGTH_PURGE_LOG), '''', '');
  ELSE
      RETURN replace(message, '''', '');
  END IF;

END get_Valid_PURGE_LOG;
/
--show errors;

/*
 The BOTH suffix means the routine writes to file and SQLPLUS console for
 backward compatibility. The BOTH routines should be used by Foreground
 procedures and not those that are run in Background by DBMS_SECHEDULER
 which only write to file.
*/
CREATE OR REPLACE PROCEDURE debug_purge_both(
 table_name IN VARCHAR2,
 str IN VARCHAR2 default null,
 write_file in utl_file.file_type default null)
AS
v_stmt  VARCHAR2(2100);
BEGIN
 $IF $$debug_on $THEN
      IF str is NULL then
         if utl_file.is_open(write_file) then
            write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
              || ' Number of rows in table ' || table_name || ' '
              || ' purged is : ' || SQL%ROWCOUNT,write_file);
         end if;
         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
           || ' Number of rows in table ' || table_name || ' '
           || ' purged is : ' || SQL%ROWCOUNT,NULL);
      ELSE
         if utl_file.is_open(write_file) then
            write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
              || ' Number of rows in table ' || table_name || ' '
              || str || SQL%ROWCOUNT,write_file);
         end if;
         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
           || ' Number of rows in table ' || table_name || ' '
           || str || SQL%ROWCOUNT,NULL);
     END IF;
 $ELSE
    null;
 $END

IF str is NULL then
     v_stmt := 'INSERT INTO SOA_PURGE_LOG VALUES (sysdate, ''' || get_Valid_PURGE_LOG('Number of rows in table ' || table_name || ' ' || ' purged is : ' || SQL%ROWCOUNT) || ''')';
ELSE
     v_stmt := 'INSERT INTO SOA_PURGE_LOG VALUES (sysdate, ''' || get_Valid_PURGE_LOG('Number of rows in table ' || table_name || ' ' || str || SQL%ROWCOUNT) || ''')';
END IF;
EXECUTE IMMEDIATE v_stmt;

END debug_purge_both;
/
show errors;

create or replace procedure log_info(message in varchar2, write_file utl_file.file_type default null) is
v_stmt  VARCHAR2(2100);
begin
  $IF $$debug_on $THEN
	   write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') ||' : '||message,write_file);
  $ELSE
     null;
  $END   

     v_stmt := 'INSERT INTO SOA_PURGE_LOG VALUES (sysdate, ''' || replace(message, '''', '') || ''')';
     EXECUTE IMMEDIATE v_stmt;

end log_info;	
/
--show errors;

/*
 The BOTH suffix means the routine writes to file and SQLPLUS console for
 backward compatibility. The BOTH routines should be used by Foreground
 procedures and not those that are run in Background by DBMS_SECHEDULER
 which only write to file.
*/
create or replace procedure log_info_both(message in varchar2, write_file utl_file.file_type default null) is
v_stmt  VARCHAR2(2100);
begin
  $IF $$debug_on $THEN
      if utl_file.is_open(write_file) then
         write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
              ||' : '||message,write_file);
      end if;
      write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') ||' : '
              ||message,NULL);
  $ELSE
     null;
  $END

     v_stmt := 'INSERT INTO SOA_PURGE_LOG VALUES (sysdate, ''' || replace(message, '''', '') || ''')';
     EXECUTE IMMEDIATE v_stmt;

end log_info_both;
/
--show errors;

create or replace procedure log_error(message in varchar2,write_file utl_file.file_type default null) is
begin
            write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') ||'
: '||message ||'. Error Code = '||SQLCODE||', Error Message = '||SQLERRM,write_file);
end log_error;
/
--show errors;

/*
 The BOTH suffix means the routine writes to file and SQLPLUS console for
 backward compatibility. The BOTH routines should be used by Foreground
 procedures and not those that are run in Background by DBMS_SECHEDULER
 which only write to file.
*/
create or replace procedure log_error_both(message in varchar2,write_file utl_file.file_type default null) is
begin
       if utl_file.is_open(write_file)
        then
          write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
            ||': '||message ||'. Error Code = '||SQLCODE
            ||', Error Message = '||SQLERRM,write_file);
       end if;
       write_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS')
         ||': '||message ||'. Error Code = '||SQLCODE
         ||', Error Message = '||SQLERRM,NULL);

end log_error_both;
/
--show errors;


CREATE OR REPLACE PROCEDURE dangling_delete_proc(p_sql IN VARCHAR2, p_transaction_size NUMBER default 0, v_stoptime in date, write_file in utl_file.file_type default null) AS 
       v_stmt  VARCHAR2(2000);
       has_more_rows BOOLEAN := TRUE;
BEGIN
       v_stmt := p_sql;
       IF (p_transaction_size > 0) THEN
          v_stmt := v_stmt || ' AND rownum <= ROWSIZE';
          v_stmt := REPLACE(v_stmt, 'ROWSIZE', p_transaction_size);
       END IF;
       WHILE (sysdate < v_stoptime and has_more_rows )
       LOOP
          EXECUTE IMMEDIATE  v_stmt;
          IF SQL%NOTFOUND THEN
              has_more_rows := FALSE;
          END IF;
          dbms_output.put_line('[' || v_stmt || '], deleted = ' || SQL%ROWCOUNT);
          log_info('[' || v_stmt || '], deleted = ' || SQL%ROWCOUNT, write_file);
          commit;
       END LOOP;
   EXCEPTION
            when others then
            log_error('ERROR(dangling_delete_proc ' || SQLCODE);

END dangling_delete_proc;
/

create or replace function is_table_partitioned(table_name in varchar2, 
                                                partition_column_name in varchar2) return boolean is
   
                                  
   row_found integer := 0;       
begin       
   select count(1) into row_found from user_part_key_columns where object_type ='TABLE' and name = table_name and column_name = partition_column_name;
       
   if row_found = 1 then
       return true;
   else
       return false;
   end if;
           
end is_table_partitioned;
/
--show errors;
create or replace function partition_exists(table_name in varchar2,
                                                partition_name in varchar2) return boolean is


   row_found integer := 0;
   tablename varchar2(100) := upper(table_name);
   partitionname varchar2(100) := upper(partition_name);
begin
   select count(1) into row_found from user_tab_partitions where table_name =tablename and partition_name = partitionname;

   if row_found = 1 then
       return true;
   else
       return false;
   end if;

end partition_exists;
/

--show errors;
CREATE OR REPLACE FUNCTION table_exist( tablename IN VARCHAR2)
   RETURN BOOLEAN
 IS
   val   VARCHAR2(2) :='F';
   val_T VARCHAR2(2) :='T';
 BEGIN
   SELECT DECODE(COUNT(*),0,'F','T')
   INTO val
   from USER_TABLES
   WHERE table_name = tablename;
   IF val = val_T THEN
     RETURN true;
   ELSE
     RETURN false;
   END IF;
 END table_exist;
/
--show errors;
CREATE OR REPLACE FUNCTION seq_exist( seqname IN VARCHAR2)
   RETURN BOOLEAN
 IS
   val   VARCHAR2(2) :='F';
   val_T VARCHAR2(2) :='T';
 BEGIN
   SELECT DECODE(COUNT(*),0,'F','T')
   INTO val
   from USER_SEQUENCES
   WHERE sequence_name = seqname;
   IF val = val_T THEN
     RETURN true;
   ELSE
     RETURN false;
   END IF;
 END seq_exist;
/
--show errors;
  create or replace function  get11g_file(thread_num in integer) return utl_file.file_type is
   write_file  utl_file.file_type;
   SOA_PURGE_DIR_NAME     varchar2(40) := 'SOA_PURGE_DIR';
   filename  varchar2(40) := 'SOA11G_PURGE_LOG_THREAD' || thread_num;

    begin
        write_file := utl_file.fopen (SOA_PURGE_DIR_NAME,filename, 'W');
        return write_file;
   EXCEPTION
      when others then
        return null;
   end get11g_file;
/
  --show errors;

  create or replace function  get_file(thread_num in integer) return utl_file.file_type is
   write_file  utl_file.file_type;
   SOA_PURGE_DIR_NAME     varchar2(40) := 'SOA_PURGE_DIR';
   filename  varchar2(40) := 'SOA_PURGE_T' 
                          ||thread_num||'_'
                          ||TO_CHAR(systimestamp,'YYYYMMDDHH24MISS')||'.log';

    begin

  $IF $$debug_on $THEN
      write_file := utl_file.fopen (SOA_PURGE_DIR_NAME,filename, 'W');
  $ELSE
     null;
  $END
       
        return write_file;
   EXCEPTION
      when others then 
        return null;
   end get_file;
/
  --show errors;

  create or replace function  get_file_main
                return utl_file.file_type is

   write_file  utl_file.file_type;
   SOA_PURGE_DIR_NAME     varchar2(40) := 'SOA_PURGE_DIR';
   filename  varchar2(40) := 'SOA_PURGE_MAIN'||'_'
                        ||TO_CHAR(systimestamp,'YYYYMMDDHH24MISS')||'.log';

    begin

  $IF $$debug_on $THEN
      write_file := utl_file.fopen (SOA_PURGE_DIR_NAME,filename, 'W');
  $ELSE
     null;
  $END
      
      return write_file;

   EXCEPTION
      when others then
        return write_file;
   end get_file_main;
/
  --show errors;

  create or replace function  get_file_other (p_suffix varchar2)
                return utl_file.file_type is

   write_file  utl_file.file_type;
   SOA_PURGE_DIR_NAME   varchar2(40) := 'SOA_PURGE_DIR';
   filename  varchar2(40) := 'SOA_PURGE_' ||p_suffix||'_'
                        ||TO_CHAR(systimestamp,'YYYYMMDDHH24MISS')||'.log';

    begin

  $IF $$debug_on $THEN
      write_file := utl_file.fopen (SOA_PURGE_DIR_NAME,filename, 'W');
  $ELSE
     null;
  $END
      
      return write_file;

   EXCEPTION
      when others then
        return write_file;
   end get_file_other;
/
  --show errors;

   create or replace procedure close_file(write_file in out utl_file.file_type) is
   begin
        utl_file.fclose(write_file);
   end close_file;
/
--show errors;

create or replace function column_exists( p_table_name varchar2, p_column_name varchar2)
  RETURN BOOLEAN
 IS
   val   VARCHAR2(2) :='F';
   val_T VARCHAR2(2) :='T';
 BEGIN
   SELECT DECODE(COUNT(*),0,'F','T') INTO val
    FROM USER_TAB_COLUMNS WHERE table_name = p_table_name and column_name = p_column_name ;

   IF val = val_T THEN
     RETURN true;
   ELSE
     RETURN false;
   END IF;
END column_exists;
/
--show errors;

create or replace procedure write_DisableEnableConst(
  trs_handle in  utl_file.file_type, 
  table_name in varchar2, 
  enable in boolean)
 is

  table_namex varchar2(40);

  begin
  
  table_namex := UPPER(table_name);

  FOR const IN
    (select table_name, constraint_name
       from user_constraints a
      where a.constraint_type = 'R'
        and exists
          (select 1 from user_constraints b
            where a.r_constraint_name = b.constraint_name
              and b.table_name =  UPPER(table_namex)))
    LOOP
        if enable then
           write_line('ALTER TABLE '
            || const.table_name  || ' enable constraint '
            || const.constraint_name ||';',trs_handle);
        else
           write_line('ALTER TABLE ' 
            || const.table_name  || ' disable constraint '
            || const.constraint_name ||';',trs_handle);
        end if;
    END LOOP;

end write_DisableEnableConst;
/
--show errors

create or replace procedure write_drop_partition_query(
p_table_name varchar2,
p_partition_name varchar2,
transition in boolean,
write_file  utl_file.file_type)
is

v_query varchar2(4000);

begin

   if partition_exists(p_table_name, p_partition_name)  = true then

      if transition then

         v_query := 'ALTER TABLE ' || p_table_name || ' truncate partition '
                 || p_partition_name ||' UPDATE GLOBAL INDEXES;';
         write_line(v_query,write_file);
      
      else

         v_query := 'ALTER TABLE ' || p_table_name || ' drop partition ' 
                 || p_partition_name ||' UPDATE GLOBAL INDEXES;';
         write_line(v_query,write_file);

      end if;

   end if;

end write_drop_partition_query;
/
--show errors

create or replace procedure write_query_comments(comments varchar2, write_file utl_file.file_type)
is
begin
     write_line('-- ' || comments,write_file ); 
end write_query_comments;
/
--show errors
 
create or replace type component_partition_info as object
(
  fabricPartitioned char,
  bpelPartitioned char,
  mediatorPartitioned char,
  b2bPartitioned char,
  workflowPartitioned char,
  decisionPartitioned char,
constructor function component_partition_info return self as result
);
/
--show errors;
create or replace type body component_partition_info as 
 
  constructor function component_partition_info return self as result is
  begin
    return;
  end component_partition_info;
end;
/
--show errors;                                             
CREATE OR REPLACE FUNCTION get_partition_name(tablename IN VARCHAR2,part_hv in timestamp)
   RETURN VARCHAR2
 IS
   part_name  VARCHAR2(40);
   x_part_hv timestamp;
 BEGIN

   part_name := 'NOTFOUND';

   for v_rec in (select partition_name,high_value
                  from user_tab_partitions
                 where table_name = tablename)
   loop
    if v_rec.high_value != 'MAXVALUE'
     then
      execute immediate 'begin :1 := ' || v_rec.high_value || '; end;'
        using out x_part_hv;
      dbms_output.put_line('High_value timestamp : ' || x_part_hv);
      if x_part_hv = part_hv
        then
           part_name := v_rec.partition_name;
      end if;
    end if;
   end loop;

   RETURN part_name;

 END get_partition_name;
/

--show errors;

CREATE OR REPLACE FUNCTION get_Valid_PURGE_LOG (message IN VARCHAR2) RETURN VARCHAR2 AS 
  MAX_LENGTH_PURGE_LOG integer := 2000;  -- max length of the PURGE_LOG column of the SOA_PURGE_LOG table
BEGIN
  IF message IS NULL THEN
      RETURN '';
  ELSIF LENGTH(message) > MAX_LENGTH_PURGE_LOG THEN
      RETURN replace(SUBSTR(message, 0, MAX_LENGTH_PURGE_LOG), '''', '');
  ELSE
      RETURN replace(message, '''', '');
  END IF;

END get_Valid_PURGE_LOG;
/
--show errors;

create or replace function batch_delete_func(p_sql IN VARCHAR2, p_transaction_size integer default 100000, p_stop_time INTEGER default -1, write_file in utl_file.file_type default null) return integer AS 
       v_stoptime DATE := sysdate + NVL(p_stop_time,24*60)/(24*60);
       v_stmt  VARCHAR2(2000);
       v_stmt2  VARCHAR2(10) := ' AND ';
       has_more_rows BOOLEAN := TRUE;
       v_totalcount integer := 0;
BEGIN
       v_stmt := p_sql;
       IF (p_transaction_size > 0) THEN
          IF (INSTR( UPPER(p_sql), 'WHERE' ) = 0) THEN
              v_stmt2 := ' WHERE ';
          END IF;
          v_stmt := v_stmt || v_stmt2 || 'rownum <= ROWSIZE';
          v_stmt := REPLACE(v_stmt, 'ROWSIZE', p_transaction_size);
       END IF;

       WHILE (has_more_rows )
       LOOP
          EXECUTE IMMEDIATE  v_stmt;
          IF SQL%NOTFOUND THEN
              has_more_rows := FALSE;
          END IF;
          v_totalcount := v_totalcount + SQL%ROWCOUNT;
          
          dbms_output.put_line('[' || v_stmt || '], rowcount = ' || SQL%ROWCOUNT);
          log_info('[' || v_stmt || '], rowcount = ' || SQL%ROWCOUNT, write_file);
          commit;

          IF p_stop_time > 0 AND sysdate > v_stoptime THEN
              has_more_rows := FALSE;
          END IF;
          
       END LOOP;
       
       return v_totalcount;
       
   EXCEPTION
            when others then
            log_error('ERROR(batch_delete_func ' || SQLCODE);
       return -1;

END batch_delete_func;
/
--show errors;



create or replace function batch_update_func(c_sql IN VARCHAR2, c_transaction_size integer default 100000, c_stop_time INTEGER) return integer AS     
       v_totalcount integer := 0;
BEGIN
       v_totalcount := batch_delete_func(c_sql, c_transaction_size,c_stop_time,NULL);	
       return v_totalcount;       
    EXCEPTION
       when others then          
    return -1;

END batch_update_func;
/
--show errors;
