/*
*
*
* decision_pruneOpenFlowIDs.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
*
*    NAME
*      decision_pruneOpenFlowIDs.sql - decision prune OPEN FLOW_IDs query
*
*
*    DESCRIPTION
*     This script is used to prune a list of composite instance ids passed in 
*     an idTable. Decision uses following criteria to identify a non-purgeable
*     instance :
*      - bri state is = 0 (instance is still open)
*      - bri.CREATION_TIME is in retention period
*
*     Parameters:
*     p_older_than TIMESTAMP : Retention period for BPEL instances
*     p_id_table : this is the temp table with purge able composite 
*     instance ids
*     p_prune_table : Add to this table the open instances
*
*/
PROCEDURE pruneOpenFlowIDs (p_id_table IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file IN utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

IF p_prune_table is not null then
    v_stmt := 'INSERT INTO ' || p_prune_table 
           || ' SELECT DISTINCT comp.Flow_ID from BRDecisionInstance bri, ' 
           ||  p_id_table 
           || '  comp WHERE comp.Flow_ID = bri.Flow_ID AND bri.STATE = 0' ;

    EXECUTE immediate v_stmt ;
    debug_purge_both(p_prune_table, 'Inserted ',write_file);

    COMMIT;
END IF;

EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;
 
END pruneOpenFlowIDs;

