Rem purge_decision_oracle.sql
Rem
Rem Copyright (c) 2009, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_decision_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Decision Tables
Rem

BEGIN
  IF table_exist('TEMP_BRDECISION_INSTANCE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_brdecision_instance';
  END IF;
  IF table_exist('TEMP_BRDECISION_INSTANCE_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_brdecision_instance_glb';
  END IF;
  EXECUTE IMMEDIATE 'CREATE TABLE temp_brdecision_instance(Id VARCHAR2(100))';
  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE temp_brdecision_instance_glb(Id VARCHAR2(100)) on commit preserve rows';
END;
/
CREATE OR REPLACE PACKAGE soa_decision
AS

PROCEDURE deleteComponentInstances ( p_id_table   IN VARCHAR2,
                            write_file in utl_file.file_type default null);

PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null);
                      
PROCEDURE deleteComponentInstAdhoc;

function isComponentPartitioned return boolean;

END soa_decision;
/
CREATE OR REPLACE
PACKAGE body soa_decision
AS
@@decision_pruneOpenFlowIDs.sql
@@decision_deleteComponentInstances.sql
@@decision_deleteComponentInstAdhoc.sql
@@decision_isComponentPartitioned.sql

END soa_decision;
/
--show errors;
