/*
Rem Copyright (c) 2006, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem    delete_composite_inst_in_parallel.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   07/18/23 - CI# 35616531 of
Rem       apfwkr   07/18/23 - apfwkr_blr_backport_34362738_12.2.1.4.230404soabp
Rem       apfwkr   07/18/23 - from st_pcbpel_12.2.1.4.0soabp.
Rem       apfwkr   07/18/23 - CI# 35616531
Rem                           apfwkr_ci_backport_34362738_12.2.1.4.0soabp
Rem       apfwkr   07/07/23 - BLR# 35579684 of linlxu_bug-34362738_12212-main .
Rem       apfwkr   07/07/23 - BLR# 35579684
Rem       apfwkr   07/07/23 - apfwkr_blr_backport_34362738_12.2.1.4.230404soabp
Rem                           from main
Rem       bpulappa 05/14/15 - 21076201
Rem
*/    


FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER,
                                   p_batch_size NUMBER default 20000,
                                   p_stop_time DATE default NULL,write_file utl_file.file_type default NULL,
                                                                   purge_partitioned_component in boolean default false)
 RETURN BOOLEAN
AS
  v_stmt  VARCHAR2(2000);
  v_deleted boolean:=true;
  v_counter NUMBER := 1;
  cursor_flag boolean:=true;
  v_stoptime date :=p_stop_time;

  -- Added for cursor optimization
  l_num_rows number := 0;
  TYPE purge_num_type IS TABLE OF NUMBER;
  l_flow_instances purge_num_type;

  CURSOR c_temp_flow_instance_thread IS
  SELECT tfp.flow_id FROM temp_flowid_purge tfp
    WHERE mod (tfp.flow_id, p_dop)=p_thread;


BEGIN

OPEN c_temp_flow_instance_thread;

v_deleted := true;
while  v_deleted  LOOP -- this loop is for keeping transactions short

    v_deleted := false;
    log_info('Begin FABRIC purge loop ' || v_counter || ' for thread = ' || p_thread,write_file);

    FETCH c_temp_flow_instance_thread BULK COLLECT into l_flow_instances LIMIT p_batch_size;
    l_num_rows := l_flow_instances.count;
    log_info('flow instances count = ' || l_num_rows, write_file);

-- Must check Foreign Keys.

v_stmt := 'Purge SCA_ASYNC_CPNT_STATE';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_ASYNC_CPNT_STATE WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_ASYNC_CPNT_STATE',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge SCA_COMMON_FAULT';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_COMMON_FAULT WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_COMMON_FAULT',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge SCA_REJECTED_MESSAGE';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_REJECTED_MESSAGE WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_REJECTED_MESSAGE',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge SCA_SENSOR_VALUE';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_SENSOR_VALUE WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_SENSOR_VALUE',null,write_file);
        COMMIT;
    END IF;

 v_stmt := 'Purge ATTACHMENT';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM ATTACHMENT WHERE KEY IN
               (SELECT SCA_ATT_KEY FROM SCA_ATTACHMENT_REF WHERE flow_id = l_flow_instances(i));
       debug_purge('ATTACHMENT',null,write_file);
       COMMIT;
    END IF;

v_stmt := 'Purge SCA_ATTACHMENT_REF';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_ATTACHMENT_REF WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_ATTACHMENT_REF',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge AUDIT_TRAIL' ;
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM AUDIT_TRAIL WHERE flow_id = l_flow_instances(i);
          debug_purge('AUDIT_TRAIL',null,write_file);
          COMMIT;
    END IF;

v_stmt := 'Purge AUDIT_DETAILS' ;
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM AUDIT_DETAILS WHERE flow_id = l_flow_instances(i);
        debug_purge('AUDIT_DETAILS',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge SCA_FLOW_ASSOC' ;
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM SCA_FLOW_ASSOC WHERE owner_flow_id = l_flow_instances(i);
        debug_purge('SCA_FLOW_ASSOC',' purged using owner_flow_id is : ' ,write_file);
        COMMIT;
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM SCA_FLOW_ASSOC WHERE correlated_flow_id = l_flow_instances(i);
        debug_purge('SCA_FLOW_ASSOC',' purged using correlated_flow_id is : ' ,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge SCA_META_DATA' ;
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM SCA_META_DATA WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_META_DATA',null,write_file);
        COMMIT;
    END IF;

-- BPM tables also have runtime entires for HWF, so it will purged by FLOW_ID instead of QUERY_ID.

v_stmt := 'Purge BPM_MEASUREMENT_ACTIONS';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM BPM_MEASUREMENT_ACTIONS WHERE flow_id = l_flow_instances(i);
        debug_purge('BPM_MEASUREMENT_ACTIONS',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge BPM_MEASUREMENT_ACTION_EXCEPS';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM BPM_MEASUREMENT_ACTION_EXCEPS WHERE flow_id = l_flow_instances(i);
        debug_purge('BPM_MEASUREMENT_ACTION_EXCEPS',null,write_file);
        COMMIT;
    END IF;
    
v_stmt := 'Purge BPM_AUDIT_QUERY_VARVALS_EXT1';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM BPM_AUDIT_QUERY_VARVALS_EXT1 WHERE flow_id = l_flow_instances(i);
        debug_purge('BPM_AUDIT_QUERY_VARVALS_EXT1',null,write_file);
        COMMIT;
    END IF;
    
v_stmt := 'Purge BPM_AUDIT_QUERY';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
          DELETE FROM BPM_AUDIT_QUERY WHERE flow_id = l_flow_instances(i);
        debug_purge('BPM_AUDIT_QUERY',null,write_file);
        COMMIT;
    END IF;
    
-- End of BPM tables

v_stmt := 'Purge SCA_FLOW_TO_CPST';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_FLOW_TO_CPST WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_FLOW_TO_CPST',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge TEST_INSTANCE';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM TEST_INSTANCE WHERE flow_id = l_flow_instances(i);
        debug_purge('TEST_INSTANCE',null,write_file);
        COMMIT;
    END IF;

v_stmt := 'Purge SCA_FLOW_INSTANCE';
    IF cursor_flag then
        FORALL i in l_flow_instances.FIRST..l_flow_instances.LAST
           DELETE FROM SCA_FLOW_INSTANCE WHERE flow_id = l_flow_instances(i);
        debug_purge('SCA_FLOW_INSTANCE',null,write_file);
        COMMIT;
    END IF;

    cursor_flag := false;
    if l_num_rows = p_batch_size then
        cursor_flag := true;
        v_deleted := true;
    end if;
    v_counter := v_counter + 1;

    -- exit loop if out of ime
    IF (sysdate >= v_stoptime) THEN
       v_deleted := FALSE;
       CLOSE c_temp_flow_instance_thread;
       return FALSE ;
    END IF;

END LOOP;
    CLOSE c_temp_flow_instance_thread;
    return TRUE;

EXCEPTION
  when others then
    log_error(v_stmt, write_file);
    CLOSE c_temp_flow_instance_thread;
    raise;

END deleteComponentInstances;  
