/*
Rem
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/mediator/mediator_deleteComponentInstAdhoc.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/11/20 17:50:01 apfwkr Exp $
Rem
Rem mediator_deleteComponentInstAdhoc.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    DESCRIPTION
Rem
Rem
*/

PROCEDURE delete_mediator_tables_adhoc
AS

BEGIN

  DELETE from MEDIATOR_CORRELATION a where a.flow_id IN (select b.flow_id from temp_flowid_purge_glb b);
  COMMIT;

  DELETE from MEDIATOR_CALLBACK a where a.flow_id IN (select b.flow_id from temp_flowid_purge_glb b);
  COMMIT;


  DELETE FROM mediator_payload a WHERE a.owner_id in (SELECT b.dummy1 FROM temp_mediator_deferred_glb b);
  COMMIT;

  DELETE FROM mediator_payload a WHERE a.owner_id in (SELECT b.id FROM temp_mediator_resequencer_glb b);
  COMMIT;

  DELETE from mediator_resequencer_message a where a.id in (select b.id from temp_mediator_resequencer_glb b);
  COMMIT;
  
  DELETE from mediator_deferred_message a where a.msg_id in (select b.msg_id from temp_mediator_deferred_glb b);
  COMMIT;

END delete_mediator_tables_adhoc;

PROCEDURE deleteComponentInstAdhoc
AS
    v_count NUMBER default 0;

BEGIN

    EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_mediator_deferred_glb';
    EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_mediator_resequencer_glb';

    INSERT into temp_mediator_deferred_glb(msg_id,flow_id,dummy1)
      SELECT mdf.msg_id, mdf.flow_id, mdf.dummy1
        FROM mediator_deferred_message mdf, temp_flowid_purge_glb comp
       WHERE comp.flow_id = mdf.flow_id;

    v_count := SQL%ROWCOUNT;
    COMMIT;

    INSERT into temp_mediator_resequencer_glb(id,flow_id)
      SELECT mdr.id, mdr.flow_id
        FROM mediator_resequencer_message mdr, temp_flowid_purge_glb comp
       WHERE comp.flow_id = mdr.flow_id;

    v_count := v_count + SQL%ROWCOUNT;
    COMMIT;

    IF v_count > 0 then
       delete_mediator_tables_adhoc;
    END  IF;


    exception
      when others then
        rollback;
        raise;

END deleteComponentInstAdhoc;
