/*
*
* orabpel_danglingdelete.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
*
*    NAME
*      orabpel_danglingdelete.sql 
*
*
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      HEADERS_PROPERTIES
*      AG_INSTANCE
*      TEST_DETAILS
*      CUBE_SCOPE
*      CI_INDEXES
*      WORK_ITEM
*      WI_FAULT
*      DOCUMENT_DLV_MSG_REF
*      DOCUMENT_CI_REF
*      DLV_MESSAGE
*      DLV_SUBSCRIPTION
*      DLV_AGGREGATION
*      VARIABLE_SENSOR_VALUES
*      FAULT_SENSOR_VALUES
*      ACTIVITY_SENSOR_VALUES
*      CUBE_INSTANCE
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false
)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

        v_stmt := 'DELETE FROM HEADERS_PROPERTIES s WHERE s.message_guid NOT IN ' || 
                  '(SELECT DISTINCT m.message_guid FROM document_dlv_msg_ref ddmr, dlv_message m WHERE ddmr.message_guid = m.message_guid)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM AG_INSTANCE s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CREATION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM TEST_DETAILS s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time);
    
        if (purge_partitioned_component = TRUE) or (is_table_partitioned('CUBE_SCOPE','CI_PARTITION_DATE') = FALSE) then
           v_stmt := 'DELETE FROM CUBE_SCOPE s WHERE s.cikey NOT IN ' || 
                     '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
        end if;	

        v_stmt := 'DELETE FROM CI_INDEXES s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM WORK_ITEM s WHERE s.cikey NOT IN ' ||
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM WI_FAULT s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM DOCUMENT_DLV_MSG_REF s WHERE s.message_guid NOT IN ' || 
                  '(SELECT DISTINCT m.message_guid FROM dlv_message m)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.DLV_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM DOCUMENT_CI_REF s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM DLV_MESSAGE s where s.flow_id NOT IN ' || 
                  '(SELECT comp.flow_id FROM sca_flow_instance comp)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.RECEIVE_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM DLV_SUBSCRIPTION s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        v_stmt := 'DELETE FROM DLV_AGGREGATION s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.RECEIVE_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

        if (purge_partitioned_component = TRUE) or (is_table_partitioned('VARIABLE_SENSOR_VALUES','CREATION_DATE') = FALSE) then
           v_stmt := 'DELETE FROM VARIABLE_SENSOR_VALUES s WHERE s.PROCESS_INSTANCE_ID NOT IN ' || 
                     '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
        end if;

        if (purge_partitioned_component = TRUE) or (is_table_partitioned('FAULT_SENSOR_VALUES','CREATION_DATE') = FALSE) then
           v_stmt := 'DELETE FROM FAULT_SENSOR_VALUES s WHERE s.PROCESS_INSTANCE_ID NOT IN ' || 
           '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
        end if;

        if (purge_partitioned_component = TRUE) or (is_table_partitioned('ACTIVITY_SENSOR_VALUES','CREATION_DATE') = FALSE) then
           v_stmt := 'DELETE FROM ACTIVITY_SENSOR_VALUES s WHERE s.PROCESS_INSTANCE_ID NOT IN ' || 
           '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
        end if;

        IF (purge_partitioned_component = TRUE) or (is_table_partitioned('CUBE_INSTANCE','CPST_INST_CREATED_TIME') = false) then
           v_stmt := 'DELETE FROM cube_instance s WHERE s.STATE >= 5 AND s.flow_id <> -1 ' || 
           ' AND s.flow_id NOT IN (SELECT sfi.flow_id FROM sca_flow_instance sfi) ';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
        END IF;
    
END dangling_delete;
