/*
Rem
Rem
Rem Copyright (c) 2012, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      delete_instances_auto.sql 
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      11/04/20 - Backport
Rem                           apfwkr_blr_backport_31572611_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      10/19/20 - Backport apfwkr_blr_backport_31572611_12.2.1.4.0
Rem                           from main
Rem    apfwkr      07/23/20 - Backport
Rem                           apfwkr_blr_backport_31589423_12.2.1.4.200524soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      07/20/20 - Backport apfwkr_blr_backport_31589423_12.2.1.4.0
Rem                           from main
Rem    apfwkr      07/16/20 - Backport linlxu_bug-31589423_apps_1221 from
Rem                           st_pcbpel_12.2.1.0.0
Rem    apfmgr      08/17/16 - Backport
Rem                           mpottlap_bug-23092584_1221_update_purge_dlv_msg_pt_next
Rem                           from st_pcbpel_pt-next
Rem    dcraft      05/05/16 - change run_auto_purge_job to run in background
Rem                           thread
Rem    apfwkr      10/16/20 - Backport apfwkr_blr_backport_31572611_12.2.1.3.0
Rem                           from main
Rem    apfwkr      10/15/20 - Backport
Rem                           shabdull_blr_backport_31572611_12.2.1.2.0 from
Rem                           st_pcbpel_12.2.1.2.0
Rem    shabdull    07/16/20 - Backport linlxu_bug-31572611_12212 from
Rem                           st_pcbpel_12.2.1.2.0
Rem    mbousamr    09/12/12 - Created
Rem
*/

/*
* get_auto_purge_job_names
*  This procedure provides a comma separated list of database job names
*  which are valid for the label and installation.
*   eg: "job_name1,job_name2"
*/
 PROCEDURE get_auto_purge_job_names(
           job_name_list out varchar2)
        is

 begin

    job_name_list := 'DELETE_INSTANCES_AUTO_JOB1,' 
                  || 'DELETE_INSTANCES_AUTO_JOB2,'
                  || 'DELETE_INMEMORY_JOB1,'
                  || 'DELETE_AWR_JOB1,'
                  || 'DELETE_HC_JOB1,'
                  || 'DELETE_COMP_BASED_JOB1';

 end get_auto_purge_job_names;

/*
*  get_sch_name
*/
 FUNCTION get_sch_name (job_name_v in varchar2)
   return varchar2
   is

 sch_name_v varchar2(40);

 begin

   sch_name_v := null;

   if job_name_v = 'DELETE_INSTANCES_AUTO_JOB1' then
      sch_name_v := 'DELETE_INSTANCES_AUTO_SCH1';
   end if;

   if job_name_v = 'DELETE_INSTANCES_AUTO_JOB2' then
      sch_name_v := 'DELETE_INSTANCES_AUTO_SCH2';
   end if;

   if job_name_v = 'DELETE_INMEMORY_JOB1' then
      sch_name_v := 'DELETE_INMEMORY_SCH1';
   end if;

   if job_name_v = 'DELETE_COMP_BASED_JOB1' then
      sch_name_v := 'DELETE_INSTANCES_AUTO_SCH3';
   end if;

   if job_name_v = 'DELETE_AWR_JOB1' then
      sch_name_v := 'DELETE_AWR_SCH1';
   end if;

   if job_name_v = 'DELETE_HC_JOB1' then
      sch_name_v := 'DELETE_HC_SCH1';
   end if;

   return sch_name_v;

 end get_sch_name;

/*
*  get_soa_purge_type
*/
 FUNCTION get_soa_purge_type (job_name_v in varchar2)
   return varchar2
   is

 soa_purge_type varchar2(8);

 begin

   select value into soa_purge_type
     from user_scheduler_job_args
    where argument_name = 'SOA_PURGE_TYPE'
      and job_name = job_name_v;

   return soa_purge_type;

   exception
      when others then
        log_error('ERROR (get_soa_purge_type)');
        rollback;
      raise;

 end get_soa_purge_type;

/*
* set_soa_purge_type
*/
 PROCEDURE set_soa_purge_type (soa_purge_type in varchar2,
                              job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'SOA_PURGE_TYPE',
      argument_value => soa_purge_type);

    exception
      when others then
        log_error('ERROR (set_soa_purge_type)');
        rollback;
        raise;

 end set_soa_purge_type;

/*
*  get_min_creation_period_days
*/
 FUNCTION get_min_creation_period_days (job_name_v in varchar2)
  return integer
   is

 min_creation_period_days integer;

 begin

   select value
     into min_creation_period_days
     from user_scheduler_job_args
    where argument_name = 'MIN_CREATION_PERIOD_DAYS'
      and job_name = job_name_v;

   return min_creation_period_days;

   exception
      when others then
        log_error('ERROR (get_min_creation_period_days)');
        rollback;
      raise;

 end get_min_creation_period_days;


/*
* set_min_creation_period_days
*/
 PROCEDURE set_min_creation_period_days 
                (min_creation_period_days in integer,
                 job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'MIN_CREATION_PERIOD_DAYS',
      argument_value => min_creation_period_days);

    exception
      when others then
        log_error('ERROR (set_min_creation_period_days)');
        rollback;
        raise;

 end set_min_creation_period_days;


/*
*  get_max_creation_period_days
*/
 FUNCTION get_max_creation_period_days (job_name_v in varchar2)
  return integer
   is

 max_creation_period_days integer;

 begin

   select value into max_creation_period_days
     from user_scheduler_job_args
    where argument_name = 'MAX_CREATION_PERIOD_DAYS'
      and job_name = job_name_v;

   return max_creation_period_days;

   exception
      when others then
        log_error('ERROR (get_max_creation_period_days)');
        rollback;
      raise;

 end get_max_creation_period_days;

/*
* set_max_creation_period_days
*/
 PROCEDURE set_max_creation_period_days 
                            (max_creation_period_days in integer,
                             job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
       job_name => job_name_v,
       argument_name => 'MAX_CREATION_PERIOD_DAYS',
       argument_value => max_creation_period_days);

    exception
      when others then
        log_error('ERROR (set_max_creation_period_days)');
        rollback;
        raise;

 end set_max_creation_period_days;

/*
*  get_batch_size
*/
 FUNCTION get_batch_size (job_name_v in varchar2)
  return integer
   is

 batch_size integer;

 begin

   select value into batch_size
     from user_scheduler_job_args
    where argument_name = 'BATCH_SIZE'
      and job_name = job_name_v;

   return batch_size;

   exception
      when others then
        log_error('ERROR (get_batch_size)');
        rollback;
      raise;

 end get_batch_size;

/*
* set_batch_size
*/
 PROCEDURE set_batch_size (batch_size in integer,
                           job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'BATCH_SIZE',
      argument_value => batch_size);

    exception
      when others then
        log_error('ERROR (set_batch_size)');
        rollback;
        raise;

 end set_batch_size;

/*
*  get_max_runtime
*/
 FUNCTION get_max_runtime (job_name_v in varchar2)
   return integer
   is

 max_runtime integer;

 begin

   select value into max_runtime
     from user_scheduler_job_args
    where argument_name = 'MAX_RUNTIME'
      and job_name = job_name_v;

   return max_runtime;

   exception
      when others then
        log_error('ERROR (get_max_runtime)');
        rollback;
      raise;

 end get_max_runtime;

/*
* set_max_runtime
*/
 PROCEDURE set_max_runtime (max_runtime in integer,
                            job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'MAX_RUNTIME',
      argument_value => max_runtime);

    exception
      when others then
        log_error('ERROR (set_max_runtime)');
        rollback;
        raise;

 end set_max_runtime;

/*
*  get_retention_period
*/
 FUNCTION get_retention_period (job_name_v in varchar2)
   return integer
   is

 retention_period integer;

 begin

   select value into retention_period
     from user_scheduler_job_args
    where argument_name = 'RETENTION_PERIOD'
      and job_name = job_name_v;

   return retention_period;

   exception
      when others then
        log_error('ERROR (get_retention_period)');
        rollback;
      raise;

 end get_retention_period;

/*
* set_retention_period
*/
 PROCEDURE set_retention_period (retention_period in integer,
                                      job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'RETENTION_PERIOD',
      argument_value => retention_period);

    exception
      when others then
        log_error('ERROR (set_retention_period)');
        rollback;
        raise;

 end set_retention_period;

/*
*  get_retention_period_unit
*/
 FUNCTION get_retention_period_unit (job_name_v in varchar2)
  return varchar2
   is

 retention_period_unit varchar2(1);

 begin

   select value into retention_period_unit
     from user_scheduler_job_args
    where argument_name = 'RETENTION_PERIOD_UNIT'
      and job_name = job_name_v;

   return retention_period_unit;

   exception
      when others then
        log_error('ERROR (get_retention_period_unit)');
        rollback;
      raise;

 end get_retention_period_unit;


/*
*  get_purge_partitioned_cmpnt
*/
 FUNCTION get_purge_partitioned_cmpnt (job_name_v in varchar2)
  return varchar2
   is

 purge_partitioned_component varchar2(5);

 begin

   select value into purge_partitioned_component
     from user_scheduler_job_args
    where argument_name = 'PURGE_PARTITIONED_COMPONENT'
      and job_name = job_name_v;

   return purge_partitioned_component;

   exception
      when others then
        log_error('ERROR (get_purge_partitioned_component)');
        rollback;
      raise;

 end get_purge_partitioned_cmpnt;

/*
* set_purge_partitioned_cmpnt
*/
 PROCEDURE set_purge_partitioned_cmpnt (
                        purge_partitioned_component in varchar2, 
                        job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'PURGE_PARTITIONED_COMPONENT',
      argument_value => purge_partitioned_component);

    exception
      when others then
        log_error('ERROR (set_purge_partitioned_component)');
        rollback;
        raise;

 end set_purge_partitioned_cmpnt;

/*
*  get_ignore_state
*/
 FUNCTION get_ignore_state (job_name_v in varchar2)
  return varchar2
   is

 ignore_state varchar2(5);

 begin

   select value into ignore_state
     from user_scheduler_job_args
    where argument_name = 'IGNORE_STATE'
      and job_name = job_name_v;

   return ignore_state;

   exception
      when others then
        log_error('ERROR (get_ignore_state)');
        rollback;
      raise;

 end get_ignore_state;

/*
* set_ignore_state
*/
 PROCEDURE set_ignore_state (ignore_state in varchar2,
                             job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'IGNORE_STATE',
      argument_value => ignore_state);

    exception
      when others then
        log_error('ERROR (set_ignore_state)');
        rollback;
        raise;

 end set_ignore_state;

/*
*  get_PQS
*/
 FUNCTION get_PQS (job_name_v in varchar2)
  return integer
   is

 PQS integer;

 begin

   select value into PQS
     from user_scheduler_job_args
    where argument_name = 'PQS'
      and job_name = job_name_v;

   return PQS;

   exception
      when others then
        log_error('ERROR (get_PQS)');
        rollback;
      raise;

 end get_PQS;

/*
* set_PQS
*/
 PROCEDURE set_PQS (PQS in integer,
                    job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'PQS',
      argument_value => PQS);

    exception
      when others then
        log_error('ERROR (set_PQS)');
        rollback;
        raise;

 end set_PQS;

/*
*  get_DOP
*/
 FUNCTION get_DOP (job_name_v in varchar2)
  return integer
   is

 DOP integer;

 begin

   select value into DOP
     from user_scheduler_job_args
    where argument_name = 'DOP'
      and job_name = job_name_v;

   return DOP;

   exception
      when others then
        log_error('ERROR (get_DOP)');
        rollback;
      raise;

 end get_DOP;

/*
* set_DOP
*/
 PROCEDURE set_DOP (DOP in integer,
                    job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'DOP',
      argument_value => DOP);

    exception
      when others then
        log_error('ERROR (set_DOP)');
        rollback;
        raise;

 end set_DOP;

/*
*  get_max_count
*/
 FUNCTION get_max_count (job_name_v in varchar2)
  return integer
   is

 max_count integer;

 begin

   select value into max_count
     from user_scheduler_job_args
    where argument_name = 'MAX_COUNT'
      and job_name = job_name_v;

   return max_count;

   exception
      when others then
        log_error('ERROR (get_max_count)');
        rollback;
      raise;

 end get_max_count;

/*
* set_max_count
*/
 PROCEDURE set_max_count (max_count in integer,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'MAX_COUNT',
      argument_value => max_count);

    exception
      when others then
        log_error('ERROR (set_max_count)');
        rollback;
        raise;

 end set_max_count;

/*
*  get_sql_trace
*/
 FUNCTION get_sql_trace (job_name_v in varchar2)
   return varchar2
   is

 sql_trace varchar2(5);

 begin

   select value into sql_trace
     from user_scheduler_job_args
    where argument_name = 'SQL_TRACE'
      and job_name = job_name_v;

   return sql_trace;

   exception
      when others then
        log_error('ERROR (get_sql_trace)');
        rollback;
      raise;

 end get_sql_trace;

/*
* set_sql_trace
*/
 PROCEDURE set_sql_trace (sql_trace_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'SQL_TRACE',
      argument_value => sql_trace_v);

    exception
      when others then
        log_error('ERROR (set_sql_trace)');
        rollback;
        raise;

 end set_sql_trace;

/*
* set_auto_purge_job
*/
 procedure set_auto_purge_job(
           enable_v in varchar2,
           job_name_v in varchar2)
         is

 begin

   if UPPER(TRIM(enable_v)) = 'TRUE' then
      dbms_scheduler.enable(job_name_v);
   else
      dbms_scheduler.disable(job_name_v);
   end if;

 end set_auto_purge_job;

/*
* get_is_job_enabled
*/
 FUNCTION get_is_job_enabled(
          job_name_v in varchar2)
  return varchar2
   is

   enabled_v varchar2(5);

 begin

   select enabled into enabled_v
     from user_scheduler_jobs
    where job_name = job_name_v;
  
   return enabled_v;

 end get_is_job_enabled;

/*
* set_auto_purge_sch
*/
 procedure set_auto_purge_sch(
           job_name_v in varchar2,
           repeat_interval_v in varchar2,
           error_message_sch out varchar2)
       is

   sch_name_v varchar2(40);

 begin

   error_message_sch := null;
   sch_name_v := get_sch_name(UPPER(job_name_v));

   if sch_name_v = null then
      error_message_sch :=
      'ERROR Job Schedule not found when attempting to set repeat_interval;';
   else
      dbms_scheduler.set_attribute(
          name => sch_name_v,
          attribute => 'REPEAT_INTERVAL',
          value => repeat_interval_v);
   end if;

   exception
      when others then
        error_message_sch :=
        'ERROR Job Schedule cannot be modified as Repeat Interval is invalid;';

 end set_auto_purge_sch;

/*
* get_auto_purge_sch
*/
 FUNCTION get_auto_purge_sch(
          job_name_v in varchar2)
  return varchar2
   is

   sch_name_v varchar2(40);
   repeat_interval_v varchar2(1000);

 begin

   sch_name_v := get_sch_name(UPPER(job_name_v));

   select repeat_interval into repeat_interval_v
     from user_scheduler_schedules
    where schedule_name = sch_name_v;

   return repeat_interval_v;

 end get_auto_purge_sch;

/*
* run_auto_purge_job
*/
 procedure run_auto_purge_job(
           job_name_v in varchar2)
         is

 begin

   dbms_scheduler.run_job(job_name_v,false);

    exception
      when others then
        log_error('ERROR (run_auto_purge_job)');
        raise;

 end run_auto_purge_job;

/*
* set_auto_purge_params
*/
 PROCEDURE set_auto_purge_params(
           job_name in varchar2,
           enabled in varchar2,
           repeat_interval in varchar2,
           soa_purge_type in varchar2,
           min_creation_period_days in integer,
           max_creation_period_days in integer,
           batch_size in integer,
           max_runtime in integer,
           retention_period in integer,
           retention_period_unit in varchar2,
           purge_partitioned_component in varchar2,
           ignore_state in varchar2,
           PQS in integer,
           DOP in integer,
           max_count in integer,
           sql_trace in varchar2,
           error_message out varchar2)
        is

 valid_params boolean;
 retention_period_ts_v timestamp;
 retention_period_date_v date;
 min_creation_period_ts_v timestamp;
 min_creation_period_date_v date;
 max_creation_period_ts_v timestamp;
 max_creation_period_date_v date;
 error_message_sch varchar2(500);
 job_name_v varchar2(40);

 begin

/* 
validate Purge Script Paremters.
*/
    valid_params := true;
    error_message := null;
    error_message_sch := null;
   -- If a PERIOD equal -1 then DATE/TIMESTAMP default to NULL.
    retention_period_ts_v := null;
    retention_period_date_v := null;
    min_creation_period_date_v := null;
    min_creation_period_ts_v := null;
    max_creation_period_date_v := null;
    max_creation_period_ts_v := null;

    job_name_v := UPPER(TRIM(job_name));
    if job_name_v != 'DELETE_INSTANCES_AUTO_JOB1'
    and job_name_v != 'DELETE_INSTANCES_AUTO_JOB2'
    and job_name_v != 'DELETE_INMEMORY_JOB1'
    and job_name_v != 'DELETE_COMP_BASED_JOB1'
    and job_name_v != 'DELETE_AWR_JOB1'
    and job_name_v != 'DELETE_HC_JOB1' then
       valid_params  := false;
       error_message := error_message
          || ' ERROR Job Name UNKNOWN;';
    end if;

    if soa_purge_type is not null
    and upper(soa_purge_type) != 'SINGLE' 
    and upper(soa_purge_type) != 'PARALLEL' then
       valid_params  := false;
       error_message := error_message
       || ' ERROR Purge Script Type must be SINGLE or PARALLEL;';
    end if;

    if  UPPER(TRIM(retention_period_unit)) != 'D'
    and UPPER(TRIM(retention_period_unit)) != 'M' then
       valid_params  := false;
       error_message := error_message
       || ' ERROR Retention Period Unit must be D or M; ';
    end if;

    if UPPER(TRIM(retention_period_unit)) = 'D' then

       if min_creation_period_days > -1
       and max_creation_period_days > -1 then
           if min_creation_period_days < max_creation_period_days then
              valid_params  := false;
              error_message := error_message              
              || ' ERROR Minimum Creation Days must be greater than Maximum Creaton Days for proper DATE conversion; ';
           end if;
       end if;
       if min_creation_period_days < -1 
       or min_creation_period_days is NULL then
          valid_params  := false;
          error_message := error_message          
          || ' ERROR Minimum Creation Days must be >= zero (or -1 to ignore); ';
       else
          --- Equal to -1 will default to NULL for dates.
          if min_creation_period_days > -1 then
             min_creation_period_date_v :=
                to_date(to_char(sysdate,'YYYY-MM-DD'),'YYYY-MM-DD')
                   - min_creation_period_days;
             min_creation_period_ts_v :=
                to_timestamp(min_creation_period_date_v);
          end if;
       end if;
       if max_creation_period_days < -1 
       or max_creation_period_days is null then
          valid_params  := false;
          error_message := error_message          
          || ' ERROR Maximum Creation Days must be >= zero (or -1 to ignore); ';
       else
          --- Equal to -1 will default to NULL for dates.
         if max_creation_period_days > -1 then
            max_creation_period_date_v :=
               to_date(to_char(sysdate,'YYYY-MM-DD'),'YYYY-MM-DD')
                  - max_creation_period_days;
            max_creation_period_ts_v :=
               to_timestamp(max_creation_period_date_v);
         end if;
       end if;
       if min_creation_period_date_v is not null
       and max_creation_period_date_v is not null then
          if min_creation_period_date_v > max_creation_period_date_v then
             valid_params  := false;
             error_message := error_message          
             || 'ERROR Calculated Maximum Creation Date cannot be less than Minimum Creation Date; ';
          end if;
       end if;
       if retention_period < -1 
       or retention_period is null then
          valid_params  := false;
          error_message := error_message          
          || ' ERROR Retention Days must be >= zero (or -1 to ignore); ';
       else
          --- Equal to -1 will default to NULL for dates.
          if retention_period > -1 then
             retention_period_date_v :=
                to_date(to_char(sysdate,'YYYY-MM-DD'),'YYYY-MM-DD')
                   - retention_period;
             retention_period_ts_v :=
                to_timestamp(retention_period_date_v);
             if max_creation_period_date_v is not null then
                if retention_period_date_v < max_creation_period_date_v then
                   valid_params  := false;
                   error_message := error_message                   
                   || ' ERROR Calculated Retention Date cannot be less than Maximum Creation Date; ';
                end if;
             end if;
             if min_creation_period_date_v is not null then
                if retention_period_date_v < min_creation_period_date_v then
                   valid_params  := false;
                   error_message := error_message
                   || ' ERROR Calculated Retention Date cannot be less than Minimum Creation Date; ';
                end if;
             end if;
          end if;
        end if;

    end if;

    if  UPPER(TRIM(retention_period_unit)) = 'M' then
       if retention_period < 15
       or retention_period > 1439
       or retention_period is null then
          valid_params  := false;
          error_message := error_message
          || ' ERROR Inmemory Retention Minutes >= 15 AND < 1440; ';
       else
          retention_period_date_v :=
             to_date(to_char(sysdate,'YYYY-MM-DD HH24:MI:SS')
                    ,'YYYY-MM-DD HH24:MI:SS')
                   - (retention_period / 1440);
          retention_period_ts_v :=
             to_timestamp(retention_period_date_v);
       end if;
    end if;

    if batch_size < 0 then 
       valid_params  := false;
       error_message := error_message
       || ' ERROR Batch Size must be greater than zero; ';
    end if;

    if max_runtime < 0 then 
       valid_params  := false;
       error_message := error_message
       || ' ERROR Maximum run time must be greater than zero; ';
    end if;

    if purge_partitioned_component is not null 
    and UPPER(TRIM(purge_partitioned_component)) != 'TRUE'
    and UPPER(TRIM(purge_partitioned_component)) != 'FALSE' then
       valid_params  := false;
       error_message := error_message
       || ' ERROR Purge Partitioned tables must be TRUE or FALSE; ';
    end if;

    if ignore_state is not null 
    and UPPER(TRIM(ignore_state)) != 'TRUE'
    and UPPER(TRIM(ignore_state)) != 'FALSE' then
       valid_params  := false;
       error_message := error_message
       || ' ERROR Ignore State must be TRUE or FALSE; ';
    end if;

    if PQS < 0 then 
       valid_params  := false;
       error_message := error_message
       || ' ERROR Parallel Query Slaves must be greater than zero; ';
    end if;

    if DOP < 1 then  -- Minimum or maybe 4 might need to group for parallel
       valid_params  := false;
       error_message := error_message
       || ' ERROR Degree of Parallel must be greater than one; ';
    end if;

    if sql_trace is not null
    and UPPER(TRIM(sql_trace)) != 'TRUE'
    and UPPER(TRIM(sql_trace)) != 'FALSE' then
       valid_params  := false;
       error_message := error_message
       || ' ERROR SQL Trace must be TRUE or FALSE; ';
    end if;

    if max_count < 0 then
       valid_params  := false;
       error_message := error_message
       || ' ERROR Max Count must be greater than zero; ';
    end if;

/*
Validate and Set Purge Schedule paremters.
*/
    if UPPER(TRIM(enabled)) != 'TRUE'
    and UPPER(TRIM(enabled)) != 'FALSE' then
       valid_params  := false;
       error_message := error_message
       || ' ERROR Enabled Job must be TRUE or FALSE; ';
    end if;
        
    if valid_params then
       set_auto_purge_sch
          (job_name_v,repeat_interval,error_message_sch);
       if error_message_sch is not null then
          valid_params := false;
          error_message := error_message || error_message_sch;
       end if;
    end if;          

/*
Set Purge Paramters.
*/
    if valid_params then
       set_auto_purge_job(UPPER(TRIM(enabled)),job_name_v);
       set_soa_purge_type(UPPER(TRIM(soa_purge_type)),job_name_v);
       set_batch_size(batch_size,job_name_v);
       set_max_runtime(max_runtime,job_name_v);
       set_retention_period(retention_period,job_name_v);
       set_purge_partitioned_cmpnt
                (UPPER(TRIM(purge_partitioned_component)),job_name_v);
       set_ignore_state(UPPER(TRIM(ignore_state)),job_name_v);
       set_PQS(PQS,job_name_v);
       set_DOP(DOP,job_name_v);
       set_max_count(max_count,job_name_v);
       set_sql_trace(UPPER(TRIM(sql_trace)),job_name_v);
       if  UPPER(TRIM(retention_period_unit)) = 'D' then
           set_min_creation_period_days(min_creation_period_days,job_name_v);
           set_max_creation_period_days(max_creation_period_days,job_name_v);
       end if;
     end if;

 end set_auto_purge_params;

/*
* get_auto_purge_params
*/
 PROCEDURE get_auto_purge_params(
           job_name in varchar2,
           enabled out varchar2,
           repeat_interval out varchar2,
           soa_purge_type out varchar2,
           min_creation_period_days out integer,
           max_creation_period_days out integer,
           batch_size out integer,
           max_runtime out integer,
           retention_period out integer,
           retention_period_unit out varchar2,
           purge_partitioned_component out varchar2,
           ignore_state out varchar2,
           PQS out integer,
           DOP out integer,
           max_count out integer,
           sql_trace out varchar2)
        is

 job_name_v varchar2(40);

 begin

    job_name_v := UPPER(TRIM(job_name));
/*
 Get Purge Schedule parameters.
*/
    enabled := get_is_job_enabled(job_name_v);
    repeat_interval := get_auto_purge_sch(job_name_v);
/*
 Get Purge parameters.
*/
    soa_purge_type := get_soa_purge_type(job_name_v);
    min_creation_period_days := get_min_creation_period_days(job_name_v);
    max_creation_period_days := get_max_creation_period_days(job_name_v);
    batch_size := get_batch_size(job_name_v);
    max_runtime := get_max_runtime(job_name_v);
    retention_period := get_retention_period(job_name_v);
    retention_period_unit := get_retention_period_unit(job_name_v);
    purge_partitioned_component := get_purge_partitioned_cmpnt(job_name_v);
    ignore_state := get_ignore_state(job_name_v);
    PQS := get_PQS(job_name_v);
    DOP := get_DOP(job_name_v);
    max_count := get_max_count(job_name_v);
    sql_trace := get_sql_trace(job_name_v);

 end get_auto_purge_params;

/*
* delete_instances_auto
*/
 procedure delete_instances_auto (
                   soa_purge_type in varchar2,
                   min_creation_period_days in integer,
                   max_creation_period_days in integer,
                   batch_size in integer,
                   max_runtime in integer,
                   retention_period in integer,
                   purge_partitioned_component in varchar2,
                   ignore_state in varchar2,
                   PQS in integer,
                   DOP in integer,
                   max_count integer,
                   sql_trace in varchar2,
                   inmemory in varchar2,
                   retention_period_unit in varchar2,
		   compbased in varchar2
                   )
		is

     purge_partitioned_component_b boolean default false;
     ignore_state_b boolean default false;
     sql_trace_b boolean default false;
     inmemory_b boolean default false;
     valid_date_params boolean;
     retention_period_ts_v timestamp;
     retention_period_date_v date;
     inm_retention_period_ts_v timestamp;
     inm_retention_period_date_v date;
     min_creation_period_ts_v timestamp;
     min_creation_period_date_v date;
     max_creation_period_ts_v timestamp;
     max_creation_period_date_v date;
     v_stmt varchar2(500);
     compbased_b boolean default false;

  begin 

     valid_date_params := true;
   -- If a PERIOD equal -1 then DATE/TIMESTAMP default to NULL.
     retention_period_ts_v := null;
     retention_period_date_v := null;
     inm_retention_period_ts_v := null;
     inm_retention_period_date_v := null;
     min_creation_period_ts_v := null;
     min_creation_period_date_v := null;
     max_creation_period_ts_v := null;
     max_creation_period_date_v := null;

     if UPPER(TRIM(purge_partitioned_component)) = 'TRUE' then
        purge_partitioned_component_b := true;
     end if;
     if UPPER(TRIM(ignore_state)) = 'TRUE' then
        ignore_state_b := true;
     end if;
     if UPPER(TRIM(sql_trace)) = 'TRUE' then
        sql_trace_b := true;
     end if;
     if UPPER(TRIM(inmemory)) = 'TRUE' then
        inmemory_b := true;
     end if;
     if UPPER(TRIM(compbased)) = 'TRUE' then
        compbased_b := true;
     end if;

    if  UPPER(TRIM(retention_period_unit)) != 'D'
    and UPPER(TRIM(retention_period_unit)) != 'M' then
       valid_date_params  := false;
       log_info('ERROR Retention Period Unit must be D or M;');
    end if;

    if UPPER(TRIM(retention_period_unit)) = 'D' then

       if min_creation_period_days > -1
       and max_creation_period_days > -1 then
           if min_creation_period_days < max_creation_period_days then
              valid_date_params  := false;
              log_info('ERROR Minimum Creation Days must be greater than Maximum Creaton Days for proper DATE conversion;');
           end if;
       end if;
       if min_creation_period_days < -1 
       or min_creation_period_days is null then
          valid_date_params  := false;
          log_info('ERROR Minimum Creation Days must be >= zero (or -1 to ignore);');
       else
          --- Equal to -1 will default to NULL for dates.
          if min_creation_period_days > -1 then
             min_creation_period_date_v :=
                to_date(to_char(sysdate,'YYYY-MM-DD'),'YYYY-MM-DD')
                   - min_creation_period_days;
             min_creation_period_ts_v :=
                to_timestamp(min_creation_period_date_v);
          end if;
       end if;
       if max_creation_period_days < -1 
       or max_creation_period_days is null then
          valid_date_params  := false;
          log_info('ERROR Maximum Creation Days must be >= zero (or -1 to ignore);');
       else
          --- Equal to -1 will default to NULL for dates.
          if max_creation_period_days > -1 then
             max_creation_period_date_v :=
                to_date(to_char(sysdate,'YYYY-MM-DD'),'YYYY-MM-DD')
                   - max_creation_period_days;
             max_creation_period_ts_v :=
                to_timestamp(max_creation_period_date_v);
          end if;
       end if;
       if min_creation_period_date_v is not null
       and max_creation_period_date_v is not null then
          if min_creation_period_date_v > max_creation_period_date_v then
             valid_date_params  := false;
             log_info('ERROR Calculated Maximum Creation Date cannot be less than Minimum Creation Date;');
          end if;
       end if;
       if retention_period < -1 
       or retention_period is null then
          valid_date_params  := false;
          log_info('ERROR Retention Days must be >= zero (or -1 to ignore);');
       else
          --- Equal to -1 will default to NULL for dates.
          if retention_period > -1 then
             retention_period_date_v :=
                to_date(to_char(sysdate,'YYYY-MM-DD'),'YYYY-MM-DD')
                   - retention_period;
             retention_period_ts_v :=
                to_timestamp(retention_period_date_v);
             if max_creation_period_date_v is not null then
                if retention_period_date_v < max_creation_period_date_v then
                   valid_date_params  := false;
                   log_info('ERROR Calculated Retention Date cannot be less than Maximum Creation Date;');
                end if;
             end if;
             if min_creation_period_date_v is not null then
                if retention_period_date_v < min_creation_period_date_v then
                   valid_date_params  := false;
                   log_info('ERROR Calculated Retention Date cannot be less than Minimum Creation Date;');
                end if;
             end if;
         end if;
       end if;

    end if;

    if  UPPER(TRIM(retention_period_unit)) = 'M' then
       if retention_period < 15
       or retention_period > 1439
       or retention_period is null then
          valid_date_params  := false;
          log_info('ERROR Inmemory Retention Minutes >= 15 AND < 1440;');
       else
          retention_period_date_v :=
             to_date(to_char(sysdate,'YYYY-MM-DD HH24:MI:SS')
                    ,'YYYY-MM-DD HH24:MI:SS')
                - (retention_period / 1440);
          retention_period_ts_v :=
             to_timestamp(retention_period_date_v);
       end if;
    end if;

     log_info('min_creation_date => '
      ||TO_CHAR(min_creation_period_ts_v,'DD/MON/YYYY:HH24/MI'));
     log_info('max_creation_date => '
      ||TO_CHAR(max_creation_period_ts_v,'DD/MON/YYYY:HH24/MI'));
     log_info('batch_size => '|| batch_size);
     log_info('max_runtime => '|| max_runtime);
     log_info('retention_period => '
       ||TO_CHAR(retention_period_ts_v,'DD/MON/YYYY:HH24/MI')); 
     log_info('retention_period_unit => '||retention_period_unit);
     log_info('DOP => '||DOP);
     log_info('max_count => '||max_count);
     log_info('inmemory  => '||inmemory);
     log_info('compbased  => '||compbased);
    
-- This has to be backward compatible..... it isn't.. ensure defaults. 
     if UPPER(TRIM(soa_purge_type)) = 'SINGLE' 
     and valid_date_params then
        soa.delete_instances (
                 min_creation_date => min_creation_period_ts_v,
                 max_creation_date => max_creation_period_ts_v,
                 batch_size => batch_size,
                 max_runtime => max_runtime,
                 retention_period => retention_period_ts_v,
                 purge_partitioned_component => purge_partitioned_component_b,
                 composite_name => null,
                 composite_revision => null,
                 soa_partition_name => null,
                 ignore_state => ignore_state_b,
                 PQS => PQS,
                 sql_trace => sql_trace_b,
                 inmemory => inmemory_b,
		 compbased => compbased_b
                 );
     end if;

     if UPPER(TRIM(soa_purge_type)) = 'PARALLEL'
     and valid_date_params then
        soa.delete_instances_in_parallel (
                 min_creation_date => min_creation_period_ts_v,
                 max_creation_date => max_creation_period_ts_v,
                 batch_size => batch_size,
                 max_runtime => max_runtime,
                 retention_period => retention_period_ts_v,
                 DOP => DOP,
                 max_count => max_count,
                 purge_partitioned_component => purge_partitioned_component_b,
                 composite_name => null,
                 composite_revision => null,
                 soa_partition_name => null,
                 ignore_state => ignore_state_b,
                 PQS => PQS,
                 sql_trace => sql_trace_b,
                 inmemory => inmemory_b,
		 compbased => compbased_b
                 );         
     end if;

  end delete_instances_auto;
