SET LINESIZE 128
Rem
Rem
Rem Copyright (c) 2010, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     purge_soa_oracle.sql - Fabric purge script 
Rem
Rem
Rem    DESCRIPTION
Rem     This script is used to purge all non-running, non-recovery-required 
Rem      composite instances based on a given time range
Rem

BEGIN
  
  IF table_exist('SOA_PURGE_LOG') = false THEN
    EXECUTE IMMEDIATE 'CREATE TABLE SOA_PURGE_LOG (LOG_DATE TIMESTAMP, PURGE_LOG varchar2(2000))';
  END IF;
  IF table_exist('JOB_FLOW_CONTROL') THEN
    EXECUTE IMMEDIATE 'DROP TABLE JOB_FLOW_CONTROL';
  END IF;
  IF table_exist('SOA_PURGE_HISTORY') THEN
    EXECUTE IMMEDIATE 'DROP TABLE SOA_PURGE_HISTORY';
  END IF;
  IF seq_exist('SOA_PURGE_SEQ') THEN
    EXECUTE IMMEDIATE 'DROP SEQUENCE SOA_PURGE_SEQ';
  END IF;
  IF table_exist('SOA_PURGE_ALERT') THEN
    EXECUTE IMMEDIATE 'DROP TABLE SOA_PURGE_ALERT';
  END IF;

  EXECUTE IMMEDIATE 
          'CREATE TABLE job_flow_control(job_thread number)';
 
  EXECUTE IMMEDIATE 
      'CREATE SEQUENCE SOA_PURGE_SEQ INCREMENT BY 1 START WITH 1';

  EXECUTE IMMEDIATE 
      'CREATE TABLE SOA_PURGE_HISTORY (
JOB_NO NUMBER,
START_TIME TIMESTAMP,
END_TIME TIMESTAMP,
TYPE VARCHAR2(1),
THREAD NUMBER,
STATUS VARCHAR(1)
)';

  EXECUTE IMMEDIATE 
      'CREATE TABLE SOA_PURGE_ALERT (
TABLE_NAME VARCHAR2(30),
NUM_ROWS_THRESHOLD NUMBER,
NUM_ROWS NUMBER,
SEG_SIZE_MB_THRESHOLD NUMBER,
SEG_SIZE_MB NUMBER
)';

  EXECUTE IMMEDIATE 
'insert into soa_purge_alert
(table_name,num_rows_threshold,num_rows,seg_size_mb_threshold,seg_size_mb)
values (''SCA_FLOW_INSTANCE'',100000,0,1000,0)';

  EXECUTE IMMEDIATE 
'insert into soa_purge_alert
(table_name,num_rows_threshold,num_rows,seg_size_mb_threshold,seg_size_mb)
values (''CUBE_INSTANCE'',100000,0,1000,0)';

  EXECUTE IMMEDIATE 
'insert into soa_purge_alert
(table_name,num_rows_threshold,num_rows,seg_size_mb_threshold,seg_size_mb)
values (''WFTASK'',100000,0,1000,0)';

  EXECUTE IMMEDIATE 
'insert into soa_purge_alert
(table_name,num_rows_threshold,num_rows,seg_size_mb_threshold,seg_size_mb)
values (''BRDECISIONINSTANCE'',100000,0,1000,0)';

  COMMIT;

END;
/

create or replace package soa as

      PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false);

      procedure delete_instances_auto (
                   soa_purge_type in varchar2,
                   min_creation_period_days in integer,
                   max_creation_period_days in integer,
                   batch_size in integer,
                   max_runtime in integer,
                   retention_period in integer,
                   purge_partitioned_component in varchar2,
                   ignore_state in varchar2,
                   PQS in integer,
                   DOP in integer,
                   max_count integer,
                   sql_trace in varchar2,
                   inmemory in varchar2,
                   retention_period_unit in varchar2,
                   compbased in varchar2
                   );

      procedure delete_instances ( min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer default 20000,
                   max_runtime in integer default 60,
                   retention_period in timestamp default null,
                   purge_partitioned_component in boolean default false,
                   composite_name in  varchar2 default null,
                   composite_revision in varchar2 default null,
                   soa_partition_name in varchar2 default null,
                   ignore_state in boolean default false,
                   PQS in integer default 1,
                   sql_trace IN boolean default false,
                   inmemory IN boolean default false,
                   compbased IN boolean default false
                   );


	procedure delete_instances_in_parallel (
                   min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer default 20000,
                   max_runtime in integer default 60,
                   retention_period in timestamp default null,
                   DOP in integer default 4,
                   max_count integer default 1000000,
                   purge_partitioned_component in boolean default false,
                   composite_name in  varchar2 default null,
                   composite_revision in varchar2 default null,
                   soa_partition_name in varchar2 default null,
                   ignore_state in boolean default false,
                   PQS in integer default 1,
                   sql_trace IN boolean default false,
                   inmemory IN boolean default false,
		   compbased IN boolean default false
                            );           

	procedure delete_insts_in_parallel_job(DOP in number,
                                          thread_num in number,
                                          batch_size in number,
                                          p_stoptime in varchar2,
                                          purge_partitioned_component in char,
                                          sql_trace IN varchar2,
                                          soa_purge_job_no in number
                                          );                            

        procedure delete_instances_adhoc (v_flowid_purge in varchar2);


  	procedure delete_instances_alert (
                            alert_num_row varchar2 default 'true',
                            alert_seg_size varchar2 default 'true'
                            );

-- Alert Procedures
-- ----------------

 PROCEDURE set_purge_alert_threshold (
                   table_name_v in varchar2 default null,
                   num_rows_threshold_v in integer default 0,
                   seg_size_mb_threshold_v in integer default 0);
     
 PROCEDURE set_alert_job_params (
                alert_row_num_v in varchar2 default 'true',
                alert_seg_size_mb_v in varchar2 default 'true');
        
 PROCEDURE set_alert_purge_job(
              enable_job in varchar2 default 'true',
              job_name_v in varchar2 default 'delete_instances_alert_job');
        
 PROCEDURE check_purge_alert_threshold (
                table_name_v in varchar2 default null,
                threshold_days in integer default 0,
                threshold_alert out varchar2);

-- Auto Enable Procedures
-- ----------------------

 PROCEDURE get_auto_purge_job_names(
           job_name_list out varchar2);

 PROCEDURE set_auto_purge_params(
           job_name in varchar2,
           enabled in varchar2,
           repeat_interval in varchar2,
           soa_purge_type in varchar2,
           min_creation_period_days in integer,
           max_creation_period_days in integer,
           batch_size in integer,
           max_runtime in integer,
           retention_period in integer,
           retention_period_unit in varchar2,
           purge_partitioned_component in varchar2,
           ignore_state in varchar2,
           PQS in integer,
           DOP in integer,
           max_count in integer,
           sql_trace in varchar2,
           error_message out varchar2);

 PROCEDURE get_auto_purge_params(
           job_name in varchar2,
           enabled out varchar2,
           repeat_interval out varchar2,
           soa_purge_type out varchar2,
           min_creation_period_days out integer,
           max_creation_period_days out integer,
           batch_size out integer,
           max_runtime out integer,
           retention_period out integer,
           retention_period_unit out varchar2,
           purge_partitioned_component out varchar2,
           ignore_state out varchar2,
           PQS out integer,
           DOP out integer,
           max_count out integer,
           sql_trace out varchar2);

 PROCEDURE set_auto_purge_job(
           enable_v in varchar2,
           job_name_v in varchar2);

 PROCEDURE set_auto_purge_sch(
           job_name_v in varchar2,
           repeat_interval_v in varchar2,
           error_message_sch out varchar2);

 PROCEDURE run_auto_purge_job(
           job_name_v in varchar2);

 FUNCTION get_auto_purge_sch(
          job_name_v in varchar2)
          return varchar2;

 FUNCTION get_is_job_enabled(
          job_name_v in varchar2)
          return varchar2;

-- osb purge function
-- ---------------------------------
 PROCEDURE deleteOSBResequencerInstances(
              p_batch_size NUMBER DEFAULT 20000,
              p_min_creation_date IN TIMESTAMP,
              p_max_creation_date IN TIMESTAMP);

PROCEDURE abortcompositeinstances (
        min_creation_date             IN   TIMESTAMP,
        max_creation_date             IN   TIMESTAMP,
	flow_ids                      IN   VARCHAR2 DEFAULT NULL,   
        batch_size                    IN   INTEGER DEFAULT 20000,
        max_runtime                   IN   INTEGER DEFAULT 1200,
	--instance_id                   IN   VARCHAR2,
        retention_period              IN   TIMESTAMP DEFAULT NULL,       
        composite_name                IN   VARCHAR2 DEFAULT NULL,
        composite_revision            IN   VARCHAR2 DEFAULT NULL,
	ec_id                         IN   VARCHAR2 DEFAULT NULL,
        soa_partition_name            IN   VARCHAR2 DEFAULT NULL,
        composite_state               IN   VARCHAR2 DEFAULT NULL,
        update_retention              IN   BOOLEAN DEFAULT true,		
        sql_trace 		      IN   BOOLEAN DEFAULT false--fine
 );	


end soa;
/

create or replace package body soa as
  @@delete_instances.sql
  @@delete_instances_auto.sql
  @@delete_instances_alert.sql
  @@delete_insts_in_parallel_job.sql
  @@delete_instances_in_parallel.sql
  @@delete_instances_adhoc.sql
  @@delete_instances_wrapper.sql
end soa; 
/
show errors;

