/*
Rem
Rem wf_deleteCompositeInstances.sql
Rem
Rem Copyright (c) 2010, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      wf_deleteCompositeInstances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Workflow purge
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr       01/19/23 - CI# 34996638 of
Rem    apfwkr       01/19/23 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr       01/19/23 - from st_pcbpel_12.2.1.4.0soabp.
Rem    apfwkr       01/19/23 - CI# 34996638
Rem    apfwkr       01/19/23 - apfwkr_ci_backport_33323056_12.2.1.4.0soabp
Rem    apfwkr       12/08/22 - BLR# 34874653 of jbahadur_bug-33323056_1221 .
Rem    apfwkr       12/08/22 - BLR# 34874653
Rem    apfwkr       12/08/22 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr       12/08/22 - from main
Rem    vumapath     08/06/10 - XbranchMerge vumapath_bug-9872950_ps3_main from
Rem                            main
Rem    wstallar     07/16/10 - Addressing performance concerns
Rem    hdoddi       07/16/10 - XbranchMerge hdoddi_bug-9846252_ps3 from main
Rem    vumapath     06/25/10 - Purge task attachments
Rem    hdoddi       07/02/10 - Adding commit statments bug 9846252
Rem    vsvetov      05/04/10 - add support when ecid is null
Rem    vsvetov      04/28/10 - creation
Rem
*/

PROCEDURE truncate_temp_tables
AS
BEGIN
   log_info('workflow.truncate_temp_tables');
  --before starting clean up temp tables
  EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_wftask_purge';
END truncate_temp_tables;



PROCEDURE delete_workflow_instances(write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN
--  purge of workflow data
--  first, purge each child-table in turn, as there are performance concerns
--  with relying on FK cascade deletes...

    log_info_both('workflow.delete_workflow_instances begins',write_file);

    log_info_both('Purging WFTask_TL',write_file);
    v_stmt := 'Purge WFTask_TL';
    DELETE FROM WFTask_TL WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTask_TL',v_stmt,write_file);
    COMMIT;

    log_info_both('Purging WFTaskHistory',write_file);
    v_stmt := 'Purge WFTaskHistory';
    DELETE FROM WFTaskHistory WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTaskHistory',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFTaskHistory_TL',write_file);
    v_stmt := 'Purge WFTaskHistory_TL';
    DELETE FROM WFTaskHistory_TL WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTaskHistory_TL',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFComments',write_file);
    v_stmt := 'Purge WFComments';
    DELETE FROM WFComments WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFComments',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFMessageAttribute',write_file);
    v_stmt := 'Purge WFMessageAttribute';
    DELETE FROM WFMessageAttribute WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFMessageAttribute',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFAttachment',write_file);
    v_stmt := 'Purge WFAttachment';
    DELETE FROM WFAttachment WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFAttachment',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFAssignee',write_file);
    v_stmt := 'Purge WFAssignee';
    DELETE FROM WFAssignee WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFAssignee',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFReviewer',write_file);
    v_stmt := 'Purge WFReviewer';
    DELETE FROM WFReviewer WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFReviewer',v_stmt,write_file);
    COMMIT;

    log_info_both('Purging WFCollectionTarget',write_file);
    v_stmt := 'Purge WFCollectionTarget';
    DELETE FROM WFCollectionTarget WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFCollectionTarget',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFRoutingSlip',write_file);
    v_stmt := 'Purge WFRoutingSlip';
    DELETE FROM WFRoutingSlip WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFRoutingSlip',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFNotification',write_file);
    v_stmt := 'Purge WFNotification' ;
    DELETE FROM WFNotification WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFNotification',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFTaskTimer',write_file);
    v_stmt := 'Purge WFTaskTimer';
    DELETE FROM WFTaskTimer WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTaskTimer',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFTaskError',write_file);
    v_stmt := 'Purge WFTaskError';
    DELETE FROM WFTaskError WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTaskError',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFHeaderProps',write_file);
    v_stmt := 'Purge WFHeaderProps';
    DELETE FROM WFHeaderProps WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFHeaderProps',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFEvidence',write_file);
    v_stmt := 'Purge  WFEvidence';
    DELETE FROM WFEvidence WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFEvidence',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFTaskAssignmentStatistic',write_file);
    v_stmt := 'Purge WFTaskAssignmentStatistic';
    DELETE FROM WFTaskAssignmentStatistic WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTaskAssignmentStatistic',v_stmt,write_file);
    COMMIT;
    
    log_info_both('Purging WFTaskAggregation',write_file);
    v_stmt := 'Purge WFTaskAggregation';
    DELETE FROM WFTaskAggregation WHERE rootTaskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp);
    debug_purge_both('WFTaskAggregation',v_stmt,write_file);
    COMMIT;

-- Now purge main task table
    log_info_both('Purging WFTask',write_file);
    v_stmt := 'Purge WFTask';
    DELETE FROM  WFTask WHERE taskId in (SELECT twfp.taskId FROM temp_wftask_purge twfp); 
    debug_purge_both('WFTask',v_stmt,write_file);
    COMMIT;

    log_info_both('workflow.delete_workflow_instances ends',write_file);

EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;
END delete_workflow_instances;
 
PROCEDURE deleteComponentInstances(p_id_table   IN VARCHAR2,
                         write_file in utl_file.file_type default null)
AS
    v_stmt  VARCHAR2(2000);
    v_count NUMBER;
BEGIN
 
    truncate_temp_tables();
    log_info_both('workflow.deleteComponentInstance begins',write_file);
    v_stmt := 'INSERT INTO temp_wftask_purge(taskId,flow_id) ' ||
              'SELECT task.taskId,task.flow_id ' ||
              '  FROM WFTask task, '||p_id_table || ' comp ' ||
              ' WHERE task.flow_id = comp.flow_id';

    EXECUTE IMMEDIATE v_stmt;
    COMMIT;
    debug_purge_both('temp_wftask_purge', 'workflow.deleteComponentInstance Inserted = ',write_file);

    delete_workflow_instances(write_file);
    log_info_both('workflow.deleteComponentInstance ends',write_file);


EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;
END deleteComponentInstances;

FUNCTION abortComponentInstances(lookupcompquery IN VARCHAR2 , batch_size IN INTEGER, cmpst_name IN VARCHAR2,max_runtime IN INTEGER) RETURN INTEGER AS
	
	batch_total_count   INTEGER := 0;	
	common_abort_query VARCHAR2(4000);
BEGIN
	--work flow started 
		common_abort_query := 'UPDATE wftask SET   state = ''STALE'' WHERE  state IS NOT NULL AND state NOT IN (''ERRORED'', ''STALE'', ''WITHDRAWN'', ''EXPIRED'')  AND flow_id IN (SELECT cmpt.flow_id FROM sca_flow_instance cmpt WHERE ' || lookupcompquery || ')' ;	
		batch_total_count := batch_update_func(common_abort_query, batch_size, max_runtime);
		COMMIT;
		dbms_output.put_line('Number of work flow entries marked aborted = ' || batch_total_count);		
		
		common_abort_query := 'UPDATE WFTaskHistory SET   state =''STALE'' WHERE  state IS NOT NULL AND state NOT IN (''ERRORED'', ''STALE'', ''WITHDRAWN'', ''EXPIRED'') AND flow_id IN (SELECT cmpt.flow_id FROM sca_flow_instance cmpt WHERE ' || lookupcompquery || ')' ;	
		batch_total_count := batch_update_func(common_abort_query, batch_size, max_runtime);
		COMMIT;
		dbms_output.put_line('Number of WFTaskHistory entries marked aborted = ' || batch_total_count);			
        --work flow Finished   
   
    RETURN batch_total_count;
EXCEPTION
    WHEN OTHERS THEN
        RETURN -1;
END abortComponentInstances;

