/*
*
*
* hwf_pruneOpenFlowIDs.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
*
*    NAME
*      hwf_pruneOpenFlowIDs.sql - HWF prune open FlowID sql
*
*
*    DESCRIPTION
*     This script is used to prune a list of composite instance ids passed in 
*     an idTable. BPEL uses following criteria to identify a non-purgeable instance :
*     - wf state is not in 'DELETED','ERRORED','EXPIRED','STALE','WITHDRAWN'                       
*     Parameters:
*     p_id_table : this is the temp table with purge able composite instance ids
*     p_prune_table : Add to this table the open instances
*
*/
PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

  IF p_prune_table IS NOT NULL THEN 
     v_stmt := ' INSERT INTO '                   || p_prune_table ||                
               ' SELECT DISTINCT comp.flow_id    '           || 
               '   FROM WFTask task, '           || p_id_table ||' comp ' ||
               '  WHERE task.flow_id = comp.flow_id '  ||                    
               '     AND (( task.componenttype = ''Workflow''' ||
               '         AND task.state IS NOT NULL ' || 
               '         AND task.state NOT IN (''DELETED'',''ERRORED'',''EXPIRED'',''STALE'',''WITHDRAWN''))'||
               '      OR ( task.componenttype = ''BPMN'''||
               '         AND task.state IS NOT NULL '||
               '         AND task.state NOT IN ( ''DELETED'',''ERRORED'',''EXPIRED'',''STALE'',''WITHDRAWN'',''ABORTED'') '||
               '))';

     execute immediate v_stmt;
     debug_purge_both
        (p_prune_table, 'Workflow inserts into prune table = ',write_file);
     COMMIT;
  END IF;

EXCEPTION
  when others then
    log_error(v_stmt,write_file);
    raise;

END pruneOpenFlowIDs;

