Rem
Rem $Header: pcbpel/admin/sqlutils12/soa_purge/oracle/workflow/purge_hwf_oracle.sql /st_pcbpel_12.2.1.4.0soabp/6 2023/01/28 03:34:49 apfwkr Exp $
Rem
Rem purge_workflow_oracle.sql
Rem
Rem Copyright (c) 2010, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_workflow_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Purges workflow related tables
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      01/19/23 - CI# 34996638 of
Rem    apfwkr      01/19/23 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr      01/19/23 - from st_pcbpel_12.2.1.4.0soabp.
Rem    apfwkr      01/19/23 - CI# 34996638
Rem    apfwkr      01/19/23 - apfwkr_ci_backport_33323056_12.2.1.4.0soabp
Rem    apfwkr      12/08/22 - BLR# 34874653 of jbahadur_bug-33323056_1221 .
Rem    apfwkr      12/08/22 - BLR# 34874653
Rem    apfwkr      12/08/22 - apfwkr_blr_backport_33323056_12.2.1.4.220827soabp
Rem    apfwkr      12/08/22 - from main
Rem    apfwkr      11/04/20 - Backport
Rem                           apfwkr_blr_backport_31572611_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      10/19/20 - Backport apfwkr_blr_backport_31572611_12.2.1.4.0
Rem                           from main
Rem    apfwkr      07/23/20 - Backport
Rem                           apfwkr_blr_backport_31589423_12.2.1.4.200524soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    apfwkr      07/20/20 - Backport apfwkr_blr_backport_31589423_12.2.1.4.0
Rem                           from main
Rem    apfwkr      07/16/20 - Backport linlxu_bug-31589423_apps_1221 from
Rem                           st_pcbpel_12.2.1.0.0
Rem    shabdull    12/17/19 - Backport apfwkr_blr_backport_30374610_12.2.1.1.0
Rem                           from st_pcbpel_12.2.1.1.0
Rem    apfwkr      11/20/19 - Backport linlxu_bug-30374610_12212-main from main
Rem    apfwkr      10/28/19 - Backport linlxu_bug-30374610_12212-main from main
Rem    apfwkr      10/16/20 - Backport apfwkr_blr_backport_31572611_12.2.1.3.0
Rem                           from main
Rem    apfwkr      10/15/20 - Backport
Rem                           shabdull_blr_backport_31572611_12.2.1.2.0 from
Rem                           st_pcbpel_12.2.1.2.0
Rem    shabdull    07/16/20 - Backport linlxu_bug-31572611_12212 from
Rem                           st_pcbpel_12.2.1.2.0
Rem    vsvetov     05/04/10 - creation
Rem

--First drop temp table before procceding with creation
BEGIN
  IF table_exist('TEMP_WFTASK_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_wftask_purge';
  END IF;
  IF table_exist('TEMP_WFTASK_PURGE_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_wftask_purge_glb';
  END IF;
  -- Create temporary tables
  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_WFTASK_PURGE
(
taskId VARCHAR2(64), 
flow_id INTEGER default ''0''
)';
  EXECUTE IMMEDIATE 'CREATE GLOBAL TEMPORARY TABLE TEMP_WFTASK_PURGE_GLB
(
taskId VARCHAR2(64), 
flow_id INTEGER default ''0''
) on commit preserve rows';

END;
/
--show errors;
CREATE OR REPLACE PACKAGE soa_workflow 
AS

PROCEDURE deleteComponentInstances ( p_id_table IN VARCHAR2,
                                write_file in utl_file.file_type default null);

PROCEDURE pruneOpenFlowIDs ( p_id_table    IN VARCHAR2,
                      p_prune_table IN VARCHAR2,
                      write_file in utl_file.file_type default null);
                      
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false);
                      
PROCEDURE createTempTables(p_id_table IN VARCHAR2,
                           write_file in utl_file.file_type default null);

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER,
                           p_batch_size NUMBER default 20000,
                           p_stop_time DATE default NULL,
                           write_file utl_file.file_type default null) 
RETURN BOOLEAN;

PROCEDURE deleteComponentInstAdhoc;

FUNCTION isComponentPartitioned RETURN BOOLEAN;
FUNCTION abortComponentInstances(lookupcompquery IN VARCHAR2 , batch_size IN INTEGER, cmpst_name IN VARCHAR2,max_runtime IN INTEGER) RETURN INTEGER;

END soa_workflow;
/

CREATE OR REPLACE PACKAGE BODY soa_workflow 
AS
@@hwf_pruneOpenFlowIDs.sql
@@hwf_danglingdelete.sql
@@hwf_deleteComponentInstances.sql
@@hwf_deleteComponentInstancesDOP.sql
@@hwf_deleteComponentInstAdhoc.sql
@@hwf_isComponentPartitioned.sql
@@hwf_createTempTables.sql
END soa_workflow;
/
--show errors;

