Rem
Rem $Header: pcbpel/admin/sqlutils12/upgrade/oracle/cache_util.sql /st_pcbpel_12.2.1.4.0soabp/1 2024/02/23 15:12:57 apfwkr Exp $
Rem
Rem cache_util.sql
Rem
Rem Copyright (c) 2023, 2024, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      cache_util.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: pcbpel/admin/sqlutils12/upgrade/oracle/cache_util.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    linlxu      12/04/23 - Created
Rem

CREATE OR REPLACE PACKAGE cache_util AS
TYPE sca_entity_subtype_type IS TABLE OF sca_entity.sub_type%TYPE;
PROCEDURE get_cache_query_type_1_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE,
sca_entity_id OUT sca_entity.id%TYPE);

PROCEDURE get_db_query_type_1_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN   sca_entity.revision%TYPE,
sca_entity_id OUT sca_entity.id%TYPE);

PROCEDURE get_cache_query_type_2_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE,
sca_entity_subtype_list OUT sca_entity_subtype_type);

PROCEDURE get_db_query_type_2_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN   sca_entity.revision%TYPE,
sca_entity_subtype_list OUT  sca_entity_subtype_type);

PROCEDURE get_cache_query_type_3_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE, name IN sca_entity.name%TYPE,
sca_entity_id  OUT  sca_entity.id%TYPE);

PROCEDURE get_db_query_type_3_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN   sca_entity.revision%TYPE, name IN sca_entity.name%TYPE,
sca_entity_id  OUT  sca_entity.id%TYPE);

PROCEDURE get_cache_query_type_4_output (name IN sca_partition.name%TYPE, 
sca_partition_id  OUT  sca_partition.id%TYPE);

PROCEDURE get_db_query_type_4_output (name IN sca_partition.name%TYPE,
sca_partition_id OUT  sca_partition.id%TYPE);

END cache_util;
/
SHOW ERRORS

CREATE OR REPLACE PACKAGE BODY cache_util AS

TYPE sca_entity_type IS TABLE OF sca_entity.id%TYPE INDEX BY VARCHAR2(500);
TYPE sca_partition_type IS TABLE OF sca_partition.id%TYPE INDEX BY VARCHAR2(500);
TYPE sca_entity_subtype_list_type IS TABLE OF sca_entity_subtype_type INDEX BY VARCHAR2(500);

-- query_type_1 = SELECT ID FROM SCA_ENTITY WHERE SCA_PARTITION_ID = :B3 
--                AND COMPOSITE = :B2 AND REVISION = :B1 AND TYPE='composite
se_cache_query_type_1  sca_entity_type;
-- query_type_2 = SELECT SUB_TYPE FROM SCA_ENTITY WHERE COMPOSITE = :B3 
--                AND SCA_PARTITION_ID = :B2 AND REVISION = :B1 AND SUB_TYPE IS NOT NULL
se_cache_query_type_2  sca_entity_subtype_list_type; 
-- query_type_3 = SELECT ID FROM SCA_ENTITY WHERE SCA_PARTITION_ID = :B4 AND COMPOSITE = :B3
--                AND REVISION = :B2 AND NAME = REGEXP_SUBSTR(:B1 , '[^/]*$') AND STATE =
--                'active' AND TYPE = 'component' AND SUB_TYPE = 'implementation.mediator'
se_cache_query_type_3 sca_entity_type;

-- query_type_4 = SELECT ID FROM SCA_PARTITION WHERE NAME = :B1
se_cache_query_type_4 sca_partition_type;

-- -----------------------------------------------------------------
PROCEDURE get_cache_query_type_1_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE,
sca_entity_id  OUT  sca_entity.id%TYPE) AS
-- -----------------------------------------------------------------
se_key varchar2(1000);
BEGIN
  se_key := ''||partition_id || '#' || composite || '#' || revision;
  sca_entity_id := se_cache_query_type_1(se_key);
EXCEPTION
WHEN NO_DATA_FOUND THEN
  sca_entity_id := NULL;
  get_db_query_type_1_output(partition_id, composite, revision, sca_entity_id);
  se_cache_query_type_1(se_key) := sca_entity_id;
END get_cache_query_type_1_output;

-- -----------------------------------------------------------------
PROCEDURE get_db_query_type_1_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE,
sca_entity_id OUT sca_entity.id%TYPE) AS
-- ----------------------------------------------------------------
se_key VARCHAR2(500);
se_query VARCHAR2 (2000);
BEGIN
    se_key := ''||partition_id || '#' || composite || '#' || revision;
    --dbms_output.put_line('[get_cache_query_type_1_output][db]key::' || se_key);
    se_query := 'SELECT ID FROM SCA_ENTITY WHERE SCA_PARTITION_ID = ' || partition_id || 
    ' AND COMPOSITE = ''' || composite || ''' AND REVISION = ''' || revision || ''' AND TYPE = ''composite''';
    EXECUTE IMMEDIATE se_query into sca_entity_id;
EXCEPTION
WHEN NO_DATA_FOUND THEN
  --dbms_output.put_line('[get_db_query_type_1_output][db] no records found for key::' || se_key);
  sca_entity_id := NULL;
END get_db_query_type_1_output;
-- -----------------------------------------------------------------

-- -----------------------------------------------------------------
PROCEDURE get_cache_query_type_2_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE,
sca_entity_subtype_list OUT  sca_entity_subtype_type) AS
-- -----------------------------------------------------------------
se_key varchar2(500);
BEGIN
  se_key := ''||partition_id || '#' || composite || '#' || revision;
  sca_entity_subtype_list := se_cache_query_type_2(se_key);
  --DBMS_OUTPUT.PUT_LINE('[get_cache_query_type_2_output][cache]sub_type.count::' ||sca_entity_subtype_list.COUNT);
EXCEPTION
WHEN NO_DATA_FOUND THEN
  sca_entity_subtype_list := NULL;
  get_db_query_type_2_output(partition_id, composite, revision, sca_entity_subtype_list);
  se_cache_query_type_2(se_key) := sca_entity_subtype_list;
END get_cache_query_type_2_output;

-- -----------------------------------------------------------------
PROCEDURE get_db_query_type_2_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN   sca_entity.revision%TYPE,
sca_entity_subtype_list OUT  sca_entity_subtype_type) AS
-- ----------------------------------------------------------------
se_key VARCHAR2(500);
se_query VARCHAR2 (2000);

BEGIN
    se_key := ''||partition_id || '#' || composite || '#' || revision;
    --dbms_output.put_line('[get_cache_query_type_1_output][db]key::' || se_key);
    se_query := 'SELECT SUB_TYPE FROM SCA_ENTITY WHERE SCA_PARTITION_ID = ' || partition_id || 
    ' AND COMPOSITE = ''' || composite || ''' AND REVISION = ''' || revision || ''' AND SUB_TYPE IS NOT NULL';
    EXECUTE IMMEDIATE se_query BULK COLLECT INTO sca_entity_subtype_list;
    --DBMS_OUTPUT.PUT_LINE('[get_cache_query_type_2_output][db]sub_type.count::' ||sca_entity_subtype_list.COUNT);
EXCEPTION
WHEN NO_DATA_FOUND THEN
  --dbms_output.put_line('[get_db_query_type_2_output][db] no records found for key::' || se_key);
  sca_entity_subtype_list := NULL;
END get_db_query_type_2_output;
-- -----------------------------------------------------------------

-- -----------------------------------------------------------------
PROCEDURE get_cache_query_type_3_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN sca_entity.revision%TYPE, name IN sca_entity.name%TYPE,
sca_entity_id  OUT  sca_entity.id%TYPE) AS
-- -----------------------------------------------------------------
se_key varchar2(500);
BEGIN
  se_key := ''||partition_id || '#' || composite || '#' || revision || '#' || name;
  sca_entity_id := se_cache_query_type_3(se_key);
EXCEPTION
WHEN NO_DATA_FOUND THEN
  sca_entity_id := NULL;
  get_db_query_type_3_output(partition_id, composite, revision, name, sca_entity_id);
  se_cache_query_type_3(se_key) := sca_entity_id;
END get_cache_query_type_3_output;

-- -----------------------------------------------------------------
PROCEDURE get_db_query_type_3_output (partition_id IN sca_entity.sca_partition_id%TYPE,
composite IN sca_entity.composite%TYPE, revision IN   sca_entity.revision%TYPE, name IN sca_entity.name%TYPE,
sca_entity_id OUT  sca_entity.id%TYPE) AS
-- ----------------------------------------------------------------
se_key VARCHAR2(500);
se_query VARCHAR2 (2000);
BEGIN
    se_key := ''||partition_id || '#' || composite || '#' || revision || '#' || name;
    --dbms_output.put_line('[get_cache_query_type_3_output][db]key::' || se_key);
    se_query := 'SELECT ID  FROM SCA_ENTITY WHERE SCA_PARTITION_ID = ' || partition_id || 
    ' AND COMPOSITE = ''' || composite || ''' AND REVISION = ''' || revision || 
    ''' AND NAME = REGEXP_SUBSTR(''' || name || ''', ''[^/]*$'') AND STATE = 
    ''active'' AND TYPE = ''component'' AND SUB_TYPE = ''implementation.mediator''';
    EXECUTE IMMEDIATE se_query into sca_entity_id;
EXCEPTION
WHEN NO_DATA_FOUND THEN
  --dbms_output.put_line('[get_db_query_type_3_output][db] no records found for key::' || se_key);
  sca_entity_id := NULL;
END get_db_query_type_3_output;
-- -----------------------------------------------------------------

-- -----------------------------------------------------------------
PROCEDURE get_cache_query_type_4_output (name IN sca_partition.name%TYPE, sca_partition_id  OUT  sca_partition.id%TYPE) AS
-- -----------------------------------------------------------------
se_key varchar2(500);
BEGIN
  if name IS NOT NULL then
     se_key := name;
  else
     se_key := '#null#';
  end if;
  sca_partition_id := se_cache_query_type_4(se_key);
EXCEPTION
WHEN NO_DATA_FOUND THEN
  sca_partition_id := NULL;
  get_db_query_type_4_output(name, sca_partition_id);
  se_cache_query_type_4(se_key) := sca_partition_id;
END get_cache_query_type_4_output;

-- -----------------------------------------------------------------
PROCEDURE get_db_query_type_4_output (name IN sca_partition.name%TYPE,
sca_partition_id OUT  sca_partition.id%TYPE) AS
-- ----------------------------------------------------------------
se_key VARCHAR2(500);
se_query VARCHAR2 (2000);
BEGIN
    se_key := name;
    --dbms_output.put_line('[get_cache_query_type_4_output][db]key::' || se_key);
    if name is NOT NULL then
      se_query := 'SELECT ID FROM SCA_PARTITION WHERE NAME = ''' || name || '''';
      EXECUTE IMMEDIATE se_query into sca_partition_id;
    else 
      -- name is null so there is only one partition entry
      se_query := 'SELECT ID FROM SCA_PARTITION WHERE rownum = 1';
      EXECUTE IMMEDIATE se_query into sca_partition_id;
    end if;
EXCEPTION
WHEN NO_DATA_FOUND THEN
  --dbms_output.put_line('[get_db_query_type_4_output][db] no records found for key::' || se_key);
  sca_partition_id := NULL;
END get_db_query_type_4_output;
-- -----------------------------------------------------------------

END cache_util;
/
SHOW ERRORS
