Rem
Rem $Header: pcbpel/admin/sqlutils12/upgrade/oracle/soa_migrate_control.sql /st_pcbpel_12.2.1.4.0soabp/1 2024/02/23 15:12:57 apfwkr Exp $
Rem
Rem soa_migrate_control.sql
Rem
Rem Copyright (c) 2013, 2024, Oracle and/or its affiliates.
Rem All rights reserved.
Rem
Rem    NAME
Rem      soa_migrate_control.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      02/22/24 - CI# 36329889 of
Rem    apfwkr      02/22/24 - linlxu_blr_backport_33808201_12.2.1.4.230827soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem    linlxu      12/04/23 - BLR# 36073346 of
Rem    linlxu      12/04/23 - linlxu_bug-36044643_1221_12.2.1.4.230827 from
Rem    linlxu      12/04/23 - st_pcbpel_12.2.1.4.0soabp.
Rem    linlxu      12/04/23 - BLR# 36073346
Rem                           linlxu_blr_backport_33808201_12.2.1.4.230827soabp
Rem    mbousamr    11/10/13 - Created
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: pcbpel/admin/sqlutils12/upgrade/oracle/soa_migrate_control.sql 
Rem    SQL_SHIPPED_FILE: 
Rem    SQL_PHASE: 
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: 
Rem    END SQL_FILE_METADATA

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

create or replace package control_migration as

 PROCEDURE control_migration_main (
           batch_size in integer default 10000,
           max_count in integer default 100000,
           ctl_max_runtime in integer default 240,
           job_max_runtime in integer default 240,
           DOP in integer default 1,
           metadata_job_complete in varchar2 default 'FALSE',
           data_job_complete in varchar2 default 'FALSE',
           open_ecids_complete in varchar2 default 'FALSE',
           first_time in varchar2 default 'TRUE',
           first_ctl_max_runtime in integer default 30,
           first_job_max_runtime in integer default 0,
           sql_trace in varchar2 default 'FALSE',
           metrics in varchar2 default 'TRUE',
           async in varchar2 default 'TRUE');

 PROCEDURE submit_migration_jobs (
           is_migrate_metadata_reqd in varchar2,
           is_migrate_data_reqd in varchar2,
           open_ecids_complete in varchar2,
           batch_size in integer,
           max_count in integer,
           stoptime_v in varchar2,
           DOP in integer,
           sql_trace in varchar2,
           metrics in varchar2,
           first_time in varchar2,
           async in varchar2);

 FUNCTION get_batch_size (job_name_v in varchar2)
  return integer;

 PROCEDURE set_batch_size (batch_size in integer,
                           job_name_v in varchar2);

 FUNCTION get_ctl_max_runtime (job_name_v in varchar2)
   return integer;

 PROCEDURE set_ctl_max_runtime (ctl_max_runtime in integer,
                            job_name_v in varchar2);

 FUNCTION get_job_max_runtime (job_name_v in varchar2)
   return integer;

 PROCEDURE set_job_max_runtime (job_max_runtime in integer,
                            job_name_v in varchar2);

 FUNCTION get_max_count (job_name_v in varchar2)
  return integer;

 PROCEDURE set_max_count (max_count in integer,
                           job_name_v in varchar2);

 FUNCTION get_DOP (job_name_v in varchar2)
  return integer;

 PROCEDURE set_DOP (DOP in integer,
                    job_name_v in varchar2);

 FUNCTION get_thread (job_name_v in varchar2)
  return integer;

 PROCEDURE set_thread (thread in integer,
                    job_name_v in varchar2);

 FUNCTION get_metadata_job_complete (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_metadata_job_complete (metadata_job_complete_v in varchar2,
                          job_name_v in varchar2);

 FUNCTION get_data_job_complete (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_data_job_complete (data_job_complete_v in varchar2,
                          job_name_v in varchar2);

 FUNCTION get_open_ecids_complete (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_open_ecids_complete (open_ecids_complete_v in varchar2,
                          job_name_v in varchar2);

 FUNCTION get_first_time (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_first_time (first_time_v in varchar2,
                          job_name_v in varchar2);

 FUNCTION get_first_ctl_max_runtime (job_name_v in varchar2)
   return integer;

 PROCEDURE set_first_ctl_max_runtime (first_ctl_max_runtime in integer,
                            job_name_v in varchar2);

 FUNCTION get_first_job_max_runtime (job_name_v in varchar2)
   return integer;

 PROCEDURE set_first_job_max_runtime (first_job_max_runtime in integer,
                            job_name_v in varchar2);

 FUNCTION get_sql_trace (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_sql_trace (sql_trace_v in varchar2,
                          job_name_v in varchar2);

 FUNCTION get_metrics (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_metrics (metrics_v in varchar2,
                          job_name_v in varchar2);

 FUNCTION get_async (job_name_v in varchar2)
   return varchar2;

 PROCEDURE set_async (async_v in varchar2,
                    job_name_v in varchar2);

 procedure set_control_migration_job(
           enable_v in varchar2,
           job_name_v in varchar2);

 FUNCTION get_is_migration_enabled(
          job_name_v in varchar2)
  return varchar2;

 procedure set_control_migration_sch(
           job_name_v in varchar2,
           repeat_interval_v in varchar2,
           error_message_sch out varchar2);

 FUNCTION get_control_migration_sch(
          job_name_v in varchar2)
  return varchar2;

 PROCEDURE inject_stop_migration;

 procedure upgrade_status_info (status out varchar2);

 TYPE upgrade_progress_log_rec_type is record (
        RUN number,
        CREATION_DATE timestamp,
        MODULE varchar2(40),
        MSG_TYPE varchar2(5),
        REMAINING number,
        UPG_COMMENT varchar2(80));

 end control_migration;

/
show errors;

create or replace package body control_migration as

 PROCEDURE  insert_upgrade_progress_log(
    upgrade_progress_log_rec in upgrade_progress_log_rec_type
                   )
   is

  error_no number;
  run_currval number;
  RUN_v number;
  CREATION_DATE_v timestamp;
  MODULE_v varchar(40);
  MSG_TYPE_v varchar(5);
  REMAINING_v number;
  UPG_COMMENT_v varchar2(80);

 begin

     error_no := 0;
     MSG_TYPE_v := upgrade_progress_log_rec.msg_type;
     IF MSG_TYPE_V != 'SEQ' THEN
        select remaining into run_currval 
          from  upgrade_progress_log
         where  msg_type='SEQ';
     END IF;
     RUN_V := run_currval;
     CREATION_DATE_v := systimestamp;
     MODULE_v := upgrade_progress_log_rec.module;
     UPG_COMMENT_v := upgrade_progress_log_rec.upg_comment;
     REMAINING_v :=  upgrade_progress_log_rec.remaining;

     BEGIN
       insert into upgrade_progress_log
       (
        RUN, CREATION_DATE, MODULE, MSG_TYPE, REMAINING, UPG_COMMENT
       )
        VALUES
      (
       RUN_V, CREATION_DATE_v, MODULE_v, MSG_TYPE_v, REMAINING_v, UPG_COMMENT_v
      );
      commit;

      EXCEPTION
        when others then
            error_no := -1;

     END;

     IF error_no = -1 THEN
        log_debug('ERROR within insert_upgrade_progress_log ');
     ELSE
        log_debug('insert_upgrade_progress_log RUN: ' || RUN_V 
         || ', creation_date: ' || CREATION_DATE_v ||  ', module : ' 
         || MODULE_v || ', msg_type : ' || MSG_TYPE_v || ', remaining : ' 
         || REMAINING_v || ', comment : ' || UPG_COMMENT_v);
     END IF;

 end insert_upgrade_progress_log;

 PROCEDURE  insert_upgrade_progress_info(
             module varchar2,
             upg_comment varchar2)
  is

  upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

    log_debug(upg_comment);   
    upgrade_progress_log_rec.msg_type := 'INFO';
    upgrade_progress_log_rec.module := module;
    upgrade_progress_log_rec.remaining := 0;
    upgrade_progress_log_rec.upg_comment := upg_comment;
    insert_upgrade_progress_log(upgrade_progress_log_rec);

 end insert_upgrade_progress_info;

 PROCEDURE  insert_upgrade_progress_parm(
             module varchar2,
             upg_comment varchar2)
  is

  upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

    log_debug(upg_comment);
    upgrade_progress_log_rec.msg_type := 'PARM';
    upgrade_progress_log_rec.module := module;
    upgrade_progress_log_rec.remaining := 0;
    upgrade_progress_log_rec.upg_comment := upg_comment;
    insert_upgrade_progress_log(upgrade_progress_log_rec);

 end insert_upgrade_progress_parm;

 PROCEDURE  insert_upgrade_progress_stat(
             module varchar2,
             upg_comment varchar2,
             remaining number)
  is

  upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

    log_debug(upg_comment);
    upgrade_progress_log_rec.msg_type := 'STAT';
    upgrade_progress_log_rec.module := module;
    upgrade_progress_log_rec.remaining := remaining;
    upgrade_progress_log_rec.upg_comment := upg_comment;
    insert_upgrade_progress_log(upgrade_progress_log_rec);

 end insert_upgrade_progress_stat;

 PROCEDURE  update_upgrade_progress_seq(
             module varchar2,
             upg_comment varchar2,
             remaining_v number)
  is

  begin

    log_debug('UPDATE SEQ in UPGRADE_PROGRESS_LOG');
    UPDATE UPGRADE_PROGRESS_LOG
      SET  remaining = remaining_v 
    WHERE  MSG_TYPE = 'SEQ';

 end update_upgrade_progress_seq;

/*
*  get_sch_name
*/
 FUNCTION get_sch_name (job_name_v in varchar2)
   return varchar2
   is

 sch_name_v varchar2(40);

 begin

   sch_name_v := null;

   if job_name_v = 'CONTROL_MIGRATION_MAIN_JOB' then
      sch_name_v := 'CONTROL_MIGRATION_MAIN_SCH';
   end if;

   return sch_name_v;

 end get_sch_name;

/*
*  get_batch_size
*/
 FUNCTION get_batch_size (job_name_v in varchar2)
  return integer
   is

 batch_size integer;

 begin

   select value into batch_size
     from user_scheduler_job_args
    where argument_name = 'BATCH_SIZE'
      and job_name = job_name_v;

   return batch_size;

   exception
      when others then
        log_error('ERROR (get_batch_size)');
        rollback;
      raise;

 end get_batch_size;

/*
* set_batch_size
*/
 PROCEDURE set_batch_size (batch_size in integer,
                           job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'BATCH_SIZE',
      argument_value => batch_size);

    exception
      when others then
        log_error('ERROR (set_batch_size)');
        rollback;
        raise;

 end set_batch_size;

/*
*  get_ctl_max_runtime
*/
 FUNCTION get_ctl_max_runtime (job_name_v in varchar2)
   return integer
   is

 ctl_max_runtime integer;

 begin

   select value into ctl_max_runtime
     from user_scheduler_job_args
    where argument_name = 'CTL_MAX_RUNTIME'
      and job_name = job_name_v;

   return ctl_max_runtime;

   exception
      when others then
        log_error('ERROR (get_ctl_max_runtime)');
        rollback;
      raise;

 end get_ctl_max_runtime;

/*
* set_ctl_max_runtime
*/
 PROCEDURE set_ctl_max_runtime (ctl_max_runtime in integer,
                            job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'CTL_MAX_RUNTIME',
      argument_value => ctl_max_runtime);

    exception
      when others then
        log_error('ERROR (set_ctl_max_runtime)');
        rollback;
        raise;

 end set_ctl_max_runtime;

/*
*  get_first_ctl_max_runtime
*/
 FUNCTION get_first_ctl_max_runtime (job_name_v in varchar2)
   return integer
   is

 first_ctl_max_runtime integer;

 begin

   select value into first_ctl_max_runtime
     from user_scheduler_job_args
    where argument_name = 'FIRST_CTL_MAX_RUNTIME'
      and job_name = job_name_v;

   return first_ctl_max_runtime;

   exception
      when others then
        log_error('ERROR (get_first_ctl_max_runtime)');
        rollback;
      raise;

 end get_first_ctl_max_runtime;

/*
* set_first_ctl_max_runtime
*/
 PROCEDURE set_first_ctl_max_runtime (first_ctl_max_runtime in integer,
                            job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'FIRST_CTL_MAX_RUNTIME',
      argument_value => first_ctl_max_runtime);

    exception
      when others then
        log_error('ERROR (set_first_ctl_max_runtime)');
        rollback;
        raise;

 end set_first_ctl_max_runtime;

/*
*  get_first_job_max_runtime
*/
 FUNCTION get_first_job_max_runtime (job_name_v in varchar2)
   return integer
   is

 first_job_max_runtime integer;

 begin

   select value into first_job_max_runtime
     from user_scheduler_job_args
    where argument_name = 'FIRST_JOB_MAX_RUNTIME'
      and job_name = job_name_v;

   return first_job_max_runtime;

   exception
      when others then
        log_error('ERROR (get_first_job_max_runtime)');
        rollback;
      raise;

 end get_first_job_max_runtime;

/*
* set_first_job_max_runtime
*/
 PROCEDURE set_first_job_max_runtime (first_job_max_runtime in integer,
                            job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'FIRST_JOB_MAX_RUNTIME',
      argument_value => first_job_max_runtime);

    exception
      when others then
        log_error('ERROR (set_first_job_max_runtime)');
        rollback;
        raise;

 end set_first_job_max_runtime;


/*
*  get_job_max_runtime
*/
 FUNCTION get_job_max_runtime (job_name_v in varchar2)
   return integer
   is

 job_max_runtime integer;

 begin

   select value into job_max_runtime
     from user_scheduler_job_args
    where argument_name = 'JOB_MAX_RUNTIME'
      and job_name = job_name_v;

   return job_max_runtime;

   exception
      when others then
        log_error('ERROR (get_job_max_runtime)');
        rollback;
      raise;

 end get_job_max_runtime;

/*
* set_job_max_runtime
*/
 PROCEDURE set_job_max_runtime (job_max_runtime in integer,
                            job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'JOB_MAX_RUNTIME',
      argument_value => job_max_runtime);

    exception
      when others then
        log_error('ERROR (set_job_max_runtime)');
        rollback;
        raise;

 end set_job_max_runtime;

/*
*  get_max_count
*/
 FUNCTION get_max_count (job_name_v in varchar2)
  return integer
   is

 max_count integer;

 begin

   select value into max_count
     from user_scheduler_job_args
    where argument_name = 'MAX_COUNT'
      and job_name = job_name_v;

   return max_count;

   exception
      when others then
        log_error('ERROR (get_max_count)');
        rollback;
      raise;

 end get_max_count;

/*
* set_max_count
*/
 PROCEDURE set_max_count (max_count in integer,
                           job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'MAX_COUNT',
      argument_value => max_count);

    exception
      when others then
        log_error('ERROR (set_max_count)');
        rollback;
        raise;

 end set_max_count;

/*
*  get_DOP
*/
 FUNCTION get_DOP (job_name_v in varchar2)
  return integer
   is

 DOP integer;

 begin

   select value into DOP
     from user_scheduler_job_args
    where argument_name = 'DOP'
      and job_name = job_name_v;

   return DOP;

   exception
      when others then
        log_error('ERROR (get_DOP)');
        rollback;
      raise;

 end get_DOP;

/*
* set_DOP
*/
 PROCEDURE set_DOP (DOP in integer,
                    job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'DOP',
      argument_value => DOP);

    exception
      when others then
        log_error('ERROR (set_DOP)');
        rollback;
        raise;

 end set_DOP;

/*
*  get_thread
*/
 FUNCTION get_thread (job_name_v in varchar2)
  return integer
   is

 thread integer;

 begin

   select value into thread
     from user_scheduler_job_args
    where argument_name = 'THREAD'
      and job_name = job_name_v;

   return thread;

   exception
      when others then
        log_error('ERROR (get_thread)');
        rollback;
      raise;

 end get_thread;

/*
* set_thread
*/
 PROCEDURE set_thread (thread in integer,
                    job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'THREAD',
      argument_value => thread);

    exception
      when others then
        log_error('ERROR (set_thread)');
        rollback;
        raise;

 end set_thread;


/*
*  get_metadata_job_complete
*/
 FUNCTION get_metadata_job_complete (job_name_v in varchar2)
   return varchar2
   is

 metadata_job_complete varchar2(5);

 begin

   select value into metadata_job_complete
     from user_scheduler_job_args
    where argument_name = 'METADATA_JOB_COMPLETE'
      and job_name = job_name_v;

   return metadata_job_complete;

   exception
      when others then
        log_error('ERROR (get_metadata_job_complete)');
        rollback;
      raise;

 end get_metadata_job_complete;

/*
* set_metadata_job_complete
*/
 PROCEDURE set_metadata_job_complete (metadata_job_complete_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'METADATA_JOB_COMPLETE',
      argument_value => metadata_job_complete_v);

    exception
      when others then
        log_error('ERROR (set_metadata_job_complete)');
        rollback;
        raise;

 end set_metadata_job_complete;

/*
*  get_data_job_complete
*/
 FUNCTION get_data_job_complete (job_name_v in varchar2)
   return varchar2
   is

 data_job_complete varchar2(5);

 begin

   select value into data_job_complete
     from user_scheduler_job_args
    where argument_name = 'DATA_JOB_COMPLETE'
      and job_name = job_name_v;

   return data_job_complete;

   exception
      when others then
        log_error('ERROR (get_data_job_complete)');
        rollback;
      raise;

 end get_data_job_complete;

/*
* set_data_job_complete
*/
 PROCEDURE set_data_job_complete (data_job_complete_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'DATA_JOB_COMPLETE',
      argument_value => data_job_complete_v);

    exception
      when others then
        log_error('ERROR (set_data_job_complete)');
        rollback;
        raise;

 end set_data_job_complete;

/*
*  get_open_ecids_complete
*/
 FUNCTION get_open_ecids_complete (job_name_v in varchar2)
   return varchar2
   is

 open_ecids_complete varchar2(5);

 begin

   select value into open_ecids_complete
     from user_scheduler_job_args
    where argument_name = 'OPEN_ECIDS_COMPLETE'
      and job_name = job_name_v;

   return open_ecids_complete;

   exception
      when others then
        log_error('ERROR (get_open_ecids_complete)');
        rollback;
      raise;

 end get_open_ecids_complete;

/*
* set_open_ecids_complete
*/
 PROCEDURE set_open_ecids_complete (open_ecids_complete_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'OPEN_ECIDS_COMPLETE',
      argument_value => open_ecids_complete_v);

    exception
      when others then
        log_error('ERROR (set_open_ecids_complete)');
        rollback;
        raise;

 end set_open_ecids_complete;

/*
*  get_first_time
*/
 FUNCTION get_first_time (job_name_v in varchar2)
   return varchar2
   is

 first_time varchar2(5);

 begin

   select value into first_time
     from user_scheduler_job_args
    where argument_name = 'FIRST_TIME'
      and job_name = job_name_v;

   return first_time;

   exception
      when others then
        log_error('ERROR (get_first_time)');
        rollback;
      raise;

 end get_first_time;

/*
* set_first_time
*/
 PROCEDURE set_first_time (first_time_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'FIRST_TIME',
      argument_value => first_time_v);

    exception
      when others then
        log_error('ERROR (set_first_time)');
        rollback;
        raise;

 end set_first_time;

/*
*  get_is_migrate_metadata_reqd
*/
 FUNCTION get_is_migrate_metadata_reqd (job_name_v in varchar2)
   return varchar2
   is

 is_migrate_metadata_reqd varchar2(5);

 begin

   select value into is_migrate_metadata_reqd
     from user_scheduler_job_args
    where argument_name = 'IS_MIGRATE_METADATA_REQD'
      and job_name = job_name_v;

   return is_migrate_metadata_reqd;

   exception
      when others then
        log_error('ERROR (get_is_migrate_metadata_reqd)');
        rollback;
      raise;

 end get_is_migrate_metadata_reqd;

/*
* set_is_migrate_metadata_reqd
*/
 PROCEDURE set_is_migrate_metadata_reqd 
             (is_migrate_metadata_reqd_v in varchar2,
              job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'IS_MIGRATE_METADATA_REQD',
      argument_value => is_migrate_metadata_reqd_v);

    exception
      when others then
        log_error('ERROR (set_is_migrate_metadata_reqd)');
        rollback;
        raise;

 end set_is_migrate_metadata_reqd;

/*
*  get_is_migrate_data_reqd
*/
 FUNCTION get_is_migrate_data_reqd (job_name_v in varchar2)
   return varchar2
   is

 is_migrate_data_reqd varchar2(5);

 begin

   select value into is_migrate_data_reqd
     from user_scheduler_job_args
    where argument_name = 'IS_MIGRATE_DATA_REQD'
      and job_name = job_name_v;

   return is_migrate_data_reqd;

   exception
      when others then
        log_error('ERROR (get_is_migrate_data_reqd)');
        rollback;
      raise;

 end get_is_migrate_data_reqd;

/*
* set_is_migrate_data_reqd
*/
 PROCEDURE set_is_migrate_data_reqd
             (is_migrate_data_reqd_v in varchar2,
              job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'IS_MIGRATE_DATA_REQD',
      argument_value => is_migrate_data_reqd_v);

    exception
      when others then
        log_error('ERROR (set_is_migrate_data_reqd)');
        rollback;
        raise;

 end set_is_migrate_data_reqd;

/*
*  get_stoptime
*/
 FUNCTION get_stoptime (job_name_v in varchar2)
   return varchar2
   is

 stoptime varchar2(100);

 begin

   select value into stoptime
     from user_scheduler_job_args
    where argument_name = 'STOPTIME_V'
      and job_name = job_name_v;

   return stoptime;

   exception
      when others then
        log_error('ERROR (get_stoptime)');
        rollback;
      raise;

 end get_stoptime;

/*
* set_stoptime
*/
 PROCEDURE set_stoptime (stoptime_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'STOPTIME_V',
      argument_value => stoptime_v);

    exception
      when others then
        log_error('ERROR (set_stoptime)');
        rollback;
        raise;

 end set_stoptime;

/*
*  get_sql_trace
*/
 FUNCTION get_sql_trace (job_name_v in varchar2)
   return varchar2
   is

 sql_trace varchar2(5);

 begin

   select value into sql_trace
     from user_scheduler_job_args
    where argument_name = 'SQL_TRACE'
      and job_name = job_name_v;

   return sql_trace;

   exception
      when others then
        log_error('ERROR (get_sql_trace)');
        rollback;
      raise;

 end get_sql_trace;

/*
* set_sql_trace
*/
 PROCEDURE set_sql_trace (sql_trace_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'SQL_TRACE',
      argument_value => sql_trace_v);

    exception
      when others then
        log_error('ERROR (set_sql_trace)');
        rollback;
        raise;

 end set_sql_trace;

/*
*  get_metrics
*/
 FUNCTION get_metrics (job_name_v in varchar2)
   return varchar2
   is

 metrics varchar2(5);

 begin

   select value into metrics
     from user_scheduler_job_args
    where argument_name = 'METRICS'
      and job_name = job_name_v;

   return metrics;

   exception
      when others then
        log_error('ERROR (get_metrics)');
        rollback;
      raise;

 end get_metrics;

/*
* set_metrics
*/
 PROCEDURE set_metrics (metrics_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'METRICS',
      argument_value => metrics_v);

    exception
      when others then
        log_error('ERROR (set_metrics)');
        rollback;
        raise;

 end set_metrics;

/*
*  get_async
*/
 FUNCTION get_async (job_name_v in varchar2)
   return varchar2
   is

 async varchar2(5);

 begin

   select value into async
     from user_scheduler_job_args
    where argument_name = 'ASYNC'
      and job_name = job_name_v;

   return async;

   exception
      when others then
        log_error('ERROR (get_async)');
        rollback;
      raise;

 end get_async;

/*
* set_async
*/
 PROCEDURE set_async (async_v in varchar2,
                          job_name_v in varchar2)
        is

 begin

    dbms_scheduler.set_job_argument_value(
      job_name => job_name_v,
      argument_name => 'ASYNC',
      argument_value => async_v);

    exception
      when others then
        log_error('ERROR (set_async)');
        rollback;
        raise;

 end set_async;

/*
* set_migration_control_job
*/
 procedure set_control_migration_job(
           enable_v in varchar2,
           job_name_v in varchar2)
         is

 begin

   if UPPER(TRIM(enable_v)) = 'TRUE' then
      dbms_scheduler.enable(job_name_v);
   else
      dbms_scheduler.disable(job_name_v);
   end if;

 end set_control_migration_job;

/*
* get_is_migration_enabled
*/
 FUNCTION get_is_migration_enabled(
          job_name_v in varchar2)
  return varchar2
   is

   enabled_v varchar2(5);

 begin

   select enabled into enabled_v
     from user_scheduler_jobs
    where job_name = job_name_v;

   return enabled_v;

 end get_is_migration_enabled;

/*
* set_control_migration_sch
*/
 procedure set_control_migration_sch(
           job_name_v in varchar2,
           repeat_interval_v in varchar2,
           error_message_sch out varchar2)
       is

   sch_name_v varchar2(40);

 begin

   error_message_sch := null;
   sch_name_v := get_sch_name(UPPER(job_name_v));

   if sch_name_v is NULL then
      error_message_sch :=
      'ERROR Job Schedule not found when attempting to set repeat_interval;';
   else
      dbms_scheduler.set_attribute(
          name => sch_name_v,
          attribute => 'REPEAT_INTERVAL',
          value => repeat_interval_v);
   end if;
   exception
      when others then
        error_message_sch :=
        'ERROR Job Schedule cannot be modified as Repeat Interval is invalid;';

 end set_control_migration_sch;

/*
* get_control_migration_sch
*/
 FUNCTION get_control_migration_sch(
          job_name_v in varchar2)
  return varchar2
   is

   sch_name_v varchar2(40);
   repeat_interval_v varchar2(1000);

 begin

   sch_name_v := get_sch_name(UPPER(job_name_v));

   select repeat_interval into repeat_interval_v
     from user_scheduler_schedules
    where schedule_name = sch_name_v;

   return repeat_interval_v;

 end get_control_migration_sch;

 FUNCTION is_fa_env return boolean as
    schema_name varchar2(128);
    begin
      SELECT sys_context('USERENV', 'CURRENT_SCHEMA') into schema_name FROM DUAL;
      if UPPER(TRIM(schema_name)) = 'FA_FUSION_SOAINFRA' then
         return true;
      end if;
      return false;
 end is_fa_env;


/*
*  is_migrate_running
*/
 FUNCTION is_migrate_running
   return boolean
   is

    CURSOR c_gvsession is
    select inst_id, sid, serial#
     from gv$session
    where action = 'SOAUPGRADEEXECUTING'
      and schemaname in
    (SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM DUAL);

    session_found boolean := FALSE;
    loop_count number := 0;

  begin

   loop_count := 0;
   session_found := FALSE;

-- Allow upto 20seconds for the job to come back on run queue.
   WHILE loop_count < 20
     AND session_found = FALSE
    LOOP
      FOR gvsess_rec in c_gvsession
      LOOP
        session_found := TRUE;
      END LOOP;
    DBMS_LOCK.sleep(seconds => 1);
    loop_count := loop_count + 1;
   END LOOP;

   RETURN session_found;

  end is_migrate_running;

/*
*  is_migrate_metadata_running
*/
 FUNCTION is_migrate_metadata_running
   return boolean
   is

    CURSOR c_gvsession is
    select inst_id, sid, serial#
     from gv$session
    where module = 'SOAUPGRADEMETADATA'
      and action = 'SOAUPGRADEEXECUTING'
      and schemaname in
    (SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM DUAL);

    session_found boolean := FALSE;
    loop_count number := 0;
    open_metadata_complete_v varchar2(5) := null;
    job_name_v varchar2(40) := null;

  begin

/*
* Check if metadata complete flag already set.
*/
   open_metadata_complete_v := null;
   job_name_v := 'CONTROL_MIGRATION_MAIN_JOB';
   open_metadata_complete_v := get_metadata_job_complete(job_name_v);
   IF UPPER(TRIM(open_metadata_complete_v)) = 'TRUE' THEN
      RETURN FALSE;
   END IF;

   loop_count := 0;
   session_found := FALSE;

-- Allow upto 20seconds for the job to come back on run queue.
   WHILE loop_count < 20
     AND session_found = FALSE
    LOOP
      FOR gvsess_rec in c_gvsession
      LOOP
        session_found := TRUE;
      END LOOP;
    DBMS_LOCK.sleep(seconds => 1);
    loop_count := loop_count + 1;
   END LOOP;

   RETURN session_found;

  end is_migrate_metadata_running;

/*
*  is_migrate_data_running
*/
 FUNCTION is_migrate_data_running
   return boolean
   is

    CURSOR c_gvsession is
    select inst_id, sid, serial#
     from gv$session
    where module like 'SOAUPGRADEDATA%'
      and action = 'SOAUPGRADEEXECUTING'
      and schemaname in
    (SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM DUAL);

    session_found boolean := FALSE;
    loop_count number := 0;

  begin

   loop_count := 0;
   session_found := FALSE;

-- Allow upto 20seconds for the job to come back on run queue.
   WHILE loop_count < 20
     AND session_found = FALSE
    LOOP
      FOR gvsess_rec in c_gvsession
      LOOP
        session_found := TRUE;
      END LOOP;
    DBMS_LOCK.sleep(seconds => 1);
    loop_count := loop_count + 1;
   END LOOP;

   RETURN session_found;

  end is_migrate_data_running;

/*
*  is_submission_running
*/
 FUNCTION is_submission_running
   return boolean
   is

    CURSOR c_gvsession is
    select inst_id, sid, serial#
     from gv$session
    where module = 'SOAUPGRADESUBMITJOBS'
      and action = 'SOAUPGRADEEXECUTING'
      and schemaname in
    (SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM DUAL);

    session_found boolean := FALSE;
    loop_count number := 0;

  begin

   loop_count := 0;
   session_found := FALSE;

-- Allow upto 20seconds for the job to come back on run queue.
   WHILE loop_count < 20
     AND session_found = FALSE
    LOOP
      FOR gvsess_rec in c_gvsession
      LOOP
        session_found := TRUE;
      END LOOP;
    DBMS_LOCK.sleep(seconds => 1);
    loop_count := loop_count + 1;
   END LOOP;

   RETURN session_found;

  end is_submission_running;

/*
*  is_soapurge_running
*/
 FUNCTION is_soapurge_running
   return boolean
   is

    CURSOR c_gvsession is
    select inst_id, sid, serial#
     from gv$session
    where action = 'SOAPURGEEXECUTING'
      and schemaname in
    (SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM DUAL);

    session_found boolean := FALSE;
    loop_count number := 0;

  begin

   loop_count := 0;
   session_found := FALSE;

-- Allow upto 20seconds for the job to come back on run queue.
   WHILE loop_count < 20
     AND session_found = FALSE
    LOOP
      FOR gvsess_rec in c_gvsession
      LOOP
        session_found := TRUE;
      END LOOP;
    DBMS_LOCK.sleep(seconds => 1);
    loop_count := loop_count + 1;
   END LOOP;

   RETURN session_found;

  end is_soapurge_running;

/*
* inject_stop_migration
*/
 PROCEDURE inject_stop_migration
        is

 begin

    update upgrade_injection set value = 'TRUE'
     where parm = 'STOP';
    commit;

    DBMS_LOCK.sleep(seconds => 30);

    exception
      when others then
        log_error('ERROR (inject_stop_migration)');
        rollback;
        raise;

 end inject_stop_migration;

/*
* is_middletier_up
*/
 FUNCTION is_middletier_up
  return boolean
   is

  upgrade_date_v timestamp := NULL;
  middletier_up boolean := FALSE;

 begin

  upgrade_date_v := NULL;
  FOR v_rec in (select soa_upgrade_date from version)
    LOOP
      upgrade_date_v := v_rec.soa_upgrade_date;
  END LOOP;

  middletier_up := FALSE;
  IF upgrade_date_v is not NULL 
   THEN
     FOR v_rec in (select last_update from cluster_node)
      LOOP

        IF v_rec.last_update >= upgrade_date_v then
           middletier_up := TRUE;
        END IF;

     END LOOP;
  END IF;

  RETURN middletier_up;

 end is_middletier_up;

/*
* is_open_ecids_complete
*/
 FUNCTION is_open_ecids_complete(DOP in number)
  return boolean
   is

   loop_count number := 0;
   row_count number := 0;
   sleep_time number := 60;
   open_ecids_complete boolean := TRUE;
   open_ecids_complete_v varchar2(5) := null;
   upg_comment_v varchar2(80) := null;
   job_name_v varchar2(40) := null;

 begin

   -- This routine should only be called once MetaData has completed.
   loop_count := 0;
   row_count := 0;
   sleep_time := 60;
   open_ecids_complete := TRUE;
   open_ecids_complete_v := null;
   job_name_v := 'CONTROL_MIGRATION_MAIN_JOB';

/*
* Check if open_ecids_complete is already set to TRUE.
*/
   open_ecids_complete_v := get_open_ecids_complete(job_name_v);
   IF UPPER(TRIM(open_ecids_complete_v)) = 'TRUE' THEN
      RETURN TRUE;
   END IF;

/*
* Sleep upto four times for all data migration jobs to start.
* There is a 10 second delay between job submissions.
*/
   WHILE loop_count < 5
   AND row_count < DOP
    LOOP
      FOR v_rec in (select complete from upgrade_open_ecids_status)
       LOOP
         IF v_rec.complete = 'FALSE' THEN
            open_ecids_complete := FALSE;
         END IF;
         row_count := row_count + 1;
      END LOOP;
      IF loop_count < 4 
      AND row_count < DOP THEN
         sleep_time := (10 + (DOP * 10));
         upg_comment_v :=
         ('CONTROL Waiting '||sleep_time||' seconds for DATA JOBS to start');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         DBMS_LOCK.sleep(seconds => sleep_time);
         row_count := 0;
      END IF;
      loop_count := loop_count + 1;
   END LOOP;

   IF row_count < DOP THEN
      upg_comment_v :=
      ('CONTROL ERROR - NOT ALL DATA UPGRADE JOBS HAVE STARTED');
      insert_upgrade_progress_info('CONTROL',upg_comment_v);
      open_ecids_complete := TRUE;
   ELSE
      IF open_ecids_complete = TRUE THEN
         set_open_ecids_complete('TRUE',job_name_v);
      ELSE
         -- To avoid loop in control procedure.
         IF is_migrate_data_running = FALSE THEN
            upg_comment_v :=
    ('CONTROL WARNING - DATA UPGRADE EXITED BEFORE ALL OPEN ECIDS UPGRADED');
            insert_upgrade_progress_info('CONTROL',upg_comment_v);
            open_ecids_complete := TRUE;
         END IF;      
      END IF;
   END IF; 

   RETURN open_ecids_complete;

 end is_open_ecids_complete;

/*
* get_closed_min_date
*/
 FUNCTION get_closed_min_date
  return timestamp
   is

  upgrade_date_v timestamp := NULL;
  closed_min_date_v timestamp := NULL;

 begin

  upgrade_date_v := NULL;
  FOR v_rec in (select soa_upgrade_date from version)
    LOOP
      upgrade_date_v := v_rec.soa_upgrade_date;
  END LOOP;

  closed_min_date_v := NULL;
  IF upgrade_date_v is not NULL THEN
     FOR v_rec in 
          (select min(created_time) closed_min_date
             from sca_flow_instance s, version v
            where s.updated_time < v.soa_upgrade_date
              and active_component_instances = 0)
       LOOP
         closed_min_date_v := v_rec.closed_min_date;
     END LOOP;
  END IF;

  RETURN closed_min_date_v;

 end get_closed_min_date;

/*
* upgrade_status_info 
*
*/
 procedure upgrade_status_info (status out varchar2)
       is

   metadata_job_complete_v varchar2(5) := null;
   data_job_complete_v varchar2(5) := null;
   open_ecids_complete_v varchar2(5) := null;
   closed_min_date timestamp := null;
   closed_migration_started_s varchar2(1) := 'F';
   metadata_job_complete_s varchar2(1) := 'F';
   data_job_complete_s varchar2(1) := 'F';
   open_ecids_complete_s varchar2(1) := 'F';
   closed_min_date_s varchar2(30) := 'F';
   tot_no_of_rows number := 0;
   job_name_v varchar2(40) := null;
  
 begin
    
   job_name_v := 'CONTROL_MIGRATION_MAIN_JOB';
   metadata_job_complete_v := get_metadata_job_complete(job_name_v);
   data_job_complete_v := get_data_job_complete(job_name_v);
   open_ecids_complete_v := get_open_ecids_complete(job_name_v);
   closed_min_date := NULL;
   closed_migration_started_s := 'T';
 
   IF open_ecids_complete_v = 'FALSE' THEN
      closed_min_date := null;
      closed_migration_started_s := 'F';
   ELSE
      IF data_job_complete_v = 'FALSE' THEN
         closed_min_date := get_closed_min_date;
         IF closed_min_date = NULL THEN
            IF any_flows_remaining = FALSE THEN
               -- This also covers purge scenarios.
               set_data_job_complete('TRUE',job_name_v);
               data_job_complete_v := 'TRUE';
               -- DISABLE MIGRATION SCHEDULE.
               --set_control_migration_job('FALSE',job_name_v);
            ELSE
               closed_migration_started_s := 'F';
            END IF;
         END IF;
      END IF;
   END IF;

   metadata_job_complete_s := 'F';
   IF metadata_job_complete_v = 'TRUE' THEN
      metadata_job_complete_s := 'T';
   END IF;
   data_job_complete_s := 'F';
   IF data_job_complete_v = 'TRUE' THEN
      data_job_complete_s := 'T';
   END IF;
   open_ecids_complete_s := 'F';
   IF open_ecids_complete_v = 'TRUE' THEN
      open_ecids_complete_s := 'T';
   END IF;
   closed_min_date_s := 'F';
   IF closed_min_date is not NULL THEN
      closed_min_date_s := 
         SUBSTR(TO_CHAR(closed_min_date,'DD/MON/YYYY:HH24/MI'),1,30);
   END IF;

   status := 'META:'    || metadata_job_complete_s
          || ',OPEN:'   || open_ecids_complete_s
          || ',DATA:'   || data_job_complete_s
          || ',CLOSED:' || closed_migration_started_s
          || ',DATE:'   || closed_min_date_s
          || ',';

 end upgrade_status_info;

/*
* submit_data_migration
*
*
*/
 procedure submit_data_migration (
                  batch_size in integer,
                  open_ecids_complete in varchar2,
                  max_count in integer,
                  stoptime_v in varchar2,
                  DOP in integer,
                  sql_trace in varchar2,
                  first_time boolean,
                  metrics_b boolean,
                  async_b boolean)
                is

    thread_v number := 0;
    job_name_v varchar2(40) := null;
    stop_injection_b boolean := FALSE;
    tot_no_of_rows number := 0;
    upg_comment_v varchar2(80) := null;
    metric_loop_count number := 0;
    stoptime_d date := NULL;
    break_loop_b boolean := FALSE;
    check_open_ecids_b  boolean := FALSE;
    upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

    log_debug('DATA Migration Started');

    IF stoptime_v is NULL THEN
       stoptime_d := NULL;
    ELSE
       stoptime_d := to_date(stoptime_v,'DD/MON/YYYY:HH24/MI');
    END IF;

    delete from upgrade_open_ecids_status;
    commit;
    thread_v := 0;
    LOOP
     EXIT WHEN DOP=thread_v;

       job_name_v := 'MIGRATE_SOA_JOB'||thread_v;
       execute immediate 'BEGIN '
       ||'dbms_scheduler.create_job(job_name => '''
       ||job_name_v
       ||''',program_name => ''migrate_soa_prg''); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''BATCH_SIZE'',to_char('||batch_size||')); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''IS_MIGRATE_METADATA_REQD'',''FALSE''); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''IS_MIGRATE_DATA_REQD'',''TRUE''); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''OPEN_ECIDS_COMPLETE'','''||open_ecids_complete||'''); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''STOPTIME_V'','''||stoptime_v||'''); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''MAX_COUNT'',to_char('||max_count||')); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''THREAD'',to_char('||thread_v||')); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''DOP'',to_char('||DOP||')); '
       ||'dbms_scheduler.set_job_argument_value ('''
       ||job_name_v
       ||''',''SQL_TRACE'','''||sql_trace||'''); '
       ||'DBMS_SCHEDULER.SET_ATTRIBUTE'
    ||'('''||job_name_v||''',''logging_level'',DBMS_SCHEDULER.LOGGING_FULL); '
       ||'dbms_scheduler.enable ('''||job_name_v||'''); '
       ||' END; ';

       upg_comment_v :=
        ('UPGRADE submitting: MIGRATE_SOA_JOB'||thread_v);
       insert_upgrade_progress_info('DATA',upg_comment_v);
       insert into upgrade_open_ecids_status values (thread_v,'FALSE');
       commit;
       DBMS_LOCK.sleep(seconds => 10);
       thread_v := thread_v + 1;

    END LOOP;

    upg_comment_v := ('UPGRADE will wait if MIGRATE_SOA_JOB running');
    log_debug(upg_comment_v);
    insert_upgrade_progress_info('DATA',upg_comment_v);

    metric_loop_count := 1;
    stop_injection_b := FALSE;
    break_loop_b := FALSE;
    WHILE is_migrate_data_running
      AND break_loop_b = FALSE
       LOOP
        log_debug('*** LOOP AND WAIT  ***');
        DBMS_LOCK.sleep(seconds => 120);
        -- Running Statistic for RUN.
        IF metrics_b
        AND metric_loop_count >= 2 THEN
             -- Every 4-5 minutes.
            tot_no_of_rows := is_upgrade_complete;
            insert_upgrade_progress_stat('DATA','RUNNING',tot_no_of_rows);
            metric_loop_count := 0;
        END IF;
        metric_loop_count := metric_loop_count + 1;
        IF first_time THEN
           -- When upgrading FA env to 12c, keeping open/closed ecids background jobs alive even if soa servers are up.
           IF is_fa_env = FALSE AND is_middletier_up THEN
              upg_comment_v :=
               ('UPGRADE Detected Middletier SOA Sever Started ');
              insert_upgrade_progress_info('DATA',upg_comment_v);
              upg_comment_v := ('UPGRADE INJECTING STOP JOBS FLAG ');
              insert_upgrade_progress_info('DATA',upg_comment_v);
              inject_stop_migration;
              stop_injection_b := TRUE;
              break_loop_b := TRUE;
            END IF;
        END IF;
        check_open_ecids_b := is_open_ecids_complete(dop);
        IF stoptime_d is not NULL THEN
           IF (sysdate > stoptime_d) THEN
              break_loop_b := TRUE;
           END IF;
        END IF;
    END LOOP;

    IF stop_injection_b = FALSE THEN
       IF stoptime_d is not NULL THEN
          IF (sysdate > stoptime_d) THEN
              -- Allow 60 seconds for jobs to stop naturally.
              DBMS_LOCK.sleep(seconds => 60);
              IF is_migrate_data_running THEN
                 upg_comment_v := 
                 ('UPGRADE MIGRATE_SOA_JOB has exceeded stoptime ');
                 insert_upgrade_progress_info('DATA',upg_comment_v);
                 upg_comment_v := ('UPGRADE INJECTING STOP JOBS FLAG ');
                 insert_upgrade_progress_info('DATA',upg_comment_v);
                 inject_stop_migration;
                 stop_injection_b := TRUE;
              END IF;
           END IF;
        END IF;
    END IF;

    -- End Statistic for RUN.
    IF metrics_b THEN
       tot_no_of_rows := is_upgrade_complete;
       insert_upgrade_progress_stat('DATA','END',tot_no_of_rows);
    END If;

    IF is_migrate_data_running THEN
       upg_comment_v :=
        ('UPGRADE ERROR : MIGRATE_SOA_JOB SHOULD HAVE STOPPED');
       insert_upgrade_progress_info('DATA',upg_comment_v);
    ELSE
       upg_comment_v := ('UPGRADE MIGRATE_SOA_JOB HAS STOPPED');
       insert_upgrade_progress_info('DATA',upg_comment_v);
       -- Recheck OPEN and CLOSED data flags.
       IF is_open_ecids_complete(dop) = FALSE THEN
          upg_comment_v :=
           ('UPGRADE MIGRATE_SOA_JOB - OPEN ECIDS STILL OUTSTANDING');
          insert_upgrade_progress_info('DATA',upg_comment_v);
       END IF;
       IF any_flows_remaining = FALSE THEN
          job_name_v := 'CONTROL_MIGRATION_MAIN_JOB';
          set_data_job_complete('TRUE',job_name_v);
          -- DISABLE MIGRATION SCHEDULE.
          --set_control_migration_job('FALSE',job_name_v);
          upg_comment_v :=
         ('UPGRADE Detected METADATA and DATA has completed');
          insert_upgrade_progress_info('DATA',upg_comment_v);
       END IF;
    END IF;

    log_debug('DATA Upgrade Ended');

 end submit_data_migration;


/*
* submit_migration_jobs
*/
 procedure submit_migration_jobs (
                  is_migrate_metadata_reqd in varchar2,
                  is_migrate_data_reqd in varchar2,
                  open_ecids_complete in varchar2,
                  batch_size in integer,
                  max_count in integer,
                  stoptime_v in varchar2,
                  DOP in integer,
                  sql_trace in varchar2,
                  metrics in varchar2,
                  first_time in varchar2,
                  async in varchar2)
                is

    thread_v number := 0;
    job_name_v varchar2(40) := null;
    first_time_b boolean := FALSE;
    is_migrate_metadata_reqd_b boolean := FALSE;
    is_migrate_data_reqd_b boolean := FALSE;
    open_ecids_complete_b  boolean := FALSE;
    stop_injection_b boolean := FALSE;
    metrics_b boolean := FALSE;
    async_b boolean := FALSE;
    upg_comment_v varchar2(80) := null;
    stoptime_d date := NULL;
    metadata_job_complete_v varchar2(5) := null;
    break_loop_b boolean := FALSE;
    upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

     -- Set ACTION_NAME on SESSION.
     DBMS_APPLICATION_INFO.SET_MODULE(
            MODULE_NAME => 'SOAUPGRADESUBMITJOBS',
            ACTION_NAME => 'SOAUPGRADEEXECUTING');    
     
    log_debug('METADATA and DATA Submission Started');

    IF stoptime_v is NULL THEN
       stoptime_d := NULL;
    ELSE
       stoptime_d := to_date(stoptime_v,'DD/MON/YYYY:HH24/MI');
    END IF;
    is_migrate_metadata_reqd_b := FALSE;
    IF UPPER(TRIM(is_migrate_metadata_reqd)) = 'TRUE' THEN
       is_migrate_metadata_reqd_b := TRUE;
    END IF;
    is_migrate_data_reqd_b := FALSE;
    IF UPPER(TRIM(is_migrate_data_reqd)) = 'TRUE' THEN
       is_migrate_data_reqd_b := TRUE;
    END IF;
    open_ecids_complete_b := FALSE;
    IF UPPER(TRIM(open_ecids_complete)) = 'TRUE' THEN
       open_ecids_complete_b := TRUE;
    END IF;
    metrics_b := FALSE;
    IF UPPER(TRIM(metrics)) = 'TRUE' THEN
       metrics_b := TRUE;
    END IF;
    async_b := FALSE;
    IF UPPER(TRIM(async)) = 'TRUE' THEN
       async_b := TRUE;
    END IF;

    IF is_migrate_metadata_reqd_b
     THEN
       job_name_v := 'MIGRATE_SOA_METADATA_JOB';
       set_batch_size(batch_size,job_name_v);
       set_stoptime(stoptime_v,job_name_v);
       set_sql_trace(sql_trace,job_name_v);
       upg_comment_v := ('UPGRADE submitting: MIGRATE_SOA_METADATA_JOB');
       insert_upgrade_progress_info('METADATA',upg_comment_v);
       IF async_b THEN
          dbms_scheduler.run_job(job_name => job_name_v,
                          USE_CURRENT_SESSION => FALSE);
          DBMS_LOCK.sleep(seconds => 10);
       ELSE
          dbms_scheduler.run_job(job_name => job_name_v);
       END IF;
    END IF;

    first_time_b := FALSE;
    IF UPPER(TRIM(first_time)) = 'TRUE' THEN
       first_time_b := TRUE;
    END IF;

/* Main IF Block */
    IF is_migrate_data_reqd_b = TRUE THEN

       upg_comment_v :=
        ('UPGRADE MIGRATE_SOA_JOB will wait for MIGRATE_SOA_METADATA_JOB ');
       insert_upgrade_progress_info('METADATA',upg_comment_v);

       stop_injection_b := FALSE;
       break_loop_b := FALSE;
       WHILE is_migrate_metadata_running
       AND break_loop_b = FALSE
         LOOP
          log_debug('*** LOOP AND WAIT ***');
          DBMS_LOCK.sleep(seconds => 30);
          IF first_time_b THEN
             -- When upgrading FA env to 12c, keeping open/closed ecids background jobs alive even if soa servers are up.
             IF is_fa_env = FALSE and is_middletier_up THEN
                upg_comment_v := 
                 ('UPGRADE Detected Middletier SOA Sever Started ');
                insert_upgrade_progress_info('METADATA',upg_comment_v);
                upg_comment_v := ('UPGRADE INJECTING STOP JOBS FLAG ');
                insert_upgrade_progress_info('METADATA',upg_comment_v);
                inject_stop_migration;
                stop_injection_b := TRUE;
                break_loop_b := TRUE;
             END IF;
          END IF;
          IF stoptime_d is not NULL THEN
             IF (sysdate > stoptime_d) THEN
                break_loop_b := TRUE;
             END IF;
          END IF;
       END LOOP;

       IF stop_injection_b = FALSE THEN
          IF stoptime_d is not NULL THEN
             IF (sysdate > stoptime_d) THEN
                -- Allow 60 seconds for jobs to stop naturally.
                DBMS_LOCK.sleep(seconds => 60);
                IF is_migrate_metadata_running THEN
                   upg_comment_v :=
                  ('UPGRADE MIGRATE_SOA_METADATA_JOB has exceeded stoptime ');
                   insert_upgrade_progress_info('METADATA',upg_comment_v);
                   upg_comment_v := ('UPGRADE INJECTING STOP JOBS FLAG ');
                   insert_upgrade_progress_info('METADATA',upg_comment_v); 
                   inject_stop_migration;
                   stop_injection_b := TRUE;
                END IF;
             END IF;
          END IF;
       END IF;

       -- Check for manual shutdown request before submission.
       IF is_stop_injected = TRUE THEN
          stop_injection_b := TRUE;
       END IF;

       IF stop_injection_b = FALSE THEN
          IF is_migrate_metadata_running = FALSE THEN
             IF stoptime_d is not NULL THEN
                IF (sysdate < stoptime_d) THEN
                   log_debug('SUBMIT: submit_data_migration');
                   submit_data_migration (
                     batch_size,
                     open_ecids_complete,
                     max_count,
                     stoptime_v,
                     DOP,
                     sql_trace,
                     first_time_b,
                     metrics_b,
                     async_b);
                ELSE
                  upg_comment_v := 
                'UPGRADE STOPTIME exceeded - Unable to submit DATA Upgrade';
                  log_debug(upg_comment_v);
                  insert_upgrade_progress_info('METADATA',upg_comment_v);
                END IF;
             ELSE
               log_debug('SUBMIT: submit_data_migration');
               submit_data_migration (
                     batch_size,
                     open_ecids_complete,
                     max_count,
                     stoptime_v,
                     DOP,
                     sql_trace,
                     first_time_b,
                     metrics_b,
                     async_b);
             END IF;  
          ELSE
             upg_comment_v := 'UPGRADE METADATA upgrade is not complete';
             log_debug(upg_comment_v);
             insert_upgrade_progress_info('METADATA',upg_comment_v);
             upg_comment_v := 'UPGRADE    DATA upgrade cannot start';
             log_debug(upg_comment_v);
             insert_upgrade_progress_info('METADATA',upg_comment_v);
          END IF;
       END IF;

/*  Is DATA MIGRATION REQUIRED */
    END IF;

    log_debug('METADATA and DATA Submission Ended');

 end submit_migration_jobs;

/*
* submit_migration
*/
 procedure submit_migration (
                  is_migrate_metadata_reqd in varchar2,
                  is_migrate_data_reqd in varchar2,
                  open_ecids_complete in varchar2,
                  batch_size in integer,
                  max_count in integer,
                  stoptime_v in varchar2,
                  DOP in integer,
                  sql_trace in varchar2,
                  metrics in varchar2,
                  first_time in varchar2,
                  async in varchar2)
                is

     job_name_v varchar2(40) := null;
     upg_comment_v varchar2(80) := null;
     async_b boolean := FALSE;
     upgrade_progress_log_rec upgrade_progress_log_rec_type;

  begin

     log_debug('SUBMIT procedure started');
     job_name_v := 'SUBMIT_MIGRATION_JOBS_JOB';
     set_batch_size(batch_size,job_name_v);
     set_max_count(max_count,job_name_v);
     set_stoptime(stoptime_v,job_name_v);
     set_DOP(DOP,job_name_v);
     set_is_migrate_metadata_reqd(is_migrate_metadata_reqd,job_name_v);
     set_is_migrate_data_reqd(is_migrate_data_reqd,job_name_v);
     set_open_ecids_complete(open_ecids_complete,job_name_v);
     set_sql_trace(sql_trace,job_name_v);
     set_metrics(metrics,job_name_v);
     set_first_time(first_time,job_name_v);
     set_async(async,job_name_v);

     IF UPPER(TRIM(async)) = 'TRUE' THEN
        async_b := TRUE;
        upg_comment_v :=
        ('UPGRADE jobs submitted ASYNCRONOUS');
     ELSE
        upg_comment_v :=
        ('UPGRADE jobs submitted in same database session');
     END IF;
     insert_upgrade_progress_info('CONTROL',upg_comment_v);
 
     IF async_b then
        dbms_scheduler.run_job(job_name => job_name_v,
                         USE_CURRENT_SESSION => FALSE);
        DBMS_LOCK.sleep(seconds => 10);
     ELSE
        dbms_scheduler.run_job(job_name => job_name_v);
     END IF;

     log_debug('SUBMIT procedure ended :');

 end submit_migration;

/*
* control_job_submission
*/
 procedure control_job_submission
                is

    job_name_v varchar2(40) := null;
    batch_size_v integer := 0;
    max_count_v integer := 0;
    ctl_stoptime_d date := null;
    job_stoptime_d date := null;
    job_stoptime_c varchar2(100) := NULL;
    DOP_v integer := 0;
    metadata_job_complete_v varchar2(5) := null;
    data_job_complete_v varchar2(5) := null;
    open_ecids_complete_v varchar2(5) := null;
    ctl_max_runtime_v integer := 0;
    job_max_runtime_v integer := 0;
    first_time_v varchar2(5) := null;
    first_ctl_max_runtime_v integer := 0;
    first_job_max_runtime_v integer := 0;
    use_ctl_max_runtime_v integer := 0;
    use_job_max_runtime_v integer := 0;
    sql_trace_v varchar2(5) := null;
    metrics_v varchar2(5) := null;
    async_v varchar2(5) := null;
    metadata_job_complete_b boolean := FALSE;
    data_job_complete_b boolean := FALSE;
    open_ecids_complete_b boolean := FALSE;
    first_time_b boolean := FALSE;
    sql_trace_b boolean := FALSE;
    metrics_b boolean := FALSE;
    async_b boolean := FALSE;
    exit_migration_b boolean := FALSE;
    exit_migration_v varchar2(5) := null;
    avoid_migration_b boolean := FALSE;
    stop_injection_b boolean := FALSE;
    metadata_migration_running_b boolean := FALSE;
    data_migration_running_b boolean := FALSE;
    is_migrate_metadata_reqd_v varchar2(5) := 'FALSE';
    is_migrate_data_reqd_v varchar2(5) := 'FALSE';
    run_nextval number := 0;
    tot_no_of_rows number := 0;
    upg_comment_v varchar2(80) := null;
    break_loop_b boolean := FALSE;
    upgrade_progress_log_rec upgrade_progress_log_rec_type;
	thread_v number := 0;

  begin

     log_debug('CONTROL procedure started');
     -- Set ACTION_NAME on SESSION.
     DBMS_APPLICATION_INFO.SET_MODULE(
        MODULE_NAME => 'SOAUPGRADECONTROLMAIN',
        ACTION_NAME => 'SOAUPGRADEEXECUTING');

     -- Increament RUN Number.
     select upgrade_run_seq.nextval into run_nextval from dual;
     update_upgrade_progress_seq('CONTROL','SEQUENCE',run_nextval);

     -- The source of truth for the parameters is the JOB ARGS.
     job_name_v := 'CONTROL_MIGRATION_MAIN_JOB';
     batch_size_v := get_batch_size(job_name_v);
     max_count_v := get_max_count(job_name_v);
     ctl_max_runtime_v := get_ctl_max_runtime(job_name_v);
     job_max_runtime_v := get_job_max_runtime(job_name_v);
     DOP_v := get_DOP(job_name_v);
     metadata_job_complete_v := get_metadata_job_complete(job_name_v);
     data_job_complete_v := get_data_job_complete(job_name_v);
     open_ecids_complete_v := get_open_ecids_complete(job_name_v);
     first_time_v := get_first_time(job_name_v);
     first_ctl_max_runtime_v := get_first_ctl_max_runtime(job_name_v);
     first_job_max_runtime_v := get_first_job_max_runtime(job_name_v);
     sql_trace_v := get_sql_trace(job_name_v);
     metrics_v := get_metrics(job_name_v);
     async_v := get_async(job_name_v);

     FOR v_rec in (select name, value from upgrade_parameter_table)
      LOOP
        IF UPPER(TRIM(v_rec.name)) = 'BATCH_SIZE' then
           batch_size_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'MAX_COUNT' then
           max_count_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'CTL_MAX_RUNTIME' then
           ctl_max_runtime_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'JOB_MAX_RUNTIME' then
           job_max_runtime_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'DOP' then
           DOP_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'METADATA_JOB_COMPLETE' then
           metadata_job_complete_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'DATA_JOB_COMPLETE' then
           data_job_complete_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'OPEN_ECIDS_COMPLETE' then
           open_ecids_complete_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'FIRST_TIME' then
           first_time_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'FIRST_CTL_MAX_RUNTIME' then
           first_ctl_max_runtime_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'FIRST_JOB_MAX_RUNTIME' then
           first_job_max_runtime_v := TO_NUMBER(TO_CHAR(v_rec.value));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'SQL_TRACE' then
           sql_trace_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'METRICS' then
           metrics_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'ASYNC' then
           async_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
        IF UPPER(TRIM(v_rec.name)) = 'EXIT' then
           exit_migration_v := UPPER(TRIM(TO_CHAR(v_rec.value)));
        END IF;
     END LOOP;

     IF UPPER(TRIM(metadata_job_complete_v)) = 'TRUE' THEN
        metadata_job_complete_b := TRUE;
     END IF;
     IF UPPER(TRIM(data_job_complete_v)) = 'TRUE' THEN
        data_job_complete_b := TRUE;
     END IF;
     IF UPPER(TRIM(open_ecids_complete_v)) = 'TRUE' THEN
        open_ecids_complete_b := TRUE;
     END IF;
     IF UPPER(TRIM(first_time_v)) = 'TRUE' THEN
        first_time_b := TRUE;
     END IF;
     IF UPPER(TRIM(sql_trace_v)) = 'TRUE' THEN
        sql_trace_b := TRUE;
     END IF;
     IF UPPER(TRIM(metrics_v)) = 'TRUE' THEN
        metrics_b := TRUE;
     END IF;
     IF UPPER(TRIM(async_v)) = 'TRUE' THEN
        async_b := TRUE;
     END IF;
     IF UPPER(TRIM(exit_migration_v)) = 'TRUE' THEN
        exit_migration_b := TRUE;
     END IF;

     use_job_max_runtime_v := job_max_runtime_v;
     use_ctl_max_runtime_v := ctl_max_runtime_v;
     IF first_time_b then
        use_job_max_runtime_v := first_job_max_runtime_v;
        use_ctl_max_runtime_v := first_ctl_max_runtime_v;
        set_first_time('FALSE',job_name_v);
     END IF;

     log_debug('CONTROL procedure print parameters');

     upg_comment_v := ('batch_size            => '|| batch_size_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('max_count             => '|| max_count_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('use_ctl_max_runtime   => '|| use_ctl_max_runtime_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('use_job_max_runtime   => '|| use_job_max_runtime_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('DOP                   => '|| DOP_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('metadata_job_complete => '|| metadata_job_complete_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('data_job_complete     => '|| data_job_complete_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('open_ecids_complete   => '|| open_ecids_complete_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('first_time            => '|| first_time_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('sql_trace             => '|| sql_trace_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('metrics               => '|| metrics_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     upg_comment_v := ('async                 => '|| async_v);
     insert_upgrade_progress_parm('CONTROL',upg_comment_v);

/*
* Decouple first time for UA and Scheduler.
*  First Time UA will wait 240 minutes and Jobs unlimited(0).
*/
     if use_ctl_max_runtime_v > 0 then
        ctl_stoptime_d := sysdate + NVL(use_ctl_max_runtime_v,24*60)/(24*60);
        upg_comment_v := ('ctl_stoptime_d        => '
          || TO_CHAR( ctl_stoptime_d,'DD/MON/YYYY:HH24/MI'));
        insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     else
        ctl_stoptime_d := NULL;
        upg_comment_v := ('ctl_stoptime_d        => NULL ' || ctl_stoptime_d);
        insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     end if;

     if use_job_max_runtime_v > 0 then
        job_stoptime_d := sysdate + NVL(use_job_max_runtime_v,24*60)/(24*60);
        job_stoptime_c := to_char(
     sysdate + NVL(use_job_max_runtime_v,24*60)/(24*60),'DD/MON/YYYY:HH24/MI');
        upg_comment_v := ('job_stoptime_d        => '
          || TO_CHAR( job_stoptime_d,'DD/MON/YYYY:HH24/MI'));
        insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     else
        job_stoptime_d := NULL;
        job_stoptime_c := NULL;
        upg_comment_v := ('job_stoptime_d        => NULL ' || job_stoptime_d);
        insert_upgrade_progress_parm('CONTROL',upg_comment_v);
     end if;

/*
* Determine if Metadata and Data upgrade have completed their task.
* Metadata must be completed before Data upgrade can start.
* The METADATA_JOB_COMPLETE parameter is set by MIGRATE_SOA_METADATA proc.
* The "completed" parameter for DATA_JOB_COMPLETE is (re)checked at the 
*  the start, as it cannot be set by MIGRATE_SOA proc due to parallel jobs.
*/

   is_migrate_metadata_reqd_v := 'TRUE';
   is_migrate_data_reqd_v := 'TRUE';
   avoid_migration_b := FALSE;

   IF  metadata_job_complete_b 
    THEN
       is_migrate_metadata_reqd_v := 'FALSE';
       IF data_job_complete_b THEN
          -- DISABLE MIGRATION SCHEDULE.
          --set_control_migration_job('FALSE',job_name_v);
          avoid_migration_b := TRUE;
          upg_comment_v := 
        ('CONTROL Detected METADATA and DATA has completed');
          insert_upgrade_progress_info('CONTROL',upg_comment_v);
       ELSE
          -- Recheck due to parallel jobs.
          IF any_flows_remaining = FALSE THEN
             set_data_job_complete('TRUE',job_name_v);
             set_open_ecids_complete('TRUE',job_name_v);
             -- DISABLE MIGRATION SCHEDULE.
             --set_control_migration_job('FALSE',job_name_v);
             avoid_migration_b := TRUE;
             data_job_complete_b := TRUE;
             is_migrate_data_reqd_v := 'FALSE';
             open_ecids_complete_b := TRUE;
             open_ecids_complete_v := 'TRUE';
             upg_comment_v := 
         ('CONTROL Detected METADATA and DATA has completed');
             insert_upgrade_progress_info('CONTROL',upg_comment_v);
          END IF;
       END IF;
   ELSE
       IF any_flows_remaining = FALSE THEN
          set_data_job_complete('TRUE',job_name_v);
          set_open_ecids_complete('TRUE',job_name_v);
          -- DISABLE MIGRATION SCHEDULE.
          -- set_control_migration_job('FALSE',job_name_v);
          data_job_complete_b := TRUE;
          is_migrate_data_reqd_v := 'FALSE';
          open_ecids_complete_b := TRUE;
          open_ecids_complete_v := 'TRUE';
          upg_comment_v :=
          ('UPGRADE Detected no 11g DATA (ecid) to migrate');
          insert_upgrade_progress_info('CONTROL',upg_comment_v);
          upg_comment_v :=
          ('UPGRADE METADATA proceeding');
          insert_upgrade_progress_info('CONTROL',upg_comment_v);
       END IF;
   END IF;

   IF avoid_migration_b = FALSE THEN
      IF first_time_b THEN
         IF is_fa_env = FALSE AND is_middletier_up THEN
            upg_comment_v :=
             ('UPGRADE Detected Middletier SOA Server has started');
            insert_upgrade_progress_info('CONTROL',upg_comment_v);
            avoid_migration_b := TRUE;
         END IF;
      END IF;
   END IF;

   IF avoid_migration_b = FALSE THEN
      IF is_soapurge_running THEN
         upg_comment_v := ('UPGRADE Detected SOA Purge is running');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         avoid_migration_b := TRUE;
      END IF;
   END IF;

   IF exit_migration_b
   OR avoid_migration_b
    THEN
      IF exit_migration_b THEN
         upg_comment_v := ('UPGRADE Detected EXIT parameter');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         -- set_control_migration_job('FALSE',job_name_v);
      END IF;
      upg_comment_v := ('UPGRADE EXITING');
      insert_upgrade_progress_info('CONTROL',upg_comment_v);
   ELSE
      log_debug('CONTROL procedure reset injection table');
      update upgrade_injection set value = 'FALSE';
      commit;

      IF metrics_b THEN
         upg_comment_v := ('UPGRADE START - Collecting Instance Counts');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         tot_no_of_rows := is_upgrade_complete;
         insert_upgrade_progress_stat('DATA','START',tot_no_of_rows);
         upg_comment_v := ('UPGRADE END - Collecting Instance Counts');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
      END IF;

      submit_migration(
               is_migrate_metadata_reqd_v,
               is_migrate_data_reqd_v,
               open_ecids_complete_v,
               batch_size_v,
               max_count_v,
               job_stoptime_c,
               DOP_v,
               sql_trace_v,
               metrics_v,
               first_time_v,
               async_v);

       upg_comment_v := 
       ('CONTROL procedure waiting for (metadata and/or open ecids)');
       insert_upgrade_progress_info('CONTROL',upg_comment_v);

       break_loop_b := FALSE;
       WHILE break_loop_b = FALSE
        LOOP
         log_debug('*** LOOP AND WAIT  ***');
         DBMS_LOCK.sleep(seconds => 120);
         IF is_stop_injected = TRUE THEN
            upg_comment_v :=
            ('CONTROL Detected that GRACEFUL SHUTDOWN has been requested');
            insert_upgrade_progress_info('CONTROL',upg_comment_v);
            break_loop_b := TRUE;
         END IF;            
         IF first_time_b THEN
            IF is_fa_env = FALSE and is_middletier_up THEN
               upg_comment_v := 
                ('CONTROL Detected Middletier SOA Server has started');
               insert_upgrade_progress_info('CONTROL',upg_comment_v);
               upg_comment_v := ('CONTROL INJECTING STOP JOBS FLAG ');
               insert_upgrade_progress_info('CONTROL',upg_comment_v); 
               inject_stop_migration;
               break_loop_b := TRUE;
            END IF;
            IF is_migrate_metadata_running = FALSE THEN
               IF is_migrate_data_reqd_v = 'TRUE' THEN
                  IF open_ecids_complete_b = FALSE THEN
                     IF is_open_ecids_complete(DOP_V) = TRUE THEN
					 
			--Migrating failed instances which were not processed during data migration. Migrating with thread=-1
			thread_v := -1;
			job_name_v := 'MIGRATE_SOA_JOB';
			   execute immediate 'BEGIN '
			   ||'dbms_scheduler.create_job(job_name => '''
			   ||job_name_v
			   ||''',program_name => ''migrate_soa_prg''); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''BATCH_SIZE'',to_char(''10000'')); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''IS_MIGRATE_METADATA_REQD'',''FALSE''); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''IS_MIGRATE_DATA_REQD'',''TRUE''); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''OPEN_ECIDS_COMPLETE'',''FALSE''); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''MAX_COUNT'',to_char(''100000'')); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''THREAD'',to_char(''-1'')); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''DOP'',to_char(''1'')); '
			   ||'dbms_scheduler.set_job_argument_value ('''
			   ||job_name_v
			   ||''',''SQL_TRACE'',''FALSE''); '
			   ||'DBMS_SCHEDULER.SET_ATTRIBUTE'
			   ||'('''||job_name_v||''',''logging_level'',DBMS_SCHEDULER.LOGGING_FULL); '
			   ||'dbms_scheduler.enable ('''||job_name_v||'''); '
			   ||' END; ';

			   upg_comment_v :=
				('UPGRADE submitting: MIGRATE_SOA_JOB'||thread_v);
			   insert_upgrade_progress_info('DATA',upg_comment_v);
			   insert into upgrade_open_ecids_status values (thread_v,'FALSE');
			   commit;
			   DBMS_LOCK.sleep(seconds => 10);

			   -- End 
					 
                        upg_comment_v :=
                        ('CONTROL Detected that METADATA upgrade exited');
                        insert_upgrade_progress_info('CONTROL',upg_comment_v);
                        upg_comment_v :=
                        ('CONTROL Detected that OPEN ECIDS upgrade exited');
                        insert_upgrade_progress_info('CONTROL',upg_comment_v);
                        upg_comment_v :=
                        ('CONTROL Procedure exiting');
                        insert_upgrade_progress_info('CONTROL',upg_comment_v);
                        break_loop_b := TRUE;
                     END IF;
                  END IF;
               ELSE
                  upg_comment_v :=
                  ('CONTROL Detected that METADATA upgrade exited ');
                  insert_upgrade_progress_info('CONTROL',upg_comment_v);
                  upg_comment_v :=
                  ('CONTROL Procedure Exiting');
                  insert_upgrade_progress_info('CONTROL',upg_comment_v);
                  break_loop_b := TRUE;    
               END IF;
            END IF;
         END IF;
         IF ctl_stoptime_d is not NULL THEN
            IF (sysdate > ctl_stoptime_d) THEN
               upg_comment_v :=
               ('CONTROL Procedure Exiting');
               insert_upgrade_progress_info('CONTROL',upg_comment_v);
               break_loop_b := TRUE;
            END IF;
         END IF;
      END LOOP;

      upg_comment_v := ('CONTROL procedure ended');
      insert_upgrade_progress_info('CONTROL',upg_comment_v); 

   END IF;

   -- Set ACTION_NAME on SESSION to NULL.
   DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);

   EXCEPTION
    when others then
     DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);
     log_error('ERROR(control_job_submission)');
     raise;

  end control_job_submission;

/*
* control_migration
* MAIN exection procedure.
*  The parameters are defined on the MIAN procedure for JOB ARGs.
*/
 procedure control_migration_main (
                   batch_size in integer default 10000,
                   max_count in integer default 100000,
                   ctl_max_runtime in integer default 240,
                   job_max_runtime in integer default 240,
                   DOP in integer default 1,
                   metadata_job_complete in varchar2 default 'FALSE',
                   data_job_complete in varchar2 default 'FALSE',
                   open_ecids_complete in varchar2 default 'FALSE',
                   first_time in varchar2 default 'TRUE',
                   first_ctl_max_runtime in integer default 30,
                   first_job_max_runtime in integer default 0,
                   sql_trace in varchar2 default 'FALSE',
                   metrics in varchar2 default 'TRUE',
                   async in varchar2 default 'TRUE'
                   )
                is

     upg_comment_v varchar2(80) := null;

  begin

     IF is_migrate_running THEN
         upg_comment_v :=
          ('UPGRADE -------------------------------------------------------');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         upg_comment_v :=
          ('UPGRADE Detected that another upgrade attempted to start');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         upg_comment_v :=
          ('UPGRADE The attempt to start another upgrade has been stopped.');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
         upg_comment_v :=
          ('UPGRADE -------------------------------------------------------');
         insert_upgrade_progress_info('CONTROL',upg_comment_v);
     ELSE
         control_job_submission; 
     END IF;

  end control_migration_main;

 end control_migration;

/
show errors;
