
create or replace PACKAGE mediator_migrate AS

	PROCEDURE perform_mediator_upgrade 
	(
		ecid_val IN VARCHAR2, 
		flow_id_val IN NUMBER ,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		component_id_val IN VARCHAR2 DEFAULT NULL,
		component_dn IN VARCHAR2 DEFAULT NULL,
		component_fault_key_val IN VARCHAR2 DEFAULT NULL,
		se_status_obj IN OUT SE_status_type,
		log_file IN utl_file.file_type,
		is_orphaned_case in boolean
	);
	 
END mediator_migrate;

/

show errors

create or replace PACKAGE BODY mediator_migrate AS

	PROCEDURE populate_sca_async_cpnt_state
	(
		flow_id  IN NUMBER,
		cikey IN NUMBER, 
		med_partial_executions IN NUMBER, 
		med_async_state IN NUMBER, 
		composite_sca_entity_id IN NUMBER,
		mediator_sca_entity_id IN NUMBER
	)
	
	IS
	  
	BEGIN         	
		INSERT INTO SCA_ASYNC_CPNT_STATE
		(
			FLOW_ID, 
			CIKEY, 
			PARTIAL_EXECUTIONS, 
			STATE, 
			COMPLETED_EXECUTIONS, 
			VERSION, 
			COMPOSITE_SCA_ENTITY_ID, 
			COMPONENT_SCA_ENTITY_ID
		)
		VALUES
		(
			flow_id,
			cikey,
			med_partial_executions,
			med_async_state,
			0,
			0,
			composite_sca_entity_id,
			mediator_sca_entity_id
		);
		
	END populate_sca_async_cpnt_state;
	
	PROCEDURE update_mediator_tables
	(
		med_instance_id IN VARCHAR2,
		flow_id_val IN NUMBER,
		cikey_val IN NUMBER,
		sca_partition_id_val IN NUMBER,
		partion_date_val IN TIMESTAMP,
		group_id_val IN VARCHAR2,
		mi_operation IN VARCHAR2,
		mi_component_name IN VARCHAR2,
		mi_resequencer_type IN VARCHAR2
	)
	
	IS
	 
	BEGIN
		UPDATE MEDIATOR_INSTANCE
		SET FLOW_ID = flow_id_val,
		CIKEY = cikey_val
                -- below component_state update was planned to use for purge but
                -- fabric requires original state of this to show 
                -- component state in 12c, there is no other way.
		-- COMPONENT_STATE = 0
		WHERE ID = med_instance_id;
		
		UPDATE MEDIATOR_CALLBACK
		SET FLOW_ID = flow_id_val,
		SCA_PARTITION_ID = sca_partition_id_val,
		PARTITION_DATE = partion_date_val,
		INSTANCE_ID = cikey_val
		WHERE INSTANCE_ID = med_instance_id;
		
		UPDATE MEDIATOR_CORRELATION
		SET FLOW_ID = flow_id_val,
		SCA_PARTITION_ID = sca_partition_id_val,
		PARTITION_DATE = partion_date_val,
		INSTANCE_ID = cikey_val
		WHERE INSTANCE_ID = med_instance_id;
		
		UPDATE MEDIATOR_DEFERRED_MESSAGE
		SET FLOW_ID = flow_id_val,
		SCA_PARTITION_ID = sca_partition_id_val,
		MSG_ID = cikey_val,
		MSG_RECEIVED_TIME = CREATION_DATE -- fix for bug - 17212408
		WHERE MSG_ID = med_instance_id;

                -- fix for bug - 17212408
		--UPDATE MEDIATOR_DEFERRED_MESSAGE
		--SET MSG_RECEIVED_TIME = CREATION_DATE
		--WHERE MSG_ID = med_instance_id AND 
		--(STATUS = 0 OR STATUS = 1 OR STATUS = 3);
		
		IF mi_resequencer_type IS NOT NULL THEN
		
			UPDATE MEDIATOR_RESEQUENCER_MESSAGE
			SET FLOW_ID = flow_id_val,
			SCA_PARTITION_ID = sca_partition_id_val,
			PARTITION_DATE = partion_date_val,
			ID = cikey_val
			WHERE ID = med_instance_id;
			
			IF group_id_val IS NOT NULL THEN
			   UPDATE MEDIATOR_GROUP_STATUS
			   SET SCA_PARTITION_ID = sca_partition_id_val,
			   PARTITION_DATE = partion_date_val
			   WHERE GROUP_ID = group_id_val AND
			   COMPONENT_DN = REGEXP_REPLACE(mi_component_name,'\*(.[^/]*)', '') AND
			   OPERATION = mi_operation;
			END IF;
			
			UPDATE MEDIATOR_PAYLOAD
			SET OWNER_ID = cikey_val
			WHERE OWNER_ID = med_instance_id;
                        
                        UPDATE SCA_FLOW_INSTANCE
                        SET RESEQUENCER = 1
                        WHERE FLOW_ID = flow_id_val;
			
		END IF;
		
	END update_mediator_tables;

FUNCTION populate_common_fault
	(
		retry_count_val IN NUMBER, 
		mediator_sca_entity_id_val IN NUMBER,
		comp_fault_key_val IN VARCHAR2,
		cikey_val IN NUMBER, 
		fault_name_val IN VARCHAR2,
		fault_type_val IN VARCHAR2,
		error_message_val IN VARCHAR2,
		state_val IN NUMBER,
		creation_date_val IN TIMESTAMP,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		se_status_obj IN OUT SE_status_type,
		log_file IN utl_file.file_type
	) RETURN NUMBER 
	
	IS 
	
	fault_id_val NUMBER;
	fault_state NUMBER;
		
	BEGIN
	
                --generate fault_id
	        fault_id_val := get_next_id('FAULT_IDS');
	        log_debug('fault_id generated:::' || fault_id_val, log_file);
                log_debug('fault id:::' || fault_id_val, log_file);
                log_debug('retry_count_val:::' || retry_count_val, log_file);
                log_debug('comp_fault_key_val:::' || comp_fault_key_val, log_file);
                log_debug('mediator_sca_entity_id_val:::' || mediator_sca_entity_id_val, log_file);
                log_debug('composite_sca_entity_id:::' || sca_flow_to_cpst_obj.composite_sca_entity_id, log_file);
                log_debug('fault_name_val:::' || fault_name_val, log_file);
                log_debug('fault_type_val:::' || upper(fault_type_val), log_file);
                log_debug('error_message_val:::' || error_message_val, log_file);
                log_debug('fault_state:::' || fault_state, log_file);
                log_debug('sca_partition_id:::' || sca_flow_to_cpst_obj.sca_partition_id, log_file);
                log_debug('creation_date_val:::' || creation_date_val, log_file);
                log_debug('fault id:::' || fault_id_val, log_file);
		
		IF state_val = 4 OR state_val = 8 THEN
			fault_state := 1536; -- mediator recovery required in case of recovery required or running state.
			se_status_obj.recoverable_fault_count := se_status_obj.recoverable_fault_count + 1;
			
		ELSIF state_val = 1 OR state_val = 2 THEN
			fault_state := 256; -- non recoverable in case of faulted or aborted states.
			se_status_obj.unhandled_count := se_status_obj.unhandled_count + 1; -- increase the unhandled fault count for each non-recoverable common fault inserted.
		ELSIF state_val = 0 THEN
			fault_state := 2560; -- recovered in case of completed successfully.
		
		END IF;
		 
		INSERT INTO SCA_COMMON_FAULT
				(
				   ID,
				   RETRY_COUNT,  -- 0
				   FLOW_ID, -- sca_flow_to_cpst_obj.flow_id
				   COMPONENT_TYPE, --mediator
				   COMPONENT_FAULT_KEY, --calculated
				   SCA_ENTITY_ID, --calculated
				   COMPOSITE_SCA_ENTITY_ID, -- sca_flow_to_cpst_obj.composite_sca_entity_id
				   CIKEY,
				   OWNER_CIKEY,
				   OWNER_SCA_ENTITY_ID,
				   OWNER_COMPONENT_TYPE,
				   OWNER_COMPOSITE_SCA_ENTITY_ID,
				   FAULT_NAME,
				   FAULT_TYPE,
				   ERROR_MESSAGE,
				   STATE,
				   SCA_PARTITION_ID,
				   OWNER_SCA_PARTITION_ID,
           COMPOSITE_ID,
				   CREATION_DATE,
				   MODIFY_DATE	
				)
			   VALUES
				(
				   fault_id_val,
				   retry_count_val,
				   sca_flow_to_cpst_obj.flow_id,
				   'mediator',
				   comp_fault_key_val, --component_fault_key
				   mediator_sca_entity_id_val, -- SCA_ENTITY_ID 
				   sca_flow_to_cpst_obj.composite_sca_entity_id,	 --COMPOSITE_SCA_ENTITY_ID
				   cikey_val, --CIKEY
				   cikey_val, --OWNER_CIKEY
				   mediator_sca_entity_id_val, -- OWNER_SCA_ENTITY_ID
				   'mediator', -- OWNER_COMPONENT_TYPE
				   sca_flow_to_cpst_obj.composite_sca_entity_id,	 --OWNER_COMPOSITE_SCA_ENTITY_ID
				   fault_name_val,  --FAULT_NAME
				   upper(fault_type_val),   --FAULT_TYPE
				   error_message_val,   -- ERROR_MESSAGE  - NOT FEASABLE TO FIX . TODO - PUT A DEFAULT ERROR MESSAGE STATING THAT ITS AN UPGRADED INSTANCE.
				   fault_state,   -- STATE
				   sca_flow_to_cpst_obj.sca_partition_id,   --SCA_PARTITION_ID
				   sca_flow_to_cpst_obj.sca_partition_id,   --OWNER_SCA_PARTITION_D
				   sca_flow_to_cpst_obj.composite_id,   -- COMPOSITE_ID
				   creation_date_val, -- CREATION_DATE
				   creation_date_val --MODIFY_DATE 
				);
				
				RETURN fault_id_val;
	END populate_common_fault;


	PROCEDURE proccess_med_case_instances
	(
          cikey IN NUMBER,
	  mci_id IN VARCHAR2,
	  mci_def_message_id IN VARCHAR2,
	  mci_retry_count IN NUMBER,
	  mci_fault_name IN VARCHAR2,
	  mci_exception_type IN VARCHAR2,
	  mci_exception_msg IN VARCHAR2,
	  mci_created_time IN TIMESTAMP,
	  mci_recoverable IN NUMBER,
          mi_id IN VARCHAR2,
          mi_group_id VARCHAR2,
		  mi_component_state IN NUMBER,
		  mi_resequencer_type IN VARCHAR2,
          component_fault_key_val IN VARCHAR2 DEFAULT NULL,
          sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
          se_status_obj IN OUT SE_status_type,
          mediator_sca_entity_id IN NUMBER,
	  log_file IN utl_file.file_type,
	  is_orphaned_case IN BOOLEAN,
	  med_partial_executions IN OUT NUMBER
	)
	  
	IS
	
          fault_id NUMBER;
          med_comp_fault_key_val VARCHAR2(100);
          med_case_detail_state NUMBER;
  
	BEGIN
	
		IF mci_def_message_id IS NOT NULL AND mci_exception_type IS NOT NULL THEN
		
		   IF is_orphaned_case = true THEN
		      IF mci_recoverable = 1 THEN
			     IF mi_component_state = 1 THEN
				    med_case_detail_state := 1;
			     ELSE
			       med_case_detail_state := 4;
				   med_partial_executions := med_partial_executions + 1;
				   
				 END IF;  
		      ELSE
			       med_case_detail_state := 2;
		      END IF;
		   ELSE
              -- fix for bug-18418399, very unusual case for normal mediator instance(non-orphaned) where mediator_instance, mediator_case_instance is populated 
              --but mediator_case_detail is not populated this case is observed when mediator_instance state is faulted, 
              --so handling this case where making case detail state to 2(faulted) becoz it is non recoverable instance.
              BEGIN			
	            SELECT state INTO med_case_detail_state FROM mediator_case_detail_v WHERE instance_id = mi_id AND case_id = mci_id AND ROWNUM < 2; --bypass issues with multiple records
	          EXCEPTION
                WHEN NO_DATA_FOUND THEN
	              med_case_detail_state := 2; -- faulted
		          log_debug('mediator_case_detail having no data, med_case_detail_state=2::[cikey=' || cikey || ']', log_file);	
                END;				
		   END IF;
					
		   IF mi_resequencer_type IS NOT NULL THEN
	               med_comp_fault_key_val := 'RESEQUENCER-' || cikey;
	           ELSE
		       med_comp_fault_key_val := mci_id;
	           END IF;
				
                   fault_id:= populate_common_fault(mci_retry_count, mediator_sca_entity_id, med_comp_fault_key_val, cikey, mci_fault_name, mci_exception_type, mci_exception_msg, med_case_detail_state, mci_created_time, sca_flow_to_cpst_obj, se_status_obj, log_file);
		   log_debug('SCA_COMMON_FAULT populated sucessfully...', log_file);
		   -- in case of inflight migration fault_id and cikey should be returned.
		   IF component_fault_key_val IS NOT NULL AND component_fault_key_val = mci_def_message_id THEN
		      se_status_obj.fault_id := fault_id;
		      se_status_obj.cikey := cikey;
		   END IF;
			
		END IF;
	
	END proccess_med_case_instances;
  
  PROCEDURE process_mediator_instances
	(
		flow_id IN NUMBER,
		mi_id IN VARCHAR2,
		mi_component_state IN NUMBER,
		mi_component_name IN VARCHAR2,
		mi_case_num IN NUMBER,
		mi_group_id IN VARCHAR2,
		mi_operation IN VARCHAR2,
		mi_resequencer_type IN VARCHAR2,
		log_file IN utl_file.file_type,
                sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
                se_status_obj IN OUT SE_status_type,
                component_fault_key_val IN VARCHAR2 DEFAULT NULL,
		is_orphaned_case IN BOOLEAN
	) 
	
	IS
  
                mediator_sca_entity_id NUMBER;
                med_partial_executions NUMBER := 0;
                cikey NUMBER;
                med_async_state NUMBER;
   
	BEGIN

        cache_util.get_cache_query_type_3_output(partition_id => sca_flow_to_cpst_obj.SCA_PARTITION_ID,composite => sca_flow_to_cpst_obj.COMPOSITE_NAME,revision => sca_flow_to_cpst_obj.REVISION, name => mi_component_name, sca_entity_id => mediator_sca_entity_id);

		-- generate cikey
		cikey := get_next_id('COMPONENT_INSTANCE_IDS');
		log_debug('cikey generated:::' || cikey, log_file);
		
		IF is_orphaned_case = true THEN
		   IF mi_component_state >= 8 AND mi_component_state <= 15 THEN
		      med_partial_executions := mi_case_num;
		   END IF;
		ELSE
		   IF mi_component_state = 8 THEN
			   med_partial_executions := mi_case_num;
		   ELSE
			   SELECT /*+ INDEX(TEMP_UPGRADE_MCDV TEMP_UPGRADE_MCDV_INSID) */ count(1) INTO med_partial_executions FROM temp_upgrade_mcdv WHERE instance_id = mi_id;
		       log_debug('med_partial_executions:::' || med_partial_executions, log_file);
		   END IF;		
		END IF;
		
	--	IF use_temp_table = true THEN
			log_debug('using temp_upgrade_mci table',log_file);
			FOR med_case_instance_loop in (SELECT  /*+ INDEX(TEMP_UPGRADE_MCI TEMP_UPGRADE_MCI_INSID) */ id, def_message_id, retry_count, fault_name, exception_type, exception_msg, created_time, recoverable FROM TEMP_UPGRADE_MCI WHERE instance_id = mi_id)
			LOOP
		          proccess_med_case_instances(cikey, med_case_instance_loop.id, med_case_instance_loop.def_message_id, med_case_instance_loop.retry_count, 
                       med_case_instance_loop.fault_name, med_case_instance_loop.exception_type, med_case_instance_loop.exception_msg, 
                       med_case_instance_loop.created_time, med_case_instance_loop.recoverable, mi_id, mi_group_id, mi_component_state, mi_resequencer_type, component_fault_key_val, sca_flow_to_cpst_obj, se_status_obj, mediator_sca_entity_id, log_file, is_orphaned_case, med_partial_executions);
				
			END LOOP;
        
	--	ELSE
			
		--	log_debug('using mediator_case_instance table',log_file);
		--	FOR med_case_instance_loop in (SELECT id, def_message_id, retry_count, fault_name, exception_type, exception_msg, created_time FROM MEDIATOR_CASE_INSTANCE WHERE instance_id = mi_id)
		--	LOOP

		--	     IF mi_component_state != 8 THEN
		--	         SELECT count(1) INTO med_partial_executions FROM mediator_case_detail_v WHERE instance_id = mi_id AND (state = 4 OR state = 8);
		--		 log_debug('med_case_detail_state:::' || med_case_detail_state, log_file);
		--	     END IF;

       --                      proccess_med_case_instances(cikey, med_case_instance_loop.id, med_case_instance_loop.def_message_id, med_case_instance_loop.retry_count, 
       --                      med_case_instance_loop.fault_name, med_case_instance_loop.exception_type, med_case_instance_loop.exception_msg, 
       --                      med_case_instance_loop.created_time,mi_id, mi_group_id,component_fault_key_val, sca_flow_to_cpst_obj, se_status_obj,
       --                      mediator_sca_entity_id, log_file);
				
		--	END LOOP;
		 
          		 
   -- END IF;  			

		IF mi_component_state = 0 THEN
			med_async_state := 2;
			
		ELSIF mi_component_state = 1 THEN
			med_async_state := 4;
		 
		ELSIF mi_component_state = 2 OR mi_component_state = 3 THEN
			med_async_state := 3;
		  
		ELSIF mi_component_state >= 4 AND mi_component_state <= 15 THEN
			med_async_state := 1;
			se_status_obj.active_component_count := se_status_obj.active_component_count + 1;

		ELSIF mi_component_state = 16 THEN
			med_async_state := 5;
		END IF;
		  
		populate_sca_async_cpnt_state(flow_id, cikey, med_partial_executions, med_async_state, sca_flow_to_cpst_obj.COMPOSITE_SCA_ENTITY_ID, mediator_sca_entity_id);
		log_debug('SCA_ASYNC_CNPT_STATE populated sucessfully...', log_file);
		update_mediator_tables(mi_id, flow_id, cikey, sca_flow_to_cpst_obj.SCA_PARTITION_ID, sca_flow_to_cpst_obj.PARTITION_DATE, mi_group_id, mi_operation, mi_component_name, mi_resequencer_type);
		log_debug('Mediator runtime tables updated successfully...', log_file);
	END process_mediator_instances;
	


	PROCEDURE perform_mediator_upgrade 
	(
		ecid_val IN VARCHAR2, 
		flow_id_val IN NUMBER ,
		sca_flow_to_cpst_obj IN OUT SCA_FLOW_TO_CPST_TYPE,
		component_id_val IN VARCHAR2 DEFAULT NULL,
		component_dn IN VARCHAR2 DEFAULT NULL,
		component_fault_key_val IN VARCHAR2 DEFAULT NULL,
		se_status_obj IN OUT SE_status_type,
		log_file IN utl_file.file_type,
		is_orphaned_case IN BOOLEAN
	)
	
	IS
	 
		med_instance_id VARCHAR2(100);
		med_case_id VARCHAR2(100);
		flow_id_check NUMBER;
		v_med_instance_loop_counter   number := 0;
        orphn_composite_dn_val varchar2(1253);
		orphan_composite_DN composite_dn_type;
        m_partition_id integer;
        composite_sca_entity_id integer;
        orphan_sca_flow_to_cpst_obj  SCA_FLOW_TO_CPST_TYPE;
		orphan_instances_per_ecid NUMBER := 0;
		is_partial_orphaned_case BOOLEAN := false;
	BEGIN
		
		log_debug('Mediator composite migration started...', log_file);
		
		IF is_orphaned_case = false THEN
		   -- check for composite instance = 0, if composite instance is 0 then make orphaned_case = true;
		   SELECT COUNT(1) INTO orphan_instances_per_ecid FROM TEMP_UPGRADE_MI WHERE ecid = ecid_val AND composite_instance_id = 0;
            log_debug('[composite_audit_off]::orphan_instances_per_ecid : ' || ecid_val || 'count : ' || orphan_instances_per_ecid, log_file);
           IF orphan_instances_per_ecid > 0 THEN
		      is_partial_orphaned_case := true;
		   END IF;
    
		END IF;		
		
		IF is_orphaned_case = true OR  is_partial_orphaned_case = true THEN
			log_debug('Upgrading Mediator for orphans',log_file);
			FOR med_instance_loop in (SELECT flow_id, id, component_state, component_name, case_num, group_id, source_action_name, resequencer_type FROM TEMP_UPGRADE_MI WHERE ecid = ecid_val)
			LOOP
                if med_instance_loop.component_state = 16 then -- State of 16 is stale for MEDIATOR_INSTANCE table
                    se_status_obj.is_stale := 1;
                elsif med_instance_loop.component_state = 1 then -- State of 1 is Aborted
                    se_status_obj.is_aborted := 1;
                end if; 
				IF med_instance_loop.flow_id IS NOT NULL THEN
					log_debug('Migration already done for this ecid : ' || ecid_val, log_file);
				END IF;
				EXIT WHEN med_instance_loop.flow_id IS NOT NULL;
				v_med_instance_loop_counter := v_med_instance_loop_counter + 1;
                
				orphn_composite_dn_val := get_composite_dn_med_orphan(med_instance_loop.component_name);
                orphan_composite_DN := composite_dn_type(orphn_composite_dn_val);
                
                select id into m_partition_id from sca_partition where name = orphan_composite_DN.partition_name;
                
                select id into composite_sca_entity_id from sca_entity where sca_partition_id = m_partition_id and composite = orphan_composite_DN.composite_name and revision = orphan_composite_DN.revision and type='composite' and rownum =1 ;--and label = m_composite_label; No label check for mediator orphans.
                
                orphan_sca_flow_to_cpst_obj := sca_flow_to_cpst_obj;
                orphan_sca_flow_to_cpst_obj.composite_sca_entity_id := composite_sca_entity_id;
                orphan_sca_flow_to_cpst_obj.sca_partition_id := m_partition_id;
                orphan_sca_flow_to_cpst_obj.composite_dn := orphn_composite_dn_val;
                orphan_sca_flow_to_cpst_obj.partition_name := orphan_composite_DN.partition_name;
                orphan_sca_flow_to_cpst_obj.composite_name := orphan_composite_DN.composite_name;
                orphan_sca_flow_to_cpst_obj.revision := orphan_composite_DN.revision;
                orphan_sca_flow_to_cpst_obj.label := orphan_composite_DN.label;
				process_mediator_instances(flow_id_val, med_instance_loop.id, med_instance_loop.component_state, med_instance_loop.component_name, 
                med_instance_loop.case_num, med_instance_loop.group_id, med_instance_loop.source_action_name, med_instance_loop.resequencer_type, log_file, orphan_sca_flow_to_cpst_obj, se_status_obj, component_fault_key_val, is_orphaned_case);
				
			END LOOP;
			
			IF is_partial_orphaned_case = true THEN
               UPDATE TEMP_UPGRADE_MI SET FLOW_ID = flow_id_val WHERE ecid = ecid_val;
			   log_debug('[composite_audit_off]::update temp_upgrade_mi done : ' || ecid_val || 'flow_id : ' || flow_id_val, log_file);
			END IF;
			
		ELSE
		
			log_debug('using normal mediator upgrade',log_file);
			FOR med_instance_loop in (SELECT /*+ INDEX(TEMP_UPGRADE_MI TEMP_UPGRADE_MI_CMPSTID) */ flow_id, id, component_state, component_name, case_num, group_id, source_action_name, resequencer_type FROM TEMP_UPGRADE_MI WHERE composite_instance_id = sca_flow_to_cpst_obj.COMPOSITE_ID)
			LOOP
                if med_instance_loop.component_state = 16 then -- State of 16 is stale for MEDIATOR_INSTANCE table
                    se_status_obj.is_stale := 1;
                elsif med_instance_loop.component_state = 1 then -- State of 1 is Aborted
                    se_status_obj.is_aborted := 1;
                end if;   
				IF med_instance_loop.flow_id IS NOT NULL THEN
					log_debug('Migration already done for this composite_id : ' || sca_flow_to_cpst_obj.COMPOSITE_ID, log_file);
				END IF;
				EXIT WHEN med_instance_loop.flow_id IS NOT NULL;
				v_med_instance_loop_counter := v_med_instance_loop_counter + 1;
				
				process_mediator_instances(flow_id_val, med_instance_loop.id, med_instance_loop.component_state, med_instance_loop.component_name, 
                med_instance_loop.case_num, med_instance_loop.group_id, med_instance_loop.source_action_name, med_instance_loop.resequencer_type, log_file, sca_flow_to_cpst_obj, se_status_obj, component_fault_key_val, is_orphaned_case);
				
			END LOOP;
		
		END IF;
		
		IF v_med_instance_loop_counter = 0 THEN
			log_debug('NO DATA FOUND for mediator_intance having composite id : ' || sca_flow_to_cpst_obj.COMPOSITE_ID, log_file);
		END IF;
		
		log_debug('Mediator composite migration completed successfully!!!', log_file);
	END perform_mediator_upgrade; 
	
END mediator_migrate;
/

show errors;
