
-- =====================================================
-- THIS IS A GENERATED FILE. PLEASE DO NOT MODIFY THIS FILE.
-- =====================================================

DEFINE CURSCHEMA=&&1;

ALTER SESSION SET EDITION=&&3;
--  
-- "Copyright (c) 2006, 2013, Oracle and/or its affiliates. All Rights Reserved." 
-- "Oracle Fusion Middleware SOA Suite" 
--  

-- ----------------------------------------------------------------------- 
-- E$LDAPADAPTER_IN 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$LDAPADAPTER_IN
(
    LAST_CHANGE_NUMBER VARCHAR2(400),
    LAST_TIME_STAMP VARCHAR2(200),
    LDAP_ENDPOINT_GUID VARCHAR2(4000) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW LDAPADAPTER_IN
 AS SELECT LAST_CHANGE_NUMBER, LAST_TIME_STAMP, LDAP_ENDPOINT_GUID FROM E$LDAPADAPTER_IN;

ALTER TABLE E$LDAPADAPTER_IN
    ADD CONSTRAINT LDAPADAPTER_IN_PK PRIMARY KEY (LDAP_ENDPOINT_GUID);

-- ----------------------------------------------------------------------- 
-- E$FILEADAPTER_IN 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$FILEADAPTER_IN
(
    FULL_PATH VARCHAR2(4000) NOT NULL,
    ROOT_DIRECTORY VARCHAR2(3000) NOT NULL,
    FILE_DIRECTORY VARCHAR2(3000) NOT NULL,
    FILE_NAME VARCHAR2(1000) NOT NULL,
    FILE_ENDPOINT_GUID VARCHAR2(2000) NOT NULL,
    FILE_LAST_MODIFIED NUMBER,
    FILE_READONLY CHAR(1),
    FILE_PROCESSED CHAR(1) DEFAULT '0',
    CREATED NUMBER NOT NULL,
    UPDATED NUMBER,
    TENANT_ID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW FILEADAPTER_IN
 AS SELECT FULL_PATH, ROOT_DIRECTORY, FILE_DIRECTORY, FILE_NAME, FILE_ENDPOINT_GUID, FILE_LAST_MODIFIED, FILE_READONLY, FILE_PROCESSED, CREATED, UPDATED, TENANT_ID FROM E$FILEADAPTER_IN;

ALTER TABLE E$FILEADAPTER_IN
    ADD CONSTRAINT FILEADAPTER_IN_PK PRIMARY KEY (FULL_PATH);

CREATE INDEX IDX_ROOT_DIRECTORY ON E$FILEADAPTER_IN
    (ROOT_DIRECTORY );

CREATE INDEX IDX_FILE_DIRECTORY ON E$FILEADAPTER_IN
    (FILE_DIRECTORY );

CREATE INDEX IDX_FILE_PROCESSED ON E$FILEADAPTER_IN
    (FILE_PROCESSED );

CREATE INDEX IDX_FILE_READONLY ON E$FILEADAPTER_IN
    (FILE_READONLY );

-- ----------------------------------------------------------------------- 
-- E$FILEADAPTER_MUTEX 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$FILEADAPTER_MUTEX
(
    MUTEX_ID VARCHAR2(4000) NOT NULL,
    MUTEX_CREATED TIMESTAMP,
    MUTEX_LAST_UPDATED TIMESTAMP,
    MUTEX_SEQUENCE NUMBER,
    TENANT_ID NUMBER(18,0) DEFAULT -1
)
;

CREATE OR REPLACE EDITIONING VIEW FILEADAPTER_MUTEX
 AS SELECT MUTEX_ID, MUTEX_CREATED, MUTEX_LAST_UPDATED, MUTEX_SEQUENCE, TENANT_ID FROM E$FILEADAPTER_MUTEX;

ALTER TABLE E$FILEADAPTER_MUTEX
    ADD CONSTRAINT FILEADAPTER_MUTEX_PK PRIMARY KEY (MUTEX_ID);

-- ----------------------------------------------------------------------- 
-- E$JCA_NATIVE_CORRELATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$JCA_NATIVE_CORRELATION
(
    PROTOCOL_CORRELATION_ID VARCHAR2(100) NOT NULL,
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    SOURCE_URI VARCHAR2(500) NOT NULL,
    ECID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    CREATED_TIME TIMESTAMP NOT NULL,
    CORRELATED_TIME TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW JCA_NATIVE_CORRELATION
 AS SELECT PROTOCOL_CORRELATION_ID, COMPOSITE_DN, SOURCE_URI, ECID, CONVERSATION_ID, CREATED_TIME, CORRELATED_TIME FROM E$JCA_NATIVE_CORRELATION;

ALTER TABLE E$JCA_NATIVE_CORRELATION
    ADD CONSTRAINT JCA_NATIVE_CORRELATION_PK PRIMARY KEY (PROTOCOL_CORRELATION_ID);

CREATE INDEX IDX_JCA_COMPOSITE_DN ON E$JCA_NATIVE_CORRELATION
    (COMPOSITE_DN );

-- ----------------------------------------------------------------------- 
-- E$FILEADAPTER_TRANSACTION_LOG 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$FILEADAPTER_TRANSACTION_LOG
(
    XID VARCHAR2(200) NOT NULL,
    SERVICE_NAME VARCHAR2(200) NOT NULL,
    JNDI VARCHAR2(100),
    FILE_ACTION INTEGER NOT NULL,
    TRANSACTION_STATE INTEGER NOT NULL,
    FILE_ACTION_ARG1 VARCHAR2(1000) NOT NULL,
    FILE_ACTION_ARG2 VARCHAR2(500) NOT NULL,
    CREATED TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW FILEADAPTER_TRANSACTION_LOG
 AS SELECT XID, SERVICE_NAME, JNDI, FILE_ACTION, TRANSACTION_STATE, FILE_ACTION_ARG1, FILE_ACTION_ARG2, CREATED, TENANT_ID FROM E$FILEADAPTER_TRANSACTION_LOG;

ALTER TABLE E$FILEADAPTER_TRANSACTION_LOG
    ADD CONSTRAINT FILEADAPTER_TRANSACTION_LOG_PK PRIMARY KEY (XID, SERVICE_NAME);

CREATE INDEX IDX_FA_JNDI ON E$FILEADAPTER_TRANSACTION_LOG
    (JNDI );

CREATE INDEX IDX_FA_TRANSACTION_STATE ON E$FILEADAPTER_TRANSACTION_LOG
    (TRANSACTION_STATE );

-- ----------------------------------------------------------------------- 
-- E$MESSAGE_STATISTICS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MESSAGE_STATISTICS
(
    SNAPSHOT_ID NUMBER NOT NULL,
    CREATION_TIME TIMESTAMP NOT NULL,
    BEGIN_INTERVAL_TIME TIMESTAMP NOT NULL,
    END_INTERVAL_TIME TIMESTAMP NOT NULL,
    MAX_MESSAGE_SIZE NUMBER NOT NULL,
    MIN_MESSAGE_SIZE NUMBER NOT NULL,
    NUM_OF_MESSAGES NUMBER NOT NULL,
    TOTAL_MESSAGE_SIZE NUMBER NOT NULL,
    AVERAGE_MESSAGE_SIZE NUMBER NOT NULL,
    MANAGED_SERVER VARCHAR2(200),
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    ENDPOINT_NAME VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW MESSAGE_STATISTICS
 AS SELECT SNAPSHOT_ID, CREATION_TIME, BEGIN_INTERVAL_TIME, END_INTERVAL_TIME, MAX_MESSAGE_SIZE, MIN_MESSAGE_SIZE, NUM_OF_MESSAGES, TOTAL_MESSAGE_SIZE, AVERAGE_MESSAGE_SIZE, MANAGED_SERVER, COMPOSITE_DN, ENDPOINT_NAME FROM E$MESSAGE_STATISTICS;

CREATE INDEX IDX_MSG_STATS ON E$MESSAGE_STATISTICS
    (CREATION_TIME , COMPOSITE_DN , ENDPOINT_NAME , MANAGED_SERVER );

-- ----------------------------------------------------------------------- 
-- E$EIS_CONNECTION_DOWN_TIME 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EIS_CONNECTION_DOWN_TIME
(
    SNAPSHOT_ID NUMBER NOT NULL,
    CREATION_TIME TIMESTAMP NOT NULL,
    BEGIN_INTERVAL_TIME TIMESTAMP NOT NULL,
    END_INTERVAL_TIME TIMESTAMP NOT NULL,
    EIS_DOWNTIME_START TIMESTAMP NOT NULL,
    EIS_DOWNTIME_END TIMESTAMP NOT NULL,
    ERROR_SUMMARY VARCHAR2(500),
    ERROR_STACK CLOB,
    MANAGED_SERVER VARCHAR2(200),
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    ENDPOINT_NAME VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW EIS_CONNECTION_DOWN_TIME
 AS SELECT SNAPSHOT_ID, CREATION_TIME, BEGIN_INTERVAL_TIME, END_INTERVAL_TIME, EIS_DOWNTIME_START, EIS_DOWNTIME_END, ERROR_SUMMARY, ERROR_STACK, MANAGED_SERVER, COMPOSITE_DN, ENDPOINT_NAME FROM E$EIS_CONNECTION_DOWN_TIME;

CREATE INDEX IDX_EIS_DT_STATS ON E$EIS_CONNECTION_DOWN_TIME
    (CREATION_TIME , COMPOSITE_DN , ENDPOINT_NAME , MANAGED_SERVER );

CREATE INDEX IDX_EIS_DT_ERROR ON E$EIS_CONNECTION_DOWN_TIME
    (SNAPSHOT_ID );

-- ----------------------------------------------------------------------- 
-- E$AIA_ERROR_NOTIFICATIONS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AIA_ERROR_NOTIFICATIONS
(
    ERROR_NOTIFICATION_ID NUMBER NOT NULL,
    ERROR_CODE VARCHAR2(255),
    SYSTEM_ID NUMBER,
    PROCESS_NAME VARCHAR2(255),
    SERVICE_NAME VARCHAR2(255) NOT NULL,
    NOTIFICATION_ROLE VARCHAR2(100),
    FYI_NOTIFICATION_ROLE VARCHAR2(100),
    ERROR_TYPE VARCHAR2(255) DEFAULT 'AIA_EH_DEFAULT' NOT NULL,
    ERROR_EXT_HANDLER VARCHAR2(100) DEFAULT 'ERRORHANDLER_EXT' NOT NULL,
    AGGR_COUNT_CUR NUMBER DEFAULT 0,
    AGGR_COUNT_TOT NUMBER DEFAULT 0,
    ST_DATETIME TIMESTAMP DEFAULT SYSDATE,
    END_DATETIME TIMESTAMP DEFAULT SYSDATE
);

CREATE OR REPLACE EDITIONING VIEW AIA_ERROR_NOTIFICATIONS
 AS SELECT ERROR_NOTIFICATION_ID, ERROR_CODE, SYSTEM_ID, PROCESS_NAME, SERVICE_NAME, NOTIFICATION_ROLE, FYI_NOTIFICATION_ROLE, ERROR_TYPE, ERROR_EXT_HANDLER, AGGR_COUNT_CUR, AGGR_COUNT_TOT, ST_DATETIME, END_DATETIME FROM E$AIA_ERROR_NOTIFICATIONS;

ALTER TABLE E$AIA_ERROR_NOTIFICATIONS
    ADD CONSTRAINT AIA_ERROR_NOTIFICATIONS_PK PRIMARY KEY (ERROR_NOTIFICATION_ID);

ALTER TABLE E$AIA_ERROR_NOTIFICATIONS
    ADD CONSTRAINT AIA_ERROR_NOTIFICATIONS_CHK1 CHECK (END_DATETIME >= ST_DATETIME);

-- ----------------------------------------------------------------------- 
-- E$AIA_SYSTEMS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AIA_SYSTEMS
(
    SYSTEM_ID NUMBER NOT NULL,
    SYSTEM_INTERNAL_ID VARCHAR2(100) NOT NULL,
    SYSTEM_CODE VARCHAR2(30) NOT NULL,
    SYSTEM_DESC VARCHAR2(100),
    SYSTEM_IP_ADDR VARCHAR2(100),
    SYSTEM_URL VARCHAR2(255),
    SYSTEM_TYPE VARCHAR2(20) NOT NULL,
    APPLICATION_TYPE VARCHAR2(30),
    APPLICATION_VERSION VARCHAR2(10),
    CONTACT_NAME VARCHAR2(100),
    CONTACT_PHONE VARCHAR2(100),
    CONTACT_EMAIL VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW AIA_SYSTEMS
 AS SELECT SYSTEM_ID, SYSTEM_INTERNAL_ID, SYSTEM_CODE, SYSTEM_DESC, SYSTEM_IP_ADDR, SYSTEM_URL, SYSTEM_TYPE, APPLICATION_TYPE, APPLICATION_VERSION, CONTACT_NAME, CONTACT_PHONE, CONTACT_EMAIL FROM E$AIA_SYSTEMS;

ALTER TABLE E$AIA_SYSTEMS
    ADD CONSTRAINT AIA_SYSTEMS_PK PRIMARY KEY (SYSTEM_ID);

ALTER TABLE E$AIA_SYSTEMS ADD CONSTRAINT AIA_SYSTEMS_U1 UNIQUE
    (SYSTEM_CODE );

-- ----------------------------------------------------------------------- 
-- E$CAVS_DEFINITION_AUDITS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_DEFINITION_AUDITS
(
    DEFINITION_ID NUMBER(15,0) NOT NULL,
    VERSION NUMBER(5) NOT NULL,
    AUDITED_ON DATE NOT NULL,
    AUDITED_BY VARCHAR2(20)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_AUDITS
 AS SELECT DEFINITION_ID, VERSION, AUDITED_ON, AUDITED_BY FROM E$CAVS_DEFINITION_AUDITS;

ALTER TABLE E$CAVS_DEFINITION_AUDITS
    ADD CONSTRAINT DEFINITION_AUDITS_PK PRIMARY KEY (DEFINITION_ID, VERSION);

-- ----------------------------------------------------------------------- 
-- E$CAVS_DEFINITION_NSXPATHS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_DEFINITION_NSXPATHS
(
    DEFINITION_ID NUMBER(15,0) NOT NULL,
    NAMESPACE_ALIAS VARCHAR2(30) NOT NULL,
    NAMESPACE VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_NSXPATHS
 AS SELECT DEFINITION_ID, NAMESPACE_ALIAS, NAMESPACE FROM E$CAVS_DEFINITION_NSXPATHS;

ALTER TABLE E$CAVS_DEFINITION_NSXPATHS
    ADD CONSTRAINT DEFINITION_NSXPATHS_PK PRIMARY KEY (DEFINITION_ID, NAMESPACE_ALIAS);

-- ----------------------------------------------------------------------- 
-- E$CAVS_DEFINITION_XPATHS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_DEFINITION_XPATHS
(
    DEFINITION_ID NUMBER(15,0) NOT NULL,
    XPATH_SEQ_ID NUMBER(5) NOT NULL,
    XPATH VARCHAR2(2048),
    IS_NODE_TEXT NUMBER(1) DEFAULT 0,
    IS_NODE_KEY NUMBER(1) DEFAULT 0,
    NODE_VALUE_KEY VARCHAR2(100),
    CONDITION VARCHAR2(10),
    NODE_VALUE_EXPECTED VARCHAR2(2048),
    IS_SYSTEM_GENERATED NUMBER(1) DEFAULT 0,
    NAMESPACE VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_XPATHS
 AS SELECT DEFINITION_ID, XPATH_SEQ_ID, XPATH, IS_NODE_TEXT, IS_NODE_KEY, NODE_VALUE_KEY, CONDITION, NODE_VALUE_EXPECTED, IS_SYSTEM_GENERATED, NAMESPACE FROM E$CAVS_DEFINITION_XPATHS;

ALTER TABLE E$CAVS_DEFINITION_XPATHS
    ADD CONSTRAINT DEFINITION_XPATHS_PK PRIMARY KEY (DEFINITION_ID, XPATH_SEQ_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_DEFINITION_XREFS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_DEFINITION_XREFS
(
    DEFINITION_ID_TEST NUMBER(15,0) NOT NULL,
    DEFINITION_ID_SIMULATOR NUMBER(15,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_XREFS
 AS SELECT DEFINITION_ID_TEST, DEFINITION_ID_SIMULATOR FROM E$CAVS_DEFINITION_XREFS;

ALTER TABLE E$CAVS_DEFINITION_XREFS
    ADD CONSTRAINT DEFINITION_XREFS_PK PRIMARY KEY (DEFINITION_ID_TEST, DEFINITION_ID_SIMULATOR);

-- ----------------------------------------------------------------------- 
-- E$CAVS_DEFINITIONS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_DEFINITIONS
(
    DEFINITION_ID NUMBER(15,0) NOT NULL,
    TYPE VARCHAR2(10) NOT NULL,
    DESCRIPTION VARCHAR2(80) NOT NULL,
    STATE VARCHAR2(10) NOT NULL,
    SERVICE_TYPE VARCHAR2(20),
    URL_WSDL VARCHAR2(1000),
    URL_ENDPOINT VARCHAR2(1000),
    SOAP_ACTION VARCHAR2(200),
    SOAP_TRANSPORT_TYPE VARCHAR2(5),
    MESSAGE_REQUEST CLOB,
    MESSAGE_RESPONSE CLOB,
    DELAY NUMBER(5),
    VERSION NUMBER(5) DEFAULT 0 NOT NULL,
    PROJECT_NAME VARCHAR2(30),
    PROJECT_VERSION VARCHAR2(10),
    EBS_NAME VARCHAR2(30),
    EBS_VERSION VARCHAR2(10),
    PROCESS_NAME VARCHAR2(80),
    PROCESS_VERSION VARCHAR2(10),
    SERVICE_NAME VARCHAR2(80),
    SERVICE_VERSION VARCHAR2(10),
    MESSAGE_NAME VARCHAR2(30),
    MESSAGE_VERSION VARCHAR2(10),
    PIP_NAME VARCHAR2(80),
    PIP_VERSION VARCHAR2(10),
    APPLICATION_NAME VARCHAR2(30),
    APPLICATION_VERSION VARCHAR2(10),
    TEST_PRIORITY VARCHAR2(1),
    REFERENCE_ID_EXTERNAL VARCHAR2(30),
    AUDITED_ON DATE,
    AUDITED_BY VARCHAR2(20),
    REQ_CORR_ID_XPATH VARCHAR2(2048),
    RESP_CORR_ID_XPATH VARCHAR2(2048),
    SETUP_ID NUMBER(15,0),
    IS_WSA_ENABLED NUMBER(1) DEFAULT 0 NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITIONS
 AS SELECT DEFINITION_ID, TYPE, DESCRIPTION, STATE, SERVICE_TYPE, URL_WSDL, URL_ENDPOINT, SOAP_ACTION, SOAP_TRANSPORT_TYPE, MESSAGE_REQUEST, MESSAGE_RESPONSE, DELAY, VERSION, PROJECT_NAME, PROJECT_VERSION, EBS_NAME, EBS_VERSION, PROCESS_NAME, PROCESS_VERSION, SERVICE_NAME, SERVICE_VERSION, MESSAGE_NAME, MESSAGE_VERSION, PIP_NAME, PIP_VERSION, APPLICATION_NAME, APPLICATION_VERSION, TEST_PRIORITY, REFERENCE_ID_EXTERNAL, AUDITED_ON, AUDITED_BY, REQ_CORR_ID_XPATH, RESP_CORR_ID_XPATH, SETUP_ID, IS_WSA_ENABLED FROM E$CAVS_DEFINITIONS;

ALTER TABLE E$CAVS_DEFINITIONS
    ADD CONSTRAINT DEFINITIONS_PK PRIMARY KEY (DEFINITION_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_GRPDEFINITION_DEFINITIO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_GRPDEFINITION_DEFINITIO
(
    GROUP_DEFINITION_ID NUMBER(15,0) NOT NULL,
    SEQ_ID NUMBER(5) NOT NULL,
    DEFINITION_ID NUMBER(15,0) NOT NULL,
    DEFINITION_SEQ_ID NUMBER(5) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPDEFINITION_DEFINITIONS
 AS SELECT GROUP_DEFINITION_ID, SEQ_ID, DEFINITION_ID, DEFINITION_SEQ_ID FROM E$CAVS_GRPDEFINITION_DEFINITIO;

ALTER TABLE E$CAVS_GRPDEFINITION_DEFINITIO
    ADD CONSTRAINT GROUP_DEFINITION_DEFNS_PK PRIMARY KEY (GROUP_DEFINITION_ID, SEQ_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_GRPDEFINITIONS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_GRPDEFINITIONS
(
    GROUP_DEFINITION_ID NUMBER(15,0) NOT NULL,
    DESCRIPTION VARCHAR2(80) NOT NULL,
    PROCESS_NAME VARCHAR2(80),
    PIP_NAME VARCHAR2(80)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPDEFINITIONS
 AS SELECT GROUP_DEFINITION_ID, DESCRIPTION, PROCESS_NAME, PIP_NAME FROM E$CAVS_GRPDEFINITIONS;

ALTER TABLE E$CAVS_GRPDEFINITIONS
    ADD CONSTRAINT GROUP_DEFINITIONS_PK PRIMARY KEY (GROUP_DEFINITION_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_GRPINSTANCE_INSTANCES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_GRPINSTANCE_INSTANCES
(
    GROUP_DEFINITION_ID NUMBER(15,0) NOT NULL,
    GROUP_INSTANCE_ID NUMBER(15,0) NOT NULL,
    INSTANCE_ID NUMBER(15,0) NOT NULL,
    ENDED_ON TIMESTAMP,
    DEFINITION_ID NUMBER(15,0),
    DEFINITION_SEQ_ID NUMBER(5) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPINSTANCE_INSTANCES
 AS SELECT GROUP_DEFINITION_ID, GROUP_INSTANCE_ID, INSTANCE_ID, ENDED_ON, DEFINITION_ID, DEFINITION_SEQ_ID FROM E$CAVS_GRPINSTANCE_INSTANCES;

ALTER TABLE E$CAVS_GRPINSTANCE_INSTANCES
    ADD CONSTRAINT GROUP_INSTANCE_INSTANCES_PK PRIMARY KEY (GROUP_DEFINITION_ID, GROUP_INSTANCE_ID, INSTANCE_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_GRPINSTANCES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_GRPINSTANCES
(
    GROUP_DEFINITION_ID NUMBER(15,0) NOT NULL,
    GROUP_INSTANCE_ID NUMBER(15,0) NOT NULL,
    STARTED_ON TIMESTAMP,
    CREATED_BY VARCHAR2(20),
    DESCRIPTION VARCHAR2(80),
    PROCESS_NAME VARCHAR2(80),
    PIP_NAME VARCHAR2(80)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPINSTANCES
 AS SELECT GROUP_DEFINITION_ID, GROUP_INSTANCE_ID, STARTED_ON, CREATED_BY, DESCRIPTION, PROCESS_NAME, PIP_NAME FROM E$CAVS_GRPINSTANCES;

ALTER TABLE E$CAVS_GRPINSTANCES
    ADD CONSTRAINT GROUP_INSTANCES_PK PRIMARY KEY (GROUP_DEFINITION_ID, GROUP_INSTANCE_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_INSTANCE_NSXPATHS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_INSTANCE_NSXPATHS
(
    INSTANCE_ID NUMBER(15,0) NOT NULL,
    NAMESPACE_ALIAS VARCHAR2(30) NOT NULL,
    NAMESPACE VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCE_NSXPATHS
 AS SELECT INSTANCE_ID, NAMESPACE_ALIAS, NAMESPACE FROM E$CAVS_INSTANCE_NSXPATHS;

ALTER TABLE E$CAVS_INSTANCE_NSXPATHS
    ADD CONSTRAINT INSTANCE_NSXPATHS_PK PRIMARY KEY (INSTANCE_ID, NAMESPACE_ALIAS);

-- ----------------------------------------------------------------------- 
-- E$CAVS_INSTANCE_XPATHS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_INSTANCE_XPATHS
(
    INSTANCE_ID NUMBER(15,0) NOT NULL,
    XPATH_SEQ_ID NUMBER(5) NOT NULL,
    STATUS VARCHAR2(10) NOT NULL,
    XPATH VARCHAR2(2048),
    IS_NODE_KEY NUMBER(1) DEFAULT 0,
    NODE_VALUE_KEY VARCHAR2(100),
    CONDITION VARCHAR2(10),
    NODE_VALUE_EXPECTED VARCHAR2(2048),
    NODE_VALUE_ACTUAL VARCHAR2(2048)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCE_XPATHS
 AS SELECT INSTANCE_ID, XPATH_SEQ_ID, STATUS, XPATH, IS_NODE_KEY, NODE_VALUE_KEY, CONDITION, NODE_VALUE_EXPECTED, NODE_VALUE_ACTUAL FROM E$CAVS_INSTANCE_XPATHS;

ALTER TABLE E$CAVS_INSTANCE_XPATHS
    ADD CONSTRAINT INSTANCE_XPATHS_PK PRIMARY KEY (INSTANCE_ID, XPATH_SEQ_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_INSTANCE_XREFS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_INSTANCE_XREFS
(
    INSTANCE_ID_TEST NUMBER(15,0) NOT NULL,
    INSTANCE_ID_SIMULATOR NUMBER(15,0) NOT NULL
)
;

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCE_XREFS
 AS SELECT INSTANCE_ID_TEST, INSTANCE_ID_SIMULATOR FROM E$CAVS_INSTANCE_XREFS;

ALTER TABLE E$CAVS_INSTANCE_XREFS
    ADD CONSTRAINT INSTANCE_XREF_PK PRIMARY KEY (INSTANCE_ID_TEST, INSTANCE_ID_SIMULATOR);

-- ----------------------------------------------------------------------- 
-- E$CAVS_INSTANCES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_INSTANCES
(
    INSTANCE_ID NUMBER(15,0) NOT NULL,
    TYPE VARCHAR2(10) NOT NULL,
    STATUS VARCHAR2(10) NOT NULL,
    STARTED_ON TIMESTAMP,
    ENDED_ON TIMESTAMP,
    TEST_COMPLETED_ON TIMESTAMP,
    CREATED_BY VARCHAR2(20),
    IS_STALED NUMBER(1) DEFAULT 0 NOT NULL,
    GROUP_INSTANCE_ID NUMBER(15,0),
    DEFINITION_ID NUMBER(15,0),
    DESCRIPTION VARCHAR2(80),
    SERVICE_TYPE VARCHAR2(20),
    URL_WSDL VARCHAR2(1000),
    URL_REQUESTER VARCHAR2(1000),
    URL_ENDPOINT VARCHAR2(1000),
    SOAP_ACTION VARCHAR2(200),
    SOAP_TRANSPORT_TYPE VARCHAR2(5),
    WS_ADDRESSING VARCHAR2(1000),
    MESSAGE_REQUEST CLOB,
    MESSAGE_RESPONSE CLOB,
    DELAY NUMBER(5),
    VERSION NUMBER(5),
    PROJECT_NAME VARCHAR2(30),
    PROJECT_VERSION VARCHAR2(10),
    EBS_NAME VARCHAR2(30),
    EBS_VERSION VARCHAR2(10),
    PROCESS_NAME VARCHAR2(80),
    PROCESS_VERSION VARCHAR2(10),
    SERVICE_NAME VARCHAR2(80),
    SERVICE_VERSION VARCHAR2(10),
    MESSAGE_NAME VARCHAR2(30),
    MESSAGE_VERSION VARCHAR2(10),
    PIP_NAME VARCHAR2(80),
    PIP_VERSION VARCHAR2(10),
    APPLICATION_NAME VARCHAR2(30),
    APPLICATION_VERSION VARCHAR2(10),
    TEST_PRIORITY VARCHAR2(1),
    REFERENCE_ID_EXTERNAL VARCHAR2(30),
    REQ_CORR_ID_XPATH VARCHAR2(2048),
    RESP_CORR_ID_XPATH VARCHAR2(2048)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCES
 AS SELECT INSTANCE_ID, TYPE, STATUS, STARTED_ON, ENDED_ON, TEST_COMPLETED_ON, CREATED_BY, IS_STALED, GROUP_INSTANCE_ID, DEFINITION_ID, DESCRIPTION, SERVICE_TYPE, URL_WSDL, URL_REQUESTER, URL_ENDPOINT, SOAP_ACTION, SOAP_TRANSPORT_TYPE, WS_ADDRESSING, MESSAGE_REQUEST, MESSAGE_RESPONSE, DELAY, VERSION, PROJECT_NAME, PROJECT_VERSION, EBS_NAME, EBS_VERSION, PROCESS_NAME, PROCESS_VERSION, SERVICE_NAME, SERVICE_VERSION, MESSAGE_NAME, MESSAGE_VERSION, PIP_NAME, PIP_VERSION, APPLICATION_NAME, APPLICATION_VERSION, TEST_PRIORITY, REFERENCE_ID_EXTERNAL, REQ_CORR_ID_XPATH, RESP_CORR_ID_XPATH FROM E$CAVS_INSTANCES;

ALTER TABLE E$CAVS_INSTANCES
    ADD CONSTRAINT INSTANCES_PK PRIMARY KEY (INSTANCE_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_ROUTING_SETUP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_ROUTING_SETUP
(
    SETUP_ID NUMBER(15,0) NOT NULL,
    DESCRIPTION VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_ROUTING_SETUP
 AS SELECT SETUP_ID, DESCRIPTION FROM E$CAVS_ROUTING_SETUP;

ALTER TABLE E$CAVS_ROUTING_SETUP
    ADD CONSTRAINT ROUTING_SETUP_ID_PK PRIMARY KEY (SETUP_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_ROUTING_SETUP_DETAILS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_ROUTING_SETUP_DETAILS
(
    SETUP_DETAIL_ID NUMBER(15,0) NOT NULL,
    SETUP_ID NUMBER(15,0) NOT NULL,
    INVOKING_SERVICE_NAME VARCHAR2(100),
    PARTNER_LINK VARCHAR2(100),
    OPERATION VARCHAR2(100),
    ROUTE_TO_CAVS CHAR(5),
    SIMULATOR_ID NUMBER(15,0)
);

CREATE OR REPLACE EDITIONING VIEW CAVS_ROUTING_SETUP_DETAILS
 AS SELECT SETUP_DETAIL_ID, SETUP_ID, INVOKING_SERVICE_NAME, PARTNER_LINK, OPERATION, ROUTE_TO_CAVS, SIMULATOR_ID FROM E$CAVS_ROUTING_SETUP_DETAILS;

ALTER TABLE E$CAVS_ROUTING_SETUP_DETAILS
    ADD CONSTRAINT ROUTING_SETUP_DETAIL_ID_PK PRIMARY KEY (SETUP_DETAIL_ID);

-- ----------------------------------------------------------------------- 
-- E$CAVS_SCHEDULER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CAVS_SCHEDULER
(
    SCHEDULER_ID VARCHAR2(100) NOT NULL,
    ID NUMBER(15,0) NOT NULL,
    TYPE VARCHAR2(30) NOT NULL,
    START_DATE TIMESTAMP NOT NULL,
    END_DATE TIMESTAMP,
    INSTANCE_ID NUMBER(15,0) NOT NULL,
    STATUS VARCHAR2(100) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CAVS_SCHEDULER
 AS SELECT SCHEDULER_ID, ID, TYPE, START_DATE, END_DATE, INSTANCE_ID, STATUS FROM E$CAVS_SCHEDULER;

ALTER TABLE E$CAVS_SCHEDULER
    ADD CONSTRAINT SCHEDULER_PK PRIMARY KEY (SCHEDULER_ID, START_DATE);

-- ----------------------------------------------------------------------- 
-- E$AIA_ERROR_FLEX_FIELD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AIA_ERROR_FLEX_FIELD
(
    PARENT_OID NUMBER(15,0) NOT NULL,
    FLEX_KEY VARCHAR2(1000) NOT NULL,
    VALUE VARCHAR2(2000) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW AIA_ERROR_FLEX_FIELD
 AS SELECT PARENT_OID, FLEX_KEY, VALUE FROM E$AIA_ERROR_FLEX_FIELD;

ALTER TABLE E$AIA_ERROR_FLEX_FIELD
    ADD CONSTRAINT AIA_ERROR_FLEX_FIELD_COM_PK PRIMARY KEY (PARENT_OID, FLEX_KEY);

-- ----------------------------------------------------------------------- 
-- E$AIA_ERROR_MONITOR 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AIA_ERROR_MONITOR
(
    OID NUMBER(15,0) NOT NULL,
    ECID VARCHAR2(200) NOT NULL,
    MESSAGE_ID VARCHAR2(50),
    RESOURCE_TYPE VARCHAR2(50),
    RESOURCE_NAME VARCHAR2(100),
    REPORTED_DATE_TIME TIMESTAMP NOT NULL,
    ERROR_CODE VARCHAR2(1000),
    SYSTEM_CODE VARCHAR2(1000),
    PROCESS_NAME VARCHAR2(1000),
    SERVICE_NAME VARCHAR2(1000),
    COMPOSITE_VERSION VARCHAR2(500),
    DRILL_DOWN_LINK VARCHAR2(2000),
    STACK_TRACE VARCHAR2(2000) NOT NULL,
    COMPOSITE_INSTANCE_ID VARCHAR2(1000) NOT NULL,
    ERROR_STAMPING VARCHAR2(1000),
    SERVICE_ENGINE VARCHAR2(1000),
    RESUBMITTED NUMBER(1) DEFAULT 0 NOT NULL,
    MESSAGE_ORDER NUMBER(15,0) NOT NULL,
    STATUS_MSG VARCHAR2(4000),
    LAST_MODIFIED_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW AIA_ERROR_MONITOR
 AS SELECT OID, ECID, MESSAGE_ID, RESOURCE_TYPE, RESOURCE_NAME, REPORTED_DATE_TIME, ERROR_CODE, SYSTEM_CODE, PROCESS_NAME, SERVICE_NAME, COMPOSITE_VERSION, DRILL_DOWN_LINK, STACK_TRACE, COMPOSITE_INSTANCE_ID, ERROR_STAMPING, SERVICE_ENGINE, RESUBMITTED, MESSAGE_ORDER, STATUS_MSG, LAST_MODIFIED_DATE FROM E$AIA_ERROR_MONITOR;

ALTER TABLE E$AIA_ERROR_MONITOR
    ADD CONSTRAINT AIA_ERROR_INSTANCES_PK PRIMARY KEY (OID);

-- ----------------------------------------------------------------------- 
-- E$AM_APPLICATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AM_APPLICATION
(
    APP_ID NUMBER(19,0) NOT NULL,
    API_KEY VARCHAR2(512) NOT NULL,
    NAME VARCHAR2(512) NOT NULL,
    CONSUMER_ACCOUNT VARCHAR2(512) NOT NULL,
    DESCRIPTION VARCHAR2(1024)
);

CREATE OR REPLACE EDITIONING VIEW AM_APPLICATION
 AS SELECT APP_ID, API_KEY, NAME, CONSUMER_ACCOUNT, DESCRIPTION FROM E$AM_APPLICATION;

ALTER TABLE E$AM_APPLICATION
    ADD CONSTRAINT AM_APPLICATION_PK PRIMARY KEY (APP_ID);

ALTER TABLE E$AM_APPLICATION ADD CONSTRAINT UNQ_AM_APPL_API_KEY UNIQUE
    (API_KEY );

ALTER TABLE E$AM_APPLICATION ADD CONSTRAINT UNQ_AM_APPL_NAME_ACC UNIQUE
    (NAME , CONSUMER_ACCOUNT );

-- ----------------------------------------------------------------------- 
-- E$AM_SUBSCRIPTION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AM_SUBSCRIPTION
(
    SCR_ID NUMBER(19,0) NOT NULL,
    API_ID VARCHAR2(512) NOT NULL,
    APP_ID NUMBER(19,0) NOT NULL,
    DESCRIPTION VARCHAR2(1024)
);

CREATE OR REPLACE EDITIONING VIEW AM_SUBSCRIPTION
 AS SELECT SCR_ID, API_ID, APP_ID, DESCRIPTION FROM E$AM_SUBSCRIPTION;

ALTER TABLE E$AM_SUBSCRIPTION
    ADD CONSTRAINT AM_SUBSCRIPTION_PK PRIMARY KEY (SCR_ID);

ALTER TABLE E$AM_SUBSCRIPTION ADD CONSTRAINT UNQ_AM_SUBS_API_APP UNIQUE
    (API_ID , APP_ID );

-- ----------------------------------------------------------------------- 
-- E$AM_APIVISIBILITY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AM_APIVISIBILITY
(
    API_ID VARCHAR2(512) NOT NULL,
    VISIBILITY NUMBER(10,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW AM_APIVISIBILITY
 AS SELECT API_ID, VISIBILITY FROM E$AM_APIVISIBILITY;

ALTER TABLE E$AM_APIVISIBILITY
    ADD CONSTRAINT AM_APIVISIBILITY_PK PRIMARY KEY (API_ID);

-- ----------------------------------------------------------------------- 
-- E$AM_ID_GENERATOR 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AM_ID_GENERATOR
(
    ID_COL_NAME VARCHAR2(50) NOT NULL,
    ID_COL_VAL NUMBER(38,0)
);

CREATE OR REPLACE EDITIONING VIEW AM_ID_GENERATOR
 AS SELECT ID_COL_NAME, ID_COL_VAL FROM E$AM_ID_GENERATOR;

ALTER TABLE E$AM_ID_GENERATOR
    ADD CONSTRAINT AM_ID_GENERATOR_PK PRIMARY KEY (ID_COL_NAME);

-- ----------------------------------------------------------------------- 
-- E$B2B_STREAMSTORE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_STREAMSTORE
(
    DOCUMENTID VARCHAR2(256) NOT NULL,
    CONTENT BLOB
);

CREATE OR REPLACE EDITIONING VIEW B2B_STREAMSTORE
 AS SELECT DOCUMENTID, CONTENT FROM E$B2B_STREAMSTORE;

ALTER TABLE E$B2B_STREAMSTORE
    ADD CONSTRAINT B2B_STREAMSTORE_PK PRIMARY KEY (DOCUMENTID);

-- ----------------------------------------------------------------------- 
-- E$B2B_DATA_STORAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_DATA_STORAGE
(
    VALUE_SELECTOR VARCHAR2(256),
    CLOB_VALUE CLOB,
    BLOB_VALUE BLOB,
    DATA_SIZE NUMBER(10,0),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    LABEL VARCHAR2(256),
    DOCUMENT_ID VARCHAR2(200),
    JOB_ID VARCHAR2(128),
    ID VARCHAR2(256) NOT NULL,
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT systimestamp-30,
    IS_OBFUSCATED NUMBER(1)
)
 PARTITION BY RANGE (CPST_INST_CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW B2B_DATA_STORAGE
 AS SELECT VALUE_SELECTOR, CLOB_VALUE, BLOB_VALUE, DATA_SIZE, ATTRIBUTE1, ATTRIBUTE2, LABEL, DOCUMENT_ID, JOB_ID, ID, CPST_INST_CREATED_TIME, IS_OBFUSCATED FROM E$B2B_DATA_STORAGE;

ALTER TABLE E$B2B_DATA_STORAGE
    ADD CONSTRAINT B2B_DATA_STORAGE_PK PRIMARY KEY (ID);

CREATE INDEX B2B_IDX_DS_DOC ON E$B2B_DATA_STORAGE
    (DOCUMENT_ID );

-- ----------------------------------------------------------------------- 
-- E$B2B_APP_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_APP_MESSAGE
(
    ID VARCHAR2(256) NOT NULL,
    SENDER_ID_TYPE VARCHAR2(512),
    SENDER_ID_VALUE VARCHAR2(512),
    RECEIVER_ID_TYPE VARCHAR2(512),
    RECEIVER_ID_VALUE VARCHAR2(512),
    DOC_TYPE VARCHAR2(512),
    DOCUMENT_DEFINITION VARCHAR2(512),
    DOC_PROTOCOL_NAME VARCHAR2(512),
    DOC_PROTOCOL_VERSION VARCHAR2(512),
    APP_MESSAGE_ID VARCHAR2(256),
    REF_TO_APP_MESSAGE_ID VARCHAR2(256),
    APP_CONV_ID VARCHAR2(256),
    APP_MESSAGE_PROPS CLOB,
    ACTION_NAME VARCHAR2(256),
    DIRECTION VARCHAR2(256),
    STATE VARCHAR2(256),
    MESSAGE_TYPE VARCHAR2(256),
    ERROR_CODE VARCHAR2(256),
    ERROR_TEXT VARCHAR2(1024),
    ERROR_DESCRIPTION VARCHAR2(2000),
    ERROR_TEXT_CLOB CLOB,
    ERROR_DESCRIPTION_CLOB CLOB,
    CREATED DATE,
    MODIFIED DATE,
    PAYLOAD_NAME VARCHAR2(256),
    MSG_SIZE NUMBER(10,0),
    LABEL VARCHAR2(256),
    URL VARCHAR2(1024),
    PAYLOAD VARCHAR2(256),
    BUSINESS_MESSAGE VARCHAR2(256),
    DOCUMENT_ID VARCHAR2(256),
    RETRY_INTERVAL NUMBER(10,0),
    REATTEMPT_COUNT NUMBER(10,0),
    REMAINING_RETRY NUMBER(10,0),
    RESUBMIT_COUNT NUMBER(10,0),
    FABRIC_APPLICATION_NAME VARCHAR2(512),
    FABRIC_COMPOSITE_VERSION VARCHAR2(512),
    FABRIC_COMPOSITE_NAME VARCHAR2(512),
    FABRIC_SERVICE_NAME VARCHAR2(512),
    FABRIC_REFERENCE_NAME VARCHAR2(512),
    FABRIC_ECID VARCHAR2(512),
    FABRIC_COMPOSITE_INSTANCE_ID VARCHAR2(512),
    FABRIC_PRT_COMPOSITE_INST_ID VARCHAR2(512),
    FABRIC_CONVERSATION_ID VARCHAR2(512),
    FABRIC_LABEL VARCHAR2(512),
    FABRIC_COMPOSITEDN VARCHAR2(512),
    ATTACHMENT_STORAGE VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(512),
    JOB_ID VARCHAR2(128),
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT systimestamp-30,
    LAST_RESUBMITTED_USER_NAME VARCHAR2(128),
    LAST_RESUBMITTED_TIME_STAMP DATE,
    LAST_VIEWED_USER_NAME VARCHAR2(128),
    LAST_VIEWED_TIME_STAMP DATE,
    INTERNAL_ENDPOINT_NAME VARCHAR2(128),
    MESSAGE_MODE VARCHAR2(10),
    TRANSFORM_PAYLOAD VARCHAR2(1),
    MESSAGE_STATUS VARCHAR2(64),
    RESUBMIT_REF_TO VARCHAR2(128)
)
 PARTITION BY RANGE (CPST_INST_CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW B2B_APP_MESSAGE
 AS SELECT ID, SENDER_ID_TYPE, SENDER_ID_VALUE, RECEIVER_ID_TYPE, RECEIVER_ID_VALUE, DOC_TYPE, DOCUMENT_DEFINITION, DOC_PROTOCOL_NAME, DOC_PROTOCOL_VERSION, APP_MESSAGE_ID, REF_TO_APP_MESSAGE_ID, APP_CONV_ID, APP_MESSAGE_PROPS, ACTION_NAME, DIRECTION, STATE, MESSAGE_TYPE, ERROR_CODE, ERROR_TEXT, ERROR_DESCRIPTION, ERROR_TEXT_CLOB, ERROR_DESCRIPTION_CLOB, CREATED, MODIFIED, PAYLOAD_NAME, MSG_SIZE, LABEL, URL, PAYLOAD, BUSINESS_MESSAGE, DOCUMENT_ID, RETRY_INTERVAL, REATTEMPT_COUNT, REMAINING_RETRY, RESUBMIT_COUNT, FABRIC_APPLICATION_NAME, FABRIC_COMPOSITE_VERSION, FABRIC_COMPOSITE_NAME, FABRIC_SERVICE_NAME, FABRIC_REFERENCE_NAME, FABRIC_ECID, FABRIC_COMPOSITE_INSTANCE_ID, FABRIC_PRT_COMPOSITE_INST_ID, FABRIC_CONVERSATION_ID, FABRIC_LABEL, FABRIC_COMPOSITEDN, ATTACHMENT_STORAGE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, JOB_ID, CPST_INST_CREATED_TIME, LAST_RESUBMITTED_USER_NAME, LAST_RESUBMITTED_TIME_STAMP, LAST_VIEWED_USER_NAME, LAST_VIEWED_TIME_STAMP, INTERNAL_ENDPOINT_NAME, MESSAGE_MODE, TRANSFORM_PAYLOAD, MESSAGE_STATUS, RESUBMIT_REF_TO FROM E$B2B_APP_MESSAGE;

ALTER TABLE E$B2B_APP_MESSAGE
    ADD CONSTRAINT B2B_APP_MESSAGE_PK PRIMARY KEY (ID);

CREATE INDEX B2B_IDX_AM_MSG_ID ON E$B2B_APP_MESSAGE
    (APP_MESSAGE_ID );

CREATE INDEX B2B_IDX_AM_ECID ON E$B2B_APP_MESSAGE
    (FABRIC_ECID );

CREATE INDEX B2B_IDX_AM_PAY ON E$B2B_APP_MESSAGE
    (PAYLOAD );

CREATE INDEX B2B_IDX_AM_ATT_STR ON E$B2B_APP_MESSAGE
    (ATTACHMENT_STORAGE );

CREATE INDEX B2B_IDX_AM_BM ON E$B2B_APP_MESSAGE
    (BUSINESS_MESSAGE );

CREATE UNIQUE INDEX B2B_APP_APP_CONV_ID ON E$B2B_APP_MESSAGE
    (APP_CONV_ID );

-- ----------------------------------------------------------------------- 
-- E$B2B_AUDIT_TEMP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_AUDIT_TEMP
(
    AUDIT_ID VARCHAR2(256) NOT NULL,
    MESSAGE_ID VARCHAR2(256) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW B2B_AUDIT_TEMP
 AS SELECT AUDIT_ID, MESSAGE_ID FROM E$B2B_AUDIT_TEMP;

-- ----------------------------------------------------------------------- 
-- E$B2B_BATCH_EVENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_BATCH_EVENT
(
    ID VARCHAR2(256) NOT NULL,
    EXPIRE_TIME DATE,
    INTERVAL INTEGER,
    TO_TP_NAME VARCHAR2(256),
    DOC_TYPE VARCHAR2(256),
    DOC_TYPE_REV VARCHAR2(256),
    MSG_COUNT INTEGER,
    STATE INTEGER,
    ENABLE INTEGER,
    BATCH_NAME VARCHAR2(512),
    START_DATE DATE,
    END_DATE DATE,
    BATCH_TIME_STAMP DATE,
    SCHEDULE VARCHAR2(256),
    REPEAT_TYPE VARCHAR2(2048),
    REPEAT_ON_DAY VARCHAR2(128),
    REPEAT_EVERY INTEGER,
    CRITERIA1 VARCHAR2(256),
    CRITERIA2 VARCHAR2(256),
    CRITERIA3 VARCHAR2(256),
    CRITERIA4 INTEGER,
    CRITERIA5 INTEGER,
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256),
    SCHEDULE_TYPE VARCHAR2(128),
    CHANNEL_NAME VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW B2B_BATCH_EVENT
 AS SELECT ID, EXPIRE_TIME, INTERVAL, TO_TP_NAME, DOC_TYPE, DOC_TYPE_REV, MSG_COUNT, STATE, ENABLE, BATCH_NAME, START_DATE, END_DATE, BATCH_TIME_STAMP, SCHEDULE, REPEAT_TYPE, REPEAT_ON_DAY, REPEAT_EVERY, CRITERIA1, CRITERIA2, CRITERIA3, CRITERIA4, CRITERIA5, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, SCHEDULE_TYPE, CHANNEL_NAME FROM E$B2B_BATCH_EVENT;

ALTER TABLE E$B2B_BATCH_EVENT
    ADD CONSTRAINT B2B_BATCH_EVENT_PK PRIMARY KEY (ID);

CREATE UNIQUE INDEX B2B_BE_CON1 ON E$B2B_BATCH_EVENT
    (TO_TP_NAME , DOC_TYPE , DOC_TYPE_REV );

-- ----------------------------------------------------------------------- 
-- E$B2B_BUSINESS_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_BUSINESS_MESSAGE
(
    MESSAGE_ID VARCHAR2(256) NOT NULL,
    REFER_TO_MESSAGE_ID VARCHAR2(256),
    SENDER_ID_TYPE VARCHAR2(256),
    SENDER_ID_VALUE VARCHAR2(256),
    RECEIVER_ID_TYPE VARCHAR2(256),
    RECEIVER_ID_VALUE VARCHAR2(256),
    SENDER_NAME VARCHAR2(256),
    RECEIVER_NAME VARCHAR2(256),
    TPA_ID VARCHAR2(256),
    TPA_NAME VARCHAR2(256),
    DOCTYPE_NAME VARCHAR2(256),
    DOC_PROTOCOL_NAME VARCHAR2(256),
    DOC_PROTOCOL_VERSION VARCHAR2(256),
    DOCUMENT_DEFINITION VARCHAR2(256),
    MESSAGE_TYPE VARCHAR2(256),
    DIRECTION VARCHAR2(256),
    STATE VARCHAR2(256),
    ACK_MODE VARCHAR2(256),
    ACK_TYPE VARCHAR2(256),
    TIME_TO_ACK VARCHAR2(256),
    RESPONSE_MODE VARCHAR2(256),
    CONTENT_TYPE VARCHAR2(256),
    PAYLOAD_NAME VARCHAR2(256),
    CREATED DATE,
    MODIFIED DATE,
    SEND_TIMESTAMP TIMESTAMP,
    RECEIVE_TIMESTAMP TIMESTAMP,
    DOC_RETRY_INTERVAL NUMBER(10,0),
    DOC_ATTEMPT_COUNT NUMBER(10,0),
    DOC_REMAINING_RETRY NUMBER(10,0),
    NATIVE_MSG_SIZE NUMBER(10,0),
    TRANSLATED_MSG_SIZE NUMBER(10,0),
    BATCH_ID VARCHAR2(256),
    XPATH_NAME1 VARCHAR2(256),
    XPATH_VALUE1 VARCHAR2(256),
    XPATH_EXPRESSION1 VARCHAR2(1024),
    XPATH_NAME2 VARCHAR2(256),
    XPATH_VALUE2 VARCHAR2(256),
    XPATH_EXPRESSION2 VARCHAR2(1024),
    XPATH_NAME3 VARCHAR2(256),
    XPATH_VALUE3 VARCHAR2(256),
    XPATH_EXPRESSION3 VARCHAR2(1024),
    CORRELATION_FROM_XPATH_NAME VARCHAR2(256),
    CORRELATION_FROM_XPATH_XPR VARCHAR2(1024),
    CORRELATION_FROM_XPATH_VALUE VARCHAR2(256),
    CORRELATION_TO_XPATH_NAME VARCHAR2(256),
    CORRELATION_TO_XPATH_XPR VARCHAR2(1024),
    CORRELATION_TO_XPATH_VALUE VARCHAR2(256),
    RESUBMIT_COUNT NUMBER(10,0),
    EXT_BUSINESS_MESSAGE VARCHAR2(256),
    WIRE_MESSAGE VARCHAR2(256),
    PAYLOAD_STORAGE VARCHAR2(256),
    ATTACHMENT_STORAGE VARCHAR2(256),
    NATIVE_DATA_STORAGE VARCHAR2(256),
    TRANSLATED_DATA_STORAGE VARCHAR2(256),
    APP_MESSAGE VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256),
    LABEL VARCHAR2(256),
    JOB_ID VARCHAR2(128),
    ID VARCHAR2(256) NOT NULL,
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT systimestamp-30,
    LAST_RESUBMITTED_USER_NAME VARCHAR2(128),
    LAST_RESUBMITTED_TIME_STAMP DATE,
    LAST_VIEWED_USER_NAME VARCHAR2(128),
    LAST_VIEWED_TIME_STAMP DATE,
    CHANNEL_NAME VARCHAR2(256),
    USER_COMMENT VARCHAR2(1024),
    ORIGINAL_STATE VARCHAR2(256),
    MESSAGE_STATUS VARCHAR2(64),
    RESUBMIT_REF_TO VARCHAR2(128),
    DOC_EVENT VARCHAR2(128)
)
 PARTITION BY RANGE (CPST_INST_CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW B2B_BUSINESS_MESSAGE
 AS SELECT MESSAGE_ID, REFER_TO_MESSAGE_ID, SENDER_ID_TYPE, SENDER_ID_VALUE, RECEIVER_ID_TYPE, RECEIVER_ID_VALUE, SENDER_NAME, RECEIVER_NAME, TPA_ID, TPA_NAME, DOCTYPE_NAME, DOC_PROTOCOL_NAME, DOC_PROTOCOL_VERSION, DOCUMENT_DEFINITION, MESSAGE_TYPE, DIRECTION, STATE, ACK_MODE, ACK_TYPE, TIME_TO_ACK, RESPONSE_MODE, CONTENT_TYPE, PAYLOAD_NAME, CREATED, MODIFIED, SEND_TIMESTAMP, RECEIVE_TIMESTAMP, DOC_RETRY_INTERVAL, DOC_ATTEMPT_COUNT, DOC_REMAINING_RETRY, NATIVE_MSG_SIZE, TRANSLATED_MSG_SIZE, BATCH_ID, XPATH_NAME1, XPATH_VALUE1, XPATH_EXPRESSION1, XPATH_NAME2, XPATH_VALUE2, XPATH_EXPRESSION2, XPATH_NAME3, XPATH_VALUE3, XPATH_EXPRESSION3, CORRELATION_FROM_XPATH_NAME, CORRELATION_FROM_XPATH_XPR, CORRELATION_FROM_XPATH_VALUE, CORRELATION_TO_XPATH_NAME, CORRELATION_TO_XPATH_XPR, CORRELATION_TO_XPATH_VALUE, RESUBMIT_COUNT, EXT_BUSINESS_MESSAGE, WIRE_MESSAGE, PAYLOAD_STORAGE, ATTACHMENT_STORAGE, NATIVE_DATA_STORAGE, TRANSLATED_DATA_STORAGE, APP_MESSAGE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, LABEL, JOB_ID, ID, CPST_INST_CREATED_TIME, LAST_RESUBMITTED_USER_NAME, LAST_RESUBMITTED_TIME_STAMP, LAST_VIEWED_USER_NAME, LAST_VIEWED_TIME_STAMP, CHANNEL_NAME, USER_COMMENT, ORIGINAL_STATE, MESSAGE_STATUS, RESUBMIT_REF_TO, DOC_EVENT FROM E$B2B_BUSINESS_MESSAGE;

ALTER TABLE E$B2B_BUSINESS_MESSAGE
    ADD CONSTRAINT B2B_BUSINESS_MESSAGE_PK PRIMARY KEY (ID);

CREATE INDEX B2B_IDX_BM_NAT_DAT_STR ON E$B2B_BUSINESS_MESSAGE
    (NATIVE_DATA_STORAGE );

CREATE INDEX B2B_IDX_BM_TRANS_DAT_STR ON E$B2B_BUSINESS_MESSAGE
    (TRANSLATED_DATA_STORAGE );

CREATE INDEX B2B_IDX_BM_ATT_DAT_STR ON E$B2B_BUSINESS_MESSAGE
    (ATTACHMENT_STORAGE );

CREATE INDEX B2B_IDX_BM_PAY_STR ON E$B2B_BUSINESS_MESSAGE
    (PAYLOAD_STORAGE );

CREATE INDEX B2B_IDX_BM_EXT_BM ON E$B2B_BUSINESS_MESSAGE
    (EXT_BUSINESS_MESSAGE );

CREATE INDEX B2B_IDX_BM_REF_ID ON E$B2B_BUSINESS_MESSAGE
    (REFER_TO_MESSAGE_ID );

CREATE INDEX B2B_IDX_BM_MSG_ID ON E$B2B_BUSINESS_MESSAGE
    (MESSAGE_ID );

CREATE INDEX B2B_IDX_BM_AM ON E$B2B_BUSINESS_MESSAGE
    (APP_MESSAGE );

CREATE INDEX B2B_IDX_BM_BAT ON E$B2B_BUSINESS_MESSAGE
    (BATCH_ID );

CREATE INDEX B2B_IDX_BM_COR1 ON E$B2B_BUSINESS_MESSAGE
    (CORRELATION_FROM_XPATH_VALUE , SENDER_NAME );

CREATE INDEX B2B_IDX_BM_COR2 ON E$B2B_BUSINESS_MESSAGE
    (CORRELATION_FROM_XPATH_VALUE , RECEIVER_NAME );

CREATE INDEX B2B_IDX_BM_WM ON E$B2B_BUSINESS_MESSAGE
    (WIRE_MESSAGE );

CREATE INDEX B2B_IDX_BM_CPST ON E$B2B_BUSINESS_MESSAGE
    (CPST_INST_CREATED_TIME );

CREATE INDEX B2B_IDX_BM_STATE ON E$B2B_BUSINESS_MESSAGE
    (STATE );

CREATE INDEX B2B_IDX_BM_CREATE ON E$B2B_BUSINESS_MESSAGE
    (CREATED DESC);

CREATE INDEX B2B_IDX_BM_SEND_TMSP ON E$B2B_BUSINESS_MESSAGE
    (SEND_TIMESTAMP );

CREATE INDEX B2B_IDX_BM_RECEIVE_TMSP ON E$B2B_BUSINESS_MESSAGE
    (RECEIVE_TIMESTAMP );

-- ----------------------------------------------------------------------- 
-- E$B2B_BUSINESS_MESSAGE_RETRY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_BUSINESS_MESSAGE_RETRY
(
    MESSAGE_ID VARCHAR2(256) NOT NULL,
    SCHEDULE_DUE_TS DATE,
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW B2B_BUSINESS_MESSAGE_RETRY
 AS SELECT MESSAGE_ID, SCHEDULE_DUE_TS, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3 FROM E$B2B_BUSINESS_MESSAGE_RETRY;

ALTER TABLE E$B2B_BUSINESS_MESSAGE_RETRY
    ADD CONSTRAINT B2B_BM_RETRY_PK PRIMARY KEY (MESSAGE_ID);

-- ----------------------------------------------------------------------- 
-- E$B2B_CONTROL_NUMBER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_CONTROL_NUMBER
(
    SENDER_NAME VARCHAR2(512) NOT NULL,
    RECEIVER_NAME VARCHAR2(512) NOT NULL,
    DOC_PROTOCOL_NAME VARCHAR2(256) NOT NULL,
    DIRECTION VARCHAR2(256) NOT NULL,
    INTERCHANGE VARCHAR2(36),
    GROUP_NUM VARCHAR2(36),
    TRANSACTION_NUM VARCHAR2(36),
    START_INTERCHANGE VARCHAR2(36),
    START_GROUP_NUM VARCHAR2(36),
    START_TRANSACTION_NUM VARCHAR2(36),
    MAX_INTERCHANGE VARCHAR2(36),
    MAX_GROUP_NUM VARCHAR2(36),
    MAX_TRANSACTION_NUM VARCHAR2(36),
    SCHEDULE VARCHAR2(256),
    SCHEDULE_ID VARCHAR2(64),
    NAME VARCHAR2(256) NOT NULL,
    IS_DEFAULT NUMBER(1) NOT NULL,
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ID VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW B2B_CONTROL_NUMBER
 AS SELECT SENDER_NAME, RECEIVER_NAME, DOC_PROTOCOL_NAME, DIRECTION, INTERCHANGE, GROUP_NUM, TRANSACTION_NUM, START_INTERCHANGE, START_GROUP_NUM, START_TRANSACTION_NUM, MAX_INTERCHANGE, MAX_GROUP_NUM, MAX_TRANSACTION_NUM, SCHEDULE, SCHEDULE_ID, NAME, IS_DEFAULT, ATTRIBUTE1, ATTRIBUTE2, ID FROM E$B2B_CONTROL_NUMBER;

ALTER TABLE E$B2B_CONTROL_NUMBER
    ADD CONSTRAINT B2B_CONTROL_NUMBER_PK PRIMARY KEY (SENDER_NAME, RECEIVER_NAME, DOC_PROTOCOL_NAME, DIRECTION, NAME, IS_DEFAULT);

CREATE INDEX B2B_IDX_CN_ALL ON E$B2B_CONTROL_NUMBER
    (DOC_PROTOCOL_NAME , DIRECTION , RECEIVER_NAME , SENDER_NAME , NAME , IS_DEFAULT );

-- ----------------------------------------------------------------------- 
-- E$B2B_CONTROL_NUMBER_SET 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_CONTROL_NUMBER_SET
(
    ID VARCHAR2(256) NOT NULL,
    NAME VARCHAR2(256),
    PROTOCOL VARCHAR2(256),
    TRADINGPARTNER VARCHAR2(256),
    DIRECTION VARCHAR2(10),
    TYPE1 VARCHAR2(256),
    CONTROL_NUMBER1 VARCHAR2(256),
    TYPE2 VARCHAR2(256),
    CONTROL_NUMBER2 VARCHAR2(256),
    TYPE3 VARCHAR2(256),
    CONTROL_NUMBER3 VARCHAR2(256),
    IS_DEFAULT VARCHAR2(1),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW B2B_CONTROL_NUMBER_SET
 AS SELECT ID, NAME, PROTOCOL, TRADINGPARTNER, DIRECTION, TYPE1, CONTROL_NUMBER1, TYPE2, CONTROL_NUMBER2, TYPE3, CONTROL_NUMBER3, IS_DEFAULT, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5 FROM E$B2B_CONTROL_NUMBER_SET;

ALTER TABLE E$B2B_CONTROL_NUMBER_SET
    ADD CONSTRAINT B2B_CONTROL_NUMBER_SET_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$B2B_CTL_NUMBER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_CTL_NUMBER
(
    ID VARCHAR2(256) NOT NULL,
    MIN NUMBER(10,0),
    MAX NUMBER(10,0),
    INCR NUMBER(10,0),
    START_VAL NUMBER(10,0),
    SEQ_ID VARCHAR2(256),
    VALUE NUMBER(10,0),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW B2B_CTL_NUMBER
 AS SELECT ID, MIN, MAX, INCR, START_VAL, SEQ_ID, VALUE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5 FROM E$B2B_CTL_NUMBER;

ALTER TABLE E$B2B_CTL_NUMBER
    ADD CONSTRAINT B2B_CTL_NUMBER_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$B2B_EXT_BUSINESS_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_EXT_BUSINESS_MESSAGE
(
    PROTOCOL_WORK_AREA CLOB,
    COLLABORATION_NAME VARCHAR2(256),
    COLLABORATION_VERSION VARCHAR2(256),
    BUSINESS_TRANSACTION_NAME VARCHAR2(256),
    BUSINESS_TRANSACTION_VERSION VARCHAR2(256),
    BUSINESS_ACTION_NAME VARCHAR2(256),
    COLLABORATION_ID VARCHAR2(256),
    BUSINESS_TRANSACTION_ID VARCHAR2(256),
    TO_ROLE VARCHAR2(256),
    FROM_ROLE VARCHAR2(256),
    COLLABORATION_STATE VARCHAR2(256),
    EXCHANGE_PROTOCOL_NAME VARCHAR2(256),
    EXCHANGE_PROTOCOL_VERSION VARCHAR2(256),
    INTERCHANGE_CONTROL_NUMBER VARCHAR2(256),
    GROUP_CONTROL_NUMBER VARCHAR2(256),
    TXNSET_CONTROL_NUMBER VARCHAR2(256),
    ERROR_SEVERITY VARCHAR2(256),
    ERROR_LEVEL VARCHAR2(256),
    ERROR_CODE VARCHAR2(256),
    ERROR_TEXT VARCHAR2(1024),
    ERROR_TEXT_CLOB CLOB,
    ERROR_DESCRIPTION VARCHAR2(2000),
    ERROR_DESCRIPTION_CLOB CLOB,
    ERROR_DETAIL VARCHAR2(2000),
    ERROR_DETAIL_CLOB CLOB,
    PROCESSING_TIME NUMBER(10,0),
    DELIVERED_ENDPOINT VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    LABEL VARCHAR2(256),
    SEQUENCE_TARGET VARCHAR2(256),
    QUEUE_TIME VARCHAR2(256),
    BUSINESS_MESSAGE VARCHAR2(256),
    JOB_ID VARCHAR2(128),
    ID VARCHAR2(256) NOT NULL,
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT systimestamp-30,
    INTERCHANGE_SENDER_ID VARCHAR2(256),
    INTERCHANGE_RECEIVER_ID VARCHAR2(256),
    INBOUND_MESSAGE_ID VARCHAR2(256),
    WIRE_CORRELATION_ID VARCHAR2(256),
    CORRELATION_FLOW_ID VARCHAR2(256)
)
 PARTITION BY RANGE (CPST_INST_CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW B2B_EXT_BUSINESS_MESSAGE
 AS SELECT PROTOCOL_WORK_AREA, COLLABORATION_NAME, COLLABORATION_VERSION, BUSINESS_TRANSACTION_NAME, BUSINESS_TRANSACTION_VERSION, BUSINESS_ACTION_NAME, COLLABORATION_ID, BUSINESS_TRANSACTION_ID, TO_ROLE, FROM_ROLE, COLLABORATION_STATE, EXCHANGE_PROTOCOL_NAME, EXCHANGE_PROTOCOL_VERSION, INTERCHANGE_CONTROL_NUMBER, GROUP_CONTROL_NUMBER, TXNSET_CONTROL_NUMBER, ERROR_SEVERITY, ERROR_LEVEL, ERROR_CODE, ERROR_TEXT, ERROR_TEXT_CLOB, ERROR_DESCRIPTION, ERROR_DESCRIPTION_CLOB, ERROR_DETAIL, ERROR_DETAIL_CLOB, PROCESSING_TIME, DELIVERED_ENDPOINT, ATTRIBUTE1, ATTRIBUTE2, LABEL, SEQUENCE_TARGET, QUEUE_TIME, BUSINESS_MESSAGE, JOB_ID, ID, CPST_INST_CREATED_TIME, INTERCHANGE_SENDER_ID, INTERCHANGE_RECEIVER_ID, INBOUND_MESSAGE_ID, WIRE_CORRELATION_ID, CORRELATION_FLOW_ID FROM E$B2B_EXT_BUSINESS_MESSAGE;

ALTER TABLE E$B2B_EXT_BUSINESS_MESSAGE
    ADD CONSTRAINT B2B_EXT_BUSINESS_MESSAGE_PK PRIMARY KEY (ID);

CREATE INDEX B2B_IDX_EXT_ALL ON E$B2B_EXT_BUSINESS_MESSAGE
    (TXNSET_CONTROL_NUMBER , GROUP_CONTROL_NUMBER , INTERCHANGE_CONTROL_NUMBER );

CREATE INDEX B2B_IDX_EXT_TG ON E$B2B_EXT_BUSINESS_MESSAGE
    (TXNSET_CONTROL_NUMBER , GROUP_CONTROL_NUMBER );

CREATE INDEX B2B_IDX_EXT_T ON E$B2B_EXT_BUSINESS_MESSAGE
    (TXNSET_CONTROL_NUMBER );

CREATE INDEX B2B_IDX_EXT_BM ON E$B2B_EXT_BUSINESS_MESSAGE
    (BUSINESS_MESSAGE );

CREATE INDEX B2B_IDX_EXT_INTCH_CTLNUM ON E$B2B_EXT_BUSINESS_MESSAGE
    (INTERCHANGE_CONTROL_NUMBER );

CREATE INDEX B2B_IDX_EXT_WIRE_CORR_ID ON E$B2B_EXT_BUSINESS_MESSAGE
    (WIRE_CORRELATION_ID );

CREATE INDEX B2B_IDX_EXT_CORR_FLOW_ID ON E$B2B_EXT_BUSINESS_MESSAGE
    (CORRELATION_FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$B2B_HA_REGISTRY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_HA_REGISTRY
(
    INSTANCE VARCHAR2(256),
    LASTUPDATE DATE
);

CREATE OR REPLACE EDITIONING VIEW B2B_HA_REGISTRY
 AS SELECT INSTANCE, LASTUPDATE FROM E$B2B_HA_REGISTRY;

-- ----------------------------------------------------------------------- 
-- E$B2B_LIFECYCLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_LIFECYCLE
(
    ID VARCHAR2(256) NOT NULL,
    TPA_NAME VARCHAR2(256),
    SENDER_NAME VARCHAR2(256),
    RECEIVER_NAME VARCHAR2(256),
    DOCTYPE_NAME VARCHAR2(256),
    DOC_PROTOCOL_VERSION VARCHAR2(256),
    STATE VARCHAR2(256),
    LABEL VARCHAR2(256),
    LABEL_DESC VARCHAR2(256),
    CREATED DATE,
    MODIFIED DATE,
    USER_NAME VARCHAR2(256),
    DOC_PROTOCOL_NAME VARCHAR2(256),
    DOC_DEF_NAME VARCHAR2(256),
    DEFINITION_MO VARCHAR2(256),
    DOC_REF_NAME VARCHAR2(512),
    DOC_ROUTING_ID VARCHAR2(256),
    BUSINESS_ACTION_NAME VARCHAR2(256),
    SERVICE_NAME VARCHAR2(256),
    SERVICE_TYPE VARCHAR2(256),
    FROM_DC VARCHAR2(256),
    TO_DC VARCHAR2(256),
    CONTROL_NUMBER_SET VARCHAR2(256),
    DOC_DEF_TIMESTAMP DATE,
    DIRECTION VARCHAR2(256),
    TPA_REFERENCE VARCHAR2(256),
    IS_CUSTOM NUMBER(1),
    APPS_DOCUMENT VARCHAR2(256),
    APPS_ACTION VARCHAR2(256),
    APPS_XSLTFILE VARCHAR2(256),
    AGREEMENT_ID VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256),
    ATTRIBUTE6 VARCHAR2(256),
    ATTRIBUTE7 VARCHAR2(256),
    ATTRIBUTE8 VARCHAR2(256),
    ATTRIBUTE9 VARCHAR2(256),
    ATTRIBUTE10 VARCHAR2(256),
    APPS_DOCTYPE_NAME VARCHAR2(256),
    APPS_DOC_PROTOCOL_NAME VARCHAR2(256),
    APPS_DOC_PROTOCOL_VERSION VARCHAR2(256),
    CREATED_BY_UI VARCHAR2(128),
    EXCHANGE_PROTOCOL_NAME VARCHAR2(256),
    WS_SERVICE_NAME VARCHAR2(1024),
    WS_PORT_NAME VARCHAR2(256),
    WS_ASSEMBLY_MO VARCHAR2(512)
);

CREATE OR REPLACE EDITIONING VIEW B2B_LIFECYCLE
 AS SELECT ID, TPA_NAME, SENDER_NAME, RECEIVER_NAME, DOCTYPE_NAME, DOC_PROTOCOL_VERSION, STATE, LABEL, LABEL_DESC, CREATED, MODIFIED, USER_NAME, DOC_PROTOCOL_NAME, DOC_DEF_NAME, DEFINITION_MO, DOC_REF_NAME, DOC_ROUTING_ID, BUSINESS_ACTION_NAME, SERVICE_NAME, SERVICE_TYPE, FROM_DC, TO_DC, CONTROL_NUMBER_SET, DOC_DEF_TIMESTAMP, DIRECTION, TPA_REFERENCE, IS_CUSTOM, APPS_DOCUMENT, APPS_ACTION, APPS_XSLTFILE, AGREEMENT_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, ATTRIBUTE6, ATTRIBUTE7, ATTRIBUTE8, ATTRIBUTE9, ATTRIBUTE10, APPS_DOCTYPE_NAME, APPS_DOC_PROTOCOL_NAME, APPS_DOC_PROTOCOL_VERSION, CREATED_BY_UI, EXCHANGE_PROTOCOL_NAME, WS_SERVICE_NAME, WS_PORT_NAME, WS_ASSEMBLY_MO FROM E$B2B_LIFECYCLE;

ALTER TABLE E$B2B_LIFECYCLE
    ADD CONSTRAINT B2B_LIFECYCLE_PK PRIMARY KEY (ID);

CREATE INDEX B2B_IDX_LC_SRA ON E$B2B_LIFECYCLE
    (SENDER_NAME , RECEIVER_NAME , AGREEMENT_ID );

CREATE INDEX B2B_IDX_LIFECYCLE_1 ON E$B2B_LIFECYCLE
    (SENDER_NAME , RECEIVER_NAME , DOCTYPE_NAME , DOC_PROTOCOL_VERSION , STATE , DIRECTION );

CREATE INDEX B2B_IDX_LIFECYCLE_2 ON E$B2B_LIFECYCLE
    (SENDER_NAME , RECEIVER_NAME , SERVICE_NAME , SERVICE_TYPE , STATE , DIRECTION );

CREATE INDEX B2B_IDX_LIFECYCLE_3 ON E$B2B_LIFECYCLE
    (TPA_NAME );

CREATE INDEX B2B_IDX_LIFECYCLE_4 ON E$B2B_LIFECYCLE
    (DOC_REF_NAME );

CREATE INDEX B2B_IDX_LC_EXPRO ON E$B2B_LIFECYCLE
    (EXCHANGE_PROTOCOL_NAME );

-- ----------------------------------------------------------------------- 
-- E$B2B_LOCK_REGISTRY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_LOCK_REGISTRY
(
    INSTANCE VARCHAR2(256),
    DIRECTION VARCHAR2(30),
    TARGET VARCHAR2(50),
    LASTUPDATE DATE
);

CREATE OR REPLACE EDITIONING VIEW B2B_LOCK_REGISTRY
 AS SELECT INSTANCE, DIRECTION, TARGET, LASTUPDATE FROM E$B2B_LOCK_REGISTRY;

CREATE UNIQUE INDEX B2B_LOCK_REGISTRY_KEY ON E$B2B_LOCK_REGISTRY
    (DIRECTION , TARGET );

-- ----------------------------------------------------------------------- 
-- E$B2B_PARAMETER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_PARAMETER
(
    NAME VARCHAR2(100),
    DATE_VALUE DATE,
    TIME_VALUE TIMESTAMP,
    STRING_VALUE VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(100),
    ATTRIBUTE2 VARCHAR2(100),
    ATTRIBUTE3 VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW B2B_PARAMETER
 AS SELECT NAME, DATE_VALUE, TIME_VALUE, STRING_VALUE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3 FROM E$B2B_PARAMETER;

-- ----------------------------------------------------------------------- 
-- E$B2B_PENDING_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_PENDING_MESSAGE
(
    MESSAGE_ID VARCHAR2(256) NOT NULL,
    CREATED DATE,
    MODIFIED DATE,
    RECEIVER_NAME VARCHAR2(256),
    DOCTYPE_NAME VARCHAR2(256),
    DOC_PROTOCOL_VERSION VARCHAR2(256),
    MSG_SIZE INTEGER,
    STATE INTEGER,
    BATCH_NAME VARCHAR2(512),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW B2B_PENDING_MESSAGE
 AS SELECT MESSAGE_ID, CREATED, MODIFIED, RECEIVER_NAME, DOCTYPE_NAME, DOC_PROTOCOL_VERSION, MSG_SIZE, STATE, BATCH_NAME, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5 FROM E$B2B_PENDING_MESSAGE;

ALTER TABLE E$B2B_PENDING_MESSAGE
    ADD CONSTRAINT B2B_PENDING_MESSAGE_PK PRIMARY KEY (MESSAGE_ID);

-- ----------------------------------------------------------------------- 
-- E$B2B_PURGE_TEMP_AM 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_PURGE_TEMP_AM
(
    AM_ID VARCHAR2(256),
    AM_PAYLOAD VARCHAR2(256),
    AM_ATTACHMENT_STORAGE VARCHAR2(256),
    STRIPECOL NUMBER
);

CREATE OR REPLACE EDITIONING VIEW B2B_PURGE_TEMP_AM
 AS SELECT AM_ID, AM_PAYLOAD, AM_ATTACHMENT_STORAGE, STRIPECOL FROM E$B2B_PURGE_TEMP_AM;

-- ----------------------------------------------------------------------- 
-- E$B2B_PURGE_TEMP_BM 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_PURGE_TEMP_BM
(
    BM_ID VARCHAR2(256),
    BM_MESSAGE_ID VARCHAR2(256),
    BM_PAYLOAD_STORAGE VARCHAR2(256),
    BM_ATTACHMENT_STORAGE VARCHAR2(256),
    BM_NATIVE_DATA_STORAGE VARCHAR2(256),
    BM_TRANSLATED_DATA_STORAGE VARCHAR2(256),
    WM_PACKED_MESSAGE VARCHAR2(256),
    WM_PAYLOAD_STORAGE VARCHAR2(256),
    AM_PAYLOAD VARCHAR2(256),
    AM_ATTACHMENT_STORAGE VARCHAR2(256),
    EXT_BM_ID VARCHAR2(256),
    AM_ID VARCHAR2(256),
    WM_ID VARCHAR2(256),
    STRIPECOL NUMBER
);

CREATE OR REPLACE EDITIONING VIEW B2B_PURGE_TEMP_BM
 AS SELECT BM_ID, BM_MESSAGE_ID, BM_PAYLOAD_STORAGE, BM_ATTACHMENT_STORAGE, BM_NATIVE_DATA_STORAGE, BM_TRANSLATED_DATA_STORAGE, WM_PACKED_MESSAGE, WM_PAYLOAD_STORAGE, AM_PAYLOAD, AM_ATTACHMENT_STORAGE, EXT_BM_ID, AM_ID, WM_ID, STRIPECOL FROM E$B2B_PURGE_TEMP_BM;

-- ----------------------------------------------------------------------- 
-- E$B2B_PURGE_TEMP_WM 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_PURGE_TEMP_WM
(
    WM_ID VARCHAR2(256),
    WM_PAYLOAD_STORAGE VARCHAR2(256),
    WM_PACKED_MESSAGE VARCHAR2(256),
    STRIPECOL NUMBER
);

CREATE OR REPLACE EDITIONING VIEW B2B_PURGE_TEMP_WM
 AS SELECT WM_ID, WM_PAYLOAD_STORAGE, WM_PACKED_MESSAGE, STRIPECOL FROM E$B2B_PURGE_TEMP_WM;

-- ----------------------------------------------------------------------- 
-- E$B2B_SEQUENCE_MANAGER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_SEQUENCE_MANAGER
(
    ID VARCHAR2(256) NOT NULL,
    MESSAGE_ID VARCHAR2(256),
    APP_MESSAGE_ID VARCHAR2(256),
    WIRE_MESSAGE_ID VARCHAR2(256),
    SEQUENCE_TARGET VARCHAR2(256) NOT NULL,
    DELIVERY_CHANNEL VARCHAR2(256),
    TIME_STAMP DATE NOT NULL,
    RETRY_INTERVAL NUMBER(10,0),
    NEXT_TIME_STAMP DATE,
    STATE VARCHAR2(256),
    DIRECTION VARCHAR2(256) NOT NULL,
    PROTOCOL VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    MODIFIED DATE,
    ATTRIBUTE5 VARCHAR2(256),
    PARAMETERS VARCHAR2(2048),
    E2E_SRC_SEQUENCE_ID VARCHAR2(256),
    E2E_SRC_TARGET VARCHAR2(256),
    E2E_GROUP_COUNT NUMBER(10,0)
);

CREATE OR REPLACE EDITIONING VIEW B2B_SEQUENCE_MANAGER
 AS SELECT ID, MESSAGE_ID, APP_MESSAGE_ID, WIRE_MESSAGE_ID, SEQUENCE_TARGET, DELIVERY_CHANNEL, TIME_STAMP, RETRY_INTERVAL, NEXT_TIME_STAMP, STATE, DIRECTION, PROTOCOL, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, MODIFIED, ATTRIBUTE5, PARAMETERS, E2E_SRC_SEQUENCE_ID, E2E_SRC_TARGET, E2E_GROUP_COUNT FROM E$B2B_SEQUENCE_MANAGER;

ALTER TABLE E$B2B_SEQUENCE_MANAGER
    ADD CONSTRAINT B2B_SEQUENCE_MANAGER_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$B2B_TRANSPORT_MANAGER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_TRANSPORT_MANAGER
(
    INSTANCE_NAME VARCHAR2(100) NOT NULL,
    ENDPOINT VARCHAR2(100) NOT NULL,
    UPDATE_TIME DATE NOT NULL,
    STATS CLOB NOT NULL,
    ATTRIBUTE1 VARCHAR2(50),
    ATTRIBUTE2 VARCHAR2(50)
);

CREATE OR REPLACE EDITIONING VIEW B2B_TRANSPORT_MANAGER
 AS SELECT INSTANCE_NAME, ENDPOINT, UPDATE_TIME, STATS, ATTRIBUTE1, ATTRIBUTE2 FROM E$B2B_TRANSPORT_MANAGER;

ALTER TABLE E$B2B_TRANSPORT_MANAGER
    ADD CONSTRAINT B2B_TRANSPORT_PK PRIMARY KEY (INSTANCE_NAME, ENDPOINT);

-- ----------------------------------------------------------------------- 
-- E$B2B_WIRE_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_WIRE_MESSAGE
(
    MESSAGE_ID VARCHAR2(256) NOT NULL,
    PACKED_MESSAGE VARCHAR2(256),
    PAYLOAD_STORAGE VARCHAR2(256),
    PROTOCOL_MESSAGE_ID VARCHAR2(1024),
    REFER_TO_PROTOCOL_MESSAGE_ID VARCHAR2(1024),
    PROTOCOL_COLLABORATION_ID VARCHAR2(1024),
    PROTOCOL_TRANSPORT_BINDING VARCHAR2(2000),
    MESSAGE_DIGEST VARCHAR2(256),
    DIGEST_ALGORITHM VARCHAR2(256),
    TRANSPORT_PROTOCOL VARCHAR2(256),
    TRANSPORT_PROTOCOL_VERSION VARCHAR2(256),
    TRANSPORT_CORRELATION_ID VARCHAR2(256),
    VERSION VARCHAR2(256),
    URL VARCHAR2(1024),
    DIRECTION VARCHAR2(256),
    TRANS_SECURITY_PROTOCOL VARCHAR2(256),
    TRANS_SECURITY_PROT_VERSION VARCHAR2(256),
    TRANSPORT_HEADERS VARCHAR2(2000),
    TRANSPORT_CERTIFICATES VARCHAR2(2000),
    TRANSPORT_CERTIFICATES_CLOB CLOB,
    STATE VARCHAR2(256),
    ERROR_CODE VARCHAR2(256),
    ERROR_TEXT VARCHAR2(1024),
    ERROR_DESCRIPTION VARCHAR2(2000),
    ERROR_TEXT_CLOB CLOB,
    ERROR_DESCRIPTION_CLOB CLOB,
    CREATED DATE,
    MODIFIED DATE,
    ACKNOWLEDGEMENT_MODE VARCHAR2(256),
    EXCHANGE_RETRY_INTERVAL NUMBER(10,0),
    EXCHANGE_ATTEMPT_COUNT NUMBER(10,0),
    EXCHANGE_REMAINING_RETRY NUMBER(10,0),
    RESUBMIT_COUNT NUMBER(10,0),
    MSG_SIZE NUMBER(10,0),
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(256),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256),
    ATTRIBUTE5 VARCHAR2(256),
    HOST_NAME VARCHAR2(256),
    PORT NUMBER(10,0),
    USER_NAME VARCHAR2(256),
    PASSWORD VARCHAR2(256),
    FROM_ADDRESS VARCHAR2(256),
    TO_ADDRESS VARCHAR2(256),
    DELIVERED_ENDPOINT VARCHAR2(256),
    LABEL VARCHAR2(256),
    JOB_ID VARCHAR2(128),
    SIGNING_PROTOCOL VARCHAR2(256),
    SIGNING_ALGORITHM VARCHAR2(256),
    SIGNING_CERTIFICATE VARCHAR2(256),
    ENCRYPTION_PROTOCOL VARCHAR2(256),
    ENCRYPTION_ALGORITHM VARCHAR2(256),
    ENCRYPTION_CERTIFICATE VARCHAR2(256),
    ID VARCHAR2(256) NOT NULL,
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT systimestamp-30,
    LAST_RESUBMITTED_USER_NAME VARCHAR2(128),
    LAST_RESUBMITTED_TIME_STAMP DATE,
    LAST_VIEWED_USER_NAME VARCHAR2(128),
    LAST_VIEWED_TIME_STAMP DATE,
    CHANNEL_NAME VARCHAR2(256),
    MESSAGE_STATUS VARCHAR2(64),
    RESUBMIT_REF_TO VARCHAR2(128)
)
 PARTITION BY RANGE (CPST_INST_CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW B2B_WIRE_MESSAGE
 AS SELECT MESSAGE_ID, PACKED_MESSAGE, PAYLOAD_STORAGE, PROTOCOL_MESSAGE_ID, REFER_TO_PROTOCOL_MESSAGE_ID, PROTOCOL_COLLABORATION_ID, PROTOCOL_TRANSPORT_BINDING, MESSAGE_DIGEST, DIGEST_ALGORITHM, TRANSPORT_PROTOCOL, TRANSPORT_PROTOCOL_VERSION, TRANSPORT_CORRELATION_ID, VERSION, URL, DIRECTION, TRANS_SECURITY_PROTOCOL, TRANS_SECURITY_PROT_VERSION, TRANSPORT_HEADERS, TRANSPORT_CERTIFICATES, TRANSPORT_CERTIFICATES_CLOB, STATE, ERROR_CODE, ERROR_TEXT, ERROR_DESCRIPTION, ERROR_TEXT_CLOB, ERROR_DESCRIPTION_CLOB, CREATED, MODIFIED, ACKNOWLEDGEMENT_MODE, EXCHANGE_RETRY_INTERVAL, EXCHANGE_ATTEMPT_COUNT, EXCHANGE_REMAINING_RETRY, RESUBMIT_COUNT, MSG_SIZE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, HOST_NAME, PORT, USER_NAME, PASSWORD, FROM_ADDRESS, TO_ADDRESS, DELIVERED_ENDPOINT, LABEL, JOB_ID, SIGNING_PROTOCOL, SIGNING_ALGORITHM, SIGNING_CERTIFICATE, ENCRYPTION_PROTOCOL, ENCRYPTION_ALGORITHM, ENCRYPTION_CERTIFICATE, ID, CPST_INST_CREATED_TIME, LAST_RESUBMITTED_USER_NAME, LAST_RESUBMITTED_TIME_STAMP, LAST_VIEWED_USER_NAME, LAST_VIEWED_TIME_STAMP, CHANNEL_NAME, MESSAGE_STATUS, RESUBMIT_REF_TO FROM E$B2B_WIRE_MESSAGE;

ALTER TABLE E$B2B_WIRE_MESSAGE
    ADD CONSTRAINT B2B_WIRE_MESSAGE_PK PRIMARY KEY (ID);

CREATE INDEX B2B_IDX_WM_PACK_MSG ON E$B2B_WIRE_MESSAGE
    (PACKED_MESSAGE );

CREATE INDEX B2B_IDX_WM_PAY_STR ON E$B2B_WIRE_MESSAGE
    (PAYLOAD_STORAGE );

CREATE INDEX B2B_IDX_WM_MSG_ID ON E$B2B_WIRE_MESSAGE
    (MESSAGE_ID );

CREATE INDEX B2B_IDX_WM_PROT ON E$B2B_WIRE_MESSAGE
    (PROTOCOL_MESSAGE_ID , PROTOCOL_COLLABORATION_ID );

CREATE INDEX B2B_IDX_WM_PROT_MSGID ON E$B2B_WIRE_MESSAGE
    (PROTOCOL_MESSAGE_ID );

-- ----------------------------------------------------------------------- 
-- E$BEAM_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_SEQUENCE
(
    SEQ_NAME VARCHAR2(256) NOT NULL,
    SEQ_COUNT NUMBER(19,0) DEFAULT 0 NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BEAM_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BEAM_SEQUENCE;

ALTER TABLE E$BEAM_SEQUENCE
    ADD CONSTRAINT BEAM_SEQ_NAME_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BEAM_PROPERTY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_PROPERTY
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    PROPERTY_NAME VARCHAR2(256) NOT NULL,
    PROPERTY_VALUE VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW BEAM_PROPERTY
 AS SELECT BEAM_OPTLOCK, PROPERTY_NAME, PROPERTY_VALUE FROM E$BEAM_PROPERTY;

ALTER TABLE E$BEAM_PROPERTY
    ADD CONSTRAINT BEAM_PROPERTY_NAME_PK PRIMARY KEY (PROPERTY_NAME);

-- ----------------------------------------------------------------------- 
-- E$BEAM_TRANSACTION_CONTEXT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_TRANSACTION_CONTEXT
(
    TRANSACTION_CID NUMBER(19,0) NOT NULL,
    TRANSACTION_TID NUMBER(19,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BEAM_TRANSACTION_CONTEXT
 AS SELECT TRANSACTION_CID, TRANSACTION_TID FROM E$BEAM_TRANSACTION_CONTEXT;

ALTER TABLE E$BEAM_TRANSACTION_CONTEXT
    ADD CONSTRAINT BEAM_TRANSACTION_CID_PK PRIMARY KEY (TRANSACTION_CID);

-- ----------------------------------------------------------------------- 
-- E$BEAM_FLEXTABLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_FLEXTABLE
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    BEAM_ID NUMBER(19,0) NOT NULL,
    FLEXTABLE_TOTAL_STRINGS NUMBER(10,0) DEFAULT 0 NOT NULL,
    FLEXTABLE_TOTAL_LONGSTRINGS NUMBER(10,0) DEFAULT 0 NOT NULL,
    FLEXTABLE_TOTAL_INTEGERS NUMBER(10,0) DEFAULT 0 NOT NULL,
    FLEXTABLE_TOTAL_DECIMALS NUMBER(10,0) DEFAULT 0 NOT NULL,
    FLEXTABLE_TOTAL_FLOATS NUMBER(10,0) DEFAULT 0 NOT NULL,
    FLEXTABLE_TOTAL_DATES NUMBER(10,0) DEFAULT 0 NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BEAM_FLEXTABLE
 AS SELECT BEAM_OPTLOCK, BEAM_ID, FLEXTABLE_TOTAL_STRINGS, FLEXTABLE_TOTAL_LONGSTRINGS, FLEXTABLE_TOTAL_INTEGERS, FLEXTABLE_TOTAL_DECIMALS, FLEXTABLE_TOTAL_FLOATS, FLEXTABLE_TOTAL_DATES FROM E$BEAM_FLEXTABLE;

ALTER TABLE E$BEAM_FLEXTABLE
    ADD CONSTRAINT BEAM_FLEXTABLE_ID_PK PRIMARY KEY (BEAM_ID);

-- ----------------------------------------------------------------------- 
-- E$BEAM_DATAOBJECT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_DATAOBJECT
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    BEAM_ID NUMBER(19,0) NOT NULL,
    DATAOBJECT_HIERARCHY VARCHAR2(256),
    DATAOBJECT_NAME VARCHAR2(256) NOT NULL,
    DATAOBJECT_FLEXTABLE NUMBER(19,0),
    DATAOBJECT_PARENT NUMBER(19,0),
    DATAOBJECT_TYPE NUMBER(10,0) NOT NULL
)
;

CREATE OR REPLACE EDITIONING VIEW BEAM_DATAOBJECT
 AS SELECT BEAM_OPTLOCK, BEAM_ID, DATAOBJECT_HIERARCHY, DATAOBJECT_NAME, DATAOBJECT_FLEXTABLE, DATAOBJECT_PARENT, DATAOBJECT_TYPE FROM E$BEAM_DATAOBJECT;

ALTER TABLE E$BEAM_DATAOBJECT
    ADD CONSTRAINT BEAM_DATAOBJECT_ID_PK PRIMARY KEY (BEAM_ID);

ALTER TABLE E$BEAM_DATAOBJECT ADD CONSTRAINT BEAM_DATAOBJECT_NAME_UK UNIQUE
    (DATAOBJECT_NAME );

-- ----------------------------------------------------------------------- 
-- E$BEAM_NAMEMAPPING 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_NAMEMAPPING
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    BEAM_ID NUMBER(19,0) NOT NULL,
    NAMEMAPPING_NAME VARCHAR2(256) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BEAM_NAMEMAPPING
 AS SELECT BEAM_OPTLOCK, BEAM_ID, NAMEMAPPING_NAME FROM E$BEAM_NAMEMAPPING;

ALTER TABLE E$BEAM_NAMEMAPPING
    ADD CONSTRAINT BEAM_NAMEMAPPING_ID_PK PRIMARY KEY (BEAM_ID);

ALTER TABLE E$BEAM_NAMEMAPPING ADD CONSTRAINT BEAM_NAMEMAPPING_NAME_UK UNIQUE
    (NAMEMAPPING_NAME );

-- ----------------------------------------------------------------------- 
-- E$BEAM_COLUMN 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_COLUMN
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    BEAM_ID NUMBER(19,0) NOT NULL,
    COLUMN_DTYPE VARCHAR2(256) NOT NULL,
    COLUMN_DATAOBJECT NUMBER(19,0) NOT NULL,
    COLUMN_NAME VARCHAR2(256) NOT NULL,
    COLUMN_LENGTH NUMBER(10,0) NOT NULL,
    COLUMN_PRECISION NUMBER(10,0) NOT NULL,
    COLUMN_SCALE NUMBER(10,0) NOT NULL,
    COLUMN_DEFAULT VARCHAR2(1024),
    COLUMN_CAPTION VARCHAR2(256),
    COLUMN_ALLOWS_NULL NUMBER(1) DEFAULT 0 NOT NULL,
    COLUMN_IS_UNIQUE NUMBER(1) DEFAULT 0 NOT NULL,
    COLUMN_FLEXTABLE NUMBER(19,0) NOT NULL,
    COLUMN_FLEXCOLUMN_NUMBER NUMBER(10,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BEAM_COLUMN
 AS SELECT BEAM_OPTLOCK, BEAM_ID, COLUMN_DTYPE, COLUMN_DATAOBJECT, COLUMN_NAME, COLUMN_LENGTH, COLUMN_PRECISION, COLUMN_SCALE, COLUMN_DEFAULT, COLUMN_CAPTION, COLUMN_ALLOWS_NULL, COLUMN_IS_UNIQUE, COLUMN_FLEXTABLE, COLUMN_FLEXCOLUMN_NUMBER FROM E$BEAM_COLUMN;

ALTER TABLE E$BEAM_COLUMN
    ADD CONSTRAINT BEAM_COLUMN_ID_PK PRIMARY KEY (BEAM_ID);

-- ----------------------------------------------------------------------- 
-- E$BEAM_ALERT_RULE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_ALERT_RULE
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    BEAM_ID NUMBER(19,0) NOT NULL,
    RULE_NAME VARCHAR2(256) NOT NULL,
    RULE_OWNER_ID VARCHAR2(256),
    RULE_CREATED TIMESTAMP,
    RULE_LAST_MODIFIED TIMESTAMP,
    RULE_MODIFIED_BY VARCHAR2(256),
    RULE_RECIPIENT_ID VARCHAR2(256),
    RULE_REPORT_ID VARCHAR2(256),
    RULE_ACTIVE INTEGER,
    RULE_TEMPLATE INTEGER,
    RULE_PACKAGE_ID VARCHAR2(256),
    RULE_LAST_FIRED TIMESTAMP,
    RULE_STALE INTEGER NOT NULL,
    RULE_ORPHAN INTEGER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BEAM_ALERT_RULE
 AS SELECT BEAM_OPTLOCK, BEAM_ID, RULE_NAME, RULE_OWNER_ID, RULE_CREATED, RULE_LAST_MODIFIED, RULE_MODIFIED_BY, RULE_RECIPIENT_ID, RULE_REPORT_ID, RULE_ACTIVE, RULE_TEMPLATE, RULE_PACKAGE_ID, RULE_LAST_FIRED, RULE_STALE, RULE_ORPHAN FROM E$BEAM_ALERT_RULE;

ALTER TABLE E$BEAM_ALERT_RULE
    ADD CONSTRAINT BEAM_ALERT_RULE_ID_PK PRIMARY KEY (BEAM_ID);

ALTER TABLE E$BEAM_ALERT_RULE ADD CONSTRAINT ALERT_RULE_NAME_UK UNIQUE
    (RULE_NAME );

-- ----------------------------------------------------------------------- 
-- E$BEAM_ALERT_ESCALATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BEAM_ALERT_ESCALATION
(
    BEAM_OPTLOCK NUMBER(19,0) NOT NULL,
    BEAM_ID NUMBER(19,0) NOT NULL,
    ESCALATION_NAME VARCHAR2(256) NOT NULL,
    ESCALATION_OWNER_ID VARCHAR2(256),
    ESCALATION_CREATED TIMESTAMP,
    ESCALATION_LAST_MODIFIED TIMESTAMP,
    ESCALATION_MODIFIED_BY VARCHAR2(256),
    ESCALATION_REPORT_ID VARCHAR2(256),
    ESCALATION_USER_ID VARCHAR2(256),
    ESCALATION_RULE_OWNER_ID VARCHAR2(256),
    ESCALATION_START_TIME TIMESTAMP,
    ESCALATION_END_TIME TIMESTAMP,
    ESCALATION_ACTION VARCHAR2(2000),
    ESCALATION_MESSAGE VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW BEAM_ALERT_ESCALATION
 AS SELECT BEAM_OPTLOCK, BEAM_ID, ESCALATION_NAME, ESCALATION_OWNER_ID, ESCALATION_CREATED, ESCALATION_LAST_MODIFIED, ESCALATION_MODIFIED_BY, ESCALATION_REPORT_ID, ESCALATION_USER_ID, ESCALATION_RULE_OWNER_ID, ESCALATION_START_TIME, ESCALATION_END_TIME, ESCALATION_ACTION, ESCALATION_MESSAGE FROM E$BEAM_ALERT_ESCALATION;

ALTER TABLE E$BEAM_ALERT_ESCALATION
    ADD CONSTRAINT BEAM_ALERT_ESCALATION_ID_PK PRIMARY KEY (BEAM_ID);

-- ----------------------------------------------------------------------- 
-- E$AUDIT_COUNTER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AUDIT_COUNTER
(
    CIKEY NUMBER NOT NULL,
    LAST_COUNT_ID INTEGER,
    LAST_EVENT_ID INTEGER,
    LAST_DETAIL_ID INTEGER,
    CI_PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW AUDIT_COUNTER
 AS SELECT CIKEY, LAST_COUNT_ID, LAST_EVENT_ID, LAST_DETAIL_ID, CI_PARTITION_DATE FROM E$AUDIT_COUNTER;

ALTER TABLE E$AUDIT_COUNTER
    ADD CONSTRAINT AC_PK PRIMARY KEY (CIKEY);

-- ----------------------------------------------------------------------- 
-- E$AUDIT_DETAILS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AUDIT_DETAILS
(
    CIKEY NUMBER NOT NULL,
    DETAIL_ID INTEGER NOT NULL,
    BIN_CSIZE INTEGER,
    BIN_USIZE INTEGER,
    DOC_REF VARCHAR2(300),
    BIN BLOB,
    CI_PARTITION_DATE TIMESTAMP NOT NULL,
    FLOW_ID INTEGER DEFAULT -1,
    SCA_PARTITION_ID INTEGER
)
storage
(
    freelists 6
)
lob( bin )
store as
(
    storage( initial 4k next 4k )
    chunk 2k
    cache
    pctversion 0
)
pctfree 0
pctused 1
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW AUDIT_DETAILS
 AS SELECT CIKEY, DETAIL_ID, BIN_CSIZE, BIN_USIZE, DOC_REF, BIN, CI_PARTITION_DATE, FLOW_ID, SCA_PARTITION_ID FROM E$AUDIT_DETAILS;

ALTER TABLE E$AUDIT_DETAILS
    ADD CONSTRAINT AD_PK PRIMARY KEY (CIKEY, DETAIL_ID);

CREATE INDEX AD_FLOWID ON E$AUDIT_DETAILS
    (FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$AUDIT_TRAIL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AUDIT_TRAIL
(
    CIKEY NUMBER NOT NULL,
    COUNT_ID INTEGER NOT NULL,
    BLOCK INTEGER,
    BLOCK_CSIZE INTEGER,
    BLOCK_USIZE INTEGER,
    LOG RAW(2000),
    CI_PARTITION_DATE TIMESTAMP NOT NULL,
    NUM_OF_EVENTS INTEGER,
    FLOW_ID INTEGER DEFAULT -1 NOT NULL,
    SCA_PARTITION_ID INTEGER,
    SERIALIZER_ID INTEGER DEFAULT 0 NOT NULL
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW AUDIT_TRAIL
 AS SELECT CIKEY, COUNT_ID, BLOCK, BLOCK_CSIZE, BLOCK_USIZE, LOG, CI_PARTITION_DATE, NUM_OF_EVENTS, FLOW_ID, SCA_PARTITION_ID, SERIALIZER_ID FROM E$AUDIT_TRAIL;

ALTER TABLE E$AUDIT_TRAIL
    ADD CONSTRAINT AT_PK PRIMARY KEY (FLOW_ID, CIKEY, COUNT_ID);

CREATE INDEX AT_CIKEY ON E$AUDIT_TRAIL
    (CIKEY );

-- ----------------------------------------------------------------------- 
-- E$CI_INDEXES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CI_INDEXES
(
    CIKEY NUMBER NOT NULL,
    INDEX_1 NVARCHAR2(100),
    INDEX_2 NVARCHAR2(100),
    INDEX_3 NVARCHAR2(100),
    INDEX_4 NVARCHAR2(100),
    INDEX_5 NVARCHAR2(100),
    INDEX_6 NVARCHAR2(100),
    CI_PARTITION_DATE TIMESTAMP NOT NULL
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW CI_INDEXES
 AS SELECT CIKEY, INDEX_1, INDEX_2, INDEX_3, INDEX_4, INDEX_5, INDEX_6, CI_PARTITION_DATE FROM E$CI_INDEXES;

ALTER TABLE E$CI_INDEXES
    ADD CONSTRAINT CI_INDEXES_PK PRIMARY KEY (CIKEY);

CREATE INDEX CI_INDEX_1 ON E$CI_INDEXES
    (INDEX_1 );

CREATE INDEX CI_INDEX_2 ON E$CI_INDEXES
    (INDEX_2 );

CREATE INDEX CI_INDEX_3 ON E$CI_INDEXES
    (INDEX_3 );

CREATE INDEX CI_INDEX_4 ON E$CI_INDEXES
    (INDEX_4 );

CREATE INDEX CI_INDEX_5 ON E$CI_INDEXES
    (INDEX_5 );

CREATE INDEX CI_INDEX_6 ON E$CI_INDEXES
    (INDEX_6 );

-- ----------------------------------------------------------------------- 
-- E$CLUSTER_MASTER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CLUSTER_MASTER
(
    NODE_ID INTEGER NOT NULL,
    DUMMY_COL VARCHAR2(1),
    COMPONENTTYPE VARCHAR2(10)
);

CREATE OR REPLACE EDITIONING VIEW CLUSTER_MASTER
 AS SELECT NODE_ID, DUMMY_COL, COMPONENTTYPE FROM E$CLUSTER_MASTER;

-- ----------------------------------------------------------------------- 
-- E$CLUSTER_NODE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CLUSTER_NODE
(
    NODE_ID INTEGER NOT NULL,
    IP_ADDRESS VARCHAR2(100),
    LAST_UPDATE TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CLUSTER_NODE
 AS SELECT NODE_ID, IP_ADDRESS, LAST_UPDATE FROM E$CLUSTER_NODE;

-- ----------------------------------------------------------------------- 
-- E$CUBE_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CUBE_INSTANCE
(
    CIKEY NUMBER NOT NULL,
    CREATION_DATE TIMESTAMP NOT NULL,
    CREATOR VARCHAR2(100),
    MODIFY_DATE TIMESTAMP,
    MODIFIER VARCHAR2(100),
    STATE INTEGER,
    PRIORITY INTEGER,
    TITLE NVARCHAR2(200),
    STATUS NVARCHAR2(100),
    STAGE VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(256),
    ROOT_ID VARCHAR2(100),
    PARENT_ID VARCHAR2(100),
    SCOPE_REVISION INTEGER,
    SCOPE_CSIZE INTEGER,
    SCOPE_USIZE INTEGER,
    PROCESS_TYPE INTEGER,
    METADATA NVARCHAR2(1000),
    EXT_STRING1 VARCHAR2(100),
    EXT_STRING2 VARCHAR2(100),
    EXT_INT1 INTEGER,
    TEST_RUN_ID VARCHAR2(100),
    TEST_RUN_NAME VARCHAR2(100),
    TEST_CASE VARCHAR2(100),
    TEST_SUITE VARCHAR2(100),
    ECID VARCHAR2(100),
    CMPST_ID VARCHAR2(100),
    OUTCOME VARCHAR2(100),
    TRACKING_LEVEL VARCHAR2(16),
    AT_COUNT_ID INTEGER,
    AT_EVENT_ID INTEGER,
    AT_DETAIL_ID INTEGER,
    VERSION INTEGER,
    AG_ROOT_ID VARCHAR2(100),
    AG_MILESTONE_PATH VARCHAR2(100),
    CACHE_VERSION INTEGER,
    PARENT_REF_ID VARCHAR2(1024),
    COMPONENTTYPE VARCHAR2(10) NOT NULL,
    NOTM INTEGER,
    COMPOSITE_NAME VARCHAR2(500) NOT NULL,
    DOMAIN_NAME VARCHAR2(50),
    COMPONENT_NAME VARCHAR2(300) NOT NULL,
    COMPOSITE_LABEL VARCHAR2(50),
    COMPOSITE_REVISION VARCHAR2(50) NOT NULL,
    CREATE_CLUSTER_NODE_ID VARCHAR2(100),
    LAST_CLUSTER_NODE_ID VARCHAR2(100),
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT systimestamp,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER DEFAULT -1,
    SCA_PARTITION_ID INTEGER
)
storage
(
    freelists 20
)
 PARTITION BY RANGE (CPST_INST_CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW CUBE_INSTANCE
 AS SELECT CIKEY, CREATION_DATE, CREATOR, MODIFY_DATE, MODIFIER, STATE, PRIORITY, TITLE, STATUS, STAGE, CONVERSATION_ID, ROOT_ID, PARENT_ID, SCOPE_REVISION, SCOPE_CSIZE, SCOPE_USIZE, PROCESS_TYPE, METADATA, EXT_STRING1, EXT_STRING2, EXT_INT1, TEST_RUN_ID, TEST_RUN_NAME, TEST_CASE, TEST_SUITE, ECID, CMPST_ID, OUTCOME, TRACKING_LEVEL, AT_COUNT_ID, AT_EVENT_ID, AT_DETAIL_ID, VERSION, AG_ROOT_ID, AG_MILESTONE_PATH, CACHE_VERSION, PARENT_REF_ID, COMPONENTTYPE, NOTM, COMPOSITE_NAME, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, CREATE_CLUSTER_NODE_ID, LAST_CLUSTER_NODE_ID, CPST_INST_CREATED_TIME, TENANT_ID, FLOW_ID, SCA_PARTITION_ID FROM E$CUBE_INSTANCE;

ALTER TABLE E$CUBE_INSTANCE
    ADD CONSTRAINT CI_PK PRIMARY KEY (CIKEY);

CREATE INDEX CI_ECID ON E$CUBE_INSTANCE
    (ECID );

CREATE INDEX CI_CUSTOM3 ON E$CUBE_INSTANCE
    (TEST_RUN_ID );

CREATE INDEX CI_CREATION_DATE ON E$CUBE_INSTANCE
    (CREATION_DATE );

CREATE INDEX CI_NAME_REV_STATE ON E$CUBE_INSTANCE
    (DOMAIN_NAME , COMPOSITE_NAME , COMPONENT_NAME , COMPOSITE_REVISION , STATE );

CREATE INDEX CI_FLOW_ID ON E$CUBE_INSTANCE
    (FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$CUBE_SCOPE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CUBE_SCOPE
(
    CIKEY NUMBER NOT NULL,
    BINARY_FORMAT INTEGER,
    MODIFY_DATE TIMESTAMP,
    SCOPE_BIN BLOB,
    CI_PARTITION_DATE TIMESTAMP NOT NULL
)
storage
(
    freelists 6
)
lob( scope_bin )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 10
)
pctfree 10
pctused 1
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW CUBE_SCOPE
 AS SELECT CIKEY, BINARY_FORMAT, MODIFY_DATE, SCOPE_BIN, CI_PARTITION_DATE FROM E$CUBE_SCOPE;

ALTER TABLE E$CUBE_SCOPE
    ADD CONSTRAINT CS_PK PRIMARY KEY (CIKEY);

-- ----------------------------------------------------------------------- 
-- E$DLV_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DLV_MESSAGE
(
    CONV_ID VARCHAR2(256),
    CONV_TYPE INTEGER,
    MESSAGE_GUID VARCHAR2(50) NOT NULL,
    PARTNER_LINK VARCHAR2(256),
    OPERATION_NAME VARCHAR2(128),
    EVENT_NAME VARCHAR2(594),
    RECEIVE_DATE TIMESTAMP,
    EXPIRY_DATE TIMESTAMP,
    STATE INTEGER DEFAULT 0 NOT NULL,
    RES_SUBSCRIBER VARCHAR2(1024),
    EXT_STRING1 VARCHAR2(100),
    EXT_STRING2 VARCHAR2(100),
    EXT_INT1 INTEGER,
    DLV_TYPE INTEGER,
    MASTER_CONV_ID VARCHAR2(256),
    PRIORITY INTEGER,
    COMPOSITE_NAME VARCHAR2(500),
    DOMAIN_NAME VARCHAR2(50),
    COMPONENT_NAME VARCHAR2(300),
    COMPOSITE_LABEL VARCHAR2(50),
    COMPOSITE_REVISION VARCHAR2(50),
    COMPONENT_TYPE VARCHAR2(10) NOT NULL,
    CIKEY NUMBER,
    RECOVER_COUNT INTEGER,
    HEADER_PROPERTIES_BIN_FORMAT INTEGER,
    ECID VARCHAR2(100),
    CLUSTER_NODE_ID VARCHAR2(100),
    CLUSTER_NODE_KEY INTEGER DEFAULT -1,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CACHE_VERSION INTEGER,
    PROPERTIES VARCHAR2(2000),
    HEADERS_REF_ID VARCHAR2(100),
    FLOW_ID INTEGER DEFAULT -1,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (RECEIVE_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW DLV_MESSAGE
 AS SELECT CONV_ID, CONV_TYPE, MESSAGE_GUID, PARTNER_LINK, OPERATION_NAME, EVENT_NAME, RECEIVE_DATE, EXPIRY_DATE, STATE, RES_SUBSCRIBER, EXT_STRING1, EXT_STRING2, EXT_INT1, DLV_TYPE, MASTER_CONV_ID, PRIORITY, COMPOSITE_NAME, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, COMPONENT_TYPE, CIKEY, RECOVER_COUNT, HEADER_PROPERTIES_BIN_FORMAT, ECID, CLUSTER_NODE_ID, CLUSTER_NODE_KEY, TENANT_ID, CACHE_VERSION, PROPERTIES, HEADERS_REF_ID, FLOW_ID, SCA_PARTITION_ID FROM E$DLV_MESSAGE;

ALTER TABLE E$DLV_MESSAGE
    ADD CONSTRAINT DLV_MESSAGE_PK PRIMARY KEY (MESSAGE_GUID);

CREATE INDEX DM_CONVERSATION ON E$DLV_MESSAGE
    (CONV_ID );

CREATE INDEX DM_RECEIVE_DATE ON E$DLV_MESSAGE
    (RECEIVE_DATE );

CREATE INDEX DLV_MESSAGE_CIKEY ON E$DLV_MESSAGE
    (CIKEY );

CREATE INDEX DLV_MESSAGE_DATE_ECID ON E$DLV_MESSAGE
    (ECID , RECEIVE_DATE );

CREATE INDEX DLV_MESSAGE_FLOWID ON E$DLV_MESSAGE
    (FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$DLV_SUBSCRIPTION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DLV_SUBSCRIPTION
(
    CONV_ID VARCHAR2(256),
    CONV_TYPE INTEGER,
    CIKEY NUMBER,
    PARTNER_LINK VARCHAR2(256),
    PROCESS_GUID VARCHAR2(50),
    OPERATION_NAME VARCHAR2(128),
    EVENT_NAME VARCHAR2(594),
    SUBSCRIBER_ID VARCHAR2(1024) NOT NULL,
    SERVICE_NAME VARCHAR2(128),
    SUBSCRIPTION_DATE TIMESTAMP,
    STATE INTEGER DEFAULT 0 NOT NULL,
    PROPERTIES VARCHAR2(2000),
    EXT_STRING1 VARCHAR2(100),
    EXT_STRING2 VARCHAR2(100),
    EXT_INT1 INTEGER,
    VERSION INTEGER,
    CACHE_VERSION INTEGER,
    COMPOSITE_NAME VARCHAR2(500),
    DOMAIN_NAME VARCHAR2(50),
    COMPONENT_NAME VARCHAR2(300),
    COMPOSITE_LABEL VARCHAR2(50),
    COMPOSITE_REVISION VARCHAR2(50),
    CI_PARTITION_DATE TIMESTAMP NOT NULL
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW DLV_SUBSCRIPTION
 AS SELECT CONV_ID, CONV_TYPE, CIKEY, PARTNER_LINK, PROCESS_GUID, OPERATION_NAME, EVENT_NAME, SUBSCRIBER_ID, SERVICE_NAME, SUBSCRIPTION_DATE, STATE, PROPERTIES, EXT_STRING1, EXT_STRING2, EXT_INT1, VERSION, CACHE_VERSION, COMPOSITE_NAME, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, CI_PARTITION_DATE FROM E$DLV_SUBSCRIPTION;

ALTER TABLE E$DLV_SUBSCRIPTION
    ADD CONSTRAINT DLV_SUBSCRIPTION_PK PRIMARY KEY (SUBSCRIBER_ID);

CREATE INDEX DS_FK ON E$DLV_SUBSCRIPTION
    (CIKEY );

CREATE INDEX DS_CONVERSATION ON E$DLV_SUBSCRIPTION
    (CONV_ID );

CREATE INDEX DS_CONV_STATE ON E$DLV_SUBSCRIPTION
    (CONV_ID , STATE );

-- ----------------------------------------------------------------------- 
-- E$DOCUMENT_CI_REF 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DOCUMENT_CI_REF
(
    CIKEY NUMBER NOT NULL,
    DOCUMENT_ID VARCHAR2(200) NOT NULL,
    DOCUMENT_TYPE INTEGER,
    CI_PARTITION_DATE TIMESTAMP NOT NULL
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW DOCUMENT_CI_REF
 AS SELECT CIKEY, DOCUMENT_ID, DOCUMENT_TYPE, CI_PARTITION_DATE FROM E$DOCUMENT_CI_REF;

ALTER TABLE E$DOCUMENT_CI_REF
    ADD CONSTRAINT DOCUMENT_CI_REF_PK PRIMARY KEY (CIKEY, DOCUMENT_ID);

-- ----------------------------------------------------------------------- 
-- E$DOCUMENT_DLV_MSG_REF 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DOCUMENT_DLV_MSG_REF
(
    MESSAGE_GUID VARCHAR2(50),
    DOCUMENT_ID VARCHAR2(200),
    PART_NAME VARCHAR2(100),
    DOCUMENT_TYPE INTEGER,
    DLV_PARTITION_DATE TIMESTAMP NOT NULL
)
 PARTITION BY RANGE (DLV_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW DOCUMENT_DLV_MSG_REF
 AS SELECT MESSAGE_GUID, DOCUMENT_ID, PART_NAME, DOCUMENT_TYPE, DLV_PARTITION_DATE FROM E$DOCUMENT_DLV_MSG_REF;

CREATE INDEX DOC_DLV_MSG_GUID_INDEX ON E$DOCUMENT_DLV_MSG_REF
    (MESSAGE_GUID );

CREATE INDEX DOC_DLV_MSG_ID_INDEX ON E$DOCUMENT_DLV_MSG_REF
    (DOCUMENT_ID );

-- ----------------------------------------------------------------------- 
-- E$HEADERS_PROPERTIES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$HEADERS_PROPERTIES
(
    MESSAGE_GUID VARCHAR2(200) NOT NULL,
    COUNT_ID INTEGER NOT NULL,
    BIN_CSIZE INTEGER,
    BIN_USIZE INTEGER,
    BIN RAW(2000),
    MODIFY_DATE TIMESTAMP,
    DLV_PARTITION_DATE TIMESTAMP DEFAULT systimestamp
)
 PARTITION BY RANGE (DLV_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW HEADERS_PROPERTIES
 AS SELECT MESSAGE_GUID, COUNT_ID, BIN_CSIZE, BIN_USIZE, BIN, MODIFY_DATE, DLV_PARTITION_DATE FROM E$HEADERS_PROPERTIES;

ALTER TABLE E$HEADERS_PROPERTIES
    ADD CONSTRAINT HEADERS_PROPERTIES_PK PRIMARY KEY (MESSAGE_GUID, COUNT_ID);

-- ----------------------------------------------------------------------- 
-- E$DLV_AGGREGATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DLV_AGGREGATION
(
    CONV_ID VARCHAR2(256) NOT NULL,
    DOMAIN_NAME VARCHAR2(50) NOT NULL,
    COMPONENT_NAME VARCHAR2(300) NOT NULL,
    COMPOSITE_NAME VARCHAR2(500) NOT NULL,
    COMPOSITE_LABEL VARCHAR2(50) NOT NULL,
    COMPOSITE_REVISION VARCHAR2(50) NOT NULL,
    COMPONENT_TYPE VARCHAR2(10) NOT NULL,
    STATE INTEGER DEFAULT 0 NOT NULL,
    RECEIVE_DATE TIMESTAMP,
    CIKEY NUMBER
);

CREATE OR REPLACE EDITIONING VIEW DLV_AGGREGATION
 AS SELECT CONV_ID, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, COMPONENT_TYPE, STATE, RECEIVE_DATE, CIKEY FROM E$DLV_AGGREGATION;

ALTER TABLE E$DLV_AGGREGATION
    ADD CONSTRAINT DA_PK PRIMARY KEY (CONV_ID, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_NAME, COMPOSITE_REVISION, COMPOSITE_LABEL);

-- ----------------------------------------------------------------------- 
-- E$ID_RANGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$ID_RANGE
(
    RANGE_NAME VARCHAR2(50) NOT NULL,
    NEXT_RANGE INTEGER NOT NULL,
    DUMMY_COL VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW ID_RANGE
 AS SELECT RANGE_NAME, NEXT_RANGE, DUMMY_COL FROM E$ID_RANGE;

ALTER TABLE E$ID_RANGE
    ADD CONSTRAINT ID_RANGE_PK PRIMARY KEY (RANGE_NAME);

-- ----------------------------------------------------------------------- 
-- E$LOAN_CUSTOMER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$LOAN_CUSTOMER
(
    SSN VARCHAR2(11),
    NAME VARCHAR2(50),
    EMAIL VARCHAR2(30) NOT NULL,
    PROVIDER VARCHAR2(20),
    STATUS CHAR(1)
);

CREATE OR REPLACE EDITIONING VIEW LOAN_CUSTOMER
 AS SELECT SSN, NAME, EMAIL, PROVIDER, STATUS FROM E$LOAN_CUSTOMER;

ALTER TABLE E$LOAN_CUSTOMER
    ADD CONSTRAINT LOAN_CUSTOMER_PK PRIMARY KEY (EMAIL);

-- ----------------------------------------------------------------------- 
-- E$NATIVE_CORRELATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$NATIVE_CORRELATION
(
    NATIVE_CORRELATION_ID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW NATIVE_CORRELATION
 AS SELECT NATIVE_CORRELATION_ID, CONVERSATION_ID FROM E$NATIVE_CORRELATION;

CREATE INDEX NC_CORR ON E$NATIVE_CORRELATION
    (NATIVE_CORRELATION_ID );

CREATE INDEX NC_CONV ON E$NATIVE_CORRELATION
    (CONVERSATION_ID );

-- ----------------------------------------------------------------------- 
-- E$TEST_DEFINITIONS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$TEST_DEFINITIONS
(
    TEST_SUITE VARCHAR2(100) NOT NULL,
    LOCATION VARCHAR2(100) NOT NULL,
    TYPE VARCHAR2(10) NOT NULL,
    CREATION_DATE TIMESTAMP NOT NULL,
    DEFINITION BLOB NOT NULL
)
storage
(
    freelists 6
)
lob( definition )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 90
)
pctfree 99
pctused 1;

CREATE OR REPLACE EDITIONING VIEW TEST_DEFINITIONS
 AS SELECT TEST_SUITE, LOCATION, TYPE, CREATION_DATE, DEFINITION FROM E$TEST_DEFINITIONS;

ALTER TABLE E$TEST_DEFINITIONS
    ADD CONSTRAINT TEST_DEFINITIONS_PK PRIMARY KEY (TEST_SUITE, LOCATION, TYPE);

-- ----------------------------------------------------------------------- 
-- E$TEST_DETAILS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$TEST_DETAILS
(
    CIKEY NUMBER NOT NULL,
    TEST_SUITE VARCHAR2(100) NOT NULL,
    TEST_LOCATION VARCHAR2(100) NOT NULL,
    TEST_RUN_NAME VARCHAR2(100) NOT NULL,
    TEST_RUN_ID VARCHAR2(100) NOT NULL,
    TEST_STATUS VARCHAR2(50) NOT NULL,
    TEST_RESULT BLOB NOT NULL
)
storage
(
    freelists 6
)
lob( test_result )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 90
)
pctfree 99
pctused 1;

CREATE OR REPLACE EDITIONING VIEW TEST_DETAILS
 AS SELECT CIKEY, TEST_SUITE, TEST_LOCATION, TEST_RUN_NAME, TEST_RUN_ID, TEST_STATUS, TEST_RESULT FROM E$TEST_DETAILS;

ALTER TABLE E$TEST_DETAILS
    ADD CONSTRAINT TEST_DETAILS_PK PRIMARY KEY (CIKEY);

-- ----------------------------------------------------------------------- 
-- E$UPGRADE_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$UPGRADE_INFO
(
    LAST_COMPLETED_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW UPGRADE_INFO
 AS SELECT LAST_COMPLETED_DATE FROM E$UPGRADE_INFO;

-- ----------------------------------------------------------------------- 
-- E$VERSION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$VERSION
(
    GUID VARCHAR2(50),
    DBTYPE VARCHAR2(50),
    DBPROFILE VARCHAR2(10),
    SOA_UPGRADE_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW VERSION
 AS SELECT GUID, DBTYPE, DBPROFILE, SOA_UPGRADE_DATE FROM E$VERSION;

-- ----------------------------------------------------------------------- 
-- E$WI_FAULT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WI_FAULT
(
    CIKEY NUMBER NOT NULL,
    NODE_ID VARCHAR2(200) NOT NULL,
    SCOPE_ID VARCHAR2(1024) NOT NULL,
    COUNT_ID INTEGER NOT NULL,
    FAULT_NAME VARCHAR2(255),
    FAULT_TYPE VARCHAR2(255),
    POLICY_NAME VARCHAR2(100),
    POLICY_VERSION VARCHAR2(25),
    POLICY_CATEGORY VARCHAR2(25),
    POLICY_ECID VARCHAR2(100),
    CREATION_DATE TIMESTAMP NOT NULL,
    MODIFY_DATE TIMESTAMP,
    MESSAGE CLOB,
    CI_PARTITION_DATE TIMESTAMP NOT NULL
)
lob( message )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
storage
(
    freelists 20
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WI_FAULT
 AS SELECT CIKEY, NODE_ID, SCOPE_ID, COUNT_ID, FAULT_NAME, FAULT_TYPE, POLICY_NAME, POLICY_VERSION, POLICY_CATEGORY, POLICY_ECID, CREATION_DATE, MODIFY_DATE, MESSAGE, CI_PARTITION_DATE FROM E$WI_FAULT;

ALTER TABLE E$WI_FAULT
    ADD CONSTRAINT WI_FAULT_PK PRIMARY KEY (CIKEY, NODE_ID, SCOPE_ID, COUNT_ID);

CREATE INDEX WF_FK2 ON E$WI_FAULT
    (FAULT_NAME );

CREATE INDEX WF_CRDATE_CIKEY ON E$WI_FAULT
    (CREATION_DATE , CIKEY );

CREATE INDEX WF_CRDATE_TYPE ON E$WI_FAULT
    (CREATION_DATE , FAULT_TYPE );

-- ----------------------------------------------------------------------- 
-- E$WORK_ITEM 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WORK_ITEM
(
    CIKEY NUMBER NOT NULL,
    NODE_ID VARCHAR2(200) NOT NULL,
    SCOPE_ID VARCHAR2(1024) NOT NULL,
    COUNT_ID INTEGER NOT NULL,
    CREATION_DATE TIMESTAMP,
    CREATOR VARCHAR2(256),
    MODIFY_DATE TIMESTAMP,
    MODIFIER VARCHAR2(100),
    STATE INTEGER,
    TRANSITION INTEGER,
    EXCEPTION INTEGER DEFAULT 0 NOT NULL,
    EXP_DATE TIMESTAMP,
    EXP_FLAG INTEGER DEFAULT 0 NOT NULL,
    PRIORITY INTEGER,
    LABEL NVARCHAR2(128),
    CUSTOM_ID VARCHAR2(256),
    COMMENTS NVARCHAR2(2000),
    REFERENCE_ID VARCHAR2(128),
    IDEMPOTENT_FLAG INTEGER DEFAULT 0 NOT NULL,
    EXECUTION_TYPE INTEGER DEFAULT 0 NOT NULL,
    FIRST_DELAY INTEGER,
    DELAY INTEGER,
    EXT_STRING1 VARCHAR2(100),
    EXT_STRING2 VARCHAR2(100),
    EXT_INT1 INTEGER,
    CLUSTER_NODE_ID VARCHAR2(100),
    VERSION INTEGER,
    CI_PARTITION_DATE TIMESTAMP NOT NULL,
    CLUSTER_NODE_KEY INTEGER DEFAULT -1
)
storage
(
    freelists 20
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WORK_ITEM
 AS SELECT CIKEY, NODE_ID, SCOPE_ID, COUNT_ID, CREATION_DATE, CREATOR, MODIFY_DATE, MODIFIER, STATE, TRANSITION, EXCEPTION, EXP_DATE, EXP_FLAG, PRIORITY, LABEL, CUSTOM_ID, COMMENTS, REFERENCE_ID, IDEMPOTENT_FLAG, EXECUTION_TYPE, FIRST_DELAY, DELAY, EXT_STRING1, EXT_STRING2, EXT_INT1, CLUSTER_NODE_ID, VERSION, CI_PARTITION_DATE, CLUSTER_NODE_KEY FROM E$WORK_ITEM;

ALTER TABLE E$WORK_ITEM
    ADD CONSTRAINT WORK_ITEM_PK PRIMARY KEY (CIKEY, NODE_ID, SCOPE_ID, COUNT_ID);

CREATE INDEX WI_EXPIRED ON E$WORK_ITEM
    (EXP_DATE );

CREATE INDEX WI_STATE_KEY ON E$WORK_ITEM
    (STATE , CIKEY );

-- ----------------------------------------------------------------------- 
-- E$CUBE_PROCESS_BREAKPOINT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CUBE_PROCESS_BREAKPOINT
(
    COMPONENT_DN VARCHAR2(300) NOT NULL,
    ELEMENT_ID VARCHAR2(24) NOT NULL,
    CONDITION VARCHAR2(300) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CUBE_PROCESS_BREAKPOINT
 AS SELECT COMPONENT_DN, ELEMENT_ID, CONDITION FROM E$CUBE_PROCESS_BREAKPOINT;

ALTER TABLE E$CUBE_PROCESS_BREAKPOINT
    ADD CONSTRAINT CPB_PK PRIMARY KEY (COMPONENT_DN, ELEMENT_ID, CONDITION);

-- ----------------------------------------------------------------------- 
-- E$BPEL_CONVERSATION_SUBSCRIPTI 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPEL_CONVERSATION_SUBSCRIPTI
(
    KEY VARCHAR2(256) NOT NULL,
    SUBSCRIBER_ID VARCHAR2(1024),
    CI_PARTITION_DATE TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPEL_CONVERSATION_SUBSCRIPTION
 AS SELECT KEY, SUBSCRIBER_ID, CI_PARTITION_DATE FROM E$BPEL_CONVERSATION_SUBSCRIPTI;

ALTER TABLE E$BPEL_CONVERSATION_SUBSCRIPTI
    ADD CONSTRAINT CONV_SUB_PK PRIMARY KEY (KEY);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_BLOB_TRIGGERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_BLOB_TRIGGERS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    BLOB_DATA BLOB
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_BLOB_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA FROM E$soaqtz_BLOB_TRIGGERS;

ALTER TABLE E$soaqtz_BLOB_TRIGGERS
    ADD CONSTRAINT soaqtz_BLOB_TRIGGERS_PK PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_CALENDARS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_CALENDARS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    CALENDAR_NAME VARCHAR2(80) NOT NULL,
    CALENDAR BLOB NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_CALENDARS
 AS SELECT SCHED_NAME, CALENDAR_NAME, CALENDAR FROM E$soaqtz_CALENDARS;

ALTER TABLE E$soaqtz_CALENDARS
    ADD CONSTRAINT soaqtz_CALENDARS_PK PRIMARY KEY (CALENDAR_NAME);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_CRON_TRIGGERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_CRON_TRIGGERS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    CRON_EXPRESSION VARCHAR2(2048) NOT NULL,
    TIME_ZONE_ID VARCHAR2(80)
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_CRON_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID FROM E$soaqtz_CRON_TRIGGERS;

ALTER TABLE E$soaqtz_CRON_TRIGGERS
    ADD CONSTRAINT soaqtz_CRON_TRIGGERS_PK PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_FIRED_TRIGGERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_FIRED_TRIGGERS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    ENTRY_ID VARCHAR2(95) NOT NULL,
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    IS_VOLATILE VARCHAR2(1) DEFAULT '0',
    INSTANCE_NAME VARCHAR2(200) NOT NULL,
    FIRED_TIME NUMBER(13,0) NOT NULL,
    PRIORITY NUMBER(13,0) NOT NULL,
    STATE VARCHAR2(16) NOT NULL,
    JOB_NAME VARCHAR2(255),
    JOB_GROUP VARCHAR2(255),
    IS_STATEFUL VARCHAR2(1),
    IS_NONCONCURRENT VARCHAR2(1),
    REQUESTS_RECOVERY VARCHAR2(1),
    SCHED_TIME NUMBER(13,0)
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_FIRED_TRIGGERS
 AS SELECT SCHED_NAME, ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, PRIORITY, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, IS_NONCONCURRENT, REQUESTS_RECOVERY, SCHED_TIME FROM E$soaqtz_FIRED_TRIGGERS;

ALTER TABLE E$soaqtz_FIRED_TRIGGERS
    ADD CONSTRAINT soaqtz_FIRED_TRIGGERS_PK PRIMARY KEY (ENTRY_ID);

CREATE INDEX IDX_SOAQTZ_FT_TRIG_NAME ON E$soaqtz_FIRED_TRIGGERS
    (TRIGGER_NAME );

CREATE INDEX IDX_SOAQTZ_FT_TRIG_GROUP ON E$soaqtz_FIRED_TRIGGERS
    (TRIGGER_GROUP );

CREATE INDEX IDX_SOAQTZ_FT_TRIG_NM_GP ON E$soaqtz_FIRED_TRIGGERS
    (TRIGGER_NAME , TRIGGER_GROUP );

CREATE INDEX IDX_SOAQTZ_FT_TRIG_VOLATILE ON E$soaqtz_FIRED_TRIGGERS
    (IS_VOLATILE );

CREATE INDEX IDX_SOAQTZ_FT_TRIG_INST_NAME ON E$soaqtz_FIRED_TRIGGERS
    (INSTANCE_NAME );

CREATE INDEX IDX_SOAQTZ_FT_JOB_NAME ON E$soaqtz_FIRED_TRIGGERS
    (JOB_NAME );

CREATE INDEX IDX_SOAQTZ_FT_JOB_GROUP ON E$soaqtz_FIRED_TRIGGERS
    (JOB_GROUP );

CREATE INDEX IDX_SOAQTZ_FT_JOB_STATEFUL ON E$soaqtz_FIRED_TRIGGERS
    (IS_STATEFUL );

CREATE INDEX IDX_SOAQTZ_FT_JOB_REQ_RECOVERY ON E$soaqtz_FIRED_TRIGGERS
    (REQUESTS_RECOVERY );

CREATE INDEX IDX2_SOAQTZ_FT_TRIG_INST_NAME ON E$soaqtz_FIRED_TRIGGERS
    (SCHED_NAME , INSTANCE_NAME );

CREATE INDEX IDX2_SOAQTZ_FT_INST_J_REQ_RCVY ON E$soaqtz_FIRED_TRIGGERS
    (SCHED_NAME , INSTANCE_NAME , REQUESTS_RECOVERY );

CREATE INDEX IDX2_SOAQTZ_FT_J_G ON E$soaqtz_FIRED_TRIGGERS
    (SCHED_NAME , JOB_NAME , JOB_GROUP );

CREATE INDEX IDX2_SOAQTZ_FT_JG ON E$soaqtz_FIRED_TRIGGERS
    (SCHED_NAME , JOB_GROUP );

CREATE INDEX IDX2_SOAQTZ_FT_T_G ON E$soaqtz_FIRED_TRIGGERS
    (SCHED_NAME , TRIGGER_NAME , TRIGGER_GROUP );

CREATE INDEX IDX2_SOAQTZ_FT_TG ON E$soaqtz_FIRED_TRIGGERS
    (SCHED_NAME , TRIGGER_GROUP );

-- ----------------------------------------------------------------------- 
-- E$soaqtz_JOB_DETAILS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_JOB_DETAILS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    JOB_NAME VARCHAR2(255) NOT NULL,
    JOB_GROUP VARCHAR2(255) NOT NULL,
    DESCRIPTION VARCHAR2(120),
    JOB_CLASS_NAME VARCHAR2(128) NOT NULL,
    IS_DURABLE VARCHAR2(1) NOT NULL,
    IS_VOLATILE VARCHAR2(1) DEFAULT '0',
    IS_STATEFUL VARCHAR2(1) DEFAULT '0',
    IS_NONCONCURRENT VARCHAR2(1) DEFAULT '0',
    IS_UPDATE_DATA VARCHAR2(1) DEFAULT '0',
    REQUESTS_RECOVERY VARCHAR2(1) NOT NULL,
    JOB_DATA BLOB
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_JOB_DETAILS
 AS SELECT SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA FROM E$soaqtz_JOB_DETAILS;

ALTER TABLE E$soaqtz_JOB_DETAILS
    ADD CONSTRAINT soaqtz_JOB_DETAILS_PK PRIMARY KEY (JOB_NAME, JOB_GROUP);

CREATE INDEX IDX_SOAQTZ_J_REQ_RECOVERY ON E$soaqtz_JOB_DETAILS
    (REQUESTS_RECOVERY );

CREATE INDEX IDX2_SOAQTZ_J_REQ_RCVY ON E$soaqtz_JOB_DETAILS
    (SCHED_NAME , REQUESTS_RECOVERY );

CREATE INDEX IDX2_SOAQTZ_J_GRP ON E$soaqtz_JOB_DETAILS
    (SCHED_NAME , JOB_GROUP );

-- ----------------------------------------------------------------------- 
-- E$soaqtz_JOB_LISTENERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_JOB_LISTENERS
(
    JOB_NAME VARCHAR2(255) NOT NULL,
    JOB_GROUP VARCHAR2(255) NOT NULL,
    JOB_LISTENER VARCHAR2(80) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_JOB_LISTENERS
 AS SELECT JOB_NAME, JOB_GROUP, JOB_LISTENER FROM E$soaqtz_JOB_LISTENERS;

ALTER TABLE E$soaqtz_JOB_LISTENERS
    ADD CONSTRAINT soaqtz_JOB_LISTENERS_PK PRIMARY KEY (JOB_NAME, JOB_GROUP, JOB_LISTENER);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_LOCKS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_LOCKS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    LOCK_NAME VARCHAR2(40) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_LOCKS
 AS SELECT SCHED_NAME, LOCK_NAME FROM E$soaqtz_LOCKS;

ALTER TABLE E$soaqtz_LOCKS
    ADD CONSTRAINT soaqtz_LOCKS_PK PRIMARY KEY (LOCK_NAME);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_PAUSED_TRIGGER_GRPS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_PAUSED_TRIGGER_GRPS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    TRIGGER_GROUP VARCHAR2(255) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_PAUSED_TRIGGER_GRPS
 AS SELECT SCHED_NAME, TRIGGER_GROUP FROM E$soaqtz_PAUSED_TRIGGER_GRPS;

ALTER TABLE E$soaqtz_PAUSED_TRIGGER_GRPS
    ADD CONSTRAINT soaqtz_PAUSED_TRIGGER_GRPS_PK PRIMARY KEY (TRIGGER_GROUP);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_SCHEDULER_STATE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_SCHEDULER_STATE
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    INSTANCE_NAME VARCHAR2(200) NOT NULL,
    LAST_CHECKIN_TIME NUMBER(13,0) NOT NULL,
    CHECKIN_INTERVAL NUMBER(13,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_SCHEDULER_STATE
 AS SELECT SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL FROM E$soaqtz_SCHEDULER_STATE;

ALTER TABLE E$soaqtz_SCHEDULER_STATE
    ADD CONSTRAINT soaqtz_SCHEDULER_STATE_PK PRIMARY KEY (INSTANCE_NAME);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_SIMPLE_TRIGGERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_SIMPLE_TRIGGERS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    REPEAT_COUNT NUMBER(7,0) NOT NULL,
    REPEAT_INTERVAL NUMBER(12,0) NOT NULL,
    TIMES_TRIGGERED NUMBER(10,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_SIMPLE_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED FROM E$soaqtz_SIMPLE_TRIGGERS;

ALTER TABLE E$soaqtz_SIMPLE_TRIGGERS
    ADD CONSTRAINT soaqtz_SIMPLE_TRIGGERS_PK PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_TRIGGER_LISTENERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_TRIGGER_LISTENERS
(
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    TRIGGER_LISTENER VARCHAR2(80) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_TRIGGER_LISTENERS
 AS SELECT TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER FROM E$soaqtz_TRIGGER_LISTENERS;

ALTER TABLE E$soaqtz_TRIGGER_LISTENERS
    ADD CONSTRAINT soaqtz_TRIGGER_LISTENERS_PK PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER);

-- ----------------------------------------------------------------------- 
-- E$soaqtz_TRIGGERS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_TRIGGERS
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    JOB_NAME VARCHAR2(255) NOT NULL,
    JOB_GROUP VARCHAR2(255) NOT NULL,
    IS_VOLATILE VARCHAR2(1) DEFAULT '0',
    DESCRIPTION VARCHAR2(120),
    NEXT_FIRE_TIME NUMBER(13,0),
    PREV_FIRE_TIME NUMBER(13,0),
    PRIORITY NUMBER(13,0),
    TRIGGER_STATE VARCHAR2(16) NOT NULL,
    TRIGGER_TYPE VARCHAR2(8) NOT NULL,
    START_TIME NUMBER(13,0) NOT NULL,
    END_TIME NUMBER(13,0),
    CALENDAR_NAME VARCHAR2(80),
    MISFIRE_INSTR NUMBER(2,0),
    JOB_DATA BLOB
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA FROM E$soaqtz_TRIGGERS;

ALTER TABLE E$soaqtz_TRIGGERS
    ADD CONSTRAINT soaqtz_TRIGGERS_PK PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP);

CREATE INDEX IDX_SOAQTZ_T_NEXT_FIRE_TIME ON E$soaqtz_TRIGGERS
    (NEXT_FIRE_TIME );

CREATE INDEX IDX_SOAQTZ_T_STATE ON E$soaqtz_TRIGGERS
    (TRIGGER_STATE );

CREATE INDEX IDX_SOAQTZ_JOBNAME_JOBGROUP ON E$soaqtz_TRIGGERS
    (JOB_NAME , JOB_GROUP );

CREATE INDEX IDX_SOAQTZ_T_NFT_ST ON E$soaqtz_TRIGGERS
    (NEXT_FIRE_TIME , TRIGGER_STATE );

CREATE INDEX IDX_SOAQTZ_T_VOLATILE ON E$soaqtz_TRIGGERS
    (IS_VOLATILE );

CREATE INDEX IDX2_SOAQTZ_T_J ON E$soaqtz_TRIGGERS
    (SCHED_NAME , JOB_NAME , JOB_GROUP );

CREATE INDEX IDX2_SOAQTZ_T_JG ON E$soaqtz_TRIGGERS
    (SCHED_NAME , JOB_GROUP );

CREATE INDEX IDX2_SOAQTZ_T_C ON E$soaqtz_TRIGGERS
    (SCHED_NAME , CALENDAR_NAME );

CREATE INDEX IDX2_SOAQTZ_T_G ON E$soaqtz_TRIGGERS
    (SCHED_NAME , TRIGGER_GROUP );

CREATE INDEX IDX2_SOAQTZ_T_STATE ON E$soaqtz_TRIGGERS
    (SCHED_NAME , TRIGGER_STATE );

CREATE INDEX IDX2_SOAQTZ_T_N_STATE ON E$soaqtz_TRIGGERS
    (SCHED_NAME , TRIGGER_NAME , TRIGGER_GROUP , TRIGGER_STATE );

CREATE INDEX IDX2_SOAQTZ_T_N_G_STATE ON E$soaqtz_TRIGGERS
    (SCHED_NAME , TRIGGER_GROUP , TRIGGER_STATE );

CREATE INDEX IDX2_SOAQTZ_T_NEXT_FIRE_TIME ON E$soaqtz_TRIGGERS
    (SCHED_NAME , NEXT_FIRE_TIME );

CREATE INDEX IDX2_SOAQTZ_T_NFT_ST ON E$soaqtz_TRIGGERS
    (SCHED_NAME , NEXT_FIRE_TIME , TRIGGER_STATE );

CREATE INDEX IDX2_SOAQTZ_T_NFT_MISFIRE ON E$soaqtz_TRIGGERS
    (SCHED_NAME , MISFIRE_INSTR , NEXT_FIRE_TIME );

CREATE INDEX IDX2_SOAQTZ_T_NFT_ST_MISFIRE ON E$soaqtz_TRIGGERS
    (SCHED_NAME , MISFIRE_INSTR , NEXT_FIRE_TIME , TRIGGER_STATE );

CREATE INDEX IDX2_SOAQTZ_T_NFT_ST_MFIRE_GRP ON E$soaqtz_TRIGGERS
    (SCHED_NAME , MISFIRE_INSTR , NEXT_FIRE_TIME , TRIGGER_GROUP );

-- ----------------------------------------------------------------------- 
-- E$soaqtz_simprop_triggers 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$soaqtz_simprop_triggers
(
    SCHED_NAME VARCHAR2(120) DEFAULT 'FabricScheduler',
    TRIGGER_NAME VARCHAR2(255) NOT NULL,
    TRIGGER_GROUP VARCHAR2(255) NOT NULL,
    STR_PROP_1 VARCHAR2(512),
    STR_PROP_2 VARCHAR2(512),
    STR_PROP_3 VARCHAR2(512),
    INT_PROP_1 NUMBER(10,0),
    INT_PROP_2 NUMBER(10,0),
    LONG_PROP_1 NUMBER(13,0),
    LONG_PROP_2 NUMBER(13,0),
    DEC_PROP_1 NUMBER(13,4),
    DEC_PROP_2 NUMBER(13,4),
    BOOL_PROP_1 VARCHAR2(1),
    BOOL_PROP_2 VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW soaqtz_simprop_triggers
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, STR_PROP_1, STR_PROP_2, STR_PROP_3, INT_PROP_1, INT_PROP_2, LONG_PROP_1, LONG_PROP_2, DEC_PROP_1, DEC_PROP_2, BOOL_PROP_1, BOOL_PROP_2 FROM E$soaqtz_simprop_triggers;

ALTER TABLE E$soaqtz_simprop_triggers
    ADD CONSTRAINT soaqtz_simprop_triggers_PK PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_OBJECT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_OBJECT
(
    ID VARCHAR2(255) NOT NULL,
    CASE_ID VARCHAR2(255),
    OBJECT_TYPE VARCHAR2(255),
    OBJECT_NAME VARCHAR2(255),
    OBJECT_DISPLAY_NAME VARCHAR2(255),
    UPDATED_BY VARCHAR2(255),
    UPDATED_BY_DISPLAY_NAME VARCHAR2(255),
    UPDATED_DATE TIMESTAMP,
    PERMISSION_TAG VARCHAR2(255),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    SYSTEM_ATTR_STRING_01 VARCHAR2(400),
    SYSTEM_ATTR_STRING_02 VARCHAR2(400),
    SYSTEM_ATTR_STRING_03 VARCHAR2(400),
    SYSTEM_ATTR_NUMBER_01 NUMBER,
    SYSTEM_ATTR_NUMBER_02 NUMBER,
    SYSTEM_ATTR_BOOLEAN_01 VARCHAR2(1),
    SYSTEM_ATTR_BOOLEAN_02 VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_OBJECT
 AS SELECT ID, CASE_ID, OBJECT_TYPE, OBJECT_NAME, OBJECT_DISPLAY_NAME, UPDATED_BY, UPDATED_BY_DISPLAY_NAME, UPDATED_DATE, PERMISSION_TAG, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, SYSTEM_ATTR_STRING_01, SYSTEM_ATTR_STRING_02, SYSTEM_ATTR_STRING_03, SYSTEM_ATTR_NUMBER_01, SYSTEM_ATTR_NUMBER_02, SYSTEM_ATTR_BOOLEAN_01, SYSTEM_ATTR_BOOLEAN_02 FROM E$CM_CASE_OBJECT;

ALTER TABLE E$CM_CASE_OBJECT
    ADD CONSTRAINT CM_CASE_OBJECT_PK PRIMARY KEY (ID);

CREATE INDEX CM_CASE_OBJECT_ID_TYPE_DATE_I ON E$CM_CASE_OBJECT
    (CASE_ID , OBJECT_TYPE , UPDATED_DATE );

CREATE INDEX CM_CASE_OBJECT_ID_TYPE_I ON E$CM_CASE_OBJECT
    (ID , OBJECT_TYPE );

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_DOCUMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_DOCUMENT
(
    ID VARCHAR2(255) NOT NULL,
    FOLDER VARCHAR2(255),
    DOC_SIZE NUMBER,
    DOC_VERSION VARCHAR2(32),
    DOC_COMMENT VARCHAR2(255),
    DOC_CONTENT BLOB,
    DOC_CONTENT_TYPE VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
)
;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DOCUMENT
 AS SELECT ID, FOLDER, DOC_SIZE, DOC_VERSION, DOC_COMMENT, DOC_CONTENT, DOC_CONTENT_TYPE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_CASE_DOCUMENT;

ALTER TABLE E$CM_CASE_DOCUMENT
    ADD CONSTRAINT CM_CASE_DOCUMENT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_EVENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_EVENT
(
    ID VARCHAR2(255) NOT NULL,
    EVENT_TYPE VARCHAR2(255),
    ACTIVITY_NAME VARCHAR2(255),
    ACTIVITY_TYPE VARCHAR2(255),
    ACTIVITY_ID VARCHAR2(255),
    ACTIVITY_EVENT VARCHAR2(32),
    STARTED_DATE TIMESTAMP,
    COMPLETED_DATE TIMESTAMP,
    LIFECYCLE_STATE VARCHAR2(255),
    LIFECYCLE_EVENT VARCHAR2(32),
    DOCUMENT_NAME VARCHAR2(255),
    DOCUMENT_VERSION VARCHAR2(32),
    DOCUMENT_ID VARCHAR2(255),
    DOCUMENT_EVENT VARCHAR2(32),
    MILESTONE VARCHAR2(255),
    MILESTONE_EVENT VARCHAR2(32),
    USER_DEFINED_EVENT VARCHAR2(255),
    DATA_NAME VARCHAR2(255),
    COMMENT_ID VARCHAR2(255),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    EVENT_SUB_TYPE VARCHAR2(255),
    ATTRIBUTE1 VARCHAR2(255),
    ATTRIBUTE2 VARCHAR2(255),
    ATTRIBUTE3 VARCHAR2(255),
    ATTRIBUTE4 VARCHAR2(255),
    FORGET VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_EVENT
 AS SELECT ID, EVENT_TYPE, ACTIVITY_NAME, ACTIVITY_TYPE, ACTIVITY_ID, ACTIVITY_EVENT, STARTED_DATE, COMPLETED_DATE, LIFECYCLE_STATE, LIFECYCLE_EVENT, DOCUMENT_NAME, DOCUMENT_VERSION, DOCUMENT_ID, DOCUMENT_EVENT, MILESTONE, MILESTONE_EVENT, USER_DEFINED_EVENT, DATA_NAME, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, EVENT_SUB_TYPE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, FORGET FROM E$CM_CASE_EVENT;

ALTER TABLE E$CM_CASE_EVENT
    ADD CONSTRAINT CM_CASE_EVENT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$CM_PROPERTY_BAG 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_PROPERTY_BAG
(
    ID VARCHAR2(255) NOT NULL,
    NAME VARCHAR2(255) NOT NULL,
    VALUE VARCHAR2(255) NOT NULL,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW CM_PROPERTY_BAG
 AS SELECT ID, NAME, VALUE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_PROPERTY_BAG;

ALTER TABLE E$CM_PROPERTY_BAG
    ADD CONSTRAINT CM_PROPERTY_BAG_PK PRIMARY KEY (ID, NAME);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_DEFINITION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_DEFINITION
(
    DEFINITION_ID VARCHAR2(400) NOT NULL,
    NAME VARCHAR2(255) NOT NULL,
    TITLE VARCHAR2(500),
    DESCRIPTION VARCHAR2(1000),
    CATEGORY VARCHAR2(400),
    NAMESPACE VARCHAR2(2000),
    COMPONENT_NAME VARCHAR2(200),
    COMPOSITE_DN VARCHAR2(500),
    COMPOSITE_NAME VARCHAR2(200),
    COMPOSITE_VERSION VARCHAR2(200),
    APPLICATION_NAME VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DEFINITION
 AS SELECT DEFINITION_ID, NAME, TITLE, DESCRIPTION, CATEGORY, NAMESPACE, COMPONENT_NAME, COMPOSITE_DN, COMPOSITE_NAME, COMPOSITE_VERSION, APPLICATION_NAME FROM E$CM_CASE_DEFINITION;

ALTER TABLE E$CM_CASE_DEFINITION
    ADD CONSTRAINT CM_CASE_DEFINITION_PK PRIMARY KEY (DEFINITION_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_MILESTONE_DEFINITION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_MILESTONE_DEFINITION
(
    CASE_DEFINITION_ID VARCHAR2(400) NOT NULL,
    MILESTONE_ID VARCHAR2(400) NOT NULL,
    MILESTONE_NAME VARCHAR2(500) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_MILESTONE_DEFINITION
 AS SELECT CASE_DEFINITION_ID, MILESTONE_ID, MILESTONE_NAME FROM E$CM_CASE_MILESTONE_DEFINITION;

ALTER TABLE E$CM_CASE_MILESTONE_DEFINITION
    ADD CONSTRAINT CM_CASE_MILESTO_DEFINITION_PK PRIMARY KEY (CASE_DEFINITION_ID, MILESTONE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_DEFINITION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_DEFINITION
(
    DEFINITION_ID VARCHAR2(200) NOT NULL,
    TYPE VARCHAR2(255) NOT NULL,
    NAME VARCHAR2(255) NOT NULL,
    TITLE VARCHAR2(500),
    DESCRIPTION VARCHAR2(1000),
    NAMESPACE VARCHAR2(2000),
    COMPONENT_NAME VARCHAR2(200),
    COMPOSITE_DN VARCHAR2(500),
    COMPOSITE_NAME VARCHAR2(200),
    COMPOSITE_VERSION VARCHAR2(200),
    APPLICATION_NAME VARCHAR2(200),
    PAYLOAD CLOB,
    CLASS_NAME VARCHAR2(2000),
    IS_CUSTOM VARCHAR2(1),
    IS_GLOBAL VARCHAR2(1),
    IS_MANUAL VARCHAR2(1),
    IS_CONDITIONAL VARCHAR2(1),
    IS_CASE_SPECIFIC VARCHAR2(1),
    IS_REQUIRED VARCHAR2(1),
    IS_REPEATABLE VARCHAR2(1),
    PRODUCT_VERSION VARCHAR2(200),
    PERMISSION_TAG VARCHAR2(255),
    TOTAL_RATING INTEGER,
    NUMBER_OF_RATINGS INTEGER,
    SYSTEM_STRING_01 VARCHAR2(400),
    SYSTEM_STRING_02 VARCHAR2(400),
    SYSTEM_STRING_03 VARCHAR2(400),
    SYSTEM_NUMBER_01 NUMBER,
    SYSTEM_NUMBER_02 NUMBER,
    SYSTEM_BOOLEAN_01 VARCHAR2(1),
    SYSTEM_BOOLEAN_02 VARCHAR2(1),
    DISPLAY_NAME VARCHAR2(255),
    MILESTONE_NAME VARCHAR2(255)
)
;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_DEFINITION
 AS SELECT DEFINITION_ID, TYPE, NAME, TITLE, DESCRIPTION, NAMESPACE, COMPONENT_NAME, COMPOSITE_DN, COMPOSITE_NAME, COMPOSITE_VERSION, APPLICATION_NAME, PAYLOAD, CLASS_NAME, IS_CUSTOM, IS_GLOBAL, IS_MANUAL, IS_CONDITIONAL, IS_CASE_SPECIFIC, IS_REQUIRED, IS_REPEATABLE, PRODUCT_VERSION, PERMISSION_TAG, TOTAL_RATING, NUMBER_OF_RATINGS, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, DISPLAY_NAME, MILESTONE_NAME FROM E$CM_ACTIVITY_DEFINITION;

ALTER TABLE E$CM_ACTIVITY_DEFINITION
    ADD CONSTRAINT CM_ACTIVITY_DEFINITION_PK PRIMARY KEY (DEFINITION_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_CASE_DEFINITION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_CASE_DEFINITION
(
    ACTIVITY_DEFINITION_ID VARCHAR2(200) NOT NULL,
    CASE_DEFINITION_ID VARCHAR2(400) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_CASE_DEFINITION
 AS SELECT ACTIVITY_DEFINITION_ID, CASE_DEFINITION_ID FROM E$CM_ACTIVITY_CASE_DEFINITION;

ALTER TABLE E$CM_ACTIVITY_CASE_DEFINITION
    ADD CONSTRAINT CM_ACTIVITY_CASE_DEFINITION_PK PRIMARY KEY (ACTIVITY_DEFINITION_ID, CASE_DEFINITION_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_CATEGORY_DEFN 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_CATEGORY_DEFN
(
    ACTIVITY_DEFINITION_ID VARCHAR2(200) NOT NULL,
    CATEGORY VARCHAR2(400) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_CATEGORY_DEFN
 AS SELECT ACTIVITY_DEFINITION_ID, CATEGORY FROM E$CM_ACTIVITY_CATEGORY_DEFN;

ALTER TABLE E$CM_ACTIVITY_CATEGORY_DEFN
    ADD CONSTRAINT CM_ACTIVITY_CATEGORY_DEFN_PK PRIMARY KEY (ACTIVITY_DEFINITION_ID, CATEGORY);

-- ----------------------------------------------------------------------- 
-- E$CM_TRANSLATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_TRANSLATION
(
    CASE_ID VARCHAR2(255) NOT NULL,
    LOCALE VARCHAR2(50) NOT NULL,
    TITLE VARCHAR2(1000),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    SHORT_SUMMARY VARCHAR2(2000),
    LONG_SUMMARY VARCHAR2(4000)
);

CREATE OR REPLACE EDITIONING VIEW CM_TRANSLATION
 AS SELECT CASE_ID, LOCALE, TITLE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, SHORT_SUMMARY, LONG_SUMMARY FROM E$CM_TRANSLATION;

ALTER TABLE E$CM_TRANSLATION
    ADD CONSTRAINT CM_TRANSLATION_PK PRIMARY KEY (CASE_ID, LOCALE);

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_INSTANCE
(
    ACTIVITY_DEFINITION_ID VARCHAR2(200) NOT NULL,
    CASE_ID VARCHAR2(255) NOT NULL,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_INSTANCE
 AS SELECT ACTIVITY_DEFINITION_ID, CASE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_ACTIVITY_INSTANCE;

ALTER TABLE E$CM_ACTIVITY_INSTANCE
    ADD CONSTRAINT CM_ACTIVITY_INSTANCE_PK PRIMARY KEY (ACTIVITY_DEFINITION_ID, CASE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE
(
    CASE_ID VARCHAR2(255) NOT NULL,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE
 AS SELECT CASE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_CASE;

ALTER TABLE E$CM_CASE
    ADD CONSTRAINT CM_CASE_PK PRIMARY KEY (CASE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_FABRIC_HEADER_PROPERTY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_FABRIC_HEADER_PROPERTY
(
    CASE_ID VARCHAR2(255) NOT NULL,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    PROPERTIES BLOB,
    COMPOSITE_CREATED_TIME TIMESTAMP DEFAULT systimestamp-30
)
;

CREATE OR REPLACE EDITIONING VIEW CM_FABRIC_HEADER_PROPERTY
 AS SELECT CASE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, PROPERTIES, COMPOSITE_CREATED_TIME FROM E$CM_FABRIC_HEADER_PROPERTY;

ALTER TABLE E$CM_FABRIC_HEADER_PROPERTY
    ADD CONSTRAINT CM_FABRIC_HEADER_PROPERTY_PK PRIMARY KEY (CASE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_LINKED_CASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_LINKED_CASE
(
    CASE_ID VARCHAR2(255) NOT NULL,
    RELATIONSHIP VARCHAR2(400) NOT NULL,
    LINKED_CASE_ID VARCHAR2(255) NOT NULL,
    COMMENT_ID VARCHAR2(255),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    ID VARCHAR2(255) NOT NULL,
    CASE_NUMBER NUMBER NOT NULL,
    CASE_TITLE VARCHAR2(500),
    RELATIONSHIP_DISPLAY_NAME VARCHAR2(1000) NOT NULL,
    LINKED_CASE_NUMBER NUMBER NOT NULL,
    LINKED_CASE_TITLE VARCHAR2(500)
);

CREATE OR REPLACE EDITIONING VIEW CM_LINKED_CASE
 AS SELECT CASE_ID, RELATIONSHIP, LINKED_CASE_ID, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, ID, CASE_NUMBER, CASE_TITLE, RELATIONSHIP_DISPLAY_NAME, LINKED_CASE_NUMBER, LINKED_CASE_TITLE FROM E$CM_LINKED_CASE;

ALTER TABLE E$CM_LINKED_CASE ADD CONSTRAINT CM_LINKED_CASE_UK UNIQUE
    (CASE_ID , RELATIONSHIP , LINKED_CASE_ID );

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_DATA
(
    ID VARCHAR2(255) NOT NULL,
    DATA CLOB,
    COMMENT_ID VARCHAR2(255),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    IS_EXTERNAL VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DATA
 AS SELECT ID, DATA, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_EXTERNAL FROM E$CM_CASE_DATA;

ALTER TABLE E$CM_CASE_DATA
    ADD CONSTRAINT CM_CASE_DATA_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_FLEX_FIELD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_FLEX_FIELD
(
    CASE_ID VARCHAR2(255) NOT NULL,
    textAttribute1 VARCHAR2(2000),
    textAttribute2 VARCHAR2(2000),
    textAttribute3 VARCHAR2(2000),
    textAttribute4 VARCHAR2(2000),
    textAttribute5 VARCHAR2(2000),
    textAttribute6 VARCHAR2(2000),
    textAttribute7 VARCHAR2(2000),
    textAttribute8 VARCHAR2(2000),
    textAttribute9 VARCHAR2(2000),
    textAttribute10 VARCHAR2(2000),
    textAttribute11 VARCHAR2(2000),
    textAttribute12 VARCHAR2(2000),
    textAttribute13 VARCHAR2(2000),
    textAttribute14 VARCHAR2(2000),
    textAttribute15 VARCHAR2(2000),
    textAttribute16 VARCHAR2(2000),
    textAttribute17 VARCHAR2(2000),
    textAttribute18 VARCHAR2(2000),
    textAttribute19 VARCHAR2(2000),
    textAttribute20 VARCHAR2(2000),
    numberAttribute1 NUMBER,
    numberAttribute2 NUMBER,
    numberAttribute3 NUMBER,
    numberAttribute4 NUMBER,
    numberAttribute5 NUMBER,
    numberAttribute6 NUMBER,
    numberAttribute7 NUMBER,
    numberAttribute8 NUMBER,
    numberAttribute9 NUMBER,
    numberAttribute10 NUMBER,
    dateAttribute1 DATE,
    dateAttribute2 DATE,
    dateAttribute3 DATE,
    dateAttribute4 DATE,
    dateAttribute5 DATE,
    dateAttribute6 DATE,
    dateAttribute7 DATE,
    dateAttribute8 DATE,
    dateAttribute9 DATE,
    dateAttribute10 DATE,
    protectedTextAttribute1 VARCHAR2(2000),
    protectedTextAttribute2 VARCHAR2(2000),
    protectedTextAttribute3 VARCHAR2(2000),
    protectedTextAttribute4 VARCHAR2(2000),
    protectedTextAttribute5 VARCHAR2(2000),
    protectedTextAttribute6 VARCHAR2(2000),
    protectedTextAttribute7 VARCHAR2(2000),
    protectedTextAttribute8 VARCHAR2(2000),
    protectedTextAttribute9 VARCHAR2(2000),
    protectedTextAttribute10 VARCHAR2(2000),
    protectedTextAttribute11 VARCHAR2(2000),
    protectedTextAttribute12 VARCHAR2(2000),
    protectedTextAttribute13 VARCHAR2(2000),
    protectedTextAttribute14 VARCHAR2(2000),
    protectedTextAttribute15 VARCHAR2(2000),
    protectedTextAttribute16 VARCHAR2(2000),
    protectedTextAttribute17 VARCHAR2(2000),
    protectedTextAttribute18 VARCHAR2(2000),
    protectedTextAttribute19 VARCHAR2(2000),
    protectedTextAttribute20 VARCHAR2(2000),
    protectedNumberAttribute1 NUMBER,
    protectedNumberAttribute2 NUMBER,
    protectedNumberAttribute3 NUMBER,
    protectedNumberAttribute4 NUMBER,
    protectedNumberAttribute5 NUMBER,
    protectedNumberAttribute6 NUMBER,
    protectedNumberAttribute7 NUMBER,
    protectedNumberAttribute8 NUMBER,
    protectedNumberAttribute9 NUMBER,
    protectedNumberAttribute10 NUMBER,
    protectedDateAttribute1 DATE,
    protectedDateAttribute2 DATE,
    protectedDateAttribute3 DATE,
    protectedDateAttribute4 DATE,
    protectedDateAttribute5 DATE,
    protectedDateAttribute6 DATE,
    protectedDateAttribute7 DATE,
    protectedDateAttribute8 DATE,
    protectedDateAttribute9 DATE,
    protectedDateAttribute10 DATE,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_FLEX_FIELD
 AS SELECT CASE_ID, textAttribute1, textAttribute2, textAttribute3, textAttribute4, textAttribute5, textAttribute6, textAttribute7, textAttribute8, textAttribute9, textAttribute10, textAttribute11, textAttribute12, textAttribute13, textAttribute14, textAttribute15, textAttribute16, textAttribute17, textAttribute18, textAttribute19, textAttribute20, numberAttribute1, numberAttribute2, numberAttribute3, numberAttribute4, numberAttribute5, numberAttribute6, numberAttribute7, numberAttribute8, numberAttribute9, numberAttribute10, dateAttribute1, dateAttribute2, dateAttribute3, dateAttribute4, dateAttribute5, dateAttribute6, dateAttribute7, dateAttribute8, dateAttribute9, dateAttribute10, protectedTextAttribute1, protectedTextAttribute2, protectedTextAttribute3, protectedTextAttribute4, protectedTextAttribute5, protectedTextAttribute6, protectedTextAttribute7, protectedTextAttribute8, protectedTextAttribute9, protectedTextAttribute10, protectedTextAttribute11, protectedTextAttribute12, protectedTextAttribute13, protectedTextAttribute14, protectedTextAttribute15, protectedTextAttribute16, protectedTextAttribute17, protectedTextAttribute18, protectedTextAttribute19, protectedTextAttribute20, protectedNumberAttribute1, protectedNumberAttribute2, protectedNumberAttribute3, protectedNumberAttribute4, protectedNumberAttribute5, protectedNumberAttribute6, protectedNumberAttribute7, protectedNumberAttribute8, protectedNumberAttribute9, protectedNumberAttribute10, protectedDateAttribute1, protectedDateAttribute2, protectedDateAttribute3, protectedDateAttribute4, protectedDateAttribute5, protectedDateAttribute6, protectedDateAttribute7, protectedDateAttribute8, protectedDateAttribute9, protectedDateAttribute10, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_CASE_FLEX_FIELD;

ALTER TABLE E$CM_CASE_FLEX_FIELD
    ADD CONSTRAINT CM_CASE_FLEX_FIELDS_PK PRIMARY KEY (CASE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_HEADER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_HEADER
(
    ID VARCHAR2(255) NOT NULL,
    CASE_NUMBER NUMBER NOT NULL,
    TITLE VARCHAR2(500),
    SHORT_SUMMARY VARCHAR2(2000),
    LONG_SUMMARY VARCHAR2(4000),
    PRIORITY INTEGER,
    IDENTIFICATION_KEY VARCHAR2(100),
    CATEGORY VARCHAR2(400),
    CATEGORY_DISPLAY_NAME VARCHAR2(800),
    CREATED_BY VARCHAR2(400),
    CREATED_BY_DISPLAY_NAME VARCHAR2(400),
    STATE VARCHAR2(100),
    STATE_DISPLAY_NAME VARCHAR2(400),
    OUTCOME VARCHAR2(400),
    OUTCOME_DISPLAY_NAME VARCHAR2(800),
    CREATED_DATE TIMESTAMP,
    EXPIRATION_DATE TIMESTAMP,
    END_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    CASE_NAMESPACE VARCHAR2(200) NOT NULL,
    CASE_DEFINITION_ID VARCHAR2(400) NOT NULL,
    CASE_DEFINITION_NAME VARCHAR2(200) NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ECM_FOLDER VARCHAR2(2000),
    APPLICATION_NAME VARCHAR2(200),
    COMPONENT_NAME VARCHAR2(500),
    COMPOSITE_DN VARCHAR2(500),
    COMPOSITE_INSTANCE_ID VARCHAR2(200),
    COMPOSITE_NAME VARCHAR2(200),
    COMPOSITE_VERSION VARCHAR2(200),
    CONVERSATION_ID VARCHAR2(200),
    ECID VARCHAR2(200),
    PARENT_COMPONENT_INSTANCE_ID VARCHAR2(200),
    PARENT_COMPONENT_INST_REF_ID VARCHAR2(200),
    INVOKED_COMPONENT VARCHAR2(500),
    COMPOSITE_CREATED_TIME TIMESTAMP,
    ORGANIZATIONAL_UNIT_ID VARCHAR2(64),
    DOMAIN_STATE VARCHAR2(300),
    DOMAIN_STATE_DISPLAY_NAME VARCHAR2(600),
    COMPONENT_INSTANCE_ID NUMBER(38,0),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUE_DATE_DURATION VARCHAR2(255),
    PERCENTAGE_COMPLETE NUMBER,
    CORRELATION_PROPERTY VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_HEADER
 AS SELECT ID, CASE_NUMBER, TITLE, SHORT_SUMMARY, LONG_SUMMARY, PRIORITY, IDENTIFICATION_KEY, CATEGORY, CATEGORY_DISPLAY_NAME, CREATED_BY, CREATED_BY_DISPLAY_NAME, STATE, STATE_DISPLAY_NAME, OUTCOME, OUTCOME_DISPLAY_NAME, CREATED_DATE, EXPIRATION_DATE, END_DATE, DUE_DATE, CASE_NAMESPACE, CASE_DEFINITION_ID, CASE_DEFINITION_NAME, TENANT_ID, ECM_FOLDER, APPLICATION_NAME, COMPONENT_NAME, COMPOSITE_DN, COMPOSITE_INSTANCE_ID, COMPOSITE_NAME, COMPOSITE_VERSION, CONVERSATION_ID, ECID, PARENT_COMPONENT_INSTANCE_ID, PARENT_COMPONENT_INST_REF_ID, INVOKED_COMPONENT, COMPOSITE_CREATED_TIME, ORGANIZATIONAL_UNIT_ID, DOMAIN_STATE, DOMAIN_STATE_DISPLAY_NAME, COMPONENT_INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUE_DATE_DURATION, PERCENTAGE_COMPLETE, CORRELATION_PROPERTY FROM E$CM_CASE_HEADER;

ALTER TABLE E$CM_CASE_HEADER
    ADD CONSTRAINT CM_CASE_HEADER_PK PRIMARY KEY (ID);

CREATE INDEX CASE_NUMBER_I ON E$CM_CASE_HEADER
    (CASE_NUMBER );

CREATE INDEX IDENTIFICATION_KEY_I ON E$CM_CASE_HEADER
    (IDENTIFICATION_KEY );

CREATE INDEX ECID_I ON E$CM_CASE_HEADER
    (ECID );

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_MILESTONE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_MILESTONE
(
    ID VARCHAR2(255) NOT NULL,
    ORDERING_SEQUENCE NUMBER,
    STATE VARCHAR2(255),
    STATE_DISPLAY_NAME VARCHAR2(400),
    COMMENT_ID VARCHAR2(255),
    SYSTEM_STRING_01 VARCHAR2(400),
    SYSTEM_STRING_02 VARCHAR2(400),
    SYSTEM_STRING_03 VARCHAR2(400),
    SYSTEM_NUMBER_01 NUMBER,
    SYSTEM_NUMBER_02 NUMBER,
    SYSTEM_BOOLEAN_01 VARCHAR2(1),
    SYSTEM_BOOLEAN_02 VARCHAR2(1),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DEADLINE TIMESTAMP,
    DEADLINE_DURATION VARCHAR2(255)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_MILESTONE
 AS SELECT ID, ORDERING_SEQUENCE, STATE, STATE_DISPLAY_NAME, COMMENT_ID, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DEADLINE, DEADLINE_DURATION FROM E$CM_CASE_MILESTONE;

ALTER TABLE E$CM_CASE_MILESTONE
    ADD CONSTRAINT CM_CASE_MILESTONE_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_PHASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_PHASE
(
    ID VARCHAR2(255) NOT NULL,
    SEQUENCE_ORDER INTEGER,
    STATE VARCHAR2(255),
    STATE_DISPLAY_NAME VARCHAR2(400),
    PERCENTAGE_COMPLETE NUMBER,
    COMMENT_ID VARCHAR2(255),
    SYSTEM_STRING_01 VARCHAR2(400),
    SYSTEM_STRING_02 VARCHAR2(400),
    SYSTEM_STRING_03 VARCHAR2(400),
    SYSTEM_NUMBER_01 NUMBER,
    SYSTEM_NUMBER_02 NUMBER,
    SYSTEM_NUMBER_03 NUMBER,
    SYSTEM_BOOLEAN_01 VARCHAR2(1),
    SYSTEM_BOOLEAN_02 VARCHAR2(1),
    SYSTEM_BOOLEAN_03 VARCHAR2(1),
    SYSTEM_DATE_01 TIMESTAMP,
    SYSTEM_DATE_02 TIMESTAMP,
    SYSTEM_DATE_03 TIMESTAMP,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DEADLINE TIMESTAMP,
    DEADLINE_DURATION VARCHAR2(255)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_PHASE
 AS SELECT ID, SEQUENCE_ORDER, STATE, STATE_DISPLAY_NAME, PERCENTAGE_COMPLETE, COMMENT_ID, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_NUMBER_03, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, SYSTEM_BOOLEAN_03, SYSTEM_DATE_01, SYSTEM_DATE_02, SYSTEM_DATE_03, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DEADLINE, DEADLINE_DURATION FROM E$CM_CASE_PHASE;

ALTER TABLE E$CM_CASE_PHASE
    ADD CONSTRAINT CM_CASE_PHASE_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_STAKE_HOLDER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_STAKE_HOLDER
(
    ID VARCHAR2(255) NOT NULL,
    STAKE_HOLDER VARCHAR2(400),
    STAKE_HOLDER_TYPE VARCHAR2(200),
    STAKE_HOLDER_DISPLAY_NAME VARCHAR2(800),
    PERMISSION_MEMBER_ROLE VARCHAR2(400),
    APPLICATION_CONTEXT VARCHAR2(400),
    COMMENT_ID VARCHAR2(255),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    IS_STAKE_HOLDER_SUPPLEMENT VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_STAKE_HOLDER
 AS SELECT ID, STAKE_HOLDER, STAKE_HOLDER_TYPE, STAKE_HOLDER_DISPLAY_NAME, PERMISSION_MEMBER_ROLE, APPLICATION_CONTEXT, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_STAKE_HOLDER_SUPPLEMENT FROM E$CM_CASE_STAKE_HOLDER;

ALTER TABLE E$CM_CASE_STAKE_HOLDER
    ADD CONSTRAINT CM_CASE_STAKE_HOLDER_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_STAKE_HOLDER_MEMBER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_STAKE_HOLDER_MEMBER
(
    ID VARCHAR2(255) NOT NULL,
    STAKE_HOLDER_ID VARCHAR2(255) NOT NULL,
    STAKE_HOLDER VARCHAR2(400) NOT NULL,
    STAKE_HOLDER_DISPLAY_NAME VARCHAR2(800),
    STAKE_HOLDER_TYPE VARCHAR2(200) NOT NULL,
    APPLICATION_CONTEXT VARCHAR2(400),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    IS_STAKE_HOLDER_SUPPLEMENT VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_STAKE_HOLDER_MEMBER
 AS SELECT ID, STAKE_HOLDER_ID, STAKE_HOLDER, STAKE_HOLDER_DISPLAY_NAME, STAKE_HOLDER_TYPE, APPLICATION_CONTEXT, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_STAKE_HOLDER_SUPPLEMENT FROM E$CM_CASE_STAKE_HOLDER_MEMBER;

ALTER TABLE E$CM_CASE_STAKE_HOLDER_MEMBER
    ADD CONSTRAINT CM_CASE_STAKE_HOLDER_MEMBER_PK PRIMARY KEY (ID);

CREATE INDEX CM_CASE_STAKE_H_KE_HOLDER_ID_I ON E$CM_CASE_STAKE_HOLDER_MEMBER
    (STAKE_HOLDER_ID );

-- ----------------------------------------------------------------------- 
-- E$CM_COMMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_COMMENT
(
    ID VARCHAR2(255) NOT NULL,
    CASE_OBJECT_ID VARCHAR2(255) NOT NULL,
    CASE_OBJECT_TYPE VARCHAR2(255) NOT NULL,
    CASE_OBJECT_COMMENT VARCHAR2(2000) NOT NULL,
    IS_SYSTEM_COMMENT VARCHAR2(1) NOT NULL,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW CM_COMMENT
 AS SELECT ID, CASE_OBJECT_ID, CASE_OBJECT_TYPE, CASE_OBJECT_COMMENT, IS_SYSTEM_COMMENT, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_COMMENT;

ALTER TABLE E$CM_COMMENT
    ADD CONSTRAINT CM_COMMENT_PK PRIMARY KEY (ID);

CREATE INDEX COMMENT_CASE_OBJECT_ID_I ON E$CM_COMMENT
    (CASE_OBJECT_ID );

-- ----------------------------------------------------------------------- 
-- E$CM_RULE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_RULE
(
    RULE_NAMESPACE VARCHAR2(2000) NOT NULL,
    RULE_DICTIONARY BLOB NOT NULL,
    RULE_COMMENTS VARCHAR2(2000),
    RULE_VERSION NUMBER NOT NULL,
    TENANT_ID VARCHAR2(64),
    IS_ACTIVE VARCHAR2(1) NOT NULL,
    CREATED_DATE TIMESTAMP,
    CREATED_BY VARCHAR2(400),
    CREATED_BY_IDCTX VARCHAR2(200),
    LAST_UPDATED_DATE TIMESTAMP,
    LAST_UPDATED_BY VARCHAR2(400),
    LAST_UDPATED_IDCTX VARCHAR2(200),
    PRODUCT_VERSION VARCHAR2(200)
)
;

CREATE OR REPLACE EDITIONING VIEW CM_RULE
 AS SELECT RULE_NAMESPACE, RULE_DICTIONARY, RULE_COMMENTS, RULE_VERSION, TENANT_ID, IS_ACTIVE, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UDPATED_IDCTX, PRODUCT_VERSION FROM E$CM_RULE;

ALTER TABLE E$CM_RULE
    ADD CONSTRAINT CM_RULE_PK PRIMARY KEY (RULE_NAMESPACE, RULE_VERSION);

-- ----------------------------------------------------------------------- 
-- E$CM_RULE_EDIT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_RULE_EDIT
(
    RULE_NAMESPACE VARCHAR2(2000) NOT NULL,
    RULE_DICTIONARY BLOB NOT NULL,
    RULE_COMMENTS VARCHAR2(2000),
    RULE_VERSION NUMBER NOT NULL,
    TENANT_ID VARCHAR2(64),
    LOCKED_BY VARCHAR2(400) NOT NULL
)
;

CREATE OR REPLACE EDITIONING VIEW CM_RULE_EDIT
 AS SELECT RULE_NAMESPACE, RULE_DICTIONARY, RULE_COMMENTS, RULE_VERSION, TENANT_ID, LOCKED_BY FROM E$CM_RULE_EDIT;

ALTER TABLE E$CM_RULE_EDIT
    ADD CONSTRAINT CM_RULE_EDIT_PK PRIMARY KEY (RULE_NAMESPACE, RULE_VERSION, LOCKED_BY);

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_ATTRIBUTE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_ATTRIBUTE
(
    ACTIVITY_DEFINITION_ID VARCHAR2(200) NOT NULL,
    CASE_ID VARCHAR2(255) NOT NULL,
    ACTIVITY_RATING NUMBER(31,2),
    PERMISSION_TAG VARCHAR2(255),
    SYSTEM_STRING_01 VARCHAR2(400),
    SYSTEM_STRING_02 VARCHAR2(400),
    SYSTEM_STRING_03 VARCHAR2(400),
    SYSTEM_NUMBER_01 NUMBER,
    SYSTEM_NUMBER_02 NUMBER,
    SYSTEM_BOOLEAN_01 VARCHAR2(1),
    SYSTEM_BOOLEAN_02 VARCHAR2(1),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    IS_REQUIRED VARCHAR2(1),
    IS_REPEATABLE VARCHAR2(1),
    IS_MANUAL VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_ATTRIBUTE
 AS SELECT ACTIVITY_DEFINITION_ID, CASE_ID, ACTIVITY_RATING, PERMISSION_TAG, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_REQUIRED, IS_REPEATABLE, IS_MANUAL FROM E$CM_ACTIVITY_ATTRIBUTE;

ALTER TABLE E$CM_ACTIVITY_ATTRIBUTE
    ADD CONSTRAINT CM_ACTIVITY_ATTRIBUTE_PK PRIMARY KEY (ACTIVITY_DEFINITION_ID, CASE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_CORRELATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_CORRELATION
(
    CASE_ID VARCHAR2(255) NOT NULL,
    CORRELATION_ID VARCHAR2(255) NOT NULL,
    INSTANCE_ID VARCHAR2(255),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_CORRELATION
 AS SELECT CASE_ID, CORRELATION_ID, INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_ACTIVITY_CORRELATION;

ALTER TABLE E$CM_ACTIVITY_CORRELATION
    ADD CONSTRAINT CM_ACTIVITY_CORRELATION_PK PRIMARY KEY (CORRELATION_ID, CASE_ID);

-- ----------------------------------------------------------------------- 
-- E$CM_SEQUENCE_TABLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_SEQUENCE_TABLE
(
    SEQUENCE_NAME VARCHAR2(400) NOT NULL,
    SEQUENCE_COUNT NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CM_SEQUENCE_TABLE
 AS SELECT SEQUENCE_NAME, SEQUENCE_COUNT FROM E$CM_SEQUENCE_TABLE;

ALTER TABLE E$CM_SEQUENCE_TABLE
    ADD CONSTRAINT CM_SEQUENCE_TABLE_PK PRIMARY KEY (SEQUENCE_NAME);

-- ----------------------------------------------------------------------- 
-- E$CM_CASE_DISPLAY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_CASE_DISPLAY
(
    CM_NAMESPACE VARCHAR2(200),
    COMPOSITE_NAMESPACE VARCHAR2(200),
    COMPOSITE_VERSION VARCHAR2(200),
    CM_URI VARCHAR2(1000),
    APPLICATIONNAME VARCHAR2(200),
    HOST_NAME VARCHAR2(200),
    HTTP_PORT VARCHAR2(20),
    HTTPS_PORT VARCHAR2(20),
    PARTITIONNAME VARCHAR2(200),
    FORM_NAME VARCHAR2(200),
    FORM_TYPE VARCHAR2(200),
    SYSTEM_STRING_01 VARCHAR2(400),
    SYSTEM_STRING_02 VARCHAR2(400),
    SYSTEM_STRING_03 VARCHAR2(400),
    SYSTEM_NUMBER_01 NUMBER,
    SYSTEM_NUMBER_02 NUMBER,
    SYSTEM_NUMBER_03 NUMBER,
    SYSTEM_BOOLEAN_01 VARCHAR2(1),
    SYSTEM_BOOLEAN_02 VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DISPLAY
 AS SELECT CM_NAMESPACE, COMPOSITE_NAMESPACE, COMPOSITE_VERSION, CM_URI, APPLICATIONNAME, HOST_NAME, HTTP_PORT, HTTPS_PORT, PARTITIONNAME, FORM_NAME, FORM_TYPE, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_NUMBER_03, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02 FROM E$CM_CASE_DISPLAY;

-- ----------------------------------------------------------------------- 
-- E$CM_ACTIVITY_STAKEHOLDER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$CM_ACTIVITY_STAKEHOLDER
(
    ACTIVITY_DEFINITION_ID VARCHAR2(200) NOT NULL,
    STAKE_HOLDER VARCHAR2(400) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_STAKEHOLDER
 AS SELECT ACTIVITY_DEFINITION_ID, STAKE_HOLDER FROM E$CM_ACTIVITY_STAKEHOLDER;

ALTER TABLE E$CM_ACTIVITY_STAKEHOLDER
    ADD CONSTRAINT CM_ACTIVITY_STAKEHOLDER_PK PRIMARY KEY (ACTIVITY_DEFINITION_ID, STAKE_HOLDER);

-- ----------------------------------------------------------------------- 
-- E$BPM_ACTIVITY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_ACTIVITY
(
    PROCESS NUMBER NOT NULL,
    ID NUMBER NOT NULL,
    NAME VARCHAR2(256),
    TYPE VARCHAR2(64),
    NODEID VARCHAR2(15),
    NODELEVEL INTEGER,
    NODESEQNUM NUMBER,
    NODEBRANCH VARCHAR2(512),
    PATTERN VARCHAR2(64),
    HASPARALLELBRANCH CHAR(1),
    ISSPLIT CHAR(1),
    ISSWITCHCASE CHAR(1),
    ISSWITCHOTHER CHAR(1),
    ISJOIN CHAR(1),
    ISWSOPERATION CHAR(1),
    ISSWITCH CHAR(1),
    VARIABLE VARCHAR2(200),
    PART VARCHAR2(200),
    CONDITION VARCHAR2(2000),
    EXPRESSION VARCHAR2(2000),
    PARTNER NUMBER,
    PORTTYPE VARCHAR2(400),
    OPERATION VARCHAR2(200),
    ISEXTENSION CHAR(1),
    EXTENSIONTYPE VARCHAR2(100),
    EXTENSIONREF VARCHAR2(2000),
    DOCUMENTATION VARCHAR2(2000),
    SOURCECODE CLOB
);

CREATE OR REPLACE EDITIONING VIEW BPM_ACTIVITY
 AS SELECT PROCESS, ID, NAME, TYPE, NODEID, NODELEVEL, NODESEQNUM, NODEBRANCH, PATTERN, HASPARALLELBRANCH, ISSPLIT, ISSWITCHCASE, ISSWITCHOTHER, ISJOIN, ISWSOPERATION, ISSWITCH, VARIABLE, PART, CONDITION, EXPRESSION, PARTNER, PORTTYPE, OPERATION, ISEXTENSION, EXTENSIONTYPE, EXTENSIONREF, DOCUMENTATION, SOURCECODE FROM E$BPM_ACTIVITY;

ALTER TABLE E$BPM_ACTIVITY
    ADD CONSTRAINT BPM_ACTIVITY_PK PRIMARY KEY (PROCESS, ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_ACTIVITY_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_ACTIVITY_INSTANCE
(
    PROCESSINSTANCE NUMBER NOT NULL,
    ID NUMBER NOT NULL,
    PROCESS NUMBER NOT NULL,
    ACTIVITY NUMBER NOT NULL,
    NODESEQNUM NUMBER NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    MODIFYDATE TIMESTAMP,
    EVALPOINT VARCHAR2(30),
    EVALTIME NUMBER,
    ERRORMESSAGE NCLOB
)
;

CREATE OR REPLACE EDITIONING VIEW BPM_ACTIVITY_INSTANCE
 AS SELECT PROCESSINSTANCE, ID, PROCESS, ACTIVITY, NODESEQNUM, CREATIONDATE, MODIFYDATE, EVALPOINT, EVALTIME, ERRORMESSAGE FROM E$BPM_ACTIVITY_INSTANCE;

ALTER TABLE E$BPM_ACTIVITY_INSTANCE
    ADD CONSTRAINT BPM_ACTIVITY_INSTANCE_PK PRIMARY KEY (PROCESSINSTANCE, ID);

CREATE INDEX BPM_ACTIVITY_INSTANCE_INDX1 ON E$BPM_ACTIVITY_INSTANCE
    (ACTIVITY , PROCESSINSTANCE );

-- ----------------------------------------------------------------------- 
-- E$BPM_ACTIVITY_PROPERTY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_ACTIVITY_PROPERTY
(
    ACTIVITY NUMBER NOT NULL,
    ID NUMBER NOT NULL,
    PROCESS NUMBER NOT NULL,
    NAME VARCHAR2(256),
    QNAME VARCHAR2(400),
    DESCRIPTION VARCHAR2(2000),
    VALUETYPE VARCHAR2(256),
    DEFAULTVALUE VARCHAR2(2000)
)
;

CREATE OR REPLACE EDITIONING VIEW BPM_ACTIVITY_PROPERTY
 AS SELECT ACTIVITY, ID, PROCESS, NAME, QNAME, DESCRIPTION, VALUETYPE, DEFAULTVALUE FROM E$BPM_ACTIVITY_PROPERTY;

ALTER TABLE E$BPM_ACTIVITY_PROPERTY
    ADD CONSTRAINT BPM_ACTIVITY_PROPERTY_PK PRIMARY KEY (ACTIVITY, ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_QUERY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_QUERY
(
    QUERY_ID NUMBER NOT NULL,
    COMPONENT_INSTANCE_ID VARCHAR2(200) NOT NULL,
    COMPONENT_TYPE VARCHAR2(100) NOT NULL,
    STEP NUMBER,
    COMPONENT_NAME VARCHAR2(500),
    COMPOSITE_INSTANCE_ID VARCHAR2(200),
    COMPOSITE_DN VARCHAR2(500),
    COMPOSITE_NAME VARCHAR2(400),
    PROCESS_NAME VARCHAR2(400),
    ACTIVITY_NAME VARCHAR2(400),
    ACTIVITY_ID VARCHAR2(400),
    ACTIVITY_TYPE VARCHAR2(400),
    FLOW_ELEMENT_TYPE VARCHAR2(100),
    SCOPE_ID VARCHAR2(1024),
    SOURCE_ACTIVITY VARCHAR2(400),
    TARGET_ACTIVITY VARCHAR2(400),
    TITLE VARCHAR2(400),
    LABEL VARCHAR2(400),
    REFERENCE_ID VARCHAR2(400),
    INVOKED_COMPONENT_NAME VARCHAR2(400),
    CREATE_TIME TIMESTAMP,
    THREAD_ID NUMBER,
    PARENT_THREAD_ID NUMBER,
    AUDIT_INSTANCE_TYPE VARCHAR2(100),
    DUE_DATE TIMESTAMP,
    PROCESS_DUE_DATE TIMESTAMP,
    FAULT_TYPE VARCHAR2(255),
    FAULT_ISRECOVERABLE VARCHAR2(1),
    OPERATION VARCHAR2(400),
    PARTICIPANT VARCHAR2(4000),
    ROLE_ID VARCHAR2(100),
    AUDIT_LOG RAW(2000),
    PRIORITY NUMBER,
    LOOP_COUNT NUMBER,
    INSTANCE_COUNT NUMBER,
    CI_PARTITION_DATE TIMESTAMP NOT NULL,
    AUDIT_LEVEL NUMBER,
    AUDIT_COMMENT BLOB,
    AUDIT_STRING1 VARCHAR2(2000),
    AUDIT_STRING2 VARCHAR2(400),
    AUDIT_STRING3 VARCHAR2(400),
    AUDIT_STRING4 VARCHAR2(400),
    AUDIT_STRING5 VARCHAR2(400),
    AUDIT_NUMBER1 NUMBER,
    AUDIT_NUMBER2 NUMBER,
    AUDIT_NUMBER3 NUMBER,
    AUDIT_NUMBER4 NUMBER,
    AUDIT_NUMBER5 NUMBER,
    AUDIT_DATE1 TIMESTAMP,
    AUDIT_DATE2 TIMESTAMP,
    AUDIT_DATE3 TIMESTAMP,
    V_VALUESTRING1 VARCHAR2(2000),
    V_VALUESTRING2 VARCHAR2(2000),
    V_VALUESTRING3 VARCHAR2(2000),
    V_VALUESTRING4 VARCHAR2(2000),
    V_VALUESTRING5 VARCHAR2(2000),
    V_VALUESTRING6 VARCHAR2(2000),
    V_VALUESTRING7 VARCHAR2(2000),
    V_VALUESTRING8 VARCHAR2(2000),
    V_VALUESTRING9 VARCHAR2(2000),
    V_VALUESTRING10 VARCHAR2(2000),
    V_VALUESTRING11 VARCHAR2(2000),
    V_VALUESTRING12 VARCHAR2(2000),
    V_VALUESTRING13 VARCHAR2(2000),
    V_VALUESTRING14 VARCHAR2(2000),
    V_VALUESTRING15 VARCHAR2(2000),
    V_VALUESTRING16 VARCHAR2(2000),
    V_VALUESTRING17 VARCHAR2(2000),
    V_VALUESTRING18 VARCHAR2(2000),
    V_VALUESTRING19 VARCHAR2(2000),
    V_VALUESTRING20 VARCHAR2(2000),
    V_VALUEDATE1 TIMESTAMP,
    V_VALUEDATE2 TIMESTAMP,
    V_VALUEDATE3 TIMESTAMP,
    V_VALUEDATE4 TIMESTAMP,
    V_VALUEDATE5 TIMESTAMP,
    V_VALUEDATE6 TIMESTAMP,
    V_VALUEDATE7 TIMESTAMP,
    V_VALUEDATE8 TIMESTAMP,
    V_VALUEDATE9 TIMESTAMP,
    V_VALUEDATE10 TIMESTAMP,
    V_VALUENUMBER1 NUMBER,
    V_VALUENUMBER2 NUMBER,
    V_VALUENUMBER3 NUMBER,
    V_VALUENUMBER4 NUMBER,
    V_VALUENUMBER5 NUMBER,
    V_VALUENUMBER6 NUMBER,
    V_VALUENUMBER7 NUMBER,
    V_VALUENUMBER8 NUMBER,
    V_VALUENUMBER9 NUMBER,
    V_VALUENUMBER10 NUMBER,
    V_VALUENUMBER11 NUMBER,
    V_VALUENUMBER12 NUMBER,
    V_VALUENUMBER13 NUMBER,
    V_VALUENUMBER14 NUMBER,
    V_VALUENUMBER15 NUMBER,
    V_VALUENUMBER16 NUMBER,
    V_VALUENUMBER17 NUMBER,
    V_VALUENUMBER18 NUMBER,
    V_VALUENUMBER19 NUMBER,
    V_VALUENUMBER20 NUMBER,
    V_VALUENUMBER21 NUMBER,
    V_VALUENUMBER22 NUMBER,
    V_VALUENUMBER23 NUMBER,
    V_VALUENUMBER24 NUMBER,
    V_VALUENUMBER25 NUMBER,
    V_VALUENUMBER26 NUMBER,
    V_VALUENUMBER27 NUMBER,
    V_VALUENUMBER28 NUMBER,
    V_VALUENUMBER29 NUMBER,
    V_VALUENUMBER30 NUMBER,
    ECID VARCHAR2(200),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PROCESS_TITLE VARCHAR2(400),
    PROCESS_EXPIRATION_DATE TIMESTAMP,
    CASEID VARCHAR2(400)
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY
 AS SELECT QUERY_ID, COMPONENT_INSTANCE_ID, COMPONENT_TYPE, STEP, COMPONENT_NAME, COMPOSITE_INSTANCE_ID, COMPOSITE_DN, COMPOSITE_NAME, PROCESS_NAME, ACTIVITY_NAME, ACTIVITY_ID, ACTIVITY_TYPE, FLOW_ELEMENT_TYPE, SCOPE_ID, SOURCE_ACTIVITY, TARGET_ACTIVITY, TITLE, LABEL, REFERENCE_ID, INVOKED_COMPONENT_NAME, CREATE_TIME, THREAD_ID, PARENT_THREAD_ID, AUDIT_INSTANCE_TYPE, DUE_DATE, PROCESS_DUE_DATE, FAULT_TYPE, FAULT_ISRECOVERABLE, OPERATION, PARTICIPANT, ROLE_ID, AUDIT_LOG, PRIORITY, LOOP_COUNT, INSTANCE_COUNT, CI_PARTITION_DATE, AUDIT_LEVEL, AUDIT_COMMENT, AUDIT_STRING1, AUDIT_STRING2, AUDIT_STRING3, AUDIT_STRING4, AUDIT_STRING5, AUDIT_NUMBER1, AUDIT_NUMBER2, AUDIT_NUMBER3, AUDIT_NUMBER4, AUDIT_NUMBER5, AUDIT_DATE1, AUDIT_DATE2, AUDIT_DATE3, V_VALUESTRING1, V_VALUESTRING2, V_VALUESTRING3, V_VALUESTRING4, V_VALUESTRING5, V_VALUESTRING6, V_VALUESTRING7, V_VALUESTRING8, V_VALUESTRING9, V_VALUESTRING10, V_VALUESTRING11, V_VALUESTRING12, V_VALUESTRING13, V_VALUESTRING14, V_VALUESTRING15, V_VALUESTRING16, V_VALUESTRING17, V_VALUESTRING18, V_VALUESTRING19, V_VALUESTRING20, V_VALUEDATE1, V_VALUEDATE2, V_VALUEDATE3, V_VALUEDATE4, V_VALUEDATE5, V_VALUEDATE6, V_VALUEDATE7, V_VALUEDATE8, V_VALUEDATE9, V_VALUEDATE10, V_VALUENUMBER1, V_VALUENUMBER2, V_VALUENUMBER3, V_VALUENUMBER4, V_VALUENUMBER5, V_VALUENUMBER6, V_VALUENUMBER7, V_VALUENUMBER8, V_VALUENUMBER9, V_VALUENUMBER10, V_VALUENUMBER11, V_VALUENUMBER12, V_VALUENUMBER13, V_VALUENUMBER14, V_VALUENUMBER15, V_VALUENUMBER16, V_VALUENUMBER17, V_VALUENUMBER18, V_VALUENUMBER19, V_VALUENUMBER20, V_VALUENUMBER21, V_VALUENUMBER22, V_VALUENUMBER23, V_VALUENUMBER24, V_VALUENUMBER25, V_VALUENUMBER26, V_VALUENUMBER27, V_VALUENUMBER28, V_VALUENUMBER29, V_VALUENUMBER30, ECID, TENANT_ID, FLOW_ID, SCA_PARTITION_ID, PROCESS_TITLE, PROCESS_EXPIRATION_DATE, CASEID FROM E$BPM_AUDIT_QUERY;

ALTER TABLE E$BPM_AUDIT_QUERY
    ADD CONSTRAINT BPM_AUDIT_QUERY_PK PRIMARY KEY (QUERY_ID);

CREATE INDEX BPM_AUDIT_QUERY_INDEX1 ON E$BPM_AUDIT_QUERY
    (COMPONENT_INSTANCE_ID , COMPONENT_TYPE , QUERY_ID );

CREATE INDEX BPM_AUDIT_QUERY_INDEX2 ON E$BPM_AUDIT_QUERY
    (COMPOSITE_DN , QUERY_ID );

CREATE INDEX BPM_AUDIT_QUERY_INDEX3 ON E$BPM_AUDIT_QUERY
    (COMPOSITE_INSTANCE_ID , QUERY_ID );

CREATE INDEX BPM_AUDIT_QUERY_INDEX4 ON E$BPM_AUDIT_QUERY
    (CI_PARTITION_DATE , COMPOSITE_INSTANCE_ID , OPERATION , CREATE_TIME );

CREATE INDEX BPM_AUDIT_QUERY_INDEX5 ON E$BPM_AUDIT_QUERY
    (ECID );

CREATE INDEX BPM_AUDIT_QUERY_INDEX6 ON E$BPM_AUDIT_QUERY
    (FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_QUERY_METADATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_QUERY_METADATA
(
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    APPLICATION_NAME VARCHAR2(400),
    COMPOSITE_NAME VARCHAR2(400),
    LABEL VARCHAR2(500),
    REVISION VARCHAR2(50),
    STATUS INTEGER,
    CREATION_DATE TIMESTAMP,
    UNDEPLOY_DATE TIMESTAMP,
    SYSTEM_STRING01 VARCHAR2(400),
    SYSTEM_STRING02 VARCHAR2(400),
    SYSTEM_STRING03 VARCHAR2(400),
    SYSTEM_STRING04 VARCHAR2(400),
    SYSTEM_STRING05 VARCHAR2(400),
    SYSTEM_NUMBER01 NUMBER,
    SYSTEM_NUMBER02 NUMBER,
    SYSTEM_NUMBER03 NUMBER,
    SYSTEM_NUMBER04 NUMBER,
    SYSTEM_NUMBER05 NUMBER,
    SYSTEM_DATE01 TIMESTAMP,
    SYSTEM_DATE02 TIMESTAMP,
    SYSTEM_DATE03 TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_METADATA
 AS SELECT COMPOSITE_DN, APPLICATION_NAME, COMPOSITE_NAME, LABEL, REVISION, STATUS, CREATION_DATE, UNDEPLOY_DATE, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03 FROM E$BPM_AUDIT_QUERY_METADATA;

ALTER TABLE E$BPM_AUDIT_QUERY_METADATA
    ADD CONSTRAINT BPM_AUDIT_QUERY_METADATA_PK PRIMARY KEY (COMPOSITE_DN);

CREATE INDEX BPM_AUDIT_QUERY_MD_I1 ON E$BPM_AUDIT_QUERY_METADATA
    (APPLICATION_NAME , COMPOSITE_NAME , LABEL , REVISION );

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_QUERY_VAR_MD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_QUERY_VAR_MD
(
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    EXTENSION_ID NUMBER NOT NULL,
    V_NAMESTRING1 VARCHAR2(400),
    V_TYPESTRING1 VARCHAR2(50),
    V_NAMESTRING2 VARCHAR2(400),
    V_TYPESTRING2 VARCHAR2(50),
    V_NAMESTRING3 VARCHAR2(400),
    V_TYPESTRING3 VARCHAR2(50),
    V_NAMESTRING4 VARCHAR2(400),
    V_TYPESTRING4 VARCHAR2(50),
    V_NAMESTRING5 VARCHAR2(400),
    V_TYPESTRING5 VARCHAR2(50),
    V_NAMESTRING6 VARCHAR2(400),
    V_TYPESTRING6 VARCHAR2(50),
    V_NAMESTRING7 VARCHAR2(400),
    V_TYPESTRING7 VARCHAR2(50),
    V_NAMESTRING8 VARCHAR2(400),
    V_TYPESTRING8 VARCHAR2(50),
    V_NAMESTRING9 VARCHAR2(400),
    V_TYPESTRING9 VARCHAR2(50),
    V_NAMESTRING10 VARCHAR2(400),
    V_TYPESTRING10 VARCHAR2(50),
    V_NAMESTRING11 VARCHAR2(400),
    V_TYPESTRING11 VARCHAR2(50),
    V_NAMESTRING12 VARCHAR2(400),
    V_TYPESTRING12 VARCHAR2(50),
    V_NAMESTRING13 VARCHAR2(400),
    V_TYPESTRING13 VARCHAR2(50),
    V_NAMESTRING14 VARCHAR2(400),
    V_TYPESTRING14 VARCHAR2(50),
    V_NAMESTRING15 VARCHAR2(400),
    V_TYPESTRING15 VARCHAR2(50),
    V_NAMESTRING16 VARCHAR2(400),
    V_TYPESTRING16 VARCHAR2(50),
    V_NAMESTRING17 VARCHAR2(400),
    V_TYPESTRING17 VARCHAR2(50),
    V_NAMESTRING18 VARCHAR2(400),
    V_TYPESTRING18 VARCHAR2(50),
    V_NAMESTRING19 VARCHAR2(400),
    V_TYPESTRING19 VARCHAR2(50),
    V_NAMESTRING20 VARCHAR2(400),
    V_TYPESTRING20 VARCHAR2(50),
    V_NAMEDATE1 VARCHAR2(400),
    V_TYPEDATE1 VARCHAR2(50),
    V_NAMEDATE2 VARCHAR2(400),
    V_TYPEDATE2 VARCHAR2(50),
    V_NAMEDATE3 VARCHAR2(400),
    V_TYPEDATE3 VARCHAR2(50),
    V_NAMEDATE4 VARCHAR2(400),
    V_TYPEDATE4 VARCHAR2(50),
    V_NAMEDATE5 VARCHAR2(400),
    V_TYPEDATE5 VARCHAR2(50),
    V_NAMEDATE6 VARCHAR2(400),
    V_TYPEDATE6 VARCHAR2(50),
    V_NAMEDATE7 VARCHAR2(400),
    V_TYPEDATE7 VARCHAR2(50),
    V_NAMEDATE8 VARCHAR2(400),
    V_TYPEDATE8 VARCHAR2(50),
    V_NAMEDATE9 VARCHAR2(400),
    V_TYPEDATE9 VARCHAR2(50),
    V_NAMEDATE10 VARCHAR2(400),
    V_TYPEDATE10 VARCHAR2(50),
    V_NAMENUMBER1 VARCHAR2(400),
    V_TYPENUMBER1 VARCHAR2(50),
    V_NAMENUMBER2 VARCHAR2(400),
    V_TYPENUMBER2 VARCHAR2(50),
    V_NAMENUMBER3 VARCHAR2(400),
    V_TYPENUMBER3 VARCHAR2(50),
    V_NAMENUMBER4 VARCHAR2(400),
    V_TYPENUMBER4 VARCHAR2(50),
    V_NAMENUMBER5 VARCHAR2(400),
    V_TYPENUMBER5 VARCHAR2(50),
    V_NAMENUMBER6 VARCHAR2(400),
    V_TYPENUMBER6 VARCHAR2(50),
    V_NAMENUMBER7 VARCHAR2(400),
    V_TYPENUMBER7 VARCHAR2(50),
    V_NAMENUMBER8 VARCHAR2(400),
    V_TYPENUMBER8 VARCHAR2(50),
    V_NAMENUMBER9 VARCHAR2(400),
    V_TYPENUMBER9 VARCHAR2(50),
    V_NAMENUMBER10 VARCHAR2(400),
    V_TYPENUMBER10 VARCHAR2(50),
    V_NAMENUMBER11 VARCHAR2(400),
    V_TYPENUMBER11 VARCHAR2(50),
    V_NAMENUMBER12 VARCHAR2(400),
    V_TYPENUMBER12 VARCHAR2(50),
    V_NAMENUMBER13 VARCHAR2(400),
    V_TYPENUMBER13 VARCHAR2(50),
    V_NAMENUMBER14 VARCHAR2(400),
    V_TYPENUMBER14 VARCHAR2(50),
    V_NAMENUMBER15 VARCHAR2(400),
    V_TYPENUMBER15 VARCHAR2(50),
    V_NAMENUMBER16 VARCHAR2(400),
    V_TYPENUMBER16 VARCHAR2(50),
    V_NAMENUMBER17 VARCHAR2(400),
    V_TYPENUMBER17 VARCHAR2(50),
    V_NAMENUMBER18 VARCHAR2(400),
    V_TYPENUMBER18 VARCHAR2(50),
    V_NAMENUMBER19 VARCHAR2(400),
    V_TYPENUMBER19 VARCHAR2(50),
    V_NAMENUMBER20 VARCHAR2(400),
    V_TYPENUMBER20 VARCHAR2(50),
    V_NAMENUMBER21 VARCHAR2(400),
    V_TYPENUMBER21 VARCHAR2(50),
    V_NAMENUMBER22 VARCHAR2(400),
    V_TYPENUMBER22 VARCHAR2(50),
    V_NAMENUMBER23 VARCHAR2(400),
    V_TYPENUMBER23 VARCHAR2(50),
    V_NAMENUMBER24 VARCHAR2(400),
    V_TYPENUMBER24 VARCHAR2(50),
    V_NAMENUMBER25 VARCHAR2(400),
    V_TYPENUMBER25 VARCHAR2(50),
    V_NAMENUMBER26 VARCHAR2(400),
    V_TYPENUMBER26 VARCHAR2(50),
    V_NAMENUMBER27 VARCHAR2(400),
    V_TYPENUMBER27 VARCHAR2(50),
    V_NAMENUMBER28 VARCHAR2(400),
    V_TYPENUMBER28 VARCHAR2(50),
    V_NAMENUMBER29 VARCHAR2(400),
    V_TYPENUMBER29 VARCHAR2(50),
    V_NAMENUMBER30 VARCHAR2(400),
    V_TYPENUMBER30 VARCHAR2(50),
    SYSTEM_STRING01 VARCHAR2(400),
    SYSTEM_STRING02 VARCHAR2(400),
    SYSTEM_STRING03 VARCHAR2(400),
    SYSTEM_STRING04 VARCHAR2(400),
    SYSTEM_STRING05 VARCHAR2(400),
    SYSTEM_NUMBER01 NUMBER,
    SYSTEM_NUMBER02 NUMBER,
    SYSTEM_NUMBER03 NUMBER,
    SYSTEM_NUMBER04 NUMBER,
    SYSTEM_NUMBER05 NUMBER,
    SYSTEM_DATE01 TIMESTAMP,
    SYSTEM_DATE02 TIMESTAMP,
    SYSTEM_DATE03 TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VAR_MD
 AS SELECT COMPOSITE_DN, EXTENSION_ID, V_NAMESTRING1, V_TYPESTRING1, V_NAMESTRING2, V_TYPESTRING2, V_NAMESTRING3, V_TYPESTRING3, V_NAMESTRING4, V_TYPESTRING4, V_NAMESTRING5, V_TYPESTRING5, V_NAMESTRING6, V_TYPESTRING6, V_NAMESTRING7, V_TYPESTRING7, V_NAMESTRING8, V_TYPESTRING8, V_NAMESTRING9, V_TYPESTRING9, V_NAMESTRING10, V_TYPESTRING10, V_NAMESTRING11, V_TYPESTRING11, V_NAMESTRING12, V_TYPESTRING12, V_NAMESTRING13, V_TYPESTRING13, V_NAMESTRING14, V_TYPESTRING14, V_NAMESTRING15, V_TYPESTRING15, V_NAMESTRING16, V_TYPESTRING16, V_NAMESTRING17, V_TYPESTRING17, V_NAMESTRING18, V_TYPESTRING18, V_NAMESTRING19, V_TYPESTRING19, V_NAMESTRING20, V_TYPESTRING20, V_NAMEDATE1, V_TYPEDATE1, V_NAMEDATE2, V_TYPEDATE2, V_NAMEDATE3, V_TYPEDATE3, V_NAMEDATE4, V_TYPEDATE4, V_NAMEDATE5, V_TYPEDATE5, V_NAMEDATE6, V_TYPEDATE6, V_NAMEDATE7, V_TYPEDATE7, V_NAMEDATE8, V_TYPEDATE8, V_NAMEDATE9, V_TYPEDATE9, V_NAMEDATE10, V_TYPEDATE10, V_NAMENUMBER1, V_TYPENUMBER1, V_NAMENUMBER2, V_TYPENUMBER2, V_NAMENUMBER3, V_TYPENUMBER3, V_NAMENUMBER4, V_TYPENUMBER4, V_NAMENUMBER5, V_TYPENUMBER5, V_NAMENUMBER6, V_TYPENUMBER6, V_NAMENUMBER7, V_TYPENUMBER7, V_NAMENUMBER8, V_TYPENUMBER8, V_NAMENUMBER9, V_TYPENUMBER9, V_NAMENUMBER10, V_TYPENUMBER10, V_NAMENUMBER11, V_TYPENUMBER11, V_NAMENUMBER12, V_TYPENUMBER12, V_NAMENUMBER13, V_TYPENUMBER13, V_NAMENUMBER14, V_TYPENUMBER14, V_NAMENUMBER15, V_TYPENUMBER15, V_NAMENUMBER16, V_TYPENUMBER16, V_NAMENUMBER17, V_TYPENUMBER17, V_NAMENUMBER18, V_TYPENUMBER18, V_NAMENUMBER19, V_TYPENUMBER19, V_NAMENUMBER20, V_TYPENUMBER20, V_NAMENUMBER21, V_TYPENUMBER21, V_NAMENUMBER22, V_TYPENUMBER22, V_NAMENUMBER23, V_TYPENUMBER23, V_NAMENUMBER24, V_TYPENUMBER24, V_NAMENUMBER25, V_TYPENUMBER25, V_NAMENUMBER26, V_TYPENUMBER26, V_NAMENUMBER27, V_TYPENUMBER27, V_NAMENUMBER28, V_TYPENUMBER28, V_NAMENUMBER29, V_TYPENUMBER29, V_NAMENUMBER30, V_TYPENUMBER30, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03 FROM E$BPM_AUDIT_QUERY_VAR_MD;

ALTER TABLE E$BPM_AUDIT_QUERY_VAR_MD
    ADD CONSTRAINT BPM_AUDIT_QUERY_VAR_MD_PK PRIMARY KEY (COMPOSITE_DN, EXTENSION_ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_QUERY_VAR_RANGES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_QUERY_VAR_RANGES
(
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    EXTENSION_ID NUMBER NOT NULL,
    VAR_LABEL VARCHAR2(500) NOT NULL,
    RANGE_NAME VARCHAR2(500) NOT NULL,
    RANGE_OPERATOR VARCHAR2(100),
    NUMBER_RANGE_START NUMBER,
    NUMBER_RANGE_END NUMBER,
    DATE_RANGE_START TIMESTAMP,
    DATE_RANGE_END TIMESTAMP,
    DATE_MASK_START VARCHAR2(200),
    DATE_MASK_END VARCHAR2(200),
    SYSTEM_STRING01 VARCHAR2(400),
    SYSTEM_STRING02 VARCHAR2(400),
    SYSTEM_STRING03 VARCHAR2(400),
    SYSTEM_STRING04 VARCHAR2(400),
    SYSTEM_STRING05 VARCHAR2(400),
    SYSTEM_NUMBER01 NUMBER,
    SYSTEM_NUMBER02 NUMBER,
    SYSTEM_NUMBER03 NUMBER,
    SYSTEM_NUMBER04 NUMBER,
    SYSTEM_NUMBER05 NUMBER,
    SYSTEM_DATE01 TIMESTAMP,
    SYSTEM_DATE02 TIMESTAMP,
    SYSTEM_DATE03 TIMESTAMP,
    ECID VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VAR_RANGES
 AS SELECT COMPOSITE_DN, EXTENSION_ID, VAR_LABEL, RANGE_NAME, RANGE_OPERATOR, NUMBER_RANGE_START, NUMBER_RANGE_END, DATE_RANGE_START, DATE_RANGE_END, DATE_MASK_START, DATE_MASK_END, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03, ECID FROM E$BPM_AUDIT_QUERY_VAR_RANGES;

ALTER TABLE E$BPM_AUDIT_QUERY_VAR_RANGES
    ADD CONSTRAINT BPM_AUDIT_QUERY_VAR_RANGES_PK PRIMARY KEY (COMPOSITE_DN, EXTENSION_ID, VAR_LABEL, RANGE_NAME);

CREATE INDEX BPM_AUDIT_VAR_RANGES_IDX1 ON E$BPM_AUDIT_QUERY_VAR_RANGES
    (ECID );

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_QUERY_VARMD_EXT1 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_QUERY_VARMD_EXT1
(
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    V_NAMESTRING1 VARCHAR2(400),
    V_TYPESTRING1 VARCHAR2(1),
    V_NAMESTRING2 VARCHAR2(400),
    V_TYPESTRING2 VARCHAR2(1),
    V_NAMESTRING3 VARCHAR2(400),
    V_TYPESTRING3 VARCHAR2(1),
    V_NAMESTRING4 VARCHAR2(400),
    V_TYPESTRING4 VARCHAR2(1),
    V_NAMESTRING5 VARCHAR2(400),
    V_TYPESTRING5 VARCHAR2(1),
    V_NAMESTRING6 VARCHAR2(400),
    V_TYPESTRING6 VARCHAR2(1),
    V_NAMESTRING7 VARCHAR2(400),
    V_TYPESTRING7 VARCHAR2(1),
    V_NAMESTRING8 VARCHAR2(400),
    V_TYPESTRING8 VARCHAR2(1),
    V_NAMESTRING9 VARCHAR2(400),
    V_TYPESTRING9 VARCHAR2(1),
    V_NAMESTRING10 VARCHAR2(400),
    V_TYPESTRING10 VARCHAR2(1),
    V_NAMESTRING11 VARCHAR2(400),
    V_TYPESTRING11 VARCHAR2(1),
    V_NAMESTRING12 VARCHAR2(400),
    V_TYPESTRING12 VARCHAR2(1),
    V_NAMESTRING13 VARCHAR2(400),
    V_TYPESTRING13 VARCHAR2(1),
    V_NAMESTRING14 VARCHAR2(400),
    V_TYPESTRING14 VARCHAR2(1),
    V_NAMESTRING15 VARCHAR2(400),
    V_TYPESTRING15 VARCHAR2(1),
    V_NAMESTRING16 VARCHAR2(400),
    V_TYPESTRING16 VARCHAR2(1),
    V_NAMESTRING17 VARCHAR2(400),
    V_TYPESTRING17 VARCHAR2(1),
    V_NAMESTRING18 VARCHAR2(400),
    V_TYPESTRING18 VARCHAR2(1),
    V_NAMESTRING19 VARCHAR2(400),
    V_TYPESTRING19 VARCHAR2(1),
    V_NAMESTRING20 VARCHAR2(400),
    V_TYPESTRING20 VARCHAR2(1),
    V_NAMEDATE1 VARCHAR2(400),
    V_TYPEDATE1 VARCHAR2(1),
    V_NAMEDATE2 VARCHAR2(400),
    V_TYPEDATE2 VARCHAR2(1),
    V_NAMEDATE3 VARCHAR2(400),
    V_TYPEDATE3 VARCHAR2(1),
    V_NAMEDATE4 VARCHAR2(400),
    V_TYPEDATE4 VARCHAR2(1),
    V_NAMEDATE5 VARCHAR2(400),
    V_TYPEDATE5 VARCHAR2(1),
    V_NAMEDATE6 VARCHAR2(400),
    V_TYPEDATE6 VARCHAR2(1),
    V_NAMEDATE7 VARCHAR2(400),
    V_TYPEDATE7 VARCHAR2(1),
    V_NAMEDATE8 VARCHAR2(400),
    V_TYPEDATE8 VARCHAR2(1),
    V_NAMEDATE9 VARCHAR2(400),
    V_TYPEDATE9 VARCHAR2(1),
    V_NAMEDATE10 VARCHAR2(400),
    V_TYPEDATE10 VARCHAR2(1),
    V_NAMENUMBER1 VARCHAR2(400),
    V_TYPENUMBER1 VARCHAR2(1),
    V_NAMENUMBER2 VARCHAR2(400),
    V_TYPENUMBER2 VARCHAR2(1),
    V_NAMENUMBER3 VARCHAR2(400),
    V_TYPENUMBER3 VARCHAR2(1),
    V_NAMENUMBER4 VARCHAR2(400),
    V_TYPENUMBER4 VARCHAR2(1),
    V_NAMENUMBER5 VARCHAR2(400),
    V_TYPENUMBER5 VARCHAR2(1),
    V_NAMENUMBER6 VARCHAR2(400),
    V_TYPENUMBER6 VARCHAR2(1),
    V_NAMENUMBER7 VARCHAR2(400),
    V_TYPENUMBER7 VARCHAR2(1),
    V_NAMENUMBER8 VARCHAR2(400),
    V_TYPENUMBER8 VARCHAR2(1),
    V_NAMENUMBER9 VARCHAR2(400),
    V_TYPENUMBER9 VARCHAR2(1),
    V_NAMENUMBER10 VARCHAR2(400),
    V_TYPENUMBER10 VARCHAR2(1),
    V_NAMENUMBER11 VARCHAR2(400),
    V_TYPENUMBER11 VARCHAR2(1),
    V_NAMENUMBER12 VARCHAR2(400),
    V_TYPENUMBER12 VARCHAR2(1),
    V_NAMENUMBER13 VARCHAR2(400),
    V_TYPENUMBER13 VARCHAR2(1),
    V_NAMENUMBER14 VARCHAR2(400),
    V_TYPENUMBER14 VARCHAR2(1),
    V_NAMENUMBER15 VARCHAR2(400),
    V_TYPENUMBER15 VARCHAR2(1),
    V_NAMENUMBER16 VARCHAR2(400),
    V_TYPENUMBER16 VARCHAR2(1),
    V_NAMENUMBER17 VARCHAR2(400),
    V_TYPENUMBER17 VARCHAR2(1),
    V_NAMENUMBER18 VARCHAR2(400),
    V_TYPENUMBER18 VARCHAR2(1),
    V_NAMENUMBER19 VARCHAR2(400),
    V_TYPENUMBER19 VARCHAR2(1),
    V_NAMENUMBER20 VARCHAR2(400),
    V_TYPENUMBER20 VARCHAR2(1),
    V_NAMENUMBER21 VARCHAR2(400),
    V_TYPENUMBER21 VARCHAR2(1),
    V_NAMENUMBER22 VARCHAR2(400),
    V_TYPENUMBER22 VARCHAR2(1),
    V_NAMENUMBER23 VARCHAR2(400),
    V_TYPENUMBER23 VARCHAR2(1),
    V_NAMENUMBER24 VARCHAR2(400),
    V_TYPENUMBER24 VARCHAR2(1),
    V_NAMENUMBER25 VARCHAR2(400),
    V_TYPENUMBER25 VARCHAR2(1),
    V_NAMENUMBER26 VARCHAR2(400),
    V_TYPENUMBER26 VARCHAR2(1),
    V_NAMENUMBER27 VARCHAR2(400),
    V_TYPENUMBER27 VARCHAR2(1),
    V_NAMENUMBER28 VARCHAR2(400),
    V_TYPENUMBER28 VARCHAR2(1),
    V_NAMENUMBER29 VARCHAR2(400),
    V_TYPENUMBER29 VARCHAR2(1),
    V_NAMENUMBER30 VARCHAR2(400),
    V_TYPENUMBER30 VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VARMD_EXT1
 AS SELECT COMPOSITE_DN, V_NAMESTRING1, V_TYPESTRING1, V_NAMESTRING2, V_TYPESTRING2, V_NAMESTRING3, V_TYPESTRING3, V_NAMESTRING4, V_TYPESTRING4, V_NAMESTRING5, V_TYPESTRING5, V_NAMESTRING6, V_TYPESTRING6, V_NAMESTRING7, V_TYPESTRING7, V_NAMESTRING8, V_TYPESTRING8, V_NAMESTRING9, V_TYPESTRING9, V_NAMESTRING10, V_TYPESTRING10, V_NAMESTRING11, V_TYPESTRING11, V_NAMESTRING12, V_TYPESTRING12, V_NAMESTRING13, V_TYPESTRING13, V_NAMESTRING14, V_TYPESTRING14, V_NAMESTRING15, V_TYPESTRING15, V_NAMESTRING16, V_TYPESTRING16, V_NAMESTRING17, V_TYPESTRING17, V_NAMESTRING18, V_TYPESTRING18, V_NAMESTRING19, V_TYPESTRING19, V_NAMESTRING20, V_TYPESTRING20, V_NAMEDATE1, V_TYPEDATE1, V_NAMEDATE2, V_TYPEDATE2, V_NAMEDATE3, V_TYPEDATE3, V_NAMEDATE4, V_TYPEDATE4, V_NAMEDATE5, V_TYPEDATE5, V_NAMEDATE6, V_TYPEDATE6, V_NAMEDATE7, V_TYPEDATE7, V_NAMEDATE8, V_TYPEDATE8, V_NAMEDATE9, V_TYPEDATE9, V_NAMEDATE10, V_TYPEDATE10, V_NAMENUMBER1, V_TYPENUMBER1, V_NAMENUMBER2, V_TYPENUMBER2, V_NAMENUMBER3, V_TYPENUMBER3, V_NAMENUMBER4, V_TYPENUMBER4, V_NAMENUMBER5, V_TYPENUMBER5, V_NAMENUMBER6, V_TYPENUMBER6, V_NAMENUMBER7, V_TYPENUMBER7, V_NAMENUMBER8, V_TYPENUMBER8, V_NAMENUMBER9, V_TYPENUMBER9, V_NAMENUMBER10, V_TYPENUMBER10, V_NAMENUMBER11, V_TYPENUMBER11, V_NAMENUMBER12, V_TYPENUMBER12, V_NAMENUMBER13, V_TYPENUMBER13, V_NAMENUMBER14, V_TYPENUMBER14, V_NAMENUMBER15, V_TYPENUMBER15, V_NAMENUMBER16, V_TYPENUMBER16, V_NAMENUMBER17, V_TYPENUMBER17, V_NAMENUMBER18, V_TYPENUMBER18, V_NAMENUMBER19, V_TYPENUMBER19, V_NAMENUMBER20, V_TYPENUMBER20, V_NAMENUMBER21, V_TYPENUMBER21, V_NAMENUMBER22, V_TYPENUMBER22, V_NAMENUMBER23, V_TYPENUMBER23, V_NAMENUMBER24, V_TYPENUMBER24, V_NAMENUMBER25, V_TYPENUMBER25, V_NAMENUMBER26, V_TYPENUMBER26, V_NAMENUMBER27, V_TYPENUMBER27, V_NAMENUMBER28, V_TYPENUMBER28, V_NAMENUMBER29, V_TYPENUMBER29, V_NAMENUMBER30, V_TYPENUMBER30 FROM E$BPM_AUDIT_QUERY_VARMD_EXT1;

ALTER TABLE E$BPM_AUDIT_QUERY_VARMD_EXT1
    ADD CONSTRAINT BPM_AUDIT_QUERY_VARMD_EXT1_PK PRIMARY KEY (COMPOSITE_DN);

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_QUERY_VARVALS_EXT1 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_QUERY_VARVALS_EXT1
(
    QUERY_ID NUMBER NOT NULL,
    EXTENSION_ID NUMBER NOT NULL,
    V_VALUESTRING1 VARCHAR2(2000),
    V_VALUESTRING2 VARCHAR2(2000),
    V_VALUESTRING3 VARCHAR2(2000),
    V_VALUESTRING4 VARCHAR2(2000),
    V_VALUESTRING5 VARCHAR2(2000),
    V_VALUESTRING6 VARCHAR2(2000),
    V_VALUESTRING7 VARCHAR2(2000),
    V_VALUESTRING8 VARCHAR2(2000),
    V_VALUESTRING9 VARCHAR2(2000),
    V_VALUESTRING10 VARCHAR2(2000),
    V_VALUESTRING11 VARCHAR2(2000),
    V_VALUESTRING12 VARCHAR2(2000),
    V_VALUESTRING13 VARCHAR2(2000),
    V_VALUESTRING14 VARCHAR2(2000),
    V_VALUESTRING15 VARCHAR2(2000),
    V_VALUESTRING16 VARCHAR2(2000),
    V_VALUESTRING17 VARCHAR2(2000),
    V_VALUESTRING18 VARCHAR2(2000),
    V_VALUESTRING19 VARCHAR2(2000),
    V_VALUESTRING20 VARCHAR2(2000),
    V_VALUEDATE1 TIMESTAMP,
    V_VALUEDATE2 TIMESTAMP,
    V_VALUEDATE3 TIMESTAMP,
    V_VALUEDATE4 TIMESTAMP,
    V_VALUEDATE5 TIMESTAMP,
    V_VALUEDATE6 TIMESTAMP,
    V_VALUEDATE7 TIMESTAMP,
    V_VALUEDATE8 TIMESTAMP,
    V_VALUEDATE9 TIMESTAMP,
    V_VALUEDATE10 TIMESTAMP,
    V_VALUENUMBER1 NUMBER,
    V_VALUENUMBER2 NUMBER,
    V_VALUENUMBER3 NUMBER,
    V_VALUENUMBER4 NUMBER,
    V_VALUENUMBER5 NUMBER,
    V_VALUENUMBER6 NUMBER,
    V_VALUENUMBER7 NUMBER,
    V_VALUENUMBER8 NUMBER,
    V_VALUENUMBER9 NUMBER,
    V_VALUENUMBER10 NUMBER,
    V_VALUENUMBER11 NUMBER,
    V_VALUENUMBER12 NUMBER,
    V_VALUENUMBER13 NUMBER,
    V_VALUENUMBER14 NUMBER,
    V_VALUENUMBER15 NUMBER,
    V_VALUENUMBER16 NUMBER,
    V_VALUENUMBER17 NUMBER,
    V_VALUENUMBER18 NUMBER,
    V_VALUENUMBER19 NUMBER,
    V_VALUENUMBER20 NUMBER,
    V_VALUENUMBER21 NUMBER,
    V_VALUENUMBER22 NUMBER,
    V_VALUENUMBER23 NUMBER,
    V_VALUENUMBER24 NUMBER,
    V_VALUENUMBER25 NUMBER,
    V_VALUENUMBER26 NUMBER,
    V_VALUENUMBER27 NUMBER,
    V_VALUENUMBER28 NUMBER,
    V_VALUENUMBER29 NUMBER,
    V_VALUENUMBER30 NUMBER,
    SYSTEM_STRING01 VARCHAR2(400),
    SYSTEM_STRING02 VARCHAR2(400),
    SYSTEM_STRING03 VARCHAR2(400),
    SYSTEM_STRING04 VARCHAR2(400),
    SYSTEM_STRING05 VARCHAR2(400),
    SYSTEM_NUMBER01 NUMBER,
    SYSTEM_NUMBER02 NUMBER,
    SYSTEM_NUMBER03 NUMBER,
    SYSTEM_NUMBER04 NUMBER,
    SYSTEM_NUMBER05 NUMBER,
    SYSTEM_DATE01 TIMESTAMP,
    SYSTEM_DATE02 TIMESTAMP,
    SYSTEM_DATE03 TIMESTAMP,
    ECID VARCHAR2(200),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
);

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VARVALS_EXT1
 AS SELECT QUERY_ID, EXTENSION_ID, V_VALUESTRING1, V_VALUESTRING2, V_VALUESTRING3, V_VALUESTRING4, V_VALUESTRING5, V_VALUESTRING6, V_VALUESTRING7, V_VALUESTRING8, V_VALUESTRING9, V_VALUESTRING10, V_VALUESTRING11, V_VALUESTRING12, V_VALUESTRING13, V_VALUESTRING14, V_VALUESTRING15, V_VALUESTRING16, V_VALUESTRING17, V_VALUESTRING18, V_VALUESTRING19, V_VALUESTRING20, V_VALUEDATE1, V_VALUEDATE2, V_VALUEDATE3, V_VALUEDATE4, V_VALUEDATE5, V_VALUEDATE6, V_VALUEDATE7, V_VALUEDATE8, V_VALUEDATE9, V_VALUEDATE10, V_VALUENUMBER1, V_VALUENUMBER2, V_VALUENUMBER3, V_VALUENUMBER4, V_VALUENUMBER5, V_VALUENUMBER6, V_VALUENUMBER7, V_VALUENUMBER8, V_VALUENUMBER9, V_VALUENUMBER10, V_VALUENUMBER11, V_VALUENUMBER12, V_VALUENUMBER13, V_VALUENUMBER14, V_VALUENUMBER15, V_VALUENUMBER16, V_VALUENUMBER17, V_VALUENUMBER18, V_VALUENUMBER19, V_VALUENUMBER20, V_VALUENUMBER21, V_VALUENUMBER22, V_VALUENUMBER23, V_VALUENUMBER24, V_VALUENUMBER25, V_VALUENUMBER26, V_VALUENUMBER27, V_VALUENUMBER28, V_VALUENUMBER29, V_VALUENUMBER30, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03, ECID, TENANT_ID, FLOW_ID, SCA_PARTITION_ID FROM E$BPM_AUDIT_QUERY_VARVALS_EXT1;

ALTER TABLE E$BPM_AUDIT_QUERY_VARVALS_EXT1
    ADD CONSTRAINT BPM_AUDIT_QUERY_ARVALS_EXT1_PK PRIMARY KEY (QUERY_ID, EXTENSION_ID);

CREATE INDEX BPM_AUDIT_VARVALS_IDX1 ON E$BPM_AUDIT_QUERY_VARVALS_EXT1
    (ECID );

-- ----------------------------------------------------------------------- 
-- E$BPM_AUDIT_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_AUDIT_SEQUENCE
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_AUDIT_SEQUENCE;

ALTER TABLE E$BPM_AUDIT_SEQUENCE
    ADD CONSTRAINT BPM_AUDIT_SEQUENCE_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_CASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CASE
(
    CASEID VARCHAR2(400) NOT NULL,
    CASEMETADATAID VARCHAR2(400),
    CASEIDENTIFICATIONKEY VARCHAR2(400),
    CASEACTIVITYID VARCHAR2(400),
    CASEACTIVITYNAME VARCHAR2(400),
    CASEACTIVITYTYPE VARCHAR2(400),
    SYSTEMSTATUS VARCHAR2(200),
    CASESTATE VARCHAR2(200),
    INDEXEDSTRINGATTRIBUTE1 VARCHAR2(2000),
    INDEXEDSTRINGATTRIBUTE2 VARCHAR2(2000),
    INDEXEDSTRINGATTRIBUTE3 VARCHAR2(2000),
    INDEXEDSTRINGATTRIBUTE4 VARCHAR2(2000),
    INDEXEDSTRINGATTRIBUTE5 VARCHAR2(2000),
    STRINGATTRIBUTE1 VARCHAR2(2000),
    STRINGATTRIBUTE2 VARCHAR2(2000),
    STRINGATTRIBUTE3 VARCHAR2(2000),
    STRINGATTRIBUTE4 VARCHAR2(2000),
    STRINGATTRIBUTE5 VARCHAR2(2000),
    STRINGATTRIBUTE6 VARCHAR2(2000),
    STRINGATTRIBUTE7 VARCHAR2(2000),
    STRINGATTRIBUTE8 VARCHAR2(2000),
    STRINGATTRIBUTE9 VARCHAR2(2000),
    STRINGATTRIBUTE10 VARCHAR2(2000),
    STRINGATTRIBUTE11 VARCHAR2(2000),
    STRINGATTRIBUTE12 VARCHAR2(2000),
    STRINGATTRIBUTE13 VARCHAR2(2000),
    STRINGATTRIBUTE14 VARCHAR2(2000),
    STRINGATTRIBUTE15 VARCHAR2(2000),
    STRINGATTRIBUTE16 VARCHAR2(2000),
    STRINGATTRIBUTE17 VARCHAR2(2000),
    STRINGATTRIBUTE18 VARCHAR2(2000),
    STRINGATTRIBUTE19 VARCHAR2(2000),
    STRINGATTRIBUTE20 VARCHAR2(2000),
    NUMBERATTRIBUTE1 NUMBER,
    NUMBERATTRIBUTE2 NUMBER,
    NUMBERATTRIBUTE3 NUMBER,
    NUMBERATTRIBUTE4 NUMBER,
    NUMBERATTRIBUTE5 NUMBER,
    NUMBERATTRIBUTE6 NUMBER,
    NUMBERATTRIBUTE7 NUMBER,
    NUMBERATTRIBUTE8 NUMBER,
    NUMBERATTRIBUTE9 NUMBER,
    NUMBERATTRIBUTE10 NUMBER,
    NUMBERATTRIBUTE11 NUMBER,
    NUMBERATTRIBUTE12 NUMBER,
    NUMBERATTRIBUTE13 NUMBER,
    NUMBERATTRIBUTE14 NUMBER,
    NUMBERATTRIBUTE15 NUMBER,
    NUMBERATTRIBUTE16 NUMBER,
    NUMBERATTRIBUTE17 NUMBER,
    NUMBERATTRIBUTE18 NUMBER,
    NUMBERATTRIBUTE19 NUMBER,
    NUMBERATTRIBUTE20 NUMBER,
    DATEATTRIBUTE1 TIMESTAMP,
    DATEATTRIBUTE2 TIMESTAMP,
    DATEATTRIBUTE3 TIMESTAMP,
    DATEATTRIBUTE4 TIMESTAMP,
    DATEATTRIBUTE5 TIMESTAMP,
    DATEATTRIBUTE6 TIMESTAMP,
    DATEATTRIBUTE7 TIMESTAMP,
    DATEATTRIBUTE8 TIMESTAMP,
    DATEATTRIBUTE9 TIMESTAMP,
    DATEATTRIBUTE10 TIMESTAMP,
    DATEATTRIBUTE11 TIMESTAMP,
    DATEATTRIBUTE12 TIMESTAMP,
    DATEATTRIBUTE13 TIMESTAMP,
    DATEATTRIBUTE14 TIMESTAMP,
    DATEATTRIBUTE15 TIMESTAMP,
    DATEATTRIBUTE16 TIMESTAMP,
    DATEATTRIBUTE17 TIMESTAMP,
    DATEATTRIBUTE18 TIMESTAMP,
    DATEATTRIBUTE19 TIMESTAMP,
    DATEATTRIBUTE20 TIMESTAMP,
    CREATEDDATE TIMESTAMP,
    UPDATEDDATE TIMESTAMP,
    VERSION VARCHAR2(50),
    SYSTEMATTRIBUTE1 VARCHAR2(400),
    SYSTEMATTRIBUTE2 VARCHAR2(400),
    SYSTEMATTRIBUTE3 VARCHAR2(400),
    SYSTEMATTRIBUTE4 VARCHAR2(400),
    SYSTEMATTRIBUTE5 VARCHAR2(400),
    SYSTEMATTRIBUTE6 VARCHAR2(400),
    SYSTEMATTRIBUTE7 VARCHAR2(400),
    SYSTEMATTRIBUTE8 VARCHAR2(400),
    SYSTEMATTRIBUTE9 VARCHAR2(400),
    SYSTEMATTRIBUTE10 VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CASE
 AS SELECT CASEID, CASEMETADATAID, CASEIDENTIFICATIONKEY, CASEACTIVITYID, CASEACTIVITYNAME, CASEACTIVITYTYPE, SYSTEMSTATUS, CASESTATE, INDEXEDSTRINGATTRIBUTE1, INDEXEDSTRINGATTRIBUTE2, INDEXEDSTRINGATTRIBUTE3, INDEXEDSTRINGATTRIBUTE4, INDEXEDSTRINGATTRIBUTE5, STRINGATTRIBUTE1, STRINGATTRIBUTE2, STRINGATTRIBUTE3, STRINGATTRIBUTE4, STRINGATTRIBUTE5, STRINGATTRIBUTE6, STRINGATTRIBUTE7, STRINGATTRIBUTE8, STRINGATTRIBUTE9, STRINGATTRIBUTE10, STRINGATTRIBUTE11, STRINGATTRIBUTE12, STRINGATTRIBUTE13, STRINGATTRIBUTE14, STRINGATTRIBUTE15, STRINGATTRIBUTE16, STRINGATTRIBUTE17, STRINGATTRIBUTE18, STRINGATTRIBUTE19, STRINGATTRIBUTE20, NUMBERATTRIBUTE1, NUMBERATTRIBUTE2, NUMBERATTRIBUTE3, NUMBERATTRIBUTE4, NUMBERATTRIBUTE5, NUMBERATTRIBUTE6, NUMBERATTRIBUTE7, NUMBERATTRIBUTE8, NUMBERATTRIBUTE9, NUMBERATTRIBUTE10, NUMBERATTRIBUTE11, NUMBERATTRIBUTE12, NUMBERATTRIBUTE13, NUMBERATTRIBUTE14, NUMBERATTRIBUTE15, NUMBERATTRIBUTE16, NUMBERATTRIBUTE17, NUMBERATTRIBUTE18, NUMBERATTRIBUTE19, NUMBERATTRIBUTE20, DATEATTRIBUTE1, DATEATTRIBUTE2, DATEATTRIBUTE3, DATEATTRIBUTE4, DATEATTRIBUTE5, DATEATTRIBUTE6, DATEATTRIBUTE7, DATEATTRIBUTE8, DATEATTRIBUTE9, DATEATTRIBUTE10, DATEATTRIBUTE11, DATEATTRIBUTE12, DATEATTRIBUTE13, DATEATTRIBUTE14, DATEATTRIBUTE15, DATEATTRIBUTE16, DATEATTRIBUTE17, DATEATTRIBUTE18, DATEATTRIBUTE19, DATEATTRIBUTE20, CREATEDDATE, UPDATEDDATE, VERSION, SYSTEMATTRIBUTE1, SYSTEMATTRIBUTE2, SYSTEMATTRIBUTE3, SYSTEMATTRIBUTE4, SYSTEMATTRIBUTE5, SYSTEMATTRIBUTE6, SYSTEMATTRIBUTE7, SYSTEMATTRIBUTE8, SYSTEMATTRIBUTE9, SYSTEMATTRIBUTE10 FROM E$BPM_CASE;

ALTER TABLE E$BPM_CASE
    ADD CONSTRAINT BPM_CASE_PK PRIMARY KEY (CASEID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CASE_ACTIVITIES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CASE_ACTIVITIES
(
    GUID VARCHAR2(64) NOT NULL,
    CASEID VARCHAR2(400) NOT NULL,
    CASEACTIVITYID VARCHAR2(400) NOT NULL,
    CASEACTIVITYTYPE VARCHAR2(400) NOT NULL,
    CASEACTIVITYNAME VARCHAR2(400),
    CASEACTIVITYSTATUS VARCHAR2(400),
    CASESUBACTIVITYID VARCHAR2(400),
    CASESUBACTIVITYTYPE VARCHAR2(400),
    CASESUBACTIVITYNAME VARCHAR2(400),
    CASESUBACTIVITYSTATUS VARCHAR2(400),
    SYSTEMATTRIBUTE1 VARCHAR2(400),
    SYSTEMATTRIBUTE2 VARCHAR2(400),
    SYSTEMATTRIBUTE3 VARCHAR2(400),
    SYSTEMATTRIBUTE4 VARCHAR2(400),
    SYSTEMATTRIBUTE5 VARCHAR2(400),
    VERSION VARCHAR2(50)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CASE_ACTIVITIES
 AS SELECT GUID, CASEID, CASEACTIVITYID, CASEACTIVITYTYPE, CASEACTIVITYNAME, CASEACTIVITYSTATUS, CASESUBACTIVITYID, CASESUBACTIVITYTYPE, CASESUBACTIVITYNAME, CASESUBACTIVITYSTATUS, SYSTEMATTRIBUTE1, SYSTEMATTRIBUTE2, SYSTEMATTRIBUTE3, SYSTEMATTRIBUTE4, SYSTEMATTRIBUTE5, VERSION FROM E$BPM_CASE_ACTIVITIES;

ALTER TABLE E$BPM_CASE_ACTIVITIES
    ADD CONSTRAINT BPM_CASE_ACTIVITIES_PK PRIMARY KEY (GUID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CASE_ATTRIBUTES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CASE_ATTRIBUTES
(
    GUID VARCHAR2(64) NOT NULL,
    CASETYPE VARCHAR2(400),
    ATTRIBUTENAME VARCHAR2(400) NOT NULL,
    COLUMNNAME VARCHAR2(400) NOT NULL,
    VERSION VARCHAR2(50)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CASE_ATTRIBUTES
 AS SELECT GUID, CASETYPE, ATTRIBUTENAME, COLUMNNAME, VERSION FROM E$BPM_CASE_ATTRIBUTES;

ALTER TABLE E$BPM_CASE_ATTRIBUTES
    ADD CONSTRAINT BPM_CASE_ATTRIBUTES_PK PRIMARY KEY (GUID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CASE_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CASE_DATA
(
    CASEID VARCHAR2(400) NOT NULL,
    NAME VARCHAR2(400) NOT NULL,
    DATA CLOB,
    VERSION VARCHAR2(50)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CASE_DATA
 AS SELECT CASEID, NAME, DATA, VERSION FROM E$BPM_CASE_DATA;

ALTER TABLE E$BPM_CASE_DATA
    ADD CONSTRAINT BPM_CASE_DATA_PK PRIMARY KEY (CASEID, NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ACTIVITY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ACTIVITY
(
    ACTIVITYID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    ACTIVITYNAME VARCHAR2(256),
    ACTIVITYTYPE VARCHAR2(64),
    LABEL VARCHAR2(500),
    NODEID VARCHAR2(200),
    NODELEVEL INTEGER,
    NODESEQNUM NUMBER,
    NODEBRANCH VARCHAR2(512),
    PATTERN VARCHAR2(64),
    HASPARALLELBRANCH CHAR(1),
    ISSPLIT CHAR(1),
    ISSWITCHCASE CHAR(1),
    ISSWITCHOTHER CHAR(1),
    ISJOIN CHAR(1),
    ISWSOPERATION CHAR(1),
    ISSWITCH CHAR(1),
    VARIABLE VARCHAR2(200),
    PART VARCHAR2(200),
    CONDITION VARCHAR2(2000),
    EXPRESSION VARCHAR2(2000),
    PRIORITY NUMBER,
    PARTNERID NUMBER,
    PORTTYPE VARCHAR2(400),
    OPERATION VARCHAR2(200),
    ISEXTENSION CHAR(1),
    EXTENSIONTYPE VARCHAR2(100),
    EXTENSIONREF VARCHAR2(2000),
    DOCUMENTATION VARCHAR2(2000),
    SOURCECODE CLOB,
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY
 AS SELECT ACTIVITYID, PROCESSID, ACTIVITYNAME, ACTIVITYTYPE, LABEL, NODEID, NODELEVEL, NODESEQNUM, NODEBRANCH, PATTERN, HASPARALLELBRANCH, ISSPLIT, ISSWITCHCASE, ISSWITCHOTHER, ISJOIN, ISWSOPERATION, ISSWITCH, VARIABLE, PART, CONDITION, EXPRESSION, PRIORITY, PARTNERID, PORTTYPE, OPERATION, ISEXTENSION, EXTENSIONTYPE, EXTENSIONREF, DOCUMENTATION, SOURCECODE, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ACTIVITY;

ALTER TABLE E$BPM_CUBE_ACTIVITY
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_PK PRIMARY KEY (PROCESSID, ACTIVITYID);

CREATE INDEX BPM_CUBE_ACTIVITY_INDX1 ON E$BPM_CUBE_ACTIVITY
    (PROCESSID , ACTIVITYNAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ACTIVITY_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ACTIVITY_INSTANCE
(
    PROCESSINSTANCEID NUMBER NOT NULL,
    ACTIVITYINSTANCEID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    ACTIVITYID NUMBER NOT NULL,
    NODESEQNUM NUMBER NOT NULL,
    CREATIONDATE TIMESTAMP NOT NULL,
    MODIFYDATE TIMESTAMP,
    EVALPOINT VARCHAR2(30),
    EVALTIME NUMBER,
    ERRORMESSAGE NCLOB,
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    SYSTEMSTRING04 VARCHAR2(400),
    SYSTEMSTRING05 VARCHAR2(400),
    SYSTEMNUMBER01 NUMBER,
    SYSTEMNUMBER02 NUMBER,
    SYSTEMNUMBER03 NUMBER,
    SYSTEMNUMBER04 NUMBER,
    SYSTEMNUMBER05 NUMBER,
    SYSTEMTIMESTAMP01 TIMESTAMP,
    SYSTEMTIMESTAMP02 TIMESTAMP,
    SYSTEMTIMESTAMP03 TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY_INSTANCE
 AS SELECT PROCESSINSTANCEID, ACTIVITYINSTANCEID, PROCESSID, ACTIVITYID, NODESEQNUM, CREATIONDATE, MODIFYDATE, EVALPOINT, EVALTIME, ERRORMESSAGE, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03 FROM E$BPM_CUBE_ACTIVITY_INSTANCE;

ALTER TABLE E$BPM_CUBE_ACTIVITY_INSTANCE
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_INSTANCE_PK PRIMARY KEY (PROCESSINSTANCEID, ACTIVITYINSTANCEID);

CREATE INDEX BPM_CUBE_ACTIVITY_INST_INDX1 ON E$BPM_CUBE_ACTIVITY_INSTANCE
    (ACTIVITYID , PROCESSINSTANCEID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ACTIVITY_PROPERTY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ACTIVITY_PROPERTY
(
    ACTIVITYID NUMBER NOT NULL,
    PROPERTYID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    PROPERTYNAME VARCHAR2(256),
    QNAME VARCHAR2(400),
    DESCRIPTION VARCHAR2(2000),
    VALUETYPE VARCHAR2(256),
    DEFAULTVALUE VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY_PROPERTY
 AS SELECT ACTIVITYID, PROPERTYID, PROCESSID, PROPERTYNAME, QNAME, DESCRIPTION, VALUETYPE, DEFAULTVALUE FROM E$BPM_CUBE_ACTIVITY_PROPERTY;

ALTER TABLE E$BPM_CUBE_ACTIVITY_PROPERTY
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_PROPERTY_PK PRIMARY KEY (ACTIVITYID, PROPERTYID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ACTIVITY_SEQFLOW 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ACTIVITY_SEQFLOW
(
    PROCESSID NUMBER NOT NULL,
    SEQUENCEFLOWID NUMBER NOT NULL,
    SOURCEACTIVITYID NUMBER,
    TARGETACTIVITYID NUMBER,
    LABEL VARCHAR2(500),
    ISNORMALFLOW CHAR(1),
    ISCONDITIONFLOW CHAR(1),
    ISEXCEPTIONFLOW CHAR(1),
    CONDITION VARCHAR2(2000),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY_SEQFLOW
 AS SELECT PROCESSID, SEQUENCEFLOWID, SOURCEACTIVITYID, TARGETACTIVITYID, LABEL, ISNORMALFLOW, ISCONDITIONFLOW, ISEXCEPTIONFLOW, CONDITION, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ACTIVITY_SEQFLOW;

ALTER TABLE E$BPM_CUBE_ACTIVITY_SEQFLOW
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_SEQFLOW_PK PRIMARY KEY (PROCESSID, SEQUENCEFLOWID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_AUDITINST_FLEX01 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_AUDITINST_FLEX01
(
    QUERYID NUMBER NOT NULL,
    EXTENSIONID NUMBER NOT NULL,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_AUDITINST_FLEX01
 AS SELECT QUERYID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_AUDITINST_FLEX01;

ALTER TABLE E$BPM_CUBE_AUDITINST_FLEX01
    ADD CONSTRAINT BPM_CUBE_AUDITINST_FLEX01_PK PRIMARY KEY (QUERYID, EXTENSIONID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_AUDITINSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_AUDITINSTANCE
(
    QUERYID NUMBER NOT NULL,
    COMPONENTINSTANCEID VARCHAR2(200) NOT NULL,
    COMPONENTNAME VARCHAR2(500) NOT NULL,
    COMPOSITEDN VARCHAR2(500) NOT NULL,
    COMPOSITEREVISION VARCHAR2(400),
    ACTIVITYID VARCHAR2(400) NOT NULL,
    ACTIVITYNAME VARCHAR2(400),
    FLOWELEMENTTYPE VARCHAR2(100),
    CREATETIME TIMESTAMP NOT NULL,
    CREATETIMEMILLIS NUMBER,
    LASTUPDATED TIMESTAMP NOT NULL,
    THREADID NUMBER NOT NULL,
    SCOPEID VARCHAR2(450),
    INSTANCECOUNT NUMBER,
    LOOPCOUNT NUMBER,
    OPERATION VARCHAR2(400) NOT NULL,
    PARTICIPANT VARCHAR2(4000),
    ROLEID VARCHAR2(100),
    PROCESSNAME VARCHAR2(500),
    REFERENCEID VARCHAR2(400),
    INVOKEDCOMPONENTNAME VARCHAR2(400),
    PROCESSED VARCHAR2(1),
    FAULTED VARCHAR2(1),
    FAULTTYPE VARCHAR2(255),
    RECOVERABLEFAULT VARCHAR2(1),
    PRIORITY NUMBER,
    BUSINESSINDICATORS CLOB,
    CIPARTITIONDATE TIMESTAMP,
    COMPOSITEINSTANCEID VARCHAR2(200),
    ACTIVITYSTATUS VARCHAR2(100),
    SUSPENDTIME NUMBER,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    SYSTEMSTRING04 VARCHAR2(400),
    SYSTEMSTRING05 VARCHAR2(400),
    SYSTEMNUMBER01 NUMBER,
    SYSTEMNUMBER02 NUMBER,
    SYSTEMNUMBER03 NUMBER,
    SYSTEMNUMBER04 NUMBER,
    SYSTEMNUMBER05 NUMBER,
    SYSTEMTIMESTAMP01 TIMESTAMP,
    SYSTEMTIMESTAMP02 TIMESTAMP,
    SYSTEMTIMESTAMP03 TIMESTAMP,
    ECID VARCHAR2(200),
    TENANTID NUMBER(18,0) DEFAULT -1,
    PROCESS_TITLE VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_AUDITINSTANCE
 AS SELECT QUERYID, COMPONENTINSTANCEID, COMPONENTNAME, COMPOSITEDN, COMPOSITEREVISION, ACTIVITYID, ACTIVITYNAME, FLOWELEMENTTYPE, CREATETIME, CREATETIMEMILLIS, LASTUPDATED, THREADID, SCOPEID, INSTANCECOUNT, LOOPCOUNT, OPERATION, PARTICIPANT, ROLEID, PROCESSNAME, REFERENCEID, INVOKEDCOMPONENTNAME, PROCESSED, FAULTED, FAULTTYPE, RECOVERABLEFAULT, PRIORITY, BUSINESSINDICATORS, CIPARTITIONDATE, COMPOSITEINSTANCEID, ACTIVITYSTATUS, SUSPENDTIME, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, ECID, TENANTID, PROCESS_TITLE FROM E$BPM_CUBE_AUDITINSTANCE;

ALTER TABLE E$BPM_CUBE_AUDITINSTANCE
    ADD CONSTRAINT BPM_CUBE_AUDITINSTANCE_PK PRIMARY KEY (QUERYID);

CREATE INDEX BPM_CUBE_AUDITINSTANCE_INDX1 ON E$BPM_CUBE_AUDITINSTANCE
    (COMPOSITEDN , PROCESSNAME );

CREATE INDEX BPM_CUBE_AUDITINSTANCE_INDX2 ON E$BPM_CUBE_AUDITINSTANCE
    (COMPONENTINSTANCEID );

CREATE INDEX BPM_CUBE_AUDITINSTANCE_INDX4 ON E$BPM_CUBE_AUDITINSTANCE
    (CREATETIME );

CREATE INDEX BPM_CUBE_AUDITINSTANCE_INDX5 ON E$BPM_CUBE_AUDITINSTANCE
    (LASTUPDATED );

CREATE INDEX BPM_CUBE_AUDITINSTANCE_INDX6 ON E$BPM_CUBE_AUDITINSTANCE
    (OPERATION , ACTIVITYSTATUS );

CREATE INDEX BPM_CUBE_AUDITINSTANCE_INDX8 ON E$BPM_CUBE_AUDITINSTANCE
    (ECID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_GLOBALCREATETASK 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_GLOBALCREATETASK
(
    PROCESSID NUMBER NOT NULL,
    ACTIVITYNAME VARCHAR2(256),
    ACTIVITYLABEL VARCHAR2(500),
    ROLE VARCHAR2(400),
    APPLICATIONCONTEXT VARCHAR2(200),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    ACTIVITYID NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_GLOBALCREATETASK
 AS SELECT PROCESSID, ACTIVITYNAME, ACTIVITYLABEL, ROLE, APPLICATIONCONTEXT, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, ACTIVITYID FROM E$BPM_CUBE_GLOBALCREATETASK;

ALTER TABLE E$BPM_CUBE_GLOBALCREATETASK
    ADD CONSTRAINT BPM_CUBE_GLOBALCREATETASK_PK PRIMARY KEY (PROCESSID, ACTIVITYID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_LASTSNAPSHOT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_LASTSNAPSHOT
(
    SNAPSHOTID NUMBER NOT NULL,
    QUERYID NUMBER NOT NULL,
    LASTSNAPSHOT TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_LASTSNAPSHOT
 AS SELECT SNAPSHOTID, QUERYID, LASTSNAPSHOT FROM E$BPM_CUBE_LASTSNAPSHOT;

ALTER TABLE E$BPM_CUBE_LASTSNAPSHOT
    ADD CONSTRAINT BPM_CUBE_LASTSNAPSHOT_PK PRIMARY KEY (SNAPSHOTID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_LOCK 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_LOCK
(
    LOCKNAME VARCHAR2(400) NOT NULL,
    LASTUPDATED TIMESTAMP,
    INFO VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_LOCK
 AS SELECT LOCKNAME, LASTUPDATED, INFO FROM E$BPM_CUBE_LOCK;

ALTER TABLE E$BPM_CUBE_LOCK
    ADD CONSTRAINT BPM_CUBE_LOCK_PK PRIMARY KEY (LOCKNAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_NAMETAB 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_NAMETAB
(
    NAMETABID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    EXTENSIONID NUMBER NOT NULL,
    NFLEXSTRING01 VARCHAR2(400),
    NFLEXSTRING02 VARCHAR2(400),
    NFLEXSTRING03 VARCHAR2(400),
    NFLEXSTRING04 VARCHAR2(400),
    NFLEXSTRING05 VARCHAR2(400),
    NFLEXSTRING06 VARCHAR2(400),
    NFLEXSTRING07 VARCHAR2(400),
    NFLEXSTRING08 VARCHAR2(400),
    NFLEXSTRING09 VARCHAR2(400),
    NFLEXSTRING10 VARCHAR2(400),
    NFLEXSTRING11 VARCHAR2(400),
    NFLEXSTRING12 VARCHAR2(400),
    NFLEXSTRING13 VARCHAR2(400),
    NFLEXSTRING14 VARCHAR2(400),
    NFLEXSTRING15 VARCHAR2(400),
    NFLEXSTRING16 VARCHAR2(400),
    NFLEXSTRING17 VARCHAR2(400),
    NFLEXSTRING18 VARCHAR2(400),
    NFLEXSTRING19 VARCHAR2(400),
    NFLEXSTRING20 VARCHAR2(400),
    TFLEXSTRING01 VARCHAR2(1),
    TFLEXSTRING02 VARCHAR2(1),
    TFLEXSTRING03 VARCHAR2(1),
    TFLEXSTRING04 VARCHAR2(1),
    TFLEXSTRING05 VARCHAR2(1),
    TFLEXSTRING06 VARCHAR2(1),
    TFLEXSTRING07 VARCHAR2(1),
    TFLEXSTRING08 VARCHAR2(1),
    TFLEXSTRING09 VARCHAR2(1),
    TFLEXSTRING10 VARCHAR2(1),
    TFLEXSTRING11 VARCHAR2(1),
    TFLEXSTRING12 VARCHAR2(1),
    TFLEXSTRING13 VARCHAR2(1),
    TFLEXSTRING14 VARCHAR2(1),
    TFLEXSTRING15 VARCHAR2(1),
    TFLEXSTRING16 VARCHAR2(1),
    TFLEXSTRING17 VARCHAR2(1),
    TFLEXSTRING18 VARCHAR2(1),
    TFLEXSTRING19 VARCHAR2(1),
    TFLEXSTRING20 VARCHAR2(1),
    NFLEXDATE01 VARCHAR2(400),
    NFLEXDATE02 VARCHAR2(400),
    NFLEXDATE03 VARCHAR2(400),
    NFLEXDATE04 VARCHAR2(400),
    NFLEXDATE05 VARCHAR2(400),
    NFLEXDATE06 VARCHAR2(400),
    NFLEXDATE07 VARCHAR2(400),
    NFLEXDATE08 VARCHAR2(400),
    NFLEXDATE09 VARCHAR2(400),
    NFLEXDATE10 VARCHAR2(400),
    TFLEXDATE01 VARCHAR2(1),
    TFLEXDATE02 VARCHAR2(1),
    TFLEXDATE03 VARCHAR2(1),
    TFLEXDATE04 VARCHAR2(1),
    TFLEXDATE05 VARCHAR2(1),
    TFLEXDATE06 VARCHAR2(1),
    TFLEXDATE07 VARCHAR2(1),
    TFLEXDATE08 VARCHAR2(1),
    TFLEXDATE09 VARCHAR2(1),
    TFLEXDATE10 VARCHAR2(1),
    NFLEXNUMBER01 VARCHAR2(400),
    NFLEXNUMBER02 VARCHAR2(400),
    NFLEXNUMBER03 VARCHAR2(400),
    NFLEXNUMBER04 VARCHAR2(400),
    NFLEXNUMBER05 VARCHAR2(400),
    NFLEXNUMBER06 VARCHAR2(400),
    NFLEXNUMBER07 VARCHAR2(400),
    NFLEXNUMBER08 VARCHAR2(400),
    NFLEXNUMBER09 VARCHAR2(400),
    NFLEXNUMBER10 VARCHAR2(400),
    NFLEXNUMBER11 VARCHAR2(400),
    NFLEXNUMBER12 VARCHAR2(400),
    NFLEXNUMBER13 VARCHAR2(400),
    NFLEXNUMBER14 VARCHAR2(400),
    NFLEXNUMBER15 VARCHAR2(400),
    NFLEXNUMBER16 VARCHAR2(400),
    NFLEXNUMBER17 VARCHAR2(400),
    NFLEXNUMBER18 VARCHAR2(400),
    NFLEXNUMBER19 VARCHAR2(400),
    NFLEXNUMBER20 VARCHAR2(400),
    NFLEXNUMBER21 VARCHAR2(400),
    NFLEXNUMBER22 VARCHAR2(400),
    NFLEXNUMBER23 VARCHAR2(400),
    NFLEXNUMBER24 VARCHAR2(400),
    NFLEXNUMBER25 VARCHAR2(400),
    NFLEXNUMBER26 VARCHAR2(400),
    NFLEXNUMBER27 VARCHAR2(400),
    NFLEXNUMBER28 VARCHAR2(400),
    NFLEXNUMBER29 VARCHAR2(400),
    NFLEXNUMBER30 VARCHAR2(400),
    TFLEXNUMBER01 VARCHAR2(1),
    TFLEXNUMBER02 VARCHAR2(1),
    TFLEXNUMBER03 VARCHAR2(1),
    TFLEXNUMBER04 VARCHAR2(1),
    TFLEXNUMBER05 VARCHAR2(1),
    TFLEXNUMBER06 VARCHAR2(1),
    TFLEXNUMBER07 VARCHAR2(1),
    TFLEXNUMBER08 VARCHAR2(1),
    TFLEXNUMBER09 VARCHAR2(1),
    TFLEXNUMBER10 VARCHAR2(1),
    TFLEXNUMBER11 VARCHAR2(1),
    TFLEXNUMBER12 VARCHAR2(1),
    TFLEXNUMBER13 VARCHAR2(1),
    TFLEXNUMBER14 VARCHAR2(1),
    TFLEXNUMBER15 VARCHAR2(1),
    TFLEXNUMBER16 VARCHAR2(1),
    TFLEXNUMBER17 VARCHAR2(1),
    TFLEXNUMBER18 VARCHAR2(1),
    TFLEXNUMBER19 VARCHAR2(1),
    TFLEXNUMBER20 VARCHAR2(1),
    TFLEXNUMBER21 VARCHAR2(1),
    TFLEXNUMBER22 VARCHAR2(1),
    TFLEXNUMBER23 VARCHAR2(1),
    TFLEXNUMBER24 VARCHAR2(1),
    TFLEXNUMBER25 VARCHAR2(1),
    TFLEXNUMBER26 VARCHAR2(1),
    TFLEXNUMBER27 VARCHAR2(1),
    TFLEXNUMBER28 VARCHAR2(1),
    TFLEXNUMBER29 VARCHAR2(1),
    TFLEXNUMBER30 VARCHAR2(1),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    SYSTEMSTRING04 VARCHAR2(400),
    SYSTEMSTRING05 VARCHAR2(400),
    SYSTEMNUMBER01 NUMBER,
    SYSTEMNUMBER02 NUMBER,
    SYSTEMNUMBER03 NUMBER,
    SYSTEMNUMBER04 NUMBER,
    SYSTEMNUMBER05 NUMBER,
    SYSTEMTIMESTAMP01 TIMESTAMP,
    SYSTEMTIMESTAMP02 TIMESTAMP,
    SYSTEMTIMESTAMP03 TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_NAMETAB
 AS SELECT NAMETABID, PROCESSID, EXTENSIONID, NFLEXSTRING01, NFLEXSTRING02, NFLEXSTRING03, NFLEXSTRING04, NFLEXSTRING05, NFLEXSTRING06, NFLEXSTRING07, NFLEXSTRING08, NFLEXSTRING09, NFLEXSTRING10, NFLEXSTRING11, NFLEXSTRING12, NFLEXSTRING13, NFLEXSTRING14, NFLEXSTRING15, NFLEXSTRING16, NFLEXSTRING17, NFLEXSTRING18, NFLEXSTRING19, NFLEXSTRING20, TFLEXSTRING01, TFLEXSTRING02, TFLEXSTRING03, TFLEXSTRING04, TFLEXSTRING05, TFLEXSTRING06, TFLEXSTRING07, TFLEXSTRING08, TFLEXSTRING09, TFLEXSTRING10, TFLEXSTRING11, TFLEXSTRING12, TFLEXSTRING13, TFLEXSTRING14, TFLEXSTRING15, TFLEXSTRING16, TFLEXSTRING17, TFLEXSTRING18, TFLEXSTRING19, TFLEXSTRING20, NFLEXDATE01, NFLEXDATE02, NFLEXDATE03, NFLEXDATE04, NFLEXDATE05, NFLEXDATE06, NFLEXDATE07, NFLEXDATE08, NFLEXDATE09, NFLEXDATE10, TFLEXDATE01, TFLEXDATE02, TFLEXDATE03, TFLEXDATE04, TFLEXDATE05, TFLEXDATE06, TFLEXDATE07, TFLEXDATE08, TFLEXDATE09, TFLEXDATE10, NFLEXNUMBER01, NFLEXNUMBER02, NFLEXNUMBER03, NFLEXNUMBER04, NFLEXNUMBER05, NFLEXNUMBER06, NFLEXNUMBER07, NFLEXNUMBER08, NFLEXNUMBER09, NFLEXNUMBER10, NFLEXNUMBER11, NFLEXNUMBER12, NFLEXNUMBER13, NFLEXNUMBER14, NFLEXNUMBER15, NFLEXNUMBER16, NFLEXNUMBER17, NFLEXNUMBER18, NFLEXNUMBER19, NFLEXNUMBER20, NFLEXNUMBER21, NFLEXNUMBER22, NFLEXNUMBER23, NFLEXNUMBER24, NFLEXNUMBER25, NFLEXNUMBER26, NFLEXNUMBER27, NFLEXNUMBER28, NFLEXNUMBER29, NFLEXNUMBER30, TFLEXNUMBER01, TFLEXNUMBER02, TFLEXNUMBER03, TFLEXNUMBER04, TFLEXNUMBER05, TFLEXNUMBER06, TFLEXNUMBER07, TFLEXNUMBER08, TFLEXNUMBER09, TFLEXNUMBER10, TFLEXNUMBER11, TFLEXNUMBER12, TFLEXNUMBER13, TFLEXNUMBER14, TFLEXNUMBER15, TFLEXNUMBER16, TFLEXNUMBER17, TFLEXNUMBER18, TFLEXNUMBER19, TFLEXNUMBER20, TFLEXNUMBER21, TFLEXNUMBER22, TFLEXNUMBER23, TFLEXNUMBER24, TFLEXNUMBER25, TFLEXNUMBER26, TFLEXNUMBER27, TFLEXNUMBER28, TFLEXNUMBER29, TFLEXNUMBER30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03 FROM E$BPM_CUBE_NAMETAB;

ALTER TABLE E$BPM_CUBE_NAMETAB
    ADD CONSTRAINT BPM_CUBE_NAMETAB_PK PRIMARY KEY (PROCESSID, NAMETABID, EXTENSIONID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_NAMETAB_RANGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_NAMETAB_RANGE
(
    NAMETABID NUMBER NOT NULL,
    EXTENSIONID NUMBER NOT NULL,
    RANGEID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    INDICATORNAME VARCHAR2(400),
    RANGENAME VARCHAR2(200),
    RANGEOPERATOR VARCHAR2(100),
    NUMBERRANGESTART NUMBER,
    NUMBERRANGEEND NUMBER,
    DATETIMERANGESTART TIMESTAMP,
    DATETIMERANGEEND TIMESTAMP,
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_NAMETAB_RANGE
 AS SELECT NAMETABID, EXTENSIONID, RANGEID, PROCESSID, INDICATORNAME, RANGENAME, RANGEOPERATOR, NUMBERRANGESTART, NUMBERRANGEEND, DATETIMERANGESTART, DATETIMERANGEEND, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_NAMETAB_RANGE;

ALTER TABLE E$BPM_CUBE_NAMETAB_RANGE
    ADD CONSTRAINT BPM_CUBE_NAMETAB_RANGE_PK PRIMARY KEY (NAMETABID, EXTENSIONID, RANGEID);

CREATE INDEX BPM_CUBE_NAMETAB_RANGE_INDX1 ON E$BPM_CUBE_NAMETAB_RANGE
    (INDICATORNAME , RANGENAME , PROCESSID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ORGUNIT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ORGUNIT
(
    ORGUNITID NUMBER NOT NULL,
    PARENTID NUMBER,
    ORGUNITNAME VARCHAR2(200) NOT NULL,
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ORGUNIT
 AS SELECT ORGUNITID, PARENTID, ORGUNITNAME, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ORGUNIT;

ALTER TABLE E$BPM_CUBE_ORGUNIT
    ADD CONSTRAINT BPM_CUBE_ORGUNIT_PK PRIMARY KEY (ORGUNITID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ORGUNIT_ASSOC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ORGUNIT_ASSOC
(
    ORGUNITID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ORGUNIT_ASSOC
 AS SELECT ORGUNITID, PROCESSID FROM E$BPM_CUBE_ORGUNIT_ASSOC;

ALTER TABLE E$BPM_CUBE_ORGUNIT_ASSOC
    ADD CONSTRAINT BPM_CUBE_ORGUNIT_ASSOC_PK PRIMARY KEY (ORGUNITID, PROCESSID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_PARTNER_SERVICE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_PARTNER_SERVICE
(
    PARTNERID NUMBER NOT NULL,
    PARTNERSERVICEID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    PORTTYPE VARCHAR2(400),
    OPERATION VARCHAR2(200),
    ISINITIATING CHAR(1)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PARTNER_SERVICE
 AS SELECT PARTNERID, PARTNERSERVICEID, PROCESSID, PORTTYPE, OPERATION, ISINITIATING FROM E$BPM_CUBE_PARTNER_SERVICE;

ALTER TABLE E$BPM_CUBE_PARTNER_SERVICE
    ADD CONSTRAINT BPM_CUBE_PARTNER_SERVICE_PK PRIMARY KEY (PARTNERID, PARTNERSERVICEID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_PROCESS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_PROCESS
(
    PROCESSID NUMBER NOT NULL,
    PROCESSNAME VARCHAR2(100) NOT NULL,
    DOMAINNAME VARCHAR2(100) NOT NULL,
    COMPOSITENAME VARCHAR2(100) NOT NULL,
    REVISION VARCHAR2(50) NOT NULL,
    SCALABEL VARCHAR2(100) NOT NULL,
    COMPOSITEDN VARCHAR2(500) NOT NULL,
    LABEL VARCHAR2(500),
    PROCESSTYPE VARCHAR2(20),
    TARGETNAMESPACE VARCHAR2(400),
    STATUS INTEGER,
    CREATIONDATE TIMESTAMP,
    UNDEPLOYDATE TIMESTAMP,
    ORGANIZATIONALUNITID VARCHAR2(64),
    HASGLOBALCREATIONTASKS CHAR(1),
    SUBTYPE VARCHAR2(200),
    SUSPENDEDTIME TIMESTAMP,
    RESUMEDTIME TIMESTAMP,
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    DEPLOYMENTINFO BLOB,
    LASTUPDATED TIMESTAMP,
    MIGRATIONSTATUS VARCHAR2(100) DEFAULT 'LATEST',
    ANALYTICSVIEWIDENTIFIER VARCHAR2(100),
    ANALYTICSVIEWGRANTEES VARCHAR2(2000),
    TEMPLATENAME VARCHAR2(2000),
    TEMPLATEVIEWIDENTIFIER VARCHAR2(100),
    APPLICATIONLINKDISPLAYNAME VARCHAR2(2000),
    CATEGORY VARCHAR2(2000),
    TAGS VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCESS
 AS SELECT PROCESSID, PROCESSNAME, DOMAINNAME, COMPOSITENAME, REVISION, SCALABEL, COMPOSITEDN, LABEL, PROCESSTYPE, TARGETNAMESPACE, STATUS, CREATIONDATE, UNDEPLOYDATE, ORGANIZATIONALUNITID, HASGLOBALCREATIONTASKS, SUBTYPE, SUSPENDEDTIME, RESUMEDTIME, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, DEPLOYMENTINFO, LASTUPDATED, MIGRATIONSTATUS, ANALYTICSVIEWIDENTIFIER, ANALYTICSVIEWGRANTEES, TEMPLATENAME, TEMPLATEVIEWIDENTIFIER, APPLICATIONLINKDISPLAYNAME, CATEGORY, TAGS FROM E$BPM_CUBE_PROCESS;

ALTER TABLE E$BPM_CUBE_PROCESS
    ADD CONSTRAINT BPM_CUBE_PROCESS_PK PRIMARY KEY (PROCESSID);

CREATE UNIQUE INDEX BPM_CUBE_PROCESS_INDX1 ON E$BPM_CUBE_PROCESS
    (COMPOSITENAME , PROCESSNAME , REVISION , DOMAINNAME , PROCESSTYPE , SCALABEL );

CREATE INDEX BPM_CUBE_PROCESS_INDX2 ON E$BPM_CUBE_PROCESS
    (COMPOSITEDN , PROCESSNAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_PROCESS_PARTNER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_PROCESS_PARTNER
(
    PARTNERID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    PARTNERNAME VARCHAR2(256),
    LINKTYPE VARCHAR2(400),
    SCOPEID NUMBER,
    PARTNERWSDL VARCHAR2(500),
    MYROLE VARCHAR2(200),
    PARTNERROLE VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCESS_PARTNER
 AS SELECT PARTNERID, PROCESSID, PARTNERNAME, LINKTYPE, SCOPEID, PARTNERWSDL, MYROLE, PARTNERROLE FROM E$BPM_CUBE_PROCESS_PARTNER;

ALTER TABLE E$BPM_CUBE_PROCESS_PARTNER
    ADD CONSTRAINT BPM_CUBE_PROCESS_PARTNER_PK PRIMARY KEY (PROCESSID, PARTNERID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_PROCESSPERFORMANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_PROCESSPERFORMANCE
(
    PROCESSPERFID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    COMPONENTINSTANCEID VARCHAR2(100),
    COMPONENTINSTANCESTATE INTEGER,
    CREATIONDATETIME TIMESTAMP,
    CREATIONDATE TIMESTAMP,
    COMPLETIONDATETIME TIMESTAMP,
    COMPLETIONDATE TIMESTAMP,
    TASKTIME NUMBER,
    DISCRIMINATOR VARCHAR2(200),
    CIPARTITIONDATE TIMESTAMP,
    COMPOSITEINSTANCEID VARCHAR2(200),
    SUSPENDTIME NUMBER,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    STARTFLEXNUMBER01 NUMBER,
    STARTFLEXNUMBER02 NUMBER,
    STARTFLEXNUMBER03 NUMBER,
    STARTFLEXNUMBER04 NUMBER,
    STARTFLEXNUMBER05 NUMBER,
    STARTFLEXNUMBER06 NUMBER,
    STARTFLEXNUMBER07 NUMBER,
    STARTFLEXNUMBER08 NUMBER,
    STARTFLEXNUMBER09 NUMBER,
    STARTFLEXNUMBER10 NUMBER,
    STARTFLEXNUMBER11 NUMBER,
    STARTFLEXNUMBER12 NUMBER,
    STARTFLEXNUMBER13 NUMBER,
    STARTFLEXNUMBER14 NUMBER,
    STARTFLEXNUMBER15 NUMBER,
    STARTFLEXNUMBER16 NUMBER,
    STARTFLEXNUMBER17 NUMBER,
    STARTFLEXNUMBER18 NUMBER,
    STARTFLEXNUMBER19 NUMBER,
    STARTFLEXNUMBER20 NUMBER,
    STARTFLEXNUMBER21 NUMBER,
    STARTFLEXNUMBER22 NUMBER,
    STARTFLEXNUMBER23 NUMBER,
    STARTFLEXNUMBER24 NUMBER,
    STARTFLEXNUMBER25 NUMBER,
    STARTFLEXNUMBER26 NUMBER,
    STARTFLEXNUMBER27 NUMBER,
    STARTFLEXNUMBER28 NUMBER,
    STARTFLEXNUMBER29 NUMBER,
    STARTFLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    SYSTEMSTRING04 VARCHAR2(400),
    SYSTEMSTRING05 VARCHAR2(400),
    SYSTEMNUMBER01 NUMBER,
    SYSTEMNUMBER02 NUMBER,
    SYSTEMNUMBER03 NUMBER,
    SYSTEMNUMBER04 NUMBER,
    SYSTEMNUMBER05 NUMBER,
    SYSTEMTIMESTAMP01 TIMESTAMP,
    SYSTEMTIMESTAMP02 TIMESTAMP,
    SYSTEMTIMESTAMP03 TIMESTAMP,
    ECID VARCHAR2(200),
    TENANTID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCESSPERFORMANCE
 AS SELECT PROCESSPERFID, PROCESSID, COMPONENTINSTANCEID, COMPONENTINSTANCESTATE, CREATIONDATETIME, CREATIONDATE, COMPLETIONDATETIME, COMPLETIONDATE, TASKTIME, DISCRIMINATOR, CIPARTITIONDATE, COMPOSITEINSTANCEID, SUSPENDTIME, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, ECID, TENANTID FROM E$BPM_CUBE_PROCESSPERFORMANCE;

ALTER TABLE E$BPM_CUBE_PROCESSPERFORMANCE
    ADD CONSTRAINT BPM_CUBE_PROCESSPERFORMANCE_PK PRIMARY KEY (PROCESSID, PROCESSPERFID);

CREATE INDEX BPM_CUBE_PROCPERF_INDX1 ON E$BPM_CUBE_PROCESSPERFORMANCE
    (COMPONENTINSTANCEID , COMPONENTINSTANCESTATE );

CREATE INDEX BPM_CUBE_PROCPERF_INDX2 ON E$BPM_CUBE_PROCESSPERFORMANCE
    (COMPLETIONDATETIME );

CREATE INDEX BPM_CUBE_PROCPERF_INDX3 ON E$BPM_CUBE_PROCESSPERFORMANCE
    (ECID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_PROCPERF_FLEX01 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_PROCPERF_FLEX01
(
    PROCESSID NUMBER NOT NULL,
    PROCESSPERFID NUMBER NOT NULL,
    EXTENSIONID NUMBER NOT NULL,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    STARTFLEXNUMBER01 NUMBER,
    STARTFLEXNUMBER02 NUMBER,
    STARTFLEXNUMBER03 NUMBER,
    STARTFLEXNUMBER04 NUMBER,
    STARTFLEXNUMBER05 NUMBER,
    STARTFLEXNUMBER06 NUMBER,
    STARTFLEXNUMBER07 NUMBER,
    STARTFLEXNUMBER08 NUMBER,
    STARTFLEXNUMBER09 NUMBER,
    STARTFLEXNUMBER10 NUMBER,
    STARTFLEXNUMBER11 NUMBER,
    STARTFLEXNUMBER12 NUMBER,
    STARTFLEXNUMBER13 NUMBER,
    STARTFLEXNUMBER14 NUMBER,
    STARTFLEXNUMBER15 NUMBER,
    STARTFLEXNUMBER16 NUMBER,
    STARTFLEXNUMBER17 NUMBER,
    STARTFLEXNUMBER18 NUMBER,
    STARTFLEXNUMBER19 NUMBER,
    STARTFLEXNUMBER20 NUMBER,
    STARTFLEXNUMBER21 NUMBER,
    STARTFLEXNUMBER22 NUMBER,
    STARTFLEXNUMBER23 NUMBER,
    STARTFLEXNUMBER24 NUMBER,
    STARTFLEXNUMBER25 NUMBER,
    STARTFLEXNUMBER26 NUMBER,
    STARTFLEXNUMBER27 NUMBER,
    STARTFLEXNUMBER28 NUMBER,
    STARTFLEXNUMBER29 NUMBER,
    STARTFLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCPERF_FLEX01
 AS SELECT PROCESSID, PROCESSPERFID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_PROCPERF_FLEX01;

ALTER TABLE E$BPM_CUBE_PROCPERF_FLEX01
    ADD CONSTRAINT BPM_CUBE_PROCPERF_FLEX01_PK PRIMARY KEY (PROCESSID, PROCESSPERFID, EXTENSIONID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_ROLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_ROLE
(
    PROCESSID NUMBER NOT NULL,
    ROLEID NUMBER NOT NULL,
    ROLENAME VARCHAR2(200) NOT NULL,
    LABEL VARCHAR2(500),
    APPROLENAME VARCHAR2(400),
    ISPROCESSOWNER VARCHAR2(1),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ROLE
 AS SELECT PROCESSID, ROLEID, ROLENAME, LABEL, APPROLENAME, ISPROCESSOWNER, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ROLE;

ALTER TABLE E$BPM_CUBE_ROLE
    ADD CONSTRAINT BPM_CUBE_ROLE_PK PRIMARY KEY (PROCESSID, ROLEID);

CREATE INDEX BPM_CUBE_ROLE_INDX1 ON E$BPM_CUBE_ROLE
    (ROLENAME , ROLEID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_SEQUENCE
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_CUBE_SEQUENCE;

ALTER TABLE E$BPM_CUBE_SEQUENCE
    ADD CONSTRAINT BPM_CUBE_SEQUENCE_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_TASKPERF_FLEX01 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_TASKPERF_FLEX01
(
    ACTIVITYID NUMBER NOT NULL,
    TASKPERFID NUMBER NOT NULL,
    EXTENSIONID NUMBER NOT NULL,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    STARTFLEXNUMBER01 NUMBER,
    STARTFLEXNUMBER02 NUMBER,
    STARTFLEXNUMBER03 NUMBER,
    STARTFLEXNUMBER04 NUMBER,
    STARTFLEXNUMBER05 NUMBER,
    STARTFLEXNUMBER06 NUMBER,
    STARTFLEXNUMBER07 NUMBER,
    STARTFLEXNUMBER08 NUMBER,
    STARTFLEXNUMBER09 NUMBER,
    STARTFLEXNUMBER10 NUMBER,
    STARTFLEXNUMBER11 NUMBER,
    STARTFLEXNUMBER12 NUMBER,
    STARTFLEXNUMBER13 NUMBER,
    STARTFLEXNUMBER14 NUMBER,
    STARTFLEXNUMBER15 NUMBER,
    STARTFLEXNUMBER16 NUMBER,
    STARTFLEXNUMBER17 NUMBER,
    STARTFLEXNUMBER18 NUMBER,
    STARTFLEXNUMBER19 NUMBER,
    STARTFLEXNUMBER20 NUMBER,
    STARTFLEXNUMBER21 NUMBER,
    STARTFLEXNUMBER22 NUMBER,
    STARTFLEXNUMBER23 NUMBER,
    STARTFLEXNUMBER24 NUMBER,
    STARTFLEXNUMBER25 NUMBER,
    STARTFLEXNUMBER26 NUMBER,
    STARTFLEXNUMBER27 NUMBER,
    STARTFLEXNUMBER28 NUMBER,
    STARTFLEXNUMBER29 NUMBER,
    STARTFLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_TASKPERF_FLEX01
 AS SELECT ACTIVITYID, TASKPERFID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_TASKPERF_FLEX01;

ALTER TABLE E$BPM_CUBE_TASKPERF_FLEX01
    ADD CONSTRAINT BPM_CUBE_TASKPERF_FLEX01_PK PRIMARY KEY (ACTIVITYID, TASKPERFID, EXTENSIONID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_TASKPERFORMANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_TASKPERFORMANCE
(
    TASKPERFID NUMBER NOT NULL,
    ACTIVITYID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    ROLEID NUMBER,
    COMPONENTINSTANCEID VARCHAR2(100),
    CREATIONDATETIME TIMESTAMP,
    CREATIONDATE TIMESTAMP,
    COMPLETIONDATETIME TIMESTAMP,
    COMPLETIONDATE TIMESTAMP,
    TASKTIME NUMBER,
    IDLETIME NUMBER,
    PARTICIPANT VARCHAR2(4000),
    PRIORITY NUMBER,
    DISCRIMINATOR VARCHAR2(200),
    REFERENCEID NUMBER,
    SCOPEID VARCHAR2(450),
    INSTANCECOUNT NUMBER,
    LOOPCOUNT NUMBER,
    CIPARTITIONDATE TIMESTAMP,
    COMPOSITEINSTANCEID VARCHAR2(200),
    SUSPENDTIME NUMBER,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    STARTFLEXNUMBER01 NUMBER,
    STARTFLEXNUMBER02 NUMBER,
    STARTFLEXNUMBER03 NUMBER,
    STARTFLEXNUMBER04 NUMBER,
    STARTFLEXNUMBER05 NUMBER,
    STARTFLEXNUMBER06 NUMBER,
    STARTFLEXNUMBER07 NUMBER,
    STARTFLEXNUMBER08 NUMBER,
    STARTFLEXNUMBER09 NUMBER,
    STARTFLEXNUMBER10 NUMBER,
    STARTFLEXNUMBER11 NUMBER,
    STARTFLEXNUMBER12 NUMBER,
    STARTFLEXNUMBER13 NUMBER,
    STARTFLEXNUMBER14 NUMBER,
    STARTFLEXNUMBER15 NUMBER,
    STARTFLEXNUMBER16 NUMBER,
    STARTFLEXNUMBER17 NUMBER,
    STARTFLEXNUMBER18 NUMBER,
    STARTFLEXNUMBER19 NUMBER,
    STARTFLEXNUMBER20 NUMBER,
    STARTFLEXNUMBER21 NUMBER,
    STARTFLEXNUMBER22 NUMBER,
    STARTFLEXNUMBER23 NUMBER,
    STARTFLEXNUMBER24 NUMBER,
    STARTFLEXNUMBER25 NUMBER,
    STARTFLEXNUMBER26 NUMBER,
    STARTFLEXNUMBER27 NUMBER,
    STARTFLEXNUMBER28 NUMBER,
    STARTFLEXNUMBER29 NUMBER,
    STARTFLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    SYSTEMSTRING04 VARCHAR2(400),
    SYSTEMSTRING05 VARCHAR2(400),
    SYSTEMNUMBER01 NUMBER,
    SYSTEMNUMBER02 NUMBER,
    SYSTEMNUMBER03 NUMBER,
    SYSTEMNUMBER04 NUMBER,
    SYSTEMNUMBER05 NUMBER,
    SYSTEMTIMESTAMP01 TIMESTAMP,
    SYSTEMTIMESTAMP02 TIMESTAMP,
    SYSTEMTIMESTAMP03 TIMESTAMP,
    ECID VARCHAR2(200),
    TENANTID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_TASKPERFORMANCE
 AS SELECT TASKPERFID, ACTIVITYID, PROCESSID, ROLEID, COMPONENTINSTANCEID, CREATIONDATETIME, CREATIONDATE, COMPLETIONDATETIME, COMPLETIONDATE, TASKTIME, IDLETIME, PARTICIPANT, PRIORITY, DISCRIMINATOR, REFERENCEID, SCOPEID, INSTANCECOUNT, LOOPCOUNT, CIPARTITIONDATE, COMPOSITEINSTANCEID, SUSPENDTIME, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, ECID, TENANTID FROM E$BPM_CUBE_TASKPERFORMANCE;

ALTER TABLE E$BPM_CUBE_TASKPERFORMANCE
    ADD CONSTRAINT BPM_CUBE_TASKPERFORMANCE_PK PRIMARY KEY (ACTIVITYID, TASKPERFID);

CREATE INDEX BPM_CUBE_TASKPERF_INDX1 ON E$BPM_CUBE_TASKPERFORMANCE
    (COMPONENTINSTANCEID );

CREATE INDEX BPM_CUBE_TASKPERF_INDX2 ON E$BPM_CUBE_TASKPERFORMANCE
    (COMPLETIONDATETIME );

CREATE INDEX BPM_CUBE_TASKPERF_INDX3 ON E$BPM_CUBE_TASKPERFORMANCE
    (ECID );

CREATE INDEX BPM_CUBE_TASKPERF_INDX4 ON E$BPM_CUBE_TASKPERFORMANCE
    (PROCESSID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_WORKLOAD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_WORKLOAD
(
    WORKLOADID NUMBER NOT NULL,
    ACTIVITYID NUMBER NOT NULL,
    PROCESSID NUMBER NOT NULL,
    ROLEID NUMBER,
    ORIGACTIVITYID NUMBER,
    SNAPSHOTTIME TIMESTAMP,
    QUANTITY NUMBER,
    AVGTIMETASK NUMBER,
    AVGTIMEPROCESS NUMBER,
    MEDIANTIMETASK NUMBER,
    MEDIANTIMEPROCESS NUMBER,
    SUMTIMETASK NUMBER,
    SUMTIMEPROCESS NUMBER,
    SQRSUMTIMETASK NUMBER,
    SQRSUMTIMEPROCESS NUMBER,
    SAMPLESIZE NUMBER,
    STATVALUE01 NUMBER,
    STATVALUE02 NUMBER,
    STATVALUE03 NUMBER,
    STATVALUE04 NUMBER,
    STATVALUE05 NUMBER,
    PARTICIPANT VARCHAR2(4000),
    PRIORITY NUMBER,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200),
    SYSTEMSTRING01 VARCHAR2(400),
    SYSTEMSTRING02 VARCHAR2(400),
    SYSTEMSTRING03 VARCHAR2(400),
    SYSTEMSTRING04 VARCHAR2(400),
    SYSTEMSTRING05 VARCHAR2(400),
    SYSTEMNUMBER01 NUMBER,
    SYSTEMNUMBER02 NUMBER,
    SYSTEMNUMBER03 NUMBER,
    SYSTEMNUMBER04 NUMBER,
    SYSTEMNUMBER05 NUMBER,
    SYSTEMTIMESTAMP01 TIMESTAMP,
    SYSTEMTIMESTAMP02 TIMESTAMP,
    SYSTEMTIMESTAMP03 TIMESTAMP,
    TENANTID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_WORKLOAD
 AS SELECT WORKLOADID, ACTIVITYID, PROCESSID, ROLEID, ORIGACTIVITYID, SNAPSHOTTIME, QUANTITY, AVGTIMETASK, AVGTIMEPROCESS, MEDIANTIMETASK, MEDIANTIMEPROCESS, SUMTIMETASK, SUMTIMEPROCESS, SQRSUMTIMETASK, SQRSUMTIMEPROCESS, SAMPLESIZE, STATVALUE01, STATVALUE02, STATVALUE03, STATVALUE04, STATVALUE05, PARTICIPANT, PRIORITY, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, TENANTID FROM E$BPM_CUBE_WORKLOAD;

ALTER TABLE E$BPM_CUBE_WORKLOAD
    ADD CONSTRAINT BPM_CUBE_WORKLOAD_PK PRIMARY KEY (ACTIVITYID, WORKLOADID);

CREATE INDEX BPM_CUBE_WORKLOAD_INDX1 ON E$BPM_CUBE_WORKLOAD
    (SNAPSHOTTIME );

CREATE INDEX BPM_CUBE_WORKLOAD_INDX2 ON E$BPM_CUBE_WORKLOAD
    (PROCESSID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CUBE_WORKLOAD_FLEX01 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUBE_WORKLOAD_FLEX01
(
    ACTIVITYID NUMBER NOT NULL,
    WORKLOADID NUMBER NOT NULL,
    EXTENSIONID NUMBER NOT NULL,
    FLEXSTRING01 VARCHAR2(2000),
    FLEXSTRING02 VARCHAR2(2000),
    FLEXSTRING03 VARCHAR2(2000),
    FLEXSTRING04 VARCHAR2(2000),
    FLEXSTRING05 VARCHAR2(2000),
    FLEXSTRING06 VARCHAR2(2000),
    FLEXSTRING07 VARCHAR2(2000),
    FLEXSTRING08 VARCHAR2(2000),
    FLEXSTRING09 VARCHAR2(2000),
    FLEXSTRING10 VARCHAR2(2000),
    FLEXSTRING11 VARCHAR2(2000),
    FLEXSTRING12 VARCHAR2(2000),
    FLEXSTRING13 VARCHAR2(2000),
    FLEXSTRING14 VARCHAR2(2000),
    FLEXSTRING15 VARCHAR2(2000),
    FLEXSTRING16 VARCHAR2(2000),
    FLEXSTRING17 VARCHAR2(2000),
    FLEXSTRING18 VARCHAR2(2000),
    FLEXSTRING19 VARCHAR2(2000),
    FLEXSTRING20 VARCHAR2(2000),
    FLEXDATE01 TIMESTAMP,
    FLEXDATE02 TIMESTAMP,
    FLEXDATE03 TIMESTAMP,
    FLEXDATE04 TIMESTAMP,
    FLEXDATE05 TIMESTAMP,
    FLEXDATE06 TIMESTAMP,
    FLEXDATE07 TIMESTAMP,
    FLEXDATE08 TIMESTAMP,
    FLEXDATE09 TIMESTAMP,
    FLEXDATE10 TIMESTAMP,
    FLEXDATERANGE01 VARCHAR2(200),
    FLEXDATERANGE02 VARCHAR2(200),
    FLEXDATERANGE03 VARCHAR2(200),
    FLEXDATERANGE04 VARCHAR2(200),
    FLEXDATERANGE05 VARCHAR2(200),
    FLEXDATERANGE06 VARCHAR2(200),
    FLEXDATERANGE07 VARCHAR2(200),
    FLEXDATERANGE08 VARCHAR2(200),
    FLEXDATERANGE09 VARCHAR2(200),
    FLEXDATERANGE10 VARCHAR2(200),
    FLEXNUMBER01 NUMBER,
    FLEXNUMBER02 NUMBER,
    FLEXNUMBER03 NUMBER,
    FLEXNUMBER04 NUMBER,
    FLEXNUMBER05 NUMBER,
    FLEXNUMBER06 NUMBER,
    FLEXNUMBER07 NUMBER,
    FLEXNUMBER08 NUMBER,
    FLEXNUMBER09 NUMBER,
    FLEXNUMBER10 NUMBER,
    FLEXNUMBER11 NUMBER,
    FLEXNUMBER12 NUMBER,
    FLEXNUMBER13 NUMBER,
    FLEXNUMBER14 NUMBER,
    FLEXNUMBER15 NUMBER,
    FLEXNUMBER16 NUMBER,
    FLEXNUMBER17 NUMBER,
    FLEXNUMBER18 NUMBER,
    FLEXNUMBER19 NUMBER,
    FLEXNUMBER20 NUMBER,
    FLEXNUMBER21 NUMBER,
    FLEXNUMBER22 NUMBER,
    FLEXNUMBER23 NUMBER,
    FLEXNUMBER24 NUMBER,
    FLEXNUMBER25 NUMBER,
    FLEXNUMBER26 NUMBER,
    FLEXNUMBER27 NUMBER,
    FLEXNUMBER28 NUMBER,
    FLEXNUMBER29 NUMBER,
    FLEXNUMBER30 NUMBER,
    FLEXNUMBERRANGE01 VARCHAR2(200),
    FLEXNUMBERRANGE02 VARCHAR2(200),
    FLEXNUMBERRANGE03 VARCHAR2(200),
    FLEXNUMBERRANGE04 VARCHAR2(200),
    FLEXNUMBERRANGE05 VARCHAR2(200),
    FLEXNUMBERRANGE06 VARCHAR2(200),
    FLEXNUMBERRANGE07 VARCHAR2(200),
    FLEXNUMBERRANGE08 VARCHAR2(200),
    FLEXNUMBERRANGE09 VARCHAR2(200),
    FLEXNUMBERRANGE10 VARCHAR2(200),
    FLEXNUMBERRANGE11 VARCHAR2(200),
    FLEXNUMBERRANGE12 VARCHAR2(200),
    FLEXNUMBERRANGE13 VARCHAR2(200),
    FLEXNUMBERRANGE14 VARCHAR2(200),
    FLEXNUMBERRANGE15 VARCHAR2(200),
    FLEXNUMBERRANGE16 VARCHAR2(200),
    FLEXNUMBERRANGE17 VARCHAR2(200),
    FLEXNUMBERRANGE18 VARCHAR2(200),
    FLEXNUMBERRANGE19 VARCHAR2(200),
    FLEXNUMBERRANGE20 VARCHAR2(200),
    FLEXNUMBERRANGE21 VARCHAR2(200),
    FLEXNUMBERRANGE22 VARCHAR2(200),
    FLEXNUMBERRANGE23 VARCHAR2(200),
    FLEXNUMBERRANGE24 VARCHAR2(200),
    FLEXNUMBERRANGE25 VARCHAR2(200),
    FLEXNUMBERRANGE26 VARCHAR2(200),
    FLEXNUMBERRANGE27 VARCHAR2(200),
    FLEXNUMBERRANGE28 VARCHAR2(200),
    FLEXNUMBERRANGE29 VARCHAR2(200),
    FLEXNUMBERRANGE30 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_WORKLOAD_FLEX01
 AS SELECT ACTIVITYID, WORKLOADID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_WORKLOAD_FLEX01;

ALTER TABLE E$BPM_CUBE_WORKLOAD_FLEX01
    ADD CONSTRAINT BPM_CUBE_WORKLOAD_FLEX01_PK PRIMARY KEY (ACTIVITYID, WORKLOADID, EXTENSIONID);

-- ----------------------------------------------------------------------- 
-- E$BPM_CUSTOM_APPS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CUSTOM_APPS
(
    APPID NUMBER NOT NULL,
    URI VARCHAR2(1000),
    DISPLAY_NAME VARCHAR2(1000),
    DESCRIPTION VARCHAR2(4000),
    AUTH_IDENTITIES VARCHAR2(4000),
    CATEGORY VARCHAR2(2000),
    SUBCATEGORY VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW BPM_CUSTOM_APPS
 AS SELECT APPID, URI, DISPLAY_NAME, DESCRIPTION, AUTH_IDENTITIES, CATEGORY, SUBCATEGORY FROM E$BPM_CUSTOM_APPS;

ALTER TABLE E$BPM_CUSTOM_APPS
    ADD CONSTRAINT BPM_CUSTOM_APPS_PK PRIMARY KEY (APPID);

-- ----------------------------------------------------------------------- 
-- E$BPM_MEASUREMENT_ACTION_EXCEP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_MEASUREMENT_ACTION_EXCEP
(
    ACTION_EXCEPTION_ID NUMBER NOT NULL,
    ACTION_EXCEPTION_TIMESTAMP TIMESTAMP,
    QUERY_ID NUMBER,
    STATUS VARCHAR2(250),
    ACTION_EXCEPTION_NAME VARCHAR2(1000),
    MESSAGE VARCHAR2(4000),
    ACTION_NAME VARCHAR2(1000),
    CI_PARTITION_DATE TIMESTAMP,
    COMPONENT_INSTANCE_ID VARCHAR2(200),
    COMPOSITE_INSTANCE_ID VARCHAR2(200),
    SYSTEM_STRING1 VARCHAR2(250),
    SYSTEM_STRING2 VARCHAR2(250),
    ECID VARCHAR2(200),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    COMPONENT_TYPE VARCHAR2(100) DEFAULT 'BPMN',
    EVENT_KEY VARCHAR2(100) DEFAULT 'BPMN_DEFAULT_EVENT_KEY',
    LAST_UPDATED TIMESTAMP,
    REPUBLISH_COUNT INTEGER DEFAULT 0,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    COMPOSITE_NAME VARCHAR2(400) DEFAULT 'BPMN_DEFAULT_COMPOSITE',
    EVENT_OBJECT BLOB
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW BPM_MEASUREMENT_ACTION_EXCEPS
 AS SELECT ACTION_EXCEPTION_ID, ACTION_EXCEPTION_TIMESTAMP, QUERY_ID, STATUS, ACTION_EXCEPTION_NAME, MESSAGE, ACTION_NAME, CI_PARTITION_DATE, COMPONENT_INSTANCE_ID, COMPOSITE_INSTANCE_ID, SYSTEM_STRING1, SYSTEM_STRING2, ECID, TENANT_ID, COMPONENT_TYPE, EVENT_KEY, LAST_UPDATED, REPUBLISH_COUNT, FLOW_ID, SCA_PARTITION_ID, COMPOSITE_NAME, EVENT_OBJECT FROM E$BPM_MEASUREMENT_ACTION_EXCEP;

ALTER TABLE E$BPM_MEASUREMENT_ACTION_EXCEP
    ADD CONSTRAINT BPM_MEASUREMENT_TION_EXCEPS_PK PRIMARY KEY (ACTION_EXCEPTION_ID);

CREATE INDEX BPM_MEASURE_ACTION_EXCEPS_N1 ON E$BPM_MEASUREMENT_ACTION_EXCEP
    (ACTION_NAME , COMPONENT_TYPE , EVENT_KEY , QUERY_ID );

CREATE INDEX BPM_MEASURE_ACTION_EXCEPS_N2 ON E$BPM_MEASUREMENT_ACTION_EXCEP
    (ACTION_EXCEPTION_TIMESTAMP );

CREATE INDEX BPM_MEASURE_ACTION_EXCEPS_N3 ON E$BPM_MEASUREMENT_ACTION_EXCEP
    (COMPONENT_INSTANCE_ID );

CREATE INDEX BPM_MEASURE_ACTION_EXCEPS_N4 ON E$BPM_MEASUREMENT_ACTION_EXCEP
    (ECID );

CREATE INDEX BPM_MEASURE_ACTION_EXCEPS_N5 ON E$BPM_MEASUREMENT_ACTION_EXCEP
    (COMPOSITE_NAME );

CREATE INDEX BPM_MEASURE_ACTION_EXCEPS_N6 ON E$BPM_MEASUREMENT_ACTION_EXCEP
    (LAST_UPDATED );

-- ----------------------------------------------------------------------- 
-- E$BPM_MEASUREMENT_ACTION_SEQ 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_MEASUREMENT_ACTION_SEQ
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_MEASUREMENT_ACTION_SEQ
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_MEASUREMENT_ACTION_SEQ;

ALTER TABLE E$BPM_MEASUREMENT_ACTION_SEQ
    ADD CONSTRAINT BPM_MEASUREMENT_ACTION_SEQ_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_MEASUREMENT_ACTIONS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_MEASUREMENT_ACTIONS
(
    ACTION_INVOCATION_ID NUMBER NOT NULL,
    ACTION_NAME VARCHAR2(1000),
    QUERY_ID NUMBER,
    AUDIT_QUERY_TIME TIMESTAMP,
    CI_PARTITION_DATE TIMESTAMP,
    COMPONENT_INSTANCE_ID VARCHAR2(200),
    COMPOSITE_INSTANCE_ID VARCHAR2(200),
    SYSTEM_STRING1 VARCHAR2(250),
    SYSTEM_STRING2 VARCHAR2(250),
    ECID VARCHAR2(200),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    COMPONENT_TYPE VARCHAR2(100) DEFAULT 'BPMN',
    EVENT_KEY VARCHAR2(100) DEFAULT 'BPMN_DEFAULT_EVENT_KEY',
    LAST_UPDATED TIMESTAMP,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (CI_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW BPM_MEASUREMENT_ACTIONS
 AS SELECT ACTION_INVOCATION_ID, ACTION_NAME, QUERY_ID, AUDIT_QUERY_TIME, CI_PARTITION_DATE, COMPONENT_INSTANCE_ID, COMPOSITE_INSTANCE_ID, SYSTEM_STRING1, SYSTEM_STRING2, ECID, TENANT_ID, COMPONENT_TYPE, EVENT_KEY, LAST_UPDATED, FLOW_ID, SCA_PARTITION_ID FROM E$BPM_MEASUREMENT_ACTIONS;

ALTER TABLE E$BPM_MEASUREMENT_ACTIONS
    ADD CONSTRAINT BPM_MEASUREMENT_ACTIONS_PK PRIMARY KEY (ACTION_INVOCATION_ID);

CREATE UNIQUE INDEX BPM_MEASUREMENT_ACTIONS_U1 ON E$BPM_MEASUREMENT_ACTIONS
    (ACTION_NAME , COMPONENT_TYPE , EVENT_KEY , QUERY_ID );

CREATE INDEX BPM_MEASUREMENT_ACTIONS_N1 ON E$BPM_MEASUREMENT_ACTIONS
    (AUDIT_QUERY_TIME );

CREATE INDEX BPM_MEASURE_ACTIONS_N2 ON E$BPM_MEASUREMENT_ACTIONS
    (COMPONENT_INSTANCE_ID );

CREATE INDEX BPM_MEASURE_ACTIONS_N3 ON E$BPM_MEASUREMENT_ACTIONS
    (ECID );

-- ----------------------------------------------------------------------- 
-- E$BPM_PARTNER_SERVICE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PARTNER_SERVICE
(
    PARTNER NUMBER NOT NULL,
    ID NUMBER NOT NULL,
    PROCESS NUMBER NOT NULL,
    PORTTYPE VARCHAR2(400),
    OPERATION VARCHAR2(200),
    ISINITIATING CHAR(1)
);

CREATE OR REPLACE EDITIONING VIEW BPM_PARTNER_SERVICE
 AS SELECT PARTNER, ID, PROCESS, PORTTYPE, OPERATION, ISINITIATING FROM E$BPM_PARTNER_SERVICE;

ALTER TABLE E$BPM_PARTNER_SERVICE
    ADD CONSTRAINT BPM_PARTNER_SERVICE_PK PRIMARY KEY (PARTNER, ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_PROCESS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PROCESS
(
    ID NUMBER NOT NULL,
    COMPONENT INTEGER,
    NAME VARCHAR2(100) NOT NULL,
    APPLICATIONNAME VARCHAR2(100) NOT NULL,
    COMPOSITENAME VARCHAR2(100) NOT NULL,
    REVISION VARCHAR2(50) NOT NULL,
    LABEL VARCHAR2(100) NOT NULL,
    NAMESPACE VARCHAR2(256),
    MDSNAMESPACE VARCHAR2(256),
    MDSOBJECT VARCHAR2(256),
    STATUS INTEGER,
    CREATIONDATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_PROCESS
 AS SELECT ID, COMPONENT, NAME, APPLICATIONNAME, COMPOSITENAME, REVISION, LABEL, NAMESPACE, MDSNAMESPACE, MDSOBJECT, STATUS, CREATIONDATE FROM E$BPM_PROCESS;

ALTER TABLE E$BPM_PROCESS
    ADD CONSTRAINT BPM_PROCESS_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_PROCESS ADD CONSTRAINT BPM_PROCESS_INDX1 UNIQUE
    (APPLICATIONNAME , COMPOSITENAME , REVISION , LABEL , NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_PROCESS_PARTNER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PROCESS_PARTNER
(
    ID NUMBER NOT NULL,
    PROCESS NUMBER NOT NULL,
    NAME VARCHAR2(256),
    LINKTYPE VARCHAR2(400),
    SCOPE NUMBER,
    PARTNERWSDL VARCHAR2(500),
    MYROLE VARCHAR2(200),
    PARTNERROLE VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_PROCESS_PARTNER
 AS SELECT ID, PROCESS, NAME, LINKTYPE, SCOPE, PARTNERWSDL, MYROLE, PARTNERROLE FROM E$BPM_PROCESS_PARTNER;

ALTER TABLE E$BPM_PROCESS_PARTNER
    ADD CONSTRAINT BPM_PROCESS_PARTNER_PK PRIMARY KEY (PROCESS, ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_PROJECTSHAREDATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PROJECTSHAREDATA
(
    ID NUMBER NOT NULL,
    COMPOSITENAME VARCHAR2(500) NOT NULL,
    COMPOSITEREVISION VARCHAR2(50) NOT NULL,
    COMPOSITELABEL VARCHAR2(50) NOT NULL,
    COMPOSITEINSTANCEID VARCHAR2(100) NOT NULL,
    VARIABLENAME VARCHAR2(400) NOT NULL,
    VALUESTRING VARCHAR2(2000),
    VALUENUMBER NUMBER,
    VALUEDATE TIMESTAMP,
    VALUEBLOB BLOB,
    CREATEDTIME TIMESTAMP NOT NULL,
    CREATEDBY VARCHAR2(200) NOT NULL,
    UPDATEDTIME TIMESTAMP NOT NULL,
    UPDATEDBY VARCHAR2(200) NOT NULL,
    UPDATEDVERSION NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_PROJECTSHAREDATA
 AS SELECT ID, COMPOSITENAME, COMPOSITEREVISION, COMPOSITELABEL, COMPOSITEINSTANCEID, VARIABLENAME, VALUESTRING, VALUENUMBER, VALUEDATE, VALUEBLOB, CREATEDTIME, CREATEDBY, UPDATEDTIME, UPDATEDBY, UPDATEDVERSION FROM E$BPM_PROJECTSHAREDATA;

ALTER TABLE E$BPM_PROJECTSHAREDATA
    ADD CONSTRAINT BPM_PROJECTSHAREDATA_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_PROJECTSHAREDATA ADD CONSTRAINT BPM_PROJECTSHAREDATA_INDX1 UNIQUE
    (COMPOSITEINSTANCEID , VARIABLENAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_PROJECTSHAREDATA_SEQ 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PROJECTSHAREDATA_SEQ
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_PROJECTSHAREDATA_SEQ
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_PROJECTSHAREDATA_SEQ;

ALTER TABLE E$BPM_PROJECTSHAREDATA_SEQ
    ADD CONSTRAINT BPM_PROJECTSHAREDATA_SEQ_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_SEQUENCE
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_SEQUENCE;

ALTER TABLE E$BPM_SEQUENCE
    ADD CONSTRAINT BPM_SEQUENCE_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_RT_FLOW_ELEMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_RT_FLOW_ELEMENT
(
    SNAPSHOTID NUMBER NOT NULL,
    FLOWELEMENTID VARCHAR2(100) NOT NULL,
    EXECUTIONS NUMBER NOT NULL,
    EXECUTIONTIMESUM NUMBER NOT NULL,
    EXECUTIONTIMESQRSUM NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_RT_FLOW_ELEMENT
 AS SELECT SNAPSHOTID, FLOWELEMENTID, EXECUTIONS, EXECUTIONTIMESUM, EXECUTIONTIMESQRSUM FROM E$BPM_RT_FLOW_ELEMENT;

ALTER TABLE E$BPM_RT_FLOW_ELEMENT
    ADD CONSTRAINT BPM_RT_FLOW_ELEMENT_PK PRIMARY KEY (SNAPSHOTID, FLOWELEMENTID);

-- ----------------------------------------------------------------------- 
-- E$BPM_RT_INSTANCE_CREATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_RT_INSTANCE_CREATION
(
    SNAPSHOTID NUMBER NOT NULL,
    FLOWELEMENTID VARCHAR2(100) NOT NULL,
    TIMEBETWEENCREATIONSUM NUMBER NOT NULL,
    TIMEBETWEENCREATIONSQRSUM NUMBER NOT NULL,
    SAMPLESIZE NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_RT_INSTANCE_CREATION
 AS SELECT SNAPSHOTID, FLOWELEMENTID, TIMEBETWEENCREATIONSUM, TIMEBETWEENCREATIONSQRSUM, SAMPLESIZE FROM E$BPM_RT_INSTANCE_CREATION;

ALTER TABLE E$BPM_RT_INSTANCE_CREATION
    ADD CONSTRAINT BPM_RT_INSTANCE_CREATION_PK PRIMARY KEY (SNAPSHOTID, FLOWELEMENTID);

-- ----------------------------------------------------------------------- 
-- E$BPM_RT_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_RT_SEQUENCE
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_RT_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_RT_SEQUENCE;

ALTER TABLE E$BPM_RT_SEQUENCE
    ADD CONSTRAINT BPM_RT_SEQUENCE_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_RT_SEQUENCE_FLOW 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_RT_SEQUENCE_FLOW
(
    SNAPSHOTID NUMBER NOT NULL,
    TARGETACTIVITY VARCHAR2(100) NOT NULL,
    SOURCEACTIVITY VARCHAR2(100) NOT NULL,
    ROUTINGS NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_RT_SEQUENCE_FLOW
 AS SELECT SNAPSHOTID, TARGETACTIVITY, SOURCEACTIVITY, ROUTINGS FROM E$BPM_RT_SEQUENCE_FLOW;

ALTER TABLE E$BPM_RT_SEQUENCE_FLOW
    ADD CONSTRAINT BPM_RT_SEQUENCE_FLOW_PK PRIMARY KEY (SNAPSHOTID, TARGETACTIVITY, SOURCEACTIVITY);

-- ----------------------------------------------------------------------- 
-- E$BPM_RT_SNAPSHOT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_RT_SNAPSHOT
(
    SNAPSHOTID NUMBER NOT NULL,
    COMPOSITEDN VARCHAR2(500),
    COMPONENTNAME VARCHAR2(100),
    TIMESTAMP TIMESTAMP,
    TENANTID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW BPM_RT_SNAPSHOT
 AS SELECT SNAPSHOTID, COMPOSITEDN, COMPONENTNAME, TIMESTAMP, TENANTID FROM E$BPM_RT_SNAPSHOT;

ALTER TABLE E$BPM_RT_SNAPSHOT
    ADD CONSTRAINT BPM_RT_SNAPSHOT_PK PRIMARY KEY (SNAPSHOTID);

-- ----------------------------------------------------------------------- 
-- E$AG_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AG_INSTANCE
(
    CIKEY INTEGER NOT NULL,
    DEFINITION_ID VARCHAR2(200),
    ROOT_AG_ID VARCHAR2(100),
    CMPST_ID VARCHAR2(100),
    CREATION_DATE DATE,
    CREATOR VARCHAR2(100),
    TITLE VARCHAR2(500),
    IDENTIFICATION_KEY VARCHAR2(100),
    STATUS VARCHAR2(100),
    COMPLETION_PERCENTAGE INTEGER,
    ERROR_MESSAGE VARCHAR2(1000),
    MILESTONE_STATE BLOB
)
storage
(
    freelists 20
)
lob( MILESTONE_STATE )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 10
)
pctfree 10
pctused 1;

CREATE OR REPLACE EDITIONING VIEW AG_INSTANCE
 AS SELECT CIKEY, DEFINITION_ID, ROOT_AG_ID, CMPST_ID, CREATION_DATE, CREATOR, TITLE, IDENTIFICATION_KEY, STATUS, COMPLETION_PERCENTAGE, ERROR_MESSAGE, MILESTONE_STATE FROM E$AG_INSTANCE;

ALTER TABLE E$AG_INSTANCE
    ADD CONSTRAINT AG_PK PRIMARY KEY (CIKEY);

CREATE INDEX AG_CREATOR ON E$AG_INSTANCE
    (CREATOR );

CREATE INDEX AG_ROOTAGID ON E$AG_INSTANCE
    (ROOT_AG_ID );

CREATE INDEX AG_IDENTIFICATIONKEY ON E$AG_INSTANCE
    (IDENTIFICATION_KEY );

-- ----------------------------------------------------------------------- 
-- E$BPM_PML_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PML_SEQUENCE
(
    seq_name VARCHAR2(100) NOT NULL,
    seq_count NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_PML_SEQUENCE
 AS SELECT seq_name, seq_count FROM E$BPM_PML_SEQUENCE;

ALTER TABLE E$BPM_PML_SEQUENCE
    ADD CONSTRAINT BPM_PML_SEQUENCE_PK PRIMARY KEY (seq_name);

-- ----------------------------------------------------------------------- 
-- E$BPM_PML_HS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PML_HS
(
    AUTHOR VARCHAR2(255) NOT NULL,
    CHANGE_DATE TIMESTAMP NOT NULL,
    PROJECTNAME VARCHAR2(255) NOT NULL,
    METADATA_CHANGE BLOB,
    PROJECTTYPE VARCHAR2(255),
    CHANGES BLOB NOT NULL,
    PROJECT_ZIP BLOB
);

CREATE OR REPLACE EDITIONING VIEW BPM_PML_HS
 AS SELECT AUTHOR, CHANGE_DATE, PROJECTNAME, METADATA_CHANGE, PROJECTTYPE, CHANGES, PROJECT_ZIP FROM E$BPM_PML_HS;

ALTER TABLE E$BPM_PML_HS
    ADD CONSTRAINT BPM_PML_HS_PK PRIMARY KEY (AUTHOR, CHANGE_DATE, PROJECTNAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_PML_HS_ITEM 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PML_HS_ITEM
(
    ID NUMBER(19,0) NOT NULL,
    ARTIFACT VARCHAR2(255),
    ACTION VARCHAR2(255),
    LOGICALNAME VARCHAR2(255)
);

CREATE OR REPLACE EDITIONING VIEW BPM_PML_HS_ITEM
 AS SELECT ID, ARTIFACT, ACTION, LOGICALNAME FROM E$BPM_PML_HS_ITEM;

ALTER TABLE E$BPM_PML_HS_ITEM
    ADD CONSTRAINT BPM_PML_HS_ITEM_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_PML_HS_BPM_PML_HS_ITEM 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PML_HS_BPM_PML_HS_ITEM
(
    AUTHOR VARCHAR2(255) NOT NULL,
    CHANGE_DATE TIMESTAMP NOT NULL,
    PROJECTNAME VARCHAR2(255) NOT NULL,
    changedItems_ID NUMBER(19,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_PML_HS_BPM_PML_HS_ITEM
 AS SELECT AUTHOR, CHANGE_DATE, PROJECTNAME, changedItems_ID FROM E$BPM_PML_HS_BPM_PML_HS_ITEM;

ALTER TABLE E$BPM_PML_HS_BPM_PML_HS_ITEM
    ADD CONSTRAINT BPM_PML_HS_BPM_PML_HS_ITEM_PK PRIMARY KEY (AUTHOR, CHANGE_DATE, PROJECTNAME, changedItems_ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_SEQUENCE
(
    seq_name VARCHAR2(100) NOT NULL,
    seq_count NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SEQUENCE
 AS SELECT seq_name, seq_count FROM E$BPM_BAC_SEQUENCE;

ALTER TABLE E$BPM_BAC_SEQUENCE
    ADD CONSTRAINT BPM_BAC_SEQUENCE_PK PRIMARY KEY (seq_name);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_SESSION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_SESSION
(
    SPACE_PROJECT_ID NVARCHAR2(512) NOT NULL,
    SESSION_FILE NVARCHAR2(1024) NOT NULL,
    FILE_CONTENT BLOB,
    CONTENT_TYPE CHAR(254),
    IS_VIRTUAL NUMBER(1),
    SYNC_TIMESTAMP NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SESSION
 AS SELECT SPACE_PROJECT_ID, SESSION_FILE, FILE_CONTENT, CONTENT_TYPE, IS_VIRTUAL, SYNC_TIMESTAMP FROM E$BPM_BAC_SESSION;

ALTER TABLE E$BPM_BAC_SESSION
    ADD CONSTRAINT BPM_BAC_SESSION_PK PRIMARY KEY (SPACE_PROJECT_ID, SESSION_FILE);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_METADATA_STORE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_METADATA_STORE
(
    METADATA_STORE_KEY VARCHAR2(255) NOT NULL,
    METADATA_STORE_VALUE VARCHAR2(255) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_METADATA_STORE
 AS SELECT METADATA_STORE_KEY, METADATA_STORE_VALUE FROM E$BPM_BAC_METADATA_STORE;

ALTER TABLE E$BPM_BAC_METADATA_STORE
    ADD CONSTRAINT BPM_BAC_METADATA_STORE_PK PRIMARY KEY (METADATA_STORE_KEY);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_REPOSITORY_BACKUP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_REPOSITORY_BACKUP
(
    ID NUMBER NOT NULL,
    REPOSITORY_UUID VARCHAR2(255) NOT NULL,
    REVISION NUMBER NOT NULL,
    ZIP_FILE BLOB NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_REPOSITORY_BACKUP
 AS SELECT ID, REPOSITORY_UUID, REVISION, ZIP_FILE FROM E$BPM_BAC_REPOSITORY_BACKUP;

ALTER TABLE E$BPM_BAC_REPOSITORY_BACKUP
    ADD CONSTRAINT BPM_BAC_REPOSITORY_BACKUP_PK PRIMARY KEY (ID);

CREATE INDEX BPM_BAC_REPOSIT_Y_BACKUP_INDEX ON E$BPM_BAC_REPOSITORY_BACKUP
    (REPOSITORY_UUID , REVISION ASC);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_ASSET 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_ASSET
(
    ID VARCHAR2(255) NOT NULL,
    NAME VARCHAR2(255) NOT NULL,
    TYPE VARCHAR2(255) NOT NULL,
    DESCRIPTION VARCHAR2(4000),
    CREATION_DATE DATE NOT NULL,
    LOCK_DATE DATE,
    SESSION_CHANNEL VARCHAR2(255),
    USER_NAME VARCHAR2(255),
    SPACE_ID VARCHAR2(255) NOT NULL,
    ARTIFACT_CREATOR NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_ASSET
 AS SELECT ID, NAME, TYPE, DESCRIPTION, CREATION_DATE, LOCK_DATE, SESSION_CHANNEL, USER_NAME, SPACE_ID, ARTIFACT_CREATOR FROM E$BPM_BAC_ASSET;

ALTER TABLE E$BPM_BAC_ASSET
    ADD CONSTRAINT BPM_BAC_ASSET_PK PRIMARY KEY (ID);

CREATE INDEX IDX_SPACE_ASSET ON E$BPM_BAC_ASSET
    (SPACE_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_ASSET_GRANT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_ASSET_GRANT
(
    GRANT_ID NUMBER NOT NULL,
    ARTIFACT_ID VARCHAR2(255) NOT NULL,
    ROLE VARCHAR2(255) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_ASSET_GRANT
 AS SELECT GRANT_ID, ARTIFACT_ID, ROLE FROM E$BPM_BAC_ASSET_GRANT;

ALTER TABLE E$BPM_BAC_ASSET_GRANT
    ADD CONSTRAINT BPM_BAC_ASSET_GRANT_PK PRIMARY KEY (GRANT_ID);

ALTER TABLE E$BPM_BAC_ASSET_GRANT ADD CONSTRAINT UNIQUE_ASSET_GRANT UNIQUE
    (ARTIFACT_ID , ROLE );

CREATE INDEX IDX_ASSET_GRANT ON E$BPM_BAC_ASSET_GRANT
    (ARTIFACT_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_ASSET_GRANT_PRINCIPA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_ASSET_GRANT_PRINCIPA
(
    GRANT_ID NUMBER NOT NULL,
    PRINCIPAL_ID NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_ASSET_GRANT_PRINCIPAL
 AS SELECT GRANT_ID, PRINCIPAL_ID FROM E$BPM_BAC_ASSET_GRANT_PRINCIPA;

ALTER TABLE E$BPM_BAC_ASSET_GRANT_PRINCIPA
    ADD CONSTRAINT BPM_BAC_ASSET_G_T_PRINCIPAL_PK PRIMARY KEY (GRANT_ID, PRINCIPAL_ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_PRINCIPAL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_PRINCIPAL
(
    PRINCIPAL_ID NUMBER NOT NULL,
    IS_GROUP NUMBER(1,0) DEFAULT 0 NOT NULL,
    PRINCIPAL_NAME VARCHAR2(255) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_PRINCIPAL
 AS SELECT PRINCIPAL_ID, IS_GROUP, PRINCIPAL_NAME FROM E$BPM_BAC_PRINCIPAL;

ALTER TABLE E$BPM_BAC_PRINCIPAL
    ADD CONSTRAINT BPM_BAC_PRINCIPAL_PK PRIMARY KEY (PRINCIPAL_ID);

ALTER TABLE E$BPM_BAC_PRINCIPAL ADD CONSTRAINT UNIQUE_PRINCIPAL UNIQUE
    (PRINCIPAL_NAME , IS_GROUP );

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_SPACE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_SPACE
(
    ID VARCHAR2(255) NOT NULL,
    NAME VARCHAR2(255) NOT NULL,
    ARTIFACT_CREATOR NUMBER NOT NULL,
    CREATION_DATE DATE NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SPACE
 AS SELECT ID, NAME, ARTIFACT_CREATOR, CREATION_DATE FROM E$BPM_BAC_SPACE;

ALTER TABLE E$BPM_BAC_SPACE
    ADD CONSTRAINT BPM_BAC_SPACE_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_SPACE_GRANT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_SPACE_GRANT
(
    GRANT_ID NUMBER NOT NULL,
    ARTIFACT_ID VARCHAR2(255) NOT NULL,
    ROLE VARCHAR2(255) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SPACE_GRANT
 AS SELECT GRANT_ID, ARTIFACT_ID, ROLE FROM E$BPM_BAC_SPACE_GRANT;

ALTER TABLE E$BPM_BAC_SPACE_GRANT
    ADD CONSTRAINT BPM_BAC_SPACE_GRANT_PK PRIMARY KEY (GRANT_ID);

ALTER TABLE E$BPM_BAC_SPACE_GRANT ADD CONSTRAINT UNIQUE_SPACE_GRANT UNIQUE
    (ARTIFACT_ID , ROLE );

CREATE INDEX IDX_SPACE_GRANT ON E$BPM_BAC_SPACE_GRANT
    (ARTIFACT_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_BAC_SPACE_GRANT_PRINCIPA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BAC_SPACE_GRANT_PRINCIPA
(
    GRANT_ID NUMBER NOT NULL,
    PRINCIPAL_ID NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SPACE_GRANT_PRINCIPAL
 AS SELECT GRANT_ID, PRINCIPAL_ID FROM E$BPM_BAC_SPACE_GRANT_PRINCIPA;

ALTER TABLE E$BPM_BAC_SPACE_GRANT_PRINCIPA
    ADD CONSTRAINT BPM_BAC_SPACE_G_T_PRINCIPAL_PK PRIMARY KEY (GRANT_ID, PRINCIPAL_ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_OPTIMIZATION_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_OPTIMIZATION_DATA
(
    COMPOSITE_DN VARCHAR2(500) NOT NULL,
    COMPONENT_NAME VARCHAR2(100) NOT NULL,
    LAST_UPDATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BPM_OPTIMIZATION_DATA
 AS SELECT COMPOSITE_DN, COMPONENT_NAME, LAST_UPDATE FROM E$BPM_OPTIMIZATION_DATA;

ALTER TABLE E$BPM_OPTIMIZATION_DATA
    ADD CONSTRAINT BPM_OPTIMIZATION_DATA_PK PRIMARY KEY (COMPOSITE_DN, COMPONENT_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_OPT_COMPLETION_DATE_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_OPT_COMPLETION_DATE_DATA
(
    NODE_IDENTIFIER NUMBER NOT NULL,
    COMPOSITE_DN VARCHAR2(500),
    COMPONENT_NAME VARCHAR2(100),
    ACTIVITY_ID VARCHAR2(400) NOT NULL,
    PARENT_NODE_ID NUMBER,
    INSTANCE_TRACES NUMBER,
    MAX_ELAPSED_TIME NUMBER,
    MIN_ELAPSED_TIME NUMBER,
    SUM_ELAPSED_TIME NUMBER,
    SUM_SQR_ELAPSED_TIME NUMBER,
    VARIANCE_ELAPSED_TIME NUMBER,
    ESTIMATED_ELAPSED_TIME NUMBER,
    MAX_TIME_TO_COMPLETION NUMBER,
    MIN_TIME_TO_COMPLETION NUMBER,
    SUM_TIME_TO_COMPLETION NUMBER,
    SUM_SQR_TIME_TO_COMPLETION NUMBER,
    VARIANCE_TIME_TO_COMPLETION NUMBER,
    ESTIMATED_TIME_TO_COMPLETION NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_OPT_COMPLETION_DATE_DATA
 AS SELECT NODE_IDENTIFIER, COMPOSITE_DN, COMPONENT_NAME, ACTIVITY_ID, PARENT_NODE_ID, INSTANCE_TRACES, MAX_ELAPSED_TIME, MIN_ELAPSED_TIME, SUM_ELAPSED_TIME, SUM_SQR_ELAPSED_TIME, VARIANCE_ELAPSED_TIME, ESTIMATED_ELAPSED_TIME, MAX_TIME_TO_COMPLETION, MIN_TIME_TO_COMPLETION, SUM_TIME_TO_COMPLETION, SUM_SQR_TIME_TO_COMPLETION, VARIANCE_TIME_TO_COMPLETION, ESTIMATED_TIME_TO_COMPLETION FROM E$BPM_OPT_COMPLETION_DATE_DATA;

ALTER TABLE E$BPM_OPT_COMPLETION_DATE_DATA
    ADD CONSTRAINT BPM_OPT_COMPLET_N_DATE_DATA_PK PRIMARY KEY (NODE_IDENTIFIER);

-- ----------------------------------------------------------------------- 
-- E$BPM_OPT_DATA_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_OPT_DATA_SEQUENCE
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_OPT_DATA_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_OPT_DATA_SEQUENCE;

ALTER TABLE E$BPM_OPT_DATA_SEQUENCE
    ADD CONSTRAINT BPM_OPT_DATA_SEQUENCE_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_ARCHIVEREQUEST 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_ARCHIVEREQUEST
(
    ID INTEGER NOT NULL,
    STATE INTEGER NOT NULL,
    SCHEDULEDSTARTTIME TIMESTAMP NOT NULL,
    CRONSPEC VARCHAR2(100),
    CREATEROLE VARCHAR2(400) NOT NULL,
    CREATEDBY VARCHAR2(200) NOT NULL,
    CREATEDTIME TIMESTAMP NOT NULL,
    UPDATEDBY VARCHAR2(200),
    UPDATEDTIME TIMESTAMP,
    FAULTREASONSUMMARY VARCHAR2(2000),
    REQUESTDETAIL BLOB,
    SYSTEMSTR01 VARCHAR2(500),
    SYSTEMSTR02 VARCHAR2(500),
    SYSTEMSTR03 VARCHAR2(500)
);

CREATE OR REPLACE EDITIONING VIEW BPM_ARCHIVEREQUEST
 AS SELECT ID, STATE, SCHEDULEDSTARTTIME, CRONSPEC, CREATEROLE, CREATEDBY, CREATEDTIME, UPDATEDBY, UPDATEDTIME, FAULTREASONSUMMARY, REQUESTDETAIL, SYSTEMSTR01, SYSTEMSTR02, SYSTEMSTR03 FROM E$BPM_ARCHIVEREQUEST;

ALTER TABLE E$BPM_ARCHIVEREQUEST
    ADD CONSTRAINT BPM_ARCHIVEREQUEST_PK PRIMARY KEY (ID);

CREATE INDEX BPM_ARCHIVEREQUEST_IDX1 ON E$BPM_ARCHIVEREQUEST
    (CREATEDBY , ID );

CREATE INDEX BPM_ARCHIVEREQUEST_IDX2 ON E$BPM_ARCHIVEREQUEST
    (CREATEROLE , ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_ARCHIVESEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_ARCHIVESEQUENCE
(
    SEQ_NAME VARCHAR2(100) NOT NULL,
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW BPM_ARCHIVESEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_ARCHIVESEQUENCE;

ALTER TABLE E$BPM_ARCHIVESEQUENCE
    ADD CONSTRAINT BPM_ARCHIVESEQUENCE_PK PRIMARY KEY (SEQ_NAME);

-- ----------------------------------------------------------------------- 
-- E$BPM_USER_DRAFT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_USER_DRAFT
(
    ID INTEGER NOT NULL,
    NAME VARCHAR2(2000) NOT NULL,
    TYPE INTEGER NOT NULL,
    CREATEDBY VARCHAR2(400) NOT NULL,
    CREATEDDATE TIMESTAMP NOT NULL,
    UPDATEDDATE TIMESTAMP,
    CONTENT BLOB,
    DESCRIPTION VARCHAR2(4000),
    MIMETYPE VARCHAR2(300) NOT NULL,
    QUERYKEY VARCHAR2(500)
);

CREATE OR REPLACE EDITIONING VIEW BPM_USER_DRAFT
 AS SELECT ID, NAME, TYPE, CREATEDBY, CREATEDDATE, UPDATEDDATE, CONTENT, DESCRIPTION, MIMETYPE, QUERYKEY FROM E$BPM_USER_DRAFT;

ALTER TABLE E$BPM_USER_DRAFT
    ADD CONSTRAINT BPM_USER_DRAFT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$edn_event_error_store 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$edn_event_error_store
(
    msg_id RAW(50),
    namespace VARCHAR2(512),
    local_name VARCHAR2(80),
    target VARCHAR2(1024),
    target_type INTEGER,
    payload CLOB,
    error_code VARCHAR2(50),
    error_type INTEGER,
    error_msg VARCHAR2(2000),
    short_error_msg VARCHAR2(200),
    state INTEGER,
    sidecar VARCHAR2(1024),
    creation_time TIMESTAMP,
    flow_id INTEGER
);

CREATE OR REPLACE EDITIONING VIEW edn_event_error_store
 AS SELECT msg_id, namespace, local_name, target, target_type, payload, error_code, error_type, error_msg, short_error_msg, state, sidecar, creation_time, flow_id FROM E$edn_event_error_store;

CREATE INDEX EDN_EVENT_ERROR_STORE_MSGID ON E$edn_event_error_store
    (msg_id );

-- ----------------------------------------------------------------------- 
-- E$EDN_E2J_MAPPING 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EDN_E2J_MAPPING
(
    NAMESPACE VARCHAR2(256) NOT NULL,
    LOCAL_NAME VARCHAR2(80) NOT NULL,
    TOPIC_NAME VARCHAR2(128) NOT NULL,
    TOPIC_JNDI VARCHAR2(128) NOT NULL,
    JMS_TYPE VARCHAR2(8) NOT NULL,
    CREATION_TIME TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW EDN_E2J_MAPPING
 AS SELECT NAMESPACE, LOCAL_NAME, TOPIC_NAME, TOPIC_JNDI, JMS_TYPE, CREATION_TIME FROM E$EDN_E2J_MAPPING;

ALTER TABLE E$EDN_E2J_MAPPING
    ADD CONSTRAINT EDN_E2J_MAPPING_PK PRIMARY KEY (NAMESPACE, LOCAL_NAME);

-- ----------------------------------------------------------------------- 
-- E$EDN_EVENT_AGENTS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EDN_EVENT_AGENTS
(
    AGENT_ID VARCHAR2(32) NOT NULL,
    AGENT_CALLBACK VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW EDN_EVENT_AGENTS
 AS SELECT AGENT_ID, AGENT_CALLBACK FROM E$EDN_EVENT_AGENTS;

-- ----------------------------------------------------------------------- 
-- E$EDN_EVENT_SUBSCRIPTIONS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EDN_EVENT_SUBSCRIPTIONS
(
    SUB_ID NUMBER NOT NULL,
    AGENT_ID VARCHAR2(32) NOT NULL,
    NAMESPACE VARCHAR2(256),
    LOCAL_NAME VARCHAR2(80),
    SUB_LEVEL CHAR(1) NOT NULL,
    ENABLED CHAR(1) NOT NULL,
    XPATH_FILTER VARCHAR2(512),
    XPATH_NS_MAP VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW EDN_EVENT_SUBSCRIPTIONS
 AS SELECT SUB_ID, AGENT_ID, NAMESPACE, LOCAL_NAME, SUB_LEVEL, ENABLED, XPATH_FILTER, XPATH_NS_MAP FROM E$EDN_EVENT_SUBSCRIPTIONS;

ALTER TABLE E$EDN_EVENT_SUBSCRIPTIONS
    ADD CONSTRAINT EDN_EVENT_SUBSCRIPTIONS_PK PRIMARY KEY (SUB_ID);

-- ----------------------------------------------------------------------- 
-- E$EDN_LOG_ENABLED 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EDN_LOG_ENABLED
(
    ENABLED INTEGER
);

CREATE OR REPLACE EDITIONING VIEW EDN_LOG_ENABLED
 AS SELECT ENABLED FROM E$EDN_LOG_ENABLED;

-- ----------------------------------------------------------------------- 
-- E$EDN_LOG_MESSAGES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EDN_LOG_MESSAGES
(
    MSG_SEQ NUMBER,
    EVENT_SEQ NUMBER,
    MSG CLOB
);

CREATE OR REPLACE EDITIONING VIEW EDN_LOG_MESSAGES
 AS SELECT MSG_SEQ, EVENT_SEQ, MSG FROM E$EDN_LOG_MESSAGES;

-- ----------------------------------------------------------------------- 
-- E$EDN_RETRY_COUNT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$EDN_RETRY_COUNT
(
    MSG_ID RAW(16),
    RETRY_COUNT NUMBER(1)
);

CREATE OR REPLACE EDITIONING VIEW EDN_RETRY_COUNT
 AS SELECT MSG_ID, RETRY_COUNT FROM E$EDN_RETRY_COUNT;

-- ----------------------------------------------------------------------- 
-- E$ATTACHMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$ATTACHMENT
(
    KEY VARCHAR2(200) NOT NULL,
    ATTACHMENT BLOB,
    PROPERTIES VARCHAR2(1000)
)
storage
(
    freelists 20
)
lob( ATTACHMENT )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 10
)
pctfree 10
pctused 1;

CREATE OR REPLACE EDITIONING VIEW ATTACHMENT
 AS SELECT KEY, ATTACHMENT, PROPERTIES FROM E$ATTACHMENT;

ALTER TABLE E$ATTACHMENT
    ADD CONSTRAINT ATT_STORE_PK PRIMARY KEY (KEY);

-- ----------------------------------------------------------------------- 
-- E$SOA_PURGE_LOG 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SOA_PURGE_LOG
(
    LOG_DATE TIMESTAMP,
    PURGE_LOG VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW SOA_PURGE_LOG
 AS SELECT LOG_DATE, PURGE_LOG FROM E$SOA_PURGE_LOG;

-- ----------------------------------------------------------------------- 
-- E$ATTACHMENT_REF 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$ATTACHMENT_REF
(
    KEY VARCHAR2(200),
    CMPST_INST_ID VARCHAR2(200),
    CMPNNT_INST_ID VARCHAR2(200),
    CMPST_DN VARCHAR2(300),
    CMPNNT_NAME VARCHAR2(300),
    CMPNNT_TYPE VARCHAR2(100),
    ECID VARCHAR2(100)
)
;

CREATE OR REPLACE EDITIONING VIEW ATTACHMENT_REF
 AS SELECT KEY, CMPST_INST_ID, CMPNNT_INST_ID, CMPST_DN, CMPNNT_NAME, CMPNNT_TYPE, ECID FROM E$ATTACHMENT_REF;

-- ----------------------------------------------------------------------- 
-- E$BRIDGE_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BRIDGE_INSTANCE
(
    ECID VARCHAR2(100),
    ID INTEGER,
    PARENT_ID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    BRIDGE_NAME VARCHAR2(200),
    BRIDGE_TYPE VARCHAR2(100),
    EVENT_NAME VARCHAR2(500),
    DIRECTION VARCHAR2(10),
    STATE INTEGER,
    ADDITIONAL_PROPERTIES VARCHAR2(4000),
    ERROR_MESSAGE VARCHAR2(1000),
    STACK_TRACE VARCHAR2(4000),
    CREATED_BY VARCHAR2(100),
    CREATED_TIME TIMESTAMP,
    UPDATED_BY VARCHAR2(100),
    UPDATED_TIME TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BRIDGE_INSTANCE
 AS SELECT ECID, ID, PARENT_ID, CONVERSATION_ID, BRIDGE_NAME, BRIDGE_TYPE, EVENT_NAME, DIRECTION, STATE, ADDITIONAL_PROPERTIES, ERROR_MESSAGE, STACK_TRACE, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME FROM E$BRIDGE_INSTANCE;

CREATE INDEX BRIDGE_INSTANCE_ECID ON E$BRIDGE_INSTANCE
    (ECID );

CREATE INDEX BRIDGE_INSTANCE_ID ON E$BRIDGE_INSTANCE
    (ID );

-- ----------------------------------------------------------------------- 
-- E$COMPONENT_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$COMPONENT_INSTANCE
(
    ECID VARCHAR2(100),
    COMPOSITE_INSTANCE_ID VARCHAR2(100),
    ID VARCHAR2(100),
    PARENT_ID VARCHAR2(100),
    COMPONENT_DN VARCHAR2(500),
    COMPONENT_TYPE VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    STATE INTEGER,
    SOURCE_ACTION_TYPE VARCHAR2(10),
    SOURCE_ACTION_NAME VARCHAR2(500),
    ADDITIONAL_PROPERTIES VARCHAR2(2000),
    ERROR_MESSAGE VARCHAR2(1000),
    STACK_TRACE VARCHAR2(4000),
    CPST_PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CREATED_BY VARCHAR2(100),
    CREATED_TIME TIMESTAMP,
    UPDATED_BY VARCHAR2(100),
    UPDATED_TIME TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW COMPONENT_INSTANCE
 AS SELECT ECID, COMPOSITE_INSTANCE_ID, ID, PARENT_ID, COMPONENT_DN, COMPONENT_TYPE, CONVERSATION_ID, STATE, SOURCE_ACTION_TYPE, SOURCE_ACTION_NAME, ADDITIONAL_PROPERTIES, ERROR_MESSAGE, STACK_TRACE, CPST_PARTITION_DATE, TENANT_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME FROM E$COMPONENT_INSTANCE;

CREATE INDEX COMPONENT_INSTANCE_ECID ON E$COMPONENT_INSTANCE
    (ECID );

CREATE INDEX COMPONENT_INSTANCE_ID ON E$COMPONENT_INSTANCE
    (ID );

-- ----------------------------------------------------------------------- 
-- E$COMPOSITE_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$COMPOSITE_INSTANCE
(
    ECID VARCHAR2(100),
    ID INTEGER,
    PARENT_ID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    COMPOSITE_DN VARCHAR2(500),
    SOURCE_NAME VARCHAR2(100),
    SOURCE_TYPE VARCHAR2(200),
    SOURCE_ACTION_TYPE VARCHAR2(10),
    SOURCE_ACTION_NAME VARCHAR2(500),
    BATCH_ID VARCHAR2(100),
    BATCH_INDEX INTEGER,
    BUSINESS_STATUS NVARCHAR2(100),
    INDEX1 VARCHAR2(100),
    INDEX2 VARCHAR2(100),
    INDEX3 VARCHAR2(100),
    INDEX4 VARCHAR2(100),
    INDEX5 VARCHAR2(100),
    INDEX6 VARCHAR2(100),
    TITLE NVARCHAR2(100),
    TAGS VARCHAR2(2000),
    TEST_RUN_NAME VARCHAR2(100),
    TEST_RUN_ID VARCHAR2(100),
    TEST_SUITE VARCHAR2(100),
    TEST_CASE VARCHAR2(100),
    STATE NUMBER(3),
    LIVE_INSTANCES NUMBER(38),
    STATE_COUNT NUMBER,
    HAS_ASSOC CHAR(1),
    VERSION INTEGER,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CREATED_BY VARCHAR2(100),
    CREATED_TIME TIMESTAMP NOT NULL,
    UPDATED_BY VARCHAR2(100),
    UPDATED_TIME TIMESTAMP,
    FLOW_ID INTEGER
);

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_INSTANCE
 AS SELECT ECID, ID, PARENT_ID, CONVERSATION_ID, COMPOSITE_DN, SOURCE_NAME, SOURCE_TYPE, SOURCE_ACTION_TYPE, SOURCE_ACTION_NAME, BATCH_ID, BATCH_INDEX, BUSINESS_STATUS, INDEX1, INDEX2, INDEX3, INDEX4, INDEX5, INDEX6, TITLE, TAGS, TEST_RUN_NAME, TEST_RUN_ID, TEST_SUITE, TEST_CASE, STATE, LIVE_INSTANCES, STATE_COUNT, HAS_ASSOC, VERSION, PARTITION_DATE, TENANT_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, FLOW_ID FROM E$COMPOSITE_INSTANCE;

CREATE INDEX COMPOSITE_INSTANCE_ECID ON E$COMPOSITE_INSTANCE
    (ECID );

CREATE INDEX COMPOSITE_INSTANCE_ID ON E$COMPOSITE_INSTANCE
    (ID );

CREATE INDEX COMPOSITE_INSTANCE_CIDN ON E$COMPOSITE_INSTANCE
    (COMPOSITE_DN , STATE );

CREATE INDEX COMPOSITE_INSTANCE_CO_ID ON E$COMPOSITE_INSTANCE
    (CONVERSATION_ID );

CREATE INDEX COMPOSITE_INSTANCE_STATE ON E$COMPOSITE_INSTANCE
    (STATE );

CREATE INDEX COMPOSITE_INSTANCE_CREATED ON E$COMPOSITE_INSTANCE
    (CREATED_TIME DESC, COMPOSITE_DN , STATE );

-- ----------------------------------------------------------------------- 
-- E$COMPOSITE_INSTANCE_ASSOC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$COMPOSITE_INSTANCE_ASSOC
(
    ASSOC1_ECID VARCHAR2(100) NOT NULL,
    ASSOC1_COMPOSITE_INSTANCE_ID INTEGER NOT NULL,
    ASSOC1_COMPONENT_INSTANCE_ID VARCHAR2(100) NOT NULL,
    ASSOC2_ECID VARCHAR2(100) NOT NULL,
    ASSOC2_COMPOSITE_INSTANCE_ID INTEGER NOT NULL,
    ASSOC2_COMPONENT_INSTANCE_ID VARCHAR2(100) NOT NULL,
    CREATED_TIME TIMESTAMP,
    FLOW_ID INTEGER
);

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_INSTANCE_ASSOC
 AS SELECT ASSOC1_ECID, ASSOC1_COMPOSITE_INSTANCE_ID, ASSOC1_COMPONENT_INSTANCE_ID, ASSOC2_ECID, ASSOC2_COMPOSITE_INSTANCE_ID, ASSOC2_COMPONENT_INSTANCE_ID, CREATED_TIME, FLOW_ID FROM E$COMPOSITE_INSTANCE_ASSOC;

CREATE INDEX COMPOSITE_INSTANCE_ASSOC1_ECID ON E$COMPOSITE_INSTANCE_ASSOC
    (ASSOC1_ECID );

CREATE INDEX COMPOSITE_INSTANCE_ASSOC2_ECID ON E$COMPOSITE_INSTANCE_ASSOC
    (ASSOC2_ECID );

-- ----------------------------------------------------------------------- 
-- E$COMPOSITE_INSTANCE_FAULT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$COMPOSITE_INSTANCE_FAULT
(
    ECID VARCHAR2(100),
    PARENT_ID VARCHAR2(100),
    ID INTEGER,
    COMPOSITE_INSTANCE_ID INTEGER,
    COMPOSITE_DN VARCHAR2(500),
    UNIQUE_ID VARCHAR2(500),
    BATCH_ID VARCHAR2(100),
    CPST_PARTITION_DATE TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CREATED_TIME TIMESTAMP,
    SERVICE_NAME VARCHAR2(200),
    BINDING_TYPE VARCHAR2(100),
    PROTOCOL_MESSAGE_ID VARCHAR2(100),
    PROTOCOL_CORRELATION_ID VARCHAR2(100),
    ERROR_CATEGORY VARCHAR2(100),
    ERROR_CODE VARCHAR2(100),
    ERROR_MESSAGE CLOB,
    STACK_TRACE CLOB,
    RETRY_COUNT INTEGER,
    MESSAGE_ORIGIN_REFERENCE VARCHAR2(200),
    ADDITIONAL_PROPERTIES VARCHAR2(4000)
)
lob( error_message )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
lob( stack_trace )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
storage
(
    freelists 20
);

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_INSTANCE_FAULT
 AS SELECT ECID, PARENT_ID, ID, COMPOSITE_INSTANCE_ID, COMPOSITE_DN, UNIQUE_ID, BATCH_ID, CPST_PARTITION_DATE, TENANT_ID, CREATED_TIME, SERVICE_NAME, BINDING_TYPE, PROTOCOL_MESSAGE_ID, PROTOCOL_CORRELATION_ID, ERROR_CATEGORY, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, RETRY_COUNT, MESSAGE_ORIGIN_REFERENCE, ADDITIONAL_PROPERTIES FROM E$COMPOSITE_INSTANCE_FAULT;

CREATE INDEX COMPOSITE_INSTANCE_FAULT_ECID ON E$COMPOSITE_INSTANCE_FAULT
    (ECID );

CREATE INDEX COMPOSITE_INSTANCE_FAULT_CIDN ON E$COMPOSITE_INSTANCE_FAULT
    (COMPOSITE_DN , ERROR_CATEGORY );

CREATE INDEX COMPOSITE_INSTANCE_FAULT_EC_CT ON E$COMPOSITE_INSTANCE_FAULT
    (ERROR_CATEGORY , CREATED_TIME DESC);

CREATE INDEX COMPOSITE_INSTANCE_FAULT_CT_EC ON E$COMPOSITE_INSTANCE_FAULT
    (CREATED_TIME DESC, ERROR_CATEGORY );

-- ----------------------------------------------------------------------- 
-- E$INSTANCE_PAYLOAD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$INSTANCE_PAYLOAD
(
    INSTANCE_ID INTEGER,
    INSTANCE_TYPE VARCHAR2(50),
    PART_NAME VARCHAR2(250),
    PAYLOAD_TYPE INTEGER,
    PAYLOAD_KEY VARCHAR2(200),
    CREATED_TIME TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW INSTANCE_PAYLOAD
 AS SELECT INSTANCE_ID, INSTANCE_TYPE, PART_NAME, PAYLOAD_TYPE, PAYLOAD_KEY, CREATED_TIME FROM E$INSTANCE_PAYLOAD;

CREATE INDEX INSTANCE_PAYLOAD_KEY ON E$INSTANCE_PAYLOAD
    (INSTANCE_TYPE , INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$REFERENCE_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REFERENCE_INSTANCE
(
    ECID VARCHAR2(100),
    ID INTEGER,
    COMPOSITE_INSTANCE_ID INTEGER,
    PARENT_ID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    COMPOSITE_DN VARCHAR2(500),
    PROTOCOL_CORRELATION_ID VARCHAR2(100),
    REFERENCE_NAME VARCHAR2(200),
    BINDING_TYPE VARCHAR2(200),
    OPERATION_NAME VARCHAR2(500),
    STATE INTEGER,
    ADDITIONAL_PROPERTIES VARCHAR2(4000),
    ERROR_CODE VARCHAR2(100),
    ERROR_MESSAGE CLOB,
    STACK_TRACE CLOB,
    CPST_PARTITION_DATE TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CREATED_BY VARCHAR2(100),
    CREATED_TIME TIMESTAMP NOT NULL,
    UPDATED_BY VARCHAR2(100),
    UPDATED_TIME TIMESTAMP
)
lob( error_message )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
lob( stack_trace )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
storage
(
    freelists 20
);

CREATE OR REPLACE EDITIONING VIEW REFERENCE_INSTANCE
 AS SELECT ECID, ID, COMPOSITE_INSTANCE_ID, PARENT_ID, CONVERSATION_ID, COMPOSITE_DN, PROTOCOL_CORRELATION_ID, REFERENCE_NAME, BINDING_TYPE, OPERATION_NAME, STATE, ADDITIONAL_PROPERTIES, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, CPST_PARTITION_DATE, TENANT_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME FROM E$REFERENCE_INSTANCE;

CREATE INDEX REFERENCE_INSTANCE_ECID ON E$REFERENCE_INSTANCE
    (ECID );

CREATE INDEX REFERENCE_INSTANCE_ID ON E$REFERENCE_INSTANCE
    (ID );

CREATE INDEX REFERENCE_INSTANCE_CO_ID ON E$REFERENCE_INSTANCE
    (PROTOCOL_CORRELATION_ID );

CREATE INDEX REFERENCE_INSTANCE_CDN_STATE ON E$REFERENCE_INSTANCE
    (COMPOSITE_DN , STATE );

CREATE INDEX REFERENCE_INSTANCE_STATE ON E$REFERENCE_INSTANCE
    (STATE );

CREATE INDEX REFERENCE_INSTANCE_TIME_CDN ON E$REFERENCE_INSTANCE
    (CREATED_TIME DESC, COMPOSITE_DN , STATE );

-- ----------------------------------------------------------------------- 
-- E$REJECTED_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REJECTED_MESSAGE
(
    ECID VARCHAR2(100),
    PARENT_ID VARCHAR2(100),
    ID INTEGER,
    COMPOSITE_DN VARCHAR2(500),
    BATCH_ID VARCHAR2(100),
    CREATED_TIME TIMESTAMP,
    SERVICE_NAME VARCHAR2(200),
    BINDING_TYPE VARCHAR2(100),
    PROTOCOL_MESSAGE_ID VARCHAR2(100),
    PROTOCOL_CORRELATION_ID VARCHAR2(100),
    ERROR_CATEGORY VARCHAR2(100),
    ERROR_CODE VARCHAR2(100),
    ERROR_MESSAGE CLOB,
    STACK_TRACE CLOB,
    RETRY_COUNT INTEGER,
    MESSAGE_ORIGIN_REFERENCE VARCHAR2(200),
    ADDITIONAL_PROPERTIES VARCHAR2(4000),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER
)
lob( error_message )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
lob( stack_trace )
store as
(
    chunk 8K
    cache
    pctversion 10
) 
storage
(
    freelists 20
);

CREATE OR REPLACE EDITIONING VIEW REJECTED_MESSAGE
 AS SELECT ECID, PARENT_ID, ID, COMPOSITE_DN, BATCH_ID, CREATED_TIME, SERVICE_NAME, BINDING_TYPE, PROTOCOL_MESSAGE_ID, PROTOCOL_CORRELATION_ID, ERROR_CATEGORY, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, RETRY_COUNT, MESSAGE_ORIGIN_REFERENCE, ADDITIONAL_PROPERTIES, TENANT_ID, FLOW_ID FROM E$REJECTED_MESSAGE;

CREATE INDEX REJECTED_MESSAGE_ECID ON E$REJECTED_MESSAGE
    (ECID );

CREATE INDEX REJECTED_MESSAGE_ID ON E$REJECTED_MESSAGE
    (ID );

CREATE INDEX REJECTED_MESSAGE_CIDN ON E$REJECTED_MESSAGE
    (COMPOSITE_DN , ERROR_CATEGORY );

CREATE INDEX REJECTED_MESSAGE_EC_CT ON E$REJECTED_MESSAGE
    (ERROR_CATEGORY , CREATED_TIME DESC);

CREATE INDEX REJECTED_MESSAGE_CT_EC ON E$REJECTED_MESSAGE
    (CREATED_TIME DESC, ERROR_CATEGORY );

-- ----------------------------------------------------------------------- 
-- E$REJECTED_MSG_NATIVE_PAYLOAD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REJECTED_MSG_NATIVE_PAYLOAD
(
    ID VARCHAR2(200) NOT NULL,
    ENCODING VARCHAR2(100),
    PAYLOAD BLOB,
    RM_PARTITION_DATE TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW REJECTED_MSG_NATIVE_PAYLOAD
 AS SELECT ID, ENCODING, PAYLOAD, RM_PARTITION_DATE, TENANT_ID FROM E$REJECTED_MSG_NATIVE_PAYLOAD;

ALTER TABLE E$REJECTED_MSG_NATIVE_PAYLOAD
    ADD CONSTRAINT REJECTED_MSG_NATIVE_PAYLOAD_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$SENSOR_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SENSOR_SEQUENCE
(
    SEQ_NAME VARCHAR2(100),
    SEQ_COUNT NUMBER
);

CREATE OR REPLACE EDITIONING VIEW SENSOR_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$SENSOR_SEQUENCE;

-- ----------------------------------------------------------------------- 
-- E$SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SEQUENCE
(
    SEQ_NAME VARCHAR2(100),
    SEQ_COUNT INTEGER
);

CREATE OR REPLACE EDITIONING VIEW SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$SEQUENCE;

-- ----------------------------------------------------------------------- 
-- E$TEST_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$TEST_INSTANCE
(
    TEST_RUN_NAME VARCHAR2(100) NOT NULL,
    TEST_RUN_ID VARCHAR2(100) NOT NULL,
    COMPOSITE_ID VARCHAR2(100) DEFAULT '-1' NOT NULL,
    COMPONENT_ID VARCHAR2(100) NOT NULL,
    STATUS VARCHAR2(100) NOT NULL,
    TEST_SUITE VARCHAR2(100) NOT NULL,
    TEST_CASE VARCHAR2(100) NOT NULL,
    OBJECT_NAME VARCHAR2(500) NOT NULL,
    OBJECT_TYPE VARCHAR2(100) NOT NULL,
    CREATION_DATE TIMESTAMP,
    UPDATE_DATE TIMESTAMP,
    VERSION INTEGER,
    FLOW_ID INTEGER DEFAULT -1 NOT NULL,
    SCA_PARTITION_ID INTEGER,
    RESULTS BLOB NOT NULL
)
lob( results )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 70
);

CREATE OR REPLACE EDITIONING VIEW TEST_INSTANCE
 AS SELECT TEST_RUN_NAME, TEST_RUN_ID, COMPOSITE_ID, COMPONENT_ID, STATUS, TEST_SUITE, TEST_CASE, OBJECT_NAME, OBJECT_TYPE, CREATION_DATE, UPDATE_DATE, VERSION, FLOW_ID, SCA_PARTITION_ID, RESULTS FROM E$TEST_INSTANCE;

ALTER TABLE E$TEST_INSTANCE
    ADD CONSTRAINT TEST_INSTANCE_PK PRIMARY KEY (TEST_RUN_ID, COMPOSITE_ID, COMPONENT_ID, FLOW_ID);

-- ----------------------------------------------------------------------- 
-- E$xml_document 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$xml_document
(
    document_id VARCHAR2(200) NOT NULL,
    document BLOB,
    document_binary_format INTEGER,
    document_type INTEGER,
    doc_partition_date TIMESTAMP
)
storage
(
    freelists 20
)
lob( document )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 10
)
pctfree 10
pctused 1
 PARTITION BY RANGE (DOC_PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW xml_document
 AS SELECT document_id, document, document_binary_format, document_type, doc_partition_date FROM E$xml_document;

ALTER TABLE E$xml_document
    ADD CONSTRAINT DOC_STORE_PK PRIMARY KEY (document_id);

-- ----------------------------------------------------------------------- 
-- E$xml_document_ref 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$xml_document_ref
(
    document_id VARCHAR2(200) NOT NULL,
    composite_instance_id VARCHAR2(200) NOT NULL,
    component_instance_id VARCHAR2(200) NOT NULL,
    composite_dn VARCHAR2(300),
    component_name VARCHAR2(500)
);

CREATE OR REPLACE EDITIONING VIEW xml_document_ref
 AS SELECT document_id, composite_instance_id, component_instance_id, composite_dn, component_name FROM E$xml_document_ref;

ALTER TABLE E$xml_document_ref
    ADD CONSTRAINT xml_document_ref_PK PRIMARY KEY (document_id, composite_instance_id, component_instance_id);

-- ----------------------------------------------------------------------- 
-- E$SCA_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_SEQUENCE
(
    RANGE_NAME VARCHAR2(50) NOT NULL,
    NEXT_RANGE NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW SCA_SEQUENCE
 AS SELECT RANGE_NAME, NEXT_RANGE FROM E$SCA_SEQUENCE;

ALTER TABLE E$SCA_SEQUENCE
    ADD CONSTRAINT SCA_SEQUENCE_PK PRIMARY KEY (RANGE_NAME);

-- ----------------------------------------------------------------------- 
-- E$SCA_PARTITION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_PARTITION
(
    ID INTEGER NOT NULL,
    NAME VARCHAR2(50) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW SCA_PARTITION
 AS SELECT ID, NAME FROM E$SCA_PARTITION;

ALTER TABLE E$SCA_PARTITION
    ADD CONSTRAINT SCA_PARTITION_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$SCA_ENTITY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_ENTITY
(
    ID INTEGER NOT NULL,
    SCA_PARTITION_ID INTEGER NOT NULL,
    COMPOSITE VARCHAR2(500) NOT NULL,
    REVISION VARCHAR2(50) NOT NULL,
    LABEL VARCHAR2(500) NOT NULL,
    NAME VARCHAR2(500),
    TYPE VARCHAR2(50) NOT NULL,
    SUB_TYPE VARCHAR2(100),
    STATE VARCHAR2(10),
    PROPERTIES VARCHAR2(4000)
);

CREATE OR REPLACE EDITIONING VIEW SCA_ENTITY
 AS SELECT ID, SCA_PARTITION_ID, COMPOSITE, REVISION, LABEL, NAME, TYPE, SUB_TYPE, STATE, PROPERTIES FROM E$SCA_ENTITY;

ALTER TABLE E$SCA_ENTITY
    ADD CONSTRAINT SCA_ENTITY_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$SCA_FLOW_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_FLOW_INSTANCE
(
    FLOW_ID INTEGER NOT NULL,
    FLOW_CORRELATION_ID VARCHAR2(100),
    ECID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    TITLE NVARCHAR2(100),
    COMPOSITE_SCA_ENTITY_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    ACTIVE_COMPONENT_INSTANCES NUMBER DEFAULT -1,
    UNHANDLED_FAULTS NUMBER DEFAULT -1,
    RECOVERABLE_FAULTS NUMBER DEFAULT -1,
    ADMIN_STATE NUMBER(1,0) DEFAULT -1,
    PURGEABLE VARCHAR2(1) DEFAULT 'U',
    RESEQUENCER NUMBER(1) DEFAULT 0,
    PROPERTIES VARCHAR2(4000),
    CREATED_BY VARCHAR2(100),
    CREATED_TIME TIMESTAMP DEFAULT systimestamp NOT NULL,
    UPDATED_BY VARCHAR2(100),
    UPDATED_TIME TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    TEST_RUN_NAME VARCHAR2(100),
    TEST_RUN_ID VARCHAR2(100),
    TEST_SUITE VARCHAR2(100),
    TEST_CASE VARCHAR2(100),
    VERSION INTEGER DEFAULT 0 NOT NULL
)
 PARTITION BY RANGE (CREATED_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_FLOW_INSTANCE
 AS SELECT FLOW_ID, FLOW_CORRELATION_ID, ECID, CONVERSATION_ID, TITLE, COMPOSITE_SCA_ENTITY_ID, SCA_PARTITION_ID, ACTIVE_COMPONENT_INSTANCES, UNHANDLED_FAULTS, RECOVERABLE_FAULTS, ADMIN_STATE, PURGEABLE, RESEQUENCER, PROPERTIES, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, TENANT_ID, TEST_RUN_NAME, TEST_RUN_ID, TEST_SUITE, TEST_CASE, VERSION FROM E$SCA_FLOW_INSTANCE;

ALTER TABLE E$SCA_FLOW_INSTANCE
    ADD CONSTRAINT SCA_FLOW_INSTANCE_PK PRIMARY KEY (FLOW_ID);

CREATE INDEX FLOW_INST_CORR_ID ON E$SCA_FLOW_INSTANCE
    (FLOW_CORRELATION_ID );

CREATE INDEX FLOW_INSTANCE_CREATED ON E$SCA_FLOW_INSTANCE
    (CREATED_TIME DESC, COMPOSITE_SCA_ENTITY_ID , SCA_PARTITION_ID );

-- ----------------------------------------------------------------------- 
-- E$SCA_FLOW_TO_CPST 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_FLOW_TO_CPST
(
    COMPOSITE_ID NUMBER NOT NULL,
    FLOW_ID INTEGER NOT NULL,
    TITLE NVARCHAR2(100),
    COMPOSITE_SCA_ENTITY_ID INTEGER NOT NULL,
    CREATED_TIME TIMESTAMP DEFAULT systimestamp NOT NULL,
    UPDATED_TIME TIMESTAMP,
    ACTIVE_COMPONENT_INSTANCES NUMBER DEFAULT -1,
    ADMIN_STATE NUMBER(1,0) DEFAULT -1,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    VERSION INTEGER DEFAULT 0 NOT NULL
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_FLOW_TO_CPST
 AS SELECT COMPOSITE_ID, FLOW_ID, TITLE, COMPOSITE_SCA_ENTITY_ID, CREATED_TIME, UPDATED_TIME, ACTIVE_COMPONENT_INSTANCES, ADMIN_STATE, PARTITION_DATE, SCA_PARTITION_ID, TENANT_ID, VERSION FROM E$SCA_FLOW_TO_CPST;

ALTER TABLE E$SCA_FLOW_TO_CPST
    ADD CONSTRAINT SCA_FLOW_TO_CPST_PK PRIMARY KEY (COMPOSITE_ID);

CREATE INDEX FLOW_CPST_INST ON E$SCA_FLOW_TO_CPST
    (FLOW_ID , COMPOSITE_SCA_ENTITY_ID , SCA_PARTITION_ID );

-- ----------------------------------------------------------------------- 
-- E$SCA_ASYNC_CPNT_STATE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_ASYNC_CPNT_STATE
(
    FLOW_ID INTEGER NOT NULL,
    CIKEY NUMBER NOT NULL,
    PARTIAL_EXECUTIONS NUMBER(5,0) NOT NULL,
    STATE INTEGER NOT NULL,
    COMPLETED_EXECUTIONS NUMBER(5,0) DEFAULT 0 NOT NULL,
    VERSION INTEGER DEFAULT 0 NOT NULL,
    COMPOSITE_SCA_ENTITY_ID INTEGER,
    COMPONENT_SCA_ENTITY_ID INTEGER,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_ASYNC_CPNT_STATE
 AS SELECT FLOW_ID, CIKEY, PARTIAL_EXECUTIONS, STATE, COMPLETED_EXECUTIONS, VERSION, COMPOSITE_SCA_ENTITY_ID, COMPONENT_SCA_ENTITY_ID, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_ASYNC_CPNT_STATE;

ALTER TABLE E$SCA_ASYNC_CPNT_STATE
    ADD CONSTRAINT SCA_ASYNC_CPNT_STATE_PK PRIMARY KEY (FLOW_ID, CIKEY);

-- ----------------------------------------------------------------------- 
-- E$SCA_COMMON_FAULT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_COMMON_FAULT
(
    ID NUMBER NOT NULL,
    RETRY_COUNT INTEGER NOT NULL,
    FLOW_ID INTEGER NOT NULL,
    FLOW_CORRELATION_ID VARCHAR2(100),
    BUS_EVENT_ID NUMBER DEFAULT -1,
    COMPONENT_TYPE VARCHAR2(100) NOT NULL,
    COMPONENT_FAULT_KEY VARCHAR2(1000),
    SCA_ENTITY_ID INTEGER,
    COMPOSITE_ID NUMBER,
    COMPOSITE_SCA_ENTITY_ID INTEGER,
    CIKEY NUMBER,
    OWNER_CIKEY NUMBER,
    OWNER_SCA_ENTITY_ID INTEGER,
    OWNER_COMPONENT_TYPE VARCHAR2(100),
    OWNER_COMPOSITE_SCA_ENTITY_ID INTEGER,
    FAULT_NAME VARCHAR2(255),
    FAULT_TYPE VARCHAR2(255),
    JNDI_LOCATION VARCHAR2(255),
    TARGET_HOST VARCHAR2(255),
    WORKLIST_ROLE VARCHAR2(255),
    ERROR_CODE VARCHAR2(100),
    ERROR_MESSAGE CLOB,
    ENRICHED_MESSAGE CLOB,
    EXCEPTION_TRACE CLOB,
    ADDITIONAL_PROPERTIES VARCHAR2(4000),
    STATE INTEGER,
    FLEX_FIELD_1 VARCHAR2(100),
    FLEX_FIELD_2 VARCHAR2(100),
    FLEX_FIELD_3 VARCHAR2(100),
    FLEX_FIELD_4 VARCHAR2(100),
    FLEX_FIELD_5 VARCHAR2(100),
    FLEX_FIELD_6 VARCHAR2(100),
    NATIVE_ID INTEGER,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CREATION_DATE TIMESTAMP DEFAULT systimestamp,
    MODIFY_DATE TIMESTAMP,
    STATE_CHANGE_DATE TIMESTAMP,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER,
    OWNER_SCA_PARTITION_ID INTEGER,
    VERSION INTEGER DEFAULT 0 NOT NULL,
    EVENT_NAME VARCHAR2(80),
    SRM_NAMESPACE VARCHAR2(512),
    INTERNAL_ID VARCHAR2(512),
    RES_SCA_ENTITY_ID INTEGER DEFAULT -1,
    LOCATION VARCHAR2(100),
    FLOW_CODE VARCHAR2(50),
    FLOW_VERSION VARCHAR2(15),
    RES_OPERATION_NAME VARCHAR2(500),
    RES_EVENT_SUB_ID VARCHAR2(30)
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_COMMON_FAULT
 AS SELECT ID, RETRY_COUNT, FLOW_ID, FLOW_CORRELATION_ID, BUS_EVENT_ID, COMPONENT_TYPE, COMPONENT_FAULT_KEY, SCA_ENTITY_ID, COMPOSITE_ID, COMPOSITE_SCA_ENTITY_ID, CIKEY, OWNER_CIKEY, OWNER_SCA_ENTITY_ID, OWNER_COMPONENT_TYPE, OWNER_COMPOSITE_SCA_ENTITY_ID, FAULT_NAME, FAULT_TYPE, JNDI_LOCATION, TARGET_HOST, WORKLIST_ROLE, ERROR_CODE, ERROR_MESSAGE, ENRICHED_MESSAGE, EXCEPTION_TRACE, ADDITIONAL_PROPERTIES, STATE, FLEX_FIELD_1, FLEX_FIELD_2, FLEX_FIELD_3, FLEX_FIELD_4, FLEX_FIELD_5, FLEX_FIELD_6, NATIVE_ID, TENANT_ID, CREATION_DATE, MODIFY_DATE, STATE_CHANGE_DATE, PARTITION_DATE, SCA_PARTITION_ID, OWNER_SCA_PARTITION_ID, VERSION, EVENT_NAME, SRM_NAMESPACE, INTERNAL_ID, RES_SCA_ENTITY_ID, LOCATION, FLOW_CODE, FLOW_VERSION, RES_OPERATION_NAME, RES_EVENT_SUB_ID FROM E$SCA_COMMON_FAULT;

ALTER TABLE E$SCA_COMMON_FAULT
    ADD CONSTRAINT SCA_COMMON_FAULT_PK PRIMARY KEY (ID, RETRY_COUNT);

CREATE INDEX COMMON_FAULT_CREATED ON E$SCA_COMMON_FAULT
    (CREATION_DATE DESC, FLOW_ID , SCA_ENTITY_ID , COMPOSITE_SCA_ENTITY_ID , OWNER_SCA_ENTITY_ID , SCA_PARTITION_ID );

CREATE INDEX COMMON_FAULT_FLOWID ON E$SCA_COMMON_FAULT
    (FLOW_ID );

CREATE INDEX REP_CDATE_EP_TGT_ST_FC ON E$SCA_COMMON_FAULT
    (CREATION_DATE DESC, LOCATION , TARGET_HOST , STATE , FLOW_ID );

CREATE INDEX REP_CDATE_FCD_VER_ST_FC ON E$SCA_COMMON_FAULT
    (CREATION_DATE DESC, FLOW_CODE , FLOW_VERSION , STATE , FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$SCA_FLOW_ASSOC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_FLOW_ASSOC
(
    OWNER_FLOW_ID INTEGER NOT NULL,
    CORRELATED_FLOW_ID INTEGER NOT NULL,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_FLOW_ASSOC
 AS SELECT OWNER_FLOW_ID, CORRELATED_FLOW_ID, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_FLOW_ASSOC;

CREATE INDEX SCA_FLOW_ASSOC_OWNER_FLOW_ID ON E$SCA_FLOW_ASSOC
    (OWNER_FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$SCA_META_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_META_DATA
(
    FLOW_ID INTEGER NOT NULL,
    INTERNAL_ID VARCHAR2(200) NOT NULL,
    CIKEY NUMBER,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER,
    DATA_CATEGORY NUMBER(3,0) DEFAULT 0 NOT NULL,
    META_DATA BLOB NOT NULL
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_META_DATA
 AS SELECT FLOW_ID, INTERNAL_ID, CIKEY, PARTITION_DATE, SCA_PARTITION_ID, DATA_CATEGORY, META_DATA FROM E$SCA_META_DATA;

ALTER TABLE E$SCA_META_DATA
    ADD CONSTRAINT SCA_META_DATA_PK PRIMARY KEY (FLOW_ID, INTERNAL_ID);

-- ----------------------------------------------------------------------- 
-- E$FAULT_NOTIFICATION_RULE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$FAULT_NOTIFICATION_RULE
(
    RULEID INTEGER NOT NULL,
    RULE_NAME VARCHAR2(100) NOT NULL,
    FAULT_RULE CLOB,
    RULE_SUBSCRIPTION CLOB,
    RULE_DESCRIPTION VARCHAR2(200),
    SCA_PARTITION_ID INTEGER,
    RULE_PAUSED CHAR(1),
    THRESHOLD_COUNT INTEGER,
    THRESHOLD_DURATION_IN_HRS INTEGER,
    SCHEDULE_PKG_NAME VARCHAR2(100),
    SCHEDULE_NAME VARCHAR2(100),
    CREATION_DATE TIMESTAMP DEFAULT systimestamp,
    MODIFY_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW FAULT_NOTIFICATION_RULE
 AS SELECT RULEID, RULE_NAME, FAULT_RULE, RULE_SUBSCRIPTION, RULE_DESCRIPTION, SCA_PARTITION_ID, RULE_PAUSED, THRESHOLD_COUNT, THRESHOLD_DURATION_IN_HRS, SCHEDULE_PKG_NAME, SCHEDULE_NAME, CREATION_DATE, MODIFY_DATE FROM E$FAULT_NOTIFICATION_RULE;

ALTER TABLE E$FAULT_NOTIFICATION_RULE
    ADD CONSTRAINT FAULT_NOTIFICATION_RULE_PK PRIMARY KEY (RULEID);

-- ----------------------------------------------------------------------- 
-- E$FAULT_ALERT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$FAULT_ALERT
(
    RULEID INTEGER NOT NULL,
    RULE_NAME VARCHAR2(100) NOT NULL,
    FAULT_COUNT INTEGER,
    SCA_PARTITION_ID INTEGER,
    CREATION_DATE TIMESTAMP NOT NULL,
    QUERY_URL VARCHAR2(500)
);

CREATE OR REPLACE EDITIONING VIEW FAULT_ALERT
 AS SELECT RULEID, RULE_NAME, FAULT_COUNT, SCA_PARTITION_ID, CREATION_DATE, QUERY_URL FROM E$FAULT_ALERT;

ALTER TABLE E$FAULT_ALERT
    ADD CONSTRAINT FAULT_ALERT_PK PRIMARY KEY (RULEID, CREATION_DATE);

-- ----------------------------------------------------------------------- 
-- E$BULK_RECOVERY_JOB 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BULK_RECOVERY_JOB
(
    JOB_ID INTEGER NOT NULL,
    ESS_PARENT_ID INTEGER,
    DESCRIPTION VARCHAR2(200),
    SUCCEEDED_COUNT INTEGER,
    FAILED_COUNT INTEGER,
    TOTAL_COUNT INTEGER,
    STATE INTEGER,
    QUERY_URL VARCHAR2(1000),
    SCA_PARTITION_ID INTEGER,
    START_DATE TIMESTAMP,
    CREATION_DATE TIMESTAMP DEFAULT systimestamp,
    MODIFIED_DATE TIMESTAMP,
    LAST_PROCESSED_INSTANCE_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW BULK_RECOVERY_JOB
 AS SELECT JOB_ID, ESS_PARENT_ID, DESCRIPTION, SUCCEEDED_COUNT, FAILED_COUNT, TOTAL_COUNT, STATE, QUERY_URL, SCA_PARTITION_ID, START_DATE, CREATION_DATE, MODIFIED_DATE, LAST_PROCESSED_INSTANCE_DATE FROM E$BULK_RECOVERY_JOB;

ALTER TABLE E$BULK_RECOVERY_JOB
    ADD CONSTRAINT BULK_RECOVERY_JOB_PK PRIMARY KEY (JOB_ID);

-- ----------------------------------------------------------------------- 
-- E$SCA_REJECTED_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_REJECTED_MESSAGE
(
    ECID VARCHAR2(100),
    SRM_ID NUMBER NOT NULL,
    FLOW_ID INTEGER NOT NULL,
    BATCH_ID VARCHAR2(100),
    CREATED_TIME TIMESTAMP,
    SERVICE_NAME VARCHAR2(200),
    BINDING_TYPE VARCHAR2(100),
    PROTOCOL_MESSAGE_ID VARCHAR2(100),
    PROTOCOL_CORRELATION_ID VARCHAR2(100),
    ERROR_CATEGORY VARCHAR2(100),
    ERROR_CODE VARCHAR2(100),
    ERROR_MESSAGE CLOB,
    STACK_TRACE CLOB,
    RETRY_COUNT INTEGER,
    MESSAGE_ORIGIN_REFERENCE VARCHAR2(200),
    ADDITIONAL_PROPERTIES VARCHAR2(4000),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    NAMESPACE VARCHAR2(512),
    LOCAL_NAME VARCHAR2(80),
    SRM_EDN_TARGET VARCHAR2(1024),
    SRM_STATE NUMBER,
    MSG_ENCODING VARCHAR2(100),
    MSG_PAYLOAD BLOB,
    PAYLOAD_TYPE INTEGER,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER,
    TRACKING_CONTEXT_PROPERTIES BLOB,
    RESUBMIT_PORT_TYPE VARCHAR2(200),
    RESUBMIT_OP VARCHAR2(200),
    SRM_VERSION NUMBER,
    ISXA INTEGER,
    UPGRADED NUMBER(1) DEFAULT 0
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_REJECTED_MESSAGE
 AS SELECT ECID, SRM_ID, FLOW_ID, BATCH_ID, CREATED_TIME, SERVICE_NAME, BINDING_TYPE, PROTOCOL_MESSAGE_ID, PROTOCOL_CORRELATION_ID, ERROR_CATEGORY, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, RETRY_COUNT, MESSAGE_ORIGIN_REFERENCE, ADDITIONAL_PROPERTIES, TENANT_ID, NAMESPACE, LOCAL_NAME, SRM_EDN_TARGET, SRM_STATE, MSG_ENCODING, MSG_PAYLOAD, PAYLOAD_TYPE, PARTITION_DATE, SCA_PARTITION_ID, TRACKING_CONTEXT_PROPERTIES, RESUBMIT_PORT_TYPE, RESUBMIT_OP, SRM_VERSION, ISXA, UPGRADED FROM E$SCA_REJECTED_MESSAGE;

ALTER TABLE E$SCA_REJECTED_MESSAGE
    ADD CONSTRAINT SCA_REJECTED_MESSAGE_PK PRIMARY KEY (SRM_ID);

CREATE INDEX SRM_FLOW_INSTANCE_IDX ON E$SCA_REJECTED_MESSAGE
    (FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$SCA_ATTACHMENT_REF 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_ATTACHMENT_REF
(
    SCA_ATT_KEY VARCHAR2(200) NOT NULL,
    FLOW_ID INTEGER,
    CMPNNT_INST_ID NUMBER,
    SCA_ENTITY_ID INTEGER,
    COMPOSITE_SCA_ENTITY_ID INTEGER,
    ECID VARCHAR2(100),
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_ATTACHMENT_REF
 AS SELECT SCA_ATT_KEY, FLOW_ID, CMPNNT_INST_ID, SCA_ENTITY_ID, COMPOSITE_SCA_ENTITY_ID, ECID, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_ATTACHMENT_REF;

-- ----------------------------------------------------------------------- 
-- E$UPGRADE_CURRENT_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$UPGRADE_CURRENT_SEQUENCE
(
    RANGE_NAME VARCHAR2(50) NOT NULL,
    CURRENT_RANGE_LOWER NUMBER NOT NULL,
    CURRENT_RANGE_UPPER NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW UPGRADE_CURRENT_SEQUENCE
 AS SELECT RANGE_NAME, CURRENT_RANGE_LOWER, CURRENT_RANGE_UPPER FROM E$UPGRADE_CURRENT_SEQUENCE;

ALTER TABLE E$UPGRADE_CURRENT_SEQUENCE
    ADD CONSTRAINT UPGRADE_CURRENT_SEQUENCE_PK PRIMARY KEY (RANGE_NAME);

-- ----------------------------------------------------------------------- 
-- E$RESLNCY_FAILURE_EP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RESLNCY_FAILURE_EP
(
    SCA_ENTITY_ID INTEGER NOT NULL,
    FAULT_RATE NUMBER(5) NOT NULL,
    FAULT_WINDOW INTEGER NOT NULL,
    HSTRY_EP_ID VARCHAR2(36)
);

CREATE OR REPLACE EDITIONING VIEW RESLNCY_FAILURE_EP
 AS SELECT SCA_ENTITY_ID, FAULT_RATE, FAULT_WINDOW, HSTRY_EP_ID FROM E$RESLNCY_FAILURE_EP;

ALTER TABLE E$RESLNCY_FAILURE_EP
    ADD CONSTRAINT RESLNCY_FAILURE_EP_PK PRIMARY KEY (SCA_ENTITY_ID);

-- ----------------------------------------------------------------------- 
-- E$RESLNCY_SUSPEND_SVC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RESLNCY_SUSPEND_SVC
(
    SCA_ENTITY_ID INTEGER NOT NULL,
    OPERATION_NAME VARCHAR2(500) NOT NULL,
    EVENT_SUB_ID VARCHAR2(30) NOT NULL,
    EP_ENTITY_ID INTEGER NOT NULL,
    SERVICE_TYPE VARCHAR2(50) NOT NULL,
    RETRY_INTERVAL INTEGER NOT NULL,
    SUSPEND_TIME TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW RESLNCY_SUSPEND_SVC
 AS SELECT SCA_ENTITY_ID, OPERATION_NAME, EVENT_SUB_ID, EP_ENTITY_ID, SERVICE_TYPE, RETRY_INTERVAL, SUSPEND_TIME FROM E$RESLNCY_SUSPEND_SVC;

ALTER TABLE E$RESLNCY_SUSPEND_SVC
    ADD CONSTRAINT RESLNCY_SUSPEND_SVC_PK PRIMARY KEY (SCA_ENTITY_ID, OPERATION_NAME, EVENT_SUB_ID);

-- ----------------------------------------------------------------------- 
-- E$RESLNCY_SUSPEND_SVC_HSTRY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RESLNCY_SUSPEND_SVC_HSTRY
(
    SCA_ENTITY_ID INTEGER NOT NULL,
    OPERATION_NAME VARCHAR2(500) NOT NULL,
    EVENT_SUB_ID VARCHAR2(30) NOT NULL,
    STATE VARCHAR2(20) NOT NULL,
    CREATION_DATE TIMESTAMP NOT NULL,
    EP_ID VARCHAR2(36),
    SCA_EP_ENTITY_ID INTEGER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW RESLNCY_SUSPEND_SVC_HSTRY
 AS SELECT SCA_ENTITY_ID, OPERATION_NAME, EVENT_SUB_ID, STATE, CREATION_DATE, EP_ID, SCA_EP_ENTITY_ID FROM E$RESLNCY_SUSPEND_SVC_HSTRY;

-- ----------------------------------------------------------------------- 
-- E$RESLNCY_FAILURE_EP_HSTRY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RESLNCY_FAILURE_EP_HSTRY
(
    ID VARCHAR2(36) NOT NULL,
    SCA_ENTITY_ID INTEGER NOT NULL,
    STATE VARCHAR2(20) NOT NULL,
    CREATION_DATE TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW RESLNCY_FAILURE_EP_HSTRY
 AS SELECT ID, SCA_ENTITY_ID, STATE, CREATION_DATE FROM E$RESLNCY_FAILURE_EP_HSTRY;

ALTER TABLE E$RESLNCY_FAILURE_EP_HSTRY
    ADD CONSTRAINT RESLNCY_FAILURE_EP_HSTRY_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$RESLNCY_CONFIG 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RESLNCY_CONFIG
(
    PROP_NAME VARCHAR2(100),
    PROP_VALUE VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW RESLNCY_CONFIG
 AS SELECT PROP_NAME, PROP_VALUE FROM E$RESLNCY_CONFIG;

-- ----------------------------------------------------------------------- 
-- E$AWR_SERVER_NODE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_SERVER_NODE
(
    ID VARCHAR2(40) NOT NULL,
    SOA_SERVER_NAME VARCHAR2(100),
    CLUSTER_ID VARCHAR2(100),
    DOMAIN VARCHAR2(100),
    PLATFORM VARCHAR2(30),
    SOA_HOST VARCHAR2(100),
    SOA_CPU VARCHAR2(30),
    SOA_CORE VARCHAR2(30),
    SOA_SOCKETS VARCHAR2(30),
    DB_SERVER_NAME VARCHAR2(100),
    DB_PLATFORM VARCHAR2(30),
    DB_HOST VARCHAR2(100),
    DB_CPU VARCHAR2(30),
    DB_CORE VARCHAR2(30),
    DB_SOCKETS VARCHAR2(30)
);

CREATE OR REPLACE EDITIONING VIEW AWR_SERVER_NODE
 AS SELECT ID, SOA_SERVER_NAME, CLUSTER_ID, DOMAIN, PLATFORM, SOA_HOST, SOA_CPU, SOA_CORE, SOA_SOCKETS, DB_SERVER_NAME, DB_PLATFORM, DB_HOST, DB_CPU, DB_CORE, DB_SOCKETS FROM E$AWR_SERVER_NODE;

ALTER TABLE E$AWR_SERVER_NODE
    ADD CONSTRAINT AWR_SERVER_NODE_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_CONFIGURATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_CONFIGURATION
(
    CONFIG_ID VARCHAR2(100) NOT NULL,
    NODE_ID VARCHAR2(40) NOT NULL,
    RUNTIME_TYPE VARCHAR2(20) NOT NULL,
    COMPONENT_TYPE VARCHAR2(40) NOT NULL,
    UPDATED_TIME TIMESTAMP NOT NULL,
    VALUE1 VARCHAR2(100),
    VALUE2 VARCHAR2(100),
    VALUE3 VARCHAR2(100),
    VALUE4 VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW AWR_CONFIGURATION
 AS SELECT CONFIG_ID, NODE_ID, RUNTIME_TYPE, COMPONENT_TYPE, UPDATED_TIME, VALUE1, VALUE2, VALUE3, VALUE4 FROM E$AWR_CONFIGURATION;

-- ----------------------------------------------------------------------- 
-- E$AWR_COMPOSITE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_COMPOSITE
(
    ID VARCHAR2(40) NOT NULL,
    NAME VARCHAR2(500),
    REVISION VARCHAR2(50),
    LABEL VARCHAR2(50),
    PARTITION VARCHAR2(300)
);

CREATE OR REPLACE EDITIONING VIEW AWR_COMPOSITE
 AS SELECT ID, NAME, REVISION, LABEL, PARTITION FROM E$AWR_COMPOSITE;

ALTER TABLE E$AWR_COMPOSITE
    ADD CONSTRAINT AWR_COMPOSITE_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_COMPONENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_COMPONENT
(
    ID VARCHAR2(40) NOT NULL,
    COMPOSITE_ID VARCHAR2(40) NOT NULL,
    NAME VARCHAR2(500),
    IMPLEMENTATION VARCHAR2(20),
    BACKLOG_TYPE VARCHAR2(20)
);

CREATE OR REPLACE EDITIONING VIEW AWR_COMPONENT
 AS SELECT ID, COMPOSITE_ID, NAME, IMPLEMENTATION, BACKLOG_TYPE FROM E$AWR_COMPONENT;

ALTER TABLE E$AWR_COMPONENT
    ADD CONSTRAINT AWR_COMPONENT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_ENDPOINT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_ENDPOINT
(
    ID VARCHAR2(40) NOT NULL,
    COMPOSITE_ID VARCHAR2(40) NOT NULL,
    TYPE VARCHAR2(50),
    WIRE_TYPE VARCHAR2(50),
    NAME VARCHAR2(500),
    IMPLEMENTATION VARCHAR2(20)
);

CREATE OR REPLACE EDITIONING VIEW AWR_ENDPOINT
 AS SELECT ID, COMPOSITE_ID, TYPE, WIRE_TYPE, NAME, IMPLEMENTATION FROM E$AWR_ENDPOINT;

ALTER TABLE E$AWR_ENDPOINT
    ADD CONSTRAINT AWR_ENDPOINT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_ACTIVITY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_ACTIVITY
(
    ID VARCHAR2(40) NOT NULL,
    COMPOSITE_ELEMENT_ID VARCHAR2(40) NOT NULL,
    TYPE VARCHAR2(50),
    NAME VARCHAR2(500),
    LINE_NUM INTEGER,
    ACTIVITY_LEVEL INTEGER
);

CREATE OR REPLACE EDITIONING VIEW AWR_ACTIVITY
 AS SELECT ID, COMPOSITE_ELEMENT_ID, TYPE, NAME, LINE_NUM, ACTIVITY_LEVEL FROM E$AWR_ACTIVITY;

ALTER TABLE E$AWR_ACTIVITY
    ADD CONSTRAINT AWR_ACTIVITY_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_SYSTEM_RESOURCES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_SYSTEM_RESOURCES
(
    ID VARCHAR2(40) NOT NULL,
    NAME VARCHAR2(300) NOT NULL,
    TYPE VARCHAR2(20)
);

CREATE OR REPLACE EDITIONING VIEW AWR_SYSTEM_RESOURCES
 AS SELECT ID, NAME, TYPE FROM E$AWR_SYSTEM_RESOURCES;

-- ----------------------------------------------------------------------- 
-- E$AWR_SNAPSHOT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_SNAPSHOT
(
    ID INTEGER NOT NULL,
    NODE_ID VARCHAR2(40) NOT NULL,
    TIMESTAMP TIMESTAMP,
    STATISTICS_LEVEL INTEGER,
    SERVER_INSTANCE_ID VARCHAR2(40)
);

CREATE OR REPLACE EDITIONING VIEW AWR_SNAPSHOT
 AS SELECT ID, NODE_ID, TIMESTAMP, STATISTICS_LEVEL, SERVER_INSTANCE_ID FROM E$AWR_SNAPSHOT;

ALTER TABLE E$AWR_SNAPSHOT
    ADD CONSTRAINT AWR_SNAPSHOT_PK PRIMARY KEY (ID, NODE_ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_RESOURCE_UTIL_METRIC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_RESOURCE_UTIL_METRIC
(
    SNAPSHOT_ID INTEGER NOT NULL,
    NODE_ID VARCHAR2(40) NOT NULL,
    RESOURCE_ID VARCHAR2(40) NOT NULL,
    COUNT_CUMM INTEGER,
    VALUE1_MIN INTEGER,
    VALUE1_MAX INTEGER,
    VALUE1_CUMM INTEGER,
    VALUE1_SQ_CUMM INTEGER,
    VALUE2_MIN INTEGER,
    VALUE2_MAX INTEGER,
    VALUE2_CUMM INTEGER,
    VALUE2_SQ_CUMM INTEGER
);

CREATE OR REPLACE EDITIONING VIEW AWR_RESOURCE_UTIL_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, RESOURCE_ID, COUNT_CUMM, VALUE1_MIN, VALUE1_MAX, VALUE1_CUMM, VALUE1_SQ_CUMM, VALUE2_MIN, VALUE2_MAX, VALUE2_CUMM, VALUE2_SQ_CUMM FROM E$AWR_RESOURCE_UTIL_METRIC;

ALTER TABLE E$AWR_RESOURCE_UTIL_METRIC
    ADD CONSTRAINT AWR_RESOURCE_UTIL_METRIC_PK PRIMARY KEY (SNAPSHOT_ID, NODE_ID, RESOURCE_ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_FLOW_METRIC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_FLOW_METRIC
(
    SNAPSHOT_ID INTEGER NOT NULL,
    NODE_ID VARCHAR2(40) NOT NULL,
    ENDPOINT_ID VARCHAR2(40) NOT NULL,
    COUNT_CUMM INTEGER,
    LATENCY_MIN INTEGER,
    LATENCY_MAX INTEGER,
    LATENCY_CUMM INTEGER,
    LATENCY_SQ_CUMM INTEGER,
    FAULT_COUNT_CUMM INTEGER,
    RUNNING_TIME_CUMM DOUBLE PRECISION
);

CREATE OR REPLACE EDITIONING VIEW AWR_FLOW_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, ENDPOINT_ID, COUNT_CUMM, LATENCY_MIN, LATENCY_MAX, LATENCY_CUMM, LATENCY_SQ_CUMM, FAULT_COUNT_CUMM, RUNNING_TIME_CUMM FROM E$AWR_FLOW_METRIC;

ALTER TABLE E$AWR_FLOW_METRIC
    ADD CONSTRAINT AWR_FLOW_METRIC_PK PRIMARY KEY (SNAPSHOT_ID, NODE_ID, ENDPOINT_ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_EXECUTION_METRIC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_EXECUTION_METRIC
(
    SNAPSHOT_ID INTEGER NOT NULL,
    NODE_ID VARCHAR2(40) NOT NULL,
    COMPOSITE_ELEMENT_ID VARCHAR2(40) NOT NULL,
    START_COUNT_CUMM INTEGER,
    DEHYDRATED_COUNT_CUMM INTEGER,
    REHYDRATED_COUNT_CUMM INTEGER,
    COMPLETED_COUNT_CUMM INTEGER,
    FAULTED_COUNT_CUMM INTEGER,
    EXEC_TIME_MIN DOUBLE PRECISION,
    EXEC_TIME_MAX DOUBLE PRECISION,
    EXEC_TIME_CUMM DOUBLE PRECISION,
    EXEC_TIME_SQ_CUMM DOUBLE PRECISION,
    DEHYDRATED_TIME_MIN DOUBLE PRECISION,
    DEHYDRATED_TIME_MAX DOUBLE PRECISION,
    DEHYDRATED_TIME_CUMM DOUBLE PRECISION,
    DEHYDRATED_TIME_SQ_CUMM DOUBLE PRECISION,
    CALLBACK_PROCESSING_TIME_MIN DOUBLE PRECISION,
    CALLBACK_PROCESSING_TIME_MAX DOUBLE PRECISION,
    CALLBACK_PROCESSING_TIME_CUMM DOUBLE PRECISION,
    CALLBACK_PROCESS_TIME_SQ_CUMM DOUBLE PRECISION
);

CREATE OR REPLACE EDITIONING VIEW AWR_EXECUTION_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, COMPOSITE_ELEMENT_ID, START_COUNT_CUMM, DEHYDRATED_COUNT_CUMM, REHYDRATED_COUNT_CUMM, COMPLETED_COUNT_CUMM, FAULTED_COUNT_CUMM, EXEC_TIME_MIN, EXEC_TIME_MAX, EXEC_TIME_CUMM, EXEC_TIME_SQ_CUMM, DEHYDRATED_TIME_MIN, DEHYDRATED_TIME_MAX, DEHYDRATED_TIME_CUMM, DEHYDRATED_TIME_SQ_CUMM, CALLBACK_PROCESSING_TIME_MIN, CALLBACK_PROCESSING_TIME_MAX, CALLBACK_PROCESSING_TIME_CUMM, CALLBACK_PROCESS_TIME_SQ_CUMM FROM E$AWR_EXECUTION_METRIC;

ALTER TABLE E$AWR_EXECUTION_METRIC
    ADD CONSTRAINT AWR_EXECUTION_METRIC_PK PRIMARY KEY (SNAPSHOT_ID, NODE_ID, COMPOSITE_ELEMENT_ID);

-- ----------------------------------------------------------------------- 
-- E$AWR_BACKUP_METRIC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$AWR_BACKUP_METRIC
(
    SNAPSHOT_ID INTEGER NOT NULL,
    NODE_ID VARCHAR2(40) NOT NULL,
    COMPOSITE_ELEMENT_ID VARCHAR2(40) NOT NULL,
    DEPTH_AT_SERVER_START INTEGER,
    ADDED_COUNT_CUMM INTEGER,
    REMOVED_COUNT_CUMM INTEGER,
    CLOSED_COUNT_CUMM INTEGER,
    FAULTED_COUNT_CUMM INTEGER,
    DEPTH_AT_SNAPSHOT_END INTEGER
);

CREATE OR REPLACE EDITIONING VIEW AWR_BACKUP_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, COMPOSITE_ELEMENT_ID, DEPTH_AT_SERVER_START, ADDED_COUNT_CUMM, REMOVED_COUNT_CUMM, CLOSED_COUNT_CUMM, FAULTED_COUNT_CUMM, DEPTH_AT_SNAPSHOT_END FROM E$AWR_BACKUP_METRIC;

ALTER TABLE E$AWR_BACKUP_METRIC
    ADD CONSTRAINT AWR_BACKUP_METRIC_PK PRIMARY KEY (SNAPSHOT_ID, NODE_ID, COMPOSITE_ELEMENT_ID);

-- ----------------------------------------------------------------------- 
-- E$REP_BUS_EVENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REP_BUS_EVENT
(
    BUS_EVENT_ID NUMBER NOT NULL,
    FLOW_ID NUMBER DEFAULT -1 NOT NULL,
    FLOW_CORRELATION_ID VARCHAR2(100),
    PARENT_BUS_EVENT_ID NUMBER DEFAULT -1,
    STATE NUMBER(3) DEFAULT 0,
    FLOW_TYPE NUMBER(3) DEFAULT 0,
    FLOW_NAME NVARCHAR2(50),
    FLOW_INST_NAME NVARCHAR2(100),
    FLEX_PROP_1 NVARCHAR2(100),
    FLEX_PROP_2 NVARCHAR2(100),
    FLEX_PROP_3 NVARCHAR2(100),
    FLEX_PROP_4 NVARCHAR2(100),
    FLOW_CODE NVARCHAR2(50),
    FLOW_VERSION NVARCHAR2(15),
    MLST_ID VARCHAR2(20),
    AGGR_EVTS VARCHAR2(500),
    ERROR_ID NUMBER DEFAULT -1,
    APP_TYPE NUMBER(3) DEFAULT 0,
    APP_SUB_TYPE NUMBER(3) DEFAULT 0,
    RETRY_COUNT INTEGER DEFAULT -1,
    PROCMON_TYPE NUMBER(3) DEFAULT 0,
    PROCMON_STATE NUMBER(3) DEFAULT 0,
    PROCMON_MODEL_ID NVARCHAR2(255),
    CREATION_DATE TIMESTAMP DEFAULT systimestamp,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    VERSION INTEGER DEFAULT 0 NOT NULL
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW REP_BUS_EVENT
 AS SELECT BUS_EVENT_ID, FLOW_ID, FLOW_CORRELATION_ID, PARENT_BUS_EVENT_ID, STATE, FLOW_TYPE, FLOW_NAME, FLOW_INST_NAME, FLEX_PROP_1, FLEX_PROP_2, FLEX_PROP_3, FLEX_PROP_4, FLOW_CODE, FLOW_VERSION, MLST_ID, AGGR_EVTS, ERROR_ID, APP_TYPE, APP_SUB_TYPE, RETRY_COUNT, PROCMON_TYPE, PROCMON_STATE, PROCMON_MODEL_ID, CREATION_DATE, PARTITION_DATE, VERSION FROM E$REP_BUS_EVENT;

ALTER TABLE E$REP_BUS_EVENT
    ADD CONSTRAINT REP_BUS_EVENT_PK PRIMARY KEY (BUS_EVENT_ID);

CREATE INDEX REP_BUS_EVT_STATE ON E$REP_BUS_EVENT
    (STATE );

CREATE INDEX REP_BUS_EVT_FC_PDATE ON E$REP_BUS_EVENT
    (FLOW_CODE , PARTITION_DATE DESC);

CREATE INDEX REP_BUS_EVT_FID ON E$REP_BUS_EVENT
    (FLOW_ID );

CREATE INDEX REP_BUS_EVT_PDATE ON E$REP_BUS_EVENT
    (PARTITION_DATE DESC);

CREATE INDEX REP_BUS_EVT_PMON_STD ON E$REP_BUS_EVENT
    (PROCMON_TYPE , PROCMON_STATE , CREATION_DATE );

-- ----------------------------------------------------------------------- 
-- E$REP_FLOW_CORL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REP_FLOW_CORL
(
    PARENT_FLOW_CORRELATION_ID VARCHAR2(100),
    CHILD_FLOW_CORRELATION_ID VARCHAR2(100),
    PARENT_FLOW_ID NUMBER NOT NULL,
    CHILD_FLOW_ID NUMBER NOT NULL,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW REP_FLOW_CORL
 AS SELECT PARENT_FLOW_CORRELATION_ID, CHILD_FLOW_CORRELATION_ID, PARENT_FLOW_ID, CHILD_FLOW_ID, PARTITION_DATE FROM E$REP_FLOW_CORL;

ALTER TABLE E$REP_FLOW_CORL
    ADD CONSTRAINT REP_FLOW_CORL_PK PRIMARY KEY (PARENT_FLOW_ID, CHILD_FLOW_ID);

-- ----------------------------------------------------------------------- 
-- E$REP_EVENT_PROP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REP_EVENT_PROP
(
    FLOW_CORRELATION_ID VARCHAR2(100),
    FLOW_ID NUMBER DEFAULT -1 NOT NULL,
    BUS_EVENT_ID NUMBER NOT NULL,
    KEY_NAME NVARCHAR2(100) NOT NULL,
    VALUE NVARCHAR2(1000),
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW REP_EVENT_PROP
 AS SELECT FLOW_CORRELATION_ID, FLOW_ID, BUS_EVENT_ID, KEY_NAME, VALUE, PARTITION_DATE FROM E$REP_EVENT_PROP;

ALTER TABLE E$REP_EVENT_PROP
    ADD CONSTRAINT REP_EVENT_PROP_PK PRIMARY KEY (BUS_EVENT_ID, KEY_NAME);

CREATE INDEX REP_EVT_PROP_FID ON E$REP_EVENT_PROP
    (FLOW_ID );

CREATE INDEX REP_EVENT_PDATE_KEY_VAL_FID ON E$REP_EVENT_PROP
    (PARTITION_DATE DESC, KEY_NAME , VALUE , FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$REP_PAYLOAD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REP_PAYLOAD
(
    PAYLOAD_ID NUMBER NOT NULL,
    PAYLOAD_NAME VARCHAR2(100) DEFAULT '@' NOT NULL,
    FLOW_CORRELATION_ID VARCHAR2(100),
    FLOW_ID NUMBER DEFAULT -1 NOT NULL,
    PAYLOAD_TYPE NUMBER(3) DEFAULT 0,
    PAYLOAD_ENCODING NVARCHAR2(20),
    PAYLOAD BLOB,
    PAYLOAD_CONTEXT BLOB,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW REP_PAYLOAD
 AS SELECT PAYLOAD_ID, PAYLOAD_NAME, FLOW_CORRELATION_ID, FLOW_ID, PAYLOAD_TYPE, PAYLOAD_ENCODING, PAYLOAD, PAYLOAD_CONTEXT, PARTITION_DATE FROM E$REP_PAYLOAD;

ALTER TABLE E$REP_PAYLOAD
    ADD CONSTRAINT REP_PAYLOAD_PK PRIMARY KEY (PAYLOAD_ID, PAYLOAD_NAME);

-- ----------------------------------------------------------------------- 
-- E$REP_BUS_RECOVERY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$REP_BUS_RECOVERY
(
    JOB_ID NUMBER NOT NULL,
    ERROR_ID NUMBER NOT NULL,
    FLOW_CORRELATION_ID VARCHAR2(100),
    FLOW_ID NUMBER DEFAULT -1 NOT NULL,
    RECOVERY_STATE NUMBER(3) DEFAULT 0,
    COMPLETION_FLAG NUMBER(3) DEFAULT 0,
    CREATION_DATE TIMESTAMP DEFAULT systimestamp,
    MODIFY_DATE TIMESTAMP
)
 PARTITION BY RANGE (CREATION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW REP_BUS_RECOVERY
 AS SELECT JOB_ID, ERROR_ID, FLOW_CORRELATION_ID, FLOW_ID, RECOVERY_STATE, COMPLETION_FLAG, CREATION_DATE, MODIFY_DATE FROM E$REP_BUS_RECOVERY;

ALTER TABLE E$REP_BUS_RECOVERY
    ADD CONSTRAINT REP_BUS_RECOVERY_PK PRIMARY KEY (JOB_ID, ERROR_ID);

CREATE INDEX REP_RCV_CDATE_JOBID ON E$REP_BUS_RECOVERY
    (CREATION_DATE DESC, JOB_ID );

-- ----------------------------------------------------------------------- 
-- E$PMON_BIZ_MODEL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PMON_BIZ_MODEL
(
    BUSINESS_MODEL_ID NVARCHAR2(255) NOT NULL,
    LC_JOB_ID NUMBER NOT NULL,
    PMON_STATE NUMBER(3) DEFAULT 0,
    CREATED_BY NVARCHAR2(255) NOT NULL,
    UPDATED_BY NVARCHAR2(255) NOT NULL,
    CREATED_DATE TIMESTAMP DEFAULT systimestamp,
    UPDATED_DATE TIMESTAMP DEFAULT systimestamp,
    FLEX_FIELD1 NVARCHAR2(255),
    FLEX_FIELD2 NVARCHAR2(255),
    PMON_ML_STATE NUMBER(3)
);

CREATE OR REPLACE EDITIONING VIEW PMON_BIZ_MODEL
 AS SELECT BUSINESS_MODEL_ID, LC_JOB_ID, PMON_STATE, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, FLEX_FIELD1, FLEX_FIELD2, PMON_ML_STATE FROM E$PMON_BIZ_MODEL;

ALTER TABLE E$PMON_BIZ_MODEL
    ADD CONSTRAINT PMON_BIZ_MODEL_PK PRIMARY KEY (BUSINESS_MODEL_ID);

-- ----------------------------------------------------------------------- 
-- E$PMON_BIZ_PROP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PMON_BIZ_PROP
(
    BUSINESS_MODEL_ID NVARCHAR2(255) NOT NULL,
    KEY_NAME NVARCHAR2(100) NOT NULL,
    PMON_VALUE NVARCHAR2(1000)
);

CREATE OR REPLACE EDITIONING VIEW PMON_BIZ_PROP
 AS SELECT BUSINESS_MODEL_ID, KEY_NAME, PMON_VALUE FROM E$PMON_BIZ_PROP;

ALTER TABLE E$PMON_BIZ_PROP
    ADD CONSTRAINT PMON_BIZ_PROP_PK PRIMARY KEY (BUSINESS_MODEL_ID, KEY_NAME);

-- ----------------------------------------------------------------------- 
-- E$PMON_AUDIT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PMON_AUDIT
(
    AUDIT_ID NUMBER NOT NULL,
    MODEL_ID NVARCHAR2(255) NOT NULL,
    AGENT_ID NVARCHAR2(255),
    LC_JOB_ID NUMBER,
    EVENT_SOURCE NUMBER(3) DEFAULT 0,
    EVENT_TYPE NUMBER(3) DEFAULT 0,
    EVENT_SUB_TYPE NUMBER(3) DEFAULT 0,
    EVENT_SEVERITY NUMBER(3) DEFAULT 0,
    CREATION_DATE TIMESTAMP DEFAULT systimestamp,
    DESCRIPTION NVARCHAR2(500)
);

CREATE OR REPLACE EDITIONING VIEW PMON_AUDIT
 AS SELECT AUDIT_ID, MODEL_ID, AGENT_ID, LC_JOB_ID, EVENT_SOURCE, EVENT_TYPE, EVENT_SUB_TYPE, EVENT_SEVERITY, CREATION_DATE, DESCRIPTION FROM E$PMON_AUDIT;

ALTER TABLE E$PMON_AUDIT
    ADD CONSTRAINT PMON_AUDIT_PK PRIMARY KEY (AUDIT_ID);

-- ----------------------------------------------------------------------- 
-- E$PMON_AUDIT_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PMON_AUDIT_INFO
(
    AUDIT_ID NUMBER NOT NULL,
    DETAIL CLOB NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW PMON_AUDIT_INFO
 AS SELECT AUDIT_ID, DETAIL FROM E$PMON_AUDIT_INFO;

ALTER TABLE E$PMON_AUDIT_INFO
    ADD CONSTRAINT PMON_AUDIT_INFO_PK PRIMARY KEY (AUDIT_ID);

-- ----------------------------------------------------------------------- 
-- E$PMON_REJECTED_MODEL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PMON_REJECTED_MODEL
(
    PMON_REJECTED_MODEL_ID NUMBER NOT NULL,
    LC_JOB_ID NUMBER,
    MODEL_ID NVARCHAR2(255),
    START_TIME TIMESTAMP DEFAULT systimestamp,
    END_TIME TIMESTAMP DEFAULT systimestamp,
    SOURCE NUMBER(3)
);

CREATE OR REPLACE EDITIONING VIEW PMON_REJECTED_MODEL
 AS SELECT PMON_REJECTED_MODEL_ID, LC_JOB_ID, MODEL_ID, START_TIME, END_TIME, SOURCE FROM E$PMON_REJECTED_MODEL;

ALTER TABLE E$PMON_REJECTED_MODEL
    ADD CONSTRAINT PMON_REJECTED_MODEL_PK PRIMARY KEY (PMON_REJECTED_MODEL_ID);

-- ----------------------------------------------------------------------- 
-- E$PMON_SEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PMON_SEQUENCE
(
    RANGE_NAME VARCHAR2(50) NOT NULL,
    NEXT_RANGE NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW PMON_SEQUENCE
 AS SELECT RANGE_NAME, NEXT_RANGE FROM E$PMON_SEQUENCE;

ALTER TABLE E$PMON_SEQUENCE
    ADD CONSTRAINT PMON_SEQUENCE_PK PRIMARY KEY (RANGE_NAME);

-- ----------------------------------------------------------------------- 
-- E$SOA_HEALTHCHECK_RESULT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SOA_HEALTHCHECK_RESULT
(
    REQUEST_ID VARCHAR2(200) NOT NULL,
    HC_NAME VARCHAR2(200) NOT NULL,
    SERVER_NAME VARCHAR2(200),
    STATE VARCHAR2(50),
    START_TIME TIMESTAMP,
    END_TIME TIMESTAMP,
    RESULT BLOB,
    REQUEST_START_TIME TIMESTAMP
)
lob( RESULT )
store as
(
    chunk 4K
    pctversion 0
)
storage
(
    freelists 20
);

CREATE OR REPLACE EDITIONING VIEW SOA_HEALTHCHECK_RESULT
 AS SELECT REQUEST_ID, HC_NAME, SERVER_NAME, STATE, START_TIME, END_TIME, RESULT, REQUEST_START_TIME FROM E$SOA_HEALTHCHECK_RESULT;

ALTER TABLE E$SOA_HEALTHCHECK_RESULT
    ADD CONSTRAINT SOA_HEALTHCHECK_RESULT_PK PRIMARY KEY (REQUEST_ID, HC_NAME);

-- ----------------------------------------------------------------------- 
-- E$PC_OWF 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_OWF
(
    OWF_DATASOURCE VARCHAR2(120) NOT NULL,
    OWF_ITEM_TYPE VARCHAR2(8) NOT NULL,
    OWF_ITEM_KEY VARCHAR2(80) NOT NULL,
    BPEL_DOMAIN VARCHAR2(40) NOT NULL,
    BPEL_PROCESS_ID VARCHAR2(60) NOT NULL,
    BPEL_REVISION_TAG VARCHAR2(60),
    BPEL_PARTNER_LINK VARCHAR2(60),
    BPEL_INSTANCE_ID VARCHAR2(80) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW PC_OWF
 AS SELECT OWF_DATASOURCE, OWF_ITEM_TYPE, OWF_ITEM_KEY, BPEL_DOMAIN, BPEL_PROCESS_ID, BPEL_REVISION_TAG, BPEL_PARTNER_LINK, BPEL_INSTANCE_ID FROM E$PC_OWF;

ALTER TABLE E$PC_OWF
    ADD CONSTRAINT PC_OWF_PK PRIMARY KEY (OWF_DATASOURCE, OWF_ITEM_TYPE, OWF_ITEM_KEY);

-- ----------------------------------------------------------------------- 
-- E$PC_TASK 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_TASK
(
    TITLE NVARCHAR2(300),
    ISGROUP NVARCHAR2(2),
    ACQUIREDBY NVARCHAR2(300),
    OWNER NVARCHAR2(300),
    CONCLUSION NVARCHAR2(100),
    STATE NVARCHAR2(100),
    SUBSTATE NVARCHAR2(200),
    PROCESSID NVARCHAR2(100),
    PROCESSNAME NVARCHAR2(100),
    TASKID NVARCHAR2(32) NOT NULL,
    VERSION INTEGER,
    NOTM INTEGER DEFAULT 1,
    TASKGROUPID NVARCHAR2(32),
    TASKTYPE NVARCHAR2(300),
    IDENTIFICATIONKEY NVARCHAR2(128),
    EXPIRATIONDURATION NVARCHAR2(64),
    EXPIRATIONDATE DATE,
    PRIORITY INTEGER,
    CREATOR NVARCHAR2(64),
    CREATEDDATE DATE,
    UPDATEDBY NVARCHAR2(64),
    MODIFYDATE DATE,
    FLEXSTRING1 NVARCHAR2(256),
    FLEXSTRING2 NVARCHAR2(256),
    FLEXSTRING3 NVARCHAR2(256),
    FLEXSTRING4 NVARCHAR2(256),
    FLEXLONG1 NUMBER,
    FLEXLONG2 NUMBER,
    FLEXDOUBLE1 NUMBER,
    FLEXDOUBLE2 NUMBER,
    FLEXDATE1 DATE,
    FLEXDATE2 DATE,
    FLEXDATE3 DATE,
    PROCESSVERSION NVARCHAR2(100),
    INSTANCEID NVARCHAR2(200),
    DOMAINID NVARCHAR2(100),
    APPROVERS NVARCHAR2(2000),
    ISHASSUBTASK NVARCHAR2(2),
    COMMENT1 NVARCHAR2(2000),
    COMMENT2 NVARCHAR2(2000),
    COMMENT3 NVARCHAR2(2000),
    COMMENT4 NVARCHAR2(2000),
    COMMENT5 NVARCHAR2(2000),
    VERSIONREASON NVARCHAR2(2000),
    PROCESSOWNER NVARCHAR2(200),
    PATTERN NVARCHAR2(2000),
    SYSTEMSTRING1 NVARCHAR2(200),
    SYSTEMSTRING2 NVARCHAR2(200),
    SYSTEMSTRING3 NVARCHAR2(200),
    TASKNUMBER NUMBER
);

CREATE OR REPLACE EDITIONING VIEW PC_TASK
 AS SELECT TITLE, ISGROUP, ACQUIREDBY, OWNER, CONCLUSION, STATE, SUBSTATE, PROCESSID, PROCESSNAME, TASKID, VERSION, NOTM, TASKGROUPID, TASKTYPE, IDENTIFICATIONKEY, EXPIRATIONDURATION, EXPIRATIONDATE, PRIORITY, CREATOR, CREATEDDATE, UPDATEDBY, MODIFYDATE, FLEXSTRING1, FLEXSTRING2, FLEXSTRING3, FLEXSTRING4, FLEXLONG1, FLEXLONG2, FLEXDOUBLE1, FLEXDOUBLE2, FLEXDATE1, FLEXDATE2, FLEXDATE3, PROCESSVERSION, INSTANCEID, DOMAINID, APPROVERS, ISHASSUBTASK, COMMENT1, COMMENT2, COMMENT3, COMMENT4, COMMENT5, VERSIONREASON, PROCESSOWNER, PATTERN, SYSTEMSTRING1, SYSTEMSTRING2, SYSTEMSTRING3, TASKNUMBER FROM E$PC_TASK;

ALTER TABLE E$PC_TASK
    ADD CONSTRAINT PC_TASK_PK PRIMARY KEY (TASKID);

CREATE INDEX PC_TASKPROCESSNAME_I ON E$PC_TASK
    (PROCESSNAME );

CREATE INDEX PC_TASKEXPIRATIONDATE_I ON E$PC_TASK
    (EXPIRATIONDATE );

CREATE INDEX PC_TASKPRIORITY_I ON E$PC_TASK
    (PRIORITY );

CREATE INDEX PC_TASKCREATOR_I ON E$PC_TASK
    (CREATOR );

CREATE INDEX PC_TASKCREATEDDATE_I ON E$PC_TASK
    (CREATEDDATE );

CREATE INDEX PC_TASKUPDATEDBY_I ON E$PC_TASK
    (UPDATEDBY );

CREATE INDEX PC_TASKMODIFYDATE_I ON E$PC_TASK
    (MODIFYDATE );

CREATE INDEX PC_TASKSTATE_I ON E$PC_TASK
    (STATE );

CREATE INDEX PC_TASKTASKNUMBER_I ON E$PC_TASK
    (TASKNUMBER );

CREATE INDEX PC_TASKOWNER_I ON E$PC_TASK
    (OWNER );

-- ----------------------------------------------------------------------- 
-- E$PC_TASKASSIGNEE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_TASKASSIGNEE
(
    TASKID NVARCHAR2(32) NOT NULL,
    VERSION NUMBER NOT NULL,
    ASSIGNEE NVARCHAR2(200) NOT NULL,
    GUID NVARCHAR2(32),
    ISGROUP NVARCHAR2(2)
);

CREATE OR REPLACE EDITIONING VIEW PC_TASKASSIGNEE
 AS SELECT TASKID, VERSION, ASSIGNEE, GUID, ISGROUP FROM E$PC_TASKASSIGNEE;

ALTER TABLE E$PC_TASKASSIGNEE
    ADD CONSTRAINT PC_TASKASSIGNEE_PK PRIMARY KEY (TASKID, VERSION, ASSIGNEE);

CREATE INDEX PC_TASKASSIGNEEASSIGNEE_I ON E$PC_TASKASSIGNEE
    (ASSIGNEE );

-- ----------------------------------------------------------------------- 
-- E$PC_TASKASSIGNEEHISTORY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_TASKASSIGNEEHISTORY
(
    TASKID NVARCHAR2(32) NOT NULL,
    VERSION NUMBER NOT NULL,
    MAXVERSION NUMBER,
    ASSIGNEE NVARCHAR2(200) NOT NULL,
    GUID NVARCHAR2(32),
    ISGROUP NVARCHAR2(2)
);

CREATE OR REPLACE EDITIONING VIEW PC_TASKASSIGNEEHISTORY
 AS SELECT TASKID, VERSION, MAXVERSION, ASSIGNEE, GUID, ISGROUP FROM E$PC_TASKASSIGNEEHISTORY;

ALTER TABLE E$PC_TASKASSIGNEEHISTORY
    ADD CONSTRAINT PC_TASKASSIGNEEHISTORY_PK PRIMARY KEY (TASKID, VERSION, ASSIGNEE);

CREATE INDEX PC_TASKASSIGNEEHASSIGNEE_I ON E$PC_TASKASSIGNEEHISTORY
    (ASSIGNEE );

-- ----------------------------------------------------------------------- 
-- E$PC_TASKATTACHMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_TASKATTACHMENT
(
    TASKID NVARCHAR2(32) NOT NULL,
    VERSION INTEGER NOT NULL,
    MAXVERSION INTEGER,
    URI NVARCHAR2(256),
    CONTENT BLOB,
    NAME NVARCHAR2(128) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW PC_TASKATTACHMENT
 AS SELECT TASKID, VERSION, MAXVERSION, URI, CONTENT, NAME FROM E$PC_TASKATTACHMENT;

ALTER TABLE E$PC_TASKATTACHMENT
    ADD CONSTRAINT PC_TASKATTACHMENT_PK PRIMARY KEY (TASKID, VERSION, NAME);

CREATE INDEX PC_TASKATTACHMENTNAME_I ON E$PC_TASKATTACHMENT
    (NAME );

-- ----------------------------------------------------------------------- 
-- E$PC_TASKHISTORY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_TASKHISTORY
(
    TITLE NVARCHAR2(300),
    ISGROUP NVARCHAR2(2),
    ACQUIREDBY NVARCHAR2(300),
    OWNER NVARCHAR2(300),
    CONCLUSION NVARCHAR2(100),
    STATE NVARCHAR2(100),
    SUBSTATE NVARCHAR2(100),
    PROCESSID NVARCHAR2(200),
    PROCESSNAME NVARCHAR2(100),
    TASKID NVARCHAR2(32) NOT NULL,
    VERSION INTEGER NOT NULL,
    NOTM INTEGER DEFAULT 1,
    TASKGROUPID NVARCHAR2(32),
    TASKTYPE NVARCHAR2(300),
    IDENTIFICATIONKEY NVARCHAR2(128),
    EXPIRATIONDURATION NVARCHAR2(64),
    EXPIRATIONDATE DATE,
    PRIORITY INTEGER,
    CREATOR NVARCHAR2(64),
    CREATEDDATE DATE,
    UPDATEDBY NVARCHAR2(64),
    MODIFYDATE DATE,
    FLEXSTRING1 NVARCHAR2(256),
    FLEXSTRING2 NVARCHAR2(256),
    FLEXSTRING3 NVARCHAR2(256),
    FLEXSTRING4 NVARCHAR2(256),
    FLEXLONG1 NUMBER,
    FLEXLONG2 NUMBER,
    FLEXDOUBLE1 NUMBER,
    FLEXDOUBLE2 NUMBER,
    FLEXDATE1 DATE,
    FLEXDATE2 DATE,
    FLEXDATE3 DATE,
    PROCESSVERSION NVARCHAR2(100),
    INSTANCEID NVARCHAR2(200),
    DOMAINID NVARCHAR2(100),
    APPROVERS NVARCHAR2(2000),
    ISHASSUBTASK NVARCHAR2(2),
    COMMENT1 NVARCHAR2(2000),
    COMMENT2 NVARCHAR2(2000),
    COMMENT3 NVARCHAR2(2000),
    COMMENT4 NVARCHAR2(2000),
    COMMENT5 NVARCHAR2(2000),
    VERSIONREASON NVARCHAR2(2000),
    PROCESSOWNER NVARCHAR2(200),
    PATTERN NVARCHAR2(2000),
    SYSTEMSTRING1 NVARCHAR2(200),
    SYSTEMSTRING2 NVARCHAR2(200),
    SYSTEMSTRING3 NVARCHAR2(200),
    TASKNUMBER NUMBER
);

CREATE OR REPLACE EDITIONING VIEW PC_TASKHISTORY
 AS SELECT TITLE, ISGROUP, ACQUIREDBY, OWNER, CONCLUSION, STATE, SUBSTATE, PROCESSID, PROCESSNAME, TASKID, VERSION, NOTM, TASKGROUPID, TASKTYPE, IDENTIFICATIONKEY, EXPIRATIONDURATION, EXPIRATIONDATE, PRIORITY, CREATOR, CREATEDDATE, UPDATEDBY, MODIFYDATE, FLEXSTRING1, FLEXSTRING2, FLEXSTRING3, FLEXSTRING4, FLEXLONG1, FLEXLONG2, FLEXDOUBLE1, FLEXDOUBLE2, FLEXDATE1, FLEXDATE2, FLEXDATE3, PROCESSVERSION, INSTANCEID, DOMAINID, APPROVERS, ISHASSUBTASK, COMMENT1, COMMENT2, COMMENT3, COMMENT4, COMMENT5, VERSIONREASON, PROCESSOWNER, PATTERN, SYSTEMSTRING1, SYSTEMSTRING2, SYSTEMSTRING3, TASKNUMBER FROM E$PC_TASKHISTORY;

ALTER TABLE E$PC_TASKHISTORY
    ADD CONSTRAINT PC_TASKHISTORY_PK PRIMARY KEY (TASKID, VERSION);

CREATE INDEX PC_TASKHSTATE_I ON E$PC_TASKHISTORY
    (STATE );

CREATE INDEX PC_TASKHTASKNUMBER_I ON E$PC_TASKHISTORY
    (TASKNUMBER );

CREATE INDEX PC_TASKHOWNER_I ON E$PC_TASKHISTORY
    (OWNER );

CREATE INDEX PC_TASKHPROCESSNAME_I ON E$PC_TASKHISTORY
    (PROCESSNAME );

CREATE INDEX PC_TASKHEXPIRATIONDATE_I ON E$PC_TASKHISTORY
    (EXPIRATIONDATE );

CREATE INDEX PC_TASKHPRIORITY_I ON E$PC_TASKHISTORY
    (PRIORITY );

CREATE INDEX PC_TASKHCREATOR_I ON E$PC_TASKHISTORY
    (CREATOR );

CREATE INDEX PC_TASKHCREATEDDATE_I ON E$PC_TASKHISTORY
    (CREATEDDATE );

CREATE INDEX PC_TASKHUPDATEDBY_I ON E$PC_TASKHISTORY
    (UPDATEDBY );

CREATE INDEX PC_TASKHMODIFYDATE_I ON E$PC_TASKHISTORY
    (MODIFYDATE );

-- ----------------------------------------------------------------------- 
-- E$PC_TASKPAYLOAD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$PC_TASKPAYLOAD
(
    TASKID NVARCHAR2(32) NOT NULL,
    VERSION INTEGER NOT NULL,
    MAXVERSION INTEGER,
    PAYLOADTYPE INTEGER,
    PAYLOAD BLOB
);

CREATE OR REPLACE EDITIONING VIEW PC_TASKPAYLOAD
 AS SELECT TASKID, VERSION, MAXVERSION, PAYLOADTYPE, PAYLOAD FROM E$PC_TASKPAYLOAD;

ALTER TABLE E$PC_TASKPAYLOAD
    ADD CONSTRAINT PC_TASKPAYLOAD_PK PRIMARY KEY (TASKID, VERSION);

-- ----------------------------------------------------------------------- 
-- E$BPELNotification 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPELNotification
(
    id NVARCHAR2(200) NOT NULL,
    destinationaddress NVARCHAR2(2000),
    destinationtype NVARCHAR2(2000),
    wftaskid NVARCHAR2(200),
    wftaskversion INTEGER,
    wftaskaction NVARCHAR2(200),
    createdtime DATE NOT NULL,
    status NVARCHAR2(200),
    attemptednumber INTEGER,
    type NVARCHAR2(100),
    caller NVARCHAR2(100),
    outputmessage NVARCHAR2(2000),
    channel_message_id VARCHAR2(2000),
    composite_dn VARCHAR2(500),
    composite_instanceid VARCHAR2(200),
    component_name VARCHAR2(200),
    message BLOB
)
;

CREATE OR REPLACE EDITIONING VIEW BPELNotification
 AS SELECT id, destinationaddress, destinationtype, wftaskid, wftaskversion, wftaskaction, createdtime, status, attemptednumber, type, caller, outputmessage, channel_message_id, composite_dn, composite_instanceid, component_name, message FROM E$BPELNotification;

ALTER TABLE E$BPELNotification
    ADD CONSTRAINT BPELNotification_PK PRIMARY KEY (id);

CREATE INDEX BPELNotification_CreTimType_I ON E$BPELNotification
    (createdtime DESC, type );

CREATE INDEX BPELNotification_status_I ON E$BPELNotification
    (status );

CREATE INDEX BPELNotification_ChnMsgId_I ON E$BPELNotification
    (channel_message_id );

-- ----------------------------------------------------------------------- 
-- E$BPELNotification_filtermsgs 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPELNotification_filtermsgs
(
    id VARCHAR2(200),
    message_channel VARCHAR2(200),
    channel_message_id VARCHAR2(2000),
    sender_address VARCHAR2(2000),
    received_address VARCHAR2(2000),
    received_date DATE,
    filter_key VARCHAR2(200),
    filter_reason VARCHAR2(2000),
    truncated_message NVARCHAR2(2000),
    composite_dn VARCHAR2(500),
    composite_instanceid VARCHAR2(200),
    component_name VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPELNotification_filtermsgs
 AS SELECT id, message_channel, channel_message_id, sender_address, received_address, received_date, filter_key, filter_reason, truncated_message, composite_dn, composite_instanceid, component_name FROM E$BPELNotification_filtermsgs;

CREATE INDEX BPELNotification_filtermsgs_I ON E$BPELNotification_filtermsgs
    (received_date DESC);

-- ----------------------------------------------------------------------- 
-- E$BPELNotification_invaladdrs 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPELNotification_invaladdrs
(
    id VARCHAR2(200),
    destination_channel VARCHAR2(200),
    destination_address VARCHAR2(2000),
    invalidated_time DATE
);

CREATE OR REPLACE EDITIONING VIEW BPELNotification_invaladdrs
 AS SELECT id, destination_channel, destination_address, invalidated_time FROM E$BPELNotification_invaladdrs;

CREATE INDEX BPELNotification_invaladdrs_I ON E$BPELNotification_invaladdrs
    (destination_channel , destination_address );

-- ----------------------------------------------------------------------- 
-- E$BPM_BUSINESS_CONSTANT_OU_ASS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BUSINESS_CONSTANT_OU_ASS
(
    ASSOCIATION_ID VARCHAR2(64) NOT NULL,
    APPLICATION_CONTEXT VARCHAR2(200),
    ORGANIZATIONAL_UNIT_ID VARCHAR2(64) NOT NULL,
    BUSINESS_CONSTANT_ID VARCHAR2(64) NOT NULL,
    CONSTANT_VALUE VARCHAR2(256) NOT NULL,
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDENCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BUSINESS_CONSTANT_OU_ASSOC
 AS SELECT ASSOCIATION_ID, APPLICATION_CONTEXT, ORGANIZATIONAL_UNIT_ID, BUSINESS_CONSTANT_ID, CONSTANT_VALUE, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_BUSINESS_CONSTANT_OU_ASS;

ALTER TABLE E$BPM_BUSINESS_CONSTANT_OU_ASS
    ADD CONSTRAINT BPM_BUSINESS_CO_NT_OU_ASSOC_PK PRIMARY KEY (ASSOCIATION_ID);

ALTER TABLE E$BPM_BUSINESS_CONSTANT_OU_ASS ADD CONSTRAINT BPM_BUSINESS_CONSTANT_OU_AS_UK UNIQUE
    (ORGANIZATIONAL_UNIT_ID , BUSINESS_CONSTANT_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_BUSINESS_CONSTANT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_BUSINESS_CONSTANT
(
    BUSINESS_CONSTANT_ID VARCHAR2(64) NOT NULL,
    BUSINESS_CONSTANT_NAME VARCHAR2(512) NOT NULL,
    BUSINESS_CONSTANT_TYPE VARCHAR2(20) NOT NULL,
    DEFAULT_VALUE VARCHAR2(256),
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDCTX VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_IDCTX VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_BUSINESS_CONSTANT
 AS SELECT BUSINESS_CONSTANT_ID, BUSINESS_CONSTANT_NAME, BUSINESS_CONSTANT_TYPE, DEFAULT_VALUE, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_IDCTX FROM E$BPM_BUSINESS_CONSTANT;

ALTER TABLE E$BPM_BUSINESS_CONSTANT
    ADD CONSTRAINT BPM_BUSINESS_CONSTANT_PK PRIMARY KEY (BUSINESS_CONSTANT_ID);

ALTER TABLE E$BPM_BUSINESS_CONSTANT ADD CONSTRAINT BPM_BUSINESS_CONSTANT_UK UNIQUE
    (BUSINESS_CONSTANT_NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_APP_ROLE_OU_CAL_ASSOC 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_APP_ROLE_OU_CAL_ASSOC
(
    ID VARCHAR2(64) NOT NULL,
    APPLICATION_ROLE_NAME VARCHAR2(400) NOT NULL,
    IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    APPLICATION_CONTEXT VARCHAR2(200),
    ORGANIZATIONAL_UNIT_ID VARCHAR2(64) NOT NULL,
    CALENDAR_RULE_ID VARCHAR2(64) NOT NULL,
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDENCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_APP_ROLE_OU_CAL_ASSOC
 AS SELECT ID, APPLICATION_ROLE_NAME, IDENTITY_CONTEXT, APPLICATION_CONTEXT, ORGANIZATIONAL_UNIT_ID, CALENDAR_RULE_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_APP_ROLE_OU_CAL_ASSOC;

ALTER TABLE E$BPM_APP_ROLE_OU_CAL_ASSOC
    ADD CONSTRAINT BPM_APP_ROLE_OU_CAL_ASSOC_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_APP_ROLE_OU_CAL_ASSOC ADD CONSTRAINT BPM_ROLE_OU_CAL_ASSOC_UK UNIQUE
    (APPLICATION_ROLE_NAME , IDENTITY_CONTEXT , ORGANIZATIONAL_UNIT_ID , CALENDAR_RULE_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_CALENDAR_RULE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CALENDAR_RULE
(
    ID VARCHAR2(64) NOT NULL,
    NAME VARCHAR2(512) NOT NULL,
    TIME_ZONE_ID VARCHAR2(128) NOT NULL,
    HOLIDAY_RULE_ID VARCHAR2(64),
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDCTX VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_IDCTX VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_CALENDAR_RULE
 AS SELECT ID, NAME, TIME_ZONE_ID, HOLIDAY_RULE_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_IDCTX FROM E$BPM_CALENDAR_RULE;

ALTER TABLE E$BPM_CALENDAR_RULE
    ADD CONSTRAINT BPM_CALENDAR_RULE_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_CALENDAR_RULE ADD CONSTRAINT BPM_CALENDAR_RULE_UK UNIQUE
    (NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_CALENDAR_WORKDAY 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_CALENDAR_WORKDAY
(
    ID VARCHAR2(64) NOT NULL,
    CALENDAR_RULE_ID VARCHAR2(64),
    WEEKDAY VARCHAR2(32) NOT NULL,
    START_TIME VARCHAR2(16) NOT NULL,
    END_TIME VARCHAR2(16) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_CALENDAR_WORKDAY
 AS SELECT ID, CALENDAR_RULE_ID, WEEKDAY, START_TIME, END_TIME FROM E$BPM_CALENDAR_WORKDAY;

ALTER TABLE E$BPM_CALENDAR_WORKDAY
    ADD CONSTRAINT BPM_CALENDAR_WORKDAY_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_FISCAL_YEAR 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_FISCAL_YEAR
(
    FISCAL_YEAR_ID VARCHAR2(64) NOT NULL,
    FISCAL_YEAR_NAME VARCHAR2(512) NOT NULL,
    DISPLAY_NAME VARCHAR2(512) NOT NULL,
    NUMBER_OF_DIVISIONS INTEGER NOT NULL,
    START_MONTH INTEGER NOT NULL,
    START_DAY INTEGER NOT NULL,
    END_MONTH INTEGER NOT NULL,
    END_DAY INTEGER NOT NULL,
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDCTX VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_IDCTX VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_FISCAL_YEAR
 AS SELECT FISCAL_YEAR_ID, FISCAL_YEAR_NAME, DISPLAY_NAME, NUMBER_OF_DIVISIONS, START_MONTH, START_DAY, END_MONTH, END_DAY, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_IDCTX FROM E$BPM_FISCAL_YEAR;

ALTER TABLE E$BPM_FISCAL_YEAR
    ADD CONSTRAINT FY_PK PRIMARY KEY (FISCAL_YEAR_ID);

ALTER TABLE E$BPM_FISCAL_YEAR ADD CONSTRAINT BPM_FISCAL_YEAR_UK UNIQUE
    (FISCAL_YEAR_NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_FISCAL_YEAR_DIVISION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_FISCAL_YEAR_DIVISION
(
    DIVISION_ID VARCHAR2(64) NOT NULL,
    FISCAL_YEAR_ID VARCHAR2(64) NOT NULL,
    DIVISION_NAME VARCHAR2(200) NOT NULL,
    DIVISION_POSITION INTEGER NOT NULL,
    DISPLAY_NAME VARCHAR2(400) NOT NULL,
    START_MONTH INTEGER NOT NULL,
    START_DAY INTEGER NOT NULL,
    END_MONTH INTEGER NOT NULL,
    END_DAY INTEGER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_FISCAL_YEAR_DIVISION
 AS SELECT DIVISION_ID, FISCAL_YEAR_ID, DIVISION_NAME, DIVISION_POSITION, DISPLAY_NAME, START_MONTH, START_DAY, END_MONTH, END_DAY FROM E$BPM_FISCAL_YEAR_DIVISION;

ALTER TABLE E$BPM_FISCAL_YEAR_DIVISION
    ADD CONSTRAINT FY_DIV_PK PRIMARY KEY (DIVISION_ID);

ALTER TABLE E$BPM_FISCAL_YEAR_DIVISION ADD CONSTRAINT BPM_FISCAL_YEAR_DIVISION_UK1 UNIQUE
    (FISCAL_YEAR_ID , DIVISION_NAME );

ALTER TABLE E$BPM_FISCAL_YEAR_DIVISION ADD CONSTRAINT BPM_FISCAL_YEAR_DIVISION_UK2 UNIQUE
    (FISCAL_YEAR_ID , DIVISION_POSITION );

ALTER TABLE E$BPM_FISCAL_YEAR_DIVISION ADD CONSTRAINT BPM_FISCAL_YEAR_DIVISION_UK3 UNIQUE
    (FISCAL_YEAR_ID , START_MONTH , START_DAY );

ALTER TABLE E$BPM_FISCAL_YEAR_DIVISION ADD CONSTRAINT BPM_FISCAL_YEAR_DIVISION_UK4 UNIQUE
    (FISCAL_YEAR_ID , END_MONTH , END_DAY );

-- ----------------------------------------------------------------------- 
-- E$BPM_EXT_USER_PROP_AVLBL_COL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_EXT_USER_PROP_AVLBL_COL
(
    STRING_COL_NAME VARCHAR2(64),
    DATE_COL_NAME VARCHAR2(64),
    NUMBER_COL_NAME VARCHAR2(64),
    GUID VARCHAR2(64) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_EXT_USER_PROP_AVLBL_COL
 AS SELECT STRING_COL_NAME, DATE_COL_NAME, NUMBER_COL_NAME, GUID FROM E$BPM_EXT_USER_PROP_AVLBL_COL;

ALTER TABLE E$BPM_EXT_USER_PROP_AVLBL_COL
    ADD CONSTRAINT BPM_EXT_USER_PROP_AVLBL_COL_PK PRIMARY KEY (GUID);

-- ----------------------------------------------------------------------- 
-- E$BPM_EXT_USER_PROPERTY_GLOBAL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_EXT_USER_PROPERTY_GLOBAL
(
    GUID VARCHAR2(64) NOT NULL,
    PROPERTY_NAME VARCHAR2(256) NOT NULL,
    PROPERTY_STRING_VALUE VARCHAR2(2048),
    PROPERTY_DATA_TYPE VARCHAR2(64),
    PROP_VALUE_COLUMN_NAME VARCHAR2(64) NOT NULL,
    CREATED_BY VARCHAR2(256) NOT NULL,
    CREATED_BY_IDCTX VARCHAR2(256) NOT NULL,
    CREATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(256) NOT NULL,
    LAST_UPDATED_BY_IDCTX VARCHAR2(256) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    MULTI_VALUED_PROPERTY INTEGER
);

CREATE OR REPLACE EDITIONING VIEW BPM_EXT_USER_PROPERTY_GLOBAL
 AS SELECT GUID, PROPERTY_NAME, PROPERTY_STRING_VALUE, PROPERTY_DATA_TYPE, PROP_VALUE_COLUMN_NAME, CREATED_BY, CREATED_BY_IDCTX, CREATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDCTX, LAST_UPDATED_DATE, MULTI_VALUED_PROPERTY FROM E$BPM_EXT_USER_PROPERTY_GLOBAL;

ALTER TABLE E$BPM_EXT_USER_PROPERTY_GLOBAL
    ADD CONSTRAINT BPM_EXT_USER_PR_ERTY_GLOBAL_PK PRIMARY KEY (GUID);

ALTER TABLE E$BPM_EXT_USER_PROPERTY_GLOBAL ADD CONSTRAINT PROP_NAME_PROP_VALUE_UNIQUE UNIQUE
    (PROPERTY_NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_EXT_USER_PROPERTY_VALUE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_EXT_USER_PROPERTY_VALUE
(
    GUID VARCHAR2(64) NOT NULL,
    PARTICIPANT_ID VARCHAR2(256) NOT NULL,
    PARTICIPANT_TYPE VARCHAR2(256) NOT NULL,
    IDENTITY_CONTEXT VARCHAR2(256) NOT NULL,
    STR_COL0 VARCHAR2(2048),
    STR_COL1 VARCHAR2(2048),
    STR_COL2 VARCHAR2(2048),
    STR_COL3 VARCHAR2(2048),
    STR_COL4 VARCHAR2(2048),
    STR_COL5 VARCHAR2(2048),
    STR_COL6 VARCHAR2(2048),
    STR_COL7 VARCHAR2(2048),
    STR_COL8 VARCHAR2(2048),
    STR_COL9 VARCHAR2(2048),
    STR_COL10 VARCHAR2(2048),
    STR_COL11 VARCHAR2(2048),
    STR_COL12 VARCHAR2(2048),
    STR_COL13 VARCHAR2(2048),
    STR_COL14 VARCHAR2(2048),
    STR_COL15 VARCHAR2(2048),
    STR_COL16 VARCHAR2(2048),
    STR_COL17 VARCHAR2(2048),
    STR_COL18 VARCHAR2(2048),
    STR_COL19 VARCHAR2(2048),
    STR_COL20 VARCHAR2(2048),
    STR_COL21 VARCHAR2(2048),
    STR_COL22 VARCHAR2(2048),
    STR_COL23 VARCHAR2(2048),
    STR_COL24 VARCHAR2(2048),
    STR_COL25 VARCHAR2(2048),
    STR_COL26 VARCHAR2(2048),
    STR_COL27 VARCHAR2(2048),
    STR_COL28 VARCHAR2(2048),
    STR_COL29 VARCHAR2(2048),
    STR_COL30 VARCHAR2(2048),
    STR_COL31 VARCHAR2(2048),
    STR_COL32 VARCHAR2(2048),
    STR_COL33 VARCHAR2(2048),
    STR_COL34 VARCHAR2(2048),
    STR_COL35 VARCHAR2(2048),
    STR_COL36 VARCHAR2(2048),
    STR_COL37 VARCHAR2(2048),
    STR_COL38 VARCHAR2(2048),
    STR_COL39 VARCHAR2(2048),
    STR_COL40 VARCHAR2(2048),
    STR_COL41 VARCHAR2(2048),
    STR_COL42 VARCHAR2(2048),
    STR_COL43 VARCHAR2(2048),
    STR_COL44 VARCHAR2(2048),
    STR_COL45 VARCHAR2(2048),
    STR_COL46 VARCHAR2(2048),
    STR_COL47 VARCHAR2(2048),
    STR_COL48 VARCHAR2(2048),
    STR_COL49 VARCHAR2(2048),
    STR_COL50 VARCHAR2(2048),
    STR_COL51 VARCHAR2(2048),
    STR_COL52 VARCHAR2(2048),
    STR_COL53 VARCHAR2(2048),
    STR_COL54 VARCHAR2(2048),
    STR_COL55 VARCHAR2(2048),
    STR_COL56 VARCHAR2(2048),
    STR_COL57 VARCHAR2(2048),
    STR_COL58 VARCHAR2(2048),
    STR_COL59 VARCHAR2(2048),
    STR_COL60 VARCHAR2(2048),
    STR_COL61 VARCHAR2(2048),
    STR_COL62 VARCHAR2(2048),
    STR_COL63 VARCHAR2(2048),
    STR_COL64 VARCHAR2(2048),
    STR_COL65 VARCHAR2(2048),
    STR_COL66 VARCHAR2(2048),
    STR_COL67 VARCHAR2(2048),
    STR_COL68 VARCHAR2(2048),
    STR_COL69 VARCHAR2(2048),
    STR_COL70 VARCHAR2(2048),
    STR_COL71 VARCHAR2(2048),
    STR_COL72 VARCHAR2(2048),
    STR_COL73 VARCHAR2(2048),
    STR_COL74 VARCHAR2(2048),
    STR_COL75 VARCHAR2(2048),
    STR_COL76 VARCHAR2(2048),
    STR_COL77 VARCHAR2(2048),
    STR_COL78 VARCHAR2(2048),
    STR_COL79 VARCHAR2(2048),
    STR_COL80 VARCHAR2(2048),
    STR_COL81 VARCHAR2(2048),
    STR_COL82 VARCHAR2(2048),
    STR_COL83 VARCHAR2(2048),
    STR_COL84 VARCHAR2(2048),
    STR_COL85 VARCHAR2(2048),
    STR_COL86 VARCHAR2(2048),
    STR_COL87 VARCHAR2(2048),
    STR_COL88 VARCHAR2(2048),
    STR_COL89 VARCHAR2(2048),
    STR_COL90 VARCHAR2(2048),
    STR_COL91 VARCHAR2(2048),
    STR_COL92 VARCHAR2(2048),
    STR_COL93 VARCHAR2(2048),
    STR_COL94 VARCHAR2(2048),
    STR_COL95 VARCHAR2(2048),
    STR_COL96 VARCHAR2(2048),
    STR_COL97 VARCHAR2(2048),
    STR_COL98 VARCHAR2(2048),
    STR_COL99 VARCHAR2(2048),
    NUM_COL0 NUMBER,
    NUM_COL1 NUMBER,
    NUM_COL2 NUMBER,
    NUM_COL3 NUMBER,
    NUM_COL4 NUMBER,
    NUM_COL5 NUMBER,
    NUM_COL6 NUMBER,
    NUM_COL7 NUMBER,
    NUM_COL8 NUMBER,
    NUM_COL9 NUMBER,
    NUM_COL10 NUMBER,
    NUM_COL11 NUMBER,
    NUM_COL12 NUMBER,
    NUM_COL13 NUMBER,
    NUM_COL14 NUMBER,
    NUM_COL15 NUMBER,
    NUM_COL16 NUMBER,
    NUM_COL17 NUMBER,
    NUM_COL18 NUMBER,
    NUM_COL19 NUMBER,
    NUM_COL20 NUMBER,
    NUM_COL21 NUMBER,
    NUM_COL22 NUMBER,
    NUM_COL23 NUMBER,
    NUM_COL24 NUMBER,
    NUM_COL25 NUMBER,
    NUM_COL26 NUMBER,
    NUM_COL27 NUMBER,
    NUM_COL28 NUMBER,
    NUM_COL29 NUMBER,
    NUM_COL30 NUMBER,
    NUM_COL31 NUMBER,
    NUM_COL32 NUMBER,
    NUM_COL33 NUMBER,
    NUM_COL34 NUMBER,
    NUM_COL35 NUMBER,
    NUM_COL36 NUMBER,
    NUM_COL37 NUMBER,
    NUM_COL38 NUMBER,
    NUM_COL39 NUMBER,
    DATE_COL0 DATE,
    DATE_COL1 DATE,
    DATE_COL2 DATE,
    DATE_COL3 DATE,
    DATE_COL4 DATE,
    DATE_COL5 DATE,
    DATE_COL6 DATE,
    DATE_COL7 DATE,
    DATE_COL8 DATE,
    DATE_COL9 DATE,
    DATE_COL10 DATE,
    DATE_COL11 DATE,
    DATE_COL12 DATE,
    DATE_COL13 DATE,
    DATE_COL14 DATE,
    DATE_COL15 DATE,
    DATE_COL16 DATE,
    DATE_COL17 DATE,
    DATE_COL18 DATE,
    DATE_COL19 DATE,
    DATE_COL20 DATE,
    DATE_COL21 DATE,
    DATE_COL22 DATE,
    DATE_COL23 DATE,
    DATE_COL24 DATE,
    DATE_COL25 DATE,
    DATE_COL26 DATE,
    DATE_COL27 DATE,
    DATE_COL28 DATE,
    DATE_COL29 DATE,
    DATE_COL30 DATE,
    DATE_COL31 DATE,
    DATE_COL32 DATE,
    DATE_COL33 DATE,
    DATE_COL34 DATE,
    DATE_COL35 DATE,
    DATE_COL36 DATE,
    DATE_COL37 DATE,
    DATE_COL38 DATE,
    DATE_COL39 DATE,
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(256) NOT NULL,
    CREATED_BY_IDCTX VARCHAR2(256) NOT NULL,
    LAST_UPDATED_BY VARCHAR2(256) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY_IDCTX VARCHAR2(256) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_EXT_USER_PROPERTY_VALUE
 AS SELECT GUID, PARTICIPANT_ID, PARTICIPANT_TYPE, IDENTITY_CONTEXT, STR_COL0, STR_COL1, STR_COL2, STR_COL3, STR_COL4, STR_COL5, STR_COL6, STR_COL7, STR_COL8, STR_COL9, STR_COL10, STR_COL11, STR_COL12, STR_COL13, STR_COL14, STR_COL15, STR_COL16, STR_COL17, STR_COL18, STR_COL19, STR_COL20, STR_COL21, STR_COL22, STR_COL23, STR_COL24, STR_COL25, STR_COL26, STR_COL27, STR_COL28, STR_COL29, STR_COL30, STR_COL31, STR_COL32, STR_COL33, STR_COL34, STR_COL35, STR_COL36, STR_COL37, STR_COL38, STR_COL39, STR_COL40, STR_COL41, STR_COL42, STR_COL43, STR_COL44, STR_COL45, STR_COL46, STR_COL47, STR_COL48, STR_COL49, STR_COL50, STR_COL51, STR_COL52, STR_COL53, STR_COL54, STR_COL55, STR_COL56, STR_COL57, STR_COL58, STR_COL59, STR_COL60, STR_COL61, STR_COL62, STR_COL63, STR_COL64, STR_COL65, STR_COL66, STR_COL67, STR_COL68, STR_COL69, STR_COL70, STR_COL71, STR_COL72, STR_COL73, STR_COL74, STR_COL75, STR_COL76, STR_COL77, STR_COL78, STR_COL79, STR_COL80, STR_COL81, STR_COL82, STR_COL83, STR_COL84, STR_COL85, STR_COL86, STR_COL87, STR_COL88, STR_COL89, STR_COL90, STR_COL91, STR_COL92, STR_COL93, STR_COL94, STR_COL95, STR_COL96, STR_COL97, STR_COL98, STR_COL99, NUM_COL0, NUM_COL1, NUM_COL2, NUM_COL3, NUM_COL4, NUM_COL5, NUM_COL6, NUM_COL7, NUM_COL8, NUM_COL9, NUM_COL10, NUM_COL11, NUM_COL12, NUM_COL13, NUM_COL14, NUM_COL15, NUM_COL16, NUM_COL17, NUM_COL18, NUM_COL19, NUM_COL20, NUM_COL21, NUM_COL22, NUM_COL23, NUM_COL24, NUM_COL25, NUM_COL26, NUM_COL27, NUM_COL28, NUM_COL29, NUM_COL30, NUM_COL31, NUM_COL32, NUM_COL33, NUM_COL34, NUM_COL35, NUM_COL36, NUM_COL37, NUM_COL38, NUM_COL39, DATE_COL0, DATE_COL1, DATE_COL2, DATE_COL3, DATE_COL4, DATE_COL5, DATE_COL6, DATE_COL7, DATE_COL8, DATE_COL9, DATE_COL10, DATE_COL11, DATE_COL12, DATE_COL13, DATE_COL14, DATE_COL15, DATE_COL16, DATE_COL17, DATE_COL18, DATE_COL19, DATE_COL20, DATE_COL21, DATE_COL22, DATE_COL23, DATE_COL24, DATE_COL25, DATE_COL26, DATE_COL27, DATE_COL28, DATE_COL29, DATE_COL30, DATE_COL31, DATE_COL32, DATE_COL33, DATE_COL34, DATE_COL35, DATE_COL36, DATE_COL37, DATE_COL38, DATE_COL39, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_BY, LAST_UPDATED_DATE, LAST_UPDATED_BY_IDCTX FROM E$BPM_EXT_USER_PROPERTY_VALUE;

ALTER TABLE E$BPM_EXT_USER_PROPERTY_VALUE
    ADD CONSTRAINT BPM_EXT_USER_PROPERTY_VALUE_PK PRIMARY KEY (GUID);

CREATE INDEX BPM_PROP_VALUES_PARTICIPANT ON E$BPM_EXT_USER_PROPERTY_VALUE
    (PARTICIPANT_ID , PARTICIPANT_TYPE , IDENTITY_CONTEXT );

-- ----------------------------------------------------------------------- 
-- E$BPM_HOLIDAY_RULE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_HOLIDAY_RULE
(
    ID VARCHAR2(64) NOT NULL,
    NAME VARCHAR2(512) NOT NULL,
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDCTX VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDCTX VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_HOLIDAY_RULE
 AS SELECT ID, NAME, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDCTX FROM E$BPM_HOLIDAY_RULE;

ALTER TABLE E$BPM_HOLIDAY_RULE
    ADD CONSTRAINT BPM_HOLIDAY_RULE_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_HOLIDAY_RULE ADD CONSTRAINT BPM_HOLIDAY_RULE_UK UNIQUE
    (NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_HOLIDAYS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_HOLIDAYS
(
    ID VARCHAR2(64) NOT NULL,
    NAME VARCHAR2(512) NOT NULL,
    HOLIDAY_PATTERN VARCHAR2(128) NOT NULL,
    HOLIDAY_RULE_ID VARCHAR2(64) NOT NULL,
    HOLIDAY_DATE DATE,
    NTH INTEGER,
    WEEK_DAY VARCHAR2(32),
    MONTH VARCHAR2(32),
    REF_HOLIDAY_NAME VARCHAR2(512)
);

CREATE OR REPLACE EDITIONING VIEW BPM_HOLIDAYS
 AS SELECT ID, NAME, HOLIDAY_PATTERN, HOLIDAY_RULE_ID, HOLIDAY_DATE, NTH, WEEK_DAY, MONTH, REF_HOLIDAY_NAME FROM E$BPM_HOLIDAYS;

ALTER TABLE E$BPM_HOLIDAYS
    ADD CONSTRAINT BPM_HOLIDAYS_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_HOLIDAYS ADD CONSTRAINT BPM_HOLIDAYS_UK UNIQUE
    (HOLIDAY_RULE_ID , NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_LOGICAL_PEOPLE_GROUP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_LOGICAL_PEOPLE_GROUP
(
    ID VARCHAR2(64) NOT NULL,
    NAME VARCHAR2(400) NOT NULL,
    DESCRIPTION VARCHAR2(2000),
    PEOPLE_QUERY VARCHAR2(4000),
    TIMEOUT VARCHAR2(50),
    STATUS VARCHAR2(50),
    EXPIRATION_TIME TIMESTAMP,
    LAST_EXECUTED_DATE TIMESTAMP,
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDENCONTEXT VARCHAR2(200) NOT NULL,
    ISPARAMETRIC VARCHAR2(1)
);

CREATE OR REPLACE EDITIONING VIEW BPM_LOGICAL_PEOPLE_GROUP
 AS SELECT ID, NAME, DESCRIPTION, PEOPLE_QUERY, TIMEOUT, STATUS, EXPIRATION_TIME, LAST_EXECUTED_DATE, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT, ISPARAMETRIC FROM E$BPM_LOGICAL_PEOPLE_GROUP;

ALTER TABLE E$BPM_LOGICAL_PEOPLE_GROUP
    ADD CONSTRAINT BPM_LOGICAL_PEOPLE_GROUP_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_LOGICAL_PEOPLE_GROUP ADD CONSTRAINT BPM_LPG_UN1 UNIQUE
    (NAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_LPG_MEMBER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_LPG_MEMBER
(
    ID VARCHAR2(64) NOT NULL,
    QUERY_ID VARCHAR2(64) NOT NULL,
    USER_ID VARCHAR2(400) NOT NULL,
    IDENTITY_CONTEXT VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW BPM_LPG_MEMBER
 AS SELECT ID, QUERY_ID, USER_ID, IDENTITY_CONTEXT FROM E$BPM_LPG_MEMBER;

ALTER TABLE E$BPM_LPG_MEMBER
    ADD CONSTRAINT BPM_LPG_MEMBER_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_ORGANIZATIONAL_UNIT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_ORGANIZATIONAL_UNIT
(
    ORGANIZATIONAL_UNIT_ID VARCHAR2(64) NOT NULL,
    PARENT_ORGANIZATIONAL_UNIT_ID VARCHAR2(64),
    HIERARCHY_PATH VARCHAR2(2000),
    ORGANIZATIONAL_UNIT_NAME VARCHAR2(400) NOT NULL,
    DESCRIPTION VARCHAR2(2000),
    CALENDAR_RULE_ID VARCHAR2(64),
    FISCAL_YEAR_ID VARCHAR2(64),
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDENCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_ORGANIZATIONAL_UNIT
 AS SELECT ORGANIZATIONAL_UNIT_ID, PARENT_ORGANIZATIONAL_UNIT_ID, HIERARCHY_PATH, ORGANIZATIONAL_UNIT_NAME, DESCRIPTION, CALENDAR_RULE_ID, FISCAL_YEAR_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_ORGANIZATIONAL_UNIT;

ALTER TABLE E$BPM_ORGANIZATIONAL_UNIT
    ADD CONSTRAINT BPM_ORGANIZATIONAL_UNIT_PK PRIMARY KEY (ORGANIZATIONAL_UNIT_ID);

CREATE INDEX BPM_OU_PARENT_ORG_UNIT_ID ON E$BPM_ORGANIZATIONAL_UNIT
    (PARENT_ORGANIZATIONAL_UNIT_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_OU_MANAGER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_OU_MANAGER
(
    ID VARCHAR2(64) NOT NULL,
    ORGANIZATIONAL_UNIT_ID VARCHAR2(64) NOT NULL,
    USER_ID VARCHAR2(400) NOT NULL,
    USER_TYPE VARCHAR2(200) NOT NULL,
    IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    APPLICATION_CONTEXT VARCHAR2(200),
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDENCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_OU_MANAGER
 AS SELECT ID, ORGANIZATIONAL_UNIT_ID, USER_ID, USER_TYPE, IDENTITY_CONTEXT, APPLICATION_CONTEXT, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_OU_MANAGER;

ALTER TABLE E$BPM_OU_MANAGER
    ADD CONSTRAINT BPM_OU_MANAGER_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_OU_MANAGER ADD CONSTRAINT BPM_OU_MANAGER_UK UNIQUE
    (ORGANIZATIONAL_UNIT_ID , USER_ID , USER_TYPE , IDENTITY_CONTEXT );

-- ----------------------------------------------------------------------- 
-- E$BPM_OU_USER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_OU_USER
(
    ID VARCHAR2(64) NOT NULL,
    ORGANIZATIONAL_UNIT_ID VARCHAR2(64) NOT NULL,
    USER_ID VARCHAR2(400),
    USER_TYPE VARCHAR2(200),
    USER_TYPE_VALUE VARCHAR2(400),
    IDENTITY_CONTEXT VARCHAR2(200),
    APPLICATION_CONTEXT VARCHAR2(200),
    PEOPLE_QUERY VARCHAR2(4000),
    LOGICAL_PEOPLE_QUERY_ID VARCHAR2(200),
    CREATED_DATE TIMESTAMP NOT NULL,
    CREATED_BY VARCHAR2(400) NOT NULL,
    CREATED_BY_IDENTITY_CONTEXT VARCHAR2(200) NOT NULL,
    LAST_UPDATED_DATE TIMESTAMP NOT NULL,
    LAST_UPDATED_BY VARCHAR2(400) NOT NULL,
    LAST_UPDATED_BY_IDENCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_OU_USER
 AS SELECT ID, ORGANIZATIONAL_UNIT_ID, USER_ID, USER_TYPE, USER_TYPE_VALUE, IDENTITY_CONTEXT, APPLICATION_CONTEXT, PEOPLE_QUERY, LOGICAL_PEOPLE_QUERY_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_OU_USER;

ALTER TABLE E$BPM_OU_USER
    ADD CONSTRAINT BPM_OU_USER_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$BPM_PP_ENTITY_GS_MAP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PP_ENTITY_GS_MAP
(
    ENTITY_ID VARCHAR2(50) NOT NULL,
    ENTITY_TYPE VARCHAR2(10) NOT NULL,
    GS_ID VARCHAR2(400) NOT NULL,
    ROWVERSION NUMBER(10,0)
);

CREATE OR REPLACE EDITIONING VIEW BPM_PP_ENTITY_GS_MAP
 AS SELECT ENTITY_ID, ENTITY_TYPE, GS_ID, ROWVERSION FROM E$BPM_PP_ENTITY_GS_MAP;

ALTER TABLE E$BPM_PP_ENTITY_GS_MAP ADD CONSTRAINT BPM_PP_ENTITY_GS_MAP_UK UNIQUE
    (ENTITY_ID , ENTITY_TYPE , GS_ID );

-- ----------------------------------------------------------------------- 
-- E$BPM_PRESENTATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PRESENTATION
(
    PRESENTATIONNAME VARCHAR2(100) NOT NULL,
    PRESENTATIONID VARCHAR2(64) NOT NULL,
    PRESENTATIONTYPE VARCHAR2(15) NOT NULL,
    PRESENTATIONOWNER VARCHAR2(400) NOT NULL,
    IDENTITYCONTEXT VARCHAR2(200) NOT NULL,
    DEFINITION BLOB,
    CREATEDDATE TIMESTAMP,
    UPDATEDDATE TIMESTAMP,
    CREATEDBY VARCHAR2(400),
    UPDATEDBY VARCHAR2(400)
)
;

CREATE OR REPLACE EDITIONING VIEW BPM_PRESENTATION
 AS SELECT PRESENTATIONNAME, PRESENTATIONID, PRESENTATIONTYPE, PRESENTATIONOWNER, IDENTITYCONTEXT, DEFINITION, CREATEDDATE, UPDATEDDATE, CREATEDBY, UPDATEDBY FROM E$BPM_PRESENTATION;

ALTER TABLE E$BPM_PRESENTATION
    ADD CONSTRAINT BPM_PRESENTATION_PK PRIMARY KEY (PRESENTATIONID);

ALTER TABLE E$BPM_PRESENTATION ADD CONSTRAINT BPM_PRESENTATION_UIDX UNIQUE
    (PRESENTATIONOWNER , IDENTITYCONTEXT , PRESENTATIONTYPE , PRESENTATIONNAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_PRESENTATION_GRANT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_PRESENTATION_GRANT
(
    ID VARCHAR2(64) NOT NULL,
    PRESENTATIONID VARCHAR2(64) NOT NULL,
    GRANTEENAME VARCHAR2(400) NOT NULL,
    GRANTEETYPE VARCHAR2(20) NOT NULL,
    IDENTITYAPPCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_PRESENTATION_GRANT
 AS SELECT ID, PRESENTATIONID, GRANTEENAME, GRANTEETYPE, IDENTITYAPPCONTEXT FROM E$BPM_PRESENTATION_GRANT;

ALTER TABLE E$BPM_PRESENTATION_GRANT
    ADD CONSTRAINT BPM_PRESENTATION_GRANT_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_PRESENTATION_GRANT ADD CONSTRAINT BPM_PRESENTATION_GRANT_UIdx UNIQUE
    (GRANTEENAME , GRANTEETYPE , IDENTITYAPPCONTEXT , PRESENTATIONID );

CREATE INDEX BPM_PRESNTATION_GRANT_Id_I ON E$BPM_PRESENTATION_GRANT
    (PRESENTATIONID );

-- ----------------------------------------------------------------------- 
-- E$BPM_USERAPPLICATIONDATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_USERAPPLICATIONDATA
(
    APPLICATIONDATAID VARCHAR2(64) NOT NULL,
    APPLICATIONDATANAME VARCHAR2(100) NOT NULL,
    APPLICATIONDATATYPE VARCHAR2(150) NOT NULL,
    OWNER VARCHAR2(400) NOT NULL,
    IDENTITYCONTEXT VARCHAR2(200) NOT NULL,
    CREATEDDATE TIMESTAMP,
    UPDATEDDATE TIMESTAMP,
    CREATEDBY VARCHAR2(400),
    UPDATEDBY VARCHAR2(400),
    APPLICATIONDATA BLOB
)
;

CREATE OR REPLACE EDITIONING VIEW BPM_USERAPPLICATIONDATA
 AS SELECT APPLICATIONDATAID, APPLICATIONDATANAME, APPLICATIONDATATYPE, OWNER, IDENTITYCONTEXT, CREATEDDATE, UPDATEDDATE, CREATEDBY, UPDATEDBY, APPLICATIONDATA FROM E$BPM_USERAPPLICATIONDATA;

ALTER TABLE E$BPM_USERAPPLICATIONDATA
    ADD CONSTRAINT BPM_USERAPPLICATIONDATA_PK PRIMARY KEY (APPLICATIONDATAID);

ALTER TABLE E$BPM_USERAPPLICATIONDATA ADD CONSTRAINT BPM_USERAPPLICATIONDATA_UIdx UNIQUE
    (OWNER , IDENTITYCONTEXT , APPLICATIONDATATYPE , APPLICATIONDATANAME );

-- ----------------------------------------------------------------------- 
-- E$BPM_USERAPPLICATIONDATA_GRAN 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BPM_USERAPPLICATIONDATA_GRAN
(
    ID VARCHAR2(64) NOT NULL,
    APPLICATIONDATAID VARCHAR2(64) NOT NULL,
    GRANTEENAME VARCHAR2(400) NOT NULL,
    GRANTEETYPE VARCHAR2(20) NOT NULL,
    IDENTITYAPPCONTEXT VARCHAR2(200) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW BPM_USERAPPLICATIONDATA_GRANT
 AS SELECT ID, APPLICATIONDATAID, GRANTEENAME, GRANTEETYPE, IDENTITYAPPCONTEXT FROM E$BPM_USERAPPLICATIONDATA_GRAN;

ALTER TABLE E$BPM_USERAPPLICATIONDATA_GRAN
    ADD CONSTRAINT BPM_USERAPPLICA_NDATA_GRANT_PK PRIMARY KEY (ID);

ALTER TABLE E$BPM_USERAPPLICATIONDATA_GRAN ADD CONSTRAINT BPM_USERAPPDATA_GRANT_UIdx UNIQUE
    (GRANTEENAME , GRANTEETYPE , IDENTITYAPPCONTEXT , APPLICATIONDATAID );

CREATE INDEX BPM_USERAPPDATA_GRANT_ID_I ON E$BPM_USERAPPLICATIONDATA_GRAN
    (APPLICATIONDATAID );

-- ----------------------------------------------------------------------- 
-- E$DocumentDefinition 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentDefinition
(
    id VARCHAR2(64) NOT NULL,
    name VARCHAR2(200),
    description VARCHAR2(2000),
    packageDefinitionId VARCHAR2(200),
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW DocumentDefinition
 AS SELECT id, name, description, packageDefinitionId, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentDefinition;

ALTER TABLE E$DocumentDefinition
    ADD CONSTRAINT DocumentDefinition_PK PRIMARY KEY (id);

CREATE INDEX DocDefName_I ON E$DocumentDefinition
    (name );

CREATE INDEX DocDefPacDefId_I ON E$DocumentDefinition
    (packageDefinitionId );

-- ----------------------------------------------------------------------- 
-- E$DocumentInstance 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentInstance
(
    id VARCHAR2(64) NOT NULL,
    packageInstanceId VARCHAR2(200),
    ucmId VARCHAR2(200),
    ucmUrl VARCHAR2(2000),
    name VARCHAR2(2000),
    docType VARCHAR2(2000),
    status VARCHAR2(100),
    updatedDate DATE,
    updatedBy VARCHAR2(200),
    createdDate DATE,
    version NUMBER,
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000),
    systemTextAttribute3 VARCHAR2(2000),
    systemDateAttribute1 DATE,
    systemDateAttribute2 DATE,
    systemDateAttribute3 DATE,
    systemNumberAttribute1 NUMBER,
    systemNumberAttribute2 NUMBER,
    systemNumberAttribute3 NUMBER
);

CREATE OR REPLACE EDITIONING VIEW DocumentInstance
 AS SELECT id, packageInstanceId, ucmId, ucmUrl, name, docType, status, updatedDate, updatedBy, createdDate, version, systemTextAttribute1, systemTextAttribute2, systemTextAttribute3, systemDateAttribute1, systemDateAttribute2, systemDateAttribute3, systemNumberAttribute1, systemNumberAttribute2, systemNumberAttribute3 FROM E$DocumentInstance;

ALTER TABLE E$DocumentInstance
    ADD CONSTRAINT DocumentInstance_PK PRIMARY KEY (id);

CREATE INDEX DocInstName_I ON E$DocumentInstance
    (name );

CREATE INDEX DocInstPacInsId_I ON E$DocumentInstance
    (packageInstanceId );

-- ----------------------------------------------------------------------- 
-- E$DocumentPackageDefinition 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentPackageDefinition
(
    id VARCHAR2(64) NOT NULL,
    name VARCHAR2(200),
    description VARCHAR2(2000),
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW DocumentPackageDefinition
 AS SELECT id, name, description, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentPackageDefinition;

ALTER TABLE E$DocumentPackageDefinition
    ADD CONSTRAINT DocumentPackageDefinition_PK PRIMARY KEY (id);

CREATE INDEX DocPackDefName_I ON E$DocumentPackageDefinition
    (name );

-- ----------------------------------------------------------------------- 
-- E$DocumentPackageInstance 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentPackageInstance
(
    id VARCHAR2(64) NOT NULL,
    name VARCHAR2(200),
    status VARCHAR2(100),
    packageDefinitionId VARCHAR2(200),
    updatedDate DATE,
    updatedBy VARCHAR2(200),
    description VARCHAR2(2000),
    searchableTextCol1 VARCHAR2(2000),
    searchableTextCol2 VARCHAR2(2000),
    searchableTextCol3 VARCHAR2(2000),
    searchableTextCol4 VARCHAR2(2000),
    searchableTextCol5 VARCHAR2(2000),
    searchableTextCol6 VARCHAR2(2000),
    searchableDateCol1 DATE,
    searchableDateCol2 DATE,
    searchableDateCol3 DATE,
    searchableDateCol4 DATE,
    searchableNumberCol1 NUMBER,
    searchableNumberCol2 NUMBER,
    searchableNumberCol3 NUMBER,
    searchableNumberCol4 NUMBER,
    searchableNumberCol5 NUMBER,
    searchableNumberCol6 NUMBER,
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000),
    systemTextAttribute3 VARCHAR2(2000),
    systemDateAttribute1 DATE,
    systemDateAttribute2 DATE,
    systemDateAttribute3 DATE,
    systemNumberAttribute1 NUMBER,
    systemNumberAttribute2 NUMBER,
    systemNumberAttribute3 NUMBER
);

CREATE OR REPLACE EDITIONING VIEW DocumentPackageInstance
 AS SELECT id, name, status, packageDefinitionId, updatedDate, updatedBy, description, searchableTextCol1, searchableTextCol2, searchableTextCol3, searchableTextCol4, searchableTextCol5, searchableTextCol6, searchableDateCol1, searchableDateCol2, searchableDateCol3, searchableDateCol4, searchableNumberCol1, searchableNumberCol2, searchableNumberCol3, searchableNumberCol4, searchableNumberCol5, searchableNumberCol6, systemTextAttribute1, systemTextAttribute2, systemTextAttribute3, systemDateAttribute1, systemDateAttribute2, systemDateAttribute3, systemNumberAttribute1, systemNumberAttribute2, systemNumberAttribute3 FROM E$DocumentPackageInstance;

ALTER TABLE E$DocumentPackageInstance
    ADD CONSTRAINT DocumentPackageInstance_PK PRIMARY KEY (id);

CREATE INDEX DocPackInstPackDefId_I ON E$DocumentPackageInstance
    (packageDefinitionId );

CREATE INDEX DocPackInstSDate1_I ON E$DocumentPackageInstance
    (searchableDateCol1 );

CREATE INDEX DocPackInstSDate2_I ON E$DocumentPackageInstance
    (searchableDateCol2 );

CREATE INDEX DocPackInstSDate3_I ON E$DocumentPackageInstance
    (searchableDateCol3 );

CREATE INDEX DocPackInstSDate4_I ON E$DocumentPackageInstance
    (searchableDateCol4 );

CREATE INDEX DocPackInstSNum1_I ON E$DocumentPackageInstance
    (searchableNumberCol1 );

CREATE INDEX DocPackInstSNum2_I ON E$DocumentPackageInstance
    (searchableNumberCol2 );

CREATE INDEX DocPackInstSNum3_I ON E$DocumentPackageInstance
    (searchableNumberCol3 );

CREATE INDEX DocPackInstSNum4_I ON E$DocumentPackageInstance
    (searchableNumberCol4 );

CREATE INDEX DocPackInstSNum5_I ON E$DocumentPackageInstance
    (searchableNumberCol5 );

CREATE INDEX DocPackInstSNum6_I ON E$DocumentPackageInstance
    (searchableNumberCol6 );

CREATE INDEX DocPackInstSText1_I ON E$DocumentPackageInstance
    (searchableTextCol1 );

CREATE INDEX DocPackInstSText2_I ON E$DocumentPackageInstance
    (searchableTextCol2 );

CREATE INDEX DocPackInstSText3_I ON E$DocumentPackageInstance
    (searchableTextCol3 );

CREATE INDEX DocPackInstSText4_I ON E$DocumentPackageInstance
    (searchableTextCol4 );

CREATE INDEX DocPackInstSText5_I ON E$DocumentPackageInstance
    (searchableTextCol5 );

CREATE INDEX DocPackInstSText6_I ON E$DocumentPackageInstance
    (searchableTextCol6 );

-- ----------------------------------------------------------------------- 
-- E$DocumentPackageProcess 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentPackageProcess
(
    processDefinitionId VARCHAR2(400),
    packageDefinitionId VARCHAR2(200),
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000),
    systemTextAttribute3 VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW DocumentPackageProcess
 AS SELECT processDefinitionId, packageDefinitionId, systemTextAttribute1, systemTextAttribute2, systemTextAttribute3 FROM E$DocumentPackageProcess;

CREATE INDEX DocPacProcessPacDefId_I ON E$DocumentPackageProcess
    (packageDefinitionId );

CREATE INDEX DocPacProcessProcDefId_I ON E$DocumentPackageProcess
    (processDefinitionId );

-- ----------------------------------------------------------------------- 
-- E$DocumentPackageProperties 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentPackageProperties
(
    parentId VARCHAR2(200),
    parentType VARCHAR2(200),
    name VARCHAR2(200),
    stringValue VARCHAR2(2000),
    dateValue DATE,
    numValue NUMBER,
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW DocumentPackageProperties
 AS SELECT parentId, parentType, name, stringValue, dateValue, numValue, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentPackageProperties;

CREATE INDEX DocPackPropsParentId_I ON E$DocumentPackageProperties
    (parentId );

-- ----------------------------------------------------------------------- 
-- E$DocumentPackagePropertiesMap 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$DocumentPackagePropertiesMap
(
    propertyName VARCHAR2(200),
    columnName VARCHAR2(200),
    systemTextAttribute1 VARCHAR2(2000),
    systemTextAttribute2 VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW DocumentPackagePropertiesMap
 AS SELECT propertyName, columnName, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentPackagePropertiesMap;

CREATE INDEX DocPackPropMapPrpName_I ON E$DocumentPackagePropertiesMap
    (propertyName );

-- ----------------------------------------------------------------------- 
-- E$NotificationTracker 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$NotificationTracker
(
    id NVARCHAR2(200) NOT NULL,
    componenttype NVARCHAR2(200),
    componentnumber NVARCHAR2(200),
    componentid NVARCHAR2(200),
    emailfromaddress NVARCHAR2(200),
    emailtoaddress NVARCHAR2(2000),
    emailccaddress NVARCHAR2(2000),
    emailsubject NVARCHAR2(2000),
    emailattachmentnames NVARCHAR2(2000),
    emailmessageid NVARCHAR2(200),
    emailinreplytoid NVARCHAR2(200),
    emailreferences NVARCHAR2(2000),
    emailprocessedtime TIMESTAMP,
    composite_dn VARCHAR2(500),
    composite_instanceid VARCHAR2(200),
    component_name VARCHAR2(200),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    emailcontent BLOB
)
;

CREATE OR REPLACE EDITIONING VIEW NotificationTracker
 AS SELECT id, componenttype, componentnumber, componentid, emailfromaddress, emailtoaddress, emailccaddress, emailsubject, emailattachmentnames, emailmessageid, emailinreplytoid, emailreferences, emailprocessedtime, composite_dn, composite_instanceid, component_name, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, emailcontent FROM E$NotificationTracker;

ALTER TABLE E$NotificationTracker
    ADD CONSTRAINT NotificationTracker_PK PRIMARY KEY (id);

CREATE INDEX NotifiTracker_CompTypeNumber_I ON E$NotificationTracker
    (componenttype , componentnumber );

-- ----------------------------------------------------------------------- 
-- E$NotifTrackerAttachments 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$NotifTrackerAttachments
(
    emailmessageid NVARCHAR2(200),
    attachmentname NVARCHAR2(200),
    emailprocessedtime TIMESTAMP,
    trackingid NVARCHAR2(200),
    attachmentcontent BLOB
)
;

CREATE OR REPLACE EDITIONING VIEW NotifTrackerAttachments
 AS SELECT emailmessageid, attachmentname, emailprocessedtime, trackingid, attachmentcontent FROM E$NotifTrackerAttachments;

CREATE INDEX NotifAttach_MsgIdAttachName_I ON E$NotifTrackerAttachments
    (emailmessageid , attachmentname );

-- ----------------------------------------------------------------------- 
-- E$WFApprovalGroupMembers 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFApprovalGroupMembers
(
    approvalGroupId NUMBER NOT NULL,
    member VARCHAR2(400) NOT NULL,
    type VARCHAR2(8) NOT NULL,
    sequence NUMBER NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW WFApprovalGroupMembers
 AS SELECT approvalGroupId, member, type, sequence FROM E$WFApprovalGroupMembers;

-- ----------------------------------------------------------------------- 
-- E$WFApprovalGroups 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFApprovalGroups
(
    approvalGroupId NUMBER NOT NULL,
    approvalGroupName VARCHAR2(400) NOT NULL,
    javaClass VARCHAR2(2000),
    owner VARCHAR2(400)
);

CREATE OR REPLACE EDITIONING VIEW WFApprovalGroups
 AS SELECT approvalGroupId, approvalGroupName, javaClass, owner FROM E$WFApprovalGroups;

ALTER TABLE E$WFApprovalGroups
    ADD CONSTRAINT WFApprovalGroups_PK PRIMARY KEY (approvalGroupId);

ALTER TABLE E$WFApprovalGroups ADD CONSTRAINT WFApprovalGroups_U1_I UNIQUE
    (approvalGroupName );

-- ----------------------------------------------------------------------- 
-- E$WFAssignee 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFAssignee
(
    taskId VARCHAR2(64) NOT NULL,
    version NUMBER NOT NULL,
    assignee VARCHAR2(400) NOT NULL,
    guid VARCHAR2(64),
    isGroup VARCHAR2(2),
    assigneeType VARCHAR2(20) NOT NULL,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    numberOfAssignments NUMBER DEFAULT 1,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFAssignee
 AS SELECT taskId, version, assignee, guid, isGroup, assigneeType, taskCreatedDate, compositeCreatedTime, taskState, numberOfAssignments, FLOW_ID, SCA_PARTITION_ID FROM E$WFAssignee;

ALTER TABLE E$WFAssignee
    ADD CONSTRAINT WFAssignee_PK PRIMARY KEY (taskId, version, assignee, assigneeType);

CREATE INDEX WFAssigneeAssignee_I ON E$WFAssignee
    (assignee );

CREATE INDEX WFAssigneeAssigneeTyp_I ON E$WFAssignee
    (assignee , assigneeType );

CREATE INDEX WFAssigneeCompositeId_I ON E$WFAssignee
    (taskId , isGroup , assignee );

CREATE INDEX WFAssigneeTaskId_I ON E$WFAssignee
    (taskId );

CREATE INDEX WFAssigneeType_I ON E$WFAssignee
    (taskId , assignee , assigneeType );

-- ----------------------------------------------------------------------- 
-- E$WFAttachment 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFAttachment
(
    taskId VARCHAR2(64),
    version NUMBER,
    maxVersion NUMBER,
    updatedBy VARCHAR2(400),
    updatedByDisplayName VARCHAR2(400),
    updatedDate DATE,
    encoding VARCHAR2(100),
    uri VARCHAR2(256),
    content BLOB,
    name VARCHAR2(2000),
    acl VARCHAR2(200),
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    correlationId VARCHAR2(64),
    attachmentSize NUMBER,
    description VARCHAR2(2000),
    storageType VARCHAR2(64),
    scope VARCHAR2(64),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFAttachment
 AS SELECT taskId, version, maxVersion, updatedBy, updatedByDisplayName, updatedDate, encoding, uri, content, name, acl, taskCreatedDate, compositeCreatedTime, taskState, correlationId, attachmentSize, description, storageType, scope, FLOW_ID, SCA_PARTITION_ID FROM E$WFAttachment;

CREATE UNIQUE INDEX WFAttachment_unique ON E$WFAttachment
    (taskId , version , updatedBy , name , correlationId );

CREATE INDEX WFAttachmentCorrelationId_I ON E$WFAttachment
    (correlationId , name );

-- ----------------------------------------------------------------------- 
-- E$WFAttributeLabelMap 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFAttributeLabelMap
(
    id VARCHAR2(64) NOT NULL,
    taskAttribute VARCHAR2(100),
    labelName VARCHAR2(500) NOT NULL,
    createdDate DATE,
    active VARCHAR2(1),
    workflowType VARCHAR2(30),
    dataType VARCHAR2(10),
    updatedDate DATE,
    description VARCHAR2(200),
    formatStyle VARCHAR2(30)
);

CREATE OR REPLACE EDITIONING VIEW WFAttributeLabelMap
 AS SELECT id, taskAttribute, labelName, createdDate, active, workflowType, dataType, updatedDate, description, formatStyle FROM E$WFAttributeLabelMap;

ALTER TABLE E$WFAttributeLabelMap
    ADD CONSTRAINT WFAttributeLabelMap_PK PRIMARY KEY (id);

ALTER TABLE E$WFAttributeLabelMap ADD CONSTRAINT wfattributemap_uk UNIQUE
    (labelName );

-- ----------------------------------------------------------------------- 
-- E$WFAttributeLabelUsage 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFAttributeLabelUsage
(
    mapId VARCHAR2(64) NOT NULL,
    workflowId VARCHAR2(200) NOT NULL,
    workflowName VARCHAR2(60),
    attributeName VARCHAR2(500),
    xpathExpression VARCHAR2(1000),
    xpathNamespaces CLOB,
    createdDate DATE,
    description VARCHAR2(200),
    componentType VARCHAR2(10)
)
;

CREATE OR REPLACE EDITIONING VIEW WFAttributeLabelUsage
 AS SELECT mapId, workflowId, workflowName, attributeName, xpathExpression, xpathNamespaces, createdDate, description, componentType FROM E$WFAttributeLabelUsage;

ALTER TABLE E$WFAttributeLabelUsage ADD CONSTRAINT wfattributeusage_uk UNIQUE
    (mapId , workflowId );

-- ----------------------------------------------------------------------- 
-- E$WFCertAuthority 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFCertAuthority
(
    caName VARCHAR2(2000) NOT NULL,
    caURL VARCHAR2(2000)
);

CREATE OR REPLACE EDITIONING VIEW WFCertAuthority
 AS SELECT caName, caURL FROM E$WFCertAuthority;

ALTER TABLE E$WFCertAuthority
    ADD CONSTRAINT WFCertAuthority_PK PRIMARY KEY (caName);

-- ----------------------------------------------------------------------- 
-- E$WFCertificate 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFCertificate
(
    certificateNo VARCHAR2(200) NOT NULL,
    caName VARCHAR2(2000) NOT NULL,
    userId VARCHAR2(200),
    identityContext VARCHAR2(200),
    certificate CLOB,
    revocationId VARCHAR2(64)
)
;

CREATE OR REPLACE EDITIONING VIEW WFCertificate
 AS SELECT certificateNo, caName, userId, identityContext, certificate, revocationId FROM E$WFCertificate;

ALTER TABLE E$WFCertificate
    ADD CONSTRAINT WFCertificate_PK PRIMARY KEY (certificateNo, caName);

-- ----------------------------------------------------------------------- 
-- E$WFCertificateRevoked 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFCertificateRevoked
(
    revocationId VARCHAR2(64) NOT NULL,
    caName VARCHAR2(2000),
    validationMode VARCHAR2(64),
    validationIssuedDate DATE,
    nextValidationDate DATE,
    validationData CLOB
)
;

CREATE OR REPLACE EDITIONING VIEW WFCertificateRevoked
 AS SELECT revocationId, caName, validationMode, validationIssuedDate, nextValidationDate, validationData FROM E$WFCertificateRevoked;

ALTER TABLE E$WFCertificateRevoked
    ADD CONSTRAINT WFCertificateRevoked_PK PRIMARY KEY (revocationId);

-- ----------------------------------------------------------------------- 
-- E$WFCollectionTarget 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFCollectionTarget
(
    taskId VARCHAR2(64),
    id VARCHAR2(64),
    xpath VARCHAR2(300),
    DISPLAYNAME VARCHAR2(300),
    collectionName VARCHAR2(300),
    collectionNamespace VARCHAR2(2000),
    type VARCHAR2(50),
    targetIndex NUMBER,
    keyList VARCHAR2(2000),
    referencedTaskId VARCHAR2(64),
    taskAggregationId VARCHAR2(64),
    action VARCHAR2(200),
    actionParams VARCHAR2(2000),
    version NUMBER,
    maxVersion NUMBER,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFCollectionTarget
 AS SELECT taskId, id, xpath, DISPLAYNAME, collectionName, collectionNamespace, type, targetIndex, keyList, referencedTaskId, taskAggregationId, action, actionParams, version, maxVersion, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFCollectionTarget;

CREATE INDEX WFCollectionTargetTaskIdHash_I ON E$WFCollectionTarget
    (taskId , version );

CREATE INDEX WFCollectionTargetIdHash_I ON E$WFCollectionTarget
    (id );

-- ----------------------------------------------------------------------- 
-- E$WFComments 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFComments
(
    taskId VARCHAR2(64),
    version NUMBER,
    updatedBy VARCHAR2(400),
    updatedByDisplayName VARCHAR2(400),
    commentDate DATE,
    action VARCHAR2(30),
    wfcomment VARCHAR2(2000),
    displayNameLanguage VARCHAR2(4),
    acl VARCHAR2(200),
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    scope VARCHAR2(64),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFComments
 AS SELECT taskId, version, updatedBy, updatedByDisplayName, commentDate, action, wfcomment, displayNameLanguage, acl, taskCreatedDate, compositeCreatedTime, taskState, scope, FLOW_ID, SCA_PARTITION_ID FROM E$WFComments;

CREATE INDEX WFCommentsTaskId_I ON E$WFComments
    (taskId , version );

CREATE INDEX WFCommentsUpdatedBy_I ON E$WFComments
    (updatedBy );

-- ----------------------------------------------------------------------- 
-- E$WFEvidence 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFEvidence
(
    evidenceId VARCHAR2(64) NOT NULL,
    taskId VARCHAR2(64),
    taskNumber NUMBER,
    taskVersion NUMBER,
    taskPriority NUMBER,
    title VARCHAR2(500),
    titleResourceKey VARCHAR2(100),
    taskStatus VARCHAR2(200),
    taskSubStatus VARCHAR2(200),
    taskOutcome VARCHAR2(100),
    userId VARCHAR2(400),
    identityContext VARCHAR2(200),
    workflowType VARCHAR2(200),
    policy VARCHAR2(32),
    certificateNo VARCHAR2(200),
    caName VARCHAR2(2000),
    plainText BLOB,
    plainTextEncoding VARCHAR2(32),
    signature CLOB,
    createDate DATE,
    signedDate DATE,
    verifiedDate DATE,
    errorMessage VARCHAR2(4000),
    status VARCHAR2(20),
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFEvidence
 AS SELECT evidenceId, taskId, taskNumber, taskVersion, taskPriority, title, titleResourceKey, taskStatus, taskSubStatus, taskOutcome, userId, identityContext, workflowType, policy, certificateNo, caName, plainText, plainTextEncoding, signature, createDate, signedDate, verifiedDate, errorMessage, status, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFEvidence;

ALTER TABLE E$WFEvidence
    ADD CONSTRAINT WFEvidence_PK PRIMARY KEY (evidenceId);

CREATE INDEX WFEvidenceStatus_I ON E$WFEvidence
    (status );

CREATE INDEX WFEvidenceTaskId_I ON E$WFEvidence
    (taskId );

-- ----------------------------------------------------------------------- 
-- E$WFHeaderProps 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFHeaderProps
(
    taskId VARCHAR2(64) NOT NULL,
    properties BLOB,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFHeaderProps
 AS SELECT taskId, properties, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFHeaderProps;

ALTER TABLE E$WFHeaderProps
    ADD CONSTRAINT WFHeaderProps_PK PRIMARY KEY (taskId);

-- ----------------------------------------------------------------------- 
-- E$WFMessageAttribute 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFMessageAttribute
(
    taskId VARCHAR2(64),
    name VARCHAR2(100),
    version NUMBER,
    maxVersion NUMBER,
    storageType INTEGER,
    encoding VARCHAR2(50),
    stringValue VARCHAR2(2000),
    numberValue NUMBER,
    dateValue DATE,
    blobValue BLOB,
    elementSeq NUMBER,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFMessageAttribute
 AS SELECT taskId, name, version, maxVersion, storageType, encoding, stringValue, numberValue, dateValue, blobValue, elementSeq, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFMessageAttribute;

CREATE INDEX WFMessageAttributeTaskId_I ON E$WFMessageAttribute
    (taskId , version );

CREATE INDEX WFMessageAttributeTaskName_I ON E$WFMessageAttribute
    (taskId , name );

-- ----------------------------------------------------------------------- 
-- E$WFNotification 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFNotification
(
    notificationId VARCHAR2(64) NOT NULL,
    taskId VARCHAR2(64),
    version NUMBER,
    taskNumber NUMBER,
    recipientUsers VARCHAR2(4000),
    recipientGroups VARCHAR2(4000),
    identityContext VARCHAR2(200),
    domain VARCHAR2(200),
    action VARCHAR2(20),
    status VARCHAR2(20),
    channel VARCHAR2(20),
    noOfNotification NUMBER,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFNotification
 AS SELECT notificationId, taskId, version, taskNumber, recipientUsers, recipientGroups, identityContext, domain, action, status, channel, noOfNotification, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFNotification;

ALTER TABLE E$WFNotification
    ADD CONSTRAINT WFNotification_PK PRIMARY KEY (notificationId);

CREATE INDEX WFNotificationId_I ON E$WFNotification
    (taskId );

-- ----------------------------------------------------------------------- 
-- E$WFNotificationMessages 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFNotificationMessages
(
    taskId VARCHAR2(64) NOT NULL,
    taskVersion NUMBER NOT NULL,
    action VARCHAR2(100),
    status VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW WFNotificationMessages
 AS SELECT taskId, taskVersion, action, status FROM E$WFNotificationMessages;

ALTER TABLE E$WFNotificationMessages
    ADD CONSTRAINT WFNotificationMessages_PK PRIMARY KEY (taskId, taskVersion);

-- ----------------------------------------------------------------------- 
-- E$WFNotificationStatus 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFNotificationStatus
(
    recipientUser VARCHAR2(400),
    recipientGroup VARCHAR2(400),
    identityContext VARCHAR2(200),
    domain VARCHAR2(200),
    status VARCHAR2(20),
    channelAddress VARCHAR2(500),
    channel VARCHAR2(20)
);

CREATE OR REPLACE EDITIONING VIEW WFNotificationStatus
 AS SELECT recipientUser, recipientGroup, identityContext, domain, status, channelAddress, channel FROM E$WFNotificationStatus;

-- ----------------------------------------------------------------------- 
-- E$WFReviewer 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFReviewer
(
    taskId VARCHAR2(64) NOT NULL,
    version NUMBER NOT NULL,
    assignee VARCHAR2(400) NOT NULL,
    guid VARCHAR2(64),
    assigneeType VARCHAR2(20) NOT NULL,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFReviewer
 AS SELECT taskId, version, assignee, guid, assigneeType, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFReviewer;

ALTER TABLE E$WFReviewer
    ADD CONSTRAINT WFReviewer_PK PRIMARY KEY (taskId, version, assignee, assigneeType);

CREATE INDEX WFReviewerAssignee_I ON E$WFReviewer
    (assignee );

CREATE INDEX WFReviewerCompositeId_I ON E$WFReviewer
    (taskId , assignee , assigneeType );

CREATE INDEX WFReviewerTaskId_I ON E$WFReviewer
    (taskId );

-- ----------------------------------------------------------------------- 
-- E$WFRoutingSlip 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFRoutingSlip
(
    taskId VARCHAR2(64) NOT NULL,
    taskNumber NUMBER,
    routingSlip BLOB,
    noOfTimesModified NUMBER,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFRoutingSlip
 AS SELECT taskId, taskNumber, routingSlip, noOfTimesModified, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFRoutingSlip;

ALTER TABLE E$WFRoutingSlip
    ADD CONSTRAINT WFRoutingSlip_PK PRIMARY KEY (taskId);

-- ----------------------------------------------------------------------- 
-- E$WFRuleDictionary 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFRuleDictionary
(
    dictionaryName VARCHAR2(400) NOT NULL,
    packageName VARCHAR2(400) NOT NULL,
    dictionary BLOB,
    encoding VARCHAR2(10)
)
;

CREATE OR REPLACE EDITIONING VIEW WFRuleDictionary
 AS SELECT dictionaryName, packageName, dictionary, encoding FROM E$WFRuleDictionary;

ALTER TABLE E$WFRuleDictionary
    ADD CONSTRAINT WFRuleDictionary_PK PRIMARY KEY (dictionaryName, packageName);

-- ----------------------------------------------------------------------- 
-- E$WFTask 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTask
(
    acquiredBy VARCHAR2(400),
    assignees VARCHAR2(4000),
    assigneesDisplayName VARCHAR2(4000),
    reviewers VARCHAR2(4000),
    reviewersDisplayName VARCHAR2(4000),
    assigneeGroups VARCHAR2(4000),
    assigneeGroupsDisplayName VARCHAR2(4000),
    assigneeUsers VARCHAR2(4000),
    assigneeUsersDisplayName VARCHAR2(4000),
    callbackContext VARCHAR2(2000),
    callbackId VARCHAR2(2000),
    callbackType VARCHAR2(20),
    creator VARCHAR2(400),
    digitalSignatureRequired VARCHAR2(1),
    expirationDate DATE,
    expirationDuration VARCHAR2(64),
    identityContext VARCHAR2(200),
    ownerUser VARCHAR2(400),
    ownerGroup VARCHAR2(400),
    passwordRequiredOnUpdate VARCHAR2(1),
    priority NUMBER,
    domainId VARCHAR2(100),
    instanceId VARCHAR2(200),
    processId VARCHAR2(100),
    processName VARCHAR2(400),
    processType VARCHAR2(10),
    processVersion VARCHAR2(100),
    secureNotifications VARCHAR2(1),
    accessKey VARCHAR2(80),
    approvalDuration NUMBER,
    approvers VARCHAR2(4000),
    assignedDate DATE,
    createdDate TIMESTAMP,
    elapsedTime NUMBER,
    endDate DATE,
    fromUser VARCHAR2(400),
    fromUserDisplayName VARCHAR2(400),
    hasSubtask VARCHAR2(1),
    inShortHistory VARCHAR2(1),
    isGroup VARCHAR2(1),
    language VARCHAR2(4),
    mailStatus VARCHAR2(8),
    numberOfTimesModified NUMBER,
    originalAssigneeUser VARCHAR2(400),
    outcome VARCHAR2(100),
    parallelOutcomeCount VARCHAR2(2000),
    pushbackSequence VARCHAR2(200),
    state VARCHAR2(100),
    subState VARCHAR2(200),
    systemString1 VARCHAR2(200),
    systemString2 VARCHAR2(200),
    systemString3 VARCHAR2(200),
    taskGroupId VARCHAR2(64),
    taskId VARCHAR2(64) NOT NULL,
    taskNumber NUMBER,
    updatedBy VARCHAR2(400),
    updatedByDisplayName VARCHAR2(400),
    updatedDate TIMESTAMP,
    updatedNotificationId VARCHAR2(200),
    version NUMBER,
    versionReason VARCHAR2(2000),
    workflowPattern VARCHAR2(2000),
    textAttribute1 VARCHAR2(2000),
    textAttribute2 VARCHAR2(2000),
    textAttribute3 VARCHAR2(2000),
    textAttribute4 VARCHAR2(2000),
    textAttribute5 VARCHAR2(2000),
    textAttribute6 VARCHAR2(2000),
    textAttribute7 VARCHAR2(2000),
    textAttribute8 VARCHAR2(2000),
    textAttribute9 VARCHAR2(2000),
    textAttribute10 VARCHAR2(2000),
    formAttribute1 VARCHAR2(2000),
    formAttribute2 VARCHAR2(2000),
    formAttribute3 VARCHAR2(2000),
    formAttribute4 VARCHAR2(2000),
    formAttribute5 VARCHAR2(2000),
    urlAttribute1 VARCHAR2(200),
    urlAttribute2 VARCHAR2(200),
    urlAttribute3 VARCHAR2(200),
    urlAttribute4 VARCHAR2(200),
    urlAttribute5 VARCHAR2(200),
    dateAttribute1 DATE,
    dateAttribute2 DATE,
    dateAttribute3 DATE,
    dateAttribute4 DATE,
    dateAttribute5 DATE,
    numberAttribute1 NUMBER,
    numberAttribute2 NUMBER,
    numberAttribute3 NUMBER,
    numberAttribute4 NUMBER,
    numberAttribute5 NUMBER,
    protectedTextAttribute1 VARCHAR2(2000),
    protectedTextAttribute2 VARCHAR2(2000),
    protectedTextAttribute3 VARCHAR2(2000),
    protectedTextAttribute4 VARCHAR2(2000),
    protectedTextAttribute5 VARCHAR2(2000),
    protectedTextAttribute6 VARCHAR2(2000),
    protectedTextAttribute7 VARCHAR2(2000),
    protectedTextAttribute8 VARCHAR2(2000),
    protectedTextAttribute9 VARCHAR2(2000),
    protectedTextAttribute10 VARCHAR2(2000),
    protectedFormAttribute1 VARCHAR2(2000),
    protectedFormAttribute2 VARCHAR2(2000),
    protectedFormAttribute3 VARCHAR2(2000),
    protectedFormAttribute4 VARCHAR2(2000),
    protectedFormAttribute5 VARCHAR2(2000),
    protectedUrlAttribute1 VARCHAR2(200),
    protectedUrlAttribute2 VARCHAR2(200),
    protectedUrlAttribute3 VARCHAR2(200),
    protectedUrlAttribute4 VARCHAR2(200),
    protectedUrlAttribute5 VARCHAR2(200),
    protectedDateAttribute1 DATE,
    protectedDateAttribute2 DATE,
    protectedDateAttribute3 DATE,
    protectedDateAttribute4 DATE,
    protectedDateAttribute5 DATE,
    protectedNumberAttribute1 NUMBER,
    protectedNumberAttribute2 NUMBER,
    protectedNumberAttribute3 NUMBER,
    protectedNumberAttribute4 NUMBER,
    protectedNumberAttribute5 NUMBER,
    title VARCHAR2(500),
    titleResourceKey VARCHAR2(100),
    identificationKey VARCHAR2(100),
    userComment VARCHAR2(2000),
    workflowDescriptorURI VARCHAR2(200),
    taskDefinitionId VARCHAR2(200),
    taskDefinitionName VARCHAR2(200),
    applicationContext VARCHAR2(200),
    applicationName VARCHAR2(200),
    category VARCHAR2(200),
    componentName VARCHAR2(500),
    compositeDN VARCHAR2(500),
    compositeInstanceId VARCHAR2(200),
    compositeName VARCHAR2(200),
    compositeVersion VARCHAR2(200),
    conversationId VARCHAR2(200),
    dueDate DATE,
    ecid VARCHAR2(200),
    isPublic VARCHAR2(1),
    isTestTask VARCHAR2(1),
    parentComponentInstanceId VARCHAR2(200),
    parentComponentInstRefId VARCHAR2(1024),
    invokedComponent VARCHAR2(500),
    participantName VARCHAR2(200),
    percentageComplete NUMBER,
    readByUsers VARCHAR2(4000),
    startDate DATE,
    parentTaskVersion NUMBER,
    taskGroupInstanceId VARCHAR2(200),
    subTaskGroupInstanceId VARCHAR2(200),
    ownerRole VARCHAR2(400),
    taskNamespace VARCHAR2(200),
    timers VARCHAR2(300),
    agRootId NUMBER,
    agMileStonePath VARCHAR2(2000),
    rootTaskId VARCHAR2(64),
    parentTaskId VARCHAR2(64),
    systemStringActions VARCHAR2(200),
    taskDisplayUrl VARCHAR2(4000),
    documentPackageId VARCHAR2(200),
    subCategory VARCHAR2(200),
    correlationId VARCHAR2(64),
    stage VARCHAR2(200),
    assignmentContext VARCHAR2(4000),
    preActionUserSteps VARCHAR2(400),
    aggregationTaskId VARCHAR2(64),
    mdsLabel VARCHAR2(200),
    isTemplateTask VARCHAR2(1),
    componentType VARCHAR2(10),
    activityName VARCHAR2(200),
    activityId VARCHAR2(200),
    processDueDate DATE,
    thread INTEGER,
    parentThread INTEGER,
    step INTEGER,
    vrcValues VARCHAR2(4000),
    organizationalUnitId VARCHAR2(64),
    textAttribute11 VARCHAR2(2000),
    textAttribute12 VARCHAR2(2000),
    textAttribute13 VARCHAR2(2000),
    textAttribute14 VARCHAR2(2000),
    textAttribute15 VARCHAR2(2000),
    textAttribute16 VARCHAR2(2000),
    textAttribute17 VARCHAR2(2000),
    textAttribute18 VARCHAR2(2000),
    textAttribute19 VARCHAR2(2000),
    textAttribute20 VARCHAR2(2000),
    formAttribute6 VARCHAR2(2000),
    formAttribute7 VARCHAR2(2000),
    formAttribute8 VARCHAR2(2000),
    formAttribute9 VARCHAR2(2000),
    formAttribute10 VARCHAR2(2000),
    urlAttribute6 VARCHAR2(200),
    urlAttribute7 VARCHAR2(200),
    urlAttribute8 VARCHAR2(200),
    urlAttribute9 VARCHAR2(200),
    urlAttribute10 VARCHAR2(200),
    dateAttribute6 DATE,
    dateAttribute7 DATE,
    dateAttribute8 DATE,
    dateAttribute9 DATE,
    dateAttribute10 DATE,
    numberAttribute6 NUMBER,
    numberAttribute7 NUMBER,
    numberAttribute8 NUMBER,
    numberAttribute9 NUMBER,
    numberAttribute10 NUMBER,
    protectedTextAttribute11 VARCHAR2(2000),
    protectedTextAttribute12 VARCHAR2(2000),
    protectedTextAttribute13 VARCHAR2(2000),
    protectedTextAttribute14 VARCHAR2(2000),
    protectedTextAttribute15 VARCHAR2(2000),
    protectedTextAttribute16 VARCHAR2(2000),
    protectedTextAttribute17 VARCHAR2(2000),
    protectedTextAttribute18 VARCHAR2(2000),
    protectedTextAttribute19 VARCHAR2(2000),
    protectedTextAttribute20 VARCHAR2(2000),
    protectedFormAttribute6 VARCHAR2(2000),
    protectedFormAttribute7 VARCHAR2(2000),
    protectedFormAttribute8 VARCHAR2(2000),
    protectedFormAttribute9 VARCHAR2(2000),
    protectedFormAttribute10 VARCHAR2(2000),
    protectedUrlAttribute6 VARCHAR2(200),
    protectedUrlAttribute7 VARCHAR2(200),
    protectedUrlAttribute8 VARCHAR2(200),
    protectedUrlAttribute9 VARCHAR2(200),
    protectedUrlAttribute10 VARCHAR2(200),
    protectedDateAttribute6 DATE,
    protectedDateAttribute7 DATE,
    protectedDateAttribute8 DATE,
    protectedDateAttribute9 DATE,
    protectedDateAttribute10 DATE,
    protectedNumberAttribute6 NUMBER,
    protectedNumberAttribute7 NUMBER,
    protectedNumberAttribute8 NUMBER,
    protectedNumberAttribute9 NUMBER,
    protectedNumberAttribute10 NUMBER,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    tenantId VARCHAR2(400),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    listBuilderId VARCHAR2(64),
    caseId VARCHAR2(64),
    swimlaneRole VARCHAR2(200),
    excludedParticipants VARCHAR2(2000),
    customAttributeString1 VARCHAR2(2000),
    customAttributeString2 VARCHAR2(2000),
    customAttributeNumber1 NUMBER,
    customAttributeNumber2 NUMBER,
    customAttributeDate1 DATE,
    customAttributeDate2 DATE,
    timersSuspended VARCHAR2(1),
    isDecomposedTask VARCHAR2(1),
    formName VARCHAR2(200),
    decomposedTaskGrpInstanceId VARCHAR2(64),
    COMPONENT_INSTANCE_ID INTEGER,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    STARTTIME TIMESTAMP,
    STOPTIME TIMESTAMP,
    WORKINGDURATION INTEGER,
    SHORTSUMMARY VARCHAR2(500),
    LONGSUMMARY VARCHAR2(1000),
    ARCHIVEDON TIMESTAMP
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTask
 AS SELECT acquiredBy, assignees, assigneesDisplayName, reviewers, reviewersDisplayName, assigneeGroups, assigneeGroupsDisplayName, assigneeUsers, assigneeUsersDisplayName, callbackContext, callbackId, callbackType, creator, digitalSignatureRequired, expirationDate, expirationDuration, identityContext, ownerUser, ownerGroup, passwordRequiredOnUpdate, priority, domainId, instanceId, processId, processName, processType, processVersion, secureNotifications, accessKey, approvalDuration, approvers, assignedDate, createdDate, elapsedTime, endDate, fromUser, fromUserDisplayName, hasSubtask, inShortHistory, isGroup, language, mailStatus, numberOfTimesModified, originalAssigneeUser, outcome, parallelOutcomeCount, pushbackSequence, state, subState, systemString1, systemString2, systemString3, taskGroupId, taskId, taskNumber, updatedBy, updatedByDisplayName, updatedDate, updatedNotificationId, version, versionReason, workflowPattern, textAttribute1, textAttribute2, textAttribute3, textAttribute4, textAttribute5, textAttribute6, textAttribute7, textAttribute8, textAttribute9, textAttribute10, formAttribute1, formAttribute2, formAttribute3, formAttribute4, formAttribute5, urlAttribute1, urlAttribute2, urlAttribute3, urlAttribute4, urlAttribute5, dateAttribute1, dateAttribute2, dateAttribute3, dateAttribute4, dateAttribute5, numberAttribute1, numberAttribute2, numberAttribute3, numberAttribute4, numberAttribute5, protectedTextAttribute1, protectedTextAttribute2, protectedTextAttribute3, protectedTextAttribute4, protectedTextAttribute5, protectedTextAttribute6, protectedTextAttribute7, protectedTextAttribute8, protectedTextAttribute9, protectedTextAttribute10, protectedFormAttribute1, protectedFormAttribute2, protectedFormAttribute3, protectedFormAttribute4, protectedFormAttribute5, protectedUrlAttribute1, protectedUrlAttribute2, protectedUrlAttribute3, protectedUrlAttribute4, protectedUrlAttribute5, protectedDateAttribute1, protectedDateAttribute2, protectedDateAttribute3, protectedDateAttribute4, protectedDateAttribute5, protectedNumberAttribute1, protectedNumberAttribute2, protectedNumberAttribute3, protectedNumberAttribute4, protectedNumberAttribute5, title, titleResourceKey, identificationKey, userComment, workflowDescriptorURI, taskDefinitionId, taskDefinitionName, applicationContext, applicationName, category, componentName, compositeDN, compositeInstanceId, compositeName, compositeVersion, conversationId, dueDate, ecid, isPublic, isTestTask, parentComponentInstanceId, parentComponentInstRefId, invokedComponent, participantName, percentageComplete, readByUsers, startDate, parentTaskVersion, taskGroupInstanceId, subTaskGroupInstanceId, ownerRole, taskNamespace, timers, agRootId, agMileStonePath, rootTaskId, parentTaskId, systemStringActions, taskDisplayUrl, documentPackageId, subCategory, correlationId, stage, assignmentContext, preActionUserSteps, aggregationTaskId, mdsLabel, isTemplateTask, componentType, activityName, activityId, processDueDate, thread, parentThread, step, vrcValues, organizationalUnitId, textAttribute11, textAttribute12, textAttribute13, textAttribute14, textAttribute15, textAttribute16, textAttribute17, textAttribute18, textAttribute19, textAttribute20, formAttribute6, formAttribute7, formAttribute8, formAttribute9, formAttribute10, urlAttribute6, urlAttribute7, urlAttribute8, urlAttribute9, urlAttribute10, dateAttribute6, dateAttribute7, dateAttribute8, dateAttribute9, dateAttribute10, numberAttribute6, numberAttribute7, numberAttribute8, numberAttribute9, numberAttribute10, protectedTextAttribute11, protectedTextAttribute12, protectedTextAttribute13, protectedTextAttribute14, protectedTextAttribute15, protectedTextAttribute16, protectedTextAttribute17, protectedTextAttribute18, protectedTextAttribute19, protectedTextAttribute20, protectedFormAttribute6, protectedFormAttribute7, protectedFormAttribute8, protectedFormAttribute9, protectedFormAttribute10, protectedUrlAttribute6, protectedUrlAttribute7, protectedUrlAttribute8, protectedUrlAttribute9, protectedUrlAttribute10, protectedDateAttribute6, protectedDateAttribute7, protectedDateAttribute8, protectedDateAttribute9, protectedDateAttribute10, protectedNumberAttribute6, protectedNumberAttribute7, protectedNumberAttribute8, protectedNumberAttribute9, protectedNumberAttribute10, compositeCreatedTime, tenantId, TENANT_ID, listBuilderId, caseId, swimlaneRole, excludedParticipants, customAttributeString1, customAttributeString2, customAttributeNumber1, customAttributeNumber2, customAttributeDate1, customAttributeDate2, timersSuspended, isDecomposedTask, formName, decomposedTaskGrpInstanceId, COMPONENT_INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, STARTTIME, STOPTIME, WORKINGDURATION, SHORTSUMMARY, LONGSUMMARY, ARCHIVEDON FROM E$WFTask;

ALTER TABLE E$WFTask
    ADD CONSTRAINT WFTask_PK PRIMARY KEY (taskId);

CREATE INDEX WFTaskAcquiredBy_I ON E$WFTask
    (acquiredBy );

CREATE INDEX WFTaskAggregationTaskId_I ON E$WFTask
    (aggregationTaskId );

CREATE INDEX WFTaskComponentType_I ON E$WFTask
    (componentType );

CREATE INDEX WFTaskCompositeDN_I ON E$WFTask
    (compositeDN );

CREATE INDEX WFTaskCompositeId_I ON E$WFTask
    (compositeInstanceId );

CREATE INDEX WFTaskCreatedDate_I ON E$WFTask
    (createdDate );

CREATE INDEX WFTaskCreator_I ON E$WFTask
    (creator );

CREATE INDEX WFTaskDocPacId_I ON E$WFTask
    (documentPackageId );

CREATE INDEX WFTaskDomainId_I ON E$WFTask
    (domainId );

CREATE INDEX WFTaskECID_I ON E$WFTask
    (ecid );

CREATE INDEX WFTaskEMCount_I ON E$WFTask
    (rootTaskId , taskId , componentName , compositeName , compositeDN , state , aggregationTaskId , isTemplateTask );

CREATE INDEX WFTaskIdentificationKey_I ON E$WFTask
    (identificationKey );

CREATE INDEX WFTaskIdStateGrpIc_I ON E$WFTask
    (taskId , state , isGroup , identityContext );

CREATE INDEX WFTaskInstanceId_I ON E$WFTask
    (instanceId );

CREATE INDEX WFTaskNumber_I ON E$WFTask
    (taskNumber );

CREATE INDEX WFTaskOAssigneeUser_I ON E$WFTask
    (originalAssigneeUser );

CREATE INDEX WFTaskOwnerGroup_I ON E$WFTask
    (ownerGroup );

CREATE INDEX WFTaskOwnerRole_I ON E$WFTask
    (applicationContext , ownerRole );

CREATE INDEX WFTaskOwnerUser_I ON E$WFTask
    (ownerUser );

CREATE INDEX WFTaskParentComponentInst_I ON E$WFTask
    (parentComponentInstanceId , parentComponentInstRefId );

CREATE INDEX WFTaskRootIdAggrTaskId_I ON E$WFTask
    (rootTaskId , aggregationTaskId );

CREATE INDEX WFTaskState_I ON E$WFTask
    (state );

CREATE INDEX WFTaskSteCptTypIdCtxAggIdOrgId ON E$WFTask
    (state , componentType , identityContext , aggregationTaskId , organizationalUnitId );

CREATE INDEX WFTaskSteRootIdTaskIdAggrId_I ON E$WFTask
    (state , rootTaskId , taskId , aggregationTaskId );

CREATE INDEX WFTaskTaskGroupId_I ON E$WFTask
    (taskGroupId );

CREATE INDEX WFTaskTaskIdPattern_I ON E$WFTask
    (taskId , workflowPattern );

CREATE INDEX WFTaskTaskIdTaskGroupId_I ON E$WFTask
    (taskId , taskGroupId );

CREATE INDEX WFTaskUpdatedBy_I ON E$WFTask
    (updatedBy );

CREATE INDEX WFTaskUpdDteSteAggrIdTmpTsk_I ON E$WFTask
    (updatedDate , state , aggregationTaskId , isTemplateTask );

CREATE INDEX WFTaskDecTaskGrpInsId_I ON E$WFTask
    (decomposedTaskGrpInstanceId );

CREATE INDEX WFTASK_COMPONENTINSTID_I ON E$WFTask
    (COMPONENT_INSTANCE_ID );

CREATE INDEX WFTASK_FLOWID_I ON E$WFTask
    (FLOW_ID );

-- ----------------------------------------------------------------------- 
-- E$WFTask_TL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTask_TL
(
    taskId VARCHAR2(64) NOT NULL,
    version NUMBER NOT NULL,
    locale VARCHAR2(2000) NOT NULL,
    title VARCHAR2(1500),
    category VARCHAR2(600),
    subCategory VARCHAR2(600),
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTask_TL
 AS SELECT taskId, version, locale, title, category, subCategory, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTask_TL;

ALTER TABLE E$WFTask_TL
    ADD CONSTRAINT WFTask_TL_PK PRIMARY KEY (taskId, version, locale);

-- ----------------------------------------------------------------------- 
-- E$WFTaskAggregation 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskAggregation
(
    rootTaskId VARCHAR2(64),
    id VARCHAR2(64) NOT NULL,
    assignee VARCHAR2(4000),
    stage VARCHAR2(64),
    aggregationType VARCHAR2(5),
    collectionName VARCHAR2(300),
    xpath VARCHAR2(300),
    targetIndex NUMBER,
    keyList VARCHAR2(2000),
    aggregationTaskId VARCHAR2(64),
    action VARCHAR2(200),
    actionParams VARCHAR2(2000),
    updatedBy VARCHAR2(400),
    updatedDate DATE,
    numberOfTimesModified NUMBER,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTaskAggregation
 AS SELECT rootTaskId, id, assignee, stage, aggregationType, collectionName, xpath, targetIndex, keyList, aggregationTaskId, action, actionParams, updatedBy, updatedDate, numberOfTimesModified, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskAggregation;

ALTER TABLE E$WFTaskAggregation
    ADD CONSTRAINT WFTaskAggregation_PK PRIMARY KEY (id);

CREATE INDEX WFTaskAggregationAggType_I ON E$WFTaskAggregation
    (aggregationType );

CREATE INDEX WFTaskAggregationColName_I ON E$WFTaskAggregation
    (collectionName );

CREATE INDEX WFTaskAggregationKeyList_I ON E$WFTaskAggregation
    (keyList );

CREATE INDEX WFTaskAggregationRootTaskId_I ON E$WFTaskAggregation
    (rootTaskId );

CREATE INDEX WFTaskAggregationStage_I ON E$WFTaskAggregation
    (stage );

CREATE INDEX WFTaskAggregationTargetIndex_I ON E$WFTaskAggregation
    (targetIndex );

-- ----------------------------------------------------------------------- 
-- E$WFTaskAssignmentStatistic 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskAssignmentStatistic
(
    statId VARCHAR2(64) NOT NULL,
    taskId VARCHAR2(64),
    taskVersion NUMBER,
    taskNumber NUMBER,
    taskDefinitionId VARCHAR2(200),
    applicationContext VARCHAR2(200),
    identityContext VARCHAR2(200),
    assignee VARCHAR2(400),
    assigneeType VARCHAR2(20),
    startAction VARCHAR2(200),
    endAction VARCHAR2(200),
    assignmentType VARCHAR2(20),
    assignmentSubType VARCHAR2(20),
    startDate DATE,
    endDate DATE,
    madeUpdate VARCHAR2(1),
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTaskAssignmentStatistic
 AS SELECT statId, taskId, taskVersion, taskNumber, taskDefinitionId, applicationContext, identityContext, assignee, assigneeType, startAction, endAction, assignmentType, assignmentSubType, startDate, endDate, madeUpdate, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskAssignmentStatistic;

ALTER TABLE E$WFTaskAssignmentStatistic
    ADD CONSTRAINT WFTaskAssignmentStatistic_PK PRIMARY KEY (statId);

CREATE INDEX WFTaskAssignmentStatisticId_I ON E$WFTaskAssignmentStatistic
    (taskId );

CREATE INDEX WFTaskASStartEndDate_I ON E$WFTaskAssignmentStatistic
    (startDate , endDate );

-- ----------------------------------------------------------------------- 
-- E$WFTaskDisplay 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskDisplay
(
    namespace VARCHAR2(200),
    compositeVersion VARCHAR2(200),
    uri VARCHAR2(1000),
    applicationName VARCHAR2(200),
    hostName VARCHAR2(200),
    httpPort VARCHAR2(20),
    httpsPort VARCHAR2(20),
    partitionName VARCHAR2(200),
    formName VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW WFTaskDisplay
 AS SELECT namespace, compositeVersion, uri, applicationName, hostName, httpPort, httpsPort, partitionName, formName FROM E$WFTaskDisplay;

CREATE UNIQUE INDEX WFTaskDisplay_UIdx ON E$WFTaskDisplay
    (namespace , compositeVersion , applicationName , partitionName );

-- ----------------------------------------------------------------------- 
-- E$WFTaskError 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskError
(
    taskErrorId VARCHAR2(200) NOT NULL,
    taskId VARCHAR2(64),
    taskNumber NUMBER,
    taskVersion NUMBER,
    ecid VARCHAR2(200),
    componentName VARCHAR2(200),
    compositeName VARCHAR2(200),
    compositeDN VARCHAR2(200),
    compositeVersion VARCHAR2(200),
    compositeInstanceId VARCHAR2(200),
    errorArgs VARCHAR2(2000),
    errorDate DATE,
    errorId NUMBER,
    errorStack VARCHAR2(4000),
    errorType VARCHAR2(20),
    isRecoverable VARCHAR2(1),
    taskDefinitionId VARCHAR2(200),
    taskCreatedDate DATE,
    taskState VARCHAR2(100),
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    errorMessage VARCHAR2(2000),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTaskError
 AS SELECT taskErrorId, taskId, taskNumber, taskVersion, ecid, componentName, compositeName, compositeDN, compositeVersion, compositeInstanceId, errorArgs, errorDate, errorId, errorStack, errorType, isRecoverable, taskDefinitionId, taskCreatedDate, taskState, compositeCreatedTime, errorMessage, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskError;

ALTER TABLE E$WFTaskError
    ADD CONSTRAINT WFTaskError_PK PRIMARY KEY (taskErrorId);

CREATE INDEX WFTaskErrorCompositeDN_I ON E$WFTaskError
    (compositeDN );

CREATE INDEX WFTaskErrorCompositeId_I ON E$WFTaskError
    (compositeInstanceId );

CREATE INDEX WFTaskErrorECID_I ON E$WFTaskError
    (ecid );

CREATE INDEX WFTaskErrorErrorMsg_I ON E$WFTaskError
    (errorMessage );

CREATE INDEX WFTaskErrorTaskDefinitionId_I ON E$WFTaskError
    (taskDefinitionId );

CREATE INDEX WFTaskErrorTaskId_I ON E$WFTaskError
    (taskId );

CREATE INDEX WFTaskErrorTaskNumber_I ON E$WFTaskError
    (taskNumber );

-- ----------------------------------------------------------------------- 
-- E$WFTaskHistory 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskHistory
(
    acquiredBy VARCHAR2(400),
    assignees VARCHAR2(4000),
    assigneesDisplayName VARCHAR2(4000),
    reviewers VARCHAR2(4000),
    reviewersDisplayName VARCHAR2(4000),
    assigneeGroups VARCHAR2(4000),
    assigneeGroupsDisplayName VARCHAR2(4000),
    assigneeUsers VARCHAR2(4000),
    assigneeUsersDisplayName VARCHAR2(4000),
    callbackContext VARCHAR2(2000),
    callbackId VARCHAR2(2000),
    callbackType VARCHAR2(20),
    creator VARCHAR2(400),
    digitalSignatureRequired VARCHAR2(1),
    expirationDate DATE,
    expirationDuration VARCHAR2(64),
    identityContext VARCHAR2(200),
    ownerUser VARCHAR2(400),
    ownerGroup VARCHAR2(400),
    passwordRequiredOnUpdate VARCHAR2(1),
    priority NUMBER,
    domainId VARCHAR2(100),
    instanceId VARCHAR2(200),
    processId VARCHAR2(100),
    processName VARCHAR2(400),
    processType VARCHAR2(10),
    processVersion VARCHAR2(100),
    secureNotifications VARCHAR2(1),
    accessKey VARCHAR2(80),
    approvalDuration NUMBER,
    approvers VARCHAR2(4000),
    assignedDate DATE,
    createdDate TIMESTAMP,
    elapsedTime NUMBER,
    endDate DATE,
    fromUser VARCHAR2(400),
    fromUserDisplayName VARCHAR2(400),
    hasSubtask VARCHAR2(1),
    inShortHistory VARCHAR2(1),
    isGroup VARCHAR2(1),
    language VARCHAR2(4),
    mailStatus VARCHAR2(8),
    numberOfTimesModified NUMBER,
    originalAssigneeUser VARCHAR2(400),
    outcome VARCHAR2(100),
    parallelOutcomeCount VARCHAR2(2000),
    pushbackSequence VARCHAR2(200),
    state VARCHAR2(100),
    subState VARCHAR2(200),
    systemString1 VARCHAR2(200),
    systemString2 VARCHAR2(200),
    systemString3 VARCHAR2(200),
    taskGroupId VARCHAR2(64),
    taskId VARCHAR2(64) NOT NULL,
    taskNumber NUMBER,
    updatedBy VARCHAR2(400),
    updatedByDisplayName VARCHAR2(400),
    updatedDate TIMESTAMP,
    updatedNotificationId VARCHAR2(200),
    version NUMBER NOT NULL,
    versionReason VARCHAR2(2000),
    workflowPattern VARCHAR2(2000),
    textAttribute1 VARCHAR2(2000),
    textAttribute2 VARCHAR2(2000),
    textAttribute3 VARCHAR2(2000),
    textAttribute4 VARCHAR2(2000),
    textAttribute5 VARCHAR2(2000),
    textAttribute6 VARCHAR2(2000),
    textAttribute7 VARCHAR2(2000),
    textAttribute8 VARCHAR2(2000),
    textAttribute9 VARCHAR2(2000),
    textAttribute10 VARCHAR2(2000),
    formAttribute1 VARCHAR2(2000),
    formAttribute2 VARCHAR2(2000),
    formAttribute3 VARCHAR2(2000),
    formAttribute4 VARCHAR2(2000),
    formAttribute5 VARCHAR2(2000),
    urlAttribute1 VARCHAR2(200),
    urlAttribute2 VARCHAR2(200),
    urlAttribute3 VARCHAR2(200),
    urlAttribute4 VARCHAR2(200),
    urlAttribute5 VARCHAR2(200),
    dateAttribute1 DATE,
    dateAttribute2 DATE,
    dateAttribute3 DATE,
    dateAttribute4 DATE,
    dateAttribute5 DATE,
    numberAttribute1 NUMBER,
    numberAttribute2 NUMBER,
    numberAttribute3 NUMBER,
    numberAttribute4 NUMBER,
    numberAttribute5 NUMBER,
    protectedTextAttribute1 VARCHAR2(2000),
    protectedTextAttribute2 VARCHAR2(2000),
    protectedTextAttribute3 VARCHAR2(2000),
    protectedTextAttribute4 VARCHAR2(2000),
    protectedTextAttribute5 VARCHAR2(2000),
    protectedTextAttribute6 VARCHAR2(2000),
    protectedTextAttribute7 VARCHAR2(2000),
    protectedTextAttribute8 VARCHAR2(2000),
    protectedTextAttribute9 VARCHAR2(2000),
    protectedTextAttribute10 VARCHAR2(2000),
    protectedFormAttribute1 VARCHAR2(2000),
    protectedFormAttribute2 VARCHAR2(2000),
    protectedFormAttribute3 VARCHAR2(2000),
    protectedFormAttribute4 VARCHAR2(2000),
    protectedFormAttribute5 VARCHAR2(2000),
    protectedUrlAttribute1 VARCHAR2(200),
    protectedUrlAttribute2 VARCHAR2(200),
    protectedUrlAttribute3 VARCHAR2(200),
    protectedUrlAttribute4 VARCHAR2(200),
    protectedUrlAttribute5 VARCHAR2(200),
    protectedDateAttribute1 DATE,
    protectedDateAttribute2 DATE,
    protectedDateAttribute3 DATE,
    protectedDateAttribute4 DATE,
    protectedDateAttribute5 DATE,
    protectedNumberAttribute1 NUMBER,
    protectedNumberAttribute2 NUMBER,
    protectedNumberAttribute3 NUMBER,
    protectedNumberAttribute4 NUMBER,
    protectedNumberAttribute5 NUMBER,
    title VARCHAR2(500),
    titleResourceKey VARCHAR2(100),
    identificationKey VARCHAR2(100),
    userComment VARCHAR2(2000),
    workflowDescriptorURI VARCHAR2(200),
    taskDefinitionId VARCHAR2(200),
    taskDefinitionName VARCHAR2(200),
    applicationContext VARCHAR2(200),
    applicationName VARCHAR2(200),
    category VARCHAR2(200),
    componentName VARCHAR2(500),
    compositeDN VARCHAR2(500),
    compositeInstanceId VARCHAR2(200),
    compositeName VARCHAR2(200),
    compositeVersion VARCHAR2(200),
    conversationId VARCHAR2(200),
    dueDate DATE,
    ecid VARCHAR2(200),
    isPublic VARCHAR2(1),
    isTestTask VARCHAR2(1),
    parentComponentInstanceId VARCHAR2(200),
    parentComponentInstRefId VARCHAR2(1024),
    invokedComponent VARCHAR2(500),
    participantName VARCHAR2(200),
    percentageComplete NUMBER,
    readByUsers VARCHAR2(4000),
    startDate DATE,
    parentTaskVersion NUMBER,
    taskGroupInstanceId VARCHAR2(200),
    subTaskGroupInstanceId VARCHAR2(200),
    ownerRole VARCHAR2(400),
    taskNamespace VARCHAR2(200),
    timers VARCHAR2(300),
    agRootId NUMBER,
    agMileStonePath VARCHAR2(2000),
    rootTaskId VARCHAR2(64),
    parentTaskId VARCHAR2(64),
    systemStringActions VARCHAR2(200),
    taskDisplayUrl VARCHAR2(4000),
    documentPackageId VARCHAR2(200),
    subCategory VARCHAR2(200),
    correlationId VARCHAR2(64),
    stage VARCHAR2(200),
    assignmentContext VARCHAR2(4000),
    preActionUserSteps VARCHAR2(400),
    aggregationTaskId VARCHAR2(64),
    mdsLabel VARCHAR2(200),
    isTemplateTask VARCHAR2(1),
    componentType VARCHAR2(10),
    activityName VARCHAR2(200),
    activityId VARCHAR2(200),
    processDueDate DATE,
    thread INTEGER,
    parentThread INTEGER,
    step INTEGER,
    vrcValues VARCHAR2(4000),
    organizationalUnitId VARCHAR2(64),
    textAttribute11 VARCHAR2(2000),
    textAttribute12 VARCHAR2(2000),
    textAttribute13 VARCHAR2(2000),
    textAttribute14 VARCHAR2(2000),
    textAttribute15 VARCHAR2(2000),
    textAttribute16 VARCHAR2(2000),
    textAttribute17 VARCHAR2(2000),
    textAttribute18 VARCHAR2(2000),
    textAttribute19 VARCHAR2(2000),
    textAttribute20 VARCHAR2(2000),
    formAttribute6 VARCHAR2(2000),
    formAttribute7 VARCHAR2(2000),
    formAttribute8 VARCHAR2(2000),
    formAttribute9 VARCHAR2(2000),
    formAttribute10 VARCHAR2(2000),
    urlAttribute6 VARCHAR2(200),
    urlAttribute7 VARCHAR2(200),
    urlAttribute8 VARCHAR2(200),
    urlAttribute9 VARCHAR2(200),
    urlAttribute10 VARCHAR2(200),
    dateAttribute6 DATE,
    dateAttribute7 DATE,
    dateAttribute8 DATE,
    dateAttribute9 DATE,
    dateAttribute10 DATE,
    numberAttribute6 NUMBER,
    numberAttribute7 NUMBER,
    numberAttribute8 NUMBER,
    numberAttribute9 NUMBER,
    numberAttribute10 NUMBER,
    protectedTextAttribute11 VARCHAR2(2000),
    protectedTextAttribute12 VARCHAR2(2000),
    protectedTextAttribute13 VARCHAR2(2000),
    protectedTextAttribute14 VARCHAR2(2000),
    protectedTextAttribute15 VARCHAR2(2000),
    protectedTextAttribute16 VARCHAR2(2000),
    protectedTextAttribute17 VARCHAR2(2000),
    protectedTextAttribute18 VARCHAR2(2000),
    protectedTextAttribute19 VARCHAR2(2000),
    protectedTextAttribute20 VARCHAR2(2000),
    protectedFormAttribute6 VARCHAR2(2000),
    protectedFormAttribute7 VARCHAR2(2000),
    protectedFormAttribute8 VARCHAR2(2000),
    protectedFormAttribute9 VARCHAR2(2000),
    protectedFormAttribute10 VARCHAR2(2000),
    protectedUrlAttribute6 VARCHAR2(200),
    protectedUrlAttribute7 VARCHAR2(200),
    protectedUrlAttribute8 VARCHAR2(200),
    protectedUrlAttribute9 VARCHAR2(200),
    protectedUrlAttribute10 VARCHAR2(200),
    protectedDateAttribute6 DATE,
    protectedDateAttribute7 DATE,
    protectedDateAttribute8 DATE,
    protectedDateAttribute9 DATE,
    protectedDateAttribute10 DATE,
    protectedNumberAttribute6 NUMBER,
    protectedNumberAttribute7 NUMBER,
    protectedNumberAttribute8 NUMBER,
    protectedNumberAttribute9 NUMBER,
    protectedNumberAttribute10 NUMBER,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    tenantId VARCHAR2(400),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    listBuilderId VARCHAR2(64),
    caseId VARCHAR2(64),
    swimlaneRole VARCHAR2(200),
    excludedParticipants VARCHAR2(2000),
    customAttributeString1 VARCHAR2(2000),
    customAttributeString2 VARCHAR2(2000),
    customAttributeNumber1 NUMBER,
    customAttributeNumber2 NUMBER,
    customAttributeDate1 DATE,
    customAttributeDate2 DATE,
    timersSuspended VARCHAR2(1),
    isDecomposedTask VARCHAR2(1),
    formName VARCHAR2(200),
    decomposedTaskGrpInstanceId VARCHAR2(64),
    COMPONENT_INSTANCE_ID INTEGER,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    STARTTIME TIMESTAMP,
    STOPTIME TIMESTAMP,
    WORKINGDURATION INTEGER,
    SHORTSUMMARY VARCHAR2(500),
    LONGSUMMARY VARCHAR2(1000)
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTaskHistory
 AS SELECT acquiredBy, assignees, assigneesDisplayName, reviewers, reviewersDisplayName, assigneeGroups, assigneeGroupsDisplayName, assigneeUsers, assigneeUsersDisplayName, callbackContext, callbackId, callbackType, creator, digitalSignatureRequired, expirationDate, expirationDuration, identityContext, ownerUser, ownerGroup, passwordRequiredOnUpdate, priority, domainId, instanceId, processId, processName, processType, processVersion, secureNotifications, accessKey, approvalDuration, approvers, assignedDate, createdDate, elapsedTime, endDate, fromUser, fromUserDisplayName, hasSubtask, inShortHistory, isGroup, language, mailStatus, numberOfTimesModified, originalAssigneeUser, outcome, parallelOutcomeCount, pushbackSequence, state, subState, systemString1, systemString2, systemString3, taskGroupId, taskId, taskNumber, updatedBy, updatedByDisplayName, updatedDate, updatedNotificationId, version, versionReason, workflowPattern, textAttribute1, textAttribute2, textAttribute3, textAttribute4, textAttribute5, textAttribute6, textAttribute7, textAttribute8, textAttribute9, textAttribute10, formAttribute1, formAttribute2, formAttribute3, formAttribute4, formAttribute5, urlAttribute1, urlAttribute2, urlAttribute3, urlAttribute4, urlAttribute5, dateAttribute1, dateAttribute2, dateAttribute3, dateAttribute4, dateAttribute5, numberAttribute1, numberAttribute2, numberAttribute3, numberAttribute4, numberAttribute5, protectedTextAttribute1, protectedTextAttribute2, protectedTextAttribute3, protectedTextAttribute4, protectedTextAttribute5, protectedTextAttribute6, protectedTextAttribute7, protectedTextAttribute8, protectedTextAttribute9, protectedTextAttribute10, protectedFormAttribute1, protectedFormAttribute2, protectedFormAttribute3, protectedFormAttribute4, protectedFormAttribute5, protectedUrlAttribute1, protectedUrlAttribute2, protectedUrlAttribute3, protectedUrlAttribute4, protectedUrlAttribute5, protectedDateAttribute1, protectedDateAttribute2, protectedDateAttribute3, protectedDateAttribute4, protectedDateAttribute5, protectedNumberAttribute1, protectedNumberAttribute2, protectedNumberAttribute3, protectedNumberAttribute4, protectedNumberAttribute5, title, titleResourceKey, identificationKey, userComment, workflowDescriptorURI, taskDefinitionId, taskDefinitionName, applicationContext, applicationName, category, componentName, compositeDN, compositeInstanceId, compositeName, compositeVersion, conversationId, dueDate, ecid, isPublic, isTestTask, parentComponentInstanceId, parentComponentInstRefId, invokedComponent, participantName, percentageComplete, readByUsers, startDate, parentTaskVersion, taskGroupInstanceId, subTaskGroupInstanceId, ownerRole, taskNamespace, timers, agRootId, agMileStonePath, rootTaskId, parentTaskId, systemStringActions, taskDisplayUrl, documentPackageId, subCategory, correlationId, stage, assignmentContext, preActionUserSteps, aggregationTaskId, mdsLabel, isTemplateTask, componentType, activityName, activityId, processDueDate, thread, parentThread, step, vrcValues, organizationalUnitId, textAttribute11, textAttribute12, textAttribute13, textAttribute14, textAttribute15, textAttribute16, textAttribute17, textAttribute18, textAttribute19, textAttribute20, formAttribute6, formAttribute7, formAttribute8, formAttribute9, formAttribute10, urlAttribute6, urlAttribute7, urlAttribute8, urlAttribute9, urlAttribute10, dateAttribute6, dateAttribute7, dateAttribute8, dateAttribute9, dateAttribute10, numberAttribute6, numberAttribute7, numberAttribute8, numberAttribute9, numberAttribute10, protectedTextAttribute11, protectedTextAttribute12, protectedTextAttribute13, protectedTextAttribute14, protectedTextAttribute15, protectedTextAttribute16, protectedTextAttribute17, protectedTextAttribute18, protectedTextAttribute19, protectedTextAttribute20, protectedFormAttribute6, protectedFormAttribute7, protectedFormAttribute8, protectedFormAttribute9, protectedFormAttribute10, protectedUrlAttribute6, protectedUrlAttribute7, protectedUrlAttribute8, protectedUrlAttribute9, protectedUrlAttribute10, protectedDateAttribute6, protectedDateAttribute7, protectedDateAttribute8, protectedDateAttribute9, protectedDateAttribute10, protectedNumberAttribute6, protectedNumberAttribute7, protectedNumberAttribute8, protectedNumberAttribute9, protectedNumberAttribute10, compositeCreatedTime, tenantId, TENANT_ID, listBuilderId, caseId, swimlaneRole, excludedParticipants, customAttributeString1, customAttributeString2, customAttributeNumber1, customAttributeNumber2, customAttributeDate1, customAttributeDate2, timersSuspended, isDecomposedTask, formName, decomposedTaskGrpInstanceId, COMPONENT_INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, STARTTIME, STOPTIME, WORKINGDURATION, SHORTSUMMARY, LONGSUMMARY FROM E$WFTaskHistory;

ALTER TABLE E$WFTaskHistory
    ADD CONSTRAINT WFTaskHistory_PK PRIMARY KEY (taskId, version);

CREATE INDEX WFTaskHAcquiredBy_I ON E$WFTaskHistory
    (acquiredBy );

CREATE INDEX WFTaskHComponentType_I ON E$WFTaskHistory
    (componentType );

CREATE INDEX WFTaskHCompositeDN_I ON E$WFTaskHistory
    (compositeDN );

CREATE INDEX WFTaskHCompositeId_I ON E$WFTaskHistory
    (compositeInstanceId );

CREATE INDEX WFTaskHCreator_I ON E$WFTaskHistory
    (creator );

CREATE INDEX WFTaskHDocPacId_I ON E$WFTaskHistory
    (documentPackageId );

CREATE INDEX WFTaskHDomainId_I ON E$WFTaskHistory
    (domainId );

CREATE INDEX WFTaskHECID_I ON E$WFTaskHistory
    (ecid );

CREATE INDEX WFTaskHGrpIdInhist_I ON E$WFTaskHistory
    (inShortHistory , taskGroupId );

CREATE INDEX WFTaskHIdentificationKey_I ON E$WFTaskHistory
    (identificationKey );

CREATE INDEX WFTaskHIdInhist_I ON E$WFTaskHistory
    (taskId , inShortHistory );

CREATE INDEX WFTaskHIdStateGrpIc_I ON E$WFTaskHistory
    (taskId , version , state , isGroup , identityContext );

CREATE INDEX WFTaskHInstanceId_I ON E$WFTaskHistory
    (instanceId );

CREATE INDEX WFTaskHNumber_I ON E$WFTaskHistory
    (taskNumber );

CREATE INDEX WFTaskHOAssigneeUser_I ON E$WFTaskHistory
    (originalAssigneeUser );

CREATE INDEX WFTaskHOwnerGroup_I ON E$WFTaskHistory
    (ownerGroup );

CREATE INDEX WFTaskHOwnerRole_I ON E$WFTaskHistory
    (applicationContext , ownerRole );

CREATE INDEX WFTaskHOwnerUser_I ON E$WFTaskHistory
    (ownerUser );

CREATE INDEX WFTaskHParentComponentInst_I ON E$WFTaskHistory
    (parentComponentInstanceId , parentComponentInstRefId );

CREATE INDEX WFTaskHSate_I ON E$WFTaskHistory
    (state );

CREATE INDEX WFTaskHSubTaskGrpInsId_I ON E$WFTaskHistory
    (subTaskGroupInstanceId );

CREATE INDEX WFTaskHTaskGroupId_I ON E$WFTaskHistory
    (taskGroupId );

CREATE INDEX WFTaskHTaskIdPattern_I ON E$WFTaskHistory
    (taskId , version , workflowPattern );

CREATE INDEX WFTaskHTaskIdTaskGroupId_I ON E$WFTaskHistory
    (taskId , version , taskGroupId );

CREATE INDEX WFTaskHUpdatedBy_I ON E$WFTaskHistory
    (updatedBy );

CREATE INDEX WFTaskHDecTaskGrpInsId_I ON E$WFTaskHistory
    (decomposedTaskGrpInstanceId );

CREATE INDEX WFTaskHTaskGrpInsId_I ON E$WFTaskHistory
    (taskGroupInstanceId );

-- ----------------------------------------------------------------------- 
-- E$WFTaskHistory_TL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskHistory_TL
(
    taskId VARCHAR2(64) NOT NULL,
    version NUMBER NOT NULL,
    locale VARCHAR2(200) NOT NULL,
    title VARCHAR2(1500),
    category VARCHAR2(600),
    subCategory VARCHAR2(600),
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTaskHistory_TL
 AS SELECT taskId, version, locale, title, category, subCategory, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskHistory_TL;

ALTER TABLE E$WFTaskHistory_TL
    ADD CONSTRAINT WFTaskHistory_TL_PK PRIMARY KEY (taskId, version, locale);

-- ----------------------------------------------------------------------- 
-- E$WFTaskMetadata 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskMetadata
(
    id VARCHAR2(200) NOT NULL,
    uri VARCHAR2(2000),
    name VARCHAR2(200),
    title VARCHAR2(2000),
    description VARCHAR2(2000),
    domainId VARCHAR2(100),
    processName VARCHAR2(100),
    processId VARCHAR2(100),
    processVersion VARCHAR2(100),
    componentName VARCHAR2(500),
    compositeDN VARCHAR2(500),
    compositeName VARCHAR2(200),
    compositeVersion VARCHAR2(200),
    applicationName VARCHAR2(200),
    namespace VARCHAR2(200),
    organizationalUnitId VARCHAR2(64),
    descriptionKey VARCHAR2(200),
    category VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW WFTaskMetadata
 AS SELECT id, uri, name, title, description, domainId, processName, processId, processVersion, componentName, compositeDN, compositeName, compositeVersion, applicationName, namespace, organizationalUnitId, descriptionKey, category FROM E$WFTaskMetadata;

ALTER TABLE E$WFTaskMetadata
    ADD CONSTRAINT WFTaskMetadata_PK PRIMARY KEY (id);

CREATE INDEX WFTaskMetadata_NameSpcVerIdx ON E$WFTaskMetadata
    (namespace , compositeVersion );

-- ----------------------------------------------------------------------- 
-- E$WFTaskSequenceChanges 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskSequenceChanges
(
    id VARCHAR2(64) NOT NULL,
    correlationId VARCHAR2(64),
    anchorChain VARCHAR2(2000),
    changeType VARCHAR2(20),
    anchorType VARCHAR2(100),
    anchorAssignee VARCHAR2(1000),
    changeAssignee VARCHAR2(1000),
    responseType VARCHAR2(20),
    updatedBy VARCHAR2(400),
    updatedDate DATE,
    seqnum NUMBER,
    status VARCHAR2(100),
    numberOfTimesModified NUMBER
);

CREATE OR REPLACE EDITIONING VIEW WFTaskSequenceChanges
 AS SELECT id, correlationId, anchorChain, changeType, anchorType, anchorAssignee, changeAssignee, responseType, updatedBy, updatedDate, seqnum, status, numberOfTimesModified FROM E$WFTaskSequenceChanges;

ALTER TABLE E$WFTaskSequenceChanges
    ADD CONSTRAINT WFTaskSequenceChanges_PK PRIMARY KEY (id);

CREATE INDEX WFTaskSequenceChanges_N1 ON E$WFTaskSequenceChanges
    (correlationId , anchorChain , changeType , anchorType );

-- ----------------------------------------------------------------------- 
-- E$WFTaskTimer 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFTaskTimer
(
    id VARCHAR2(300) NOT NULL,
    taskId VARCHAR2(64),
    jobName VARCHAR2(30),
    jobDate DATE,
    taskCreatedDate DATE,
    compositeCreatedTime TIMESTAMP DEFAULT systimestamp-30,
    taskState VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (compositeCreatedTime)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW WFTaskTimer
 AS SELECT id, taskId, jobName, jobDate, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskTimer;

ALTER TABLE E$WFTaskTimer
    ADD CONSTRAINT WFTaskTimer_PK PRIMARY KEY (id);

CREATE INDEX WFTaskTimerTaskId_I ON E$WFTaskTimer
    (taskId );

-- ----------------------------------------------------------------------- 
-- E$WFUserPreference 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFUserPreference
(
    userName VARCHAR2(400) NOT NULL,
    identityContext VARCHAR2(200) NOT NULL,
    preferenceName VARCHAR2(100) NOT NULL,
    preferenceValue VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW WFUserPreference
 AS SELECT userName, identityContext, preferenceName, preferenceValue FROM E$WFUserPreference;

ALTER TABLE E$WFUserPreference
    ADD CONSTRAINT WFUserPreference_PK PRIMARY KEY (userName, identityContext, preferenceName);

-- ----------------------------------------------------------------------- 
-- E$WFUserTaskView 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFUserTaskView
(
    viewName VARCHAR2(100) NOT NULL,
    viewId VARCHAR2(64) NOT NULL,
    viewType VARCHAR2(15),
    viewOwner VARCHAR2(400) NOT NULL,
    identityContext VARCHAR2(200) NOT NULL,
    hidden VARCHAR2(1),
    description VARCHAR2(1000),
    definition BLOB,
    createdDate DATE,
    updatedDate DATE,
    presentationId VARCHAR2(64)
)
;

CREATE OR REPLACE EDITIONING VIEW WFUserTaskView
 AS SELECT viewName, viewId, viewType, viewOwner, identityContext, hidden, description, definition, createdDate, updatedDate, presentationId FROM E$WFUserTaskView;

ALTER TABLE E$WFUserTaskView
    ADD CONSTRAINT WFUserTaskView_PK PRIMARY KEY (viewId);

ALTER TABLE E$WFUserTaskView ADD CONSTRAINT WFUserTaskView_UIdx UNIQUE
    (viewOwner , identityContext , viewName );

CREATE INDEX WFUserTaskView_PresId_I ON E$WFUserTaskView
    (presentationId );

-- ----------------------------------------------------------------------- 
-- E$WFUserTaskViewGrant 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFUserTaskViewGrant
(
    grantee VARCHAR2(400) NOT NULL,
    identityContext VARCHAR2(200) NOT NULL,
    viewId VARCHAR2(64) NOT NULL,
    grantedName VARCHAR2(400) NOT NULL,
    grantedDesc VARCHAR2(1000),
    hidden VARCHAR2(1),
    grantType VARCHAR2(20),
    granteeType VARCHAR2(20)
);

CREATE OR REPLACE EDITIONING VIEW WFUserTaskViewGrant
 AS SELECT grantee, identityContext, viewId, grantedName, grantedDesc, hidden, grantType, granteeType FROM E$WFUserTaskViewGrant;

ALTER TABLE E$WFUserTaskViewGrant
    ADD CONSTRAINT WFUserTaskViewGrant_PK PRIMARY KEY (grantee, identityContext, viewId);

ALTER TABLE E$WFUserTaskViewGrant ADD CONSTRAINT WFUserTaskViewGrant_UIdx UNIQUE
    (grantee , identityContext , grantedName );

CREATE INDEX WFUserTaskViewGrantId ON E$WFUserTaskViewGrant
    (viewId );

-- ----------------------------------------------------------------------- 
-- E$WFUserVacation 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFUserVacation
(
    userId VARCHAR2(400) NOT NULL,
    identityContext VARCHAR2(200) NOT NULL,
    startDate DATE,
    endDate DATE
);

CREATE OR REPLACE EDITIONING VIEW WFUserVacation
 AS SELECT userId, identityContext, startDate, endDate FROM E$WFUserVacation;

ALTER TABLE E$WFUserVacation
    ADD CONSTRAINT WFUserVacation_PK PRIMARY KEY (userId, identityContext);

-- ----------------------------------------------------------------------- 
-- E$WFWORKQUEUE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFWORKQUEUE
(
    NAME VARCHAR2(600) NOT NULL,
    QUEUE_TYPE VARCHAR2(10) DEFAULT 'WFTASK',
    PRIORITY INTEGER,
    TASK_TYPE VARCHAR2(1000),
    DISPLAY_NAME VARCHAR2(1000),
    DISPLAY_NAME_KEY VARCHAR2(600),
    DESCRIPTION CLOB,
    DESCRIPTION_KEY VARCHAR2(600),
    CREATED_BY VARCHAR2(400),
    UPDATED_BY VARCHAR2(400),
    CREATED_DATE TIMESTAMP,
    UPDATED_DATE TIMESTAMP,
    DEFINITION BLOB
)
;

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE
 AS SELECT NAME, QUEUE_TYPE, PRIORITY, TASK_TYPE, DISPLAY_NAME, DISPLAY_NAME_KEY, DESCRIPTION, DESCRIPTION_KEY, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, DEFINITION FROM E$WFWORKQUEUE;

ALTER TABLE E$WFWORKQUEUE
    ADD CONSTRAINT WFWORKQUEUE_PK PRIMARY KEY (NAME);

-- ----------------------------------------------------------------------- 
-- E$WFWORKQUEUE_MEMBER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFWORKQUEUE_MEMBER
(
    WORKQUEUE_NAME VARCHAR2(600) NOT NULL,
    MEMBER_NAME VARCHAR2(400) NOT NULL,
    MEMBER_TYPE VARCHAR2(20) NOT NULL,
    APPLICATION_CONTEXT VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE_MEMBER
 AS SELECT WORKQUEUE_NAME, MEMBER_NAME, MEMBER_TYPE, APPLICATION_CONTEXT FROM E$WFWORKQUEUE_MEMBER;

ALTER TABLE E$WFWORKQUEUE_MEMBER
    ADD CONSTRAINT WFWORKQUEUE_MEMBER_PK PRIMARY KEY (WORKQUEUE_NAME, MEMBER_NAME, MEMBER_TYPE);

CREATE INDEX WFWQMEMBERNAME_IDX ON E$WFWORKQUEUE_MEMBER
    (MEMBER_NAME , MEMBER_TYPE , APPLICATION_CONTEXT );

-- ----------------------------------------------------------------------- 
-- E$WFWORKQUEUE_MANAGER 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFWORKQUEUE_MANAGER
(
    WORKQUEUE_NAME VARCHAR2(600) NOT NULL,
    MANAGER_NAME VARCHAR2(400) NOT NULL,
    MANAGER_TYPE VARCHAR2(20) NOT NULL,
    APPLICATION_CONTEXT VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE_MANAGER
 AS SELECT WORKQUEUE_NAME, MANAGER_NAME, MANAGER_TYPE, APPLICATION_CONTEXT FROM E$WFWORKQUEUE_MANAGER;

ALTER TABLE E$WFWORKQUEUE_MANAGER
    ADD CONSTRAINT WFWORKQUEUE_MANAGER_PK PRIMARY KEY (WORKQUEUE_NAME, MANAGER_NAME, MANAGER_TYPE);

CREATE INDEX WFWQMANAGNERNAME_IDX ON E$WFWORKQUEUE_MANAGER
    (MANAGER_NAME , MANAGER_TYPE , APPLICATION_CONTEXT );

-- ----------------------------------------------------------------------- 
-- E$WFWORKQUEUE_SKIP 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WFWORKQUEUE_SKIP
(
    WORKQUEUE_NAME VARCHAR2(600) NOT NULL,
    WORKITEM_ID VARCHAR2(64) NOT NULL,
    USERNAME VARCHAR2(400) NOT NULL,
    SKIP_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE_SKIP
 AS SELECT WORKQUEUE_NAME, WORKITEM_ID, USERNAME, SKIP_DATE FROM E$WFWORKQUEUE_SKIP;

ALTER TABLE E$WFWORKQUEUE_SKIP
    ADD CONSTRAINT WFWORKQUEUE_SKIP_PK PRIMARY KEY (WORKQUEUE_NAME, WORKITEM_ID, USERNAME);

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_AUDIT_DOCUMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_AUDIT_DOCUMENT
(
    ID VARCHAR2(100) NOT NULL,
    AUDIT_ID VARCHAR2(100) NOT NULL,
    NAME VARCHAR2(1000),
    DOCUMENT BLOB,
    TYPE VARCHAR2(100),
    PAYLOAD_KEY VARCHAR2(200),
    INSTANCE_ID VARCHAR2(100),
    CASE_ID VARCHAR2(100),
    MI_PARTITION_DATE TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1
)
storage
(
    freelists 20
)
lob( document )
store as
(
    storage( initial 16K next 16K )
    chunk 8K
    cache
    pctversion 10
)
pctfree 10
pctused 1;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_AUDIT_DOCUMENT
 AS SELECT ID, AUDIT_ID, NAME, DOCUMENT, TYPE, PAYLOAD_KEY, INSTANCE_ID, CASE_ID, MI_PARTITION_DATE, TENANT_ID FROM E$MEDIATOR_AUDIT_DOCUMENT;

ALTER TABLE E$MEDIATOR_AUDIT_DOCUMENT
    ADD CONSTRAINT MEDIATOR_AUDIT_DOCUMENT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_CALLBACK 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_CALLBACK
(
    INSTANCE_ID VARCHAR2(100),
    CALLBACK_OPERATION VARCHAR2(1000),
    SOURCE_CONVERSATION_ID VARCHAR2(100),
    SOURCE_URI VARCHAR2(1000),
    REPLY_TO_ADDRESS VARCHAR2(1000),
    REPLY_TO_SERVICE VARCHAR2(1000),
    REPLY_TO_PORTTYPE VARCHAR2(1000),
    SERVICE_NAME VARCHAR2(1000),
    CREATION_DATE TIMESTAMP,
    REPLY_TO_REF_XML VARCHAR2(4000),
    FAULT_TO_REF_XML VARCHAR2(4000),
    WSA_VERSION VARCHAR2(100),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CALLBACK
 AS SELECT INSTANCE_ID, CALLBACK_OPERATION, SOURCE_CONVERSATION_ID, SOURCE_URI, REPLY_TO_ADDRESS, REPLY_TO_SERVICE, REPLY_TO_PORTTYPE, SERVICE_NAME, CREATION_DATE, REPLY_TO_REF_XML, FAULT_TO_REF_XML, WSA_VERSION, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$MEDIATOR_CALLBACK;

CREATE INDEX MEDIATOR_CALLBACK_INDEX1 ON E$MEDIATOR_CALLBACK
    (INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_CASE_DETAIL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_CASE_DETAIL
(
    INSTANCE_ID VARCHAR2(100),
    CASE_ID VARCHAR2(100),
    TRAIL_SEQ INTEGER,
    STATE INTEGER,
    AUDIT_TRAIL BLOB,
    CREATED_TIME TIMESTAMP,
    MI_PARTITION_DATE TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CASE_DETAIL
 AS SELECT INSTANCE_ID, CASE_ID, TRAIL_SEQ, STATE, AUDIT_TRAIL, CREATED_TIME, MI_PARTITION_DATE, TENANT_ID FROM E$MEDIATOR_CASE_DETAIL;

CREATE INDEX MEDIATOR_CASE_DETAIL_INDEX1 ON E$MEDIATOR_CASE_DETAIL
    (INSTANCE_ID );

CREATE INDEX MEDIATOR_CASE_DETAIL_INDEX2 ON E$MEDIATOR_CASE_DETAIL
    (CASE_ID );

CREATE INDEX MEDIATOR_CASE_DETAIL_INDEX3 ON E$MEDIATOR_CASE_DETAIL
    (CASE_ID , INSTANCE_ID , TRAIL_SEQ );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_CASE_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_CASE_INSTANCE
(
    ID VARCHAR2(100) NOT NULL,
    INSTANCE_ID VARCHAR2(100),
    CONVERSATION_ID VARCHAR2(100),
    DEF_MESSAGE_ID VARCHAR2(100),
    SYSTEM VARCHAR2(100),
    CASE_NAME VARCHAR2(1000),
    TARGET_TYPE VARCHAR2(100),
    TARGET_ACTION_NAME VARCHAR2(1000),
    TARGET_REFERENCE VARCHAR2(1000),
    CALLBACK_OPERATION VARCHAR2(1000),
    EXCEPTION_TYPE VARCHAR2(100),
    SHORT_EXCEPTION_MSG VARCHAR2(4000),
    EXCEPTION_MSG VARCHAR2(4000),
    EXCEPTION_TRACE VARCHAR2(4000),
    FAULT_NAME VARCHAR2(4000),
    FAULT_OBJ BLOB,
    RETRY_COUNT INTEGER,
    RETRY_INTERVAL INTEGER,
    STEP VARCHAR2(100),
    SOURCE_URI VARCHAR2(1000),
    RECOVERABLE INTEGER,
    STATUS VARCHAR2(20),
    LOCK_TIME TIMESTAMP,
    CONTAINER_ID VARCHAR2(100),
    CREATED_TIME TIMESTAMP,
    MI_PARTITION_DATE TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    PROPERTIES VARCHAR2(4000)
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CASE_INSTANCE
 AS SELECT ID, INSTANCE_ID, CONVERSATION_ID, DEF_MESSAGE_ID, SYSTEM, CASE_NAME, TARGET_TYPE, TARGET_ACTION_NAME, TARGET_REFERENCE, CALLBACK_OPERATION, EXCEPTION_TYPE, SHORT_EXCEPTION_MSG, EXCEPTION_MSG, EXCEPTION_TRACE, FAULT_NAME, FAULT_OBJ, RETRY_COUNT, RETRY_INTERVAL, STEP, SOURCE_URI, RECOVERABLE, STATUS, LOCK_TIME, CONTAINER_ID, CREATED_TIME, MI_PARTITION_DATE, TENANT_ID, PROPERTIES FROM E$MEDIATOR_CASE_INSTANCE;

ALTER TABLE E$MEDIATOR_CASE_INSTANCE
    ADD CONSTRAINT MEDIATOR_CASE_INSTANCE_PK PRIMARY KEY (ID);

CREATE INDEX MEDIATOR_CASE_INSTANCE_INDEX2 ON E$MEDIATOR_CASE_INSTANCE
    (INSTANCE_ID );

CREATE INDEX MEDIATOR_CASE_INSTANCE_INDEX3 ON E$MEDIATOR_CASE_INSTANCE
    (STATUS , LOCK_TIME );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_CONTAINERID_LEASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_CONTAINERID_LEASE
(
    CONTAINER_ID VARCHAR2(100) NOT NULL,
    RENEWAL_TIME TIMESTAMP WITH TIME ZONE
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$MEDIATOR_CONTAINERID_LEASE;

ALTER TABLE E$MEDIATOR_CONTAINERID_LEASE
    ADD CONSTRAINT MEDIATOR_CONTAINERID_LEASE_PK PRIMARY KEY (CONTAINER_ID);

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_CORRELATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_CORRELATION
(
    CONVERSATION_ID VARCHAR2(100),
    INSTANCE_ID VARCHAR2(100),
    CASE_INSTANCE_ID VARCHAR2(100),
    CALLBACK_OPERATION VARCHAR2(1000),
    CALLBACK_CASE VARCHAR2(4000),
    RESPONSE_COUNT INTEGER,
    CREATION_DATE TIMESTAMP,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CORRELATION
 AS SELECT CONVERSATION_ID, INSTANCE_ID, CASE_INSTANCE_ID, CALLBACK_OPERATION, CALLBACK_CASE, RESPONSE_COUNT, CREATION_DATE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$MEDIATOR_CORRELATION;

CREATE INDEX MEDIATOR_CORRELATION_INDEX1 ON E$MEDIATOR_CORRELATION
    (CONVERSATION_ID );

CREATE INDEX MEDIATOR_CORRELATION_INDEX2 ON E$MEDIATOR_CORRELATION
    (INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_DEFERRED_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_DEFERRED_MESSAGE
(
    CASE_ID VARCHAR2(1000),
    COMPONENT_DN VARCHAR2(1000),
    QNAME_LOCAL_PART VARCHAR2(1000),
    QNAME_NAMESPACE VARCHAR2(1000),
    SOURCE_URI VARCHAR2(1000),
    OPERATION VARCHAR2(1000),
    MSG_ID VARCHAR2(1000),
    CASE_INFO VARCHAR2(4000),
    PRIORITY NUMBER,
    INSTANCE_CREATED VARCHAR2(20),
    STATUS NUMBER,
    CREATION_DATE TIMESTAMP,
    LOCK_TIME TIMESTAMP,
    COMPONENT_STATUS NUMBER,
    IS_EVENT NUMBER,
    CONTAINER_ID VARCHAR2(100),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    MSG_RECEIVED_TIME TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
)
 PARTITION BY RANGE (CREATION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_DEFERRED_MESSAGE
 AS SELECT CASE_ID, COMPONENT_DN, QNAME_LOCAL_PART, QNAME_NAMESPACE, SOURCE_URI, OPERATION, MSG_ID, CASE_INFO, PRIORITY, INSTANCE_CREATED, STATUS, CREATION_DATE, LOCK_TIME, COMPONENT_STATUS, IS_EVENT, CONTAINER_ID, TENANT_ID, FLOW_ID, SCA_PARTITION_ID, MSG_RECEIVED_TIME, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_DEFERRED_MESSAGE;

CREATE INDEX MEDIATOR_DEFERRED_INDEX1 ON E$MEDIATOR_DEFERRED_MESSAGE
    (CASE_ID );

CREATE INDEX MEDIATOR_DEFERRED_INDEX_PS3_1 ON E$MEDIATOR_DEFERRED_MESSAGE
    (DUMMY1 );

CREATE INDEX MEDIATOR_DEFERRED_INDEX2 ON E$MEDIATOR_DEFERRED_MESSAGE
    (COMPONENT_STATUS );

CREATE INDEX MEDIATOR_DEFERRED_INDEX3 ON E$MEDIATOR_DEFERRED_MESSAGE
    (STATUS , LOCK_TIME , CONTAINER_ID );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_INSTANCE
(
    ECID VARCHAR2(100),
    COMPOSITE_INSTANCE_ID INTEGER,
    ID VARCHAR2(100),
    PARENT_ID VARCHAR2(100),
    PARENT_REF_ID VARCHAR2(200),
    CONVERSATION_ID VARCHAR2(100),
    COMPONENT_NAME VARCHAR2(1000),
    OUTCOME VARCHAR2(1000),
    COMPONENT_STATE INTEGER,
    SOURCE_TYPE VARCHAR2(100),
    SOURCE_ACTION_NAME VARCHAR2(1000),
    CASE_NUM INTEGER,
    COMPLETED_CASE_NUM INTEGER,
    CREATED_BY VARCHAR2(1000),
    CREATED_TIME TIMESTAMP NOT NULL,
    UPDATED_BY VARCHAR2(1000),
    UPDATED_TIME TIMESTAMP,
    COMPOSITE_CREATION_DATE TIMESTAMP,
    COMPONENT_DN VARCHAR2(1000),
    COMPONENT_TYPE VARCHAR2(100),
    RESEQUENCER_TYPE VARCHAR2(100),
    GROUP_ID VARCHAR2(1000),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER,
    CIKEY INTEGER
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_INSTANCE
 AS SELECT ECID, COMPOSITE_INSTANCE_ID, ID, PARENT_ID, PARENT_REF_ID, CONVERSATION_ID, COMPONENT_NAME, OUTCOME, COMPONENT_STATE, SOURCE_TYPE, SOURCE_ACTION_NAME, CASE_NUM, COMPLETED_CASE_NUM, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, COMPOSITE_CREATION_DATE, COMPONENT_DN, COMPONENT_TYPE, RESEQUENCER_TYPE, GROUP_ID, TENANT_ID, FLOW_ID, CIKEY FROM E$MEDIATOR_INSTANCE;

CREATE INDEX MEDIATOR_INSTANCE_INDEX1 ON E$MEDIATOR_INSTANCE
    (ID );

CREATE INDEX MEDIATOR_INSTANCE_INDEX2 ON E$MEDIATOR_INSTANCE
    (CREATED_TIME DESC, COMPONENT_STATE );

CREATE INDEX MEDIATOR_INSTANCE_INDEX3 ON E$MEDIATOR_INSTANCE
    (COMPONENT_NAME , COMPONENT_STATE );

CREATE INDEX MEDIATOR_INSTANCE_INDEX4 ON E$MEDIATOR_INSTANCE
    (ECID );

CREATE INDEX MEDIATOR_INSTANCE_INDEX5 ON E$MEDIATOR_INSTANCE
    (COMPLETED_CASE_NUM , CASE_NUM , COMPONENT_NAME );

CREATE INDEX MEDIATOR_INSTANCE_INDEX6 ON E$MEDIATOR_INSTANCE
    (COMPONENT_STATE , COMPONENT_NAME );

CREATE INDEX MEDIATOR_INSTANCE_INDEX7 ON E$MEDIATOR_INSTANCE
    (CREATED_TIME , COMPONENT_NAME );

CREATE INDEX MEDIATOR_INSTANCE_CMPSTID ON E$MEDIATOR_INSTANCE
    (COMPOSITE_INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_PAYLOAD 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_PAYLOAD
(
    ID VARCHAR2(100),
    OWNER_ID VARCHAR2(100),
    NAME VARCHAR2(1000),
    TYPE VARCHAR2(100),
    BIN BLOB,
    MODIFY_DATE TIMESTAMP,
    BIN_FORMAT INTEGER,
    CREATION_TIME TIMESTAMP
)
 PARTITION BY RANGE (CREATION_TIME)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_PAYLOAD
 AS SELECT ID, OWNER_ID, NAME, TYPE, BIN, MODIFY_DATE, BIN_FORMAT, CREATION_TIME FROM E$MEDIATOR_PAYLOAD;

CREATE INDEX MEDIATOR_PAYLOAD_INDEX ON E$MEDIATOR_PAYLOAD
    (OWNER_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_SOURCE_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_SOURCE_MESSAGE
(
    ID VARCHAR2(256) NOT NULL,
    SOURCE_NAME VARCHAR2(128),
    DATA_STORAGE_ID VARCHAR2(256) NOT NULL,
    SOURCE_ENDPOINT_REF VARCHAR2(512),
    SOURCE_TYPE VARCHAR2(128),
    SOURCE_REF_ID VARCHAR2(256),
    FILE_NAME VARCHAR2(256),
    TRANSFORMED_FILE_NAME VARCHAR2(256),
    CONTENT_IDENTIFIER VARCHAR2(256),
    FLOW_ID VARCHAR2(256),
    CORRELATION_FLOW_ID VARCHAR2(256),
    ECID VARCHAR2(128),
    SENDER_USER_NAME VARCHAR2(256),
    TRANSFER_METHOD VARCHAR2(128) NOT NULL,
    SOURCE_ID VARCHAR2(256),
    SOURCE_LABEL VARCHAR2(256),
    RESUBMIT_CORRELATION_ID VARCHAR2(256),
    RESUBMITTED_COUNT NUMBER,
    RECENT_RESUBMIT_STATUS VARCHAR2(128),
    STATUS VARCHAR2(128),
    SUB_STATUS VARCHAR2(128),
    STATUS_DETAILS VARCHAR2(128),
    SCHEDULE_DETAILS TIMESTAMP,
    ERROR_INFO_ID VARCHAR2(256),
    SECURITY_INFO_ID VARCHAR2(256),
    TRANSFORMED_DATA_STORAGE_ID VARCHAR2(256),
    PRIORITY NUMBER NOT NULL,
    TRIGGER_EVENT_SESSION_ID VARCHAR2(256),
    PROP_VALUE1 VARCHAR2(512),
    PROP_VALUE2 VARCHAR2(512),
    PROP_VALUE3 VARCHAR2(512),
    PROP_VALUE4 VARCHAR2(512),
    PROP_VALUE5 VARCHAR2(512),
    MESSAGE_PROP_CLOB CLOB,
    TRANSPORT_CERTIFICATES_CLOB CLOB,
    TRANSPORT_HEADER_CLOB CLOB,
    MODIFIED_MESSAGE_PROP_CLOB CLOB,
    MODIFIED_TRANSPORT_HEADER_CLOB CLOB,
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 NUMBER(18,0),
    ATTRIBUTE2 VARCHAR2(64),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_SOURCE_MESSAGE
 AS SELECT ID, SOURCE_NAME, DATA_STORAGE_ID, SOURCE_ENDPOINT_REF, SOURCE_TYPE, SOURCE_REF_ID, FILE_NAME, TRANSFORMED_FILE_NAME, CONTENT_IDENTIFIER, FLOW_ID, CORRELATION_FLOW_ID, ECID, SENDER_USER_NAME, TRANSFER_METHOD, SOURCE_ID, SOURCE_LABEL, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, STATUS, SUB_STATUS, STATUS_DETAILS, SCHEDULE_DETAILS, ERROR_INFO_ID, SECURITY_INFO_ID, TRANSFORMED_DATA_STORAGE_ID, PRIORITY, TRIGGER_EVENT_SESSION_ID, PROP_VALUE1, PROP_VALUE2, PROP_VALUE3, PROP_VALUE4, PROP_VALUE5, MESSAGE_PROP_CLOB, TRANSPORT_CERTIFICATES_CLOB, TRANSPORT_HEADER_CLOB, MODIFIED_MESSAGE_PROP_CLOB, MODIFIED_TRANSPORT_HEADER_CLOB, CREATE_TS, LAST_MODIFY_TS, CPST_INST_CREATED_TIME, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_SOURCE_MESSAGE;

ALTER TABLE E$MFT_SOURCE_MESSAGE
    ADD CONSTRAINT MFT_SOURCE_MESSAGE_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_SM_SRC_NAME ON E$MFT_SOURCE_MESSAGE
    (SOURCE_NAME );

CREATE INDEX MFT_IDX_SM_FILE_NAME ON E$MFT_SOURCE_MESSAGE
    (FILE_NAME );

CREATE INDEX MFT_IDX_SM_SRC_ID_SUB_STATUS ON E$MFT_SOURCE_MESSAGE
    (SOURCE_ID , SUB_STATUS );

CREATE INDEX MFT_IDX_SM_SRC_REF_ID ON E$MFT_SOURCE_MESSAGE
    (SOURCE_REF_ID );

CREATE INDEX MFT_IDX_SM_CORR_FLOW_ID ON E$MFT_SOURCE_MESSAGE
    (CORRELATION_FLOW_ID );

CREATE INDEX MFT_IDX_SM_PRIORITY ON E$MFT_SOURCE_MESSAGE
    (PRIORITY );

CREATE INDEX MFT_IDX_SM_CRT_TS ON E$MFT_SOURCE_MESSAGE
    (CREATE_TS );

CREATE INDEX MFT_IDX_SM_TRG_EVT_SES_ID ON E$MFT_SOURCE_MESSAGE
    (TRIGGER_EVENT_SESSION_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_SECURITY_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_SECURITY_INFO
(
    ID VARCHAR2(256) NOT NULL,
    VERSION VARCHAR2(128),
    ENCRYPTION_CERTIFICATE VARCHAR2(2000),
    ENCRYPTION_ALGORITHM VARCHAR2(128),
    ENCRYPTION_PROTOCOL VARCHAR2(128),
    SIGNING_CERTIFICATE VARCHAR2(2000),
    SIGNING_ALGORITHM VARCHAR2(128),
    SIGNING_PROTOCOL VARCHAR2(128),
    DIGEST_ALGORITHM VARCHAR2(128),
    MESSAGE_DIGEST VARCHAR2(40),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_SECURITY_INFO
 AS SELECT ID, VERSION, ENCRYPTION_CERTIFICATE, ENCRYPTION_ALGORITHM, ENCRYPTION_PROTOCOL, SIGNING_CERTIFICATE, SIGNING_ALGORITHM, SIGNING_PROTOCOL, DIGEST_ALGORITHM, MESSAGE_DIGEST, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_SECURITY_INFO;

ALTER TABLE E$MFT_SECURITY_INFO
    ADD CONSTRAINT MFT_SECURITY_INFO_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$MFT_RETRY_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_RETRY_INFO
(
    ID VARCHAR2(256) NOT NULL,
    TARGET_MESSAGE_ID VARCHAR2(256),
    CALLOUT_INSTANCE_ID VARCHAR2(256),
    STATUS VARCHAR2(128),
    COUNT NUMBER,
    ESS_RETRY_JOB_ID VARCHAR2(256),
    SCHEDULE_DETAILS TIMESTAMP,
    RETRIAL_INTERVAL NUMBER(10,0),
    ERROR_INFO_ID VARCHAR2(256),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_RETRY_INFO
 AS SELECT ID, TARGET_MESSAGE_ID, CALLOUT_INSTANCE_ID, STATUS, COUNT, ESS_RETRY_JOB_ID, SCHEDULE_DETAILS, RETRIAL_INTERVAL, ERROR_INFO_ID, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_RETRY_INFO;

ALTER TABLE E$MFT_RETRY_INFO
    ADD CONSTRAINT MFT_RETRY_INFO_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_RI_TM_ID ON E$MFT_RETRY_INFO
    (TARGET_MESSAGE_ID );

CREATE INDEX MFT_IDX_RI_CI_ID ON E$MFT_RETRY_INFO
    (CALLOUT_INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_RESUBMIT_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_RESUBMIT_INFO
(
    ID VARCHAR2(256) NOT NULL,
    TYPE VARCHAR2(128),
    SOURCE_MESSAGE_ID VARCHAR2(256),
    TARGET_MESSAGE_ID VARCHAR2(256),
    INSTANCE_ID VARCHAR2(256),
    TRANSFER_INSTANCE_ID VARCHAR2(256),
    RESUBMITTED_ID VARCHAR2(256),
    SCHEDULE_DETAILS TIMESTAMP,
    ESS_JOB_ID VARCHAR2(256),
    USER_COMMENT VARCHAR2(2000),
    RESUBMITTED_BY VARCHAR2(256),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_RESUBMIT_INFO
 AS SELECT ID, TYPE, SOURCE_MESSAGE_ID, TARGET_MESSAGE_ID, INSTANCE_ID, TRANSFER_INSTANCE_ID, RESUBMITTED_ID, SCHEDULE_DETAILS, ESS_JOB_ID, USER_COMMENT, RESUBMITTED_BY, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_RESUBMIT_INFO;

ALTER TABLE E$MFT_RESUBMIT_INFO
    ADD CONSTRAINT MFT_RESUBMIT_INFO_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_RSI_SM_ID ON E$MFT_RESUBMIT_INFO
    (SOURCE_MESSAGE_ID );

CREATE INDEX MFT_IDX_RSI_TM_ID ON E$MFT_RESUBMIT_INFO
    (TARGET_MESSAGE_ID );

CREATE INDEX MFT_IDX_RSI_INST_ID ON E$MFT_RESUBMIT_INFO
    (INSTANCE_ID );

CREATE INDEX MFT_IDX_RSI_TR_INST_ID ON E$MFT_RESUBMIT_INFO
    (TRANSFER_INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_PAUSED_INSTANCE_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_PAUSED_INSTANCE_INFO
(
    ID VARCHAR2(256) NOT NULL,
    TARGET_MESSAGE_ID VARCHAR2(256) NOT NULL,
    CURRENT_STATE VARCHAR2(128) NOT NULL,
    PAUSED_BY_USER VARCHAR2(256) NOT NULL,
    PAUSED_COMMENTS VARCHAR2(2000),
    PAUSED_ON TIMESTAMP NOT NULL,
    BYTES_TRASNFERRED NUMBER,
    PERCENT_TRANSFERRED FLOAT,
    RESUMED_BY_USER VARCHAR2(256),
    RESUMED_COMMENTS VARCHAR2(2000),
    RESUMED_ON TIMESTAMP,
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_PAUSED_INSTANCE_INFO
 AS SELECT ID, TARGET_MESSAGE_ID, CURRENT_STATE, PAUSED_BY_USER, PAUSED_COMMENTS, PAUSED_ON, BYTES_TRASNFERRED, PERCENT_TRANSFERRED, RESUMED_BY_USER, RESUMED_COMMENTS, RESUMED_ON, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_PAUSED_INSTANCE_INFO;

ALTER TABLE E$MFT_PAUSED_INSTANCE_INFO
    ADD CONSTRAINT MFT_PAUSED_INSTANCE_INFO_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_PII_TM_ID ON E$MFT_PAUSED_INSTANCE_INFO
    (TARGET_MESSAGE_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_TARGET_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TARGET_INSTANCE
(
    ID VARCHAR2(256) NOT NULL,
    DATA_STORAGE_ID VARCHAR2(256),
    TRANSFER_NAME VARCHAR2(128) NOT NULL,
    TARGET_NAME VARCHAR2(128) NOT NULL,
    STATUS VARCHAR2(128),
    SUB_STATUS VARCHAR2(128),
    PRIORITY NUMBER,
    TRANSFER_INSTANCE_ID VARCHAR2(256) NOT NULL,
    SCHEDULE_DETAILS TIMESTAMP,
    INSTANCE_PROCESS_START_TIME TIMESTAMP,
    INSTANCE_PROCESS_END_TIME TIMESTAMP,
    TRANSFER_LABEL VARCHAR2(256),
    TARGET_ID VARCHAR2(256),
    TARGET_LABEL VARCHAR2(256),
    TRANSFER_TARGET_ID VARCHAR2(256),
    ERROR_INFO_ID VARCHAR2(256),
    IS_MANUALLY_MODIFIED NUMBER(1,0),
    MODIFIED_BY VARCHAR2(256),
    LAST_CHANGE_COMMENTS VARCHAR2(2000),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    RESUBMIT_CORRELATION_ID VARCHAR2(256),
    RESUBMITTED_COUNT NUMBER,
    RECENT_RESUBMIT_STATUS VARCHAR2(128),
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ESS_JOB_ID VARCHAR2(256),
    ATTRIBUTE1 NUMBER(18,0),
    ATTRIBUTE2 VARCHAR2(64),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TARGET_INSTANCE
 AS SELECT ID, DATA_STORAGE_ID, TRANSFER_NAME, TARGET_NAME, STATUS, SUB_STATUS, PRIORITY, TRANSFER_INSTANCE_ID, SCHEDULE_DETAILS, INSTANCE_PROCESS_START_TIME, INSTANCE_PROCESS_END_TIME, TRANSFER_LABEL, TARGET_ID, TARGET_LABEL, TRANSFER_TARGET_ID, ERROR_INFO_ID, IS_MANUALLY_MODIFIED, MODIFIED_BY, LAST_CHANGE_COMMENTS, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, CPST_INST_CREATED_TIME, ESS_JOB_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_TARGET_INSTANCE;

ALTER TABLE E$MFT_TARGET_INSTANCE
    ADD CONSTRAINT MFT_TARGET_INSTANCE_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_TI_TR_INST_ID ON E$MFT_TARGET_INSTANCE
    (TRANSFER_INSTANCE_ID );

CREATE INDEX MFT_IDX_TI_SUB_ST_TR_TGT_ID ON E$MFT_TARGET_INSTANCE
    (SUB_STATUS , TRANSFER_TARGET_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_ES_AUTHORIZATION 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_ES_AUTHORIZATION
(
    ID VARCHAR2(256) NOT NULL,
    FILE_PATH VARCHAR2(2000) NOT NULL,
    RESOURCE_ID VARCHAR2(256) NOT NULL,
    MFT_SOURCE_MESSAGE_ID VARCHAR2(256) NOT NULL,
    IS_DIRECTORY NUMBER(1,0) DEFAULT 0,
    UPLOADED_BY VARCHAR2(128),
    CREATE_TS TIMESTAMP NOT NULL,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_ES_AUTHORIZATION
 AS SELECT ID, FILE_PATH, RESOURCE_ID, MFT_SOURCE_MESSAGE_ID, IS_DIRECTORY, UPLOADED_BY, CREATE_TS, CPST_INST_CREATED_TIME, LAST_MODIFY_TS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_ES_AUTHORIZATION;

ALTER TABLE E$MFT_ES_AUTHORIZATION
    ADD CONSTRAINT MFT_ES_AUTHORIZATION_PK PRIMARY KEY (ID);

CREATE INDEX MFT_ES_AUTHORIZATION_FP_IX ON E$MFT_ES_AUTHORIZATION
    (FILE_PATH , IS_DIRECTORY );

CREATE INDEX MFT_ES_AUTHORIZATION_SM_IX ON E$MFT_ES_AUTHORIZATION
    (MFT_SOURCE_MESSAGE_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_ERROR_INFO 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_ERROR_INFO
(
    ID VARCHAR2(256) NOT NULL,
    ERROR_CODE VARCHAR2(128),
    ERROR_LEVEL NUMBER,
    ERROR_SEVERITY NUMBER,
    ERROR_DESCRIPTION_CLOB CLOB,
    ERROR_TEXT_CLOB CLOB,
    INSTANCE_TYPE NUMBER NOT NULL,
    INSTANCE_ID VARCHAR2(256),
    CREATE_TS TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_ERROR_INFO
 AS SELECT ID, ERROR_CODE, ERROR_LEVEL, ERROR_SEVERITY, ERROR_DESCRIPTION_CLOB, ERROR_TEXT_CLOB, INSTANCE_TYPE, INSTANCE_ID, CREATE_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_ERROR_INFO;

ALTER TABLE E$MFT_ERROR_INFO
    ADD CONSTRAINT MFT_ERROR_INFO_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_EI_INST_TYPE_ID ON E$MFT_ERROR_INFO
    (INSTANCE_TYPE , INSTANCE_ID );

CREATE INDEX MFT_IDX_CR_TS ON E$MFT_ERROR_INFO
    (CREATE_TS DESC);

-- ----------------------------------------------------------------------- 
-- E$MFT_DATA_STORAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_DATA_STORAGE
(
    ID VARCHAR2(256) NOT NULL,
    CHECKSUM VARCHAR2(512),
    PAYLOAD_REFERENCE VARCHAR2(2000),
    REFERENCE_TYPE NUMBER(1,0),
    INTERNAL_FTP_REF VARCHAR2(2000),
    IS_DIRECTORY_REF NUMBER(1,0) DEFAULT 0,
    IS_PAYLOAD_DELTED NUMBER(1,0) DEFAULT 0,
    IS_ENCRYPTED NUMBER(1,0),
    PAYLOAD BLOB,
    PAYLOAD_SIZE NUMBER(18,0) DEFAULT -1,
    CREATE_TS TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_DATA_STORAGE
 AS SELECT ID, CHECKSUM, PAYLOAD_REFERENCE, REFERENCE_TYPE, INTERNAL_FTP_REF, IS_DIRECTORY_REF, IS_PAYLOAD_DELTED, IS_ENCRYPTED, PAYLOAD, PAYLOAD_SIZE, CREATE_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_DATA_STORAGE;

ALTER TABLE E$MFT_DATA_STORAGE
    ADD CONSTRAINT MFT_DATA_STORAGE_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_PAYLOAD_SZ ON E$MFT_DATA_STORAGE
    (PAYLOAD_SIZE );

-- ----------------------------------------------------------------------- 
-- E$MFT_CALLOUT_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_CALLOUT_INSTANCE
(
    ID VARCHAR2(256) NOT NULL,
    NAME VARCHAR2(128) NOT NULL,
    TYPE VARCHAR2(128) NOT NULL,
    INSTANCE_ID VARCHAR2(256),
    SOURCE_MESSAGE_ID VARCHAR2(256),
    STATUS VARCHAR2(128),
    MODIFIED_FILE_NAME VARCHAR2(128),
    MODIFIED_MESSAGE_PROP_CLOB CLOB,
    MODIFIED_TRANSPORT_HEADER_CLOB CLOB,
    CREATE_TS TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_CALLOUT_INSTANCE
 AS SELECT ID, NAME, TYPE, INSTANCE_ID, SOURCE_MESSAGE_ID, STATUS, MODIFIED_FILE_NAME, MODIFIED_MESSAGE_PROP_CLOB, MODIFIED_TRANSPORT_HEADER_CLOB, CREATE_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_CALLOUT_INSTANCE;

ALTER TABLE E$MFT_CALLOUT_INSTANCE
    ADD CONSTRAINT MFT_CALLOUT_INSTANCE_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_CO_INST_ID ON E$MFT_CALLOUT_INSTANCE
    (INSTANCE_ID );

CREATE INDEX MFT_IDX_CO_SM_ID ON E$MFT_CALLOUT_INSTANCE
    (SOURCE_MESSAGE_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_SOURCE_UNPROCESSED 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_SOURCE_UNPROCESSED
(
    ID VARCHAR2(256) NOT NULL,
    SOURCE_NAME VARCHAR2(128),
    SOURCE_ID VARCHAR2(256),
    CONTENT_TYPE VARCHAR2(128),
    DATA_STORAGE_ID VARCHAR2(256) NOT NULL,
    SOURCE_ENDPOINT_REF VARCHAR2(512),
    SOURCE_TYPE VARCHAR2(128),
    REASON VARCHAR2(128),
    PRIORITY NUMBER,
    MESSAGE_PROP_CLOB CLOB,
    TRANSPORT_CERTIFICATES_CLOB CLOB,
    TRANSPORT_HEADER_CLOB CLOB,
    OTHER_PROPERTIES CLOB,
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 VARCHAR2(256),
    ATTRIBUTE2 VARCHAR2(64)
);

CREATE OR REPLACE EDITIONING VIEW MFT_SOURCE_UNPROCESSED
 AS SELECT ID, SOURCE_NAME, SOURCE_ID, CONTENT_TYPE, DATA_STORAGE_ID, SOURCE_ENDPOINT_REF, SOURCE_TYPE, REASON, PRIORITY, MESSAGE_PROP_CLOB, TRANSPORT_CERTIFICATES_CLOB, TRANSPORT_HEADER_CLOB, OTHER_PROPERTIES, CREATE_TS, LAST_MODIFY_TS, CPST_INST_CREATED_TIME, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_SOURCE_UNPROCESSED;

ALTER TABLE E$MFT_SOURCE_UNPROCESSED
    ADD CONSTRAINT MFT_SOURCE_UNPROCESSED_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$MFT_TRANSFER_INSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TRANSFER_INSTANCE
(
    ID VARCHAR2(256) NOT NULL,
    SOURCE_MESSAGE_ID VARCHAR2(256) NOT NULL,
    CONTENT_TYPE VARCHAR2(128),
    STATUS VARCHAR2(128),
    SUB_STATUS VARCHAR2(128),
    STATUS_DETAILS VARCHAR2(128),
    TRANSFER_INITIATION_TIME TIMESTAMP,
    TRANSFER_COMPLETION_TIME TIMESTAMP,
    TRANSFER_NAME VARCHAR2(128) NOT NULL,
    TRANSFER_ID VARCHAR2(256),
    PRIORITY NUMBER,
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    RESUBMIT_CORRELATION_ID VARCHAR2(256),
    RESUBMITTED_COUNT NUMBER,
    RECENT_RESUBMIT_STATUS VARCHAR2(128),
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    ATTRIBUTE1 NUMBER(18,0),
    ATTRIBUTE2 VARCHAR2(64),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_INSTANCE
 AS SELECT ID, SOURCE_MESSAGE_ID, CONTENT_TYPE, STATUS, SUB_STATUS, STATUS_DETAILS, TRANSFER_INITIATION_TIME, TRANSFER_COMPLETION_TIME, TRANSFER_NAME, TRANSFER_ID, PRIORITY, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_TRANSFER_INSTANCE;

ALTER TABLE E$MFT_TRANSFER_INSTANCE
    ADD CONSTRAINT MFT_TRANSFER_INSTANCE_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_TRI_SM_ID ON E$MFT_TRANSFER_INSTANCE
    (SOURCE_MESSAGE_ID );

CREATE INDEX MFT_IDX_TRI_TR_NAME ON E$MFT_TRANSFER_INSTANCE
    (TRANSFER_NAME );

CREATE INDEX MFT_IDX_TRI_PRIORITY ON E$MFT_TRANSFER_INSTANCE
    (PRIORITY );

CREATE INDEX MFT_IDX_TRI_CR_TS ON E$MFT_TRANSFER_INSTANCE
    (CREATE_TS );

CREATE INDEX MFT_IDX_TFR_IN_TIME ON E$MFT_TRANSFER_INSTANCE
    (TRANSFER_INITIATION_TIME DESC);

-- ----------------------------------------------------------------------- 
-- E$MFT_SOURCE_LIFECYCLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_SOURCE_LIFECYCLE
(
    ID VARCHAR2(256) NOT NULL,
    NAME VARCHAR2(128),
    URI VARCHAR2(2000),
    CATEGORY VARCHAR2(256),
    BINDING_TYPE VARCHAR2(256) NOT NULL,
    IS_LISTENING NUMBER(1,0),
    IS_DEPLOYED NUMBER(1,0) NOT NULL,
    IS_INCLUDE_SUBFOLDER NUMBER(1,0) DEFAULT 0,
    LABEL VARCHAR2(256) NOT NULL,
    VERSION NUMBER,
    STATUS VARCHAR2(128),
    START_ESS_JOB_ID VARCHAR2(256),
    STOP_ESS_JOB_ID VARCHAR2(256),
    START_SCHEDULE_REF VARCHAR2(256),
    STOP_SCHEDULE_REF VARCHAR2(256),
    IS_SCHEDULE_EXPIRED NUMBER(1,0),
    OPSS_RESOURCE_NAME VARCHAR2(256),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    LAST_MODIFIED_BY VARCHAR2(256),
    CREATED_BY VARCHAR2(256),
    CREATE_COMMENTS VARCHAR2(1024),
    LAST_MODIFY_COMMENTS VARCHAR2(1024),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_SOURCE_LIFECYCLE
 AS SELECT ID, NAME, URI, CATEGORY, BINDING_TYPE, IS_LISTENING, IS_DEPLOYED, IS_INCLUDE_SUBFOLDER, LABEL, VERSION, STATUS, START_ESS_JOB_ID, STOP_ESS_JOB_ID, START_SCHEDULE_REF, STOP_SCHEDULE_REF, IS_SCHEDULE_EXPIRED, OPSS_RESOURCE_NAME, CREATE_TS, LAST_MODIFY_TS, LAST_MODIFIED_BY, CREATED_BY, CREATE_COMMENTS, LAST_MODIFY_COMMENTS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_SOURCE_LIFECYCLE;

ALTER TABLE E$MFT_SOURCE_LIFECYCLE
    ADD CONSTRAINT MFT_SOURCE_LIFECYCLE_PK PRIMARY KEY (ID, LABEL);

CREATE INDEX MFT_IDX_SLC_ID ON E$MFT_SOURCE_LIFECYCLE
    (ID );

CREATE INDEX MFT_IDX_SLC_NAME ON E$MFT_SOURCE_LIFECYCLE
    (NAME );

CREATE INDEX MFT_IDX_SLC_URI_BTYPE ON E$MFT_SOURCE_LIFECYCLE
    (URI , BINDING_TYPE );

-- ----------------------------------------------------------------------- 
-- E$MFT_TRANSFER_LIFECYCLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TRANSFER_LIFECYCLE
(
    ID VARCHAR2(256) NOT NULL,
    NAME VARCHAR2(128),
    SOURCE_ID VARCHAR2(256),
    IS_DEPLOYED NUMBER(1,0) NOT NULL,
    LABEL VARCHAR2(256) NOT NULL,
    VERSION NUMBER,
    STATUS VARCHAR2(128),
    OPSS_RESOURCE_NAME VARCHAR2(256),
    IS_FILTER_AVAILABLE NUMBER(1,0),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    LAST_MODIFIED_BY VARCHAR2(256),
    CREATED_BY VARCHAR2(256),
    CREATE_COMMENTS VARCHAR2(1024),
    LAST_MODIFY_COMMENTS VARCHAR2(1024),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_LIFECYCLE
 AS SELECT ID, NAME, SOURCE_ID, IS_DEPLOYED, LABEL, VERSION, STATUS, OPSS_RESOURCE_NAME, IS_FILTER_AVAILABLE, CREATE_TS, LAST_MODIFY_TS, LAST_MODIFIED_BY, CREATED_BY, CREATE_COMMENTS, LAST_MODIFY_COMMENTS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_TRANSFER_LIFECYCLE;

ALTER TABLE E$MFT_TRANSFER_LIFECYCLE
    ADD CONSTRAINT MFT_TRANSFER_LIFECYCLE_PK PRIMARY KEY (ID, LABEL);

CREATE INDEX MFT_IDX_TRLC_ID ON E$MFT_TRANSFER_LIFECYCLE
    (ID );

CREATE INDEX MFT_IDX_TRLC_NAME ON E$MFT_TRANSFER_LIFECYCLE
    (NAME );

CREATE INDEX MFT_IDX_TRLC_SRC_ID ON E$MFT_TRANSFER_LIFECYCLE
    (SOURCE_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_TARGET_LIFECYCLE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TARGET_LIFECYCLE
(
    ID VARCHAR2(256) NOT NULL,
    NAME VARCHAR2(128),
    CATEGORY VARCHAR2(256),
    BINDING_TYPE VARCHAR2(256) NOT NULL,
    IS_DEPLOYED NUMBER(1,0) NOT NULL,
    LABEL VARCHAR2(256) NOT NULL,
    VERSION NUMBER,
    STATUS VARCHAR2(128),
    CREATE_TS TIMESTAMP NOT NULL,
    LAST_MODIFY_TS TIMESTAMP,
    LAST_MODIFIED_BY VARCHAR2(256),
    CREATED_BY VARCHAR2(256),
    CREATE_COMMENTS VARCHAR2(1024),
    LAST_MODIFY_COMMENTS VARCHAR2(1024),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TARGET_LIFECYCLE
 AS SELECT ID, NAME, CATEGORY, BINDING_TYPE, IS_DEPLOYED, LABEL, VERSION, STATUS, CREATE_TS, LAST_MODIFY_TS, LAST_MODIFIED_BY, CREATED_BY, CREATE_COMMENTS, LAST_MODIFY_COMMENTS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_TARGET_LIFECYCLE;

ALTER TABLE E$MFT_TARGET_LIFECYCLE
    ADD CONSTRAINT MFT_TARGET_LIFECYCLE_PK PRIMARY KEY (ID, LABEL);

CREATE INDEX MFT_IDX_TGTLC_ID ON E$MFT_TARGET_LIFECYCLE
    (ID );

CREATE INDEX MFT_IDX_TGTLC_NAME ON E$MFT_TARGET_LIFECYCLE
    (NAME );

-- ----------------------------------------------------------------------- 
-- E$MFT_TRANSFER_TARGET_REL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TRANSFER_TARGET_REL
(
    TRANSFER_ID VARCHAR2(256) NOT NULL,
    TRANSFER_LABEL VARCHAR2(256),
    TARGET_ID VARCHAR2(256) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_TARGET_REL
 AS SELECT TRANSFER_ID, TRANSFER_LABEL, TARGET_ID FROM E$MFT_TRANSFER_TARGET_REL;

CREATE INDEX MFT_IDX_TR_TGT_REL_TR_ID_LABEL ON E$MFT_TRANSFER_TARGET_REL
    (TRANSFER_ID , TRANSFER_LABEL );

CREATE INDEX MFT_IDX_TR_TGT_REL_TGT_ID ON E$MFT_TRANSFER_TARGET_REL
    (TARGET_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_TRANSFER_SCHEDULE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TRANSFER_SCHEDULE
(
    TRANSFER_ID VARCHAR2(256) NOT NULL,
    TRANSFER_LABEL VARCHAR2(256) NOT NULL,
    TARGET_ID VARCHAR2(256) NOT NULL,
    START_ESS_JOB_ID VARCHAR2(256),
    STOP_ESS_JOB_ID VARCHAR2(256),
    START_SCHEDULE_REF VARCHAR2(256),
    STOP_SCHEDULE_REF VARCHAR2(256),
    IS_SCHEDULE_EXPIRED NUMBER(1,0),
    WS_REF_DELIVERY_TYPE NUMBER(1,0),
    ESS_JOB_ID VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_SCHEDULE
 AS SELECT TRANSFER_ID, TRANSFER_LABEL, TARGET_ID, START_ESS_JOB_ID, STOP_ESS_JOB_ID, START_SCHEDULE_REF, STOP_SCHEDULE_REF, IS_SCHEDULE_EXPIRED, WS_REF_DELIVERY_TYPE, ESS_JOB_ID FROM E$MFT_TRANSFER_SCHEDULE;

ALTER TABLE E$MFT_TRANSFER_SCHEDULE
    ADD CONSTRAINT MFT_TRANSFER_SCHEDULE_PK PRIMARY KEY (TRANSFER_ID, TRANSFER_LABEL, TARGET_ID);

CREATE INDEX MFT_IDX_TR_SCHD_TR_ID ON E$MFT_TRANSFER_SCHEDULE
    (TRANSFER_ID );

CREATE INDEX MFT_IDX_TR_SCHD_TGT_ID ON E$MFT_TRANSFER_SCHEDULE
    (TARGET_ID );

-- ----------------------------------------------------------------------- 
-- E$MFT_TARGET_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TARGET_MESSAGE
(
    ID VARCHAR2(256) NOT NULL,
    INSTANCE_ID VARCHAR2(256) NOT NULL,
    DATA_STORAGE_ID VARCHAR2(256) NOT NULL,
    TARGET_NAME VARCHAR2(128),
    ENDPOINT_REFERENCE VARCHAR2(2000),
    PROTOCOL VARCHAR2(128),
    FILE_NAME VARCHAR2(256),
    DELIVERED_FILE_NAME VARCHAR2(256),
    IS_REF_DELIVERY NUMBER(1,0) DEFAULT 0,
    FLOW_ID VARCHAR2(256),
    CORRELATION_FLOW_ID VARCHAR2(256),
    ECID VARCHAR2(128),
    TARGET_REF_ID VARCHAR2(256),
    TARGET_LABEL VARCHAR2(256),
    TRANSFER_START_TIME TIMESTAMP,
    TRANSFER_COMPLETED_TIME TIMESTAMP,
    BYTES_TRANSFERRED NUMBER(18,0),
    TIME_TAKEN NUMBER,
    ERROR_INFO_ID VARCHAR2(256),
    RESUBMIT_CORRELATION_ID VARCHAR2(256),
    RESUBMITTED_COUNT NUMBER,
    RECENT_RESUBMIT_STATUS VARCHAR2(128),
    SECURITY_INFO_ID VARCHAR2(256),
    STATUS VARCHAR2(128),
    DELIVERY_STATUS VARCHAR2(128),
    SENDER_USER_NAME VARCHAR2(256),
    PRIORITY NUMBER,
    INITIAL_FILE_SIZE NUMBER(18,0) DEFAULT -1,
    MESSAGE_PROP_CLOB CLOB,
    TRANSPORT_HEADER_CLOB CLOB,
    LAST_MODIFY_TS TIMESTAMP,
    CREATE_TS TIMESTAMP NOT NULL,
    CPST_INST_CREATED_TIME TIMESTAMP NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 NUMBER(18,0),
    ATTRIBUTE2 VARCHAR2(64),
    ATTRIBUTE3 VARCHAR2(256),
    ATTRIBUTE4 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TARGET_MESSAGE
 AS SELECT ID, INSTANCE_ID, DATA_STORAGE_ID, TARGET_NAME, ENDPOINT_REFERENCE, PROTOCOL, FILE_NAME, DELIVERED_FILE_NAME, IS_REF_DELIVERY, FLOW_ID, CORRELATION_FLOW_ID, ECID, TARGET_REF_ID, TARGET_LABEL, TRANSFER_START_TIME, TRANSFER_COMPLETED_TIME, BYTES_TRANSFERRED, TIME_TAKEN, ERROR_INFO_ID, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, SECURITY_INFO_ID, STATUS, DELIVERY_STATUS, SENDER_USER_NAME, PRIORITY, INITIAL_FILE_SIZE, MESSAGE_PROP_CLOB, TRANSPORT_HEADER_CLOB, LAST_MODIFY_TS, CREATE_TS, CPST_INST_CREATED_TIME, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_TARGET_MESSAGE;

ALTER TABLE E$MFT_TARGET_MESSAGE
    ADD CONSTRAINT MFT_TARGET_MESSAGE_PK PRIMARY KEY (ID);

CREATE INDEX MFT_IDX_TM_INST_ID ON E$MFT_TARGET_MESSAGE
    (INSTANCE_ID );

CREATE INDEX MFT_IDX_TM_TGT_NAME ON E$MFT_TARGET_MESSAGE
    (TARGET_NAME );

CREATE INDEX MFT_IDX_TM_FILE_NAME ON E$MFT_TARGET_MESSAGE
    (FILE_NAME );

CREATE INDEX MFT_IDX_TM_DEL_FILE_NAME ON E$MFT_TARGET_MESSAGE
    (DELIVERED_FILE_NAME );

CREATE INDEX MFT_IDX_TM_CORR_FLOW_ID ON E$MFT_TARGET_MESSAGE
    (CORRELATION_FLOW_ID );

CREATE INDEX MFT_IDX_TM_PRIORITY ON E$MFT_TARGET_MESSAGE
    (PRIORITY );

CREATE INDEX MFT_IDX_TM_CRT_TS ON E$MFT_TARGET_MESSAGE
    (CREATE_TS );

CREATE INDEX MFT_IDX_LST_MOD_TS ON E$MFT_TARGET_MESSAGE
    (LAST_MODIFY_TS DESC);

CREATE INDEX MFT_IDX_STATUS ON E$MFT_TARGET_MESSAGE
    (STATUS );

CREATE INDEX MFT_IDX_DELRY_STATUS ON E$MFT_TARGET_MESSAGE
    (DELIVERY_STATUS );

-- ----------------------------------------------------------------------- 
-- E$MFT_ES_PORT_ASSIGNMENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_ES_PORT_ASSIGNMENT
(
    SERVER_INSTANCE VARCHAR2(256) NOT NULL,
    SERVICE VARCHAR2(256) NOT NULL,
    CONFIGURED_PORT NUMBER NOT NULL,
    RUNNING_PORT NUMBER NOT NULL,
    STATUS VARCHAR2(256) NOT NULL,
    MODIFIED_BY VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_ES_PORT_ASSIGNMENT
 AS SELECT SERVER_INSTANCE, SERVICE, CONFIGURED_PORT, RUNNING_PORT, STATUS, MODIFIED_BY FROM E$MFT_ES_PORT_ASSIGNMENT;

ALTER TABLE E$MFT_ES_PORT_ASSIGNMENT
    ADD CONSTRAINT MFT_ES_PORT_ASSIGNMENT_PK PRIMARY KEY (SERVER_INSTANCE, SERVICE);

-- ----------------------------------------------------------------------- 
-- E$MFT_RCU_PURGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_RCU_PURGE
(
    BATCH_ID VARCHAR2(256) NOT NULL,
    PURGE_CRITERIA VARCHAR2(512) NOT NULL,
    PURGE_STATUS VARCHAR2(32) NOT NULL,
    TOTAL_PURGE_COUNT NUMBER,
    RCU_PURGE_ERROR_COUNT NUMBER,
    FS_PURGE_DONE_COUNT NUMBER,
    FS_PURGE_ERROR_COUNT NUMBER,
    THREAD_COUNT NUMBER,
    USER_COMMENTS VARCHAR2(1024),
    CREATED_BY VARCHAR2(256) NOT NULL,
    CREATE_TS TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW MFT_RCU_PURGE
 AS SELECT BATCH_ID, PURGE_CRITERIA, PURGE_STATUS, TOTAL_PURGE_COUNT, RCU_PURGE_ERROR_COUNT, FS_PURGE_DONE_COUNT, FS_PURGE_ERROR_COUNT, THREAD_COUNT, USER_COMMENTS, CREATED_BY, CREATE_TS FROM E$MFT_RCU_PURGE;

ALTER TABLE E$MFT_RCU_PURGE
    ADD CONSTRAINT MFT_RCU_PURGE_PK PRIMARY KEY (BATCH_ID);

-- ----------------------------------------------------------------------- 
-- E$MFT_TRIGGER_EVENT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_TRIGGER_EVENT
(
    ID VARCHAR2(256) NOT NULL,
    SOURCE_NAME VARCHAR2(256) NOT NULL,
    STATUS VARCHAR2(128),
    COMMENTS VARCHAR2(1024),
    SUBMITTED_BY VARCHAR2(256),
    SUBMITTED_TS TIMESTAMP NOT NULL,
    SERVER_INSTANCE VARCHAR2(256) NOT NULL,
    PROP_CLOB CLOB,
    LAST_MODIFY_TS TIMESTAMP,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    ATTRIBUTE1 VARCHAR2(8),
    ATTRIBUTE2 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_TRIGGER_EVENT
 AS SELECT ID, SOURCE_NAME, STATUS, COMMENTS, SUBMITTED_BY, SUBMITTED_TS, SERVER_INSTANCE, PROP_CLOB, LAST_MODIFY_TS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_TRIGGER_EVENT;

ALTER TABLE E$MFT_TRIGGER_EVENT
    ADD CONSTRAINT MFT_TRIGGER_EVENT_PK PRIMARY KEY (ID);

-- ----------------------------------------------------------------------- 
-- E$MFT_SCHEDULE_PURGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MFT_SCHEDULE_PURGE
(
    ID VARCHAR2(256) NOT NULL,
    NAME VARCHAR2(256) NOT NULL,
    IS_ACTIVE NUMBER(1,0) DEFAULT 0,
    LAST_ACTIVATED_TS TIMESTAMP,
    LAST_ACTIVATED_BY VARCHAR2(256),
    ESS_JOB_ID VARCHAR2(256),
    LAST_EXECUTION_TS TIMESTAMP,
    LAST_PURGE_BATCH_ID VARCHAR2(256),
    LAST_PURGE_EXECUTION_RESULT VARCHAR2(256),
    ATTRIBUTE1 VARCHAR2(256)
);

CREATE OR REPLACE EDITIONING VIEW MFT_SCHEDULE_PURGE
 AS SELECT ID, NAME, IS_ACTIVE, LAST_ACTIVATED_TS, LAST_ACTIVATED_BY, ESS_JOB_ID, LAST_EXECUTION_TS, LAST_PURGE_BATCH_ID, LAST_PURGE_EXECUTION_RESULT, ATTRIBUTE1 FROM E$MFT_SCHEDULE_PURGE;

ALTER TABLE E$MFT_SCHEDULE_PURGE
    ADD CONSTRAINT MFT_SCHEDULE_PURGE_PK PRIMARY KEY (ID);

ALTER TABLE E$MFT_SCHEDULE_PURGE ADD CONSTRAINT MFT_SCHEDULE_PURGE_UK UNIQUE
    (NAME );

-- ----------------------------------------------------------------------- 
-- E$WLI_QS_REPORT_ATTRIBUTE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WLI_QS_REPORT_ATTRIBUTE
(
    MSG_GUID VARCHAR2(64) NOT NULL,
    DB_TIMESTAMP DATE DEFAULT SYSDATE NOT NULL,
    LOCALHOST_TIMESTAMP DATE NOT NULL,
    HOST_NAME VARCHAR2(50) NOT NULL,
    STATE VARCHAR2(8) NOT NULL,
    NODE VARCHAR2(128),
    PIPELINE_NAME VARCHAR2(128),
    STAGE_NAME VARCHAR2(128),
    INBOUND_SERVICE_NAME VARCHAR2(256) NOT NULL,
    INBOUND_SERVICE_URI VARCHAR2(128) NOT NULL,
    INBOUND_OPERATION VARCHAR2(64),
    OUTBOUND_SERVICE_NAME VARCHAR2(256),
    OUTBOUND_SERVICE_URI VARCHAR2(256),
    OUTBOUND_OPERATION VARCHAR2(64),
    MSG_LABELS VARCHAR2(2048),
    ERROR_CODE VARCHAR2(64),
    ERROR_REASON VARCHAR2(1024),
    ERROR_DETAILS VARCHAR2(2048)
)
;

CREATE OR REPLACE EDITIONING VIEW WLI_QS_REPORT_ATTRIBUTE
 AS SELECT MSG_GUID, DB_TIMESTAMP, LOCALHOST_TIMESTAMP, HOST_NAME, STATE, NODE, PIPELINE_NAME, STAGE_NAME, INBOUND_SERVICE_NAME, INBOUND_SERVICE_URI, INBOUND_OPERATION, OUTBOUND_SERVICE_NAME, OUTBOUND_SERVICE_URI, OUTBOUND_OPERATION, MSG_LABELS, ERROR_CODE, ERROR_REASON, ERROR_DETAILS FROM E$WLI_QS_REPORT_ATTRIBUTE;

ALTER TABLE E$WLI_QS_REPORT_ATTRIBUTE
    ADD CONSTRAINT WLI_QS_REPORT_ATTRIBUTE_PK PRIMARY KEY (MSG_GUID);

CREATE INDEX IX_WLI_QS_REPORT_ATTRIBUTE_IED ON E$WLI_QS_REPORT_ATTRIBUTE
    (INBOUND_SERVICE_NAME , ERROR_CODE , DB_TIMESTAMP );

CREATE INDEX IX_WLI_QS_REPORT_ATTRIBUTE_DM ON E$WLI_QS_REPORT_ATTRIBUTE
    (DB_TIMESTAMP , MSG_LABELS );

-- ----------------------------------------------------------------------- 
-- E$WLI_QS_REPORT_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$WLI_QS_REPORT_DATA
(
    MSG_GUID VARCHAR2(64) NOT NULL,
    DATA_TYPE INTEGER,
    ENCODING VARCHAR2(24),
    DATA_VALUE BLOB
);

CREATE OR REPLACE EDITIONING VIEW WLI_QS_REPORT_DATA
 AS SELECT MSG_GUID, DATA_TYPE, ENCODING, DATA_VALUE FROM E$WLI_QS_REPORT_DATA;

ALTER TABLE E$WLI_QS_REPORT_DATA ADD CONSTRAINT IX_WLI_QS_REPORT_DATA UNIQUE
    (MSG_GUID );

-- ----------------------------------------------------------------------- 
-- E$OSB_MSG 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$OSB_MSG
(
    MSG_ID VARCHAR2(100) NOT NULL,
    MSG_TYPE VARCHAR2(100) NOT NULL,
    CREATION_TIME TIMESTAMP,
    MODIFY_TIME TIMESTAMP,
    MSG_BIN BLOB,
    DUMMY1 VARCHAR2(100),
    DUMMY2 VARCHAR2(100),
    DUMMY3 VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW OSB_MSG
 AS SELECT MSG_ID, MSG_TYPE, CREATION_TIME, MODIFY_TIME, MSG_BIN, DUMMY1, DUMMY2, DUMMY3 FROM E$OSB_MSG;

ALTER TABLE E$OSB_MSG
    ADD CONSTRAINT OSB_MSG_PK PRIMARY KEY (MSG_ID, MSG_TYPE);

-- ----------------------------------------------------------------------- 
-- E$RM_SEQUENCES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RM_SEQUENCES
(
    ENDPOINT_UID VARCHAR2(512) NOT NULL,
    ID VARCHAR2(256) NOT NULL,
    TYPE CHAR(1) NOT NULL,
    EXP_TIME NUMBER(19,0) NOT NULL,
    BOUND_ID VARCHAR2(256),
    STR_ID VARCHAR2(256),
    STATUS NUMBER(5,0) NOT NULL,
    ACK_REQUESTED_FLAG CHAR(1),
    LAST_MESSAGE_NUMBER NUMBER(19,0) NOT NULL,
    LAST_ACTIVITY_TIME NUMBER(19,0) NOT NULL,
    LAST_ACK_REQUEST_TIME NUMBER(19,0) NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW RM_SEQUENCES
 AS SELECT ENDPOINT_UID, ID, TYPE, EXP_TIME, BOUND_ID, STR_ID, STATUS, ACK_REQUESTED_FLAG, LAST_MESSAGE_NUMBER, LAST_ACTIVITY_TIME, LAST_ACK_REQUEST_TIME FROM E$RM_SEQUENCES;

ALTER TABLE E$RM_SEQUENCES
    ADD CONSTRAINT RM_SEQUENCES_PK PRIMARY KEY (ENDPOINT_UID, ID);

CREATE INDEX IDX_RM_SEQUENCES_BOUND_ID ON E$RM_SEQUENCES
    (BOUND_ID );

-- ----------------------------------------------------------------------- 
-- E$RM_UNACKED_MESSAGES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RM_UNACKED_MESSAGES
(
    ENDPOINT_UID VARCHAR2(512) NOT NULL,
    SEQ_ID VARCHAR2(256) NOT NULL,
    MSG_NUMBER NUMBER(19,0) NOT NULL,
    IS_RECEIVED CHAR(1) NOT NULL,
    CORRELATION_ID VARCHAR2(256),
    NEXT_RESEND_COUNT NUMBER(10,0),
    WSA_ACTION VARCHAR2(256),
    MSG_DATA BLOB
);

CREATE OR REPLACE EDITIONING VIEW RM_UNACKED_MESSAGES
 AS SELECT ENDPOINT_UID, SEQ_ID, MSG_NUMBER, IS_RECEIVED, CORRELATION_ID, NEXT_RESEND_COUNT, WSA_ACTION, MSG_DATA FROM E$RM_UNACKED_MESSAGES;

ALTER TABLE E$RM_UNACKED_MESSAGES
    ADD CONSTRAINT RM_UNACKED_MESSAGES_PK PRIMARY KEY (ENDPOINT_UID, SEQ_ID, MSG_NUMBER);

CREATE INDEX IDX_RM_UNACKED_MSGS_COR_ID ON E$RM_UNACKED_MESSAGES
    (CORRELATION_ID );

-- ----------------------------------------------------------------------- 
-- E$RM_LOCALIDS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$RM_LOCALIDS
(
    LOCAL_ID VARCHAR2(512) NOT NULL,
    SEQ_ID VARCHAR2(256) NOT NULL,
    MSG_NUMBER NUMBER(19,0) NOT NULL,
    CREATE_TIME NUMBER(19,0),
    SEQ_TERMINATE_TIME NUMBER(19,0)
);

CREATE OR REPLACE EDITIONING VIEW RM_LOCALIDS
 AS SELECT LOCAL_ID, SEQ_ID, MSG_NUMBER, CREATE_TIME, SEQ_TERMINATE_TIME FROM E$RM_LOCALIDS;

ALTER TABLE E$RM_LOCALIDS
    ADD CONSTRAINT RM_LOCALIDS_PK PRIMARY KEY (LOCAL_ID);

-- ----------------------------------------------------------------------- 
-- E$BRDECISIONFAULT 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BRDECISIONFAULT
(
    INSTANCE_ID VARCHAR2(100),
    SEQ_ID NUMBER NOT NULL,
    CREATION_TIME TIMESTAMP NOT NULL,
    UOW_STEP INTEGER,
    FAULT_TYPE INTEGER,
    QNAME VARCHAR2(200),
    RECOVERY_LEVEL INTEGER,
    MESSAGE CLOB,
    TENANT_ID NUMBER(18,0) DEFAULT -1
)
LOB(MESSAGE)
STORE AS
(
  CHUNK 8K
  CACHE
  PCTVERSION 10
) 
STORAGE 
(
  FREELISTS 20
);

CREATE OR REPLACE EDITIONING VIEW BRDECISIONFAULT
 AS SELECT INSTANCE_ID, SEQ_ID, CREATION_TIME, UOW_STEP, FAULT_TYPE, QNAME, RECOVERY_LEVEL, MESSAGE, TENANT_ID FROM E$BRDECISIONFAULT;

CREATE UNIQUE INDEX BRDECISIONFAULT_UK ON E$BRDECISIONFAULT
    (INSTANCE_ID , SEQ_ID );

CREATE INDEX BRDECISIONFAULT_INDX1 ON E$BRDECISIONFAULT
    (CREATION_TIME , FAULT_TYPE );

-- ----------------------------------------------------------------------- 
-- E$BRDECISIONINSTANCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BRDECISIONINSTANCE
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_ID INTEGER,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_CREATION_DATE TIMESTAMP,
    ECID VARCHAR2(100),
    COMPOSITE_INSTANCE_ID VARCHAR2(100),
    PARENT_ID VARCHAR2(1000),
    APPLICATION_NAME VARCHAR2(200),
    COMPOSITE_NAME VARCHAR2(500),
    REVISION VARCHAR2(200),
    LABEL VARCHAR2(200),
    COMPONENT_DN VARCHAR2(1000),
    COMPONENT_NAME VARCHAR2(200),
    STATE INTEGER,
    COMPONENT_VERSION VARCHAR2(200),
    COMPONENT_STATE VARCHAR2(200),
    CREATED_BY VARCHAR2(100),
    CREATION_TIME TIMESTAMP NOT NULL,
    UPDATED_BY VARCHAR2(100),
    UPDATED_TIME TIMESTAMP,
    PROCESSING_TIME NUMBER,
    OUTCOME VARCHAR2(100),
    RPI_CATALOG VARCHAR2(200),
    RPI_CATALOG_VERSION VARCHAR2(200),
    RPI_RULESET_CSV VARCHAR2(2000),
    RPI_RULESET_VERSION_CSV VARCHAR2(2000),
    RPI_FLEX1 VARCHAR2(2000),
    RPI_FLEX2 VARCHAR2(2000),
    RPI_FLEX3 VARCHAR2(2000),
    RPI_FLEX4 VARCHAR2(2000),
    PARENT_REF_ID VARCHAR2(1000),
    DECISION_TRACE CLOB,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    CPST_INST_CREATED_TIME TIMESTAMP DEFAULT SYSTIMESTAMP - 30
);

CREATE OR REPLACE EDITIONING VIEW BRDECISIONINSTANCE
 AS SELECT ID, COMPONENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_CREATION_DATE, ECID, COMPOSITE_INSTANCE_ID, PARENT_ID, APPLICATION_NAME, COMPOSITE_NAME, REVISION, LABEL, COMPONENT_DN, COMPONENT_NAME, STATE, COMPONENT_VERSION, COMPONENT_STATE, CREATED_BY, CREATION_TIME, UPDATED_BY, UPDATED_TIME, PROCESSING_TIME, OUTCOME, RPI_CATALOG, RPI_CATALOG_VERSION, RPI_RULESET_CSV, RPI_RULESET_VERSION_CSV, RPI_FLEX1, RPI_FLEX2, RPI_FLEX3, RPI_FLEX4, PARENT_REF_ID, DECISION_TRACE, TENANT_ID, CPST_INST_CREATED_TIME FROM E$BRDECISIONINSTANCE;

ALTER TABLE E$BRDECISIONINSTANCE
    ADD CONSTRAINT BRDECISIONINSTANCE_PK PRIMARY KEY (ID);

CREATE INDEX BRDECISIONINSTANCE_INDX1 ON E$BRDECISIONINSTANCE
    (COMPOSITE_NAME , REVISION , COMPONENT_NAME , APPLICATION_NAME , LABEL );

CREATE INDEX BRDECISIONINSTANCE_INDX2 ON E$BRDECISIONINSTANCE
    (COMPONENT_DN );

CREATE INDEX BRDECISIONINSTANCE_INDX3 ON E$BRDECISIONINSTANCE
    (CREATION_TIME , STATE );

CREATE INDEX BRDECISIONINSTANCE_INDX4 ON E$BRDECISIONINSTANCE
    (ECID );

CREATE INDEX BRDECISIONINSTANCE_INDX5 ON E$BRDECISIONINSTANCE
    (ECID , CREATION_TIME DESC);

-- ----------------------------------------------------------------------- 
-- E$BRDECISIONUNITOFWORK 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BRDECISIONUNITOFWORK
(
    INSTANCE_ID VARCHAR2(100),
    UOW_STEP INTEGER NOT NULL,
    CREATION_TIME TIMESTAMP NOT NULL,
    UOW_STATE NUMBER(1),
    UOW_CLASSIFIER NUMBER(2,0),
    UOW_DATA CLOB,
    PROCESSING_TIME NUMBER,
    UOW_RETURN_CODE NUMBER(1),
    MESSAGE VARCHAR2(2000),
    TENANT_ID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW BRDECISIONUNITOFWORK
 AS SELECT INSTANCE_ID, UOW_STEP, CREATION_TIME, UOW_STATE, UOW_CLASSIFIER, UOW_DATA, PROCESSING_TIME, UOW_RETURN_CODE, MESSAGE, TENANT_ID FROM E$BRDECISIONUNITOFWORK;

CREATE INDEX BRDECISIONUNITOFWORK_INDX1 ON E$BRDECISIONUNITOFWORK
    (INSTANCE_ID );

-- ----------------------------------------------------------------------- 
-- E$BRSEQUENCE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$BRSEQUENCE
(
    SEQ_NAME VARCHAR2(100),
    SEQ_COUNT NUMBER,
    TENANT_ID NUMBER(18,0) DEFAULT -1
);

CREATE OR REPLACE EDITIONING VIEW BRSEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT, TENANT_ID FROM E$BRSEQUENCE;

-- ----------------------------------------------------------------------- 
-- E$ACTIVITY_SENSOR_VALUES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$ACTIVITY_SENSOR_VALUES
(
    ID NUMBER NOT NULL,
    PROCESS_INSTANCE_ID NUMBER NOT NULL,
    SENSOR_NAME NVARCHAR2(100),
    SENSOR_TARGET NVARCHAR2(256),
    ACTION_NAME NVARCHAR2(100),
    ACTION_FILTER NVARCHAR2(256),
    CREATION_DATE TIMESTAMP NOT NULL,
    MODIFY_DATE TIMESTAMP,
    TS_HOUR NUMBER,
    CRITERIA_SATISFIED VARCHAR2(1),
    ACTIVITY_NAME NVARCHAR2(100),
    ACTIVITY_TYPE VARCHAR2(30),
    ACTIVITY_STATE VARCHAR2(30),
    EVAL_POINT VARCHAR2(30),
    ERROR_MESSAGE NCLOB,
    RETRY_COUNT NUMBER,
    EVAL_TIME NUMBER
);

CREATE OR REPLACE EDITIONING VIEW ACTIVITY_SENSOR_VALUES
 AS SELECT ID, PROCESS_INSTANCE_ID, SENSOR_NAME, SENSOR_TARGET, ACTION_NAME, ACTION_FILTER, CREATION_DATE, MODIFY_DATE, TS_HOUR, CRITERIA_SATISFIED, ACTIVITY_NAME, ACTIVITY_TYPE, ACTIVITY_STATE, EVAL_POINT, ERROR_MESSAGE, RETRY_COUNT, EVAL_TIME FROM E$ACTIVITY_SENSOR_VALUES;

ALTER TABLE E$ACTIVITY_SENSOR_VALUES
    ADD CONSTRAINT ACTIVITY_SENSOR_PK PRIMARY KEY (ID, PROCESS_INSTANCE_ID);

CREATE INDEX ACTIVITY_SENSOR_VALUES_INDX ON E$ACTIVITY_SENSOR_VALUES
    (PROCESS_INSTANCE_ID , SENSOR_NAME , ACTION_NAME );

-- ----------------------------------------------------------------------- 
-- E$COMPOSITE_SENSOR_VALUE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$COMPOSITE_SENSOR_VALUE
(
    COMPOSITE_INSTANCE_ID INTEGER NOT NULL,
    COMPONENT_INSTANCE_ID VARCHAR2(100),
    COMPONENT_NAME NVARCHAR2(256) NOT NULL,
    ACTION_PERFORMED NVARCHAR2(100) NOT NULL,
    SENSOR_NAME NVARCHAR2(100) NOT NULL,
    SENSOR_TYPE VARCHAR2(2) NOT NULL,
    CRITERIA_SATISFIED VARCHAR2(1),
    VALUE_TYPE INTEGER NOT NULL,
    CPST_PARTITION_DATE TIMESTAMP,
    STRING_VALUE NVARCHAR2(2000),
    NUMBER_VALUE NUMBER,
    DATE_VALUE TIMESTAMP,
    CLOB_VALUE CLOB,
    BLOB_VALUE BLOB
);

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_SENSOR_VALUE
 AS SELECT COMPOSITE_INSTANCE_ID, COMPONENT_INSTANCE_ID, COMPONENT_NAME, ACTION_PERFORMED, SENSOR_NAME, SENSOR_TYPE, CRITERIA_SATISFIED, VALUE_TYPE, CPST_PARTITION_DATE, STRING_VALUE, NUMBER_VALUE, DATE_VALUE, CLOB_VALUE, BLOB_VALUE FROM E$COMPOSITE_SENSOR_VALUE;

CREATE INDEX COMPOSITE_SENSOR_VALUE_IDX ON E$COMPOSITE_SENSOR_VALUE
    (COMPOSITE_INSTANCE_ID , SENSOR_NAME );

-- ----------------------------------------------------------------------- 
-- E$FAULT_SENSOR_VALUES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$FAULT_SENSOR_VALUES
(
    ID NUMBER NOT NULL,
    PROCESS_INSTANCE_ID NUMBER NOT NULL,
    SENSOR_NAME NVARCHAR2(100),
    SENSOR_TARGET NVARCHAR2(256),
    ACTION_NAME NVARCHAR2(100),
    ACTION_FILTER NVARCHAR2(256),
    CREATION_DATE TIMESTAMP NOT NULL,
    MODIFY_DATE TIMESTAMP,
    TS_HOUR NUMBER,
    CRITERIA_SATISFIED VARCHAR2(1),
    ACTIVITY_NAME NVARCHAR2(100),
    ACTIVITY_TYPE VARCHAR2(30),
    MESSAGE CLOB
);

CREATE OR REPLACE EDITIONING VIEW FAULT_SENSOR_VALUES
 AS SELECT ID, PROCESS_INSTANCE_ID, SENSOR_NAME, SENSOR_TARGET, ACTION_NAME, ACTION_FILTER, CREATION_DATE, MODIFY_DATE, TS_HOUR, CRITERIA_SATISFIED, ACTIVITY_NAME, ACTIVITY_TYPE, MESSAGE FROM E$FAULT_SENSOR_VALUES;

ALTER TABLE E$FAULT_SENSOR_VALUES
    ADD CONSTRAINT FAULT_SENSOR_VALUES_PK PRIMARY KEY (ID, PROCESS_INSTANCE_ID);

CREATE INDEX FAULT_SENSOR_VALUES_INDX ON E$FAULT_SENSOR_VALUES
    (PROCESS_INSTANCE_ID , SENSOR_NAME , ACTION_NAME );

-- ----------------------------------------------------------------------- 
-- E$VARIABLE_SENSOR_VALUES 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$VARIABLE_SENSOR_VALUES
(
    ID NUMBER NOT NULL,
    PROCESS_INSTANCE_ID NUMBER NOT NULL,
    SENSOR_NAME NVARCHAR2(100),
    SENSOR_TARGET NVARCHAR2(256),
    ACTION_NAME NVARCHAR2(100),
    ACTION_FILTER NVARCHAR2(256),
    ACTIVITY_SENSOR_ID NUMBER,
    CREATION_DATE TIMESTAMP NOT NULL,
    MODIFY_DATE TIMESTAMP,
    TS_HOUR NUMBER,
    VARIABLE_NAME NVARCHAR2(256),
    EVAL_POINT VARCHAR2(30),
    CRITERIA_SATISFIED VARCHAR2(1),
    TARGET NVARCHAR2(256),
    SCHEMA_NAMESPACE NVARCHAR2(256),
    SCHEMA_DATATYPE NVARCHAR2(256),
    UPDATER_NAME NVARCHAR2(100),
    UPDATER_TYPE NVARCHAR2(100),
    VALUE_TYPE INTEGER,
    VARCHAR2_VALUE NVARCHAR2(2000),
    NUMBER_VALUE NUMBER,
    DATE_VALUE TIMESTAMP,
    DATE_VALUE_TZ VARCHAR2(10),
    BLOB_VALUE BLOB,
    CLOB_VALUE CLOB
);

CREATE OR REPLACE EDITIONING VIEW VARIABLE_SENSOR_VALUES
 AS SELECT ID, PROCESS_INSTANCE_ID, SENSOR_NAME, SENSOR_TARGET, ACTION_NAME, ACTION_FILTER, ACTIVITY_SENSOR_ID, CREATION_DATE, MODIFY_DATE, TS_HOUR, VARIABLE_NAME, EVAL_POINT, CRITERIA_SATISFIED, TARGET, SCHEMA_NAMESPACE, SCHEMA_DATATYPE, UPDATER_NAME, UPDATER_TYPE, VALUE_TYPE, VARCHAR2_VALUE, NUMBER_VALUE, DATE_VALUE, DATE_VALUE_TZ, BLOB_VALUE, CLOB_VALUE FROM E$VARIABLE_SENSOR_VALUES;

ALTER TABLE E$VARIABLE_SENSOR_VALUES
    ADD CONSTRAINT VARIABLE_SENSOR_VALUES_PK PRIMARY KEY (ID, PROCESS_INSTANCE_ID);

CREATE INDEX VARIABLE_SENSOR_VALUES_INDX ON E$VARIABLE_SENSOR_VALUES
    (PROCESS_INSTANCE_ID , SENSOR_NAME , ACTION_NAME );

-- ----------------------------------------------------------------------- 
-- E$SCA_SENSOR_VALUE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$SCA_SENSOR_VALUE
(
    FLOW_ID INTEGER NOT NULL,
    CIKEY NUMBER,
    SCA_ENTITY_ID INTEGER,
    COMPOSITE_ID NUMBER,
    COMPOSITE_SCA_ENTITY_ID INTEGER,
    COMPONENT_NAME NVARCHAR2(256) NOT NULL,
    ACTION_PERFORMED NVARCHAR2(100) NOT NULL,
    SENSOR_NAME NVARCHAR2(100) NOT NULL,
    SENSOR_TYPE VARCHAR2(2) NOT NULL,
    CRITERIA_SATISFIED VARCHAR2(1),
    VALUE_TYPE INTEGER NOT NULL,
    STRING_VALUE NVARCHAR2(2000),
    NUMBER_VALUE NUMBER,
    DATE_VALUE TIMESTAMP,
    CLOB_VALUE CLOB,
    BLOB_VALUE BLOB,
    PARTITION_DATE TIMESTAMP DEFAULT systimestamp,
    SCA_PARTITION_ID INTEGER
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW SCA_SENSOR_VALUE
 AS SELECT FLOW_ID, CIKEY, SCA_ENTITY_ID, COMPOSITE_ID, COMPOSITE_SCA_ENTITY_ID, COMPONENT_NAME, ACTION_PERFORMED, SENSOR_NAME, SENSOR_TYPE, CRITERIA_SATISFIED, VALUE_TYPE, STRING_VALUE, NUMBER_VALUE, DATE_VALUE, CLOB_VALUE, BLOB_VALUE, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_SENSOR_VALUE;

CREATE INDEX SCA_SENSOR_VALUE_IDX ON E$SCA_SENSOR_VALUE
    (FLOW_ID , SENSOR_NAME );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_GROUP_STATUS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_GROUP_STATUS
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000) NOT NULL,
    LEVEL_DETAIL2 VARCHAR2(1000),
    GROUP_ID VARCHAR2(1000) NOT NULL,
    SUPPORT_BATCHING NUMBER DEFAULT 0,
    LOCK_TIME_1 NUMBER,
    START_SEQUENCE_ID VARCHAR2(1000),
    LAST_SEQUENCE_ID VARCHAR2(1000),
    NEXT_SEQUENCE_ID VARCHAR2(1000),
    CREATION_DATE TIMESTAMP,
    LAST_RECEIVED_TIME TIMESTAMP,
    STATUS NUMBER NOT NULL,
    SEQUENCING_LEVEL VARCHAR2(100) NOT NULL,
    CONTAINER_ID VARCHAR2(100),
    LOCK_TIME TIMESTAMP,
    RESEQUENCER_TYPE VARCHAR2(100),
    TIMEOUT_DURATION NUMBER,
    COMPONENT_STATUS NUMBER DEFAULT 0 NOT NULL,
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_GROUP_STATUS
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, SUPPORT_BATCHING, LOCK_TIME_1, START_SEQUENCE_ID, LAST_SEQUENCE_ID, NEXT_SEQUENCE_ID, CREATION_DATE, LAST_RECEIVED_TIME, STATUS, SEQUENCING_LEVEL, CONTAINER_ID, LOCK_TIME, RESEQUENCER_TYPE, TIMEOUT_DURATION, COMPONENT_STATUS, TENANT_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_GROUP_STATUS;

ALTER TABLE E$MEDIATOR_GROUP_STATUS
    ADD CONSTRAINT MEDIATOR_GROUP_STATUS_PK PRIMARY KEY (ID);

CREATE INDEX MEDIATOR_GROUP_STATUS_INDEX1 ON E$MEDIATOR_GROUP_STATUS
    (RESEQUENCER_TYPE , STATUS , COMPONENT_STATUS , LOCK_TIME , NEXT_SEQUENCE_ID );

CREATE INDEX MEDIATOR_GROUP_STATUS_INDEX2 ON E$MEDIATOR_GROUP_STATUS
    (COMPONENT_DN , OPERATION , GROUP_ID );

CREATE INDEX MEDIATOR_GROUP_STATUS_INDEX3 ON E$MEDIATOR_GROUP_STATUS
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 , GROUP_ID );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_RESEQUENCER_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_RESEQUENCER_MESSAGE
(
    ID VARCHAR2(100) NOT NULL,
    OWNER_ID VARCHAR2(100),
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000) NOT NULL,
    LEVEL_DETAIL2 VARCHAR2(1000),
    GROUP_ID VARCHAR2(1000) NOT NULL,
    PROPERTY1 VARCHAR2(1000),
    PROPERTY2 VARCHAR2(1000),
    PROPERTY3 BLOB,
    SEQUENCE_ID VARCHAR2(1000) NOT NULL,
    CONTAINER_ID VARCHAR2(100),
    CREATION_DATE TIMESTAMP,
    MI_PARTITION_DATE TIMESTAMP,
    PROCESS_DATE TIMESTAMP,
    IS_EVENT NUMBER,
    QNAME_LOCAL_PART VARCHAR2(1000),
    QNAME_NAMESPACE VARCHAR2(1000),
    LOCK_TIME TIMESTAMP,
    NEXT_SEQUENCE_ID VARCHAR2(1000),
    PRIORITY NUMBER,
    SOURCE_URI VARCHAR2(1000),
    STANDARD_SEQUENCE_ID VARCHAR2(1000),
    STATUS NUMBER,
    INSTANCE_CREATED VARCHAR2(20),
    TENANT_ID NUMBER(18,0) DEFAULT -1,
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
)
 PARTITION BY RANGE (PARTITION_DATE)
 INTERVAL(NUMTOYMINTERVAL(1, 'MONTH'))
 (PARTITION p0 VALUES LESS THAN (TO_DATE('1-2-2007', 'DD-MM-YYYY')))
;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_RESEQUENCER_MESSAGE
 AS SELECT ID, OWNER_ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, PROPERTY1, PROPERTY2, PROPERTY3, SEQUENCE_ID, CONTAINER_ID, CREATION_DATE, MI_PARTITION_DATE, PROCESS_DATE, IS_EVENT, QNAME_LOCAL_PART, QNAME_NAMESPACE, LOCK_TIME, NEXT_SEQUENCE_ID, PRIORITY, SOURCE_URI, STANDARD_SEQUENCE_ID, STATUS, INSTANCE_CREATED, TENANT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_RESEQUENCER_MESSAGE;

ALTER TABLE E$MEDIATOR_RESEQUENCER_MESSAGE
    ADD CONSTRAINT MEDIATOR_RESEQU_CER_MESSAGE_PK PRIMARY KEY (ID);

CREATE UNIQUE INDEX MEDIATOR_RESQ_MSG_UNIQUE1 ON E$MEDIATOR_RESEQUENCER_MESSAGE
    (OWNER_ID , STANDARD_SEQUENCE_ID );

CREATE INDEX MEDIATOR_RESQ_MSG_INDEX1 ON E$MEDIATOR_RESEQUENCER_MESSAGE
    (STATUS , SEQUENCE_ID , LOCK_TIME , NEXT_SEQUENCE_ID );

CREATE INDEX MEDIATOR_RESQ_MSG_INDEX2 ON E$MEDIATOR_RESEQUENCER_MESSAGE
    (COMPONENT_DN , OPERATION , GROUP_ID );

CREATE INDEX MEDIATOR_RESQ_MSG_INDEX3 ON E$MEDIATOR_RESEQUENCER_MESSAGE
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 , GROUP_ID );

-- ----------------------------------------------------------------------- 
-- E$OSB_GROUP_STATUS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$OSB_GROUP_STATUS
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000),
    LEVEL_DETAIL2 VARCHAR2(1000),
    GROUP_ID VARCHAR2(1000) NOT NULL,
    SUPPORT_BATCHING NUMBER DEFAULT 0,
    LOCK_TIME_1 NUMBER,
    START_SEQUENCE_ID VARCHAR2(1000),
    LAST_SEQUENCE_ID VARCHAR2(1000),
    NEXT_SEQUENCE_ID VARCHAR2(1000),
    LAST_RECEIVED_TIME TIMESTAMP,
    STATUS NUMBER NOT NULL,
    SEQUENCING_LEVEL VARCHAR2(100) NOT NULL,
    CONTAINER_ID VARCHAR2(100),
    LOCK_TIME TIMESTAMP,
    RESEQUENCER_TYPE VARCHAR2(100),
    TIMEOUT_DURATION NUMBER,
    COMPONENT_STATUS NUMBER DEFAULT 0 NOT NULL,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW OSB_GROUP_STATUS
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, SUPPORT_BATCHING, LOCK_TIME_1, START_SEQUENCE_ID, LAST_SEQUENCE_ID, NEXT_SEQUENCE_ID, LAST_RECEIVED_TIME, STATUS, SEQUENCING_LEVEL, CONTAINER_ID, LOCK_TIME, RESEQUENCER_TYPE, TIMEOUT_DURATION, COMPONENT_STATUS, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$OSB_GROUP_STATUS;

ALTER TABLE E$OSB_GROUP_STATUS
    ADD CONSTRAINT OSB_GROUP_STATUS_PK PRIMARY KEY (ID);

CREATE INDEX OSB_GROUP_STATUS_INDEX1 ON E$OSB_GROUP_STATUS
    (RESEQUENCER_TYPE , STATUS , COMPONENT_STATUS , LOCK_TIME , NEXT_SEQUENCE_ID );

CREATE INDEX OSB_GROUP_STATUS_INDEX2 ON E$OSB_GROUP_STATUS
    (COMPONENT_DN , OPERATION , GROUP_ID );

CREATE INDEX OSB_GROUP_STATUS_INDEX3 ON E$OSB_GROUP_STATUS
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 , GROUP_ID );

-- ----------------------------------------------------------------------- 
-- E$OSB_RESEQUENCER_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$OSB_RESEQUENCER_MESSAGE
(
    ID VARCHAR2(100) NOT NULL,
    OWNER_ID VARCHAR2(100),
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000),
    LEVEL_DETAIL2 VARCHAR2(1000),
    GROUP_ID VARCHAR2(1000) NOT NULL,
    PROPERTY1 VARCHAR2(1000),
    PROPERTY2 VARCHAR2(1000),
    PROPERTY3 BLOB,
    SEQUENCE_ID VARCHAR2(1000) NOT NULL,
    CONTAINER_ID VARCHAR2(100),
    CREATION_DATE TIMESTAMP,
    PROCESS_DATE TIMESTAMP,
    IS_EVENT NUMBER,
    QNAME_LOCAL_PART VARCHAR2(1000),
    QNAME_NAMESPACE VARCHAR2(1000),
    LOCK_TIME TIMESTAMP,
    NEXT_SEQUENCE_ID VARCHAR2(1000),
    PRIORITY NUMBER,
    SOURCE_URI VARCHAR2(1000),
    STANDARD_SEQUENCE_ID VARCHAR2(1000),
    STATUS NUMBER,
    INSTANCE_CREATED VARCHAR2(20),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW OSB_RESEQUENCER_MESSAGE
 AS SELECT ID, OWNER_ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, PROPERTY1, PROPERTY2, PROPERTY3, SEQUENCE_ID, CONTAINER_ID, CREATION_DATE, PROCESS_DATE, IS_EVENT, QNAME_LOCAL_PART, QNAME_NAMESPACE, LOCK_TIME, NEXT_SEQUENCE_ID, PRIORITY, SOURCE_URI, STANDARD_SEQUENCE_ID, STATUS, INSTANCE_CREATED, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$OSB_RESEQUENCER_MESSAGE;

ALTER TABLE E$OSB_RESEQUENCER_MESSAGE
    ADD CONSTRAINT OSB_RESEQUENCER_MESSAGE_PK PRIMARY KEY (ID);

CREATE UNIQUE INDEX OSB_RESQ_MSG_UNIQUE1 ON E$OSB_RESEQUENCER_MESSAGE
    (OWNER_ID , STANDARD_SEQUENCE_ID );

CREATE INDEX OSB_RESQ_MSG_INDEX1 ON E$OSB_RESEQUENCER_MESSAGE
    (STATUS , SEQUENCE_ID , LOCK_TIME , NEXT_SEQUENCE_ID );

CREATE INDEX OSB_RESQ_MSG_INDEX2 ON E$OSB_RESEQUENCER_MESSAGE
    (COMPONENT_DN , OPERATION , GROUP_ID );

CREATE INDEX OSB_RESQ_MSG_INDEX3 ON E$OSB_RESEQUENCER_MESSAGE
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 , GROUP_ID );

-- ----------------------------------------------------------------------- 
-- E$B2B_GROUP_STATUS 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_GROUP_STATUS
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000),
    LEVEL_DETAIL2 VARCHAR2(1000),
    GROUP_ID VARCHAR2(1000) NOT NULL,
    SUPPORT_BATCHING NUMBER DEFAULT 0,
    LOCK_TIME_1 NUMBER,
    START_SEQUENCE_ID VARCHAR2(1000),
    LAST_SEQUENCE_ID VARCHAR2(1000),
    NEXT_SEQUENCE_ID VARCHAR2(1000),
    LAST_RECEIVED_TIME TIMESTAMP,
    STATUS NUMBER NOT NULL,
    SEQUENCING_LEVEL VARCHAR2(100) NOT NULL,
    CONTAINER_ID VARCHAR2(100),
    LOCK_TIME TIMESTAMP,
    RESEQUENCER_TYPE VARCHAR2(100),
    TIMEOUT_DURATION NUMBER,
    COMPONENT_STATUS NUMBER DEFAULT 0 NOT NULL,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW B2B_GROUP_STATUS
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, SUPPORT_BATCHING, LOCK_TIME_1, START_SEQUENCE_ID, LAST_SEQUENCE_ID, NEXT_SEQUENCE_ID, LAST_RECEIVED_TIME, STATUS, SEQUENCING_LEVEL, CONTAINER_ID, LOCK_TIME, RESEQUENCER_TYPE, TIMEOUT_DURATION, COMPONENT_STATUS, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$B2B_GROUP_STATUS;

ALTER TABLE E$B2B_GROUP_STATUS
    ADD CONSTRAINT B2B_GROUP_STATUS_PK PRIMARY KEY (ID);

CREATE INDEX B2B_GROUP_STATUS_INDEX1 ON E$B2B_GROUP_STATUS
    (RESEQUENCER_TYPE , STATUS , COMPONENT_STATUS , LOCK_TIME , NEXT_SEQUENCE_ID );

CREATE INDEX B2B_GROUP_STATUS_INDEX2 ON E$B2B_GROUP_STATUS
    (COMPONENT_DN , OPERATION , GROUP_ID );

CREATE INDEX B2B_GROUP_STATUS_INDEX3 ON E$B2B_GROUP_STATUS
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 , GROUP_ID );

-- ----------------------------------------------------------------------- 
-- E$B2B_RESEQUENCER_MESSAGE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_RESEQUENCER_MESSAGE
(
    ID VARCHAR2(100) NOT NULL,
    OWNER_ID VARCHAR2(100),
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000),
    LEVEL_DETAIL2 VARCHAR2(1000) DEFAULT '0' NOT NULL,
    GROUP_ID VARCHAR2(1000) NOT NULL,
    PROPERTY1 VARCHAR2(1000),
    PROPERTY2 VARCHAR2(1000),
    PROPERTY3 BLOB,
    SEQUENCE_ID VARCHAR2(1000) NOT NULL,
    CONTAINER_ID VARCHAR2(100),
    CREATION_DATE TIMESTAMP,
    PROCESS_DATE TIMESTAMP,
    IS_EVENT NUMBER,
    QNAME_LOCAL_PART VARCHAR2(1000),
    QNAME_NAMESPACE VARCHAR2(1000),
    LOCK_TIME TIMESTAMP,
    NEXT_SEQUENCE_ID VARCHAR2(1000),
    PRIORITY NUMBER,
    SOURCE_URI VARCHAR2(1000),
    STANDARD_SEQUENCE_ID VARCHAR2(1000),
    STATUS NUMBER,
    INSTANCE_CREATED VARCHAR2(20),
    FLOW_ID INTEGER,
    SCA_PARTITION_ID INTEGER,
    PARTITION_DATE TIMESTAMP,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW B2B_RESEQUENCER_MESSAGE
 AS SELECT ID, OWNER_ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, PROPERTY1, PROPERTY2, PROPERTY3, SEQUENCE_ID, CONTAINER_ID, CREATION_DATE, PROCESS_DATE, IS_EVENT, QNAME_LOCAL_PART, QNAME_NAMESPACE, LOCK_TIME, NEXT_SEQUENCE_ID, PRIORITY, SOURCE_URI, STANDARD_SEQUENCE_ID, STATUS, INSTANCE_CREATED, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$B2B_RESEQUENCER_MESSAGE;

ALTER TABLE E$B2B_RESEQUENCER_MESSAGE
    ADD CONSTRAINT B2B_RESEQUENCER_MESSAGE_PK PRIMARY KEY (ID);

CREATE UNIQUE INDEX B2B_RESQ_MSG_UNIQUE1 ON E$B2B_RESEQUENCER_MESSAGE
    (OWNER_ID , STANDARD_SEQUENCE_ID );

CREATE INDEX B2B_RESQ_MSG_INDEX1 ON E$B2B_RESEQUENCER_MESSAGE
    (STATUS , SEQUENCE_ID , LOCK_TIME , NEXT_SEQUENCE_ID );

CREATE INDEX B2B_RESQ_MSG_INDEX2 ON E$B2B_RESEQUENCER_MESSAGE
    (COMPONENT_DN , OPERATION , GROUP_ID );

CREATE INDEX B2B_RESQ_MSG_INDEX3 ON E$B2B_RESEQUENCER_MESSAGE
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 , GROUP_ID );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_SERVICE_DETAIL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_SERVICE_DETAIL
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000) NOT NULL,
    LEVEL_DETAIL2 VARCHAR2(1000),
    SEQUENCING_LEVEL VARCHAR2(100) NOT NULL,
    RESEQUENCER_TYPE VARCHAR2(100),
    CREATION_DATE TIMESTAMP,
    COMPONENT_STATUS NUMBER DEFAULT 0 NOT NULL,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_SERVICE_DETAIL
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, SEQUENCING_LEVEL, RESEQUENCER_TYPE, CREATION_DATE, COMPONENT_STATUS, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_SERVICE_DETAIL;

ALTER TABLE E$MEDIATOR_SERVICE_DETAIL
    ADD CONSTRAINT MEDIATOR_SERVICE_DETAIL_PK PRIMARY KEY (ID);

CREATE INDEX MEDIATOR_SERVICE_DETAIL_INDEX1 ON E$MEDIATOR_SERVICE_DETAIL
    (RESEQUENCER_TYPE , COMPONENT_STATUS );

CREATE INDEX MEDIATOR_SERVICE_DETAIL_INDEX2 ON E$MEDIATOR_SERVICE_DETAIL
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 );

-- ----------------------------------------------------------------------- 
-- E$OSB_SERVICE_DETAIL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$OSB_SERVICE_DETAIL
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000) NOT NULL,
    LEVEL_DETAIL2 VARCHAR2(1000),
    SEQUENCING_LEVEL VARCHAR2(100) NOT NULL,
    RESEQUENCER_TYPE VARCHAR2(100),
    CREATION_DATE TIMESTAMP,
    COMPONENT_STATUS NUMBER DEFAULT 0 NOT NULL,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW OSB_SERVICE_DETAIL
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, SEQUENCING_LEVEL, RESEQUENCER_TYPE, CREATION_DATE, COMPONENT_STATUS, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$OSB_SERVICE_DETAIL;

ALTER TABLE E$OSB_SERVICE_DETAIL
    ADD CONSTRAINT OSB_SERVICE_DETAIL_PK PRIMARY KEY (ID);

CREATE INDEX OSB_SERVICE_DETAIL_INDEX1 ON E$OSB_SERVICE_DETAIL
    (RESEQUENCER_TYPE , COMPONENT_STATUS );

CREATE INDEX OSB_SERVICE_DETAIL_INDEX2 ON E$OSB_SERVICE_DETAIL
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 );

-- ----------------------------------------------------------------------- 
-- E$B2B_SERVICE_DETAIL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_SERVICE_DETAIL
(
    ID VARCHAR2(100) NOT NULL,
    COMPONENT_DN VARCHAR2(1000) NOT NULL,
    OPERATION VARCHAR2(1000) NOT NULL,
    LEVEL_DETAIL2 VARCHAR2(1000),
    SEQUENCING_LEVEL VARCHAR2(100) NOT NULL,
    RESEQUENCER_TYPE VARCHAR2(100),
    CREATION_DATE TIMESTAMP,
    COMPONENT_STATUS NUMBER DEFAULT 0 NOT NULL,
    DUMMY1 VARCHAR2(200),
    DUMMY2 VARCHAR2(200),
    DUMMY3 VARCHAR2(200),
    DUMMY4 VARCHAR2(200),
    DUMMY5 VARCHAR2(200)
);

CREATE OR REPLACE EDITIONING VIEW B2B_SERVICE_DETAIL
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, SEQUENCING_LEVEL, RESEQUENCER_TYPE, CREATION_DATE, COMPONENT_STATUS, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$B2B_SERVICE_DETAIL;

ALTER TABLE E$B2B_SERVICE_DETAIL
    ADD CONSTRAINT B2B_SERVICE_DETAIL_PK PRIMARY KEY (ID);

CREATE INDEX B2B_SERVICE_DETAIL_INDEX1 ON E$B2B_SERVICE_DETAIL
    (RESEQUENCER_TYPE , COMPONENT_STATUS );

CREATE INDEX B2B_SERVICE_DETAIL_INDEX2 ON E$B2B_SERVICE_DETAIL
    (COMPONENT_DN , OPERATION , LEVEL_DETAIL2 );

-- ----------------------------------------------------------------------- 
-- E$MEDIATOR_RES_CONTAINERID_LEA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$MEDIATOR_RES_CONTAINERID_LEA
(
    CONTAINER_ID VARCHAR2(100) NOT NULL,
    RENEWAL_TIME TIMESTAMP WITH TIME ZONE
);

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_RES_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$MEDIATOR_RES_CONTAINERID_LEA;

ALTER TABLE E$MEDIATOR_RES_CONTAINERID_LEA
    ADD CONSTRAINT MEDIATOR_RES_CO_NERID_LEASE_PK PRIMARY KEY (CONTAINER_ID);

-- ----------------------------------------------------------------------- 
-- E$B2B_RES_CONTAINERID_LEASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$B2B_RES_CONTAINERID_LEASE
(
    CONTAINER_ID VARCHAR2(100) NOT NULL,
    RENEWAL_TIME TIMESTAMP WITH TIME ZONE
);

CREATE OR REPLACE EDITIONING VIEW B2B_RES_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$B2B_RES_CONTAINERID_LEASE;

ALTER TABLE E$B2B_RES_CONTAINERID_LEASE
    ADD CONSTRAINT B2B_RES_CONTAINERID_LEASE_PK PRIMARY KEY (CONTAINER_ID);

-- ----------------------------------------------------------------------- 
-- E$OSB_RES_CONTAINERID_LEASE 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$OSB_RES_CONTAINERID_LEASE
(
    CONTAINER_ID VARCHAR2(100) NOT NULL,
    RENEWAL_TIME TIMESTAMP WITH TIME ZONE
);

CREATE OR REPLACE EDITIONING VIEW OSB_RES_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$OSB_RES_CONTAINERID_LEASE;

ALTER TABLE E$OSB_RES_CONTAINERID_LEASE
    ADD CONSTRAINT OSB_RES_CONTAINERID_LEASE_PK PRIMARY KEY (CONTAINER_ID);

-- ----------------------------------------------------------------------- 
-- E$LABEL_VERSION_PCBPEL 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$LABEL_VERSION_PCBPEL
(
    LABEL VARCHAR2(100)
);

CREATE OR REPLACE EDITIONING VIEW LABEL_VERSION_PCBPEL
 AS SELECT LABEL FROM E$LABEL_VERSION_PCBPEL;

-- ----------------------------------------------------------------------- 
-- E$XREF_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$XREF_DATA
(
    XREF_TABLE_NAME VARCHAR2(2000) NOT NULL,
    XREF_COLUMN_NAME VARCHAR2(2000) NOT NULL,
    ROW_NUMBER VARCHAR2(48) NOT NULL,
    VALUE VARCHAR2(2000) NOT NULL,
    IS_DELETED VARCHAR2(1) NOT NULL,
    LAST_MODIFIED TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW XREF_DATA
 AS SELECT XREF_TABLE_NAME, XREF_COLUMN_NAME, ROW_NUMBER, VALUE, IS_DELETED, LAST_MODIFIED FROM E$XREF_DATA;

ALTER TABLE E$XREF_DATA
    ADD CONSTRAINT XREF_DATA_PK PRIMARY KEY (XREF_TABLE_NAME, XREF_COLUMN_NAME, VALUE);

CREATE INDEX XREF_ROW_NUMBER ON E$XREF_DATA
    (ROW_NUMBER );

CREATE INDEX XREF_VALUE ON E$XREF_DATA
    (VALUE );

-- ----------------------------------------------------------------------- 
-- E$XREF_DELETED_DATA 
-- ----------------------------------------------------------------------- 

CREATE TABLE E$XREF_DELETED_DATA
(
    XREF_TABLE_NAME VARCHAR2(2000) NOT NULL,
    XREF_COLUMN_NAME VARCHAR2(2000) NOT NULL,
    ROW_ID VARCHAR2(48) NOT NULL,
    VALUE VARCHAR2(2000) NOT NULL,
    LAST_MODIFIED TIMESTAMP NOT NULL
);

CREATE OR REPLACE EDITIONING VIEW XREF_DELETED_DATA
 AS SELECT XREF_TABLE_NAME, XREF_COLUMN_NAME, ROW_ID, VALUE, LAST_MODIFIED FROM E$XREF_DELETED_DATA;

ALTER TABLE E$AIA_ERROR_NOTIFICATIONS
    ADD CONSTRAINT AIA_ERROR_NOTIFICATIONS_FK FOREIGN KEY (SYSTEM_ID) REFERENCES E$AIA_SYSTEMS (SYSTEM_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_DEFINITION_AUDITS
    ADD CONSTRAINT DEFINITION_AUDITS_D_FK FOREIGN KEY (DEFINITION_ID) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_DEFINITION_NSXPATHS
    ADD CONSTRAINT DEFINITION_NSXPATHS_D_FK FOREIGN KEY (DEFINITION_ID) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_DEFINITION_XPATHS
    ADD CONSTRAINT DEFINITION_XPATHS_D_FK FOREIGN KEY (DEFINITION_ID) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_DEFINITION_XREFS
    ADD CONSTRAINT DEFINITION_XREFS_DS_FK FOREIGN KEY (DEFINITION_ID_SIMULATOR) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID);

ALTER TABLE E$CAVS_DEFINITION_XREFS
    ADD CONSTRAINT DEFINITION_XREFS_DT_FK FOREIGN KEY (DEFINITION_ID_TEST) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_GRPDEFINITION_DEFINITIO
    ADD CONSTRAINT GROUP_DEFINITION_DEFS_D_FK FOREIGN KEY (DEFINITION_ID) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_GRPDEFINITION_DEFINITIO
    ADD CONSTRAINT GROUP_DEFINITION_DEFS_GD_FK FOREIGN KEY (GROUP_DEFINITION_ID) REFERENCES E$CAVS_GRPDEFINITIONS (GROUP_DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_GRPINSTANCE_INSTANCES
    ADD CONSTRAINT GROUP_INSTANCE_INSTANCES_IG_FK FOREIGN KEY (GROUP_DEFINITION_ID, GROUP_INSTANCE_ID) REFERENCES E$CAVS_GRPINSTANCES (GROUP_DEFINITION_ID, GROUP_INSTANCE_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_GRPINSTANCE_INSTANCES
    ADD CONSTRAINT GROUP_INSTANCE_INSTANCES_I_FK FOREIGN KEY (INSTANCE_ID) REFERENCES E$CAVS_INSTANCES (INSTANCE_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_GRPINSTANCES
    ADD CONSTRAINT GROUP_INSTANCES_GD_FK FOREIGN KEY (GROUP_DEFINITION_ID) REFERENCES E$CAVS_GRPDEFINITIONS (GROUP_DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_INSTANCE_NSXPATHS
    ADD CONSTRAINT INSTANCE_NSXPATHS_I_FK FOREIGN KEY (INSTANCE_ID) REFERENCES E$CAVS_INSTANCES (INSTANCE_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_INSTANCE_XPATHS
    ADD CONSTRAINT INSTANCE_XPATHS_I_FK FOREIGN KEY (INSTANCE_ID) REFERENCES E$CAVS_INSTANCES (INSTANCE_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_INSTANCE_XREFS
    ADD CONSTRAINT INSTANCE_XREF_IS_FK FOREIGN KEY (INSTANCE_ID_SIMULATOR) REFERENCES E$CAVS_INSTANCES (INSTANCE_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_INSTANCE_XREFS
    ADD CONSTRAINT INSTANCE_XREF_IT_FK FOREIGN KEY (INSTANCE_ID_TEST) REFERENCES E$CAVS_INSTANCES (INSTANCE_ID) ON DELETE CASCADE;

ALTER TABLE E$CAVS_INSTANCES
    ADD CONSTRAINT INSTANCES_T_FK FOREIGN KEY (DEFINITION_ID) REFERENCES E$CAVS_DEFINITIONS (DEFINITION_ID) ON DELETE SET NULL;

ALTER TABLE E$CAVS_ROUTING_SETUP_DETAILS
    ADD CONSTRAINT ROUTING_SETUP_ID_FK FOREIGN KEY (SETUP_ID) REFERENCES E$CAVS_ROUTING_SETUP (SETUP_ID) ON DELETE CASCADE;

ALTER TABLE E$AIA_ERROR_FLEX_FIELD
    ADD CONSTRAINT ERR_FF_FK_ERR_MON FOREIGN KEY (PARENT_OID) REFERENCES E$AIA_ERROR_MONITOR (OID);

ALTER TABLE E$AM_SUBSCRIPTION
    ADD CONSTRAINT FK_AM_SUBS_APP_ID FOREIGN KEY (APP_ID) REFERENCES E$AM_APPLICATION (APP_ID);

ALTER TABLE E$B2B_LIFECYCLE
    ADD CONSTRAINT B2B_LC_CN_FK FOREIGN KEY (CONTROL_NUMBER_SET) REFERENCES E$B2B_CONTROL_NUMBER_SET (ID);

ALTER TABLE E$BEAM_DATAOBJECT
    ADD CONSTRAINT BEAM_DATAOBJECT_FLEXTABLE_FK FOREIGN KEY (DATAOBJECT_FLEXTABLE) REFERENCES E$BEAM_FLEXTABLE (BEAM_ID);

ALTER TABLE E$BEAM_DATAOBJECT
    ADD CONSTRAINT BEAM_DATAOBJECT_PARENT_FK FOREIGN KEY (DATAOBJECT_PARENT) REFERENCES E$BEAM_DATAOBJECT (BEAM_ID) ON DELETE CASCADE;

ALTER TABLE E$BEAM_COLUMN
    ADD CONSTRAINT BEAM_COLUMN_DATAOBJECT_FK FOREIGN KEY (COLUMN_DATAOBJECT) REFERENCES E$BEAM_DATAOBJECT (BEAM_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_OBJECT
    ADD CONSTRAINT CM_CASE_OBJECT_TO_CASE_ID_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_DOCUMENT
    ADD CONSTRAINT CASE_DOCUMENT_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_EVENT
    ADD CONSTRAINT CM_CASE_EVENT_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_PROPERTY_BAG
    ADD CONSTRAINT CM_CASE_EVENT_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_EVENT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_MILESTONE_DEFINITION
    ADD CONSTRAINT CM_CASE_MILESTO_DEFINITION_FK FOREIGN KEY (CASE_DEFINITION_ID) REFERENCES E$CM_CASE_DEFINITION (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_ACTIVITY_CASE_DEFINITION
    ADD CONSTRAINT CM_ACTIVITY_CAS_DEFINITION_FK1 FOREIGN KEY (ACTIVITY_DEFINITION_ID) REFERENCES E$CM_ACTIVITY_DEFINITION (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_ACTIVITY_CASE_DEFINITION
    ADD CONSTRAINT CM_ACTIVITY_CAS_DEFINITION_FK2 FOREIGN KEY (CASE_DEFINITION_ID) REFERENCES E$CM_CASE_DEFINITION (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_ACTIVITY_CATEGORY_DEFN
    ADD CONSTRAINT CM_ACTIVITY_CATEGORY_DEFN_FK FOREIGN KEY (ACTIVITY_DEFINITION_ID) REFERENCES E$CM_ACTIVITY_DEFINITION (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_TRANSLATION
    ADD CONSTRAINT CASE_ID_TRANSLATION_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_ACTIVITY_INSTANCE
    ADD CONSTRAINT CM_ACTIVITY_INSTANCE_FK1 FOREIGN KEY (ACTIVITY_DEFINITION_ID) REFERENCES E$CM_ACTIVITY_DEFINITION (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_FABRIC_HEADER_PROPERTY
    ADD CONSTRAINT CASE_ID_FABRIC_ER_PROPERTY_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_LINKED_CASE
    ADD CONSTRAINT LINKED_CASE_CASE_ID_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_DATA
    ADD CONSTRAINT CASE_DATA_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_FLEX_FIELD
    ADD CONSTRAINT CASE_ID_FLEX_FIELDS_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_HEADER
    ADD CONSTRAINT CASE_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_MILESTONE
    ADD CONSTRAINT CASE_MILESTONE_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_PHASE
    ADD CONSTRAINT CASE_PHASE_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_STAKE_HOLDER
    ADD CONSTRAINT CASE_STAKE_HOLDER_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_CASE_STAKE_HOLDER_MEMBER
    ADD CONSTRAINT CASE_STAKE_HOLDER_MEMBER_ID_FK FOREIGN KEY (STAKE_HOLDER_ID) REFERENCES E$CM_CASE_STAKE_HOLDER (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_COMMENT
    ADD CONSTRAINT COMMENT_ID_FK FOREIGN KEY (ID) REFERENCES E$CM_CASE_OBJECT (ID) ON DELETE CASCADE;

ALTER TABLE E$CM_RULE_EDIT
    ADD CONSTRAINT CM_RULE_EDIT_CM_RULE_FK1 FOREIGN KEY (RULE_NAMESPACE, RULE_VERSION) REFERENCES E$CM_RULE (RULE_NAMESPACE, RULE_VERSION);

ALTER TABLE E$CM_ACTIVITY_ATTRIBUTE
    ADD CONSTRAINT CM_ACTIVITY_ATTRIBUTE_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_ACTIVITY_CORRELATION
    ADD CONSTRAINT CM_ACTIVITY_CORRELATION_FK FOREIGN KEY (CASE_ID) REFERENCES E$CM_CASE (CASE_ID) ON DELETE CASCADE;

ALTER TABLE E$CM_ACTIVITY_STAKEHOLDER
    ADD CONSTRAINT CM_ACTIVITY_STAKEHOLDER_FK1 FOREIGN KEY (ACTIVITY_DEFINITION_ID) REFERENCES E$CM_ACTIVITY_DEFINITION (DEFINITION_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_ACTIVITY
    ADD CONSTRAINT BPM_ACTIVITY_FK1 FOREIGN KEY (PROCESS) REFERENCES E$BPM_PROCESS (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_ACTIVITY_INSTANCE
    ADD CONSTRAINT BPM_ACTIVITY_INSTANCE_FK2 FOREIGN KEY (PROCESS, ACTIVITY) REFERENCES E$BPM_ACTIVITY (PROCESS, ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_ACTIVITY_PROPERTY
    ADD CONSTRAINT BPM_ACTIVITY_PROPERTY_FK1 FOREIGN KEY (PROCESS, ACTIVITY) REFERENCES E$BPM_ACTIVITY (PROCESS, ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_AUDIT_QUERY_VAR_MD
    ADD CONSTRAINT BPM_AUDIT_QUERY_VAR_MD_BP_FK1 FOREIGN KEY (COMPOSITE_DN) REFERENCES E$BPM_AUDIT_QUERY_METADATA (COMPOSITE_DN) ON DELETE CASCADE;

ALTER TABLE E$BPM_AUDIT_QUERY_VAR_RANGES
    ADD CONSTRAINT BPM_AUDIT_QUERY_VAR_RANGE_FK1 FOREIGN KEY (COMPOSITE_DN, EXTENSION_ID) REFERENCES E$BPM_AUDIT_QUERY_VAR_MD (COMPOSITE_DN, EXTENSION_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_AUDIT_QUERY_VARVALS_EXT1
    ADD CONSTRAINT BPM_AUDIT_QUERY_VARVALS_FK1 FOREIGN KEY (QUERY_ID) REFERENCES E$BPM_AUDIT_QUERY (QUERY_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_ACTIVITY
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_ACTIVITY_INSTANCE
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_INST_FK2 FOREIGN KEY (PROCESSID, ACTIVITYID) REFERENCES E$BPM_CUBE_ACTIVITY (PROCESSID, ACTIVITYID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_ACTIVITY_PROPERTY
    ADD CONSTRAINT BPM_CUBE_ACTIVITY_PROPERTY_FK1 FOREIGN KEY (PROCESSID, ACTIVITYID) REFERENCES E$BPM_CUBE_ACTIVITY (PROCESSID, ACTIVITYID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_AUDITINST_FLEX01
    ADD CONSTRAINT BPM_CUBE_AUDITINST_FLEX01_FK1 FOREIGN KEY (QUERYID) REFERENCES E$BPM_CUBE_AUDITINSTANCE (QUERYID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_GLOBALCREATETASK
    ADD CONSTRAINT BPM_CUBE_GLOBALCREATETASK_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_NAMETAB
    ADD CONSTRAINT BPM_CUBE_NAMETAB_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_NAMETAB_RANGE
    ADD CONSTRAINT BPM_CUBE_NAMETAB_RANGE_FK1 FOREIGN KEY (PROCESSID, NAMETABID, EXTENSIONID) REFERENCES E$BPM_CUBE_NAMETAB (PROCESSID, NAMETABID, EXTENSIONID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_PARTNER_SERVICE
    ADD CONSTRAINT BPM_CUBE_PARTNER_SERVICE_FK1 FOREIGN KEY (PROCESSID, PARTNERID) REFERENCES E$BPM_CUBE_PROCESS_PARTNER (PROCESSID, PARTNERID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_PROCESS_PARTNER
    ADD CONSTRAINT BPM_CUBE_PROCESS_PARTNER_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_PROCESSPERFORMANCE
    ADD CONSTRAINT BPM_CUBE_PROCESSPERF_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_PROCPERF_FLEX01
    ADD CONSTRAINT BPM_CUBE_PROCPERF_FLEX01_FK1 FOREIGN KEY (PROCESSID, PROCESSPERFID) REFERENCES E$BPM_CUBE_PROCESSPERFORMANCE (PROCESSID, PROCESSPERFID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_ROLE
    ADD CONSTRAINT BPM_CUBE_ROLE_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_TASKPERF_FLEX01
    ADD CONSTRAINT BPM_CUBE_TASKPERF_FLEX01_FK1 FOREIGN KEY (ACTIVITYID, TASKPERFID) REFERENCES E$BPM_CUBE_TASKPERFORMANCE (ACTIVITYID, TASKPERFID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_TASKPERFORMANCE
    ADD CONSTRAINT BPM_CUBE_TASKPERF_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_WORKLOAD
    ADD CONSTRAINT BPM_CUBE_WORKLOAD_FK1 FOREIGN KEY (PROCESSID) REFERENCES E$BPM_CUBE_PROCESS (PROCESSID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CUBE_WORKLOAD_FLEX01
    ADD CONSTRAINT BPM_CUBE_WORKLOAD_FLEX01_FK1 FOREIGN KEY (ACTIVITYID, WORKLOADID) REFERENCES E$BPM_CUBE_WORKLOAD (ACTIVITYID, WORKLOADID) ON DELETE CASCADE;

ALTER TABLE E$BPM_PARTNER_SERVICE
    ADD CONSTRAINT BPM_PARTNER_SERVICE_FK1 FOREIGN KEY (PROCESS, PARTNER) REFERENCES E$BPM_PROCESS_PARTNER (PROCESS, ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_PROCESS_PARTNER
    ADD CONSTRAINT BPM_PROCESS_PARTNER_FK1 FOREIGN KEY (PROCESS) REFERENCES E$BPM_PROCESS (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_RT_FLOW_ELEMENT
    ADD CONSTRAINT BPM_RT_FLOW_ELEMENT_FK2 FOREIGN KEY (SNAPSHOTID) REFERENCES E$BPM_RT_SNAPSHOT (SNAPSHOTID) ON DELETE CASCADE;

ALTER TABLE E$BPM_RT_INSTANCE_CREATION
    ADD CONSTRAINT BPM_RT_INSTANCE_CREATION_FK2 FOREIGN KEY (SNAPSHOTID) REFERENCES E$BPM_RT_SNAPSHOT (SNAPSHOTID) ON DELETE CASCADE;

ALTER TABLE E$BPM_RT_SEQUENCE_FLOW
    ADD CONSTRAINT BPM_RT_SEQUENCE_FLOW_FK2 FOREIGN KEY (SNAPSHOTID) REFERENCES E$BPM_RT_SNAPSHOT (SNAPSHOTID) ON DELETE CASCADE;

ALTER TABLE E$BPM_PML_HS_BPM_PML_HS_ITEM
    ADD CONSTRAINT BPM_PML_HS_HS_ITEM_CHG_ITEMS FOREIGN KEY (changedItems_ID) REFERENCES E$BPM_PML_HS_ITEM (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_BAC_ASSET
    ADD CONSTRAINT FK_BPM_BAC_ASSET_SPACE_ID FOREIGN KEY (SPACE_ID) REFERENCES E$BPM_BAC_SPACE (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_BAC_ASSET
    ADD CONSTRAINT FK_BPM_BAC_ASSE_TIFACT_CREATOR FOREIGN KEY (ARTIFACT_CREATOR) REFERENCES E$BPM_BAC_PRINCIPAL (PRINCIPAL_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_BAC_ASSET_GRANT
    ADD CONSTRAINT FK_BPM_BAC_ASSE_GRANT_ARTIFACT FOREIGN KEY (ARTIFACT_ID) REFERENCES E$BPM_BAC_ASSET (ID);

ALTER TABLE E$BPM_BAC_ASSET_GRANT_PRINCIPA
    ADD CONSTRAINT FK_BPM_BAC_ASSE_NT_PRINCIPAL_1 FOREIGN KEY (PRINCIPAL_ID) REFERENCES E$BPM_BAC_PRINCIPAL (PRINCIPAL_ID);

ALTER TABLE E$BPM_BAC_ASSET_GRANT_PRINCIPA
    ADD CONSTRAINT FK_BPM_BAC_ASSE_NT_PRINCIPAL_2 FOREIGN KEY (GRANT_ID) REFERENCES E$BPM_BAC_ASSET_GRANT (GRANT_ID);

ALTER TABLE E$BPM_BAC_SPACE
    ADD CONSTRAINT FK_BPM_BAC_SPAC_TIFACT_CREATOR FOREIGN KEY (ARTIFACT_CREATOR) REFERENCES E$BPM_BAC_PRINCIPAL (PRINCIPAL_ID);

ALTER TABLE E$BPM_BAC_SPACE_GRANT
    ADD CONSTRAINT FK_BPM_BAC_SPACE_GRANT FOREIGN KEY (ARTIFACT_ID) REFERENCES E$BPM_BAC_SPACE (ID);

ALTER TABLE E$BPM_BAC_SPACE_GRANT_PRINCIPA
    ADD CONSTRAINT FK_BPM_BAC_SPAC_NT_PRINCIPAL_1 FOREIGN KEY (PRINCIPAL_ID) REFERENCES E$BPM_BAC_PRINCIPAL (PRINCIPAL_ID);

ALTER TABLE E$BPM_BAC_SPACE_GRANT_PRINCIPA
    ADD CONSTRAINT FK_BPM_BAC_SPAC_NT_PRINCIPAL_2 FOREIGN KEY (GRANT_ID) REFERENCES E$BPM_BAC_SPACE_GRANT (GRANT_ID);

ALTER TABLE E$BPM_OPT_COMPLETION_DATE_DATA
    ADD CONSTRAINT BPM_OPT_COMPLET_DATE_DATA_FK1 FOREIGN KEY (COMPOSITE_DN, COMPONENT_NAME) REFERENCES E$BPM_OPTIMIZATION_DATA (COMPOSITE_DN, COMPONENT_NAME);

ALTER TABLE E$BPM_OPT_COMPLETION_DATE_DATA
    ADD CONSTRAINT BPM_OPT_COMPLET_DATE_DATA_FK2 FOREIGN KEY (PARENT_NODE_ID) REFERENCES E$BPM_OPT_COMPLETION_DATE_DATA (NODE_IDENTIFIER);

ALTER TABLE E$SCA_ENTITY
    ADD CONSTRAINT SE_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$SCA_FLOW_INSTANCE
    ADD CONSTRAINT FI_SCA_ENTITY_FK FOREIGN KEY (COMPOSITE_SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$SCA_FLOW_INSTANCE
    ADD CONSTRAINT FI_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$SCA_FLOW_TO_CPST
    ADD CONSTRAINT FTCA_FLOW_INSTANCE_FK FOREIGN KEY (FLOW_ID) REFERENCES E$SCA_FLOW_INSTANCE (FLOW_ID);

ALTER TABLE E$SCA_FLOW_TO_CPST
    ADD CONSTRAINT FTCA_SCA_ENTITY_FK FOREIGN KEY (COMPOSITE_SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$SCA_FLOW_TO_CPST
    ADD CONSTRAINT FTCA_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$SCA_ASYNC_CPNT_STATE
    ADD CONSTRAINT ACIS_FLOW_INSTANCE_FK FOREIGN KEY (FLOW_ID) REFERENCES E$SCA_FLOW_INSTANCE (FLOW_ID);

ALTER TABLE E$SCA_FLOW_ASSOC
    ADD CONSTRAINT FA_OWNER_FLOW_INSTANCE_FK FOREIGN KEY (OWNER_FLOW_ID) REFERENCES E$SCA_FLOW_INSTANCE (FLOW_ID);

ALTER TABLE E$SCA_FLOW_ASSOC
    ADD CONSTRAINT FA_CORR_FLOW_INSTANCE_FK FOREIGN KEY (CORRELATED_FLOW_ID) REFERENCES E$SCA_FLOW_INSTANCE (FLOW_ID);

ALTER TABLE E$SCA_FLOW_ASSOC
    ADD CONSTRAINT FA_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$SCA_META_DATA
    ADD CONSTRAINT MD_FLOW_INSTANCE_FK FOREIGN KEY (FLOW_ID) REFERENCES E$SCA_FLOW_INSTANCE (FLOW_ID);

ALTER TABLE E$SCA_META_DATA
    ADD CONSTRAINT MD_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$SCA_REJECTED_MESSAGE
    ADD CONSTRAINT SRM_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$SCA_ATTACHMENT_REF
    ADD CONSTRAINT SAR_SCA_ENTITY_FK FOREIGN KEY (SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$SCA_ATTACHMENT_REF
    ADD CONSTRAINT SAR_COMPOSITE_SCA_ENTITY_FK FOREIGN KEY (COMPOSITE_SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$SCA_ATTACHMENT_REF
    ADD CONSTRAINT SAR_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$RESLNCY_FAILURE_EP
    ADD CONSTRAINT RESLNCY_EP_SCA_ENTITY_FK FOREIGN KEY (SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$RESLNCY_SUSPEND_SVC
    ADD CONSTRAINT RESLNCY_SVC_EP_FK FOREIGN KEY (EP_ENTITY_ID) REFERENCES E$RESLNCY_FAILURE_EP (SCA_ENTITY_ID) ON DELETE CASCADE;

ALTER TABLE E$RESLNCY_SUSPEND_SVC
    ADD CONSTRAINT RESLNCY_SCA_ENTITY_FK FOREIGN KEY (SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$RESLNCY_SUSPEND_SVC_HSTRY
    ADD CONSTRAINT RESLNCY_HSTRY_SVC_EP_FK FOREIGN KEY (EP_ID) REFERENCES E$RESLNCY_FAILURE_EP_HSTRY (ID);

ALTER TABLE E$BPM_BUSINESS_CONSTANT_OU_ASS
    ADD CONSTRAINT FK__BPM_BC__5D646C00 FOREIGN KEY (BUSINESS_CONSTANT_ID) REFERENCES E$BPM_BUSINESS_CONSTANT (BUSINESS_CONSTANT_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_BUSINESS_CONSTANT_OU_ASS
    ADD CONSTRAINT FK__BPM_BC__ASS_ORG__5C7047C7 FOREIGN KEY (ORGANIZATIONAL_UNIT_ID) REFERENCES E$BPM_ORGANIZATIONAL_UNIT (ORGANIZATIONAL_UNIT_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_APP_ROLE_OU_CAL_ASSOC
    ADD CONSTRAINT FK__BPM_APP_R__CALEN__5D646C00 FOREIGN KEY (CALENDAR_RULE_ID) REFERENCES E$BPM_CALENDAR_RULE (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_APP_ROLE_OU_CAL_ASSOC
    ADD CONSTRAINT FK__BPM_APP_R__ORGAN__5C7047C7 FOREIGN KEY (ORGANIZATIONAL_UNIT_ID) REFERENCES E$BPM_ORGANIZATIONAL_UNIT (ORGANIZATIONAL_UNIT_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_CALENDAR_RULE
    ADD CONSTRAINT FK__BPM_CALEN__HOLID__3B0F53FC FOREIGN KEY (HOLIDAY_RULE_ID) REFERENCES E$BPM_HOLIDAY_RULE (ID);

ALTER TABLE E$BPM_CALENDAR_WORKDAY
    ADD CONSTRAINT FK__BPM_CALEN__CALEN__3FD40919 FOREIGN KEY (CALENDAR_RULE_ID) REFERENCES E$BPM_CALENDAR_RULE (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_FISCAL_YEAR_DIVISION
    ADD CONSTRAINT FK__BPM__FISCAL_FOR_DIVISIONS FOREIGN KEY (FISCAL_YEAR_ID) REFERENCES E$BPM_FISCAL_YEAR (FISCAL_YEAR_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_HOLIDAYS
    ADD CONSTRAINT FK__BPM_HOLID__HOLID__3462566D FOREIGN KEY (HOLIDAY_RULE_ID) REFERENCES E$BPM_HOLIDAY_RULE (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_LPG_MEMBER
    ADD CONSTRAINT FK__BPM_LPG_M__QUERY__68D61EAC FOREIGN KEY (QUERY_ID) REFERENCES E$BPM_LOGICAL_PEOPLE_GROUP (ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_ORGANIZATIONAL_UNIT
    ADD CONSTRAINT FK__BPM_ORGAN__CALEN__4C39DFFE FOREIGN KEY (CALENDAR_RULE_ID) REFERENCES E$BPM_CALENDAR_RULE (ID);

ALTER TABLE E$BPM_ORGANIZATIONAL_UNIT
    ADD CONSTRAINT FK__BPM_FISCAL_R_ORGANIZATION FOREIGN KEY (FISCAL_YEAR_ID) REFERENCES E$BPM_FISCAL_YEAR (FISCAL_YEAR_ID);

ALTER TABLE E$BPM_ORGANIZATIONAL_UNIT
    ADD CONSTRAINT FK__BPM_ORGAN__PAREN__4B45BBC5 FOREIGN KEY (PARENT_ORGANIZATIONAL_UNIT_ID) REFERENCES E$BPM_ORGANIZATIONAL_UNIT (ORGANIZATIONAL_UNIT_ID);

ALTER TABLE E$BPM_OU_MANAGER
    ADD CONSTRAINT FK__BPM_OU_MA__ORGAN__56B76E71 FOREIGN KEY (ORGANIZATIONAL_UNIT_ID) REFERENCES E$BPM_ORGANIZATIONAL_UNIT (ORGANIZATIONAL_UNIT_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_OU_USER
    ADD CONSTRAINT FK__BPM_OU_US__ORGAN__50FE951B FOREIGN KEY (ORGANIZATIONAL_UNIT_ID) REFERENCES E$BPM_ORGANIZATIONAL_UNIT (ORGANIZATIONAL_UNIT_ID) ON DELETE CASCADE;

ALTER TABLE E$BPM_PRESENTATION_GRANT
    ADD CONSTRAINT FK__BPM_PRESE__PRESE__4D630E61 FOREIGN KEY (PRESENTATIONID) REFERENCES E$BPM_PRESENTATION (PRESENTATIONID) ON DELETE CASCADE;

ALTER TABLE E$BPM_USERAPPLICATIONDATA_GRAN
    ADD CONSTRAINT FK__BPM_USERA__APPLI__63524F80 FOREIGN KEY (APPLICATIONDATAID) REFERENCES E$BPM_USERAPPLICATIONDATA (APPLICATIONDATAID) ON DELETE CASCADE;

ALTER TABLE E$NotifTrackerAttachments
    ADD CONSTRAINT FK_NOTIFICATION_TRACKER_ID FOREIGN KEY (trackingid) REFERENCES E$NotificationTracker (id) ON DELETE CASCADE;

ALTER TABLE E$WFApprovalGroupMembers
    ADD CONSTRAINT FK__WFApprova__appro__205B5DC0 FOREIGN KEY (approvalGroupId) REFERENCES E$WFApprovalGroups (approvalGroupId) ON DELETE CASCADE;

ALTER TABLE E$WFAssignee
    ADD CONSTRAINT FK__WFAssigne__taskI__1CBFD706 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFAttributeLabelUsage
    ADD CONSTRAINT FK__WFAttribu__mapId__40FD377C FOREIGN KEY (mapId) REFERENCES E$WFAttributeLabelMap (id);

ALTER TABLE E$WFCertificate
    ADD CONSTRAINT FK__WFCertifi__caNam__078FAFF6 FOREIGN KEY (caName) REFERENCES E$WFCertAuthority (caName);

ALTER TABLE E$WFCertificateRevoked
    ADD CONSTRAINT FK__WFCertifi__caNam__02CAFAD9 FOREIGN KEY (caName) REFERENCES E$WFCertAuthority (caName);

ALTER TABLE E$WFCollectionTarget
    ADD CONSTRAINT FK__WFCollect__taskI__25551D07 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFComments
    ADD CONSTRAINT FK__WFComment__taskI__142A9105 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFEvidence
    ADD CONSTRAINT FK__WFEvidence__0D48894C FOREIGN KEY (certificateNo, caName) REFERENCES E$WFCertificate (certificateNo, caName);

ALTER TABLE E$WFEvidence
    ADD CONSTRAINT FK__WFEvidenc__taskI__0C546513 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFHeaderProps
    ADD CONSTRAINT FK__WFHeaderP__taskI__7A35B4D8 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFMessageAttribute
    ADD CONSTRAINT FK__WFMessage__taskI__1612D977 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFNotification
    ADD CONSTRAINT FK__WFNotific__taskI__2EDE8741 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFReviewer
    ADD CONSTRAINT FK__WFReviewe__taskI__236CD495 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFRoutingSlip
    ADD CONSTRAINT FK__WFRouting__taskI__2A19D224 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTask_TL
    ADD CONSTRAINT FK__WFTask_TL__taskI__08B8DE59 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTaskAggregation
    ADD CONSTRAINT FK__WFTaskAgg__rootT__1AA2846A FOREIGN KEY (rootTaskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTaskAssignmentStatistic
    ADD CONSTRAINT FK__WFTaskAss__taskI__120D3E69 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTaskError
    ADD CONSTRAINT FK__WFTaskErr__taskI__7570FFBB FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTaskHistory
    ADD CONSTRAINT FK__WFTaskHis__taskI__0D7D9376 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTaskHistory_TL
    ADD CONSTRAINT FK__WFTaskHis__taskI__12424893 FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFTaskTimer
    ADD CONSTRAINT FK__WFTaskTim__taskI__6CDBB9BA FOREIGN KEY (taskId) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WFUserTaskView
    ADD CONSTRAINT FK__WFUserTas__prese__5227C37E FOREIGN KEY (presentationId) REFERENCES E$BPM_PRESENTATION (PRESENTATIONID);

ALTER TABLE E$WFUserTaskViewGrant
    ADD CONSTRAINT FK__WFUserTas__viewI__56EC789B FOREIGN KEY (viewId) REFERENCES E$WFUserTaskView (viewId) ON DELETE CASCADE;

ALTER TABLE E$WFWORKQUEUE_MEMBER
    ADD CONSTRAINT FK_WORKQUEUE_MEMBER_WORKQUEUE FOREIGN KEY (WORKQUEUE_NAME) REFERENCES E$WFWORKQUEUE (NAME) ON DELETE CASCADE;

ALTER TABLE E$WFWORKQUEUE_MANAGER
    ADD CONSTRAINT FK_WORKQUEUE_MANAGER_WORKQUEUE FOREIGN KEY (WORKQUEUE_NAME) REFERENCES E$WFWORKQUEUE (NAME) ON DELETE CASCADE;

ALTER TABLE E$WFWORKQUEUE_SKIP
    ADD CONSTRAINT FK_WORKQUEUE_SKIP_WORKQUEUE FOREIGN KEY (WORKQUEUE_NAME) REFERENCES E$WFWORKQUEUE (NAME) ON DELETE CASCADE;

ALTER TABLE E$WFWORKQUEUE_SKIP
    ADD CONSTRAINT FK_WORKQUEUE_SKIP_WFTASK FOREIGN KEY (WORKITEM_ID) REFERENCES E$WFTask (taskId) ON DELETE CASCADE;

ALTER TABLE E$WLI_QS_REPORT_DATA
    ADD CONSTRAINT FK_WLI_QS_REPORT_DATA FOREIGN KEY (MSG_GUID) REFERENCES E$WLI_QS_REPORT_ATTRIBUTE (MSG_GUID) ON DELETE CASCADE;

ALTER TABLE E$RM_UNACKED_MESSAGES
    ADD CONSTRAINT FK_SEQUENCE FOREIGN KEY (ENDPOINT_UID, SEQ_ID) REFERENCES E$RM_SEQUENCES (ENDPOINT_UID, ID) ON DELETE CASCADE;

ALTER TABLE E$BRDECISIONFAULT
    ADD CONSTRAINT BRDECISIONFAULT_FK1 FOREIGN KEY (INSTANCE_ID) REFERENCES E$BRDECISIONINSTANCE (ID) ON DELETE CASCADE;

ALTER TABLE E$BRDECISIONUNITOFWORK
    ADD CONSTRAINT SYS_C00372357 FOREIGN KEY (INSTANCE_ID) REFERENCES E$BRDECISIONINSTANCE (ID) ON DELETE CASCADE;

ALTER TABLE E$VARIABLE_SENSOR_VALUES
    ADD CONSTRAINT VARIABLE_SENSOR_FK1 FOREIGN KEY (ACTIVITY_SENSOR_ID, PROCESS_INSTANCE_ID) REFERENCES E$ACTIVITY_SENSOR_VALUES (ID, PROCESS_INSTANCE_ID);

ALTER TABLE E$SCA_SENSOR_VALUE
    ADD CONSTRAINT FSV_FLOW_INSTANCE_FK FOREIGN KEY (FLOW_ID) REFERENCES E$SCA_FLOW_INSTANCE (FLOW_ID);

ALTER TABLE E$SCA_SENSOR_VALUE
    ADD CONSTRAINT FSV_SCA_ENTITY_FK FOREIGN KEY (SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$SCA_SENSOR_VALUE
    ADD CONSTRAINT FSV_COMPOSITE_SCA_ENTITY_FK FOREIGN KEY (COMPOSITE_SCA_ENTITY_ID) REFERENCES E$SCA_ENTITY (ID);

ALTER TABLE E$SCA_SENSOR_VALUE
    ADD CONSTRAINT FSV_SCA_PARTITION_FK FOREIGN KEY (SCA_PARTITION_ID) REFERENCES E$SCA_PARTITION (ID);

ALTER TABLE E$MEDIATOR_RESEQUENCER_MESSAGE
    ADD CONSTRAINT MEDIATOR_GROUP_STATUS_FK1 FOREIGN KEY (OWNER_ID) REFERENCES E$MEDIATOR_GROUP_STATUS (ID);

ALTER TABLE E$OSB_RESEQUENCER_MESSAGE
    ADD CONSTRAINT OSB_GROUP_STATUS_FK1 FOREIGN KEY (OWNER_ID) REFERENCES E$OSB_GROUP_STATUS (ID);

ALTER TABLE E$B2B_RESEQUENCER_MESSAGE
    ADD CONSTRAINT B2B_GROUP_STATUS_FK1 FOREIGN KEY (OWNER_ID) REFERENCES E$B2B_GROUP_STATUS (ID);

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE FUNCTION FILEADAPTERNEXTVALUE(mutexid in VARCHAR2) RETURN NUMBER IS
   seq NUMBER;      BEGIN
   UPDATE FILEADAPTER_MUTEX
   SET MUTEX_SEQUENCE = MUTEX_SEQUENCE + 1
   WHERE MUTEX_ID = mutexid
   RETURNING MUTEX_SEQUENCE
   INTO seq;
   RETURN seq;
END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE ADAPTER_REPORT_SEQUENCE INCREMENT BY 1 START WITH 1 MINVALUE 1 CACHE 100
/

-- oracle----------------------------------------------------------------------- 
-- Stop and drop the AQs 

BEGIN
      dbms_aqadm.create_queue_table (
      queue_table        => '&CURSCHEMA..AIA_CAVSCALLBACKJMSQTAB', 
      queue_payload_type => 'SYS.AQ$_JMS_OBJECT_MESSAGE', 
      sort_list          => 'ENQ_TIME', 
      comment            => '',  
      multiple_consumers => FALSE, 
      message_grouping   => DBMS_AQADM.NONE, 
      compatible         => '8.1', 
      primary_instance   => '0', 
      secondary_instance => '0');

      dbms_aqadm.create_queue (
      queue_name         => '&CURSCHEMA..AIA_CAVSCALLBACKJMSQ', 
      queue_table        => '&CURSCHEMA..AIA_CAVSCALLBACKJMSQTAB', 
      queue_type         => sys.dbms_aqadm.NORMAL_QUEUE, 
      max_retries        => '5', 
      retry_delay        => '0', 
      retention_time     => '0', 
      comment => '');

      dbms_aqadm.start_queue (
      queue_name         => '&CURSCHEMA..AIA_CAVSCALLBACKJMSQ', 
      enqueue            => TRUE, 
      dequeue            => TRUE);
      END;
/

-- ----------------------------------------------------------------------- 
-- Unknown 

Insert into AIA_SYSTEMS (SYSTEM_ID,SYSTEM_INTERNAL_ID,SYSTEM_CODE,SYSTEM_DESC,SYSTEM_IP_ADDR,SYSTEM_URL,SYSTEM_TYPE,APPLICATION_TYPE,APPLICATION_VERSION,CONTACT_NAME,CONTACT_PHONE,CONTACT_EMAIL) values (1016,'CAVS_SOURCE','CAVS_SOURCE','CAVS Testing Framework','127.0.0.1','','CAVS','CAVS','1.0','CAVS Contact','1234567890','cavs_contact@aia.com')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

Insert into AIA_SYSTEMS (SYSTEM_ID,SYSTEM_INTERNAL_ID,SYSTEM_CODE,SYSTEM_DESC,SYSTEM_IP_ADDR,SYSTEM_URL,SYSTEM_TYPE,APPLICATION_TYPE,APPLICATION_VERSION,CONTACT_NAME,CONTACT_PHONE,CONTACT_EMAIL) values (1017,'CAVS_TARGET','CAVS_TARGET','CAVS Testing Framework','127.0.0.1','','CAVS','CAVS','1.0','CAVS Contact','1234567890','cavs_contact@aia.com')
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE AIA_ERROR_NOTIFICATIONS_S INCREMENT BY 1 START 
        WITH 10000 MINVALUE 1 MAXVALUE 999999999999999999999999999 NOCYCLE 
        CACHE 20 NOORDER;
      CREATE SEQUENCE AIA_SYSTEMS_S INCREMENT BY 1 START WITH 10000 MINVALUE 1 
        MAXVALUE 999999999999999999999999999 NOCYCLE CACHE 20 NOORDER;
      CREATE SEQUENCE CAVS_DEFINITION_ID INCREMENT BY 1 START WITH 1000 
        MAXVALUE 100000 MINVALUE 1000;
      CREATE SEQUENCE CAVS_GROUP_DEFINITION_ID INCREMENT BY 1 START WITH 1000 
        MAXVALUE 100000 MINVALUE 1000;
      CREATE SEQUENCE CAVS_GROUP_INSTANCE_ID INCREMENT BY 1 START WITH 1000 
        MAXVALUE 100000 MINVALUE 1000;
      CREATE SEQUENCE CAVS_INSTANCE_ID INCREMENT BY 1 START WITH 1000 
        MAXVALUE 100000 MINVALUE 1000;
      CREATE SEQUENCE CAVS_ROUTING_SETUP_ID INCREMENT BY 1 START WITH 1000 
        MAXVALUE 100000 MINVALUE 1000;
      CREATE SEQUENCE CAVS_ROUTING_SETUP_DETAIL_ID INCREMENT BY 1 START WITH 1 
        MAXVALUE 100000 MINVALUE 1;
      CREATE SEQUENCE AIA_OID_SEQ INCREMENT BY 1 START 
        WITH 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 NOCYCLE 
        CACHE 20 NOORDER;
      CREATE SEQUENCE AIA_MSG_ORDER_SEQ INCREMENT BY 1 START 
        WITH 1 MINVALUE 1 MAXVALUE 999999999999999999999999999 NOCYCLE 
        CACHE 20 NOORDER
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE PROCEDURE MSG_RESUBMIT
      (
        MSG_ID 		RAW,
        CONSUMER_NAME       VARCHAR,
        DEQUEUE_NAME        VARCHAR,
        RESUBMIT_QUEUE_NAME VARCHAR,
        NEW_MSG_ID          OUT VARCHAR
      )
      AS
        R_DEQUEUE_OPTIONS DBMS_AQ.DEQUEUE_OPTIONS_T;
        R_ENQUEUE_OPTIONS DBMS_AQ.ENQUEUE_OPTIONS_T;
        R_MESSAGE_PROPERTIES DBMS_AQ.MESSAGE_PROPERTIES_T;
        R_ENQUEU_MESSAGE_PROPERTIES DBMS_AQ.MESSAGE_PROPERTIES_T;
        L_MESSAGE_HANDLE RAW(16);
        RESUBMIT_MESSAGE_ID RAW(2000);
        MSG SYS.AQ$_JMS_MESSAGE;
        ANYEXCEPTION EXCEPTION;
        V_MESSAGE_HANDLE RAW(16);
      BEGIN
        R_DEQUEUE_OPTIONS.CONSUMER_NAME := NULL;
        R_DEQUEUE_OPTIONS.DEQUEUE_MODE  := DBMS_AQ.REMOVE;
        R_DEQUEUE_OPTIONS.WAIT          := DBMS_AQ.NO_WAIT;
        R_DEQUEUE_OPTIONS.VISIBILITY    := DBMS_AQ.ON_COMMIT;
        R_DEQUEUE_OPTIONS.NAVIGATION    := DBMS_AQ.FIRST_MESSAGE;
        R_DEQUEUE_OPTIONS.MSGID         := MSG_ID;

        DBMS_AQ.DEQUEUE( 
        QUEUE_NAME => DEQUEUE_NAME, 
        DEQUEUE_OPTIONS => R_DEQUEUE_OPTIONS, 
        MESSAGE_PROPERTIES => R_MESSAGE_PROPERTIES, 
        PAYLOAD => MSG, 
        MSGID => V_MESSAGE_HANDLE );

        R_ENQUEUE_OPTIONS.VISIBILITY:=DBMS_AQ.IMMEDIATE;

        DBMS_AQ.ENQUEUE( 
        QUEUE_NAME => RESUBMIT_QUEUE_NAME, 
        ENQUEUE_OPTIONS => R_ENQUEUE_OPTIONS, 
        MESSAGE_PROPERTIES => R_ENQUEU_MESSAGE_PROPERTIES, 	
        PAYLOAD => MSG, 
        MSGID => RESUBMIT_MESSAGE_ID );

        NEW_MSG_ID := RESUBMIT_MESSAGE_ID;

      EXCEPTION
      WHEN ANYEXCEPTION THEN
        ROLLBACK;
      END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW CAVS_DEFINITION_XPATH_VW AS SELECT 
        XPATHS.DEFINITION_ID DEFINITION_ID, 
        XPATHS.XPATH XPATH, 
        XPATHS.NODE_VALUE_EXPECTED NODE_VALUE_KEY, 
        XPATHS.NAMESPACE NAMESPACE 
      FROM 
        CAVS_DEFINITION_XPATHS XPATHS 
      WHERE 
        DEFINITION_ID = XPATHS.DEFINITION_ID AND IS_NODE_KEY = 1
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW CAVS_INSTANCE_XREF_VW AS SELECT 
        INSTANCES_TEST.INSTANCE_ID INSTANCE_ID_TEST, 
        INSTANCES_TEST.DEFINITION_ID DEFINITION_ID_TEST, 
        INSTANCES_TEST.STARTED_ON STARTED_ON_TEST, 
        INSTANCES_TEST.ENDED_ON ENDED_ON_TEST, 
        INSTANCES_SIMULATOR.INSTANCE_ID INSTANCE_ID_SIMULATOR, 
        INSTANCES_SIMULATOR.DEFINITION_ID DEFINITION_ID_SIMULATOR, 
        INSTANCES_SIMULATOR.STARTED_ON STARTED_ON_SIMULATOR, 
        INSTANCES_SIMULATOR.ENDED_ON ENDED_ON_SIMULATOR 
      FROM 
        CAVS_INSTANCES INSTANCES_TEST,
        CAVS_INSTANCES INSTANCES_SIMULATOR,
        CAVS_DEFINITION_XREFS
      WHERE 
        CAVS_DEFINITION_XREFS.DEFINITION_ID_TEST = INSTANCES_TEST.DEFINITION_ID AND CAVS_DEFINITION_XREFS.DEFINITION_ID_SIMULATOR = INSTANCES_SIMULATOR.DEFINITION_ID AND INSTANCES_TEST.STARTED_ON < INSTANCES_SIMULATOR.STARTED_ON
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER AIA_ERROR_NOTIFICATIONS_INSERT
      BEFORE INSERT ON AIA_ERROR_NOTIFICATIONS FOR EACH ROW
      BEGIN
        IF :NEW.ERROR_NOTIFICATION_ID IS NULL THEN
          SELECT AIA_ERROR_NOTIFICATIONS_S.NEXTVAL INTO :NEW.ERROR_NOTIFICATION_ID FROM DUAL;
        END IF;
      END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER AIA_SYSTEMS_INSERT
      BEFORE INSERT ON AIA_SYSTEMS FOR EACH ROW
      BEGIN
        IF :NEW.SYSTEM_ID IS NULL THEN
          SELECT AIA_SYSTEMS_S.NEXTVAL INTO :NEW.SYSTEM_ID FROM DUAL;
        END IF;
      END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_DEFINITION_ID BEFORE INSERT 
      ON CAVS_DEFINITIONS FOR EACH ROW
      begin
        if inserting then
          if :NEW."DEFINITION_ID" is null then
            select CAVS_DEFINITION_ID.nextval into :NEW."DEFINITION_ID" 
            from dual;
          end if;
        end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_INSTANCE_ID BEFORE INSERT ON 
      CAVS_INSTANCES FOR EACH ROW
      begin
        if inserting then
          if :NEW."INSTANCE_ID" is null then
            select CAVS_INSTANCE_ID.nextval into :NEW."INSTANCE_ID" from dual;
          end if;
        end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_GROUP_DEFINITION_ID BEFORE INSERT 
      ON CAVS_GRPDEFINITIONS FOR EACH ROW
      begin
        if inserting then
          if :NEW."GROUP_DEFINITION_ID" is null then
            select CAVS_GROUP_DEFINITION_ID.nextval into 
            :NEW."GROUP_DEFINITION_ID" from dual;
          end if;
        end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_GROUP_INSTANCE_ID BEFORE INSERT 
      ON CAVS_GRPINSTANCES FOR EACH ROW
      begin
        if inserting then
          if :NEW."GROUP_INSTANCE_ID" is null then
            select CAVS_GROUP_INSTANCE_ID.nextval into 
            :NEW."GROUP_INSTANCE_ID" from dual;
          end if;
        end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_DEFINITIONS_AFTER_AUDITED AFTER 
      INSERT OR UPDATE ON CAVS_DEFINITIONS FOR EACH ROW
      begin
        if updating then
          update CAVS_INSTANCES
            set IS_STALED = 1
            where DEFINITION_ID = :OLD."DEFINITION_ID";
         end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_SETUP_ID BEFORE INSERT ON 
      CAVS_ROUTING_SETUP FOR EACH ROW
      begin
        if inserting then
          if :NEW."SETUP_ID" is null then
            select CAVS_ROUTING_SETUP_ID.nextval into 
            :NEW."SETUP_ID" from dual;
          end if;
        end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE TRIGGER CAVS_SETUP_DETAIL_ID BEFORE INSERT 
      ON CAVS_ROUTING_SETUP_DETAILS FOR EACH ROW
      begin
        if inserting then
          if :NEW."SETUP_DETAIL_ID" is null then
            select CAVS_ROUTING_SETUP_DETAIL_ID.nextval into 
            :NEW."SETUP_DETAIL_ID" from dual;
          end if;
         end if;
      end;
/

-- oracle----------------------------------------------------------------------- 
-- Stop and drop the AQs 

BEGIN
 dbms_aqadm.stop_queue (queue_name => 'IP_IN_QUEUE');
 dbms_aqadm.drop_queue (queue_name => 'IP_IN_QUEUE');
 dbms_aqadm.stop_queue (queue_name => 'IP_OUT_QUEUE');
 dbms_aqadm.drop_queue (queue_name => 'IP_OUT_QUEUE');
 dbms_aqadm.drop_queue_table (queue_table => 'IP_QTAB');
END;
/

-- oracle----------------------------------------------------------------------- 
-- 10g perf optimizations 

/* sql hints  */
    CREATE OR REPLACE PACKAGE WIRE_MESSAGE_TYPES IS
    TYPE WDATA IS REF CURSOR RETURN B2B_WIRE_MESSAGE%ROWTYPE;
    END WIRE_MESSAGE_TYPES;
/

-- oracle----------------------------------------------------------------------- 
-- Create and Start the AQs 

BEGIN
   dbms_aqadm.create_queue_table (queue_table => 'IP_QTAB', queue_payload_type =>  '&2..IP_MESSAGE_TYPE', multiple_consumers => TRUE);
   dbms_aqadm.create_queue (queue_name =>  'IP_IN_QUEUE', queue_table =>  'IP_QTAB');
   dbms_aqadm.create_queue (queue_name => 'IP_OUT_QUEUE', queue_table => 'IP_QTAB');
   dbms_aqadm.start_queue(queue_name => 'IP_IN_QUEUE', dequeue => TRUE, enqueue => TRUE);
   dbms_aqadm.start_queue(queue_name =>  'IP_OUT_QUEUE', dequeue => TRUE, enqueue => TRUE);
END;
/

-- oracle----------------------------------------------------------------------- 
-- 10g perf optimizations 

/* sql hints  */
CREATE OR REPLACE PACKAGE WIRE_MESSAGE_TYPES IS
TYPE WDATA IS REF CURSOR RETURN B2B_WIRE_MESSAGE%ROWTYPE;
END WIRE_MESSAGE_TYPES;
/

-- oracle----------------------------------------------------------------------- 
-- Sequence Counter 

CREATE SEQUENCE B2B_SEQUENCECOUNTER 
    MINVALUE 1 
    MAXVALUE 9999999999999999
    START WITH 1 
    INCREMENT BY 1 
    CACHE 20
/

-- oracle----------------------------------------------------------------------- 
-- Type definition 

CREATE OR REPLACE TYPE B2B_PARTITION_INFO_TYPE AS OBJECT(PARTITION_NAME VARCHAR2(30),TABLE_NAME VARCHAR2(30), DDL_STATEMENT VARCHAR2(1000));
/

-- oracle----------------------------------------------------------------------- 
-- Type definition 

CREATE OR REPLACE TYPE LIST_PARTITION_INFO_TYPE IS TABLE OF B2B_PARTITION_INFO_TYPE;
/

-- oracleEbr----------------------------------------------------------------------- 
-- Materialized View used by HCFP Dashboard 

CREATE MATERIALIZED VIEW b2b_system_mv
BUILD IMMEDIATE REFRESH ON DEMAND
AS
  SELECT channel_name, 
    direction,
    doc_protocol_name || '-' || doc_protocol_version || '-' ||  doctype_name  document_type,
    trunc(created, 'HH24') created_hour,
    COUNT(*) no_of_msgs,
    AVG(native_msg_size) avg_msg_size,
    COUNT(native_msg_size) ct_msg_size,
    AVG(processing_time) avg_proc_time,
    COUNT(processing_time) ct_proc_time,
    COUNT(error_code) no_of_errs
  FROM E$b2b_business_message bm,
    E$b2b_ext_business_message ext
  WHERE bm.ext_business_message = ext.id
  group by channel_name, direction, doc_protocol_name || '-' || doc_protocol_version || '-' ||  doctype_name, trunc(created, 'HH24')
/

-- oracle----------------------------------------------------------------------- 
-- Procedure to change status of Constraint or Drop Constraint 

create or replace 
			PROCEDURE B2B_CH_STATUS_DROP_CONSTRAINT(
			tableName IN VARCHAR2, 
			constraintName IN VARCHAR2, 
			changeStatusTo IN VARCHAR2) 
			AS
     		 	TABLE_NAME_LOCAL VARCHAR2(30);  
      		BEGIN
       			EXECUTE IMMEDIATE 'SELECT TABLE_NAME FROM USER_CONSTRAINTS 
       								WHERE CONSTRAINT_NAME= :constraintName' INTO TABLE_NAME_LOCAL USING constraintName;
        		IF TABLE_NAME_LOCAL = tableName THEN 
          			EXECUTE IMMEDIATE 'ALTER TABLE ' || tableName || ' '||changeStatusTo||' CONSTRAINT ' || constraintName;
        		END IF;
        	 EXCEPTION
          		WHEN NO_DATA_FOUND THEN
            	dbms_output.put_line('Info: CONSTRAINT ' || constraintName ||' NOT FOUND IN TABLE '||tableName);
  			END B2B_CH_STATUS_DROP_CONSTRAINT;
/

-- oracleEbr----------------------------------------------------------------------- 
-- Procedure to change status of  all B2B Constraints 

CREATE OR REPLACE PROCEDURE B2B_CHANGE_STATUS_CONSTRAINTS(changeStatusTo IN VARCHAR2) AS
BEGIN
  B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_WM_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_AM_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_NDS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_TDS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_AS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_EBM_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_BUSINESS_MESSAGE',  'B2B_BM_PS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_WIRE_MESSAGE',  'B2B_WM_DS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_WIRE_MESSAGE',  'B2B_WM_PS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_EXT_BUSINESS_MESSAGE',  'B2B_EBM_BM_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_APP_MESSAGE',  'B2B_AM_PAYLOAD_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_APP_MESSAGE',  'B2B_AM_BM_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_APP_MESSAGE',  'B2B_AM_AS_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_DATA_STORAGE',  'B2B_DS_DOC_ID_FK',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_CONTROL_NUMBER_SET',  'B2B_CNS_CN_FK1',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_CONTROL_NUMBER_SET',  'B2B_CNS_CN_FK2',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_CONTROL_NUMBER_SET',  'B2B_CNS_CN_FK3',  changeStatusTo);
	B2B_CH_STATUS_DROP_CONSTRAINT('E$B2B_LIFECYCLE',  'B2B_LC_CN_FK',  changeStatusTo); 
END B2B_CHANGE_STATUS_CONSTRAINTS;
/

-- oracle----------------------------------------------------------------------- 
-- Procedure to disable all B2B Constraints 

CREATE OR REPLACE PROCEDURE B2B_DISABLE_CONSTRAINTS AS
 	/* This procedure is deprecated and will be removed in forthcoming release.
   	 * Please use  B2B_CHANGE_STATUS_CONSTRAINTS() instead.
   	 */
BEGIN
  		B2B_CHANGE_STATUS_CONSTRAINTS('DISABLE');
END B2B_DISABLE_CONSTRAINTS;
/

-- oracle----------------------------------------------------------------------- 
-- Procedure to enable all B2B Constraints 

CREATE OR REPLACE PROCEDURE B2B_ENABLE_CONSTRAINTS AS
	/* This procedure is deprecated and will be removed in forthcoming release.
   	 * Please use  B2B_CHANGE_STATUS_CONSTRAINTS() instead.
   	 */
BEGIN
   		B2B_CHANGE_STATUS_CONSTRAINTS('ENABLE');		
END B2B_ENABLE_CONSTRAINTS;
/

-- oracle----------------------------------------------------------------------- 
-- Stored Procedure to export B2B Runtime Data 

CREATE OR REPLACE PROCEDURE B2B_EXPORT_JOB 
 (filename in varchar2, job_id in varchar2) AS
  ind NUMBER;              /* Loop index */
  h1 NUMBER;               /* Data Pump job handle */
  percent_done NUMBER;     /* Percentage of job complete */
  job_state VARCHAR2(30);  /* To keep track of job state */
  le ku$_LogEntry;         /* For WIP and error messages */
  js ku$_JobStatus;        /* The job status from get_status */
  jd ku$_JobDesc;          /* The job description from get_status */
  sts ku$_Status;          /* The status object returned by get_status */
BEGIN
/* Create a (user-named) Data Pump job to do a schema export. */

   h1 := DBMS_DATAPUMP.OPEN('EXPORT','TABLE',NULL,job_id,'LATEST');

/*
 Specify a single dump file for the job (using the handle just returned)
 and a directory object, which must already be defined and accessible
 to the user running this procedure.
*/

  DBMS_DATAPUMP.ADD_FILE(h1, filename,'B2B_EXPORT_DIR');
  
  dbms_datapump.metadata_filter(h1,'NAME_EXPR','IN (''B2B_BUSINESS_MESSAGE'', ''B2B_EXT_BUSINESS_MESSAGE'', ''B2B_APP_MESSAGE'', ''B2B_WIRE_MESSAGE'',''B2B_DATA_STORAGE'')');
  
  

    DBMS_DATAPUMP.DATA_FILTER(
            handle => h1, 
            name => 'SUBQUERY', 
            value => 'WHERE JOB_ID = ''' || job_id || '''',
                    table_name => 'B2B_BUSINESS_MESSAGE'        
        );          

    DBMS_DATAPUMP.DATA_FILTER(
            handle => h1, 
            name => 'SUBQUERY', 
            value => 'WHERE JOB_ID = ''' || job_id || '''',
                    table_name => 'B2B_EXT_BUSINESS_MESSAGE'        
        );          


    DBMS_DATAPUMP.DATA_FILTER(
            handle => h1, 
            name => 'SUBQUERY', 
            value => 'WHERE JOB_ID = ''' || job_id || '''',
                    table_name => 'B2B_APP_MESSAGE'        
        );          

    DBMS_DATAPUMP.DATA_FILTER(
            handle => h1, 
            name => 'SUBQUERY', 
            value => 'WHERE JOB_ID = ''' || job_id || '''',
                    table_name => 'B2B_WIRE_MESSAGE'        
        );          

    DBMS_DATAPUMP.DATA_FILTER(
            handle => h1, 
            name => 'SUBQUERY', 
            value => 'WHERE JOB_ID = ''' || job_id || '''',
                    table_name => 'B2B_DATA_STORAGE'        
        );          


/*
 Start the job. An exception will be generated if something is not set up
 properly. 
*/

  DBMS_DATAPUMP.START_JOB(h1);

/*
 The export job should now be running. In the following loop, the job
 is monitored until it completes. In the meantime, progress information is
 displayed.
*/
 
  percent_done := 0;
  job_state := 'UNDEFINED';
  while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop
    dbms_datapump.get_status(h1,
           dbms_datapump.ku$_status_job_error +
           dbms_datapump.ku$_status_job_status +
           dbms_datapump.ku$_status_wip,-1,job_state,sts);
    js := sts.job_status;

/* If the percentage done changed, display the new value. */

    if js.percent_done != percent_done
    then
      dbms_output.put_line('*** Job percent done = ' ||
                           to_char(js.percent_done));
      percent_done := js.percent_done;
    end if;

/*
 If any work-in-progress (WIP) or error messages were received for the job,
 display them.
*/

   if (bitand(sts.mask,dbms_datapump.ku$_status_wip) != 0)
    then
      le := sts.wip;
    else
      if (bitand(sts.mask,dbms_datapump.ku$_status_job_error) != 0)
      then
        le := sts.error;
      else
        le := null;
      end if;
    end if;
    if le is not null
    then
      ind := le.FIRST;
      while ind is not null loop
        dbms_output.put_line(le(ind).LogText);
        ind := le.NEXT(ind);
      end loop;
    end if;
  end loop;

/* Indicate that the job finished and detach from it. */

  dbms_output.put_line('Job has completed');
  dbms_output.put_line('Final job state = ' || job_state);
  dbms_datapump.detach(h1);
END B2B_EXPORT_JOB;
/

-- oracle----------------------------------------------------------------------- 
-- Restore data from Datapump archive 

REM =======================
REM Import
REM =======================

CREATE OR REPLACE PROCEDURE B2B_RESTORE_PROCEDURE 
  (filename in varchar2, source_schema in varchar2 default null, target_schema in varchar2 default null)  AS
   l_handle    NUMBER;     -- not used
   ind NUMBER;              -- Loop index
   log_file VARCHAR2(100);  -- log file name derived from filename
  h1 NUMBER;               -- Data Pump job handle
  percent_done NUMBER;     -- Percentage of job complete
  job_state VARCHAR2(30);  -- To keep track of job state
  le ku$_LogEntry;         -- For WIP and error messages
  js ku$_JobStatus;        -- The job status from get_status
  jd ku$_JobDesc;          -- The job description from get_status
  sts ku$_Status;          -- The status object returned by get_status
BEGIN

log_file := filename || '.log';

dbms_output.put_line('disabling constraints');
B2B_CHANGE_STATUS_CONSTRAINTS('DISABLE');
dbms_output.put_line('disabling constraints - done');


l_handle := DBMS_DATAPUMP.open(
        operation => 'IMPORT',
        job_mode => 'TABLE',
        job_name => 'IMPORT11');
        
        
        DBMS_DATAPUMP.add_file(
        handle => l_handle,
        filename => filename,
        directory => 'B2B_IMPORT_DIR'
        );     
        
DBMS_DATAPUMP.add_file(
        handle => l_handle,
        filename => log_file,
        directory => 'B2B_IMPORT_DIR',
        filetype => DBMS_DATAPUMP.KU$_FILE_TYPE_LOG_FILE
        );
  DBMS_DATAPUMP.set_parameter(
        handle => l_handle,
        name => 'TABLE_EXISTS_ACTION',
        value => 'APPEND');

        IF source_schema IS NOT NULL AND target_schema IS NOT NULL THEN
        DBMS_DATAPUMP.METADATA_REMAP(handle => l_handle, 
                            name => 'REMAP_SCHEMA', 
                            old_value => source_schema,
                            value => target_schema);
        END IF;
        
DBMS_DATAPUMP.start_job(l_handle);
-- DBMS_DATAPUMP.detach(l_handle);
-- The export job should now be running. In the following loop, the job
-- is monitored until it completes. In the meantime, progress information is
-- displayed.
 
  percent_done := 0;
  job_state := 'UNDEFINED';
  while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop
    dbms_datapump.get_status(l_handle,
           dbms_datapump.ku$_status_job_error +
           dbms_datapump.ku$_status_job_status +
           dbms_datapump.ku$_status_wip,-1,job_state,sts);
    js := sts.job_status;

-- If the percentage done changed, display the new value.

    if js.percent_done != percent_done
    then
      dbms_output.put_line('*** Job percent done = ' ||
                           to_char(js.percent_done));
      percent_done := js.percent_done;
    end if;

-- If any work-in-progress (WIP) or error messages were received for the job,
-- display them.

   if (bitand(sts.mask,dbms_datapump.ku$_status_wip) != 0)
    then
      le := sts.wip;
    else
      if (bitand(sts.mask,dbms_datapump.ku$_status_job_error) != 0)
      then
        le := sts.error;
      else
        le := null;
      end if;
    end if;
    if le is not null
    then
      ind := le.FIRST;
      while ind is not null loop
        dbms_output.put_line(le(ind).LogText);
        ind := le.NEXT(ind);
      end loop;
    end if;
  end loop;

-- Indicate that the job finished and detach from it.

  dbms_output.put_line('Job has completed');
  dbms_output.put_line('Final job state = ' || job_state);
  dbms_datapump.detach(l_handle);
  
  
-- Now Enable the constraints
 dbms_output.put_line('Enabling constraints');
 B2B_CHANGE_STATUS_CONSTRAINTS('ENABLE');
dbms_output.put_line('Enabling constraints - done');
EXCEPTION
 WHEN OTHERS THEN
 dbms_output.put_line('Error: ' || SQLERRM);
 dbms_output.put_line('Enabling constraints');
 B2B_CHANGE_STATUS_CONSTRAINTS('ENABLE');
dbms_output.put_line('Enabling constraints - done');
  dbms_datapump.detach(l_handle);

END B2B_RESTORE_PROCEDURE;
/

-- oracle----------------------------------------------------------------------- 
-- Archive B2B data using Data Pump 

CREATE OR REPLACE PROCEDURE B2B_ARCHIVE_PROCEDURE
( 
  startdate IN DATE, 
  enddate IN DATE, 
  msgstate IN VARCHAR2,
  filename IN VARCHAR2,
  should_purge IN CHAR
) AS
str VARCHAR2(10000);
id RAW(16);
num RAW(16);
BEGIN
    str := 'SELECT bm.id, bm.payload_storage bmps, bm.ext_business_message ext, bm.wire_message w, bm.app_message a, wm.payload_storage ps, wm.packed_message pm, am.payload' || 
  ' FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am' || 
  ' WHERE bm.state = :1' || 
  ' AND to_date(bm.created, ''DD-MON-YYYY'') >= to_date('' ' || startdate || ' '', ''DD-MON-YYYY'') '|| 
  ' AND to_date(bm.created, ''DD-MON-YYYY'') <= to_date('' ' || enddate || ' '', ''DD-MON-YYYY'') + 1 '||
  ' AND bm.wire_message = wm.id (+)'  ||
  ' AND bm.app_message = am.id(+)';
  num := sys_guid();
   DBMS_OUTPUT.PUT_LINE(num);
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE dummy';

  EXCEPTION
  WHEN others THEN
    DBMS_OUTPUT.PUT_LINE('Error dropping table, ignore this error');
  END;
  
  /* create the table first with the condition 1 = 2, so that we can use variable binding during the  insert */
  EXECUTE IMMEDIATE 'CREATE TABLE dummy AS (SELECT bm.id, bm.payload_storage bmps, bm.ext_business_message ext, bm.wire_message w, bm.app_message a, wm.payload_storage ps, wm.packed_message pm, am.payload
   FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am
   WHERE 1 = 2
   AND bm.wire_message = wm.id (+)
   AND bm.app_message = am.id(+))';

   /* insert using variable binding. msgstate is assigned to :1 */
   EXECUTE IMMEDIATE 'INSERT INTO dummy ' || str using msgstate;

  EXECUTE IMMEDIATE 'UPDATE b2b_business_message SET job_id = ''' || num || ''' where id IN (SELECT id from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_ext_business_message SET job_id = ''' || num || ''' where id IN (SELECT ext from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_wire_message SET job_id = ''' || num ||  ''' where id IN (SELECT w from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_app_message SET job_id = ''' || num || ''' where id IN (SELECT a from dummy)';
  
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT ps from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT pm from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT payload from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT bmps from dummy)';
  
  DBMS_OUTPUT.PUT_LINE('Calling export job');
  
  b2b_export_job(filename, num);
  
  IF should_purge = 'Y' THEN
  DBMS_OUTPUT.PUT_LINE('Calling purge');
  B2B_CHANGE_STATUS_CONSTRAINTS('DISABLE');
  EXECUTE IMMEDIATE 'DELETE b2b_data_storage WHERE job_id = ''' || num || ''' ';
  EXECUTE IMMEDIATE 'DELETE b2b_data_storage WHERE job_id = ''' || num || ''' ';
  EXECUTE IMMEDIATE 'DELETE b2b_data_storage WHERE job_id = ''' || num || ''' ';
  EXECUTE IMMEDIATE 'DELETE b2b_data_storage WHERE job_id = ''' || num || ''' ';
  EXECUTE IMMEDIATE 'DELETE b2b_app_message WHERE job_id = ''' || num || ''' ';
  EXECUTE IMMEDIATE 'DELETE b2b_wire_message WHERE job_id = ''' || num ||  ''' ';
  
  EXECUTE IMMEDIATE 'DELETE b2b_ext_business_message WHERE job_id = ''' || num || ''' ';
  EXECUTE IMMEDIATE 'DELETE b2b_business_message WHERE job_id = ''' || num || ''' ';
  
  B2B_CHANGE_STATUS_CONSTRAINTS('ENABLE');
  
    DBMS_OUTPUT.PUT_LINE('Calling purge done');
    ELSE
    DBMS_OUTPUT.PUT_LINE('Not Calling purge');
  END IF;
  
END B2B_ARCHIVE_PROCEDURE;
/

-- oracle----------------------------------------------------------------------- 
-- Archive using Data Pump PS5 onwards. With more options 

create or replace PROCEDURE B2B_ARCHIVE_INST_MSGS_PS5(
                                   p_startDate in varchar2
                                  ,p_endDate in varchar2
                                  ,p_msgState in varchar2 
                                  ,p_tpName in varchar2 
                                  ,p_direction in varchar2 
                                  ,p_msgType in varchar2 
                                  ,p_tpaName in varchar2 
                                  ,p_idType in varchar2 
                                  ,p_idVal in varchar2 
                                  ,p_action in varchar2
                                  ,p_service in varchar2   
                                  ,p_docType in varchar2 
                                  ,filename IN VARCHAR2  
    ) AS
    
     /* This procedure is deprecated and will be removed in forthcoming release.
      * Please use B2B_PURGE.ARCHIVE_INSTANCE_MSGS() instead.
      */  
      
    str VARCHAR2(10000);
    firstCond varchar2(10);
    num RAW(16);
    safestate VARCHAR2(100);
    BEGIN
    firstCond := 'true';
    /*    safestate := sys.dbms_assert.enquote_name(REPLACE(msgstate, '''',''''''), FALSE); */
      str := 'SELECT bm.id, bm.payload_storage bmps, bm.ext_business_message ext, bm.wire_message w, bm.app_message a, wm.payload_storage ps, wm.packed_message pm, am.payload '||
           ' FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am '||
           'WHERE  ' ;
           
           if ((p_startDate is not null) AND (p_endDate is not null)) then
              if firstCond='true' then
              begin
                                 
                str := str || '  bm.created between to_date( :1  , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( :2 , ''YYYY-MM-DD HH24:MI:SS'')'	;
                firstCond := 'false';
              end;
              else
                str := str || ' AND  bm.created between to_date( :1 , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( :2 , ''YYYY-MM-DD HH24:MI:SS'')'	;
              end if ;
           else 
    	    if firstCond='true' then
    	       begin
    	       str := str || '(1=1 or :1 is null) and (1=1 or :2 is null)';
    	      firstCond := 'false';
    	       end;
    	    else
    	       str := str || 'and (1=1 or :1 is null) and (1=1 or :2 is null)';
    	    end if ;
    
          end if;
          
        if p_msgState is not null then
    /*        DBMS_OUTPUT.PUT_LINE('inside msgState'); */
    
              if firstCond='true' then
              begin
                str := str || '  bm.STATE = :3 ';
                firstCond := 'false';
              end;
              else
                str := str || ' AND  bm.STATE = :3 ';
               
              end if;
             
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :3 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :3 is null)';
             end if  ;   
        end if  ;   
        
         if p_tpName is not null then
              if firstCond='true' then
              begin
                str := str || '( bm.sender_name = :4 )';
                firstCond := 'false';
              end;
              else
                str := str || ' AND  (  bm.sender_name = :4 )';
              end if;
              
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :4 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :4 is null)';
             end if ;              
         end if ;
    
        if p_direction is not null then
              if firstCond='true' then
              begin
                str := str || '  bm.DIRECTION = :5 ';
                firstCond := 'false';
              end;
              else
                str := str || ' AND  bm.DIRECTION = :5 ';
              end if;
        else
        
                 if firstCond='true' then
                    begin
                    str := str || '(1=1 or :5 is null)';
                    firstCond := 'false';
                    end;
                 else
                    str := str || 'and (1=1 or :5 is null)';
                 end if  ;             
    
        end if  ;   
    
     
    
        if p_msgType is not null then
              if firstCond='true' then
                begin
                  str := str || '  bm.MESSAGE_TYPE  =:6  ';
                  firstCond := 'false';
                end;
              else
                 str := str || ' AND bm.MESSAGE_TYPE  =:6  ';
              end if;
        else
             if firstCond='true' then
                begin
                str := str || '(1=1 or :6 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :6 is null)';
             end if;       
        end if;         
    
        if p_tpaName is not null then
              if firstCond='true' then
                begin
                str := str  || '  bm.tpa_name  = :7  ';
                  firstCond := 'false';
                end;
              else
                          str := str  || ' AND  bm.tpa_name  = :7  ';
    
              end if ;  
        else
             if firstCond='true' then
                begin
                str := str || '(1=1 or :7 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :7 is null)';
             end if ;                  
        end if;  
        
        if p_idType is not null then
              if firstCond='true' then
                begin
                  str := str || ' ( bm.SENDER_ID_TYPE  =:8   )';
                  firstCond := 'false';
                end;
              else
                 str := str || ' AND ( bm.SENDER_ID_TYPE  =:8   )';
              end if;
             
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :8 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :8 is null)';
             end if ;              
        end if;         
        if p_idVal is not null then
              if firstCond='true' then
                begin
                  str := str || ' ( bm.SENDER_ID_VALUE  =:9  )';
                  firstCond := 'false';
                end;
              else
                 str := str || ' AND ( bm.SENDER_ID_VALUE  =:9   )';
              end if;
              
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :9 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :9 is null)';
             end if ;              
        end if;        
                    
           
        if p_docType is not null then
              if firstCond='true' then
                begin
                  str := str || ' ( bm.DOCTYPE_NAME  =:10  )';
                  firstCond := 'false';
                end;
              else
                 str := str || ' AND ( bm.DOCTYPE_NAME  =:10   )';
              end if;
              
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :10 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :10 is null)';
             end if ;              
        end if;        
           
        if p_action is not null then
              if firstCond='true' then
                begin
                  str := str || ' ( bm.attribute2  =:11  )';
                  firstCond := 'false';
                end;
              else
                 str := str || ' AND ( bm.attribute2  =:11   )';
              end if;
              
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :11 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :11 is null)';
             end if ;              
        end if;    
        
        if p_service is not null then
              if firstCond='true' then
                begin
                  str := str || ' ( bm.attribute2  =:12  )';
                  firstCond := 'false';
                end;
              else
                 str := str || ' AND ( bm.attribute2  =:12   )';
              end if;
              
        else
            
             if firstCond='true' then
                begin
                str := str || '(1=1 or :12 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :12 is null)';
             end if ;              
        end if;  
    	
        if firstCond='true' then
          begin
              str := str   || ' bm.wire_message = wm.id (+)'
              || ' AND bm.app_message = am.id (+)';
          end;
        else
          begin 
              str := str   || ' AND bm.wire_message = wm.id (+)'
              || ' AND bm.app_message = am.id (+)';
          end;
        end if;
              
      num := sys_guid();
       DBMS_OUTPUT.PUT_LINE(num);
       DBMS_OUTPUT.PUT_LINE(str);
      BEGIN
        EXECUTE IMMEDIATE 'DROP TABLE dummy';
    
      EXCEPTION
      WHEN others THEN
        DBMS_OUTPUT.PUT_LINE('Error dropping table, ignore this error');
      END;
    /*  
      create the table first with the condition 1 = 2, so that we can use variable binding during the  insert
    */
    
    
    
      EXECUTE IMMEDIATE 'CREATE TABLE dummy AS (SELECT bm.id, bm.payload_storage bmps, bm.ext_business_message ext, bm.wire_message w, bm.app_message a, wm.payload_storage ps, wm.packed_message pm,
      am.payload FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am 
      WHERE 1=2 and  bm.wire_message = wm.id (+)  AND bm.wire_message = wm.id (+))' ;
      /* insert using variable binding. msgstate is assigned to :1, :2,:3, :4, :5, :6, :7, :8, :9 */
    
    
      EXECUTE IMMEDIATE 'INSERT INTO dummy ' || str using p_startDate, p_endDate, p_msgState, p_tpName, p_direction, p_msgType, p_tpaName, p_idType , p_idVal,p_docType,p_action, p_service;
      
      EXECUTE IMMEDIATE 'UPDATE b2b_business_message SET job_id = ''' || num || ''' where id IN (SELECT id from dummy)';
      EXECUTE IMMEDIATE 'UPDATE b2b_ext_business_message SET job_id = ''' || num || ''' where id IN (SELECT ext from dummy)';
      EXECUTE IMMEDIATE 'UPDATE b2b_wire_message SET job_id = ''' || num ||  ''' where id IN (SELECT w from dummy)';
      EXECUTE IMMEDIATE 'UPDATE b2b_app_message SET job_id = ''' || num || ''' where id IN (SELECT a from dummy)';
      
      EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT ps from dummy)';
      EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT pm from dummy)';
      EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT payload from dummy)';
      EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT bmps from dummy)';
      
      DBMS_OUTPUT.PUT_LINE('Calling export job to file name '||filename);
      
      b2b_export_job(filename, num);
     
    END B2B_ARCHIVE_INST_MSGS_PS5;
/

-- oracle----------------------------------------------------------------------- 
-- Archive using Data Pump. With more options 

CREATE OR REPLACE PROCEDURE B2B_ARCHIVE_INSTANCE_MSGS
(
                               p_startDate in varchar2
                              ,p_endDate in varchar2
                              ,p_msgState in varchar2 
                              ,p_tpName in varchar2 
                              ,p_direction in varchar2 
                              ,p_msgType in varchar2 
                              ,p_tpaName in varchar2 
                              ,p_idType in varchar2 
                              ,p_idVal in varchar2 
                              ,p_docType in varchar2 
                              ,filename IN VARCHAR2  
) 
/* This procedure is deprecated and will be removed in forthcoming release.
  * Please use B2B_PURGE.ARCHIVE_INSTANCE_MSGS() instead.
  */  

AS
str VARCHAR2(10000);
firstCond varchar2(10);
num RAW(16);
safestate VARCHAR2(100);
BEGIN
firstCond := 'true';
/*    safestate := sys.dbms_assert.enquote_name(REPLACE(msgstate, '''',''''''), FALSE); */
  str := 'SELECT bm.id, bm.payload_storage bmps, bm.ext_business_message ext, bm.wire_message w, bm.app_message a, wm.payload_storage ps, wm.packed_message pm, am.payload '||
       ' FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am '||
       'WHERE  ' ;
       
       if ((p_startDate is not null) AND (p_endDate is not null)) then
          if firstCond='true' then
          begin
                             
            str := str || '  bm.created between to_date( :1  , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( :2 , ''YYYY-MM-DD HH24:MI:SS'')' ;
            firstCond := 'false';
          end;
          else
            str := str || ' AND  bm.created between to_date( :1 , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( :2 , ''YYYY-MM-DD HH24:MI:SS'')'      ;
          end if ;
       else 
            if firstCond='true' then
               begin
               str := str || '(1=1 or :1 is null) and (1=1 or :2 is null)';
              firstCond := 'false';
               end;
            else
               str := str || 'and (1=1 or :1 is null) and (1=1 or :2 is null)';
            end if ;

      end if;
      
    if p_msgState is not null then
/*        DBMS_OUTPUT.PUT_LINE('inside msgState'); */

          if firstCond='true' then
          begin
            str := str || '  bm.STATE = :3 ';
            firstCond := 'false';
          end;
          else
            str := str || ' AND  bm.STATE = :3 ';
           
          end if;
         
    else
        
         if firstCond='true' then
            begin
            str := str || '(1=1 or :3 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :3 is null)';
         end if  ;   
    end if  ;   
    
     if p_tpName is not null then
          if firstCond='true' then
          begin
            str := str || '( bm.sender_name = :4 )';
            firstCond := 'false';
          end;
          else
            str := str || ' AND  (  bm.sender_name = :4 )';
          end if;
          
    else
        
         if firstCond='true' then
            begin
            str := str || '(1=1 or :4 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :4 is null)';
         end if ;              
     end if ;

    if p_direction is not null then
          if firstCond='true' then
          begin
            str := str || '  bm.DIRECTION = :5 ';
            firstCond := 'false';
          end;
          else
            str := str || ' AND  bm.DIRECTION = :5 ';
          end if;
    else
    
             if firstCond='true' then
                begin
                str := str || '(1=1 or :5 is null)';
                firstCond := 'false';
                end;
             else
                str := str || 'and (1=1 or :5 is null)';
             end if  ;             

    end if  ;   

 

    if p_msgType is not null then
          if firstCond='true' then
            begin
              str := str || '  bm.MESSAGE_TYPE  =:6  ';
              firstCond := 'false';
            end;
          else
             str := str || ' AND bm.MESSAGE_TYPE  =:6  ';
          end if;
    else
         if firstCond='true' then
            begin
            str := str || '(1=1 or :6 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :6 is null)';
         end if;       
    end if;         

    if p_tpaName is not null then
          if firstCond='true' then
            begin
            str := str  || '  bm.tpa_name  = :7  ';
              firstCond := 'false';
            end;
          else
                      str := str  || ' AND  bm.tpa_name  = :7  ';

          end if ;  
    else
         if firstCond='true' then
            begin
            str := str || '(1=1 or :7 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :7 is null)';
         end if ;                  
    end if;  
    
    if p_idType is not null then
          if firstCond='true' then
            begin
              str := str || ' ( bm.SENDER_ID_TYPE  =:8   )';
              firstCond := 'false';
            end;
          else
             str := str || ' AND ( bm.SENDER_ID_TYPE  =:8   )';
          end if;
         
    else
        
         if firstCond='true' then
            begin
            str := str || '(1=1 or :8 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :8 is null)';
         end if ;              
    end if;         
    if p_idVal is not null then
          if firstCond='true' then
            begin
              str := str || ' ( bm.SENDER_ID_VALUE  =:9  )';
              firstCond := 'false';
            end;
          else
             str := str || ' AND ( bm.SENDER_ID_VALUE  =:9   )';
          end if;
          
    else
        
         if firstCond='true' then
            begin
            str := str || '(1=1 or :9 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :9 is null)';
         end if ;              
    end if;        
                
       
    if p_docType is not null then
          if firstCond='true' then
            begin
              str := str || ' ( bm.DOCTYPE_NAME  =:10  )';
              firstCond := 'false';
            end;
          else
             str := str || ' AND ( bm.DOCTYPE_NAME  =:10   )';
          end if;
          
    else
        
         if firstCond='true' then
            begin
            str := str || '(1=1 or :10 is null)';
            firstCond := 'false';
            end;
         else
            str := str || 'and (1=1 or :10 is null)';
         end if ;              
    end if;        
       
    
    if firstCond='true' then
      begin
          str := str   || ' bm.wire_message = wm.id (+)'
          || ' AND bm.app_message = am.id (+)';
      end;
    else
      begin 
          str := str   || ' AND bm.wire_message = wm.id (+)'
          || ' AND bm.app_message = am.id (+)';
      end;
    end if;
          
  num := sys_guid();
   DBMS_OUTPUT.PUT_LINE(num);
   DBMS_OUTPUT.PUT_LINE(str);
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE dummy';

  EXCEPTION
  WHEN others THEN
    DBMS_OUTPUT.PUT_LINE('Error dropping table, ignore this error');
  END;
/*  
  create the table first with the condition 1 = 2, so that we can use variable binding during the  insert
*/



  EXECUTE IMMEDIATE 'CREATE TABLE dummy AS (SELECT bm.id, bm.payload_storage bmps, bm.ext_business_message ext, bm.wire_message w, bm.app_message a, wm.payload_storage ps, wm.packed_message pm,
  am.payload FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am 
  WHERE 1=2 and  bm.wire_message = wm.id (+)  AND bm.wire_message = wm.id (+))' ;
  /* insert using variable binding. msgstate is assigned to :1, :2,:3, :4, :5, :6, :7, :8, :9 */


  EXECUTE IMMEDIATE 'INSERT INTO dummy ' || str using p_startDate, p_endDate, p_msgState, p_tpName, p_direction, p_msgType, p_tpaName, p_idType , p_idVal,p_docType;
  
  EXECUTE IMMEDIATE 'UPDATE b2b_business_message SET job_id = ''' || num || ''' where id IN (SELECT id from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_ext_business_message SET job_id = ''' || num || ''' where id IN (SELECT ext from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_wire_message SET job_id = ''' || num ||  ''' where id IN (SELECT w from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_app_message SET job_id = ''' || num || ''' where id IN (SELECT a from dummy)';
  
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT ps from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT pm from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT payload from dummy)';
  EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = ''' || num || ''' where id IN (SELECT bmps from dummy)';
  
  DBMS_OUTPUT.PUT_LINE('Calling export job to file name '||filename);
  
  b2b_export_job(filename, num);
 
END B2B_ARCHIVE_INSTANCE_MSGS;
/

-- oracle----------------------------------------------------------------------- 
-- Purge Instance Data post PS5. With more options 

create or replace
    PROCEDURE B2B_PURGE_INST_MSGS_PS5(
                                   p_startDate in varchar2 default NULL
                                   ,p_endDate in varchar2 default NULL
                                   ,p_msgState in varchar2  default NULL
                                   ,p_tpName in varchar2  default NULL
                                   ,p_direction in varchar2  default NULL
                                   ,p_msgType in varchar2  default NULL
                                   ,p_tpaName in varchar2  default NULL
                                   ,p_idType in varchar2  default NULL
                                   ,p_idVal in varchar2  default NULL
    
                                   ,p_shouldArchive in varchar2
                                   ,p_force_del in varchar2 default 'false'
                                   ,p_archiveFileName in varchar2
                                   ,p_tpaId in varchar2  default NULL
                                   ,p_action in varchar2  default NULL
                                   ,p_service in varchar2  default NULL
                                   ,p_docType in varchar2  default NULL
                                   ,p_commitFrequency number default 0
                                   ) IS
           /* This procedure is deprecated and will be removed in forthcoming release.
          	* Please use B2B_PURGE.PURGE_INSTANCE_MSGS() instead.
          	*/                         
                                   
         bizid               b2b_business_message.id%TYPE;
         bizstate               b2b_business_message.state%TYPE;
         message_id               b2b_business_message.message_id%TYPE;
         payload_storage     b2b_business_message.payload_storage%TYPE;
         attachment_storage   b2b_app_message.attachment_storage%TYPE;
         native_data_storage  b2b_business_message.native_data_storage%TYPE;
         translated_data_storage b2b_business_message.translated_data_storage%TYPE;
         packed_message    b2b_wire_message.packed_message%TYPE;
         wmps              b2b_wire_message.payload_storage%TYPE;
         payload           b2b_app_message.payload%TYPE;
         amas              b2b_app_message.attachment_storage%TYPE;
         wm                b2b_business_message.WIRE_MESSAGE%TYPE;
         am                b2b_business_message.APP_MESSAGE%TYPE;
    
    l_id  VARCHAR2(256);
    ln_start number:=1;
    ln_end number:=5000;
    commitFrequency number:=ln_end;
    
    str VARCHAR2(10000);
    id RAW(16);
    num RAW(16);
    safestate VARCHAR2(100);
    tmpFileName varchar2(100);
    firstCond varchar2(10);
    myexp    exception;
    nCount    NUMBER; 
    invalidParamCode number:=-20000;
    sSQL    VARCHAR2(2000);
    
    BEGIN
    
    
         firstCond := 'true';
    
    
         if ((p_startDate is not null) AND (p_endDate is not null)) then
               if firstCond='true' then
               begin
    
                 str := str || '  bm.created between to_date( '''|| p_startDate || '''  , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''||p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  bm.created between to_date( '''|| p_startDate || ''' , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''|| p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
               end if ;
    
    
           end if;
    
      if p_msgState is not null then
    /*        DBMS_OUTPUT.PUT_LINE('inside msgState'); */
    
               if firstCond='true' then
               begin
                 str := str || '  bm.STATE = '''|| p_msgState || ''' ';
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  bm.STATE = '''|| p_msgState || ''' ';
    
               end if;
    
         end if  ;
    
          if p_tpName is not null then
               if firstCond='true' then
               begin
                 str := str || '( bm.sender_name = '''|| p_tpName || ''' )';
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  (  bm.sender_name ='''|| p_tpName || ''' )';
               end if;
    
          end if ;
    
         if p_direction is not null then
               if firstCond='true' then
               begin
                 str := str || '  bm.DIRECTION = '''|| p_direction || ''' ';
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  bm.DIRECTION = '''|| p_direction || ''' ';
               end if;
    
    
         end if  ;
    
    
    
         if p_msgType is not null then
               if firstCond='true' then
                 begin
                   str := str || '  bm.MESSAGE_TYPE  ='''|| p_msgType || ''' ';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND bm.MESSAGE_TYPE  = '''|| p_msgType || '''  ';
               end if;
    
         end if;
    
         if p_tpaName is not null then
               if firstCond='true' then
                 begin
                 str := str  || '  bm.tpa_name  = '''|| p_tpaName || '''  ';
                   firstCond := 'false';
                 end;
               else
                           str := str  || ' AND  bm.tpa_name  = '''|| p_tpaName || '''  ';
    
               end if ;
    
         end if;
    
         if p_tpaId is not null then
               if firstCond='true' then
                 begin
                 str := str  || '  bm.tpa_Id  = '''|| p_tpaId || '''  ';
                   firstCond := 'false';
                 end;
               else
                           str := str  || ' AND  bm.tpa_Id  = '''|| p_tpaId || '''  ';
    
               end if ;
    
         end if;
    
        -- Added parameter for action for bug 11773067
         if p_action is not null then
               if firstCond='true' then
                 begin
                 str := str  || ' substr(bm.attribute2,instr(bm.attribute2,' || ' ''#:#'' ' || ')+3)  = '''|| p_action || '''  ';
                   firstCond := 'false';
                 end;
               else
                          str := str  || ' AND  substr(bm.attribute2,instr(bm.attribute2,' || ' ''#:#'' ' || ')+3)  = '''|| p_action || '''  ';
    
               end if ;
    
         end if;
         
    	 -- Added parameter for service for bug 11773067
         if p_service is not null then
               if firstCond='true' then
                 begin
                 str := str  || '  substr(bm.attribute2,1,instr(bm.attribute2,' || ' ''#:#'' ' || ')-1) = '''|| p_service || '''  ';
                   firstCond := 'false';
                 end;
               else
                           str := str  || ' AND  substr(bm.attribute2,1,instr(bm.attribute2,' || ' ''#:#'' ' || ')-1) = '''|| p_service || '''  ';
    
               end if ;
    
         end if;
    
    
         if p_idType is not null then
               if firstCond='true' then
                 begin
                   str := str || ' ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
               end if;
    
    
         end if;
         if p_idVal is not null then
               if firstCond='true' then
                 begin
                   str := str || ' ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''  )';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''   )';
               end if;
    
         end if;
         if p_docType is not null then
               if firstCond='true' then
                 begin
                   str := str || ' ( bm.DOCTYPE_NAME  ='''|| p_docType || '''  )';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND ( bm.DOCTYPE_NAME  ='''|| p_docType || '''   )';
               end if;
    
         end if;     
              if firstCond='true' then
               begin
                  str := str || '  bm.wire_message = wm.id (+)
                 AND bm.ext_business_message = ext.id (+)
                 AND bm.app_message = am.id (+) ';
              end;
             else
               begin
                  str := str ||' AND  bm.wire_message = wm.id (+)
                 AND bm.ext_business_message = ext.id (+)
                 AND bm.app_message = am.id (+) ';
               end;
             end if;
    
           
         
    
    
           DBMS_OUTPUT.PUT_LINE(str);
    
    
    
               if p_shouldArchive = 'true' then
    
           dbms_output.put_line('===========' ||  str  );
           tmpFileName := p_archiveFileName;
    
           if tmpFileName is  null then
             tmpFileName :=  to_char(sysdate, 'DD-Mon-YYYY-HH24:MI:SS');
             tmpFileName := tmpFileName || '.dmp';
           end if;
    
             B2B_ARCHIVE_INST_MSGS_PS5(p_startDate,p_endDate ,p_msgState ,p_tpName ,p_direction ,p_msgType ,p_tpaName ,p_action,p_service,p_idType ,p_idVal,p_docType,tmpFileName);
         end if ;
    
    
      BEGIN
                 EXECUTE IMMEDIATE 'DROP TABLE b2b_temp';
             
               EXCEPTION
               WHEN others THEN
                 DBMS_OUTPUT.PUT_LINE('Error dropping table, ignore this error');
        END;
        
        EXECUTE IMMEDIATE 'CREATE TABLE b2b_temp AS (SELECT  rownum row_number, bm.id, bm.state, bm.message_id, bm.ext_business_message ext, bm.payload_storage, bm.attachment_storage, bm.native_data_storage,
                            bm.translated_data_storage, bm.WIRE_MESSAGE,bm.APP_MESSAGE, wm.packed_message, wm.payload_storage wmps, am.payload, am.attachment_storage amas
        			FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext WHERE '||str||')' ;
              
              
        sSQL:= 'SELECT COUNT(rowid) from b2b_temp';      
              
    
        LOOP
        
        	EXECUTE IMMEDIATE 'DELETE from b2b_data_storage WHERE id in 
        			  (
        			  select payload_storage from b2b_temp where row_number between '||ln_start|| ' and ' ||ln_end|| 
        			  'union all  
        			  select packed_message from b2b_temp where row_number between '||ln_start|| ' and '|| ln_end||
        			  'union all
        			  select payload from b2b_temp where row_number between '||ln_start ||' and '|| ln_end||
        			  'union all
        			  select wmps from b2b_temp where row_number between '||ln_start||' and '||ln_end||
        			  'union all
        			  select native_data_storage from b2b_temp where row_number between '||ln_start||' and '||ln_end||
        			  'union all
        			  select translated_data_storage from b2b_temp where row_number between '||ln_start||' and '||ln_end||
        			  'union all
        			  select attachment_storage from b2b_temp where row_number between '||ln_start||' and '||ln_end||')'; 
        	
        		EXECUTE IMMEDIATE 'DELETE from b2b_sequence_manager WHERE b2b_sequence_manager.message_id in (select message_id from b2b_temp where row_number between '|| ln_start ||' and '|| ln_end||')';
        		EXECUTE IMMEDIATE 'DELETE from b2b_app_message WHERE id in (select app_message from b2b_temp where row_number between '|| ln_start ||' and '|| ln_end||')';
        		EXECUTE IMMEDIATE 'DELETE from b2b_wire_message WHERE id in (select wire_message from b2b_temp where row_number between '||ln_start ||' and '||ln_end||')';
        		EXECUTE IMMEDIATE 'DELETE from b2b_ext_business_message WHERE id in (select ext from b2b_temp where row_number between '||ln_start||' and '||ln_end||')';
        		EXECUTE IMMEDIATE 'DELETE from b2b_business_message WHERE id in (select id from b2b_temp where row_number between '||ln_start||' and '||ln_end||')';
        		EXECUTE IMMEDIATE 'DELETE from b2b_temp where row_number between '||ln_start||' and '||ln_end; 
        		  
        	 nCount:= sql%rowcount;
        	commit;  
        	
        		  EXIT WHEN nCount = 0;
        	ln_start :=ln_end + 1;
        	ln_end := ln_start + (commitFrequency -1);
        	
          END LOOP;
        
        
           EXCEPTION
        
              WHEN myexp then
                  rollback;
        	  dbms_output.put_line('tpName is provided without direction.');
        
              WHEN OTHERS THEN
                 ROLLBACK;
                 RAISE;
    END B2B_PURGE_INST_MSGS_PS5;
/

-- oracle----------------------------------------------------------------------- 
-- Purge Instance Data. With more options 

CREATE OR REPLACE PROCEDURE B2B_PURGE_INSTANCE_MSGS
(
                               p_startDate in varchar2 default NULL
                               ,p_endDate in varchar2 default NULL
                               ,p_msgState in varchar2  default NULL
                               ,p_tpName in varchar2  default NULL
                               ,p_direction in varchar2  default NULL
                               ,p_msgType in varchar2  default NULL
                               ,p_tpaName in varchar2  default NULL
                               ,p_idType in varchar2  default NULL
                               ,p_idVal in varchar2  default NULL
                               ,p_docType in varchar2  default NULL
                               ,p_shouldArchive in varchar2
                               ,p_force_del in varchar2 default 'false'
                               ,p_archiveFileName in varchar2
                               ,p_tpaId in varchar2  default NULL ) IS
                               
 /* This procedure is deprecated and will be removed in forthcoming release.
   * Please use B2B_PURGE.PURGE_INSTANCE_MSGS() instead.
   */                                

b2b_refcur      SYS_REFCURSOR;


     bizid               b2b_business_message.id%TYPE;
     bizstate               b2b_business_message.state%TYPE;
     message_id               b2b_business_message.message_id%TYPE;
     payload_storage     b2b_business_message.payload_storage%TYPE;
     attachment_storage   b2b_app_message.attachment_storage%TYPE;
     native_data_storage  b2b_business_message.native_data_storage%TYPE;
     translated_data_storage b2b_business_message.translated_data_storage%TYPE;
     packed_message    b2b_wire_message.packed_message%TYPE;
     wmps              b2b_wire_message.payload_storage%TYPE;
     payload           b2b_app_message.payload%TYPE;
     amas              b2b_app_message.attachment_storage%TYPE;

l_id  VARCHAR2(256);

str VARCHAR2(10000);
id RAW(16);
num RAW(16);
safestate VARCHAR2(100);
tmpFileName varchar2(100);
firstCond varchar2(10);
BEGIN

/*
     firstCond := 'true';


     if ((p_startDate is not null) AND (p_endDate is not null)) then
           if firstCond='true' then
           begin

             str := str || '  bm.created between to_date( '''|| p_startDate || '''  , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''||p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
             firstCond := 'false';
           end;
           else
             str := str || ' AND  bm.created between to_date( '''|| p_startDate || ''' , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''|| p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
           end if ;


       end if;

  if p_msgState is not null then

           if firstCond='true' then
           begin
             str := str || '  bm.STATE = '''|| p_msgState || ''' ';
             firstCond := 'false';
           end;
           else
             str := str || ' AND  bm.STATE = '''|| p_msgState || ''' ';

           end if;

     end if  ;

      if p_tpName is not null then
           if firstCond='true' then
           begin
             str := str || '( bm.sender_name = '''|| p_tpName || ''' )';
             firstCond := 'false';
           end;
           else
             str := str || ' AND  (  bm.sender_name ='''|| p_tpName || ''' )';
           end if;

      end if ;

     if p_direction is not null then
           if firstCond='true' then
           begin
             str := str || '  bm.DIRECTION = '''|| p_direction || ''' ';
             firstCond := 'false';
           end;
           else
             str := str || ' AND  bm.DIRECTION = '''|| p_direction || ''' ';
           end if;


     end if  ;



     if p_msgType is not null then
           if firstCond='true' then
             begin
               str := str || '  bm.MESSAGE_TYPE  ='''|| p_msgType || ''' ';
               firstCond := 'false';
             end;
           else
              str := str || ' AND bm.MESSAGE_TYPE  = '''|| p_msgType || '''  ';
           end if;

     end if;

     if p_tpaName is not null then
           if firstCond='true' then
             begin
             str := str  || '  bm.tpa_name  = '''|| p_tpaName || '''  ';
               firstCond := 'false';
             end;
           else
                       str := str  || ' AND  bm.tpa_name  = '''|| p_tpaName || '''  ';

           end if ;

     end if;

     if p_tpaId is not null then
           if firstCond='true' then
             begin
             str := str  || '  bm.tpa_Id  = '''|| p_tpaId || '''  ';
               firstCond := 'false';
             end;
           else
                       str := str  || ' AND  bm.tpa_Id  = '''|| p_tpaId || '''  ';

           end if ;

     end if;

     if p_idType is not null then
           if firstCond='true' then
             begin
               str := str || ' ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
               firstCond := 'false';
             end;
           else
              str := str || ' AND ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
           end if;


     end if;
     if p_idVal is not null then
           if firstCond='true' then
             begin
               str := str || ' ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''  )';
               firstCond := 'false';
             end;
           else
              str := str || ' AND ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''   )';
           end if;

     end if;
     if p_docType is not null then
           if firstCond='true' then
             begin
               str := str || ' ( bm.DOCTYPE_NAME  ='''|| p_docType || '''  )';
               firstCond := 'false';
             end;
           else
              str := str || ' AND ( bm.DOCTYPE_NAME  ='''|| p_docType || '''   )';
           end if;

     end if;     
          if firstCond='true' then
           begin
              str := str || '  bm.wire_message = wm.id (+)
             AND bm.ext_business_message = ext.id (+)
             AND bm.app_message = am.id (+) ';
          end;
         else
           begin
              str := str ||' AND  bm.wire_message = wm.id (+)
             AND bm.ext_business_message = ext.id (+)
             AND bm.app_message = am.id (+) ';
           end;
         end if;

       DBMS_OUTPUT.PUT_LINE(str);
        open b2b_refcur for

     'SELECT  bm.id, bm.state, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage,
                  bm.translated_data_storage, wm.packed_message, wm.payload_storage wmps, am.payload, am.attachment_storage amas
        FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
        WHERE '  || str        ;
*/

open b2b_refcur for

'SELECT  bm.id, bm.state, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage,
	  bm.translated_data_storage, wm.packed_message, wm.payload_storage wmps, am.payload, am.attachment_storage amas
	  FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
	  WHERE (:a is null or :b is null or bm.created between
	  	to_date(:c, ''YYYY-MM-DD HH24:MI:SS'') and to_date(:d, ''YYYY-MM-DD HH24:MI:SS''))  
	  	 and (:e is null or bm.state = :f) 
	  	  and (:g is null or bm.sender_name = :h)
	  	   and (:i is null or bm.DIRECTION = :j)
	  	    and (:k is null or bm.MESSAGE_TYPE = :l)
	  	     and (:m is null or bm.tpa_name = :n)
	  	      and (:o is null or bm.tpa_Id = :p)
	  	       and (:q is null or bm.SENDER_ID_TYPE = :r)
	  	        and (:s is null or bm.SENDER_ID_VALUE = :t)
	  	         and (:u is null or bm.DOCTYPE_NAME = :v)
	  	          AND  bm.wire_message = wm.id (+)
	  	               AND bm.ext_business_message = ext.id (+)
	  	                    AND bm.app_message = am.id (+)
	  	                     '  using   p_startDate,p_endDate,p_startDate,p_endDate,p_msgState,p_msgState 
	  	                      ,p_tpName,p_tpName ,p_direction,p_direction ,p_msgType ,p_msgType,p_tpaName,p_tpaName,p_tpaId,p_tpaId
	  	                       ,p_idType,p_idType ,p_idVal,p_idVal ,p_docType ,p_docType  ;



       DBMS_OUTPUT.PUT_LINE(str);



           if p_shouldArchive = 'true' then

       dbms_output.put_line('===========' ||  str  );
       tmpFileName := p_archiveFileName;

       if tmpFileName is  null then
         tmpFileName :=  to_char(sysdate, 'DD-Mon-YYYY-HH24:MI:SS');
         tmpFileName := tmpFileName || '.dmp';
       end if;

         B2B_ARCHIVE_INSTANCE_MSGS(p_startDate,p_endDate ,p_msgState ,p_tpName ,p_direction ,p_msgType ,p_tpaName ,p_idType ,p_idVal,p_docType,tmpFileName);
     end if ;


  LOOP




  FETCH b2b_refcur INTO bizid, bizstate, message_id, payload_storage,
attachment_storage, native_data_storage, translated_data_storage,
packed_message, wmps, payload, amas;

DELETE FROM b2b_data_storage WHERE id in( payload_storage,packed_message);
       DELETE FROM b2b_data_storage WHERE id in(wmps,native_data_storage,translated_data_storage);
       DELETE FROM b2b_data_storage WHERE id in( attachment_storage,payload);

                                 

/*   DBMS_OUTPUT.PUT_LINE('Dheeraj ' || payload_storage); */

      IF MOD(b2b_refcur%ROWCOUNT, 1000) = 0 THEN 
        COMMIT;
      END IF;
 

    EXIT WHEN b2b_refcur%NOTFOUND;
    END LOOP;
CLOSE b2b_refcur;
   COMMIT;

    
    /* Bug#8438439 */
    /*
     There could be entries in b2b_wiremessage table for which there are
     no corresponding entries in b2b_business_message table. Such entries
     would not get deleted in delete operation occuring above through b2b_cur
     cursor. We are deleting such entries here.
    
    */

/*
 *   for i in (
 *     select payload_storage, packed_message
 *     from b2b_wire_message wm
 *     where
 *     wm.created >= to_date(p_startDate, 'YYYY-MM-DD HH24:MI:SS')
 *        AND wm.created <= to_date(p_endDate, 'YYYY-MM-DD HH24:MI:SS') AND
 *             wm.created between nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),  nvl((select min(created) from b2b_wire_message),sysdate))
 *                        AND nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),    nvl((select max(created) from b2b_wire_message),sysdate))
 *      AND wm.state like nvl(p_msgState,'%')
 *  )
 *  loop
 *    DELETE FROM b2b_data_storage where id = i.payload_storage;
 *    DELETE FROM b2b_data_storage where id = i.packed_message;
 *
 *  end loop;
 *
 *
 *  COMMIT;


     * There could be entries in b2b_app_message table for which there are
     * no corresponding entries in b2b_business_message table. Such entries
     * would not get deleted in delete operation occuring above through b2b_cur
     * cursor. We are deleting such entries here.
     *
 *   for i in (
 *     select payload, attachment_storage
 *     from b2b_app_message am
 *     where
 *     am.created >= to_date(p_startDate, 'YYYY-MM-DD HH24:MI:SS')
 *        AND am.created <= to_date(p_endDate, 'YYYY-MM-DD HH24:MI:SS') AND
 *        am.created between nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),  nvl((select min(created) from b2b_app_message),sysdate))
 *                        AND nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),    nvl((select max(created) from b2b_app_message),sysdate))
 *     AND am.state like nvl(p_msgState,'%')
 *  )
 *  loop
 *    DELETE FROM b2b_data_storage where id in (i.payload, i.attachment_storage);
 *  end loop;
 *
 *  COMMIT;
 */


   EXCEPTION
      WHEN OTHERS THEN
         ROLLBACK;
         RAISE;
END B2B_PURGE_INSTANCE_MSGS;
/

-- oracle----------------------------------------------------------------------- 
-- Data based purge runtime 

/*
 * purge all runtime messages between the startDate, endDate and of a givenState
 */
CREATE OR REPLACE PROCEDURE purge_runtime 
(startDate IN DATE, endDate IN DATE, givenState IN VARCHAR2)  AS

/* This procedure is deprecated and will be removed in forthcoming release.
 * Please use B2B_PURGE.PURGE_INSTANCE_MSGS() instead.
 */ 
 
   CURSOR b2b_cur IS
       SELECT bm.id, bm.state, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage, 
              bm.translated_data_storage,
              wm.packed_message, wm.payload_storage wmps,  
              am.payload, am.attachment_storage amas
       FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
       WHERE                                                            
       TRUNC(bm.created) BETWEEN TRUNC(startDate) AND TRUNC(endDate) AND 
       bm.state = givenState AND
       bm.wire_message = wm.id (+)
       AND bm.ext_business_message = ext.id (+)
       AND bm.app_message = am.id (+);

BEGIN

   FOR b2b_rec IN b2b_cur
   LOOP
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.payload_storage; 
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.attachment_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.native_data_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.translated_data_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.packed_message;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.wmps;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.payload;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.amas;
      IF b2b_rec.state='MSG_WAIT_BATCH' THEN
        DELETE FROM b2b_pending_message where message_id = b2b_rec.message_id;
      END IF;

      IF MOD(b2b_cur%ROWCOUNT, 1000) = 0 THEN 
        COMMIT;
      END IF;

   END LOOP;

  COMMIT;

   /*
    * Bug#8438439
    * There could be entries in b2b_wiremessage table for which there are
    * no corresponding entries in b2b_business_message table. Such entries
    * would not get deleted in delete operation occuring above through b2b_cur
    * cursor. We are deleting such entries here.
   /*

   for i in (
     select payload_storage, packed_message
     from b2b_wire_message wm
     where  TRUNC(wm.created) BETWEEN TRUNC(startDate) AND TRUNC(endDate) AND
     wm.state = givenState
  )
  loop
    DELETE FROM b2b_data_storage where id = i.payload_storage;
    DELETE FROM b2b_data_storage where id = i.packed_message;
  end loop;


  COMMIT;       


   /*
    * There could be entries in b2b_app_message table for which there are
    * no corresponding entries in b2b_business_message table. Such entries
    * would not get deleted in delete operation occuring above through b2b_cur
    * cursor. We are deleting such entries here.
    */
   for i in (
     select payload, attachment_storage
     from b2b_app_message am
     where  TRUNC(am.created) BETWEEN TRUNC(startDate) AND TRUNC(endDate) AND
     am.state = givenState
  )
  loop
    DELETE FROM b2b_data_storage where id = i.payload;
    DELETE FROM b2b_data_storage where id = i.attachment_storage;
  end loop;

  COMMIT;


  EXCEPTION
     WHEN OTHERS THEN
        ROLLBACK;
        RAISE;
END;
/

-- oracle----------------------------------------------------------------------- 
-- called for debugging 

CREATE OR REPLACE PROCEDURE b2b_debug_purge 
(table_name IN VARCHAR2, before_after IN VARCHAR2) AS
    stmt  VARCHAR2(300);
    rowcount  NUMBER;
BEGIN
$IF $$debug_on $THEN

IF before_after = 'After'
THEN
     DBMS_OUTPUT.put_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || ' Purged is : ' || SQL%ROWCOUNT);
ELSE
     stmt := 'SELECT COUNT(*) FROM TABLE_NAME';
     stmt := REPLACE(stmt,'TABLE_NAME',table_name);
     execute immediate stmt into rowcount;
     DBMS_OUTPUT.put_line(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' Number of rows in table ' || table_name || ' ' || before_after || ' Purge is : ' || rowcount);
END IF;
$ELSE
    null;
$END

END b2b_debug_purge;
/

-- oracle----------------------------------------------------------------------- 
-- Called by SOA Purge 

CREATE OR REPLACE PROCEDURE purge_runtime_with_timeout 
(p_lower_band IN DATE, p_upper_band IN DATE, givenState IN VARCHAR2, p_rownum NUMBER default 1000, p_stop_time INTEGER default NULL)  AS
  v_counter NUMBER := 1;
  v_startdate timestamp := sysdate;
  v_loopstart timestamp;
  v_loopend timestamp;
  v_stoptime date := sysdate + NVL(p_stop_time,24*60)/(24*60); 
  v_nr_rows integer := 0;
  v_nextloop BOOLEAN := TRUE;
  v_timeout BOOLEAN := FALSE;
  v_code NUMBER;
  v_errm VARCHAR2(90);
  v_stmt VARCHAR2(100);
  v_sqlstmt varchar2(2000);
  v_wireState VARCHAR2(100);
  has_rows_bm_instance boolean := FALSE;
  has_rows_wm_instance boolean := FALSE;
  has_rows_am_instance boolean := FALSE;
  
/* This procedure is deprecated and will be removed in forthcoming release.
 * Please use B2B_PURGE.PURGE_INSTANCE_MSGS() instead.
 */
 
BEGIN
v_stmt := 'Start';
execute immediate 'alter session force parallel dml parallel 8';

/* before starting clean up temp tables */
EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_bm';
EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_wm';
EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_am';

/* avoid unwanted execution plans */
   execute immediate 'alter session set "_optimizer_sortmerge_join_enabled"=false';
   execute immediate 'alter session set "_optimizer_mjc_enabled"=false';
   execute immediate 'alter session set "_optimizer_cartesian_enabled"=false';
/* and set MBRC high to boost Full Table Scans */
   execute immediate 'alter session set db_file_multiblock_read_count=128';

/* here starts the loop */
v_stmt := 'Jump into Loop BM';

WHILE v_nextloop = TRUE LOOP

   v_nextloop := FALSE;
   has_rows_bm_instance := FALSE;
   dbms_output.put_line('======Start run '|| v_counter||' '|| p_rownum||' rows to delete======');

/* Populate table with information about older instances */
   v_stmt := 'Insert into b2b_purge_temp_bm';
   b2b_debug_purge('b2b_purge_temp_bm', 'Before');
insert into b2b_purge_temp_bm(bm_id, bm_message_id, bm_payload_storage, bm_attachment_storage, bm_native_data_storage, bm_translated_data_storage, wm_packed_message, wm_payload_storage, am_payload, am_attachment_storage, ext_bm_id, am_id, wm_id)        SELECT bm.id, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage, 
              bm.translated_data_storage,
              wm.packed_message, wm.payload_storage,  
              am.payload, am.attachment_storage, ext.id, am.id, wm.id
       FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
       WHERE                                                            
       TRUNC(bm.created) BETWEEN TRUNC(p_lower_band) AND TRUNC(p_upper_band) AND 
       bm.state = givenState AND
       bm.wire_message = wm.id (+)
       AND bm.ext_business_message = ext.id (+)
       AND bm.app_message = am.id (+)
       AND rownum <= p_rownum;

   b2b_debug_purge('b2b_purge_temp_bm', 'After');
   IF SQL%ROWCOUNT > 0 THEN
       has_rows_bm_instance := TRUE;
   END IF;

   IF SQL%ROWCOUNT = p_rownum THEN
       v_nextloop := TRUE ;
   END IF;

   COMMIT;

IF has_rows_bm_instance = TRUE
THEN

   v_stmt := 'delete from b2b_business_message'; 
   b2b_debug_purge('b2b_business_message', 'Before');

   for b2b_rec in (
     select bm_message_id, bm_payload_storage, bm_attachment_storage, bm_native_data_storage, bm_translated_data_storage, wm_packed_message, wm_payload_storage, am_payload, am_attachment_storage
     from b2b_purge_temp_bm 
  )
  LOOP
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.bm_payload_storage; 
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.bm_attachment_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.bm_native_data_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.bm_translated_data_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.wm_packed_message;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.wm_payload_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.am_payload;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.am_attachment_storage;
      IF givenState='MSG_WAIT_BATCH' THEN
        DELETE FROM b2b_pending_message where message_id = b2b_rec.bm_message_id;
      END IF;
  END LOOP;

   b2b_debug_purge('b2b_business_message', 'After');

   delete b2b_purge_temp_bm;

   COMMIT;

END IF;

   IF (sysdate >= v_stoptime) THEN
     v_timeout := TRUE;
     v_nextloop := FALSE;
   END IF;

v_stmt := 'End Loop BM';
END LOOP;

IF (v_timeout = FALSE) THEN
   v_stmt := 'Jump into Loop WM';
   v_nextloop := TRUE;
END IF;

WHILE v_nextloop = TRUE LOOP

   v_nextloop := FALSE;
   has_rows_wm_instance := FALSE;
   dbms_output.put_line('======Start run '|| v_counter||' '|| p_rownum||' rows to delete======');

   IF givenState = 'MSG_COMPLETE' THEN
      v_wireState := 'COMPLETE';
   ELSE IF givenState = 'MSG_ERROR' THEN
      v_wireState := 'ERROR';
   ELSE v_wireState := 'PROCESSING';
        END IF;
   END IF;

/* Populate table with information about older instances */
   v_stmt := 'Insert into b2b_purge_temp_wm';
   b2b_debug_purge('b2b_purge_temp_wm', 'Before');
insert into b2b_purge_temp_wm(wm_id, wm_payload_storage, wm_packed_message)        SELECT wm.id, wm.payload_storage, wm.packed_message 
       FROM b2b_wire_message wm
       WHERE                                                            
       TRUNC(wm.created) BETWEEN TRUNC(p_lower_band) AND TRUNC(p_upper_band) AND       wm.state = v_wireState AND
       rownum <= p_rownum;

   b2b_debug_purge('b2b_purge_temp_wm', 'After');
   IF SQL%ROWCOUNT > 0 THEN
       has_rows_wm_instance := TRUE;
   END IF;

   IF SQL%ROWCOUNT = p_rownum THEN
       v_nextloop := TRUE ;
   END IF;

   COMMIT;

IF has_rows_wm_instance = TRUE
THEN

   v_stmt := 'delete from b2b_wire_message'; 
   b2b_debug_purge('b2b_wire_message', 'Before');
   for i in (
     select wm_payload_storage, wm_packed_message
     from b2b_purge_temp_wm
  )
  loop
    DELETE FROM b2b_data_storage where id = i.wm_payload_storage;
    DELETE FROM b2b_data_storage where id = i.wm_packed_message;
  end loop;

   b2b_debug_purge('b2b_wire_message', 'After');

   delete b2b_purge_temp_wm;

   COMMIT;

END IF;


   IF (sysdate >= v_stoptime) THEN
     v_timeout := TRUE;
     v_nextloop := FALSE;
   END IF;

v_stmt := 'End Loop WM';
END LOOP;

IF (v_timeout = FALSE) THEN
   v_stmt := 'Jump into Loop AM';
   v_nextloop := TRUE;
END IF;


WHILE v_nextloop = TRUE LOOP

   v_nextloop := FALSE;
   has_rows_am_instance := FALSE;
   dbms_output.put_line('======Start run '|| v_counter||' '|| p_rownum||' rows to delete======');

/* Populate table with information about older instances */
   v_stmt := 'Insert into b2b_purge_temp_am';
   b2b_debug_purge('b2b_purge_temp_am', 'Before');
insert into b2b_purge_temp_am(am_id, am_payload, am_attachment_storage)        SELECT am.id, am.payload, am.attachment_storage
       FROM b2b_app_message am
       WHERE                                                            
       TRUNC(am.created) BETWEEN TRUNC(p_lower_band) AND TRUNC(p_upper_band) AND 
       am.state = givenState AND
       rownum <= p_rownum;

   b2b_debug_purge('b2b_purge_temp_am', 'After');
   IF SQL%ROWCOUNT > 0 THEN
       has_rows_am_instance := TRUE;
   END IF;

   IF SQL%ROWCOUNT = p_rownum THEN
       v_nextloop := TRUE ;
   END IF;

   COMMIT;

IF has_rows_wm_instance = TRUE
THEN

   for i in (
     select am_payload, am_attachment_storage
     from b2b_purge_temp_am
  )
  loop
    DELETE FROM b2b_data_storage where id = i.am_payload;
    DELETE FROM b2b_data_storage where id = i.am_attachment_storage;
  end loop;

   delete b2b_purge_temp_am;

   COMMIT;

END IF;


   IF (sysdate >= v_stoptime) THEN
     v_nextloop := FALSE;
   END IF;

v_stmt := 'End Loop AM';
END LOOP;

EXCEPTION
  when others then 
    v_code := SQLCODE;
    v_errm := SUBSTR(SQLERRM, 1 , 64);
    DBMS_OUTPUT.PUT_LINE('Error code ' || v_code || ': ' || v_errm || ' at line : ' || v_stmt);
   
END purge_runtime_with_timeout;
/

-- oracle----------------------------------------------------------------------- 
-- Called by SOA Purge 

CREATE OR REPLACE PROCEDURE purge_b2b_instances_down 
(p_lower_band DATE, p_upper_band DATE, givenState IN VARCHAR2, p_rownum NUMBER default 1000, p_stop_time INTEGER default NULL)
AS
  v_counter NUMBER := 1;
  v_startdate timestamp := sysdate;
  v_loopstart timestamp;
  v_loopend timestamp;
  v_stoptime date := sysdate + NVL(p_stop_time,24*60)/(24*60); 
  v_nr_rows integer := 0;
  v_nextloop BOOLEAN := TRUE;
  v_timeout BOOLEAN := FALSE;
  v_code NUMBER;
  v_errm VARCHAR2(90);
  v_stmt VARCHAR2(100);
  v_sqlstmt varchar2(2000);
  v_wireState VARCHAR2(100);
  has_rows_bm_instance boolean := FALSE;
  has_rows_wm_instance boolean := FALSE;
  has_rows_am_instance boolean := FALSE;

BEGIN
v_stmt := 'Start';
execute immediate 'alter session force parallel dml parallel 8';

/* before starting clean up temp tables */
EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_bm';
EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_wm';
EXECUTE IMMEDIATE 'TRUNCATE TABLE b2b_purge_temp_am';

/* avoid unwanted execution plans  */
   execute immediate 'alter session set "_optimizer_sortmerge_join_enabled"=false';
   execute immediate 'alter session set "_optimizer_mjc_enabled"=false';
   execute immediate 'alter session set "_optimizer_cartesian_enabled"=false';
/* and set MBRC high to boost Full Table Scans */
   execute immediate 'alter session set db_file_multiblock_read_count=128';

   	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_WIRE_MESSAGE',  'B2B_WM_DS_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_WIRE_MESSAGE',  'B2B_WM_PS_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_WM_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_AM_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_NDS_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_TDS_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_AS_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_EBM_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_PS_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_EXT_BUSINESS_MESSAGE',  'B2B_EBM_BM_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_APP_MESSAGE',  'B2B_AM_PAYLOAD_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_APP_MESSAGE',  'B2B_AM_BM_FK',  'DISABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_APP_MESSAGE',  'B2B_AM_AS_FK',  'DISABLE');

/* here starts the loop */
v_stmt := 'Jump into Loop BM';

WHILE v_nextloop = TRUE LOOP

   v_nextloop := FALSE;
   has_rows_bm_instance := FALSE;
   dbms_output.put_line('======Start run '|| v_counter||' '|| p_rownum||' rows to delete======');

/* Populate table with information about older instances */
   v_stmt := 'Insert into b2b_purge_temp_bm';
   b2b_debug_purge('b2b_purge_temp_bm', 'Before');
insert into b2b_purge_temp_bm(bm_id, bm_message_id, bm_payload_storage, bm_attachment_storage, bm_native_data_storage, bm_translated_data_storage, wm_packed_message, wm_payload_storage, am_payload, am_attachment_storage, ext_bm_id, am_id, wm_id)        SELECT bm.id, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage, 
              bm.translated_data_storage,
              wm.packed_message, wm.payload_storage,  
              am.payload, am.attachment_storage, ext.id, am.id, wm.id
       FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
       WHERE                                                            
       TRUNC(bm.CPST_INST_CREATED_TIME) BETWEEN TRUNC(p_lower_band) AND TRUNC(p_upper_band) AND 
       bm.state = givenState AND
       bm.wire_message = wm.id (+)
       AND bm.ext_business_message = ext.id (+)
       AND bm.app_message = am.id (+)
       AND rownum <= p_rownum;

   b2b_debug_purge('b2b_purge_temp_bm', 'After');
   IF SQL%ROWCOUNT > 0 THEN
       has_rows_bm_instance := TRUE;
   END IF;

   IF SQL%ROWCOUNT = p_rownum THEN
       v_nextloop := TRUE ;
   END IF;

   COMMIT;

IF has_rows_bm_instance = TRUE
THEN

   v_stmt := 'delete from b2b_business_message'; 
   b2b_debug_purge('b2b_business_message', 'Before');

   DELETE FROM b2b_business_message
         WHERE id in (select bm_id from b2b_purge_temp_bm);
   b2b_debug_purge('b2b_business_message', 'After');

   IF givenState='MSG_WAIT_BATCH' THEN
      DELETE FROM b2b_pending_message where message_id in (select bm_id from b2b_purge_temp_bm);
   END IF;

   v_stmt := 'delete from b2b_ext_business_message'; 
   b2b_debug_purge('b2b_ext_business_message', 'Before');

   DELETE FROM b2b_ext_business_message
         WHERE id in (select ext_bm_id from b2b_purge_temp_bm);
   b2b_debug_purge('b2b_ext_business_message', 'After');

   v_stmt := 'delete from b2b_app_message'; 
   b2b_debug_purge('b2b_app_message', 'Before');

   DELETE FROM b2b_app_message
         WHERE id in (select am_id from b2b_purge_temp_bm);
   b2b_debug_purge('b2b_app_message', 'After');

   v_stmt := 'delete from b2b_wire_message'; 
   b2b_debug_purge('b2b_wire_message', 'Before');

   DELETE FROM b2b_wire_message
         WHERE id in (select wm_id from b2b_purge_temp_bm);
   b2b_debug_purge('b2b_wire_message', 'After');

   v_stmt := 'delete from b2b_data_storage bm_payload_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select bm_payload_storage from  b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage bm_attachment_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select bm_attachment_storage from  b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage bm_native_data_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select bm_native_data_storage from  b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage bm_translated_data_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select bm_translated_data_storage from  b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage wm_packed_message'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select wm_packed_message from b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage wm_payload_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select wm_payload_storage from b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage am_payload'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select am_payload  from  b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage am_attachment_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select am_attachment_storage from  b2b_purge_temp_bm);
   b2b_debug_purge('b2b_data_storage', 'After');

   delete b2b_purge_temp_bm;

   COMMIT;

END IF;


   IF (sysdate >= v_stoptime) THEN
     v_timeout := TRUE;
     v_nextloop := FALSE;
   END IF;

v_stmt := 'End Loop BM';
END LOOP;

IF (v_timeout = FALSE) THEN
   v_stmt := 'Jump into Loop WM';
   v_nextloop := TRUE;
END IF;

WHILE v_nextloop = TRUE LOOP

   v_nextloop := FALSE;
   has_rows_wm_instance := FALSE;
   dbms_output.put_line('======Start run '|| v_counter||' '|| p_rownum||' rows to delete======');

   IF givenState = 'MSG_COMPLETE' THEN
      v_wireState := 'COMPLETE';
   ELSE IF givenState = 'MSG_ERROR' THEN
      v_wireState := 'ERROR';
   ELSE v_wireState := 'PROCESSING';
        END IF;
   END IF;

/* Populate table with information about older instances */
   v_stmt := 'Insert into b2b_purge_temp_wm';
   b2b_debug_purge('b2b_purge_temp_wm', 'Before');
insert into b2b_purge_temp_wm(wm_id, wm_payload_storage, wm_packed_message)        SELECT wm.id, wm.payload_storage, wm.packed_message 
       FROM b2b_wire_message wm
       WHERE                                                            
       TRUNC(wm.CPST_INST_CREATED_TIME) BETWEEN TRUNC(p_lower_band) AND TRUNC(p_upper_band) AND       wm.state = v_wireState AND
       rownum <= p_rownum;

   b2b_debug_purge('b2b_purge_temp_wm', 'After');
   IF SQL%ROWCOUNT > 0 THEN
       has_rows_wm_instance := TRUE;
   END IF;

   IF SQL%ROWCOUNT = p_rownum THEN
       v_nextloop := TRUE ;
   END IF;

   COMMIT;

IF has_rows_wm_instance = TRUE
THEN

   v_stmt := 'delete from b2b_wire_message'; 
   b2b_debug_purge('b2b_wire_message', 'Before');

   DELETE FROM b2b_wire_message
         WHERE id in (select wm_id from b2b_purge_temp_wm);
   b2b_debug_purge('b2b_wire_message', 'After');

   v_stmt := 'delete from b2b_data_storage wm_payload_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select wm_payload_storage from b2b_purge_temp_wm);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage wm_packed_message'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select wm_packed_message from b2b_purge_temp_wm);
   b2b_debug_purge('b2b_data_storage', 'After');

   delete b2b_purge_temp_wm;

   COMMIT;

END IF;


   IF (sysdate >= v_stoptime) THEN
     v_timeout := TRUE;
     v_nextloop := FALSE;
   END IF;

v_stmt := 'End Loop WM';
END LOOP;

IF (v_timeout = FALSE) THEN
   v_stmt := 'Jump into Loop AM';
   v_nextloop := TRUE;
END IF;


WHILE v_nextloop = TRUE LOOP

   v_nextloop := FALSE;
   has_rows_am_instance := FALSE;
   dbms_output.put_line('======Start run '|| v_counter||' '|| p_rownum||' rows to delete======');

/* Populate table with information about older instances */
   v_stmt := 'Insert into b2b_purge_temp_am';
   b2b_debug_purge('b2b_purge_temp_am', 'Before');
insert into b2b_purge_temp_am(am_id, am_payload, am_attachment_storage)        SELECT am.id, am.payload, am.attachment_storage
       FROM b2b_app_message am
       WHERE                                                            
       TRUNC(am.CPST_INST_CREATED_TIME) BETWEEN TRUNC(p_lower_band) AND TRUNC(p_upper_band) AND 
       am.state = givenState AND
       rownum <= p_rownum;

   b2b_debug_purge('b2b_purge_temp_am', 'After');
   IF SQL%ROWCOUNT > 0 THEN
       has_rows_am_instance := TRUE;
   END IF;

   IF SQL%ROWCOUNT = p_rownum THEN
       v_nextloop := TRUE ;
   END IF;

   COMMIT;

IF has_rows_wm_instance = TRUE
THEN

   v_stmt := 'delete from b2b_app_message'; 
   b2b_debug_purge('b2b_app_message', 'Before');

   DELETE FROM b2b_app_message
         WHERE id in (select am_id from b2b_purge_temp_am);
   b2b_debug_purge('b2b_app_message', 'After');

   v_stmt := 'delete from b2b_data_storage am_payload'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select am_payload  from  b2b_purge_temp_am);
   b2b_debug_purge('b2b_data_storage', 'After');

   v_stmt := 'delete from b2b_data_storage am_attachment_storage'; 
   b2b_debug_purge('b2b_data_storage', 'Before');

   DELETE FROM b2b_data_storage
         WHERE id in (select am_attachment_storage from  b2b_purge_temp_am);
   b2b_debug_purge('b2b_data_storage', 'After');

   delete b2b_purge_temp_am;

   COMMIT;

END IF;


   IF (sysdate >= v_stoptime) THEN
     v_nextloop := FALSE;
   END IF;

v_stmt := 'End Loop AM';
END LOOP;

	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_WIRE_MESSAGE',  'B2B_WM_DS_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_WIRE_MESSAGE',  'B2B_WM_PS_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_WM_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_AM_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_NDS_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_TDS_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_AS_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_EBM_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_BUSINESS_MESSAGE',  'B2B_BM_PS_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_EXT_BUSINESS_MESSAGE',  'B2B_EBM_BM_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_APP_MESSAGE',  'B2B_AM_PAYLOAD_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_APP_MESSAGE',  'B2B_AM_BM_FK',  'ENABLE');
	B2B_CH_STATUS_DROP_CONSTRAINT('B2B_APP_MESSAGE',  'B2B_AM_AS_FK',  'ENABLE');
	
EXCEPTION
  when others then 
    v_code := SQLCODE;
    v_errm := SUBSTR(SQLERRM, 1 , 64);
    DBMS_OUTPUT.PUT_LINE('Error code ' || v_code || ': ' || v_errm || ' at line : ' || v_stmt);
   
END purge_b2b_instances_down;
/

-- oracle----------------------------------------------------------------------- 
-- Purge based on Business Message ID 

CREATE OR REPLACE PROCEDURE purge_runtime_by_id 
(msg_id IN VARCHAR2) AS
/* This procedure is deprecated and will be removed in forthcoming release.
 * Please use B2B_PURGE.PURGE_RUNTIME_BY_MSG_ID() instead.
 */
   CURSOR b2b_cur IS
       SELECT bm.id, bm.state, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage, bm.translated_data_storage,
              wm.packed_message, wm.payload_storage wmps,  
              am.payload, am.attachment_storage amas
       FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
       WHERE                                                            
       bm.message_id = msg_id AND
       bm.wire_message = wm.id (+)
       AND bm.ext_business_message = ext.id (+)
       AND bm.app_message = am.id (+);

BEGIN

   FOR b2b_rec IN b2b_cur
   LOOP
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.payload_storage; 
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.attachment_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.native_data_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.translated_data_storage;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.packed_message;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.wmps;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.payload;
      DELETE FROM b2b_data_storage WHERE id = b2b_rec.amas;
      IF b2b_rec.state='MSG_WAIT_BATCH' THEN
        DELETE FROM b2b_pending_message where message_id = b2b_rec.message_id;
      END IF;

   END LOOP;

  COMMIT;


  EXCEPTION
     WHEN OTHERS THEN
        ROLLBACK;
        RAISE;
END;
/

-- oracle----------------------------------------------------------------------- 
-- Purge All Runtime Data 

CREATE OR REPLACE PROCEDURE purge_all as
BEGIN
        dbms_output.put_line('disabling constraints');
        B2B_CHANGE_STATUS_CONSTRAINTS('DISABLE');
        dbms_output.put_line('disabling constraints - done');

        EXECUTE IMMEDIATE 'truncate table B2B_CONTROL_NUMBER';
        EXECUTE IMMEDIATE 'truncate table B2B_PENDING_MESSAGE';
        EXECUTE IMMEDIATE 'truncate table B2B_BATCH_EVENT';
        EXECUTE IMMEDIATE 'truncate table B2B_TRANSPORT_MANAGER';
        EXECUTE IMMEDIATE 'truncate table B2B_HA_REGISTRY';
        EXECUTE IMMEDIATE 'truncate table B2B_LIFECYCLE';
        EXECUTE IMMEDIATE 'truncate table B2B_SEQUENCE_MANAGER';
        EXECUTE IMMEDIATE 'truncate table B2B_CTL_NUMBER';
        EXECUTE IMMEDIATE 'truncate table B2B_CONTROL_NUMBER_SET';

        EXECUTE IMMEDIATE 'truncate table B2B_BUSINESS_MESSAGE';
        EXECUTE IMMEDIATE 'truncate table B2B_WIRE_MESSAGE';
        EXECUTE IMMEDIATE 'truncate table B2B_EXT_BUSINESS_MESSAGE';
        EXECUTE IMMEDIATE 'truncate table B2B_APP_MESSAGE';
        EXECUTE IMMEDIATE 'truncate table B2B_DATA_STORAGE';

         /* Now Enable the constraints */
        dbms_output.put_line('Enabling constraints');
        B2B_CHANGE_STATUS_CONSTRAINTS('ENABLE');
        dbms_output.put_line('Enabling constraints - done');
END;
/

-- oracle----------------------------------------------------------------------- 
-- Used by HA 

/* ha registry che */

CREATE OR REPLACE PROCEDURE is_active
(inst in varchar2, elapsed in number, res out number) as
pragma autonomous_transaction;
CURSOR c1 IS SELECT INSTANCE, LASTUPDATE FROM B2B_HA_REGISTRY for UPDATE;
reg_rec        c1%ROWTYPE;
dummy        INTEGER;
BEGIN
   res := 0;
   OPEN c1;

   FETCH c1 INTO reg_rec;

       IF c1%NOTFOUND THEN
   insert into B2B_HA_REGISTRY values (inst, SYSDATE);
   res := 1;
       ELSE
       IF reg_rec.INSTANCE = inst THEN
       update B2B_HA_REGISTRY set LASTUPDATE = SYSDATE;
       res := 1;
       ELSE
       IF SYSDATE - reg_rec.LASTUPDATE > elapsed/1440 THEN
       delete B2B_HA_REGISTRY;
       insert into B2B_HA_REGISTRY values (inst, SYSDATE);
       res := 1;
           END IF;
       END IF;
   END IF;
   CLOSE c1;
   COMMIT;
END;
/

-- oracle----------------------------------------------------------------------- 
-- Used by HA for Coherence 

/* ha registry using coherence implementation */

create or replace procedure dbactive(inst in varchar2, elapsedInSec in number, switchupd in number, res out number) as
pragma autonomous_transaction;
CURSOR c1 IS SELECT INSTANCE, LASTUPDATE FROM B2B_HA_REGISTRY for UPDATE;
reg_rec        c1%ROWTYPE;
dummy        INTEGER;
BEGIN
   res := 0;
   OPEN c1;

   FETCH c1 INTO reg_rec;

       IF c1%NOTFOUND THEN
   insert into B2B_HA_REGISTRY values (inst, SYSDATE);
   res := 1;
       ELSE
       IF reg_rec.INSTANCE = inst THEN
       update B2B_HA_REGISTRY set LASTUPDATE = SYSDATE;
       res := 1;
       ELSE
       IF SYSDATE - reg_rec.LASTUPDATE > elapsedInSec/(1440*60) THEN
        IF switchupd = 1 THEN
            delete B2B_HA_REGISTRY;
           insert into B2B_HA_REGISTRY values (inst, SYSDATE);
       END IF;

       res := 1;
           END IF;
       END IF;
   END IF;
   CLOSE c1;
   COMMIT;
END;
/

-- oracle----------------------------------------------------------------------- 
-- 10g perf optimizations 

/* sql hints  */
CREATE OR REPLACE PACKAGE WIRE_MESSAGE_TYPES IS
TYPE WDATA IS REF CURSOR RETURN B2B_WIRE_MESSAGE%ROWTYPE;
END WIRE_MESSAGE_TYPES;
/

-- oracle----------------------------------------------------------------------- 
-- 10g Perf optimizations 

CREATE OR REPLACE PROCEDURE GET_WIREMESSAGE_PID
(PROMSGID IN B2B_WIRE_MESSAGE.PROTOCOL_MESSAGE_ID%TYPE, DATAOUT OUT WIRE_MESSAGE_TYPES.WDATA) AS
BEGIN
  OPEN DATAOUT FOR
  SELECT
   /*+ INDEX(B2B_WIRE_MESSAGE B2B_IDX_WM_PROT_MSGID) */ *
  FROM B2B_WIRE_MESSAGE
  WHERE PROTOCOL_MESSAGE_ID = PROMSGID;
END;
/

-- oracle----------------------------------------------------------------------- 
-- 10g Perf optimizations 

CREATE OR REPLACE PROCEDURE GET_WIREMESSAGE_PIDPCID
(PROMSGID IN B2B_WIRE_MESSAGE.PROTOCOL_MESSAGE_ID%TYPE, PROCOLID IN B2B_WIRE_MESSAGE.PROTOCOL_COLLABORATION_ID%TYPE, DATAOUT OUT WIRE_MESSAGE_TYPES.WDATA) AS
BEGIN
  OPEN DATAOUT FOR
  SELECT
   /*+ INDEX(B2B_WIRE_MESSAGE B2B_IDX_WM_PROT) */ *
  FROM B2B_WIRE_MESSAGE
  WHERE PROTOCOL_MESSAGE_ID = PROMSGID AND PROTOCOL_COLLABORATION_ID = PROCOLID;
END;
/

-- oracle----------------------------------------------------------------------- 
-- Purge Instance Message Audit for PS5 onwards. 

create or replace
    PROCEDURE B2B_PURGE_INST_MSGS_AUDIT_PS5(
                                   p_startDate in varchar2 default NULL
                                   ,p_endDate in varchar2 default NULL
                                   ,p_msgState in varchar2  default NULL
                                   ,p_tpName in varchar2  default NULL
                                   ,p_direction in varchar2  default NULL
                                   ,p_msgType in varchar2  default NULL
                                   ,p_tpaName in varchar2  default NULL
                                   ,p_idType in varchar2  default NULL
                                   ,p_idVal in varchar2  default NULL
                                   ,p_shouldArchive in varchar2
                                   ,p_force_del in varchar2 default 'false'
                                   ,p_archiveFileName in varchar2
                                   ,p_tpaId in varchar2  default NULL
                                   ,p_action in varchar2  default NULL
                                   ,p_service in varchar2  default NULL
                                   ,p_commitFrequency number default 0
                                   ,p_docType in varchar2  default NULL
                                   ,p_auditId in varchar2
                                   ,p_numOfRecordsPurged out varchar2 )  IS
                                   
        /* This procedure is deprecated and will be removed in forthcoming release.
         * Please use B2B_PURGE.PURGE_INSTANCE_MSGS_AUDIT() instead.
         */                              
    
    
         bizid               b2b_business_message.id%TYPE;
         bizstate               b2b_business_message.state%TYPE;
         message_id               b2b_business_message.message_id%TYPE;
         payload_storage     b2b_business_message.payload_storage%TYPE;
         attachment_storage   b2b_app_message.attachment_storage%TYPE;
         native_data_storage  b2b_business_message.native_data_storage%TYPE;
         translated_data_storage b2b_business_message.translated_data_storage%TYPE;
         packed_message    b2b_wire_message.packed_message%TYPE;
         wmps              b2b_wire_message.payload_storage%TYPE;
         payload           b2b_app_message.payload%TYPE;
         amas              b2b_app_message.attachment_storage%TYPE;
         wm                b2b_business_message.WIRE_MESSAGE%TYPE;
         am                b2b_business_message.APP_MESSAGE%TYPE;
    
    l_id  VARCHAR2(256);
    l_p_rowcount NUMBER := 0;
    ln_start number:=1;
    ln_end number:=5000;
    commitFrequency number:=ln_end;
    str VARCHAR2(10000);
    id RAW(16);
    num RAW(16);
    safestate VARCHAR2(100);
    tmpFileName varchar2(100);
    firstCond varchar2(10);
    myexp	exception;
    sSQL    VARCHAR2(2000);
    nCount    NUMBER;
    invalidParamCode number:=-20000;
    
    BEGIN
    
    execute immediate 'alter session force parallel dml parallel 8';
    
    /* avoid unwanted execution plans  */
       execute immediate 'alter session set "_optimizer_sortmerge_join_enabled"=false';
       execute immediate 'alter session set "_optimizer_mjc_enabled"=false';
       execute immediate 'alter session set "_optimizer_cartesian_enabled"=false';
    /* and set MBRC high to boost Full Table Scans */
       execute immediate 'alter session set db_file_multiblock_read_count=128';
    
    
         firstCond := 'true';
    
    
         if ((p_startDate is not null) AND (p_endDate is not null)) then
               if firstCond='true' then
               begin
    
                 str := str || '  bm.created between to_date( '''|| p_startDate || '''  , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''||p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  bm.created between to_date( '''|| p_startDate || ''' , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''|| p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
               end if ;
    
    
           end if;
    
      if p_msgState is not null then
    /*        DBMS_OUTPUT.PUT_LINE('inside msgState'); */
    
               if firstCond='true' then
               begin
                 str := str || '  bm.STATE = '''|| p_msgState || ''' ';
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  bm.STATE = '''|| p_msgState || ''' ';
    
               end if;
    
         end if  ;
    
          if p_tpName is not null then
               if firstCond='true' then
               begin
                 str := str || '( bm.sender_name = '''|| p_tpName || ''' )';
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  (  bm.sender_name ='''|| p_tpName || ''' )';
               end if;
    
          end if ;
         if p_tpaId is not null then
               if firstCond='true' then
                 begin
                 str := str  || '  bm.tpa_id  = '''|| p_tpaId || '''  ';
                   firstCond := 'false';
                 end;
               else
                           str := str  || ' AND  bm.tpa_id  = '''|| p_tpaId || '''  ';
    
               end if ;
    
         end if;
    
    -- Added parameter for action for bug 11773067
         if p_action is not null then
               if firstCond='true' then
                 begin
                 str := str  || ' substr(bm.attribute2,instr(bm.attribute2,' || ' ''#:#'' ' || ')+3)  = '''|| p_action || '''  ';
                   firstCond := 'false';
                 end;
               else
                          str := str  || ' AND  substr(bm.attribute2,instr(bm.attribute2,' || ' ''#:#'' ' || ')+3)  = '''|| p_action || '''  ';
    
               end if ;
    
         end if;
    -- Added parameter for service for bug 11773067
         if p_service is not null then
               if firstCond='true' then
                 begin
                 str := str  || '  substr(bm.attribute2,1,instr(bm.attribute2,' || ' ''#:#'' ' || ')-1) = '''|| p_service || '''  ';
                   firstCond := 'false';
                 end;
               else
                           str := str  || ' AND  substr(bm.attribute2,1,instr(bm.attribute2,' || ' ''#:#'' ' || ')-1) = '''|| p_service || '''  ';
    
               end if ;
    
         end if;
    --
    
         if p_direction is not null then
               if firstCond='true' then
               begin
                 str := str || '  bm.DIRECTION = '''|| p_direction || ''' ';
                 firstCond := 'false';
               end;
               else
                 str := str || ' AND  bm.DIRECTION = '''|| p_direction || ''' ';
               end if;
    
    
         end if  ;
    
    
    
         if p_msgType is not null then
               if firstCond='true' then
                 begin
                   str := str || '  bm.MESSAGE_TYPE  ='''|| p_msgType || ''' ';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND bm.MESSAGE_TYPE  = '''|| p_msgType || '''  ';
               end if;
    
         end if;
    
         if p_tpaName is not null then
               if firstCond='true' then
                 begin
                 str := str  || '  bm.tpa_name  = '''|| p_tpaName || '''  ';
                   firstCond := 'false';
                 end;
               else
                           str := str  || ' AND  bm.tpa_name  = '''|| p_tpaName || '''  ';
    
               end if ;
    
         end if;
    
         if p_idType is not null then
               if firstCond='true' then
                 begin
                   str := str || ' ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
               end if;
    
    
         end if;
         if p_idVal is not null then
               if firstCond='true' then
                 begin
                   str := str || ' ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''  )';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''   )';
               end if;
    
         end if;
    
         if p_docType is not null then
               if firstCond='true' then
                 begin
                   str := str || ' ( bm.DOCTYPE_NAME  ='''|| p_docType || '''  )';
                   firstCond := 'false';
                 end;
               else
                  str := str || ' AND ( bm.DOCTYPE_NAME  ='''|| p_docType || '''   )';
               end if;
    
         end if;
         
                   if firstCond='true' then
               begin
                  str := str || '  bm.wire_message = wm.id (+)
                 AND bm.ext_business_message = ext.id (+)
                 AND bm.app_message = am.id (+) ';
              end;
             else
               begin
                  str := str ||' AND  bm.wire_message = wm.id (+)
                 AND bm.ext_business_message = ext.id (+)
                 AND bm.app_message = am.id (+) ';
               end;
             end if;
    
           DBMS_OUTPUT.PUT_LINE(str);
            
    
    
    
               if p_shouldArchive = 'true' then
    
           dbms_output.put_line('===========' ||  str  );
           tmpFileName := p_archiveFileName;
    
           if tmpFileName is  null then
             tmpFileName :=  to_char(sysdate, 'DD-Mon-YYYY-HH24:MI:SS');
             tmpFileName := tmpFileName || '.dmp';
           end if;
    
             B2B_ARCHIVE_INST_MSGS_PS5(p_startDate,p_endDate ,p_msgState ,p_tpName ,p_direction ,p_msgType ,p_tpaName ,p_idType ,p_idVal,p_action,p_service,p_docType,tmpFileName);
         end if ;
    
    
      BEGIN
        EXECUTE IMMEDIATE 'DROP TABLE b2b_temp';
             
               EXCEPTION
               WHEN others THEN
                 DBMS_OUTPUT.PUT_LINE('Error dropping table, ignore this error');
          END;
        
          EXECUTE IMMEDIATE 'CREATE TABLE b2b_temp AS (SELECT  rownum row_number, bm.id, bm.state, bm.message_id, bm.ext_business_message ext, bm.payload_storage, bm.attachment_storage, bm.native_data_storage,
                          bm.translated_data_storage, bm.WIRE_MESSAGE,bm.APP_MESSAGE, wm.packed_message, wm.payload_storage wmps, am.payload, am.attachment_storage amas
                FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext WHERE '||str||')' ;
          
        sSQL:= 'SELECT COUNT(rowid) from b2b_temp';
        
        LOOP
      
        EXECUTE IMMEDIATE 'DELETE from b2b_data_storage WHERE id in 
        		  (
        		  select payload_storage from b2b_temp where row_number between '||ln_start|| ' and ' ||ln_end|| 
        		  'union all  
        		  select packed_message from b2b_temp where row_number between '||ln_start|| ' and '|| ln_end||
        		  'union all
        		  select payload from b2b_temp where row_number between '||ln_start ||' and '|| ln_end||
        		  'union all
        		  select wmps from b2b_temp where row_number between '||ln_start||' and '||ln_end||
        		  'union all
        		  select native_data_storage from b2b_temp where row_number between '||ln_start||' and '||ln_end||
        		  'union all
        		  select translated_data_storage from b2b_temp where row_number between '||ln_start||' and '||ln_end||
        		  'union all
        		  select attachment_storage from b2b_temp where row_number between '||ln_start||' and '||ln_end||')'; 
        
        	EXECUTE IMMEDIATE 'DELETE from b2b_sequence_manager WHERE b2b_sequence_manager.message_id in (select message_id from b2b_temp where row_number between '|| ln_start ||' and '|| ln_end||')';
        	EXECUTE IMMEDIATE 'DELETE from b2b_app_message WHERE id in (select app_message from b2b_temp where row_number between '|| ln_start ||' and '|| ln_end||')';
        	EXECUTE IMMEDIATE 'DELETE from b2b_wire_message WHERE id in (select wire_message from b2b_temp where row_number between '||ln_start ||' and '||ln_end||')';
        	EXECUTE IMMEDIATE 'DELETE from b2b_ext_business_message WHERE id in (select ext from b2b_temp where row_number between '||ln_start||' and '||ln_end||')';
        	EXECUTE IMMEDIATE 'DELETE from b2b_business_message WHERE id in (select id from b2b_temp where row_number between '||ln_start||' and '||ln_end||')';
        	--Changes begin - Fix for bug 13364362
      	EXECUTE IMMEDIATE 'INSERT INTO B2B_AUDIT_TEMP (select '||''''||p_auditId||''''||', message_id from b2b_temp where row_number between '||ln_start||' and '||ln_end||')';
      	--Changes end
              EXECUTE IMMEDIATE 'DELETE from b2b_temp where row_number between '||ln_start||' and '||ln_end; 
        	  
         nCount:= sql%rowcount;
      
         --Changes begin - Fix for bug 13364362
         if (nCount != 0) then
          l_p_rowcount := l_p_rowcount + nCount;
         end if;
         --Changes end
        commit;  
        
        	  EXIT WHEN nCount = 0;
        
        ln_start :=ln_end + 1;
        ln_end := ln_start + (commitFrequency -1);
      
        END LOOP;
        p_numOfRecordsPurged := l_p_rowcount;
      
         EXCEPTION
                WHEN myexp then
                rollback;
      	  dbms_output.put_line('tpName is provided without direction.');
      
      
            WHEN OTHERS THEN
               ROLLBACK;
               RAISE;
                  
    END B2B_PURGE_INST_MSGS_AUDIT_PS5;
/

-- oracle----------------------------------------------------------------------- 
-- Purge Instance Message Audit 

CREATE OR REPLACE PROCEDURE B2B_PURGE_INSTANCE_MSGS_AUDIT
(
                               p_startDate in varchar2 default NULL
                               ,p_endDate in varchar2 default NULL
                               ,p_msgState in varchar2  default NULL
                               ,p_tpName in varchar2  default NULL
                               ,p_direction in varchar2  default NULL
                               ,p_msgType in varchar2  default NULL
                               ,p_tpaName in varchar2  default NULL
                               ,p_idType in varchar2  default NULL
                               ,p_idVal in varchar2  default NULL
                               ,p_docType in varchar2  default NULL
                               ,p_shouldArchive in varchar2
                               ,p_force_del in varchar2 default 'false'
                               ,p_archiveFileName in varchar2
                               ,p_tpaId in varchar2  default NULL
                               ,p_auditId in varchar2
                               ,p_numOfRecordsPurged out varchar2 )  IS
                               
 /* This procedure is deprecated and will be removed in forthcoming release.
  * Please use B2B_PURGE.PURGE_INSTANCE_MSGS_AUDIT() instead.
  */                                   


b2b_refcur      SYS_REFCURSOR;


     bizid               b2b_business_message.id%TYPE;
     bizstate               b2b_business_message.state%TYPE;
     message_id               b2b_business_message.message_id%TYPE;
     payload_storage     b2b_business_message.payload_storage%TYPE;
     attachment_storage   b2b_app_message.attachment_storage%TYPE;
     native_data_storage  b2b_business_message.native_data_storage%TYPE;
     translated_data_storage b2b_business_message.translated_data_storage%TYPE;
     packed_message    b2b_wire_message.packed_message%TYPE;
     wmps              b2b_wire_message.payload_storage%TYPE;
     payload           b2b_app_message.payload%TYPE;
     amas              b2b_app_message.attachment_storage%TYPE;

l_id  VARCHAR2(256);
l_p_rowcount NUMBER := 0;
str VARCHAR2(10000);
id RAW(16);
num RAW(16);
safestate VARCHAR2(100);
tmpFileName varchar2(100);
firstCond varchar2(10);
BEGIN

execute immediate 'alter session force parallel dml parallel 8';

/* avoid unwanted execution plans  */
   execute immediate 'alter session set "_optimizer_sortmerge_join_enabled"=false';
   execute immediate 'alter session set "_optimizer_mjc_enabled"=false';
   execute immediate 'alter session set "_optimizer_cartesian_enabled"=false';
/* and set MBRC high to boost Full Table Scans */
   execute immediate 'alter session set db_file_multiblock_read_count=128';

/*
     firstCond := 'true';


     if ((p_startDate is not null) AND (p_endDate is not null)) then
           if firstCond='true' then
           begin

             str := str || '  bm.created between to_date( '''|| p_startDate || '''  , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''||p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
             firstCond := 'false';
           end;
           else
             str := str || ' AND  bm.created between to_date( '''|| p_startDate || ''' , ''YYYY-MM-DD HH24:MI:SS'') AND to_date( '''|| p_endDate || ''' , ''YYYY-MM-DD HH24:MI:SS'')'    ;
           end if ;


       end if;

  if p_msgState is not null then

           if firstCond='true' then
           begin
             str := str || '  bm.STATE = '''|| p_msgState || ''' ';
             firstCond := 'false';
           end;
           else
             str := str || ' AND  bm.STATE = '''|| p_msgState || ''' ';

           end if;

     end if  ;

      if p_tpName is not null then
           if firstCond='true' then
           begin
             str := str || '( bm.sender_name = '''|| p_tpName || ''' )';
             firstCond := 'false';
           end;
           else
             str := str || ' AND  (  bm.sender_name ='''|| p_tpName || ''' )';
           end if;

      end if ;
     if p_tpaId is not null then
           if firstCond='true' then
             begin
             str := str  || '  bm.tpa_id  = '''|| p_tpaId || '''  ';
               firstCond := 'false';
             end;
           else
                       str := str  || ' AND  bm.tpa_id  = '''|| p_tpaId || '''  ';

           end if ;

     end if;

     if p_direction is not null then
           if firstCond='true' then
           begin
             str := str || '  bm.DIRECTION = '''|| p_direction || ''' ';
             firstCond := 'false';
           end;
           else
             str := str || ' AND  bm.DIRECTION = '''|| p_direction || ''' ';
           end if;


     end if  ;



     if p_msgType is not null then
           if firstCond='true' then
             begin
               str := str || '  bm.MESSAGE_TYPE  ='''|| p_msgType || ''' ';
               firstCond := 'false';
             end;
           else
              str := str || ' AND bm.MESSAGE_TYPE  = '''|| p_msgType || '''  ';
           end if;

     end if;

     if p_tpaName is not null then
           if firstCond='true' then
             begin
             str := str  || '  bm.tpa_name  = '''|| p_tpaName || '''  ';
               firstCond := 'false';
             end;
           else
                       str := str  || ' AND  bm.tpa_name  = '''|| p_tpaName || '''  ';

           end if ;

     end if;

     if p_idType is not null then
           if firstCond='true' then
             begin
               str := str || ' ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
               firstCond := 'false';
             end;
           else
              str := str || ' AND ( bm.SENDER_ID_TYPE  = '''|| p_idType || '''   )';
           end if;


     end if;
     if p_idVal is not null then
           if firstCond='true' then
             begin
               str := str || ' ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''  )';
               firstCond := 'false';
             end;
           else
              str := str || ' AND ( bm.SENDER_ID_VALUE  ='''|| p_idVal || '''   )';
           end if;

     end if;

     if p_docType is not null then
           if firstCond='true' then
             begin
               str := str || ' ( bm.DOCTYPE_NAME  ='''|| p_docType || '''  )';
               firstCond := 'false';
             end;
           else
              str := str || ' AND ( bm.DOCTYPE_NAME  ='''|| p_docType || '''   )';
           end if;

     end if;
     
               if firstCond='true' then
           begin
              str := str || '  bm.wire_message = wm.id (+)
             AND bm.ext_business_message = ext.id (+)
             AND bm.app_message = am.id (+) ';
          end;
         else
           begin
              str := str ||' AND  bm.wire_message = wm.id (+)
             AND bm.ext_business_message = ext.id (+)
             AND bm.app_message = am.id (+) ';
           end;
         end if;

       DBMS_OUTPUT.PUT_LINE(str);
        open b2b_refcur for

     'SELECT  bm.id, bm.state, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage,
                  bm.translated_data_storage, wm.packed_message, wm.payload_storage wmps, am.payload, am.attachment_storage amas
        FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
        WHERE '  || str        ;
*/


open b2b_refcur for

'SELECT  bm.id, bm.state, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage,
bm.translated_data_storage, wm.packed_message, wm.payload_storage wmps, am.payload, am.attachment_storage amas
FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
WHERE (:a is null or :b is null or bm.created between
to_date(:c, ''YYYY-MM-DD HH24:MI:SS'') and to_date(:d, ''YYYY-MM-DD HH24:MI:SS''))  
and (:e is null or bm.state = :f) 
and (:g is null or bm.sender_name = :h)
and (:i is null or bm.DIRECTION = :j)
and (:k is null or bm.MESSAGE_TYPE = :l)
and (:m is null or bm.tpa_name = :n)
and (:o is null or bm.tpa_Id = :p)
and (:q is null or bm.SENDER_ID_TYPE = :r)
and (:s is null or bm.SENDER_ID_VALUE = :t)
and (:u is null or bm.DOCTYPE_NAME = :v)
AND  bm.wire_message = wm.id (+)
AND bm.ext_business_message = ext.id (+)
AND bm.app_message = am.id (+)
'  using   p_startDate,p_endDate,p_startDate,p_endDate,p_msgState,p_msgState 
,p_tpName,p_tpName ,p_direction,p_direction ,p_msgType ,p_msgType,p_tpaName,p_tpaName,p_tpaId,p_tpaId
,p_idType,p_idType ,p_idVal,p_idVal ,p_docType ,p_docType  ;


       DBMS_OUTPUT.PUT_LINE(str);



           if p_shouldArchive = 'true' then

       dbms_output.put_line('===========' ||  str  );
       tmpFileName := p_archiveFileName;

       if tmpFileName is  null then
         tmpFileName :=  to_char(sysdate, 'DD-Mon-YYYY-HH24:MI:SS');
         tmpFileName := tmpFileName || '.dmp';
       end if;

         B2B_ARCHIVE_INSTANCE_MSGS(p_startDate,p_endDate ,p_msgState ,p_tpName ,p_direction ,p_msgType ,p_tpaName ,p_idType ,p_idVal,p_docType,tmpFileName);
     end if ;


  LOOP




  FETCH b2b_refcur INTO bizid, bizstate, message_id, payload_storage,
attachment_storage, native_data_storage, translated_data_storage,
packed_message, wmps, payload, amas;



DELETE FROM b2b_data_storage WHERE id in( payload_storage,packed_message);
       DELETE FROM b2b_data_storage WHERE id in(wmps,native_data_storage,translated_data_storage);
       DELETE FROM b2b_data_storage WHERE id in( attachment_storage,payload);

                    

/*   DBMS_OUTPUT.PUT_LINE('Dheeraj ' || payload_storage); */

      IF MOD(b2b_refcur%ROWCOUNT, 1000) = 0 THEN 
        COMMIT;
      END IF;
 

    EXIT WHEN b2b_refcur%NOTFOUND;
    INSERT INTO B2B_AUDIT_TEMP VALUES ( p_auditId, message_id );
    l_p_rowcount := l_p_rowcount + 1;             
    END LOOP;
CLOSE b2b_refcur;
   COMMIT;
p_numOfRecordsPurged := l_p_rowcount;
    
    /* Bug#8438439 */
    /*
     * There could be entries in b2b_wiremessage table for which there are
     * no corresponding entries in b2b_business_message table. Such entries
     * would not get deleted in delete operation occuring above through b2b_cur
     * cursor. We are deleting such entries here.
     */

/*
 *   for i in (
 *     select payload_storage, packed_message
 *     from b2b_wire_message wm
 *     where
 *     wm.created >= to_date(p_startDate, 'YYYY-MM-DD HH24:MI:SS')
 *        AND wm.created <= to_date(p_endDate, 'YYYY-MM-DD HH24:MI:SS') AND
 *             wm.created between nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),  nvl((select min(created) from b2b_wire_message),sysdate))
 *                        AND nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),    nvl((select max(created) from b2b_wire_message),sysdate))
 *      AND wm.state like nvl(p_msgState,'%')
 *  )
 *  loop
 *    DELETE FROM b2b_data_storage where id = i.payload_storage;
 *    DELETE FROM b2b_data_storage where id = i.packed_message;
 *
 *  end loop;
 *
 *
 *  COMMIT;
 */


    /*
     * There could be entries in b2b_app_message table for which there are
     * no corresponding entries in b2b_business_message table. Such entries
     * would not get deleted in delete operation occuring above through b2b_cur
     * cursor. We are deleting such entries here.
     */
/*
 *   for i in (
 *     select payload, attachment_storage
 *     from b2b_app_message am
 *     where
 *     am.created >= to_date(p_startDate, 'YYYY-MM-DD HH24:MI:SS')
 *        AND am.created <= to_date(p_endDate, 'YYYY-MM-DD HH24:MI:SS') AND
 *        am.created between nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),  nvl((select min(created) from b2b_app_message),sysdate))
 *                        AND nvl(to_date(null, 'YYYY-MM-DD HH24:MI:SS'),    nvl((select max(created) from b2b_app_message),sysdate))
 *     AND am.state like nvl(p_msgState,'%')
 *  )
 *  loop
 *    DELETE FROM b2b_data_storage where id in (i.payload, i.attachment_storage);
 *  end loop;
 *
 *  COMMIT;
 */


   EXCEPTION
      WHEN OTHERS THEN
         ROLLBACK;
         RAISE;
         
END B2B_PURGE_INSTANCE_MSGS_AUDIT;
/

-- oracle----------------------------------------------------------------------- 
-- Called by UI Purge to refresh MV 

create or replace procedure b2b_refresh_mv as 
	ln_count	NUMBER := 0;
begin
	SELECT COUNT(*) INTO ln_count FROM USER_SNAPSHOTS WHERE NAME = 'B2B_SYSTEM_MV' AND REFRESH_MODE = 'PERIODIC';
	IF ln_count = 1 THEN
		DBMS_MVIEW.REFRESH(LIST=>'b2b_system_mv', METHOD=>'c', ATOMIC_REFRESH=>false);
	END IF;
end b2b_refresh_mv;
/

-- oracle----------------------------------------------------------------------- 
-- Purge Package 

/****************************************************************************************************************
* B2B Purge package implementation of b2b purge mechanism.
*****************************************************************************************************************/
CREATE OR REPLACE PACKAGE B2B_PURGE AS
        /****************************************************************************************
        *       Package variable indicating the log level. User can set the log level by passing the
        *       log level enums to wrapper procedures or simply use
        *       EXEC B2B_PURGE.gn_logLevel := 0/1/2;
        *       0       - ERROR MODE
        *       1.      - INFO MODE
        *       2.      - DEBUG MODE
        *****************************************************************************************/
        gn_logLevel NUMBER := 0;
        guf_file_obj UTL_FILE.FILE_TYPE;
        /****************************************************************************************
        *       The function retieves partitions in a table which would fall within the criteria
        *       provided. The function returns true if the partitions match the criteria provided
        *       exactly.
        *       1. p_tableName  - Table Name for which the partition has to be
        *       2. p_startTstp  - Start Timestamp as a VARCHAR in format 'YYYY-MM-DD HH24:MI:SS'
        *       3. p_endTstp    - End Timestamp as a VARCHAR in format 'YYYY-MM-DD HH24:MI:SS'
        *       4. p_partitionInfoList  - An in/out list which would be populated with the partition details
        *****************************************************************************************/
        FUNCTION GET_PARTITION_INFO(p_tableName VARCHAR2
                                ,p_partitionColumn VARCHAR2
                                ,p_startTstp TIMESTAMP
                                ,p_endTstp TIMESTAMP
                ,p_partitionInfoList IN OUT LIST_PARTITION_INFO_TYPE) RETURN BOOLEAN;

        /****************************************************************************************
        *       The function analyzes if a table is partitioned based on a given column. It also ensures
        *       that the field provided is the first criteria of the partition.
        *       1. p_tableName  - Table Name for which the partition has to be
        *       2. p_partitionColumn    - Column name in the table
        *****************************************************************************************/
        FUNCTION IS_TABLE_PARTITIONED(p_tableName VARCHAR2
                                ,p_partitionColumn VARCHAR2) RETURN BOOLEAN;

        /****************************************************************************************
        *       The procedure creates statements for partition DROP/TRUNCATE based on the list
        *       and updates the statement back in the list.
        *       1. p_partitionInfoList  - List containing partition information which need to be cleared
        *       2. p_dropPartition - Boolean value indicating if the statement should be a drop/truncate stmt.
        *       3. p_opFile - The statement created are written to this file in SOA_PURGE_DIR
        *****************************************************************************************/
        PROCEDURE CREATE_PARTITION_STATEMENTS(p_partitionInfoList IN OUT LIST_PARTITION_INFO_TYPE
                                ,p_dropPartition BOOLEAN DEFAULT TRUE
                                ,p_opFile VARCHAR2 DEFAULT NULL);

        /****************************************************************************************
        *       Wrapper around the PURGE_INSTANCE_MSGS_AUDIT procedure for clients where we do not
        *       require a out parameter  For parameter definition refer to PURGE_INSTANCE_MSGS_AUDIT
        *****************************************************************************************/
        PROCEDURE PURGE_INSTANCE_MSGS(p_startDate in VARCHAR2 default NULL
                ,p_endDate in VARCHAR2 default NULL
                ,p_msgState in VARCHAR2  default NULL
                ,p_tpName in VARCHAR2  default NULL
                ,p_direction in VARCHAR2  default NULL
                ,p_msgType in VARCHAR2  default NULL
                ,p_tpaName in VARCHAR2  default NULL
                ,p_idType in VARCHAR2  default NULL
                ,p_idVal in VARCHAR2  default NULL
                ,p_shouldArchive in VARCHAR2 default NULL
                ,p_archiveFileName in VARCHAR2 default NULL
                                ,p_force_del in VARCHAR2 default 'false'
                ,p_tpaId in VARCHAR2  default NULL
                ,p_action in VARCHAR2  default NULL
                ,p_service in VARCHAR2  default NULL
                ,p_docType in VARCHAR2  default NULL
                                ,p_commitFrequency number default 0
                                ,p_partitionMode in VARCHAR2 default 'DROP'
                                ,p_logMode in VARCHAR2 default NULL
                                ,p_rowLimit NUMBER default NULL
                                ,p_stop_time INTEGER default NULL
                                ,p_refreshMW in VARCHAR2 default NULL
                                ,p_includeOrphanRecs in VARCHAR2 default 'true');

        /****************************************************************************************
        *       The procedure purges data from the B2B tables, based on the conditions provided,
        *       The driver table for the procedure is the B2B_BUSINESS_MESSAGE table.
        *
        *       PARTITIONING
        *       In case ONLY a date range is provided, the procedure attempts to evaluate if the
        *       BM table is partitioned based on the CPST_INST_CREATED_TIME field.
        *       > If possible, it attempts usage of partition pruning in these tables to clear the data.
        *       > If the date range does not exactly match the criteria, it clears out as much of data
        *       possible through pruning and then deletes the remaining rows.
        *       NOTE> In case partitioning is employed on the tables all the B2B data tables must be
        *       partitioned with the same date ranges, else there could be orphan records left in
        *       non-BUSINESS MESSAGE tables
        *
        *       WIRE_MESSAGE table
        *       > In case ONLY a date range is provided, and deletion (not partition pruning) was used
        *       to clear the data it also clears wiremessage (and its DS) rows which match the criteria.
        *       This handles (Discard ack/Immediate Ack) scenarios where WM alone is present.
        *       > This WM alone message clearing does not happen even if a rowlimt/timelimit is specified.
        *
        *       1. p_startDate  - Start Date for the records to be purged
        *       2. p_endDate - Start Date for the records to be purged
        *       3. p_msgState - State of the Business Message
        *       4. p_tpName - Trading Partner Name. (If provided Direction should also be provided)
        *       5. p_direction - Indicates the direction of the method - Values - INBOUND/OUTBOUND
        *       6. p_msgType - Indicates request type. Can be REQ/RESP etc
        *       7. p_tpaName - TPA Name
        *       8. p_idType - SENDER_ID_TYPE
        *       9. p_idVal - SENDER_ID_VALUE
        *       10. p_shouldArchive - true/false indicating the messages to be purged should be archived.
        *       11. p_archiveFileName - File Name of the archive
        *       12. p_force_del - This parameter does not have a use in the curr release. Used to be in sync
        *               with previous versions in the case the functionality is needed again
        *       13. p_tpaId  - TPA Id
        *       14. p_action - EBMS Action
        *       15. p_service - EBMS Service
        *       16. p_docType - Document Type
        *       17. p_commitFrequency - Commit frequency for batching up deletes. Default value is 5000 rec/batch
        *       18. p_auditId - Audit Id to be used to track messages deleted against a auditId.
        *       19. p_partitionMode - Indicates how partitions should be handled - DROP/TRUNCATE/STATEMENT
        *       20. p_logMode - Indicates Log level and whether the logging in console/file based. Valid values
        *               DEBUG/INFO/ERROR/CONSOLE_DEBUG/CONSOLE_INFO/CONSOLE_ERROR
        *               This parameter should not be passed if logmode is initialized in the wrapper
        *       21. p_rowLimit - Indicates the max number of business message records which can be deleted.
        *       22. p_stop_time - Indicates the time by which the purge should complete. The procedure continues
        *               to delete records in batch until the time is elapsed.
        *       23. p_refreshMW - Indicates whether the SYSTEM_MW should be Complete refreshed after the purge. By
        *               default the purge refreshes it only when a partition pruning is done. true/false/null
        *       24. p_includeOrphanRecs - Variable indicating if orphan records (Wire only, App only records)
        *               should be deleted in case if a date alone if provided as a filter criteria.
        *       25. p_numOfRecordsPurged - OUT variable indicating the number of records purged in the run
        *****************************************************************************************/
        PROCEDURE PURGE_INSTANCE_MSGS_AUDIT(p_startDate in VARCHAR2 default NULL
                                ,p_endDate in VARCHAR2 default NULL
                                ,p_msgState in VARCHAR2  default NULL
                                ,p_tpName in VARCHAR2  default NULL
                                ,p_direction in VARCHAR2  default NULL
                                ,p_msgType in VARCHAR2  default NULL
                                ,p_tpaName in VARCHAR2  default NULL
                                ,p_idType in VARCHAR2  default NULL
                                ,p_idVal in VARCHAR2  default NULL
                                ,p_shouldArchive in VARCHAR2 default 'false'
                                ,p_archiveFileName in VARCHAR2 default NULL
                                ,p_force_del in VARCHAR2 default 'false'
                                ,p_tpaId in VARCHAR2  default NULL
                                ,p_action in VARCHAR2  default NULL
                                ,p_service in VARCHAR2  default NULL
                                ,p_docType in VARCHAR2  default NULL
                                ,p_commitFrequency number default 0
                                ,p_auditId in VARCHAR2 DEFAULT NULL
                                ,p_partitionMode in VARCHAR2 default 'DROP'
                                ,p_logMode in VARCHAR2 default NULL
                                ,p_rowLimit NUMBER default NULL
                                ,p_stop_time INTEGER default NULL
                                ,p_refreshMW in VARCHAR2 default NULL
                                ,p_includeOrphanRecs in VARCHAR2 default 'true'
                                ,p_numOfRecordsPurged out NUMBER);
                                
	/****************************************************************************************
        *       The procedure purges data from the B2B tables, based on the message id provided
        *       The driver table for the procedure is the B2B_BUSINESS_MESSAGE table. It ensures
	*	that if the message is part of a batch, the entire batch is cleared.
        *
        *       1. msg_id  - Message ID for the records to be purged      
        *****************************************************************************************/                      
        PROCEDURE PURGE_RUNTIME_BY_MSG_ID (msg_id IN VARCHAR2 default NULL);

	/****************************************************************************************
        *       The procedure purges data from the B2B tables, based on the id provided
        *       The driver table for the procedure is the B2B_BUSINESS_MESSAGE table.It ensures
        *       that if the message is part of a batch, the entire batch is cleared.
        *
        *       1. p_bmId  - ID of the business message to be deleted
        *****************************************************************************************/                      
        PROCEDURE PURGE_RUNTIME_BY_ID (p_bmId IN VARCHAR2 default NULL);
        
        /****************************************************************************************
        *       The procedure archives data from the B2B tables, based on the conditions provided,
        *       The driver table for the procedure is the B2B_BUSINESS_MESSAGE table.
        *
        *       1. p_startDate  - Start Date for the records to be purged
        *       2. p_endDate - Start Date for the records to be purged
        *       3. p_msgState - State of the Business Message
        *       4. p_tpName - Trading Partner Name. (If provided Direction should also be provided)
        *       5. p_direction - Indicates the direction of the method - Values - INBOUND/OUTBOUND
        *       6. p_msgType - Indicates request type. Can be REQ/RESP etc
        *       7. p_tpaName - TPA Name
        *       8. p_idType - SENDER_ID_TYPE
        *       9. p_idVal - SENDER_ID_VALUE
        *       10. p_tpaId  - TPA Id
        *       11. p_archiveFileName - File Name of the archive
        *       12. p_commitFrequency - Commit frequency for batching up job_id updates
        *       13. p_action - EBMS Action
        *       14. p_service - EBMS Service
        *       15. p_docType - Document Type
        *       16. p_logMode - Indicates Log level and whether the logging in console/file based. Valid values
        *               DEBUG/INFO/ERROR/CONSOLE_DEBUG/CONSOLE_INFO/CONSOLE_ERROR
        *               This parameter should not be passed if logmode is initialized in the wrapper
        *       17. p_includeOrphanRecs - Variable indicating if orphan records (Wire only, App only records)
        *               should be deleted in case if a date alone if provided as a filter criteria.
        *****************************************************************************************/
        PROCEDURE ARCHIVE_INSTANCE_MSGS(p_startDate in VARCHAR2 default NULL
                                ,p_endDate in VARCHAR2 default NULL
                                ,p_msgState in VARCHAR2 default NULL
                                ,p_tpName in VARCHAR2 default NULL
                                ,p_direction in VARCHAR2 default NULL
                                ,p_msgType in VARCHAR2 default NULL
                                ,p_tpaName in VARCHAR2 default NULL
                                ,p_idType in VARCHAR2 default NULL
                                ,p_idVal in VARCHAR2 default NULL
                                ,p_tpaId in VARCHAR2 default NULL
                                ,p_action in VARCHAR2 default NULL
                                ,p_service in VARCHAR2 default NULL
                                ,p_docType in VARCHAR2 default NULL
                                ,p_archiveFileName IN VARCHAR2
                                ,p_commitFrequency number default 0
                                ,p_logMode in VARCHAR2 default NULL
                                ,p_includeOrphanRecs in VARCHAR2 default 'true');

        /****************************************************************************************
        *       Utility procedure used to identify rows to be deleted/archived
        *****************************************************************************************/
        PROCEDURE CREATE_TEMP_TABLE(
                                        p_startDate in VARCHAR2 default NULL
                                        ,p_endDate in VARCHAR2 default NULL
                                        ,p_msgState in VARCHAR2  default NULL
                                        ,p_tpName in VARCHAR2  default NULL
                                        ,p_direction in VARCHAR2  default NULL
                                        ,p_msgType in VARCHAR2  default NULL
                                        ,p_tpaName in VARCHAR2  default NULL
                                        ,p_idType in VARCHAR2  default NULL
                                        ,p_idVal in VARCHAR2  default NULL
                                        ,p_tpaId in VARCHAR2  default NULL
                                        ,p_action in VARCHAR2  default NULL
                                        ,p_service in VARCHAR2  default NULL
                                        ,p_docType in VARCHAR2  default NULL
                                        ,p_rowLimit NUMBER default NULL
                                        ,p_dateOnly in BOOLEAN default false
                                        ,p_includeOrphanRecs in VARCHAR2 default 'true');

        /****************************************************************************************
        *       Utility procedure used by the purge proc to for the select statement
        *****************************************************************************************/
        PROCEDURE ADD_TO_QUERY(p_value VARCHAR2
                                ,p_column VARCHAR2
                                ,p_query IN OUT VARCHAR2
                                ,p_bindNum VARCHAR2
                                ,p_eval VARCHAR2 DEFAULT ' = ');

        /****************************************************************************************
        *       LOG methods
        *****************************************************************************************/
        PROCEDURE LOG_DEBUG(p_method VARCHAR2, p_logText VARCHAR2);
        PROCEDURE LOG_INFO(p_method VARCHAR2, p_logText VARCHAR2);
        PROCEDURE LOG_ERROR(p_method VARCHAR2, p_logText VARCHAR2);
        PROCEDURE LOG(p_logText VARCHAR2);
        PROCEDURE INIT_LOG(p_logMode VARCHAR2);
        PROCEDURE CLOSE_LOG(p_logMode VARCHAR2);
END B2B_PURGE;
/

-- oracle----------------------------------------------------------------------- 
-- Type definition 

CREATE OR REPLACE PACKAGE BODY B2B_PURGE AS
        FUNCTION GET_PARTITION_INFO(p_tableName VARCHAR2
                                ,p_partitionColumn VARCHAR2
                                ,p_startTstp TIMESTAMP
                                ,p_endTstp TIMESTAMP
                                ,p_partitionInfoList IN OUT LIST_PARTITION_INFO_TYPE) RETURN BOOLEAN AS
                CURSOR CUR IS
                        SELECT HIGH_VALUE, PARTITION_NAME FROM USER_TAB_PARTITIONS WHERE TABLE_NAME = UPPER(p_tableName) ORDER BY PARTITION_POSITION;

                lt_part_min_val_tstp    TIMESTAMP;
                ld_part_high_val_tstp   TIMESTAMP;
                ld_prev_high_val_tstp   TIMESTAMP;
                lb_criteria_match       BOOLEAN := FALSE;
                lt_partitionInfo        B2B_PARTITION_INFO_TYPE;
                ln_count                NUMBER := p_partitionInfoList.Count + 1;
                lv_methodName           VARCHAR2(30) := 'GET_PARTITION_INFO';
        BEGIN
                IF (IS_TABLE_PARTITIONED(p_tableName, p_partitionColumn) = FALSE) THEN
                        LOG_DEBUG(lv_methodName, p_tableName || ' TABLE IS NOT PARTITIONINED ON COLUMN ' || p_partitionColumn);
                        RETURN FALSE;
                END IF;
                LOG_DEBUG(lv_methodName, 'p_tableName = '  || p_tableName || ',
                                p_partitionColumn = ' || p_partitionColumn ||',
                                p_startTstp = ' || p_startTstp || ',
                                p_endTstp = ' || p_endTstp);

                lt_part_min_val_tstp := TO_TIMESTAMP('1970-01-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS');
                LOG_INFO(lv_methodName, 'MIN PARTITION CHECK DATE' || lt_part_min_val_tstp);

                IF(p_startTstp IS NULL OR p_endTstp IS NULL) THEN
                        LOG_INFO(lv_methodName, 'End Date and Start Date are mandatory for partition cleanup. Hence proceeding with normal delete');
                        RETURN FALSE;
                ELSIF (p_startTstp IS NOT NULL AND p_startTstp > p_endTstp) THEN
                        LOG_ERROR(lv_methodName, 'End Date cannot be less than Start date. StartDate : ' || p_startTstp ||' EndDate : ' || p_endTstp);
                        RETURN FALSE;
                END IF;

                /*
                  LOOP THROUGH ALL THE PARTITIONS IN THE TABLE TO IDENTIFY PARTITIONS FOR DELETION.
                */
                FOR REC IN CUR
                LOOP
                        EXECUTE IMMEDIATE 'SELECT ' || REC.HIGH_VALUE ||' FROM DUAL' INTO ld_part_high_val_tstp;
                        LOG_DEBUG(lv_methodName, 'Partition Name : ' || REC.PARTITION_NAME || ', High Value : ' || REC.HIGH_VALUE );

                        IF(ld_prev_high_val_tstp IS NOT NULL AND ld_prev_high_val_tstp != lt_part_min_val_tstp) THEN
                                --ASSIGN THE PREV_HIGH_VAL TO MIN VAL. This is set up for multi-key partitions
                                LOG_DEBUG(lv_methodName, 'Assigning Min Value for partition from prev high Val: ' || TO_CHAR(ld_prev_high_val_tstp, 'YYYY-MM-DD HH24:MI:SS'));
                                lt_part_min_val_tstp:= ld_prev_high_val_tstp;
                        END IF;

                        LOG_DEBUG(lv_methodName, 'lt_part_min_val_tstp : ' || lt_part_min_val_tstp || ',p_startTstp : ' || p_startTstp || ',ld_part_high_val_tstp : ' ||ld_part_high_val_tstp  || ',p_endDate : ' ||p_endTstp );
                        IF ((lt_part_min_val_tstp >= p_startTstp OR (lt_part_min_val_tstp IS NULL AND ld_part_high_val_tstp  > p_startTstp )) AND ld_part_high_val_tstp <= p_endTstp) THEN
                                LOG_INFO(lv_methodName, 'Partition selected for pruning as interval includes the complete partition');
                                lt_partitionInfo := B2B_PARTITION_INFO_TYPE(REC.PARTITION_NAME, p_tableName, ' ');
                                p_partitionInfoList.EXTEND;
                                p_partitionInfoList(ln_count) := lt_partitionInfo;
                                LOG_DEBUG(lv_methodName, ln_count ||' ' || REC.PARTITION_NAME);
                                IF (ld_part_high_val_tstp = p_endTstp) THEN
                                        LOG_INFO(lv_methodName, 'Returning true as ' || ld_part_high_val_tstp ||' = ' || p_endTstp);
                                        RETURN lb_criteria_match;
                                ELSIF (lt_part_min_val_tstp = p_startTstp OR lt_part_min_val_tstp IS NULL) THEN
                                        LOG_INFO(lv_methodName, 'Setting lb_criteria_match  as true as min criteria matched lt_part_min_val_tstp =' || lt_part_min_val_tstp);
                                        lb_criteria_match := TRUE;
                                END IF;
                                ln_count:= ln_count +1;
                        ELSIF (ld_part_high_val_tstp > p_endTstp) THEN
                                LOG_INFO(lv_methodName, 'Returning false as ' || ld_part_high_val_tstp ||' > ' || p_endTstp);
                                RETURN FALSE;
                        END IF;
                        ld_prev_high_val_tstp:= ld_part_high_val_tstp;
                END LOOP;
                RETURN FALSE;
        END;

        FUNCTION IS_TABLE_PARTITIONED(p_tableName VARCHAR2, p_partitionColumn VARCHAR2) RETURN BOOLEAN AS
                ln_row_count    NUMBER := 0;
                lv_methodName   VARCHAR2(30) := 'IS_TABLE_PARTITIONED';
        BEGIN
                --The column position 1 indicates that this is the first key in the partition clause
                SELECT Count(1) INTO ln_row_count  FROM USER_PART_KEY_COLUMNS WHERE OBJECT_TYPE = 'TABLE' AND NAME = UPPER(p_tableName) AND COLUMN_NAME = UPPER(p_partitionColumn) AND COLUMN_POSITION = 1;
                IF ln_row_count = 1 THEN
                        RETURN TRUE;
                ELSE
                        RETURN FALSE;
                END IF;
        END;

        PROCEDURE CREATE_PARTITION_STATEMENTS(p_partitionInfoList IN OUT LIST_PARTITION_INFO_TYPE, p_dropPartition BOOLEAN DEFAULT TRUE, p_opFile VARCHAR2 DEFAULT NULL) AS
                lv_ddl_operation        VARCHAR2(30) := ' DROP ';
                luf_file_obj            UTL_FILE.FILE_TYPE;
                lv_methodName           VARCHAR2(30) := 'CREATE_PARTITION_STATEMENTS';
                lv_currSchema           VARCHAR2(30);
        BEGIN
                IF (p_dropPartition = FALSE) THEN
                        lv_ddl_operation :=  ' TRUNCATE ';
                END IF;
                IF (p_opFile IS NOT NULL) THEN
                        luf_file_obj := Utl_File.FOPEN('SOA_PURGE_DIR', p_opFile, 'W');
                END IF;
                SELECT SYS_CONTEXT( 'USERENV', 'CURRENT_SCHEMA' ) INTO lv_currSchema FROM DUAL;
                FOR i IN 1..p_partitionInfoList.Count
                LOOP
                        IF (p_partitionInfoList(i) IS NOT NULL) THEN
                                p_partitionInfoList(i).DDL_STATEMENT := 'ALTER TABLE ' || lv_currSchema || '.' || p_partitionInfoList(i).TABLE_NAME || lv_ddl_operation || 'PARTITION ' || p_partitionInfoList(i).PARTITION_NAME || ' UPDATE GLOBAL INDEXES';
                                LOG_DEBUG(lv_methodName, p_partitionInfoList(i).DDL_STATEMENT || ' ' || p_partitionInfoList(i).TABLE_NAME || ' ' || p_partitionInfoList(i).PARTITION_NAME );
                                IF (p_opFile IS NOT NULL) THEN
                                        UTL_FILE.PUT_LINE(luf_file_obj,p_partitionInfoList(i).DDL_STATEMENT || ';');
                                END IF;
                        ELSE
                                LOG_ERROR(lv_methodName, 'Position Val = ' || i || ' Partition Info is null');
                        END IF;
                END LOOP;

                IF (p_opFile IS NOT NULL AND Utl_File.IS_OPEN(luf_file_obj)) THEN
                        Utl_File.FCLOSE(luf_file_obj);
                END IF;
        END;

        PROCEDURE PURGE_INSTANCE_MSGS(p_startDate in VARCHAR2 default NULL
                                ,p_endDate in VARCHAR2 default NULL
                                ,p_msgState in VARCHAR2  default NULL
                                ,p_tpName in VARCHAR2  default NULL
                                ,p_direction in VARCHAR2  default NULL
                                ,p_msgType in VARCHAR2  default NULL
                                ,p_tpaName in VARCHAR2  default NULL
                                ,p_idType in VARCHAR2  default NULL
                                ,p_idVal in VARCHAR2  default NULL
                                ,p_shouldArchive in VARCHAR2 default NULL
                                ,p_archiveFileName in VARCHAR2 default NULL
                                ,p_force_del in VARCHAR2 default 'false'
                                ,p_tpaId in VARCHAR2  default NULL
                                ,p_action in VARCHAR2  default NULL
                                ,p_service in VARCHAR2  default NULL
                                ,p_docType in VARCHAR2  default NULL
                                ,p_commitFrequency number default 0
                                ,p_partitionMode in VARCHAR2 default 'DROP'
                                ,p_logMode in VARCHAR2 default NULL
                                ,p_rowLimit NUMBER default NULL
                                ,p_stop_time INTEGER default NULL
                                ,p_refreshMW in VARCHAR2  default NULL
                                ,p_includeOrphanRecs in VARCHAR2 default 'true') IS
                p_numOfRecordsPurged    number:= 0;
        BEGIN
                --INVOKE THE AUDIT_PURGE PROCEDURE WITH AUDIT = NULL
                PURGE_INSTANCE_MSGS_AUDIT(p_startDate => p_startDate
                                        ,p_endDate => p_endDate
                                        ,p_msgState => p_msgState
                                        ,p_tpName => p_tpName
                                        ,p_direction => p_direction
                                        ,p_msgType => p_msgType
                                        ,p_tpaName => p_tpaName
                                        ,p_idType => p_idType
                                        ,p_idVal => p_idVal
                                        ,p_shouldArchive => p_shouldArchive
                                        ,p_archiveFileName => p_archiveFileName
                                        ,p_force_del => p_force_del
                                        ,p_tpaId => p_tpaId
                                        ,p_action => p_action
                                        ,p_service => p_service
                                        ,p_docType => p_docType
                                        ,p_commitFrequency => p_commitFrequency
                                        ,p_partitionMode => p_partitionMode
                                        ,p_logMode => p_logMode
                                        ,p_rowLimit => p_rowLimit
                                        ,p_stop_time => p_stop_time
                                        ,p_refreshMW => p_refreshMW
                                        ,p_includeOrphanRecs => p_includeOrphanRecs
                                        ,p_numOfRecordsPurged => p_numOfRecordsPurged);
        END;


        PROCEDURE PURGE_INSTANCE_MSGS_AUDIT(
                                        p_startDate in VARCHAR2 default NULL
                                        ,p_endDate in VARCHAR2 default NULL
                                        ,p_msgState in VARCHAR2  default NULL
                                        ,p_tpName in VARCHAR2  default NULL
                                        ,p_direction in VARCHAR2  default NULL
                                        ,p_msgType in VARCHAR2  default NULL
                                        ,p_tpaName in VARCHAR2  default NULL
                                        ,p_idType in VARCHAR2  default NULL
                                        ,p_idVal in VARCHAR2  default NULL
                                        ,p_shouldArchive in VARCHAR2 default 'false'
                                        ,p_archiveFileName in VARCHAR2 default NULL
                                        ,p_force_del in VARCHAR2 default 'false'
                                        ,p_tpaId in VARCHAR2  default NULL
                                        ,p_action in VARCHAR2  default NULL
                                        ,p_service in VARCHAR2  default NULL
                                        ,p_docType in VARCHAR2  default NULL
                                        ,p_commitFrequency number default 0
                                        ,p_auditId in VARCHAR2 default NULL
                                        ,p_partitionMode in VARCHAR2 default 'DROP'
                                        ,p_logMode in VARCHAR2 default NULL
                                        ,p_rowLimit NUMBER default NULL
                                        ,p_stop_time INTEGER default NULL
                                        ,p_refreshMW in VARCHAR2  default NULL
                                        ,p_includeOrphanRecs in VARCHAR2 default 'true'
                                        ,p_numOfRecordsPurged out NUMBER) IS

                lv_tmpFileName  VARCHAR2(100);
                lv_methodName   VARCHAR2(30) := 'PURGE_INSTANCE_MSGS_AUDIT';
                lv_refreshMW    VARCHAR2(30);
                ln_invalidParamCode NUMBER:=-20000;

                --Commit Frequency control variables
                ln_start                NUMBER:=1;
                ln_end                  NUMBER:=5000;
                ln_commitFrequency      NUMBER:=ln_end;
                ln_count                NUMBER := 0;

                --Partitioning variables
                lb_dateOnly                     BOOLEAN := TRUE;
                lb_pruningComplete      BOOLEAN := FALSE;
                lt_partitionInfo        LIST_PARTITION_INFO_TYPE := LIST_PARTITION_INFO_TYPE();
                lb_ds_pruning           BOOLEAN := FALSE;
                lb_wm_pruning           BOOLEAN := FALSE;
                lb_am_pruning           BOOLEAN := FALSE;
                lb_bm_pruning           BOOLEAN := FALSE;
                lb_extbm_pruning        BOOLEAN := FALSE;
                lb_dropPartition        BOOLEAN := TRUE;
                lv_queryFile            VARCHAR2(30);
                lt_startTstp            TIMESTAMP;
                lt_endTstp                      TIMESTAMP;

                --Timeout Variable
                ld_stopTime                     DATE;
                lb_tempCreated          BOOLEAN := FALSE;
        BEGIN
                INIT_LOG(p_logMode);
                LOG_DEBUG(lv_methodName,
                        'p_startDate = '  || p_startDate || ',
                        p_endDate = ' || p_endDate || ',
                        p_msgState = ' || p_msgState || ',
                        p_tpName = ' || p_tpName || ',
                        p_direction = ' || p_direction || ',
                        p_msgType = ' || p_msgType || ',
                        p_tpaName = ' || p_tpaName || ',
                        p_idType = ' || p_idType || ',
                        p_idVal = ' || p_idVal || ',
                        p_shouldArchive = ' || p_shouldArchive || ',
                        p_archiveFileName = ' || p_archiveFileName || ',
                        p_force_del = ' || p_force_del || ',
                        p_tpaId = ' || p_tpaId || ',
                        p_action = ' || p_action || ',
                        p_service = ' || p_service || ',
                        p_docType = ' || p_docType || ',
                        p_commitFrequency = ' || p_commitFrequency || ',
                        p_auditId = ' || p_auditId || ',
                        p_partitionMode = ' || p_partitionMode || ',
                        p_logMode = '|| p_logMode ||',
                        p_rowLimit = ' || p_rowLimit ||',
                        p_stop_time = ' || p_stop_time || ',
                        p_refreshMW = ' || p_refreshMW || ',
                        p_includeOrphanRecs = ' || p_includeOrphanRecs);

                if (p_shouldArchive = 'true' and (p_rowLimit is not null or p_stop_time is not null)) then
                        RAISE_APPLICATION_ERROR(ln_invalidParamCode,'Archive operation not supported with rowlimit and stop time parameters');
                end if;

                if (p_stop_time is not null) then
                        ld_stopTime := sysdate + (p_stop_time /(24 * 60));
                end if;

                if(p_commitFrequency is not null and p_commitFrequency!= 0) then
                        ln_commitFrequency := p_commitFrequency;
                        ln_end := p_commitFrequency;
                end if;

                lv_refreshMW := p_refreshMW;
                p_numOfRecordsPurged := 0;

                if ((p_startDate is not null) AND (p_endDate is not null)) then
                        if (p_msgState IS NOT NULL OR p_tpName IS NOT NULL OR p_direction IS NOT NULL OR
                                p_msgType IS NOT NULL OR p_tpaName IS NOT NULL OR p_idType IS NOT NULL OR
                                p_idVal IS NOT NULL OR p_tpaId IS NOT NULL OR p_action IS NOT NULL OR
                                p_service IS NOT NULL OR p_docType IS NOT NULL OR p_rowLimit is NOT NULL) then
                                --If date is the ONLY condition partition pruning would be possible
                                lb_dateOnly := false;
                                LOG_INFO(lv_methodName, 'Partition evaluation not done as non-date conditions are specified');
                        end if;
                        lt_startTstp := TO_TIMESTAMP(p_startDate, 'YYYY-MM-DD HH24:MI:SS');
                        lt_endTstp := TO_TIMESTAMP(p_endDate, 'YYYY-MM-DD HH24:MI:SS');
                else
                        LOG_INFO(lv_methodName, 'Partition evaluation not done as date conditions are not specified');
                        lb_dateOnly := false;
                end if;

                if (p_shouldArchive = 'true') then
                        lv_tmpFileName := p_archiveFileName;
                        if (lv_tmpFileName is  null) then
                                lv_tmpFileName :=  to_char(sysdate, 'DD-Mon-YYYY-HH24:MI:SS');
                                lv_tmpFileName := lv_tmpFileName || '.dmp';
                        end if;

                        ARCHIVE_INSTANCE_MSGS(
                                        p_startDate => p_startDate
                                        ,p_endDate => p_endDate
                                        ,p_msgState => p_msgState
                                        ,p_tpName => p_tpName
                                        ,p_direction => p_direction
                                        ,p_msgType => p_msgType
                                        ,p_tpaName => p_tpaName
                                        ,p_idType => p_idType
                                        ,p_idVal => p_idVal
                                        ,p_tpaId => p_tpaId
                                        ,p_action => p_action
                                        ,p_service => p_service
                                        ,p_docType => p_docType
                                        ,p_archiveFileName => lv_tmpFileName
                                        ,p_commitFrequency => p_commitFrequency
                                        ,p_includeOrphanRecs => p_includeOrphanRecs);

                        lb_tempCreated:= TRUE;
                end if ;

                if (lb_dateOnly = true AND p_rowLimit IS NULL) then
                        --Ensure there is only a date filter and no limits on the number of records be purged.
                        lb_bm_pruning := GET_PARTITION_INFO('B2B_BUSINESS_MESSAGE', 'CPST_INST_CREATED_TIME', lt_startTstp, lt_endTstp,lt_partitionInfo);
                        --proceed only if the business Message table is partitioned
                        if(lt_partitionInfo.Count != 0) then
                                lb_ds_pruning := GET_PARTITION_INFO('B2B_DATA_STORAGE', 'CPST_INST_CREATED_TIME', lt_startTstp, lt_endTstp,lt_partitionInfo);
                                lb_am_pruning := GET_PARTITION_INFO('B2B_APP_MESSAGE', 'CPST_INST_CREATED_TIME', lt_startTstp, lt_endTstp,lt_partitionInfo);
                                lb_wm_pruning := GET_PARTITION_INFO('B2B_WIRE_MESSAGE', 'CPST_INST_CREATED_TIME', lt_startTstp, lt_endTstp,lt_partitionInfo);
                                lb_extbm_pruning := GET_PARTITION_INFO('B2B_EXT_BUSINESS_MESSAGE', 'CPST_INST_CREATED_TIME', lt_startTstp, lt_endTstp,lt_partitionInfo);

                                if(p_partitionMode = 'TRUNCATE') then
                                        lb_dropPartition:= false;
                                elsif (p_partitionMode = 'STATEMENT') then
                                        lv_queryFile := 'dropPartition.sql';
                                end if;
                                CREATE_PARTITION_STATEMENTS(p_partitionInfoList => lt_partitionInfo, p_dropPartition => lb_dropPartition, p_opFile => lv_queryFile);

                                if(p_partitionMode != 'STATEMENT') then
                                        if(p_refreshMW is null) then
                                                lv_refreshMW := 'true';
                                        end if;
                                        for i IN 1..lt_partitionInfo.Count LOOP
                                                LOG_INFO(lv_methodName, 'Executing ' || lt_partitionInfo(i).DDL_STATEMENT);
                                                if(lt_partitionInfo(i).TABLE_NAME = 'B2B_BUSINESS_MESSAGE') then
                                                        if(p_auditId IS NOT NULL) then
                                                                LOG_DEBUG(lv_methodName, 'Executing INSERT INTO B2B_AUDIT_TEMP (select :1, message_id from B2B_BUSINESS_MESSAGE PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || '))'); 
                                                                EXECUTE IMMEDIATE 'INSERT INTO B2B_AUDIT_TEMP (select :1, message_id from B2B_BUSINESS_MESSAGE PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || '))' using p_auditId;
                                                        end if;
                                                        LOG_DEBUG(lv_methodName, 'Executing DELETE FROM b2b_pending_message a where exists (select id from B2B_BUSINESS_MESSAGE PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || ') b where a.message_id = b.message_id)'); 
                                                        EXECUTE IMMEDIATE 'DELETE FROM b2b_pending_message a where exists (select id from B2B_BUSINESS_MESSAGE PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || ') b where a.message_id = b.message_id)';
                                                        EXECUTE IMMEDIATE 'DELETE FROM b2b_sequence_manager a where exists (select id from B2B_BUSINESS_MESSAGE PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || ') b where a.message_id = b.message_id)';
                                                        LOG_DEBUG(lv_methodName, 'select count(*) from ' || lt_partitionInfo(i).TABLE_NAME || ' PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || ')' );
                                                        EXECUTE IMMEDIATE 'select count(*) from B2B_BUSINESS_MESSAGE PARTITION(' || lt_partitionInfo(i).PARTITION_NAME || ')' into ln_count;

                                                        EXECUTE IMMEDIATE lt_partitionInfo(i).DDL_STATEMENT;
                                                        LOG_INFO(lv_methodName, ln_count || ' records were cleared through ' || p_partitionMode || ' of partition ' || lt_partitionInfo(i).PARTITION_NAME);
                                                        p_numOfRecordsPurged := p_numOfRecordsPurged + ln_count;
                                                else
                                                        EXECUTE IMMEDIATE lt_partitionInfo(i).DDL_STATEMENT;
                                                end if;
                                        END LOOP;
                                else
                                        LOG_INFO(lv_methodName, 'Not proceeding to purge as STATEMENT mode was used.');
                                        return;
                                end if;

                                IF(lb_ds_pruning =TRUE AND lb_am_pruning = TRUE AND lb_wm_pruning = TRUE AND lb_extbm_pruning = TRUE AND lb_bm_pruning=TRUE ) THEN
                                        lb_pruningComplete := TRUE;
                                        LOG_INFO(lv_methodName, 'Pruning is complete through partition management. No delete required.');
                                END IF;
                        end if;
                end if;

                IF (lb_pruningComplete = FALSE AND p_partitionMode != 'STATEMENT') THEN
                        IF (lb_tempCreated = FALSE) then
                                CREATE_TEMP_TABLE(
                                         p_startDate => p_startDate
                                        ,p_endDate => p_endDate
                                        ,p_msgState => p_msgState
                                        ,p_tpName => p_tpName
                                        ,p_direction => p_direction
                                        ,p_msgType => p_msgType
                                        ,p_tpaName => p_tpaName
                                        ,p_idType => p_idType
                                        ,p_idVal => p_idVal
                                        ,p_tpaId => p_tpaId
                                        ,p_action => p_action
                                        ,p_service => p_service
                                        ,p_docType => p_docType
                                        ,p_rowLimit => p_rowLimit
                                        ,p_dateOnly => lb_dateOnly
                                        ,p_includeOrphanRecs => p_includeOrphanRecs);
                                lb_tempCreated:= TRUE;
                        END IF;

                        LOOP
                                if(ld_stopTime is not null and sysdate > ld_stopTime) then
                                        LOG_INFO(lv_methodName, 'Exiting method as time limit exceeded. Current time ' || TO_CHAR(sysdate,'DD-MON-YYYY HH24:MI:SS') || ' stopTime : ' || TO_CHAR(ld_stopTime, 'DD-MON-YYYY HH24:MI:SS'));
                                end if;
                                EXIT WHEN (ld_stopTime is not null and sysdate > ld_stopTime);
                                LOG_DEBUG(lv_methodName, 'Looping through for deletion with ln_start = ' || ln_start || ' ln_end = ' || ln_end);
                                EXECUTE IMMEDIATE 'DELETE from b2b_data_storage WHERE id in (
                                        select payload_storage from b2b_temp where payload_storage is not null and row_number between :1 and :2
                                        union all
                                        select packed_message from b2b_temp where packed_message is not null and row_number between :3 and :4
                                        union all
                                        select payload from b2b_temp where payload is not null and row_number between :5 and :6
                                        union all
                                        select wmps from b2b_temp where wmps is not null and row_number between :7 and :8
                                        union all
                                        select native_data_storage from b2b_temp where native_data_storage is not null and row_number between :9 and :10
                                        union all
                                        select translated_data_storage from b2b_temp where translated_data_storage is not null and row_number between :11 and :12
                                        union all
                                        select amas from b2b_temp where amas is not null and row_number between :13 and :14
                                        union all
                                        select attachment_storage from b2b_temp where attachment_storage is not null and row_number between :15 and :16)'
                                        using ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_data_storage in this loop');
                                EXECUTE IMMEDIATE 'DELETE from b2b_app_message WHERE id in (select app_message from b2b_temp where row_number between :1 and :2)' using ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_app_message in this loop');
                                EXECUTE IMMEDIATE 'DELETE from b2b_wire_message WHERE id in (select wire_message from b2b_temp where row_number between :1 and :2)' using ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_wire_message in this loop');
                                EXECUTE IMMEDIATE 'DELETE from b2b_ext_business_message WHERE id in (select ext from b2b_temp where ext is not null and row_number between :1 and :2)' using ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_ext_business_message in this loop');
                                EXECUTE IMMEDIATE 'DELETE from b2b_business_message WHERE id in (select id from b2b_temp where id not in (''APP_MESSAGE'', ''WIRE_MESSAGE'') and row_number between :1 and :2)' using ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_business_message in this loop');
                                EXECUTE IMMEDIATE 'DELETE FROM b2b_pending_message where message_id in (select message_id from b2b_temp where id not in (''APP_MESSAGE'', ''WIRE_MESSAGE'') and row_number between :1 and :2)' using ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_pending_message in this loop');
                                EXECUTE IMMEDIATE 'DELETE from b2b_sequence_manager WHERE b2b_sequence_manager.message_id in (select message_id from b2b_temp where message_id not in (''APP_MESSAGE'', ''WIRE_MESSAGE'')  and row_number between :1 and :2)' using ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows deleted from b2b_sequence_manager in this loop');
                                if(p_auditId IS NOT NULL) THEN
                                        EXECUTE IMMEDIATE 'INSERT INTO B2B_AUDIT_TEMP (select :1, message_id from b2b_temp where row_number between :2 and :3)' using  p_auditId,ln_start, ln_end;
                                        LOG_DEBUG(lv_methodName, sql%rowcount ||' rows inserted into AUDIT table');
                                END IF;
                                EXECUTE IMMEDIATE 'DELETE from b2b_temp where row_number between :1 and :2' using ln_start, ln_end;
                                ln_count:= sql%rowcount;
                                commit;
                                --Set Out variable
                                p_numOfRecordsPurged := p_numOfRecordsPurged + ln_count;
                                ln_start :=ln_end + 1;
                                ln_end := ln_start + (ln_commitFrequency -1);
                                EXIT WHEN ln_count = 0;
                        END LOOP;
                        COMMIT;
                END IF;
                if(lv_refreshMW = 'true') then
                        LOG_INFO(lv_methodName, 'Issuing Complete refresh on Materialized View');
                        b2b_refresh_mv();
                        LOG_INFO(lv_methodName, 'Materialized View refresh completed');
                end if;
                CLOSE_LOG(p_logMode);
        EXCEPTION
                WHEN OTHERS THEN
                        LOG_ERROR(lv_methodName, 'SQLCode : ' || sqlcode || ' Message : ' || sqlerrm);
                        ROLLBACK;
                        CLOSE_LOG(p_logMode);
                        RAISE;
        END;

	PROCEDURE PURGE_RUNTIME_BY_MSG_ID (msg_id IN VARCHAR2 default NULL) AS
		CURSOR b2b_cur IS
   		SELECT ID FROM B2B_BUSINESS_MESSAGE WHERE MESSAGE_ID = msg_id;
	BEGIN
		FOR b2b_rec IN b2b_cur
   		LOOP
			B2B_PURGE.PURGE_RUNTIME_BY_ID(b2b_rec.id);
		END LOOP;
	END;
		

	PROCEDURE PURGE_RUNTIME_BY_ID (p_bmId IN VARCHAR2 default NULL) AS
		wmid VARCHAR2(256);

		CURSOR b2b_cur IS
      		SELECT 
			bm.id bm_id, bm.state, bm.message_id, ext.id ext_bm_id,
			bm.payload_storage, bm.attachment_storage, bm.native_data_storage, bm.translated_data_storage,
	              	wm.id wm_id,  wm.packed_message, wm.payload_storage wmps,  
	              	am.id am_id, am.payload, am.attachment_storage amas
       		FROM 
			b2b_business_message bm, 
			b2b_wire_message wm, 
			b2b_app_message am, 
			b2b_ext_business_message ext
       		WHERE                                                            
       			(bm.wire_message = wmid or (bm.id = p_bmId and wmid is null))
			AND bm.wire_message = wm.id (+)
       			AND bm.ext_business_message = ext.id (+)
       			AND bm.app_message = am.id (+);

	BEGIN
		BEGIN
			SELECT WIRE_MESSAGE INTO wmid from b2b_business_message bm where bm.id = p_bmId;
		EXCEPTION
			 WHEN NO_DATA_FOUND THEN
			 wmid := null;
		END;
		
		FOR b2b_rec IN b2b_cur
   		LOOP
			DELETE FROM b2b_app_message WHERE id = b2b_rec.am_id;
			DELETE FROM b2b_app_message WHERE id IN (SELECT app_message FROM b2b_business_message 
				WHERE wire_message = b2b_rec.wm_id);
			DELETE FROM b2b_business_message WHERE id = b2b_rec.bm_id;  
			DELETE FROM b2b_business_message WHERE wire_message = b2b_rec.wm_id;				
			IF b2b_rec.state='MSG_WAIT_BATCH' THEN
				DELETE FROM b2b_pending_message where message_id = b2b_rec.message_id;
			END IF;
			DELETE FROM b2b_sequence_manager WHERE  message_id =  b2b_rec.message_id;			
			DELETE FROM b2b_ext_business_message WHERE id = b2b_rec.ext_bm_id;      			
			DELETE FROM b2b_wire_message WHERE id = b2b_rec.wm_id;      			   				
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.payload_storage; 
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.attachment_storage;
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.native_data_storage;
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.translated_data_storage;
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.packed_message;
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.wmps;
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.payload;
			DELETE FROM b2b_data_storage WHERE id = b2b_rec.amas;
   		END LOOP;
  		COMMIT;
	EXCEPTION
		WHEN OTHERS THEN
       		ROLLBACK;
       		RAISE;
	END;
	
        PROCEDURE ARCHIVE_INSTANCE_MSGS(p_startDate in VARCHAR2 default NULL
                                ,p_endDate in VARCHAR2 default NULL
                                ,p_msgState in VARCHAR2 default NULL
                                ,p_tpName in VARCHAR2 default NULL
                                ,p_direction in VARCHAR2 default NULL
                                ,p_msgType in VARCHAR2 default NULL
                                ,p_tpaName in VARCHAR2 default NULL
                                ,p_idType in VARCHAR2 default NULL
                                ,p_idVal in VARCHAR2 default NULL
                                ,p_tpaId in VARCHAR2 default NULL
                                ,p_action in VARCHAR2 default NULL
                                ,p_service in VARCHAR2 default NULL
                                ,p_docType in VARCHAR2 default NULL
                                ,p_archiveFileName IN VARCHAR2
                                ,p_commitFrequency number default 0
                                ,p_logMode in VARCHAR2 default NULL
                                ,p_includeOrphanRecs in VARCHAR2 default 'true') AS
                lr_jobId                RAW(16);
                lv_methodName           VARCHAR2(30) := 'ARCHIVE_INSTANCE_MSGS';

                --Commit Frequency control variables
                ln_start                NUMBER:=1;
                ln_end                  NUMBER:=5000;
                ln_commitFrequency      NUMBER:=ln_end;
                ln_numRows              NUMBER := 0;
                lb_dateOnly  BOOLEAN := TRUE;
        BEGIN
                LOG_DEBUG(lv_methodName, 'ARCHIVE_INSTANCE_MSGS Called');
                INIT_LOG(p_logMode);
                LOG_DEBUG(lv_methodName,
                        'p_startDate = '  || p_startDate || ',
                        p_endDate = ' || p_endDate || ',
                        p_msgState = ' || p_msgState || ',
                        p_tpName = ' || p_tpName || ',
                        p_direction = ' || p_direction || ',
                        p_msgType = ' || p_msgType || ',
                        p_tpaName = ' || p_tpaName || ',
                        p_idType = ' || p_idType || ',
                        p_tpaId = ' || p_tpaId || ',
                        p_idVal = ' || p_idVal || ',
                        p_action = ' || p_action || ',
                        p_service = ' || p_service || ',
                        p_docType = ' || p_docType || ',
                        p_archiveFileName = ' || p_archiveFileName || ',
                        p_commitFrequency = ' || p_commitFrequency || ',
                        p_logMode = '|| p_logMode || ',
                        p_includeOrphanRecs = ' || p_includeOrphanRecs);

                if(p_commitFrequency is not null and p_commitFrequency!= 0) then
                        ln_commitFrequency := p_commitFrequency;
                        ln_end := p_commitFrequency;
                end if;

        lr_jobId := sys_guid();

                if ((p_startDate is not null) AND (p_endDate is not null)) then
                        if (p_msgState IS NOT NULL OR p_tpName IS NOT NULL OR p_direction IS NOT NULL OR
                                p_msgType IS NOT NULL OR p_tpaName IS NOT NULL OR p_idType IS NOT NULL OR
                                p_idVal IS NOT NULL OR p_tpaId IS NOT NULL OR p_action IS NOT NULL OR
                                p_service IS NOT NULL OR p_docType IS NOT NULL) then
                                --If date is the ONLY condition partition pruning would be possible
                                lb_dateOnly := false;
                                LOG_INFO(lv_methodName, 'Partition evaluation not done as non-date conditions are specified');
                        end if;
                else
                        LOG_INFO(lv_methodName, 'Partition evaluation not done as date conditions are not specified');
                        lb_dateOnly := false;
                end if;

                CREATE_TEMP_TABLE(
                         p_startDate => p_startDate
                        ,p_endDate => p_endDate
                        ,p_msgState => p_msgState
                        ,p_tpName => p_tpName
                        ,p_direction => p_direction
                        ,p_msgType => p_msgType
                        ,p_tpaName => p_tpaName
                        ,p_idType => p_idType
                        ,p_idVal => p_idVal
                        ,p_tpaId => p_tpaId
                        ,p_action => p_action
                        ,p_service => p_service
                        ,p_docType => p_docType
                        ,p_dateOnly => lb_dateOnly
                        ,p_includeOrphanRecs => p_includeOrphanRecs);

                EXECUTE IMMEDIATE 'select count(*) from b2b_temp' into ln_numRows;
                LOG_DEBUG(lv_methodName, ln_numRows || ' messages would be marked for archive with job id ' || lr_jobId);
                LOOP
                        EXECUTE IMMEDIATE 'UPDATE b2b_data_storage SET job_id = :1 WHERE id in (
                                select payload_storage from b2b_temp where payload_storage is not null and row_number between :2 and :3
                                union all
                                select packed_message from b2b_temp where packed_message is not null and row_number between :4 and :5
                                union all
                                select payload from b2b_temp where payload is not null and row_number between :6 and :7
                                union all
                                select wmps from b2b_temp where wmps is not null and row_number between :8 and :9
                                union all
                                select native_data_storage from b2b_temp where native_data_storage is not null and row_number between :10 and :11
                                union all
                                select translated_data_storage from b2b_temp where translated_data_storage is not null and row_number between :12 and :13
                                union all
                                select amas from b2b_temp where amas is not null and row_number between :14 and :15
                                union all
                                select attachment_storage from b2b_temp where attachment_storage is not null and row_number between :16 and :17)'
                                using lr_jobId, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end, ln_start, ln_end;
                                LOG_DEBUG(lv_methodName, sql%rowcount ||' rows marked for archive in b2b_data_storage');
                        EXECUTE IMMEDIATE 'UPDATE b2b_app_message SET job_id = :1  WHERE id in (select app_message from b2b_temp where row_number between :2 and :3)' using lr_jobId, ln_start, ln_end;
                        LOG_DEBUG(lv_methodName, sql%rowcount ||' rows marked for archive in b2b_app_message');
                        EXECUTE IMMEDIATE 'UPDATE b2b_wire_message SET job_id = :1 WHERE id in (select wire_message from b2b_temp where row_number between :2 and :3)' using lr_jobId, ln_start, ln_end;
                        LOG_DEBUG(lv_methodName, sql%rowcount ||' rows marked for archive in b2b_wire_message');
                        EXECUTE IMMEDIATE 'UPDATE b2b_ext_business_message SET job_id = :1 WHERE id in (select ext from b2b_temp where ext is not null and row_number between :2 and :3)' using lr_jobId, ln_start, ln_end;
                        LOG_DEBUG(lv_methodName, sql%rowcount ||' rows marked for archive in b2b_ext_business_message');
                        EXECUTE IMMEDIATE 'UPDATE b2b_business_message SET job_id = :1 WHERE id in (select id from b2b_temp where id not in (''APP_MESSAGE'', ''WIRE_MESSAGE'') and row_number between :2 and :3)' using lr_jobId, ln_start, ln_end;
                        LOG_DEBUG(lv_methodName, sql%rowcount ||' rows marked for archive in b2b_business_message');
                        commit;
                        ln_start :=ln_end + 1;
                        ln_end := ln_start + (ln_commitFrequency -1);
                        EXIT WHEN ln_start >= ln_numRows;
                END LOOP;
                COMMIT;
                LOG_INFO(lv_methodName, 'Calling export job to file name '||p_archiveFileName || ' Job Id for archive ' || lr_jobId);
                B2B_EXPORT_JOB(p_archiveFileName, lr_jobId);
                CLOSE_LOG(p_logMode);
                LOG_DEBUG(lv_methodName, 'ARCHIVE_INSTANCE_MSGS Completed');
        END;

        PROCEDURE CREATE_TEMP_TABLE(
                                        p_startDate in VARCHAR2 default NULL
                                        ,p_endDate in VARCHAR2 default NULL
                                        ,p_msgState in VARCHAR2  default NULL
                                        ,p_tpName in VARCHAR2  default NULL
                                        ,p_direction in VARCHAR2  default NULL
                                        ,p_msgType in VARCHAR2  default NULL
                                        ,p_tpaName in VARCHAR2  default NULL
                                        ,p_idType in VARCHAR2  default NULL
                                        ,p_idVal in VARCHAR2  default NULL
                                        ,p_tpaId in VARCHAR2  default NULL
                                        ,p_action in VARCHAR2  default NULL
                                        ,p_service in VARCHAR2  default NULL
                                        ,p_docType in VARCHAR2  default NULL
                                        ,p_rowLimit NUMBER default NULL
                                        ,p_dateOnly in BOOLEAN default false
                                        ,p_includeOrphanRecs in VARCHAR2 default 'true') IS
                --Query Forming Variables
                lv_query_filter         VARCHAR2(10000);
                lv_select                       VARCHAR2(10000);
                lv_wm_stmt                      VARCHAR2(10000);
                lv_am_stmt                      VARCHAR2(10000);
                lv_bm_am_batch_stmt	  VARCHAR2(10000);
                lv_column_name          VARCHAR2(30) := 'bm.SENDER_NAME';
                ln_invalidParamCode NUMBER:=-20000;
                ln_count                        NUMBER:=0;
                ln_offset                       NUMBER:=0;
                lv_methodName           VARCHAR2(20) := 'CREATE_TEMP_TABLE';
        BEGIN
                --Always intended to be called from a wrapper. Hence log level is not initialized.
                --This would inherit the log level from the current session
                LOG_DEBUG(lv_methodName,
                        'p_startDate = '  || p_startDate || ',
                        p_endDate = ' || p_endDate || ',
                        p_msgState = ' || p_msgState || ',
                        p_tpName = ' || p_tpName || ',
                        p_direction = ' || p_direction || ',
                        p_msgType = ' || p_msgType || ',
                        p_tpaName = ' || p_tpaName || ',
                        p_idType = ' || p_idType || ',
                        p_idVal = ' || p_idVal || ',
                        p_tpaId = ' || p_tpaId || ',
                        p_action = ' || p_action || ',
                        p_service = ' || p_service || ',
                        p_docType = ' || p_docType ||',
                        p_dateOnly = ' || CASE p_dateOnly when true then 'true' ELSE 'false' END ||',
                        p_includeOrphanRecs = ' || p_includeOrphanRecs);

                lv_select := 'SELECT  ROWNUM ROW_NUMBER,
                                        BM.ID,
                                        BM.STATE,
                                        BM.MESSAGE_ID,
                                        BM.EXT_BUSINESS_MESSAGE EXT,
                                        BM.PAYLOAD_STORAGE,
                                        BM.ATTACHMENT_STORAGE,
                                        BM.NATIVE_DATA_STORAGE,
                                        BM.TRANSLATED_DATA_STORAGE,
                                        BM.WIRE_MESSAGE,
                                        BM.APP_MESSAGE,
                                        WM.PACKED_MESSAGE,
                                        WM.PAYLOAD_STORAGE WMPS,
                                        AM.PAYLOAD,
                                        AM.ATTACHMENT_STORAGE AMAS
                                FROM    B2B_BUSINESS_MESSAGE BM,
                                        B2B_WIRE_MESSAGE WM,
                                        B2B_APP_MESSAGE AM,
                                        B2B_EXT_BUSINESS_MESSAGE EXT
                                WHERE ';

                --Orphan records
                lv_wm_stmt :=   'INSERT INTO B2B_TEMP (ROW_NUMBER, ID, MESSAGE_ID, PACKED_MESSAGE, WMPS, WIRE_MESSAGE)
                                SELECT ROWNUM + :1 ROW_NUMBER,
                                        ''WIRE_MESSAGE'',
                                        WM.MESSAGE_ID,
                                        WM.PACKED_MESSAGE,
                                        WM.PAYLOAD_STORAGE WMPS,
                                        ID WIREMESSAGE
                                FROM    B2B_WIRE_MESSAGE WM
                                WHERE   WM.CPST_INST_CREATED_TIME BETWEEN TO_TIMESTAMP(:2, ''YYYY-MM-DD HH24:MI:SS'') AND TO_TIMESTAMP(:3, ''YYYY-MM-DD HH24:MI:SS'')
                                AND NOT EXISTS (SELECT WIRE_MESSAGE FROM B2B_BUSINESS_MESSAGE BM WHERE BM.WIRE_MESSAGE = WM.ID)';

                lv_am_stmt :=   'INSERT INTO B2B_TEMP (ROW_NUMBER, ID, MESSAGE_ID, PAYLOAD, AMAS, APP_MESSAGE)
                                SELECT ROWNUM + :1 ROW_NUMBER,
                                        ''APP_MESSAGE'',
                                        NVL(AM.APP_MESSAGE_ID, ''APP_MESSAGE''),
                                        AM.PAYLOAD,
                                        AM.ATTACHMENT_STORAGE AMAS,
                                        ID APP_MESSAGE
                                FROM    B2B_APP_MESSAGE AM
                                WHERE   AM.CPST_INST_CREATED_TIME BETWEEN TO_TIMESTAMP(:2, ''YYYY-MM-DD HH24:MI:SS'') AND TO_TIMESTAMP(:3, ''YYYY-MM-DD HH24:MI:SS'')
                                AND NOT EXISTS (SELECT APP_MESSAGE FROM B2B_BUSINESS_MESSAGE BM WHERE BM.APP_MESSAGE = AM.ID)';
                                
                lv_bm_am_batch_stmt :=     'INSERT INTO B2B_TEMP (ROW_NUMBER, 
                																						ID,
                                        																STATE,
                                        																MESSAGE_ID,
                                        																EXT,
                                        																PAYLOAD_STORAGE,
                                        																ATTACHMENT_STORAGE,
                                        																NATIVE_DATA_STORAGE,
                                        																TRANSLATED_DATA_STORAGE,
                                        																WIRE_MESSAGE,
                                        																APP_MESSAGE,
                                        																PAYLOAD,
                                        																AMAS)    
                										SELECT  ROWNUM  + :1 ROW_NUMBER,
                                        					BM.ID,
                                        					BM.STATE,
                                        					BM.MESSAGE_ID,
                                        					BM.EXT_BUSINESS_MESSAGE EXT,
                                        					BM.PAYLOAD_STORAGE,
                                        					BM.ATTACHMENT_STORAGE,
                                        					BM.NATIVE_DATA_STORAGE,
                                        					BM.TRANSLATED_DATA_STORAGE,
                                        					BM.WIRE_MESSAGE,
                                        					BM.APP_MESSAGE,
                                        					AM.PAYLOAD,
                                       						AM.ATTACHMENT_STORAGE AMAS
                                        				FROM B2B_BUSINESS_MESSAGE BM, B2B_APP_MESSAGE AM, B2B_TEMP
                                        				WHERE BM.WIRE_MESSAGE = B2B_TEMP.WIRE_MESSAGE AND BM.APP_MESSAGE=AM.ID AND NOT EXISTS (SELECT MESSAGE_ID FROM B2B_TEMP WHERE BM.ID = B2B_TEMP.ID)'; 
              
                --Join Condition Always required
                lv_query_filter := '  bm.wire_message = wm.id (+) AND bm.ext_business_message = ext.id (+) AND bm.app_message = am.id (+) ';


                if ((p_startDate is not null) AND (p_endDate is not null)) then
                        lv_query_filter := lv_query_filter || ' AND bm.CPST_INST_CREATED_TIME between TO_TIMESTAMP(:1, ''YYYY-MM-DD HH24:MI:SS'') AND TO_TIMESTAMP(:2, ''YYYY-MM-DD HH24:MI:SS'') ';
                elsif (((p_startDate is null) AND (p_endDate is not null)) OR  ((p_startDate is not null) AND (p_endDate is null))) then
                        RAISE_APPLICATION_ERROR (ln_invalidParamCode,'Only one of the date params are entered. Ensure to provide values for both start date and end date');
                else
                        lv_query_filter := lv_query_filter || ' AND (1=1 OR :1 IS NULL OR :2 IS NULL) ';
                end if;

                if p_tpName is not null then
                        if (p_direction is not null and UPPER(p_direction) = 'INBOUND') then
                                lv_column_name := 'bm.SENDER_NAME' ;
                        elsif (p_direction is not null and UPPER(p_direction) = 'OUTBOUND') then
                                lv_column_name := 'bm.RECEIVER_NAME';
                        else
                                RAISE_APPLICATION_ERROR (ln_invalidParamCode,'tpName is provided without direction.');
                        end if;
                end if;

                ADD_TO_QUERY(p_msgState, 'bm.STATE', lv_query_filter, '3');
                ADD_TO_QUERY(p_tpName, lv_column_name, lv_query_filter, '4');
                ADD_TO_QUERY(p_direction, 'bm.DIRECTION', lv_query_filter, '5');
                ADD_TO_QUERY(p_msgType, 'bm.MESSAGE_TYPE', lv_query_filter, '6');
                ADD_TO_QUERY(p_tpaName, 'bm.TPA_NAME', lv_query_filter, '7');
                ADD_TO_QUERY(p_idType, 'bm.SENDER_ID_TYPE', lv_query_filter, '8');
                ADD_TO_QUERY(p_idVal, 'bm.SENDER_ID_VALUE', lv_query_filter, '9');
                ADD_TO_QUERY(p_tpaId, 'bm.TPA_ID', lv_query_filter, '10');
                ADD_TO_QUERY(p_action, 'substr(bm.attribute2,instr(bm.attribute2,' || ' ''#:#'' ' || ')+3)', lv_query_filter, '11');
                ADD_TO_QUERY(p_service, 'substr(bm.attribute2,1,instr(bm.attribute2,' || ' ''#:#'' ' || ')-1)', lv_query_filter, '12');
                ADD_TO_QUERY(p_docType, 'bm.DOCTYPE_NAME', lv_query_filter, '13');
                ADD_TO_QUERY(p_rowLimit, 'ROWNUM', lv_query_filter, '14', ' <= ');

                LOG_DEBUG(lv_methodName, lv_query_filter);

                BEGIN
                        EXECUTE IMMEDIATE 'DROP TABLE B2B_TEMP';
                EXCEPTION
                        WHEN others THEN
                        LOG_INFO(lv_methodName, 'Error dropping B2B_TEMP table, ignoring this error');
                END;

                LOG_INFO(lv_methodName, 'CREATE TABLE B2B_TEMP AS (' || lv_select || ' 1=2)');
                LOG_INFO(lv_methodName, 'INSERT INTO B2B_TEMP ' || lv_select || lv_query_filter);

                EXECUTE IMMEDIATE 'CREATE TABLE B2B_TEMP AS (' || lv_select || ' 1=2)';
                EXECUTE IMMEDIATE 'INSERT INTO B2B_TEMP ' || lv_select || lv_query_filter
                                using p_startDate, p_endDate, UPPER(p_msgState), p_tpName, UPPER(p_direction), p_msgType, p_tpaName, p_idType, p_idVal, p_tpaId, p_action, p_service, p_docType, p_rowLimit;
                ln_count := sql%rowcount;
                ln_offset := ln_count;
                LOG_INFO(lv_methodName, ln_count || ' rows inserted into the temp table with select from B2B_BUSINESS_MESSAGE table');

                if ( p_dateOnly = true and LOWER(p_includeOrphanRecs)= 'true') then
                        EXECUTE IMMEDIATE lv_wm_stmt using ln_offset, p_startDate, p_endDate;
                        ln_count := sql%rowcount;
                        ln_offset := ln_offset + ln_count;
                        LOG_INFO(lv_methodName, ln_count || ' rows inserted into the temp table from B2B_WIRE_MESSAGE for orphan record cleanup');
                        EXECUTE IMMEDIATE lv_am_stmt using ln_offset, p_startDate, p_endDate;
                        ln_count := sql%rowcount;
                        ln_offset := ln_offset + ln_count;
                        LOG_INFO(lv_methodName, ln_count || ' rows inserted into the temp table from B2B_APP_MESSAGE for orphan record cleanup');
                end if;
                
                 EXECUTE IMMEDIATE lv_bm_am_batch_stmt  using ln_offset;
                 ln_count := sql%rowcount;
                 LOG_INFO(lv_methodName, ln_count || ' rows inserted into the temp table from B2B_BUSINESS_MESSAGE and B2B_APP_MESSAGE for batch record cleanup');
       
        END;

        PROCEDURE ADD_TO_QUERY(p_value VARCHAR2
                        ,p_column VARCHAR2
                        ,p_query IN OUT VARCHAR2
                        ,p_bindNum VARCHAR2
                        ,p_eval VARCHAR2 DEFAULT ' = ') AS
        BEGIN
                IF(p_value IS NOT NULL) THEN
                        p_query := p_query || ' AND ' || p_column || p_eval || ':' || p_bindNum || ' ';
                ELSE
                        p_query := p_query || ' AND (1=1 OR :' || p_bindNum || ' IS NULL) ';
                END IF;
        END;


        PROCEDURE LOG_DEBUG(p_method VARCHAR2, p_logText VARCHAR2) AS
        BEGIN
                IF(gn_logLevel > 1) THEN
                        LOG('DEBUG: ' || p_method || ' : ' ||  p_logText);
        END IF;
        END;

        PROCEDURE LOG_INFO(p_method VARCHAR2, p_logText VARCHAR2) AS
        BEGIN
                IF(gn_logLevel > 0) THEN
                        LOG('INFO: ' || p_method || ' : ' ||  p_logText);
        END IF;
        END;

        PROCEDURE LOG_ERROR(p_method VARCHAR2, p_logText VARCHAR2) AS
        BEGIN
                LOG('ERROR: ' || p_method || ' : ' ||  p_logText);
        END;

        PROCEDURE LOG(p_logText VARCHAR2) AS
        BEGIN
                if UTL_FILE.IS_OPEN(guf_file_obj)=false  then
                        DBMS_OUTPUT.PUT_LINE(TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' : ' || p_logText);
                else
                        UTL_FILE.PUT_LINE(guf_file_obj,TO_CHAR(sysdate, 'DD-MON-YYYY HH24:MI:SS') || ' : ' || p_logText);
                end if;
        END;

        PROCEDURE INIT_LOG(p_logMode VARCHAR2) AS
        BEGIN
                if(p_logMode is not null) then

                        if(INSTR(UPPER(p_logMode), 'CONSOLE') = 1) then
                                if (UTL_FILE.IS_OPEN(guf_file_obj)=true) then
                                        Utl_File.FCLOSE(guf_file_obj);
                                end if;
                        elsif (UTL_FILE.IS_OPEN(guf_file_obj)=false) then
                                        guf_file_obj := Utl_File.FOPEN('SOA_PURGE_DIR', 'b2b_purge.log', 'W');
                        end if;

                        if(INSTR(UPPER(p_logMode), 'DEBUG') != 0) then
                                gn_logLevel:= 2;
                        elsif (INSTR(UPPER(p_logMode), 'INFO') != 0) then
                                gn_logLevel:= 1;
                        else
                                gn_logLevel:= 0;
                        end if;
                end if;
        EXCEPTION
                WHEN OTHERS THEN
                DBMS_OUTPUT.PUT_LINE('Unable to initialize logger. SQLCode : ' || sqlcode || ' Message : ' || sqlerrm);
                DBMS_OUTPUT.PUT_LINE('Ignoring the exception. Logging would happen in console/error mode.');
        END;

        PROCEDURE CLOSE_LOG(p_logMode VARCHAR2) AS
        BEGIN
                if (p_logMode is not null AND UTL_FILE.IS_OPEN(guf_file_obj)=true) then
                        Utl_File.FCLOSE(guf_file_obj);
                end if;
        END;

END B2B_PURGE;
/

-- oracle----------------------------------------------------------------------- 
-- B2B Instance View. Used by Instance API 

CREATE OR REPLACE VIEW b2b_instancemessage AS
(SELECT 
  bm.id, 
  bm.refer_to_message_id refertoid, 
  bm.message_id b2bmessageid, 
  bm.ack_mode acknowledgemode, 
  bm.modified messagedatetime, 
  bm.message_type messagetype, 
  bm.state, 
  bm.doc_remaining_retry remainingretry, 
  bm.direction, 
  bm.time_to_ack timetoack,
  bm.tpa_name,
  bm.xpath_expression1, 
  bm.xpath_expression2, 
  bm.xpath_expression3, 
  bm.xpath_name1, 
  bm.xpath_name2, 
  bm.xpath_name3, 
  bm.xpath_value1, 
  bm.xpath_value2, 
  bm.xpath_value3, 
  bm.document_definition,
  bm.created,
  bm.modified,
  bm.send_timestamp,
  bm.receive_timestamp,
  bm.native_msg_size,
  bm.translated_msg_size,
  bm.resubmit_count bm_resubmit_count,
  ext.error_code errorcode,
  ext.error_text errortext, 
  ext.error_description errordescription, 
  ext.processing_time,
  bm.doctype_name || ' ' || bm.doc_protocol_version documenttype, 
  ap.app_conv_id correlationid,                                                       
  ap.fabric_ecid,
  ap.fabric_composite_name,
  ap.resubmit_count am_resubmit_count,
  apds.blob_value app_payload,
  ext.txnset_control_number transactioncontrolnumber,
  ext.group_control_number groupcontrolnumber, 
  ext.interchange_control_number interchangecontrolnumber,
  ext.protocol_work_area protocolworkarea,
  wm.message_id b2bwiremessageid,
  wm.modified b2btimestamp, 
  wm.protocol_collaboration_id conversationid, 
  wm.protocol_message_id protocolmessageid, 
  wm.url, 
  wm.transport_protocol || ' ' || wm.transport_protocol_version transportprotocol, 
  wm.protocol_transport_binding transportheaders,
  wm.resubmit_count wm_resubmit_count,
  bm.doc_protocol_name || ' ' || bm.doc_protocol_version documentprotocol,                           
  ext.exchange_protocol_name || ' ' || ext.exchange_protocol_version exchangeprotocol,
  bm.tpa_id agreementid,                                                             
  bm.sender_name sendername,
  bm.sender_id_type || ' ' || bm.sender_id_value senderid, 
  bm.receiver_name receivername,
  bm.receiver_id_type || ' ' || bm.receiver_id_value receiverid,
  bmds.clob_value payload,
  wmds.blob_value wirepayload,
  wmds1.clob_value wirepayloadunpacked,
  substr(bm.attribute2,1,instr(bm.attribute2,'#:#')-1) SERVICE,
  substr(bm.attribute2,instr(bm.attribute2,'#:#')+3) ACTION,
  ext.correlation_flow_id correlationflowid
FROM
 b2b_business_message bm,
 b2b_data_storage bmds,
 b2b_data_storage wmds,
 b2b_data_storage wmds1,
 b2b_wire_message wm,
 b2b_ext_business_message ext,
 b2b_app_message ap,
 b2b_data_storage apds
WHERE
      bm.payload_storage = bmds.id (+) 
  AND bm.wire_message = wm.id (+)
  AND wm.packed_message = wmds.id (+) 
  AND bm.ext_business_message = ext.id (+)
  AND bm.app_message = ap.id (+)
  AND ap.payload = apds.id(+)
  AND wm.payload_storage = wmds1.id(+)
) WITH READ ONLY
/

-- ----------------------------------------------------------------------- 
-- Add sequence table entry for generating transaction CID values. 

INSERT INTO BEAM_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('SEQ_BEAM_TRANSACTION_CONTEXT', 0)
/

-- ----------------------------------------------------------------------- 
-- Add sequence table entry for generating DataObject ID values. 

INSERT INTO BEAM_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('SEQ_BEAM_DATAOBJECT', 0)
/

-- ----------------------------------------------------------------------- 
-- Add sequence table entry for generating Column ID values. 

INSERT INTO BEAM_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('SEQ_BEAM_COLUMN', 0)
/

-- ----------------------------------------------------------------------- 
-- Add sequence table entry for generating Alert Rules ID values. 

INSERT INTO BEAM_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('SEQ_BEAM_ALERT_RULE', 0)
/

-- ----------------------------------------------------------------------- 
-- Add sequence table entry for generating Alert Escalation ID values. 

INSERT INTO BEAM_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('SEQ_BEAM_ALERT_ESCALATION', 0)
/

-- ----------------------------------------------------------------------- 
-- Set BAM Schema Version property value. 

INSERT INTO BEAM_PROPERTY ("BEAM_OPTLOCK", "PROPERTY_NAME", "PROPERTY_VALUE") VALUES (1,'beam.server.schema.version', '12.2.1.4.0')
/

-- ----------------------------------------------------------------------- 
-- (REQUIRED FOR SQL SERVER ONLY) Define delete trigger to perform BEAM DataObject parent/child foreign key cascade delete. 

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace package collaxa
as

    procedure delete_ci( p_cikey in integer );

    procedure delete_cis_by_cmpst_iid( p_cmpst_id in varchar2,
                                        r_row_count out integer );

    procedure delete_cis_by_component_dn( p_domain_name  in varchar2,
                                          p_composite_name in varchar2,
                                          p_component_name in varchar2,
                                          p_composite_label in varchar2,
                                          p_composite_revision in varchar2,
                                        r_row_count out integer );

    procedure delete_cis_by_composite_dn( p_domain_name  in varchar2,
                                          p_composite_name in varchar2,
                                          p_composite_revision in varchar2,
                                        r_row_count out integer );

end collaxa;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace package body collaxa
as
    /**
     * procedure delete_ci
     *
     * Deletes a cube instance and all rows in other Collaxa tables that
     * reference the cube instance.  Since we don't have referential
     * integrity on the tables (for performance reasons), we need this
     * method to help clean up the database easily.
     */
    procedure delete_ci( p_cikey in integer )
    as
    begin
        -- Then cascade the delete to other tables with references
        --
        delete from cube_scope where cikey = p_cikey;
        delete from ci_indexes where cikey = p_cikey;
        delete from work_item where cikey = p_cikey;
        delete from wi_fault where cikey = p_cikey;
        delete from xml_document where document_id in (select ddmr.document_id from document_dlv_msg_ref ddmr, dlv_message dm where dm.message_guid=ddmr.message_guid and dm.cikey = p_cikey);
        delete from xml_document where document_id in (select dcr.document_id from document_ci_ref dcr where dcr.cikey = p_cikey);
        delete from document_dlv_msg_ref where message_guid in (select m.message_guid from dlv_message m where m.cikey = p_cikey);
        delete from headers_properties where message_guid in (select dm.message_guid from dlv_message dm where dm.cikey = p_cikey);
        delete from audit_counter where cikey = p_cikey;
        delete from dlv_message where cikey = p_cikey;
        delete from dlv_subscription where cikey = p_cikey;
        delete from dlv_aggregation where cikey = p_cikey;
        delete from audit_trail where cikey = p_cikey;
        delete from audit_details where cikey = p_cikey;
        delete from test_details where cikey = p_cikey;
        delete from document_ci_ref where cikey = p_cikey;
        delete from AG_INSTANCE where CIKEY = p_cikey;	
        delete from cube_instance where cikey = p_cikey;	
    end delete_ci;

    /**
     * procedure delete_cis_by_composite_instance_id
     *
     * Deletes all the cube instances in the system.  Since we don't have
     * referential integrity on the tables (for performance reasons), we
     * need this method to help clean up the database easily.
     */
    procedure delete_cis_by_cmpst_iid( p_cmpst_id in varchar2,
                                        r_row_count out integer )
    as

      cursor cikeys_cursor is select cikey from cube_instance where
                                          cmpst_id = p_cmpst_id;
	   begin

       for r_cikeys_cursor in cikeys_cursor loop
           delete from cube_scope where cikey = r_cikeys_cursor.cikey;
           delete from ci_indexes where cikey = r_cikeys_cursor.cikey;
           delete from work_item where cikey = r_cikeys_cursor.cikey;
           delete from wi_fault where cikey = r_cikeys_cursor.cikey;
           delete from xml_document where document_id in (select ddmr.document_id from document_dlv_msg_ref ddmr, dlv_message dm where dm.message_guid=ddmr.message_guid and dm.cikey = r_cikeys_cursor.cikey);
           delete from xml_document where document_id in (select dcr.document_id from document_ci_ref dcr where dcr.cikey = r_cikeys_cursor.cikey);
           delete from document_dlv_msg_ref where message_guid in (select m.message_guid from dlv_message m where m.cikey = r_cikeys_cursor.cikey);
           delete from headers_properties where message_guid in (select dm.message_guid from dlv_message dm where dm.cikey = r_cikeys_cursor.cikey);
           delete from audit_counter where cikey = r_cikeys_cursor.cikey;
           delete from audit_trail where cikey = r_cikeys_cursor.cikey;
           delete from audit_details where cikey = r_cikeys_cursor.cikey;
           delete from test_details where cikey = r_cikeys_cursor.cikey;
           delete from document_ci_ref where cikey = r_cikeys_cursor.cikey;
           delete from AG_INSTANCE where CIKEY = r_cikeys_cursor.cikey;
           delete from dlv_subscription where cikey = r_cikeys_cursor.cikey;
           delete from dlv_message where cikey = r_cikeys_cursor.cikey;
           r_row_count := r_row_count + 1;
       end loop;
       delete from cube_instance where cmpst_id = p_cmpst_id;
    end delete_cis_by_cmpst_iid;

    /**
     * procedure delete_cis_by_component_dn
     *
     * Deletes all the cube instances for the given component.  Since we don't have
     * referential integrity on the tables (for performance reasons), we
     * need this method to help clean up the database easily.
     */
     procedure delete_cis_by_component_dn( p_domain_name  in varchar2,
                                          p_composite_name in varchar2,
                                          p_component_name in varchar2,
                                          p_composite_label in varchar2,
                                          p_composite_revision in varchar2,
                                        r_row_count out integer )
    as
      cursor cikeys_cursor is select cikey from cube_instance where
                       component_name = p_component_name
                        and domain_name = p_domain_name 
                        and composite_name = p_composite_name
                        and composite_revision = p_composite_revision
                        and  composite_label = p_composite_label;
      begin
          for r_cikeys_cursor in cikeys_cursor loop
              delete from cube_scope where cikey = r_cikeys_cursor.cikey;
              delete from ci_indexes where cikey = r_cikeys_cursor.cikey;
              delete from work_item where cikey = r_cikeys_cursor.cikey;
              delete from wi_fault where cikey = r_cikeys_cursor.cikey;
              delete from xml_document where document_id in (select ddmr.document_id from document_dlv_msg_ref ddmr, dlv_message dm where dm.message_guid=ddmr.message_guid and dm.cikey = r_cikeys_cursor.cikey);
              delete from xml_document where document_id in (select dcr.document_id from document_ci_ref dcr where dcr.cikey = r_cikeys_cursor.cikey);
              delete from document_dlv_msg_ref where message_guid in (select m.message_guid from dlv_message m where m.cikey = r_cikeys_cursor.cikey);
              delete from headers_properties where message_guid in (select dm.message_guid from dlv_message dm where dm.cikey = r_cikeys_cursor.cikey);
              delete from audit_counter where cikey = r_cikeys_cursor.cikey;
              delete from audit_trail where cikey = r_cikeys_cursor.cikey;
              delete from audit_details where cikey = r_cikeys_cursor.cikey;
              delete from test_details where cikey = r_cikeys_cursor.cikey;
              delete from document_ci_ref where cikey = r_cikeys_cursor.cikey;
              delete from AG_INSTANCE where CIKEY = r_cikeys_cursor.cikey;
              r_row_count := r_row_count + 1;
          end loop;

          delete from dlv_subscription where composite_name = p_composite_name
                and domain_name = p_domain_name and 
                component_name = p_component_name and 
                composite_label = p_composite_label and
               composite_revision = p_composite_revision;
                
          delete from dlv_message where composite_name = p_composite_name
               and domain_name = p_domain_name 
               and component_name = p_component_name and 
                composite_label = p_composite_label and
               composite_revision = p_composite_revision;

        
          delete from cube_instance where composite_name = p_composite_name
               and domain_name = p_domain_name 
               and component_name = p_component_name and 
                composite_label = p_composite_label and
               composite_revision = p_composite_revision;

    end delete_cis_by_component_dn;

    /**
     * procedure delete_cis_by_composite_dn
     *
     * Deletes all the cube instances for the given composite.  Since we don't have
     * referential integrity on the tables (for performance reasons), we
     * need this method to help clean up the database easily.
     */
    procedure delete_cis_by_composite_dn( p_domain_name  in varchar2,
                                        p_composite_name in varchar2,
                                          p_composite_revision in varchar2,
                                        r_row_count out integer )
    as
      cursor cikeys_cursor is select cikey from cube_instance where
                                      domain_name = p_domain_name and composite_name = p_composite_name
                                      and composite_revision = p_composite_revision;
   begin
       for r_cikeys_cursor in cikeys_cursor loop
       delete from cube_scope where cikey = r_cikeys_cursor.cikey;
       delete from ci_indexes where cikey = r_cikeys_cursor.cikey;
       delete from work_item where cikey = r_cikeys_cursor.cikey;
       delete from wi_fault where cikey = r_cikeys_cursor.cikey; 
       delete from xml_document where document_id in (select ddmr.document_id from document_dlv_msg_ref ddmr, dlv_message dm where dm.message_guid=ddmr.message_guid and dm.cikey = r_cikeys_cursor.cikey);
       delete from xml_document where document_id in (select dcr.document_id from document_ci_ref dcr where dcr.cikey = r_cikeys_cursor.cikey);
       delete from document_dlv_msg_ref where message_guid in (select m.message_guid from dlv_message m where m.cikey = r_cikeys_cursor.cikey);
       delete from headers_properties where message_guid in (select dm.message_guid from dlv_message dm where dm.cikey = r_cikeys_cursor.cikey);
       delete from audit_counter where cikey = r_cikeys_cursor.cikey;
       delete from audit_trail where cikey = r_cikeys_cursor.cikey;
       delete from audit_details where cikey = r_cikeys_cursor.cikey;
       delete from test_details where cikey = r_cikeys_cursor.cikey;
       delete from document_ci_ref where cikey = r_cikeys_cursor.cikey;
       delete from AG_INSTANCE where CIKEY = r_cikeys_cursor.cikey;
       r_row_count := r_row_count + 1;
       end loop;

       delete from dlv_subscription where composite_name = p_composite_name
       and domain_name = p_domain_name and
       composite_revision = p_composite_revision;


       delete from dlv_message where composite_name = p_composite_name
                                     and domain_name = p_domain_name
                                     and composite_revision = p_composite_revision;

       delete from cube_instance where composite_name = p_composite_name
                                       and domain_name = p_domain_name
                                       and composite_revision = p_composite_revision;

      end delete_cis_by_composite_dn;
    
end collaxa;
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO CLUSTER_MASTER( NODE_ID ) values( -1 )
/

-- oracle----------------------------------------------------------------------- 
-- CI_PK to reverse 

alter index CI_PK rebuild reverse
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO ID_RANGE( RANGE_NAME, NEXT_RANGE ) values( 'cikey', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO ID_RANGE( RANGE_NAME, NEXT_RANGE ) values( 'cluster_node', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO LOAN_CUSTOMER values( '123-12-1234','demo1', 'demo1@otn.com', null, null )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO LOAN_CUSTOMER values( '087-65-4321','demo2', 'demo2@otn.com', null, null )
/

-- oracle----------------------------------------------------------------------- 
-- Insert Version Information 

INSERT INTO VERSION values( '12.2.1.4.0', 'oracle', 'SMALL', NULL)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW WI_EXPIRABLE
AS SELECT
    /*+ USE_NL(wi ci) */
    WI.CLUSTER_NODE_KEY, WI.CIKEY, WI.NODE_ID, WI.SCOPE_ID, WI.COUNT_ID, WI.LABEL,
    CI.DOMAIN_NAME, CI.COMPONENT_NAME, CI.COMPOSITE_NAME,
    CI.COMPOSITE_LABEL, CI.COMPOSITE_REVISION,
    CI.COMPONENTTYPE, CI.PRIORITY, WI.EXP_DATE, WI.MODIFY_DATE, WI.EXECUTION_TYPE
FROM
    WORK_ITEM WI, CUBE_INSTANCE CI
WHERE
    WI.CIKEY = CI.CIKEY AND
    WI.STATE <= 3 AND
    CI.STATE <= 3 AND
    WI.EXP_DATE IS NOT NULL AND
    WI.EXP_FLAG = 0
/

-- ----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW WI_EXPIRABLE_CLUSTER
AS SELECT
    /*+ INDEX (dlv_subscription DS_FK) */
    WI.CLUSTER_NODE_KEY, WI.CIKEY, WI.NODE_ID, WI.SCOPE_ID, WI.COUNT_ID, WI.LABEL,
    CI.DOMAIN_NAME, CI.COMPONENT_NAME, CI.COMPOSITE_NAME,
    CI.COMPOSITE_LABEL, CI.COMPOSITE_REVISION,
    CI.COMPONENTTYPE, CI.PRIORITY,
    WI.EXP_DATE, WI.MODIFY_DATE, CN.LAST_UPDATE
FROM
    WORK_ITEM WI INNER JOIN CUBE_INSTANCE CI ON WI.CIKEY = CI.CIKEY
    LEFT JOIN CLUSTER_NODE CN ON WI.CLUSTER_NODE_KEY = CN.NODE_ID
WHERE
    WI.CIKEY = CI.CIKEY AND
    WI.STATE <= 3 AND
    CI.STATE <= 3 AND
    WI.EXP_DATE IS NOT NULL AND
    WI.EXP_FLAG = 0
/

-- ----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW DS_UNRESOLVED
AS SELECT
    /*+ INDEX (dlv_subscription DS_FK) */
    SUBSCRIBER_ID, CONV_ID, CONV_TYPE, CIKEY, DOMAIN_NAME, COMPOSITE_NAME,
    COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, OPERATION_NAME, EVENT_NAME,
    PARTNER_LINK, SERVICE_NAME, SUBSCRIPTION_DATE, STATE, PROPERTIES
FROM
    DLV_SUBSCRIPTION
WHERE
    STATE = 0
/

-- ----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW DS_RESOLVED
AS SELECT
    /*+ INDEX (dlv_subscription DS_FK) */
    SUBSCRIBER_ID, CONV_ID, CONV_TYPE, CIKEY, DOMAIN_NAME, COMPOSITE_NAME,
    COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, OPERATION_NAME, EVENT_NAME,
    PARTNER_LINK, SERVICE_NAME, SUBSCRIPTION_DATE, STATE, PROPERTIES
FROM
    DLV_SUBSCRIPTION
WHERE
    STATE = 1
/

-- ----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW ADMIN_LIST_Ci
    AS SELECT CIKEY,
              COMPONENT_NAME,
              COMPOSITE_NAME,
              COMPOSITE_LABEL,
              COMPOSITE_REVISION,
              DOMAIN_NAME,
              CREATION_DATE as CI_CREATION_DATE,
              CREATOR as CI_CREATOR,
              MODIFY_DATE as CI_MODIFY_DATE,
              MODIFIER as CI_MODIFIER,
              STATE as CI_STATE,
              PRIORITY as CI_PRIORITY,
              TITLE,
              STATUS,
              STAGE,
              CONVERSATION_ID,
              METADATA,
              ROOT_ID,
              PARENT_ID,
              TEST_RUN_ID,
              ECID,
              CMPST_ID,
              TRACKING_LEVEL
       FROM CUBE_INSTANCE
/

-- ----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW ADMIN_LIST_CX
    AS SELECT CI.CIKEY,
              COMPONENT_NAME,
              COMPOSITE_NAME,
              COMPOSITE_LABEL,
              COMPOSITE_REVISION,
              DOMAIN_NAME,
              CREATION_DATE as CI_CREATION_DATE,
              CREATOR as CI_CREATOR,
              MODIFY_DATE as CI_MODIFY_DATE,
              MODIFIER as CI_MODIFIER,
              STATE as CI_STATE,
              PRIORITY as CI_PRIORITY,
              TITLE,
              STATUS,
              STAGE,
              CONVERSATION_ID,
              METADATA,
              ROOT_ID,
              PARENT_ID,
              INDEX_1,
              INDEX_2,
              INDEX_3,
              INDEX_4,
              INDEX_5,
              INDEX_6,
              CI.TEST_RUN_ID
       FROM CUBE_INSTANCE CI,
            CI_INDEXES CX
       WHERE CI.CIKEY = CX.CIKEY
/

-- oracle,db2,mysql----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW admin_list_td
    AS SELECT cikey,
              test_run_name,
              test_run_id,
              test_suite,
              test_location,
              test_status,
              test_result
       FROM test_details
/

-- oracle,db2,mysql----------------------------------------------------------------------- 
-- Unknown 

CREATE VIEW admin_list_tdef
    AS SELECT test_suite,
              location,
              type,
              creation_date,
              definition
       FROM test_definitions
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW ADMIN_LIST_WI AS
SELECT    FAULT.CIKEY      CIKEY,
          FAULT.NODE_ID    NODE_ID,
          FAULT.SCOPE_ID   SCOPE_ID,
          FAULT.COUNT_ID   COUNT_ID,
          FAULT.CREATION_DATE  WI_CREATION_DATE,
          NVL(WI.CREATOR, ' ')        WI_CREATOR,
          FAULT.MODIFY_DATE    WI_MODIFY_DATE,
          NVL(WI.MODIFIER, ' ')       WI_MODIFIER,
          NVL(WI.STATE, 9)          WI_STATE,
          WI.TRANSITION,
          WI.EXP_DATE,
          EXP_FLAG,
          WI.PRIORITY       WI_PRIORITY,
          WI.LABEL          LABEL,
          WI.CUSTOM_ID,
          WI.COMMENTS, 
          WI.REFERENCE_ID,
          WI.EXECUTION_TYPE,
          CI.COMPONENT_NAME AS COMPONENT_NAME,
          CI.TITLE TITLE, CI.ROOT_ID, CI.PARENT_ID, FAULT_NAME,
          FAULT.MESSAGE FAULT_MESSAGE
       , INDEX_1, INDEX_2, INDEX_3, INDEX_4, INDEX_5, INDEX_6
        FROM CUBE_INSTANCE CI, WORK_ITEM WI, WI_FAULT FAULT
        , CI_INDEXES INDEXES
        WHERE CI.CIKEY = FAULT.CIKEY
        AND FAULT.CIKEY     = WI.CIKEY (+)
        AND FAULT.NODE_ID   = WI.NODE_ID (+)
        AND FAULT.SCOPE_ID  = WI.SCOPE_ID (+)
        AND FAULT.COUNT_ID  = WI.COUNT_ID (+)
        AND INDEXES.CIKEY (+) = CI.CIKEY
UNION  ALL
SELECT    WI.CIKEY      CIKEY,
          WI.NODE_ID    NODE_ID,
          WI.SCOPE_ID   SCOPE_ID,
          WI.COUNT_ID   COUNT_ID,
          WI.CREATION_DATE  WI_CREATION_DATE,
          WI.CREATOR        WI_CREATOR,
          WI.MODIFY_DATE    WI_MODIFY_DATE,
          WI.MODIFIER       WI_MODIFIER,
          WI.STATE          WI_STATE,
          WI.TRANSITION,
          WI.EXP_DATE,
          EXP_FLAG,
          WI.PRIORITY       WI_PRIORITY,
          WI.LABEL          LABEL,
          WI.CUSTOM_ID,  
          WI.COMMENTS,      
          WI.REFERENCE_ID,  
          WI.EXECUTION_TYPE,
          CI.COMPONENT_NAME AS COMPONENT_NAME,
          CI.TITLE TITLE, CI.ROOT_ID, CI.PARENT_ID, FAULT_NAME,
          FAULT.MESSAGE FAULT_MESSAGE
        , INDEX_1, INDEX_2, INDEX_3, INDEX_4, INDEX_5, INDEX_6
        FROM CUBE_INSTANCE CI, WORK_ITEM WI, WI_FAULT FAULT
        , CI_INDEXES INDEXES
        WHERE CI.CIKEY = WI.CIKEY
        AND FAULT.CIKEY  (+) = WI.CIKEY 
        AND FAULT.NODE_ID  (+)= WI.NODE_ID
        AND FAULT.SCOPE_ID  (+)= WI.SCOPE_ID
        AND FAULT.COUNT_ID  (+)= WI.COUNT_ID
        AND INDEXES.CIKEY (+) = CI.CIKEY
        AND WI.STATE != 13
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace view dbg_wi
as select cikey, node_id, scope_id, count_id,
          to_char( creation_date, 'mm/dd/yyyy hh24:mi:ss' ) creation_date,
          state, transition
   from work_item
   order by creation_date asc
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace view activity_perf
as select cikey, node_id, label, creation_date, modify_date,
          (86400 * (modify_date - creation_date)) eval_time
   from work_item
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace view instance_perf
as select cikey,  creation_date, modify_date,
          (86400 * (modify_date - creation_date)) eval_time
   from cube_instance
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE  OR REPLACE VIEW BPEL_FAULTS_VW AS
SELECT
        CI.ECID ECID,
        COMPOSITE_INSTANCE.ID,
        COMPONENT_NAME,
        CI.DOMAIN_NAME,
        CI.COMPOSITE_NAME,
        CI.COMPOSITE_REVISION ,
        CI.COMPOSITE_LABEL AS COMPONENT_LABEL,
        FAULT.CIKEY ,
        FAULT.NODE_ID, FAULT.SCOPE_ID, FAULT.COUNT_ID,
        FAULT.CREATION_DATE WI_CREATION_DATE,
        FAULT.MODIFY_DATE WI_MODIFY_DATE,
        NVL(WI.STATE, 9) WI_STATE,
        WI.LABEL, WI.COMMENTS, WI.REFERENCE_ID,
        WI.EXECUTION_TYPE,
        FAULT_NAME, FAULT_TYPE,
        FAULT.MESSAGE FAULT_MESSAGE
FROM CUBE_INSTANCE CI, WORK_ITEM WI, WI_FAULT FAULT, COMPOSITE_INSTANCE
WHERE CI.CIKEY = FAULT.CIKEY
   AND FAULT.CIKEY  = WI.CIKEY (+)
   AND FAULT.NODE_ID  = WI.NODE_ID (+)
   AND FAULT.SCOPE_ID  = WI.SCOPE_ID (+)
   AND FAULT.COUNT_ID  = WI.COUNT_ID (+)
   AND CI.ECID = COMPOSITE_INSTANCE.ECID
   AND ( WI.STATE IS NULL OR WI.STATE IN ('4', '9','13'))
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW BPM_PROCESS_PARTNER_SERVICE_V
AS
SELECT proc.Id              as ProcessId,
       plnk.Id              as PartnerLinkId,
       srvc.Id              as PartnerServiceId,
       proc.ApplicationName as ApplicationName,
       proc.CompositeName   as CompositeName,
       proc.Revision        as Revision,
       proc.Label           as Label,
       proc.Name           as ProcessName,
       plnk.Name            as PartnerLinkName,
       plnk.LinkType        as PartnerLinkType,
       plnk.MyRole          as MyRole,
       plnk.PartnerRole     as PartnerRole,
       srvc.PortType        as PortType,
       srvc.Operation       as Operation,
       srvc.IsInitiating    as IsInitiating
  FROM BPM_PROCESS proc,
       BPM_PROCESS_PARTNER plnk,
       BPM_PARTNER_SERVICE srvc
 WHERE plnk.process   = proc.id AND
       plnk.id        = srvc.partner(+) AND
       plnk.process   = srvc.process(+)
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW CI_AVG_PROCESSING_TIME
AS 
SELECT 	CI.composite_name, 
	CI.component_name,  
	count(0) as INSTANCES, 
	round (avg (substr ((modify_date - creation_date), instr  ((modify_date - creation_date) , ' ') + 1,2) * 3600 + substr ((modify_date - creation_date) , instr((modify_date - creation_date),' ') +  4,2) * 60 + substr((modify_date - creation_date) , instr ((modify_date - creation_date) , ' ') + 7,2) + substr ((modify_date - creation_date) , instr((modify_date - creation_date),' ') +  10,3) * 0.001), 2) as AVG 
FROM cube_instance CI
WHERE state = 5
GROUP BY CI.composite_name, CI.component_name
ORDER BY CI.composite_name
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW CI_AVG_INV_PROCESSING_DELAY
AS 
select CI.composite_name, CI.component_name, DM.partner_link, DM.operation_name,
        round ( avg (
			                substr ((CI.CREATION_DATE - DM.RECEIVE_DATE), instr((CI.CREATION_DATE - DM.RECEIVE_DATE), ' ') + 1,2)  * 3600 + 
			                substr ((CI.CREATION_DATE - DM.RECEIVE_DATE), instr((CI.CREATION_DATE - DM.RECEIVE_DATE), ' ') + 4,2) * 60 + 
			                substr ((CI.CREATION_DATE - DM.RECEIVE_DATE), instr((CI.CREATION_DATE - DM.RECEIVE_DATE), ' ') + 7,2)  + 
			                substr ((CI.CREATION_DATE - DM.RECEIVE_DATE), instr((CI.CREATION_DATE - DM.RECEIVE_DATE), ' ') + 10,3) * 0.001), 2) as AVG_INVOKE_PROCESSING_DELAY
			 from DLV_MESSAGE DM, CUBE_INSTANCE CI 
			 where DM.cikey = CI.cikey 
			 and DM.DLV_TYPE = 1
			 group by CI.composite_name, CI.component_name, DM.partner_link, DM.operation_name
			 order by CI.component_name
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO soaqtz_LOCKS (LOCK_NAME) values('TRIGGER_ACCESS')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO soaqtz_LOCKS (LOCK_NAME) values('JOB_ACCESS')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO soaqtz_LOCKS (LOCK_NAME) values('CALENDAR_ACCESS')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO soaqtz_LOCKS (LOCK_NAME) values('STATE_ACCESS')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO soaqtz_LOCKS (LOCK_NAME) values('MISFIRE_ACCESS')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO CM_SEQUENCE_TABLE (SEQUENCE_NAME, SEQUENCE_COUNT) VALUES ('CASE_NUMBER', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_AUDIT_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('AUDIT_QUERY_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_AUDIT_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('AUDIT_DETAILS_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_AUDIT_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('AUDIT_METADATA_EXT_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_AUDIT_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('AUDIT_VALUES_EXT_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_AUDIT_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('AUDIT_QUERY_METADATA_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO  BPM_CUBE_LOCK(LOCKNAME) VALUES ('CUBE_TIMER_LOCK')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO  BPM_CUBE_LOCK(LOCKNAME) VALUES ('MEASUREMENT_PUBLISH_LOCK')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO  BPM_CUBE_LOCK(LOCKNAME) VALUES ('PURGE_LOCK')
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_CUBE_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('CUBE_DEFAULT_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_CUBE_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('PROCESS_PERF_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_CUBE_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('TASK_PERF_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_CUBE_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('WORKLOAD_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_MEASUREMENT_ACTION_SEQ (SEQ_NAME, SEQ_COUNT) VALUES ('ACTION_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_MEASUREMENT_ACTION_SEQ (SEQ_NAME, SEQ_COUNT) VALUES ('ACTION_EXCEPTION_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_PROJECTSHAREDATA_SEQ (SEQ_NAME, SEQ_COUNT) VALUES ('PROJECTSHAREDATA_DEFAULT_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_RT_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('ROUNDTRIP_DEFAULT_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_PML_SEQUENCE (seq_name, seq_count) VALUES ('HS_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_BAC_SEQUENCE (seq_name, seq_count) VALUES ('BAC_SEQ', 0)
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE BAC_MODEL_SEQ
        START WITH 1
        MAXVALUE 999999999999999999999999999
        MINVALUE 1
        NOCYCLE
        CACHE 20
        NOORDER
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_OPT_DATA_SEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('OPT_DATA_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO BPM_ARCHIVESEQUENCE (SEQ_NAME, SEQ_COUNT) VALUES ('ARCHIVEREQUEST', 0)
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE VIEW BPM_ACTIVITY_PERFORMANCE_V
AS
SELECT
  PERF.TASKPERFID    AS SEQUENCE_ID,
  PRC.PROCESSID      AS PROCESS_ID,
  PRC.PROCESSNAME    AS PROCESS_NAME,
  ACT.ACTIVITYID     AS ACTIVITY_ID,
  ACT.LABEL          AS ACTIVITY_LABEL,
  PERF.COMPONENTINSTANCEID AS PROCESS_INSTANCE_ID,
  PERF.COMPOSITEINSTANCEID AS COMPOSITE_INSTANCE_ID,
  PERF.DISCRIMINATOR AS ACTIVITY_DISCRIMINATOR,
  PERF.ROLEID        AS ACTIVITY_ROLE_ID,
  (select ROLE.ROLENAME FROM BPM_CUBE_ROLE ROLE WHERE PERF.ROLEID=ROLE.ROLEID) AS ACTIVITY_ROLE_NAME, 
  PERF.CREATIONDATETIME   AS ACTIVITY_START_TIME,
  PERF.COMPLETIONDATETIME AS ACTIVITY_END_TIME,
  PERF.TASKTIME           AS ACTIVITY_RUNNING_TIME_IN_MSEC,
  PERF.PARTICIPANT        AS ACTIVITY_PARTICIPANT,
  PERF.PRIORITY           AS ACTIVITY_PRIORITY,
  PERF.TENANTID           AS TENANT_ID
FROM
  BPM_CUBE_TASKPERFORMANCE PERF,
  BPM_CUBE_PROCESS PRC,
  BPM_CUBE_ACTIVITY ACT
WHERE
  PERF.ACTIVITYID  = ACT.ACTIVITYID AND
  ACT.PROCESSID    = PRC.PROCESSID AND
  PRC.PROCESSTYPE  = 'BPMN' AND
    (PERF.DISCRIMINATOR IS NULL OR PERF.DISCRIMINATOR <> 'MEASUREMENT_COUNTER');

CREATE OR REPLACE VIEW BPM_PROCESS_PERFORMANCE_V
AS
SELECT
  PERF.PROCESSPERFID       AS SEQUENCE_ID,
  PRC.PROCESSID            AS PROCESS_ID,
  PRC.PROCESSNAME          AS PROCESS_NAME,
  PERF.COMPOSITEINSTANCEID AS COMPOSITE_INSTANCE_ID,
  PERF.COMPONENTINSTANCEID AS PROCESS_INSTANCE_ID,
  PERF.DISCRIMINATOR       AS PROCESS_DISCRIMINATOR,
  PERF.CREATIONDATETIME    AS PROCESS_START_TIME,
  PERF.COMPLETIONDATETIME  AS PROCESS_END_TIME,
  PERF.TASKTIME            AS PROCESS_RUNNING_TIME_IN_MSEC,
  PERF.TENANTID            AS TENANT_ID
FROM
  BPM_CUBE_PROCESSPERFORMANCE PERF,
  BPM_CUBE_PROCESS PRC
WHERE
  PERF.PROCESSID   = PRC.PROCESSID AND
  PRC.PROCESSTYPE  = 'BPMN';

CREATE OR REPLACE VIEW BPM_ACTIVITY_INSTANCE_V
AS
SELECT
  t0.QUERYID         AS SEQUENCE_ID,
  PRC.PROCESSID      AS PROCESS_ID,
  PRC.PROCESSNAME    AS PROCESS_NAME,
  ACT.ACTIVITYID     AS ACTIVITY_ID,
  ACT.LABEL          AS ACTIVITY_LABEL,
  t0.COMPONENTINSTANCEID AS PROCESS_INSTANCE_ID,
  t0.COMPOSITEINSTANCEID AS COMPOSITE_INSTANCE_ID,
  t0.THREADID            AS PROCESS_THREAD_ID,
  t0.ROLEID              AS ACTIVITY_ROLE_NAME,
  t0.PARTICIPANT         AS ACTIVITY_PARTICIPANT,
  t0.PRIORITY            AS ACTIVITY_PRIORITY,
  t0.CREATETIME          AS ACTIVITY_START_TIME,
  t0.TENANTID            AS TENANT_ID
FROM
  BPM_CUBE_AUDITINSTANCE t0,
  BPM_CUBE_PROCESS PRC, BPM_CUBE_ACTIVITY ACT
WHERE
  t0.OPERATION IN ('FLOW_NODE_IN', 'MEASUREMENT_START') AND
  t0.ACTIVITYSTATUS = 'ACTIVE' AND
  t0.COMPOSITEDN = PRC.COMPOSITEDN AND t0.PROCESSNAME = PRC.PROCESSNAME AND
  PRC.PROCESSID = ACT.PROCESSID and t0.ACTIVITYID = ACT.ACTIVITYNAME AND
  PRC.PROCESSTYPE = 'BPMN' AND PRC.STATUS = 1;

CREATE OR REPLACE VIEW BPM_PROCESS_INSTANCE_V
AS
SELECT
  t0.QUERYID         AS SEQUENCE_ID,
  PRC.PROCESSID      AS PROCESS_ID,
  PRC.PROCESSNAME    AS PROCESS_NAME,
  t0.COMPONENTINSTANCEID AS PROCESS_INSTANCE_ID,
  t0.COMPOSITEINSTANCEID AS COMPOSITE_INSTANCE_ID,
  t0.CREATETIME          AS PROCESS_START_TIME,
  t0.TENANTID            AS TENANT_ID
FROM
  BPM_CUBE_AUDITINSTANCE t0,
  BPM_CUBE_PROCESS PRC
WHERE
  t0.OPERATION = 'INSTANCE_CREATED' AND
  t0.ACTIVITYSTATUS = 'ACTIVE' AND
  t0.COMPOSITEDN = PRC.COMPOSITEDN AND t0.PROCESSNAME = PRC.PROCESSNAME AND
  PRC.PROCESSTYPE = 'BPMN' AND PRC.STATUS = 1;

CREATE OR REPLACE VIEW BPM_PROCESS_DEFINITION_V
AS
SELECT
   PROCESSID, PROCESSNAME, DOMAINNAME, COMPOSITENAME, REVISION,
   SCALABEL, COMPOSITEDN, LABEL, PROCESSTYPE, STATUS, MIGRATIONSTATUS
FROM BPM_CUBE_PROCESS
WHERE PROCESSTYPE='BPMN';

CREATE OR REPLACE VIEW BPM_ACTIVITY_DEFINITION_V
AS
SELECT ACTIVITYID, PROCESSID, ACTIVITYNAME, ACTIVITYTYPE, LABEL
FROM BPM_CUBE_ACTIVITY;

CREATE OR REPLACE VIEW BPM_ROLE_DEFINITION_V
AS
SELECT ROLEID, PROCESSID, ROLENAME, APPROLENAME, LABEL, ISPROCESSOWNER
FROM BPM_CUBE_ROLE;

CREATE OR REPLACE VIEW BPM_CUBE_PROCESS_PARTNER_SVC_V
AS
SELECT
       proc.ProcessId       as ProcessId,
       plnk.PartnerId       as PartnerLinkId,
       srvc.PartnerServiceId as PartnerServiceId,
       proc.DomainName      as DomainName,
       proc.CompositeName   as CompositeName,
       proc.Revision        as Revision,
       proc.SCALabel        as Label,
       proc.ProcessName     as ProcessName,
       plnk.PartnerName     as PartnerLinkName,
       plnk.LinkType        as PartnerLinkType,
       plnk.MyRole          as MyRole,
       plnk.PartnerRole     as PartnerRole,
       srvc.PortType        as PortType,
       srvc.Operation       as Operation,
       srvc.IsInitiating    as IsInitiating
FROM
       BPM_CUBE_PROCESS proc,
       BPM_CUBE_PROCESS_PARTNER plnk,
       BPM_CUBE_PARTNER_SERVICE srvc
WHERE
       plnk.processid = proc.processid AND
       plnk.partnerid = srvc.partnerid(+) AND
       plnk.processid = srvc.processid(+)
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

define edn_user=&1


/***********************************************************
  Stop and drop AQ-JMS topic related queue and queue table
  This is the default EDN 12c AQ-JMS topic
***********************************************************/
-- Workaround of dropping queue table per Bug 19512807
declare
view_not_exist exception;
pragma EXCEPTION_INIT(view_not_exist, -00942 );

begin
  execute immediate 'DROP VIEW ' || '&edn_user' || '.AQ$EDN_AQJMS_TOPIC_TABLE';
  execute immediate 'DROP VIEW ' || '&edn_user' || '.AQ$_EDN_AQJMS_TOPIC_TABLE_F';

  execute immediate 'DROP VIEW ' || '&edn_user' || '.AQ$edn_event_queue_table';
  execute immediate 'DROP VIEW ' || '&edn_user' || '.AQ$_edn_event_queue_table_F';

  execute immediate 'DROP VIEW ' || '&edn_user' || '.AQ$edn_oaoo_delivery_table';
  execute immediate 'DROP VIEW ' || '&edn_user' || '.AQ$_edn_oaoo_delivery_table_F';
exception
when view_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when others then
-- re-throw current exception
raise;
end;

/

declare
queue_not_exist exception;
queue_table_not_exist exception;
pragma EXCEPTION_INIT(queue_not_exist, -24010);
pragma EXCEPTION_INIT(queue_table_not_exist, -24002);

begin
  DBMS_AQADM.stop_queue(queue_name=>'&edn_user..EDN_AQJMS_TOPIC');
  DBMS_AQADM.drop_queue(queue_name=>'&edn_user..EDN_AQJMS_TOPIC');
  -- DBMS_AQADM.drop_queue_table(queue_table=>'&edn_user..EDN_AQJMS_TOPIC_TABLE');
  DBMS_AQADM.drop_queue_table('&edn_user..EDN_AQJMS_TOPIC_TABLE', true);
exception
when queue_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when queue_table_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when others then
-- re-throw current exception
raise;
end;

/

/***********************************************************
  Stop and drop two 11g legacy AQ queues and related queue tables
  These legacy AQ queues are still used in 12c for backlog upgrade 
  purposes during customer upgrade from 11g
***********************************************************/
declare
queue_not_exist exception;
queue_table_not_exist exception;
pragma EXCEPTION_INIT(queue_not_exist, -24010);
pragma EXCEPTION_INIT(queue_table_not_exist, -24002);

begin
  DBMS_AQADM.stop_queue(queue_name=>'edn_event_queue');
  DBMS_AQADM.drop_queue(queue_name=>'edn_event_queue');
  -- DBMS_AQADM.drop_queue_table(queue_table=>'edn_event_queue_table');
  DBMS_AQADM.drop_queue_table('&edn_user..edn_event_queue_table', true);
exception
when queue_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when queue_table_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when others then
-- re-throw current exception
raise;
end;

/

declare
queue_not_exist exception;
queue_table_not_exist exception;
pragma EXCEPTION_INIT(queue_not_exist, -24010);
pragma EXCEPTION_INIT(queue_table_not_exist, -24002);

begin
  DBMS_AQADM.stop_queue(queue_name=>'edn_oaoo_queue');
  DBMS_AQADM.drop_queue(queue_name=>'edn_oaoo_queue');
  -- DBMS_AQADM.drop_queue_table(queue_table=>'edn_oaoo_delivery_table');
  DBMS_AQADM.drop_queue_table('&edn_user..edn_oaoo_delivery_table', true);
exception
when queue_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when queue_table_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when others then
-- re-throw current exception
raise;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

declare
seq_not_exist exception;
pragma EXCEPTION_INIT(seq_not_exist, -02289);

begin
execute immediate 'drop sequence edn_subscription_seq';
exception
when seq_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when others then
-- re-throw current exception
raise;
end;

/

/************ Logging Related Reset ***************/
declare
seq_not_exist exception;
pragma EXCEPTION_INIT(seq_not_exist, -02289);

begin
execute immediate 'drop sequence edn_log_seq';
execute immediate 'drop sequence edn_log_event_seq';
exception
when seq_not_exist then
dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
when others then
-- re-throw current exception
raise;
end;

/

/***********************************************************
  Sequence number for a group of loggings for operations on a single event
  (-- Used by sp: edn_log_message
***********************************************************/
create sequence edn_log_seq start with 1 increment by 1 nomaxvalue;

/***********************************************************
  Sequence number for one operation on a single event
  (-- Used by fx: edn_next_log_event_id
***********************************************************/
create sequence edn_log_event_seq start with 1 increment by 1 nomaxvalue;

/***********************************************************
  (-- Invoked by EDN java: void enableDbLogging(boolean enabled)
  --) Using table: edn_log_enabled
***********************************************************/
create or replace procedure edn_enable_logging (enabled in int) is
begin
  delete from edn_log_enabled;
  insert into edn_log_enabled values (enabled);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  (-- Invoked by sp: edn_enq_event_to_aqjms
  (-- Invoked by sp: edn_dequeue_bus_event2 (11g)
  (-- Invoked by sp: edn_dequeue_oaoo_delivery2 (11g)
  (-- Invoked by sp: edn_event_agent (11g)
  --) Using sequence: edn_log_event_seq
***********************************************************/
create or replace function edn_next_log_event_id return number is
  val int;
begin
  select edn_log_event_seq.nextval into val from dual;
  return val;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  (-- Invoked by EDN Event Bus Java: boolean isDbLoggingEnabled()
  (-- Invoked by sp: edn_enq_event_to_aqjms
  (-- Invoked by sp: edn_dequeue_bus_event2 (11g)
  (-- Invoked by sp: edn_dequeue_oaoo_delivery2 (11g)
  (-- Invoked by sp: edn_event_agent (11g)
  --) Using table: edn_log_enabled
***********************************************************/
create or replace function edn_logging_enabled return number is
  val int;
begin
  select enabled into val from edn_log_enabled;
  return val;
  exception 
    when others then
      return 0;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  (-- Invoked by sp: edn_enq_event_to_aqjms
  (-- Invoked by sp: edn_dequeue_bus_event2 (11g)
  (-- Invoked by sp: edn_dequeue_oaoo_delivery2 (11g)
  (-- Invoked by sp: edn_event_agent (11g)
  (-- Invoked by sp: edn_filter_and_deliver_event (11g)
  --) Using table: edn_log_messages
***********************************************************/
create or replace procedure edn_log_message (event_id number, msg clob) as
  PRAGMA AUTONOMOUS_TRANSACTION;
  tmp clob;
begin
  tmp := msg || ' [@' || TO_CHAR(sysdate, 'DD-MON-YYYY HH:MI:SS') || ']';
  insert into edn_log_messages values (edn_log_seq.nextval, event_id, tmp);
  commit;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g sequence for database subscription
  (-- Used in sp: edn_subscribe
  (-- Used in sp: edn_subscribe_immediate
***********************************************************/
-- SQL event subscriptions
create sequence edn_subscription_seq start with 1 increment by 1 nomaxvalue;

/***********************************************************
  11g legacy AQ queue Main_Q and its queue table
  kept in 12c for backlog upgrade
  (-- Used in sp: edn_dequeue_bus_event2 (11g)
***********************************************************/
begin
  DBMS_AQADM.create_queue_table(
    queue_table         => 'edn_event_queue_table',
    queue_payload_type  => '&2..edn_event_data', 
    multiple_consumers  => TRUE);
  DBMS_AQADM.create_queue(
    queue_name          => 'edn_event_queue',
    queue_table         => 'edn_event_queue_table');
  DBMS_AQADM.start_queue(queue_name=>'edn_event_queue');
end;

/

/***********************************************************
  11g legacy AQ queue OAOO_Q and its queue table
  kept in 12c for backlog upgrade
  (-- Used in sp: edn_dequeue_oaoo_delivery2 (11g)
***********************************************************/
begin
  DBMS_AQADM.create_queue_table(
    queue_table         => 'edn_oaoo_delivery_table',
    queue_payload_type  => '&2..edn_oaoo_delivery', 
    multiple_consumers  => TRUE);
  DBMS_AQADM.create_queue(
    queue_name          => 'edn_oaoo_queue',
    queue_table         => 'edn_oaoo_delivery_table');
  DBMS_AQADM.start_queue(queue_name=>'edn_oaoo_queue');
end;

/

/***********************************************************
  11g legacy: Register edn_java_subscriber to Main_Q
***********************************************************/
declare
  sub sys.aq$_agent;
begin
  sub := sys.aq$_agent('edn_java_subscriber', NULL, NULL);
  DBMS_AQADM.add_subscriber(queue_name=>'edn_event_queue', subscriber=>sub);
end;

/

/***********************************************************
  11g legacy: Register edn_oaoo_subscriber to OAOO_Q
***********************************************************/
declare
  sub sys.aq$_agent;
begin
  sub := sys.aq$_agent('edn_oaoo_subscriber', NULL, NULL);
  DBMS_AQADM.add_subscriber(queue_name=>'edn_oaoo_queue', subscriber=>sub);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  EDN 12c specific procedure to initialize or upsert event to JMS topic mappings.
  (1) if initialize is 1, then it wipes out any existing data in the table, and populates
      the edn_e2j_mapping table with the default mapping specified in mapping_in.
      example:
      mapping_in := input default mapping, e.g. '*,*,EDNTopic,jms/fabric/EDNTopic,WLJMS' 
  (2) if initialize is 0, then for each mappng entry in mapping_in, it inserts (if not yet exists) or
      updates (if already exists) the mapping table.
      example:
      mapping_in := (mapping_entry)+
      mapping_entry := 'http://earthquake-event.oracle.com,Earthquake,DEV12_SOAINFRA.EDN_AQJMS_TOPIC,jms/fabric/EDNAQjmsTopic,AQJMS'

  (-- Invoked by EDN 12c Event Bus: void saveEventToJmsMappingToDB()
  --) Using table: edn_e2j_mapping
***********************************************************/
create or replace procedure edn_save_e2j_mapping (mapping_in in edn_e2j_map_type, initialize in int) as
  tmp   varchar2(1024);
  pos   pls_integer;
  ns    varchar2(512);
  ln    varchar2(80);
  tn    varchar2(128);
  tj    varchar2(128);
  jt    varchar2(8);
begin
  if initialize = 1 then
    delete from edn_e2j_mapping;
  end if;

  for i in 1 .. mapping_in.COUNT
  loop
    tmp := mapping_in(i);
    -- namespace extraction
    pos := instr(tmp, ',');
    ns := substr(tmp, 0, pos - 1);
    tmp := substr(tmp, pos + 1);
    -- local_name extraction
    pos := instr(tmp, ',');
    ln := substr(tmp, 0, pos - 1);
    tmp := substr(tmp, pos + 1);
    -- topic_name extraction
    pos := instr(tmp, ',');
    tn := substr(tmp, 0, pos - 1);
    tmp := substr(tmp, pos + 1);
    -- topic_jndi extraction
    pos := instr(tmp, ',');
    tj := substr(tmp, 0, pos - 1);
    tmp := substr(tmp, pos + 1);
    -- jms_type extraction
    jt := tmp;

    --dbms_output.put_line('ns [' || ns || '] ln [' || ln || '] tn [' || tn || '] tj [' || tj || '] jt [' || jt || ']');

    if ns is not null or ln is not null then
      -- insert if not exist and update if exists
      insert into edn_e2j_mapping (namespace, local_name, topic_name, topic_jndi, jms_type, creation_time) 
        select ns, ln, tn, tj, jt, current_timestamp from dual 
          where not exists (select namespace, local_name from edn_e2j_mapping where namespace = ns and local_name = ln); 
      update edn_e2j_mapping 
        set topic_name = tn, topic_jndi = tj, jms_type = jt, creation_time = current_timestamp 
          where namespace = ns and local_name = ln;
    end if;

  end loop;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  For EDN 12c event to JMS topic mapping lookup
  (-- Invoked by sp: edn_enq_event_to_aqjms
  --) using table: edn_e2j_mapping
***********************************************************/
create or replace procedure edn_lookup_aqjms_topic (v_namespace in varchar2, v_local_name in varchar2, 
  v_topic_name out varchar2)
as 
  jmstype varchar2(5);
begin
  select topic_name into v_topic_name from edn_e2j_mapping
    where namespace = v_namespace AND local_name = v_local_name;

  if jmstype = 'WLJMS' then
    v_topic_name := NULL;
  end if;

  exception
    when no_data_found then
      -- find default mapping signified with wildcard
      begin
        select topic_name into v_topic_name from edn_e2j_mapping 
          where namespace = '*' AND local_name = '*';
          
        if jmstype = 'WLJMS' then
          v_topic_name := NULL;
        end if;

        exception
          when no_data_found then
            -- use default AQJMS topic
            v_topic_name := '&edn_user..EDN_AQJMS_TOPIC';
      end;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  Create AQ-JMS topic related queue and queue table
  This is the default EDN AQ JMS topic.
***********************************************************/
begin
  DBMS_AQADM.CREATE_QUEUE_TABLE (
    queue_table         => '&edn_user..EDN_AQJMS_TOPIC_TABLE', 
    queue_payload_type  => 'SYS.AQ$_JMS_TEXT_MESSAGE', 
    compatible          => '8.1.0', 
    multiple_consumers  => true);
  DBMS_AQADM.CREATE_QUEUE (
    queue_name          => '&edn_user..EDN_AQJMS_TOPIC',
    queue_table         => '&edn_user..EDN_AQJMS_TOPIC_TABLE');
  DBMS_AQADM.START_QUEUE (queue_name => '&edn_user..EDN_AQJMS_TOPIC');
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procecure for event decompression
  (-- Invoked by sp: edn_filter_and_deliver_event
  --) Using type: edn_business_event
***********************************************************/
create or replace procedure edn_decompress_event(event in out edn_business_event) 
as
  statement varchar2(2000);
begin
    statement := 'BEGIN :1 := ' || event.decomp_method || '(:2); END;';
    execute immediate statement using OUT event.payload, IN event.compressed_event;
    exception
      when others then
        NULL;  /* TODO: log */
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procecure for event decompression
  (-- Invoked by Java: EventData readEvent(Connection)
***********************************************************/
create or replace procedure edn_internal_decompress_event (compressed_event in decimal,
        decomp_method in varchar2, payload_clob out clob)
as
  statement varchar2(2000);
  payload sys.xmltype;
begin
    statement := 'BEGIN :1 := '||decomp_method||'(:2); END;';
    execute immediate statement using OUT payload, IN compressed_event;
    payload_clob := payload.getClobVal();
    exception
      when others then
        NULL;  /*TODO: log */
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g internal procecure for database subscription
  (-- Invoked by sp: edn_event_agent
  --) Invoking sp: edn_decompress_event
  --) Invoking sp: edn_log_message
  --) Using type: edn_business_event
***********************************************************/
create or replace procedure edn_filter_and_deliver_event (subscriber_agent in varchar2, 
        subscriber_callback in varchar2, event_in in edn_business_event, xpath_filter in varchar2, 
        xpath_ns_map in varchar2, subject_info in varchar2, log_id in number) 
as
  call_agent         integer;
  lwsession_created  boolean;
  lwsession_id       raw(16);
  event              edn_business_event;
begin
  lwsession_created := false;
  event := event_in;

  if xpath_filter is null then
    call_agent := 1;
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, '  No XPath filter for subscription');
    end if;
  else 
    if event.payload is null then
      edn_decompress_event(event);
    end if;
    call_agent := event.payload.existsNode(xpath_filter, xpath_ns_map);
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, '  XPath filter result: ' || call_agent);
    end if;
  end if;
  if call_agent > 0 then
    /*
    if subject_info is not null then 
    edn_create_lw_session (subject_info, lwsession_id, lwsession_created);
    end if;
    */
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, '  Calling subscriber ' || subscriber_agent || ' via callback ' || subscriber_callback);
    end if;
    execute immediate 'begin ' || subscriber_callback || '(:1, :2, :3); end;' 
      using event.namespace, event.local_name, event;
/*
if lwsession_created then
edn_close_lw_session (lwsession_id);
end if;
*/
  end if;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace procedure edn_compress_to_base64 (input in clob, output out clob)
as
  in_blob            blob;
  compressed_blob    blob;
  compressed64e_blob    blob;
begin
  in_blob := to_blob(utl_raw.cast_to_raw(input));
  compressed_blob := to_blob('0');
  compressed64e_blob := to_blob('0');

  -- compress
  utl_compress.lz_compress (src => in_blob, dst => compressed_blob);
  -- base 64 encoding
  compressed64e_blob := utl_encode.base64_encode (r => compressed_blob);

  -- output
  output := utl_raw.cast_to_varchar2(compressed64e_blob);

  --dbms_output.put_line('input length is    : ' || length(in_blob));
  --dbms_output.put_line('compressed length  : ' || length(compressed_blob));
  --dbms_output.put_line('compressed base64 encoded length  : ' || length(compressed64e_blob));

  -- free up temporary lobs
  dbms_lob.freetemporary(in_blob);
  dbms_lob.freetemporary(compressed_blob);
  dbms_lob.freetemporary(compressed64e_blob);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace procedure edn_uncompress_from_base64 (input in clob, output out clob)
as
  in_blob            blob;
  compressed_blob    blob;
  uncompressed_blob  blob;
begin
  -- input is compressed base 64 encoded
  in_blob           := to_blob(utl_raw.cast_to_raw(input));
  compressed_blob   := to_blob('0');
  uncompressed_blob := to_blob('0');
  
  -- base 64 decode
  compressed_blob := utl_encode.base64_decode (r => in_blob);

  -- uncompress
  utl_compress.lz_uncompress (src => compressed_blob, dst => uncompressed_blob);

  -- output
  output := utl_raw.cast_to_varchar2(uncompressed_blob);

  --dbms_output.put_line('input length is    : ' || length(input));
  --dbms_output.put_line('input compressed base64 encoded length is    : ' || length(in_blob));
  --dbms_output.put_line('compressed length  : ' || length(compressed_blob));
  --dbms_output.put_line('uncompressed length  : ' || length(uncompressed_blob));

  -- free up temporary lobs
  dbms_lob.freetemporary(in_blob);
  dbms_lob.freetemporary(compressed_blob);
  dbms_lob.freetemporary(uncompressed_blob);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  12c core internal procedure: Enqueue an Event in mapped AQJMS topic
  NOTES: Starting 12.2.1.1 PS2 this procedure is not used, because FA uses WLS-DB-JMS.
  (-- Invoked by sp: edn_java_pub_event (until 12.2.1, not since 12.2.1.1)
  (-- Invoked by sp: edn_publish_event_12c (until 12.2.1, not since 12.2.1.1)
  --) Invoking sp: edn_log_message
  --) Invoking sp: edn_lookup_aqjms_topic
  --) Invoking fx: edn_logging_enabled
  --) Invoking fx: edn_next_log_event_id
  --) Invoking AQ API: DBMS_AQ.enqueue
  payload := serialized XML of BusinessEvent Java object with root element "business-event"
             with subject and context
  source := (1) 'SOA' - from SOA Java component, 
            (2) 'Remote' - remote Java, 
            (3) 'PLSQL' - from PL/SQL procedure: edn_publish_event or edn_publish_event_with_context
***********************************************************/
create or replace procedure edn_enq_event_to_aqjms (namespace in varchar2, local_name in varchar2, 
  payloadWithContext in clob, source in varchar2 default 'SOA', subject_info in varchar2 default null, 
  priority in pls_integer default 4, persistent in boolean default true, 
  timetolive in pls_integer default 0, keyfieldvalues in sys.xmltype default null)
as
  msg_hdr                SYS.AQ$_JMS_HEADER;
  msg_agent              SYS.AQ$_AGENT;
  msg_proparray          SYS.AQ$_JMS_USERPROPARRAY;
  msg_property           SYS.AQ$_JMS_USERPROPERTY;
  e_opt                  DBMS_AQ.ENQUEUE_OPTIONS_T;
  m_prop                 DBMS_AQ.MESSAGE_PROPERTIES_T;
  m_handle               raw(16);
  message                SYS.AQ$_JMS_TEXT_MESSAGE;
  log_id                 number;
  i                      number := 1;
  eventXML               sys.xmltype;
  childEle               sys.xmltype;
  ns_decl                varchar2(256);
  aqjms_topic_name       varchar2(128);
  no_subscriber_exp      exception;
  compressed_contxt      varchar2(4000);
  pragma                 EXCEPTION_INIT(no_subscriber_exp, -24033);
begin
  ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';
  -- logging
  log_id := edn_next_log_event_id;
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Enqueuing event: {' || namespace || '}' || local_name || ' from ' || source);
  end if;
  if payloadWithContext is not null then
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'EventXML: ' || payloadWithContext);
    end if;
  else
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'ERROR: EventXML is empty!');
    end if;
  end if;

  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Subject name: "' || subject_info || '"');
  end if;

  /*************** MESSAGE PROPERTIES m_prop *******************/
  -- Set up message priority, The priority attribute specifies the priority of the message. 
  --  It can be any number, including negative numbers. A smaller number indicates higher priority
  --  NOTE: AQ's priority is opposite to JMS message priority (normalize it so that priority=9 maps to 0)
  m_prop.priority := 9 - priority;

  -- The expiration attribute specifies the number of seconds during 
  --  which the message is available for dequeuing, 
  --  starting from when the message reaches the READY state. 
  --  If the message is not dequeued before it expires, then it is moved 
  --  to the exception queue in the EXPIRED state. 
  --  If you specify NEVER, then the message does not expire. Can also specify: e.g. 100 (seconds)
  --  Message delay and expiration are enforced by the queue monitor (QMN) background processes. 
  --  You must start the QMN processes for the database if you intend to 
  --  use the delay and expiration features of Oracle Streams AQ.
  if timetolive = 0 then
    m_prop.expiration := DBMS_AQ.NEVER;
  else
    m_prop.expiration := timetolive / 1000; -- convert from ms to seconds
  end if;

  /*************** ENQUEUE PROPERTIES e_opt  *******************/
  -- If the delivery_mode attribute is the default PERSISTENT, then the message is 
  --      enqueued as a persistent message. 
  --  If it is set to BUFFERED, then the message is enqueued as an buffered message. 
  --      null values are not allowed.
  if persistent then
    e_opt.delivery_mode := DBMS_AQ.PERSISTENT;
  else
    -- Per Anil Madan: AQ doesn't have transactional support for BUFFERED delivery mode.
    e_opt.delivery_mode := DBMS_AQ.PERSISTENT; 
  end if;

  -- The visibility attribute specifies the transactional behavior of the enqueue request. 
  --  ON_COMMIT (the default) makes the enqueue is part of the current transaction. 
  --  IMMEDIATE makes the enqueue operation an autonomous transaction 
  --     which commits at the end of the operation.
  --  You must set the visibility attribute to IMMEDIATE to use buffered messaging.
  if persistent then
    e_opt.visibility := DBMS_AQ.ON_COMMIT;
  else
    e_opt.visibility := DBMS_AQ.IMMEDIATE;
  end if;

  -- parse payloadWithContext into eventXML
  eventXML := sys.xmltype.createXML(payloadWithContext);

  -- JMS message properties (EDN related)
  msg_proparray := SYS.AQ$_JMS_USERPROPARRAY();

  -- context of eventXML
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:context/*', ns_decl);
  if childEle is not null then
    edn_compress_to_base64(childEle.getClobVal, compressed_contxt);

    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$context', 100, compressed_contxt, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;

  -- priority
  msg_proparray.EXTEND(1);
  msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$priority', 200, NULL, priority, 23);
  msg_proparray(i) := msg_property;
  i := i + 1;

  if namespace is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$namespace', 100, namespace, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  if local_name is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$localName', 100, local_name, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  if subject_info is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$oracleFabricSecurityIdentitySubject', 100, subject_info, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:id/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$id', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:published-time/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$publishedTime', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:source/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$source', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  else
    if source is not null then
      msg_proparray.EXTEND(1);
      msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$source', 100, source, NULL, 27);
      msg_proparray(i) := msg_property;
      i := i + 1;
    end if;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:parent-id/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$parentId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:owner/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$owner', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:mode/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$mode', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;

  -- tracking properties
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:ecid/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingEcid', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:compositeInstanceId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingCompositeInstanceId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:parentComponentInstanceId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingParentComponentInstanceId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:conversationId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingConversationId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:flowId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingFlowId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:compositeInstanceCreatedTime/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingCompositeInstanceCreatedTime', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:flowEventId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingFlowEventId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:faultId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingFaultId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:flowId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingFlowId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:flowCreatedTime/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingFlowCreatedTime', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:componentInstanceId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingComponentInstanceId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:scaEntityId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingScaEntityId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:flowSCAPartitionId/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingFlowSCAPartitionId', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:correlationFlowID/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingCorrelationFlowID', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:compositeSCAEntityID/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingCompositeSCAEntityID', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:dmsWrapperContext/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingDmsWrapperContext', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:instanceIDCreationTime/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingInstanceIDCreationTime', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;  
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:tracking/be:retryCount/text()', ns_decl);
  if childEle is not null then
    msg_proparray.EXTEND(1);
    msg_property := SYS.AQ$_JMS_USERPROPERTY('EDN$trackingRetryCount', 100, childEle.getClobVal, NULL, 27);
    msg_proparray(i) := msg_property;
    i := i + 1;
  end if;

  -- construct JMS text message with message properties
  msg_agent := SYS.AQ$_AGENT(' ', null, 0);
  msg_hdr := SYS.AQ$_JMS_HEADER(msg_agent, null, '&edn_user', null, null, null, msg_proparray);
  message := SYS.AQ$_JMS_TEXT_MESSAGE(msg_hdr, null, null, null);

  -- content (event body XML)
  childEle := sys.xmltype.extract(eventXML, '/be:business-event/be:content/*', ns_decl);
  if childEle is not null then
    message.text_vc := childEle.getClobVal;
    message.text_len := length(message.text_vc);
  end if;

  -- lookup event to JMS topic mapping to find the right AQJMS topic
  edn_lookup_aqjms_topic (namespace, local_name, aqjms_topic_name);

  if aqjms_topic_name is not NULL then
    -- event publishing
    DBMS_AQ.enqueue (
      queue_name          => aqjms_topic_name, 
      enqueue_options     => e_opt,
      message_properties  => m_prop, 
      payload             => message, 
      msgid               => m_handle);

    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Enqueing to AQ-JMS topic = [' || aqjms_topic_name || '] complete');
    end if;
  else
    edn_log_message (log_id, 'Enqueuing to AQ-JMS topic failed - not found mapped AQJMS topic for namespace = [' 
      || namespace || '], local_name = [' || local_name || '].');
  end if;

  exception 
    when no_subscriber_exp then
      null; -- no subscribers for this message, it's ok
    --when others then
    --  dbms_output.put_line('An error was encountered with sqlcode: '|| SQLCODE ||', ERROR: '||SQLERRM);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  12c internal procedure since PS2 for dequeueing event from AQJMS topic
  for durable subscriber specified.
  Added starting 12.2.2.1 PS2 as FA uses WLS-DB-JMS
  (-- Invoked by JDBC java code
  --) Invoking function: edn_logging_enabled
  --) Invoking function: edn_next_log_event_id
  --) Invoking sp: edn_log_message
  --) Invoking DBMS_AQ.dequeue API
***********************************************************/
create or replace
procedure edn_dequeue_from_aqjms (topic_name in varchar2, subscriber in varchar2, namespace out varchar2, local_name out varchar2,
     event_envelop out clob, source out varchar2, subject_info out varchar2, 
     deq_wait in binary_integer) as
  d_opt           DBMS_AQ.dequeue_options_t;
  m_prop          DBMS_AQ.message_properties_t;
  m_handle        RAW(16);
  ret             pls_integer;
  log_id          number;
  message         SYS.AQ$_JMS_TEXT_MESSAGE;
  msg_header      SYS.AQ$_JMS_HEADER;
  msg_property    SYS.AQ$_JMS_USERPROPERTY;
  msg_properties  SYS.AQ$_JMS_USERPROPARRAY;
  context_clob    clob;
  context_clob_decomp clob;
  prop_val        varchar2(1024);
  p_name          varchar2(100);
  p_type          integer;
  p_val_num       NUMBER;
  msg_clob        clob;
  eventXML               sys.xmltype;
  childEle               sys.xmltype;
  ns_decl                varchar2(256);
  ns_et_decl             varchar2(1024);
  no_messages     exception;
  PRAGMA EXCEPTION_INIT(no_messages, -25228);
begin
  d_opt.navigation := DBMS_AQ.first_message;
  d_opt.consumer_name := subscriber; 
  d_opt.wait := deq_wait;
  if deq_wait = 0 then
    d_opt.wait := DBMS_AQ.NO_WAIT;
  else
    if deq_wait < 0 then
      d_opt.wait := DBMS_AQ.FOREVER;
    end if;
  end if;

  if topic_name is not null then

      DBMS_AQ.dequeue(
      queue_name          =>  topic_name,
      dequeue_options     =>  d_opt,
      message_properties  =>  m_prop,
      payload             =>  message,
      msgid               =>  m_handle);

    if message is not null then
      msg_header := message.header;
      if msg_header is not null then
        msg_properties := msg_header.properties;
      end if;
      
      if msg_properties is not null then
        -- find namespace and local_name first
        for i in 1 .. msg_properties.count loop
          msg_property := msg_properties(i);
          p_name := msg_property.name;
          p_type := msg_property.type;
          if p_name = 'EDN$namespace' then
            namespace := msg_property.str_value;
          end if;
          if p_name = 'EDN$localName' then
            local_name := msg_property.str_value;
          end if;
          if p_name = 'EDN$source' then
            source := msg_property.str_value;
          end if;
          if p_name = 'EDN$oracleFabricSecurityIdentitySubject' then
            subject_info := msg_property.str_value;
          end if;
        end loop;

        ns_et_decl := 'xmlns:et="' || namespace || '"';
        eventXML := sys.xmltype.createXML('<business-event ' || ns_et_decl || ' xmlns="http://oracle.com/fabric/businessEvent"></business-event>');
        ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';

        eventXML := sys.xmltype.appendChildXML(eventXML, '/e:business-event', 
          sys.xmltype.createXML('<content xmlns="http://oracle.com/fabric/businessEvent"></content>'), 
          'xmlns:e="http://oracle.com/fabric/businessEvent"');

        if message.text_vc is not null then
          eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event/e:content', 
            sys.xmltype.createXML(message.text_vc), 'xmlns:e="http://oracle.com/fabric/businessEvent"');
        else
          eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event/e:content', 
            sys.xmltype.createXML(message.text_lob), 'xmlns:e="http://oracle.com/fabric/businessEvent"');
        end if;
        
        for i in 1 .. msg_properties.count loop
          msg_property := msg_properties(i);
          p_name := msg_property.name;
          p_type := msg_property.type;
          if p_name = 'EDN$context' then
            context_clob := msg_property.str_value;
            if context_clob is not null then
              edn_uncompress_from_base64(context_clob, context_clob_decomp);
              eventXML := sys.xmltype.appendChildXML(eventXML, '/e:business-event', 
              sys.xmltype.createXML('<context xmlns="http://oracle.com/fabric/businessEvent"></context>'), 
                  'xmlns:e="http://oracle.com/fabric/businessEvent"');
              eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event/e:context', 
                  sys.xmltype.createXML(context_clob_decomp), 'xmlns:e="http://oracle.com/fabric/businessEvent"');
            end if;
          else
              if instr(p_name, 'EDN$') = 1 then
                p_name := substr(p_name, 5);
              end if;
              if p_name = 'priority' then
                eventXML := sys.xmltype.appendChildXML(eventXML, '/e:business-event', 
                sys.xmltype.createXML('<' || p_name || ' xmlns="http://oracle.com/fabric/businessEvent"' || '>' || msg_property.num_value || '</' || p_name || '>'), 
                'xmlns:e="http://oracle.com/fabric/businessEvent"');
              elsif p_name = 'localName' then
                prop_val := msg_property.str_value;
                eventXML := sys.xmltype.appendChildXML(eventXML, '/e:business-event', 
                sys.xmltype.createXML('<' || p_name || ' xmlns="http://oracle.com/fabric/businessEvent"' || '>et:' || prop_val || '</' || p_name || '>'), 
                'xmlns:e="http://oracle.com/fabric/businessEvent"');
              else
                prop_val := msg_property.str_value;
                eventXML := sys.xmltype.appendChildXML(eventXML, '/e:business-event', 
                sys.xmltype.createXML('<' || p_name || ' xmlns="http://oracle.com/fabric/businessEvent"' || '>' || prop_val || '</' || p_name || '>'), 
                'xmlns:e="http://oracle.com/fabric/businessEvent"');
              end if;
          end if;
        end loop;

      end if;
    else
      if edn_logging_enabled = 1 then
        edn_log_message (log_id, 'No event dequeued');
      end if;
    end if;

    if eventXML is not null then
    -- serialize event and return to caller
      event_envelop := eventXML.getClobVal();
    end if;
    
    if edn_logging_enabled = 1 then
      log_id := edn_next_log_event_id;
    end if;
  
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Dequeued event: ' || namespace || '::' || local_name);
      edn_log_message (log_id, 'Subject name: "' || subject_info || '", AQ consumer: "' || subscriber || '"');
    end if;

  else
    edn_log_message (log_id, 'Can not find AQJMS Topic for: ' || 'namespace=' || namespace || '::' || 'local_name=' || local_name);
  end if;
  exception when no_messages then
  begin
    namespace := null;
    local_name := null;
  end;
  
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g internal procedure for event enqueueing to Main_Q
  Re-surrected to 12.2.2.1 as FA uses WLS-DB-JMS
  (-- Invoked by sp: edn_internal_publish_event (11g only)
  (-- Invoked by sp: edn_publish_compressed_event (11g only)
  (-- Invoked by sp: edn_java_pub_event (since 12.2.1.1)
  (-- Invoked by sp: edn_publish_event_12c (since 12.2.1.1)
  (-- Invoked by sp: edn_publish_event_with_context (since 12.2.1.1)
  --) Invoking function: edn_logging_enabled
  --) Invoking function: edn_next_log_event_id
  --) Invoking sp: edn_log_message
  --) Invoking sp: edn_filter_and_deliver_event
  --) Invoking DBMS_AQ.enqueue API
  -- source: 'J' (Java), 'S' (SQL or PLSQL), 'R' (Remote Java)
***********************************************************/
create or replace procedure edn_enqueue_business_event (event in edn_business_event, source in char,
    subject_info in varchar2, target in varchar2, priority in BINARY_INTEGER) as 
  e_opt                  DBMS_AQ.enqueue_options_t;
  m_prop                 DBMS_AQ.message_properties_t;
  m_handle               raw(16);
  message                anydata;
  immediate_subject_info varchar2(256);
  log_id                 number;
begin
  log_id := edn_next_log_event_id;
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Enqueing event: ' || event.namespace || '::' || event.local_name || ' from ' || source);
  end if;
  if event.payload is not null then
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Body: ' || event.payload.getClobVal());
    end if;
  else
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Event is compressed');
    end if;
  end if;
  if source = 'S' then
    immediate_subject_info := NULL;
  else
    immediate_subject_info := subject_info;
  end if;

  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Subject name: "' || subject_info || '"');
  end if;

  for subscriber in 
    (select edn_event_agents.agent_id agent, edn_event_agents.agent_callback callback, 
          edn_event_subscriptions.xpath_filter xpath_filter, edn_event_subscriptions.xpath_ns_map xpath_ns_map 
      from 
        edn_event_subscriptions, edn_event_agents  
      where 
        namespace=event.namespace and local_name=event.local_name and
            edn_event_agents.agent_id=edn_event_subscriptions.agent_id and
            edn_event_subscriptions.sub_level = 'I' and
            edn_event_subscriptions.enabled = 'Y')
  loop
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Invoking immediate subscriber: ' || subscriber.agent);
    end if;
    edn_filter_and_deliver_event (subscriber.agent, subscriber.callback, event, 
        subscriber.xpath_filter, subscriber.xpath_ns_map, immediate_subject_info, log_id);
  end loop;

  m_prop.priority := priority;
  DBMS_AQ.enqueue(
    queue_name          => '&edn_user..edn_event_queue',
    enqueue_options     => e_opt,
    message_properties  => m_prop,
    payload             => edn_event_data(event, source, subject_info, target),
    msgid               => m_handle);
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Enqueueing complete');
  end if;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  12c new API till PS1, adapter method used by Java midtier EdnAqConnection:
      void publishEvent(event, persistent, priority, timeToLive, edlURI)
  payloadWithContext := serialized XML of BusinessEvent Java object with root element "business-event"
             with subject and context
  source := (1) 'SOA' - from SOA Java component, 
            (2) 'Remote' - remote Java, (in 12c, this is the only possible value passed in)
            (3) 'PLSQL' - from PL/SQL procedure: edn_publish_event or edn_publish_event_with_context
  --) Invoking sp: edn_enq_event_to_aqjms
***********************************************************/
create or replace procedure edn_java_pub_event (namespace in varchar2, local_name in varchar2, 
  payloadWithContext in clob, source in varchar2, subject_info in varchar2, priority in pls_integer,
  persistent in char default 'N', timetolive in pls_integer default 0, keyfieldvalues in clob)
as
  p  boolean;
begin
  if (persistent = 'Y') then
    p := true;
  else
    p := false;
  end if;
  edn_enq_event_to_aqjms (namespace, local_name, payloadWithContext, source, subject_info, priority,
    p, timetolive, sys.xmltype.createXML(keyfieldvalues));
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  12.2 PS2 new API, adapter method used by Java midtier EdnAqConnection:
      void publishEvent(event, persistent, priority, timeToLive, edlURI)
  payloadWithContext := serialized XML of BusinessEvent Java object with root element "business-event"
             with subject and context
  source := (1) 'SOA' - from SOA Java component, 
            (2) 'Remote' - remote Java, (in 12c, this is the only possible value passed in)
            (3) 'PLSQL' - from PL/SQL procedure: edn_publish_event_to_aq or edn_publish_event_w_ctx_to_aq
  --) Invoking sp: edn_enqueue_business_event
***********************************************************/
create or replace procedure edn_java_pub_event_to_aq (namespace in varchar2, local_name in varchar2, 
  payloadWithContext in clob, source in varchar2, subject_info in varchar2, priority in pls_integer,
  persistent in char default 'N', timetolive in pls_integer default 0, keyfieldvalues in clob)
as
  eventXML         sys.xmltype;
  ns_decl          varchar(256);
  keyfieldvaluesEl sys.xmltype;
begin
  ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';
  eventXML := sys.xmltype.createXML(payloadWithContext);

  -- add priority to header property
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:priority', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:priority/text()', priority, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<priority xmlns="http://oracle.com/fabric/businessEvent">' || priority || '</priority>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- add persistent to header property
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:persistent', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:persistent/text()', persistent, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<persistent xmlns="http://oracle.com/fabric/businessEvent">' || persistent || '</persistent>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- add timetolive to header property
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:timetolive', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:timetolive/text()', timetolive, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<timetolive xmlns="http://oracle.com/fabric/businessEvent">' || timetolive || '</timetolive>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- add keyfieldvalues at same level as context, content
  if keyfieldvalues is not null then
    keyfieldvaluesEl := sys.xmltype.createXML('<keyfieldvalues xmlns="http://oracle.com/fabric/businessEvent"></keyfieldvalues>');
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event', keyfieldvaluesEl, ns_decl);
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event/be:keyfieldvalues', sys.xmltype.createXML(keyfieldvalues), ns_decl);
  end if;

  edn_enqueue_business_event (edn_business_event(namespace, local_name, eventXML, NULL, NULL), 'R', -- assuming source is always 'Remote'
    subject_info, NULL, priority);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  Main PL-SQL event publish API in 12c until PS1, for PL-SQL event publishing with context, subject,
     and a number of JMS messge related parameters supplied
  It has 12c specific additional parameters c.f. edn_publish_event_with_context
  payloadNoContext := serialized XML of BusinessEvent Java object with root element "business-event", 
             but without subject or context
  --) Invoking sp: edn_enq_event_to_aqjms
***********************************************************/
create or replace procedure edn_publish_event_12c (namespace in varchar2, local_name in varchar2, 
  payloadNoContext in clob, priority in pls_integer default 5, subject_info varchar2, context sys.xmltype, 
  persistent in boolean default false, timetolive in pls_integer default 0, keyfieldvalues in sys.xmltype)
as
  payloadWithContext  clob;
  eventXML            sys.xmltype;
  contextEl           sys.xmltype;
  ns_decl             varchar(256);
begin
  ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';
  -- put context inside event XML
  if context is not null then
    eventXML := sys.xmltype.createXML(payloadNoContext);
    contextEl := sys.xmltype.createXML('<context xmlns="http://oracle.com/fabric/businessEvent"></context>');
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event', contextEl, ns_decl);
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event/be:context', context, ns_decl);
    payloadWithContext := eventXML.getClobVal;
  else
    payloadWithContext := payloadNoContext;
  end if;

  edn_enq_event_to_aqjms (namespace, local_name, payloadWithContext, 'PLSQL', subject_info, priority, 
    persistent, timetolive, keyfieldvalues);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  Main PL-SQL event publish API in 12c starting PS2, for PL-SQL event publishing with context, subject,
     and a number of JMS messge related parameters supplied
  It has 12c specific additional parameters c.f. edn_publish_event_with_context
  payloadNoContext := serialized XML of BusinessEvent Java object with root element "business-event", 
             but without subject or context
  --) Invoking sp: edn_enqueue_business_event
***********************************************************/
create or replace procedure edn_publish_event_12c_to_aq (namespace in varchar2, local_name in varchar2, 
  payloadNoContext in clob, priority in pls_integer default 5, subject_info varchar2, context sys.xmltype, 
  persistent in boolean default false, timetolive in pls_integer default 0, keyfieldvalues in sys.xmltype)
as
  payloadWithContext  clob;
  eventXML            sys.xmltype;
  contextEl           sys.xmltype;
  ns_decl             varchar(256);
  keyfieldvaluesEl    sys.xmltype;
  p                   char;
begin
  ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';
  eventXML := sys.xmltype.createXML(payloadNoContext);

  -- add priority to header property
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:priority', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:priority/text()', priority, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<priority xmlns="http://oracle.com/fabric/businessEvent">' || priority || '</priority>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- add persistent to header property
  p := (CASE when persistent then 'Y' ELSE 'N' END);
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:persistent', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:persistent/text()', p, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<persistent xmlns="http://oracle.com/fabric/businessEvent">' || p || '</persistent>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- add timetolive to header property
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:timetolive', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:timetolive/text()', timetolive, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<timetolive xmlns="http://oracle.com/fabric/businessEvent">' || timetolive || '</timetolive>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- add keyfieldvalues at same level as context, content
  if keyfieldvalues is not null then
    keyfieldvaluesEl := sys.xmltype.createXML('<keyfieldvalues xmlns="http://oracle.com/fabric/businessEvent"></keyfieldvalues>');
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event', keyfieldvaluesEl, ns_decl);
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event/be:keyfieldvalues', keyfieldvalues, ns_decl);
  end if;

  -- put context inside event XML
  if context is not null then
    contextEl := sys.xmltype.createXML('<context xmlns="http://oracle.com/fabric/businessEvent"></context>');
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event', contextEl, ns_decl);
    eventXML := sys.xmltype.appendChildXML (eventXML, '/be:business-event/be:context', context, ns_decl);
  end if;

  edn_enqueue_business_event (edn_business_event(namespace, local_name, eventXML, NULL, NULL), 'S',
    subject_info, NULL, priority);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  MAIN API since 11g PS6 until 12c PS1, for PL-SQL event publishing with context and subject info supplied.
  payloadNoContext := serialized XML of BusinessEvent Java object with root element "business-event", 
             but without subject or context
  It adds context header element to event
  (-- Invoked by sp: edn_publish_event
  --) Invoking sp: edn_enq_event_to_aqjms
  Bug 21324237 - Compatible changes to retain FA priority support per 11g Bug 20847269:
       ignore passed priority value, use LOW priority = 1, also update priority header
***********************************************************/
create or replace procedure edn_publish_event_with_context (namespace in varchar2, local_name in varchar2, 
  payloadNoContext in clob, priority in pls_integer default 5, subject_info varchar2, context sys.xmltype) 
as
  eventXML            sys.xmltype;
  contextEl           sys.xmltype;
  ns_decl             varchar(256);
begin
  ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';
  
  -- Bug 21324237: ignore passed priority value, use LOW priority = 1, also update priority header
  eventXML := sys.xmltype.createXML(payloadNoContext);
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:priority', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:priority/text()', '1', 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<priority xmlns="http://oracle.com/fabric/businessEvent">1</priority>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  -- put context inside event XML
  if context is not null then
    contextEl := sys.xmltype.createXML('<context xmlns="http://oracle.com/fabric/businessEvent"></context>');
    eventXML := sys.xmltype.appendChildXML(eventXML, '/be:business-event', contextEl, ns_decl);
    eventXML := sys.xmltype.appendChildXML(eventXML, '/be:business-event/be:context', context, ns_decl);
  end if;

  edn_enq_event_to_aqjms (namespace, local_name, eventXML.getClobVal, 'PLSQL',
    subject_info, priority => 1, persistent => true, timetolive => 0, keyfieldvalues => null);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  New API since 12c PS2, for PL-SQL event publishing with context and subject info supplied.
  payloadNoContext := serialized XML of BusinessEvent Java object with root element "business-event", 
             but without subject or context
  It adds context header element to event
  (-- Invoked by sp: edn_publish_event_to_aq
  --) Invoking sp: edn_enqueue_business_event
  Bug 21324237 - Compatible changes to retain FA priority support per 11g Bug 20847269:
       ignore passed priority value, use LOW priority = 1, also update priority header
***********************************************************/
create or replace procedure edn_publish_event_w_ctx_to_aq (namespace in varchar2, local_name in varchar2, 
  payloadNoContext in clob, priority in pls_integer default 5, subject_info varchar2, context sys.xmltype) 
as
  eventXML            sys.xmltype;
  contextEl           sys.xmltype;
  ns_decl             varchar(256);
  effective_priority  pls_integer;
  log_id              number;
begin
  ns_decl := 'xmlns:be="http://oracle.com/fabric/businessEvent"';
  
  -- Bug 21324237: ignore passed priority value, use LOW priority = 1, also update priority header
  effective_priority := 1;
  eventXML := sys.xmltype.createXML(payloadNoContext);
  if sys.xmltype.existsNode(eventXML, '/e:business-event/e:priority', 
      'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
    select updateXML(eventXML, '/e:business-event/e:priority/text()', effective_priority, 
        'xmlns:e="http://oracle.com/fabric/businessEvent"')
      into eventXML from dual;
  else
    eventXML := sys.xmltype.appendChildXML (eventXML, '/e:business-event', 
        sys.xmltype.createXML('<priority xmlns="http://oracle.com/fabric/businessEvent">' || effective_priority || '</priority>'), 
        'xmlns:e="http://oracle.com/fabric/businessEvent"');
  end if;

  if edn_logging_enabled = 1 then
    log_id := edn_next_log_event_id;
    edn_log_message (log_id, 'Assign published event LOW priority (' || effective_priority || ') despite passed in value of ' || priority);
  end if;

  -- put context inside event XML
  if context is not null then
    contextEl := sys.xmltype.createXML('<context xmlns="http://oracle.com/fabric/businessEvent"></context>');
    eventXML := sys.xmltype.appendChildXML(eventXML, '/be:business-event', contextEl, ns_decl);
    eventXML := sys.xmltype.appendChildXML(eventXML, '/be:business-event/be:context', context, ns_decl);
  end if;

  edn_enqueue_business_event (edn_business_event(namespace, local_name, eventXML, NULL, NULL), 'S', -- meaning 'SQL' or 'PLSQL'
    subject_info, NULL, effective_priority);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  Main EDN public API since 11g, also supported in 12c, for PL-SQL event publishing without context or subject.
  payloadNoContext := serialized XML of BusinessEvent Java object with root element "business-event", 
             but without subject or context
  However, user should use edn_publish_event_with_context instead of this one as edn_publish_event
     does not carry context or subject info in event XML.
  --) Invoking sp: edn_publish_event_with_context
***********************************************************/
create or replace procedure edn_publish_event (namespace in varchar2, local_name in varchar2,
  payloadNoContext in clob, priority in pls_integer default 5) 
as
  subject_info 	varchar2(256);
  context       sys.xmltype;
begin
  subject_info := null;
  context := null;
  edn_publish_event_with_context (namespace, local_name, payloadNoContext,
    priority, subject_info, context);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g (PS7) Dequeue an Event from Main_Q with dequeue wait variable
  kept for backlog upgrade.
  (-- Invoked by sp: edn_dequeue_bus_event
  --) Invoking AQ API: DBMS_AQ.dequeue
  --) Invoking sp: edn_log_message
  --) Invoking function: edn_logging_enabled
  --) Invoking function: edn_next_log_event_id
  --) Using type: edn_business_event
  --) Using type: edn_event_data
  Bug 18351710 - add dequeue wait parameter; 
  Bug 21324237 - Compatible changes to retain FA priority support per 11g Bug 20847269: change log_id handling
***********************************************************/
create or replace procedure edn_dequeue_bus_event2 (subscriber in varchar2, namespace out varchar2, local_name out varchar2,
     payload out clob, comp_event out decimal, decomp_proc out varchar2, source out char, target out varchar2,
     subject_info out varchar2, deq_wait in binary_integer) as
  d_opt         DBMS_AQ.dequeue_options_t;
  m_prop        DBMS_AQ.message_properties_t;
  m_handle      RAW(16);
  event_data    edn_event_data;
  event         edn_business_event;
  ret           pls_integer;
  log_id        number;
  no_messages   exception;
  PRAGMA EXCEPTION_INIT(no_messages, -25228);
begin
  d_opt.navigation := DBMS_AQ.first_message;
  d_opt.consumer_name := subscriber;
  d_opt.wait := deq_wait;
  if deq_wait = 0 then
    d_opt.wait := DBMS_AQ.NO_WAIT;
  else
    if deq_wait < 0 then
      d_opt.wait := DBMS_AQ.FOREVER;
    end if;
  end if;

  DBMS_AQ.dequeue(
    queue_name          =>  '&edn_user..edn_event_queue',
    dequeue_options     =>  d_opt,
    message_properties  =>  m_prop,
    payload             =>  event_data,
    msgid               =>  m_handle);
  event := event_data.event;
  namespace := event.namespace;
  local_name := event.local_name;
  if event.payload is not null then
    payload := event.payload.getClobVal();
  end if;
  comp_event := event.compressed_event;
  decomp_proc := event.decomp_method;
  target := event_data.target;
  source := event_data.publish_impl;
  subject_info := event_data.subject_info;
  
  if edn_logging_enabled = 1 then
    log_id := edn_next_log_event_id;
  end if;
  
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Dequeued event: ' || namespace || '::' || local_name);
    edn_log_message (log_id, 'Subject name: "' || subject_info || '", AQ consumer: "' || subscriber || '"');
  end if;
  if event.payload is not null then
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Body: ' || event.payload.getClobVal());
    end if;
  else
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Event is compressed');
    end if;
  end if;

  exception when no_messages then
  begin
    namespace := null;
    local_name := null;
  end;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g Dequeue an Event from Main_Q with default dequeue wait value (5 seconds)
  kept for backlog upgrade.
  (-- Invoked by EDN Java: EventData readEvent(Connection)
      where subscriber="edn_java_subscriber"
  --) Invoking sp: edn_dequeue_bus_event2 (11g)
***********************************************************/
create or replace procedure edn_dequeue_bus_event (subscriber in varchar2, namespace out varchar2, local_name out varchar2,
     payload out clob, comp_event out decimal, decomp_proc out varchar2, source out char, target out varchar2,
     subject_info out varchar2) as
  deq_wait binary_integer;
begin
  deq_wait := 5;
  edn_dequeue_bus_event2 (subscriber, namespace, local_name, payload, comp_event, decomp_proc, source, target,
    subject_info, deq_wait);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g (since REL12) Dequeue an OAOO Delivery data from OAOO_Q with dequeue wait variable
  and prioritized flag indicating whether or not priority is considered during dequeue.
  The queueName parameter passed is always "edn_oaoo_queue"
  forward-ported for backlog upgrade.
  (-- Invoked by Java method: EventInvocation readOAOODelivery(Connection conn, byte[] msgId) 
  (-- Invoked by sp: edn_dequeue_oaoo_delivery2
  --) Invoking AQ API: DBMS_AQ.dequeue
  --) Invoking sp: edn_log_message
  --) Invoking function: edn_logging_enabled
  --) Invoking function: edn_next_log_event_id
  --) Using type: edn_oaoo_delivery
***********************************************************/
create or replace procedure edn_dequeue_oaoo_delivery3 (queueName in varchar2, target out varchar2,
    subject_info out varchar2, payload out clob, msg_id out raw, deq_wait in binary_integer, prioritized in binary_integer)  as
  d_opt             DBMS_AQ.dequeue_options_t;
  m_prop            DBMS_AQ.message_properties_t;
  m_handle          RAW(16);
  event_delivery    edn_oaoo_delivery;
  log_id            number;
  no_messages       exception;
  PRAGMA EXCEPTION_INIT(no_messages, -25228);
begin
  d_opt.navigation := DBMS_AQ.first_message;
  d_opt.consumer_name := 'edn_oaoo_subscriber';
  d_opt.wait := deq_wait;
  if deq_wait = 0 then
    d_opt.wait := DBMS_AQ.NO_WAIT;
  else
    if deq_wait < 0 then
      d_opt.wait := DBMS_AQ.FOREVER;
    end if;
  end if;

  -- Bug 20847269 - EDN 11g priority support: if prioritized=1, then do high priority-based dequeue with priority being 6,7,8,9
  if prioritized = 1 then
    d_opt.deq_condition := 'priority > 5';
  end if;

  DBMS_AQ.dequeue(
    queue_name          =>  queueName, /*queueName : edn_oaoo_queue*/
    dequeue_options     =>  d_opt,     /*d_opt.consumer_name : edn_oaoo_subscriber*/
    message_properties  =>  m_prop,
    payload             =>  event_delivery,
    msgid               =>  m_handle);
  target := event_delivery.target;
  payload := event_delivery.payload.getClobVal();
  msg_id := m_handle;
  subject_info := event_delivery.subject_info;

  if edn_logging_enabled = 1 then
    log_id := edn_next_log_event_id;
  end if;
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Dequeued OAOO delivery. Subject name: "' || subject_info || '". Target: "' || target || '"');
  end if;
  if event_delivery.payload is not null then
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Body: ' || event_delivery.payload.getClobVal());
    end if;
  else
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Event is compressed');
    end if;
  end if;

  exception when no_messages then
  begin
    payload := null;
    target := null;
  end;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g (PS7) Dequeue an OAOO Delivery data from OAOO_Q with dequeue wait variable
  kept for backlog upgrade.
  The queueName parameter passed is always "edn_oaoo_queue"
  (-- Invoked by sp: edn_dequeue_oaoo_delivery
  --) Invoking edn_dequeue_oaoo_delivery3
***********************************************************/
create or replace procedure edn_dequeue_oaoo_delivery2 (queueName in varchar2, target out varchar2,
    subject_info out varchar2, payload out clob, msg_id out raw, deq_wait in binary_integer)  as
  d_opt             DBMS_AQ.dequeue_options_t;
  m_prop            DBMS_AQ.message_properties_t;
  m_handle          RAW(16);
  event_delivery    edn_oaoo_delivery;
  log_id            number;
  no_messages       exception;
  PRAGMA EXCEPTION_INIT(no_messages, -25228);
begin
  -- Bug 20847269: last parameter 0 meaning non-priority based dequeue on OAOO_Q
  edn_dequeue_oaoo_delivery3(queueName, target, subject_info, payload, msg_id, deq_wait, 0);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g Dequeue an OAOO Delivery data from OAOO_Q with default dequeue wait value (5 seconds)
  kept for backlog upgrade.
  (-- Invoked by EDN Java: EventInvocation readOAOODelivery(Connection conn, byte[] msgId) 
       where queueName="edn_oaoo_queue"
  --) Invoking sp: edn_dequeue_oaoo_delivery2
***********************************************************/
create or replace procedure edn_dequeue_oaoo_delivery (queueName in varchar2, target out varchar2,
    subject_info out varchar2, payload out clob, msg_id out raw)  as
  deq_wait binary_integer;
begin
  deq_wait := 5;
  edn_dequeue_oaoo_delivery2 (queueName, target, subject_info, payload, msg_id, deq_wait);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure to be invoked automatically, but not used anymore since 11g PS7
  --) Using table: edn_event_agents
  --) Using table: edn_event_subscriptions
  --) Using type:  edn_business_event
  --) Using type:  edn_event_data
  --) Invoking sp: edn_filter_and_deliver_event
  --) Invoking sp: edn_log_message
  --) Invoking function: edn_logging_enabled
  --) Invoking function: edn_next_log_event_id
***********************************************************/
create or replace procedure edn_event_agent (context RAW, reginfo SYS.AQ$_REG_INFO,
    descr SYS.AQ$_DESCRIPTOR, payload raw, payloadl NUMBER)  as
  dequeue_options    DBMS_AQ.dequeue_options_t;
  message_properties DBMS_AQ.message_properties_t;
  message_handle     raw(16);
  event              edn_business_event;
  event_data         edn_event_data;
  call_agent         integer;
  err_code           varchar2(50);
  err_msg            varchar2(2000);
  log_id             number;
begin
  dequeue_options.msgid         := descr.msg_id;
  dequeue_options.consumer_name := descr.consumer_name;
  dequeue_options.wait          := DBMS_AQ.no_wait;
  
  log_id := edn_next_log_event_id;
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Starting EDN event agent (plsql) from source queue: ' || descr.queue_name);
  end if;

  DBMS_AQ.DEQUEUE(
    queue_name         => descr.queue_name,
    dequeue_options    => dequeue_options,
    message_properties => message_properties,
    payload            => event_data,
    msgid              => message_handle);

  event := event_data.event;
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Dequeued event: ' || event.namespace || '::' || event.local_name);
    edn_log_message (log_id, 'Subject name: "' || event_data.subject_info || '", AQ consumer: "' || descr.consumer_name || '"');
  end if;
  if event.payload is not null then
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Body: ' || event.payload.getClobVal());
    end if;
  else
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Event is compressed');
    end if;
  end if;

  for subscriber in 
    (select edn_event_agents.agent_id agent, edn_event_agents.agent_callback callback, 
          edn_event_subscriptions.xpath_filter xpath_filter, edn_event_subscriptions.xpath_ns_map xpath_ns_map 
      from 
        edn_event_subscriptions, edn_event_agents  
      where 
        namespace=event.namespace and local_name=event.local_name and
            edn_event_agents.agent_id=edn_event_subscriptions.agent_id and
            edn_event_subscriptions.sub_level = 'D' and
            edn_event_subscriptions.enabled = 'Y')    /* D: Deferred subscription */
  loop
    begin
      if edn_logging_enabled = 1 then
        edn_log_message (log_id, 'Invoking deferred subscriber: ' || subscriber.agent);
      end if;
      edn_filter_and_deliver_event (subscriber.agent, subscriber.callback, event, 
          subscriber.xpath_filter, subscriber.xpath_ns_map, event_data.subject_info, log_id);
    exception
      when others then
        if edn_logging_enabled = 1 then
          edn_log_message (log_id, 'Error in event subscriber: ' || sqlerrm);
        end if;
/*
        err_code := TO_CHAR(SQLCODE);
        err_msg := SQLERRM;
        edn_error_handler(descr.msg_id, event.namespace, event.local_name, 
          event.payload.getClobVal(), subscriber.agent, 0, err_code, 0, 
          err_msg, SUBSTR(err_msg,1,200),1, subscriber.agent); 
*/
    end;
  end loop;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_agents
***********************************************************/
create or replace procedure edn_register_agent (agent_id varchar2, agent_callback varchar2) as
begin
  insert into edn_event_agents values (agent_id, agent_callback);
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_agents
  --) Using table: edn_event_subscriptions
***********************************************************/
create or replace procedure edn_unregister_agent (id varchar2) as 
begin
  delete from edn_event_subscriptions where agent_id = id;
  delete from edn_event_agents where agent_id = id;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_agents
  --) Using table: edn_event_subscriptions
  --) Using sequence: edn_subscription_seq
***********************************************************/
CREATE OR REPLACE procedure edn_subscribe (agent_id varchar2, namespace varchar2,
        local_name varchar2, xpath_filter varchar2, xpath_ns_map varchar2, sub_id out number) as
  counter number;
  agent_not_found_exception exception;
  cursor c is select count(*) from edn_event_agents eea where eea.agent_id=agent_id;
begin
  open c;
  fetch c into counter;

  if (counter > 0) then
  	 select  edn_subscription_seq.nextval into sub_id from dual;
  	insert into edn_event_subscriptions values (sub_id, agent_id, namespace, local_name, 'D', 'Y',
    	   xpath_filter, xpath_ns_map);
    	   /* D: Deferred; Y: enabled */
  end if;  
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_subscriptions
***********************************************************/
create or replace procedure edn_subscription_exists (sid in number, exsts out number) is
begin
  select count(*) into exsts from edn_event_subscriptions subs where subs.sub_id = sid;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_subscriptions
***********************************************************/
create or replace procedure edn_unsubscribe (sid  number) as
begin
  delete from edn_event_subscriptions where sub_id = sid;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_subscriptions
***********************************************************/
create or replace procedure edn_enable_subscription (sid  number) as
begin
  update edn_event_subscriptions set enabled = 'Y' where sub_id = sid;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_subscriptions
***********************************************************/
create or replace procedure edn_disable_subscription (sid  number) as
begin
  update edn_event_subscriptions set enabled = 'N' where sub_id = sid;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_subscriptions
***********************************************************/
create or replace procedure edn_unsubscribe_all (id varchar2) as 
begin
  delete from edn_event_subscriptions where agent_id = id;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

/***********************************************************
  11g procedure for database subscription
  --) Using table: edn_event_subscriptions
  --) Using sequence: edn_subscription_seq
***********************************************************/
create or replace procedure edn_subscribe_immediate (agent_id varchar2, namespace varchar2, 
        local_name varchar2, xpath_filter varchar2, xpath_ns_map varchar2, sub_id out number) as
begin
  select edn_subscription_seq.nextval into sub_id from dual;
  insert into edn_event_subscriptions values (sub_id, agent_id, namespace, local_name, 'I', 'Y', xpath_filter, xpath_ns_map);
        /* I: Immeidate; Y: enabled */
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace function edn_get_event_queue_backlog return clob is
  evt EDN_BUSINESS_EVENT;
  TYPE map_t IS TABLE OF NUMBER INDEX BY VARCHAR2(512);
  map_tab map_t;
  qname VARCHAR2(512);
  cnt NUMBER;
  backlogs clob;
  k VARCHAR2(512);
BEGIN
  for cur in (SELECT user_data FROM AQ$EDN_EVENT_QUEUE_TABLE WHERE DEQ_TIME is null)
  loop
    begin
      evt := cur.user_data.event;
      qname := '{' || evt.namespace || '}'  || evt.local_name;
      cnt := map_tab(qname);
      map_tab(qname) := cnt + 1;
      exception 
        when others then
          map_tab(qname) := 1; -- first time
    end;    
  end loop;

  k := map_tab.FIRST;
  backlogs := '';
  WHILE k IS NOT NULL LOOP
    backlogs := backlogs || '||' || map_tab(k) || '==' || k;
    --dbms_output.put_line(map_tab(k) || '==' || k);
    k := map_tab.NEXT( k );  
  END LOOP;
  
  return backlogs;
END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace function edn_get_oaoo_queue_backlog return clob is
  TYPE map_t IS TABLE OF NUMBER INDEX BY VARCHAR2(512);
  map_tab map_t;
  qname VARCHAR2(512);
  cnt NUMBER;
  backlogs clob;
  target VARCHAR2(1024);
  xml CLOB;
  k VARCHAR2(1024);
  pos1 pls_integer;
  pos2 pls_integer;
  ns_map VARCHAR2(512);
  prefix VARCHAR2(16);
  local_name VARCHAR2(512);
  ns VARCHAR2(512);
BEGIN
  for cur in (SELECT user_data FROM AQ$EDN_OAOO_DELIVERY_TABLE WHERE DEQ_TIME is null)
  loop
    begin
      target := cur.user_data.target;
      xml := cur.user_data.payload.getClobVal();
      pos1 := instr(xml, '<name>') + length('<name>');
      pos2 := instr(xml, '</name>');
      qname := trim(substr(xml, pos1, pos2 - pos1));
      prefix := substr(qname, 1, instr(qname, ':') - 1);
      local_name := substr(qname, instr(qname, ':') + 1);
      prefix := 'xmlns:' || prefix || '="';
      pos1 := instr(xml, prefix) + length(prefix);
      pos2 := instr(xml, '"', pos1);
      ns := trim(substr(xml, pos1, pos2 - pos1));
      qname := '{' || ns || '}' || local_name;
      k := qname || '^^' || target;
      cnt := map_tab(k);
      map_tab(k) := cnt + 1;
      exception 
        when others then
          map_tab(k) := 1; -- first time
    end;    
  end loop;

  k := map_tab.FIRST;
  backlogs := '';
  WHILE k IS NOT NULL LOOP
    backlogs := backlogs || '||' || map_tab(k) || '==' || k;
    --dbms_output.put_line(map_tab(k) || '==' || k);
    k := map_tab.NEXT( k );
  END LOOP;
  
  return backlogs;
END;
/

-- oracle----------------------------------------------------------------------- 
-- Bug 25576907 - support of event durablity for a suspended OAOO target subscriber 

REM  Enqueue an OAOO Delivery 
REM     with support of event durablity for a suspended OAOO target subscriber
create or replace procedure edn_enqueue_oaoo_delivery_dura (queueName in varchar2, target varchar2, subject_info varchar2,  
    payload in clob, suspended in binary_integer) as 
  payload_xml   sys.xmltype;
  e_opt         DBMS_AQ.enqueue_options_t;
  m_prop        DBMS_AQ.message_properties_t;
  m_handle      raw(16);
  log_id        number;
  priority      pls_integer;
begin
  log_id := edn_next_log_event_id;
  if edn_logging_enabled = 1 then
    if suspended = 1 then
      edn_log_message (log_id, 'Enqueuing OAOO delivery. Subject name: "' || subject_info || '". Target: "' || target || '". Target SUSPENDED!!!');
    else
      edn_log_message (log_id, 'Enqueuing OAOO delivery. Subject name: "' || subject_info || '". Target: "' || target || '". Target Active.');
    end if;
  end if;
  
  payload_xml := sys.xmltype.createXML(payload);

  -- handles event priority below
  if payload is not NULL then
    if sys.xmltype.existsNode(payload_xml, '/e:business-event/e:priority', 
        'xmlns:e="http://oracle.com/fabric/businessEvent"') = 1 then
      select extractValue(payload_xml, '/e:business-event/e:priority/text()', 
            'xmlns:e="http://oracle.com/fabric/businessEvent"') 
          into priority from dual;
      m_prop.priority := priority;
      if edn_logging_enabled = 1 then
        edn_log_message (log_id, 'Body: ' || payload_xml.getClobVal());
        edn_log_message (log_id, 'Event Priority obtained from header: ' || priority);
      end if;
    else
      m_prop.priority := 1;
      if edn_logging_enabled = 1 then
        edn_log_message (log_id, 'Body: ' || payload_xml.getClobVal());
        edn_log_message (log_id, 'Cannot find event priority header, hence set LOW Priority: 1');
      end if;
    end if;
  else
    m_prop.priority := 1;
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Event is compressed');
      edn_log_message (log_id, 'Set LOW Priority: 1');
    end if;
  end if;

  -- update user_property to indicate state: 1- suspended, 0- not suspended
  m_prop.user_property := SYS.ANYDATA.ConvertNumber(suspended);
  
  DBMS_AQ.enqueue(
    queue_name         => queueName,
    enqueue_options    => e_opt,
    message_properties => m_prop,
    payload            => edn_oaoo_delivery(target, subject_info, payload_xml),
    msgid              => m_handle);
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Enqueuing OAOO delivery complete');
  end if;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Bug 25576907 - support of event durablity for a suspended OAOO target subscriber 

REM  Dequeue an OAOO Delivery with both dequeue wait and dequeue condition variables
REM     with support of event durablity for a suspended OAOO target subscriber
create or replace procedure edn_dequeue_oaoo_delivery_dura (queueName in varchar2, target out varchar2,
    subject_info out varchar2, payload out clob, msg_id out raw, deq_wait in binary_integer, deq_condition in varchar2) as
  d_opt             DBMS_AQ.dequeue_options_t;
  m_prop            DBMS_AQ.message_properties_t;
  m_handle          RAW(16);
  event_delivery    edn_oaoo_delivery;
  log_id            number;
  no_messages       exception;
  PRAGMA EXCEPTION_INIT(no_messages, -25228);
begin
  d_opt.navigation := DBMS_AQ.first_message;
  d_opt.consumer_name := 'edn_oaoo_subscriber';
  d_opt.wait := deq_wait;
  if deq_wait = 0 then
    d_opt.wait := DBMS_AQ.NO_WAIT;
  else
    if deq_wait < 0 then
      d_opt.wait := DBMS_AQ.FOREVER;
    end if;
  end if;

  -- deq_condition(filter) specifies suspended flag, priority, target DN pattern and/or cutoff time.  
  d_opt.deq_condition := deq_condition;

  DBMS_AQ.dequeue(
    queue_name          =>  queueName, /*queueName : edn_oaoo_queue*/
    dequeue_options     =>  d_opt,     /*d_opt.consumer_name : edn_oaoo_subscriber*/
    message_properties  =>  m_prop,
    payload             =>  event_delivery,
    msgid               =>  m_handle);
  target := event_delivery.target;
  payload := event_delivery.payload.getClobVal();
  msg_id := m_handle;
  subject_info := event_delivery.subject_info;

  log_id := edn_next_log_event_id;
  if edn_logging_enabled = 1 then
    edn_log_message (log_id, 'Dequeued OAOO delivery for Active subscriber. Subject name: "' || subject_info || '". Target: "' || target || '"');
  end if;
  if event_delivery.payload is not null then
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Body: ' || event_delivery.payload.getClobVal());
    end if;
  else
    if edn_logging_enabled = 1 then
      edn_log_message (log_id, 'Event is compressed');
    end if;
  end if;

  exception when no_messages then
  begin
    payload := null;
    target := null;
  end;
end;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace
PACKAGE SOA_TRK AS 

    --Fabric composite state bits
    STATE_RUNNING_OR_COMPLETED constant integer := 1;
    STATE_FAULTED constant integer := 2;
    STATE_RECOVERY_REQUIRED constant integer := 4;
    STATE_SUSPENDED constant integer := 8;
    STATE_TERMINATED_BY_USER constant integer := 16;
    STATE_UNKNOWN constant integer := 32;
    STATE_STALE constant integer := 64;
    
    FUNCTION IS_CPST_INFLIGHT_STATE(CPST_STATE IN NUMBER) RETURN NUMBER;
    FUNCTION IS_CPST_UNKNOWN_STATE(CPST_STATE IN NUMBER) RETURN NUMBER;
    PROCEDURE CHECK_COMPOSITE_UNDEPLOY_LOG(COMPOSITE_DN IN VARCHAR2, RESULT OUT INTEGER, LOG_MSG OUT VARCHAR2);
    PROCEDURE CHECK_COMPOSITE_UNDEPLOYMENT(COMPOSITE_DN IN VARCHAR2, RESULT OUT INTEGER);
    PROCEDURE CHECK_COMPONENT_STATE(COMPOSITE_INSTANCE_ID IN VARCHAR2, RESULT OUT INTEGER);
    PROCEDURE CHECK_COMPONENT_STATE_CPST_DN(COMPOSITE_DN IN VARCHAR2, RESULT OUT INTEGER);
    PROCEDURE GET_SHORT_COMPOSITE_DN(COMPOSITE_DN IN VARCHAR2, COMPOSITE_DN_SHORT OUT VARCHAR2);
    
END SOA_TRK;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

create or replace
PACKAGE BODY SOA_TRK
AS
gv_log_message VARCHAR(8000);
--
FUNCTION IS_CPST_INFLIGHT_STATE(
    CPST_STATE IN NUMBER )
  RETURN NUMBER
IS
  RET_RESULT NUMBER := 0;
BEGIN
  IF (CPST_STATE = 0) OR (CPST_STATE = 2) THEN
    RETURN 1;
  ELSIF (CPST_STATE >= 16) THEN
    RETURN 0;
  END IF;
  IF (
      (
        (
          bitand(CPST_STATE, STATE_SUSPENDED) = STATE_SUSPENDED
        )
        OR
        (
          bitand(CPST_STATE, STATE_RECOVERY_REQUIRED) = STATE_RECOVERY_REQUIRED
        )
      )
    )
    THEN
    RET_RESULT := 1;
  END IF;
  RETURN RET_RESULT;
END IS_CPST_INFLIGHT_STATE;
--
FUNCTION IS_CPST_UNKNOWN_STATE(
    CPST_STATE IN NUMBER )
  RETURN NUMBER
IS
  RET_RESULT NUMBER := 0;
BEGIN
  IF (bitand(CPST_STATE, STATE_UNKNOWN) = STATE_UNKNOWN) THEN
    RET_RESULT                         := 1;
  END IF;
  RETURN RET_RESULT;
END IS_CPST_UNKNOWN_STATE;
--
PROCEDURE CHECK_COMPOSITE_UNDEPLOY_LOG(COMPOSITE_DN IN VARCHAR2, RESULT OUT INTEGER, LOG_MSG OUT VARCHAR2)
AS
BEGIN
    gv_log_message := '';
    CHECK_COMPOSITE_UNDEPLOYMENT(COMPOSITE_DN, RESULT);
    LOG_MSG := gv_log_message;
END CHECK_COMPOSITE_UNDEPLOY_LOG;
--
--Here are 3 possible cases to handle regarding user configured audit trail
--setting:
--1. Based on composite_dn, get the list of composite instance; if no record
--found, that would be case #3
--2. If composite instance record found, if state in unknown state, that would
--be case #2
--3. For case #1, check the composite instance state for inflight state
-- if the list of composite instance records reflects the different audit
--trail setting over time
--, we want to use the latest composite instance record to reflect such the
--case.
--
PROCEDURE CHECK_COMPOSITE_UNDEPLOYMENT(
    COMPOSITE_DN IN VARCHAR2,
    RESULT OUT INTEGER)
AS
  v_composite_inflgt_inst_count  INTEGER;
  v_composite_unknown_inst_count INTEGER;
  init_stmt                      VARCHAR2(4000);
  stmt                           VARCHAR2(4000);
  v_component_state_result       INTEGER;
  v_composite_instance_id        VARCHAR2(2000);
  v_composite_dn                 VARCHAR2(500);
BEGIN
  RESULT          := 0;
  IF COMPOSITE_DN IS NULL THEN
    RETURN;
  END IF;
  init_stmt :=
  'select count(*) from composite_instance where composite_dn = ''' ||
  COMPOSITE_DN || '''';
  stmt := init_stmt ||
    ' and ( (state < 16 and state >3) or state = 0 or state =  2 )';
  dbms_output.put_line('stmt : ' || stmt);
  EXECUTE IMMEDIATE stmt INTO v_composite_inflgt_inst_count;
  IF (v_composite_inflgt_inst_count > 0) THEN
    -- since there is inflight instance at composite, just return false.
    gv_log_message := gv_log_message || ' WARNING: There are ' || v_composite_inflgt_inst_count || ' active state composite instances.' || chr(10);
    RESULT := 0;
  ELSE
    -- if there is no inflight instance at composite, it will fall into case #2 or #3
    -- gv_log_message := gv_log_message || ' INFO: CASE for Composite Audit Trail OFF.' || chr(10);
    CHECK_COMPONENT_STATE_CPST_DN(composite_dn, v_component_state_result);
    IF (v_component_state_result = 1) THEN
      gv_log_message := gv_log_message || ' WARNING: Service Engine Component Instance indicates there are active instances. ' || chr(10);
      RETURN;
    ELSE
      gv_log_message := gv_log_message || ' INFO: Service Engine Component Instance indicates there are NO active instances. ' || chr(10);
      RESULT := 1;
    END IF;
  END IF;
END CHECK_COMPOSITE_UNDEPLOYMENT;
--
-- This procedure is used for case #2
-- We would use composite_dn for query to avoid the looping of composite instance id
-- For checking case #2, we will be using case #3 procedure as well
--
PROCEDURE CHECK_COMPONENT_STATE(
    COMPOSITE_INSTANCE_ID IN VARCHAR2,
    RESULT OUT INTEGER)
AS
  v_component_inst_count       INTEGER;
  v_bpel_component_inst_count  INTEGER;
  v_med_component_inst_count   INTEGER;
  v_rules_component_inst_count INTEGER;
  v_hwf_component_inst_count   INTEGER;
  subquery                     VARCHAR2(4000);
BEGIN
  RESULT                   := 0;
  IF COMPOSITE_INSTANCE_ID IS NULL THEN
    RETURN;
  END IF;
  BEGIN
    subquery := 'select count(*) from cube_instance c where ' ||
    COMPOSITE_INSTANCE_ID || ' = to_number(c.cmpst_id) and c.state < 5';
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_bpel_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_bpel_component_inst_count || ' cube_instances under inflight state with matched compsoite instance id: ' || COMPOSITE_INSTANCE_ID || chr(10);    
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_bpel_component_inst_count := 0;
  END;
  BEGIN
    subquery := 'select count(*) from mediator_instance M where ' ||
    COMPOSITE_INSTANCE_ID ||
    ' = M.COMPOSITE_INSTANCE_ID AND M.COMPONENT_STATE between 4 and 15';
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_med_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_med_component_inst_count || ' mediator_instance under inflight state with matched compsoite instance id: ' || COMPOSITE_INSTANCE_ID || chr(10);    
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_med_component_inst_count := 0;
  END;
  BEGIN
    subquery := 'select count(*) from BRDECISIONINSTANCE B where ' ||
    COMPOSITE_INSTANCE_ID ||
    ' = to_number(B.COMPOSITE_INSTANCE_ID) AND B.STATE = 0';
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_rules_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_rules_component_inst_count || ' BRDECISIONINSTANCE under inflight state with matched compsoite instance id: ' || COMPOSITE_INSTANCE_ID || chr(10);    
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_rules_component_inst_count := 0;
  END;
  BEGIN
    subquery := 'select count(*) from COMPONENT_INSTANCE CP where ' ||
    COMPOSITE_INSTANCE_ID ||
    ' = to_number(CP.COMPOSITE_INSTANCE_ID) AND CP.STATE = 0';
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_component_inst_count || ' COMPONENT_INSTANCE under inflight state with matched compsoite instance id: ' || COMPOSITE_INSTANCE_ID || chr(10);        
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_component_inst_count := 0;
  END;
  BEGIN
    subquery := 'SELECT count(*) ' ||'       FROM WFTASK W ' ||'        where '
    || COMPOSITE_INSTANCE_ID || ' = to_number(W.COMPOSITEINSTANCEID) ' ||
    '          AND W.STATE IS NOT NULL ' ||
    '          AND W.STATE NOT IN (''DELETED'',''ERRORED'',''EXPIRED'',''STALE'',''WITHDRAWN'')'
    ;
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_hwf_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_hwf_component_inst_count || ' WFTASK under inflight state with matched compsoite instance id: ' || COMPOSITE_INSTANCE_ID || chr(10);            
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_hwf_component_inst_count := 0;
  END;
  IF (v_component_inst_count>0) OR
    (
      v_bpel_component_inst_count>0
    )
    OR
    (
      v_med_component_inst_count>0
    )
    OR
    (
      v_rules_component_inst_count>0
    )
    OR
    (
      v_hwf_component_inst_count>0
    )
    THEN
    RESULT := 1;
  END IF;
END CHECK_COMPONENT_STATE;
--
-- This procedure is used for case #3
-- We took out the component and rule checking since it is most likely be in sync process with completed state
-- To accommodate the case #2 in this procedure, we take out the criteria on checking composite instance id is null 
--
PROCEDURE CHECK_COMPONENT_STATE_CPST_DN(
    COMPOSITE_DN IN VARCHAR2,
    RESULT OUT INTEGER)
AS
  v_bpel_component_inst_count  INTEGER;
  v_dlv_message_inst_count     INTEGER;
  v_med_component_inst_count   INTEGER;
  v_hwf_component_inst_count   INTEGER;
  v_short_composite_dn         VARCHAR2(500);
  subquery                     VARCHAR2(4000);
BEGIN
  RESULT          := 0;
  IF COMPOSITE_DN IS NULL THEN
    RETURN;
  END IF;
  BEGIN
    subquery := 'select count(*) from dlv_message where ''' || COMPOSITE_DN
    ||
    ''' = domain_name || ''/'' || composite_name || ''!'' || composite_revision || ''*'' || composite_label and state in (0,1)'
    ;
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_dlv_message_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_bpel_component_inst_count || ' cube_instance under inflight state with matched COMPOSITE_DN: ' || COMPOSITE_DN || chr(10);            
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_dlv_message_inst_count := 0;
  END;
  IF (v_dlv_message_inst_count>0) THEN
    RESULT := 1;
    RETURN;
  END IF;
  BEGIN
    subquery := 'select count(*) from cube_instance where ''' || COMPOSITE_DN
    ||
    ''' = domain_name || ''/'' || composite_name || ''!'' || composite_revision || ''*'' || composite_label and state < 5'
    ;
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_bpel_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_bpel_component_inst_count || ' cube_instance under inflight state with matched COMPOSITE_DN: ' || COMPOSITE_DN || chr(10);            
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_bpel_component_inst_count := 0;
  END;
  IF (v_bpel_component_inst_count>0) THEN
    RESULT := 1;
    RETURN;
  END IF;
  BEGIN
    subquery :=
    'select count(*) from mediator_instance where component_name = ''' ||
    COMPOSITE_DN ||
    ''' AND COMPONENT_STATE between 4 and 15'
    ;
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_med_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_med_component_inst_count || ' mediator_instance under inflight state with matched COMPOSITE_DN: ' || COMPOSITE_DN || chr(10);                
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_med_component_inst_count := 0;
  END;
  IF (v_med_component_inst_count>0) THEN
    RESULT := 1;
    RETURN;
  END IF;
  -- hwf will use like on comparing composite_dn due to the natural of user oriented process which might left running after redeployment
  BEGIN
    GET_SHORT_COMPOSITE_DN(COMPOSITE_DN, v_short_composite_dn);
    subquery := 'SELECT count(*) ' ||'       FROM WFTASK W ' ||
    '        where w.compositedn like ''' || v_short_composite_dn ||
    '%''' ||
    '          AND W.STATE IS NOT NULL ' ||
    '          AND W.STATE NOT IN (''DELETED'',''ERRORED'',''EXPIRED'',''STALE'',''WITHDRAWN'')'
    ;
    dbms_output.put_line('subquery : ' || subquery);
    EXECUTE IMMEDIATE subquery INTO v_hwf_component_inst_count;
    -- gv_log_message := gv_log_message || ' Found ' || v_hwf_component_inst_count || ' WFTASK under inflight state with matched COMPOSITE_DN: ' || COMPOSITE_DN || chr(10);                            
  EXCEPTION
  WHEN NO_DATA_FOUND THEN
    v_hwf_component_inst_count := 0;
  END;  
  IF (v_hwf_component_inst_count>0) THEN
    RESULT := 1;
  END IF;  
END CHECK_COMPONENT_STATE_CPST_DN;
-- parse long composite dn which includes the uuid label and return the short version without uuid label.
PROCEDURE GET_SHORT_COMPOSITE_DN(COMPOSITE_DN IN VARCHAR2, COMPOSITE_DN_SHORT OUT VARCHAR2)
AS
  stmt                           VARCHAR2(4000);
BEGIN
    COMPOSITE_DN_SHORT := '';
    stmt := 'select substr(''' || COMPOSITE_DN || ''', 1, instr(''' || COMPOSITE_DN || ''',''*'')-1) from dual';
    dbms_output.put_line('stmt : ' || stmt);
    EXECUTE IMMEDIATE stmt INTO COMPOSITE_DN_SHORT;
    RETURN;
END GET_SHORT_COMPOSITE_DN;
END SOA_TRK;
/

-- oracle----------------------------------------------------------------------- 
-- ATT_STORE_PK reverse 

alter index ATT_STORE_PK rebuild reverse
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SENSOR_SEQUENCE (SEQ_NAME, SEQ_COUNT) values ('GLOBAL_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SENSOR_SEQUENCE (SEQ_NAME, SEQ_COUNT) values ('ACTIVITY_SENSOR_VALUES_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SENSOR_SEQUENCE (SEQ_NAME, SEQ_COUNT) values ('FAULT_SENSOR_VALUES_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SENSOR_SEQUENCE (SEQ_NAME, SEQ_COUNT) values ('VARIABLE_SENSOR_VALUES_SEQ', 0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('COMPOSITE_INSTANCE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('COMPONENT_INSTANCE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('REFERENCE_INSTANCE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('BRIDGE_INSTANCE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('REJECTED_MESSAGE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('COMPOSITE_INSTANCE_FAULT_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('SCA_FLOW_INSTANCE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('SCA_COMMON_FAULT_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('SCA_ENTITY_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('SCA_PARTITION_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('FAULT_NOTIFICATION_RULE_SEQ',0)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

insert into SEQUENCE values('BULK_RECOVERY_JOB_SEQ',0)
/

-- oracle----------------------------------------------------------------------- 
-- DOC_STORE_PK reverse 

alter index DOC_STORE_PK rebuild reverse
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'FAULT_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'COMPONENT_INSTANCE_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'FLOW_EVENT_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'AUDIT_DETAIL_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'AUDIT_TRAIL_COUNT', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'SCA_REJECTED_MSG_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'COMPOSITE_INSTANCE_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'FLOW_INSTANCE_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'SCA_ENTITY_IDS', 2 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'REP_BUSINESS_EVENT_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'REP_BUS_RECOV_JOB_IDS', 1 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO SCA_SEQUENCE( RANGE_NAME, NEXT_RANGE ) values( 'SCA_TENANT_ENTITY_IDS', 1000000001 )
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO UPGRADE_CURRENT_SEQUENCE VALUES( 'FAULT_IDS',-1,-1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO UPGRADE_CURRENT_SEQUENCE VALUES( 'FLOW_INSTANCE_IDS',-1,-1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO UPGRADE_CURRENT_SEQUENCE VALUES( 'COMPONENT_INSTANCE_IDS',-1,-1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO UPGRADE_CURRENT_SEQUENCE VALUES( 'SCA_ENTITY_IDS',-1,-1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO UPGRADE_CURRENT_SEQUENCE VALUES( 'SCA_REJECTED_MSG_IDS',-1,-1)
/

-- oracleEbr----------------------------------------------------------------------- 
-- Compress index Flow Code column 

ALTER INDEX REP_BUS_EVT_FC_PDATE REBUILD COMPRESS 1
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO PMON_SEQUENCE(RANGE_NAME,NEXT_RANGE) values('AUDIT_IDS',1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO PMON_SEQUENCE(RANGE_NAME, NEXT_RANGE) values('REJECTED_MODEL_IDS',1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO PMON_SEQUENCE(RANGE_NAME, NEXT_RANGE) values('LC_JOB_IDS',1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO PMON_SEQUENCE(RANGE_NAME, NEXT_RANGE) values('EVENT_IDS',1)
/

-- ----------------------------------------------------------------------- 
-- Unknown 

INSERT INTO PMON_SEQUENCE(RANGE_NAME, NEXT_RANGE) values('UNIQUE_IDS',1)
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE SOA_HEALTHCHECK_REQID_SEQ START WITH 1 INCREMENT BY 1
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE WFTaskSeq START WITH 200000 INCREMENT BY 1
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE WFApprovalGroupIdSeq INCREMENT BY 1
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE SEQUENCE pc_tasknumber_sq  START WITH 10000 INCREMENT BY 1
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE PROCEDURE PC_CreateAssigneeHistory(
                          v_taskId IN VARCHAR2,
                          v_maxVersion IN NUMBER,
                          v_assignee IN VARCHAR2)
IS
BEGIN
   IF v_assignee IS NOT NULL THEN
     UPDATE PC_TASKASSIGNEEHISTORY
        SET MaxVersion = v_maxVersion
        WHERE taskId = v_taskId
        AND assignee = v_assignee
        AND MaxVersion is NULL
        AND version <= v_maxVersion;

      DELETE FROM PC_TASKASSIGNEE
          WHERE taskId = v_taskId
                   AND assignee = v_assignee
                   AND version <= v_maxVersion;
    ELSE
      UPDATE PC_TASKASSIGNEEHISTORY
        SET MaxVersion = v_maxVersion
        WHERE taskId = v_taskId
              AND MaxVersion is NULL
              AND version <= v_maxVersion;

      DELETE FROM PC_TASKASSIGNEE
          WHERE taskId = v_taskId
            AND version <= v_maxVersion ;

    END IF;

EXCEPTION
  WHEN OTHERS THEN
     raise_application_error(-20001,
       'Exception while creating Assignee history ', true);
END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE PROCEDURE PC_InsertAssignee(
                            v_taskId IN VARCHAR2,
                            v_version IN NUMBER,
                            v_assignee IN VARCHAR2,
                            v_guid IN VARCHAR2,
                            v_isGroup IN VARCHAR2)
IS
BEGIN
  INSERT INTO PC_TASKASSIGNEEHISTORY
        (taskId, version ,  Assignee,guid,isGroup)
        VALUES(v_taskId,v_version,v_assignee,v_guid,v_isGroup);
  INSERT INTO PC_TASKASSIGNEE
        (taskId, version ,  Assignee,guid,isGroup)
        VALUES(v_taskId,v_version,v_assignee,v_guid,v_isGroup);


EXCEPTION
  WHEN OTHERS THEN
     raise_application_error(-20001,
       'Exception while creating Assignee history ', true);
END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

DECLARE
       queue_not_exist exception;
       queue_table_not_exist exception;
       pragma EXCEPTION_INIT(queue_not_exist, -24010);
       pragma EXCEPTION_INIT(queue_table_not_exist, -24002);
      BEGIN
       dbms_aqadm.stop_queue (queue_name => 'TASK_NOTIFICATION_Q');
       dbms_aqadm.drop_queue (queue_name => 'TASK_NOTIFICATION_Q');
       dbms_aqadm.drop_queue_table (queue_table => 'TASK_NOTIFICATION_Q_T');
      EXCEPTION
       WHEN queue_not_exist THEN
        dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
       WHEN queue_table_not_exist THEN
        dbms_output.put_line('[' || SQLCODE || '] ' || SQLERRM);
       WHEN others THEN
      -- re-throw current exception
      raise;
      END;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

BEGIN
        dbms_aqadm.create_queue_table (queue_table => 'TASK_NOTIFICATION_Q_T', queue_payload_type =>  'sys.aq$_jms_text_message', multiple_consumers => FALSE);
        dbms_aqadm.create_queue (queue_name =>  'TASK_NOTIFICATION_Q', queue_table =>  'TASK_NOTIFICATION_Q_T');
        dbms_aqadm.start_queue(queue_name =>  'TASK_NOTIFICATION_Q');
      END;
/

-- oracle----------------------------------------------------------------------- 
-- Procedure to enable all HWF WFTask FK Constraints 

CREATE OR REPLACE PROCEDURE HWF_ENABLE_CONSTRAINTS AS
BEGIN
   dbms_output.put_line('Enabling constraints');
   FOR r_constraints IN
     (SELECT table_name, constraint_name
        FROM user_constraints
       WHERE constraint_type = 'R' 
         AND r_constraint_name = 'WFTASK_PK')
   LOOP
    execute immediate 'ALTER TABLE ' || r_constraints.table_name || ' ENABLE CONSTRAINT ' || r_constraints.constraint_name;
   END LOOP;
   dbms_output.put_line('Enabling constraints - done');
END HWF_ENABLE_CONSTRAINTS;
/

-- oracle----------------------------------------------------------------------- 
-- Procedure to disable all HWF WFTask FK Constraints 

CREATE OR REPLACE PROCEDURE HWF_DISABLE_CONSTRAINTS AS
BEGIN
   dbms_output.put_line('Disabling constraints');
   FOR r_constraints IN
     (SELECT table_name, constraint_name
        FROM user_constraints
       WHERE constraint_type = 'R' 
         AND r_constraint_name = 'WFTASK_PK')
   LOOP
    execute immediate 'ALTER TABLE ' || r_constraints.table_name || ' DISABLE CONSTRAINT ' || r_constraints.constraint_name;
   END LOOP;
   dbms_output.put_line('Disabling constraints - done');
END HWF_DISABLE_CONSTRAINTS;
/

-- oracle----------------------------------------------------------------------- 
-- Unknown 

CREATE OR REPLACE PACKAGE WFTaskpkg_122130 AS
  
  BLOB_DATATYPE NUMBER := 7;
  BOOLEAN_FALSE_STRING VARCHAR2(1) := 'F';
  BOOLEAN_TRUE_STRING VARCHAR2(1) := 'T';
  
  TYPE TASK_TRANSLATION_T IS TABLE OF VARCHAR2(2000)
     INDEX BY BINARY_INTEGER;

   FUNCTION insertRoutingSlip(
                             p_taskId  VARCHAR2,
                             p_taskNumber NUMBER,
                             p_compositeCreatedTime TIMESTAMP
                            ) RETURN blob;
  
  
  FUNCTION updateRoutingSlip(
                              p_taskId  VARCHAR2,
                              p_notm NUMBER
                             ) RETURN blob;


  PROCEDURE insertTask(  
                               p_acquiredBy                  VARCHAR2,
                               p_assignees              VARCHAR2,
                               p_assigneesDisplayName   VARCHAR2,
                               p_reviewers              VARCHAR2,
                               p_reviewersDisplayName   VARCHAR2,
                               p_callbackContext             VARCHAR2,
                               p_callbackId                  VARCHAR2,
                               p_callbackType                VARCHAR2,
                               p_creator                     VARCHAR2,
                               p_digitalSignatureRequired    VARCHAR2,
                               p_expirationDate              DATE,
                               p_expirationDuration          VARCHAR2,
                               p_identityContext             VARCHAR2,
                               p_ownerUser                   VARCHAR2,
                               p_ownerGroup                   VARCHAR2,
                               p_ownerRole                   VARCHAR2,
                               p_passwordRequiredOnUpdate    VARCHAR2,
                               p_priority                    NUMBER,
                               p_domainId                    VARCHAR2,
                               p_instanceId                  VARCHAR2,
                               p_processId                   VARCHAR2,
                               p_processName                 VARCHAR2,
                               p_processType                 VARCHAR2,
                               p_processVersion              VARCHAR2,
                               p_secureNotifications         VARCHAR2,
                               p_accessKey                   VARCHAR2,
                               p_approvalDuration            NUMBER,
                               p_approvers                   VARCHAR2,
                               p_assignedDate                DATE,
                               p_createdDate                 DATE,
                               p_elapsedTime                 NUMBER,
                               p_endDate                     DATE,
                               p_fromUser                    VARCHAR2,
                               p_fromUserDisplayName         VARCHAR2,
                               p_hasSubtask                  VARCHAR2,
                               p_inShortHistory              VARCHAR2,
                               p_isGroup                     VARCHAR2,
                               p_language                    VARCHAR2,
                               p_mailStatus                  VARCHAR2,
                               p_numberOfTimesModified       NUMBER,
                               p_originalAssigneeUser        VARCHAR2,
                               p_outcome                     VARCHAR2,
                               p_parallelOutcomeCount        VARCHAR2,
                               p_pushbackSequence            VARCHAR2,
                               p_State                       VARCHAR2,
                               p_SubState                    VARCHAR2,
                               p_systemString1               VARCHAR2,
                               p_systemString2               VARCHAR2,
                               p_SystemString3               VARCHAR2,
                               p_taskGroupId                 VARCHAR2,
                               p_taskId                      VARCHAR2,
                               p_taskNumber      IN OUT      NUMBER,
                               p_updatedBy                   VARCHAR2,
                               p_updatedByDisplayName        VARCHAR2,
                               p_updatedDate                 DATE,
                               p_updatedNotificationId       VARCHAR2,
                               p_version                     NUMBER,
                               p_versionReason               VARCHAR2,
                               p_workflowPattern             VARCHAR2,
                               p_textAttribute1              VARCHAR2,
                               p_textAttribute2              VARCHAR2,
                               p_textAttribute3              VARCHAR2,
                               p_textAttribute4              VARCHAR2,
                               p_textAttribute5              VARCHAR2,
                               p_textAttribute6              VARCHAR2,
                               p_textAttribute7              VARCHAR2,
                               p_textAttribute8              VARCHAR2,
                               p_textAttribute9              VARCHAR2,
                               p_textAttribute10             VARCHAR2,
                               p_textAttribute11             VARCHAR2,
                               p_textAttribute12             VARCHAR2,
                               p_textAttribute13             VARCHAR2,
                               p_textAttribute14             VARCHAR2,
                               p_textAttribute15             VARCHAR2,
                               p_textAttribute16             VARCHAR2,
                               p_textAttribute17             VARCHAR2,
                               p_textAttribute18             VARCHAR2,
                               p_textAttribute19             VARCHAR2,
                               p_textAttribute20             VARCHAR2,
                               p_formAttribute1              VARCHAR2,
                               p_formAttribute2              VARCHAR2,
                               p_formAttribute3              VARCHAR2,
                               p_formAttribute4              VARCHAR2,
                               p_formAttribute5              VARCHAR2,
                               p_formAttribute6              VARCHAR2,
                               p_formAttribute7              VARCHAR2,
                               p_formAttribute8              VARCHAR2,
                               p_formAttribute9              VARCHAR2,
                               p_formAttribute10             VARCHAR2,
                               p_urlAttribute1               VARCHAR2,
                               p_urlAttribute2               VARCHAR2,
                               p_urlAttribute3               VARCHAR2,
                               p_urlAttribute4               VARCHAR2,
                               p_urlAttribute5               VARCHAR2,
                               p_urlAttribute6               VARCHAR2,
                               p_urlAttribute7               VARCHAR2,
                               p_urlAttribute8               VARCHAR2,
                               p_urlAttribute9               VARCHAR2,
                               p_urlAttribute10              VARCHAR2,
                               p_dateAttribute1              DATE,
                               p_dateAttribute2              DATE,
                               p_dateAttribute3              DATE,
                               p_dateAttribute4              DATE,
                               p_dateAttribute5              DATE,
                               p_dateAttribute6              DATE,
                               p_dateAttribute7              DATE,
                               p_dateAttribute8              DATE,
                               p_dateAttribute9              DATE,
                               p_dateAttribute10             DATE,
                               p_numberAttribute1            NUMBER,
                               p_numberAttribute2            NUMBER,
                               p_numberAttribute3            NUMBER,
                               p_numberAttribute4            NUMBER,
                               p_numberAttribute5            NUMBER,
                               p_numberAttribute6            NUMBER,
                               p_numberAttribute7            NUMBER,
                               p_numberAttribute8            NUMBER,
                               p_numberAttribute9            NUMBER,
                               p_numberAttribute10           NUMBER,
                               p_protectedTextAttribute1     VARCHAR2,
                               p_protectedTextAttribute2     VARCHAR2,
                               p_protectedTextAttribute3     VARCHAR2,
                               p_protectedTextAttribute4     VARCHAR2,
                               p_protectedTextAttribute5     VARCHAR2,
                               p_protectedTextAttribute6     VARCHAR2,
                               p_protectedTextAttribute7     VARCHAR2,
                               p_protectedTextAttribute8     VARCHAR2,
                               p_protectedTextAttribute9     VARCHAR2,
                               p_protectedTextAttribute10    VARCHAR2,
                               p_protectedTextAttribute11    VARCHAR2,
                               p_protectedTextAttribute12    VARCHAR2,
                               p_protectedTextAttribute13    VARCHAR2,
                               p_protectedTextAttribute14    VARCHAR2,
                               p_protectedTextAttribute15    VARCHAR2,
                               p_protectedTextAttribute16    VARCHAR2,
                               p_protectedTextAttribute17    VARCHAR2,
                               p_protectedTextAttribute18    VARCHAR2,
                               p_protectedTextAttribute19    VARCHAR2,
                               p_protectedTextAttribute20    VARCHAR2,
                               p_protectedFormAttribute1     VARCHAR2,
                               p_protectedFormAttribute2     VARCHAR2,
                               p_protectedFormAttribute3     VARCHAR2,
                               p_protectedFormAttribute4     VARCHAR2,
                               p_protectedFormAttribute5     VARCHAR2,
                               p_protectedFormAttribute6     VARCHAR2,
                               p_protectedFormAttribute7     VARCHAR2,
                               p_protectedFormAttribute8     VARCHAR2,
                               p_protectedFormAttribute9     VARCHAR2,
                               p_protectedFormAttribute10    VARCHAR2,
                               p_protectedUrlAttribute1      VARCHAR2,
                               p_protectedUrlAttribute2      VARCHAR2,
                               p_protectedUrlAttribute3      VARCHAR2,
                               p_protectedUrlAttribute4      VARCHAR2,
                               p_protectedUrlAttribute5      VARCHAR2,
                               p_protectedUrlAttribute6      VARCHAR2,
                               p_protectedUrlAttribute7      VARCHAR2,
                               p_protectedUrlAttribute8      VARCHAR2,
                               p_protectedUrlAttribute9      VARCHAR2,
                               p_protectedUrlAttribute10     VARCHAR2,
                               p_protectedDateAttribute1     DATE,
                               p_protectedDateAttribute2     DATE,
                               p_protectedDateAttribute3     DATE,
                               p_protectedDateAttribute4     DATE,
                               p_protectedDateAttribute5     DATE,
                               p_protectedDateAttribute6     DATE,
                               p_protectedDateAttribute7     DATE,
                               p_protectedDateAttribute8     DATE,
                               p_protectedDateAttribute9     DATE,
                               p_protectedDateAttribute10    DATE,
                               p_protectedNumberAttribute1   NUMBER,
                               p_protectedNumberAttribute2   NUMBER,
                               p_protectedNumberAttribute3   NUMBER,
                               p_protectedNumberAttribute4   NUMBER,
                               p_protectedNumberAttribute5   NUMBER,
                               p_protectedNumberAttribute6   NUMBER,
                               p_protectedNumberAttribute7   NUMBER,
                               p_protectedNumberAttribute8   NUMBER,
                               p_protectedNumberAttribute9   NUMBER,
                               p_protectedNumberAttribute10  NUMBER,
                               p_title                       VARCHAR2,
                               p_titleResourceKey            VARCHAR2,
                               p_identificationKey           VARCHAR2,
                               p_workflowDescriptorURI       VARCHAR2,
                               p_taskDefinitionId            VARCHAR2,
                               p_taskDefinitionName          VARCHAR2,
                               p_applicationContext          VARCHAR2,
                               p_applicationName             VARCHAR2,
                               p_category                    VARCHAR2,
                               p_componentName               VARCHAR2,
                               p_compositeDN                 VARCHAR2,
                               p_compositeInstanceId         VARCHAR2,
                               p_compositeName               VARCHAR2,
                               p_compositeVersion            VARCHAR2,
                               p_conversationId              VARCHAR2,
                               p_dueDate                     DATE,
                               p_ecId                        VARCHAR2,
                               p_isPublic                    VARCHAR2,
                               p_isTestTask                  VARCHAR2,
                               p_parentComponentInstanceId   VARCHAR2,
                               p_parentComponentInstRefId    VARCHAR2,
                               p_invokedComponent            VARCHAR2,
                               p_participantName             VARCHAR2,
                               p_percentageComplete          NUMBER,
                               p_readByUsers                 VARCHAR2,
                               p_startDate                   DATE,
                               p_parentTaskVersion           NUMBER,
                               p_taskGroupInstanceId         VARCHAR2,
                               p_subTaskGroupInstanceId      VARCHAR2,
                               p_agRootId                    NUMBER,
                               p_agMileStonePath             VARCHAR2,
                               p_rootTaskId                  VARCHAR2,
                               p_parentTaskId                VARCHAR2,
                               p_systemStringActions         VARCHAR2,
                               p_taskDisplayUrl              VARCHAR2,
                               p_documentPackageId           VARCHAR2,
                               p_subCategory                 VARCHAR2,
                               p_correlationId               VARCHAR2,
                               p_stage                       VARCHAR2,
                               p_assignmentContext           VARCHAR2,
                               p_preActionUserSteps          VARCHAR2,
                               p_aggregationTaskId           VARCHAR2,
                               p_mdsLabel                    VARCHAR2,
                               p_isTemplateTask              VARCHAR2,
                               p_componentType               VARCHAR2,
                               p_activityName                VARCHAR2,
                               p_activityId                  VARCHAR2,
                               p_processDueDate              DATE,
                               p_thread                      INTEGER,
                               p_parentThread                INTEGER,
                               p_step                        INTEGER,
                               p_taskNamespace               VARCHAR2,
                               p_timers                      VARCHAR2,
                               p_vrcValues                   VARCHAR2,
                               p_organizationalUnitId        VARCHAR2,
                               p_compositeCreatedTime        TIMESTAMP,
                               p_tenantId                    VARCHAR2,
                               p_listBuilderId               VARCHAR2,
                               p_caseId                      VARCHAR2,
                               p_swimlaneRole                VARCHAR2,
                               p_excludedParticipants        VARCHAR2,
                               p_customAttributeString1    VARCHAR2,
                               p_customAttributeString2    VARCHAR2,
                               p_customAttributeNumber1    NUMBER,
                               p_customAttributeNumber2    NUMBER,
                               p_customAttributeDate1      DATE,
                               p_customAttributeDate2      DATE,
                               p_timersSuspended           VARCHAR2,
                               p_tenant_id		   NUMBER,
                               p_isDecomposedTask          VARCHAR2,
                               p_formName                  VARCHAR2,
                               p_decomposedTaskGrpInstanceId VARCHAR2,
                               p_startTime                 TIMESTAMP,
			       p_stopTime                  TIMESTAMP,
                               p_workingduration           INTEGER,
                               p_shortSummary              VARCHAR2,
                               p_longSummary               VARCHAR2,
                               p_COMPONENT_INSTANCE_ID       INTEGER,
                               p_FLOW_ID                   INTEGER,
                               p_SCA_PARTITION_ID          INTEGER
                             );
                             
                            
    /**
     *  Insert update of process instance. This package takes same argument as others so that we can reuse the bind
     *  code from java. This takes extra argument as locale which is last argument. 
     */
    PROCEDURE insertUpdateProcessInstance(  
                               p_acquiredBy                  VARCHAR2,
                               p_assignees              VARCHAR2,
                               p_assigneesDisplayName   VARCHAR2,
                               p_reviewers              VARCHAR2,
                               p_reviewersDisplayName   VARCHAR2,
                               p_callbackContext             VARCHAR2,
                               p_callbackId                  VARCHAR2,
                               p_callbackType                VARCHAR2,
                               p_creator                     VARCHAR2,
                               p_digitalSignatureRequired    VARCHAR2,
                               p_expirationDate              DATE,
                               p_expirationDuration          VARCHAR2,
                               p_identityContext             VARCHAR2,
                               p_ownerUser                   VARCHAR2,
                               p_ownerGroup                   VARCHAR2,
                               p_ownerRole                   VARCHAR2,
                               p_passwordRequiredOnUpdate    VARCHAR2,
                               p_priority                    NUMBER,
                               p_domainId                    VARCHAR2,
                               p_instanceId                  VARCHAR2,
                               p_processId                   VARCHAR2,
                               p_processName                 VARCHAR2,
                               p_processType                 VARCHAR2,
                               p_processVersion              VARCHAR2,
                               p_secureNotifications         VARCHAR2,
                               p_accessKey                   VARCHAR2,
                               p_approvalDuration            NUMBER,
                               p_approvers                   VARCHAR2,
                               p_assignedDate                DATE,
                               p_createdDate          IN OUT       DATE,
                               p_elapsedTime                 NUMBER,
                               p_endDate                     DATE,
                               p_fromUser                    VARCHAR2,
                               p_fromUserDisplayName         VARCHAR2,
                               p_hasSubtask                  VARCHAR2,
                               p_inShortHistory              VARCHAR2,
                               p_isGroup                     VARCHAR2,
                               p_language                    VARCHAR2,
                               p_mailStatus                  VARCHAR2,
                               p_numberOfTimesModified  IN OUT     NUMBER,
                               p_originalAssigneeUser        VARCHAR2,
                               p_outcome                     VARCHAR2,
                               p_parallelOutcomeCount        VARCHAR2,
                               p_pushbackSequence            VARCHAR2,
                               p_State                       VARCHAR2,
                               p_SubState                    VARCHAR2,
                               p_systemString1               VARCHAR2,
                               p_systemString2               VARCHAR2,
                               p_SystemString3               VARCHAR2,
                               p_taskGroupId                 VARCHAR2,
                               p_taskId                      VARCHAR2,
                               p_taskNumber      IN OUT      NUMBER,
                               p_updatedBy                   VARCHAR2,
                               p_updatedByDisplayName        VARCHAR2,
                               p_updatedDate        IN OUT         DATE,
                               p_updatedNotificationId       VARCHAR2,
                               p_version        IN OUT             NUMBER,
                               p_versionReason               VARCHAR2,
                               p_workflowPattern             VARCHAR2,
                               p_textAttribute1              VARCHAR2,
                               p_textAttribute2              VARCHAR2,
                               p_textAttribute3              VARCHAR2,
                               p_textAttribute4              VARCHAR2,
                               p_textAttribute5              VARCHAR2,
                               p_textAttribute6              VARCHAR2,
                               p_textAttribute7              VARCHAR2,
                               p_textAttribute8              VARCHAR2,
                               p_textAttribute9              VARCHAR2,
                               p_textAttribute10             VARCHAR2,
                               p_textAttribute11             VARCHAR2,
                               p_textAttribute12             VARCHAR2,
                               p_textAttribute13             VARCHAR2,
                               p_textAttribute14             VARCHAR2,
                               p_textAttribute15             VARCHAR2,
                               p_textAttribute16             VARCHAR2,
                               p_textAttribute17             VARCHAR2,
                               p_textAttribute18             VARCHAR2,
                               p_textAttribute19             VARCHAR2,
                               p_textAttribute20             VARCHAR2,
                               p_formAttribute1              VARCHAR2,
                               p_formAttribute2              VARCHAR2,
                               p_formAttribute3              VARCHAR2,
                               p_formAttribute4              VARCHAR2,
                               p_formAttribute5              VARCHAR2,
                               p_formAttribute6              VARCHAR2,
                               p_formAttribute7              VARCHAR2,
                               p_formAttribute8              VARCHAR2,
                               p_formAttribute9              VARCHAR2,
                               p_formAttribute10             VARCHAR2,
                               p_urlAttribute1               VARCHAR2,
                               p_urlAttribute2               VARCHAR2,
                               p_urlAttribute3               VARCHAR2,
                               p_urlAttribute4               VARCHAR2,
                               p_urlAttribute5               VARCHAR2,
                               p_urlAttribute6               VARCHAR2,
                               p_urlAttribute7               VARCHAR2,
                               p_urlAttribute8               VARCHAR2,
                               p_urlAttribute9               VARCHAR2,
                               p_urlAttribute10              VARCHAR2,
                               p_dateAttribute1              DATE,
                               p_dateAttribute2              DATE,
                               p_dateAttribute3              DATE,
                               p_dateAttribute4              DATE,
                               p_dateAttribute5              DATE,
                               p_dateAttribute6              DATE,
                               p_dateAttribute7              DATE,
                               p_dateAttribute8              DATE,
                               p_dateAttribute9              DATE,
                               p_dateAttribute10             DATE,
                               p_numberAttribute1            NUMBER,
                               p_numberAttribute2            NUMBER,
                               p_numberAttribute3            NUMBER,
                               p_numberAttribute4            NUMBER,
                               p_numberAttribute5            NUMBER,
                               p_numberAttribute6            NUMBER,
                               p_numberAttribute7            NUMBER,
                               p_numberAttribute8            NUMBER,
                               p_numberAttribute9            NUMBER,
                               p_numberAttribute10           NUMBER,
                               p_protectedTextAttribute1     VARCHAR2,
                               p_protectedTextAttribute2     VARCHAR2,
                               p_protectedTextAttribute3     VARCHAR2,
                               p_protectedTextAttribute4     VARCHAR2,
                               p_protectedTextAttribute5     VARCHAR2,
                               p_protectedTextAttribute6     VARCHAR2,
                               p_protectedTextAttribute7     VARCHAR2,
                               p_protectedTextAttribute8     VARCHAR2,
                               p_protectedTextAttribute9     VARCHAR2,
                               p_protectedTextAttribute10    VARCHAR2,
                               p_protectedTextAttribute11    VARCHAR2,
                               p_protectedTextAttribute12    VARCHAR2,
                               p_protectedTextAttribute13    VARCHAR2,
                               p_protectedTextAttribute14    VARCHAR2,
                               p_protectedTextAttribute15    VARCHAR2,
                               p_protectedTextAttribute16    VARCHAR2,
                               p_protectedTextAttribute17    VARCHAR2,
                               p_protectedTextAttribute18    VARCHAR2,
                               p_protectedTextAttribute19    VARCHAR2,
                               p_protectedTextAttribute20    VARCHAR2,
                               p_protectedFormAttribute1     VARCHAR2,
                               p_protectedFormAttribute2     VARCHAR2,
                               p_protectedFormAttribute3     VARCHAR2,
                               p_protectedFormAttribute4     VARCHAR2,
                               p_protectedFormAttribute5     VARCHAR2,
                               p_protectedFormAttribute6     VARCHAR2,
                               p_protectedFormAttribute7     VARCHAR2,
                               p_protectedFormAttribute8     VARCHAR2,
                               p_protectedFormAttribute9     VARCHAR2,
                               p_protectedFormAttribute10    VARCHAR2,
                               p_protectedUrlAttribute1      VARCHAR2,
                               p_protectedUrlAttribute2      VARCHAR2,
                               p_protectedUrlAttribute3      VARCHAR2,
                               p_protectedUrlAttribute4      VARCHAR2,
                               p_protectedUrlAttribute5      VARCHAR2,
                               p_protectedUrlAttribute6      VARCHAR2,
                               p_protectedUrlAttribute7      VARCHAR2,
                               p_protectedUrlAttribute8      VARCHAR2,
                               p_protectedUrlAttribute9      VARCHAR2,
                               p_protectedUrlAttribute10     VARCHAR2,
                               p_protectedDateAttribute1     DATE,
                               p_protectedDateAttribute2     DATE,
                               p_protectedDateAttribute3     DATE,
                               p_protectedDateAttribute4     DATE,
                               p_protectedDateAttribute5     DATE,
                               p_protectedDateAttribute6     DATE,
                               p_protectedDateAttribute7     DATE,
                               p_protectedDateAttribute8     DATE,
                               p_protectedDateAttribute9     DATE,
                               p_protectedDateAttribute10    DATE,
                               p_protectedNumberAttribute1   NUMBER,
                               p_protectedNumberAttribute2   NUMBER,
                               p_protectedNumberAttribute3   NUMBER,
                               p_protectedNumberAttribute4   NUMBER,
                               p_protectedNumberAttribute5   NUMBER,
                               p_protectedNumberAttribute6   NUMBER,
                               p_protectedNumberAttribute7   NUMBER,
                               p_protectedNumberAttribute8   NUMBER,
                               p_protectedNumberAttribute9   NUMBER,
                               p_protectedNumberAttribute10  NUMBER,
                               p_title                       VARCHAR2,
                               p_titleResourceKey            VARCHAR2,
                               p_identificationKey           VARCHAR2,
                               p_workflowDescriptorURI       VARCHAR2,
                               p_taskDefinitionId            VARCHAR2,
                               p_taskDefinitionName          VARCHAR2,
                               p_applicationContext          VARCHAR2,
                               p_applicationName             VARCHAR2,
                               p_category                    VARCHAR2,
                               p_componentName               VARCHAR2,
                               p_compositeDN                 VARCHAR2,
                               p_compositeInstanceId         VARCHAR2,
                               p_compositeName               VARCHAR2,
                               p_compositeVersion            VARCHAR2,
                               p_conversationId              VARCHAR2,
                               p_dueDate                     DATE,
                               p_ecId                        VARCHAR2,
                               p_isPublic                    VARCHAR2,
                               p_isTestTask                  VARCHAR2,
                               p_parentComponentInstanceId   VARCHAR2,
                               p_parentComponentInstRefId    VARCHAR2,
                               p_invokedComponent            VARCHAR2,
                               p_participantName             VARCHAR2,
                               p_percentageComplete          NUMBER,
                               p_readByUsers                 VARCHAR2,
                               p_startDate                   DATE,
                               p_parentTaskVersion           NUMBER,
                               p_taskGroupInstanceId         VARCHAR2,
                               p_subTaskGroupInstanceId      VARCHAR2,
                               p_agRootId                    NUMBER,
                               p_agMileStonePath             VARCHAR2,
                               p_rootTaskId                  VARCHAR2,
                               p_parentTaskId                VARCHAR2,
                               p_systemStringActions         VARCHAR2,
                               p_taskDisplayUrl              VARCHAR2,
                               p_documentPackageId           VARCHAR2,
                               p_subCategory                 VARCHAR2,
                               p_correlationId               VARCHAR2,
                               p_stage                       VARCHAR2,
                               p_assignmentContext           VARCHAR2,
                               p_preActionUserSteps          VARCHAR2,
                               p_aggregationTaskId           VARCHAR2,
                               p_mdsLabel                    VARCHAR2,
                               p_isTemplateTask              VARCHAR2,
                               p_componentType               VARCHAR2,
                               p_activityName                VARCHAR2,
                               p_activityId                  VARCHAR2,
                               p_processDueDate              DATE,
                               p_thread                      INTEGER,
                               p_parentThread                INTEGER,
                               p_step                        INTEGER,
                               p_taskNamespace               VARCHAR2,
                               p_timers                      VARCHAR2,
                               p_vrcValues                   VARCHAR2,
                               p_organizationalUnitId        VARCHAR2,
                               p_compositeCreatedTime        TIMESTAMP,
                               p_tenantId                    VARCHAR2,
                               p_listBuilderId               VARCHAR2,
                               p_caseId                      VARCHAR2,
                               p_swimlaneRole              VARCHAR2,
                               p_excludedParticipants      VARCHAR2,
                               p_customAttributeString1    VARCHAR2,
                               p_customAttributeString2    VARCHAR2,
                               p_customAttributeNumber1    NUMBER,
                               p_customAttributeNumber2    NUMBER,
                               p_customAttributeDate1      DATE,
                               p_customAttributeDate2      DATE,
                               p_timersSuspended           VARCHAR2,
                               p_tenant_id		   NUMBER,
                               p_isDecomposedTask          VARCHAR2,
                               p_formName                  VARCHAR2,
                               p_decomposedTaskGrpInstanceId VARCHAR2,
			       p_startTime                 TIMESTAMP,
			       p_stopTime                  TIMESTAMP,
                               p_workingduration           INTEGER,
                               p_shortSummary              VARCHAR2,
                               p_longSummary               VARCHAR2,
                               p_COMPONENT_INSTANCE_ID       INTEGER,
                               p_FLOW_ID                   INTEGER,
                               p_SCA_PARTITION_ID          INTEGER,
                               /** p_locale should be the last parameter **/
                               p_locale                      VARCHAR2
                             );
      
      
      /*
       * Performs a bulk insert of the WFTask_TL data for the
       * given taskId.
       *
       * p_taskId - The ID of the task to which the translations will be 
       *            attached
       * p_task_data The PL/SQL table containing the translations to be
       *             attached for the task.
       * p_isVersionable - A flag to create a history version of the 
       *                   translations
       */
      PROCEDURE createTaskTranslations(p_taskId VARCHAR2,
                                       p_version NUMBER,
                                       p_task_data TASK_TRANSLATION_T,
                                       p_rec_size NUMBER,
                                       p_isVersionable VARCHAR2,
                                       p_compositeCreatedTime TIMESTAMP,
                                       p_FLOW_ID NUMBER,
                                       p_SCA_PARTITION_ID NUMBER
                                      );
      
       PROCEDURE updateTask(  
                               p_acquiredBy                  VARCHAR2,
                               p_assignees              VARCHAR2,
                               p_assigneesDisplayName   VARCHAR2,
                               p_reviewers              VARCHAR2,
                               p_reviewersDisplayName   VARCHAR2,
                               p_callbackContext             VARCHAR2,
                               p_callbackId                  VARCHAR2,
                               p_callbackType                VARCHAR2,
                               p_creator                     VARCHAR2,
                               p_digitalSignatureRequired    VARCHAR2,
                               p_expirationDate              DATE,
                               p_expirationDuration          VARCHAR2,
                               p_identityContext             VARCHAR2,
                               p_ownerUser                   VARCHAR2,
                               p_ownerGroup                   VARCHAR2,
                               p_ownerRole                   VARCHAR2,
                               p_passwordRequiredOnUpdate    VARCHAR2,
                               p_priority                    NUMBER,
                               p_domainId                    VARCHAR2,
                               p_instanceId                  VARCHAR2,
                               p_processId                   VARCHAR2,
                               p_processName                 VARCHAR2,
                               p_processType                 VARCHAR2,
                               p_processVersion              VARCHAR2,
                               p_secureNotifications         VARCHAR2,
                               p_accessKey                   VARCHAR2,
                               p_approvalDuration            NUMBER,
                               p_approvers                   VARCHAR2,
                               p_assignedDate                DATE,
                               p_createdDate                 DATE,
                               p_elapsedTime                 NUMBER,
                               p_endDate                     DATE,
                               p_fromUser                    VARCHAR2,
                               p_fromUserDisplayName         VARCHAR2,
                               p_hasSubtask                  VARCHAR2,
                               p_inShortHistory              VARCHAR2,
                               p_isGroup                     VARCHAR2,
                               p_language                    VARCHAR2,
                               p_mailStatus                  VARCHAR2,
                               p_numberOfTimesModified       NUMBER,
                               p_originalAssigneeUser        VARCHAR2,
                               p_outcome                     VARCHAR2,
                               p_parallelOutcomeCount        VARCHAR2,
                               p_pushbackSequence            VARCHAR2,
                               p_State                       VARCHAR2,
                               p_SubState                    VARCHAR2,
                               p_systemString1               VARCHAR2,
                               p_systemString2               VARCHAR2,
                               p_SystemString3               VARCHAR2,
                               p_taskGroupId                 VARCHAR2,
                               p_taskId                      VARCHAR2,
                               p_taskNumber                  NUMBER,
                               p_updatedBy                   VARCHAR2,
                               p_updatedByDisplayName        VARCHAR2,
                               p_updatedDate                 DATE,
                               p_updatedNotificationId       VARCHAR2,
                               p_version                     NUMBER,
                               p_versionReason               VARCHAR2,
                               p_workflowPattern             VARCHAR2,
                               p_textAttribute1              VARCHAR2,
                               p_textAttribute2              VARCHAR2,
                               p_textAttribute3              VARCHAR2,
                               p_textAttribute4              VARCHAR2,
                               p_textAttribute5              VARCHAR2,
                               p_textAttribute6              VARCHAR2,
                               p_textAttribute7              VARCHAR2,
                               p_textAttribute8              VARCHAR2,
                               p_textAttribute9              VARCHAR2,
                               p_textAttribute10             VARCHAR2,
                               p_textAttribute11             VARCHAR2,
                               p_textAttribute12             VARCHAR2,
                               p_textAttribute13             VARCHAR2,
                               p_textAttribute14             VARCHAR2,
                               p_textAttribute15             VARCHAR2,
                               p_textAttribute16             VARCHAR2,
                               p_textAttribute17             VARCHAR2,
                               p_textAttribute18             VARCHAR2,
                               p_textAttribute19             VARCHAR2,
                               p_textAttribute20             VARCHAR2,
                               p_formAttribute1              VARCHAR2,
                               p_formAttribute2              VARCHAR2,
                               p_formAttribute3              VARCHAR2,
                               p_formAttribute4              VARCHAR2,
                               p_formAttribute5              VARCHAR2,
                               p_formAttribute6              VARCHAR2,
                               p_formAttribute7              VARCHAR2,
                               p_formAttribute8              VARCHAR2,
                               p_formAttribute9              VARCHAR2,
                               p_formAttribute10             VARCHAR2,
                               p_urlAttribute1               VARCHAR2,
                               p_urlAttribute2               VARCHAR2,
                               p_urlAttribute3               VARCHAR2,
                               p_urlAttribute4               VARCHAR2,
                               p_urlAttribute5               VARCHAR2,
                               p_urlAttribute6               VARCHAR2,
                               p_urlAttribute7               VARCHAR2,
                               p_urlAttribute8               VARCHAR2,
                               p_urlAttribute9               VARCHAR2,
                               p_urlAttribute10              VARCHAR2,
                               p_dateAttribute1              DATE,
                               p_dateAttribute2              DATE,
                               p_dateAttribute3              DATE,
                               p_dateAttribute4              DATE,
                               p_dateAttribute5              DATE,
                               p_dateAttribute6              DATE,
                               p_dateAttribute7              DATE,
                               p_dateAttribute8              DATE,
                               p_dateAttribute9              DATE,
                               p_dateAttribute10             DATE,
                               p_numberAttribute1            NUMBER,
                               p_numberAttribute2            NUMBER,
                               p_numberAttribute3            NUMBER,
                               p_numberAttribute4            NUMBER,
                               p_numberAttribute5            NUMBER,
                               p_numberAttribute6            NUMBER,
                               p_numberAttribute7            NUMBER,
                               p_numberAttribute8            NUMBER,
                               p_numberAttribute9            NUMBER,
                               p_numberAttribute10           NUMBER,
                               p_protectedTextAttribute1     VARCHAR2,
                               p_protectedTextAttribute2     VARCHAR2,
                               p_protectedTextAttribute3     VARCHAR2,
                               p_protectedTextAttribute4     VARCHAR2,
                               p_protectedTextAttribute5     VARCHAR2,
                               p_protectedTextAttribute6     VARCHAR2,
                               p_protectedTextAttribute7     VARCHAR2,
                               p_protectedTextAttribute8     VARCHAR2,
                               p_protectedTextAttribute9     VARCHAR2,
                               p_protectedTextAttribute10    VARCHAR2,
                               p_protectedTextAttribute11    VARCHAR2,
                               p_protectedTextAttribute12    VARCHAR2,
                               p_protectedTextAttribute13    VARCHAR2,
                               p_protectedTextAttribute14    VARCHAR2,
                               p_protectedTextAttribute15    VARCHAR2,
                               p_protectedTextAttribute16    VARCHAR2,
                               p_protectedTextAttribute17    VARCHAR2,
                               p_protectedTextAttribute18    VARCHAR2,
                               p_protectedTextAttribute19    VARCHAR2,
                               p_protectedTextAttribute20    VARCHAR2,
                               p_protectedFormAttribute1     VARCHAR2,
                               p_protectedFormAttribute2     VARCHAR2,
                               p_protectedFormAttribute3     VARCHAR2,
                               p_protectedFormAttribute4     VARCHAR2,
                               p_protectedFormAttribute5     VARCHAR2,
                               p_protectedFormAttribute6     VARCHAR2,
                               p_protectedFormAttribute7     VARCHAR2,
                               p_protectedFormAttribute8     VARCHAR2,
                               p_protectedFormAttribute9     VARCHAR2,
                               p_protectedFormAttribute10    VARCHAR2,
                               p_protectedUrlAttribute1      VARCHAR2,
                               p_protectedUrlAttribute2      VARCHAR2,
                               p_protectedUrlAttribute3      VARCHAR2,
                               p_protectedUrlAttribute4      VARCHAR2,
                               p_protectedUrlAttribute5      VARCHAR2,
                               p_protectedUrlAttribute6      VARCHAR2,
                               p_protectedUrlAttribute7      VARCHAR2,
                               p_protectedUrlAttribute8      VARCHAR2,
                               p_protectedUrlAttribute9      VARCHAR2,
                               p_protectedUrlAttribute10     VARCHAR2,
                               p_protectedDateAttribute1     DATE,
                               p_protectedDateAttribute2     DATE,
                               p_protectedDateAttribute3     DATE,
                               p_protectedDateAttribute4     DATE,
                               p_protectedDateAttribute5     DATE,
                               p_protectedDateAttribute6     DATE,
                               p_protectedDateAttribute7     DATE,
                               p_protectedDateAttribute8     DATE,
                               p_protectedDateAttribute9     DATE,
                               p_protectedDateAttribute10    DATE,
                               p_protectedNumberAttribute1   NUMBER,
                               p_protectedNumberAttribute2   NUMBER,
                               p_protectedNumberAttribute3   NUMBER,
                               p_protectedNumberAttribute4   NUMBER,
                               p_protectedNumberAttribute5   NUMBER,
                               p_protectedNumberAttribute6   NUMBER,
                               p_protectedNumberAttribute7   NUMBER,
                               p_protectedNumberAttribute8   NUMBER,
                               p_protectedNumberAttribute9   NUMBER,
                               p_protectedNumberAttribute10  NUMBER,
                               p_title                       VARCHAR2,
                               p_titleResourceKey            VARCHAR2,
                               p_identificationKey           VARCHAR2,
                               p_workflowDescriptorURI       VARCHAR2,
                               p_taskDefinitionId            VARCHAR2,
                               