CREATE OR REPLACE EDITIONING VIEW LDAPADAPTER_IN
 AS SELECT LAST_CHANGE_NUMBER, LAST_TIME_STAMP, LDAP_ENDPOINT_GUID FROM E$LDAPADAPTER_IN;

CREATE OR REPLACE EDITIONING VIEW FILEADAPTER_IN
 AS SELECT FULL_PATH, ROOT_DIRECTORY, FILE_DIRECTORY, FILE_NAME, FILE_ENDPOINT_GUID, FILE_LAST_MODIFIED, FILE_READONLY, FILE_PROCESSED, CREATED, UPDATED, TENANT_ID FROM E$FILEADAPTER_IN;

CREATE OR REPLACE EDITIONING VIEW FILEADAPTER_MUTEX
 AS SELECT MUTEX_ID, MUTEX_CREATED, MUTEX_LAST_UPDATED, MUTEX_SEQUENCE, TENANT_ID FROM E$FILEADAPTER_MUTEX;

CREATE OR REPLACE EDITIONING VIEW JCA_NATIVE_CORRELATION
 AS SELECT PROTOCOL_CORRELATION_ID, COMPOSITE_DN, SOURCE_URI, ECID, CONVERSATION_ID, CREATED_TIME, CORRELATED_TIME FROM E$JCA_NATIVE_CORRELATION;

CREATE OR REPLACE EDITIONING VIEW FILEADAPTER_TRANSACTION_LOG
 AS SELECT XID, SERVICE_NAME, JNDI, FILE_ACTION, TRANSACTION_STATE, FILE_ACTION_ARG1, FILE_ACTION_ARG2, CREATED, TENANT_ID FROM E$FILEADAPTER_TRANSACTION_LOG;

CREATE OR REPLACE EDITIONING VIEW MESSAGE_STATISTICS
 AS SELECT SNAPSHOT_ID, CREATION_TIME, BEGIN_INTERVAL_TIME, END_INTERVAL_TIME, MAX_MESSAGE_SIZE, MIN_MESSAGE_SIZE, NUM_OF_MESSAGES, TOTAL_MESSAGE_SIZE, AVERAGE_MESSAGE_SIZE, MANAGED_SERVER, COMPOSITE_DN, ENDPOINT_NAME FROM E$MESSAGE_STATISTICS;

CREATE OR REPLACE EDITIONING VIEW EIS_CONNECTION_DOWN_TIME
 AS SELECT SNAPSHOT_ID, CREATION_TIME, BEGIN_INTERVAL_TIME, END_INTERVAL_TIME, EIS_DOWNTIME_START, EIS_DOWNTIME_END, ERROR_SUMMARY, ERROR_STACK, MANAGED_SERVER, COMPOSITE_DN, ENDPOINT_NAME FROM E$EIS_CONNECTION_DOWN_TIME;

CREATE OR REPLACE EDITIONING VIEW AIA_ERROR_NOTIFICATIONS
 AS SELECT ERROR_NOTIFICATION_ID, ERROR_CODE, SYSTEM_ID, PROCESS_NAME, SERVICE_NAME, NOTIFICATION_ROLE, FYI_NOTIFICATION_ROLE, ERROR_TYPE, ERROR_EXT_HANDLER, AGGR_COUNT_CUR, AGGR_COUNT_TOT, ST_DATETIME, END_DATETIME FROM E$AIA_ERROR_NOTIFICATIONS;

CREATE OR REPLACE EDITIONING VIEW AIA_SYSTEMS
 AS SELECT SYSTEM_ID, SYSTEM_INTERNAL_ID, SYSTEM_CODE, SYSTEM_DESC, SYSTEM_IP_ADDR, SYSTEM_URL, SYSTEM_TYPE, APPLICATION_TYPE, APPLICATION_VERSION, CONTACT_NAME, CONTACT_PHONE, CONTACT_EMAIL FROM E$AIA_SYSTEMS;

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_AUDITS
 AS SELECT DEFINITION_ID, VERSION, AUDITED_ON, AUDITED_BY FROM E$CAVS_DEFINITION_AUDITS;

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_NSXPATHS
 AS SELECT DEFINITION_ID, NAMESPACE_ALIAS, NAMESPACE FROM E$CAVS_DEFINITION_NSXPATHS;

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_XPATHS
 AS SELECT DEFINITION_ID, XPATH_SEQ_ID, XPATH, IS_NODE_TEXT, IS_NODE_KEY, NODE_VALUE_KEY, CONDITION, NODE_VALUE_EXPECTED, IS_SYSTEM_GENERATED, NAMESPACE FROM E$CAVS_DEFINITION_XPATHS;

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITION_XREFS
 AS SELECT DEFINITION_ID_TEST, DEFINITION_ID_SIMULATOR FROM E$CAVS_DEFINITION_XREFS;

CREATE OR REPLACE EDITIONING VIEW CAVS_DEFINITIONS
 AS SELECT DEFINITION_ID, TYPE, DESCRIPTION, STATE, SERVICE_TYPE, URL_WSDL, URL_ENDPOINT, SOAP_ACTION, SOAP_TRANSPORT_TYPE, MESSAGE_REQUEST, MESSAGE_RESPONSE, DELAY, VERSION, PROJECT_NAME, PROJECT_VERSION, EBS_NAME, EBS_VERSION, PROCESS_NAME, PROCESS_VERSION, SERVICE_NAME, SERVICE_VERSION, MESSAGE_NAME, MESSAGE_VERSION, PIP_NAME, PIP_VERSION, APPLICATION_NAME, APPLICATION_VERSION, TEST_PRIORITY, REFERENCE_ID_EXTERNAL, AUDITED_ON, AUDITED_BY, REQ_CORR_ID_XPATH, RESP_CORR_ID_XPATH, SETUP_ID, IS_WSA_ENABLED FROM E$CAVS_DEFINITIONS;

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPDEFINITION_DEFINITIONS
 AS SELECT GROUP_DEFINITION_ID, SEQ_ID, DEFINITION_ID, DEFINITION_SEQ_ID FROM E$CAVS_GRPDEFINITION_DEFINITIO;

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPDEFINITIONS
 AS SELECT GROUP_DEFINITION_ID, DESCRIPTION, PROCESS_NAME, PIP_NAME FROM E$CAVS_GRPDEFINITIONS;

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPINSTANCE_INSTANCES
 AS SELECT GROUP_DEFINITION_ID, GROUP_INSTANCE_ID, INSTANCE_ID, ENDED_ON, DEFINITION_ID, DEFINITION_SEQ_ID FROM E$CAVS_GRPINSTANCE_INSTANCES;

CREATE OR REPLACE EDITIONING VIEW CAVS_GRPINSTANCES
 AS SELECT GROUP_DEFINITION_ID, GROUP_INSTANCE_ID, STARTED_ON, CREATED_BY, DESCRIPTION, PROCESS_NAME, PIP_NAME FROM E$CAVS_GRPINSTANCES;

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCE_NSXPATHS
 AS SELECT INSTANCE_ID, NAMESPACE_ALIAS, NAMESPACE FROM E$CAVS_INSTANCE_NSXPATHS;

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCE_XPATHS
 AS SELECT INSTANCE_ID, XPATH_SEQ_ID, STATUS, XPATH, IS_NODE_KEY, NODE_VALUE_KEY, CONDITION, NODE_VALUE_EXPECTED, NODE_VALUE_ACTUAL FROM E$CAVS_INSTANCE_XPATHS;

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCE_XREFS
 AS SELECT INSTANCE_ID_TEST, INSTANCE_ID_SIMULATOR FROM E$CAVS_INSTANCE_XREFS;

CREATE OR REPLACE EDITIONING VIEW CAVS_INSTANCES
 AS SELECT INSTANCE_ID, TYPE, STATUS, STARTED_ON, ENDED_ON, TEST_COMPLETED_ON, CREATED_BY, IS_STALED, GROUP_INSTANCE_ID, DEFINITION_ID, DESCRIPTION, SERVICE_TYPE, URL_WSDL, URL_REQUESTER, URL_ENDPOINT, SOAP_ACTION, SOAP_TRANSPORT_TYPE, WS_ADDRESSING, MESSAGE_REQUEST, MESSAGE_RESPONSE, DELAY, VERSION, PROJECT_NAME, PROJECT_VERSION, EBS_NAME, EBS_VERSION, PROCESS_NAME, PROCESS_VERSION, SERVICE_NAME, SERVICE_VERSION, MESSAGE_NAME, MESSAGE_VERSION, PIP_NAME, PIP_VERSION, APPLICATION_NAME, APPLICATION_VERSION, TEST_PRIORITY, REFERENCE_ID_EXTERNAL, REQ_CORR_ID_XPATH, RESP_CORR_ID_XPATH FROM E$CAVS_INSTANCES;

CREATE OR REPLACE EDITIONING VIEW CAVS_ROUTING_SETUP
 AS SELECT SETUP_ID, DESCRIPTION FROM E$CAVS_ROUTING_SETUP;

CREATE OR REPLACE EDITIONING VIEW CAVS_ROUTING_SETUP_DETAILS
 AS SELECT SETUP_DETAIL_ID, SETUP_ID, INVOKING_SERVICE_NAME, PARTNER_LINK, OPERATION, ROUTE_TO_CAVS, SIMULATOR_ID FROM E$CAVS_ROUTING_SETUP_DETAILS;

CREATE OR REPLACE EDITIONING VIEW CAVS_SCHEDULER
 AS SELECT SCHEDULER_ID, ID, TYPE, START_DATE, END_DATE, INSTANCE_ID, STATUS FROM E$CAVS_SCHEDULER;

CREATE OR REPLACE EDITIONING VIEW AIA_ERROR_FLEX_FIELD
 AS SELECT PARENT_OID, FLEX_KEY, VALUE FROM E$AIA_ERROR_FLEX_FIELD;

CREATE OR REPLACE EDITIONING VIEW AIA_ERROR_MONITOR
 AS SELECT OID, ECID, MESSAGE_ID, RESOURCE_TYPE, RESOURCE_NAME, REPORTED_DATE_TIME, ERROR_CODE, SYSTEM_CODE, PROCESS_NAME, SERVICE_NAME, COMPOSITE_VERSION, DRILL_DOWN_LINK, STACK_TRACE, COMPOSITE_INSTANCE_ID, ERROR_STAMPING, SERVICE_ENGINE, RESUBMITTED, MESSAGE_ORDER, STATUS_MSG, LAST_MODIFIED_DATE FROM E$AIA_ERROR_MONITOR;

CREATE OR REPLACE EDITIONING VIEW AM_APPLICATION
 AS SELECT APP_ID, API_KEY, NAME, CONSUMER_ACCOUNT, DESCRIPTION FROM E$AM_APPLICATION;

CREATE OR REPLACE EDITIONING VIEW AM_SUBSCRIPTION
 AS SELECT SCR_ID, API_ID, APP_ID, DESCRIPTION FROM E$AM_SUBSCRIPTION;

CREATE OR REPLACE EDITIONING VIEW AM_APIVISIBILITY
 AS SELECT API_ID, VISIBILITY FROM E$AM_APIVISIBILITY;

CREATE OR REPLACE EDITIONING VIEW AM_ID_GENERATOR
 AS SELECT ID_COL_NAME, ID_COL_VAL FROM E$AM_ID_GENERATOR;

CREATE OR REPLACE EDITIONING VIEW B2B_STREAMSTORE
 AS SELECT DOCUMENTID, CONTENT FROM E$B2B_STREAMSTORE;

CREATE OR REPLACE EDITIONING VIEW B2B_DATA_STORAGE
 AS SELECT VALUE_SELECTOR, CLOB_VALUE, BLOB_VALUE, DATA_SIZE, ATTRIBUTE1, ATTRIBUTE2, LABEL, DOCUMENT_ID, JOB_ID, ID, CPST_INST_CREATED_TIME, IS_OBFUSCATED FROM E$B2B_DATA_STORAGE;

CREATE OR REPLACE EDITIONING VIEW B2B_APP_MESSAGE
 AS SELECT ID, SENDER_ID_TYPE, SENDER_ID_VALUE, RECEIVER_ID_TYPE, RECEIVER_ID_VALUE, DOC_TYPE, DOCUMENT_DEFINITION, DOC_PROTOCOL_NAME, DOC_PROTOCOL_VERSION, APP_MESSAGE_ID, REF_TO_APP_MESSAGE_ID, APP_CONV_ID, APP_MESSAGE_PROPS, ACTION_NAME, DIRECTION, STATE, MESSAGE_TYPE, ERROR_CODE, ERROR_TEXT, ERROR_DESCRIPTION, ERROR_TEXT_CLOB, ERROR_DESCRIPTION_CLOB, CREATED, MODIFIED, PAYLOAD_NAME, MSG_SIZE, LABEL, URL, PAYLOAD, BUSINESS_MESSAGE, DOCUMENT_ID, RETRY_INTERVAL, REATTEMPT_COUNT, REMAINING_RETRY, RESUBMIT_COUNT, FABRIC_APPLICATION_NAME, FABRIC_COMPOSITE_VERSION, FABRIC_COMPOSITE_NAME, FABRIC_SERVICE_NAME, FABRIC_REFERENCE_NAME, FABRIC_ECID, FABRIC_COMPOSITE_INSTANCE_ID, FABRIC_PRT_COMPOSITE_INST_ID, FABRIC_CONVERSATION_ID, FABRIC_LABEL, FABRIC_COMPOSITEDN, ATTACHMENT_STORAGE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, JOB_ID, CPST_INST_CREATED_TIME, LAST_RESUBMITTED_USER_NAME, LAST_RESUBMITTED_TIME_STAMP, LAST_VIEWED_USER_NAME, LAST_VIEWED_TIME_STAMP, INTERNAL_ENDPOINT_NAME, MESSAGE_MODE, TRANSFORM_PAYLOAD, MESSAGE_STATUS, RESUBMIT_REF_TO FROM E$B2B_APP_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW B2B_AUDIT_TEMP
 AS SELECT AUDIT_ID, MESSAGE_ID FROM E$B2B_AUDIT_TEMP;

CREATE OR REPLACE EDITIONING VIEW B2B_BATCH_EVENT
 AS SELECT ID, EXPIRE_TIME, INTERVAL, TO_TP_NAME, DOC_TYPE, DOC_TYPE_REV, MSG_COUNT, STATE, ENABLE, BATCH_NAME, START_DATE, END_DATE, BATCH_TIME_STAMP, SCHEDULE, REPEAT_TYPE, REPEAT_ON_DAY, REPEAT_EVERY, CRITERIA1, CRITERIA2, CRITERIA3, CRITERIA4, CRITERIA5, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, SCHEDULE_TYPE, CHANNEL_NAME FROM E$B2B_BATCH_EVENT;

CREATE OR REPLACE EDITIONING VIEW B2B_BUSINESS_MESSAGE
 AS SELECT MESSAGE_ID, REFER_TO_MESSAGE_ID, SENDER_ID_TYPE, SENDER_ID_VALUE, RECEIVER_ID_TYPE, RECEIVER_ID_VALUE, SENDER_NAME, RECEIVER_NAME, TPA_ID, TPA_NAME, DOCTYPE_NAME, DOC_PROTOCOL_NAME, DOC_PROTOCOL_VERSION, DOCUMENT_DEFINITION, MESSAGE_TYPE, DIRECTION, STATE, ACK_MODE, ACK_TYPE, TIME_TO_ACK, RESPONSE_MODE, CONTENT_TYPE, PAYLOAD_NAME, CREATED, MODIFIED, SEND_TIMESTAMP, RECEIVE_TIMESTAMP, DOC_RETRY_INTERVAL, DOC_ATTEMPT_COUNT, DOC_REMAINING_RETRY, NATIVE_MSG_SIZE, TRANSLATED_MSG_SIZE, BATCH_ID, XPATH_NAME1, XPATH_VALUE1, XPATH_EXPRESSION1, XPATH_NAME2, XPATH_VALUE2, XPATH_EXPRESSION2, XPATH_NAME3, XPATH_VALUE3, XPATH_EXPRESSION3, CORRELATION_FROM_XPATH_NAME, CORRELATION_FROM_XPATH_XPR, CORRELATION_FROM_XPATH_VALUE, CORRELATION_TO_XPATH_NAME, CORRELATION_TO_XPATH_XPR, CORRELATION_TO_XPATH_VALUE, RESUBMIT_COUNT, EXT_BUSINESS_MESSAGE, WIRE_MESSAGE, PAYLOAD_STORAGE, ATTACHMENT_STORAGE, NATIVE_DATA_STORAGE, TRANSLATED_DATA_STORAGE, APP_MESSAGE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, LABEL, JOB_ID, ID, CPST_INST_CREATED_TIME, LAST_RESUBMITTED_USER_NAME, LAST_RESUBMITTED_TIME_STAMP, LAST_VIEWED_USER_NAME, LAST_VIEWED_TIME_STAMP, CHANNEL_NAME, USER_COMMENT, ORIGINAL_STATE, MESSAGE_STATUS, RESUBMIT_REF_TO, DOC_EVENT FROM E$B2B_BUSINESS_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW B2B_BUSINESS_MESSAGE_RETRY
 AS SELECT MESSAGE_ID, SCHEDULE_DUE_TS, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3 FROM E$B2B_BUSINESS_MESSAGE_RETRY;

CREATE OR REPLACE EDITIONING VIEW B2B_CONTROL_NUMBER
 AS SELECT SENDER_NAME, RECEIVER_NAME, DOC_PROTOCOL_NAME, DIRECTION, INTERCHANGE, GROUP_NUM, TRANSACTION_NUM, START_INTERCHANGE, START_GROUP_NUM, START_TRANSACTION_NUM, MAX_INTERCHANGE, MAX_GROUP_NUM, MAX_TRANSACTION_NUM, SCHEDULE, SCHEDULE_ID, NAME, IS_DEFAULT, ATTRIBUTE1, ATTRIBUTE2, ID FROM E$B2B_CONTROL_NUMBER;

CREATE OR REPLACE EDITIONING VIEW B2B_CONTROL_NUMBER_SET
 AS SELECT ID, NAME, PROTOCOL, TRADINGPARTNER, DIRECTION, TYPE1, CONTROL_NUMBER1, TYPE2, CONTROL_NUMBER2, TYPE3, CONTROL_NUMBER3, IS_DEFAULT, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5 FROM E$B2B_CONTROL_NUMBER_SET;

CREATE OR REPLACE EDITIONING VIEW B2B_CTL_NUMBER
 AS SELECT ID, MIN, MAX, INCR, START_VAL, SEQ_ID, VALUE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5 FROM E$B2B_CTL_NUMBER;

CREATE OR REPLACE EDITIONING VIEW B2B_EXT_BUSINESS_MESSAGE
 AS SELECT PROTOCOL_WORK_AREA, COLLABORATION_NAME, COLLABORATION_VERSION, BUSINESS_TRANSACTION_NAME, BUSINESS_TRANSACTION_VERSION, BUSINESS_ACTION_NAME, COLLABORATION_ID, BUSINESS_TRANSACTION_ID, TO_ROLE, FROM_ROLE, COLLABORATION_STATE, EXCHANGE_PROTOCOL_NAME, EXCHANGE_PROTOCOL_VERSION, INTERCHANGE_CONTROL_NUMBER, GROUP_CONTROL_NUMBER, TXNSET_CONTROL_NUMBER, ERROR_SEVERITY, ERROR_LEVEL, ERROR_CODE, ERROR_TEXT, ERROR_TEXT_CLOB, ERROR_DESCRIPTION, ERROR_DESCRIPTION_CLOB, ERROR_DETAIL, ERROR_DETAIL_CLOB, PROCESSING_TIME, DELIVERED_ENDPOINT, ATTRIBUTE1, ATTRIBUTE2, LABEL, SEQUENCE_TARGET, QUEUE_TIME, BUSINESS_MESSAGE, JOB_ID, ID, CPST_INST_CREATED_TIME, INTERCHANGE_SENDER_ID, INTERCHANGE_RECEIVER_ID, INBOUND_MESSAGE_ID, WIRE_CORRELATION_ID, CORRELATION_FLOW_ID FROM E$B2B_EXT_BUSINESS_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW B2B_HA_REGISTRY
 AS SELECT INSTANCE, LASTUPDATE FROM E$B2B_HA_REGISTRY;

CREATE OR REPLACE EDITIONING VIEW B2B_LIFECYCLE
 AS SELECT ID, TPA_NAME, SENDER_NAME, RECEIVER_NAME, DOCTYPE_NAME, DOC_PROTOCOL_VERSION, STATE, LABEL, LABEL_DESC, CREATED, MODIFIED, USER_NAME, DOC_PROTOCOL_NAME, DOC_DEF_NAME, DEFINITION_MO, DOC_REF_NAME, DOC_ROUTING_ID, BUSINESS_ACTION_NAME, SERVICE_NAME, SERVICE_TYPE, FROM_DC, TO_DC, CONTROL_NUMBER_SET, DOC_DEF_TIMESTAMP, DIRECTION, TPA_REFERENCE, IS_CUSTOM, APPS_DOCUMENT, APPS_ACTION, APPS_XSLTFILE, AGREEMENT_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, ATTRIBUTE6, ATTRIBUTE7, ATTRIBUTE8, ATTRIBUTE9, ATTRIBUTE10, APPS_DOCTYPE_NAME, APPS_DOC_PROTOCOL_NAME, APPS_DOC_PROTOCOL_VERSION, CREATED_BY_UI, EXCHANGE_PROTOCOL_NAME, WS_SERVICE_NAME, WS_PORT_NAME, WS_ASSEMBLY_MO FROM E$B2B_LIFECYCLE;

CREATE OR REPLACE EDITIONING VIEW B2B_LOCK_REGISTRY
 AS SELECT INSTANCE, DIRECTION, TARGET, LASTUPDATE FROM E$B2B_LOCK_REGISTRY;

CREATE OR REPLACE EDITIONING VIEW B2B_PARAMETER
 AS SELECT NAME, DATE_VALUE, TIME_VALUE, STRING_VALUE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3 FROM E$B2B_PARAMETER;

CREATE OR REPLACE EDITIONING VIEW B2B_PENDING_MESSAGE
 AS SELECT MESSAGE_ID, CREATED, MODIFIED, RECEIVER_NAME, DOCTYPE_NAME, DOC_PROTOCOL_VERSION, MSG_SIZE, STATE, BATCH_NAME, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5 FROM E$B2B_PENDING_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW B2B_PURGE_TEMP_AM
 AS SELECT AM_ID, AM_PAYLOAD, AM_ATTACHMENT_STORAGE, STRIPECOL FROM E$B2B_PURGE_TEMP_AM;

CREATE OR REPLACE EDITIONING VIEW B2B_PURGE_TEMP_BM
 AS SELECT BM_ID, BM_MESSAGE_ID, BM_PAYLOAD_STORAGE, BM_ATTACHMENT_STORAGE, BM_NATIVE_DATA_STORAGE, BM_TRANSLATED_DATA_STORAGE, WM_PACKED_MESSAGE, WM_PAYLOAD_STORAGE, AM_PAYLOAD, AM_ATTACHMENT_STORAGE, EXT_BM_ID, AM_ID, WM_ID, STRIPECOL FROM E$B2B_PURGE_TEMP_BM;

CREATE OR REPLACE EDITIONING VIEW B2B_PURGE_TEMP_WM
 AS SELECT WM_ID, WM_PAYLOAD_STORAGE, WM_PACKED_MESSAGE, STRIPECOL FROM E$B2B_PURGE_TEMP_WM;

CREATE OR REPLACE EDITIONING VIEW B2B_SEQUENCE_MANAGER
 AS SELECT ID, MESSAGE_ID, APP_MESSAGE_ID, WIRE_MESSAGE_ID, SEQUENCE_TARGET, DELIVERY_CHANNEL, TIME_STAMP, RETRY_INTERVAL, NEXT_TIME_STAMP, STATE, DIRECTION, PROTOCOL, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, MODIFIED, ATTRIBUTE5, PARAMETERS, E2E_SRC_SEQUENCE_ID, E2E_SRC_TARGET, E2E_GROUP_COUNT FROM E$B2B_SEQUENCE_MANAGER;

CREATE OR REPLACE EDITIONING VIEW B2B_TRANSPORT_MANAGER
 AS SELECT INSTANCE_NAME, ENDPOINT, UPDATE_TIME, STATS, ATTRIBUTE1, ATTRIBUTE2 FROM E$B2B_TRANSPORT_MANAGER;

CREATE OR REPLACE EDITIONING VIEW B2B_WIRE_MESSAGE
 AS SELECT MESSAGE_ID, PACKED_MESSAGE, PAYLOAD_STORAGE, PROTOCOL_MESSAGE_ID, REFER_TO_PROTOCOL_MESSAGE_ID, PROTOCOL_COLLABORATION_ID, PROTOCOL_TRANSPORT_BINDING, MESSAGE_DIGEST, DIGEST_ALGORITHM, TRANSPORT_PROTOCOL, TRANSPORT_PROTOCOL_VERSION, TRANSPORT_CORRELATION_ID, VERSION, URL, DIRECTION, TRANS_SECURITY_PROTOCOL, TRANS_SECURITY_PROT_VERSION, TRANSPORT_HEADERS, TRANSPORT_CERTIFICATES, TRANSPORT_CERTIFICATES_CLOB, STATE, ERROR_CODE, ERROR_TEXT, ERROR_DESCRIPTION, ERROR_TEXT_CLOB, ERROR_DESCRIPTION_CLOB, CREATED, MODIFIED, ACKNOWLEDGEMENT_MODE, EXCHANGE_RETRY_INTERVAL, EXCHANGE_ATTEMPT_COUNT, EXCHANGE_REMAINING_RETRY, RESUBMIT_COUNT, MSG_SIZE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, ATTRIBUTE5, HOST_NAME, PORT, USER_NAME, PASSWORD, FROM_ADDRESS, TO_ADDRESS, DELIVERED_ENDPOINT, LABEL, JOB_ID, SIGNING_PROTOCOL, SIGNING_ALGORITHM, SIGNING_CERTIFICATE, ENCRYPTION_PROTOCOL, ENCRYPTION_ALGORITHM, ENCRYPTION_CERTIFICATE, ID, CPST_INST_CREATED_TIME, LAST_RESUBMITTED_USER_NAME, LAST_RESUBMITTED_TIME_STAMP, LAST_VIEWED_USER_NAME, LAST_VIEWED_TIME_STAMP, CHANNEL_NAME, MESSAGE_STATUS, RESUBMIT_REF_TO FROM E$B2B_WIRE_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW BEAM_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BEAM_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BEAM_PROPERTY
 AS SELECT BEAM_OPTLOCK, PROPERTY_NAME, PROPERTY_VALUE FROM E$BEAM_PROPERTY;

CREATE OR REPLACE EDITIONING VIEW BEAM_TRANSACTION_CONTEXT
 AS SELECT TRANSACTION_CID, TRANSACTION_TID FROM E$BEAM_TRANSACTION_CONTEXT;

CREATE OR REPLACE EDITIONING VIEW BEAM_FLEXTABLE
 AS SELECT BEAM_OPTLOCK, BEAM_ID, FLEXTABLE_TOTAL_STRINGS, FLEXTABLE_TOTAL_LONGSTRINGS, FLEXTABLE_TOTAL_INTEGERS, FLEXTABLE_TOTAL_DECIMALS, FLEXTABLE_TOTAL_FLOATS, FLEXTABLE_TOTAL_DATES FROM E$BEAM_FLEXTABLE;

CREATE OR REPLACE EDITIONING VIEW BEAM_DATAOBJECT
 AS SELECT BEAM_OPTLOCK, BEAM_ID, DATAOBJECT_HIERARCHY, DATAOBJECT_NAME, DATAOBJECT_FLEXTABLE, DATAOBJECT_PARENT, DATAOBJECT_TYPE FROM E$BEAM_DATAOBJECT;

CREATE OR REPLACE EDITIONING VIEW BEAM_NAMEMAPPING
 AS SELECT BEAM_OPTLOCK, BEAM_ID, NAMEMAPPING_NAME FROM E$BEAM_NAMEMAPPING;

CREATE OR REPLACE EDITIONING VIEW BEAM_COLUMN
 AS SELECT BEAM_OPTLOCK, BEAM_ID, COLUMN_DTYPE, COLUMN_DATAOBJECT, COLUMN_NAME, COLUMN_LENGTH, COLUMN_PRECISION, COLUMN_SCALE, COLUMN_DEFAULT, COLUMN_CAPTION, COLUMN_ALLOWS_NULL, COLUMN_IS_UNIQUE, COLUMN_FLEXTABLE, COLUMN_FLEXCOLUMN_NUMBER FROM E$BEAM_COLUMN;

CREATE OR REPLACE EDITIONING VIEW BEAM_ALERT_RULE
 AS SELECT BEAM_OPTLOCK, BEAM_ID, RULE_NAME, RULE_OWNER_ID, RULE_CREATED, RULE_LAST_MODIFIED, RULE_MODIFIED_BY, RULE_RECIPIENT_ID, RULE_REPORT_ID, RULE_ACTIVE, RULE_TEMPLATE, RULE_PACKAGE_ID, RULE_LAST_FIRED, RULE_STALE, RULE_ORPHAN FROM E$BEAM_ALERT_RULE;

CREATE OR REPLACE EDITIONING VIEW BEAM_ALERT_ESCALATION
 AS SELECT BEAM_OPTLOCK, BEAM_ID, ESCALATION_NAME, ESCALATION_OWNER_ID, ESCALATION_CREATED, ESCALATION_LAST_MODIFIED, ESCALATION_MODIFIED_BY, ESCALATION_REPORT_ID, ESCALATION_USER_ID, ESCALATION_RULE_OWNER_ID, ESCALATION_START_TIME, ESCALATION_END_TIME, ESCALATION_ACTION, ESCALATION_MESSAGE FROM E$BEAM_ALERT_ESCALATION;

CREATE OR REPLACE EDITIONING VIEW AUDIT_COUNTER
 AS SELECT CIKEY, LAST_COUNT_ID, LAST_EVENT_ID, LAST_DETAIL_ID, CI_PARTITION_DATE FROM E$AUDIT_COUNTER;

CREATE OR REPLACE EDITIONING VIEW AUDIT_DETAILS
 AS SELECT CIKEY, DETAIL_ID, BIN_CSIZE, BIN_USIZE, DOC_REF, BIN, CI_PARTITION_DATE, FLOW_ID, SCA_PARTITION_ID FROM E$AUDIT_DETAILS;

CREATE OR REPLACE EDITIONING VIEW AUDIT_TRAIL
 AS SELECT CIKEY, COUNT_ID, BLOCK, BLOCK_CSIZE, BLOCK_USIZE, LOG, CI_PARTITION_DATE, NUM_OF_EVENTS, FLOW_ID, SCA_PARTITION_ID, SERIALIZER_ID FROM E$AUDIT_TRAIL;

CREATE OR REPLACE EDITIONING VIEW CI_INDEXES
 AS SELECT CIKEY, INDEX_1, INDEX_2, INDEX_3, INDEX_4, INDEX_5, INDEX_6, CI_PARTITION_DATE FROM E$CI_INDEXES;

CREATE OR REPLACE EDITIONING VIEW CLUSTER_MASTER
 AS SELECT NODE_ID, DUMMY_COL, COMPONENTTYPE FROM E$CLUSTER_MASTER;

CREATE OR REPLACE EDITIONING VIEW CLUSTER_NODE
 AS SELECT NODE_ID, IP_ADDRESS, LAST_UPDATE FROM E$CLUSTER_NODE;

CREATE OR REPLACE EDITIONING VIEW CUBE_INSTANCE
 AS SELECT CIKEY, CREATION_DATE, CREATOR, MODIFY_DATE, MODIFIER, STATE, PRIORITY, TITLE, STATUS, STAGE, CONVERSATION_ID, ROOT_ID, PARENT_ID, SCOPE_REVISION, SCOPE_CSIZE, SCOPE_USIZE, PROCESS_TYPE, METADATA, EXT_STRING1, EXT_STRING2, EXT_INT1, TEST_RUN_ID, TEST_RUN_NAME, TEST_CASE, TEST_SUITE, ECID, CMPST_ID, OUTCOME, TRACKING_LEVEL, AT_COUNT_ID, AT_EVENT_ID, AT_DETAIL_ID, VERSION, AG_ROOT_ID, AG_MILESTONE_PATH, CACHE_VERSION, PARENT_REF_ID, COMPONENTTYPE, NOTM, COMPOSITE_NAME, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, CREATE_CLUSTER_NODE_ID, LAST_CLUSTER_NODE_ID, CPST_INST_CREATED_TIME, TENANT_ID, FLOW_ID, SCA_PARTITION_ID FROM E$CUBE_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW CUBE_SCOPE
 AS SELECT CIKEY, BINARY_FORMAT, MODIFY_DATE, SCOPE_BIN, CI_PARTITION_DATE FROM E$CUBE_SCOPE;

CREATE OR REPLACE EDITIONING VIEW DLV_MESSAGE
 AS SELECT CONV_ID, CONV_TYPE, MESSAGE_GUID, PARTNER_LINK, OPERATION_NAME, EVENT_NAME, RECEIVE_DATE, EXPIRY_DATE, STATE, RES_SUBSCRIBER, EXT_STRING1, EXT_STRING2, EXT_INT1, DLV_TYPE, MASTER_CONV_ID, PRIORITY, COMPOSITE_NAME, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, COMPONENT_TYPE, CIKEY, RECOVER_COUNT, HEADER_PROPERTIES_BIN_FORMAT, ECID, CLUSTER_NODE_ID, CLUSTER_NODE_KEY, TENANT_ID, CACHE_VERSION, PROPERTIES, HEADERS_REF_ID, FLOW_ID, SCA_PARTITION_ID FROM E$DLV_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW DLV_SUBSCRIPTION
 AS SELECT CONV_ID, CONV_TYPE, CIKEY, PARTNER_LINK, PROCESS_GUID, OPERATION_NAME, EVENT_NAME, SUBSCRIBER_ID, SERVICE_NAME, SUBSCRIPTION_DATE, STATE, PROPERTIES, EXT_STRING1, EXT_STRING2, EXT_INT1, VERSION, CACHE_VERSION, COMPOSITE_NAME, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, CI_PARTITION_DATE FROM E$DLV_SUBSCRIPTION;

CREATE OR REPLACE EDITIONING VIEW DOCUMENT_CI_REF
 AS SELECT CIKEY, DOCUMENT_ID, DOCUMENT_TYPE, CI_PARTITION_DATE FROM E$DOCUMENT_CI_REF;

CREATE OR REPLACE EDITIONING VIEW DOCUMENT_DLV_MSG_REF
 AS SELECT MESSAGE_GUID, DOCUMENT_ID, PART_NAME, DOCUMENT_TYPE, DLV_PARTITION_DATE FROM E$DOCUMENT_DLV_MSG_REF;

CREATE OR REPLACE EDITIONING VIEW HEADERS_PROPERTIES
 AS SELECT MESSAGE_GUID, COUNT_ID, BIN_CSIZE, BIN_USIZE, BIN, MODIFY_DATE, DLV_PARTITION_DATE FROM E$HEADERS_PROPERTIES;

CREATE OR REPLACE EDITIONING VIEW DLV_AGGREGATION
 AS SELECT CONV_ID, DOMAIN_NAME, COMPONENT_NAME, COMPOSITE_NAME, COMPOSITE_LABEL, COMPOSITE_REVISION, COMPONENT_TYPE, STATE, RECEIVE_DATE, CIKEY FROM E$DLV_AGGREGATION;

CREATE OR REPLACE EDITIONING VIEW ID_RANGE
 AS SELECT RANGE_NAME, NEXT_RANGE, DUMMY_COL FROM E$ID_RANGE;

CREATE OR REPLACE EDITIONING VIEW LOAN_CUSTOMER
 AS SELECT SSN, NAME, EMAIL, PROVIDER, STATUS FROM E$LOAN_CUSTOMER;

CREATE OR REPLACE EDITIONING VIEW NATIVE_CORRELATION
 AS SELECT NATIVE_CORRELATION_ID, CONVERSATION_ID FROM E$NATIVE_CORRELATION;

CREATE OR REPLACE EDITIONING VIEW TEST_DEFINITIONS
 AS SELECT TEST_SUITE, LOCATION, TYPE, CREATION_DATE, DEFINITION FROM E$TEST_DEFINITIONS;

CREATE OR REPLACE EDITIONING VIEW TEST_DETAILS
 AS SELECT CIKEY, TEST_SUITE, TEST_LOCATION, TEST_RUN_NAME, TEST_RUN_ID, TEST_STATUS, TEST_RESULT FROM E$TEST_DETAILS;

CREATE OR REPLACE EDITIONING VIEW UPGRADE_INFO
 AS SELECT LAST_COMPLETED_DATE FROM E$UPGRADE_INFO;

CREATE OR REPLACE EDITIONING VIEW VERSION
 AS SELECT GUID, DBTYPE, DBPROFILE, SOA_UPGRADE_DATE FROM E$VERSION;

CREATE OR REPLACE EDITIONING VIEW WI_FAULT
 AS SELECT CIKEY, NODE_ID, SCOPE_ID, COUNT_ID, FAULT_NAME, FAULT_TYPE, POLICY_NAME, POLICY_VERSION, POLICY_CATEGORY, POLICY_ECID, CREATION_DATE, MODIFY_DATE, MESSAGE, CI_PARTITION_DATE FROM E$WI_FAULT;

CREATE OR REPLACE EDITIONING VIEW WORK_ITEM
 AS SELECT CIKEY, NODE_ID, SCOPE_ID, COUNT_ID, CREATION_DATE, CREATOR, MODIFY_DATE, MODIFIER, STATE, TRANSITION, EXCEPTION, EXP_DATE, EXP_FLAG, PRIORITY, LABEL, CUSTOM_ID, COMMENTS, REFERENCE_ID, IDEMPOTENT_FLAG, EXECUTION_TYPE, FIRST_DELAY, DELAY, EXT_STRING1, EXT_STRING2, EXT_INT1, CLUSTER_NODE_ID, VERSION, CI_PARTITION_DATE, CLUSTER_NODE_KEY FROM E$WORK_ITEM;

CREATE OR REPLACE EDITIONING VIEW CUBE_PROCESS_BREAKPOINT
 AS SELECT COMPONENT_DN, ELEMENT_ID, CONDITION FROM E$CUBE_PROCESS_BREAKPOINT;

CREATE OR REPLACE EDITIONING VIEW BPEL_CONVERSATION_SUBSCRIPTION
 AS SELECT KEY, SUBSCRIBER_ID, CI_PARTITION_DATE FROM E$BPEL_CONVERSATION_SUBSCRIPTI;

CREATE OR REPLACE EDITIONING VIEW soaqtz_BLOB_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA FROM E$soaqtz_BLOB_TRIGGERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_CALENDARS
 AS SELECT SCHED_NAME, CALENDAR_NAME, CALENDAR FROM E$soaqtz_CALENDARS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_CRON_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID FROM E$soaqtz_CRON_TRIGGERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_FIRED_TRIGGERS
 AS SELECT SCHED_NAME, ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, PRIORITY, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, IS_NONCONCURRENT, REQUESTS_RECOVERY, SCHED_TIME FROM E$soaqtz_FIRED_TRIGGERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_JOB_DETAILS
 AS SELECT SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA FROM E$soaqtz_JOB_DETAILS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_JOB_LISTENERS
 AS SELECT JOB_NAME, JOB_GROUP, JOB_LISTENER FROM E$soaqtz_JOB_LISTENERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_LOCKS
 AS SELECT SCHED_NAME, LOCK_NAME FROM E$soaqtz_LOCKS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_PAUSED_TRIGGER_GRPS
 AS SELECT SCHED_NAME, TRIGGER_GROUP FROM E$soaqtz_PAUSED_TRIGGER_GRPS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_SCHEDULER_STATE
 AS SELECT SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL FROM E$soaqtz_SCHEDULER_STATE;

CREATE OR REPLACE EDITIONING VIEW soaqtz_SIMPLE_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED FROM E$soaqtz_SIMPLE_TRIGGERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_TRIGGER_LISTENERS
 AS SELECT TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER FROM E$soaqtz_TRIGGER_LISTENERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_TRIGGERS
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA FROM E$soaqtz_TRIGGERS;

CREATE OR REPLACE EDITIONING VIEW soaqtz_simprop_triggers
 AS SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, STR_PROP_1, STR_PROP_2, STR_PROP_3, INT_PROP_1, INT_PROP_2, LONG_PROP_1, LONG_PROP_2, DEC_PROP_1, DEC_PROP_2, BOOL_PROP_1, BOOL_PROP_2 FROM E$soaqtz_simprop_triggers;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_OBJECT
 AS SELECT ID, CASE_ID, OBJECT_TYPE, OBJECT_NAME, OBJECT_DISPLAY_NAME, UPDATED_BY, UPDATED_BY_DISPLAY_NAME, UPDATED_DATE, PERMISSION_TAG, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, SYSTEM_ATTR_STRING_01, SYSTEM_ATTR_STRING_02, SYSTEM_ATTR_STRING_03, SYSTEM_ATTR_NUMBER_01, SYSTEM_ATTR_NUMBER_02, SYSTEM_ATTR_BOOLEAN_01, SYSTEM_ATTR_BOOLEAN_02 FROM E$CM_CASE_OBJECT;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DOCUMENT
 AS SELECT ID, FOLDER, DOC_SIZE, DOC_VERSION, DOC_COMMENT, DOC_CONTENT, DOC_CONTENT_TYPE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_CASE_DOCUMENT;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_EVENT
 AS SELECT ID, EVENT_TYPE, ACTIVITY_NAME, ACTIVITY_TYPE, ACTIVITY_ID, ACTIVITY_EVENT, STARTED_DATE, COMPLETED_DATE, LIFECYCLE_STATE, LIFECYCLE_EVENT, DOCUMENT_NAME, DOCUMENT_VERSION, DOCUMENT_ID, DOCUMENT_EVENT, MILESTONE, MILESTONE_EVENT, USER_DEFINED_EVENT, DATA_NAME, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, EVENT_SUB_TYPE, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4, FORGET FROM E$CM_CASE_EVENT;

CREATE OR REPLACE EDITIONING VIEW CM_PROPERTY_BAG
 AS SELECT ID, NAME, VALUE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_PROPERTY_BAG;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DEFINITION
 AS SELECT DEFINITION_ID, NAME, TITLE, DESCRIPTION, CATEGORY, NAMESPACE, COMPONENT_NAME, COMPOSITE_DN, COMPOSITE_NAME, COMPOSITE_VERSION, APPLICATION_NAME FROM E$CM_CASE_DEFINITION;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_MILESTONE_DEFINITION
 AS SELECT CASE_DEFINITION_ID, MILESTONE_ID, MILESTONE_NAME FROM E$CM_CASE_MILESTONE_DEFINITION;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_DEFINITION
 AS SELECT DEFINITION_ID, TYPE, NAME, TITLE, DESCRIPTION, NAMESPACE, COMPONENT_NAME, COMPOSITE_DN, COMPOSITE_NAME, COMPOSITE_VERSION, APPLICATION_NAME, PAYLOAD, CLASS_NAME, IS_CUSTOM, IS_GLOBAL, IS_MANUAL, IS_CONDITIONAL, IS_CASE_SPECIFIC, IS_REQUIRED, IS_REPEATABLE, PRODUCT_VERSION, PERMISSION_TAG, TOTAL_RATING, NUMBER_OF_RATINGS, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, DISPLAY_NAME, MILESTONE_NAME FROM E$CM_ACTIVITY_DEFINITION;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_CASE_DEFINITION
 AS SELECT ACTIVITY_DEFINITION_ID, CASE_DEFINITION_ID FROM E$CM_ACTIVITY_CASE_DEFINITION;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_CATEGORY_DEFN
 AS SELECT ACTIVITY_DEFINITION_ID, CATEGORY FROM E$CM_ACTIVITY_CATEGORY_DEFN;

CREATE OR REPLACE EDITIONING VIEW CM_TRANSLATION
 AS SELECT CASE_ID, LOCALE, TITLE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, SHORT_SUMMARY, LONG_SUMMARY FROM E$CM_TRANSLATION;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_INSTANCE
 AS SELECT ACTIVITY_DEFINITION_ID, CASE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_ACTIVITY_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW CM_CASE
 AS SELECT CASE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_CASE;

CREATE OR REPLACE EDITIONING VIEW CM_FABRIC_HEADER_PROPERTY
 AS SELECT CASE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, PROPERTIES, COMPOSITE_CREATED_TIME FROM E$CM_FABRIC_HEADER_PROPERTY;

CREATE OR REPLACE EDITIONING VIEW CM_LINKED_CASE
 AS SELECT CASE_ID, RELATIONSHIP, LINKED_CASE_ID, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, ID, CASE_NUMBER, CASE_TITLE, RELATIONSHIP_DISPLAY_NAME, LINKED_CASE_NUMBER, LINKED_CASE_TITLE FROM E$CM_LINKED_CASE;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DATA
 AS SELECT ID, DATA, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_EXTERNAL FROM E$CM_CASE_DATA;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_FLEX_FIELD
 AS SELECT CASE_ID, textAttribute1, textAttribute2, textAttribute3, textAttribute4, textAttribute5, textAttribute6, textAttribute7, textAttribute8, textAttribute9, textAttribute10, textAttribute11, textAttribute12, textAttribute13, textAttribute14, textAttribute15, textAttribute16, textAttribute17, textAttribute18, textAttribute19, textAttribute20, numberAttribute1, numberAttribute2, numberAttribute3, numberAttribute4, numberAttribute5, numberAttribute6, numberAttribute7, numberAttribute8, numberAttribute9, numberAttribute10, dateAttribute1, dateAttribute2, dateAttribute3, dateAttribute4, dateAttribute5, dateAttribute6, dateAttribute7, dateAttribute8, dateAttribute9, dateAttribute10, protectedTextAttribute1, protectedTextAttribute2, protectedTextAttribute3, protectedTextAttribute4, protectedTextAttribute5, protectedTextAttribute6, protectedTextAttribute7, protectedTextAttribute8, protectedTextAttribute9, protectedTextAttribute10, protectedTextAttribute11, protectedTextAttribute12, protectedTextAttribute13, protectedTextAttribute14, protectedTextAttribute15, protectedTextAttribute16, protectedTextAttribute17, protectedTextAttribute18, protectedTextAttribute19, protectedTextAttribute20, protectedNumberAttribute1, protectedNumberAttribute2, protectedNumberAttribute3, protectedNumberAttribute4, protectedNumberAttribute5, protectedNumberAttribute6, protectedNumberAttribute7, protectedNumberAttribute8, protectedNumberAttribute9, protectedNumberAttribute10, protectedDateAttribute1, protectedDateAttribute2, protectedDateAttribute3, protectedDateAttribute4, protectedDateAttribute5, protectedDateAttribute6, protectedDateAttribute7, protectedDateAttribute8, protectedDateAttribute9, protectedDateAttribute10, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_CASE_FLEX_FIELD;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_HEADER
 AS SELECT ID, CASE_NUMBER, TITLE, SHORT_SUMMARY, LONG_SUMMARY, PRIORITY, IDENTIFICATION_KEY, CATEGORY, CATEGORY_DISPLAY_NAME, CREATED_BY, CREATED_BY_DISPLAY_NAME, STATE, STATE_DISPLAY_NAME, OUTCOME, OUTCOME_DISPLAY_NAME, CREATED_DATE, EXPIRATION_DATE, END_DATE, DUE_DATE, CASE_NAMESPACE, CASE_DEFINITION_ID, CASE_DEFINITION_NAME, TENANT_ID, ECM_FOLDER, APPLICATION_NAME, COMPONENT_NAME, COMPOSITE_DN, COMPOSITE_INSTANCE_ID, COMPOSITE_NAME, COMPOSITE_VERSION, CONVERSATION_ID, ECID, PARENT_COMPONENT_INSTANCE_ID, PARENT_COMPONENT_INST_REF_ID, INVOKED_COMPONENT, COMPOSITE_CREATED_TIME, ORGANIZATIONAL_UNIT_ID, DOMAIN_STATE, DOMAIN_STATE_DISPLAY_NAME, COMPONENT_INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUE_DATE_DURATION, PERCENTAGE_COMPLETE, CORRELATION_PROPERTY FROM E$CM_CASE_HEADER;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_MILESTONE
 AS SELECT ID, ORDERING_SEQUENCE, STATE, STATE_DISPLAY_NAME, COMMENT_ID, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DEADLINE, DEADLINE_DURATION FROM E$CM_CASE_MILESTONE;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_PHASE
 AS SELECT ID, SEQUENCE_ORDER, STATE, STATE_DISPLAY_NAME, PERCENTAGE_COMPLETE, COMMENT_ID, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_NUMBER_03, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, SYSTEM_BOOLEAN_03, SYSTEM_DATE_01, SYSTEM_DATE_02, SYSTEM_DATE_03, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DEADLINE, DEADLINE_DURATION FROM E$CM_CASE_PHASE;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_STAKE_HOLDER
 AS SELECT ID, STAKE_HOLDER, STAKE_HOLDER_TYPE, STAKE_HOLDER_DISPLAY_NAME, PERMISSION_MEMBER_ROLE, APPLICATION_CONTEXT, COMMENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_STAKE_HOLDER_SUPPLEMENT FROM E$CM_CASE_STAKE_HOLDER;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_STAKE_HOLDER_MEMBER
 AS SELECT ID, STAKE_HOLDER_ID, STAKE_HOLDER, STAKE_HOLDER_DISPLAY_NAME, STAKE_HOLDER_TYPE, APPLICATION_CONTEXT, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_STAKE_HOLDER_SUPPLEMENT FROM E$CM_CASE_STAKE_HOLDER_MEMBER;

CREATE OR REPLACE EDITIONING VIEW CM_COMMENT
 AS SELECT ID, CASE_OBJECT_ID, CASE_OBJECT_TYPE, CASE_OBJECT_COMMENT, IS_SYSTEM_COMMENT, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_COMMENT;

CREATE OR REPLACE EDITIONING VIEW CM_RULE
 AS SELECT RULE_NAMESPACE, RULE_DICTIONARY, RULE_COMMENTS, RULE_VERSION, TENANT_ID, IS_ACTIVE, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UDPATED_IDCTX, PRODUCT_VERSION FROM E$CM_RULE;

CREATE OR REPLACE EDITIONING VIEW CM_RULE_EDIT
 AS SELECT RULE_NAMESPACE, RULE_DICTIONARY, RULE_COMMENTS, RULE_VERSION, TENANT_ID, LOCKED_BY FROM E$CM_RULE_EDIT;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_ATTRIBUTE
 AS SELECT ACTIVITY_DEFINITION_ID, CASE_ID, ACTIVITY_RATING, PERMISSION_TAG, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, IS_REQUIRED, IS_REPEATABLE, IS_MANUAL FROM E$CM_ACTIVITY_ATTRIBUTE;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_CORRELATION
 AS SELECT CASE_ID, CORRELATION_ID, INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$CM_ACTIVITY_CORRELATION;

CREATE OR REPLACE EDITIONING VIEW CM_SEQUENCE_TABLE
 AS SELECT SEQUENCE_NAME, SEQUENCE_COUNT FROM E$CM_SEQUENCE_TABLE;

CREATE OR REPLACE EDITIONING VIEW CM_CASE_DISPLAY
 AS SELECT CM_NAMESPACE, COMPOSITE_NAMESPACE, COMPOSITE_VERSION, CM_URI, APPLICATIONNAME, HOST_NAME, HTTP_PORT, HTTPS_PORT, PARTITIONNAME, FORM_NAME, FORM_TYPE, SYSTEM_STRING_01, SYSTEM_STRING_02, SYSTEM_STRING_03, SYSTEM_NUMBER_01, SYSTEM_NUMBER_02, SYSTEM_NUMBER_03, SYSTEM_BOOLEAN_01, SYSTEM_BOOLEAN_02 FROM E$CM_CASE_DISPLAY;

CREATE OR REPLACE EDITIONING VIEW CM_ACTIVITY_STAKEHOLDER
 AS SELECT ACTIVITY_DEFINITION_ID, STAKE_HOLDER FROM E$CM_ACTIVITY_STAKEHOLDER;

CREATE OR REPLACE EDITIONING VIEW BPM_ACTIVITY
 AS SELECT PROCESS, ID, NAME, TYPE, NODEID, NODELEVEL, NODESEQNUM, NODEBRANCH, PATTERN, HASPARALLELBRANCH, ISSPLIT, ISSWITCHCASE, ISSWITCHOTHER, ISJOIN, ISWSOPERATION, ISSWITCH, VARIABLE, PART, CONDITION, EXPRESSION, PARTNER, PORTTYPE, OPERATION, ISEXTENSION, EXTENSIONTYPE, EXTENSIONREF, DOCUMENTATION, SOURCECODE FROM E$BPM_ACTIVITY;

CREATE OR REPLACE EDITIONING VIEW BPM_ACTIVITY_INSTANCE
 AS SELECT PROCESSINSTANCE, ID, PROCESS, ACTIVITY, NODESEQNUM, CREATIONDATE, MODIFYDATE, EVALPOINT, EVALTIME, ERRORMESSAGE FROM E$BPM_ACTIVITY_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW BPM_ACTIVITY_PROPERTY
 AS SELECT ACTIVITY, ID, PROCESS, NAME, QNAME, DESCRIPTION, VALUETYPE, DEFAULTVALUE FROM E$BPM_ACTIVITY_PROPERTY;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY
 AS SELECT QUERY_ID, COMPONENT_INSTANCE_ID, COMPONENT_TYPE, STEP, COMPONENT_NAME, COMPOSITE_INSTANCE_ID, COMPOSITE_DN, COMPOSITE_NAME, PROCESS_NAME, ACTIVITY_NAME, ACTIVITY_ID, ACTIVITY_TYPE, FLOW_ELEMENT_TYPE, SCOPE_ID, SOURCE_ACTIVITY, TARGET_ACTIVITY, TITLE, LABEL, REFERENCE_ID, INVOKED_COMPONENT_NAME, CREATE_TIME, THREAD_ID, PARENT_THREAD_ID, AUDIT_INSTANCE_TYPE, DUE_DATE, PROCESS_DUE_DATE, FAULT_TYPE, FAULT_ISRECOVERABLE, OPERATION, PARTICIPANT, ROLE_ID, AUDIT_LOG, PRIORITY, LOOP_COUNT, INSTANCE_COUNT, CI_PARTITION_DATE, AUDIT_LEVEL, AUDIT_COMMENT, AUDIT_STRING1, AUDIT_STRING2, AUDIT_STRING3, AUDIT_STRING4, AUDIT_STRING5, AUDIT_NUMBER1, AUDIT_NUMBER2, AUDIT_NUMBER3, AUDIT_NUMBER4, AUDIT_NUMBER5, AUDIT_DATE1, AUDIT_DATE2, AUDIT_DATE3, V_VALUESTRING1, V_VALUESTRING2, V_VALUESTRING3, V_VALUESTRING4, V_VALUESTRING5, V_VALUESTRING6, V_VALUESTRING7, V_VALUESTRING8, V_VALUESTRING9, V_VALUESTRING10, V_VALUESTRING11, V_VALUESTRING12, V_VALUESTRING13, V_VALUESTRING14, V_VALUESTRING15, V_VALUESTRING16, V_VALUESTRING17, V_VALUESTRING18, V_VALUESTRING19, V_VALUESTRING20, V_VALUEDATE1, V_VALUEDATE2, V_VALUEDATE3, V_VALUEDATE4, V_VALUEDATE5, V_VALUEDATE6, V_VALUEDATE7, V_VALUEDATE8, V_VALUEDATE9, V_VALUEDATE10, V_VALUENUMBER1, V_VALUENUMBER2, V_VALUENUMBER3, V_VALUENUMBER4, V_VALUENUMBER5, V_VALUENUMBER6, V_VALUENUMBER7, V_VALUENUMBER8, V_VALUENUMBER9, V_VALUENUMBER10, V_VALUENUMBER11, V_VALUENUMBER12, V_VALUENUMBER13, V_VALUENUMBER14, V_VALUENUMBER15, V_VALUENUMBER16, V_VALUENUMBER17, V_VALUENUMBER18, V_VALUENUMBER19, V_VALUENUMBER20, V_VALUENUMBER21, V_VALUENUMBER22, V_VALUENUMBER23, V_VALUENUMBER24, V_VALUENUMBER25, V_VALUENUMBER26, V_VALUENUMBER27, V_VALUENUMBER28, V_VALUENUMBER29, V_VALUENUMBER30, ECID, TENANT_ID, FLOW_ID, SCA_PARTITION_ID, PROCESS_TITLE, PROCESS_EXPIRATION_DATE, CASEID FROM E$BPM_AUDIT_QUERY;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_METADATA
 AS SELECT COMPOSITE_DN, APPLICATION_NAME, COMPOSITE_NAME, LABEL, REVISION, STATUS, CREATION_DATE, UNDEPLOY_DATE, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03 FROM E$BPM_AUDIT_QUERY_METADATA;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VAR_MD
 AS SELECT COMPOSITE_DN, EXTENSION_ID, V_NAMESTRING1, V_TYPESTRING1, V_NAMESTRING2, V_TYPESTRING2, V_NAMESTRING3, V_TYPESTRING3, V_NAMESTRING4, V_TYPESTRING4, V_NAMESTRING5, V_TYPESTRING5, V_NAMESTRING6, V_TYPESTRING6, V_NAMESTRING7, V_TYPESTRING7, V_NAMESTRING8, V_TYPESTRING8, V_NAMESTRING9, V_TYPESTRING9, V_NAMESTRING10, V_TYPESTRING10, V_NAMESTRING11, V_TYPESTRING11, V_NAMESTRING12, V_TYPESTRING12, V_NAMESTRING13, V_TYPESTRING13, V_NAMESTRING14, V_TYPESTRING14, V_NAMESTRING15, V_TYPESTRING15, V_NAMESTRING16, V_TYPESTRING16, V_NAMESTRING17, V_TYPESTRING17, V_NAMESTRING18, V_TYPESTRING18, V_NAMESTRING19, V_TYPESTRING19, V_NAMESTRING20, V_TYPESTRING20, V_NAMEDATE1, V_TYPEDATE1, V_NAMEDATE2, V_TYPEDATE2, V_NAMEDATE3, V_TYPEDATE3, V_NAMEDATE4, V_TYPEDATE4, V_NAMEDATE5, V_TYPEDATE5, V_NAMEDATE6, V_TYPEDATE6, V_NAMEDATE7, V_TYPEDATE7, V_NAMEDATE8, V_TYPEDATE8, V_NAMEDATE9, V_TYPEDATE9, V_NAMEDATE10, V_TYPEDATE10, V_NAMENUMBER1, V_TYPENUMBER1, V_NAMENUMBER2, V_TYPENUMBER2, V_NAMENUMBER3, V_TYPENUMBER3, V_NAMENUMBER4, V_TYPENUMBER4, V_NAMENUMBER5, V_TYPENUMBER5, V_NAMENUMBER6, V_TYPENUMBER6, V_NAMENUMBER7, V_TYPENUMBER7, V_NAMENUMBER8, V_TYPENUMBER8, V_NAMENUMBER9, V_TYPENUMBER9, V_NAMENUMBER10, V_TYPENUMBER10, V_NAMENUMBER11, V_TYPENUMBER11, V_NAMENUMBER12, V_TYPENUMBER12, V_NAMENUMBER13, V_TYPENUMBER13, V_NAMENUMBER14, V_TYPENUMBER14, V_NAMENUMBER15, V_TYPENUMBER15, V_NAMENUMBER16, V_TYPENUMBER16, V_NAMENUMBER17, V_TYPENUMBER17, V_NAMENUMBER18, V_TYPENUMBER18, V_NAMENUMBER19, V_TYPENUMBER19, V_NAMENUMBER20, V_TYPENUMBER20, V_NAMENUMBER21, V_TYPENUMBER21, V_NAMENUMBER22, V_TYPENUMBER22, V_NAMENUMBER23, V_TYPENUMBER23, V_NAMENUMBER24, V_TYPENUMBER24, V_NAMENUMBER25, V_TYPENUMBER25, V_NAMENUMBER26, V_TYPENUMBER26, V_NAMENUMBER27, V_TYPENUMBER27, V_NAMENUMBER28, V_TYPENUMBER28, V_NAMENUMBER29, V_TYPENUMBER29, V_NAMENUMBER30, V_TYPENUMBER30, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03 FROM E$BPM_AUDIT_QUERY_VAR_MD;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VAR_RANGES
 AS SELECT COMPOSITE_DN, EXTENSION_ID, VAR_LABEL, RANGE_NAME, RANGE_OPERATOR, NUMBER_RANGE_START, NUMBER_RANGE_END, DATE_RANGE_START, DATE_RANGE_END, DATE_MASK_START, DATE_MASK_END, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03, ECID FROM E$BPM_AUDIT_QUERY_VAR_RANGES;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VARMD_EXT1
 AS SELECT COMPOSITE_DN, V_NAMESTRING1, V_TYPESTRING1, V_NAMESTRING2, V_TYPESTRING2, V_NAMESTRING3, V_TYPESTRING3, V_NAMESTRING4, V_TYPESTRING4, V_NAMESTRING5, V_TYPESTRING5, V_NAMESTRING6, V_TYPESTRING6, V_NAMESTRING7, V_TYPESTRING7, V_NAMESTRING8, V_TYPESTRING8, V_NAMESTRING9, V_TYPESTRING9, V_NAMESTRING10, V_TYPESTRING10, V_NAMESTRING11, V_TYPESTRING11, V_NAMESTRING12, V_TYPESTRING12, V_NAMESTRING13, V_TYPESTRING13, V_NAMESTRING14, V_TYPESTRING14, V_NAMESTRING15, V_TYPESTRING15, V_NAMESTRING16, V_TYPESTRING16, V_NAMESTRING17, V_TYPESTRING17, V_NAMESTRING18, V_TYPESTRING18, V_NAMESTRING19, V_TYPESTRING19, V_NAMESTRING20, V_TYPESTRING20, V_NAMEDATE1, V_TYPEDATE1, V_NAMEDATE2, V_TYPEDATE2, V_NAMEDATE3, V_TYPEDATE3, V_NAMEDATE4, V_TYPEDATE4, V_NAMEDATE5, V_TYPEDATE5, V_NAMEDATE6, V_TYPEDATE6, V_NAMEDATE7, V_TYPEDATE7, V_NAMEDATE8, V_TYPEDATE8, V_NAMEDATE9, V_TYPEDATE9, V_NAMEDATE10, V_TYPEDATE10, V_NAMENUMBER1, V_TYPENUMBER1, V_NAMENUMBER2, V_TYPENUMBER2, V_NAMENUMBER3, V_TYPENUMBER3, V_NAMENUMBER4, V_TYPENUMBER4, V_NAMENUMBER5, V_TYPENUMBER5, V_NAMENUMBER6, V_TYPENUMBER6, V_NAMENUMBER7, V_TYPENUMBER7, V_NAMENUMBER8, V_TYPENUMBER8, V_NAMENUMBER9, V_TYPENUMBER9, V_NAMENUMBER10, V_TYPENUMBER10, V_NAMENUMBER11, V_TYPENUMBER11, V_NAMENUMBER12, V_TYPENUMBER12, V_NAMENUMBER13, V_TYPENUMBER13, V_NAMENUMBER14, V_TYPENUMBER14, V_NAMENUMBER15, V_TYPENUMBER15, V_NAMENUMBER16, V_TYPENUMBER16, V_NAMENUMBER17, V_TYPENUMBER17, V_NAMENUMBER18, V_TYPENUMBER18, V_NAMENUMBER19, V_TYPENUMBER19, V_NAMENUMBER20, V_TYPENUMBER20, V_NAMENUMBER21, V_TYPENUMBER21, V_NAMENUMBER22, V_TYPENUMBER22, V_NAMENUMBER23, V_TYPENUMBER23, V_NAMENUMBER24, V_TYPENUMBER24, V_NAMENUMBER25, V_TYPENUMBER25, V_NAMENUMBER26, V_TYPENUMBER26, V_NAMENUMBER27, V_TYPENUMBER27, V_NAMENUMBER28, V_TYPENUMBER28, V_NAMENUMBER29, V_TYPENUMBER29, V_NAMENUMBER30, V_TYPENUMBER30 FROM E$BPM_AUDIT_QUERY_VARMD_EXT1;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_QUERY_VARVALS_EXT1
 AS SELECT QUERY_ID, EXTENSION_ID, V_VALUESTRING1, V_VALUESTRING2, V_VALUESTRING3, V_VALUESTRING4, V_VALUESTRING5, V_VALUESTRING6, V_VALUESTRING7, V_VALUESTRING8, V_VALUESTRING9, V_VALUESTRING10, V_VALUESTRING11, V_VALUESTRING12, V_VALUESTRING13, V_VALUESTRING14, V_VALUESTRING15, V_VALUESTRING16, V_VALUESTRING17, V_VALUESTRING18, V_VALUESTRING19, V_VALUESTRING20, V_VALUEDATE1, V_VALUEDATE2, V_VALUEDATE3, V_VALUEDATE4, V_VALUEDATE5, V_VALUEDATE6, V_VALUEDATE7, V_VALUEDATE8, V_VALUEDATE9, V_VALUEDATE10, V_VALUENUMBER1, V_VALUENUMBER2, V_VALUENUMBER3, V_VALUENUMBER4, V_VALUENUMBER5, V_VALUENUMBER6, V_VALUENUMBER7, V_VALUENUMBER8, V_VALUENUMBER9, V_VALUENUMBER10, V_VALUENUMBER11, V_VALUENUMBER12, V_VALUENUMBER13, V_VALUENUMBER14, V_VALUENUMBER15, V_VALUENUMBER16, V_VALUENUMBER17, V_VALUENUMBER18, V_VALUENUMBER19, V_VALUENUMBER20, V_VALUENUMBER21, V_VALUENUMBER22, V_VALUENUMBER23, V_VALUENUMBER24, V_VALUENUMBER25, V_VALUENUMBER26, V_VALUENUMBER27, V_VALUENUMBER28, V_VALUENUMBER29, V_VALUENUMBER30, SYSTEM_STRING01, SYSTEM_STRING02, SYSTEM_STRING03, SYSTEM_STRING04, SYSTEM_STRING05, SYSTEM_NUMBER01, SYSTEM_NUMBER02, SYSTEM_NUMBER03, SYSTEM_NUMBER04, SYSTEM_NUMBER05, SYSTEM_DATE01, SYSTEM_DATE02, SYSTEM_DATE03, ECID, TENANT_ID, FLOW_ID, SCA_PARTITION_ID FROM E$BPM_AUDIT_QUERY_VARVALS_EXT1;

CREATE OR REPLACE EDITIONING VIEW BPM_AUDIT_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_AUDIT_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_CASE
 AS SELECT CASEID, CASEMETADATAID, CASEIDENTIFICATIONKEY, CASEACTIVITYID, CASEACTIVITYNAME, CASEACTIVITYTYPE, SYSTEMSTATUS, CASESTATE, INDEXEDSTRINGATTRIBUTE1, INDEXEDSTRINGATTRIBUTE2, INDEXEDSTRINGATTRIBUTE3, INDEXEDSTRINGATTRIBUTE4, INDEXEDSTRINGATTRIBUTE5, STRINGATTRIBUTE1, STRINGATTRIBUTE2, STRINGATTRIBUTE3, STRINGATTRIBUTE4, STRINGATTRIBUTE5, STRINGATTRIBUTE6, STRINGATTRIBUTE7, STRINGATTRIBUTE8, STRINGATTRIBUTE9, STRINGATTRIBUTE10, STRINGATTRIBUTE11, STRINGATTRIBUTE12, STRINGATTRIBUTE13, STRINGATTRIBUTE14, STRINGATTRIBUTE15, STRINGATTRIBUTE16, STRINGATTRIBUTE17, STRINGATTRIBUTE18, STRINGATTRIBUTE19, STRINGATTRIBUTE20, NUMBERATTRIBUTE1, NUMBERATTRIBUTE2, NUMBERATTRIBUTE3, NUMBERATTRIBUTE4, NUMBERATTRIBUTE5, NUMBERATTRIBUTE6, NUMBERATTRIBUTE7, NUMBERATTRIBUTE8, NUMBERATTRIBUTE9, NUMBERATTRIBUTE10, NUMBERATTRIBUTE11, NUMBERATTRIBUTE12, NUMBERATTRIBUTE13, NUMBERATTRIBUTE14, NUMBERATTRIBUTE15, NUMBERATTRIBUTE16, NUMBERATTRIBUTE17, NUMBERATTRIBUTE18, NUMBERATTRIBUTE19, NUMBERATTRIBUTE20, DATEATTRIBUTE1, DATEATTRIBUTE2, DATEATTRIBUTE3, DATEATTRIBUTE4, DATEATTRIBUTE5, DATEATTRIBUTE6, DATEATTRIBUTE7, DATEATTRIBUTE8, DATEATTRIBUTE9, DATEATTRIBUTE10, DATEATTRIBUTE11, DATEATTRIBUTE12, DATEATTRIBUTE13, DATEATTRIBUTE14, DATEATTRIBUTE15, DATEATTRIBUTE16, DATEATTRIBUTE17, DATEATTRIBUTE18, DATEATTRIBUTE19, DATEATTRIBUTE20, CREATEDDATE, UPDATEDDATE, VERSION, SYSTEMATTRIBUTE1, SYSTEMATTRIBUTE2, SYSTEMATTRIBUTE3, SYSTEMATTRIBUTE4, SYSTEMATTRIBUTE5, SYSTEMATTRIBUTE6, SYSTEMATTRIBUTE7, SYSTEMATTRIBUTE8, SYSTEMATTRIBUTE9, SYSTEMATTRIBUTE10 FROM E$BPM_CASE;

CREATE OR REPLACE EDITIONING VIEW BPM_CASE_ACTIVITIES
 AS SELECT GUID, CASEID, CASEACTIVITYID, CASEACTIVITYTYPE, CASEACTIVITYNAME, CASEACTIVITYSTATUS, CASESUBACTIVITYID, CASESUBACTIVITYTYPE, CASESUBACTIVITYNAME, CASESUBACTIVITYSTATUS, SYSTEMATTRIBUTE1, SYSTEMATTRIBUTE2, SYSTEMATTRIBUTE3, SYSTEMATTRIBUTE4, SYSTEMATTRIBUTE5, VERSION FROM E$BPM_CASE_ACTIVITIES;

CREATE OR REPLACE EDITIONING VIEW BPM_CASE_ATTRIBUTES
 AS SELECT GUID, CASETYPE, ATTRIBUTENAME, COLUMNNAME, VERSION FROM E$BPM_CASE_ATTRIBUTES;

CREATE OR REPLACE EDITIONING VIEW BPM_CASE_DATA
 AS SELECT CASEID, NAME, DATA, VERSION FROM E$BPM_CASE_DATA;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY
 AS SELECT ACTIVITYID, PROCESSID, ACTIVITYNAME, ACTIVITYTYPE, LABEL, NODEID, NODELEVEL, NODESEQNUM, NODEBRANCH, PATTERN, HASPARALLELBRANCH, ISSPLIT, ISSWITCHCASE, ISSWITCHOTHER, ISJOIN, ISWSOPERATION, ISSWITCH, VARIABLE, PART, CONDITION, EXPRESSION, PRIORITY, PARTNERID, PORTTYPE, OPERATION, ISEXTENSION, EXTENSIONTYPE, EXTENSIONREF, DOCUMENTATION, SOURCECODE, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ACTIVITY;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY_INSTANCE
 AS SELECT PROCESSINSTANCEID, ACTIVITYINSTANCEID, PROCESSID, ACTIVITYID, NODESEQNUM, CREATIONDATE, MODIFYDATE, EVALPOINT, EVALTIME, ERRORMESSAGE, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03 FROM E$BPM_CUBE_ACTIVITY_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY_PROPERTY
 AS SELECT ACTIVITYID, PROPERTYID, PROCESSID, PROPERTYNAME, QNAME, DESCRIPTION, VALUETYPE, DEFAULTVALUE FROM E$BPM_CUBE_ACTIVITY_PROPERTY;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ACTIVITY_SEQFLOW
 AS SELECT PROCESSID, SEQUENCEFLOWID, SOURCEACTIVITYID, TARGETACTIVITYID, LABEL, ISNORMALFLOW, ISCONDITIONFLOW, ISEXCEPTIONFLOW, CONDITION, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ACTIVITY_SEQFLOW;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_AUDITINST_FLEX01
 AS SELECT QUERYID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_AUDITINST_FLEX01;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_AUDITINSTANCE
 AS SELECT QUERYID, COMPONENTINSTANCEID, COMPONENTNAME, COMPOSITEDN, COMPOSITEREVISION, ACTIVITYID, ACTIVITYNAME, FLOWELEMENTTYPE, CREATETIME, CREATETIMEMILLIS, LASTUPDATED, THREADID, SCOPEID, INSTANCECOUNT, LOOPCOUNT, OPERATION, PARTICIPANT, ROLEID, PROCESSNAME, REFERENCEID, INVOKEDCOMPONENTNAME, PROCESSED, FAULTED, FAULTTYPE, RECOVERABLEFAULT, PRIORITY, BUSINESSINDICATORS, CIPARTITIONDATE, COMPOSITEINSTANCEID, ACTIVITYSTATUS, SUSPENDTIME, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, ECID, TENANTID, PROCESS_TITLE FROM E$BPM_CUBE_AUDITINSTANCE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_GLOBALCREATETASK
 AS SELECT PROCESSID, ACTIVITYNAME, ACTIVITYLABEL, ROLE, APPLICATIONCONTEXT, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, ACTIVITYID FROM E$BPM_CUBE_GLOBALCREATETASK;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_LASTSNAPSHOT
 AS SELECT SNAPSHOTID, QUERYID, LASTSNAPSHOT FROM E$BPM_CUBE_LASTSNAPSHOT;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_LOCK
 AS SELECT LOCKNAME, LASTUPDATED, INFO FROM E$BPM_CUBE_LOCK;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_NAMETAB
 AS SELECT NAMETABID, PROCESSID, EXTENSIONID, NFLEXSTRING01, NFLEXSTRING02, NFLEXSTRING03, NFLEXSTRING04, NFLEXSTRING05, NFLEXSTRING06, NFLEXSTRING07, NFLEXSTRING08, NFLEXSTRING09, NFLEXSTRING10, NFLEXSTRING11, NFLEXSTRING12, NFLEXSTRING13, NFLEXSTRING14, NFLEXSTRING15, NFLEXSTRING16, NFLEXSTRING17, NFLEXSTRING18, NFLEXSTRING19, NFLEXSTRING20, TFLEXSTRING01, TFLEXSTRING02, TFLEXSTRING03, TFLEXSTRING04, TFLEXSTRING05, TFLEXSTRING06, TFLEXSTRING07, TFLEXSTRING08, TFLEXSTRING09, TFLEXSTRING10, TFLEXSTRING11, TFLEXSTRING12, TFLEXSTRING13, TFLEXSTRING14, TFLEXSTRING15, TFLEXSTRING16, TFLEXSTRING17, TFLEXSTRING18, TFLEXSTRING19, TFLEXSTRING20, NFLEXDATE01, NFLEXDATE02, NFLEXDATE03, NFLEXDATE04, NFLEXDATE05, NFLEXDATE06, NFLEXDATE07, NFLEXDATE08, NFLEXDATE09, NFLEXDATE10, TFLEXDATE01, TFLEXDATE02, TFLEXDATE03, TFLEXDATE04, TFLEXDATE05, TFLEXDATE06, TFLEXDATE07, TFLEXDATE08, TFLEXDATE09, TFLEXDATE10, NFLEXNUMBER01, NFLEXNUMBER02, NFLEXNUMBER03, NFLEXNUMBER04, NFLEXNUMBER05, NFLEXNUMBER06, NFLEXNUMBER07, NFLEXNUMBER08, NFLEXNUMBER09, NFLEXNUMBER10, NFLEXNUMBER11, NFLEXNUMBER12, NFLEXNUMBER13, NFLEXNUMBER14, NFLEXNUMBER15, NFLEXNUMBER16, NFLEXNUMBER17, NFLEXNUMBER18, NFLEXNUMBER19, NFLEXNUMBER20, NFLEXNUMBER21, NFLEXNUMBER22, NFLEXNUMBER23, NFLEXNUMBER24, NFLEXNUMBER25, NFLEXNUMBER26, NFLEXNUMBER27, NFLEXNUMBER28, NFLEXNUMBER29, NFLEXNUMBER30, TFLEXNUMBER01, TFLEXNUMBER02, TFLEXNUMBER03, TFLEXNUMBER04, TFLEXNUMBER05, TFLEXNUMBER06, TFLEXNUMBER07, TFLEXNUMBER08, TFLEXNUMBER09, TFLEXNUMBER10, TFLEXNUMBER11, TFLEXNUMBER12, TFLEXNUMBER13, TFLEXNUMBER14, TFLEXNUMBER15, TFLEXNUMBER16, TFLEXNUMBER17, TFLEXNUMBER18, TFLEXNUMBER19, TFLEXNUMBER20, TFLEXNUMBER21, TFLEXNUMBER22, TFLEXNUMBER23, TFLEXNUMBER24, TFLEXNUMBER25, TFLEXNUMBER26, TFLEXNUMBER27, TFLEXNUMBER28, TFLEXNUMBER29, TFLEXNUMBER30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03 FROM E$BPM_CUBE_NAMETAB;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_NAMETAB_RANGE
 AS SELECT NAMETABID, EXTENSIONID, RANGEID, PROCESSID, INDICATORNAME, RANGENAME, RANGEOPERATOR, NUMBERRANGESTART, NUMBERRANGEEND, DATETIMERANGESTART, DATETIMERANGEEND, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_NAMETAB_RANGE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ORGUNIT
 AS SELECT ORGUNITID, PARENTID, ORGUNITNAME, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ORGUNIT;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ORGUNIT_ASSOC
 AS SELECT ORGUNITID, PROCESSID FROM E$BPM_CUBE_ORGUNIT_ASSOC;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PARTNER_SERVICE
 AS SELECT PARTNERID, PARTNERSERVICEID, PROCESSID, PORTTYPE, OPERATION, ISINITIATING FROM E$BPM_CUBE_PARTNER_SERVICE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCESS
 AS SELECT PROCESSID, PROCESSNAME, DOMAINNAME, COMPOSITENAME, REVISION, SCALABEL, COMPOSITEDN, LABEL, PROCESSTYPE, TARGETNAMESPACE, STATUS, CREATIONDATE, UNDEPLOYDATE, ORGANIZATIONALUNITID, HASGLOBALCREATIONTASKS, SUBTYPE, SUSPENDEDTIME, RESUMEDTIME, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, DEPLOYMENTINFO, LASTUPDATED, MIGRATIONSTATUS, ANALYTICSVIEWIDENTIFIER, ANALYTICSVIEWGRANTEES, TEMPLATENAME, TEMPLATEVIEWIDENTIFIER, APPLICATIONLINKDISPLAYNAME, CATEGORY, TAGS FROM E$BPM_CUBE_PROCESS;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCESS_PARTNER
 AS SELECT PARTNERID, PROCESSID, PARTNERNAME, LINKTYPE, SCOPEID, PARTNERWSDL, MYROLE, PARTNERROLE FROM E$BPM_CUBE_PROCESS_PARTNER;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCESSPERFORMANCE
 AS SELECT PROCESSPERFID, PROCESSID, COMPONENTINSTANCEID, COMPONENTINSTANCESTATE, CREATIONDATETIME, CREATIONDATE, COMPLETIONDATETIME, COMPLETIONDATE, TASKTIME, DISCRIMINATOR, CIPARTITIONDATE, COMPOSITEINSTANCEID, SUSPENDTIME, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, ECID, TENANTID FROM E$BPM_CUBE_PROCESSPERFORMANCE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_PROCPERF_FLEX01
 AS SELECT PROCESSID, PROCESSPERFID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_PROCPERF_FLEX01;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_ROLE
 AS SELECT PROCESSID, ROLEID, ROLENAME, LABEL, APPROLENAME, ISPROCESSOWNER, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03 FROM E$BPM_CUBE_ROLE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_CUBE_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_TASKPERF_FLEX01
 AS SELECT ACTIVITYID, TASKPERFID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_TASKPERF_FLEX01;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_TASKPERFORMANCE
 AS SELECT TASKPERFID, ACTIVITYID, PROCESSID, ROLEID, COMPONENTINSTANCEID, CREATIONDATETIME, CREATIONDATE, COMPLETIONDATETIME, COMPLETIONDATE, TASKTIME, IDLETIME, PARTICIPANT, PRIORITY, DISCRIMINATOR, REFERENCEID, SCOPEID, INSTANCECOUNT, LOOPCOUNT, CIPARTITIONDATE, COMPOSITEINSTANCEID, SUSPENDTIME, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, STARTFLEXNUMBER01, STARTFLEXNUMBER02, STARTFLEXNUMBER03, STARTFLEXNUMBER04, STARTFLEXNUMBER05, STARTFLEXNUMBER06, STARTFLEXNUMBER07, STARTFLEXNUMBER08, STARTFLEXNUMBER09, STARTFLEXNUMBER10, STARTFLEXNUMBER11, STARTFLEXNUMBER12, STARTFLEXNUMBER13, STARTFLEXNUMBER14, STARTFLEXNUMBER15, STARTFLEXNUMBER16, STARTFLEXNUMBER17, STARTFLEXNUMBER18, STARTFLEXNUMBER19, STARTFLEXNUMBER20, STARTFLEXNUMBER21, STARTFLEXNUMBER22, STARTFLEXNUMBER23, STARTFLEXNUMBER24, STARTFLEXNUMBER25, STARTFLEXNUMBER26, STARTFLEXNUMBER27, STARTFLEXNUMBER28, STARTFLEXNUMBER29, STARTFLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, ECID, TENANTID FROM E$BPM_CUBE_TASKPERFORMANCE;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_WORKLOAD
 AS SELECT WORKLOADID, ACTIVITYID, PROCESSID, ROLEID, ORIGACTIVITYID, SNAPSHOTTIME, QUANTITY, AVGTIMETASK, AVGTIMEPROCESS, MEDIANTIMETASK, MEDIANTIMEPROCESS, SUMTIMETASK, SUMTIMEPROCESS, SQRSUMTIMETASK, SQRSUMTIMEPROCESS, SAMPLESIZE, STATVALUE01, STATVALUE02, STATVALUE03, STATVALUE04, STATVALUE05, PARTICIPANT, PRIORITY, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30, SYSTEMSTRING01, SYSTEMSTRING02, SYSTEMSTRING03, SYSTEMSTRING04, SYSTEMSTRING05, SYSTEMNUMBER01, SYSTEMNUMBER02, SYSTEMNUMBER03, SYSTEMNUMBER04, SYSTEMNUMBER05, SYSTEMTIMESTAMP01, SYSTEMTIMESTAMP02, SYSTEMTIMESTAMP03, TENANTID FROM E$BPM_CUBE_WORKLOAD;

CREATE OR REPLACE EDITIONING VIEW BPM_CUBE_WORKLOAD_FLEX01
 AS SELECT ACTIVITYID, WORKLOADID, EXTENSIONID, FLEXSTRING01, FLEXSTRING02, FLEXSTRING03, FLEXSTRING04, FLEXSTRING05, FLEXSTRING06, FLEXSTRING07, FLEXSTRING08, FLEXSTRING09, FLEXSTRING10, FLEXSTRING11, FLEXSTRING12, FLEXSTRING13, FLEXSTRING14, FLEXSTRING15, FLEXSTRING16, FLEXSTRING17, FLEXSTRING18, FLEXSTRING19, FLEXSTRING20, FLEXDATE01, FLEXDATE02, FLEXDATE03, FLEXDATE04, FLEXDATE05, FLEXDATE06, FLEXDATE07, FLEXDATE08, FLEXDATE09, FLEXDATE10, FLEXDATERANGE01, FLEXDATERANGE02, FLEXDATERANGE03, FLEXDATERANGE04, FLEXDATERANGE05, FLEXDATERANGE06, FLEXDATERANGE07, FLEXDATERANGE08, FLEXDATERANGE09, FLEXDATERANGE10, FLEXNUMBER01, FLEXNUMBER02, FLEXNUMBER03, FLEXNUMBER04, FLEXNUMBER05, FLEXNUMBER06, FLEXNUMBER07, FLEXNUMBER08, FLEXNUMBER09, FLEXNUMBER10, FLEXNUMBER11, FLEXNUMBER12, FLEXNUMBER13, FLEXNUMBER14, FLEXNUMBER15, FLEXNUMBER16, FLEXNUMBER17, FLEXNUMBER18, FLEXNUMBER19, FLEXNUMBER20, FLEXNUMBER21, FLEXNUMBER22, FLEXNUMBER23, FLEXNUMBER24, FLEXNUMBER25, FLEXNUMBER26, FLEXNUMBER27, FLEXNUMBER28, FLEXNUMBER29, FLEXNUMBER30, FLEXNUMBERRANGE01, FLEXNUMBERRANGE02, FLEXNUMBERRANGE03, FLEXNUMBERRANGE04, FLEXNUMBERRANGE05, FLEXNUMBERRANGE06, FLEXNUMBERRANGE07, FLEXNUMBERRANGE08, FLEXNUMBERRANGE09, FLEXNUMBERRANGE10, FLEXNUMBERRANGE11, FLEXNUMBERRANGE12, FLEXNUMBERRANGE13, FLEXNUMBERRANGE14, FLEXNUMBERRANGE15, FLEXNUMBERRANGE16, FLEXNUMBERRANGE17, FLEXNUMBERRANGE18, FLEXNUMBERRANGE19, FLEXNUMBERRANGE20, FLEXNUMBERRANGE21, FLEXNUMBERRANGE22, FLEXNUMBERRANGE23, FLEXNUMBERRANGE24, FLEXNUMBERRANGE25, FLEXNUMBERRANGE26, FLEXNUMBERRANGE27, FLEXNUMBERRANGE28, FLEXNUMBERRANGE29, FLEXNUMBERRANGE30 FROM E$BPM_CUBE_WORKLOAD_FLEX01;

CREATE OR REPLACE EDITIONING VIEW BPM_CUSTOM_APPS
 AS SELECT APPID, URI, DISPLAY_NAME, DESCRIPTION, AUTH_IDENTITIES, CATEGORY, SUBCATEGORY FROM E$BPM_CUSTOM_APPS;

CREATE OR REPLACE EDITIONING VIEW BPM_MEASUREMENT_ACTION_EXCEPS
 AS SELECT ACTION_EXCEPTION_ID, ACTION_EXCEPTION_TIMESTAMP, QUERY_ID, STATUS, ACTION_EXCEPTION_NAME, MESSAGE, ACTION_NAME, CI_PARTITION_DATE, COMPONENT_INSTANCE_ID, COMPOSITE_INSTANCE_ID, SYSTEM_STRING1, SYSTEM_STRING2, ECID, TENANT_ID, COMPONENT_TYPE, EVENT_KEY, LAST_UPDATED, REPUBLISH_COUNT, FLOW_ID, SCA_PARTITION_ID, COMPOSITE_NAME, EVENT_OBJECT FROM E$BPM_MEASUREMENT_ACTION_EXCEP;

CREATE OR REPLACE EDITIONING VIEW BPM_MEASUREMENT_ACTION_SEQ
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_MEASUREMENT_ACTION_SEQ;

CREATE OR REPLACE EDITIONING VIEW BPM_MEASUREMENT_ACTIONS
 AS SELECT ACTION_INVOCATION_ID, ACTION_NAME, QUERY_ID, AUDIT_QUERY_TIME, CI_PARTITION_DATE, COMPONENT_INSTANCE_ID, COMPOSITE_INSTANCE_ID, SYSTEM_STRING1, SYSTEM_STRING2, ECID, TENANT_ID, COMPONENT_TYPE, EVENT_KEY, LAST_UPDATED, FLOW_ID, SCA_PARTITION_ID FROM E$BPM_MEASUREMENT_ACTIONS;

CREATE OR REPLACE EDITIONING VIEW BPM_PARTNER_SERVICE
 AS SELECT PARTNER, ID, PROCESS, PORTTYPE, OPERATION, ISINITIATING FROM E$BPM_PARTNER_SERVICE;

CREATE OR REPLACE EDITIONING VIEW BPM_PROCESS
 AS SELECT ID, COMPONENT, NAME, APPLICATIONNAME, COMPOSITENAME, REVISION, LABEL, NAMESPACE, MDSNAMESPACE, MDSOBJECT, STATUS, CREATIONDATE FROM E$BPM_PROCESS;

CREATE OR REPLACE EDITIONING VIEW BPM_PROCESS_PARTNER
 AS SELECT ID, PROCESS, NAME, LINKTYPE, SCOPE, PARTNERWSDL, MYROLE, PARTNERROLE FROM E$BPM_PROCESS_PARTNER;

CREATE OR REPLACE EDITIONING VIEW BPM_PROJECTSHAREDATA
 AS SELECT ID, COMPOSITENAME, COMPOSITEREVISION, COMPOSITELABEL, COMPOSITEINSTANCEID, VARIABLENAME, VALUESTRING, VALUENUMBER, VALUEDATE, VALUEBLOB, CREATEDTIME, CREATEDBY, UPDATEDTIME, UPDATEDBY, UPDATEDVERSION FROM E$BPM_PROJECTSHAREDATA;

CREATE OR REPLACE EDITIONING VIEW BPM_PROJECTSHAREDATA_SEQ
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_PROJECTSHAREDATA_SEQ;

CREATE OR REPLACE EDITIONING VIEW BPM_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_RT_FLOW_ELEMENT
 AS SELECT SNAPSHOTID, FLOWELEMENTID, EXECUTIONS, EXECUTIONTIMESUM, EXECUTIONTIMESQRSUM FROM E$BPM_RT_FLOW_ELEMENT;

CREATE OR REPLACE EDITIONING VIEW BPM_RT_INSTANCE_CREATION
 AS SELECT SNAPSHOTID, FLOWELEMENTID, TIMEBETWEENCREATIONSUM, TIMEBETWEENCREATIONSQRSUM, SAMPLESIZE FROM E$BPM_RT_INSTANCE_CREATION;

CREATE OR REPLACE EDITIONING VIEW BPM_RT_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_RT_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_RT_SEQUENCE_FLOW
 AS SELECT SNAPSHOTID, TARGETACTIVITY, SOURCEACTIVITY, ROUTINGS FROM E$BPM_RT_SEQUENCE_FLOW;

CREATE OR REPLACE EDITIONING VIEW BPM_RT_SNAPSHOT
 AS SELECT SNAPSHOTID, COMPOSITEDN, COMPONENTNAME, TIMESTAMP, TENANTID FROM E$BPM_RT_SNAPSHOT;

CREATE OR REPLACE EDITIONING VIEW AG_INSTANCE
 AS SELECT CIKEY, DEFINITION_ID, ROOT_AG_ID, CMPST_ID, CREATION_DATE, CREATOR, TITLE, IDENTIFICATION_KEY, STATUS, COMPLETION_PERCENTAGE, ERROR_MESSAGE, MILESTONE_STATE FROM E$AG_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW BPM_PML_SEQUENCE
 AS SELECT seq_name, seq_count FROM E$BPM_PML_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_PML_HS
 AS SELECT AUTHOR, CHANGE_DATE, PROJECTNAME, METADATA_CHANGE, PROJECTTYPE, CHANGES, PROJECT_ZIP FROM E$BPM_PML_HS;

CREATE OR REPLACE EDITIONING VIEW BPM_PML_HS_ITEM
 AS SELECT ID, ARTIFACT, ACTION, LOGICALNAME FROM E$BPM_PML_HS_ITEM;

CREATE OR REPLACE EDITIONING VIEW BPM_PML_HS_BPM_PML_HS_ITEM
 AS SELECT AUTHOR, CHANGE_DATE, PROJECTNAME, changedItems_ID FROM E$BPM_PML_HS_BPM_PML_HS_ITEM;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SEQUENCE
 AS SELECT seq_name, seq_count FROM E$BPM_BAC_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SESSION
 AS SELECT SPACE_PROJECT_ID, SESSION_FILE, FILE_CONTENT, CONTENT_TYPE, IS_VIRTUAL, SYNC_TIMESTAMP FROM E$BPM_BAC_SESSION;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_METADATA_STORE
 AS SELECT METADATA_STORE_KEY, METADATA_STORE_VALUE FROM E$BPM_BAC_METADATA_STORE;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_REPOSITORY_BACKUP
 AS SELECT ID, REPOSITORY_UUID, REVISION, ZIP_FILE FROM E$BPM_BAC_REPOSITORY_BACKUP;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_ASSET
 AS SELECT ID, NAME, TYPE, DESCRIPTION, CREATION_DATE, LOCK_DATE, SESSION_CHANNEL, USER_NAME, SPACE_ID, ARTIFACT_CREATOR FROM E$BPM_BAC_ASSET;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_ASSET_GRANT
 AS SELECT GRANT_ID, ARTIFACT_ID, ROLE FROM E$BPM_BAC_ASSET_GRANT;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_ASSET_GRANT_PRINCIPAL
 AS SELECT GRANT_ID, PRINCIPAL_ID FROM E$BPM_BAC_ASSET_GRANT_PRINCIPA;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_PRINCIPAL
 AS SELECT PRINCIPAL_ID, IS_GROUP, PRINCIPAL_NAME FROM E$BPM_BAC_PRINCIPAL;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SPACE
 AS SELECT ID, NAME, ARTIFACT_CREATOR, CREATION_DATE FROM E$BPM_BAC_SPACE;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SPACE_GRANT
 AS SELECT GRANT_ID, ARTIFACT_ID, ROLE FROM E$BPM_BAC_SPACE_GRANT;

CREATE OR REPLACE EDITIONING VIEW BPM_BAC_SPACE_GRANT_PRINCIPAL
 AS SELECT GRANT_ID, PRINCIPAL_ID FROM E$BPM_BAC_SPACE_GRANT_PRINCIPA;

CREATE OR REPLACE EDITIONING VIEW BPM_OPTIMIZATION_DATA
 AS SELECT COMPOSITE_DN, COMPONENT_NAME, LAST_UPDATE FROM E$BPM_OPTIMIZATION_DATA;

CREATE OR REPLACE EDITIONING VIEW BPM_OPT_COMPLETION_DATE_DATA
 AS SELECT NODE_IDENTIFIER, COMPOSITE_DN, COMPONENT_NAME, ACTIVITY_ID, PARENT_NODE_ID, INSTANCE_TRACES, MAX_ELAPSED_TIME, MIN_ELAPSED_TIME, SUM_ELAPSED_TIME, SUM_SQR_ELAPSED_TIME, VARIANCE_ELAPSED_TIME, ESTIMATED_ELAPSED_TIME, MAX_TIME_TO_COMPLETION, MIN_TIME_TO_COMPLETION, SUM_TIME_TO_COMPLETION, SUM_SQR_TIME_TO_COMPLETION, VARIANCE_TIME_TO_COMPLETION, ESTIMATED_TIME_TO_COMPLETION FROM E$BPM_OPT_COMPLETION_DATE_DATA;

CREATE OR REPLACE EDITIONING VIEW BPM_OPT_DATA_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_OPT_DATA_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_ARCHIVEREQUEST
 AS SELECT ID, STATE, SCHEDULEDSTARTTIME, CRONSPEC, CREATEROLE, CREATEDBY, CREATEDTIME, UPDATEDBY, UPDATEDTIME, FAULTREASONSUMMARY, REQUESTDETAIL, SYSTEMSTR01, SYSTEMSTR02, SYSTEMSTR03 FROM E$BPM_ARCHIVEREQUEST;

CREATE OR REPLACE EDITIONING VIEW BPM_ARCHIVESEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$BPM_ARCHIVESEQUENCE;

CREATE OR REPLACE EDITIONING VIEW BPM_USER_DRAFT
 AS SELECT ID, NAME, TYPE, CREATEDBY, CREATEDDATE, UPDATEDDATE, CONTENT, DESCRIPTION, MIMETYPE, QUERYKEY FROM E$BPM_USER_DRAFT;

CREATE OR REPLACE EDITIONING VIEW edn_event_error_store
 AS SELECT msg_id, namespace, local_name, target, target_type, payload, error_code, error_type, error_msg, short_error_msg, state, sidecar, creation_time, flow_id FROM E$edn_event_error_store;

CREATE OR REPLACE EDITIONING VIEW EDN_E2J_MAPPING
 AS SELECT NAMESPACE, LOCAL_NAME, TOPIC_NAME, TOPIC_JNDI, JMS_TYPE, CREATION_TIME FROM E$EDN_E2J_MAPPING;

CREATE OR REPLACE EDITIONING VIEW EDN_EVENT_AGENTS
 AS SELECT AGENT_ID, AGENT_CALLBACK FROM E$EDN_EVENT_AGENTS;

CREATE OR REPLACE EDITIONING VIEW EDN_EVENT_SUBSCRIPTIONS
 AS SELECT SUB_ID, AGENT_ID, NAMESPACE, LOCAL_NAME, SUB_LEVEL, ENABLED, XPATH_FILTER, XPATH_NS_MAP FROM E$EDN_EVENT_SUBSCRIPTIONS;

CREATE OR REPLACE EDITIONING VIEW EDN_LOG_ENABLED
 AS SELECT ENABLED FROM E$EDN_LOG_ENABLED;

CREATE OR REPLACE EDITIONING VIEW EDN_LOG_MESSAGES
 AS SELECT MSG_SEQ, EVENT_SEQ, MSG FROM E$EDN_LOG_MESSAGES;

CREATE OR REPLACE EDITIONING VIEW EDN_RETRY_COUNT
 AS SELECT MSG_ID, RETRY_COUNT FROM E$EDN_RETRY_COUNT;

CREATE OR REPLACE EDITIONING VIEW ATTACHMENT
 AS SELECT KEY, ATTACHMENT, PROPERTIES FROM E$ATTACHMENT;

CREATE OR REPLACE EDITIONING VIEW SOA_PURGE_LOG
 AS SELECT LOG_DATE, PURGE_LOG FROM E$SOA_PURGE_LOG;

CREATE OR REPLACE EDITIONING VIEW ATTACHMENT_REF
 AS SELECT KEY, CMPST_INST_ID, CMPNNT_INST_ID, CMPST_DN, CMPNNT_NAME, CMPNNT_TYPE, ECID FROM E$ATTACHMENT_REF;

CREATE OR REPLACE EDITIONING VIEW BRIDGE_INSTANCE
 AS SELECT ECID, ID, PARENT_ID, CONVERSATION_ID, BRIDGE_NAME, BRIDGE_TYPE, EVENT_NAME, DIRECTION, STATE, ADDITIONAL_PROPERTIES, ERROR_MESSAGE, STACK_TRACE, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME FROM E$BRIDGE_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW COMPONENT_INSTANCE
 AS SELECT ECID, COMPOSITE_INSTANCE_ID, ID, PARENT_ID, COMPONENT_DN, COMPONENT_TYPE, CONVERSATION_ID, STATE, SOURCE_ACTION_TYPE, SOURCE_ACTION_NAME, ADDITIONAL_PROPERTIES, ERROR_MESSAGE, STACK_TRACE, CPST_PARTITION_DATE, TENANT_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME FROM E$COMPONENT_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_INSTANCE
 AS SELECT ECID, ID, PARENT_ID, CONVERSATION_ID, COMPOSITE_DN, SOURCE_NAME, SOURCE_TYPE, SOURCE_ACTION_TYPE, SOURCE_ACTION_NAME, BATCH_ID, BATCH_INDEX, BUSINESS_STATUS, INDEX1, INDEX2, INDEX3, INDEX4, INDEX5, INDEX6, TITLE, TAGS, TEST_RUN_NAME, TEST_RUN_ID, TEST_SUITE, TEST_CASE, STATE, LIVE_INSTANCES, STATE_COUNT, HAS_ASSOC, VERSION, PARTITION_DATE, TENANT_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, FLOW_ID FROM E$COMPOSITE_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_INSTANCE_ASSOC
 AS SELECT ASSOC1_ECID, ASSOC1_COMPOSITE_INSTANCE_ID, ASSOC1_COMPONENT_INSTANCE_ID, ASSOC2_ECID, ASSOC2_COMPOSITE_INSTANCE_ID, ASSOC2_COMPONENT_INSTANCE_ID, CREATED_TIME, FLOW_ID FROM E$COMPOSITE_INSTANCE_ASSOC;

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_INSTANCE_FAULT
 AS SELECT ECID, PARENT_ID, ID, COMPOSITE_INSTANCE_ID, COMPOSITE_DN, UNIQUE_ID, BATCH_ID, CPST_PARTITION_DATE, TENANT_ID, CREATED_TIME, SERVICE_NAME, BINDING_TYPE, PROTOCOL_MESSAGE_ID, PROTOCOL_CORRELATION_ID, ERROR_CATEGORY, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, RETRY_COUNT, MESSAGE_ORIGIN_REFERENCE, ADDITIONAL_PROPERTIES FROM E$COMPOSITE_INSTANCE_FAULT;

CREATE OR REPLACE EDITIONING VIEW INSTANCE_PAYLOAD
 AS SELECT INSTANCE_ID, INSTANCE_TYPE, PART_NAME, PAYLOAD_TYPE, PAYLOAD_KEY, CREATED_TIME FROM E$INSTANCE_PAYLOAD;

CREATE OR REPLACE EDITIONING VIEW REFERENCE_INSTANCE
 AS SELECT ECID, ID, COMPOSITE_INSTANCE_ID, PARENT_ID, CONVERSATION_ID, COMPOSITE_DN, PROTOCOL_CORRELATION_ID, REFERENCE_NAME, BINDING_TYPE, OPERATION_NAME, STATE, ADDITIONAL_PROPERTIES, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, CPST_PARTITION_DATE, TENANT_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME FROM E$REFERENCE_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW REJECTED_MESSAGE
 AS SELECT ECID, PARENT_ID, ID, COMPOSITE_DN, BATCH_ID, CREATED_TIME, SERVICE_NAME, BINDING_TYPE, PROTOCOL_MESSAGE_ID, PROTOCOL_CORRELATION_ID, ERROR_CATEGORY, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, RETRY_COUNT, MESSAGE_ORIGIN_REFERENCE, ADDITIONAL_PROPERTIES, TENANT_ID, FLOW_ID FROM E$REJECTED_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW REJECTED_MSG_NATIVE_PAYLOAD
 AS SELECT ID, ENCODING, PAYLOAD, RM_PARTITION_DATE, TENANT_ID FROM E$REJECTED_MSG_NATIVE_PAYLOAD;

CREATE OR REPLACE EDITIONING VIEW SENSOR_SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$SENSOR_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW SEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT FROM E$SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW TEST_INSTANCE
 AS SELECT TEST_RUN_NAME, TEST_RUN_ID, COMPOSITE_ID, COMPONENT_ID, STATUS, TEST_SUITE, TEST_CASE, OBJECT_NAME, OBJECT_TYPE, CREATION_DATE, UPDATE_DATE, VERSION, FLOW_ID, SCA_PARTITION_ID, RESULTS FROM E$TEST_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW xml_document
 AS SELECT document_id, document, document_binary_format, document_type, doc_partition_date FROM E$xml_document;

CREATE OR REPLACE EDITIONING VIEW xml_document_ref
 AS SELECT document_id, composite_instance_id, component_instance_id, composite_dn, component_name FROM E$xml_document_ref;

CREATE OR REPLACE EDITIONING VIEW SCA_SEQUENCE
 AS SELECT RANGE_NAME, NEXT_RANGE FROM E$SCA_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW SCA_PARTITION
 AS SELECT ID, NAME FROM E$SCA_PARTITION;

CREATE OR REPLACE EDITIONING VIEW SCA_ENTITY
 AS SELECT ID, SCA_PARTITION_ID, COMPOSITE, REVISION, LABEL, NAME, TYPE, SUB_TYPE, STATE, PROPERTIES FROM E$SCA_ENTITY;

CREATE OR REPLACE EDITIONING VIEW SCA_FLOW_INSTANCE
 AS SELECT FLOW_ID, FLOW_CORRELATION_ID, ECID, CONVERSATION_ID, TITLE, COMPOSITE_SCA_ENTITY_ID, SCA_PARTITION_ID, ACTIVE_COMPONENT_INSTANCES, UNHANDLED_FAULTS, RECOVERABLE_FAULTS, ADMIN_STATE, PURGEABLE, RESEQUENCER, PROPERTIES, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, TENANT_ID, TEST_RUN_NAME, TEST_RUN_ID, TEST_SUITE, TEST_CASE, VERSION FROM E$SCA_FLOW_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW SCA_FLOW_TO_CPST
 AS SELECT COMPOSITE_ID, FLOW_ID, TITLE, COMPOSITE_SCA_ENTITY_ID, CREATED_TIME, UPDATED_TIME, ACTIVE_COMPONENT_INSTANCES, ADMIN_STATE, PARTITION_DATE, SCA_PARTITION_ID, TENANT_ID, VERSION FROM E$SCA_FLOW_TO_CPST;

CREATE OR REPLACE EDITIONING VIEW SCA_ASYNC_CPNT_STATE
 AS SELECT FLOW_ID, CIKEY, PARTIAL_EXECUTIONS, STATE, COMPLETED_EXECUTIONS, VERSION, COMPOSITE_SCA_ENTITY_ID, COMPONENT_SCA_ENTITY_ID, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_ASYNC_CPNT_STATE;

CREATE OR REPLACE EDITIONING VIEW SCA_COMMON_FAULT
 AS SELECT ID, RETRY_COUNT, FLOW_ID, FLOW_CORRELATION_ID, BUS_EVENT_ID, COMPONENT_TYPE, COMPONENT_FAULT_KEY, SCA_ENTITY_ID, COMPOSITE_ID, COMPOSITE_SCA_ENTITY_ID, CIKEY, OWNER_CIKEY, OWNER_SCA_ENTITY_ID, OWNER_COMPONENT_TYPE, OWNER_COMPOSITE_SCA_ENTITY_ID, FAULT_NAME, FAULT_TYPE, JNDI_LOCATION, TARGET_HOST, WORKLIST_ROLE, ERROR_CODE, ERROR_MESSAGE, ENRICHED_MESSAGE, EXCEPTION_TRACE, ADDITIONAL_PROPERTIES, STATE, FLEX_FIELD_1, FLEX_FIELD_2, FLEX_FIELD_3, FLEX_FIELD_4, FLEX_FIELD_5, FLEX_FIELD_6, NATIVE_ID, TENANT_ID, CREATION_DATE, MODIFY_DATE, STATE_CHANGE_DATE, PARTITION_DATE, SCA_PARTITION_ID, OWNER_SCA_PARTITION_ID, VERSION, EVENT_NAME, SRM_NAMESPACE, INTERNAL_ID, RES_SCA_ENTITY_ID, LOCATION, FLOW_CODE, FLOW_VERSION, RES_OPERATION_NAME, RES_EVENT_SUB_ID FROM E$SCA_COMMON_FAULT;

CREATE OR REPLACE EDITIONING VIEW SCA_FLOW_ASSOC
 AS SELECT OWNER_FLOW_ID, CORRELATED_FLOW_ID, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_FLOW_ASSOC;

CREATE OR REPLACE EDITIONING VIEW SCA_META_DATA
 AS SELECT FLOW_ID, INTERNAL_ID, CIKEY, PARTITION_DATE, SCA_PARTITION_ID, DATA_CATEGORY, META_DATA FROM E$SCA_META_DATA;

CREATE OR REPLACE EDITIONING VIEW FAULT_NOTIFICATION_RULE
 AS SELECT RULEID, RULE_NAME, FAULT_RULE, RULE_SUBSCRIPTION, RULE_DESCRIPTION, SCA_PARTITION_ID, RULE_PAUSED, THRESHOLD_COUNT, THRESHOLD_DURATION_IN_HRS, SCHEDULE_PKG_NAME, SCHEDULE_NAME, CREATION_DATE, MODIFY_DATE FROM E$FAULT_NOTIFICATION_RULE;

CREATE OR REPLACE EDITIONING VIEW FAULT_ALERT
 AS SELECT RULEID, RULE_NAME, FAULT_COUNT, SCA_PARTITION_ID, CREATION_DATE, QUERY_URL FROM E$FAULT_ALERT;

CREATE OR REPLACE EDITIONING VIEW BULK_RECOVERY_JOB
 AS SELECT JOB_ID, ESS_PARENT_ID, DESCRIPTION, SUCCEEDED_COUNT, FAILED_COUNT, TOTAL_COUNT, STATE, QUERY_URL, SCA_PARTITION_ID, START_DATE, CREATION_DATE, MODIFIED_DATE, LAST_PROCESSED_INSTANCE_DATE FROM E$BULK_RECOVERY_JOB;

CREATE OR REPLACE EDITIONING VIEW SCA_REJECTED_MESSAGE
 AS SELECT ECID, SRM_ID, FLOW_ID, BATCH_ID, CREATED_TIME, SERVICE_NAME, BINDING_TYPE, PROTOCOL_MESSAGE_ID, PROTOCOL_CORRELATION_ID, ERROR_CATEGORY, ERROR_CODE, ERROR_MESSAGE, STACK_TRACE, RETRY_COUNT, MESSAGE_ORIGIN_REFERENCE, ADDITIONAL_PROPERTIES, TENANT_ID, NAMESPACE, LOCAL_NAME, SRM_EDN_TARGET, SRM_STATE, MSG_ENCODING, MSG_PAYLOAD, PAYLOAD_TYPE, PARTITION_DATE, SCA_PARTITION_ID, TRACKING_CONTEXT_PROPERTIES, RESUBMIT_PORT_TYPE, RESUBMIT_OP, SRM_VERSION, ISXA, UPGRADED FROM E$SCA_REJECTED_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW SCA_ATTACHMENT_REF
 AS SELECT SCA_ATT_KEY, FLOW_ID, CMPNNT_INST_ID, SCA_ENTITY_ID, COMPOSITE_SCA_ENTITY_ID, ECID, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_ATTACHMENT_REF;

CREATE OR REPLACE EDITIONING VIEW UPGRADE_CURRENT_SEQUENCE
 AS SELECT RANGE_NAME, CURRENT_RANGE_LOWER, CURRENT_RANGE_UPPER FROM E$UPGRADE_CURRENT_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW RESLNCY_FAILURE_EP
 AS SELECT SCA_ENTITY_ID, FAULT_RATE, FAULT_WINDOW, HSTRY_EP_ID FROM E$RESLNCY_FAILURE_EP;

CREATE OR REPLACE EDITIONING VIEW RESLNCY_SUSPEND_SVC
 AS SELECT SCA_ENTITY_ID, OPERATION_NAME, EVENT_SUB_ID, EP_ENTITY_ID, SERVICE_TYPE, RETRY_INTERVAL, SUSPEND_TIME FROM E$RESLNCY_SUSPEND_SVC;

CREATE OR REPLACE EDITIONING VIEW RESLNCY_SUSPEND_SVC_HSTRY
 AS SELECT SCA_ENTITY_ID, OPERATION_NAME, EVENT_SUB_ID, STATE, CREATION_DATE, EP_ID, SCA_EP_ENTITY_ID FROM E$RESLNCY_SUSPEND_SVC_HSTRY;

CREATE OR REPLACE EDITIONING VIEW RESLNCY_FAILURE_EP_HSTRY
 AS SELECT ID, SCA_ENTITY_ID, STATE, CREATION_DATE FROM E$RESLNCY_FAILURE_EP_HSTRY;

CREATE OR REPLACE EDITIONING VIEW RESLNCY_CONFIG
 AS SELECT PROP_NAME, PROP_VALUE FROM E$RESLNCY_CONFIG;

CREATE OR REPLACE EDITIONING VIEW AWR_SERVER_NODE
 AS SELECT ID, SOA_SERVER_NAME, CLUSTER_ID, DOMAIN, PLATFORM, SOA_HOST, SOA_CPU, SOA_CORE, SOA_SOCKETS, DB_SERVER_NAME, DB_PLATFORM, DB_HOST, DB_CPU, DB_CORE, DB_SOCKETS FROM E$AWR_SERVER_NODE;

CREATE OR REPLACE EDITIONING VIEW AWR_CONFIGURATION
 AS SELECT CONFIG_ID, NODE_ID, RUNTIME_TYPE, COMPONENT_TYPE, UPDATED_TIME, VALUE1, VALUE2, VALUE3, VALUE4 FROM E$AWR_CONFIGURATION;

CREATE OR REPLACE EDITIONING VIEW AWR_COMPOSITE
 AS SELECT ID, NAME, REVISION, LABEL, PARTITION FROM E$AWR_COMPOSITE;

CREATE OR REPLACE EDITIONING VIEW AWR_COMPONENT
 AS SELECT ID, COMPOSITE_ID, NAME, IMPLEMENTATION, BACKLOG_TYPE FROM E$AWR_COMPONENT;

CREATE OR REPLACE EDITIONING VIEW AWR_ENDPOINT
 AS SELECT ID, COMPOSITE_ID, TYPE, WIRE_TYPE, NAME, IMPLEMENTATION FROM E$AWR_ENDPOINT;

CREATE OR REPLACE EDITIONING VIEW AWR_ACTIVITY
 AS SELECT ID, COMPOSITE_ELEMENT_ID, TYPE, NAME, LINE_NUM, ACTIVITY_LEVEL FROM E$AWR_ACTIVITY;

CREATE OR REPLACE EDITIONING VIEW AWR_SYSTEM_RESOURCES
 AS SELECT ID, NAME, TYPE FROM E$AWR_SYSTEM_RESOURCES;

CREATE OR REPLACE EDITIONING VIEW AWR_SNAPSHOT
 AS SELECT ID, NODE_ID, TIMESTAMP, STATISTICS_LEVEL, SERVER_INSTANCE_ID FROM E$AWR_SNAPSHOT;

CREATE OR REPLACE EDITIONING VIEW AWR_RESOURCE_UTIL_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, RESOURCE_ID, COUNT_CUMM, VALUE1_MIN, VALUE1_MAX, VALUE1_CUMM, VALUE1_SQ_CUMM, VALUE2_MIN, VALUE2_MAX, VALUE2_CUMM, VALUE2_SQ_CUMM FROM E$AWR_RESOURCE_UTIL_METRIC;

CREATE OR REPLACE EDITIONING VIEW AWR_FLOW_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, ENDPOINT_ID, COUNT_CUMM, LATENCY_MIN, LATENCY_MAX, LATENCY_CUMM, LATENCY_SQ_CUMM, FAULT_COUNT_CUMM, RUNNING_TIME_CUMM FROM E$AWR_FLOW_METRIC;

CREATE OR REPLACE EDITIONING VIEW AWR_EXECUTION_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, COMPOSITE_ELEMENT_ID, START_COUNT_CUMM, DEHYDRATED_COUNT_CUMM, REHYDRATED_COUNT_CUMM, COMPLETED_COUNT_CUMM, FAULTED_COUNT_CUMM, EXEC_TIME_MIN, EXEC_TIME_MAX, EXEC_TIME_CUMM, EXEC_TIME_SQ_CUMM, DEHYDRATED_TIME_MIN, DEHYDRATED_TIME_MAX, DEHYDRATED_TIME_CUMM, DEHYDRATED_TIME_SQ_CUMM, CALLBACK_PROCESSING_TIME_MIN, CALLBACK_PROCESSING_TIME_MAX, CALLBACK_PROCESSING_TIME_CUMM, CALLBACK_PROCESS_TIME_SQ_CUMM FROM E$AWR_EXECUTION_METRIC;

CREATE OR REPLACE EDITIONING VIEW AWR_BACKUP_METRIC
 AS SELECT SNAPSHOT_ID, NODE_ID, COMPOSITE_ELEMENT_ID, DEPTH_AT_SERVER_START, ADDED_COUNT_CUMM, REMOVED_COUNT_CUMM, CLOSED_COUNT_CUMM, FAULTED_COUNT_CUMM, DEPTH_AT_SNAPSHOT_END FROM E$AWR_BACKUP_METRIC;

CREATE OR REPLACE EDITIONING VIEW REP_BUS_EVENT
 AS SELECT BUS_EVENT_ID, FLOW_ID, FLOW_CORRELATION_ID, PARENT_BUS_EVENT_ID, STATE, FLOW_TYPE, FLOW_NAME, FLOW_INST_NAME, FLEX_PROP_1, FLEX_PROP_2, FLEX_PROP_3, FLEX_PROP_4, FLOW_CODE, FLOW_VERSION, MLST_ID, AGGR_EVTS, ERROR_ID, APP_TYPE, APP_SUB_TYPE, RETRY_COUNT, PROCMON_TYPE, PROCMON_STATE, PROCMON_MODEL_ID, CREATION_DATE, PARTITION_DATE, VERSION FROM E$REP_BUS_EVENT;

CREATE OR REPLACE EDITIONING VIEW REP_FLOW_CORL
 AS SELECT PARENT_FLOW_CORRELATION_ID, CHILD_FLOW_CORRELATION_ID, PARENT_FLOW_ID, CHILD_FLOW_ID, PARTITION_DATE FROM E$REP_FLOW_CORL;

CREATE OR REPLACE EDITIONING VIEW REP_EVENT_PROP
 AS SELECT FLOW_CORRELATION_ID, FLOW_ID, BUS_EVENT_ID, KEY_NAME, VALUE, PARTITION_DATE FROM E$REP_EVENT_PROP;

CREATE OR REPLACE EDITIONING VIEW REP_PAYLOAD
 AS SELECT PAYLOAD_ID, PAYLOAD_NAME, FLOW_CORRELATION_ID, FLOW_ID, PAYLOAD_TYPE, PAYLOAD_ENCODING, PAYLOAD, PAYLOAD_CONTEXT, PARTITION_DATE FROM E$REP_PAYLOAD;

CREATE OR REPLACE EDITIONING VIEW REP_BUS_RECOVERY
 AS SELECT JOB_ID, ERROR_ID, FLOW_CORRELATION_ID, FLOW_ID, RECOVERY_STATE, COMPLETION_FLAG, CREATION_DATE, MODIFY_DATE FROM E$REP_BUS_RECOVERY;

CREATE OR REPLACE EDITIONING VIEW PMON_BIZ_MODEL
 AS SELECT BUSINESS_MODEL_ID, LC_JOB_ID, PMON_STATE, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, FLEX_FIELD1, FLEX_FIELD2, PMON_ML_STATE FROM E$PMON_BIZ_MODEL;

CREATE OR REPLACE EDITIONING VIEW PMON_BIZ_PROP
 AS SELECT BUSINESS_MODEL_ID, KEY_NAME, PMON_VALUE FROM E$PMON_BIZ_PROP;

CREATE OR REPLACE EDITIONING VIEW PMON_AUDIT
 AS SELECT AUDIT_ID, MODEL_ID, AGENT_ID, LC_JOB_ID, EVENT_SOURCE, EVENT_TYPE, EVENT_SUB_TYPE, EVENT_SEVERITY, CREATION_DATE, DESCRIPTION FROM E$PMON_AUDIT;

CREATE OR REPLACE EDITIONING VIEW PMON_AUDIT_INFO
 AS SELECT AUDIT_ID, DETAIL FROM E$PMON_AUDIT_INFO;

CREATE OR REPLACE EDITIONING VIEW PMON_REJECTED_MODEL
 AS SELECT PMON_REJECTED_MODEL_ID, LC_JOB_ID, MODEL_ID, START_TIME, END_TIME, SOURCE FROM E$PMON_REJECTED_MODEL;

CREATE OR REPLACE EDITIONING VIEW PMON_SEQUENCE
 AS SELECT RANGE_NAME, NEXT_RANGE FROM E$PMON_SEQUENCE;

CREATE OR REPLACE EDITIONING VIEW SOA_HEALTHCHECK_RESULT
 AS SELECT REQUEST_ID, HC_NAME, SERVER_NAME, STATE, START_TIME, END_TIME, RESULT, REQUEST_START_TIME FROM E$SOA_HEALTHCHECK_RESULT;

CREATE OR REPLACE EDITIONING VIEW PC_OWF
 AS SELECT OWF_DATASOURCE, OWF_ITEM_TYPE, OWF_ITEM_KEY, BPEL_DOMAIN, BPEL_PROCESS_ID, BPEL_REVISION_TAG, BPEL_PARTNER_LINK, BPEL_INSTANCE_ID FROM E$PC_OWF;

CREATE OR REPLACE EDITIONING VIEW PC_TASK
 AS SELECT TITLE, ISGROUP, ACQUIREDBY, OWNER, CONCLUSION, STATE, SUBSTATE, PROCESSID, PROCESSNAME, TASKID, VERSION, NOTM, TASKGROUPID, TASKTYPE, IDENTIFICATIONKEY, EXPIRATIONDURATION, EXPIRATIONDATE, PRIORITY, CREATOR, CREATEDDATE, UPDATEDBY, MODIFYDATE, FLEXSTRING1, FLEXSTRING2, FLEXSTRING3, FLEXSTRING4, FLEXLONG1, FLEXLONG2, FLEXDOUBLE1, FLEXDOUBLE2, FLEXDATE1, FLEXDATE2, FLEXDATE3, PROCESSVERSION, INSTANCEID, DOMAINID, APPROVERS, ISHASSUBTASK, COMMENT1, COMMENT2, COMMENT3, COMMENT4, COMMENT5, VERSIONREASON, PROCESSOWNER, PATTERN, SYSTEMSTRING1, SYSTEMSTRING2, SYSTEMSTRING3, TASKNUMBER FROM E$PC_TASK;

CREATE OR REPLACE EDITIONING VIEW PC_TASKASSIGNEE
 AS SELECT TASKID, VERSION, ASSIGNEE, GUID, ISGROUP FROM E$PC_TASKASSIGNEE;

CREATE OR REPLACE EDITIONING VIEW PC_TASKASSIGNEEHISTORY
 AS SELECT TASKID, VERSION, MAXVERSION, ASSIGNEE, GUID, ISGROUP FROM E$PC_TASKASSIGNEEHISTORY;

CREATE OR REPLACE EDITIONING VIEW PC_TASKATTACHMENT
 AS SELECT TASKID, VERSION, MAXVERSION, URI, CONTENT, NAME FROM E$PC_TASKATTACHMENT;

CREATE OR REPLACE EDITIONING VIEW PC_TASKHISTORY
 AS SELECT TITLE, ISGROUP, ACQUIREDBY, OWNER, CONCLUSION, STATE, SUBSTATE, PROCESSID, PROCESSNAME, TASKID, VERSION, NOTM, TASKGROUPID, TASKTYPE, IDENTIFICATIONKEY, EXPIRATIONDURATION, EXPIRATIONDATE, PRIORITY, CREATOR, CREATEDDATE, UPDATEDBY, MODIFYDATE, FLEXSTRING1, FLEXSTRING2, FLEXSTRING3, FLEXSTRING4, FLEXLONG1, FLEXLONG2, FLEXDOUBLE1, FLEXDOUBLE2, FLEXDATE1, FLEXDATE2, FLEXDATE3, PROCESSVERSION, INSTANCEID, DOMAINID, APPROVERS, ISHASSUBTASK, COMMENT1, COMMENT2, COMMENT3, COMMENT4, COMMENT5, VERSIONREASON, PROCESSOWNER, PATTERN, SYSTEMSTRING1, SYSTEMSTRING2, SYSTEMSTRING3, TASKNUMBER FROM E$PC_TASKHISTORY;

CREATE OR REPLACE EDITIONING VIEW PC_TASKPAYLOAD
 AS SELECT TASKID, VERSION, MAXVERSION, PAYLOADTYPE, PAYLOAD FROM E$PC_TASKPAYLOAD;

CREATE OR REPLACE EDITIONING VIEW BPELNotification
 AS SELECT id, destinationaddress, destinationtype, wftaskid, wftaskversion, wftaskaction, createdtime, status, attemptednumber, type, caller, outputmessage, channel_message_id, composite_dn, composite_instanceid, component_name, message FROM E$BPELNotification;

CREATE OR REPLACE EDITIONING VIEW BPELNotification_filtermsgs
 AS SELECT id, message_channel, channel_message_id, sender_address, received_address, received_date, filter_key, filter_reason, truncated_message, composite_dn, composite_instanceid, component_name FROM E$BPELNotification_filtermsgs;

CREATE OR REPLACE EDITIONING VIEW BPELNotification_invaladdrs
 AS SELECT id, destination_channel, destination_address, invalidated_time FROM E$BPELNotification_invaladdrs;

CREATE OR REPLACE EDITIONING VIEW BPM_BUSINESS_CONSTANT_OU_ASSOC
 AS SELECT ASSOCIATION_ID, APPLICATION_CONTEXT, ORGANIZATIONAL_UNIT_ID, BUSINESS_CONSTANT_ID, CONSTANT_VALUE, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_BUSINESS_CONSTANT_OU_ASS;

CREATE OR REPLACE EDITIONING VIEW BPM_BUSINESS_CONSTANT
 AS SELECT BUSINESS_CONSTANT_ID, BUSINESS_CONSTANT_NAME, BUSINESS_CONSTANT_TYPE, DEFAULT_VALUE, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_IDCTX FROM E$BPM_BUSINESS_CONSTANT;

CREATE OR REPLACE EDITIONING VIEW BPM_APP_ROLE_OU_CAL_ASSOC
 AS SELECT ID, APPLICATION_ROLE_NAME, IDENTITY_CONTEXT, APPLICATION_CONTEXT, ORGANIZATIONAL_UNIT_ID, CALENDAR_RULE_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_APP_ROLE_OU_CAL_ASSOC;

CREATE OR REPLACE EDITIONING VIEW BPM_CALENDAR_RULE
 AS SELECT ID, NAME, TIME_ZONE_ID, HOLIDAY_RULE_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_IDCTX FROM E$BPM_CALENDAR_RULE;

CREATE OR REPLACE EDITIONING VIEW BPM_CALENDAR_WORKDAY
 AS SELECT ID, CALENDAR_RULE_ID, WEEKDAY, START_TIME, END_TIME FROM E$BPM_CALENDAR_WORKDAY;

CREATE OR REPLACE EDITIONING VIEW BPM_FISCAL_YEAR
 AS SELECT FISCAL_YEAR_ID, FISCAL_YEAR_NAME, DISPLAY_NAME, NUMBER_OF_DIVISIONS, START_MONTH, START_DAY, END_MONTH, END_DAY, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_IDCTX FROM E$BPM_FISCAL_YEAR;

CREATE OR REPLACE EDITIONING VIEW BPM_FISCAL_YEAR_DIVISION
 AS SELECT DIVISION_ID, FISCAL_YEAR_ID, DIVISION_NAME, DIVISION_POSITION, DISPLAY_NAME, START_MONTH, START_DAY, END_MONTH, END_DAY FROM E$BPM_FISCAL_YEAR_DIVISION;

CREATE OR REPLACE EDITIONING VIEW BPM_EXT_USER_PROP_AVLBL_COL
 AS SELECT STRING_COL_NAME, DATE_COL_NAME, NUMBER_COL_NAME, GUID FROM E$BPM_EXT_USER_PROP_AVLBL_COL;

CREATE OR REPLACE EDITIONING VIEW BPM_EXT_USER_PROPERTY_GLOBAL
 AS SELECT GUID, PROPERTY_NAME, PROPERTY_STRING_VALUE, PROPERTY_DATA_TYPE, PROP_VALUE_COLUMN_NAME, CREATED_BY, CREATED_BY_IDCTX, CREATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDCTX, LAST_UPDATED_DATE, MULTI_VALUED_PROPERTY FROM E$BPM_EXT_USER_PROPERTY_GLOBAL;

CREATE OR REPLACE EDITIONING VIEW BPM_EXT_USER_PROPERTY_VALUE
 AS SELECT GUID, PARTICIPANT_ID, PARTICIPANT_TYPE, IDENTITY_CONTEXT, STR_COL0, STR_COL1, STR_COL2, STR_COL3, STR_COL4, STR_COL5, STR_COL6, STR_COL7, STR_COL8, STR_COL9, STR_COL10, STR_COL11, STR_COL12, STR_COL13, STR_COL14, STR_COL15, STR_COL16, STR_COL17, STR_COL18, STR_COL19, STR_COL20, STR_COL21, STR_COL22, STR_COL23, STR_COL24, STR_COL25, STR_COL26, STR_COL27, STR_COL28, STR_COL29, STR_COL30, STR_COL31, STR_COL32, STR_COL33, STR_COL34, STR_COL35, STR_COL36, STR_COL37, STR_COL38, STR_COL39, STR_COL40, STR_COL41, STR_COL42, STR_COL43, STR_COL44, STR_COL45, STR_COL46, STR_COL47, STR_COL48, STR_COL49, STR_COL50, STR_COL51, STR_COL52, STR_COL53, STR_COL54, STR_COL55, STR_COL56, STR_COL57, STR_COL58, STR_COL59, STR_COL60, STR_COL61, STR_COL62, STR_COL63, STR_COL64, STR_COL65, STR_COL66, STR_COL67, STR_COL68, STR_COL69, STR_COL70, STR_COL71, STR_COL72, STR_COL73, STR_COL74, STR_COL75, STR_COL76, STR_COL77, STR_COL78, STR_COL79, STR_COL80, STR_COL81, STR_COL82, STR_COL83, STR_COL84, STR_COL85, STR_COL86, STR_COL87, STR_COL88, STR_COL89, STR_COL90, STR_COL91, STR_COL92, STR_COL93, STR_COL94, STR_COL95, STR_COL96, STR_COL97, STR_COL98, STR_COL99, NUM_COL0, NUM_COL1, NUM_COL2, NUM_COL3, NUM_COL4, NUM_COL5, NUM_COL6, NUM_COL7, NUM_COL8, NUM_COL9, NUM_COL10, NUM_COL11, NUM_COL12, NUM_COL13, NUM_COL14, NUM_COL15, NUM_COL16, NUM_COL17, NUM_COL18, NUM_COL19, NUM_COL20, NUM_COL21, NUM_COL22, NUM_COL23, NUM_COL24, NUM_COL25, NUM_COL26, NUM_COL27, NUM_COL28, NUM_COL29, NUM_COL30, NUM_COL31, NUM_COL32, NUM_COL33, NUM_COL34, NUM_COL35, NUM_COL36, NUM_COL37, NUM_COL38, NUM_COL39, DATE_COL0, DATE_COL1, DATE_COL2, DATE_COL3, DATE_COL4, DATE_COL5, DATE_COL6, DATE_COL7, DATE_COL8, DATE_COL9, DATE_COL10, DATE_COL11, DATE_COL12, DATE_COL13, DATE_COL14, DATE_COL15, DATE_COL16, DATE_COL17, DATE_COL18, DATE_COL19, DATE_COL20, DATE_COL21, DATE_COL22, DATE_COL23, DATE_COL24, DATE_COL25, DATE_COL26, DATE_COL27, DATE_COL28, DATE_COL29, DATE_COL30, DATE_COL31, DATE_COL32, DATE_COL33, DATE_COL34, DATE_COL35, DATE_COL36, DATE_COL37, DATE_COL38, DATE_COL39, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_BY, LAST_UPDATED_DATE, LAST_UPDATED_BY_IDCTX FROM E$BPM_EXT_USER_PROPERTY_VALUE;

CREATE OR REPLACE EDITIONING VIEW BPM_HOLIDAY_RULE
 AS SELECT ID, NAME, CREATED_DATE, CREATED_BY, CREATED_BY_IDCTX, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDCTX FROM E$BPM_HOLIDAY_RULE;

CREATE OR REPLACE EDITIONING VIEW BPM_HOLIDAYS
 AS SELECT ID, NAME, HOLIDAY_PATTERN, HOLIDAY_RULE_ID, HOLIDAY_DATE, NTH, WEEK_DAY, MONTH, REF_HOLIDAY_NAME FROM E$BPM_HOLIDAYS;

CREATE OR REPLACE EDITIONING VIEW BPM_LOGICAL_PEOPLE_GROUP
 AS SELECT ID, NAME, DESCRIPTION, PEOPLE_QUERY, TIMEOUT, STATUS, EXPIRATION_TIME, LAST_EXECUTED_DATE, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT, ISPARAMETRIC FROM E$BPM_LOGICAL_PEOPLE_GROUP;

CREATE OR REPLACE EDITIONING VIEW BPM_LPG_MEMBER
 AS SELECT ID, QUERY_ID, USER_ID, IDENTITY_CONTEXT FROM E$BPM_LPG_MEMBER;

CREATE OR REPLACE EDITIONING VIEW BPM_ORGANIZATIONAL_UNIT
 AS SELECT ORGANIZATIONAL_UNIT_ID, PARENT_ORGANIZATIONAL_UNIT_ID, HIERARCHY_PATH, ORGANIZATIONAL_UNIT_NAME, DESCRIPTION, CALENDAR_RULE_ID, FISCAL_YEAR_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_ORGANIZATIONAL_UNIT;

CREATE OR REPLACE EDITIONING VIEW BPM_OU_MANAGER
 AS SELECT ID, ORGANIZATIONAL_UNIT_ID, USER_ID, USER_TYPE, IDENTITY_CONTEXT, APPLICATION_CONTEXT, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_OU_MANAGER;

CREATE OR REPLACE EDITIONING VIEW BPM_OU_USER
 AS SELECT ID, ORGANIZATIONAL_UNIT_ID, USER_ID, USER_TYPE, USER_TYPE_VALUE, IDENTITY_CONTEXT, APPLICATION_CONTEXT, PEOPLE_QUERY, LOGICAL_PEOPLE_QUERY_ID, CREATED_DATE, CREATED_BY, CREATED_BY_IDENTITY_CONTEXT, LAST_UPDATED_DATE, LAST_UPDATED_BY, LAST_UPDATED_BY_IDENCONTEXT FROM E$BPM_OU_USER;

CREATE OR REPLACE EDITIONING VIEW BPM_PP_ENTITY_GS_MAP
 AS SELECT ENTITY_ID, ENTITY_TYPE, GS_ID, ROWVERSION FROM E$BPM_PP_ENTITY_GS_MAP;

CREATE OR REPLACE EDITIONING VIEW BPM_PRESENTATION
 AS SELECT PRESENTATIONNAME, PRESENTATIONID, PRESENTATIONTYPE, PRESENTATIONOWNER, IDENTITYCONTEXT, DEFINITION, CREATEDDATE, UPDATEDDATE, CREATEDBY, UPDATEDBY FROM E$BPM_PRESENTATION;

CREATE OR REPLACE EDITIONING VIEW BPM_PRESENTATION_GRANT
 AS SELECT ID, PRESENTATIONID, GRANTEENAME, GRANTEETYPE, IDENTITYAPPCONTEXT FROM E$BPM_PRESENTATION_GRANT;

CREATE OR REPLACE EDITIONING VIEW BPM_USERAPPLICATIONDATA
 AS SELECT APPLICATIONDATAID, APPLICATIONDATANAME, APPLICATIONDATATYPE, OWNER, IDENTITYCONTEXT, CREATEDDATE, UPDATEDDATE, CREATEDBY, UPDATEDBY, APPLICATIONDATA FROM E$BPM_USERAPPLICATIONDATA;

CREATE OR REPLACE EDITIONING VIEW BPM_USERAPPLICATIONDATA_GRANT
 AS SELECT ID, APPLICATIONDATAID, GRANTEENAME, GRANTEETYPE, IDENTITYAPPCONTEXT FROM E$BPM_USERAPPLICATIONDATA_GRAN;

CREATE OR REPLACE EDITIONING VIEW DocumentDefinition
 AS SELECT id, name, description, packageDefinitionId, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentDefinition;

CREATE OR REPLACE EDITIONING VIEW DocumentInstance
 AS SELECT id, packageInstanceId, ucmId, ucmUrl, name, docType, status, updatedDate, updatedBy, createdDate, version, systemTextAttribute1, systemTextAttribute2, systemTextAttribute3, systemDateAttribute1, systemDateAttribute2, systemDateAttribute3, systemNumberAttribute1, systemNumberAttribute2, systemNumberAttribute3 FROM E$DocumentInstance;

CREATE OR REPLACE EDITIONING VIEW DocumentPackageDefinition
 AS SELECT id, name, description, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentPackageDefinition;

CREATE OR REPLACE EDITIONING VIEW DocumentPackageInstance
 AS SELECT id, name, status, packageDefinitionId, updatedDate, updatedBy, description, searchableTextCol1, searchableTextCol2, searchableTextCol3, searchableTextCol4, searchableTextCol5, searchableTextCol6, searchableDateCol1, searchableDateCol2, searchableDateCol3, searchableDateCol4, searchableNumberCol1, searchableNumberCol2, searchableNumberCol3, searchableNumberCol4, searchableNumberCol5, searchableNumberCol6, systemTextAttribute1, systemTextAttribute2, systemTextAttribute3, systemDateAttribute1, systemDateAttribute2, systemDateAttribute3, systemNumberAttribute1, systemNumberAttribute2, systemNumberAttribute3 FROM E$DocumentPackageInstance;

CREATE OR REPLACE EDITIONING VIEW DocumentPackageProcess
 AS SELECT processDefinitionId, packageDefinitionId, systemTextAttribute1, systemTextAttribute2, systemTextAttribute3 FROM E$DocumentPackageProcess;

CREATE OR REPLACE EDITIONING VIEW DocumentPackageProperties
 AS SELECT parentId, parentType, name, stringValue, dateValue, numValue, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentPackageProperties;

CREATE OR REPLACE EDITIONING VIEW DocumentPackagePropertiesMap
 AS SELECT propertyName, columnName, systemTextAttribute1, systemTextAttribute2 FROM E$DocumentPackagePropertiesMap;

CREATE OR REPLACE EDITIONING VIEW NotificationTracker
 AS SELECT id, componenttype, componentnumber, componentid, emailfromaddress, emailtoaddress, emailccaddress, emailsubject, emailattachmentnames, emailmessageid, emailinreplytoid, emailreferences, emailprocessedtime, composite_dn, composite_instanceid, component_name, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, emailcontent FROM E$NotificationTracker;

CREATE OR REPLACE EDITIONING VIEW NotifTrackerAttachments
 AS SELECT emailmessageid, attachmentname, emailprocessedtime, trackingid, attachmentcontent FROM E$NotifTrackerAttachments;

CREATE OR REPLACE EDITIONING VIEW WFApprovalGroupMembers
 AS SELECT approvalGroupId, member, type, sequence FROM E$WFApprovalGroupMembers;

CREATE OR REPLACE EDITIONING VIEW WFApprovalGroups
 AS SELECT approvalGroupId, approvalGroupName, javaClass, owner FROM E$WFApprovalGroups;

CREATE OR REPLACE EDITIONING VIEW WFAssignee
 AS SELECT taskId, version, assignee, guid, isGroup, assigneeType, taskCreatedDate, compositeCreatedTime, taskState, numberOfAssignments, FLOW_ID, SCA_PARTITION_ID FROM E$WFAssignee;

CREATE OR REPLACE EDITIONING VIEW WFAttachment
 AS SELECT taskId, version, maxVersion, updatedBy, updatedByDisplayName, updatedDate, encoding, uri, content, name, acl, taskCreatedDate, compositeCreatedTime, taskState, correlationId, attachmentSize, description, storageType, scope, FLOW_ID, SCA_PARTITION_ID FROM E$WFAttachment;

CREATE OR REPLACE EDITIONING VIEW WFAttributeLabelMap
 AS SELECT id, taskAttribute, labelName, createdDate, active, workflowType, dataType, updatedDate, description, formatStyle FROM E$WFAttributeLabelMap;

CREATE OR REPLACE EDITIONING VIEW WFAttributeLabelUsage
 AS SELECT mapId, workflowId, workflowName, attributeName, xpathExpression, xpathNamespaces, createdDate, description, componentType FROM E$WFAttributeLabelUsage;

CREATE OR REPLACE EDITIONING VIEW WFCertAuthority
 AS SELECT caName, caURL FROM E$WFCertAuthority;

CREATE OR REPLACE EDITIONING VIEW WFCertificate
 AS SELECT certificateNo, caName, userId, identityContext, certificate, revocationId FROM E$WFCertificate;

CREATE OR REPLACE EDITIONING VIEW WFCertificateRevoked
 AS SELECT revocationId, caName, validationMode, validationIssuedDate, nextValidationDate, validationData FROM E$WFCertificateRevoked;

CREATE OR REPLACE EDITIONING VIEW WFCollectionTarget
 AS SELECT taskId, id, xpath, DISPLAYNAME, collectionName, collectionNamespace, type, targetIndex, keyList, referencedTaskId, taskAggregationId, action, actionParams, version, maxVersion, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFCollectionTarget;

CREATE OR REPLACE EDITIONING VIEW WFComments
 AS SELECT taskId, version, updatedBy, updatedByDisplayName, commentDate, action, wfcomment, displayNameLanguage, acl, taskCreatedDate, compositeCreatedTime, taskState, scope, FLOW_ID, SCA_PARTITION_ID FROM E$WFComments;

CREATE OR REPLACE EDITIONING VIEW WFEvidence
 AS SELECT evidenceId, taskId, taskNumber, taskVersion, taskPriority, title, titleResourceKey, taskStatus, taskSubStatus, taskOutcome, userId, identityContext, workflowType, policy, certificateNo, caName, plainText, plainTextEncoding, signature, createDate, signedDate, verifiedDate, errorMessage, status, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFEvidence;

CREATE OR REPLACE EDITIONING VIEW WFHeaderProps
 AS SELECT taskId, properties, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFHeaderProps;

CREATE OR REPLACE EDITIONING VIEW WFMessageAttribute
 AS SELECT taskId, name, version, maxVersion, storageType, encoding, stringValue, numberValue, dateValue, blobValue, elementSeq, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFMessageAttribute;

CREATE OR REPLACE EDITIONING VIEW WFNotification
 AS SELECT notificationId, taskId, version, taskNumber, recipientUsers, recipientGroups, identityContext, domain, action, status, channel, noOfNotification, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFNotification;

CREATE OR REPLACE EDITIONING VIEW WFNotificationMessages
 AS SELECT taskId, taskVersion, action, status FROM E$WFNotificationMessages;

CREATE OR REPLACE EDITIONING VIEW WFNotificationStatus
 AS SELECT recipientUser, recipientGroup, identityContext, domain, status, channelAddress, channel FROM E$WFNotificationStatus;

CREATE OR REPLACE EDITIONING VIEW WFReviewer
 AS SELECT taskId, version, assignee, guid, assigneeType, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFReviewer;

CREATE OR REPLACE EDITIONING VIEW WFRoutingSlip
 AS SELECT taskId, taskNumber, routingSlip, noOfTimesModified, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFRoutingSlip;

CREATE OR REPLACE EDITIONING VIEW WFRuleDictionary
 AS SELECT dictionaryName, packageName, dictionary, encoding FROM E$WFRuleDictionary;

CREATE OR REPLACE EDITIONING VIEW WFTask
 AS SELECT acquiredBy, assignees, assigneesDisplayName, reviewers, reviewersDisplayName, assigneeGroups, assigneeGroupsDisplayName, assigneeUsers, assigneeUsersDisplayName, callbackContext, callbackId, callbackType, creator, digitalSignatureRequired, expirationDate, expirationDuration, identityContext, ownerUser, ownerGroup, passwordRequiredOnUpdate, priority, domainId, instanceId, processId, processName, processType, processVersion, secureNotifications, accessKey, approvalDuration, approvers, assignedDate, createdDate, elapsedTime, endDate, fromUser, fromUserDisplayName, hasSubtask, inShortHistory, isGroup, language, mailStatus, numberOfTimesModified, originalAssigneeUser, outcome, parallelOutcomeCount, pushbackSequence, state, subState, systemString1, systemString2, systemString3, taskGroupId, taskId, taskNumber, updatedBy, updatedByDisplayName, updatedDate, updatedNotificationId, version, versionReason, workflowPattern, textAttribute1, textAttribute2, textAttribute3, textAttribute4, textAttribute5, textAttribute6, textAttribute7, textAttribute8, textAttribute9, textAttribute10, formAttribute1, formAttribute2, formAttribute3, formAttribute4, formAttribute5, urlAttribute1, urlAttribute2, urlAttribute3, urlAttribute4, urlAttribute5, dateAttribute1, dateAttribute2, dateAttribute3, dateAttribute4, dateAttribute5, numberAttribute1, numberAttribute2, numberAttribute3, numberAttribute4, numberAttribute5, protectedTextAttribute1, protectedTextAttribute2, protectedTextAttribute3, protectedTextAttribute4, protectedTextAttribute5, protectedTextAttribute6, protectedTextAttribute7, protectedTextAttribute8, protectedTextAttribute9, protectedTextAttribute10, protectedFormAttribute1, protectedFormAttribute2, protectedFormAttribute3, protectedFormAttribute4, protectedFormAttribute5, protectedUrlAttribute1, protectedUrlAttribute2, protectedUrlAttribute3, protectedUrlAttribute4, protectedUrlAttribute5, protectedDateAttribute1, protectedDateAttribute2, protectedDateAttribute3, protectedDateAttribute4, protectedDateAttribute5, protectedNumberAttribute1, protectedNumberAttribute2, protectedNumberAttribute3, protectedNumberAttribute4, protectedNumberAttribute5, title, titleResourceKey, identificationKey, userComment, workflowDescriptorURI, taskDefinitionId, taskDefinitionName, applicationContext, applicationName, category, componentName, compositeDN, compositeInstanceId, compositeName, compositeVersion, conversationId, dueDate, ecid, isPublic, isTestTask, parentComponentInstanceId, parentComponentInstRefId, invokedComponent, participantName, percentageComplete, readByUsers, startDate, parentTaskVersion, taskGroupInstanceId, subTaskGroupInstanceId, ownerRole, taskNamespace, timers, agRootId, agMileStonePath, rootTaskId, parentTaskId, systemStringActions, taskDisplayUrl, documentPackageId, subCategory, correlationId, stage, assignmentContext, preActionUserSteps, aggregationTaskId, mdsLabel, isTemplateTask, componentType, activityName, activityId, processDueDate, thread, parentThread, step, vrcValues, organizationalUnitId, textAttribute11, textAttribute12, textAttribute13, textAttribute14, textAttribute15, textAttribute16, textAttribute17, textAttribute18, textAttribute19, textAttribute20, formAttribute6, formAttribute7, formAttribute8, formAttribute9, formAttribute10, urlAttribute6, urlAttribute7, urlAttribute8, urlAttribute9, urlAttribute10, dateAttribute6, dateAttribute7, dateAttribute8, dateAttribute9, dateAttribute10, numberAttribute6, numberAttribute7, numberAttribute8, numberAttribute9, numberAttribute10, protectedTextAttribute11, protectedTextAttribute12, protectedTextAttribute13, protectedTextAttribute14, protectedTextAttribute15, protectedTextAttribute16, protectedTextAttribute17, protectedTextAttribute18, protectedTextAttribute19, protectedTextAttribute20, protectedFormAttribute6, protectedFormAttribute7, protectedFormAttribute8, protectedFormAttribute9, protectedFormAttribute10, protectedUrlAttribute6, protectedUrlAttribute7, protectedUrlAttribute8, protectedUrlAttribute9, protectedUrlAttribute10, protectedDateAttribute6, protectedDateAttribute7, protectedDateAttribute8, protectedDateAttribute9, protectedDateAttribute10, protectedNumberAttribute6, protectedNumberAttribute7, protectedNumberAttribute8, protectedNumberAttribute9, protectedNumberAttribute10, compositeCreatedTime, tenantId, TENANT_ID, listBuilderId, caseId, swimlaneRole, excludedParticipants, customAttributeString1, customAttributeString2, customAttributeNumber1, customAttributeNumber2, customAttributeDate1, customAttributeDate2, timersSuspended, isDecomposedTask, formName, decomposedTaskGrpInstanceId, COMPONENT_INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, STARTTIME, STOPTIME, WORKINGDURATION, SHORTSUMMARY, LONGSUMMARY, ARCHIVEDON FROM E$WFTask;

CREATE OR REPLACE EDITIONING VIEW WFTask_TL
 AS SELECT taskId, version, locale, title, category, subCategory, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTask_TL;

CREATE OR REPLACE EDITIONING VIEW WFTaskAggregation
 AS SELECT rootTaskId, id, assignee, stage, aggregationType, collectionName, xpath, targetIndex, keyList, aggregationTaskId, action, actionParams, updatedBy, updatedDate, numberOfTimesModified, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskAggregation;

CREATE OR REPLACE EDITIONING VIEW WFTaskAssignmentStatistic
 AS SELECT statId, taskId, taskVersion, taskNumber, taskDefinitionId, applicationContext, identityContext, assignee, assigneeType, startAction, endAction, assignmentType, assignmentSubType, startDate, endDate, madeUpdate, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskAssignmentStatistic;

CREATE OR REPLACE EDITIONING VIEW WFTaskDisplay
 AS SELECT namespace, compositeVersion, uri, applicationName, hostName, httpPort, httpsPort, partitionName, formName FROM E$WFTaskDisplay;

CREATE OR REPLACE EDITIONING VIEW WFTaskError
 AS SELECT taskErrorId, taskId, taskNumber, taskVersion, ecid, componentName, compositeName, compositeDN, compositeVersion, compositeInstanceId, errorArgs, errorDate, errorId, errorStack, errorType, isRecoverable, taskDefinitionId, taskCreatedDate, taskState, compositeCreatedTime, errorMessage, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskError;

CREATE OR REPLACE EDITIONING VIEW WFTaskHistory
 AS SELECT acquiredBy, assignees, assigneesDisplayName, reviewers, reviewersDisplayName, assigneeGroups, assigneeGroupsDisplayName, assigneeUsers, assigneeUsersDisplayName, callbackContext, callbackId, callbackType, creator, digitalSignatureRequired, expirationDate, expirationDuration, identityContext, ownerUser, ownerGroup, passwordRequiredOnUpdate, priority, domainId, instanceId, processId, processName, processType, processVersion, secureNotifications, accessKey, approvalDuration, approvers, assignedDate, createdDate, elapsedTime, endDate, fromUser, fromUserDisplayName, hasSubtask, inShortHistory, isGroup, language, mailStatus, numberOfTimesModified, originalAssigneeUser, outcome, parallelOutcomeCount, pushbackSequence, state, subState, systemString1, systemString2, systemString3, taskGroupId, taskId, taskNumber, updatedBy, updatedByDisplayName, updatedDate, updatedNotificationId, version, versionReason, workflowPattern, textAttribute1, textAttribute2, textAttribute3, textAttribute4, textAttribute5, textAttribute6, textAttribute7, textAttribute8, textAttribute9, textAttribute10, formAttribute1, formAttribute2, formAttribute3, formAttribute4, formAttribute5, urlAttribute1, urlAttribute2, urlAttribute3, urlAttribute4, urlAttribute5, dateAttribute1, dateAttribute2, dateAttribute3, dateAttribute4, dateAttribute5, numberAttribute1, numberAttribute2, numberAttribute3, numberAttribute4, numberAttribute5, protectedTextAttribute1, protectedTextAttribute2, protectedTextAttribute3, protectedTextAttribute4, protectedTextAttribute5, protectedTextAttribute6, protectedTextAttribute7, protectedTextAttribute8, protectedTextAttribute9, protectedTextAttribute10, protectedFormAttribute1, protectedFormAttribute2, protectedFormAttribute3, protectedFormAttribute4, protectedFormAttribute5, protectedUrlAttribute1, protectedUrlAttribute2, protectedUrlAttribute3, protectedUrlAttribute4, protectedUrlAttribute5, protectedDateAttribute1, protectedDateAttribute2, protectedDateAttribute3, protectedDateAttribute4, protectedDateAttribute5, protectedNumberAttribute1, protectedNumberAttribute2, protectedNumberAttribute3, protectedNumberAttribute4, protectedNumberAttribute5, title, titleResourceKey, identificationKey, userComment, workflowDescriptorURI, taskDefinitionId, taskDefinitionName, applicationContext, applicationName, category, componentName, compositeDN, compositeInstanceId, compositeName, compositeVersion, conversationId, dueDate, ecid, isPublic, isTestTask, parentComponentInstanceId, parentComponentInstRefId, invokedComponent, participantName, percentageComplete, readByUsers, startDate, parentTaskVersion, taskGroupInstanceId, subTaskGroupInstanceId, ownerRole, taskNamespace, timers, agRootId, agMileStonePath, rootTaskId, parentTaskId, systemStringActions, taskDisplayUrl, documentPackageId, subCategory, correlationId, stage, assignmentContext, preActionUserSteps, aggregationTaskId, mdsLabel, isTemplateTask, componentType, activityName, activityId, processDueDate, thread, parentThread, step, vrcValues, organizationalUnitId, textAttribute11, textAttribute12, textAttribute13, textAttribute14, textAttribute15, textAttribute16, textAttribute17, textAttribute18, textAttribute19, textAttribute20, formAttribute6, formAttribute7, formAttribute8, formAttribute9, formAttribute10, urlAttribute6, urlAttribute7, urlAttribute8, urlAttribute9, urlAttribute10, dateAttribute6, dateAttribute7, dateAttribute8, dateAttribute9, dateAttribute10, numberAttribute6, numberAttribute7, numberAttribute8, numberAttribute9, numberAttribute10, protectedTextAttribute11, protectedTextAttribute12, protectedTextAttribute13, protectedTextAttribute14, protectedTextAttribute15, protectedTextAttribute16, protectedTextAttribute17, protectedTextAttribute18, protectedTextAttribute19, protectedTextAttribute20, protectedFormAttribute6, protectedFormAttribute7, protectedFormAttribute8, protectedFormAttribute9, protectedFormAttribute10, protectedUrlAttribute6, protectedUrlAttribute7, protectedUrlAttribute8, protectedUrlAttribute9, protectedUrlAttribute10, protectedDateAttribute6, protectedDateAttribute7, protectedDateAttribute8, protectedDateAttribute9, protectedDateAttribute10, protectedNumberAttribute6, protectedNumberAttribute7, protectedNumberAttribute8, protectedNumberAttribute9, protectedNumberAttribute10, compositeCreatedTime, tenantId, TENANT_ID, listBuilderId, caseId, swimlaneRole, excludedParticipants, customAttributeString1, customAttributeString2, customAttributeNumber1, customAttributeNumber2, customAttributeDate1, customAttributeDate2, timersSuspended, isDecomposedTask, formName, decomposedTaskGrpInstanceId, COMPONENT_INSTANCE_ID, FLOW_ID, SCA_PARTITION_ID, STARTTIME, STOPTIME, WORKINGDURATION, SHORTSUMMARY, LONGSUMMARY FROM E$WFTaskHistory;

CREATE OR REPLACE EDITIONING VIEW WFTaskHistory_TL
 AS SELECT taskId, version, locale, title, category, subCategory, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskHistory_TL;

CREATE OR REPLACE EDITIONING VIEW WFTaskMetadata
 AS SELECT id, uri, name, title, description, domainId, processName, processId, processVersion, componentName, compositeDN, compositeName, compositeVersion, applicationName, namespace, organizationalUnitId, descriptionKey, category FROM E$WFTaskMetadata;

CREATE OR REPLACE EDITIONING VIEW WFTaskSequenceChanges
 AS SELECT id, correlationId, anchorChain, changeType, anchorType, anchorAssignee, changeAssignee, responseType, updatedBy, updatedDate, seqnum, status, numberOfTimesModified FROM E$WFTaskSequenceChanges;

CREATE OR REPLACE EDITIONING VIEW WFTaskTimer
 AS SELECT id, taskId, jobName, jobDate, taskCreatedDate, compositeCreatedTime, taskState, FLOW_ID, SCA_PARTITION_ID FROM E$WFTaskTimer;

CREATE OR REPLACE EDITIONING VIEW WFUserPreference
 AS SELECT userName, identityContext, preferenceName, preferenceValue FROM E$WFUserPreference;

CREATE OR REPLACE EDITIONING VIEW WFUserTaskView
 AS SELECT viewName, viewId, viewType, viewOwner, identityContext, hidden, description, definition, createdDate, updatedDate, presentationId FROM E$WFUserTaskView;

CREATE OR REPLACE EDITIONING VIEW WFUserTaskViewGrant
 AS SELECT grantee, identityContext, viewId, grantedName, grantedDesc, hidden, grantType, granteeType FROM E$WFUserTaskViewGrant;

CREATE OR REPLACE EDITIONING VIEW WFUserVacation
 AS SELECT userId, identityContext, startDate, endDate FROM E$WFUserVacation;

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE
 AS SELECT NAME, QUEUE_TYPE, PRIORITY, TASK_TYPE, DISPLAY_NAME, DISPLAY_NAME_KEY, DESCRIPTION, DESCRIPTION_KEY, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, DEFINITION FROM E$WFWORKQUEUE;

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE_MEMBER
 AS SELECT WORKQUEUE_NAME, MEMBER_NAME, MEMBER_TYPE, APPLICATION_CONTEXT FROM E$WFWORKQUEUE_MEMBER;

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE_MANAGER
 AS SELECT WORKQUEUE_NAME, MANAGER_NAME, MANAGER_TYPE, APPLICATION_CONTEXT FROM E$WFWORKQUEUE_MANAGER;

CREATE OR REPLACE EDITIONING VIEW WFWORKQUEUE_SKIP
 AS SELECT WORKQUEUE_NAME, WORKITEM_ID, USERNAME, SKIP_DATE FROM E$WFWORKQUEUE_SKIP;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_AUDIT_DOCUMENT
 AS SELECT ID, AUDIT_ID, NAME, DOCUMENT, TYPE, PAYLOAD_KEY, INSTANCE_ID, CASE_ID, MI_PARTITION_DATE, TENANT_ID FROM E$MEDIATOR_AUDIT_DOCUMENT;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CALLBACK
 AS SELECT INSTANCE_ID, CALLBACK_OPERATION, SOURCE_CONVERSATION_ID, SOURCE_URI, REPLY_TO_ADDRESS, REPLY_TO_SERVICE, REPLY_TO_PORTTYPE, SERVICE_NAME, CREATION_DATE, REPLY_TO_REF_XML, FAULT_TO_REF_XML, WSA_VERSION, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$MEDIATOR_CALLBACK;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CASE_DETAIL
 AS SELECT INSTANCE_ID, CASE_ID, TRAIL_SEQ, STATE, AUDIT_TRAIL, CREATED_TIME, MI_PARTITION_DATE, TENANT_ID FROM E$MEDIATOR_CASE_DETAIL;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CASE_INSTANCE
 AS SELECT ID, INSTANCE_ID, CONVERSATION_ID, DEF_MESSAGE_ID, SYSTEM, CASE_NAME, TARGET_TYPE, TARGET_ACTION_NAME, TARGET_REFERENCE, CALLBACK_OPERATION, EXCEPTION_TYPE, SHORT_EXCEPTION_MSG, EXCEPTION_MSG, EXCEPTION_TRACE, FAULT_NAME, FAULT_OBJ, RETRY_COUNT, RETRY_INTERVAL, STEP, SOURCE_URI, RECOVERABLE, STATUS, LOCK_TIME, CONTAINER_ID, CREATED_TIME, MI_PARTITION_DATE, TENANT_ID, PROPERTIES FROM E$MEDIATOR_CASE_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$MEDIATOR_CONTAINERID_LEASE;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_CORRELATION
 AS SELECT CONVERSATION_ID, INSTANCE_ID, CASE_INSTANCE_ID, CALLBACK_OPERATION, CALLBACK_CASE, RESPONSE_COUNT, CREATION_DATE, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE FROM E$MEDIATOR_CORRELATION;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_DEFERRED_MESSAGE
 AS SELECT CASE_ID, COMPONENT_DN, QNAME_LOCAL_PART, QNAME_NAMESPACE, SOURCE_URI, OPERATION, MSG_ID, CASE_INFO, PRIORITY, INSTANCE_CREATED, STATUS, CREATION_DATE, LOCK_TIME, COMPONENT_STATUS, IS_EVENT, CONTAINER_ID, TENANT_ID, FLOW_ID, SCA_PARTITION_ID, MSG_RECEIVED_TIME, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_DEFERRED_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_INSTANCE
 AS SELECT ECID, COMPOSITE_INSTANCE_ID, ID, PARENT_ID, PARENT_REF_ID, CONVERSATION_ID, COMPONENT_NAME, OUTCOME, COMPONENT_STATE, SOURCE_TYPE, SOURCE_ACTION_NAME, CASE_NUM, COMPLETED_CASE_NUM, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, COMPOSITE_CREATION_DATE, COMPONENT_DN, COMPONENT_TYPE, RESEQUENCER_TYPE, GROUP_ID, TENANT_ID, FLOW_ID, CIKEY FROM E$MEDIATOR_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_PAYLOAD
 AS SELECT ID, OWNER_ID, NAME, TYPE, BIN, MODIFY_DATE, BIN_FORMAT, CREATION_TIME FROM E$MEDIATOR_PAYLOAD;

CREATE OR REPLACE EDITIONING VIEW MFT_SOURCE_MESSAGE
 AS SELECT ID, SOURCE_NAME, DATA_STORAGE_ID, SOURCE_ENDPOINT_REF, SOURCE_TYPE, SOURCE_REF_ID, FILE_NAME, TRANSFORMED_FILE_NAME, CONTENT_IDENTIFIER, FLOW_ID, CORRELATION_FLOW_ID, ECID, SENDER_USER_NAME, TRANSFER_METHOD, SOURCE_ID, SOURCE_LABEL, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, STATUS, SUB_STATUS, STATUS_DETAILS, SCHEDULE_DETAILS, ERROR_INFO_ID, SECURITY_INFO_ID, TRANSFORMED_DATA_STORAGE_ID, PRIORITY, TRIGGER_EVENT_SESSION_ID, PROP_VALUE1, PROP_VALUE2, PROP_VALUE3, PROP_VALUE4, PROP_VALUE5, MESSAGE_PROP_CLOB, TRANSPORT_CERTIFICATES_CLOB, TRANSPORT_HEADER_CLOB, MODIFIED_MESSAGE_PROP_CLOB, MODIFIED_TRANSPORT_HEADER_CLOB, CREATE_TS, LAST_MODIFY_TS, CPST_INST_CREATED_TIME, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_SOURCE_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW MFT_SECURITY_INFO
 AS SELECT ID, VERSION, ENCRYPTION_CERTIFICATE, ENCRYPTION_ALGORITHM, ENCRYPTION_PROTOCOL, SIGNING_CERTIFICATE, SIGNING_ALGORITHM, SIGNING_PROTOCOL, DIGEST_ALGORITHM, MESSAGE_DIGEST, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_SECURITY_INFO;

CREATE OR REPLACE EDITIONING VIEW MFT_RETRY_INFO
 AS SELECT ID, TARGET_MESSAGE_ID, CALLOUT_INSTANCE_ID, STATUS, COUNT, ESS_RETRY_JOB_ID, SCHEDULE_DETAILS, RETRIAL_INTERVAL, ERROR_INFO_ID, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_RETRY_INFO;

CREATE OR REPLACE EDITIONING VIEW MFT_RESUBMIT_INFO
 AS SELECT ID, TYPE, SOURCE_MESSAGE_ID, TARGET_MESSAGE_ID, INSTANCE_ID, TRANSFER_INSTANCE_ID, RESUBMITTED_ID, SCHEDULE_DETAILS, ESS_JOB_ID, USER_COMMENT, RESUBMITTED_BY, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_RESUBMIT_INFO;

CREATE OR REPLACE EDITIONING VIEW MFT_PAUSED_INSTANCE_INFO
 AS SELECT ID, TARGET_MESSAGE_ID, CURRENT_STATE, PAUSED_BY_USER, PAUSED_COMMENTS, PAUSED_ON, BYTES_TRASNFERRED, PERCENT_TRANSFERRED, RESUMED_BY_USER, RESUMED_COMMENTS, RESUMED_ON, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_PAUSED_INSTANCE_INFO;

CREATE OR REPLACE EDITIONING VIEW MFT_TARGET_INSTANCE
 AS SELECT ID, DATA_STORAGE_ID, TRANSFER_NAME, TARGET_NAME, STATUS, SUB_STATUS, PRIORITY, TRANSFER_INSTANCE_ID, SCHEDULE_DETAILS, INSTANCE_PROCESS_START_TIME, INSTANCE_PROCESS_END_TIME, TRANSFER_LABEL, TARGET_ID, TARGET_LABEL, TRANSFER_TARGET_ID, ERROR_INFO_ID, IS_MANUALLY_MODIFIED, MODIFIED_BY, LAST_CHANGE_COMMENTS, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, CPST_INST_CREATED_TIME, ESS_JOB_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_TARGET_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW MFT_ES_AUTHORIZATION
 AS SELECT ID, FILE_PATH, RESOURCE_ID, MFT_SOURCE_MESSAGE_ID, IS_DIRECTORY, UPLOADED_BY, CREATE_TS, CPST_INST_CREATED_TIME, LAST_MODIFY_TS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_ES_AUTHORIZATION;

CREATE OR REPLACE EDITIONING VIEW MFT_ERROR_INFO
 AS SELECT ID, ERROR_CODE, ERROR_LEVEL, ERROR_SEVERITY, ERROR_DESCRIPTION_CLOB, ERROR_TEXT_CLOB, INSTANCE_TYPE, INSTANCE_ID, CREATE_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_ERROR_INFO;

CREATE OR REPLACE EDITIONING VIEW MFT_DATA_STORAGE
 AS SELECT ID, CHECKSUM, PAYLOAD_REFERENCE, REFERENCE_TYPE, INTERNAL_FTP_REF, IS_DIRECTORY_REF, IS_PAYLOAD_DELTED, IS_ENCRYPTED, PAYLOAD, PAYLOAD_SIZE, CREATE_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_DATA_STORAGE;

CREATE OR REPLACE EDITIONING VIEW MFT_CALLOUT_INSTANCE
 AS SELECT ID, NAME, TYPE, INSTANCE_ID, SOURCE_MESSAGE_ID, STATUS, MODIFIED_FILE_NAME, MODIFIED_MESSAGE_PROP_CLOB, MODIFIED_TRANSPORT_HEADER_CLOB, CREATE_TS, TENANT_ID, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_CALLOUT_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW MFT_SOURCE_UNPROCESSED
 AS SELECT ID, SOURCE_NAME, SOURCE_ID, CONTENT_TYPE, DATA_STORAGE_ID, SOURCE_ENDPOINT_REF, SOURCE_TYPE, REASON, PRIORITY, MESSAGE_PROP_CLOB, TRANSPORT_CERTIFICATES_CLOB, TRANSPORT_HEADER_CLOB, OTHER_PROPERTIES, CREATE_TS, LAST_MODIFY_TS, CPST_INST_CREATED_TIME, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_SOURCE_UNPROCESSED;

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_INSTANCE
 AS SELECT ID, SOURCE_MESSAGE_ID, CONTENT_TYPE, STATUS, SUB_STATUS, STATUS_DETAILS, TRANSFER_INITIATION_TIME, TRANSFER_COMPLETION_TIME, TRANSFER_NAME, TRANSFER_ID, PRIORITY, CREATE_TS, LAST_MODIFY_TS, TENANT_ID, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, CPST_INST_CREATED_TIME, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_TRANSFER_INSTANCE;

CREATE OR REPLACE EDITIONING VIEW MFT_SOURCE_LIFECYCLE
 AS SELECT ID, NAME, URI, CATEGORY, BINDING_TYPE, IS_LISTENING, IS_DEPLOYED, IS_INCLUDE_SUBFOLDER, LABEL, VERSION, STATUS, START_ESS_JOB_ID, STOP_ESS_JOB_ID, START_SCHEDULE_REF, STOP_SCHEDULE_REF, IS_SCHEDULE_EXPIRED, OPSS_RESOURCE_NAME, CREATE_TS, LAST_MODIFY_TS, LAST_MODIFIED_BY, CREATED_BY, CREATE_COMMENTS, LAST_MODIFY_COMMENTS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_SOURCE_LIFECYCLE;

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_LIFECYCLE
 AS SELECT ID, NAME, SOURCE_ID, IS_DEPLOYED, LABEL, VERSION, STATUS, OPSS_RESOURCE_NAME, IS_FILTER_AVAILABLE, CREATE_TS, LAST_MODIFY_TS, LAST_MODIFIED_BY, CREATED_BY, CREATE_COMMENTS, LAST_MODIFY_COMMENTS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_TRANSFER_LIFECYCLE;

CREATE OR REPLACE EDITIONING VIEW MFT_TARGET_LIFECYCLE
 AS SELECT ID, NAME, CATEGORY, BINDING_TYPE, IS_DEPLOYED, LABEL, VERSION, STATUS, CREATE_TS, LAST_MODIFY_TS, LAST_MODIFIED_BY, CREATED_BY, CREATE_COMMENTS, LAST_MODIFY_COMMENTS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_TARGET_LIFECYCLE;

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_TARGET_REL
 AS SELECT TRANSFER_ID, TRANSFER_LABEL, TARGET_ID FROM E$MFT_TRANSFER_TARGET_REL;

CREATE OR REPLACE EDITIONING VIEW MFT_TRANSFER_SCHEDULE
 AS SELECT TRANSFER_ID, TRANSFER_LABEL, TARGET_ID, START_ESS_JOB_ID, STOP_ESS_JOB_ID, START_SCHEDULE_REF, STOP_SCHEDULE_REF, IS_SCHEDULE_EXPIRED, WS_REF_DELIVERY_TYPE, ESS_JOB_ID FROM E$MFT_TRANSFER_SCHEDULE;

CREATE OR REPLACE EDITIONING VIEW MFT_TARGET_MESSAGE
 AS SELECT ID, INSTANCE_ID, DATA_STORAGE_ID, TARGET_NAME, ENDPOINT_REFERENCE, PROTOCOL, FILE_NAME, DELIVERED_FILE_NAME, IS_REF_DELIVERY, FLOW_ID, CORRELATION_FLOW_ID, ECID, TARGET_REF_ID, TARGET_LABEL, TRANSFER_START_TIME, TRANSFER_COMPLETED_TIME, BYTES_TRANSFERRED, TIME_TAKEN, ERROR_INFO_ID, RESUBMIT_CORRELATION_ID, RESUBMITTED_COUNT, RECENT_RESUBMIT_STATUS, SECURITY_INFO_ID, STATUS, DELIVERY_STATUS, SENDER_USER_NAME, PRIORITY, INITIAL_FILE_SIZE, MESSAGE_PROP_CLOB, TRANSPORT_HEADER_CLOB, LAST_MODIFY_TS, CREATE_TS, CPST_INST_CREATED_TIME, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2, ATTRIBUTE3, ATTRIBUTE4 FROM E$MFT_TARGET_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW MFT_ES_PORT_ASSIGNMENT
 AS SELECT SERVER_INSTANCE, SERVICE, CONFIGURED_PORT, RUNNING_PORT, STATUS, MODIFIED_BY FROM E$MFT_ES_PORT_ASSIGNMENT;

CREATE OR REPLACE EDITIONING VIEW MFT_RCU_PURGE
 AS SELECT BATCH_ID, PURGE_CRITERIA, PURGE_STATUS, TOTAL_PURGE_COUNT, RCU_PURGE_ERROR_COUNT, FS_PURGE_DONE_COUNT, FS_PURGE_ERROR_COUNT, THREAD_COUNT, USER_COMMENTS, CREATED_BY, CREATE_TS FROM E$MFT_RCU_PURGE;

CREATE OR REPLACE EDITIONING VIEW MFT_TRIGGER_EVENT
 AS SELECT ID, SOURCE_NAME, STATUS, COMMENTS, SUBMITTED_BY, SUBMITTED_TS, SERVER_INSTANCE, PROP_CLOB, LAST_MODIFY_TS, TENANT_ID, ATTRIBUTE1, ATTRIBUTE2 FROM E$MFT_TRIGGER_EVENT;

CREATE OR REPLACE EDITIONING VIEW MFT_SCHEDULE_PURGE
 AS SELECT ID, NAME, IS_ACTIVE, LAST_ACTIVATED_TS, LAST_ACTIVATED_BY, ESS_JOB_ID, LAST_EXECUTION_TS, LAST_PURGE_BATCH_ID, LAST_PURGE_EXECUTION_RESULT, ATTRIBUTE1 FROM E$MFT_SCHEDULE_PURGE;

CREATE OR REPLACE EDITIONING VIEW WLI_QS_REPORT_ATTRIBUTE
 AS SELECT MSG_GUID, DB_TIMESTAMP, LOCALHOST_TIMESTAMP, HOST_NAME, STATE, NODE, PIPELINE_NAME, STAGE_NAME, INBOUND_SERVICE_NAME, INBOUND_SERVICE_URI, INBOUND_OPERATION, OUTBOUND_SERVICE_NAME, OUTBOUND_SERVICE_URI, OUTBOUND_OPERATION, MSG_LABELS, ERROR_CODE, ERROR_REASON, ERROR_DETAILS FROM E$WLI_QS_REPORT_ATTRIBUTE;

CREATE OR REPLACE EDITIONING VIEW WLI_QS_REPORT_DATA
 AS SELECT MSG_GUID, DATA_TYPE, ENCODING, DATA_VALUE FROM E$WLI_QS_REPORT_DATA;

CREATE OR REPLACE EDITIONING VIEW OSB_MSG
 AS SELECT MSG_ID, MSG_TYPE, CREATION_TIME, MODIFY_TIME, MSG_BIN, DUMMY1, DUMMY2, DUMMY3 FROM E$OSB_MSG;

CREATE OR REPLACE EDITIONING VIEW RM_SEQUENCES
 AS SELECT ENDPOINT_UID, ID, TYPE, EXP_TIME, BOUND_ID, STR_ID, STATUS, ACK_REQUESTED_FLAG, LAST_MESSAGE_NUMBER, LAST_ACTIVITY_TIME, LAST_ACK_REQUEST_TIME FROM E$RM_SEQUENCES;

CREATE OR REPLACE EDITIONING VIEW RM_UNACKED_MESSAGES
 AS SELECT ENDPOINT_UID, SEQ_ID, MSG_NUMBER, IS_RECEIVED, CORRELATION_ID, NEXT_RESEND_COUNT, WSA_ACTION, MSG_DATA FROM E$RM_UNACKED_MESSAGES;

CREATE OR REPLACE EDITIONING VIEW RM_LOCALIDS
 AS SELECT LOCAL_ID, SEQ_ID, MSG_NUMBER, CREATE_TIME, SEQ_TERMINATE_TIME FROM E$RM_LOCALIDS;

CREATE OR REPLACE EDITIONING VIEW BRDECISIONFAULT
 AS SELECT INSTANCE_ID, SEQ_ID, CREATION_TIME, UOW_STEP, FAULT_TYPE, QNAME, RECOVERY_LEVEL, MESSAGE, TENANT_ID FROM E$BRDECISIONFAULT;

CREATE OR REPLACE EDITIONING VIEW BRDECISIONINSTANCE
 AS SELECT ID, COMPONENT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_CREATION_DATE, ECID, COMPOSITE_INSTANCE_ID, PARENT_ID, APPLICATION_NAME, COMPOSITE_NAME, REVISION, LABEL, COMPONENT_DN, COMPONENT_NAME, STATE, COMPONENT_VERSION, COMPONENT_STATE, CREATED_BY, CREATION_TIME, UPDATED_BY, UPDATED_TIME, PROCESSING_TIME, OUTCOME, RPI_CATALOG, RPI_CATALOG_VERSION, RPI_RULESET_CSV, RPI_RULESET_VERSION_CSV, RPI_FLEX1, RPI_FLEX2, RPI_FLEX3, RPI_FLEX4, PARENT_REF_ID, DECISION_TRACE, TENANT_ID, CPST_INST_CREATED_TIME FROM E$BRDECISIONINSTANCE;

CREATE OR REPLACE EDITIONING VIEW BRDECISIONUNITOFWORK
 AS SELECT INSTANCE_ID, UOW_STEP, CREATION_TIME, UOW_STATE, UOW_CLASSIFIER, UOW_DATA, PROCESSING_TIME, UOW_RETURN_CODE, MESSAGE, TENANT_ID FROM E$BRDECISIONUNITOFWORK;

CREATE OR REPLACE EDITIONING VIEW BRSEQUENCE
 AS SELECT SEQ_NAME, SEQ_COUNT, TENANT_ID FROM E$BRSEQUENCE;

CREATE OR REPLACE EDITIONING VIEW ACTIVITY_SENSOR_VALUES
 AS SELECT ID, PROCESS_INSTANCE_ID, SENSOR_NAME, SENSOR_TARGET, ACTION_NAME, ACTION_FILTER, CREATION_DATE, MODIFY_DATE, TS_HOUR, CRITERIA_SATISFIED, ACTIVITY_NAME, ACTIVITY_TYPE, ACTIVITY_STATE, EVAL_POINT, ERROR_MESSAGE, RETRY_COUNT, EVAL_TIME FROM E$ACTIVITY_SENSOR_VALUES;

CREATE OR REPLACE EDITIONING VIEW COMPOSITE_SENSOR_VALUE
 AS SELECT COMPOSITE_INSTANCE_ID, COMPONENT_INSTANCE_ID, COMPONENT_NAME, ACTION_PERFORMED, SENSOR_NAME, SENSOR_TYPE, CRITERIA_SATISFIED, VALUE_TYPE, CPST_PARTITION_DATE, STRING_VALUE, NUMBER_VALUE, DATE_VALUE, CLOB_VALUE, BLOB_VALUE FROM E$COMPOSITE_SENSOR_VALUE;

CREATE OR REPLACE EDITIONING VIEW FAULT_SENSOR_VALUES
 AS SELECT ID, PROCESS_INSTANCE_ID, SENSOR_NAME, SENSOR_TARGET, ACTION_NAME, ACTION_FILTER, CREATION_DATE, MODIFY_DATE, TS_HOUR, CRITERIA_SATISFIED, ACTIVITY_NAME, ACTIVITY_TYPE, MESSAGE FROM E$FAULT_SENSOR_VALUES;

CREATE OR REPLACE EDITIONING VIEW VARIABLE_SENSOR_VALUES
 AS SELECT ID, PROCESS_INSTANCE_ID, SENSOR_NAME, SENSOR_TARGET, ACTION_NAME, ACTION_FILTER, ACTIVITY_SENSOR_ID, CREATION_DATE, MODIFY_DATE, TS_HOUR, VARIABLE_NAME, EVAL_POINT, CRITERIA_SATISFIED, TARGET, SCHEMA_NAMESPACE, SCHEMA_DATATYPE, UPDATER_NAME, UPDATER_TYPE, VALUE_TYPE, VARCHAR2_VALUE, NUMBER_VALUE, DATE_VALUE, DATE_VALUE_TZ, BLOB_VALUE, CLOB_VALUE FROM E$VARIABLE_SENSOR_VALUES;

CREATE OR REPLACE EDITIONING VIEW SCA_SENSOR_VALUE
 AS SELECT FLOW_ID, CIKEY, SCA_ENTITY_ID, COMPOSITE_ID, COMPOSITE_SCA_ENTITY_ID, COMPONENT_NAME, ACTION_PERFORMED, SENSOR_NAME, SENSOR_TYPE, CRITERIA_SATISFIED, VALUE_TYPE, STRING_VALUE, NUMBER_VALUE, DATE_VALUE, CLOB_VALUE, BLOB_VALUE, PARTITION_DATE, SCA_PARTITION_ID FROM E$SCA_SENSOR_VALUE;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_GROUP_STATUS
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, SUPPORT_BATCHING, LOCK_TIME_1, START_SEQUENCE_ID, LAST_SEQUENCE_ID, NEXT_SEQUENCE_ID, CREATION_DATE, LAST_RECEIVED_TIME, STATUS, SEQUENCING_LEVEL, CONTAINER_ID, LOCK_TIME, RESEQUENCER_TYPE, TIMEOUT_DURATION, COMPONENT_STATUS, TENANT_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_GROUP_STATUS;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_RESEQUENCER_MESSAGE
 AS SELECT ID, OWNER_ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, PROPERTY1, PROPERTY2, PROPERTY3, SEQUENCE_ID, CONTAINER_ID, CREATION_DATE, MI_PARTITION_DATE, PROCESS_DATE, IS_EVENT, QNAME_LOCAL_PART, QNAME_NAMESPACE, LOCK_TIME, NEXT_SEQUENCE_ID, PRIORITY, SOURCE_URI, STANDARD_SEQUENCE_ID, STATUS, INSTANCE_CREATED, TENANT_ID, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_RESEQUENCER_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW OSB_GROUP_STATUS
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, SUPPORT_BATCHING, LOCK_TIME_1, START_SEQUENCE_ID, LAST_SEQUENCE_ID, NEXT_SEQUENCE_ID, LAST_RECEIVED_TIME, STATUS, SEQUENCING_LEVEL, CONTAINER_ID, LOCK_TIME, RESEQUENCER_TYPE, TIMEOUT_DURATION, COMPONENT_STATUS, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$OSB_GROUP_STATUS;

CREATE OR REPLACE EDITIONING VIEW OSB_RESEQUENCER_MESSAGE
 AS SELECT ID, OWNER_ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, PROPERTY1, PROPERTY2, PROPERTY3, SEQUENCE_ID, CONTAINER_ID, CREATION_DATE, PROCESS_DATE, IS_EVENT, QNAME_LOCAL_PART, QNAME_NAMESPACE, LOCK_TIME, NEXT_SEQUENCE_ID, PRIORITY, SOURCE_URI, STANDARD_SEQUENCE_ID, STATUS, INSTANCE_CREATED, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$OSB_RESEQUENCER_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW B2B_GROUP_STATUS
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, SUPPORT_BATCHING, LOCK_TIME_1, START_SEQUENCE_ID, LAST_SEQUENCE_ID, NEXT_SEQUENCE_ID, LAST_RECEIVED_TIME, STATUS, SEQUENCING_LEVEL, CONTAINER_ID, LOCK_TIME, RESEQUENCER_TYPE, TIMEOUT_DURATION, COMPONENT_STATUS, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$B2B_GROUP_STATUS;

CREATE OR REPLACE EDITIONING VIEW B2B_RESEQUENCER_MESSAGE
 AS SELECT ID, OWNER_ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, GROUP_ID, PROPERTY1, PROPERTY2, PROPERTY3, SEQUENCE_ID, CONTAINER_ID, CREATION_DATE, PROCESS_DATE, IS_EVENT, QNAME_LOCAL_PART, QNAME_NAMESPACE, LOCK_TIME, NEXT_SEQUENCE_ID, PRIORITY, SOURCE_URI, STANDARD_SEQUENCE_ID, STATUS, INSTANCE_CREATED, FLOW_ID, SCA_PARTITION_ID, PARTITION_DATE, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$B2B_RESEQUENCER_MESSAGE;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_SERVICE_DETAIL
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, SEQUENCING_LEVEL, RESEQUENCER_TYPE, CREATION_DATE, COMPONENT_STATUS, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$MEDIATOR_SERVICE_DETAIL;

CREATE OR REPLACE EDITIONING VIEW OSB_SERVICE_DETAIL
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, SEQUENCING_LEVEL, RESEQUENCER_TYPE, CREATION_DATE, COMPONENT_STATUS, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$OSB_SERVICE_DETAIL;

CREATE OR REPLACE EDITIONING VIEW B2B_SERVICE_DETAIL
 AS SELECT ID, COMPONENT_DN, OPERATION, LEVEL_DETAIL2, SEQUENCING_LEVEL, RESEQUENCER_TYPE, CREATION_DATE, COMPONENT_STATUS, DUMMY1, DUMMY2, DUMMY3, DUMMY4, DUMMY5 FROM E$B2B_SERVICE_DETAIL;

CREATE OR REPLACE EDITIONING VIEW MEDIATOR_RES_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$MEDIATOR_RES_CONTAINERID_LEA;

CREATE OR REPLACE EDITIONING VIEW B2B_RES_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$B2B_RES_CONTAINERID_LEASE;

CREATE OR REPLACE EDITIONING VIEW OSB_RES_CONTAINERID_LEASE
 AS SELECT CONTAINER_ID, RENEWAL_TIME FROM E$OSB_RES_CONTAINERID_LEASE;

CREATE OR REPLACE EDITIONING VIEW LABEL_VERSION_PCBPEL
 AS SELECT LABEL FROM E$LABEL_VERSION_PCBPEL;

CREATE OR REPLACE EDITIONING VIEW XREF_DATA
 AS SELECT XREF_TABLE_NAME, XREF_COLUMN_NAME, ROW_NUMBER, VALUE, IS_DELETED, LAST_MODIFIED FROM E$XREF_DATA;

CREATE OR REPLACE EDITIONING VIEW XREF_DELETED_DATA
 AS SELECT XREF_TABLE_NAME, XREF_COLUMN_NAME, ROW_ID, VALUE, LAST_MODIFIED FROM E$XREF_DELETED_DATA;
