//
// $Header: bpm/main/modules/composer/adf/src/main/resources/META-INF/bpm/jsLibs/AdfEditorTransportMessageEvent.js /st_pcbpel_12.2.1.4.0soabp/1 2020/12/31 08:32:23 pbsingha Exp $
//
// AdfEditorTransportMessageEvent.js
//
// Copyright (c) 2020, Oracle and/or its affiliates. 
//
//    NAME
//     AdfEditorTransportMessageEvent.js - <one-line expansion of the name>
//
//    DESCRIPTION
//     <short description of component this file declares/defines>
//
//    NOTES
//     <other useful comments, qualifications, etc. >
//
//    MODIFIED  (MM/DD/YY)
//    manpasin   12/15/20 - Created
//
/**
 * Javascript event to send TransportMessages from client to server
 */
AdfObject.createSubclass(GraphEditorTransportMessageEvent, AdfPhasedEvent);

GraphEditorTransportMessageEvent.MSG_EVENT = "ge_msg_event_";

/*
 *      ADF does not allow to send multiple events of the same type ('ge_msg_event') into the same ppr request.
 *      Then, to allow flash to send multiple events, event types are sequentially named ge_msg_event_0, ge_msg_event_1
 *      or ge_msg_event_2. You can see server side logic at oracle.bpm.composer.component.renderkit.CommonFlashRender
 *      class.
 */
GraphEditorTransportMessageEvent.messageNumber = 0;

function GraphEditorTransportMessageEvent(source, msg)
{
    this.Init(source, msg);
}

GraphEditorTransportMessageEvent.prototype.Init = function(source, msg)
{
    this.messageId = GraphEditorTransportMessageEvent.MSG_EVENT + GraphEditorTransportMessageEvent.messageNumber;
    GraphEditorTransportMessageEvent.messageNumber = (GraphEditorTransportMessageEvent.messageNumber + 1) % 4;
    GraphEditorTransportMessageEvent.superclass.Init.call(this, source, this.messageId);
    this._msg = msg;
}

GraphEditorTransportMessageEvent.prototype.AddMarshalledProperties = function(properties)
{
    GraphEditorTransportMessageEvent.superclass.AddMarshalledProperties.call(this, properties);
    properties['msg'] = this._msg;
}

/**
 * Override to cause the event to propagate to the server.
 */
GraphEditorTransportMessageEvent.prototype.propagatesToServer = function() {
    return true;
}

GraphEditorTransportMessageEvent.prototype.toString = function() {
    return this.messageId;
}