import os
import sys
import fileinput
#import platform
import time
import shutil
import tempfile
import datetime

refconfig_dir = os.path.dirname(sys.argv[0])
localization_dir=os.path.join(refconfig_dir, "resources/localization")

OracleSOASuiteReferenceConfiguration = '"Oracle SOA Suite Reference Configuration"'
OracleSOASuiteReferenceConfigurationTemplate = "oracle.soa.refconfig_template.jar"
SOAReferenceFound = False
 
OracleSOASuiteClassic = '"Oracle SOA Suite Classic"'
OracleSOASuiteClassicTemplate = "oracle.soa.classic.domain_template.jar"
SOAClassicFound = False

OracleSOASuite = '"Oracle SOA Suite"'
OracleSOASuiteTemplate = "oracle.soa_template.jar"
SOAFound = False

OracleServiceBusReferenceConfiguration = '"Oracle Service Bus Reference Configuration"'
OracleServiceBusReferenceConfigurationTemplate = "oracle.osb.refconfig_template.jar"
OSBReferenceFound = False
 
OracleServiceBusClassic = '"Oracle Service Bus Classic"'
OracleServiceBusClassicTemplate = "oracle.osb.classic.domain_template.jar"
OSBClassicFound = False

OracleServiceBus = '"Oracle Service Bus"'
OracleServiceBusTemplate = "oracle.osb_template.jar"
OSBFound = False


OracleB2BReferenceConfiguration = '"Oracle B2B Reference Configuration"'
OracleB2BReferenceConfigurationTemplate = "oracle.soa.b2b.refconfig_template.jar"
B2BReferenceFound = False

OracleB2BClassic = '"Oracle B2B Classic"'
OracleB2BClassicTemplate = "oracle.soa.b2b.classic.domain_template.jar"
B2BClassicFound = False

OracleB2BSuite = '"Oracle B2B"'
OracleB2BTemplate = "oracle.soa.b2b_template.jar"
B2BFound = False

OracleBPMSuite = '"Oracle BPM Suite"'
BPMFound = False
backupDomain = ""

timestamp = time.strftime('%d-%Y_%H-%M-%S', time.localtime())
f = open('soaFixDomainTemplate_'+timestamp+'.log', 'w')


if localization_dir not in sys.path:
    sys.path.insert(0, localization_dir)

from soaLocalizationUtils import *
 
def printLog (message) :
   print(message)
   f.write(message)

def initialText():
   printLog ("========================================================================================================================================================")
   printLog ("========================================================================================================================================================")
   printLog(getMessage('DOMAIN_INFO_LINE1'))
   printLog(getMessage('DOMAIN_INFO_LINE2'))
   printLog(OracleSOASuiteClassic)
   printLog(OracleServiceBusClassic) 
   printLog(OracleB2BClassic+'\n\n') 
   printLog(getMessage('DOMAIN_INFO_LINE3'))
   printLog(OracleSOASuite)
   printLog(OracleServiceBus) 
   printLog(OracleB2BSuite+'\n\n') 
   printLog(getMessage('DOMAIN_INFO_LINE4'))
   printLog ("========================================================================================================================================================")
   printLog ("========================================================================================================================================================")
  
def input_yes_no(question, default="no"):
    """Ask a yes/no question via raw_input() and return their answer.

    "question" is a string that is presented to the user.
    "default" is the presumed answer if the user just hits <Enter>.
        It must be "yes" (the default), "no" or None (meaning
        an answer is required of the user).

    The "answer" return value is True for "yes" or False for "no".
    """
    valid = {"yes": True, "y": True, "ye": True,
             "no": False, "n": False}
    if default is None:
        prompt = " [y/n] "
    elif default == "yes":
        prompt = " [Y/n] "
    elif default == "no":
        prompt = " [y/N] "
    else:
        raise ValueError("invalid default answer: '%s'" % default)

    while True:
        sys.stdout.write(question + prompt)
        choice = raw_input().lower()
        if default is not None and choice == '':
            return valid[default]
        elif choice in valid:
            return valid[choice]
        else:
            sys.stdout.write("Please respond with 'yes' or 'no' "
                             "(or 'y' or 'n').\n")


def usage():
   printLog  ("=======================================================================================\n")
   printLog ("Usage:" + sys.argv[0] + " -d <domain_home_location> [-silent]\n " )
             
   printLog ('=======================================================================================')
  
   sys.exit(0)
  
def restoreSetDomain(setDomain, backedupSetDomain) :
  try:

#    timestamp = time.strftime('%d-%Y_%H-%M-%S', time.localtime())
    backupLocal = setDomain+"_err-" + timestamp
    printLogLog(getMessage('INFO_RESTORESET_DOMAIN_INFO'))
    shutil.copy(setDomain, backupLocal)
    shutil.copy(backedupSetDomain,setDomain)
    
  except IOError , e:
    printLogLog(getMessage('ERR_COPY_FAIL') %(setDmoain))
    printLogLog (str(e))
    sys.exit(0)
  except:
     printLog(getMessage('ERR_UNEXPECTED_ERROR'))  
     sys.exit(0)

def backUp(fileToSearch,backUpType):  

  try:
 
#    timestamp = time.strftime('%d-%Y_%H-%M-%S', time.localtime())
    global backupDomain
    backupDomain = fileToSearch+"_bak-" + timestamp
    shutil.copy(fileToSearch,backupDomain)
  except IOError , e:
    
    printLog(getMessage('ERR_BACKUP_FAIL') %(fileToSearch))
    printLog(str(e))
    sys.exit(0)
  except:
    printLog(getMessage('ERR_UNEXPECTED_ERROR'))
    #printLog(getMessage('INFO_BACKUP') %(target))
    printLog(str(e))
    sys.exit(0)

  printLog(getMessage('INFO_BACKUP_INFO') %(backUpType,backupDomain))  

def checkDomainTemplates (fileToSearch):
  isThereError = 0 
  try:
    tempfile =  open( fileToSearch, 'r' ) 
    for line1 in tempfile:
      if OracleSOASuiteReferenceConfiguration in line1:
         global SOAReferenceFound 
         SOAReferenceFound = True 
      if OracleSOASuiteClassic in line1:
         global SOAClassicFound
         SOAClassicFound = True 
         global SOAFound
         SOAFound = True 
      if OracleSOASuite in line1:
         global SOAFound
         SOAFound = True 

      if OracleBPMSuite in line1:
         global BPMFound
         BPMFound = True 

      if OracleServiceBusReferenceConfiguration in line1:
         global OSBReferenceFound 
         OSBReferenceFound = True

      if OracleServiceBusClassic in line1:
         global OSBClassicFound
         OSBClassicFound = True 
         global OSBFound
         OSBFound = True

      if OracleServiceBus in line1:
         global OSBFound
         OSBFound = True

      if OracleB2BReferenceConfiguration in line1:
         global B2BReferenceFound 
         B2BReferenceFound = True

      if OracleB2BClassic in line1:
         global B2BClassicFound 
         B2BClassicFound = True
         global B2BFound 
         B2BFound = True

      if OracleB2BSuite in line1:
         global B2BFound 
         B2BFound = True
  except IOError , e:
     printLog(getMessage('ERR_UNABLETO_PROCESS_FILE') %(fileToSeach) % e)
     sys.exit(0)
  except:
    printLog(getMessage('ERR_UNEXPECTED_ERROR'))
    sys.exit(0)
    
  else:    
    xx = 1

def fixClassicTemplates (fileToSearch):
  isThereError = 0
  s1 = "<extention-template-ref"
  r1 = "<!--<extention-template-ref"
  s2 = "/>"
  r2 = "/>-->"
  try:
     tempFile3 = open( fileToSearch, 'r+' )
     print("heere 1"+fileToSearch)
     for line3 in fileinput.input( fileToSearch ):
      if OracleSOASuiteClassic in line3  :
          line3 = line3.replace(s1,r1)
          line3 = line3.replace(s2,r2)
          printLog (getMessage('REMOVE_TEMPLATE') %(OracleSOASuiteClassic))
      if OracleServiceBusClassic in line3  :
          line3 = line3.replace(s1,r1)
          line3 = line3.replace(s2,r2)
          printLog (getMessage('REMOVE_TEMPLATE') %(OracleServiceBusClassic))
      if OracleB2BClassic in line3  :
          line3 = line3.replace(s1,r1)
          line3 = line3.replace(s2,r2)
          printLog (getMessage('REMOVE_TEMPLATE') %(OracleB2BClassic))
      tempFile3.write(line3)
     tempFile3.close()
  except IOError , e:
    printLog("IOERROR")
    printLog(getMessage('ERR_UNABLETO_PROCESS_FILE') %(fileToSeach) % e)
    isThereError = 1
    sys.exit(0)
  except:
    printLog(getMessage('ERR_UNEXPECTED_ERROR'))
    isThereError = 1
           
  else:    
    tempFile3.close()    
    if(isThereError == 1) :
      restoreSetDomain(fileToSearch,backupDomain)
 
def fixReferenceTemplates (fileToSearch):
  isThereError = 0
  try:
     tempFile2 = open( fileToSearch, 'r+' )
     for line2 in fileinput.input( fileToSearch ):
        if OracleSOASuite in line2  :
          line2 = line2.replace(OracleSOASuite,OracleSOASuiteReferenceConfiguration)
          line2 = line2.replace(OracleSOASuiteTemplate,OracleSOASuiteReferenceConfigurationTemplate)
          printLog(getMessage('REPLACE_TEMPLATE') %(OracleSOASuite,OracleSOASuiteReferenceConfiguration)) 

        if OracleServiceBus in line2  :
          line2 = line2.replace(OracleServiceBus,OracleServiceBusReferenceConfiguration)
          line2 = line2.replace(OracleServiceBusTemplate,OracleServiceBusReferenceConfigurationTemplate)
          printLog(getMessage('REPLACE_TEMPLATE') %(OracleServiceBus,OracleServiceBusReferenceConfiguration))

        if OracleB2BSuite in line2  :
          line2 = line2.replace(OracleB2BSuite,OracleB2BReferenceConfiguration)
          line2 = line2.replace(OracleB2BTemplate,OracleB2BReferenceConfigurationTemplate)
          printLog(getMessage('REPLACE_TEMPLATE') %(OracleB2BSuite,OracleB2BReferenceConfiguration))
        tempFile2.write(line2)
     tempFile2.close()
  except IOError , e:
    printLog("IOERROR")
    printLog(getMessage('ERR_UNABLETO_PROCESS_FILE') %(fileToSeach) % e)
    isThereError = 1
    sys.exit(0)
  except:
    printLog("*** in This Error ")
    printLog(getMessage('ERR_UNEXPECTED_ERROR'))
    isThereError = 1
           
  else:    
    tempFile2.close()    
    if(isThereError == 1) :
      restoreSetDomain(fileToSearch,backupDomain)
 
 
def fixBpmOsbTemplates (fileToSearch):
  isThereError = 0
  r1 = "<!-- "
  r2 = " -->\n"
  try:
     tempFile4 = open( fileToSearch, 'r+' )
     for line4 in fileinput.input( fileToSearch ):
        if OracleServiceBusReferenceConfiguration in line4  :
          line4 = r1+ getMessage('REPLACED_TEMPLATE') %(OracleServiceBusReferenceConfiguration,OracleServiceBus) +r2 +line4
          line4 = line4.replace(OracleServiceBusReferenceConfiguration,OracleServiceBus)
          line4 = line4.replace(OracleServiceBusReferenceConfigurationTemplate,OracleServiceBusTemplate)
          printLog(getMessage('REPLACE_TEMPLATE') %(OracleServiceBusReferenceConfiguration,OracleServiceBus))
        tempFile4.write(line4)
     tempFile4.close()
  except IOError , e:
    printLog("IOERROR")
    printLog(getMessage('ERR_UNABLETO_PROCESS_FILE') %(fileToSeach) % e)
    isThereError = 1
    sys.exit(0)
  except:
    printLog("*** in This Error ")
    printLog(getMessage('ERR_UNEXPECTED_ERROR'))
    isThereError = 1
           
  else:    
    tempFile4.close()    
    if(isThereError == 1) :
      restoreSetDomain(fileToSearch,backupDomain)
   
def fixSoaProfile (fileToSearch):
  isThereError = 0
  printLogDone = 0
  try:
     tempFile2 = open( fileToSearch, 'r+' )
     for line2 in fileinput.input( fileToSearch ):
        if OracleSOASuite[1:-1]+"</" in line2  :
          line2 = line2.replace(OracleSOASuite[1:-1],OracleSOASuiteReferenceConfiguration[1:-1])
          if (printLogDone == 0) :
            printLog(getMessage('REPLACE_SOAPROFILE') %(OracleSOASuite,OracleSOASuiteReferenceConfiguration)) 
            printLogDone  = 1
        tempFile2.write(line2)
     tempFile2.close()
  except IOError , e:
    printLog("IOERROR")
    printLog(getMessage('ERR_UNABLETO_PROCESS_FILE') %(fileToSeach) % e)
    isThereError = 1
    sys.exit(0)
  except:
    printLog("*** in This Error ")
    printLog(getMessage('ERR_UNEXPECTED_ERROR'))  
    isThereError = 1
           
  else:    
    tempFile2.close()    
    if(isThereError == 1) :
      restoreSetDomain(fileToSearch,backupDomain)
 
   
printLog ("")

if len(sys.argv) < 3:
  usage()

ifYes = False
i = 1
while i < len(sys.argv):

     if sys.argv[i] == '-silent' :
        ifYes = True 	
        i += 1
     elif sys.argv[i] == '-d':
         DOMAINHOME = sys.argv[i + 1]
         i += 2
     else:
         printLog(getMessage('ERR_PARAM_WRONG')   )
         usage()
         sys.exit(1)
if (ifYes is False ) :
	initialText()
	ifYes = input_yes_no (getMessage('CONFIRM_DOMAIN_INFO'))
	if (ifYes is False) :
  		sys.exit(1)

fileToSearch = DOMAINHOME +"/init-info/domain-info.xml" 
printLog (getMessage('INFO_SETDOMAIN_INFO') %(fileToSearch))
  
# TAKE BACKUP  
backUp(fileToSearch,"domain-info")

# Check domain Types 
checkDomainTemplates(fileToSearch)

noFixNeed = True

if (SOAClassicFound or OSBClassicFound  or B2BClassicFound ):
     printLog (getMessage('FIX_CLASSIC'))
     fixClassicTemplates(fileToSearch)
     noFixNeed = False
 
if (OSBReferenceFound and BPMFound) :
  printLog(getMessage('FIX_REFERENCE'))
  fixBpmOsbTemplates(fileToSearch)
  noFixNeed = False
  
elif(SOAReferenceFound or OSBReferenceFound  or B2BReferenceFound ):
  if (SOAFound or OSBFound or B2BFound) : 
       printLog (getMessage('FIX_REFERENCE'))
       fixReferenceTemplates(fileToSearch)
       if (SOAFound) :
         printLog (getMessage('FIX_SOAPROFILE'))
         fileToSearch = DOMAINHOME +"/config/fmwconfig/soa-profiles-config.xml"
         backUp(fileToSearch,"soa-profiles-config")
         fixSoaProfile(fileToSearch)
       noFixNeed = False

if (noFixNeed) :
    printLog (getMessage('NO_FIX_NEEDED'))
